--TEST--
swoole_redis: get & set
--SKIPIF--
<?php require __DIR__ . "/../include/skipif.inc";
if (!class_exists("swoole_redis", false))
{
    exit("required redis.");
}
?>
--INI--
assert.active=1
assert.warning=1
assert.bail=0
assert.quiet_eval=0


--FILE--
<?php
require_once __DIR__ . "/../include/swoole.inc";

$redis = new swoole_redis();
$redis->on("close", function ()
{
    echo "close";
});
$redis->on("message", function ()
{
    var_dump(func_get_args());
});

$redis->testKey = "swoole:test:key_" . md5(microtime());
$redis->testData = RandStr::gen(128, RandStr::ALPHA | RandStr::NUM | RandStr::CHINESE);

// $swoole_redis->connect(REDIS_SERVER_PATH, false, swoole_function() {}); TODO
$redis->connect(REDIS_SERVER_HOST, REDIS_SERVER_PORT, function (\swoole_redis $redis)
{
    $redis->setex($redis->testKey, 3600, $redis->testData, function (\swoole_redis $redis, $result)
    {
        assert($result === 'OK');
        $redis->get($redis->testKey, function (\swoole_redis $redis, $result)
        {
            assert($result === $redis->testData);
            $redis->close();
        });
    });
});

?>
--EXPECT--
close