
/*
  +------------------------------------------------------------------------+
  | Zephir Language                                                        |
  +------------------------------------------------------------------------+
  | Copyright (c) 2011-2015 Zephir Team (http://www.zephir-lang.com)       |
  +------------------------------------------------------------------------+
  | This source file is subject to the New BSD License that is bundled     |
  | with this package in the file docs/LICENSE.txt.                        |
  |                                                                        |
  | If you did not receive a copy of the license and are unable to         |
  | obtain it through the world-wide-web, please send an email             |
  | to license@zephir-lang.com so we can send you a copy immediately.      |
  +------------------------------------------------------------------------+
  | Authors: Andres Gutierrez <andres@zephir-lang.com>                     |
  |          Eduar Carvajal <eduar@zephir-lang.com>                        |
  |          Rack Lin <racklin@gmail.com>                                  |
  +------------------------------------------------------------------------+
*/

#ifndef ZEPHIR_KERNEL_VARIABLES_H
#define ZEPHIR_KERNEL_VARIABLES_H

#include <php.h>
#include <Zend/zend.h>

void zephir_serialize(zval *return_value, zval **var  TSRMLS_DC);
void zephir_unserialize(zval *return_value, zval *var TSRMLS_DC);

void zephir_var_export(zval **var TSRMLS_DC);
void zephir_var_export_ex(zval *return_value, zval **var TSRMLS_DC);

void zephir_var_dump(zval **var TSRMLS_DC);

#endif