--TEST--
Decimal128: Non-Canonical Parsing - Long Significand with Exponent
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

$canonicalBson = hex2bin('1800000013640079D9E0F9763ADA429D0200000000583000');
$canonicalExtJson = '{"d" : {"$numberDecimal" : "1.2345689012345789012345E+34"}}';
$degenerateExtJson = '{"d" : {"$numberDecimal" : "12345689012345789012345E+12"}}';

// Canonical BSON -> Native -> Canonical BSON
echo bin2hex(fromPHP(toPHP($canonicalBson))), "\n";

// Canonical BSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromBSON($canonicalBson)), "\n";

// Canonical BSON -> Canonical extJSON
echo json_canonicalize(toCanonicalExtendedJSON($canonicalBson)), "\n";

// Canonical BSON -> BSON object -> Canonical extJSON
echo json_canonicalize(MongoDB\BSON\Document::fromBSON($canonicalBson)->toCanonicalExtendedJSON()), "\n";

// Canonical extJSON -> Canonical BSON
echo bin2hex(fromJSON($canonicalExtJson)), "\n";

// Canonical extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($canonicalExtJson)), "\n";

// Degenerate extJSON -> Canonical BSON
echo bin2hex(fromJSON($degenerateExtJson)), "\n";

// Degenerate extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($degenerateExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1800000013640079d9e0f9763ada429d0200000000583000
1800000013640079d9e0f9763ada429d0200000000583000
{"d":{"$numberDecimal":"1.2345689012345789012345E+34"}}
{"d":{"$numberDecimal":"1.2345689012345789012345E+34"}}
1800000013640079d9e0f9763ada429d0200000000583000
1800000013640079d9e0f9763ada429d0200000000583000
1800000013640079d9e0f9763ada429d0200000000583000
1800000013640079d9e0f9763ada429d0200000000583000
===DONE===