#ifndef PHP_IMLIB2_H
#define PHP_IMLIB2_H

#include "X11/Xlib.h"
#include <Imlib2.h>

extern zend_module_entry imlib2_module_entry;
#define phpext_imlib2_ptr &imlib2_module_entry

#ifdef PHP_WIN32
#define PHP_IMLIB2_API __declspec(dllexport)
#else
#define PHP_IMLIB2_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(imlib2);
PHP_MSHUTDOWN_FUNCTION(imlib2);
PHP_RINIT_FUNCTION(imlib2);
PHP_RSHUTDOWN_FUNCTION(imlib2);
PHP_MINFO_FUNCTION(imlib2);

PHP_FUNCTION(imlib2_image_modify_gamma);
PHP_FUNCTION(imlib2_image_modify_contrast);
PHP_FUNCTION(imlib2_image_modify_brightness);
PHP_FUNCTION(imlib2_load_image_immediately);
PHP_FUNCTION(imlib2_load_image_without_cache);
PHP_FUNCTION(imlib2_load_image_immediately_without_cache);
PHP_FUNCTION(imlib2_free_image);
PHP_FUNCTION(imlib2_free_image_and_decache);
PHP_FUNCTION(imlib2_add_color_to_color_range);
PHP_FUNCTION(imlib2_blend_image_onto_image);
PHP_FUNCTION(imlib2_clone_image);
PHP_FUNCTION(imlib2_create_color_range);
PHP_FUNCTION(imlib2_create_cropped_image);
PHP_FUNCTION(imlib2_create_cropped_scaled_image);
PHP_FUNCTION(imlib2_create_image);
PHP_FUNCTION(imlib2_create_rotated_image);
PHP_FUNCTION(imlib2_image_orientate);
PHP_FUNCTION(imlib2_create_scaled_image);
PHP_FUNCTION(imlib2_free_color_range);
PHP_FUNCTION(imlib2_free_font);
PHP_FUNCTION(imlib2_get_text_size);
PHP_FUNCTION(imlib2_image_blur);
PHP_FUNCTION(imlib2_image_draw_ellipse);
PHP_FUNCTION(imlib2_image_draw_line);
PHP_FUNCTION(imlib2_image_draw_polygon);
PHP_FUNCTION(imlib2_image_draw_rectangle);
PHP_FUNCTION(imlib2_image_fill_color_range_rectangle);
PHP_FUNCTION(imlib2_image_fill_ellipse);
PHP_FUNCTION(imlib2_image_fill_polygon);
PHP_FUNCTION(imlib2_image_fill_rectangle);
PHP_FUNCTION(imlib2_image_flip_horizontal);
PHP_FUNCTION(imlib2_image_flip_vertical);
PHP_FUNCTION(imlib2_image_flip_diagonal);
PHP_FUNCTION(imlib2_image_format);
PHP_FUNCTION(imlib2_image_get_filename);
PHP_FUNCTION(imlib2_image_get_height);
PHP_FUNCTION(imlib2_image_get_width);
PHP_FUNCTION(imlib2_image_has_alpha);
PHP_FUNCTION(imlib2_image_modify_alpha);
PHP_FUNCTION(imlib2_image_set_format);
PHP_FUNCTION(imlib2_image_sharpen);
PHP_FUNCTION(imlib2_image_tile_horizontal);
PHP_FUNCTION(imlib2_image_tile_vertical);
PHP_FUNCTION(imlib2_image_tile);
PHP_FUNCTION(imlib2_list_fonts);
PHP_FUNCTION(imlib2_load_font);
PHP_FUNCTION(imlib2_load_image);
PHP_FUNCTION(imlib2_load_image_with_error_return);
PHP_FUNCTION(imlib2_polygon_add_point);
PHP_FUNCTION(imlib2_polygon_contains_point);
PHP_FUNCTION(imlib2_polygon_free);
PHP_FUNCTION(imlib2_polygon_get_bounds);
PHP_FUNCTION(imlib2_polygon_new);
PHP_FUNCTION(imlib2_save_image);
PHP_FUNCTION(imlib2_dump_image);
PHP_FUNCTION(imlib2_text_draw);
PHP_FUNCTION(imlib2_get_data);


ZEND_BEGIN_MODULE_GLOBALS(imlib2)
	int font_cache_max_size;
	int font_cache_status;
	char *font_path;
ZEND_END_MODULE_GLOBALS(imlib2)


/* In every utility function you add that needs to use variables 
   in php_imlib2_globals, call TSRM_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMLS_CC
   after the last function argument and declare your utility function
   with TSRMLS_DC after the last declared argument.  Always refer to
   the globals in your function as IMLIB2_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/



#ifdef ZTS
#define IMLIB2_G(v) TSRMG(imlib2_globals_id, zend_imlib2_globals *, v)
#define IMLIB2_LS_FETCH() imlib2_globals *imlib2_globals = ts_resource(gd_imlib_id)
#else
#define IMLIB2_G(v) (imlib2_globals.v)
#define IMLIB2_LS_FETCH()
#endif

#endif	/* PHP_IMLIB2_H */

/* __footer_here__ */
