/*
 * PHP-GTK - The PHP language bindings for GTK+
 *
 * Copyright (C) 2001-2008 Andrei Zmievski <andrei@php.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
/* $Id$: */

#include "php_gtk.h"
#if HAVE_PHP_GTK

#include "php_gtk+.h"
#include <gdk/gdkkeysyms.h>

extern zend_class_entry *gdk_ce;

void phpg_gdk_register_keysyms()
{
	phpg_register_int_constant(gdk_ce, "KEY_VoidSymbol", sizeof("KEY_VoidSymbol")-1, GDK_VoidSymbol);
	phpg_register_int_constant(gdk_ce, "KEY_BackSpace", sizeof("KEY_BackSpace")-1, GDK_BackSpace);
	phpg_register_int_constant(gdk_ce, "KEY_Tab", sizeof("KEY_Tab")-1, GDK_Tab);
	phpg_register_int_constant(gdk_ce, "KEY_Linefeed", sizeof("KEY_Linefeed")-1, GDK_Linefeed);
	phpg_register_int_constant(gdk_ce, "KEY_Clear", sizeof("KEY_Clear")-1, GDK_Clear);
	phpg_register_int_constant(gdk_ce, "KEY_Return", sizeof("KEY_Return")-1, GDK_Return);
	phpg_register_int_constant(gdk_ce, "KEY_Pause", sizeof("KEY_Pause")-1, GDK_Pause);
	phpg_register_int_constant(gdk_ce, "KEY_Scroll_Lock", sizeof("KEY_Scroll_Lock")-1, GDK_Scroll_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_Sys_Req", sizeof("KEY_Sys_Req")-1, GDK_Sys_Req);
	phpg_register_int_constant(gdk_ce, "KEY_Escape", sizeof("KEY_Escape")-1, GDK_Escape);
	phpg_register_int_constant(gdk_ce, "KEY_Delete", sizeof("KEY_Delete")-1, GDK_Delete);
	phpg_register_int_constant(gdk_ce, "KEY_Multi_key", sizeof("KEY_Multi_key")-1, GDK_Multi_key);
	phpg_register_int_constant(gdk_ce, "KEY_Codeinput", sizeof("KEY_Codeinput")-1, GDK_Codeinput);
	phpg_register_int_constant(gdk_ce, "KEY_SingleCandidate", sizeof("KEY_SingleCandidate")-1, GDK_SingleCandidate);
	phpg_register_int_constant(gdk_ce, "KEY_MultipleCandidate", sizeof("KEY_MultipleCandidate")-1, GDK_MultipleCandidate);
	phpg_register_int_constant(gdk_ce, "KEY_PreviousCandidate", sizeof("KEY_PreviousCandidate")-1, GDK_PreviousCandidate);
	phpg_register_int_constant(gdk_ce, "KEY_Kanji", sizeof("KEY_Kanji")-1, GDK_Kanji);
	phpg_register_int_constant(gdk_ce, "KEY_Muhenkan", sizeof("KEY_Muhenkan")-1, GDK_Muhenkan);
	phpg_register_int_constant(gdk_ce, "KEY_Henkan_Mode", sizeof("KEY_Henkan_Mode")-1, GDK_Henkan_Mode);
	phpg_register_int_constant(gdk_ce, "KEY_Henkan", sizeof("KEY_Henkan")-1, GDK_Henkan);
	phpg_register_int_constant(gdk_ce, "KEY_Romaji", sizeof("KEY_Romaji")-1, GDK_Romaji);
	phpg_register_int_constant(gdk_ce, "KEY_Hiragana", sizeof("KEY_Hiragana")-1, GDK_Hiragana);
	phpg_register_int_constant(gdk_ce, "KEY_Katakana", sizeof("KEY_Katakana")-1, GDK_Katakana);
	phpg_register_int_constant(gdk_ce, "KEY_Hiragana_Katakana", sizeof("KEY_Hiragana_Katakana")-1, GDK_Hiragana_Katakana);
	phpg_register_int_constant(gdk_ce, "KEY_Zenkaku", sizeof("KEY_Zenkaku")-1, GDK_Zenkaku);
	phpg_register_int_constant(gdk_ce, "KEY_Hankaku", sizeof("KEY_Hankaku")-1, GDK_Hankaku);
	phpg_register_int_constant(gdk_ce, "KEY_Zenkaku_Hankaku", sizeof("KEY_Zenkaku_Hankaku")-1, GDK_Zenkaku_Hankaku);
	phpg_register_int_constant(gdk_ce, "KEY_Touroku", sizeof("KEY_Touroku")-1, GDK_Touroku);
	phpg_register_int_constant(gdk_ce, "KEY_Massyo", sizeof("KEY_Massyo")-1, GDK_Massyo);
	phpg_register_int_constant(gdk_ce, "KEY_Kana_Lock", sizeof("KEY_Kana_Lock")-1, GDK_Kana_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_Kana_Shift", sizeof("KEY_Kana_Shift")-1, GDK_Kana_Shift);
	phpg_register_int_constant(gdk_ce, "KEY_Eisu_Shift", sizeof("KEY_Eisu_Shift")-1, GDK_Eisu_Shift);
	phpg_register_int_constant(gdk_ce, "KEY_Eisu_toggle", sizeof("KEY_Eisu_toggle")-1, GDK_Eisu_toggle);
	phpg_register_int_constant(gdk_ce, "KEY_Kanji_Bangou", sizeof("KEY_Kanji_Bangou")-1, GDK_Kanji_Bangou);
	phpg_register_int_constant(gdk_ce, "KEY_Zen_Koho", sizeof("KEY_Zen_Koho")-1, GDK_Zen_Koho);
	phpg_register_int_constant(gdk_ce, "KEY_Mae_Koho", sizeof("KEY_Mae_Koho")-1, GDK_Mae_Koho);
	phpg_register_int_constant(gdk_ce, "KEY_Home", sizeof("KEY_Home")-1, GDK_Home);
	phpg_register_int_constant(gdk_ce, "KEY_Left", sizeof("KEY_Left")-1, GDK_Left);
	phpg_register_int_constant(gdk_ce, "KEY_Up", sizeof("KEY_Up")-1, GDK_Up);
	phpg_register_int_constant(gdk_ce, "KEY_Right", sizeof("KEY_Right")-1, GDK_Right);
	phpg_register_int_constant(gdk_ce, "KEY_Down", sizeof("KEY_Down")-1, GDK_Down);
	phpg_register_int_constant(gdk_ce, "KEY_Prior", sizeof("KEY_Prior")-1, GDK_Prior);
	phpg_register_int_constant(gdk_ce, "KEY_Page_Up", sizeof("KEY_Page_Up")-1, GDK_Page_Up);
	phpg_register_int_constant(gdk_ce, "KEY_Next", sizeof("KEY_Next")-1, GDK_Next);
	phpg_register_int_constant(gdk_ce, "KEY_Page_Down", sizeof("KEY_Page_Down")-1, GDK_Page_Down);
	phpg_register_int_constant(gdk_ce, "KEY_End", sizeof("KEY_End")-1, GDK_End);
	phpg_register_int_constant(gdk_ce, "KEY_Begin", sizeof("KEY_Begin")-1, GDK_Begin);
	phpg_register_int_constant(gdk_ce, "KEY_Select", sizeof("KEY_Select")-1, GDK_Select);
	phpg_register_int_constant(gdk_ce, "KEY_Print", sizeof("KEY_Print")-1, GDK_Print);
	phpg_register_int_constant(gdk_ce, "KEY_Execute", sizeof("KEY_Execute")-1, GDK_Execute);
	phpg_register_int_constant(gdk_ce, "KEY_Insert", sizeof("KEY_Insert")-1, GDK_Insert);
	phpg_register_int_constant(gdk_ce, "KEY_Undo", sizeof("KEY_Undo")-1, GDK_Undo);
	phpg_register_int_constant(gdk_ce, "KEY_Redo", sizeof("KEY_Redo")-1, GDK_Redo);
	phpg_register_int_constant(gdk_ce, "KEY_Menu", sizeof("KEY_Menu")-1, GDK_Menu);
	phpg_register_int_constant(gdk_ce, "KEY_Find", sizeof("KEY_Find")-1, GDK_Find);
	phpg_register_int_constant(gdk_ce, "KEY_Cancel", sizeof("KEY_Cancel")-1, GDK_Cancel);
	phpg_register_int_constant(gdk_ce, "KEY_Help", sizeof("KEY_Help")-1, GDK_Help);
	phpg_register_int_constant(gdk_ce, "KEY_Break", sizeof("KEY_Break")-1, GDK_Break);
	phpg_register_int_constant(gdk_ce, "KEY_Mode_switch", sizeof("KEY_Mode_switch")-1, GDK_Mode_switch);
	phpg_register_int_constant(gdk_ce, "KEY_script_switch", sizeof("KEY_script_switch")-1, GDK_script_switch);
	phpg_register_int_constant(gdk_ce, "KEY_Num_Lock", sizeof("KEY_Num_Lock")-1, GDK_Num_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Space", sizeof("KEY_KP_Space")-1, GDK_KP_Space);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Tab", sizeof("KEY_KP_Tab")-1, GDK_KP_Tab);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Enter", sizeof("KEY_KP_Enter")-1, GDK_KP_Enter);
	phpg_register_int_constant(gdk_ce, "KEY_KP_F1", sizeof("KEY_KP_F1")-1, GDK_KP_F1);
	phpg_register_int_constant(gdk_ce, "KEY_KP_F2", sizeof("KEY_KP_F2")-1, GDK_KP_F2);
	phpg_register_int_constant(gdk_ce, "KEY_KP_F3", sizeof("KEY_KP_F3")-1, GDK_KP_F3);
	phpg_register_int_constant(gdk_ce, "KEY_KP_F4", sizeof("KEY_KP_F4")-1, GDK_KP_F4);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Home", sizeof("KEY_KP_Home")-1, GDK_KP_Home);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Left", sizeof("KEY_KP_Left")-1, GDK_KP_Left);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Up", sizeof("KEY_KP_Up")-1, GDK_KP_Up);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Right", sizeof("KEY_KP_Right")-1, GDK_KP_Right);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Down", sizeof("KEY_KP_Down")-1, GDK_KP_Down);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Prior", sizeof("KEY_KP_Prior")-1, GDK_KP_Prior);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Page_Up", sizeof("KEY_KP_Page_Up")-1, GDK_KP_Page_Up);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Next", sizeof("KEY_KP_Next")-1, GDK_KP_Next);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Page_Down", sizeof("KEY_KP_Page_Down")-1, GDK_KP_Page_Down);
	phpg_register_int_constant(gdk_ce, "KEY_KP_End", sizeof("KEY_KP_End")-1, GDK_KP_End);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Begin", sizeof("KEY_KP_Begin")-1, GDK_KP_Begin);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Insert", sizeof("KEY_KP_Insert")-1, GDK_KP_Insert);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Delete", sizeof("KEY_KP_Delete")-1, GDK_KP_Delete);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Equal", sizeof("KEY_KP_Equal")-1, GDK_KP_Equal);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Multiply", sizeof("KEY_KP_Multiply")-1, GDK_KP_Multiply);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Add", sizeof("KEY_KP_Add")-1, GDK_KP_Add);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Separator", sizeof("KEY_KP_Separator")-1, GDK_KP_Separator);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Subtract", sizeof("KEY_KP_Subtract")-1, GDK_KP_Subtract);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Decimal", sizeof("KEY_KP_Decimal")-1, GDK_KP_Decimal);
	phpg_register_int_constant(gdk_ce, "KEY_KP_Divide", sizeof("KEY_KP_Divide")-1, GDK_KP_Divide);
	phpg_register_int_constant(gdk_ce, "KEY_KP_0", sizeof("KEY_KP_0")-1, GDK_KP_0);
	phpg_register_int_constant(gdk_ce, "KEY_KP_1", sizeof("KEY_KP_1")-1, GDK_KP_1);
	phpg_register_int_constant(gdk_ce, "KEY_KP_2", sizeof("KEY_KP_2")-1, GDK_KP_2);
	phpg_register_int_constant(gdk_ce, "KEY_KP_3", sizeof("KEY_KP_3")-1, GDK_KP_3);
	phpg_register_int_constant(gdk_ce, "KEY_KP_4", sizeof("KEY_KP_4")-1, GDK_KP_4);
	phpg_register_int_constant(gdk_ce, "KEY_KP_5", sizeof("KEY_KP_5")-1, GDK_KP_5);
	phpg_register_int_constant(gdk_ce, "KEY_KP_6", sizeof("KEY_KP_6")-1, GDK_KP_6);
	phpg_register_int_constant(gdk_ce, "KEY_KP_7", sizeof("KEY_KP_7")-1, GDK_KP_7);
	phpg_register_int_constant(gdk_ce, "KEY_KP_8", sizeof("KEY_KP_8")-1, GDK_KP_8);
	phpg_register_int_constant(gdk_ce, "KEY_KP_9", sizeof("KEY_KP_9")-1, GDK_KP_9);
	phpg_register_int_constant(gdk_ce, "KEY_F1", sizeof("KEY_F1")-1, GDK_F1);
	phpg_register_int_constant(gdk_ce, "KEY_F2", sizeof("KEY_F2")-1, GDK_F2);
	phpg_register_int_constant(gdk_ce, "KEY_F3", sizeof("KEY_F3")-1, GDK_F3);
	phpg_register_int_constant(gdk_ce, "KEY_F4", sizeof("KEY_F4")-1, GDK_F4);
	phpg_register_int_constant(gdk_ce, "KEY_F5", sizeof("KEY_F5")-1, GDK_F5);
	phpg_register_int_constant(gdk_ce, "KEY_F6", sizeof("KEY_F6")-1, GDK_F6);
	phpg_register_int_constant(gdk_ce, "KEY_F7", sizeof("KEY_F7")-1, GDK_F7);
	phpg_register_int_constant(gdk_ce, "KEY_F8", sizeof("KEY_F8")-1, GDK_F8);
	phpg_register_int_constant(gdk_ce, "KEY_F9", sizeof("KEY_F9")-1, GDK_F9);
	phpg_register_int_constant(gdk_ce, "KEY_F10", sizeof("KEY_F10")-1, GDK_F10);
	phpg_register_int_constant(gdk_ce, "KEY_F11", sizeof("KEY_F11")-1, GDK_F11);
	phpg_register_int_constant(gdk_ce, "KEY_L1", sizeof("KEY_L1")-1, GDK_L1);
	phpg_register_int_constant(gdk_ce, "KEY_F12", sizeof("KEY_F12")-1, GDK_F12);
	phpg_register_int_constant(gdk_ce, "KEY_L2", sizeof("KEY_L2")-1, GDK_L2);
	phpg_register_int_constant(gdk_ce, "KEY_F13", sizeof("KEY_F13")-1, GDK_F13);
	phpg_register_int_constant(gdk_ce, "KEY_L3", sizeof("KEY_L3")-1, GDK_L3);
	phpg_register_int_constant(gdk_ce, "KEY_F14", sizeof("KEY_F14")-1, GDK_F14);
	phpg_register_int_constant(gdk_ce, "KEY_L4", sizeof("KEY_L4")-1, GDK_L4);
	phpg_register_int_constant(gdk_ce, "KEY_F15", sizeof("KEY_F15")-1, GDK_F15);
	phpg_register_int_constant(gdk_ce, "KEY_L5", sizeof("KEY_L5")-1, GDK_L5);
	phpg_register_int_constant(gdk_ce, "KEY_F16", sizeof("KEY_F16")-1, GDK_F16);
	phpg_register_int_constant(gdk_ce, "KEY_L6", sizeof("KEY_L6")-1, GDK_L6);
	phpg_register_int_constant(gdk_ce, "KEY_F17", sizeof("KEY_F17")-1, GDK_F17);
	phpg_register_int_constant(gdk_ce, "KEY_L7", sizeof("KEY_L7")-1, GDK_L7);
	phpg_register_int_constant(gdk_ce, "KEY_F18", sizeof("KEY_F18")-1, GDK_F18);
	phpg_register_int_constant(gdk_ce, "KEY_L8", sizeof("KEY_L8")-1, GDK_L8);
	phpg_register_int_constant(gdk_ce, "KEY_F19", sizeof("KEY_F19")-1, GDK_F19);
	phpg_register_int_constant(gdk_ce, "KEY_L9", sizeof("KEY_L9")-1, GDK_L9);
	phpg_register_int_constant(gdk_ce, "KEY_F20", sizeof("KEY_F20")-1, GDK_F20);
	phpg_register_int_constant(gdk_ce, "KEY_L10", sizeof("KEY_L10")-1, GDK_L10);
	phpg_register_int_constant(gdk_ce, "KEY_F21", sizeof("KEY_F21")-1, GDK_F21);
	phpg_register_int_constant(gdk_ce, "KEY_R1", sizeof("KEY_R1")-1, GDK_R1);
	phpg_register_int_constant(gdk_ce, "KEY_F22", sizeof("KEY_F22")-1, GDK_F22);
	phpg_register_int_constant(gdk_ce, "KEY_R2", sizeof("KEY_R2")-1, GDK_R2);
	phpg_register_int_constant(gdk_ce, "KEY_F23", sizeof("KEY_F23")-1, GDK_F23);
	phpg_register_int_constant(gdk_ce, "KEY_R3", sizeof("KEY_R3")-1, GDK_R3);
	phpg_register_int_constant(gdk_ce, "KEY_F24", sizeof("KEY_F24")-1, GDK_F24);
	phpg_register_int_constant(gdk_ce, "KEY_R4", sizeof("KEY_R4")-1, GDK_R4);
	phpg_register_int_constant(gdk_ce, "KEY_F25", sizeof("KEY_F25")-1, GDK_F25);
	phpg_register_int_constant(gdk_ce, "KEY_R5", sizeof("KEY_R5")-1, GDK_R5);
	phpg_register_int_constant(gdk_ce, "KEY_F26", sizeof("KEY_F26")-1, GDK_F26);
	phpg_register_int_constant(gdk_ce, "KEY_R6", sizeof("KEY_R6")-1, GDK_R6);
	phpg_register_int_constant(gdk_ce, "KEY_F27", sizeof("KEY_F27")-1, GDK_F27);
	phpg_register_int_constant(gdk_ce, "KEY_R7", sizeof("KEY_R7")-1, GDK_R7);
	phpg_register_int_constant(gdk_ce, "KEY_F28", sizeof("KEY_F28")-1, GDK_F28);
	phpg_register_int_constant(gdk_ce, "KEY_R8", sizeof("KEY_R8")-1, GDK_R8);
	phpg_register_int_constant(gdk_ce, "KEY_F29", sizeof("KEY_F29")-1, GDK_F29);
	phpg_register_int_constant(gdk_ce, "KEY_R9", sizeof("KEY_R9")-1, GDK_R9);
	phpg_register_int_constant(gdk_ce, "KEY_F30", sizeof("KEY_F30")-1, GDK_F30);
	phpg_register_int_constant(gdk_ce, "KEY_R10", sizeof("KEY_R10")-1, GDK_R10);
	phpg_register_int_constant(gdk_ce, "KEY_F31", sizeof("KEY_F31")-1, GDK_F31);
	phpg_register_int_constant(gdk_ce, "KEY_R11", sizeof("KEY_R11")-1, GDK_R11);
	phpg_register_int_constant(gdk_ce, "KEY_F32", sizeof("KEY_F32")-1, GDK_F32);
	phpg_register_int_constant(gdk_ce, "KEY_R12", sizeof("KEY_R12")-1, GDK_R12);
	phpg_register_int_constant(gdk_ce, "KEY_F33", sizeof("KEY_F33")-1, GDK_F33);
	phpg_register_int_constant(gdk_ce, "KEY_R13", sizeof("KEY_R13")-1, GDK_R13);
	phpg_register_int_constant(gdk_ce, "KEY_F34", sizeof("KEY_F34")-1, GDK_F34);
	phpg_register_int_constant(gdk_ce, "KEY_R14", sizeof("KEY_R14")-1, GDK_R14);
	phpg_register_int_constant(gdk_ce, "KEY_F35", sizeof("KEY_F35")-1, GDK_F35);
	phpg_register_int_constant(gdk_ce, "KEY_R15", sizeof("KEY_R15")-1, GDK_R15);
	phpg_register_int_constant(gdk_ce, "KEY_Shift_L", sizeof("KEY_Shift_L")-1, GDK_Shift_L);
	phpg_register_int_constant(gdk_ce, "KEY_Shift_R", sizeof("KEY_Shift_R")-1, GDK_Shift_R);
	phpg_register_int_constant(gdk_ce, "KEY_Control_L", sizeof("KEY_Control_L")-1, GDK_Control_L);
	phpg_register_int_constant(gdk_ce, "KEY_Control_R", sizeof("KEY_Control_R")-1, GDK_Control_R);
	phpg_register_int_constant(gdk_ce, "KEY_Caps_Lock", sizeof("KEY_Caps_Lock")-1, GDK_Caps_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_Shift_Lock", sizeof("KEY_Shift_Lock")-1, GDK_Shift_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_Meta_L", sizeof("KEY_Meta_L")-1, GDK_Meta_L);
	phpg_register_int_constant(gdk_ce, "KEY_Meta_R", sizeof("KEY_Meta_R")-1, GDK_Meta_R);
	phpg_register_int_constant(gdk_ce, "KEY_Alt_L", sizeof("KEY_Alt_L")-1, GDK_Alt_L);
	phpg_register_int_constant(gdk_ce, "KEY_Alt_R", sizeof("KEY_Alt_R")-1, GDK_Alt_R);
	phpg_register_int_constant(gdk_ce, "KEY_Super_L", sizeof("KEY_Super_L")-1, GDK_Super_L);
	phpg_register_int_constant(gdk_ce, "KEY_Super_R", sizeof("KEY_Super_R")-1, GDK_Super_R);
	phpg_register_int_constant(gdk_ce, "KEY_Hyper_L", sizeof("KEY_Hyper_L")-1, GDK_Hyper_L);
	phpg_register_int_constant(gdk_ce, "KEY_Hyper_R", sizeof("KEY_Hyper_R")-1, GDK_Hyper_R);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Lock", sizeof("KEY_ISO_Lock")-1, GDK_ISO_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Level2_Latch", sizeof("KEY_ISO_Level2_Latch")-1, GDK_ISO_Level2_Latch);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Level3_Shift", sizeof("KEY_ISO_Level3_Shift")-1, GDK_ISO_Level3_Shift);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Level3_Latch", sizeof("KEY_ISO_Level3_Latch")-1, GDK_ISO_Level3_Latch);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Level3_Lock", sizeof("KEY_ISO_Level3_Lock")-1, GDK_ISO_Level3_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Group_Shift", sizeof("KEY_ISO_Group_Shift")-1, GDK_ISO_Group_Shift);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Group_Latch", sizeof("KEY_ISO_Group_Latch")-1, GDK_ISO_Group_Latch);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Group_Lock", sizeof("KEY_ISO_Group_Lock")-1, GDK_ISO_Group_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Next_Group", sizeof("KEY_ISO_Next_Group")-1, GDK_ISO_Next_Group);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Next_Group_Lock", sizeof("KEY_ISO_Next_Group_Lock")-1, GDK_ISO_Next_Group_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Prev_Group", sizeof("KEY_ISO_Prev_Group")-1, GDK_ISO_Prev_Group);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Prev_Group_Lock", sizeof("KEY_ISO_Prev_Group_Lock")-1, GDK_ISO_Prev_Group_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_First_Group", sizeof("KEY_ISO_First_Group")-1, GDK_ISO_First_Group);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_First_Group_Lock", sizeof("KEY_ISO_First_Group_Lock")-1, GDK_ISO_First_Group_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Last_Group", sizeof("KEY_ISO_Last_Group")-1, GDK_ISO_Last_Group);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Last_Group_Lock", sizeof("KEY_ISO_Last_Group_Lock")-1, GDK_ISO_Last_Group_Lock);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Left_Tab", sizeof("KEY_ISO_Left_Tab")-1, GDK_ISO_Left_Tab);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Move_Line_Up", sizeof("KEY_ISO_Move_Line_Up")-1, GDK_ISO_Move_Line_Up);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Move_Line_Down", sizeof("KEY_ISO_Move_Line_Down")-1, GDK_ISO_Move_Line_Down);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Partial_Line_Up", sizeof("KEY_ISO_Partial_Line_Up")-1, GDK_ISO_Partial_Line_Up);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Partial_Line_Down", sizeof("KEY_ISO_Partial_Line_Down")-1, GDK_ISO_Partial_Line_Down);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Partial_Space_Left", sizeof("KEY_ISO_Partial_Space_Left")-1, GDK_ISO_Partial_Space_Left);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Partial_Space_Right", sizeof("KEY_ISO_Partial_Space_Right")-1, GDK_ISO_Partial_Space_Right);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Set_Margin_Left", sizeof("KEY_ISO_Set_Margin_Left")-1, GDK_ISO_Set_Margin_Left);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Set_Margin_Right", sizeof("KEY_ISO_Set_Margin_Right")-1, GDK_ISO_Set_Margin_Right);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Release_Margin_Left", sizeof("KEY_ISO_Release_Margin_Left")-1, GDK_ISO_Release_Margin_Left);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Release_Margin_Right", sizeof("KEY_ISO_Release_Margin_Right")-1, GDK_ISO_Release_Margin_Right);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Release_Both_Margins", sizeof("KEY_ISO_Release_Both_Margins")-1, GDK_ISO_Release_Both_Margins);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Fast_Cursor_Left", sizeof("KEY_ISO_Fast_Cursor_Left")-1, GDK_ISO_Fast_Cursor_Left);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Fast_Cursor_Right", sizeof("KEY_ISO_Fast_Cursor_Right")-1, GDK_ISO_Fast_Cursor_Right);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Fast_Cursor_Up", sizeof("KEY_ISO_Fast_Cursor_Up")-1, GDK_ISO_Fast_Cursor_Up);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Fast_Cursor_Down", sizeof("KEY_ISO_Fast_Cursor_Down")-1, GDK_ISO_Fast_Cursor_Down);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Continuous_Underline", sizeof("KEY_ISO_Continuous_Underline")-1, GDK_ISO_Continuous_Underline);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Discontinuous_Underline", sizeof("KEY_ISO_Discontinuous_Underline")-1, GDK_ISO_Discontinuous_Underline);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Emphasize", sizeof("KEY_ISO_Emphasize")-1, GDK_ISO_Emphasize);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Center_Object", sizeof("KEY_ISO_Center_Object")-1, GDK_ISO_Center_Object);
	phpg_register_int_constant(gdk_ce, "KEY_ISO_Enter", sizeof("KEY_ISO_Enter")-1, GDK_ISO_Enter);
	phpg_register_int_constant(gdk_ce, "KEY_dead_grave", sizeof("KEY_dead_grave")-1, GDK_dead_grave);
	phpg_register_int_constant(gdk_ce, "KEY_dead_acute", sizeof("KEY_dead_acute")-1, GDK_dead_acute);
	phpg_register_int_constant(gdk_ce, "KEY_dead_circumflex", sizeof("KEY_dead_circumflex")-1, GDK_dead_circumflex);
	phpg_register_int_constant(gdk_ce, "KEY_dead_tilde", sizeof("KEY_dead_tilde")-1, GDK_dead_tilde);
	phpg_register_int_constant(gdk_ce, "KEY_dead_macron", sizeof("KEY_dead_macron")-1, GDK_dead_macron);
	phpg_register_int_constant(gdk_ce, "KEY_dead_breve", sizeof("KEY_dead_breve")-1, GDK_dead_breve);
	phpg_register_int_constant(gdk_ce, "KEY_dead_abovedot", sizeof("KEY_dead_abovedot")-1, GDK_dead_abovedot);
	phpg_register_int_constant(gdk_ce, "KEY_dead_diaeresis", sizeof("KEY_dead_diaeresis")-1, GDK_dead_diaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_dead_abovering", sizeof("KEY_dead_abovering")-1, GDK_dead_abovering);
	phpg_register_int_constant(gdk_ce, "KEY_dead_doubleacute", sizeof("KEY_dead_doubleacute")-1, GDK_dead_doubleacute);
	phpg_register_int_constant(gdk_ce, "KEY_dead_caron", sizeof("KEY_dead_caron")-1, GDK_dead_caron);
	phpg_register_int_constant(gdk_ce, "KEY_dead_cedilla", sizeof("KEY_dead_cedilla")-1, GDK_dead_cedilla);
	phpg_register_int_constant(gdk_ce, "KEY_dead_ogonek", sizeof("KEY_dead_ogonek")-1, GDK_dead_ogonek);
	phpg_register_int_constant(gdk_ce, "KEY_dead_iota", sizeof("KEY_dead_iota")-1, GDK_dead_iota);
	phpg_register_int_constant(gdk_ce, "KEY_dead_voiced_sound", sizeof("KEY_dead_voiced_sound")-1, GDK_dead_voiced_sound);
	phpg_register_int_constant(gdk_ce, "KEY_dead_semivoiced_sound", sizeof("KEY_dead_semivoiced_sound")-1, GDK_dead_semivoiced_sound);
	phpg_register_int_constant(gdk_ce, "KEY_dead_belowdot", sizeof("KEY_dead_belowdot")-1, GDK_dead_belowdot);
	phpg_register_int_constant(gdk_ce, "KEY_dead_hook", sizeof("KEY_dead_hook")-1, GDK_dead_hook);
	phpg_register_int_constant(gdk_ce, "KEY_dead_horn", sizeof("KEY_dead_horn")-1, GDK_dead_horn);
	phpg_register_int_constant(gdk_ce, "KEY_First_Virtual_Screen", sizeof("KEY_First_Virtual_Screen")-1, GDK_First_Virtual_Screen);
	phpg_register_int_constant(gdk_ce, "KEY_Prev_Virtual_Screen", sizeof("KEY_Prev_Virtual_Screen")-1, GDK_Prev_Virtual_Screen);
	phpg_register_int_constant(gdk_ce, "KEY_Next_Virtual_Screen", sizeof("KEY_Next_Virtual_Screen")-1, GDK_Next_Virtual_Screen);
	phpg_register_int_constant(gdk_ce, "KEY_Last_Virtual_Screen", sizeof("KEY_Last_Virtual_Screen")-1, GDK_Last_Virtual_Screen);
	phpg_register_int_constant(gdk_ce, "KEY_Terminate_Server", sizeof("KEY_Terminate_Server")-1, GDK_Terminate_Server);
	phpg_register_int_constant(gdk_ce, "KEY_AccessX_Enable", sizeof("KEY_AccessX_Enable")-1, GDK_AccessX_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_AccessX_Feedback_Enable", sizeof("KEY_AccessX_Feedback_Enable")-1, GDK_AccessX_Feedback_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_RepeatKeys_Enable", sizeof("KEY_RepeatKeys_Enable")-1, GDK_RepeatKeys_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_SlowKeys_Enable", sizeof("KEY_SlowKeys_Enable")-1, GDK_SlowKeys_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_BounceKeys_Enable", sizeof("KEY_BounceKeys_Enable")-1, GDK_BounceKeys_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_StickyKeys_Enable", sizeof("KEY_StickyKeys_Enable")-1, GDK_StickyKeys_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_MouseKeys_Enable", sizeof("KEY_MouseKeys_Enable")-1, GDK_MouseKeys_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_MouseKeys_Accel_Enable", sizeof("KEY_MouseKeys_Accel_Enable")-1, GDK_MouseKeys_Accel_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_Overlay1_Enable", sizeof("KEY_Overlay1_Enable")-1, GDK_Overlay1_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_Overlay2_Enable", sizeof("KEY_Overlay2_Enable")-1, GDK_Overlay2_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_AudibleBell_Enable", sizeof("KEY_AudibleBell_Enable")-1, GDK_AudibleBell_Enable);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Left", sizeof("KEY_Pointer_Left")-1, GDK_Pointer_Left);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Right", sizeof("KEY_Pointer_Right")-1, GDK_Pointer_Right);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Up", sizeof("KEY_Pointer_Up")-1, GDK_Pointer_Up);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Down", sizeof("KEY_Pointer_Down")-1, GDK_Pointer_Down);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_UpLeft", sizeof("KEY_Pointer_UpLeft")-1, GDK_Pointer_UpLeft);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_UpRight", sizeof("KEY_Pointer_UpRight")-1, GDK_Pointer_UpRight);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DownLeft", sizeof("KEY_Pointer_DownLeft")-1, GDK_Pointer_DownLeft);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DownRight", sizeof("KEY_Pointer_DownRight")-1, GDK_Pointer_DownRight);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Button_Dflt", sizeof("KEY_Pointer_Button_Dflt")-1, GDK_Pointer_Button_Dflt);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Button1", sizeof("KEY_Pointer_Button1")-1, GDK_Pointer_Button1);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Button2", sizeof("KEY_Pointer_Button2")-1, GDK_Pointer_Button2);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Button3", sizeof("KEY_Pointer_Button3")-1, GDK_Pointer_Button3);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Button4", sizeof("KEY_Pointer_Button4")-1, GDK_Pointer_Button4);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Button5", sizeof("KEY_Pointer_Button5")-1, GDK_Pointer_Button5);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DblClick_Dflt", sizeof("KEY_Pointer_DblClick_Dflt")-1, GDK_Pointer_DblClick_Dflt);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DblClick1", sizeof("KEY_Pointer_DblClick1")-1, GDK_Pointer_DblClick1);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DblClick2", sizeof("KEY_Pointer_DblClick2")-1, GDK_Pointer_DblClick2);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DblClick3", sizeof("KEY_Pointer_DblClick3")-1, GDK_Pointer_DblClick3);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DblClick4", sizeof("KEY_Pointer_DblClick4")-1, GDK_Pointer_DblClick4);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DblClick5", sizeof("KEY_Pointer_DblClick5")-1, GDK_Pointer_DblClick5);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Drag_Dflt", sizeof("KEY_Pointer_Drag_Dflt")-1, GDK_Pointer_Drag_Dflt);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Drag1", sizeof("KEY_Pointer_Drag1")-1, GDK_Pointer_Drag1);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Drag2", sizeof("KEY_Pointer_Drag2")-1, GDK_Pointer_Drag2);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Drag3", sizeof("KEY_Pointer_Drag3")-1, GDK_Pointer_Drag3);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Drag4", sizeof("KEY_Pointer_Drag4")-1, GDK_Pointer_Drag4);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Drag5", sizeof("KEY_Pointer_Drag5")-1, GDK_Pointer_Drag5);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_EnableKeys", sizeof("KEY_Pointer_EnableKeys")-1, GDK_Pointer_EnableKeys);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_Accelerate", sizeof("KEY_Pointer_Accelerate")-1, GDK_Pointer_Accelerate);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DfltBtnNext", sizeof("KEY_Pointer_DfltBtnNext")-1, GDK_Pointer_DfltBtnNext);
	phpg_register_int_constant(gdk_ce, "KEY_Pointer_DfltBtnPrev", sizeof("KEY_Pointer_DfltBtnPrev")-1, GDK_Pointer_DfltBtnPrev);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Duplicate", sizeof("KEY_3270_Duplicate")-1, GDK_3270_Duplicate);
	phpg_register_int_constant(gdk_ce, "KEY_3270_FieldMark", sizeof("KEY_3270_FieldMark")-1, GDK_3270_FieldMark);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Right2", sizeof("KEY_3270_Right2")-1, GDK_3270_Right2);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Left2", sizeof("KEY_3270_Left2")-1, GDK_3270_Left2);
	phpg_register_int_constant(gdk_ce, "KEY_3270_BackTab", sizeof("KEY_3270_BackTab")-1, GDK_3270_BackTab);
	phpg_register_int_constant(gdk_ce, "KEY_3270_EraseEOF", sizeof("KEY_3270_EraseEOF")-1, GDK_3270_EraseEOF);
	phpg_register_int_constant(gdk_ce, "KEY_3270_EraseInput", sizeof("KEY_3270_EraseInput")-1, GDK_3270_EraseInput);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Reset", sizeof("KEY_3270_Reset")-1, GDK_3270_Reset);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Quit", sizeof("KEY_3270_Quit")-1, GDK_3270_Quit);
	phpg_register_int_constant(gdk_ce, "KEY_3270_PA1", sizeof("KEY_3270_PA1")-1, GDK_3270_PA1);
	phpg_register_int_constant(gdk_ce, "KEY_3270_PA2", sizeof("KEY_3270_PA2")-1, GDK_3270_PA2);
	phpg_register_int_constant(gdk_ce, "KEY_3270_PA3", sizeof("KEY_3270_PA3")-1, GDK_3270_PA3);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Test", sizeof("KEY_3270_Test")-1, GDK_3270_Test);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Attn", sizeof("KEY_3270_Attn")-1, GDK_3270_Attn);
	phpg_register_int_constant(gdk_ce, "KEY_3270_CursorBlink", sizeof("KEY_3270_CursorBlink")-1, GDK_3270_CursorBlink);
	phpg_register_int_constant(gdk_ce, "KEY_3270_AltCursor", sizeof("KEY_3270_AltCursor")-1, GDK_3270_AltCursor);
	phpg_register_int_constant(gdk_ce, "KEY_3270_KeyClick", sizeof("KEY_3270_KeyClick")-1, GDK_3270_KeyClick);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Jump", sizeof("KEY_3270_Jump")-1, GDK_3270_Jump);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Ident", sizeof("KEY_3270_Ident")-1, GDK_3270_Ident);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Rule", sizeof("KEY_3270_Rule")-1, GDK_3270_Rule);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Copy", sizeof("KEY_3270_Copy")-1, GDK_3270_Copy);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Play", sizeof("KEY_3270_Play")-1, GDK_3270_Play);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Setup", sizeof("KEY_3270_Setup")-1, GDK_3270_Setup);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Record", sizeof("KEY_3270_Record")-1, GDK_3270_Record);
	phpg_register_int_constant(gdk_ce, "KEY_3270_ChangeScreen", sizeof("KEY_3270_ChangeScreen")-1, GDK_3270_ChangeScreen);
	phpg_register_int_constant(gdk_ce, "KEY_3270_DeleteWord", sizeof("KEY_3270_DeleteWord")-1, GDK_3270_DeleteWord);
	phpg_register_int_constant(gdk_ce, "KEY_3270_ExSelect", sizeof("KEY_3270_ExSelect")-1, GDK_3270_ExSelect);
	phpg_register_int_constant(gdk_ce, "KEY_3270_CursorSelect", sizeof("KEY_3270_CursorSelect")-1, GDK_3270_CursorSelect);
	phpg_register_int_constant(gdk_ce, "KEY_3270_PrintScreen", sizeof("KEY_3270_PrintScreen")-1, GDK_3270_PrintScreen);
	phpg_register_int_constant(gdk_ce, "KEY_3270_Enter", sizeof("KEY_3270_Enter")-1, GDK_3270_Enter);
	phpg_register_int_constant(gdk_ce, "KEY_space", sizeof("KEY_space")-1, GDK_space);
	phpg_register_int_constant(gdk_ce, "KEY_exclam", sizeof("KEY_exclam")-1, GDK_exclam);
	phpg_register_int_constant(gdk_ce, "KEY_quotedbl", sizeof("KEY_quotedbl")-1, GDK_quotedbl);
	phpg_register_int_constant(gdk_ce, "KEY_numbersign", sizeof("KEY_numbersign")-1, GDK_numbersign);
	phpg_register_int_constant(gdk_ce, "KEY_dollar", sizeof("KEY_dollar")-1, GDK_dollar);
	phpg_register_int_constant(gdk_ce, "KEY_percent", sizeof("KEY_percent")-1, GDK_percent);
	phpg_register_int_constant(gdk_ce, "KEY_ampersand", sizeof("KEY_ampersand")-1, GDK_ampersand);
	phpg_register_int_constant(gdk_ce, "KEY_apostrophe", sizeof("KEY_apostrophe")-1, GDK_apostrophe);
	phpg_register_int_constant(gdk_ce, "KEY_quoteright", sizeof("KEY_quoteright")-1, GDK_quoteright);
	phpg_register_int_constant(gdk_ce, "KEY_parenleft", sizeof("KEY_parenleft")-1, GDK_parenleft);
	phpg_register_int_constant(gdk_ce, "KEY_parenright", sizeof("KEY_parenright")-1, GDK_parenright);
	phpg_register_int_constant(gdk_ce, "KEY_asterisk", sizeof("KEY_asterisk")-1, GDK_asterisk);
	phpg_register_int_constant(gdk_ce, "KEY_plus", sizeof("KEY_plus")-1, GDK_plus);
	phpg_register_int_constant(gdk_ce, "KEY_comma", sizeof("KEY_comma")-1, GDK_comma);
	phpg_register_int_constant(gdk_ce, "KEY_minus", sizeof("KEY_minus")-1, GDK_minus);
	phpg_register_int_constant(gdk_ce, "KEY_period", sizeof("KEY_period")-1, GDK_period);
	phpg_register_int_constant(gdk_ce, "KEY_slash", sizeof("KEY_slash")-1, GDK_slash);
	phpg_register_int_constant(gdk_ce, "KEY_0", sizeof("KEY_0")-1, GDK_0);
	phpg_register_int_constant(gdk_ce, "KEY_1", sizeof("KEY_1")-1, GDK_1);
	phpg_register_int_constant(gdk_ce, "KEY_2", sizeof("KEY_2")-1, GDK_2);
	phpg_register_int_constant(gdk_ce, "KEY_3", sizeof("KEY_3")-1, GDK_3);
	phpg_register_int_constant(gdk_ce, "KEY_4", sizeof("KEY_4")-1, GDK_4);
	phpg_register_int_constant(gdk_ce, "KEY_5", sizeof("KEY_5")-1, GDK_5);
	phpg_register_int_constant(gdk_ce, "KEY_6", sizeof("KEY_6")-1, GDK_6);
	phpg_register_int_constant(gdk_ce, "KEY_7", sizeof("KEY_7")-1, GDK_7);
	phpg_register_int_constant(gdk_ce, "KEY_8", sizeof("KEY_8")-1, GDK_8);
	phpg_register_int_constant(gdk_ce, "KEY_9", sizeof("KEY_9")-1, GDK_9);
	phpg_register_int_constant(gdk_ce, "KEY_colon", sizeof("KEY_colon")-1, GDK_colon);
	phpg_register_int_constant(gdk_ce, "KEY_semicolon", sizeof("KEY_semicolon")-1, GDK_semicolon);
	phpg_register_int_constant(gdk_ce, "KEY_less", sizeof("KEY_less")-1, GDK_less);
	phpg_register_int_constant(gdk_ce, "KEY_equal", sizeof("KEY_equal")-1, GDK_equal);
	phpg_register_int_constant(gdk_ce, "KEY_greater", sizeof("KEY_greater")-1, GDK_greater);
	phpg_register_int_constant(gdk_ce, "KEY_question", sizeof("KEY_question")-1, GDK_question);
	phpg_register_int_constant(gdk_ce, "KEY_at", sizeof("KEY_at")-1, GDK_at);
	phpg_register_int_constant(gdk_ce, "KEY_A", sizeof("KEY_A")-1, GDK_A);
	phpg_register_int_constant(gdk_ce, "KEY_B", sizeof("KEY_B")-1, GDK_B);
	phpg_register_int_constant(gdk_ce, "KEY_C", sizeof("KEY_C")-1, GDK_C);
	phpg_register_int_constant(gdk_ce, "KEY_D", sizeof("KEY_D")-1, GDK_D);
	phpg_register_int_constant(gdk_ce, "KEY_E", sizeof("KEY_E")-1, GDK_E);
	phpg_register_int_constant(gdk_ce, "KEY_F", sizeof("KEY_F")-1, GDK_F);
	phpg_register_int_constant(gdk_ce, "KEY_G", sizeof("KEY_G")-1, GDK_G);
	phpg_register_int_constant(gdk_ce, "KEY_H", sizeof("KEY_H")-1, GDK_H);
	phpg_register_int_constant(gdk_ce, "KEY_I", sizeof("KEY_I")-1, GDK_I);
	phpg_register_int_constant(gdk_ce, "KEY_J", sizeof("KEY_J")-1, GDK_J);
	phpg_register_int_constant(gdk_ce, "KEY_K", sizeof("KEY_K")-1, GDK_K);
	phpg_register_int_constant(gdk_ce, "KEY_L", sizeof("KEY_L")-1, GDK_L);
	phpg_register_int_constant(gdk_ce, "KEY_M", sizeof("KEY_M")-1, GDK_M);
	phpg_register_int_constant(gdk_ce, "KEY_N", sizeof("KEY_N")-1, GDK_N);
	phpg_register_int_constant(gdk_ce, "KEY_O", sizeof("KEY_O")-1, GDK_O);
	phpg_register_int_constant(gdk_ce, "KEY_P", sizeof("KEY_P")-1, GDK_P);
	phpg_register_int_constant(gdk_ce, "KEY_Q", sizeof("KEY_Q")-1, GDK_Q);
	phpg_register_int_constant(gdk_ce, "KEY_R", sizeof("KEY_R")-1, GDK_R);
	phpg_register_int_constant(gdk_ce, "KEY_S", sizeof("KEY_S")-1, GDK_S);
	phpg_register_int_constant(gdk_ce, "KEY_T", sizeof("KEY_T")-1, GDK_T);
	phpg_register_int_constant(gdk_ce, "KEY_U", sizeof("KEY_U")-1, GDK_U);
	phpg_register_int_constant(gdk_ce, "KEY_V", sizeof("KEY_V")-1, GDK_V);
	phpg_register_int_constant(gdk_ce, "KEY_W", sizeof("KEY_W")-1, GDK_W);
	phpg_register_int_constant(gdk_ce, "KEY_X", sizeof("KEY_X")-1, GDK_X);
	phpg_register_int_constant(gdk_ce, "KEY_Y", sizeof("KEY_Y")-1, GDK_Y);
	phpg_register_int_constant(gdk_ce, "KEY_Z", sizeof("KEY_Z")-1, GDK_Z);
	phpg_register_int_constant(gdk_ce, "KEY_bracketleft", sizeof("KEY_bracketleft")-1, GDK_bracketleft);
	phpg_register_int_constant(gdk_ce, "KEY_backslash", sizeof("KEY_backslash")-1, GDK_backslash);
	phpg_register_int_constant(gdk_ce, "KEY_bracketright", sizeof("KEY_bracketright")-1, GDK_bracketright);
	phpg_register_int_constant(gdk_ce, "KEY_asciicircum", sizeof("KEY_asciicircum")-1, GDK_asciicircum);
	phpg_register_int_constant(gdk_ce, "KEY_underscore", sizeof("KEY_underscore")-1, GDK_underscore);
	phpg_register_int_constant(gdk_ce, "KEY_grave", sizeof("KEY_grave")-1, GDK_grave);
	phpg_register_int_constant(gdk_ce, "KEY_quoteleft", sizeof("KEY_quoteleft")-1, GDK_quoteleft);
	phpg_register_int_constant(gdk_ce, "KEY_a", sizeof("KEY_a")-1, GDK_a);
	phpg_register_int_constant(gdk_ce, "KEY_b", sizeof("KEY_b")-1, GDK_b);
	phpg_register_int_constant(gdk_ce, "KEY_c", sizeof("KEY_c")-1, GDK_c);
	phpg_register_int_constant(gdk_ce, "KEY_d", sizeof("KEY_d")-1, GDK_d);
	phpg_register_int_constant(gdk_ce, "KEY_e", sizeof("KEY_e")-1, GDK_e);
	phpg_register_int_constant(gdk_ce, "KEY_f", sizeof("KEY_f")-1, GDK_f);
	phpg_register_int_constant(gdk_ce, "KEY_g", sizeof("KEY_g")-1, GDK_g);
	phpg_register_int_constant(gdk_ce, "KEY_h", sizeof("KEY_h")-1, GDK_h);
	phpg_register_int_constant(gdk_ce, "KEY_i", sizeof("KEY_i")-1, GDK_i);
	phpg_register_int_constant(gdk_ce, "KEY_j", sizeof("KEY_j")-1, GDK_j);
	phpg_register_int_constant(gdk_ce, "KEY_k", sizeof("KEY_k")-1, GDK_k);
	phpg_register_int_constant(gdk_ce, "KEY_l", sizeof("KEY_l")-1, GDK_l);
	phpg_register_int_constant(gdk_ce, "KEY_m", sizeof("KEY_m")-1, GDK_m);
	phpg_register_int_constant(gdk_ce, "KEY_n", sizeof("KEY_n")-1, GDK_n);
	phpg_register_int_constant(gdk_ce, "KEY_o", sizeof("KEY_o")-1, GDK_o);
	phpg_register_int_constant(gdk_ce, "KEY_p", sizeof("KEY_p")-1, GDK_p);
	phpg_register_int_constant(gdk_ce, "KEY_q", sizeof("KEY_q")-1, GDK_q);
	phpg_register_int_constant(gdk_ce, "KEY_r", sizeof("KEY_r")-1, GDK_r);
	phpg_register_int_constant(gdk_ce, "KEY_s", sizeof("KEY_s")-1, GDK_s);
	phpg_register_int_constant(gdk_ce, "KEY_t", sizeof("KEY_t")-1, GDK_t);
	phpg_register_int_constant(gdk_ce, "KEY_u", sizeof("KEY_u")-1, GDK_u);
	phpg_register_int_constant(gdk_ce, "KEY_v", sizeof("KEY_v")-1, GDK_v);
	phpg_register_int_constant(gdk_ce, "KEY_w", sizeof("KEY_w")-1, GDK_w);
	phpg_register_int_constant(gdk_ce, "KEY_x", sizeof("KEY_x")-1, GDK_x);
	phpg_register_int_constant(gdk_ce, "KEY_y", sizeof("KEY_y")-1, GDK_y);
	phpg_register_int_constant(gdk_ce, "KEY_z", sizeof("KEY_z")-1, GDK_z);
	phpg_register_int_constant(gdk_ce, "KEY_braceleft", sizeof("KEY_braceleft")-1, GDK_braceleft);
	phpg_register_int_constant(gdk_ce, "KEY_bar", sizeof("KEY_bar")-1, GDK_bar);
	phpg_register_int_constant(gdk_ce, "KEY_braceright", sizeof("KEY_braceright")-1, GDK_braceright);
	phpg_register_int_constant(gdk_ce, "KEY_asciitilde", sizeof("KEY_asciitilde")-1, GDK_asciitilde);
	phpg_register_int_constant(gdk_ce, "KEY_nobreakspace", sizeof("KEY_nobreakspace")-1, GDK_nobreakspace);
	phpg_register_int_constant(gdk_ce, "KEY_exclamdown", sizeof("KEY_exclamdown")-1, GDK_exclamdown);
	phpg_register_int_constant(gdk_ce, "KEY_cent", sizeof("KEY_cent")-1, GDK_cent);
	phpg_register_int_constant(gdk_ce, "KEY_sterling", sizeof("KEY_sterling")-1, GDK_sterling);
	phpg_register_int_constant(gdk_ce, "KEY_currency", sizeof("KEY_currency")-1, GDK_currency);
	phpg_register_int_constant(gdk_ce, "KEY_yen", sizeof("KEY_yen")-1, GDK_yen);
	phpg_register_int_constant(gdk_ce, "KEY_brokenbar", sizeof("KEY_brokenbar")-1, GDK_brokenbar);
	phpg_register_int_constant(gdk_ce, "KEY_section", sizeof("KEY_section")-1, GDK_section);
	phpg_register_int_constant(gdk_ce, "KEY_diaeresis", sizeof("KEY_diaeresis")-1, GDK_diaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_copyright", sizeof("KEY_copyright")-1, GDK_copyright);
	phpg_register_int_constant(gdk_ce, "KEY_ordfeminine", sizeof("KEY_ordfeminine")-1, GDK_ordfeminine);
	phpg_register_int_constant(gdk_ce, "KEY_guillemotleft", sizeof("KEY_guillemotleft")-1, GDK_guillemotleft);
	phpg_register_int_constant(gdk_ce, "KEY_notsign", sizeof("KEY_notsign")-1, GDK_notsign);
	phpg_register_int_constant(gdk_ce, "KEY_hyphen", sizeof("KEY_hyphen")-1, GDK_hyphen);
	phpg_register_int_constant(gdk_ce, "KEY_registered", sizeof("KEY_registered")-1, GDK_registered);
	phpg_register_int_constant(gdk_ce, "KEY_macron", sizeof("KEY_macron")-1, GDK_macron);
	phpg_register_int_constant(gdk_ce, "KEY_degree", sizeof("KEY_degree")-1, GDK_degree);
	phpg_register_int_constant(gdk_ce, "KEY_plusminus", sizeof("KEY_plusminus")-1, GDK_plusminus);
	phpg_register_int_constant(gdk_ce, "KEY_twosuperior", sizeof("KEY_twosuperior")-1, GDK_twosuperior);
	phpg_register_int_constant(gdk_ce, "KEY_threesuperior", sizeof("KEY_threesuperior")-1, GDK_threesuperior);
	phpg_register_int_constant(gdk_ce, "KEY_acute", sizeof("KEY_acute")-1, GDK_acute);
	phpg_register_int_constant(gdk_ce, "KEY_mu", sizeof("KEY_mu")-1, GDK_mu);
	phpg_register_int_constant(gdk_ce, "KEY_paragraph", sizeof("KEY_paragraph")-1, GDK_paragraph);
	phpg_register_int_constant(gdk_ce, "KEY_periodcentered", sizeof("KEY_periodcentered")-1, GDK_periodcentered);
	phpg_register_int_constant(gdk_ce, "KEY_cedilla", sizeof("KEY_cedilla")-1, GDK_cedilla);
	phpg_register_int_constant(gdk_ce, "KEY_onesuperior", sizeof("KEY_onesuperior")-1, GDK_onesuperior);
	phpg_register_int_constant(gdk_ce, "KEY_masculine", sizeof("KEY_masculine")-1, GDK_masculine);
	phpg_register_int_constant(gdk_ce, "KEY_guillemotright", sizeof("KEY_guillemotright")-1, GDK_guillemotright);
	phpg_register_int_constant(gdk_ce, "KEY_onequarter", sizeof("KEY_onequarter")-1, GDK_onequarter);
	phpg_register_int_constant(gdk_ce, "KEY_onehalf", sizeof("KEY_onehalf")-1, GDK_onehalf);
	phpg_register_int_constant(gdk_ce, "KEY_threequarters", sizeof("KEY_threequarters")-1, GDK_threequarters);
	phpg_register_int_constant(gdk_ce, "KEY_questiondown", sizeof("KEY_questiondown")-1, GDK_questiondown);
	phpg_register_int_constant(gdk_ce, "KEY_Agrave", sizeof("KEY_Agrave")-1, GDK_Agrave);
	phpg_register_int_constant(gdk_ce, "KEY_Aacute", sizeof("KEY_Aacute")-1, GDK_Aacute);
	phpg_register_int_constant(gdk_ce, "KEY_Acircumflex", sizeof("KEY_Acircumflex")-1, GDK_Acircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Atilde", sizeof("KEY_Atilde")-1, GDK_Atilde);
	phpg_register_int_constant(gdk_ce, "KEY_Adiaeresis", sizeof("KEY_Adiaeresis")-1, GDK_Adiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_Aring", sizeof("KEY_Aring")-1, GDK_Aring);
	phpg_register_int_constant(gdk_ce, "KEY_AE", sizeof("KEY_AE")-1, GDK_AE);
	phpg_register_int_constant(gdk_ce, "KEY_Ccedilla", sizeof("KEY_Ccedilla")-1, GDK_Ccedilla);
	phpg_register_int_constant(gdk_ce, "KEY_Egrave", sizeof("KEY_Egrave")-1, GDK_Egrave);
	phpg_register_int_constant(gdk_ce, "KEY_Eacute", sizeof("KEY_Eacute")-1, GDK_Eacute);
	phpg_register_int_constant(gdk_ce, "KEY_Ecircumflex", sizeof("KEY_Ecircumflex")-1, GDK_Ecircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Ediaeresis", sizeof("KEY_Ediaeresis")-1, GDK_Ediaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_Igrave", sizeof("KEY_Igrave")-1, GDK_Igrave);
	phpg_register_int_constant(gdk_ce, "KEY_Iacute", sizeof("KEY_Iacute")-1, GDK_Iacute);
	phpg_register_int_constant(gdk_ce, "KEY_Icircumflex", sizeof("KEY_Icircumflex")-1, GDK_Icircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Idiaeresis", sizeof("KEY_Idiaeresis")-1, GDK_Idiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_Eth", sizeof("KEY_Eth")-1, GDK_Eth);
	phpg_register_int_constant(gdk_ce, "KEY_Ntilde", sizeof("KEY_Ntilde")-1, GDK_Ntilde);
	phpg_register_int_constant(gdk_ce, "KEY_Ograve", sizeof("KEY_Ograve")-1, GDK_Ograve);
	phpg_register_int_constant(gdk_ce, "KEY_Oacute", sizeof("KEY_Oacute")-1, GDK_Oacute);
	phpg_register_int_constant(gdk_ce, "KEY_Ocircumflex", sizeof("KEY_Ocircumflex")-1, GDK_Ocircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Otilde", sizeof("KEY_Otilde")-1, GDK_Otilde);
	phpg_register_int_constant(gdk_ce, "KEY_Odiaeresis", sizeof("KEY_Odiaeresis")-1, GDK_Odiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_multiply", sizeof("KEY_multiply")-1, GDK_multiply);
	phpg_register_int_constant(gdk_ce, "KEY_Ooblique", sizeof("KEY_Ooblique")-1, GDK_Ooblique);
	phpg_register_int_constant(gdk_ce, "KEY_Ugrave", sizeof("KEY_Ugrave")-1, GDK_Ugrave);
	phpg_register_int_constant(gdk_ce, "KEY_Uacute", sizeof("KEY_Uacute")-1, GDK_Uacute);
	phpg_register_int_constant(gdk_ce, "KEY_Ucircumflex", sizeof("KEY_Ucircumflex")-1, GDK_Ucircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Udiaeresis", sizeof("KEY_Udiaeresis")-1, GDK_Udiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_Yacute", sizeof("KEY_Yacute")-1, GDK_Yacute);
	phpg_register_int_constant(gdk_ce, "KEY_Thorn", sizeof("KEY_Thorn")-1, GDK_Thorn);
	phpg_register_int_constant(gdk_ce, "KEY_ssharp", sizeof("KEY_ssharp")-1, GDK_ssharp);
	phpg_register_int_constant(gdk_ce, "KEY_agrave", sizeof("KEY_agrave")-1, GDK_agrave);
	phpg_register_int_constant(gdk_ce, "KEY_aacute", sizeof("KEY_aacute")-1, GDK_aacute);
	phpg_register_int_constant(gdk_ce, "KEY_acircumflex", sizeof("KEY_acircumflex")-1, GDK_acircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_atilde", sizeof("KEY_atilde")-1, GDK_atilde);
	phpg_register_int_constant(gdk_ce, "KEY_adiaeresis", sizeof("KEY_adiaeresis")-1, GDK_adiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_aring", sizeof("KEY_aring")-1, GDK_aring);
	phpg_register_int_constant(gdk_ce, "KEY_ae", sizeof("KEY_ae")-1, GDK_ae);
	phpg_register_int_constant(gdk_ce, "KEY_ccedilla", sizeof("KEY_ccedilla")-1, GDK_ccedilla);
	phpg_register_int_constant(gdk_ce, "KEY_egrave", sizeof("KEY_egrave")-1, GDK_egrave);
	phpg_register_int_constant(gdk_ce, "KEY_eacute", sizeof("KEY_eacute")-1, GDK_eacute);
	phpg_register_int_constant(gdk_ce, "KEY_ecircumflex", sizeof("KEY_ecircumflex")-1, GDK_ecircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_ediaeresis", sizeof("KEY_ediaeresis")-1, GDK_ediaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_igrave", sizeof("KEY_igrave")-1, GDK_igrave);
	phpg_register_int_constant(gdk_ce, "KEY_iacute", sizeof("KEY_iacute")-1, GDK_iacute);
	phpg_register_int_constant(gdk_ce, "KEY_icircumflex", sizeof("KEY_icircumflex")-1, GDK_icircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_idiaeresis", sizeof("KEY_idiaeresis")-1, GDK_idiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_eth", sizeof("KEY_eth")-1, GDK_eth);
	phpg_register_int_constant(gdk_ce, "KEY_ntilde", sizeof("KEY_ntilde")-1, GDK_ntilde);
	phpg_register_int_constant(gdk_ce, "KEY_ograve", sizeof("KEY_ograve")-1, GDK_ograve);
	phpg_register_int_constant(gdk_ce, "KEY_oacute", sizeof("KEY_oacute")-1, GDK_oacute);
	phpg_register_int_constant(gdk_ce, "KEY_ocircumflex", sizeof("KEY_ocircumflex")-1, GDK_ocircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_otilde", sizeof("KEY_otilde")-1, GDK_otilde);
	phpg_register_int_constant(gdk_ce, "KEY_odiaeresis", sizeof("KEY_odiaeresis")-1, GDK_odiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_division", sizeof("KEY_division")-1, GDK_division);
	phpg_register_int_constant(gdk_ce, "KEY_oslash", sizeof("KEY_oslash")-1, GDK_oslash);
	phpg_register_int_constant(gdk_ce, "KEY_ugrave", sizeof("KEY_ugrave")-1, GDK_ugrave);
	phpg_register_int_constant(gdk_ce, "KEY_uacute", sizeof("KEY_uacute")-1, GDK_uacute);
	phpg_register_int_constant(gdk_ce, "KEY_ucircumflex", sizeof("KEY_ucircumflex")-1, GDK_ucircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_udiaeresis", sizeof("KEY_udiaeresis")-1, GDK_udiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_yacute", sizeof("KEY_yacute")-1, GDK_yacute);
	phpg_register_int_constant(gdk_ce, "KEY_thorn", sizeof("KEY_thorn")-1, GDK_thorn);
	phpg_register_int_constant(gdk_ce, "KEY_ydiaeresis", sizeof("KEY_ydiaeresis")-1, GDK_ydiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_Aogonek", sizeof("KEY_Aogonek")-1, GDK_Aogonek);
	phpg_register_int_constant(gdk_ce, "KEY_breve", sizeof("KEY_breve")-1, GDK_breve);
	phpg_register_int_constant(gdk_ce, "KEY_Lstroke", sizeof("KEY_Lstroke")-1, GDK_Lstroke);
	phpg_register_int_constant(gdk_ce, "KEY_Lcaron", sizeof("KEY_Lcaron")-1, GDK_Lcaron);
	phpg_register_int_constant(gdk_ce, "KEY_Sacute", sizeof("KEY_Sacute")-1, GDK_Sacute);
	phpg_register_int_constant(gdk_ce, "KEY_Scaron", sizeof("KEY_Scaron")-1, GDK_Scaron);
	phpg_register_int_constant(gdk_ce, "KEY_Scedilla", sizeof("KEY_Scedilla")-1, GDK_Scedilla);
	phpg_register_int_constant(gdk_ce, "KEY_Tcaron", sizeof("KEY_Tcaron")-1, GDK_Tcaron);
	phpg_register_int_constant(gdk_ce, "KEY_Zacute", sizeof("KEY_Zacute")-1, GDK_Zacute);
	phpg_register_int_constant(gdk_ce, "KEY_Zcaron", sizeof("KEY_Zcaron")-1, GDK_Zcaron);
	phpg_register_int_constant(gdk_ce, "KEY_Zabovedot", sizeof("KEY_Zabovedot")-1, GDK_Zabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_aogonek", sizeof("KEY_aogonek")-1, GDK_aogonek);
	phpg_register_int_constant(gdk_ce, "KEY_ogonek", sizeof("KEY_ogonek")-1, GDK_ogonek);
	phpg_register_int_constant(gdk_ce, "KEY_lstroke", sizeof("KEY_lstroke")-1, GDK_lstroke);
	phpg_register_int_constant(gdk_ce, "KEY_lcaron", sizeof("KEY_lcaron")-1, GDK_lcaron);
	phpg_register_int_constant(gdk_ce, "KEY_sacute", sizeof("KEY_sacute")-1, GDK_sacute);
	phpg_register_int_constant(gdk_ce, "KEY_caron", sizeof("KEY_caron")-1, GDK_caron);
	phpg_register_int_constant(gdk_ce, "KEY_scaron", sizeof("KEY_scaron")-1, GDK_scaron);
	phpg_register_int_constant(gdk_ce, "KEY_scedilla", sizeof("KEY_scedilla")-1, GDK_scedilla);
	phpg_register_int_constant(gdk_ce, "KEY_tcaron", sizeof("KEY_tcaron")-1, GDK_tcaron);
	phpg_register_int_constant(gdk_ce, "KEY_zacute", sizeof("KEY_zacute")-1, GDK_zacute);
	phpg_register_int_constant(gdk_ce, "KEY_doubleacute", sizeof("KEY_doubleacute")-1, GDK_doubleacute);
	phpg_register_int_constant(gdk_ce, "KEY_zcaron", sizeof("KEY_zcaron")-1, GDK_zcaron);
	phpg_register_int_constant(gdk_ce, "KEY_zabovedot", sizeof("KEY_zabovedot")-1, GDK_zabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_Racute", sizeof("KEY_Racute")-1, GDK_Racute);
	phpg_register_int_constant(gdk_ce, "KEY_Abreve", sizeof("KEY_Abreve")-1, GDK_Abreve);
	phpg_register_int_constant(gdk_ce, "KEY_Lacute", sizeof("KEY_Lacute")-1, GDK_Lacute);
	phpg_register_int_constant(gdk_ce, "KEY_Cacute", sizeof("KEY_Cacute")-1, GDK_Cacute);
	phpg_register_int_constant(gdk_ce, "KEY_Ccaron", sizeof("KEY_Ccaron")-1, GDK_Ccaron);
	phpg_register_int_constant(gdk_ce, "KEY_Eogonek", sizeof("KEY_Eogonek")-1, GDK_Eogonek);
	phpg_register_int_constant(gdk_ce, "KEY_Ecaron", sizeof("KEY_Ecaron")-1, GDK_Ecaron);
	phpg_register_int_constant(gdk_ce, "KEY_Dcaron", sizeof("KEY_Dcaron")-1, GDK_Dcaron);
	phpg_register_int_constant(gdk_ce, "KEY_Dstroke", sizeof("KEY_Dstroke")-1, GDK_Dstroke);
	phpg_register_int_constant(gdk_ce, "KEY_Nacute", sizeof("KEY_Nacute")-1, GDK_Nacute);
	phpg_register_int_constant(gdk_ce, "KEY_Ncaron", sizeof("KEY_Ncaron")-1, GDK_Ncaron);
	phpg_register_int_constant(gdk_ce, "KEY_Odoubleacute", sizeof("KEY_Odoubleacute")-1, GDK_Odoubleacute);
	phpg_register_int_constant(gdk_ce, "KEY_Rcaron", sizeof("KEY_Rcaron")-1, GDK_Rcaron);
	phpg_register_int_constant(gdk_ce, "KEY_Uring", sizeof("KEY_Uring")-1, GDK_Uring);
	phpg_register_int_constant(gdk_ce, "KEY_Udoubleacute", sizeof("KEY_Udoubleacute")-1, GDK_Udoubleacute);
	phpg_register_int_constant(gdk_ce, "KEY_Tcedilla", sizeof("KEY_Tcedilla")-1, GDK_Tcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_racute", sizeof("KEY_racute")-1, GDK_racute);
	phpg_register_int_constant(gdk_ce, "KEY_abreve", sizeof("KEY_abreve")-1, GDK_abreve);
	phpg_register_int_constant(gdk_ce, "KEY_lacute", sizeof("KEY_lacute")-1, GDK_lacute);
	phpg_register_int_constant(gdk_ce, "KEY_cacute", sizeof("KEY_cacute")-1, GDK_cacute);
	phpg_register_int_constant(gdk_ce, "KEY_ccaron", sizeof("KEY_ccaron")-1, GDK_ccaron);
	phpg_register_int_constant(gdk_ce, "KEY_eogonek", sizeof("KEY_eogonek")-1, GDK_eogonek);
	phpg_register_int_constant(gdk_ce, "KEY_ecaron", sizeof("KEY_ecaron")-1, GDK_ecaron);
	phpg_register_int_constant(gdk_ce, "KEY_dcaron", sizeof("KEY_dcaron")-1, GDK_dcaron);
	phpg_register_int_constant(gdk_ce, "KEY_dstroke", sizeof("KEY_dstroke")-1, GDK_dstroke);
	phpg_register_int_constant(gdk_ce, "KEY_nacute", sizeof("KEY_nacute")-1, GDK_nacute);
	phpg_register_int_constant(gdk_ce, "KEY_ncaron", sizeof("KEY_ncaron")-1, GDK_ncaron);
	phpg_register_int_constant(gdk_ce, "KEY_odoubleacute", sizeof("KEY_odoubleacute")-1, GDK_odoubleacute);
	phpg_register_int_constant(gdk_ce, "KEY_udoubleacute", sizeof("KEY_udoubleacute")-1, GDK_udoubleacute);
	phpg_register_int_constant(gdk_ce, "KEY_rcaron", sizeof("KEY_rcaron")-1, GDK_rcaron);
	phpg_register_int_constant(gdk_ce, "KEY_uring", sizeof("KEY_uring")-1, GDK_uring);
	phpg_register_int_constant(gdk_ce, "KEY_tcedilla", sizeof("KEY_tcedilla")-1, GDK_tcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_abovedot", sizeof("KEY_abovedot")-1, GDK_abovedot);
	phpg_register_int_constant(gdk_ce, "KEY_Hstroke", sizeof("KEY_Hstroke")-1, GDK_Hstroke);
	phpg_register_int_constant(gdk_ce, "KEY_Hcircumflex", sizeof("KEY_Hcircumflex")-1, GDK_Hcircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Iabovedot", sizeof("KEY_Iabovedot")-1, GDK_Iabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_Gbreve", sizeof("KEY_Gbreve")-1, GDK_Gbreve);
	phpg_register_int_constant(gdk_ce, "KEY_Jcircumflex", sizeof("KEY_Jcircumflex")-1, GDK_Jcircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_hstroke", sizeof("KEY_hstroke")-1, GDK_hstroke);
	phpg_register_int_constant(gdk_ce, "KEY_hcircumflex", sizeof("KEY_hcircumflex")-1, GDK_hcircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_idotless", sizeof("KEY_idotless")-1, GDK_idotless);
	phpg_register_int_constant(gdk_ce, "KEY_gbreve", sizeof("KEY_gbreve")-1, GDK_gbreve);
	phpg_register_int_constant(gdk_ce, "KEY_jcircumflex", sizeof("KEY_jcircumflex")-1, GDK_jcircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Cabovedot", sizeof("KEY_Cabovedot")-1, GDK_Cabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_Ccircumflex", sizeof("KEY_Ccircumflex")-1, GDK_Ccircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Gabovedot", sizeof("KEY_Gabovedot")-1, GDK_Gabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_Gcircumflex", sizeof("KEY_Gcircumflex")-1, GDK_Gcircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_Ubreve", sizeof("KEY_Ubreve")-1, GDK_Ubreve);
	phpg_register_int_constant(gdk_ce, "KEY_Scircumflex", sizeof("KEY_Scircumflex")-1, GDK_Scircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_cabovedot", sizeof("KEY_cabovedot")-1, GDK_cabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_ccircumflex", sizeof("KEY_ccircumflex")-1, GDK_ccircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_gabovedot", sizeof("KEY_gabovedot")-1, GDK_gabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_gcircumflex", sizeof("KEY_gcircumflex")-1, GDK_gcircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_ubreve", sizeof("KEY_ubreve")-1, GDK_ubreve);
	phpg_register_int_constant(gdk_ce, "KEY_scircumflex", sizeof("KEY_scircumflex")-1, GDK_scircumflex);
	phpg_register_int_constant(gdk_ce, "KEY_kra", sizeof("KEY_kra")-1, GDK_kra);
	phpg_register_int_constant(gdk_ce, "KEY_kappa", sizeof("KEY_kappa")-1, GDK_kappa);
	phpg_register_int_constant(gdk_ce, "KEY_Rcedilla", sizeof("KEY_Rcedilla")-1, GDK_Rcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_Itilde", sizeof("KEY_Itilde")-1, GDK_Itilde);
	phpg_register_int_constant(gdk_ce, "KEY_Lcedilla", sizeof("KEY_Lcedilla")-1, GDK_Lcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_Emacron", sizeof("KEY_Emacron")-1, GDK_Emacron);
	phpg_register_int_constant(gdk_ce, "KEY_Gcedilla", sizeof("KEY_Gcedilla")-1, GDK_Gcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_Tslash", sizeof("KEY_Tslash")-1, GDK_Tslash);
	phpg_register_int_constant(gdk_ce, "KEY_rcedilla", sizeof("KEY_rcedilla")-1, GDK_rcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_itilde", sizeof("KEY_itilde")-1, GDK_itilde);
	phpg_register_int_constant(gdk_ce, "KEY_lcedilla", sizeof("KEY_lcedilla")-1, GDK_lcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_emacron", sizeof("KEY_emacron")-1, GDK_emacron);
	phpg_register_int_constant(gdk_ce, "KEY_gcedilla", sizeof("KEY_gcedilla")-1, GDK_gcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_tslash", sizeof("KEY_tslash")-1, GDK_tslash);
	phpg_register_int_constant(gdk_ce, "KEY_Eng", sizeof("KEY_Eng")-1, GDK_ENG);
	phpg_register_int_constant(gdk_ce, "KEY_eng", sizeof("KEY_eng")-1, GDK_eng);
	phpg_register_int_constant(gdk_ce, "KEY_Amacron", sizeof("KEY_Amacron")-1, GDK_Amacron);
	phpg_register_int_constant(gdk_ce, "KEY_Iogonek", sizeof("KEY_Iogonek")-1, GDK_Iogonek);
	phpg_register_int_constant(gdk_ce, "KEY_Eabovedot", sizeof("KEY_Eabovedot")-1, GDK_Eabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_Imacron", sizeof("KEY_Imacron")-1, GDK_Imacron);
	phpg_register_int_constant(gdk_ce, "KEY_Ncedilla", sizeof("KEY_Ncedilla")-1, GDK_Ncedilla);
	phpg_register_int_constant(gdk_ce, "KEY_Omacron", sizeof("KEY_Omacron")-1, GDK_Omacron);
	phpg_register_int_constant(gdk_ce, "KEY_Kcedilla", sizeof("KEY_Kcedilla")-1, GDK_Kcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_Uogonek", sizeof("KEY_Uogonek")-1, GDK_Uogonek);
	phpg_register_int_constant(gdk_ce, "KEY_Utilde", sizeof("KEY_Utilde")-1, GDK_Utilde);
	phpg_register_int_constant(gdk_ce, "KEY_Umacron", sizeof("KEY_Umacron")-1, GDK_Umacron);
	phpg_register_int_constant(gdk_ce, "KEY_amacron", sizeof("KEY_amacron")-1, GDK_amacron);
	phpg_register_int_constant(gdk_ce, "KEY_iogonek", sizeof("KEY_iogonek")-1, GDK_iogonek);
	phpg_register_int_constant(gdk_ce, "KEY_eabovedot", sizeof("KEY_eabovedot")-1, GDK_eabovedot);
	phpg_register_int_constant(gdk_ce, "KEY_imacron", sizeof("KEY_imacron")-1, GDK_imacron);
	phpg_register_int_constant(gdk_ce, "KEY_ncedilla", sizeof("KEY_ncedilla")-1, GDK_ncedilla);
	phpg_register_int_constant(gdk_ce, "KEY_omacron", sizeof("KEY_omacron")-1, GDK_omacron);
	phpg_register_int_constant(gdk_ce, "KEY_kcedilla", sizeof("KEY_kcedilla")-1, GDK_kcedilla);
	phpg_register_int_constant(gdk_ce, "KEY_uogonek", sizeof("KEY_uogonek")-1, GDK_uogonek);
	phpg_register_int_constant(gdk_ce, "KEY_utilde", sizeof("KEY_utilde")-1, GDK_utilde);
	phpg_register_int_constant(gdk_ce, "KEY_umacron", sizeof("KEY_umacron")-1, GDK_umacron);
	phpg_register_int_constant(gdk_ce, "KEY_OE", sizeof("KEY_OE")-1, GDK_OE);
	phpg_register_int_constant(gdk_ce, "KEY_oe", sizeof("KEY_oe")-1, GDK_oe);
	phpg_register_int_constant(gdk_ce, "KEY_Ydiaeresis", sizeof("KEY_Ydiaeresis")-1, GDK_Ydiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_overline", sizeof("KEY_overline")-1, GDK_overline);
	phpg_register_int_constant(gdk_ce, "KEY_kana_fullstop", sizeof("KEY_kana_fullstop")-1, GDK_kana_fullstop);
	phpg_register_int_constant(gdk_ce, "KEY_kana_openingbracket", sizeof("KEY_kana_openingbracket")-1, GDK_kana_openingbracket);
	phpg_register_int_constant(gdk_ce, "KEY_kana_closingbracket", sizeof("KEY_kana_closingbracket")-1, GDK_kana_closingbracket);
	phpg_register_int_constant(gdk_ce, "KEY_kana_comma", sizeof("KEY_kana_comma")-1, GDK_kana_comma);
	phpg_register_int_constant(gdk_ce, "KEY_kana_conjunctive", sizeof("KEY_kana_conjunctive")-1, GDK_kana_conjunctive);
	phpg_register_int_constant(gdk_ce, "KEY_kana_middledot", sizeof("KEY_kana_middledot")-1, GDK_kana_middledot);
	phpg_register_int_constant(gdk_ce, "KEY_kana_WO", sizeof("KEY_kana_WO")-1, GDK_kana_WO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_a", sizeof("KEY_kana_a")-1, GDK_kana_a);
	phpg_register_int_constant(gdk_ce, "KEY_kana_i", sizeof("KEY_kana_i")-1, GDK_kana_i);
	phpg_register_int_constant(gdk_ce, "KEY_kana_u", sizeof("KEY_kana_u")-1, GDK_kana_u);
	phpg_register_int_constant(gdk_ce, "KEY_kana_e", sizeof("KEY_kana_e")-1, GDK_kana_e);
	phpg_register_int_constant(gdk_ce, "KEY_kana_o", sizeof("KEY_kana_o")-1, GDK_kana_o);
	phpg_register_int_constant(gdk_ce, "KEY_kana_ya", sizeof("KEY_kana_ya")-1, GDK_kana_ya);
	phpg_register_int_constant(gdk_ce, "KEY_kana_yu", sizeof("KEY_kana_yu")-1, GDK_kana_yu);
	phpg_register_int_constant(gdk_ce, "KEY_kana_yo", sizeof("KEY_kana_yo")-1, GDK_kana_yo);
	phpg_register_int_constant(gdk_ce, "KEY_kana_tsu", sizeof("KEY_kana_tsu")-1, GDK_kana_tsu);
	phpg_register_int_constant(gdk_ce, "KEY_kana_tu", sizeof("KEY_kana_tu")-1, GDK_kana_tu);
	phpg_register_int_constant(gdk_ce, "KEY_prolongedsound", sizeof("KEY_prolongedsound")-1, GDK_prolongedsound);
	phpg_register_int_constant(gdk_ce, "KEY_kana_A", sizeof("KEY_kana_A")-1, GDK_kana_A);
	phpg_register_int_constant(gdk_ce, "KEY_kana_I", sizeof("KEY_kana_I")-1, GDK_kana_I);
	phpg_register_int_constant(gdk_ce, "KEY_kana_U", sizeof("KEY_kana_U")-1, GDK_kana_U);
	phpg_register_int_constant(gdk_ce, "KEY_kana_E", sizeof("KEY_kana_E")-1, GDK_kana_E);
	phpg_register_int_constant(gdk_ce, "KEY_kana_O", sizeof("KEY_kana_O")-1, GDK_kana_O);
	phpg_register_int_constant(gdk_ce, "KEY_kana_KA", sizeof("KEY_kana_KA")-1, GDK_kana_KA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_KI", sizeof("KEY_kana_KI")-1, GDK_kana_KI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_KU", sizeof("KEY_kana_KU")-1, GDK_kana_KU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_KE", sizeof("KEY_kana_KE")-1, GDK_kana_KE);
	phpg_register_int_constant(gdk_ce, "KEY_kana_KO", sizeof("KEY_kana_KO")-1, GDK_kana_KO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_SA", sizeof("KEY_kana_SA")-1, GDK_kana_SA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_SHI", sizeof("KEY_kana_SHI")-1, GDK_kana_SHI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_SU", sizeof("KEY_kana_SU")-1, GDK_kana_SU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_SE", sizeof("KEY_kana_SE")-1, GDK_kana_SE);
	phpg_register_int_constant(gdk_ce, "KEY_kana_SO", sizeof("KEY_kana_SO")-1, GDK_kana_SO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_TA", sizeof("KEY_kana_TA")-1, GDK_kana_TA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_CHI", sizeof("KEY_kana_CHI")-1, GDK_kana_CHI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_TI", sizeof("KEY_kana_TI")-1, GDK_kana_TI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_TSU", sizeof("KEY_kana_TSU")-1, GDK_kana_TSU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_TU", sizeof("KEY_kana_TU")-1, GDK_kana_TU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_TE", sizeof("KEY_kana_TE")-1, GDK_kana_TE);
	phpg_register_int_constant(gdk_ce, "KEY_kana_TO", sizeof("KEY_kana_TO")-1, GDK_kana_TO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_NA", sizeof("KEY_kana_NA")-1, GDK_kana_NA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_NI", sizeof("KEY_kana_NI")-1, GDK_kana_NI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_NU", sizeof("KEY_kana_NU")-1, GDK_kana_NU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_NE", sizeof("KEY_kana_NE")-1, GDK_kana_NE);
	phpg_register_int_constant(gdk_ce, "KEY_kana_NO", sizeof("KEY_kana_NO")-1, GDK_kana_NO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_HA", sizeof("KEY_kana_HA")-1, GDK_kana_HA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_HI", sizeof("KEY_kana_HI")-1, GDK_kana_HI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_FU", sizeof("KEY_kana_FU")-1, GDK_kana_FU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_HU", sizeof("KEY_kana_HU")-1, GDK_kana_HU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_HE", sizeof("KEY_kana_HE")-1, GDK_kana_HE);
	phpg_register_int_constant(gdk_ce, "KEY_kana_HO", sizeof("KEY_kana_HO")-1, GDK_kana_HO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_MA", sizeof("KEY_kana_MA")-1, GDK_kana_MA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_MI", sizeof("KEY_kana_MI")-1, GDK_kana_MI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_MU", sizeof("KEY_kana_MU")-1, GDK_kana_MU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_ME", sizeof("KEY_kana_ME")-1, GDK_kana_ME);
	phpg_register_int_constant(gdk_ce, "KEY_kana_MO", sizeof("KEY_kana_MO")-1, GDK_kana_MO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_YA", sizeof("KEY_kana_YA")-1, GDK_kana_YA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_YU", sizeof("KEY_kana_YU")-1, GDK_kana_YU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_YO", sizeof("KEY_kana_YO")-1, GDK_kana_YO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_RA", sizeof("KEY_kana_RA")-1, GDK_kana_RA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_RI", sizeof("KEY_kana_RI")-1, GDK_kana_RI);
	phpg_register_int_constant(gdk_ce, "KEY_kana_RU", sizeof("KEY_kana_RU")-1, GDK_kana_RU);
	phpg_register_int_constant(gdk_ce, "KEY_kana_RE", sizeof("KEY_kana_RE")-1, GDK_kana_RE);
	phpg_register_int_constant(gdk_ce, "KEY_kana_RO", sizeof("KEY_kana_RO")-1, GDK_kana_RO);
	phpg_register_int_constant(gdk_ce, "KEY_kana_WA", sizeof("KEY_kana_WA")-1, GDK_kana_WA);
	phpg_register_int_constant(gdk_ce, "KEY_kana_N", sizeof("KEY_kana_N")-1, GDK_kana_N);
	phpg_register_int_constant(gdk_ce, "KEY_voicedsound", sizeof("KEY_voicedsound")-1, GDK_voicedsound);
	phpg_register_int_constant(gdk_ce, "KEY_semivoicedsound", sizeof("KEY_semivoicedsound")-1, GDK_semivoicedsound);
	phpg_register_int_constant(gdk_ce, "KEY_kana_switch", sizeof("KEY_kana_switch")-1, GDK_kana_switch);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_comma", sizeof("KEY_Arabic_comma")-1, GDK_Arabic_comma);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_semicolon", sizeof("KEY_Arabic_semicolon")-1, GDK_Arabic_semicolon);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_question_mark", sizeof("KEY_Arabic_question_mark")-1, GDK_Arabic_question_mark);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_hamza", sizeof("KEY_Arabic_hamza")-1, GDK_Arabic_hamza);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_maddaonalef", sizeof("KEY_Arabic_maddaonalef")-1, GDK_Arabic_maddaonalef);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_hamzaonalef", sizeof("KEY_Arabic_hamzaonalef")-1, GDK_Arabic_hamzaonalef);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_hamzaonwaw", sizeof("KEY_Arabic_hamzaonwaw")-1, GDK_Arabic_hamzaonwaw);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_hamzaunderalef", sizeof("KEY_Arabic_hamzaunderalef")-1, GDK_Arabic_hamzaunderalef);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_hamzaonyeh", sizeof("KEY_Arabic_hamzaonyeh")-1, GDK_Arabic_hamzaonyeh);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_alef", sizeof("KEY_Arabic_alef")-1, GDK_Arabic_alef);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_beh", sizeof("KEY_Arabic_beh")-1, GDK_Arabic_beh);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_tehmarbuta", sizeof("KEY_Arabic_tehmarbuta")-1, GDK_Arabic_tehmarbuta);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_teh", sizeof("KEY_Arabic_teh")-1, GDK_Arabic_teh);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_theh", sizeof("KEY_Arabic_theh")-1, GDK_Arabic_theh);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_jeem", sizeof("KEY_Arabic_jeem")-1, GDK_Arabic_jeem);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_hah", sizeof("KEY_Arabic_hah")-1, GDK_Arabic_hah);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_khah", sizeof("KEY_Arabic_khah")-1, GDK_Arabic_khah);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_dal", sizeof("KEY_Arabic_dal")-1, GDK_Arabic_dal);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_thal", sizeof("KEY_Arabic_thal")-1, GDK_Arabic_thal);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_ra", sizeof("KEY_Arabic_ra")-1, GDK_Arabic_ra);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_zain", sizeof("KEY_Arabic_zain")-1, GDK_Arabic_zain);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_seen", sizeof("KEY_Arabic_seen")-1, GDK_Arabic_seen);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_sheen", sizeof("KEY_Arabic_sheen")-1, GDK_Arabic_sheen);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_sad", sizeof("KEY_Arabic_sad")-1, GDK_Arabic_sad);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_dad", sizeof("KEY_Arabic_dad")-1, GDK_Arabic_dad);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_tah", sizeof("KEY_Arabic_tah")-1, GDK_Arabic_tah);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_zah", sizeof("KEY_Arabic_zah")-1, GDK_Arabic_zah);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_ain", sizeof("KEY_Arabic_ain")-1, GDK_Arabic_ain);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_ghain", sizeof("KEY_Arabic_ghain")-1, GDK_Arabic_ghain);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_tatweel", sizeof("KEY_Arabic_tatweel")-1, GDK_Arabic_tatweel);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_feh", sizeof("KEY_Arabic_feh")-1, GDK_Arabic_feh);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_qaf", sizeof("KEY_Arabic_qaf")-1, GDK_Arabic_qaf);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_kaf", sizeof("KEY_Arabic_kaf")-1, GDK_Arabic_kaf);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_lam", sizeof("KEY_Arabic_lam")-1, GDK_Arabic_lam);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_meem", sizeof("KEY_Arabic_meem")-1, GDK_Arabic_meem);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_noon", sizeof("KEY_Arabic_noon")-1, GDK_Arabic_noon);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_ha", sizeof("KEY_Arabic_ha")-1, GDK_Arabic_ha);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_heh", sizeof("KEY_Arabic_heh")-1, GDK_Arabic_heh);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_waw", sizeof("KEY_Arabic_waw")-1, GDK_Arabic_waw);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_alefmaksura", sizeof("KEY_Arabic_alefmaksura")-1, GDK_Arabic_alefmaksura);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_yeh", sizeof("KEY_Arabic_yeh")-1, GDK_Arabic_yeh);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_fathatan", sizeof("KEY_Arabic_fathatan")-1, GDK_Arabic_fathatan);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_dammatan", sizeof("KEY_Arabic_dammatan")-1, GDK_Arabic_dammatan);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_kasratan", sizeof("KEY_Arabic_kasratan")-1, GDK_Arabic_kasratan);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_fatha", sizeof("KEY_Arabic_fatha")-1, GDK_Arabic_fatha);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_damma", sizeof("KEY_Arabic_damma")-1, GDK_Arabic_damma);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_kasra", sizeof("KEY_Arabic_kasra")-1, GDK_Arabic_kasra);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_shadda", sizeof("KEY_Arabic_shadda")-1, GDK_Arabic_shadda);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_sukun", sizeof("KEY_Arabic_sukun")-1, GDK_Arabic_sukun);
	phpg_register_int_constant(gdk_ce, "KEY_Arabic_switch", sizeof("KEY_Arabic_switch")-1, GDK_Arabic_switch);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_dje", sizeof("KEY_Serbian_dje")-1, GDK_Serbian_dje);
	phpg_register_int_constant(gdk_ce, "KEY_Macedonia_gje", sizeof("KEY_Macedonia_gje")-1, GDK_Macedonia_gje);
	phpg_register_int_constant(gdk_ce, "KEY_Ukrainian_ghe_with_upturn", sizeof("KEY_Ukrainian_ghe_with_upturn")-1, GDK_Ukrainian_ghe_with_upturn);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_io", sizeof("KEY_Cyrillic_io")-1, GDK_Cyrillic_io);
	phpg_register_int_constant(gdk_ce, "KEY_Ukrainian_ie", sizeof("KEY_Ukrainian_ie")-1, GDK_Ukrainian_ie);
	phpg_register_int_constant(gdk_ce, "KEY_Ukranian_je", sizeof("KEY_Ukranian_je")-1, GDK_Ukranian_je);
	phpg_register_int_constant(gdk_ce, "KEY_Macedonia_dse", sizeof("KEY_Macedonia_dse")-1, GDK_Macedonia_dse);
	phpg_register_int_constant(gdk_ce, "KEY_Ukrainian_i", sizeof("KEY_Ukrainian_i")-1, GDK_Ukrainian_i);
	phpg_register_int_constant(gdk_ce, "KEY_Ukranian_i", sizeof("KEY_Ukranian_i")-1, GDK_Ukranian_i);
	phpg_register_int_constant(gdk_ce, "KEY_Ukrainian_yi", sizeof("KEY_Ukrainian_yi")-1, GDK_Ukrainian_yi);
	phpg_register_int_constant(gdk_ce, "KEY_Ukranian_yi", sizeof("KEY_Ukranian_yi")-1, GDK_Ukranian_yi);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_je", sizeof("KEY_Cyrillic_je")-1, GDK_Cyrillic_je);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_je", sizeof("KEY_Serbian_je")-1, GDK_Serbian_je);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_lje", sizeof("KEY_Cyrillic_lje")-1, GDK_Cyrillic_lje);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_lje", sizeof("KEY_Serbian_lje")-1, GDK_Serbian_lje);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_nje", sizeof("KEY_Cyrillic_nje")-1, GDK_Cyrillic_nje);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_nje", sizeof("KEY_Serbian_nje")-1, GDK_Serbian_nje);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_tshe", sizeof("KEY_Serbian_tshe")-1, GDK_Serbian_tshe);
	phpg_register_int_constant(gdk_ce, "KEY_Macedonia_kje", sizeof("KEY_Macedonia_kje")-1, GDK_Macedonia_kje);
	phpg_register_int_constant(gdk_ce, "KEY_Byelorussian_shortu", sizeof("KEY_Byelorussian_shortu")-1, GDK_Byelorussian_shortu);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_dzhe", sizeof("KEY_Cyrillic_dzhe")-1, GDK_Cyrillic_dzhe);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_dze", sizeof("KEY_Serbian_dze")-1, GDK_Serbian_dze);
	phpg_register_int_constant(gdk_ce, "KEY_numerosign", sizeof("KEY_numerosign")-1, GDK_numerosign);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_DJE", sizeof("KEY_Serbian_DJE")-1, GDK_Serbian_DJE);
	phpg_register_int_constant(gdk_ce, "KEY_Macedonia_GJE", sizeof("KEY_Macedonia_GJE")-1, GDK_Macedonia_GJE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_IO", sizeof("KEY_Cyrillic_IO")-1, GDK_Cyrillic_IO);
	phpg_register_int_constant(gdk_ce, "KEY_Ukrainian_IE", sizeof("KEY_Ukrainian_IE")-1, GDK_Ukrainian_IE);
	phpg_register_int_constant(gdk_ce, "KEY_Ukranian_JE", sizeof("KEY_Ukranian_JE")-1, GDK_Ukranian_JE);
	phpg_register_int_constant(gdk_ce, "KEY_Macedonia_DSE", sizeof("KEY_Macedonia_DSE")-1, GDK_Macedonia_DSE);
	phpg_register_int_constant(gdk_ce, "KEY_Ukrainian_I", sizeof("KEY_Ukrainian_I")-1, GDK_Ukrainian_I);
	phpg_register_int_constant(gdk_ce, "KEY_Ukranian_I", sizeof("KEY_Ukranian_I")-1, GDK_Ukranian_I);
	phpg_register_int_constant(gdk_ce, "KEY_Ukrainian_YI", sizeof("KEY_Ukrainian_YI")-1, GDK_Ukrainian_YI);
	phpg_register_int_constant(gdk_ce, "KEY_Ukranian_YI", sizeof("KEY_Ukranian_YI")-1, GDK_Ukranian_YI);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_JE", sizeof("KEY_Cyrillic_JE")-1, GDK_Cyrillic_JE);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_JE", sizeof("KEY_Serbian_JE")-1, GDK_Serbian_JE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_LJE", sizeof("KEY_Cyrillic_LJE")-1, GDK_Cyrillic_LJE);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_LJE", sizeof("KEY_Serbian_LJE")-1, GDK_Serbian_LJE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_NJE", sizeof("KEY_Cyrillic_NJE")-1, GDK_Cyrillic_NJE);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_NJE", sizeof("KEY_Serbian_NJE")-1, GDK_Serbian_NJE);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_TSHE", sizeof("KEY_Serbian_TSHE")-1, GDK_Serbian_TSHE);
	phpg_register_int_constant(gdk_ce, "KEY_Macedonia_KJE", sizeof("KEY_Macedonia_KJE")-1, GDK_Macedonia_KJE);
	phpg_register_int_constant(gdk_ce, "KEY_Byelorussian_SHORTU", sizeof("KEY_Byelorussian_SHORTU")-1, GDK_Byelorussian_SHORTU);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_DZHE", sizeof("KEY_Cyrillic_DZHE")-1, GDK_Cyrillic_DZHE);
	phpg_register_int_constant(gdk_ce, "KEY_Serbian_DZE", sizeof("KEY_Serbian_DZE")-1, GDK_Serbian_DZE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_yu", sizeof("KEY_Cyrillic_yu")-1, GDK_Cyrillic_yu);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_a", sizeof("KEY_Cyrillic_a")-1, GDK_Cyrillic_a);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_be", sizeof("KEY_Cyrillic_be")-1, GDK_Cyrillic_be);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_tse", sizeof("KEY_Cyrillic_tse")-1, GDK_Cyrillic_tse);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_de", sizeof("KEY_Cyrillic_de")-1, GDK_Cyrillic_de);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ie", sizeof("KEY_Cyrillic_ie")-1, GDK_Cyrillic_ie);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ef", sizeof("KEY_Cyrillic_ef")-1, GDK_Cyrillic_ef);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ghe", sizeof("KEY_Cyrillic_ghe")-1, GDK_Cyrillic_ghe);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ha", sizeof("KEY_Cyrillic_ha")-1, GDK_Cyrillic_ha);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_i", sizeof("KEY_Cyrillic_i")-1, GDK_Cyrillic_i);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_shorti", sizeof("KEY_Cyrillic_shorti")-1, GDK_Cyrillic_shorti);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ka", sizeof("KEY_Cyrillic_ka")-1, GDK_Cyrillic_ka);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_el", sizeof("KEY_Cyrillic_el")-1, GDK_Cyrillic_el);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_em", sizeof("KEY_Cyrillic_em")-1, GDK_Cyrillic_em);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_en", sizeof("KEY_Cyrillic_en")-1, GDK_Cyrillic_en);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_o", sizeof("KEY_Cyrillic_o")-1, GDK_Cyrillic_o);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_pe", sizeof("KEY_Cyrillic_pe")-1, GDK_Cyrillic_pe);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ya", sizeof("KEY_Cyrillic_ya")-1, GDK_Cyrillic_ya);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_er", sizeof("KEY_Cyrillic_er")-1, GDK_Cyrillic_er);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_es", sizeof("KEY_Cyrillic_es")-1, GDK_Cyrillic_es);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_te", sizeof("KEY_Cyrillic_te")-1, GDK_Cyrillic_te);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_u", sizeof("KEY_Cyrillic_u")-1, GDK_Cyrillic_u);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_zhe", sizeof("KEY_Cyrillic_zhe")-1, GDK_Cyrillic_zhe);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ve", sizeof("KEY_Cyrillic_ve")-1, GDK_Cyrillic_ve);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_softsign", sizeof("KEY_Cyrillic_softsign")-1, GDK_Cyrillic_softsign);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_yeru", sizeof("KEY_Cyrillic_yeru")-1, GDK_Cyrillic_yeru);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ze", sizeof("KEY_Cyrillic_ze")-1, GDK_Cyrillic_ze);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_sha", sizeof("KEY_Cyrillic_sha")-1, GDK_Cyrillic_sha);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_e", sizeof("KEY_Cyrillic_e")-1, GDK_Cyrillic_e);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_shcha", sizeof("KEY_Cyrillic_shcha")-1, GDK_Cyrillic_shcha);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_che", sizeof("KEY_Cyrillic_che")-1, GDK_Cyrillic_che);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_hardsign", sizeof("KEY_Cyrillic_hardsign")-1, GDK_Cyrillic_hardsign);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_YU", sizeof("KEY_Cyrillic_YU")-1, GDK_Cyrillic_YU);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_A", sizeof("KEY_Cyrillic_A")-1, GDK_Cyrillic_A);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_BE", sizeof("KEY_Cyrillic_BE")-1, GDK_Cyrillic_BE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_TSE", sizeof("KEY_Cyrillic_TSE")-1, GDK_Cyrillic_TSE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_DE", sizeof("KEY_Cyrillic_DE")-1, GDK_Cyrillic_DE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_IE", sizeof("KEY_Cyrillic_IE")-1, GDK_Cyrillic_IE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_EF", sizeof("KEY_Cyrillic_EF")-1, GDK_Cyrillic_EF);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_GHE", sizeof("KEY_Cyrillic_GHE")-1, GDK_Cyrillic_GHE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_HA", sizeof("KEY_Cyrillic_HA")-1, GDK_Cyrillic_HA);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_I", sizeof("KEY_Cyrillic_I")-1, GDK_Cyrillic_I);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_SHORTI", sizeof("KEY_Cyrillic_SHORTI")-1, GDK_Cyrillic_SHORTI);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_KA", sizeof("KEY_Cyrillic_KA")-1, GDK_Cyrillic_KA);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_EL", sizeof("KEY_Cyrillic_EL")-1, GDK_Cyrillic_EL);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_EM", sizeof("KEY_Cyrillic_EM")-1, GDK_Cyrillic_EM);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_EN", sizeof("KEY_Cyrillic_EN")-1, GDK_Cyrillic_EN);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_O", sizeof("KEY_Cyrillic_O")-1, GDK_Cyrillic_O);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_PE", sizeof("KEY_Cyrillic_PE")-1, GDK_Cyrillic_PE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_YA", sizeof("KEY_Cyrillic_YA")-1, GDK_Cyrillic_YA);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ER", sizeof("KEY_Cyrillic_ER")-1, GDK_Cyrillic_ER);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ES", sizeof("KEY_Cyrillic_ES")-1, GDK_Cyrillic_ES);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_TE", sizeof("KEY_Cyrillic_TE")-1, GDK_Cyrillic_TE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_U", sizeof("KEY_Cyrillic_U")-1, GDK_Cyrillic_U);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ZHE", sizeof("KEY_Cyrillic_ZHE")-1, GDK_Cyrillic_ZHE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_VE", sizeof("KEY_Cyrillic_VE")-1, GDK_Cyrillic_VE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_SOFTSIGN", sizeof("KEY_Cyrillic_SOFTSIGN")-1, GDK_Cyrillic_SOFTSIGN);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_YERU", sizeof("KEY_Cyrillic_YERU")-1, GDK_Cyrillic_YERU);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_ZE", sizeof("KEY_Cyrillic_ZE")-1, GDK_Cyrillic_ZE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_SHA", sizeof("KEY_Cyrillic_SHA")-1, GDK_Cyrillic_SHA);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_E", sizeof("KEY_Cyrillic_E")-1, GDK_Cyrillic_E);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_SHCHA", sizeof("KEY_Cyrillic_SHCHA")-1, GDK_Cyrillic_SHCHA);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_CHE", sizeof("KEY_Cyrillic_CHE")-1, GDK_Cyrillic_CHE);
	phpg_register_int_constant(gdk_ce, "KEY_Cyrillic_HARDSIGN", sizeof("KEY_Cyrillic_HARDSIGN")-1, GDK_Cyrillic_HARDSIGN);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_ALPHAaccent", sizeof("KEY_Greek_ALPHAaccent")-1, GDK_Greek_ALPHAaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_EPSILONaccent", sizeof("KEY_Greek_EPSILONaccent")-1, GDK_Greek_EPSILONaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_ETAaccent", sizeof("KEY_Greek_ETAaccent")-1, GDK_Greek_ETAaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_IOTAaccent", sizeof("KEY_Greek_IOTAaccent")-1, GDK_Greek_IOTAaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_IOTAdieresis", sizeof("KEY_Greek_IOTAdieresis")-1, GDK_Greek_IOTAdieresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_IOTAdiaeresis", sizeof("KEY_Greek_IOTAdiaeresis")-1, GDK_Greek_IOTAdiaeresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_OMICRONaccent", sizeof("KEY_Greek_OMICRONaccent")-1, GDK_Greek_OMICRONaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_UPSILONaccent", sizeof("KEY_Greek_UPSILONaccent")-1, GDK_Greek_UPSILONaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_UPSILONdieresis", sizeof("KEY_Greek_UPSILONdieresis")-1, GDK_Greek_UPSILONdieresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_OMEGAaccent", sizeof("KEY_Greek_OMEGAaccent")-1, GDK_Greek_OMEGAaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_accentdieresis", sizeof("KEY_Greek_accentdieresis")-1, GDK_Greek_accentdieresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_horizbar", sizeof("KEY_Greek_horizbar")-1, GDK_Greek_horizbar);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_alphaaccent", sizeof("KEY_Greek_alphaaccent")-1, GDK_Greek_alphaaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_epsilonaccent", sizeof("KEY_Greek_epsilonaccent")-1, GDK_Greek_epsilonaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_etaaccent", sizeof("KEY_Greek_etaaccent")-1, GDK_Greek_etaaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_iotaaccent", sizeof("KEY_Greek_iotaaccent")-1, GDK_Greek_iotaaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_iotadieresis", sizeof("KEY_Greek_iotadieresis")-1, GDK_Greek_iotadieresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_iotaaccentdieresis", sizeof("KEY_Greek_iotaaccentdieresis")-1, GDK_Greek_iotaaccentdieresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_omicronaccent", sizeof("KEY_Greek_omicronaccent")-1, GDK_Greek_omicronaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_upsilonaccent", sizeof("KEY_Greek_upsilonaccent")-1, GDK_Greek_upsilonaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_upsilondieresis", sizeof("KEY_Greek_upsilondieresis")-1, GDK_Greek_upsilondieresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_upsilonaccentdieresis", sizeof("KEY_Greek_upsilonaccentdieresis")-1, GDK_Greek_upsilonaccentdieresis);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_omegaaccent", sizeof("KEY_Greek_omegaaccent")-1, GDK_Greek_omegaaccent);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_ALPHA", sizeof("KEY_Greek_ALPHA")-1, GDK_Greek_ALPHA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_BETA", sizeof("KEY_Greek_BETA")-1, GDK_Greek_BETA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_GAMMA", sizeof("KEY_Greek_GAMMA")-1, GDK_Greek_GAMMA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_DELTA", sizeof("KEY_Greek_DELTA")-1, GDK_Greek_DELTA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_EPSILON", sizeof("KEY_Greek_EPSILON")-1, GDK_Greek_EPSILON);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_ZETA", sizeof("KEY_Greek_ZETA")-1, GDK_Greek_ZETA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_ETA", sizeof("KEY_Greek_ETA")-1, GDK_Greek_ETA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_THETA", sizeof("KEY_Greek_THETA")-1, GDK_Greek_THETA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_IOTA", sizeof("KEY_Greek_IOTA")-1, GDK_Greek_IOTA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_KAPPA", sizeof("KEY_Greek_KAPPA")-1, GDK_Greek_KAPPA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_LAMDA", sizeof("KEY_Greek_LAMDA")-1, GDK_Greek_LAMDA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_LAMBDA", sizeof("KEY_Greek_LAMBDA")-1, GDK_Greek_LAMBDA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_MU", sizeof("KEY_Greek_MU")-1, GDK_Greek_MU);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_NU", sizeof("KEY_Greek_NU")-1, GDK_Greek_NU);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_XI", sizeof("KEY_Greek_XI")-1, GDK_Greek_XI);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_OMICRON", sizeof("KEY_Greek_OMICRON")-1, GDK_Greek_OMICRON);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_PI", sizeof("KEY_Greek_PI")-1, GDK_Greek_PI);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_RHO", sizeof("KEY_Greek_RHO")-1, GDK_Greek_RHO);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_SIGMA", sizeof("KEY_Greek_SIGMA")-1, GDK_Greek_SIGMA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_TAU", sizeof("KEY_Greek_TAU")-1, GDK_Greek_TAU);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_UPSILON", sizeof("KEY_Greek_UPSILON")-1, GDK_Greek_UPSILON);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_PHI", sizeof("KEY_Greek_PHI")-1, GDK_Greek_PHI);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_CHI", sizeof("KEY_Greek_CHI")-1, GDK_Greek_CHI);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_PSI", sizeof("KEY_Greek_PSI")-1, GDK_Greek_PSI);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_OMEGA", sizeof("KEY_Greek_OMEGA")-1, GDK_Greek_OMEGA);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_alpha", sizeof("KEY_Greek_alpha")-1, GDK_Greek_alpha);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_beta", sizeof("KEY_Greek_beta")-1, GDK_Greek_beta);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_gamma", sizeof("KEY_Greek_gamma")-1, GDK_Greek_gamma);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_delta", sizeof("KEY_Greek_delta")-1, GDK_Greek_delta);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_epsilon", sizeof("KEY_Greek_epsilon")-1, GDK_Greek_epsilon);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_zeta", sizeof("KEY_Greek_zeta")-1, GDK_Greek_zeta);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_eta", sizeof("KEY_Greek_eta")-1, GDK_Greek_eta);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_theta", sizeof("KEY_Greek_theta")-1, GDK_Greek_theta);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_iota", sizeof("KEY_Greek_iota")-1, GDK_Greek_iota);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_kappa", sizeof("KEY_Greek_kappa")-1, GDK_Greek_kappa);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_lamda", sizeof("KEY_Greek_lamda")-1, GDK_Greek_lamda);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_lambda", sizeof("KEY_Greek_lambda")-1, GDK_Greek_lambda);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_mu", sizeof("KEY_Greek_mu")-1, GDK_Greek_mu);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_nu", sizeof("KEY_Greek_nu")-1, GDK_Greek_nu);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_xi", sizeof("KEY_Greek_xi")-1, GDK_Greek_xi);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_omicron", sizeof("KEY_Greek_omicron")-1, GDK_Greek_omicron);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_pi", sizeof("KEY_Greek_pi")-1, GDK_Greek_pi);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_rho", sizeof("KEY_Greek_rho")-1, GDK_Greek_rho);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_sigma", sizeof("KEY_Greek_sigma")-1, GDK_Greek_sigma);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_finalsmallsigma", sizeof("KEY_Greek_finalsmallsigma")-1, GDK_Greek_finalsmallsigma);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_tau", sizeof("KEY_Greek_tau")-1, GDK_Greek_tau);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_upsilon", sizeof("KEY_Greek_upsilon")-1, GDK_Greek_upsilon);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_phi", sizeof("KEY_Greek_phi")-1, GDK_Greek_phi);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_chi", sizeof("KEY_Greek_chi")-1, GDK_Greek_chi);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_psi", sizeof("KEY_Greek_psi")-1, GDK_Greek_psi);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_omega", sizeof("KEY_Greek_omega")-1, GDK_Greek_omega);
	phpg_register_int_constant(gdk_ce, "KEY_Greek_switch", sizeof("KEY_Greek_switch")-1, GDK_Greek_switch);
	phpg_register_int_constant(gdk_ce, "KEY_leftradical", sizeof("KEY_leftradical")-1, GDK_leftradical);
	phpg_register_int_constant(gdk_ce, "KEY_topleftradical", sizeof("KEY_topleftradical")-1, GDK_topleftradical);
	phpg_register_int_constant(gdk_ce, "KEY_horizconnector", sizeof("KEY_horizconnector")-1, GDK_horizconnector);
	phpg_register_int_constant(gdk_ce, "KEY_topintegral", sizeof("KEY_topintegral")-1, GDK_topintegral);
	phpg_register_int_constant(gdk_ce, "KEY_botintegral", sizeof("KEY_botintegral")-1, GDK_botintegral);
	phpg_register_int_constant(gdk_ce, "KEY_vertconnector", sizeof("KEY_vertconnector")-1, GDK_vertconnector);
	phpg_register_int_constant(gdk_ce, "KEY_topleftsqbracket", sizeof("KEY_topleftsqbracket")-1, GDK_topleftsqbracket);
	phpg_register_int_constant(gdk_ce, "KEY_botleftsqbracket", sizeof("KEY_botleftsqbracket")-1, GDK_botleftsqbracket);
	phpg_register_int_constant(gdk_ce, "KEY_toprightsqbracket", sizeof("KEY_toprightsqbracket")-1, GDK_toprightsqbracket);
	phpg_register_int_constant(gdk_ce, "KEY_botrightsqbracket", sizeof("KEY_botrightsqbracket")-1, GDK_botrightsqbracket);
	phpg_register_int_constant(gdk_ce, "KEY_topleftparens", sizeof("KEY_topleftparens")-1, GDK_topleftparens);
	phpg_register_int_constant(gdk_ce, "KEY_botleftparens", sizeof("KEY_botleftparens")-1, GDK_botleftparens);
	phpg_register_int_constant(gdk_ce, "KEY_toprightparens", sizeof("KEY_toprightparens")-1, GDK_toprightparens);
	phpg_register_int_constant(gdk_ce, "KEY_botrightparens", sizeof("KEY_botrightparens")-1, GDK_botrightparens);
	phpg_register_int_constant(gdk_ce, "KEY_leftmiddlecurlybrace", sizeof("KEY_leftmiddlecurlybrace")-1, GDK_leftmiddlecurlybrace);
	phpg_register_int_constant(gdk_ce, "KEY_rightmiddlecurlybrace", sizeof("KEY_rightmiddlecurlybrace")-1, GDK_rightmiddlecurlybrace);
	phpg_register_int_constant(gdk_ce, "KEY_topleftsummation", sizeof("KEY_topleftsummation")-1, GDK_topleftsummation);
	phpg_register_int_constant(gdk_ce, "KEY_botleftsummation", sizeof("KEY_botleftsummation")-1, GDK_botleftsummation);
	phpg_register_int_constant(gdk_ce, "KEY_topvertsummationconnector", sizeof("KEY_topvertsummationconnector")-1, GDK_topvertsummationconnector);
	phpg_register_int_constant(gdk_ce, "KEY_botvertsummationconnector", sizeof("KEY_botvertsummationconnector")-1, GDK_botvertsummationconnector);
	phpg_register_int_constant(gdk_ce, "KEY_toprightsummation", sizeof("KEY_toprightsummation")-1, GDK_toprightsummation);
	phpg_register_int_constant(gdk_ce, "KEY_botrightsummation", sizeof("KEY_botrightsummation")-1, GDK_botrightsummation);
	phpg_register_int_constant(gdk_ce, "KEY_rightmiddlesummation", sizeof("KEY_rightmiddlesummation")-1, GDK_rightmiddlesummation);
	phpg_register_int_constant(gdk_ce, "KEY_lessthanequal", sizeof("KEY_lessthanequal")-1, GDK_lessthanequal);
	phpg_register_int_constant(gdk_ce, "KEY_notequal", sizeof("KEY_notequal")-1, GDK_notequal);
	phpg_register_int_constant(gdk_ce, "KEY_greaterthanequal", sizeof("KEY_greaterthanequal")-1, GDK_greaterthanequal);
	phpg_register_int_constant(gdk_ce, "KEY_integral", sizeof("KEY_integral")-1, GDK_integral);
	phpg_register_int_constant(gdk_ce, "KEY_therefore", sizeof("KEY_therefore")-1, GDK_therefore);
	phpg_register_int_constant(gdk_ce, "KEY_variation", sizeof("KEY_variation")-1, GDK_variation);
	phpg_register_int_constant(gdk_ce, "KEY_infinity", sizeof("KEY_infinity")-1, GDK_infinity);
	phpg_register_int_constant(gdk_ce, "KEY_nabla", sizeof("KEY_nabla")-1, GDK_nabla);
	phpg_register_int_constant(gdk_ce, "KEY_approximate", sizeof("KEY_approximate")-1, GDK_approximate);
	phpg_register_int_constant(gdk_ce, "KEY_similarequal", sizeof("KEY_similarequal")-1, GDK_similarequal);
	phpg_register_int_constant(gdk_ce, "KEY_ifonlyif", sizeof("KEY_ifonlyif")-1, GDK_ifonlyif);
	phpg_register_int_constant(gdk_ce, "KEY_implies", sizeof("KEY_implies")-1, GDK_implies);
	phpg_register_int_constant(gdk_ce, "KEY_identical", sizeof("KEY_identical")-1, GDK_identical);
	phpg_register_int_constant(gdk_ce, "KEY_radical", sizeof("KEY_radical")-1, GDK_radical);
	phpg_register_int_constant(gdk_ce, "KEY_includedin", sizeof("KEY_includedin")-1, GDK_includedin);
	phpg_register_int_constant(gdk_ce, "KEY_includes", sizeof("KEY_includes")-1, GDK_includes);
	phpg_register_int_constant(gdk_ce, "KEY_intersection", sizeof("KEY_intersection")-1, GDK_intersection);
	phpg_register_int_constant(gdk_ce, "KEY_union", sizeof("KEY_union")-1, GDK_union);
	phpg_register_int_constant(gdk_ce, "KEY_logicaland", sizeof("KEY_logicaland")-1, GDK_logicaland);
	phpg_register_int_constant(gdk_ce, "KEY_logicalor", sizeof("KEY_logicalor")-1, GDK_logicalor);
	phpg_register_int_constant(gdk_ce, "KEY_partialderivative", sizeof("KEY_partialderivative")-1, GDK_partialderivative);
	phpg_register_int_constant(gdk_ce, "KEY_function", sizeof("KEY_function")-1, GDK_function);
	phpg_register_int_constant(gdk_ce, "KEY_leftarrow", sizeof("KEY_leftarrow")-1, GDK_leftarrow);
	phpg_register_int_constant(gdk_ce, "KEY_uparrow", sizeof("KEY_uparrow")-1, GDK_uparrow);
	phpg_register_int_constant(gdk_ce, "KEY_rightarrow", sizeof("KEY_rightarrow")-1, GDK_rightarrow);
	phpg_register_int_constant(gdk_ce, "KEY_downarrow", sizeof("KEY_downarrow")-1, GDK_downarrow);
	phpg_register_int_constant(gdk_ce, "KEY_blank", sizeof("KEY_blank")-1, GDK_blank);
	phpg_register_int_constant(gdk_ce, "KEY_soliddiamond", sizeof("KEY_soliddiamond")-1, GDK_soliddiamond);
	phpg_register_int_constant(gdk_ce, "KEY_checkerboard", sizeof("KEY_checkerboard")-1, GDK_checkerboard);
	phpg_register_int_constant(gdk_ce, "KEY_ht", sizeof("KEY_ht")-1, GDK_ht);
	phpg_register_int_constant(gdk_ce, "KEY_ff", sizeof("KEY_ff")-1, GDK_ff);
	phpg_register_int_constant(gdk_ce, "KEY_cr", sizeof("KEY_cr")-1, GDK_cr);
	phpg_register_int_constant(gdk_ce, "KEY_lf", sizeof("KEY_lf")-1, GDK_lf);
	phpg_register_int_constant(gdk_ce, "KEY_nl", sizeof("KEY_nl")-1, GDK_nl);
	phpg_register_int_constant(gdk_ce, "KEY_vt", sizeof("KEY_vt")-1, GDK_vt);
	phpg_register_int_constant(gdk_ce, "KEY_lowrightcorner", sizeof("KEY_lowrightcorner")-1, GDK_lowrightcorner);
	phpg_register_int_constant(gdk_ce, "KEY_uprightcorner", sizeof("KEY_uprightcorner")-1, GDK_uprightcorner);
	phpg_register_int_constant(gdk_ce, "KEY_upleftcorner", sizeof("KEY_upleftcorner")-1, GDK_upleftcorner);
	phpg_register_int_constant(gdk_ce, "KEY_lowleftcorner", sizeof("KEY_lowleftcorner")-1, GDK_lowleftcorner);
	phpg_register_int_constant(gdk_ce, "KEY_crossinglines", sizeof("KEY_crossinglines")-1, GDK_crossinglines);
	phpg_register_int_constant(gdk_ce, "KEY_horizlinescan1", sizeof("KEY_horizlinescan1")-1, GDK_horizlinescan1);
	phpg_register_int_constant(gdk_ce, "KEY_horizlinescan3", sizeof("KEY_horizlinescan3")-1, GDK_horizlinescan3);
	phpg_register_int_constant(gdk_ce, "KEY_horizlinescan5", sizeof("KEY_horizlinescan5")-1, GDK_horizlinescan5);
	phpg_register_int_constant(gdk_ce, "KEY_horizlinescan7", sizeof("KEY_horizlinescan7")-1, GDK_horizlinescan7);
	phpg_register_int_constant(gdk_ce, "KEY_horizlinescan9", sizeof("KEY_horizlinescan9")-1, GDK_horizlinescan9);
	phpg_register_int_constant(gdk_ce, "KEY_leftt", sizeof("KEY_leftt")-1, GDK_leftt);
	phpg_register_int_constant(gdk_ce, "KEY_rightt", sizeof("KEY_rightt")-1, GDK_rightt);
	phpg_register_int_constant(gdk_ce, "KEY_bott", sizeof("KEY_bott")-1, GDK_bott);
	phpg_register_int_constant(gdk_ce, "KEY_topt", sizeof("KEY_topt")-1, GDK_topt);
	phpg_register_int_constant(gdk_ce, "KEY_vertbar", sizeof("KEY_vertbar")-1, GDK_vertbar);
	phpg_register_int_constant(gdk_ce, "KEY_emspace", sizeof("KEY_emspace")-1, GDK_emspace);
	phpg_register_int_constant(gdk_ce, "KEY_enspace", sizeof("KEY_enspace")-1, GDK_enspace);
	phpg_register_int_constant(gdk_ce, "KEY_em3space", sizeof("KEY_em3space")-1, GDK_em3space);
	phpg_register_int_constant(gdk_ce, "KEY_em4space", sizeof("KEY_em4space")-1, GDK_em4space);
	phpg_register_int_constant(gdk_ce, "KEY_digitspace", sizeof("KEY_digitspace")-1, GDK_digitspace);
	phpg_register_int_constant(gdk_ce, "KEY_punctspace", sizeof("KEY_punctspace")-1, GDK_punctspace);
	phpg_register_int_constant(gdk_ce, "KEY_thinspace", sizeof("KEY_thinspace")-1, GDK_thinspace);
	phpg_register_int_constant(gdk_ce, "KEY_hairspace", sizeof("KEY_hairspace")-1, GDK_hairspace);
	phpg_register_int_constant(gdk_ce, "KEY_emdash", sizeof("KEY_emdash")-1, GDK_emdash);
	phpg_register_int_constant(gdk_ce, "KEY_endash", sizeof("KEY_endash")-1, GDK_endash);
	phpg_register_int_constant(gdk_ce, "KEY_signifblank", sizeof("KEY_signifblank")-1, GDK_signifblank);
	phpg_register_int_constant(gdk_ce, "KEY_ellipsis", sizeof("KEY_ellipsis")-1, GDK_ellipsis);
	phpg_register_int_constant(gdk_ce, "KEY_doubbaselinedot", sizeof("KEY_doubbaselinedot")-1, GDK_doubbaselinedot);
	phpg_register_int_constant(gdk_ce, "KEY_onethird", sizeof("KEY_onethird")-1, GDK_onethird);
	phpg_register_int_constant(gdk_ce, "KEY_twothirds", sizeof("KEY_twothirds")-1, GDK_twothirds);
	phpg_register_int_constant(gdk_ce, "KEY_onefifth", sizeof("KEY_onefifth")-1, GDK_onefifth);
	phpg_register_int_constant(gdk_ce, "KEY_twofifths", sizeof("KEY_twofifths")-1, GDK_twofifths);
	phpg_register_int_constant(gdk_ce, "KEY_threefifths", sizeof("KEY_threefifths")-1, GDK_threefifths);
	phpg_register_int_constant(gdk_ce, "KEY_fourfifths", sizeof("KEY_fourfifths")-1, GDK_fourfifths);
	phpg_register_int_constant(gdk_ce, "KEY_onesixth", sizeof("KEY_onesixth")-1, GDK_onesixth);
	phpg_register_int_constant(gdk_ce, "KEY_fivesixths", sizeof("KEY_fivesixths")-1, GDK_fivesixths);
	phpg_register_int_constant(gdk_ce, "KEY_careof", sizeof("KEY_careof")-1, GDK_careof);
	phpg_register_int_constant(gdk_ce, "KEY_figdash", sizeof("KEY_figdash")-1, GDK_figdash);
	phpg_register_int_constant(gdk_ce, "KEY_leftanglebracket", sizeof("KEY_leftanglebracket")-1, GDK_leftanglebracket);
	phpg_register_int_constant(gdk_ce, "KEY_decimalpoint", sizeof("KEY_decimalpoint")-1, GDK_decimalpoint);
	phpg_register_int_constant(gdk_ce, "KEY_rightanglebracket", sizeof("KEY_rightanglebracket")-1, GDK_rightanglebracket);
	phpg_register_int_constant(gdk_ce, "KEY_marker", sizeof("KEY_marker")-1, GDK_marker);
	phpg_register_int_constant(gdk_ce, "KEY_oneeighth", sizeof("KEY_oneeighth")-1, GDK_oneeighth);
	phpg_register_int_constant(gdk_ce, "KEY_threeeighths", sizeof("KEY_threeeighths")-1, GDK_threeeighths);
	phpg_register_int_constant(gdk_ce, "KEY_fiveeighths", sizeof("KEY_fiveeighths")-1, GDK_fiveeighths);
	phpg_register_int_constant(gdk_ce, "KEY_seveneighths", sizeof("KEY_seveneighths")-1, GDK_seveneighths);
	phpg_register_int_constant(gdk_ce, "KEY_trademark", sizeof("KEY_trademark")-1, GDK_trademark);
	phpg_register_int_constant(gdk_ce, "KEY_signaturemark", sizeof("KEY_signaturemark")-1, GDK_signaturemark);
	phpg_register_int_constant(gdk_ce, "KEY_trademarkincircle", sizeof("KEY_trademarkincircle")-1, GDK_trademarkincircle);
	phpg_register_int_constant(gdk_ce, "KEY_leftopentriangle", sizeof("KEY_leftopentriangle")-1, GDK_leftopentriangle);
	phpg_register_int_constant(gdk_ce, "KEY_rightopentriangle", sizeof("KEY_rightopentriangle")-1, GDK_rightopentriangle);
	phpg_register_int_constant(gdk_ce, "KEY_emopencircle", sizeof("KEY_emopencircle")-1, GDK_emopencircle);
	phpg_register_int_constant(gdk_ce, "KEY_emopenrectangle", sizeof("KEY_emopenrectangle")-1, GDK_emopenrectangle);
	phpg_register_int_constant(gdk_ce, "KEY_leftsinglequotemark", sizeof("KEY_leftsinglequotemark")-1, GDK_leftsinglequotemark);
	phpg_register_int_constant(gdk_ce, "KEY_rightsinglequotemark", sizeof("KEY_rightsinglequotemark")-1, GDK_rightsinglequotemark);
	phpg_register_int_constant(gdk_ce, "KEY_leftdoublequotemark", sizeof("KEY_leftdoublequotemark")-1, GDK_leftdoublequotemark);
	phpg_register_int_constant(gdk_ce, "KEY_rightdoublequotemark", sizeof("KEY_rightdoublequotemark")-1, GDK_rightdoublequotemark);
	phpg_register_int_constant(gdk_ce, "KEY_prescription", sizeof("KEY_prescription")-1, GDK_prescription);
	phpg_register_int_constant(gdk_ce, "KEY_minutes", sizeof("KEY_minutes")-1, GDK_minutes);
	phpg_register_int_constant(gdk_ce, "KEY_seconds", sizeof("KEY_seconds")-1, GDK_seconds);
	phpg_register_int_constant(gdk_ce, "KEY_latincross", sizeof("KEY_latincross")-1, GDK_latincross);
	phpg_register_int_constant(gdk_ce, "KEY_hexagram", sizeof("KEY_hexagram")-1, GDK_hexagram);
	phpg_register_int_constant(gdk_ce, "KEY_filledrectbullet", sizeof("KEY_filledrectbullet")-1, GDK_filledrectbullet);
	phpg_register_int_constant(gdk_ce, "KEY_filledlefttribullet", sizeof("KEY_filledlefttribullet")-1, GDK_filledlefttribullet);
	phpg_register_int_constant(gdk_ce, "KEY_filledrighttribullet", sizeof("KEY_filledrighttribullet")-1, GDK_filledrighttribullet);
	phpg_register_int_constant(gdk_ce, "KEY_emfilledcircle", sizeof("KEY_emfilledcircle")-1, GDK_emfilledcircle);
	phpg_register_int_constant(gdk_ce, "KEY_emfilledrect", sizeof("KEY_emfilledrect")-1, GDK_emfilledrect);
	phpg_register_int_constant(gdk_ce, "KEY_enopencircbullet", sizeof("KEY_enopencircbullet")-1, GDK_enopencircbullet);
	phpg_register_int_constant(gdk_ce, "KEY_enopensquarebullet", sizeof("KEY_enopensquarebullet")-1, GDK_enopensquarebullet);
	phpg_register_int_constant(gdk_ce, "KEY_openrectbullet", sizeof("KEY_openrectbullet")-1, GDK_openrectbullet);
	phpg_register_int_constant(gdk_ce, "KEY_opentribulletup", sizeof("KEY_opentribulletup")-1, GDK_opentribulletup);
	phpg_register_int_constant(gdk_ce, "KEY_opentribulletdown", sizeof("KEY_opentribulletdown")-1, GDK_opentribulletdown);
	phpg_register_int_constant(gdk_ce, "KEY_openstar", sizeof("KEY_openstar")-1, GDK_openstar);
	phpg_register_int_constant(gdk_ce, "KEY_enfilledcircbullet", sizeof("KEY_enfilledcircbullet")-1, GDK_enfilledcircbullet);
	phpg_register_int_constant(gdk_ce, "KEY_enfilledsqbullet", sizeof("KEY_enfilledsqbullet")-1, GDK_enfilledsqbullet);
	phpg_register_int_constant(gdk_ce, "KEY_filledtribulletup", sizeof("KEY_filledtribulletup")-1, GDK_filledtribulletup);
	phpg_register_int_constant(gdk_ce, "KEY_filledtribulletdown", sizeof("KEY_filledtribulletdown")-1, GDK_filledtribulletdown);
	phpg_register_int_constant(gdk_ce, "KEY_leftpointer", sizeof("KEY_leftpointer")-1, GDK_leftpointer);
	phpg_register_int_constant(gdk_ce, "KEY_rightpointer", sizeof("KEY_rightpointer")-1, GDK_rightpointer);
	phpg_register_int_constant(gdk_ce, "KEY_club", sizeof("KEY_club")-1, GDK_club);
	phpg_register_int_constant(gdk_ce, "KEY_diamond", sizeof("KEY_diamond")-1, GDK_diamond);
	phpg_register_int_constant(gdk_ce, "KEY_heart", sizeof("KEY_heart")-1, GDK_heart);
	phpg_register_int_constant(gdk_ce, "KEY_maltesecross", sizeof("KEY_maltesecross")-1, GDK_maltesecross);
	phpg_register_int_constant(gdk_ce, "KEY_dagger", sizeof("KEY_dagger")-1, GDK_dagger);
	phpg_register_int_constant(gdk_ce, "KEY_doubledagger", sizeof("KEY_doubledagger")-1, GDK_doubledagger);
	phpg_register_int_constant(gdk_ce, "KEY_checkmark", sizeof("KEY_checkmark")-1, GDK_checkmark);
	phpg_register_int_constant(gdk_ce, "KEY_ballotcross", sizeof("KEY_ballotcross")-1, GDK_ballotcross);
	phpg_register_int_constant(gdk_ce, "KEY_musicalsharp", sizeof("KEY_musicalsharp")-1, GDK_musicalsharp);
	phpg_register_int_constant(gdk_ce, "KEY_musicalflat", sizeof("KEY_musicalflat")-1, GDK_musicalflat);
	phpg_register_int_constant(gdk_ce, "KEY_malesymbol", sizeof("KEY_malesymbol")-1, GDK_malesymbol);
	phpg_register_int_constant(gdk_ce, "KEY_femalesymbol", sizeof("KEY_femalesymbol")-1, GDK_femalesymbol);
	phpg_register_int_constant(gdk_ce, "KEY_telephone", sizeof("KEY_telephone")-1, GDK_telephone);
	phpg_register_int_constant(gdk_ce, "KEY_telephonerecorder", sizeof("KEY_telephonerecorder")-1, GDK_telephonerecorder);
	phpg_register_int_constant(gdk_ce, "KEY_phonographcopyright", sizeof("KEY_phonographcopyright")-1, GDK_phonographcopyright);
	phpg_register_int_constant(gdk_ce, "KEY_caret", sizeof("KEY_caret")-1, GDK_caret);
	phpg_register_int_constant(gdk_ce, "KEY_singlelowquotemark", sizeof("KEY_singlelowquotemark")-1, GDK_singlelowquotemark);
	phpg_register_int_constant(gdk_ce, "KEY_doublelowquotemark", sizeof("KEY_doublelowquotemark")-1, GDK_doublelowquotemark);
	phpg_register_int_constant(gdk_ce, "KEY_cursor", sizeof("KEY_cursor")-1, GDK_cursor);
	phpg_register_int_constant(gdk_ce, "KEY_leftcaret", sizeof("KEY_leftcaret")-1, GDK_leftcaret);
	phpg_register_int_constant(gdk_ce, "KEY_rightcaret", sizeof("KEY_rightcaret")-1, GDK_rightcaret);
	phpg_register_int_constant(gdk_ce, "KEY_downcaret", sizeof("KEY_downcaret")-1, GDK_downcaret);
	phpg_register_int_constant(gdk_ce, "KEY_upcaret", sizeof("KEY_upcaret")-1, GDK_upcaret);
	phpg_register_int_constant(gdk_ce, "KEY_overbar", sizeof("KEY_overbar")-1, GDK_overbar);
	phpg_register_int_constant(gdk_ce, "KEY_downtack", sizeof("KEY_downtack")-1, GDK_downtack);
	phpg_register_int_constant(gdk_ce, "KEY_upshoe", sizeof("KEY_upshoe")-1, GDK_upshoe);
	phpg_register_int_constant(gdk_ce, "KEY_downstile", sizeof("KEY_downstile")-1, GDK_downstile);
	phpg_register_int_constant(gdk_ce, "KEY_underbar", sizeof("KEY_underbar")-1, GDK_underbar);
	phpg_register_int_constant(gdk_ce, "KEY_jot", sizeof("KEY_jot")-1, GDK_jot);
	phpg_register_int_constant(gdk_ce, "KEY_quad", sizeof("KEY_quad")-1, GDK_quad);
	phpg_register_int_constant(gdk_ce, "KEY_uptack", sizeof("KEY_uptack")-1, GDK_uptack);
	phpg_register_int_constant(gdk_ce, "KEY_circle", sizeof("KEY_circle")-1, GDK_circle);
	phpg_register_int_constant(gdk_ce, "KEY_upstile", sizeof("KEY_upstile")-1, GDK_upstile);
	phpg_register_int_constant(gdk_ce, "KEY_downshoe", sizeof("KEY_downshoe")-1, GDK_downshoe);
	phpg_register_int_constant(gdk_ce, "KEY_rightshoe", sizeof("KEY_rightshoe")-1, GDK_rightshoe);
	phpg_register_int_constant(gdk_ce, "KEY_leftshoe", sizeof("KEY_leftshoe")-1, GDK_leftshoe);
	phpg_register_int_constant(gdk_ce, "KEY_lefttack", sizeof("KEY_lefttack")-1, GDK_lefttack);
	phpg_register_int_constant(gdk_ce, "KEY_righttack", sizeof("KEY_righttack")-1, GDK_righttack);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_doublelowline", sizeof("KEY_hebrew_doublelowline")-1, GDK_hebrew_doublelowline);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_aleph", sizeof("KEY_hebrew_aleph")-1, GDK_hebrew_aleph);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_bet", sizeof("KEY_hebrew_bet")-1, GDK_hebrew_bet);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_beth", sizeof("KEY_hebrew_beth")-1, GDK_hebrew_beth);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_gimel", sizeof("KEY_hebrew_gimel")-1, GDK_hebrew_gimel);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_gimmel", sizeof("KEY_hebrew_gimmel")-1, GDK_hebrew_gimmel);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_dalet", sizeof("KEY_hebrew_dalet")-1, GDK_hebrew_dalet);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_daleth", sizeof("KEY_hebrew_daleth")-1, GDK_hebrew_daleth);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_he", sizeof("KEY_hebrew_he")-1, GDK_hebrew_he);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_waw", sizeof("KEY_hebrew_waw")-1, GDK_hebrew_waw);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_zain", sizeof("KEY_hebrew_zain")-1, GDK_hebrew_zain);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_zayin", sizeof("KEY_hebrew_zayin")-1, GDK_hebrew_zayin);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_chet", sizeof("KEY_hebrew_chet")-1, GDK_hebrew_chet);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_het", sizeof("KEY_hebrew_het")-1, GDK_hebrew_het);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_tet", sizeof("KEY_hebrew_tet")-1, GDK_hebrew_tet);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_teth", sizeof("KEY_hebrew_teth")-1, GDK_hebrew_teth);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_yod", sizeof("KEY_hebrew_yod")-1, GDK_hebrew_yod);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_finalkaph", sizeof("KEY_hebrew_finalkaph")-1, GDK_hebrew_finalkaph);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_kaph", sizeof("KEY_hebrew_kaph")-1, GDK_hebrew_kaph);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_lamed", sizeof("KEY_hebrew_lamed")-1, GDK_hebrew_lamed);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_finalmem", sizeof("KEY_hebrew_finalmem")-1, GDK_hebrew_finalmem);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_mem", sizeof("KEY_hebrew_mem")-1, GDK_hebrew_mem);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_finalnun", sizeof("KEY_hebrew_finalnun")-1, GDK_hebrew_finalnun);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_nun", sizeof("KEY_hebrew_nun")-1, GDK_hebrew_nun);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_samech", sizeof("KEY_hebrew_samech")-1, GDK_hebrew_samech);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_samekh", sizeof("KEY_hebrew_samekh")-1, GDK_hebrew_samekh);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_ayin", sizeof("KEY_hebrew_ayin")-1, GDK_hebrew_ayin);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_finalpe", sizeof("KEY_hebrew_finalpe")-1, GDK_hebrew_finalpe);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_pe", sizeof("KEY_hebrew_pe")-1, GDK_hebrew_pe);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_finalzade", sizeof("KEY_hebrew_finalzade")-1, GDK_hebrew_finalzade);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_finalzadi", sizeof("KEY_hebrew_finalzadi")-1, GDK_hebrew_finalzadi);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_zade", sizeof("KEY_hebrew_zade")-1, GDK_hebrew_zade);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_zadi", sizeof("KEY_hebrew_zadi")-1, GDK_hebrew_zadi);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_qoph", sizeof("KEY_hebrew_qoph")-1, GDK_hebrew_qoph);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_kuf", sizeof("KEY_hebrew_kuf")-1, GDK_hebrew_kuf);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_resh", sizeof("KEY_hebrew_resh")-1, GDK_hebrew_resh);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_shin", sizeof("KEY_hebrew_shin")-1, GDK_hebrew_shin);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_taw", sizeof("KEY_hebrew_taw")-1, GDK_hebrew_taw);
	phpg_register_int_constant(gdk_ce, "KEY_hebrew_taf", sizeof("KEY_hebrew_taf")-1, GDK_hebrew_taf);
	phpg_register_int_constant(gdk_ce, "KEY_Hebrew_switch", sizeof("KEY_Hebrew_switch")-1, GDK_Hebrew_switch);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_kokai", sizeof("KEY_Thai_kokai")-1, GDK_Thai_kokai);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_khokhai", sizeof("KEY_Thai_khokhai")-1, GDK_Thai_khokhai);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_khokhuat", sizeof("KEY_Thai_khokhuat")-1, GDK_Thai_khokhuat);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_khokhwai", sizeof("KEY_Thai_khokhwai")-1, GDK_Thai_khokhwai);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_khokhon", sizeof("KEY_Thai_khokhon")-1, GDK_Thai_khokhon);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_khorakhang", sizeof("KEY_Thai_khorakhang")-1, GDK_Thai_khorakhang);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_ngongu", sizeof("KEY_Thai_ngongu")-1, GDK_Thai_ngongu);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_chochan", sizeof("KEY_Thai_chochan")-1, GDK_Thai_chochan);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_choching", sizeof("KEY_Thai_choching")-1, GDK_Thai_choching);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_chochang", sizeof("KEY_Thai_chochang")-1, GDK_Thai_chochang);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_soso", sizeof("KEY_Thai_soso")-1, GDK_Thai_soso);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_chochoe", sizeof("KEY_Thai_chochoe")-1, GDK_Thai_chochoe);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_yoying", sizeof("KEY_Thai_yoying")-1, GDK_Thai_yoying);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_dochada", sizeof("KEY_Thai_dochada")-1, GDK_Thai_dochada);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_topatak", sizeof("KEY_Thai_topatak")-1, GDK_Thai_topatak);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_thothan", sizeof("KEY_Thai_thothan")-1, GDK_Thai_thothan);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_thonangmontho", sizeof("KEY_Thai_thonangmontho")-1, GDK_Thai_thonangmontho);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_thophuthao", sizeof("KEY_Thai_thophuthao")-1, GDK_Thai_thophuthao);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_nonen", sizeof("KEY_Thai_nonen")-1, GDK_Thai_nonen);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_dodek", sizeof("KEY_Thai_dodek")-1, GDK_Thai_dodek);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_totao", sizeof("KEY_Thai_totao")-1, GDK_Thai_totao);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_thothung", sizeof("KEY_Thai_thothung")-1, GDK_Thai_thothung);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_thothahan", sizeof("KEY_Thai_thothahan")-1, GDK_Thai_thothahan);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_thothong", sizeof("KEY_Thai_thothong")-1, GDK_Thai_thothong);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_nonu", sizeof("KEY_Thai_nonu")-1, GDK_Thai_nonu);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_bobaimai", sizeof("KEY_Thai_bobaimai")-1, GDK_Thai_bobaimai);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_popla", sizeof("KEY_Thai_popla")-1, GDK_Thai_popla);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_phophung", sizeof("KEY_Thai_phophung")-1, GDK_Thai_phophung);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_fofa", sizeof("KEY_Thai_fofa")-1, GDK_Thai_fofa);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_phophan", sizeof("KEY_Thai_phophan")-1, GDK_Thai_phophan);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_fofan", sizeof("KEY_Thai_fofan")-1, GDK_Thai_fofan);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_phosamphao", sizeof("KEY_Thai_phosamphao")-1, GDK_Thai_phosamphao);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_moma", sizeof("KEY_Thai_moma")-1, GDK_Thai_moma);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_yoyak", sizeof("KEY_Thai_yoyak")-1, GDK_Thai_yoyak);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_rorua", sizeof("KEY_Thai_rorua")-1, GDK_Thai_rorua);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_ru", sizeof("KEY_Thai_ru")-1, GDK_Thai_ru);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_loling", sizeof("KEY_Thai_loling")-1, GDK_Thai_loling);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lu", sizeof("KEY_Thai_lu")-1, GDK_Thai_lu);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_wowaen", sizeof("KEY_Thai_wowaen")-1, GDK_Thai_wowaen);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sosala", sizeof("KEY_Thai_sosala")-1, GDK_Thai_sosala);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sorusi", sizeof("KEY_Thai_sorusi")-1, GDK_Thai_sorusi);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sosua", sizeof("KEY_Thai_sosua")-1, GDK_Thai_sosua);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_hohip", sizeof("KEY_Thai_hohip")-1, GDK_Thai_hohip);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lochula", sizeof("KEY_Thai_lochula")-1, GDK_Thai_lochula);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_oang", sizeof("KEY_Thai_oang")-1, GDK_Thai_oang);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_honokhuk", sizeof("KEY_Thai_honokhuk")-1, GDK_Thai_honokhuk);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_paiyannoi", sizeof("KEY_Thai_paiyannoi")-1, GDK_Thai_paiyannoi);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraa", sizeof("KEY_Thai_saraa")-1, GDK_Thai_saraa);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maihanakat", sizeof("KEY_Thai_maihanakat")-1, GDK_Thai_maihanakat);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraaa", sizeof("KEY_Thai_saraaa")-1, GDK_Thai_saraaa);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraam", sizeof("KEY_Thai_saraam")-1, GDK_Thai_saraam);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sarai", sizeof("KEY_Thai_sarai")-1, GDK_Thai_sarai);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraii", sizeof("KEY_Thai_saraii")-1, GDK_Thai_saraii);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraue", sizeof("KEY_Thai_saraue")-1, GDK_Thai_saraue);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sarauee", sizeof("KEY_Thai_sarauee")-1, GDK_Thai_sarauee);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sarau", sizeof("KEY_Thai_sarau")-1, GDK_Thai_sarau);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sarauu", sizeof("KEY_Thai_sarauu")-1, GDK_Thai_sarauu);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_phinthu", sizeof("KEY_Thai_phinthu")-1, GDK_Thai_phinthu);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maihanakat_maitho", sizeof("KEY_Thai_maihanakat_maitho")-1, GDK_Thai_maihanakat_maitho);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_baht", sizeof("KEY_Thai_baht")-1, GDK_Thai_baht);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sarae", sizeof("KEY_Thai_sarae")-1, GDK_Thai_sarae);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraae", sizeof("KEY_Thai_saraae")-1, GDK_Thai_saraae);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_sarao", sizeof("KEY_Thai_sarao")-1, GDK_Thai_sarao);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraaimaimuan", sizeof("KEY_Thai_saraaimaimuan")-1, GDK_Thai_saraaimaimuan);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_saraaimaimalai", sizeof("KEY_Thai_saraaimaimalai")-1, GDK_Thai_saraaimaimalai);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lakkhangyao", sizeof("KEY_Thai_lakkhangyao")-1, GDK_Thai_lakkhangyao);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maiyamok", sizeof("KEY_Thai_maiyamok")-1, GDK_Thai_maiyamok);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maitaikhu", sizeof("KEY_Thai_maitaikhu")-1, GDK_Thai_maitaikhu);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maiek", sizeof("KEY_Thai_maiek")-1, GDK_Thai_maiek);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maitho", sizeof("KEY_Thai_maitho")-1, GDK_Thai_maitho);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maitri", sizeof("KEY_Thai_maitri")-1, GDK_Thai_maitri);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_maichattawa", sizeof("KEY_Thai_maichattawa")-1, GDK_Thai_maichattawa);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_thanthakhat", sizeof("KEY_Thai_thanthakhat")-1, GDK_Thai_thanthakhat);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_nikhahit", sizeof("KEY_Thai_nikhahit")-1, GDK_Thai_nikhahit);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_leksun", sizeof("KEY_Thai_leksun")-1, GDK_Thai_leksun);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_leknung", sizeof("KEY_Thai_leknung")-1, GDK_Thai_leknung);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_leksong", sizeof("KEY_Thai_leksong")-1, GDK_Thai_leksong);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_leksam", sizeof("KEY_Thai_leksam")-1, GDK_Thai_leksam);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_leksi", sizeof("KEY_Thai_leksi")-1, GDK_Thai_leksi);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lekha", sizeof("KEY_Thai_lekha")-1, GDK_Thai_lekha);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lekhok", sizeof("KEY_Thai_lekhok")-1, GDK_Thai_lekhok);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lekchet", sizeof("KEY_Thai_lekchet")-1, GDK_Thai_lekchet);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lekpaet", sizeof("KEY_Thai_lekpaet")-1, GDK_Thai_lekpaet);
	phpg_register_int_constant(gdk_ce, "KEY_Thai_lekkao", sizeof("KEY_Thai_lekkao")-1, GDK_Thai_lekkao);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul", sizeof("KEY_Hangul")-1, GDK_Hangul);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Start", sizeof("KEY_Hangul_Start")-1, GDK_Hangul_Start);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_End", sizeof("KEY_Hangul_End")-1, GDK_Hangul_End);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Hanja", sizeof("KEY_Hangul_Hanja")-1, GDK_Hangul_Hanja);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Jamo", sizeof("KEY_Hangul_Jamo")-1, GDK_Hangul_Jamo);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Romaja", sizeof("KEY_Hangul_Romaja")-1, GDK_Hangul_Romaja);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Codeinput", sizeof("KEY_Hangul_Codeinput")-1, GDK_Hangul_Codeinput);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Jeonja", sizeof("KEY_Hangul_Jeonja")-1, GDK_Hangul_Jeonja);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Banja", sizeof("KEY_Hangul_Banja")-1, GDK_Hangul_Banja);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_PreHanja", sizeof("KEY_Hangul_PreHanja")-1, GDK_Hangul_PreHanja);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_PostHanja", sizeof("KEY_Hangul_PostHanja")-1, GDK_Hangul_PostHanja);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SingleCandidate", sizeof("KEY_Hangul_SingleCandidate")-1, GDK_Hangul_SingleCandidate);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_MultipleCandidate", sizeof("KEY_Hangul_MultipleCandidate")-1, GDK_Hangul_MultipleCandidate);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_PreviousCandidate", sizeof("KEY_Hangul_PreviousCandidate")-1, GDK_Hangul_PreviousCandidate);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Special", sizeof("KEY_Hangul_Special")-1, GDK_Hangul_Special);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_switch", sizeof("KEY_Hangul_switch")-1, GDK_Hangul_switch);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Kiyeog", sizeof("KEY_Hangul_Kiyeog")-1, GDK_Hangul_Kiyeog);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SsangKiyeog", sizeof("KEY_Hangul_SsangKiyeog")-1, GDK_Hangul_SsangKiyeog);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_KiyeogSios", sizeof("KEY_Hangul_KiyeogSios")-1, GDK_Hangul_KiyeogSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Nieun", sizeof("KEY_Hangul_Nieun")-1, GDK_Hangul_Nieun);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_NieunJieuj", sizeof("KEY_Hangul_NieunJieuj")-1, GDK_Hangul_NieunJieuj);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_NieunHieuh", sizeof("KEY_Hangul_NieunHieuh")-1, GDK_Hangul_NieunHieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Dikeud", sizeof("KEY_Hangul_Dikeud")-1, GDK_Hangul_Dikeud);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SsangDikeud", sizeof("KEY_Hangul_SsangDikeud")-1, GDK_Hangul_SsangDikeud);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Rieul", sizeof("KEY_Hangul_Rieul")-1, GDK_Hangul_Rieul);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulKiyeog", sizeof("KEY_Hangul_RieulKiyeog")-1, GDK_Hangul_RieulKiyeog);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulMieum", sizeof("KEY_Hangul_RieulMieum")-1, GDK_Hangul_RieulMieum);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulPieub", sizeof("KEY_Hangul_RieulPieub")-1, GDK_Hangul_RieulPieub);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulSios", sizeof("KEY_Hangul_RieulSios")-1, GDK_Hangul_RieulSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulTieut", sizeof("KEY_Hangul_RieulTieut")-1, GDK_Hangul_RieulTieut);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulPhieuf", sizeof("KEY_Hangul_RieulPhieuf")-1, GDK_Hangul_RieulPhieuf);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulHieuh", sizeof("KEY_Hangul_RieulHieuh")-1, GDK_Hangul_RieulHieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Mieum", sizeof("KEY_Hangul_Mieum")-1, GDK_Hangul_Mieum);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Pieub", sizeof("KEY_Hangul_Pieub")-1, GDK_Hangul_Pieub);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SsangPieub", sizeof("KEY_Hangul_SsangPieub")-1, GDK_Hangul_SsangPieub);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_PieubSios", sizeof("KEY_Hangul_PieubSios")-1, GDK_Hangul_PieubSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Sios", sizeof("KEY_Hangul_Sios")-1, GDK_Hangul_Sios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SsangSios", sizeof("KEY_Hangul_SsangSios")-1, GDK_Hangul_SsangSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Ieung", sizeof("KEY_Hangul_Ieung")-1, GDK_Hangul_Ieung);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Jieuj", sizeof("KEY_Hangul_Jieuj")-1, GDK_Hangul_Jieuj);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SsangJieuj", sizeof("KEY_Hangul_SsangJieuj")-1, GDK_Hangul_SsangJieuj);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Cieuc", sizeof("KEY_Hangul_Cieuc")-1, GDK_Hangul_Cieuc);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Khieuq", sizeof("KEY_Hangul_Khieuq")-1, GDK_Hangul_Khieuq);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Tieut", sizeof("KEY_Hangul_Tieut")-1, GDK_Hangul_Tieut);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Phieuf", sizeof("KEY_Hangul_Phieuf")-1, GDK_Hangul_Phieuf);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_Hieuh", sizeof("KEY_Hangul_Hieuh")-1, GDK_Hangul_Hieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_A", sizeof("KEY_Hangul_A")-1, GDK_Hangul_A);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_AE", sizeof("KEY_Hangul_AE")-1, GDK_Hangul_AE);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YA", sizeof("KEY_Hangul_YA")-1, GDK_Hangul_YA);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YAE", sizeof("KEY_Hangul_YAE")-1, GDK_Hangul_YAE);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_EO", sizeof("KEY_Hangul_EO")-1, GDK_Hangul_EO);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_E", sizeof("KEY_Hangul_E")-1, GDK_Hangul_E);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YEO", sizeof("KEY_Hangul_YEO")-1, GDK_Hangul_YEO);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YE", sizeof("KEY_Hangul_YE")-1, GDK_Hangul_YE);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_O", sizeof("KEY_Hangul_O")-1, GDK_Hangul_O);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_WA", sizeof("KEY_Hangul_WA")-1, GDK_Hangul_WA);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_WAE", sizeof("KEY_Hangul_WAE")-1, GDK_Hangul_WAE);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_OE", sizeof("KEY_Hangul_OE")-1, GDK_Hangul_OE);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YO", sizeof("KEY_Hangul_YO")-1, GDK_Hangul_YO);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_U", sizeof("KEY_Hangul_U")-1, GDK_Hangul_U);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_WEO", sizeof("KEY_Hangul_WEO")-1, GDK_Hangul_WEO);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_WE", sizeof("KEY_Hangul_WE")-1, GDK_Hangul_WE);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_WI", sizeof("KEY_Hangul_WI")-1, GDK_Hangul_WI);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YU", sizeof("KEY_Hangul_YU")-1, GDK_Hangul_YU);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_EU", sizeof("KEY_Hangul_EU")-1, GDK_Hangul_EU);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YI", sizeof("KEY_Hangul_YI")-1, GDK_Hangul_YI);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_I", sizeof("KEY_Hangul_I")-1, GDK_Hangul_I);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Kiyeog", sizeof("KEY_Hangul_J_Kiyeog")-1, GDK_Hangul_J_Kiyeog);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_SsangKiyeog", sizeof("KEY_Hangul_J_SsangKiyeog")-1, GDK_Hangul_J_SsangKiyeog);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_KiyeogSios", sizeof("KEY_Hangul_J_KiyeogSios")-1, GDK_Hangul_J_KiyeogSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Nieun", sizeof("KEY_Hangul_J_Nieun")-1, GDK_Hangul_J_Nieun);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_NieunJieuj", sizeof("KEY_Hangul_J_NieunJieuj")-1, GDK_Hangul_J_NieunJieuj);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_NieunHieuh", sizeof("KEY_Hangul_J_NieunHieuh")-1, GDK_Hangul_J_NieunHieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Dikeud", sizeof("KEY_Hangul_J_Dikeud")-1, GDK_Hangul_J_Dikeud);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Rieul", sizeof("KEY_Hangul_J_Rieul")-1, GDK_Hangul_J_Rieul);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_RieulKiyeog", sizeof("KEY_Hangul_J_RieulKiyeog")-1, GDK_Hangul_J_RieulKiyeog);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_RieulMieum", sizeof("KEY_Hangul_J_RieulMieum")-1, GDK_Hangul_J_RieulMieum);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_RieulPieub", sizeof("KEY_Hangul_J_RieulPieub")-1, GDK_Hangul_J_RieulPieub);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_RieulSios", sizeof("KEY_Hangul_J_RieulSios")-1, GDK_Hangul_J_RieulSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_RieulTieut", sizeof("KEY_Hangul_J_RieulTieut")-1, GDK_Hangul_J_RieulTieut);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_RieulPhieuf", sizeof("KEY_Hangul_J_RieulPhieuf")-1, GDK_Hangul_J_RieulPhieuf);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_RieulHieuh", sizeof("KEY_Hangul_J_RieulHieuh")-1, GDK_Hangul_J_RieulHieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Mieum", sizeof("KEY_Hangul_J_Mieum")-1, GDK_Hangul_J_Mieum);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Pieub", sizeof("KEY_Hangul_J_Pieub")-1, GDK_Hangul_J_Pieub);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_PieubSios", sizeof("KEY_Hangul_J_PieubSios")-1, GDK_Hangul_J_PieubSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Sios", sizeof("KEY_Hangul_J_Sios")-1, GDK_Hangul_J_Sios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_SsangSios", sizeof("KEY_Hangul_J_SsangSios")-1, GDK_Hangul_J_SsangSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Ieung", sizeof("KEY_Hangul_J_Ieung")-1, GDK_Hangul_J_Ieung);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Jieuj", sizeof("KEY_Hangul_J_Jieuj")-1, GDK_Hangul_J_Jieuj);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Cieuc", sizeof("KEY_Hangul_J_Cieuc")-1, GDK_Hangul_J_Cieuc);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Khieuq", sizeof("KEY_Hangul_J_Khieuq")-1, GDK_Hangul_J_Khieuq);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Tieut", sizeof("KEY_Hangul_J_Tieut")-1, GDK_Hangul_J_Tieut);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Phieuf", sizeof("KEY_Hangul_J_Phieuf")-1, GDK_Hangul_J_Phieuf);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_Hieuh", sizeof("KEY_Hangul_J_Hieuh")-1, GDK_Hangul_J_Hieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_RieulYeorinHieuh", sizeof("KEY_Hangul_RieulYeorinHieuh")-1, GDK_Hangul_RieulYeorinHieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SunkyeongeumMieum", sizeof("KEY_Hangul_SunkyeongeumMieum")-1, GDK_Hangul_SunkyeongeumMieum);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SunkyeongeumPieub", sizeof("KEY_Hangul_SunkyeongeumPieub")-1, GDK_Hangul_SunkyeongeumPieub);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_PanSios", sizeof("KEY_Hangul_PanSios")-1, GDK_Hangul_PanSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_KkogjiDalrinIeung", sizeof("KEY_Hangul_KkogjiDalrinIeung")-1, GDK_Hangul_KkogjiDalrinIeung);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_SunkyeongeumPhieuf", sizeof("KEY_Hangul_SunkyeongeumPhieuf")-1, GDK_Hangul_SunkyeongeumPhieuf);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_YeorinHieuh", sizeof("KEY_Hangul_YeorinHieuh")-1, GDK_Hangul_YeorinHieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_AraeA", sizeof("KEY_Hangul_AraeA")-1, GDK_Hangul_AraeA);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_AraeAE", sizeof("KEY_Hangul_AraeAE")-1, GDK_Hangul_AraeAE);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_PanSios", sizeof("KEY_Hangul_J_PanSios")-1, GDK_Hangul_J_PanSios);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_KkogjiDalrinIeung", sizeof("KEY_Hangul_J_KkogjiDalrinIeung")-1, GDK_Hangul_J_KkogjiDalrinIeung);
	phpg_register_int_constant(gdk_ce, "KEY_Hangul_J_YeorinHieuh", sizeof("KEY_Hangul_J_YeorinHieuh")-1, GDK_Hangul_J_YeorinHieuh);
	phpg_register_int_constant(gdk_ce, "KEY_Korean_Won", sizeof("KEY_Korean_Won")-1, GDK_Korean_Won);
	phpg_register_int_constant(gdk_ce, "KEY_EcuSign", sizeof("KEY_EcuSign")-1, GDK_EcuSign);
	phpg_register_int_constant(gdk_ce, "KEY_ColonSign", sizeof("KEY_ColonSign")-1, GDK_ColonSign);
	phpg_register_int_constant(gdk_ce, "KEY_CruzeiroSign", sizeof("KEY_CruzeiroSign")-1, GDK_CruzeiroSign);
	phpg_register_int_constant(gdk_ce, "KEY_FFrancSign", sizeof("KEY_FFrancSign")-1, GDK_FFrancSign);
	phpg_register_int_constant(gdk_ce, "KEY_LiraSign", sizeof("KEY_LiraSign")-1, GDK_LiraSign);
	phpg_register_int_constant(gdk_ce, "KEY_MillSign", sizeof("KEY_MillSign")-1, GDK_MillSign);
	phpg_register_int_constant(gdk_ce, "KEY_NairaSign", sizeof("KEY_NairaSign")-1, GDK_NairaSign);
	phpg_register_int_constant(gdk_ce, "KEY_PesetaSign", sizeof("KEY_PesetaSign")-1, GDK_PesetaSign);
	phpg_register_int_constant(gdk_ce, "KEY_RupeeSign", sizeof("KEY_RupeeSign")-1, GDK_RupeeSign);
	phpg_register_int_constant(gdk_ce, "KEY_WonSign", sizeof("KEY_WonSign")-1, GDK_WonSign);
	phpg_register_int_constant(gdk_ce, "KEY_NewSheqelSign", sizeof("KEY_NewSheqelSign")-1, GDK_NewSheqelSign);
	phpg_register_int_constant(gdk_ce, "KEY_DongSign", sizeof("KEY_DongSign")-1, GDK_DongSign);
	phpg_register_int_constant(gdk_ce, "KEY_EuroSign", sizeof("KEY_EuroSign")-1, GDK_EuroSign);
}

#endif	/* HAVE_PHP_GTK */
