/* $Id: $ */
#include<common/io/Writer.h>
#include<colorer/handlers/LineRegion.h>

class LineWriter{
public:

  static void tokenWrite(Writer *markupWriter, Writer *textWriter, Hashtable<String*> *docLinkHash, String *line, LineRegion *lineRegions){
    int pos = 0;
    for(LineRegion *l1 = lineRegions; l1; l1 = l1->next){
      if (l1->special || l1->region == null) continue;
      if (l1->start == l1->end) continue;
      int end = l1->end;
      if (end == -1) end = line->length();
      if (l1->start > pos){
        textWriter->write(line, pos, l1->start - pos);
        pos = l1->start;
      };
      String *token = l1->region->getName()->replace(DString(":"),DString("_"));
      markupWriter->write(DString("<span class='"));
      markupWriter->write(token);
      markupWriter->write(DString("'>"));
      textWriter->write(line, pos, end - l1->start);
      markupWriter->write(DString("</span>"));
      delete token;
      pos += end - l1->start;
    };
    if (pos < line->length()){
      textWriter->write(line, pos, line->length() - pos);
    };
  };


  static void markupWrite(Writer *markupWriter, Writer *textWriter, Hashtable<String*> *docLinkHash, String *line, LineRegion *lineRegions){
    int pos = 0;
    for(LineRegion *l1 = lineRegions; l1; l1 = l1->next){
      if (l1->special || l1->rdef == null) continue;
      if (l1->start == l1->end) continue;
      int end = l1->end;
      if (end == -1) end = line->length();
      if (l1->start > pos){
        textWriter->write(line, pos, l1->start - pos);
        pos = l1->start;
      };
      if (l1->texted()->sback != null) markupWriter->write(l1->texted()->sback);
      if (l1->texted()->stext != null) markupWriter->write(l1->texted()->stext);
      textWriter->write(line, pos, end - l1->start);
      if (l1->texted()->etext != null) markupWriter->write(l1->texted()->etext);
      if (l1->texted()->eback != null) markupWriter->write(l1->texted()->eback);
      pos += end - l1->start;
    };
    if (pos < line->length()){
      textWriter->write(line, pos, line->length() - pos);
    };
  };

  static void htmlRGBWrite(Writer *markupWriter, Writer *textWriter, Hashtable<String*> *docLinkHash, String *line, LineRegion *lineRegions){
    int pos = 0;
    for(LineRegion *l1 = lineRegions; l1; l1 = l1->next){
      if (l1->special || l1->rdef == null) continue;
      if (l1->start == l1->end) continue;
      int end = l1->end;
      if (end == -1) end = line->length();
      if (l1->start > pos){
        textWriter->write(line, pos, l1->start - pos);
        pos = l1->start;
      };
      if (docLinkHash->size() > 0)
        writeHref(markupWriter, docLinkHash, l1->scheme, DString(line, pos, end - l1->start), true);
      writeStart(markupWriter, l1->styled());
      textWriter->write(line, pos, end - l1->start);
      writeEnd(markupWriter, l1->styled());
      if (docLinkHash->size() > 0)
        writeHref(markupWriter, docLinkHash, l1->scheme, DString(line, pos, end - l1->start), false);
      pos += end - l1->start;
    };
    if (pos < line->length()){
      textWriter->write(line, pos, line->length() - pos);
    };
  };
  
  
  static void writeStyle(Writer *writer, const StyledRegion *lr){
    static char span[256];
    int cp = 0;
    if (lr->bfore) cp += sprintf(span, "color:#%.6x; ", lr->fore);
    if (lr->bback) cp += sprintf(span+cp, "background:#%.6x; ", lr->back);
    if (lr->style&StyledRegion::RD_BOLD) cp += sprintf(span+cp, "font-weight:bold; ");
    if (lr->style&StyledRegion::RD_ITALIC) cp += sprintf(span+cp, "font-style:italic; ");
    if (lr->style&StyledRegion::RD_UNDERLINE) cp += sprintf(span+cp, "text-decoration:underline; ");
    if (lr->style&StyledRegion::RD_STRIKEOUT) cp += sprintf(span+cp, "text-decoration:strikeout; ");
    if (cp > 0) writer->write(DString(span));
  };
  
  static void writeStart(Writer *writer, const StyledRegion *lr){
    if (!lr->bfore && !lr->bback) return;
    writer->write(DString("<span style='"));
    writeStyle(writer, lr);
    writer->write(DString("'>"));
  };

  static void writeEnd(Writer *writer, const StyledRegion *lr){
    if (!lr->bfore && !lr->bback) return;
    writer->write(DString("</span>"));
  };

  static void writeHref(Writer *writer, Hashtable<String*> *docLinkHash, const Scheme *scheme, const String &token, bool start){
    String *url = null;
    if (scheme != null){
      url = docLinkHash->get(&(StringBuffer(token).append(DString("--")).append(scheme->getName())));
    };
    if (url == null){
      url = docLinkHash->get(&token);
    };
    if (url != null){
      if (start) writer->write(StringBuffer("<a href='")+url+DString("'>"));
      else writer->write(DString("</a>"));
    };
  };

};

