/* $Id: $ */
#include<common/io/Writer.h>
#include<common/Vector.h>
#include<common/io/InputSource.h>
#include<colorer/LineSource.h>
/* {{{ ColorerWriter */
class ColorerWriter : public Writer {
	public:
		  ColorerWriter(int encoding);
		  void write(wchar c);
private:
	  int encodingIndex;
};

/* }}} */
/* {{{ LineStore */
class LineStore : public LineSource
{
public:

  /** Empty constructor. Does nothing.
  */
  LineStore();
  ~LineStore();

  /** Loads specified file into vector of strings.
      @param fileName File to load.
      @param inputEncoding Input file encoding.
      @param tab2spaces Points, if we have to convert all tabs in file into spaces.
  */
  void loadFile(const String *fileName, int ei, bool tab2spaces);

  void loadString(const String *str, bool tab2spaces);
  
  /** Returns loaded file name.
  */
  const String *getFileName();
  /** Returns total lines count in text. */
  int getLineCount();

  String *getLine(int lno);
protected:
  /** Frees loaded file lines.
  */
  void freeFile();
private:
  Vector<String*> lines;
  SString *fileName;
  void replaceTabs(int lno);

};

/* }}} */
/* HtmlEscapedWriter {{{ */
class HtmlEscapedWriter : public Writer{
public:
  HtmlEscapedWriter(Writer *writer);
  void write(wchar c);
protected:
  Writer *writer;
};
/* }}} */

/*
 *  * Local variables:
 *  * tab-width: 4
 *  * c-basic-offset: 4
 *  * End:
 *  * vim600: noet sw=4 ts=4 fdm=marker
 *  * vim<600: noet sw=4 ts=4
 *  */
