/* Generated by re2c 1.1.1 */
/* scanner.re
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php_phalcon.h"

#include "scanner.h"

#define PPCTYPE unsigned char
#define PPCURSOR (s->start)
#define PPLIMIT (s->end)
#define PPMARKER q

int phql_get_token(phql_scanner_state *s, phql_scanner_token *token) {

	char *q = PPCURSOR;
	int status = PHQL_SCANNER_RETCODE_IMPOSSIBLE;

	while (PHQL_SCANNER_RETCODE_IMPOSSIBLE == status) {

		
		{
			PPCTYPE ppch;
			unsigned int ppaccept = 0;
			ppch = *PPCURSOR;
			switch (ppch) {
			case 0x00:	goto pp2;
			case '\t':
			case '\n':
			case '\r':
			case ' ':	goto pp6;
			case '!':	goto pp9;
			case '"':	goto pp11;
			case '%':	goto pp12;
			case '&':	goto pp14;
			case '\'':	goto pp16;
			case '(':	goto pp17;
			case ')':	goto pp19;
			case '*':	goto pp21;
			case '+':	goto pp23;
			case ',':	goto pp25;
			case '-':	goto pp27;
			case '.':	goto pp29;
			case '/':	goto pp31;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto pp33;
			case ':':	goto pp36;
			case '<':	goto pp38;
			case '=':	goto pp40;
			case '>':	goto pp42;
			case '?':	goto pp44;
			case '@':	goto pp45;
			case 'A':
			case 'a':	goto pp46;
			case 'B':
			case 'b':	goto pp48;
			case 'C':
			case 'c':	goto pp49;
			case 'D':
			case 'd':	goto pp50;
			case 'E':
			case 'e':	goto pp51;
			case 'F':
			case 'f':	goto pp52;
			case 'G':
			case 'g':	goto pp53;
			case 'H':
			case 'h':	goto pp55;
			case 'I':
			case 'i':	goto pp56;
			case 'J':
			case 'j':	goto pp57;
			case 'K':
			case 'M':
			case 'P':
			case 'Q':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'k':
			case 'm':
			case 'p':
			case 'q':
			case 'y':
			case 'z':	goto pp58;
			case 'L':
			case 'l':	goto pp60;
			case 'N':
			case 'n':	goto pp61;
			case 'O':
			case 'o':	goto pp62;
			case 'R':
			case 'r':	goto pp63;
			case 'S':
			case 's':	goto pp64;
			case 'T':
			case 't':	goto pp65;
			case 'U':
			case 'u':	goto pp66;
			case 'V':
			case 'v':	goto pp67;
			case 'W':
			case 'w':	goto pp68;
			case '[':	goto pp69;
			case '\\':	goto pp70;
			case '^':	goto pp71;
			case 'x':	goto pp73;
			case '{':	goto pp75;
			case '|':	goto pp76;
			case '~':	goto pp78;
			default:	goto pp4;
			}
pp2:
			++PPCURSOR;
			{
			status = PHQL_SCANNER_RETCODE_EOF;
			break;
		}
pp4:
			++PPCURSOR;
pp5:
			{
			status = PHQL_SCANNER_RETCODE_ERR;
			break;
		}
pp6:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '\t':
			case '\n':
			case '\r':
			case ' ':	goto pp6;
			default:	goto pp8;
			}
pp8:
			{
			token->opcode = PHQL_T_IGNORE;
			return 0;
		}
pp9:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '!':	goto pp80;
			case '=':	goto pp82;
			default:	goto pp10;
			}
pp10:
			{
			token->opcode = PHQL_T_NOT;
			return 0;
		}
pp11:
			ppaccept = 0;
			ppch = *(PPMARKER = ++PPCURSOR);
			if (ppch <= 0x00) goto pp5;
			goto pp85;
pp12:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_MOD;
			return 0;
		}
pp14:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '&':	goto pp90;
			default:	goto pp15;
			}
pp15:
			{
			token->opcode = PHQL_T_BITWISE_AND;
			return 0;
		}
pp16:
			ppaccept = 0;
			ppch = *(PPMARKER = ++PPCURSOR);
			if (ppch <= 0x00) goto pp5;
			goto pp93;
pp17:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_PARENTHESES_OPEN;
			return 0;
		}
pp19:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_PARENTHESES_CLOSE;
			return 0;
		}
pp21:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_MUL;
			return 0;
		}
pp23:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_ADD;
			return 0;
		}
pp25:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_COMMA;
			return 0;
		}
pp27:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_SUB;
			return 0;
		}
pp29:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto pp95;
			default:	goto pp30;
			}
pp30:
			{
			token->opcode = PHQL_T_DOT;
			return 0;
		}
pp31:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_DIV;
			return 0;
		}
pp33:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '.':	goto pp95;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto pp33;
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'x':	goto pp98;
			default:	goto pp35;
			}
pp35:
			{
			token->opcode = PHQL_T_INTEGER;
			token->value = estrndup(q, PPCURSOR - q);
			token->len = PPCURSOR - q;
			q = PPCURSOR;
			return 0;
		}
pp36:
			ppaccept = 1;
			ppch = *(PPMARKER = ++PPCURSOR);
			switch (ppch) {
			case '-':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp100;
			default:	goto pp37;
			}
pp37:
			{
			token->opcode = PHQL_T_COLON;
			return 0;
		}
pp38:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '=':	goto pp102;
			case '>':	goto pp104;
			default:	goto pp39;
			}
pp39:
			{
			token->opcode = PHQL_T_LESS;
			return 0;
		}
pp40:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_EQUALS;
			return 0;
		}
pp42:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '=':	goto pp106;
			default:	goto pp43;
			}
pp43:
			{
			token->opcode = PHQL_T_GREATER;
			return 0;
		}
pp44:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto pp108;
			default:	goto pp5;
			}
pp45:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '>':	goto pp111;
			case '@':	goto pp113;
			default:	goto pp5;
			}
pp46:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'G':
			case 'g':	goto pp115;
			case 'L':
			case 'l':	goto pp116;
			case 'N':
			case 'n':	goto pp117;
			case 'S':
			case 's':	goto pp118;
			default:	goto pp74;
			}
pp47:
			{
			token->value = estrndup(q, PPCURSOR - q);
			token->len = PPCURSOR - q;
			if (token->len > 2 && !memcmp(token->value, "0x", 2)) {
				token->opcode = PHQL_T_HINTEGER;
			} else {
				int i, alpha = 0;
				for (i = 0; i < token->len; i++) {
					unsigned char ch = token->value[i];
					if (!((ch >= '0') && (ch <= '9'))) {
						alpha = 1;
						break;
					}
				}
				if (alpha) {
					token->opcode = PHQL_T_IDENTIFIER;
				} else {
					token->opcode = PHQL_T_INTEGER;
				}
			}
			q = PPCURSOR;
			return 0;
		}
pp48:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp120;
			case 'Y':
			case 'y':	goto pp121;
			default:	goto pp74;
			}
pp49:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'A':
			case 'a':	goto pp123;
			case 'O':
			case 'o':	goto pp124;
			case 'R':
			case 'r':	goto pp125;
			default:	goto pp74;
			}
pp50:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp126;
			case 'I':
			case 'i':	goto pp127;
			default:	goto pp74;
			}
pp51:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp128;
			case 'N':
			case 'n':	goto pp129;
			case 'X':	goto pp130;
			case 'x':	goto pp131;
			default:	goto pp74;
			}
pp52:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'A':
			case 'a':	goto pp132;
			case 'O':
			case 'o':	goto pp133;
			case 'R':
			case 'r':	goto pp134;
			case 'U':
			case 'u':	goto pp135;
			default:	goto pp74;
			}
pp53:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'R':
			case 'r':	goto pp136;
			default:	goto pp59;
			}
pp54:
			{
			token->opcode = PHQL_T_IDENTIFIER;
			if ((PPCURSOR - q) > 1) {
				if (q[0] == '\\') {
					token->value = estrndup(q + 1, PPCURSOR - q - 1);
					token->len = PPCURSOR - q - 1;
				} else {
					token->value = estrndup(q, PPCURSOR - q);
					token->len = PPCURSOR - q;
				}
			} else {
				token->value = estrndup(q, PPCURSOR - q);
				token->len = PPCURSOR - q;
			}
			q = PPCURSOR;
			return 0;
		}
pp55:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'A':
			case 'a':	goto pp137;
			default:	goto pp59;
			}
pp56:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp138;
			case 'N':
			case 'n':	goto pp139;
			case 'S':
			case 's':	goto pp141;
			default:	goto pp59;
			}
pp57:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'O':
			case 'o':	goto pp143;
			default:	goto pp59;
			}
pp58:
			ppch = *++PPCURSOR;
pp59:
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp54;
			}
pp60:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp144;
			case 'I':
			case 'i':	goto pp145;
			default:	goto pp59;
			}
pp61:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'O':
			case 'o':	goto pp146;
			case 'U':
			case 'u':	goto pp147;
			default:	goto pp59;
			}
pp62:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'F':
			case 'f':	goto pp148;
			case 'N':
			case 'n':	goto pp149;
			case 'R':
			case 'r':	goto pp151;
			case 'U':
			case 'u':	goto pp153;
			default:	goto pp59;
			}
pp63:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp154;
			default:	goto pp59;
			}
pp64:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp155;
			default:	goto pp59;
			}
pp65:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'H':
			case 'h':	goto pp156;
			case 'R':
			case 'r':	goto pp157;
			default:	goto pp59;
			}
pp66:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'P':
			case 'p':	goto pp158;
			case 'S':
			case 's':	goto pp159;
			default:	goto pp59;
			}
pp67:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'A':
			case 'a':	goto pp160;
			default:	goto pp59;
			}
pp68:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'H':
			case 'h':	goto pp161;
			case 'I':
			case 'i':	goto pp162;
			default:	goto pp59;
			}
pp69:
			ppaccept = 0;
			ppch = *(PPMARKER = ++PPCURSOR);
			switch (ppch) {
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp163;
			default:	goto pp5;
			}
pp70:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp5;
			}
pp71:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_BITWISE_XOR;
			return 0;
		}
pp73:
			ppch = *++PPCURSOR;
pp74:
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'x':	goto pp73;
			case ':':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp47;
			}
pp75:
			ppaccept = 0;
			ppch = *(PPMARKER = ++PPCURSOR);
			switch (ppch) {
			case '-':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp165;
			default:	goto pp5;
			}
pp76:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '|':	goto pp167;
			default:	goto pp77;
			}
pp77:
			{
			token->opcode = PHQL_T_BITWISE_OR;
			return 0;
		}
pp78:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_BITWISE_NOT;
			return 0;
		}
pp80:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_TS_NEGATE;
			return 0;
		}
pp82:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_NOTEQUALS;
			return 0;
		}
pp84:
			ppch = *++PPCURSOR;
pp85:
			switch (ppch) {
			case 0x00:	goto pp86;
			case '"':	goto pp87;
			case '\\':	goto pp89;
			default:	goto pp84;
			}
pp86:
			PPCURSOR = PPMARKER;
			switch (ppaccept) {
			case 0: 	goto pp5;
			case 1: 	goto pp37;
			default:	goto pp205;
			}
pp87:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_STRING;
			token->value = estrndup(q, PPCURSOR - q - 1);
			token->len = PPCURSOR - q - 1;
			q = PPCURSOR;
			return 0;
		}
pp89:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '\n':	goto pp86;
			default:	goto pp84;
			}
pp90:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_TS_AND;
			return 0;
		}
pp92:
			ppch = *++PPCURSOR;
pp93:
			switch (ppch) {
			case 0x00:	goto pp86;
			case '\'':	goto pp87;
			case '\\':	goto pp94;
			default:	goto pp92;
			}
pp94:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '\n':	goto pp86;
			default:	goto pp92;
			}
pp95:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto pp95;
			default:	goto pp97;
			}
pp97:
			{
			token->opcode = PHQL_T_DOUBLE;
			token->value = estrndup(q, PPCURSOR - q);
			token->len = PPCURSOR - q;
			q = PPCURSOR;
			return 0;
		}
pp98:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'x':	goto pp98;
			default:	goto pp47;
			}
pp100:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '-':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp100;
			case ':':	goto pp169;
			default:	goto pp86;
			}
pp102:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_LESSEQUAL;
			return 0;
		}
pp104:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_NOTEQUALS;
			return 0;
		}
pp106:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_GREATEREQUAL;
			return 0;
		}
pp108:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto pp108;
			default:	goto pp110;
			}
pp110:
			{
			token->opcode = PHQL_T_NPLACEHOLDER;
			token->value = estrndup(q, PPCURSOR - q);
			token->len = PPCURSOR - q;
			q = PPCURSOR;
			return 0;
		}
pp111:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_TS_CONTAINS_ANOTHER;
			return 0;
		}
pp113:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_TS_MATCHES;
			return 0;
		}
pp115:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'A':
			case 'a':	goto pp171;
			default:	goto pp59;
			}
pp116:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp172;
			default:	goto pp59;
			}
pp117:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'D':
			case 'd':	goto pp174;
			default:	goto pp59;
			}
pp118:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			case 'C':
			case 'c':	goto pp176;
			default:	goto pp119;
			}
pp119:
			{
			token->opcode = PHQL_T_AS;
			return 0;
		}
pp120:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp178;
			default:	goto pp74;
			}
pp121:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp122;
			}
pp122:
			{
			token->opcode = PHQL_T_BY;
			return 0;
		}
pp123:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp179;
			default:	goto pp74;
			}
pp124:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp180;
			default:	goto pp59;
			}
pp125:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'O':
			case 'o':	goto pp181;
			default:	goto pp59;
			}
pp126:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp182;
			case 'S':
			case 's':	goto pp183;
			default:	goto pp74;
			}
pp127:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp184;
			default:	goto pp59;
			}
pp128:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp185;
			default:	goto pp59;
			}
pp129:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'D':
			case 'd':	goto pp186;
			default:	goto pp59;
			}
pp130:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp188;
			default:	goto pp59;
			}
pp131:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp188;
			default:	goto pp74;
			}
pp132:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp189;
			default:	goto pp74;
			}
pp133:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'R':
			case 'r':	goto pp190;
			default:	goto pp59;
			}
pp134:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'O':
			case 'o':	goto pp192;
			default:	goto pp59;
			}
pp135:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp193;
			default:	goto pp59;
			}
pp136:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'O':
			case 'o':	goto pp194;
			default:	goto pp59;
			}
pp137:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'V':
			case 'v':	goto pp195;
			default:	goto pp59;
			}
pp138:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp196;
			default:	goto pp59;
			}
pp139:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			case 'N':
			case 'n':	goto pp197;
			case 'S':
			case 's':	goto pp198;
			case 'T':
			case 't':	goto pp199;
			default:	goto pp140;
			}
pp140:
			{
			token->opcode = PHQL_T_IN;
			return 0;
		}
pp141:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp142;
			}
pp142:
			{
			token->opcode = PHQL_T_IS;
			return 0;
		}
pp143:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp200;
			default:	goto pp59;
			}
pp144:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'F':
			case 'f':	goto pp201;
			default:	goto pp59;
			}
pp145:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'K':
			case 'k':	goto pp202;
			case 'M':
			case 'm':	goto pp203;
			default:	goto pp59;
			}
pp146:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp204;
			default:	goto pp59;
			}
pp147:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp206;
			default:	goto pp59;
			}
pp148:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'F':
			case 'f':	goto pp207;
			default:	goto pp59;
			}
pp149:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp150;
			}
pp150:
			{
			token->opcode = PHQL_T_ON;
			return 0;
		}
pp151:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			case 'D':
			case 'd':	goto pp208;
			default:	goto pp152;
			}
pp152:
			{
			token->opcode = PHQL_T_OR;
			return 0;
		}
pp153:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp209;
			default:	goto pp59;
			}
pp154:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'G':
			case 'g':	goto pp210;
			default:	goto pp59;
			}
pp155:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp211;
			case 'T':
			case 't':	goto pp212;
			default:	goto pp59;
			}
pp156:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp214;
			default:	goto pp59;
			}
pp157:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'U':
			case 'u':	goto pp215;
			default:	goto pp59;
			}
pp158:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'D':
			case 'd':	goto pp216;
			default:	goto pp59;
			}
pp159:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp217;
			default:	goto pp59;
			}
pp160:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp218;
			default:	goto pp59;
			}
pp161:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp219;
			default:	goto pp59;
			}
pp162:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp220;
			default:	goto pp59;
			}
pp163:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp163;
			case ']':	goto pp221;
			default:	goto pp86;
			}
pp165:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '-':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp165;
			case '}':	goto pp223;
			default:	goto pp86;
			}
pp167:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_TS_OR;
			return 0;
		}
pp169:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_SPLACEHOLDER;
			token->value = estrndup(q, PPCURSOR - q - 1);
			token->len = PPCURSOR - q - 1;
			q = PPCURSOR;
			return 0;
		}
pp171:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp225;
			default:	goto pp59;
			}
pp172:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp173;
			}
pp173:
			{
			token->opcode = PHQL_T_ALL;
			return 0;
		}
pp174:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp175;
			}
pp175:
			{
			token->opcode = PHQL_T_AND;
			return 0;
		}
pp176:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp177;
			}
pp177:
			{
			token->opcode = PHQL_T_ASC;
			return 0;
		}
pp178:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'W':
			case 'w':	goto pp226;
			default:	goto pp59;
			}
pp179:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp227;
			case 'T':
			case 't':	goto pp229;
			default:	goto pp59;
			}
pp180:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'V':
			case 'v':	goto pp231;
			default:	goto pp59;
			}
pp181:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp232;
			default:	goto pp59;
			}
pp182:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp233;
			default:	goto pp59;
			}
pp183:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'C':
			case 'c':	goto pp234;
			default:	goto pp59;
			}
pp184:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp236;
			default:	goto pp59;
			}
pp185:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp237;
			default:	goto pp59;
			}
pp186:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp187;
			}
pp187:
			{
			token->opcode = PHQL_T_END;
			return 0;
		}
pp188:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp239;
			default:	goto pp59;
			}
pp189:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp240;
			default:	goto pp59;
			}
pp190:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp191;
			}
pp191:
			{
			token->opcode = PHQL_T_FOR;
			return 0;
		}
pp192:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'M':
			case 'm':	goto pp241;
			default:	goto pp59;
			}
pp193:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp243;
			default:	goto pp59;
			}
pp194:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'U':
			case 'u':	goto pp245;
			default:	goto pp59;
			}
pp195:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp246;
			default:	goto pp59;
			}
pp196:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'K':
			case 'k':	goto pp247;
			default:	goto pp59;
			}
pp197:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp248;
			default:	goto pp59;
			}
pp198:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp249;
			default:	goto pp59;
			}
pp199:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'O':
			case 'o':	goto pp250;
			default:	goto pp59;
			}
pp200:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp252;
			default:	goto pp59;
			}
pp201:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp254;
			default:	goto pp59;
			}
pp202:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp256;
			default:	goto pp59;
			}
pp203:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp258;
			default:	goto pp59;
			}
pp204:
			ppaccept = 2;
			ppch = *(PPMARKER = ++PPCURSOR);
			switch (ppch) {
			case ' ':	goto pp259;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp205;
			}
pp205:
			{
			token->opcode = PHQL_T_NOT;
			return 0;
		}
pp206:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'L':
			case 'l':	goto pp260;
			default:	goto pp59;
			}
pp207:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp262;
			default:	goto pp59;
			}
pp208:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp263;
			default:	goto pp59;
			}
pp209:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp264;
			default:	goto pp59;
			}
pp210:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'H':
			case 'h':	goto pp265;
			default:	goto pp59;
			}
pp211:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp266;
			default:	goto pp59;
			}
pp212:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp213;
			}
pp213:
			{
			token->opcode = PHQL_T_SET;
			return 0;
		}
pp214:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp267;
			default:	goto pp59;
			}
pp215:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp269;
			default:	goto pp59;
			}
pp216:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'A':
			case 'a':	goto pp271;
			default:	goto pp59;
			}
pp217:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp272;
			default:	goto pp59;
			}
pp218:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'U':
			case 'u':	goto pp273;
			default:	goto pp59;
			}
pp219:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp274;
			case 'R':
			case 'r':	goto pp276;
			default:	goto pp59;
			}
pp220:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'H':
			case 'h':	goto pp277;
			default:	goto pp59;
			}
pp221:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_IDENTIFIER;
			token->value = estrndup(q, PPCURSOR - q - 1);
			token->len = PPCURSOR - q - 1;
			q = PPCURSOR;
			return 0;
		}
pp223:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_BPLACEHOLDER;
			token->value = estrndup(q, PPCURSOR - q - 1);
			token->len = PPCURSOR - q - 1;
			q = PPCURSOR;
			return 0;
		}
pp225:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp279;
			default:	goto pp59;
			}
pp226:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp280;
			default:	goto pp59;
			}
pp227:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp228;
			}
pp228:
			{
			token->opcode = PHQL_T_CASE;
			return 0;
		}
pp229:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp230;
			}
pp230:
			{
			token->opcode = PHQL_T_CAST;
			return 0;
		}
pp231:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp281;
			default:	goto pp59;
			}
pp232:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp282;
			default:	goto pp59;
			}
pp233:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp284;
			default:	goto pp59;
			}
pp234:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp235;
			}
pp235:
			{
			token->opcode = PHQL_T_DESC;
			return 0;
		}
pp236:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'I':
			case 'i':	goto pp285;
			default:	goto pp59;
			}
pp237:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp238;
			}
pp238:
			{
			token->opcode = PHQL_T_ELSE;
			return 0;
		}
pp239:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp286;
			default:	goto pp59;
			}
pp240:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp287;
			default:	goto pp59;
			}
pp241:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp242;
			}
pp242:
			{
			token->opcode = PHQL_T_FROM;
			return 0;
		}
pp243:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp244;
			}
pp244:
			{
			token->opcode = PHQL_T_FULL;
			return 0;
		}
pp245:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'P':
			case 'p':	goto pp289;
			default:	goto pp59;
			}
pp246:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp291;
			default:	goto pp59;
			}
pp247:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp292;
			default:	goto pp59;
			}
pp248:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'R':
			case 'r':	goto pp294;
			default:	goto pp59;
			}
pp249:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'R':
			case 'r':	goto pp296;
			default:	goto pp59;
			}
pp250:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp251;
			}
pp251:
			{
			token->opcode = PHQL_T_INTO;
			return 0;
		}
pp252:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp253;
			}
pp253:
			{
			token->opcode = PHQL_T_JOIN;
			return 0;
		}
pp254:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp255;
			}
pp255:
			{
			token->opcode = PHQL_T_LEFT;
			return 0;
		}
pp256:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp257;
			}
pp257:
			{
			token->opcode = PHQL_T_LIKE;
			return 0;
		}
pp258:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp297;
			default:	goto pp59;
			}
pp259:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'B':
			case 'b':	goto pp299;
			default:	goto pp86;
			}
pp260:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp261;
			}
pp261:
			{
			token->opcode = PHQL_T_NULL;
			return 0;
		}
pp262:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp300;
			default:	goto pp59;
			}
pp263:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'R':
			case 'r':	goto pp301;
			default:	goto pp59;
			}
pp264:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'R':
			case 'r':	goto pp303;
			default:	goto pp59;
			}
pp265:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp305;
			default:	goto pp59;
			}
pp266:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'C':
			case 'c':	goto pp307;
			default:	goto pp59;
			}
pp267:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp268;
			}
pp268:
			{
			token->opcode = PHQL_T_THEN;
			return 0;
		}
pp269:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp270;
			}
pp270:
			{
			token->opcode = PHQL_T_TRUE;
			return 0;
		}
pp271:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp308;
			default:	goto pp59;
			}
pp272:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'G':
			case 'g':	goto pp309;
			default:	goto pp59;
			}
pp273:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp311;
			default:	goto pp59;
			}
pp274:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp275;
			}
pp275:
			{
			token->opcode = PHQL_T_WHEN;
			return 0;
		}
pp276:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp312;
			default:	goto pp59;
			}
pp277:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp278;
			}
pp278:
			{
			token->opcode = PHQL_T_WITH;
			return 0;
		}
pp279:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp314;
			default:	goto pp59;
			}
pp280:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp315;
			default:	goto pp59;
			}
pp281:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'R':
			case 'r':	goto pp316;
			default:	goto pp59;
			}
pp282:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp283;
			}
pp283:
			{
			token->opcode = PHQL_T_CROSS;
			return 0;
		}
pp284:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp317;
			default:	goto pp59;
			}
pp285:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp319;
			default:	goto pp59;
			}
pp286:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp320;
			default:	goto pp59;
			}
pp287:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp288;
			}
pp288:
			{
			token->opcode = PHQL_T_FALSE;
			return 0;
		}
pp289:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp290;
			}
pp290:
			{
			token->opcode = PHQL_T_GROUP;
			return 0;
		}
pp291:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'G':
			case 'g':	goto pp322;
			default:	goto pp59;
			}
pp292:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp293;
			}
pp293:
			{
			token->opcode = PHQL_T_ILIKE;
			return 0;
		}
pp294:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp295;
			}
pp295:
			{
			token->opcode = PHQL_T_INNER;
			return 0;
		}
pp296:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp324;
			default:	goto pp59;
			}
pp297:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp298;
			}
pp298:
			{
			token->opcode = PHQL_T_LIMIT;
			return 0;
		}
pp299:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp326;
			default:	goto pp86;
			}
pp300:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp327;
			default:	goto pp59;
			}
pp301:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp302;
			}
pp302:
			{
			token->opcode = PHQL_T_ORDER;
			return 0;
		}
pp303:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp304;
			}
pp304:
			{
			token->opcode = PHQL_T_OUTER;
			return 0;
		}
pp305:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp306;
			}
pp306:
			{
			token->opcode = PHQL_T_RIGHT;
			return 0;
		}
pp307:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp329;
			default:	goto pp59;
			}
pp308:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp331;
			default:	goto pp59;
			}
pp309:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp310;
			}
pp310:
			{
			token->opcode = PHQL_T_USING;
			return 0;
		}
pp311:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'S':
			case 's':	goto pp333;
			default:	goto pp59;
			}
pp312:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp313;
			}
pp313:
			{
			token->opcode = PHQL_T_WHERE;
			return 0;
		}
pp314:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp335;
			default:	goto pp59;
			}
pp315:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp337;
			default:	goto pp59;
			}
pp316:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp339;
			default:	goto pp59;
			}
pp317:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp318;
			}
pp318:
			{
			token->opcode = PHQL_T_DELETE;
			return 0;
		}
pp319:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'C':
			case 'c':	goto pp341;
			default:	goto pp59;
			}
pp320:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp321;
			}
pp321:
			{
			token->opcode = PHQL_T_EXISTS;
			return 0;
		}
pp322:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp323;
			}
pp323:
			{
			token->opcode = PHQL_T_HAVING;
			return 0;
		}
pp324:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp325;
			}
pp325:
			{
			token->opcode = PHQL_T_INSERT;
			return 0;
		}
pp326:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp342;
			default:	goto pp86;
			}
pp327:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp328;
			}
pp328:
			{
			token->opcode = PHQL_T_OFFSET;
			return 0;
		}
pp329:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp330;
			}
pp330:
			{
			token->opcode = PHQL_T_SELECT;
			return 0;
		}
pp331:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp332;
			}
pp332:
			{
			token->opcode = PHQL_T_UPDATE;
			return 0;
		}
pp333:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp334;
			}
pp334:
			{
			token->opcode = PHQL_T_VALUES;
			return 0;
		}
pp335:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp336;
			}
pp336:
			{
			token->opcode = PHQL_T_AGAINST;
			return 0;
		}
pp337:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp338;
			}
pp338:
			{
			token->opcode = PHQL_T_BETWEEN;
			return 0;
		}
pp339:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp340;
			}
pp340:
			{
			token->opcode = PHQL_T_CONVERT;
			return 0;
		}
pp341:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'T':
			case 't':	goto pp343;
			default:	goto pp59;
			}
pp342:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'W':
			case 'w':	goto pp345;
			default:	goto pp86;
			}
pp343:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto pp58;
			default:	goto pp344;
			}
pp344:
			{
			token->opcode = PHQL_T_DISTINCT;
			return 0;
		}
pp345:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp346;
			default:	goto pp86;
			}
pp346:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'E':
			case 'e':	goto pp347;
			default:	goto pp86;
			}
pp347:
			ppch = *++PPCURSOR;
			switch (ppch) {
			case 'N':
			case 'n':	goto pp348;
			default:	goto pp86;
			}
pp348:
			++PPCURSOR;
			{
			token->opcode = PHQL_T_BETWEEN_NOT;
			return 0;
		}
		}

	}

	return status;
}
