# Build Directory

This directory contains:

* Tools to build Phalcon extension from source - they are located in the current directory
* Copied, merged and optimized Phalcon source files, which are used during the build - they are located in
  `<php-version>/safe`, `<php-version>/32bits` and `<php-version>/64bits` directories
* Resources for build process (config files and source code of build generator) - they are located in
  `_resources` directories
* Tool to re-generate copied Phalcon source files according to the main source files - that is `gen-build.php` script


## Preparing source code to be built

You can omit this step, if you've got source code for stable Phalcon version. Everything is up-to-date there.

The source code, used to build Phalcon extension, is not the actual code, being developed. When preparing to build
Phalcon extension, `gen-build.php` script needs to be executed. It copies, merges and slightly optimizes all the
sources, putting them into `<php-version>/safe`, `<php-version>/32bits` and `<php-version>/64bits` directories.

The algorithm of `gen-build.php` is as follows:

* Walk through all the code in `<phalcon_root>/ext/` directory
* Merge all the found files and copy them into `<php-version>/safe` directory
* Pre-calculate hashes for 32 bit PHP and 64 bit PHP and put optimized sources into corresponding
  `<php-version>/32bits` and `<php-version>/64bits` directories
* Copy Linux and Windows build configs from to build directories

After those manipulations, any of the build directories contain full code, which can be used to build Phalcon.
The differences of the directories are:

* `<php-version>/safe` directory contain source code to build Phalcon for any PHP - either 32 bit or 64 bit
* `<php-version>/32bits` directory contain slightly optimized source code to build Phalcon for 32 bit PHP,
  it will not work properly with 64 bit PHP
* `<php-version>/64bits` directory contain slightly optimized source code to build Phalcon for 64 bit PHP,
  it will not work properly with 32 bit PHP

Run `gen-build.php`, if you're working with development version of Phalcon sources and want to rebuild the extension.
Running the tool for stable version of Phalcon sources will not do anything new, because build directories are
regenerated by Phalcon team for every stable release.

The tool requires PHP 5.5+ to regenerate `<php-version>/safe` directory. Additionally, installed Phalcon extension is
needed to regenerate `<php-version>/32bits` and `<php-version>/64bits` directories.

After running `gen-build.php` you are ready to build Phalcon extension.


## Building extension for Linux

Please, refer to [Phalcon documentation](https://phalcon.link/docs)


## Building extension for Windows

Please, refer to [Phalcon Internals documentation](https://internals.phalconphp.com)
