<?php
declare(strict_types=1);

/**
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalconphp.com>
 *
 * For the full copyright and license information, please view the LICENSE.txt
 * file that was distributed with this source code.
 */

namespace Phalcon\Test\Unit\Events\Event;

use Phalcon\Events\Event;
use UnitTester;

class SetTypeCest
{
    /**
     * Tests Phalcon\Events\Event :: setType()
     *
     * @author Sid Roberts <https://github.com/SidRoberts>
     * @since  2019-05-20
     */
    public function eventsEventSetType(UnitTester $I)
    {
        $I->wantToTest('Events\Event - setType()');

        $event = new Event(
            'some-type:beforeSome',
            $this,
            []
        );

        $newType = 'some-type:afterSome';

        $event->setType($newType);

        $I->assertEquals(
            $newType,
            $event->getType()
        );
    }
}
