
/**
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalconphp.com>
 *
 * For the full copyright and license information, please view the LICENSE.txt
 * file that was distributed with this source code.
 */

namespace Phalcon\Filter;

/**
 * Lazy loads, stores and exposes sanitizer objects
 */
interface FilterInterface
{
    /**
     * Sanitizes a value with a specified single or set of sanitizers
     */
    public function sanitize(var value, var sanitizers, bool noRecursive = false) -> var;
}
