/*  xbasenew.cpp

   Create Xbase DBF file with no records (just header)

   Copyright (C) 1998,1999 Piotr Klaban
   email - makler@man.torun.pl

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   V 0.9   Feb 26, 1998   - Start working on the program
   V 1.0   Sep 21, 1999   - field name need to be <= 10 chars long
 */

#include <iostream.h>
#include <string>
#ifdef LINUX
 #ifndef _XOPEN_SOURCE
 # define _XOPEN_SOURCE
 #endif
 #include <unistd.h>
#endif
#include <xbase.h>
#include <strings.h>
#include "xbase2pg.hh"

/* set the stack large for dos compiles */
#ifdef DOS
#include <stdio.h>
extern unsigned _stklen = 100000;
#endif

int verbose = 0, upper = 0, lower = 0, create = 0, clear = 0, begin = -1,
  end = -1, fieldlower = 0, fieldupper = 0, be_quiet = 0, overlay = XB_DONTOVERLAY;
char *subarg = NULL;
xbShort tableDesc (const char * table);
int WriteRecs (const char	 * query);
int rc;
void usage (void);

void
usage (void)
{
	cerr << "xbasenew (pg2xbase v" << PG2XBASE_VERSION << ")" << endl <<
		"usage:\txbasenew [-C name[:len]] [-D name] [-F name[:dec]]" << endl <<
		"\t\t[-L name] [-M name] [-N name[:dec]] [-V {3|4}] dbf-file" << endl;
}

class TabFields
{
	Point_to_Mem < xbSchema > Sc;
	xbShort TabSize;
	xbShort LastElem;
	  public:
	  TabFields (int r):Sc (r + 1)
	{
		TabSize = r + 1;
		LastElem = 0;
		for (register int i = 0 ; i < TabSize ; ++i ) {
			memset(&Sc[i],0,sizeof(Sc[i]));
		}
	}
	xbShort AppendField (xbSchema * Field)
	{
		if (LastElem >= (TabSize - 1)) {
			Sc.renew(++TabSize);
			memset(&Sc[TabSize-1],0,sizeof(Sc[0]));
		}
		memcpy (&Sc[LastElem], Field, sizeof (Sc[LastElem]));

		LastElem += 1;
		return 1;
	}
	xbSchema *GetSchema ()
	{
		return Sc;
	}
};

class TabFields *MySchema;
class PgDatabase *PG;
class xbDbf *XbaseFile;

void AddField(char ftype, char *arg)
{
	xbSchema	Field;
	char		*fname;
	char		*p, *q, *r;
	int		fsize, fsizebis;

	Field.NoOfDecs = 0;
	Field.FieldLen = 0;
	fsize = fsizebis = 0;
	fname = arg;

	if (arg != NULL) {
	    if (strlen(arg) > 0) {
		if ((p = index(arg,':')) != NULL) {
		    *p = 0;
		    q = p+1;
		    if (strlen(q) > 0) {
			if ((p = index(q,':')) != NULL) {
			    *p = 0;
			    r = p+1;
			    if (strlen(r) > 0) {
				fsizebis = atoi(r);
			    }
			}
			fsize = atoi(q);
		    }
		}
	    }
	}

	if ((fsize < 0) || (fsizebis < 0)) {
	    cerr << "ERROR: Field length or no. of decs is less than zero" << endl;
	    exit(-3);
	}

	/* If field len is outside of range or is less than
	 * no. of decimal digits xbase library returns an error
	 * but this mey be more descriptive */
	switch (ftype) {
	    case 'C':
		if ((fsize < 0) || (fsize > 254)) {
		    cerr << "ERROR: Char field len " << fsize << " outside of range 0-254" << endl;
		    exit(-3);
		}
		if (!fsize) fsize = 1;
		Field.FieldLen	= (unsigned char) fsize;
		break;
	    case 'D':
		Field.FieldLen	= 8;
		break;
	    case 'F':
		if (!fsize) fsize = 6;
		if (!fsizebis) fsizebis = 15;
		Field.FieldLen	= (unsigned char) fsizebis;
		Field.NoOfDecs	= (unsigned char) fsize;
		if (fsize > fsizebis) {
		    cerr << "ERROR: Float field length is less that no. of decs (" <<
			fsizebis << " < " << fsize << ")" << endl;
		    exit(-3);
		}
		break;
	    case 'L':
		Field.FieldLen	= 1;
		break;
	    case 'M':
		Field.FieldLen	= 10;
		break;
	    case 'N':
		if (fsizebis == 0) fsizebis = 10;
		if (fsize > fsizebis) {
		    cerr << "ERROR: Numeric field length is less that no. of decs (" <<
			fsizebis << " < " << fsize << ")" << endl;
		    exit(-3);
		}
		Field.FieldLen	= (unsigned char) fsizebis;
		Field.NoOfDecs	= (unsigned char) fsize;
		break;
	    default:
		cerr << "ERROR: Field type " << ftype << " unknown" << endl;
		exit(-2);
	}
	Field.Type = ftype;
	if (strlen (fname) >= 11)
	    fname[10] = '\0';
	strcpy (Field.FieldName, fname);
	MySchema->AppendField (&Field);
}

int
main (int argc, char ** argv)
{
	char *oarg, *dbfname;
	extern int optind;
	extern char *optarg;
	xbShort dbfversion = DEF_DBF_VERSION; /* 3 or 4 */
	xbShort rc;
	int i;

	if (!MySchema)
		MySchema = new TabFields (1);

	while ((i = getopt (argc, argv, "C:D:F:L:M:N:OV:")) != EOF)
	  {
		  switch (i)
		    {
		    case 'C':
		    case 'D':
		    case 'F':
		    case 'L':
		    case 'M':
		    case 'N':
#ifndef XB_MEMO_FLD
			    if (i == 'M') {
				cerr << "Memo field type is not supported" << endl;
			    }
#endif
			    oarg = strdup(optarg);
			    AddField(i,oarg);
			    free(oarg);
			    break;
		    case 'O':
			    overlay = 1;
			    break;
		    case 'V':
			    dbfversion = atoi (optarg);
			    break;
		    case '?':
			    usage ();
			    cerr << "Unknown argument: " << argv[0] << endl;
			    exit (1);
		    default:
			    break;
		    }
	  }

	argc -= optind;
	argv = &argv[optind];

	if (argc != 1)
	  {
		  usage ();
		  exit (1);
	  }

	dbfname = argv[0];

		  xbXBase x;
		  xbDbf DBFtemp (&x);
		  XbaseFile = &DBFtemp;
		  XbaseFile->SetVersion (dbfversion);

		    rc = XbaseFile->CreateDatabase (dbfname, MySchema->GetSchema (), (xbShort) overlay);

		  if (rc != XB_NO_ERROR)
		    {
			    cout << "ERROR: opening " << dbfname << ": "; x.DisplayError(rc);
		    }
		  else
		    {
		  	    XbaseFile->DumpHeader(3);
			    XbaseFile->CloseDatabase ();	/* Close database and associated indexes */
		    }

		  delete MySchema;

	return rc;
}

