/* -*- pftp-c -*- */
#ifndef TAB_LIST_H
#define TAB_LIST_H

typedef struct tab_list_s *tab_list_t;
typedef struct tab_item_s *tab_item_t;

/* Add item last in list */
void add_item(tab_list_t list, const char *match, size_t match_len);
/* Add item last in list */
void add_item2(tab_list_t list, tab_item_t item);
/* Allocate and prepare a new list */
tab_list_t init_list(void);
/* Free list and all it's items */
void free_list(tab_list_t list);
/* Return length of list (cached so fast) */
size_t len_list(tab_list_t list);
/* Return first item in list (NULL if there isn't any) */
tab_item_t get_first(tab_list_t list);
/* Return next item in list (NULL if there isn't any) */
tab_item_t get_nextitem(tab_item_t item);
/* Returns data in items */
const char *get_match(tab_item_t item);
size_t get_matchlen(tab_item_t item);
void get_matchdata(tab_item_t item, char **match, size_t *len);
/* Remove item from list, item will be set to next item. 
   (NULL if it were the last) */
void remove_listitem(tab_list_t list, tab_item_t *item);
/* Move all items from src to dest. Init's dest and free:s src */
void move_list(tab_list_t *dest, tab_list_t src);

#endif /* TAB_LIST_H */
