#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/fortranimpl.h"
/* dt.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(PetscFortranAddr *)(a))
#define PetscFromPointer(a) (PetscFortranAddr)(a)
#define PetscRmPointer(a)
#endif

#include "petscdt.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadraturecreate_ PETSCQUADRATURECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadraturecreate_ petscquadraturecreate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadratureduplicate_ PETSCQUADRATUREDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadratureduplicate_ petscquadratureduplicate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadraturedestroy_ PETSCQUADRATUREDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadraturedestroy_ petscquadraturedestroy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadraturegetorder_ PETSCQUADRATUREGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadraturegetorder_ petscquadraturegetorder
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadraturesetorder_ PETSCQUADRATURESETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadraturesetorder_ petscquadraturesetorder
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadraturegetnumcomponents_ PETSCQUADRATUREGETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadraturegetnumcomponents_ petscquadraturegetnumcomponents
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadraturesetnumcomponents_ PETSCQUADRATURESETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadraturesetnumcomponents_ petscquadraturesetnumcomponents
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscquadraturepushforward_ PETSCQUADRATUREPUSHFORWARD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscquadraturepushforward_ petscquadraturepushforward
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtjacobieval_ PETSCDTJACOBIEVAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtjacobieval_ petscdtjacobieval
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtlegendreeval_ PETSCDTLEGENDREEVAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtlegendreeval_ petscdtlegendreeval
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtgaussjacobiquadrature_ PETSCDTGAUSSJACOBIQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtgaussjacobiquadrature_ petscdtgaussjacobiquadrature
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtgausslobattojacobiquadrature_ PETSCDTGAUSSLOBATTOJACOBIQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtgausslobattojacobiquadrature_ petscdtgausslobattojacobiquadrature
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtgaussquadrature_ PETSCDTGAUSSQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtgaussquadrature_ petscdtgaussquadrature
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtgausstensorquadrature_ PETSCDTGAUSSTENSORQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtgausstensorquadrature_ petscdtgausstensorquadrature
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtstroudconicalquadrature_ PETSCDTSTROUDCONICALQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtstroudconicalquadrature_ petscdtstroudconicalquadrature
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdttanhsinhtensorquadrature_ PETSCDTTANHSINHTENSORQUADRATURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdttanhsinhtensorquadrature_ petscdttanhsinhtensorquadrature
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtreconstructpoly_ PETSCDTRECONSTRUCTPOLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtreconstructpoly_ petscdtreconstructpoly
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtindextobary_ PETSCDTINDEXTOBARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtindextobary_ petscdtindextobary
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define petscdtbarytoindex_ PETSCDTBARYTOINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define petscdtbarytoindex_ petscdtbarytoindex
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
PETSC_EXTERN void  petscquadraturecreate_(MPI_Fint * comm,PetscQuadrature *q, int *__ierr){
*__ierr = PetscQuadratureCreate(
	MPI_Comm_f2c(*(comm)),q);
}
PETSC_EXTERN void  petscquadratureduplicate_(PetscQuadrature q,PetscQuadrature *r, int *__ierr){
*__ierr = PetscQuadratureDuplicate(
	(PetscQuadrature)PetscToPointer((q) ),r);
}
PETSC_EXTERN void  petscquadraturedestroy_(PetscQuadrature *q, int *__ierr){
*__ierr = PetscQuadratureDestroy(q);
}
PETSC_EXTERN void  petscquadraturegetorder_(PetscQuadrature q,PetscInt *order, int *__ierr){
*__ierr = PetscQuadratureGetOrder(
	(PetscQuadrature)PetscToPointer((q) ),order);
}
PETSC_EXTERN void  petscquadraturesetorder_(PetscQuadrature q,PetscInt *order, int *__ierr){
*__ierr = PetscQuadratureSetOrder(
	(PetscQuadrature)PetscToPointer((q) ),*order);
}
PETSC_EXTERN void  petscquadraturegetnumcomponents_(PetscQuadrature q,PetscInt *Nc, int *__ierr){
*__ierr = PetscQuadratureGetNumComponents(
	(PetscQuadrature)PetscToPointer((q) ),Nc);
}
PETSC_EXTERN void  petscquadraturesetnumcomponents_(PetscQuadrature q,PetscInt *Nc, int *__ierr){
*__ierr = PetscQuadratureSetNumComponents(
	(PetscQuadrature)PetscToPointer((q) ),*Nc);
}
PETSC_EXTERN void  petscquadraturepushforward_(PetscQuadrature q,PetscInt *imageDim, PetscReal origin[], PetscReal originImage[], PetscReal J[],PetscInt *formDegree,PetscQuadrature *Jinvstarq, int *__ierr){
*__ierr = PetscQuadraturePushForward(
	(PetscQuadrature)PetscToPointer((q) ),*imageDim,origin,originImage,J,*formDegree,Jinvstarq);
}
PETSC_EXTERN void  petscdtjacobieval_(PetscInt *npoints,PetscReal *alpha,PetscReal *beta, PetscReal *points,PetscInt *ndegree, PetscInt *degrees,PetscReal *B,PetscReal *D,PetscReal *D2, int *__ierr){
*__ierr = PetscDTJacobiEval(*npoints,*alpha,*beta,points,*ndegree,degrees,B,D,D2);
}
PETSC_EXTERN void  petscdtlegendreeval_(PetscInt *npoints, PetscReal *points,PetscInt *ndegree, PetscInt *degrees,PetscReal *B,PetscReal *D,PetscReal *D2, int *__ierr){
*__ierr = PetscDTLegendreEval(*npoints,points,*ndegree,degrees,B,D,D2);
}
PETSC_EXTERN void  petscdtgaussjacobiquadrature_(PetscInt *npoints,PetscReal *a,PetscReal *b,PetscReal *alpha,PetscReal *beta,PetscReal x[],PetscReal w[], int *__ierr){
*__ierr = PetscDTGaussJacobiQuadrature(*npoints,*a,*b,*alpha,*beta,x,w);
}
PETSC_EXTERN void  petscdtgausslobattojacobiquadrature_(PetscInt *npoints,PetscReal *a,PetscReal *b,PetscReal *alpha,PetscReal *beta,PetscReal x[],PetscReal w[], int *__ierr){
*__ierr = PetscDTGaussLobattoJacobiQuadrature(*npoints,*a,*b,*alpha,*beta,x,w);
}
PETSC_EXTERN void  petscdtgaussquadrature_(PetscInt *npoints,PetscReal *a,PetscReal *b,PetscReal *x,PetscReal *w, int *__ierr){
*__ierr = PetscDTGaussQuadrature(*npoints,*a,*b,x,w);
}
PETSC_EXTERN void  petscdtgausstensorquadrature_(PetscInt *dim,PetscInt *Nc,PetscInt *npoints,PetscReal *a,PetscReal *b,PetscQuadrature *q, int *__ierr){
*__ierr = PetscDTGaussTensorQuadrature(*dim,*Nc,*npoints,*a,*b,q);
}
PETSC_EXTERN void  petscdtstroudconicalquadrature_(PetscInt *dim,PetscInt *Nc,PetscInt *npoints,PetscReal *a,PetscReal *b,PetscQuadrature *q, int *__ierr){
*__ierr = PetscDTStroudConicalQuadrature(*dim,*Nc,*npoints,*a,*b,q);
}
PETSC_EXTERN void  petscdttanhsinhtensorquadrature_(PetscInt *dim,PetscInt *level,PetscReal *a,PetscReal *b,PetscQuadrature *q, int *__ierr){
*__ierr = PetscDTTanhSinhTensorQuadrature(*dim,*level,*a,*b,q);
}
PETSC_EXTERN void  petscdtreconstructpoly_(PetscInt *degree,PetscInt *nsource, PetscReal *sourcex,PetscInt *ntarget, PetscReal *targetx,PetscReal *R, int *__ierr){
*__ierr = PetscDTReconstructPoly(*degree,*nsource,sourcex,*ntarget,targetx,R);
}
PETSC_EXTERN void  petscdtindextobary_(PetscInt *len,PetscInt *sum,PetscInt *index,PetscInt coord[], int *__ierr){
*__ierr = PetscDTIndexToBary(*len,*sum,*index,coord);
}
PETSC_EXTERN void  petscdtbarytoindex_(PetscInt *len,PetscInt *sum, PetscInt coord[],PetscInt *index, int *__ierr){
*__ierr = PetscDTBaryToIndex(*len,*sum,coord,index);
}
#if defined(__cplusplus)
}
#endif
