#!/usr/bin/perl -w

use FAlite;
use Getopt::Long;
use strict;

my $usage = <<END
$0 [ -n seq-prefix ] genome-name fasta-file [fasta-file ... ]

name-prefix - the prefix to assign to beginning of sequnce ids (default: read)
genome-name - the name of the genome to put in the fasta headers
fasta-file - (multi) fasta file containing sequences to database

Creates a blastz database file out of a given set of multi fasta file(s) 
containing reads or scaffolds.  The database is output to STDOUT
END
;

my $seq_prefix;
GetOptions("name=s" => \$seq_prefix);
$seq_prefix = "read" unless(defined($seq_prefix));
scalar(@ARGV) > 1 or die $usage;

my $genome_name = shift @ARGV;

#first check if they all are readable before running the long process of reading
#the fasta files
for my $fa_file (@ARGV) {
    open FA, $fa_file or die "Could not open $fa_file for reading.\n";
    close FA;
}

my $read_count = 1;
for my $fa_file (@ARGV) {
    open FA, $fa_file or die "Could not open $fa_file for reading.\n";
    my $fa = new FAlite(\*FA);
    my ($entry, $length);
    while ($entry = $fa->nextEntry) {
        $length = length ($entry->seq);
        print ">$genome_name:$seq_prefix$read_count:1:+:$length\n";
        print $entry->seq."\n";
        $read_count++;
    }
    close FA;
}
