Summary: perl-ipe
Name: perl-ipe
Version: 0.3.1
Release: 1
Group: Applications/System
License: GPL
URL: http://mblab.wustl.edu
Source0: perl-ipe-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: perl-libxml-enno perl-libxml-perl perl-XML-LibXML eval-common
BuildRequires: perl-libxml-enno perl-libxml-perl perl-XML-LibXML
AutoReq: 0
Obsoletes: ipe

%ifarch x86_64
    %define libdir /usr/lib64
%else
    %define libdir /usr/lib
%endif

%description
Parameter estimation software for generalized hidden Markov models.
For information and documentation, see http://mblab.wustl.edu.

%prep
%setup -q 

%build
%{__perl} Makefile.PL INSTALLDIRS="vendor" PREFIX="%{buildroot}%{_prefix}" 
make

%install 
rm -rf $RPM_BUILD_ROOT
make install

mkdir -p $RPM_BUILD_ROOT/usr/share/sgml/dtd
cp sgml/*.dtd $RPM_BUILD_ROOT/usr/share/sgml/dtd

mkdir -p $RPM_BUILD_ROOT/usr/bin
for f in scripts/*; do
  install -m 0755 $f $RPM_BUILD_ROOT/usr/bin/$(basename $f .pl)
done

mkdir -p $RPM_BUILD_ROOT/usr/share/iPE/doc
mv doc/book/iPE-User-Guide.pdf doc/iPE-User-Guide.pdf
rm -rf doc/book
cp -r doc/* $RPM_BUILD_ROOT/usr/share/iPE/doc

mkdir -p $RPM_BUILD_ROOT/usr/share/iPE/conf
cp -r conf/* $RPM_BUILD_ROOT/usr/share/iPE/conf

mkdir -p $RPM_BUILD_ROOT/etc/profile.d
echo 'SGML_SEARCH_PATH=/usr/share/sgml/dtd' > $RPM_BUILD_ROOT/etc/profile.d/iPE.sh
chmod 0755 $RPM_BUILD_ROOT/etc/profile.d/iPE.sh


find $RPM_BUILD_ROOT \( -name perllocal.pod -o -name .packlist \) -exec rm -v {} \;

%clean
rm -rf $RPM_BUILD_ROOT

%post

%preun

%files
%defattr(-, root, root)
/etc/profile.d/iPE.sh
/usr/bin
/usr/share
%{libdir}

%changelog
* Thu Jul 26 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.3.1-1
- No tests in the MANIFEST
- Re-adding finalize script
- Changes to the greeting in the book to be consistent with current 
  0.3.1 version
* Tue Jul 25 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.3.0-1
- Restoring gcc optimizations
- Fixed up install script
- Fixed up man pages
* Tue Jul 24 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.9-1
- BUG FIX:  Sam's code assigns to an array index that he doesn't allocate.
  This will step on other memory sometimes and cause a crash.  This is
  eliminated now.
- More freeing of memory (leaks eliminated with valgrind)
- BNTree uses topology and model type from its own object rather than the
  globals module.
* Tue Jul 17 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.8-1
- redirecting stdout and stderr is not cross-platform friendly.  
  Directly commented out the fprintfs in Sam's code.
- removed all other _models tags from the gHMM DTD definition
* Mon Jul 09 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.7-1
- Default value of randomSeed is now the return value of time() on calling
- Fixed a message bug for the maximizing parameters step
* Mon Jul 09 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.6-1
- Correcting the incorrect nscanTree error messages to nscanTopology
* Mon Jul 09 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.5-1
- Changing package name to perl-ipe
- Fixing MANIFEST
* Wed Jun 06 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.4-1
- Reviving deprecated gHMM test
- Reviving old test gHMMs
- Simplified zhmm output so the sequence tags are automatically generated
- Added (missing) finalized zhmm files for nscan checks in 002
- Added a check to see if a zhmm is missing before comparing it
- Fixed some of the zoe irregular sequence types
* Mon Jun 04 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.3-1
- Added warning in convert script for the use of WWAMs.
- Adding D.mel and C.el gHMM files
- Fixed off-by-one line width bug in convert script
- Adding finalization to check_all_gHMMs script
- Fixed a test bug that causes finalize to run when unneeded
* Wed May 30 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.2-1
- Added ELUT model for Aaron's tiling array data
- Added Array sequence class
- moved to testing on chr20 for gene density and tiling array sequence.
  (regression tests were performed on 0.1.60 to verify the new sequences)
- added an option to generic testing to specify instance template
- updated the URL for Brent lab home page
* Wed May 30 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.1-1
- make_instance_file removes basedir attr from gHMM and feature_map elements
* Fri May 25 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.2.0-1
- added functionality to generate flat file training/testing sets.
- added functionality to convert old BNTREE model gHMMs to new ones.
- moved greeting message out to ipestimate script
- more verbose usage statement
- verbose death when obsolete gHMM is presented
  (old gHMMs are still handled in the code, should be cleaned up)
- added more updated data fields to OEM gHMM files.
- removed deprecated warning from iPE::Model::Emission;
  this is done in iPE::gHMM now
- updated Makefile.PL to handle linking bntree binary
- fixed test 006 (didn't output correct filename)
- ADDED N-SCAN MAXIMIZATION:
  * BNTREE* emission models
  * iPE::Model::BNTree handles optimization/interface to sam's code
  * updated test OK files that didn't previously have phylo params
  * added nscanTopology, nscanModel and keepSSFiles options
* Thu May 17 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.63-1
- added functionality to format converted gHMMs in the conversion script
- remove all leading and trailing whitespace from text nodes in 
  iPE::XML::Object
- refactored tests so that redundant code is unnecessary
- added a test for the make_instance_file script.
* Thu May 3 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.62-1
- STOPGAP version--make_instance_file test has to be developed
  DO NOT USE
- Relaxed the requirement for a 'conservation_model', 'est_model' tag.
  Now anything can be lumped into the sequence_model tag in the gHMM.
- Relaxed the requirement for 'est_files', 'cons_files' ,etc. tag.
  Everything should just use 'seq_files', tag.
- Updated all gHMMs for the above two guidelines
- Updated make_instance_file script to generate sequence types automatically.
  (No update is needed after a new sequence type is created)
- Fixed 004 and 005 tests (EM needed a fixed random seed to verify)
- Changed iPE::XML::Object to get rid of all flanking whitespace from
  PCDATA lines.
- Added an old to new format conversion script.
- Added a gHMM validator script
* Wed Apr 25 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.61-1
- Added a globals module
- Added an old-style (deprecated, pre-data-attribute change) gHMM test.
- Added a test for testing nscan parameters.
- Changed classnames for sequences to begin simplifying the addition of new sequences (see ticket #12)
- Fixed option setting in finalize script.
- Fixed clean feature in book Makefile
- Updated README
* Tue Apr 24 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.60-1
- Fixing bug in random seed code and adding test for it
* Tue Apr 24 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.59-1
- adding new settings framework for the data attributes
- specified a little more with the feature mapping error
- created the beginnings of a test suite for validating updates to ipe.
- removed unused null_region_definition DTD sections in iPE_instance
- removed native script extensions (.pl) from install
- added feature to specify gHMM and feature-map file in 
    make_instance_file script
* Tue Apr 17 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.58-1
- Removed needless use statements in Estimator.pm
- Added a more verbose, sensible die message for incompatible feature maps
* Mon Apr 16 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.57-1
- Added an error for an unimplemented getRevSeq method in a NoLoad sequence reader.
- Added the ability to output noload sequences (and alignments)
* Thu Mar 29 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.56-1
- Added capability in SPLIT model to print out the submodels in zoe output
* Thu Mar 29 2007 Akshat <ars6@cec.wustl.edu> - 0.1.55-1
- Adding new ASM model and incorporating into Emission.pm
* Mon Mar 26 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.54-1
- Fixed bug created by fix in finalize_nscan_parameters.pl
* Thu Mar 22 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.53-1
- Setting filehandles at the beginning of finalize_nscan_parameters.pl
- removing gtf_map_inter.xml from MANIFEST
- Throwing error message when SDT submodels are of improper length
- Made clearer error message for improperly formatted phylo trees in 
    finalize_nscan_parameters.pl
* Tue Mar 20 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.52-1
- added some documentation to the feature maps
* Mon Mar 19 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.51-1
- moved gtf_map_hacked_inter.xml to gtf_map_utr_hacked_inter.xml, since 
    it includes 5' UTR states
- added gtf_map_hacked_inter.xml which does not include utr states for use
    with Twinscan_EST.
* Tue Feb 27 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.50-1
- fixed a bug in make_instance_file.pl that accepted single quotes in directory names
* Tue Feb 27 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.49-1
- adding feature to better glob in make_instance_file.pl
* Tue Feb 27 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.48-1
- specfile was setting sgml envvar incorrectly
* Tue Feb 27 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.47-1
- specfile was installing dtds in the wrong directory
* Tue Feb 27 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.46-1
- fixed so XML::Checker::Parser no longer requires SGML_SEARCH_PATH set.
* Tue Feb 27 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.45-1
- changed to appropriate unix name ipe.
* Wed Feb 14 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.44-1
- streams now default to stderr properly
- debug output will not duplicate messages to stderr if that is the current fh.
* Wed Feb 14 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.43-1
- Warning message when GEOMETRIC has no defined values and is smoothed corrected
- Fixed a bug in gHMM_utr.xml introduced in source:/trunk/iPE/conf/gHMM_utr.xml@119
* Thu Jan 18 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.42-1
- Adding wiki folder in document
- Fixing MANIFEST
* Tue Jan 16 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.41-1
- fixed messages for 0 samples
- moved some inappropriate Msg's to Warn's
- double checked frames for gHMM templates
- added a check to see if all model types in the gHMM have corresponding seqs
* Fri Jan 12 2007 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.40-1
- eliminating unused gHMMs from failed projects
- confirmed correctness of frames in gHMM templates
* Tue Nov 28 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.39-1
- recorrecting the header for ASESTSEQ...more convenient not to change the name :)
* Mon Nov 27 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.38-1
- correcting the header for ASESTSEQ models.
- fixed a bug preventing asest from counting
* Sun Nov 26 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.37-1
- oops--didn't check but the OptExon fix created a new bug.
* Sun Nov 26 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.36-1
- better checking for opt exon -- if a bigger exon exists in the same place as an
    optional exon, it is not converted into an optional exon
* Sun Nov 26 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.35-1
- Msg function now broadcasts
- moving finalization calls into Annotation.pm
- rearranged iPE_instance DTD file
- cut fat in iPE.pm
* Fri Nov 24 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.34-1
- Warn function added which affects many files
- Prevent inserting OptExons on opposite strand transcripts
- Message output is now separated into three transparent categories:
    messages, warnings and debug.  The user can now channel any of these three
    streams to a file, let them default to stderr, or suppress them altogether.
* Fri Nov 24 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.33-1
- Fixed a bug that I created in the last commit: opt exons had bad 
    frame information because the frame was altered in some cases.
* Fri Nov 24 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.32-1
- Fixed a bug that printed an error to stdout
- Added ASEST to zhmm output
- Added feature to allow bad transitions between states in transcripts
- Changed OptExon altsplice state to carry out to all transcripts in the gene 
    for that region
* Thu Nov 23 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.31-1
- Added ASEST to rpm and svn.
* Wed Nov 22 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.30-1
- Did a little more revamping of generate_cv_sets.pl
* Wed Nov 22 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.29-1
- Added capability of multisites (still testing)
- Added better usage statement to generate_cv_sets.pl
- Made a small correction in the documentation
* Fri Aug 25 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.28-1
- added mani's jumplut
* Fri Aug 25 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.27-1
- fixed up (hopefully) the normal Twinscan-EST gHMM file
* Sat Aug 19 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.26-1
- Moved a few common routines around for library use outside of PE context
- Eliminated all sanity checks from iPE::Annotation::Transcript::addFeature.  
    All checks are now in finalize.
- iPE::Annotation::Transcript::finalize no longer short circuits if it sees 
    a bad transcript.  It is up to the caller to decide to discard blacklisted
    transcripts or not.
* Mon Aug 14 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.25-1
- Somehow I reallowed features within transcripts to overlap.  This was probably for debugging, so I returned to not allowing it.
* Mon Aug 14 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1.24-1
- Co-opting the release number to subminor version, since we're adding features,
    not rebuilding
- Added some error checking to make_instance_file.pl
* Sun Aug 13 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-23
- Corrected bugs in EST gHMM and made a new hacked intergenic featuremap.

* Fri Aug 11 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-22
- Changed the est_files tag to estseq_files
- Updated make_instance_file.pl script
- Cleaned up the EST and AltSplice manpages
* Wed Aug 9 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-21
- The addition of strand-free or 'N'-strand states: states that may come 
    from a feature from a feature mapping on either strand.
- Allowing gapped transcripts: if the transcript has two features which 
    don't have a state that can fill the gap between the features, 
    this is now optionally allowed (option set in instance file), and all 
    consequences of handling this (namely not counting transitions between 
    the features) is compensated for
- Strand-specific feature mappings:  Allowing for the originating feature's 
    strand to be specified.  This is useful for converting features to 
    strand-free states.
- Non-overlapping states: You may now define a state which may not have 
    any other features (besides features from that state) overlap it.  
    This is useful in the case of annotating intergenic regions, which 
    should never overlap other features.
- Bug fixes: 
    Annotation.pm: Avoid populating the list with empty annotations
    State.pm: Sanity check to make sure the strand is either '+' '-' or 'N'
    whole_genome_inst.xml: removed this file; it refers to Brent Lab directories; example instance is sufficient
* Wed Aug 1 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-20
- Changed finalize script to have fewer commandline parameters
* Wed Aug 1 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-19
- Fixed a frame tracking bug in multisite states
* Wed Aug 1 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-18
- Added altsplice states for multisites (5' and 3')
* Fri Jul 14 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-17
- Added more changes to allow tile array data to work.
* Thu Jul 13 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-16
- Fixed pod man pages.  Really bad news.  No way to check for errors
    without manually doing all pods and then checking to see which
    was the last one that worked.  Erg.
* Wed Jul 12 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-15
- Changed tiling alphabet to 3 characters instead of 2.
* Wed Jul 12 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-14
- Added tiling array data and generalized sequence type usage to necessitate
    less additional code than was previously needed.  (More needs to be done.)
* Tue Jul 11 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-13
- Changed requisite from eval to eval-common, the new non-X11 package
* Tue Jul 11 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-12
- Changed iPE::AnnotationPlugin::GTF to ...GTFPlugin to avoid namespace 
    clash with GTF.pm
* Wed Mar 17 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-11
- Hush perl warning in Kernel.pm
* Wed Mar 17 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-10
- Fixed make_instance_file.pl script and a minor mistake in GEOMETRIC.pm
* Wed Mar 17 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-9
- Changed permissions for the finalize_nscan_parameters.pl script
* Wed Mar 17 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-8
- Copy the scripts into the bin directory
* Wed Mar 17 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-7
- Fixed a minor bug in Emission.pm
* Wed Mar 10 2006 Brian Koebbe <koebbe@wustl.edu> - 0.1-6
- change the libdir dependent on the current archetecture
* Wed Mar 10 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-5
- remove the book tex files and leave the pdf
* Wed Mar 10 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-4
- added XML::LibXML dependency
* Wed Mar 10 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 0.1-3
- changed the version number to the beta number (we went back in time!)
* Wed Mar 10 2006 Bob Zimmermann <rpz@cse.wustl.edu> - 1.0-2
- Added documentation and configuration files
* Mon Mar 6 2006 Brian Koebbe <koebbe@wustl.edu> - 1.0-1
- Initial build
