/*

 Copyright (c) 2013-2015, Tomas Podermanski

 This file is part of libnf.net project.

 Libnf is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Libnf is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with libnf.  If not, see <http://www.gnu.org/licenses/>.

*/

%option outfile="lex.yy.c"
%option prefix="ff2_"
%option reentrant bison-bridge
%option noyywrap
%option nounput
%option noinput

digit 	[0-9]
letter	[A-Za-z:/\.\-]

ws	[ \t]

%{
	#include <stdlib.h>
	#include <string.h>
	#include "ffilter_internal.h"
	#include "ffilter_gram.h"
	#include "ffilter.h"
//	#define YY_FATAL_ERROR(msg) (printf("LEXXX> %s\n", msg))
%}

%%

and|"&&"		{ return AND; }
or|"||"			{ return OR; }
not|"!"			{ return NOT; }

exist           { return EXIST; }

"in"{ws}+"["	{ return IN; }

"="|"=="|eq		{ return EQ; }
">"|gt			{ return GT; }
"<"|lt			{ return LT; }
"&"			{ return ISSET; }
"("			{ return LP; }
")"			{ return RP; }
"["			{ return LPS; }
"]"			{ return RPS; }

"next"{ws}+"ip"	{
			// Grammar exceptions nfdump compat, maybe enable one space separated identifiers ?
					strncpy(yylval->string, "nextip", FF_MAX_STRING - 1);
					return STRING;
				}
"bgpnext"{ws}+"ip"	{
					strncpy(yylval->string, "bgpnextip", FF_MAX_STRING - 1);
					return STRING;
				}
"router"{ws}+"ip"	{
					strncpy(yylval->string, "routerip", FF_MAX_STRING - 1);
					return STRING;
				}

"mpls"{ws}+"label"	{
					strncpy(yylval->string, "mplslabel", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label1"	{
					strncpy(yylval->string, "mplslabel1", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label2"	{
					strncpy(yylval->string, "mplslabel2", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label3"	{
					strncpy(yylval->string, "mplslabel3", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label4"	{
					strncpy(yylval->string, "mplslabel4", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label5"	{
					strncpy(yylval->string, "mplslabel5", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label6"	{
					strncpy(yylval->string, "mplslabel6", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label7"	{
					strncpy(yylval->string, "mplslabel7", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label8"	{
					strncpy(yylval->string, "mplslabel8", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label9"	{
					strncpy(yylval->string, "mplslabel9", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"label10"	{
					strncpy(yylval->string, "mplslabel10", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"eos"	{
					strncpy(yylval->string, "mplseos", FF_MAX_STRING - 1);
					return STRING;
				}
"mpls"{ws}+"exp"    {
					strncpy(yylval->string, "mplsexp", FF_MAX_STRING - 1);
					return STRING;
				}

"src and dst"|"dst and src"         { strncpy(yylval->string, yytext, FF_MAX_STRING - 1); return BIDIR_AND; }
"src or dst"|"dst or src"           { strncpy(yylval->string, yytext, FF_MAX_STRING - 1); return BIDIR_OR; }
"in src"|"in dst"|"out src"|"out dst"  { strncpy(yylval->string, yytext, FF_MAX_STRING - 1); return DIR_DIR_MAC; }
src|prev|in|ingress                 { strncpy(yylval->string, yytext, FF_MAX_STRING - 1); return DIR; }
dst|next|out|egress                 { strncpy(yylval->string, yytext, FF_MAX_STRING - 1); return DIR; }

any 				{ return ANY; }

({letter}|{digit})+	{
					strncpy(yylval->string, yytext, FF_MAX_STRING - 1);
					return STRING;
				}

#.*         { ; }	//comments
{ws}+       { ; }	//whitespace
[\n]        { ; }	//end of line

.			{ /*fprintf(stderr, "%s: %s\n", "invalid character", yytext);*/ return BAD_TOKEN; }

%%

