#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFInfo2',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 90 => 0x69 },
	'about' => { 400 => 'about' },
	'aboutcvterm' => { 393 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 393 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 393 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 393 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 393 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 406 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 71 => 0x518 },
	'accelerometer' => { 316 => 0x3 },
	'accelerometerx' => { 258 => 0x8d },
	'accelerometery' => { 258 => 0x8e },
	'accelerometerz' => { 258 => 0x8c },
	'accessoryserialnumber' => { 258 => 0x54 },
	'accessorytype' => { 258 => 0x53 },
	'actionadvised' => { 106 => 0x2a },
	'activearea' => { 98 => 0xc68d },
	'actived-lighting' => { 185 => 0x22, 217 => 0x24 },
	'actived-lightingmode' => { 217 => 0x25 },
	'adaptervoltage' => { 112 => 0x407 },
	'addaspectratioinfo' => { 71 => 0x80e },
	'additionalmodelinformation' => { 393 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 71 => 0x80f, 72 => 0x11, 73 => 0x13, 76 => 0x14 },
	'address' => { 133 => 'Address' },
	'adjustmentmode' => { 322 => 0x15 },
	'adobe' => { 99 => 'Adobe' },
	'adultcontentwarning' => { 396 => 'AdultContentWarning', 399 => 'adultContentWarning' },
	'advancedfilter' => { 103 => 0x1201 },
	'advancedraw' => { 219 => 0x76a43203 },
	'advancedscenetype' => { 258 => 0x3d },
	'advisory' => { 404 => 'Advisory' },
	'ae_iso' => { 265 => 0x2, 266 => 0x4, 267 => 0x12 },
	'aeaperture' => { 265 => 0x1, 266 => 0x3, 267 => 0x11 },
	'aeaperturesteps' => { 265 => 0x8, 266 => 0xb },
	'aebautocancel' => { 71 => 0x104 },
	'aebbracketvalue' => { 65 => 0x11 },
	'aebsequence' => { 71 => 0x105 },
	'aebsequenceautocancel' => { 69 => 0x9, 70 => 0x9, 72 => 0x8, 73 => 0x9, 76 => 0x9, 77 => 0x7 },
	'aebshotcount' => { 71 => 0x106 },
	'aebxv' => { 265 => 0x4, 266 => 0x6 },
	'aeerror' => { 266 => 0x8 },
	'aeexposuretime' => { 265 => 0x0, 266 => 0x2, 267 => 0x10 },
	'aelbutton' => { 153 => 0x45 },
	'aelexposureindicator' => { 153 => 0x51 },
	'aelock' => { 153 => 0x5b, 228 => '4.2', 234 => '4.2', 238 => 0x201, 291 => 0x48, 330 => 0x40, 331 => 0x40, 332 => [0x86,0x286] },
	'aelockbutton' => { 226 => '16.1', 228 => '4.1', 229 => '15.1', 230 => '16.1', 231 => '16.1', 232 => '30.1', 233 => '16.1', 234 => '4.1', 236 => '17.1' },
	'aelockbuttonplusdials' => { 226 => '16.2', 232 => '32.1' },
	'aelockformb-d80' => { 236 => '3.1' },
	'aemaxaperture' => { 265 => 0x9, 266 => 0x10, 267 => 0x1c },
	'aemaxaperture2' => { 265 => 0xa, 266 => 0x11, 267 => 0x1d },
	'aemeteringmode' => { 265 => 0xc },
	'aemeteringmode2' => { 265 => '13.1' },
	'aemeteringsegments' => { 156 => 0x628, 291 => 0x209 },
	'aemicroadjustment' => { 71 => 0x110 },
	'aeminaperture' => { 265 => 0xb, 266 => 0x12, 267 => 0x1e },
	'aeminexposuretime' => { 265 => 0x5, 266 => 0x13, 267 => 0x1f },
	'aeprogrammode' => { 265 => 0x6 },
	'aesetting' => { 30 => 0x21 },
	'aewhitebalance' => { 265 => 0xd },
	'aexv' => { 265 => 0x3, 266 => 0x5 },
	'af-cpriorityselection' => { 226 => '1.1', 227 => '1.1', 230 => '0.1', 231 => '0.1', 232 => '1.1', 233 => '0.1' },
	'af-onformb-d10' => { 226 => '3.3', 232 => '3.2' },
	'af-onformb-d11' => { 233 => '2.2' },
	'af-spriorityselection' => { 226 => '1.2', 227 => '1.2', 232 => '1.2', 233 => '0.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 226 => '2.1', 227 => '2.1', 232 => '2.1' },
	'afadjustment' => { 291 => 0x72 },
	'afandmeteringbuttons' => { 71 => 0x701 },
	'afaperture' => { 181 => 0x5, 182 => 0x5 },
	'afareaheight' => { 161 => 0x1a },
	'afareaillumination' => { 153 => 0x4b, 234 => '15.3' },
	'afareamode' => { 149 => 0x33, 153 => 0xe, 160 => 0x0, 161 => 0x5, 258 => 0xf, 313 => 0x1205, 323 => [0xa,0x3a], 330 => 0x11, 331 => 0x10, 332 => 0x24, 342 => 0xb043, 360 => 0x17 },
	'afareamodesetting' => { 228 => '11.1', 229 => '0.1', 234 => '16.1', 236 => '2.1', 342 => 0x201c },
	'afareas' => { 238 => 0x304 },
	'afareaselectmethod' => { 71 => 0x51b },
	'afareawidth' => { 161 => 0x18 },
	'afareaxposition' => { 161 => 0x14, 313 => 0x1203 },
	'afareaxposition1' => { 313 => 0x1201 },
	'afareayposition' => { 161 => 0x16, 313 => 0x1204 },
	'afareayposition1' => { 313 => 0x1202 },
	'afassist' => { 69 => 0x5, 77 => 0x5, 153 => 0x48, 226 => '2.5', 228 => '0.2', 229 => '0.2', 230 => '1.1', 231 => '1.1', 232 => '2.4', 233 => '1.4', 234 => '0.2', 236 => '2.3' },
	'afassistbeam' => { 71 => 0x50e, 72 => 0x4, 73 => 0x5, 74 => 0x4, 75 => 0x4, 76 => 0x5 },
	'afassistlamp' => { 258 => 0x31 },
	'afbuttonpressed' => { 332 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 268 => 0x6 },
	'afduringliveview' => { 71 => 0x511 },
	'affinea' => { 377 => 'AffineA' },
	'affineb' => { 377 => 'AffineB' },
	'affinec' => { 377 => 'AffineC' },
	'affined' => { 377 => 'AffineD' },
	'affinetune' => { 162 => 0x0, 238 => 0x306 },
	'affinetuneadj' => { 162 => 0x2, 193 => 0x2d1, 194 => 0x2dc, 238 => 0x307 },
	'affinetuneindex' => { 162 => 0x1 },
	'affinex' => { 377 => 'AffineX' },
	'affiney' => { 377 => 'AffineY' },
	'afilluminator' => { 330 => 0x29, 342 => 0xb044 },
	'afimageheight' => { 161 => 0x12 },
	'afimagewidth' => { 161 => 0x10 },
	'afintegrationtime' => { 268 => 0x7 },
	'afmicroadj' => { 323 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 327 => 0x131 },
	'afmicroadjregisteredlenses' => { 327 => '305.1' },
	'afmicroadjustment' => { 71 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 327 => 0x130 },
	'afmode' => { 94 => 0x3009, 149 => 0x16, 322 => 0x5 },
	'afmoderestrictions' => { 227 => '50.3' },
	'afonaelockbuttonswitch' => { 71 => 0x702 },
	'afonbutton' => { 226 => '3.1', 227 => '47.1' },
	'afpoint' => { 30 => 0x13, 93 => 0x18, 149 => 0x15, 160 => 0x1, 241 => 0x308, 322 => 0x1f, 323 => 0x7, 327 => 0x19, 328 => 0x18, 329 => [0x18,0x20] },
	'afpointactivationarea' => { 70 => 0x11, 76 => 0x11 },
	'afpointareaexpansion' => { 71 => 0x508 },
	'afpointatshutterrelease' => { 323 => 0x9 },
	'afpointautoselection' => { 71 => 0x50b },
	'afpointbrightness' => { 71 => 0x50d, 226 => '2.4', 227 => '46.5' },
	'afpointdisplayduringfocus' => { 71 => 0x50c },
	'afpointillumination' => { 70 => 0xa, 226 => '2.3', 227 => '46.2', 232 => '2.3', 233 => '1.3', 236 => '2.4' },
	'afpointinfocus' => { 323 => 0x8 },
	'afpointmode' => { 272 => 0x3 },
	'afpointposition' => { 94 => 0x2021, 258 => 0x4d },
	'afpointregistration' => { 69 => 0x7 },
	'afpoints' => { 152 => 0x10 },
	'afpointselected' => { 153 => 0xd, 238 => 0x305, 291 => 0xe, 327 => 0x15, 328 => 0x14, 329 => [0x14,0x1c], 342 => 0x201e },
	'afpointselected2' => { 272 => 0x4 },
	'afpointselection' => { 70 => 0xb, 226 => '1.3', 227 => '1.3', 232 => '1.3' },
	'afpointselectionmethod' => { 71 => 0x50f, 72 => 0xc, 73 => 0xd, 76 => 0xd },
	'afpointset' => { 103 => 0x1022 },
	'afpointsetting' => { 330 => 0x12, 331 => 0x11 },
	'afpointsinfocus' => { 65 => 0xe, 160 => 0x2, 268 => 0xb, 291 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 70 => 0xd },
	'afpointsselected' => { 367 => 0x4 },
	'afpointsunknown1' => { 268 => 0x0 },
	'afpointsunknown2' => { 268 => 0x2 },
	'afpointsused' => { 161 => 0x8, 324 => 0x0 },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 268 => 0x4 },
	'afresponse' => { 185 => 0xad },
	'afresult' => { 243 => 0x1038 },
	'afsearch' => { 238 => 0x303 },
	'afsensoractive' => { 149 => 0x1 },
	'afstatus' => { 313 => 0x1200 },
	'afstatusactivesensor' => { 149 => 0x2, 323 => 0x4, 327 => 0x1e, 328 => 0x1b, 329 => [0x1b,0x21] },
	'afstatusbottom' => { 149 => 0x8, 327 => 0x2a, 328 => 0x21, 329 => 0x21 },
	'afstatusbottom-left' => { 149 => 0x12, 328 => 0x2b, 329 => 0x2b },
	'afstatusbottom-right' => { 149 => 0x6, 328 => 0x1f, 329 => 0x1f },
	'afstatusbottomassist-left' => { 327 => 0x28 },
	'afstatusbottomassist-right' => { 327 => 0x2c },
	'afstatusbottomhorizontal' => { 325 => 0x10, 326 => 0x1c },
	'afstatusbottomvertical' => { 325 => 0x16, 326 => 0x26 },
	'afstatuscenter-10' => { 327 => 0x34 },
	'afstatuscenter-11' => { 327 => 0x36 },
	'afstatuscenter-12' => { 327 => 0x38 },
	'afstatuscenter-14' => { 327 => 0x3c },
	'afstatuscenter-7' => { 327 => 0x2e },
	'afstatuscenter-9' => { 327 => 0x32 },
	'afstatuscenter-horizontal' => { 327 => 0x30 },
	'afstatuscenter-vertical' => { 327 => 0x3a },
	'afstatuscenterf2-8' => { 327 => 0x4c },
	'afstatuscenterhorizontal' => { 149 => 0x2f, 325 => 0xc, 326 => 0x18, 328 => 0x2f, 329 => 0x2f },
	'afstatuscentervertical' => { 149 => 0xc, 325 => 0x14, 326 => 0x22, 328 => 0x25, 329 => 0x25 },
	'afstatusfarleft' => { 325 => 0x6, 327 => 0x26 },
	'afstatusfarlefthorizontal' => { 326 => 0x4 },
	'afstatusfarleftvertical' => { 326 => 0x12 },
	'afstatusfarright' => { 325 => 0x18, 327 => 0x44 },
	'afstatusfarrighthorizontal' => { 326 => 0x2c },
	'afstatusfarrightvertical' => { 326 => 0x34 },
	'afstatusleft' => { 149 => 0x2d, 325 => 0x2, 327 => 0x22, 328 => 0x2d, 329 => 0x2d },
	'afstatuslefthorizontal' => { 326 => 0x6 },
	'afstatusleftvertical' => { 326 => 0xe },
	'afstatuslower-left' => { 325 => 0x4, 327 => 0x24 },
	'afstatuslower-lefthorizontal' => { 326 => 0xa },
	'afstatuslower-leftvertical' => { 326 => 0x10 },
	'afstatuslower-middle' => { 325 => 0x22, 326 => 0x24 },
	'afstatuslower-right' => { 325 => 0x1e, 327 => 0x4a },
	'afstatuslower-righthorizontal' => { 326 => 0x32 },
	'afstatuslower-rightvertical' => { 326 => 0x3a },
	'afstatuslowerfarleft' => { 326 => 0x8 },
	'afstatuslowerfarright' => { 326 => 0x30 },
	'afstatusmiddlehorizontal' => { 149 => 0xa, 328 => 0x23, 329 => 0x23 },
	'afstatusnearleft' => { 325 => 0xe, 326 => 0x1a },
	'afstatusnearright' => { 325 => 0xa, 326 => 0x16 },
	'afstatusright' => { 149 => 0x31, 325 => 0x1c, 327 => 0x48, 328 => 0x31, 329 => 0x31 },
	'afstatusrighthorizontal' => { 326 => 0x2e },
	'afstatusrightvertical' => { 326 => 0x38 },
	'afstatustop' => { 149 => 0xe, 327 => 0x40, 328 => 0x27, 329 => 0x27 },
	'afstatustop-left' => { 149 => 0x10, 328 => 0x29, 329 => 0x29 },
	'afstatustop-right' => { 149 => 0x4, 328 => 0x1d, 329 => 0x1d },
	'afstatustopassist-left' => { 327 => 0x3e },
	'afstatustopassist-right' => { 327 => 0x42 },
	'afstatustophorizontal' => { 325 => 0x8, 326 => 0x14 },
	'afstatustopvertical' => { 325 => 0x12, 326 => 0x1e },
	'afstatusupper-left' => { 325 => 0x0, 327 => 0x20 },
	'afstatusupper-lefthorizontal' => { 326 => 0x2 },
	'afstatusupper-leftvertical' => { 326 => 0xc },
	'afstatusupper-middle' => { 325 => 0x20, 326 => 0x20 },
	'afstatusupper-right' => { 325 => 0x1a, 327 => 0x46 },
	'afstatusupper-righthorizontal' => { 326 => 0x2a },
	'afstatusupper-rightvertical' => { 326 => 0x36 },
	'afstatusupperfarleft' => { 326 => 0x0 },
	'afstatusupperfarright' => { 326 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 323 => 0x2 },
	'afwithshutter' => { 330 => 0x2a },
	'aggregationtype' => { 397 => 'aggregationType' },
	'agreement' => { 399 => 'agreement' },
	'aiservocontinuousshooting' => { 70 => 0x15 },
	'aiservofirstimagepriority' => { 71 => 0x519 },
	'aiservoimagepriority' => { 71 => 0x503 },
	'aiservosecondimagepriority' => { 71 => 0x51a },
	'aiservotrackingmethod' => { 71 => 0x504 },
	'aiservotrackingsensitivity' => { 70 => 0x14, 71 => 0x502 },
	'album' => { 406 => 'album' },
	'alreadyapplied' => { 383 => 'AlreadyApplied' },
	'alternatetitle' => { 397 => 'alternateTitle' },
	'altitude' => { 163 => 0x6 },
	'alttapename' => { 406 => 'altTapeName' },
	'alttimecode' => { 406 => 'altTimecode' },
	'alttimecodetimeformat' => { 406 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 406 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 406 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 309 => 0x14, 360 => 0x4 },
	'ambienttemperaturefahrenheit' => { 309 => 0x13 },
	'analogbalance' => { 98 => 0xc627 },
	'angleadj' => { 90 => 0x8b },
	'angleinforoll' => { 379 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 379 => 'AngleInfoYaw' },
	'anti-blur' => { 342 => 0xb04b },
	'antialiasstrength' => { 98 => 0xc632 },
	'aperturelock' => { 227 => '38.2' },
	'aperturerange' => { 71 => 0x10d },
	'apertureringuse' => { 272 => '1.4' },
	'aperturesetting' => { 153 => 0x7, 330 => 0x30, 331 => 0x29, 332 => 0x1 },
	'aperturevalue' => { 80 => 0x2, 98 => 0x9202, 243 => 0x1002, 387 => 'ApertureValue' },
	'applekeywords' => { 247 => 'AAPL:Keywords' },
	'applicationnotes' => { 98 => 0x2bc, 262 => 0x2bc },
	'applicationrecordversion' => { 106 => 0x0 },
	'applyshootingmeteringmode' => { 71 => 0x10e },
	'approved' => { 389 => 'Approved' },
	'approvedby' => { 389 => 'ApprovedBy' },
	'approximatefnumber' => { 254 => 0x313, 260 => 0x3406 },
	'approximatefocusdistance' => { 380 => 'ApproximateFocusDistance' },
	'armidentifier' => { 107 => 0x78 },
	'armversion' => { 107 => 0x7a },
	'artfilter' => { 238 => 0x529 },
	'artfiltereffect' => { 238 => 0x52f },
	'artist' => { 98 => 0x13b, 250 => 'Artist', 291 => 0x22e, 402 => 'Artist', 406 => 'artist' },
	'artmode' => { 94 => 0x301b },
	'artmodeparameters' => { 94 => 0x310b },
	'artworkcircadatecreated' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 393 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 393 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 242 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 242 => 0x1112, 291 => 0x80, 330 => 0x55, 331 => 0x55, 332 => 0xa },
	'asshoticcprofile' => { 98 => 0xc68f },
	'asshotneutral' => { 98 => 0xc628 },
	'asshotpreprofilematrix' => { 98 => 0xc690 },
	'asshotprofilename' => { 98 => 0xc6f6 },
	'asshotwhitexy' => { 98 => 0xc629 },
	'assignbktbutton' => { 226 => '4.2', 227 => '16.1' },
	'assignfuncbutton' => { 71 => 0x70b },
	'assignmovierecordbutton' => { 227 => '43.2' },
	'assignremotefnbutton' => { 227 => '54.1' },
	'assistbuttonfunction' => { 69 => 0xd },
	'attributionname' => { 381 => 'attributionName' },
	'attributionurl' => { 381 => 'attributionURL' },
	'audio' => { 258 => 0x20 },
	'audiobitrate' => { 56 => 0x6c },
	'audiochannels' => { 56 => 0x70 },
	'audiochanneltype' => { 406 => 'audioChannelType' },
	'audiocompression' => { 127 => 'Compression' },
	'audiocompressor' => { 406 => 'audioCompressor' },
	'audioduration' => { 106 => 0x99 },
	'audiomoddate' => { 406 => 'audioModDate' },
	'audiooutcue' => { 106 => 0x9a },
	'audiosamplerate' => { 56 => 0x6e, 406 => 'audioSampleRate' },
	'audiosampletype' => { 406 => 'audioSampleType' },
	'audiosamplingrate' => { 106 => 0x97 },
	'audiosamplingresolution' => { 106 => 0x98 },
	'audiotype' => { 106 => 0x96 },
	'author' => { 129 => 'Author', 247 => 'Author', 250 => 'Author', 304 => 'Author', 378 => 'author', 394 => 'Author', 404 => 'Author' },
	'authorsposition' => { 395 => 'AuthorsPosition' },
	'autoaperture' => { 282 => '0.1' },
	'autobracket' => { 322 => 0x19 },
	'autobracketing' => { 103 => 0x1100, 291 => 0x18, 313 => 0x1007 },
	'autobracketingmode' => { 235 => '12.3' },
	'autobracketingset' => { 235 => '12.1' },
	'autobracketmodem' => { 226 => '21.2', 227 => '13.3', 232 => '26.2' },
	'autobracketorder' => { 153 => 0x43, 226 => '21.3', 227 => '13.2', 232 => '26.3', 233 => '12.2', 234 => '2.2', 235 => '12.2', 236 => '13.2' },
	'autobracketset' => { 226 => '21.1', 227 => '13.1', 229 => '11.1', 230 => '12.1', 231 => '12.1', 232 => '26.1', 233 => '12.1', 234 => '2.1', 236 => '13.1' },
	'autobrightness' => { 383 => 'AutoBrightness' },
	'autocontrast' => { 383 => 'AutoContrast' },
	'autodistortioncontrol' => { 171 => 0x4 },
	'autodynamicrange' => { 103 => 0x140b },
	'autoexposure' => { 383 => 'AutoExposure' },
	'autoexposurebracketing' => { 65 => 0x10 },
	'autofocus' => { 241 => 0x209 },
	'autofp' => { 234 => '7.3', 236 => '31.4' },
	'autoiso' => { 65 => 0x1, 94 => 0x3008, 228 => '1.1', 234 => '1.1' },
	'autoisomax' => { 228 => '1.2', 234 => '1.2' },
	'autoisominshutterspeed' => { 228 => '1.3', 234 => '1.3' },
	'autolateralca' => { 383 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 52 => 0x2, 71 => 0x204, 90 => 0x6f },
	'autolightingoptimizeron' => { 90 => 0x6e },
	'autoportraitframed' => { 342 => 0x2016 },
	'autoredeye' => { 219 => 0xfe28a44f },
	'autorotate' => { 65 => 0x1b },
	'autoshadows' => { 383 => 'AutoShadows' },
	'autowhiteversion' => { 383 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 185 => 0x82 },
	'avaperturesetting' => { 272 => 0x13 },
	'averageblacklevel' => { 37 => 0xe7, 39 => 0xfb, 40 => 0x114 },
	'averagelv' => { 156 => 0x38 },
	'avsettingwithoutlens' => { 71 => 0x707 },
	'azimuth' => { 137 => 'Azimuth' },
	'babyage' => { 258 => [0x8010,0x33] },
	'babyname' => { 258 => 0x66 },
	'backgroundalpha' => { 401 => 'bgalpha' },
	'baseexposurecompensation' => { 272 => 0x15 },
	'baseiso' => { 65 => 0x2, 84 => 0x101c, 112 => 0x903, 260 => 0x312a, 365 => 0x6 },
	'baselineexposure' => { 98 => 0xc62a },
	'baselineexposureoffset' => { 98 => 0xc7a5 },
	'baselinenoise' => { 98 => 0xc62b },
	'baselinesharpness' => { 98 => 0xc62c },
	'baseurl' => { 404 => 'BaseURL' },
	'batterylevel' => { 330 => 0x51, 334 => 0xc, 335 => 0x4, 336 => 0x4, 366 => 0x7 },
	'batterylevelgrip1' => { 366 => 0x6 },
	'batterylevelgrip2' => { 366 => 0x8 },
	'batteryorder' => { 226 => '12.5', 232 => '13.2', 233 => '2.1' },
	'batterystate' => { 153 => 0x60, 330 => 0x50, 336 => 0x14 },
	'batterytemperature' => { 334 => 0x1, 336 => 0x2, 366 => 0x5 },
	'batteryunknown' => { 334 => 0x2, 336 => 0x0 },
	'batteryvoltage' => { 112 => 0x408, 309 => 0x2a, 334 => 0x8 },
	'batteryvoltage1' => { 336 => 0x6 },
	'batteryvoltage2' => { 336 => 0x8 },
	'bayergreensplit' => { 98 => 0xc62d },
	'bayerpattern' => { 111 => 0xf902, 157 => 0x17 },
	'beatspliceparams' => { 406 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 406 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 406 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 406 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 406 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 406 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 226 => '13.1', 227 => '5.4', 228 => '0.1', 229 => '2.1', 230 => '3.1', 231 => '3.1', 232 => '10.1', 234 => '0.1', 236 => '4.1' },
	'beeppitch' => { 233 => '3.1' },
	'beepvolume' => { 233 => '4.5' },
	'bestqualityscale' => { 98 => 0xc65c },
	'bestshotmode' => { 94 => 0x3007 },
	'bitdepth' => { 134 => 'BitDepth', 157 => 0x11, 190 => 0x41 },
	'bitspercomponent' => { 108 => 0x87 },
	'bitspersample' => { 98 => 0x102, 402 => 'BitsPerSample' },
	'blacklevel' => { 98 => 0xc61a, 185 => 0x3d, 243 => [0x401,0x1012] },
	'blacklevel1' => { 262 => 0x8 },
	'blacklevel2' => { 242 => 0x600, 246 => 0x600, 262 => 0x9 },
	'blacklevel3' => { 262 => 0xa },
	'blacklevelblue' => { 262 => 0x1e },
	'blackleveldeltah' => { 98 => 0xc61b },
	'blackleveldeltav' => { 98 => 0xc61c },
	'blacklevelgreen' => { 262 => 0x1d },
	'blacklevelred' => { 262 => 0x1c },
	'blacklevelrepeatdim' => { 98 => 0xc619 },
	'blackpoint' => { 291 => 0x200 },
	'blacks2012' => { 383 => 'Blacks2012' },
	'bleachbypasstoning' => { 291 => 0x7f },
	'bluebalance' => { 169 => 0x271, 243 => 0x1018, 262 => 0x12, 291 => 0x1b },
	'bluecurvelimits' => { 89 => 0x1fe },
	'bluecurvepoints' => { 89 => 0x1d4 },
	'bluehue' => { 383 => 'BlueHue' },
	'bluesaturation' => { 383 => 'BlueSaturation' },
	'blurcontrol' => { 291 => 0x82 },
	'blurwarning' => { 103 => 0x1300 },
	'bodybatteryadload' => { 270 => 0x3 },
	'bodybatteryadnoload' => { 270 => 0x2 },
	'bodybatterystate' => { 270 => '1.1' },
	'bodybatteryvoltage1' => { 270 => 0x2 },
	'bodybatteryvoltage2' => { 270 => 0x4 },
	'bodybatteryvoltage3' => { 270 => 0x6 },
	'bodybatteryvoltage4' => { 270 => 0x8 },
	'bodyfirmware' => { 314 => 0x0 },
	'bodyfirmwareversion' => { 239 => 0x104, 240 => 0x100, 243 => 0x104 },
	'bodyserialnumber' => { 314 => 0x10 },
	'bracketmode' => { 47 => 0x3 },
	'bracketsequence' => { 94 => 0x301d },
	'bracketsettings' => { 258 => 0x45 },
	'bracketshotnumber' => { 47 => 0x5, 272 => 0x9, 341 => 0x2b },
	'bracketshotnumber2' => { 341 => 0x2d },
	'bracketstep' => { 150 => 0xe },
	'bracketvalue' => { 47 => 0x4 },
	'brightness' => { 98 => 0xfe53, 128 => 'Brightness', 150 => 0x2c, 187 => 0x34, 309 => 0x25, 330 => 0x22, 342 => 0x2007, 383 => 'Brightness' },
	'brightnessadj' => { 89 => 0x114, 212 => 0x0, 222 => 0x2d, 369 => 0x8018 },
	'brightnessvalue' => { 98 => 0x9203, 156 => [0x691,0x49c3], 243 => 0x1003, 346 => 0x1e, 349 => 0x1140, 350 => 0x1140, 351 => 0x111c, 352 => 0x1198, 353 => 0x1174, 354 => 0x102c, 355 => 0x224, 387 => 'BrightnessValue' },
	'bulbduration' => { 65 => 0x18 },
	'burstmode' => { 114 => 0xa, 258 => 0x2a },
	'burstmode2' => { 114 => 0x18 },
	'burstshot' => { 322 => 0x34 },
	'burstspeed' => { 258 => 0x77 },
	'buttonfunctioncontroloff' => { 71 => 0x70a },
	'bwfilter' => { 150 => 0x2a, 158 => 0x39 },
	'bwmode' => { 243 => 0x203 },
	'by-line' => { 106 => 0x50 },
	'by-linetitle' => { 106 => 0x55 },
	'bytecount' => { 397 => 'byteCount' },
	'calibration' => { 322 => [0x24,0x30] },
	'calibrationilluminant1' => { 98 => 0xc65a },
	'calibrationilluminant2' => { 98 => 0xc65b },
	'cameraangle' => { 406 => 'cameraAngle' },
	'cameracalibration1' => { 98 => 0xc623 },
	'cameracalibration2' => { 98 => 0xc624 },
	'cameracalibrationsig' => { 98 => 0xc6f3 },
	'cameracolorcalibration01' => { 32 => 0x0, 38 => 0xba },
	'cameracolorcalibration02' => { 32 => 0x4, 38 => 0xbf },
	'cameracolorcalibration03' => { 32 => 0x8, 38 => 0xc4 },
	'cameracolorcalibration04' => { 32 => 0xc, 38 => 0xc9 },
	'cameracolorcalibration05' => { 32 => 0x10, 38 => 0xce },
	'cameracolorcalibration06' => { 32 => 0x14, 38 => 0xd3 },
	'cameracolorcalibration07' => { 32 => 0x18, 38 => 0xd8 },
	'cameracolorcalibration08' => { 32 => 0x1c, 38 => 0xdd },
	'cameracolorcalibration09' => { 32 => 0x20, 38 => 0xe2 },
	'cameracolorcalibration10' => { 32 => 0x24, 38 => 0xe7 },
	'cameracolorcalibration11' => { 32 => 0x28, 38 => 0xec },
	'cameracolorcalibration12' => { 32 => 0x2c, 38 => 0xf1 },
	'cameracolorcalibration13' => { 32 => 0x30, 38 => 0xf6 },
	'cameracolorcalibration14' => { 32 => 0x34, 38 => 0xfb },
	'cameracolorcalibration15' => { 32 => 0x38, 38 => 0x100 },
	'cameraid' => { 243 => 0x209, 321 => 0x209 },
	'cameraiso' => { 30 => 0x10 },
	'cameralabel' => { 98 => 0xc7a1, 406 => 'cameraLabel' },
	'cameramodel' => { 406 => 'cameraModel' },
	'cameramove' => { 406 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 258 => 0x8f, 294 => 0x1, 336 => [0x16,0x18], 357 => 0x28, 358 => 0x24, 359 => 0x29 },
	'cameraowner' => { 115 => 0xc353 },
	'cameraparameters' => { 243 => 0x2050 },
	'cameraprofile' => { 383 => 'CameraProfile' },
	'cameraprofiledigest' => { 383 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 98 => 0xc62f, 148 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 238 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 29 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 65 => 0xc, 112 => 0x406, 242 => 0x1306, 254 => 0x320, 260 => 0x3402, 291 => 0x47, 319 => 0x43, 361 => 0x5 },
	'cameratemperature2' => { 295 => 0xc },
	'cameratemperature3' => { 295 => 0xe },
	'cameratemperature4' => { 295 => 0x14 },
	'cameratemperature5' => { 295 => 0x16 },
	'cameratemperaturerangemax' => { 100 => 0x5 },
	'cameratemperaturerangemin' => { 100 => 0x6 },
	'cameratype' => { 65 => 0x1a, 243 => 0x207 },
	'cameratype2' => { 239 => 0x100 },
	'canonexposuremode' => { 30 => 0x14 },
	'canonfiledescription' => { 84 => 0x805 },
	'canonfilelength' => { 53 => 0xe },
	'canonfirmwareversion' => { 53 => 0x7, 84 => 0x80b },
	'canonflashinfo' => { 84 => 0x1028 },
	'canonflashmode' => { 30 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 30 => 0xa },
	'canonimagetype' => { 53 => 0x6, 84 => 0x815 },
	'canonmodelid' => { 53 => 0x10, 84 => 0x1834 },
	'canonvrd' => { 99 => 'CanonVRD' },
	'caption' => { 378 => 'caption' },
	'caption-abstract' => { 106 => 0x78 },
	'captionsauthornames' => { 386 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 386 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 395 => 'CaptionWriter' },
	'captureframerate' => { 94 => 0x4001 },
	'capturesoftware' => { 373 => 'CaptureSoftware' },
	'cardshutterlock' => { 153 => 0x49 },
	'casioimagesize' => { 94 => 0x9 },
	'catalogsets' => { 106 => 0xff, 372 => 'CatalogSets', 376 => 'CatalogSets' },
	'categories' => { 53 => 0x23, 378 => 'categories' },
	'category' => { 106 => 0xf, 237 => 0x30, 395 => 'Category' },
	'cbcrgain' => { 319 => 0xa036 },
	'cbcrgaindefault' => { 319 => 0xa035 },
	'cbcrmatrix' => { 319 => 0xa034 },
	'cbcrmatrixdefault' => { 319 => 0xa033 },
	'ccdboardversion' => { 254 => 0x331 },
	'ccdscanmode' => { 243 => 0x1039 },
	'ccdsensitivity' => { 209 => 0x6 },
	'ccdversion' => { 254 => 0x330 },
	'cellglobalid' => { 382 => 'cgi' },
	'celllength' => { 98 => 0x109 },
	'cellr' => { 382 => 'r' },
	'celltowerid' => { 382 => 'cellid' },
	'cellwidth' => { 98 => 0x108 },
	'centerafarea' => { 234 => '15.1' },
	'centerfocuspoint' => { 236 => '2.2' },
	'centerweightedareasize' => { 226 => '7.1', 227 => '8.1', 232 => '5.1', 233 => '7.1', 234 => '6.3', 236 => '8.1' },
	'certificate' => { 410 => 'Certificate' },
	'cfapattern' => { 98 => 0xa302, 387 => 'CFAPattern' },
	'cfapattern2' => { 98 => 0x828e },
	'cfapatterncolumns' => { 387 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 387 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 387 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 98 => 0x828d },
	'channel' => { 397 => 'channel' },
	'channels' => { 127 => 'Channels' },
	'checkmark' => { 89 => 0x26a },
	'checkmark2' => { 90 => 0x8e },
	'childfontfiles' => { 411 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 226 => '10.3', 227 => '11.2' },
	'chromablurradius' => { 98 => 0xc631 },
	'chromaticaberration' => { 90 => 0x66, 319 => 0xa051 },
	'chromaticaberrationb' => { 383 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 90 => 0x6b },
	'chromaticaberrationcorr' => { 67 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 281 => 0x1 },
	'chromaticaberrationon' => { 90 => 0x62 },
	'chromaticaberrationr' => { 383 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 90 => 0x6a },
	'chromaticaberrationsetting' => { 68 => 0x6 },
	'chrominancenoisereduction' => { 90 => 0x5e, 322 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 90 => 0x60 },
	'circgradbasedcorractive' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 383 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 383 => 'CircularGradientBasedCorrections' },
	'city' => { 106 => 0x5a, 133 => 'City', 258 => 0x6d, 395 => 'City' },
	'city2' => { 258 => 0x80 },
	'clarity' => { 383 => 'Clarity' },
	'clarity2012' => { 383 => 'Clarity2012' },
	'classifystate' => { 106 => 0xe1 },
	'clearretouch' => { 258 => 0x7c },
	'clearretouchvalue' => { 258 => 0xa3 },
	'client' => { 406 => 'client' },
	'clientname' => { 389 => 'ClientName' },
	'clmodeshootingspeed' => { 226 => '10.2', 227 => '11.3', 232 => '11.2', 233 => '10.2', 236 => '11.1' },
	'cmcontrast' => { 246 => 0x2022 },
	'cmexposurecompensation' => { 246 => 0x2000 },
	'cmhue' => { 246 => 0x2021 },
	'cmsaturation' => { 246 => 0x2020 },
	'cmsharpness' => { 246 => 0x2023 },
	'cmwhitebalance' => { 246 => 0x2001 },
	'cmwhitebalancecomp' => { 246 => 0x2002 },
	'cmwhitebalancegraypoint' => { 246 => 0x2010 },
	'codec' => { 141 => 'Codec' },
	'codedcharacterset' => { 107 => 0x5a },
	'collectionname' => { 142 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 142 => 'Collections' },
	'collectionuri' => { 142 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 219 => 0xc89224b },
	'coloradjustment' => { 322 => 0x14 },
	'coloradjustmentmode' => { 321 => 0x210 },
	'coloranta' => { 411 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 411 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 411 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 411 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 411 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 411 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 411 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 411 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 411 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 411 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 411 => 'Colorants' },
	'colorantswatchname' => { 411 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 411 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 411 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 411 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 128 => 'ColorBalance' },
	'colorbalanceadj' => { 219 => 0x76a43202 },
	'colorbalanceblue' => { 150 => 0x1e },
	'colorbalancegreen' => { 150 => 0x1d },
	'colorbalancered' => { 150 => 0x1c },
	'colorbalanceversion' => { 170 => 0x0 },
	'colorblur' => { 90 => 0x65 },
	'colorbooster' => { 219 => 0x5f0e7d23 },
	'colorboostlevel' => { 213 => 0x1 },
	'colorboosttype' => { 213 => 0x0 },
	'colorclass' => { 299 => 0xde, 300 => 'ColorClass' },
	'colorcompensationfilter' => { 153 => [0x3a,0x5f], 155 => 0x111, 342 => 0xb022 },
	'colorcompensationfiltercustom' => { 330 => 0xd, 331 => 0xc },
	'colorcompensationfilterset' => { 330 => 0x8, 331 => 0x7, 332 => 0x18, 346 => 0xf },
	'colorcontrol' => { 243 => 0x102b },
	'colorcorrection' => { 369 => 0x8015 },
	'colordataversion' => { 36 => 0x0, 37 => 0x0, 39 => 0x0, 40 => 0x0 },
	'coloreffect' => { 258 => 0x28 },
	'colorfilter' => { 93 => 0x17, 94 => 0x3017, 150 => 0x29, 158 => [0x38,0x4d,0x4f], 297 => 0x17 },
	'colorgain' => { 190 => 0x51 },
	'colorhue' => { 185 => 0x8d },
	'colorimetricreference' => { 98 => 0xc6bf },
	'colorlabel' => { 386 => 'ColorLabel' },
	'colormatrix' => { 242 => 0x200, 243 => 0x1011, 319 => 0xa030 },
	'colormatrix1' => { 98 => 0xc621 },
	'colormatrix2' => { 98 => 0xc622, 246 => 0x200 },
	'colormatrixa' => { 291 => 0x203 },
	'colormatrixadobergb' => { 319 => 0xa032 },
	'colormatrixb' => { 291 => 0x204 },
	'colormatrixnumber' => { 243 => 0x1019 },
	'colormatrixsrgb' => { 319 => 0xa031 },
	'colormode' => { 94 => 0x3015, 103 => 0x1210, 114 => 0x66, 150 => 0x28, 153 => 0x16, 155 => 0x101, 156 => 0x36, 158 => 0x7, 185 => 0x3, 209 => 0x4, 258 => 0x32, 322 => 0x2c, 342 => 0xb029, 395 => 'ColorMode' },
	'colormoirereduction' => { 220 => 0x15 },
	'colormoirereductionmode' => { 220 => 0x5 },
	'colornoisereduction' => { 369 => 0x8029, 383 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 383 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 220 => 0x18 },
	'colornoisereductionsharpness' => { 220 => 0x1c },
	'colornoisereductionsmoothness' => { 383 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 102 => 0x2 },
	'colorprofile' => { 150 => 0x33 },
	'colorrepresentation' => { 108 => 0x3c },
	'colorsequence' => { 108 => 0x41 },
	'colorspace' => { 41 => 0x3, 53 => 0xb4, 84 => 0x10b4, 98 => 0xa001, 134 => 'ColorSpace', 151 => 0x2f, 152 => 0x25, 153 => 0x17, 185 => 0x1e, 238 => 0x507, 291 => 0x37, 319 => 0xa011, 322 => 0xb, 330 => 0x1b, 331 => 0x83, 332 => 0xe, 346 => 0x6, 387 => 'ColorSpace' },
	'colortempasshot' => { 33 => 0x4, 34 => 0x1d, 35 => 0x26, 36 => 0x43, 39 => 0x43, 40 => 0x43 },
	'colortempauto' => { 33 => 0x9, 34 => 0x22, 35 => 0x1c, 36 => 0x48, 39 => 0x48, 40 => 0x48 },
	'colortempcloudy' => { 33 => 0x22, 34 => 0x31, 35 => 0x35, 36 => 0x5c, 39 => 0x75, 40 => 0x8e, 291 => 0x55 },
	'colortempcustom' => { 36 => 0x84 },
	'colortempcustom1' => { 34 => 0x45 },
	'colortempcustom2' => { 34 => 0x4a },
	'colortempdaylight' => { 33 => 0x18, 34 => 0x27, 35 => 0x2b, 36 => 0x52, 39 => 0x6b, 40 => 0x84, 291 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 53 => 0xae, 63 => 0x9, 84 => 0x10ae, 103 => 0x1005, 112 => 0x846, 128 => 'ColorTemperature', 151 => [0x6e,0x49], 152 => 0x3f, 153 => [0x39,0x5e], 155 => 0x10b, 158 => [0x3c,0x4c,0x4e], 254 => 0x321, 291 => 0x50, 313 => 0x1308, 342 => 0xb021, 383 => 'Temperature' },
	'colortemperatureadj' => { 369 => 0x8013 },
	'colortemperaturebg' => { 243 => 0x1013 },
	'colortemperaturecustom' => { 330 => 0xc, 331 => 0xb },
	'colortemperaturerg' => { 243 => 0x1014 },
	'colortemperatureset' => { 330 => 0x7, 331 => 0x6 },
	'colortemperaturesetting' => { 153 => 0x25, 332 => 0x17, 346 => 0xe },
	'colortempflash' => { 33 => 0x36, 34 => 0x40, 35 => 0x49, 36 => 0x70, 39 => 0x89, 40 => 0xa2, 291 => 0x5a },
	'colortempflashdata' => { 36 => 0x24a },
	'colortempfluorescent' => { 33 => 0x2c, 34 => 0x3b, 35 => 0x3f, 36 => 0x66, 39 => 0x7f, 40 => 0x98 },
	'colortempfluorescentd' => { 291 => 0x57 },
	'colortempfluorescentn' => { 291 => 0x58 },
	'colortempfluorescentw' => { 291 => 0x59 },
	'colortempkelvin' => { 33 => 0x31, 35 => 0x44, 36 => 0x6b, 39 => 0x84, 40 => 0x9d, 258 => 0x44, 313 => 0x1307 },
	'colortempmeasured' => { 33 => 0xe, 36 => 0x4d, 39 => 0x4d, 40 => 0x4d },
	'colortemppc1' => { 35 => 0x94, 36 => 0x75 },
	'colortemppc2' => { 35 => 0x99, 36 => 0x7a },
	'colortemppc3' => { 35 => 0x9e, 36 => 0x7f },
	'colortempshade' => { 33 => 0x1d, 34 => 0x2c, 35 => 0x30, 36 => 0x57, 39 => 0x70, 40 => 0x89, 291 => 0x54 },
	'colortemptungsten' => { 33 => 0x27, 34 => 0x36, 35 => 0x3a, 36 => 0x61, 39 => 0x7a, 40 => 0x93, 291 => 0x56 },
	'colortempunknown' => { 33 => 0x13, 35 => 0x21, 39 => 0x52, 40 => 0x52 },
	'colortempunknown10' => { 33 => 0x63, 35 => 0x76, 39 => 0xa2, 40 => 0x7f },
	'colortempunknown11' => { 33 => 0x68, 35 => 0x7b, 39 => 0xa7, 40 => 0xa7 },
	'colortempunknown12' => { 33 => 0x6d, 35 => 0x80, 39 => 0xac, 40 => 0xac },
	'colortempunknown13' => { 33 => 0x72, 35 => 0x85, 39 => 0xb1, 40 => 0xb1 },
	'colortempunknown14' => { 35 => 0x8a, 39 => 0xb6, 40 => 0xb6 },
	'colortempunknown15' => { 35 => 0x8f, 39 => 0xbb, 40 => 0xbb },
	'colortempunknown16' => { 35 => 0xa3, 40 => 0xc0 },
	'colortempunknown17' => { 40 => 0xc5 },
	'colortempunknown18' => { 40 => 0xca },
	'colortempunknown19' => { 40 => 0xcf },
	'colortempunknown2' => { 33 => 0x3b, 35 => 0x4e, 39 => 0x57, 40 => 0x57 },
	'colortempunknown20' => { 40 => 0xd4 },
	'colortempunknown3' => { 33 => 0x40, 35 => 0x53, 39 => 0x5c, 40 => 0x5c },
	'colortempunknown4' => { 33 => 0x45, 35 => 0x58, 39 => 0x61, 40 => 0x61 },
	'colortempunknown5' => { 33 => 0x4a, 35 => 0x5d, 39 => 0x66, 40 => 0x66 },
	'colortempunknown6' => { 33 => 0x4f, 35 => 0x62, 39 => 0x8e, 40 => 0x6b },
	'colortempunknown7' => { 33 => 0x54, 35 => 0x67, 39 => 0x93, 40 => 0x70 },
	'colortempunknown8' => { 33 => 0x59, 35 => 0x6c, 39 => 0x98, 40 => 0x75 },
	'colortempunknown9' => { 33 => 0x5e, 35 => 0x71, 39 => 0x9d, 40 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 30 => 0x2a, 41 => 0x2 },
	'colortoneadj' => { 89 => 0x11e },
	'colortoneauto' => { 60 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 59 => 0x6c, 60 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 59 => 0x3c, 60 => 0x3c },
	'colortonemonochrome' => { 59 => 0x84, 60 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 59 => 0x54, 60 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 59 => 0x24, 60 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 59 => 0xc, 60 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 59 => 0x9c, 60 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 59 => 0xb4, 60 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 59 => 0xcc, 60 => 0xe4 },
	'commanddials' => { 234 => '5.1' },
	'commanddialsaperturesetting' => { 226 => '17.3', 227 => '18.3', 232 => '33.3', 233 => '17.3' },
	'commanddialschangemainsub' => { 226 => '17.2', 227 => '18.1', 232 => '33.2', 233 => '17.2' },
	'commanddialsmenuandplayback' => { 226 => '17.4', 227 => '18.2', 232 => '33.4', 233 => '17.4' },
	'commanddialsreverserotation' => { 226 => '17.1', 227 => '6.4', 229 => '16.2', 230 => '17.2', 232 => '33.1', 233 => '17.1', 236 => '18.1' },
	'commanderchannel' => { 234 => '10.2', 235 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 234 => '13.1', 235 => '31.1' },
	'commandergroupa_ttlcomp' => { 236 => '32.1' },
	'commandergroupamanualoutput' => { 234 => '13.2', 235 => '28.2' },
	'commandergroupamode' => { 234 => '11.2', 235 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 234 => '14.1', 235 => '32.1' },
	'commandergroupb_ttlcomp' => { 236 => '33.1' },
	'commandergroupbmanualoutput' => { 234 => '14.2', 235 => '29.2' },
	'commandergroupbmode' => { 234 => '11.3', 235 => '29.1' },
	'commanderinternalflash' => { 234 => '11.1', 235 => '27.1' },
	'commanderinternalmanualoutput' => { 234 => '12.2', 235 => '27.2' },
	'commanderinternalttlchannel' => { 232 => '18.2' },
	'commanderinternalttlcomp' => { 234 => '12.1', 235 => '30.2', 236 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 232 => '20.1', 233 => '26.1' },
	'commanderinternalttlcompgroupa' => { 232 => '21.1', 233 => '27.1' },
	'commanderinternalttlcompgroupb' => { 232 => '22.1', 233 => '28.1' },
	'comment' => { 0 => 0x2, 99 => 'Comment', 129 => 'Comment', 250 => 'Comment' },
	'compass' => { 316 => 0x4 },
	'complianceprofile' => { 397 => 'complianceProfile' },
	'componentsconfiguration' => { 98 => 0x9101, 134 => 'Components', 387 => 'ComponentsConfiguration' },
	'componentversion' => { 84 => 0x80c },
	'composer' => { 406 => 'composer' },
	'compositionadjust' => { 290 => '0.1' },
	'compositionadjustrotation' => { 290 => 0x7 },
	'compositionadjustx' => { 290 => 0x5 },
	'compositionadjusty' => { 290 => 0x6 },
	'compressedbitsperpixel' => { 98 => 0x9102, 387 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 155 => 0x40, 243 => 0x40 },
	'compression' => { 98 => 0x103, 402 => 'Compression' },
	'compressionfactor' => { 238 => 0x50d },
	'compressionratio' => { 134 => 'Compression', 243 => 0x1034 },
	'confidencelevel' => { 379 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 89 => 0x266, 299 => 0xd6 },
	'constrainedcropwidth' => { 89 => 0x262, 299 => 0xd5 },
	'contact' => { 106 => 0x76 },
	'contentlocationcode' => { 106 => 0x1a },
	'contentlocationname' => { 106 => 0x1b },
	'continuousbracketing' => { 153 => 0x20 },
	'continuousdrive' => { 30 => 0x5 },
	'continuousshootingspeed' => { 71 => 0x610 },
	'continuousshotlimit' => { 71 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 30 => 0xd, 93 => 0xc, 94 => [0x3012,0x20], 98 => [0xa408,0xfe54], 103 => [0x1004,0x1006], 128 => 'Contrast', 150 => 0x20, 151 => 0x31, 152 => 0x27, 153 => 0x19, 158 => 0x2, 187 => 0x33, 243 => 0x1029, 258 => 0x39, 260 => 0x300a, 291 => 0x20, 297 => 0xc, 309 => 0x24, 313 => 0x1012, 322 => 0xd, 330 => 0x1d, 331 => 0x1a, 342 => 0x2004, 383 => 'Contrast', 387 => 'Contrast' },
	'contrast2012' => { 383 => 'Contrast2012' },
	'contrastadj' => { 89 => 0x115, 222 => 0x2c, 369 => 0x8017 },
	'contrastauto' => { 60 => 0x90 },
	'contrastcurve' => { 185 => 0x8c },
	'contrastdetectaf' => { 161 => 0x4 },
	'contrastdetectafarea' => { 291 => 0x231 },
	'contrastdetectafinfocus' => { 161 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 59 => 0x60, 60 => 0x60 },
	'contrasthighlight' => { 291 => 0x6d },
	'contrasthighlightshadowadj' => { 291 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 59 => 0x30, 60 => 0x30 },
	'contrastmode' => { 258 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 59 => 0x78, 60 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 59 => 0x48, 60 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 59 => 0x18, 60 => 0x18 },
	'contrastsetting' => { 238 => 0x505, 246 => 0x1012, 332 => 0x10, 346 => 0x8 },
	'contrastshadow' => { 291 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 59 => 0x0, 60 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 59 => 0x90, 60 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 59 => 0xa8, 60 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 59 => 0xc0, 60 => 0xd8 },
	'contributedmedia' => { 406 => 'contributedMedia' },
	'contributedmediaduration' => { 406 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 406 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 406 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 406 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 406 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 406 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 406 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 406 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 406 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 406 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 384 => 'contributor' },
	'contributors' => { 129 => 'Contributors' },
	'controldialset' => { 153 => 0x46 },
	'controlledvocabularyterm' => { 393 => 'CVterm' },
	'controllerboardversion' => { 254 => 0x332 },
	'controlmode' => { 65 => 0x12 },
	'conversionlens' => { 239 => 0x403, 258 => 0x35 },
	'converter' => { 98 => 0xfe4d, 209 => 0xb, 383 => 'Converter' },
	'converttograyscale' => { 383 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 98 => 0x8298, 129 => 'Copyright', 250 => 'Copyright', 291 => 0x22f, 304 => 'Copyright', 394 => 'Copyright', 397 => 'copyright', 399 => 'copyright', 402 => 'Copyright', 406 => 'copyright' },
	'copyrightflag' => { 302 => 0x40a },
	'copyrightnotice' => { 106 => 0x74 },
	'copyrightowner' => { 396 => 'CopyrightOwner' },
	'copyrightownerid' => { 396 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 396 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 396 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 396 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 396 => 'CopyrightStatus' },
	'coringfilter' => { 242 => 0x310, 243 => 0x102d, 246 => 0x310 },
	'coringvalues' => { 242 => 0x311, 246 => 0x311 },
	'corporateentity' => { 397 => 'corporateEntity' },
	'country' => { 133 => 'Country', 258 => 0x69, 395 => 'Country' },
	'country-primarylocationcode' => { 106 => 0x64 },
	'country-primarylocationname' => { 106 => 0x65 },
	'countrycode' => { 184 => 0x5, 300 => 'CountryCode', 392 => 'CountryCode' },
	'coverage' => { 384 => 'coverage' },
	'coverdate' => { 397 => 'coverDate' },
	'coverdisplaydate' => { 397 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 291 => 0x28 },
	'crc32' => { 385 => 'crc32' },
	'createdate' => { 98 => 0x9004, 129 => 'CreateDate', 247 => 'CreationDate', 250 => 'create-date', 304 => 'CreationDate', 306 => 0x1, 404 => 'CreateDate' },
	'creationdate' => { 394 => 'CreationDate', 397 => 'creationDate' },
	'creationtime' => { 250 => 'Creation Time' },
	'creativestyle' => { 330 => 0x1a, 331 => 0x18, 341 => 0x41, 342 => 0xb020, 365 => 0x4a },
	'creativestylesetting' => { 332 => 0xf, 346 => 0x7 },
	'creativestylewaschanged' => { 369 => 0x8001 },
	'creator' => { 247 => 'Creator', 304 => 'Creator', 384 => 'creator', 394 => 'Creator' },
	'creatoraddress' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 392 => 'CreatorContactInfo' },
	'creatorcountry' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 404 => 'CreatorTool' },
	'creatorworkemail' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 392 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 106 => 0x6e, 395 => 'Credit' },
	'creditline' => { 399 => 'creditLine' },
	'creditlinereq' => { 409 => 'CreditLineReq' },
	'creditlinerequired' => { 396 => 'CreditLineRequired' },
	'cropactive' => { 89 => 0x244 },
	'cropangle' => { 383 => 'CropAngle' },
	'cropaspectratio' => { 89 => 0x260 },
	'cropbottom' => { 102 => 0x9, 214 => 0x36, 299 => 0xdc, 383 => 'CropBottom' },
	'cropbottommargin' => { 43 => 0x3 },
	'cropcircleactive' => { 90 => 0xd6 },
	'cropcircleradius' => { 90 => 0xd9 },
	'cropcirclex' => { 90 => 0xd7 },
	'cropcircley' => { 90 => 0xd8 },
	'cropconstraintowarp' => { 383 => 'CropConstrainToWarp' },
	'croph' => { 377 => 'CropH' },
	'cropheight' => { 89 => 0x24c, 242 => 0x615, 246 => 0x615, 383 => 'CropHeight' },
	'crophispeed' => { 185 => 0x1b },
	'cropleft' => { 89 => 0x246, 102 => 0x6, 214 => 0x1e, 242 => 0x612, 246 => 0x612, 299 => 0xd9, 383 => 'CropLeft' },
	'cropleftmargin' => { 43 => 0x0 },
	'cropmode35mm' => { 313 => 0x1018 },
	'cropoutputheight' => { 214 => 0xce },
	'cropoutputheightinches' => { 214 => 0x96 },
	'cropoutputpixels' => { 214 => 0xd6 },
	'cropoutputresolution' => { 214 => 0xb6 },
	'cropoutputscale' => { 214 => 0xbe },
	'cropoutputwidth' => { 214 => 0xc6 },
	'cropoutputwidthinches' => { 214 => 0x8e },
	'croppedareaimageheightpixels' => { 373 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 373 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 373 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 373 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 313 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 313 => 0x1603 },
	'cropright' => { 102 => 0x8, 214 => 0x2e, 299 => 0xdb, 383 => 'CropRight' },
	'croprightmargin' => { 43 => 0x1 },
	'croprotation' => { 102 => 0xb },
	'cropscaledresolution' => { 214 => 0x9e },
	'cropsourceresolution' => { 214 => 0xae },
	'croptop' => { 89 => 0x248, 102 => 0x7, 214 => 0x26, 242 => 0x613, 246 => 0x613, 299 => 0xda, 383 => 'CropTop' },
	'croptopmargin' => { 43 => 0x2 },
	'cropunit' => { 383 => 'CropUnit' },
	'cropunits' => { 383 => 'CropUnits' },
	'cropw' => { 377 => 'CropW' },
	'cropwidth' => { 89 => 0x24a, 242 => 0x614, 246 => 0x614, 383 => 'CropWidth' },
	'cropx' => { 377 => 'CropX' },
	'cropy' => { 377 => 'CropY' },
	'crossprocess' => { 291 => 0x7b },
	'crossprocessparams' => { 291 => 0x235 },
	'currenticcprofile' => { 98 => 0xc691 },
	'currentpreprofilematrix' => { 98 => 0xc692 },
	'currentversion' => { 369 => 0xd000 },
	'curve0x' => { 377 => 'Curve0x' },
	'curve0y' => { 377 => 'Curve0y' },
	'curve1x' => { 377 => 'Curve1x' },
	'curve1y' => { 377 => 'Curve1y' },
	'curve2x' => { 377 => 'Curve2x' },
	'curve2y' => { 377 => 'Curve2y' },
	'curve3x' => { 377 => 'Curve3x' },
	'curve3y' => { 377 => 'Curve3y' },
	'curve4x' => { 377 => 'Curve4x' },
	'curve4y' => { 377 => 'Curve4y' },
	'curves' => { 219 => 0x76a43201 },
	'custom1' => { 396 => 'Custom1' },
	'custom10' => { 396 => 'Custom10' },
	'custom2' => { 396 => 'Custom2' },
	'custom3' => { 396 => 'Custom3' },
	'custom4' => { 396 => 'Custom4' },
	'custom5' => { 396 => 'Custom5' },
	'custom6' => { 396 => 'Custom6' },
	'custom7' => { 396 => 'Custom7' },
	'custom8' => { 396 => 'Custom8' },
	'custom9' => { 396 => 'Custom9' },
	'customcontrast' => { 90 => 0x4e },
	'customcontrols' => { 71 => 0x70c },
	'customdefaultunsharpfineness' => { 90 => 0xbe },
	'customdefaultunsharpstrength' => { 90 => 0xbc },
	'customdefaultunsharpthreshold' => { 90 => 0xc0 },
	'customlinear' => { 90 => 0x4f },
	'customoutputhighlightpoint' => { 90 => 0x53 },
	'customoutputshadowpoint' => { 90 => 0x54 },
	'custompicturestylefilename' => { 53 => 0x4010 },
	'customrawhighlight' => { 90 => 0x7c },
	'customrawhighlightpoint' => { 90 => 0x51 },
	'customrawshadow' => { 90 => 0x85 },
	'customrawshadowpoint' => { 90 => 0x52 },
	'customrendered' => { 98 => 0xa401, 387 => 'CustomRendered' },
	'customsaturation' => { 238 => 0x503 },
	'customsettingsalldefault' => { 226 => '0.2', 232 => '0.2' },
	'customsettingsbank' => { 226 => '0.1', 227 => '0.1', 232 => '0.1' },
	'customsharpness' => { 90 => 0x50 },
	'customunsharpmaskfineness' => { 90 => 0xb8 },
	'customunsharpmaskstrength' => { 90 => 0xb6 },
	'customunsharpmaskthreshold' => { 90 => 0xba },
	'customwb_rblevels' => { 346 => 0x1a },
	'customwb_rgblevels' => { 331 => 0x8, 332 => 0x19 },
	'customwbbluelevel' => { 153 => 0x36 },
	'customwberror' => { 153 => 0x37 },
	'customwbgreenlevel' => { 153 => 0x35 },
	'customwbredlevel' => { 153 => 0x34 },
	'customwbsetting' => { 153 => 0x26 },
	'd-lightinghq' => { 219 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 215 => 0x2 },
	'd-lightinghqhighlight' => { 215 => 0x1 },
	'd-lightinghqselected' => { 219 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 215 => 0x0 },
	'd-lightinghs' => { 219 => 0xce5554aa },
	'd-lightinghsadjustment' => { 216 => 0x0 },
	'd-lightinghscolorboost' => { 216 => 0x1 },
	'd-rangeoptimizerhighlight' => { 369 => 0x8024 },
	'd-rangeoptimizermode' => { 369 => 0x8022 },
	'd-rangeoptimizershadow' => { 369 => 0x802d },
	'd-rangeoptimizervalue' => { 369 => 0x8023 },
	'datacompressionmethod' => { 108 => 0x6e },
	'dataimprint' => { 150 => 0x34 },
	'datascaling' => { 291 => 0x3d },
	'date' => { 291 => 0x6, 384 => 'date' },
	'dateacquired' => { 148 => 'DateAcquired' },
	'datecreated' => { 106 => 0x37, 395 => 'DateCreated' },
	'datedisplayformat' => { 211 => 0x3 },
	'dateidentified' => { 97 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 229 => '4.2' },
	'daterecieved' => { 397 => 'dateRecieved' },
	'datesent' => { 107 => 0x46 },
	'datestampmode' => { 53 => 0x1c },
	'datetime' => { 378 => 'datetime', 402 => 'DateTime' },
	'datetimedigitized' => { 387 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 87 => 0x0, 98 => 0x9003, 126 => 0x14, 129 => 'OriginalDate', 309 => 0xb, 387 => 'DateTimeOriginal' },
	'datetimestamp' => { 114 => 0x64 },
	'datetimeutc' => { 238 => 0x908 },
	'daylightsavings' => { 66 => 0x3, 211 => 0x2 },
	'dccontinent' => { 97 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 97 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 97 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 97 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 97 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 97 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 97 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 97 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 97 => 'Event' },
	'dcfootprintspatialfit' => { 97 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 97 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 97 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 97 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 97 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 97 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 97 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 97 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 97 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 97 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 97 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 97 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 97 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 97 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 97 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 97 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 97 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 97 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 97 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 97 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 137 => 'Declination' },
	'decposition' => { 150 => 0x32 },
	'defaultblackrender' => { 98 => 0xc7a6 },
	'defaultcroporigin' => { 98 => 0xc61f },
	'defaultcropsize' => { 98 => 0xc620 },
	'defaulteraseoption' => { 71 => 0x813 },
	'defaultscale' => { 98 => 0xc61e },
	'defaultusercrop' => { 98 => 0xc7b5 },
	'defringe' => { 383 => 'Defringe' },
	'defringegreenamount' => { 383 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 383 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 383 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 383 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 383 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 383 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 185 => 0xa6, 191 => 0x6e },
	'deprecatedon' => { 381 => 'deprecatedOn' },
	'derivedfrom' => { 407 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 407 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 407 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 407 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 407 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 407 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 407 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 407 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 407 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 407 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 407 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 407 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 407 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 407 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 407 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 407 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 407 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 407 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 250 => 'Description', 384 => 'description', 404 => 'Description' },
	'destination' => { 107 => 0x5 },
	'destinationcity' => { 291 => 0x24, 296 => 0x3 },
	'destinationcitycode' => { 297 => 0x1001 },
	'destinationdst' => { 291 => 0x26, 296 => '0.3' },
	'developmentdynamicrange' => { 103 => 0x1403 },
	'devicesettingdescription' => { 387 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 387 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 387 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 387 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 319 => 0x2 },
	'dialdirectiontvav' => { 71 => 0x706 },
	'digitalcreationdate' => { 106 => 0x3e },
	'digitalcreationtime' => { 106 => 0x3f },
	'digitaldeehighlightadj' => { 190 => 0x202 },
	'digitaldeeshadowadj' => { 190 => 0x200 },
	'digitaldeethreshold' => { 190 => 0x201 },
	'digitalfilter' => { 322 => 0x59 },
	'digitalfilter01' => { 278 => 0x5 },
	'digitalfilter02' => { 278 => 0x16 },
	'digitalfilter03' => { 278 => 0x27 },
	'digitalfilter04' => { 278 => 0x38 },
	'digitalfilter05' => { 278 => 0x49 },
	'digitalfilter06' => { 278 => 0x5a },
	'digitalfilter07' => { 278 => 0x6b },
	'digitalfilter08' => { 278 => 0x7c },
	'digitalfilter09' => { 278 => 0x8d },
	'digitalfilter10' => { 278 => 0x9e },
	'digitalfilter11' => { 278 => 0xaf },
	'digitalfilter12' => { 278 => 0xc0 },
	'digitalfilter13' => { 278 => 0xd1 },
	'digitalfilter14' => { 278 => 0xe2 },
	'digitalfilter15' => { 278 => 0xf3 },
	'digitalfilter16' => { 278 => 0x104 },
	'digitalfilter17' => { 278 => 0x115 },
	'digitalfilter18' => { 278 => 0x126 },
	'digitalfilter19' => { 278 => 0x137 },
	'digitalfilter20' => { 278 => 0x148 },
	'digitalgain' => { 63 => 0xb },
	'digitalgem' => { 177 => 0x0 },
	'digitalice' => { 190 => 0x100 },
	'digitalimageguid' => { 393 => 'DigImageGUID' },
	'digitalroc' => { 189 => 0x0 },
	'digitalsourcefiletype' => { 393 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 393 => 'DigitalSourceType' },
	'digitalzoom' => { 30 => 0xc, 93 => 0xa, 114 => 0x68, 128 => 'DigitalZoom', 150 => 0xc, 185 => 0x86, 209 => 0xa, 243 => 0x204, 291 => 0x1e, 297 => 0xa, 321 => 0x204, 357 => 0x12, 358 => 0x12 },
	'digitalzoomon' => { 321 => 0x21b },
	'digitalzoomratio' => { 98 => 0xa404, 351 => 0x200, 353 => 0x21c, 387 => 'DigitalZoomRatio' },
	'director' => { 406 => 'director' },
	'directorphotography' => { 406 => 'directorPhotography' },
	'directory' => { 99 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 173 => 0x3 },
	'disclaimer' => { 250 => 'Disclaimer' },
	'discnumber' => { 406 => 'discNumber' },
	'displayallafpoints' => { 71 => 0x514 },
	'displayaperture' => { 30 => 0x23 },
	'displayedunitsx' => { 303 => 0x2 },
	'displayedunitsy' => { 303 => 0x6 },
	'distance1' => { 114 => 0x28 },
	'distance2' => { 114 => 0x2c },
	'distance3' => { 114 => 0x30 },
	'distance4' => { 114 => 0x34 },
	'distortion' => { 319 => 0xa050 },
	'distortioncontrol' => { 191 => 0x10 },
	'distortioncorrection' => { 90 => 0x67, 238 => 0x50b, 261 => '7.1', 281 => 0x0, 364 => 0x601, 365 => 0x5b },
	'distortioncorrection2' => { 242 => 0x1011 },
	'distortioncorrectionon' => { 90 => 0x63 },
	'distortioncorrectionsetting' => { 342 => 0x2013 },
	'distortionn' => { 261 => 0xc },
	'distortionparam02' => { 261 => 0x2 },
	'distortionparam04' => { 261 => 0x4 },
	'distortionparam08' => { 261 => 0x8 },
	'distortionparam09' => { 261 => 0x9 },
	'distortionparam11' => { 261 => 0xb },
	'distortionscale' => { 261 => 0x5 },
	'distributor' => { 397 => 'distributor' },
	'dloon' => { 90 => 0xdc },
	'dlosetting' => { 90 => 0xdd },
	'dlosettingapplied' => { 90 => 0xe4 },
	'dloshootingdistance' => { 90 => 0xde },
	'dloversion' => { 90 => 0xe5 },
	'dmcomment' => { 406 => 'comment' },
	'dngadobedata' => { 98 => 0xc634 },
	'dngbackwardversion' => { 98 => 0xc613 },
	'dnglensinfo' => { 98 => 0xc630 },
	'dngprivatedata' => { 98 => 0xc634 },
	'dngversion' => { 98 => 0xc612 },
	'document' => { 250 => 'Document' },
	'documentancestorid' => { 395 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 395 => 'DocumentAncestors' },
	'documenthistory' => { 106 => 0xe7 },
	'documentid' => { 407 => 'DocumentID' },
	'documentname' => { 98 => 0x10d },
	'documentnotes' => { 106 => 0xe6 },
	'doi' => { 397 => 'doi' },
	'dotrange' => { 98 => 0x150 },
	'dpp' => { 378 => 'dpp' },
	'drivemode' => { 94 => 0x3103, 150 => 0x6, 153 => 0x1e, 156 => 0xe, 238 => 0x600, 291 => 0x34, 313 => 0x1002, 322 => 0x3, 330 => 0x4, 331 => 0x7e, 332 => 0x34 },
	'drivemode2' => { 153 => 0xa, 272 => 0x7, 341 => 0xe, 346 => 0x1 },
	'drivemodesetting' => { 332 => 0x4 },
	'dspfirmwareversion' => { 291 => 0x27 },
	'duration' => { 56 => 0x6a, 127 => 'Duration', 141 => 'Duration', 406 => 'duration' },
	'durationscale' => { 406 => [\'duration','durationScale'] },
	'durationvalue' => { 406 => [\'duration','durationValue'] },
	'dustremovaldata' => { 53 => 0x97 },
	'dynamicafarea' => { 226 => '1.4', 232 => '1.4' },
	'dynamicareaafdisplay' => { 227 => '46.1' },
	'dynamicrange' => { 103 => 0x1400 },
	'dynamicrangeexpansion' => { 291 => 0x69, 313 => 0x100e },
	'dynamicrangemax' => { 89 => 0x7c },
	'dynamicrangemin' => { 89 => 0x7a },
	'dynamicrangeoptimizer' => { 153 => 0x15, 342 => [0xb025,0xb04f], 349 => 0x1144, 350 => [0x1144,0x324], 351 => [0x1120,0x300], 352 => [0x119c,0x37c], 353 => [0x1178,0x328], 354 => [0x1030,0x50], 355 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 341 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 330 => 0x19, 331 => 0x17, 332 => 0xd, 341 => 0x79, 346 => 0x5 },
	'dynamicrangeoptimizermode' => { 156 => 0x15, 330 => 0x18, 331 => 0x16, 341 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 153 => 0x27, 332 => 0xc, 346 => 0x4 },
	'dynamicrangesetting' => { 103 => 0x1402 },
	'e-dialinprogram' => { 272 => '1.3' },
	'e-mountversioncamera' => { 332 => 0x3f3, 368 => 0xb },
	'e-mountversionlens' => { 332 => 0x3f0, 368 => 0xd },
	'earliestageorloweststage' => { 97 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 97 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 97 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 97 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 97 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 236 => '6.1' },
	'easyexposurecompensation' => { 226 => '6.4', 227 => '6.5', 232 => '4.4', 233 => '5.2' },
	'easymode' => { 30 => 0xb },
	'edgenoisereduction' => { 220 => 0x4, 369 => 0x8028 },
	'edition' => { 397 => 'edition' },
	'editorialupdate' => { 106 => 0x8 },
	'editstatus' => { 106 => 0x7, 300 => 'EditStatus' },
	'editversionname' => { 219 => 0x3d136244 },
	'effectivelv' => { 291 => 0x2d },
	'effectivemaxaperture' => { 181 => 0x12, 182 => 0x13 },
	'eissn' => { 397 => 'eIssn' },
	'elevation' => { 137 => 'Elevation' },
	'email' => { 129 => 'EMail' },
	'embargodate' => { 397 => 'embargoDate', 399 => 'embargoDate' },
	'embdencrightsexpr' => { 393 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 393 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 393 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 393 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 395 => 'EmbeddedXMPDigest' },
	'emissivity' => { 100 => 0x3 },
	'encryptionkey' => { 319 => 0xa020 },
	'endingpage' => { 397 => 'endingPage' },
	'enduser' => { 396 => 'EndUser' },
	'enduserid' => { 396 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 396 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 406 => 'engineer' },
	'enhancedarktones' => { 212 => 0x8 },
	'enhancement' => { 93 => 0x16, 94 => 0x3016 },
	'enhancer' => { 242 => 0x300 },
	'enhancervalues' => { 242 => 0x301 },
	'envelopenumber' => { 107 => 0x28 },
	'envelopepriority' => { 107 => 0x3c },
	'enveloperecordversion' => { 107 => 0x0 },
	'epsonimageheight' => { 243 => 0x20c },
	'epsonimagewidth' => { 243 => 0x20b },
	'epsonsoftware' => { 243 => 0x20d },
	'equipmentinstitution' => { 371 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 371 => 'EquipmentManufacturer' },
	'equipmentversion' => { 239 => 0x0 },
	'ettlii' => { 71 => 0x304, 72 => 0xd, 73 => 0xe, 74 => 0x7, 75 => 0x7, 76 => 0xe },
	'event' => { 372 => 'Event', 376 => 'Event', 393 => 'Event', 397 => 'event' },
	'eventday' => { 97 => [\'Event','EventDay'] },
	'eventearliestdate' => { 97 => [\'Event','EventEarliestDate'] },
	'eventenddayofyear' => { 97 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 97 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 97 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 97 => [\'Event','EventHabitat'] },
	'eventid' => { 97 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 97 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 97 => [\'Event','EventMonth'] },
	'eventnumber' => { 309 => 0x9 },
	'eventremarks' => { 97 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 97 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 97 => [\'Event','EventSamplingProtocol'] },
	'eventstartdayofyear' => { 97 => [\'Event','EventStartDayOfYear'] },
	'eventtime' => { 97 => [\'Event','EventEventTime'] },
	'eventverbatimeventdate' => { 97 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 97 => [\'Event','EventYear'] },
	'evsteps' => { 272 => '1.2', 274 => 0x0 },
	'evstepsize' => { 229 => '5.1', 230 => '6.1', 231 => '6.1', 234 => '0.7' },
	'exclusivityenddate' => { 399 => 'exclusivityEndDate' },
	'excursiontolerance' => { 108 => 0x82 },
	'exif' => { 99 => 'EXIF' },
	'exifbyteorder' => { 99 => 'ExifByteOrder' },
	'exifcamerainfo' => { 106 => 0xe8 },
	'exifimageheight' => { 98 => 0xa003, 387 => 'PixelYDimension' },
	'exifimagewidth' => { 98 => 0xa002, 387 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 99 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 98 => 0x9000, 387 => 'ExifVersion' },
	'exitpupilposition' => { 181 => 0x4, 182 => 0x4 },
	'expirationdate' => { 106 => 0x25, 397 => 'expirationDate', 399 => 'expirationDate' },
	'expirationtime' => { 106 => 0x26 },
	'exposure' => { 98 => 0xfe51, 383 => 'Exposure' },
	'exposure2012' => { 383 => 'Exposure2012' },
	'exposureadj' => { 217 => 0x0 },
	'exposureadj2' => { 217 => 0x12 },
	'exposureadjust' => { 322 => 0xc },
	'exposurebracketingindicatorlast' => { 153 => 0x52 },
	'exposurebracketshotnumber' => { 156 => 0x2d, 341 => 0x2f },
	'exposurebracketstepsize' => { 272 => 0x8 },
	'exposurebracketvalue' => { 185 => 0x19 },
	'exposurecompensation' => { 65 => 0x6, 80 => 0x0, 98 => 0x9204, 114 => 0x24, 128 => 'ExposureComp', 150 => 0xd, 151 => 0x53, 152 => 0x1e, 156 => 0x49c0, 243 => 0x1006, 291 => 0x16, 319 => 0xa013, 322 => [0xc,0x35,0x4d], 349 => 0x114c, 350 => 0x114c, 351 => 0x1128, 353 => 0x1180, 354 => 0x1038, 355 => 0x230, 387 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 346 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 153 => 0x47, 156 => 0x2a },
	'exposurecompensationset' => { 330 => 0x3, 331 => 0x3, 332 => 0x3, 346 => 0x1e },
	'exposurecompensationsetting' => { 153 => 0x1 },
	'exposurecompstepsize' => { 226 => '6.3', 227 => '7.3', 232 => '4.3' },
	'exposurecontrolstep' => { 233 => '6.1' },
	'exposurecontrolstepsize' => { 226 => '6.2', 227 => '7.1', 232 => '4.2', 236 => '7.1' },
	'exposurecount' => { 103 => 0x1032 },
	'exposuredelaymode' => { 226 => '10.1', 227 => '11.1', 229 => '9.1', 230 => '10.1', 231 => '10.1', 232 => '10.4', 233 => '10.1', 234 => '6.4', 236 => '11.2' },
	'exposuredifference' => { 185 => 0xe },
	'exposureindex' => { 98 => 0xa215, 387 => 'ExposureIndex' },
	'exposureindicator' => { 153 => 0x50 },
	'exposurelevelincrements' => { 69 => 0x6, 70 => 0x6, 71 => 0x101, 72 => 0x5, 73 => 0x6, 74 => 0x5, 75 => 0x5, 76 => 0x6, 77 => 0x4, 330 => 0x58, 331 => 0x58 },
	'exposurelockused' => { 373 => 'ExposureLockUsed' },
	'exposuremode' => { 98 => 0xa402, 128 => 'ExposureMode', 150 => 0x1, 151 => 0xa, 152 => 0x0, 153 => 0x0, 156 => 0x34, 238 => 0x200, 256 => 0x40d, 322 => 0x8, 342 => 0xb041, 387 => 'ExposureMode' },
	'exposuremodeinmanual' => { 71 => 0x10b },
	'exposureprogram' => { 98 => 0x8822, 313 => 0x1001, 323 => 0x17e, 330 => 0x3c, 331 => 0x3c, 332 => 0x5, 336 => 0x14, 341 => 0x3f, 346 => 0x2, 349 => 0x1175, 350 => 0x1179, 351 => 0x1155, 352 => 0x11d1, 353 => 0x11ad, 354 => 0x1065, 355 => 0x25d, 365 => 0x48, 387 => 'ExposureProgram' },
	'exposureshift' => { 238 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 65 => 0x16, 98 => 0x829a, 111 => 0xfd05, 114 => 0x20, 116 => 0xfa24, 118 => 0xf104, 121 => 0x12, 123 => 0x38, 126 => 0x10, 128 => 'ExposureTime', 150 => 0x9, 151 => 0x35, 152 => 0x48, 153 => 0x8, 156 => 0x49b8, 291 => 0x12, 319 => 0xa018, 322 => [0x32,0x4a], 330 => 0x0, 331 => 0x0, 346 => [0x21,0x23,0x27], 365 => 0x10, 387 => 'ExposureTime' },
	'exposuretime2' => { 322 => [0x33,0x4b] },
	'exposuretuning' => { 185 => 0x1c },
	'exposurevalue' => { 112 => 0x3 },
	'exposurewarning' => { 103 => 0x1302 },
	'exrauto' => { 103 => 0x1033 },
	'exrmode' => { 103 => 0x1034 },
	'extendedwbdetect' => { 238 => 0x902 },
	'extender' => { 239 => 0x301 },
	'extenderfirmwareversion' => { 239 => 0x304 },
	'extendermagnification' => { 130 => 'Magnification' },
	'extendermake' => { 130 => 'Make' },
	'extendermodel' => { 130 => 'Model', 239 => 0x303 },
	'extenderserialnumber' => { 130 => 'SerialNumber', 239 => 0x302 },
	'externalflash' => { 241 => 0x1201 },
	'externalflashae1' => { 243 => 0x101f },
	'externalflashae1_0' => { 243 => 0x101b },
	'externalflashae2' => { 243 => 0x1020 },
	'externalflashae2_0' => { 243 => 0x101c },
	'externalflashbounce' => { 241 => 0x1204, 243 => 0x1026, 279 => 0x1a },
	'externalflashcompensation' => { 176 => 0x1b },
	'externalflashexposurecomp' => { 185 => 0x17, 279 => 0x19 },
	'externalflashfirmware' => { 174 => 0x6, 175 => 0x6, 176 => 0x6 },
	'externalflashflags' => { 174 => 0x8, 175 => 0x8, 176 => 0x8 },
	'externalflashguidenumber' => { 241 => 0x1203, 279 => '24.1' },
	'externalflashgvalue' => { 243 => 0x1025 },
	'externalflashmode' => { 243 => 0x1028, 279 => 0x2 },
	'externalflashzoom' => { 241 => 0x1205, 243 => 0x1027 },
	'externalsensorbrightnessvalue' => { 254 => 0x311, 260 => 0x3408 },
	'extrainfoversion' => { 334 => 0x1a },
	'eyestartaf' => { 153 => 0x40 },
	'face10position' => { 91 => 0x3f4, 92 => 0x1ec, 172 => 0x28, 276 => 0x12 },
	'face10size' => { 277 => 0x12 },
	'face11position' => { 172 => 0x2c, 276 => 0x14 },
	'face11size' => { 277 => 0x14 },
	'face12position' => { 172 => 0x30, 276 => 0x16 },
	'face12size' => { 277 => 0x16 },
	'face13position' => { 276 => 0x18 },
	'face13size' => { 277 => 0x18 },
	'face14position' => { 276 => 0x1a },
	'face14size' => { 277 => 0x1a },
	'face15position' => { 276 => 0x1c },
	'face15size' => { 277 => 0x1c },
	'face16position' => { 276 => 0x1e },
	'face16size' => { 277 => 0x1e },
	'face17position' => { 276 => 0x20 },
	'face17size' => { 277 => 0x20 },
	'face18position' => { 276 => 0x22 },
	'face18size' => { 277 => 0x22 },
	'face19position' => { 276 => 0x24 },
	'face19size' => { 277 => 0x24 },
	'face1position' => { 44 => 0x8, 91 => 0xd, 92 => 0x18, 172 => 0x4, 252 => 0x1, 276 => 0x0, 310 => 0xbc, 337 => 0x1, 338 => 0x0, 339 => 0x0, 340 => 0x5b },
	'face1size' => { 277 => 0x0 },
	'face20position' => { 276 => 0x26 },
	'face20size' => { 277 => 0x26 },
	'face21position' => { 276 => 0x28 },
	'face21size' => { 277 => 0x28 },
	'face22position' => { 276 => 0x2a },
	'face22size' => { 277 => 0x2a },
	'face23position' => { 276 => 0x2c },
	'face23size' => { 277 => 0x2c },
	'face24position' => { 276 => 0x2e },
	'face24size' => { 277 => 0x2e },
	'face25position' => { 276 => 0x30 },
	'face25size' => { 277 => 0x30 },
	'face26position' => { 276 => 0x32 },
	'face26size' => { 277 => 0x32 },
	'face27position' => { 276 => 0x34 },
	'face27size' => { 277 => 0x34 },
	'face28position' => { 276 => 0x36 },
	'face28size' => { 277 => 0x36 },
	'face29position' => { 276 => 0x38 },
	'face29size' => { 277 => 0x38 },
	'face2position' => { 44 => 0xa, 91 => 0x7c, 92 => 0x4c, 172 => 0x8, 252 => 0x5, 276 => 0x2, 310 => 0xc8, 337 => 0x6, 338 => 0x20, 339 => 0x25, 340 => 0x65 },
	'face2size' => { 277 => 0x2 },
	'face30position' => { 276 => 0x3a },
	'face30size' => { 277 => 0x3a },
	'face31position' => { 276 => 0x3c },
	'face31size' => { 277 => 0x3c },
	'face32position' => { 276 => 0x3e },
	'face32size' => { 277 => 0x3e },
	'face3position' => { 44 => 0xc, 91 => 0xeb, 92 => 0x80, 172 => 0xc, 252 => 0x9, 276 => 0x4, 310 => 0xd4, 337 => 0xb, 338 => 0x40, 339 => 0x4a, 340 => 0x6f },
	'face3size' => { 277 => 0x4 },
	'face4position' => { 44 => 0xe, 91 => 0x15a, 92 => 0xb4, 172 => 0x10, 252 => 0xd, 276 => 0x6, 310 => 0xe0, 337 => 0x10, 338 => 0x60, 339 => 0x6f, 340 => 0x79 },
	'face4size' => { 277 => 0x6 },
	'face5position' => { 44 => 0x10, 91 => 0x1c9, 92 => 0xe8, 172 => 0x14, 252 => 0x11, 276 => 0x8, 310 => 0xec, 337 => 0x15, 338 => 0x80, 339 => 0x94 },
	'face5size' => { 277 => 0x8 },
	'face6position' => { 44 => 0x12, 91 => 0x238, 92 => 0x11c, 172 => 0x18, 276 => 0xa, 310 => 0xf8, 337 => 0x1a, 338 => 0xa0, 339 => 0xb9 },
	'face6size' => { 277 => 0xa },
	'face7position' => { 44 => 0x14, 91 => 0x2a7, 92 => 0x150, 172 => 0x1c, 276 => 0xc, 310 => 0x104, 337 => 0x1f, 338 => 0xc0, 339 => 0xde },
	'face7size' => { 277 => 0xc },
	'face8position' => { 44 => 0x16, 91 => 0x316, 92 => 0x184, 172 => 0x20, 276 => 0xe, 310 => 0x110, 337 => 0x24, 338 => 0xe0, 339 => 0x103 },
	'face8size' => { 277 => 0xe },
	'face9position' => { 44 => 0x18, 91 => 0x385, 92 => 0x1b8, 172 => 0x24, 276 => 0x10 },
	'face9size' => { 277 => 0x10 },
	'facedetect' => { 291 => 0x76, 319 => 0x100 },
	'facedetectarea' => { 242 => 0x1201 },
	'facedetectframecrop' => { 242 => 0x1207 },
	'facedetectframesize' => { 44 => 0x3, 91 => 0x1, 92 => 0x4, 172 => 0x1, 242 => 0x1203, 291 => 0x77, 310 => 0xb6 },
	'facedetection' => { 332 => 0x30, 346 => 0x19 },
	'faceid' => { 379 => 'FaceID' },
	'faceinfounknown' => { 94 => 0x2089 },
	'facename' => { 319 => 0x123 },
	'faceorientation' => { 92 => 0x8 },
	'faceposition' => { 275 => 0x2, 320 => 0x4 },
	'facepositions' => { 103 => 0x4103 },
	'facerecognition' => { 319 => 0x120 },
	'facesdetected' => { 44 => 0x2, 45 => 0x2, 46 => 0x3, 91 => 0x0, 92 => 0x2, 94 => 0x211c, 103 => 0x4100, 172 => 0x3, 242 => 0x1200, 258 => 0x3f, 275 => 0x0, 310 => 0xb5, 320 => 0x0, 337 => 0x0, 340 => 0x3, 348 => 0x30 },
	'facesrecognized' => { 253 => 0x0 },
	'facewidth' => { 45 => 0x1 },
	'faithfuloutputhighlightpoint' => { 90 => 0x38 },
	'faithfuloutputshadowpoint' => { 90 => 0x39 },
	'faithfulrawcolortone' => { 90 => 0x31 },
	'faithfulrawcontrast' => { 90 => 0x33 },
	'faithfulrawhighlight' => { 90 => 0x79 },
	'faithfulrawhighlightpoint' => { 90 => 0x36 },
	'faithfulrawlinear' => { 90 => 0x34 },
	'faithfulrawsaturation' => { 90 => 0x32 },
	'faithfulrawshadow' => { 90 => 0x82 },
	'faithfulrawshadowpoint' => { 90 => 0x37 },
	'faithfulrawsharpness' => { 90 => 0x35 },
	'faithfulunsharpmaskfineness' => { 90 => 0xac },
	'faithfulunsharpmaskstrength' => { 90 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 90 => 0xae },
	'femicroadjustment' => { 71 => 0x111 },
	'ffid' => { 385 => 'ffid' },
	'fieldcount' => { 243 => 0x103f },
	'filecreatedate' => { 99 => 'FileCreateDate' },
	'filedatarate' => { 406 => 'fileDataRate' },
	'fileformat' => { 82 => 0x0, 107 => 0x14, 322 => [0x22,0x26], 342 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 259 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 99 => 'FileModifyDate' },
	'filename' => { 99 => 'FileName' },
	'filenameasdelivered' => { 396 => 'FileNameAsDelivered' },
	'filenumber' => { 47 => 0x1, 53 => 0x8, 84 => 0x1817, 95 => 'FileNumber', 173 => 0x4 },
	'filenumbermemory' => { 150 => 0x1a },
	'filenumbersequence' => { 226 => '12.2', 229 => '3.1', 230 => '4.1', 231 => '4.1', 232 => '11.1', 233 => '4.3', 236 => '5.2' },
	'filesource' => { 98 => 0xa300, 103 => 0x8000, 387 => 'FileSource' },
	'fileversion' => { 107 => 0x16 },
	'fillflashautoreduction' => { 69 => 0xe, 70 => 0xe, 77 => 0xa },
	'filllight' => { 383 => 'FillLight' },
	'fillorder' => { 98 => 0x10a },
	'filmmode' => { 103 => 0x1401, 256 => 0x412, 258 => 0x42 },
	'filmtype' => { 190 => 0x2 },
	'filtereffect' => { 47 => 0xe, 187 => 0x37 },
	'filtereffectauto' => { 60 => 0xa0 },
	'filtereffectfaithful' => { 59 => 0x70, 60 => 0x70 },
	'filtereffectlandscape' => { 59 => 0x40, 60 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 59 => 0x88, 60 => 0x88 },
	'filtereffectneutral' => { 59 => 0x58, 60 => 0x58 },
	'filtereffectportrait' => { 59 => 0x28, 60 => 0x28 },
	'filtereffectstandard' => { 59 => 0x10, 60 => 0x10 },
	'filtereffectuserdef1' => { 59 => 0xa0, 60 => 0xb8 },
	'filtereffectuserdef2' => { 59 => 0xb8, 60 => 0xd0 },
	'filtereffectuserdef3' => { 59 => 0xd0, 60 => 0xe8 },
	'finderdisplayduringexposure' => { 70 => 0x1 },
	'finesharpness' => { 291 => 0x70 },
	'finetuneoptcenterweighted' => { 226 => '7.2', 227 => '9.1', 236 => '9.1' },
	'finetuneoptmatrixmetering' => { 226 => '8.1', 227 => '8.2', 232 => '6.1', 236 => '8.2' },
	'finetuneoptspotmetering' => { 226 => '8.2', 227 => '9.2', 232 => '6.2', 236 => '9.2' },
	'firmware' => { 243 => 0x405, 322 => [0x17,0x3b,0x57], 380 => 'Firmware' },
	'firmwaredate' => { 93 => 0x15, 94 => 0x2001, 309 => 0x4 },
	'firmwareid' => { 157 => 0x0 },
	'firmwarename' => { 319 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 53 => 0x1e, 311 => 0x0 },
	'firmwarerevision2' => { 311 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 112 => 0xce5, 126 => 0x57, 128 => 'FirmwareVersion', 258 => 0x2, 260 => 0x3109, 291 => 0x230, 313 => 0x2 },
	'firstphotodate' => { 373 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 396 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 106 => 0x16 },
	'flash' => { 95 => 'Flash', 98 => 0x9209, 151 => 0x1f, 152 => 0x15, 387 => 'Flash' },
	'flashaction' => { 330 => 0x3e, 331 => 0x3e, 342 => 0x2017, 346 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 330 => 0x4c, 331 => 0x4c, 346 => 0x77 },
	'flashactionexternal' => { 346 => [0x78,0x7c] },
	'flashactivity' => { 30 => 0x1c },
	'flashbatterylevel' => { 36 => 0x249 },
	'flashbias' => { 258 => 0x24 },
	'flashbits' => { 30 => 0x1d },
	'flashbuttonfunction' => { 71 => 0x70e },
	'flashchargelevel' => { 243 => 0x1010 },
	'flashcolorfilter' => { 176 => 0x10 },
	'flashcommandermode' => { 174 => '9.1', 175 => '9.1', 176 => '9.1' },
	'flashcompensation' => { 174 => 0xa, 175 => 0xa, 176 => 0xa, 380 => 'FlashCompensation' },
	'flashcontrol' => { 330 => 0x23, 331 => 0x1f, 332 => 0x21 },
	'flashcontrolbuilt-in' => { 232 => '16.1', 233 => '23.1', 235 => '23.1' },
	'flashcontrolmode' => { 174 => '9.2', 175 => '9.2', 176 => '9.2', 238 => 0x404 },
	'flashcurtain' => { 258 => 0x48 },
	'flashdefault' => { 153 => 0x42 },
	'flashdevice' => { 243 => 0x1005 },
	'flashdistance' => { 94 => 0x2034 },
	'flashenergy' => { 98 => 0xa20b, 387 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 185 => 0x18 },
	'flashexposurecomp' => { 65 => 0xf, 103 => 0x1011, 131 => 'ExposureComp', 150 => 0x23, 155 => 0x104, 156 => 0x49c1, 185 => 0x12, 238 => 0x401, 243 => 0x1023, 291 => 0x4d, 313 => 0x100b, 322 => [0x3a,0x56], 342 => 0x104 },
	'flashexposurecomp2' => { 207 => 0x4d2 },
	'flashexposurecomp3' => { 176 => 0x1d },
	'flashexposurecomp4' => { 176 => 0x27 },
	'flashexposurecomparea' => { 227 => '38.4' },
	'flashexposurecompset' => { 153 => 0x10, 265 => 0xe, 330 => 0x14, 331 => 0x12, 332 => 0x23, 346 => 0x1f },
	'flashexposurecompset2' => { 346 => [0x26,0x2c] },
	'flashexposureindicator' => { 153 => 0x54 },
	'flashexposureindicatorlast' => { 153 => 0x56 },
	'flashexposureindicatornext' => { 153 => 0x55 },
	'flashexposurelock' => { 47 => 0x19 },
	'flashfired' => { 114 => 0x5d, 131 => 'Fired', 150 => 0x14, 206 => '590.3', 258 => 0x8007, 387 => [\'Flash','FlashFired'] },
	'flashfiring' => { 71 => 0x306, 72 => 0x6, 73 => 0x7, 76 => 0x7 },
	'flashfirmwareversion' => { 239 => 0x1002 },
	'flashfocallength' => { 174 => 0xb, 175 => 0xc, 176 => 0xc },
	'flashfunction' => { 156 => 0x31, 387 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 174 => 0xe, 175 => 0xf, 176 => 0xf },
	'flashgroupacompensation' => { 174 => 0x11, 175 => 0x12, 176 => 0x13 },
	'flashgroupacontrolmode' => { 174 => 0xf, 175 => '16.1', 176 => '17.1' },
	'flashgroupaoutput' => { 174 => 0x11, 175 => 0x12, 176 => 0x13 },
	'flashgroupbcompensation' => { 174 => 0x12, 175 => 0x13, 176 => 0x14 },
	'flashgroupbcontrolmode' => { 174 => 0x10, 175 => '17.1', 176 => '18.1' },
	'flashgroupboutput' => { 174 => 0x12, 175 => 0x13, 176 => 0x14 },
	'flashgroupccompensation' => { 175 => 0x14, 176 => 0x15 },
	'flashgroupccontrolmode' => { 175 => '17.2', 176 => '18.2' },
	'flashgroupcoutput' => { 175 => 0x14, 176 => 0x15 },
	'flashguidenumber' => { 65 => 0xd, 81 => 0x0, 131 => 'GuideNumber' },
	'flashintensity' => { 93 => [0x19,0x5], 238 => 0x405 },
	'flashlevel' => { 228 => 0x9, 342 => 0xb048 },
	'flashmake' => { 131 => 'Make' },
	'flashmanufacturer' => { 148 => 'FlashManufacturer' },
	'flashmetering' => { 150 => 0x3f, 153 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 291 => 0x20a },
	'flashmode' => { 93 => 0x4, 114 => 0x5c, 131 => 'Mode', 150 => 0x2, 151 => 0x20, 152 => 0x16, 153 => 0xf, 185 => 0x87, 238 => 0x400, 243 => 0x1004, 291 => 0xc, 297 => 0x4, 312 => 0x20, 313 => 0x100a, 321 => 0x225, 330 => 0x13, 331 => 0x7f, 332 => 0x20, 346 => 0x10, 349 => 0x1138, 350 => 0x1138, 351 => 0x1114, 352 => 0x1190, 353 => 0x116c, 354 => 0x1024, 355 => 0x21c, 387 => [\'Flash','FlashMode'] },
	'flashmodel' => { 131 => 'Model', 148 => 'FlashModel', 239 => 0x1001 },
	'flashoptions' => { 272 => 0x2 },
	'flashoptions2' => { 272 => 0x10 },
	'flashoutput' => { 36 => 0x248, 65 => 0x21, 174 => 0xa, 175 => 0xa, 176 => 0xa },
	'flashpixversion' => { 98 => 0xa000, 387 => 'FlashpixVersion' },
	'flashredeyemode' => { 387 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 238 => 0x403 },
	'flashreturn' => { 387 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 131 => 'SerialNumber', 239 => 0x1003 },
	'flashsetting' => { 185 => 0x8 },
	'flashshutterspeed' => { 226 => '20.2', 227 => '23.2', 232 => '15.2', 233 => '22.2', 234 => '7.2', 235 => '22.2', 236 => '23.1' },
	'flashsource' => { 174 => 0x4, 175 => 0x4, 176 => 0x4 },
	'flashstatus' => { 279 => 0x0, 346 => [0x82,0x86], 356 => 0x31 },
	'flashstatusbuilt-in' => { 332 => [0x87,0x287] },
	'flashstatusexternal' => { 332 => [0x88,0x288] },
	'flashsyncspeed' => { 226 => '20.1', 227 => '23.1', 232 => '15.1', 233 => '22.1', 235 => '22.1' },
	'flashsyncspeedav' => { 69 => 0x3, 71 => 0x10f, 72 => 0x2, 73 => 0x3, 74 => 0x2, 75 => 0x2, 76 => 0x3, 77 => 0x6 },
	'flashthreshold' => { 81 => 0x1 },
	'flashtype' => { 131 => 'Type', 153 => 0x59, 185 => 0x9, 239 => 0x1000 },
	'flashwarning' => { 233 => '30.1', 234 => '7.1', 236 => '31.1', 258 => 0x62 },
	'flexiblespotposition' => { 342 => 0x201d },
	'flickerreduce' => { 321 => 0x218 },
	'fliphorizontal' => { 219 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 65 => 0x15, 98 => 0x829d, 111 => 0xfd04, 114 => 0x1e, 116 => 0xfa23, 118 => 0xf103, 121 => 0x13, 123 => 0x3c, 126 => 0xc, 135 => 'FNumber', 150 => 0xa, 151 => 0x36, 152 => 0x47, 153 => 0x9, 156 => 0x49c7, 291 => 0x13, 319 => 0xa019, 322 => [0x31,0x49], 330 => 0x1, 331 => 0x1, 346 => [0x20,0x22,0x26], 387 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 49 => 0x1, 94 => 0x1d, 98 => 0x920a, 121 => 0x1d, 135 => 'FocalLength', 150 => 0x12, 181 => 0xa, 182 => 0xb, 282 => 0x9, 291 => 0x1d, 313 => 0x1500, 329 => 0xe, 353 => 0x1278, 354 => 0x1134, 355 => 0x32c, 387 => 'FocalLength' },
	'focallength2' => { 346 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 98 => 0xa405, 319 => 0xa01a, 387 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 329 => 0x10 },
	'focalplanediagonal' => { 239 => 0x103, 243 => 0x205 },
	'focalplaneresolutionunit' => { 98 => 0xa210, 387 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 98 => 0xa20e, 387 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 49 => 0x2 },
	'focalplanexunknown' => { 49 => 0x2 },
	'focalplaneyresolution' => { 98 => 0xa20f, 387 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 49 => 0x3 },
	'focalplaneyunknown' => { 49 => 0x3 },
	'focaltype' => { 9 => 0x2d, 49 => 0x0 },
	'focalunits' => { 30 => 0x19 },
	'focus' => { 209 => 0x8 },
	'focusarea' => { 150 => 0x31 },
	'focusareaselection' => { 234 => '15.2' },
	'focuscontinuous' => { 30 => 0x20 },
	'focusdisplayaiservoandmf' => { 71 => 0x515 },
	'focusdistance' => { 135 => 'FocusDistance', 150 => 0x13, 156 => 0x49bb, 181 => 0x9, 182 => 0xa, 241 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 47 => 0x15, 65 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 47 => 0x14, 65 => 0x13 },
	'focusholdbutton' => { 153 => 0x44 },
	'focusinfoversion' => { 241 => 0x0 },
	'focusingscreen' => { 70 => 0x0, 71 => 0x80b, 76 => 0x0 },
	'focuslocked' => { 149 => 0x14 },
	'focusmode' => { 30 => 0x7, 93 => 0x3, 94 => [0x3003,0xd], 103 => 0x1021, 114 => 0x38, 128 => 'FocusMode', 150 => 0x30, 152 => 0xe, 153 => 0xc, 185 => 0x7, 238 => 0x301, 243 => 0x100b, 258 => 0x7, 291 => 0xd, 297 => 0x3, 313 => 0x1006, 323 => [0xb,0x5], 329 => [0x15,0x1d], 330 => 0x4d, 331 => 0x4d, 342 => [0xb042,0xb04e,0x201b], 346 => 0x13, 360 => 0x16 },
	'focusmode2' => { 272 => '3.1', 346 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 228 => '10.1', 327 => 0x14, 328 => 0x15, 330 => 0x10, 331 => 0xf, 332 => 0x6 },
	'focusmodeswitch' => { 153 => 0x58, 330 => 0x2e },
	'focuspixel' => { 103 => 0x1023 },
	'focuspointwrap' => { 226 => '2.2', 227 => '2.2', 232 => '2.2', 233 => '1.2', 236 => '2.5' },
	'focusposition' => { 181 => 0x8, 182 => 0x8, 291 => 0x10, 341 => 0x9bb },
	'focusposition2' => { 346 => [0x29,0x2b,0x2f], 360 => 0x2d, 363 => 0x20 },
	'focusprocess' => { 238 => 0x302 },
	'focusrange' => { 30 => 0x12, 243 => 0x100a },
	'focusrangeindex' => { 282 => '3.1' },
	'focussetting' => { 322 => 0x6 },
	'focusstatus' => { 329 => 0x19, 330 => 0x53, 331 => 0x53 },
	'focusstepcount' => { 241 => 0x301, 243 => 0x100e },
	'focusstepinfinity' => { 241 => 0x303, 243 => 0x103b },
	'focusstepnear' => { 241 => 0x304, 243 => 0x103c },
	'focustrackinglockon' => { 226 => ['1.5','4.1'], 227 => '1.4', 232 => '3.1', 233 => '0.4' },
	'focuswarning' => { 103 => 0x1301 },
	'foldername' => { 150 => 0x27 },
	'foldernumber' => { 330 => 0x9a, 332 => [0x402,0x114,0x316] },
	'fontcomposite' => { 411 => [\'Fonts','FontsComposite'] },
	'fontface' => { 411 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 411 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 411 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 411 => [\'Fonts','FontsFontName'] },
	'fonts' => { 411 => 'Fonts' },
	'fonttype' => { 411 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 411 => [\'Fonts','FontsVersionString'] },
	'for' => { 304 => 'For' },
	'format' => { 384 => 'format', 404 => 'Format' },
	'forwardlock' => { 401 => 'forwardlock' },
	'forwardmatrix1' => { 98 => 0xc714 },
	'forwardmatrix2' => { 98 => 0xc715 },
	'framecount' => { 56 => [0x2,0x4] },
	'frameheight' => { 103 => 0x3822 },
	'framenum' => { 299 => 0xd7 },
	'framenumber' => { 103 => 0x8003, 156 => 0x3c, 291 => 0x29 },
	'framerate' => { 56 => [0x1,0x6], 98 => 0xc764, 103 => 0x3820 },
	'framewidth' => { 103 => 0x3821 },
	'freebytes' => { 84 => 0x1 },
	'freememorycardimages' => { 151 => [0x37,0x54], 152 => [0x2d,0x4a], 153 => 0x32 },
	'fujiflashmode' => { 103 => 0x1010 },
	'fullimagesize' => { 342 => 0xb02b },
	'fullpanoheightpixels' => { 373 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 373 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 313 => 0x100d },
	'fullsizeimage' => { 134 => 'data' },
	'fullsizeimagename' => { 134 => '1Name' },
	'fullsizeimagetype' => { 134 => '0Type' },
	'funcbutton' => { 226 => ['14.1','15.1'], 227 => '14.1', 232 => '28.1', 233 => '13.1', 236 => '14.1' },
	'funcbuttonplusdials' => { 226 => ['14.2','15.2'], 227 => '14.2', 232 => '31.1' },
	'functionbutton' => { 231 => '13.1', 234 => '5.2' },
	'gainbase' => { 242 => 0x610 },
	'gaincontrol' => { 98 => 0xa407, 387 => 'GainControl' },
	'gamma' => { 98 => 0xa500, 388 => 'Gamma' },
	'gammacompensatedvalue' => { 108 => 0x91 },
	'geimagesize' => { 103 => 0x1304 },
	'gemake' => { 104 => 0x300 },
	'gemodel' => { 104 => 0x207 },
	'genre' => { 397 => 'genre', 406 => 'genre' },
	'geography' => { 398 => 'geography' },
	'geologicalcontext' => { 97 => 'GeologicalContext' },
	'geologicalcontextbed' => { 97 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 97 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 97 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 97 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 97 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 99 => 'Geosync' },
	'geotag' => { 99 => 'Geotag' },
	'geotiffasciiparams' => { 98 => 0x87b1 },
	'geotiffdirectory' => { 98 => 0x87af },
	'geotiffdoubleparams' => { 98 => 0x87b0 },
	'geotime' => { 99 => 'Geotime' },
	'globalaltitude' => { 302 => 0x419 },
	'globalangle' => { 302 => 0x40d },
	'good' => { 406 => 'good' },
	'googleplusuploadcode' => { 98 => 0x9009 },
	'gpsaltitude' => { 105 => 0x6, 132 => 'Altitude', 387 => 'GPSAltitude' },
	'gpsaltituderef' => { 105 => 0x5, 387 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 105 => 0x1c, 387 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 105 => 0x1d },
	'gpsdatetime' => { 132 => 'DateTime', 387 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 105 => 0x18, 132 => 'Bearing', 387 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 105 => 0x17, 387 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 105 => 0x1a, 132 => 'Distance', 387 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 105 => 0x19, 387 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 105 => 0x14, 387 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 105 => 0x13 },
	'gpsdestlongitude' => { 105 => 0x16, 387 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 105 => 0x15 },
	'gpsdifferential' => { 105 => 0x1e, 132 => 'Differential', 387 => 'GPSDifferential' },
	'gpsdop' => { 105 => 0xb, 387 => 'GPSDOP' },
	'gpshpositioningerror' => { 105 => 0x1f, 387 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 105 => 0x11, 387 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 105 => 0x10, 387 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 105 => 0x2, 132 => 'Latitude', 387 => 'GPSLatitude' },
	'gpslatituderef' => { 105 => 0x1 },
	'gpslongitude' => { 105 => 0x4, 132 => 'Longitude', 387 => 'GPSLongitude' },
	'gpslongituderef' => { 105 => 0x3 },
	'gpsmapdatum' => { 105 => 0x12, 132 => 'Datum', 387 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 105 => 0xa, 132 => 'MeasureMode', 387 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 105 => 0x1b, 387 => 'GPSProcessingMethod' },
	'gpssatellites' => { 105 => 0x8, 132 => 'Satellites', 387 => 'GPSSatellites' },
	'gpsspeed' => { 105 => 0xd, 132 => 'Speed', 387 => 'GPSSpeed' },
	'gpsspeedref' => { 105 => 0xc, 387 => 'GPSSpeedRef' },
	'gpsstatus' => { 105 => 0x9, 387 => 'GPSStatus' },
	'gpstimestamp' => { 105 => 0x7 },
	'gpstrack' => { 105 => 0xf, 132 => 'Heading', 387 => 'GPSTrack' },
	'gpstrackref' => { 105 => 0xe, 387 => 'GPSTrackRef' },
	'gpsversionid' => { 105 => 0x0, 387 => 'GPSVersionID' },
	'gradation' => { 238 => 0x50f },
	'gradientbasedcorractive' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 383 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 383 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 383 => 'GrainAmount' },
	'grainfrequency' => { 383 => 'GrainFrequency' },
	'grainsize' => { 383 => 'GrainSize' },
	'graymixeraqua' => { 383 => 'GrayMixerAqua' },
	'graymixerblue' => { 383 => 'GrayMixerBlue' },
	'graymixergreen' => { 383 => 'GrayMixerGreen' },
	'graymixermagenta' => { 383 => 'GrayMixerMagenta' },
	'graymixerorange' => { 383 => 'GrayMixerOrange' },
	'graymixerpurple' => { 383 => 'GrayMixerPurple' },
	'graymixerred' => { 383 => 'GrayMixerRed' },
	'graymixeryellow' => { 383 => 'GrayMixerYellow' },
	'graypoint' => { 369 => 0x8021 },
	'grayresponseunit' => { 98 => 0x122 },
	'greencurvelimits' => { 89 => 0x1c4 },
	'greencurvepoints' => { 89 => 0x19a },
	'greenhue' => { 383 => 'GreenHue' },
	'greensaturation' => { 383 => 'GreenSaturation' },
	'griddisplay' => { 226 => '13.3', 227 => '4.3', 229 => '2.2', 232 => '10.5', 233 => '3.4', 234 => '6.1', 236 => '4.2' },
	'gripbatteryadload' => { 270 => 0x5 },
	'gripbatteryadnoload' => { 270 => 0x4 },
	'gripbatterystate' => { 270 => '1.2' },
	'groupareaafillumination' => { 227 => '46.4' },
	'halftonehints' => { 98 => 0x141 },
	'hardlink' => { 99 => 'HardLink' },
	'hasalternative' => { 397 => 'hasAlternative' },
	'hascorrection' => { 397 => 'hasCorrection' },
	'hascrop' => { 383 => 'HasCrop' },
	'hasextendedxmp' => { 408 => 'HasExtendedXMP' },
	'haspreviousversion' => { 397 => 'hasPreviousVersion' },
	'hassettings' => { 383 => 'HasSettings' },
	'hastranslation' => { 397 => 'hasTranslation' },
	'hdr' => { 50 => 0x1, 178 => 0x4, 258 => 0x9e, 291 => 0x85, 342 => 0x200a },
	'hdreffect' => { 50 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 178 => 0x0 },
	'hdrlevel' => { 178 => 0x5, 332 => 0x2e, 346 => 0x17 },
	'hdrlevel2' => { 178 => 0x7 },
	'hdrsetting' => { 332 => 0x2d, 346 => 0x16, 349 => 0x1148, 350 => 0x1148, 351 => 0x1124, 352 => 0x11a0, 353 => 0x117c, 354 => 0x1034, 355 => 0x22c },
	'hdrsmoothing' => { 178 => 0x6 },
	'headline' => { 106 => 0x69, 395 => 'Headline' },
	'hierarchicalkeywords' => { 143 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 143 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 143 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 143 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 143 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 143 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 375 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 97 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 262 => 0x1a },
	'highisomultipliergreen' => { 262 => 0x19 },
	'highisomultiplierred' => { 262 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 52 => 0x5, 71 => 0x202, 103 => 0x100e, 185 => 0xb1, 291 => 0x71, 330 => 0x2c, 331 => 0x26, 332 => 0x26, 342 => 0x2009, 346 => 0x12, 365 => 0x42 },
	'highisonoisereduction2' => { 342 => 0xb050 },
	'highlight' => { 322 => 0xf },
	'highlightcolordistortreduct' => { 369 => 0x8026 },
	'highlightprotection' => { 218 => 0x6 },
	'highlightrecovery' => { 383 => 'HighlightRecovery' },
	'highlights' => { 377 => 'Highlights' },
	'highlights2012' => { 383 => 'Highlights2012' },
	'highlighttone' => { 103 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 52 => 0x3, 71 => 0x203 },
	'highlowkeyadj' => { 291 => 0x6c },
	'highspeedsync' => { 153 => 0x5, 330 => 0x2, 331 => 0x2 },
	'histogramxml' => { 219 => 0x83a1a25 },
	'history' => { 395 => 'History', 407 => 'History' },
	'historyaction' => { 407 => [\'History','HistoryAction'] },
	'historychanged' => { 407 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 407 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 407 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 407 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 407 => [\'History','HistoryWhen'] },
	'hometowncity' => { 94 => 0x3006, 291 => 0x23, 296 => 0x2 },
	'hometowncitycode' => { 297 => 0x1000 },
	'hometowndst' => { 291 => 0x25, 296 => '0.2' },
	'hostcomputer' => { 98 => 0x13c },
	'hue' => { 158 => 0x3b, 291 => 0x67 },
	'hueadj' => { 222 => 0x2f, 369 => 0x8019 },
	'hueadjust' => { 313 => 0x1016 },
	'hueadjustment' => { 151 => 0x4a, 152 => 0x40, 185 => 0x92, 187 => 0x36 },
	'hueadjustmentaqua' => { 383 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 383 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 383 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 383 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 383 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 383 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 383 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 383 => 'HueAdjustmentYellow' },
	'huesetting' => { 246 => 0x1011 },
	'icc_profile' => { 99 => 'ICC_Profile' },
	'iccprofilename' => { 395 => 'ICCProfile' },
	'idccreativestyle' => { 369 => 0x8000 },
	'idcpreviewlength' => { 369 => 0x202 },
	'idcpreviewstart' => { 369 => 0x201 },
	'identification' => { 97 => 'Identification' },
	'identificationid' => { 97 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 97 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 97 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 97 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 97 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 97 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 384 => 'identifier', 404 => 'Identifier' },
	'illumination' => { 234 => '0.5' },
	'imageadjustment' => { 185 => 0x80, 209 => 0x5 },
	'imagealterationconstraints' => { 396 => 'ImageAlterationConstraints' },
	'imagearea' => { 195 => 0x10, 198 => 0x10 },
	'imageareaoffset' => { 291 => 0x38 },
	'imageauthentication' => { 185 => 0x20 },
	'imageboundary' => { 185 => 0x16 },
	'imagecount' => { 185 => 0xa5, 344 => 0x11b, 356 => 0x32 },
	'imagecount2' => { 356 => 0x4c },
	'imagecount3' => { 356 => [0x1a0,0x1aa,0x1bd] },
	'imagecreator' => { 396 => 'ImageCreator' },
	'imagecreatorid' => { 396 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 396 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 396 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 185 => 0xa2 },
	'imagedescription' => { 98 => 0x10e, 402 => 'ImageDescription' },
	'imageduplicationconstraints' => { 396 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 219 => 0xfe443a45 },
	'imageeditcount' => { 291 => 0x41 },
	'imageediting' => { 291 => 0x32 },
	'imageeffects' => { 313 => 0x1010 },
	'imagefileconstraints' => { 396 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 396 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 396 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 103 => 0x1436 },
	'imageheight' => { 98 => 0x101, 157 => 0xc, 402 => 'ImageLength' },
	'imagehistory' => { 98 => 0x9213 },
	'imageidnumber' => { 254 => 0x340 },
	'imagenumber' => { 98 => 0x9211, 128 => 'ImageNumber', 151 => 0xae, 152 => 0x5e, 330 => 0x9b, 332 => [0x400,'276.1',0x314], 380 => 'ImageNumber' },
	'imagenumber2' => { 152 => 0x62 },
	'imageoptimization' => { 185 => 0xa9 },
	'imageorientation' => { 106 => 0x83 },
	'imageprocessing' => { 185 => 0x1a },
	'imageprocessingversion' => { 242 => 0x0 },
	'imagequality' => { 128 => 'ImageQuality', 197 => '723.2', 198 => '732.2', 206 => '708.1', 258 => 0x1 },
	'imagequality2' => { 238 => 0x603 },
	'imageref' => { 391 => 'ImageRef' },
	'imagereview' => { 228 => '0.4', 234 => '0.4' },
	'imagereviewmonitorofftime' => { 227 => '21.1' },
	'imagereviewtime' => { 226 => '25.1', 228 => '2.1', 229 => '19.1', 230 => '20.1', 231 => '20.1', 232 => '9.2', 233 => '20.1', 236 => '21.2' },
	'imagesize' => { 134 => 'ImageSize' },
	'imagesizerestriction' => { 399 => 'imageSizeRestriction' },
	'imagesourcedata' => { 98 => 0x935c },
	'imagestabilization' => { 30 => 0x22, 94 => 0x3020, 103 => 0x1422, 128 => 'ImageStabilization', 151 => 0xbd, 152 => 0x71, 153 => 0x57, 154 => 0x0, 155 => [0x18,0x107,0x113], 156 => 0x49c2, 185 => 0xac, 238 => 0x604, 241 => 0x1600, 258 => 0x1a, 335 => 0x12, 336 => 0x11, 342 => 0xb026 },
	'imagestabilization2' => { 334 => 0xa },
	'imagestabilizationsetting' => { 156 => 0x14, 330 => 0x3d, 331 => 0x3d, 341 => 0x14 },
	'imagestyle' => { 330 => 0x2d, 331 => 0x27 },
	'imagesupplier' => { 396 => 'ImageSupplier' },
	'imagesupplierid' => { 396 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 396 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 396 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 100 => 0x1 },
	'imagetemperaturemin' => { 100 => 0x2 },
	'imagetone' => { 291 => 0x4f },
	'imagetype' => { 106 => 0x82, 396 => 'ImageType' },
	'imageuniqueid' => { 53 => 0x28, 98 => 0xa420, 387 => 'ImageUniqueID' },
	'imagewidth' => { 98 => 0x100, 157 => 0xe, 402 => 'ImageWidth' },
	'incrementaltemperature' => { 383 => 'IncrementalTemperature' },
	'incrementaltint' => { 383 => 'IncrementalTint' },
	'industry' => { 397 => 'industry', 398 => 'industry' },
	'infobuttonwhenshooting' => { 71 => 0x409 },
	'infraredilluminator' => { 309 => 0x28 },
	'ingredients' => { 407 => 'Ingredients' },
	'ingredientsalternatepaths' => { 407 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 407 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 407 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 407 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 407 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 407 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 407 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 407 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 407 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 407 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 407 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 407 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 407 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 407 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 407 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 407 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 407 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 373 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 373 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 373 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 373 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 226 => '4.4' },
	'initialzoomsetting' => { 226 => '9.3', 232 => '27.3' },
	'inkset' => { 98 => 0x14c },
	'inputprofile' => { 112 => 0x1389 },
	'instanceid' => { 407 => 'InstanceID' },
	'instantplaybacksetup' => { 153 => 0x3e },
	'instantplaybacktime' => { 153 => 0x3d },
	'instructions' => { 395 => 'Instructions' },
	'instrument' => { 406 => 'instrument' },
	'intellectualgenre' => { 392 => 'IntellectualGenre' },
	'intelligentauto' => { 342 => 0xb052 },
	'intelligentcontrast' => { 42 => 0x4 },
	'intelligentd-range' => { 258 => 0x79 },
	'intelligentexposure' => { 258 => 0x5d },
	'intelligentresolution' => { 258 => 0x70 },
	'interchangecolorspace' => { 108 => 0x40 },
	'internalflash' => { 150 => 0x2b, 226 => '23.1', 228 => '8.1', 229 => '22.1', 231 => '23.1', 234 => '8.1', 236 => '24.1', 241 => 0x1208 },
	'internalflashae1' => { 243 => 0x1021 },
	'internalflashae1_0' => { 243 => 0x101d },
	'internalflashae2' => { 243 => 0x1022 },
	'internalflashae2_0' => { 243 => 0x101e },
	'internalflashmode' => { 279 => 0x1 },
	'internalflashstrength' => { 279 => 0x3 },
	'internalflashtable' => { 243 => 0x1024 },
	'internallensserialnumber' => { 319 => 0xa005 },
	'internalndfilter' => { 258 => 0x9d },
	'internalserialnumber' => { 53 => 0x96, 64 => 0x9, 103 => 0x10, 156 => 0x49dc, 237 => 0x18, 239 => 0x102, 258 => 0x25, 271 => 0x4, 313 => 0x5, 356 => [0x7c,0xf0] },
	'interopindex' => { 98 => 0x1, 388 => 'InteroperabilityIndex' },
	'interopversion' => { 98 => 0x2 },
	'intervallength' => { 150 => 0x10 },
	'intervalmode' => { 150 => 0x26 },
	'intervalnumber' => { 150 => 0x11 },
	'introtime' => { 406 => 'introTime' },
	'introtimescale' => { 406 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 406 => [\'introTime','introTimeValue'] },
	'iptc' => { 99 => 'IPTC' },
	'iptc-naa' => { 98 => 0x83bb, 262 => 0x83bb },
	'iptcbitspersample' => { 108 => 0x56 },
	'iptcdigest' => { 302 => 0x425 },
	'iptcimageheight' => { 108 => 0x1e },
	'iptcimagerotation' => { 108 => 0x66 },
	'iptcimagewidth' => { 108 => 0x14 },
	'iptclastedited' => { 393 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 108 => 0xa },
	'iptcpixelheight' => { 108 => 0x32 },
	'iptcpixelwidth' => { 108 => 0x28 },
	'isbn' => { 397 => 'isbn' },
	'iscorrectionof' => { 397 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 90 => 0x3 },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 93 => 0x14, 94 => [0x3014,0x14], 98 => 0x8827, 111 => 0xfd06, 112 => 0x1784, 114 => 0x60, 116 => [0xfa2e,0xfa46], 117 => [0x27,0x28], 118 => 0xf105, 121 => 0x14, 123 => 0x4e, 126 => 0x34, 128 => 'ISO', 150 => 0x8, 156 => 0x49ba, 179 => 0x0, 185 => 0x2, 262 => 0x17, 291 => [0x8b,0x14], 297 => 0x14, 319 => 0xa014, 341 => 0x6f, 346 => [0x1f,0x21,0x25], 387 => 'ISOSpeedRatings' },
	'iso2' => { 179 => 0x6, 192 => 0x265, 193 => 0x25c, 194 => 0x265, 195 => 0x221, 196 => 0x25d, 197 => 0x256, 198 => 0x25d, 201 => 0x2b5, 204 => 0x265, 208 => 0x2b5 },
	'isoauto' => { 272 => '14.4' },
	'isoautoparameters' => { 291 => 0x7a },
	'isodisplay' => { 229 => '2.3', 230 => '3.3', 231 => '3.3', 233 => '3.3', 236 => '4.3' },
	'isoexpansion' => { 71 => 0x103, 72 => 0x7, 73 => 0x8, 76 => 0x8, 179 => 0x4 },
	'isoexpansion2' => { 179 => 0xa },
	'isofloor' => { 272 => 0x6 },
	'isoselection' => { 185 => 0xf },
	'isosensitivitystep' => { 233 => '6.2' },
	'isosetting' => { 114 => 0x5e, 128 => 'ISOSetting', 150 => 0x24, 151 => 0x26, 152 => 0x1c, 153 => 0x13, 158 => 0x6, 185 => 0x13, 272 => '17.3', 312 => 0x27, 330 => 0x16, 331 => 0x14, 332 => 0x2, 341 => 0x6d },
	'isospeed' => { 98 => 0x8833, 388 => 'ISOSpeed' },
	'isospeedexpansion' => { 70 => 0x3 },
	'isospeedincrements' => { 71 => 0x102 },
	'isospeedlatitudeyyy' => { 98 => 0x8834, 388 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 98 => 0x8835, 388 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 71 => 0x103 },
	'isostepsize' => { 226 => '6.1', 227 => '7.2', 232 => '4.1' },
	'isovalue' => { 243 => 0x1001 },
	'issn' => { 397 => 'issn' },
	'issueidentifier' => { 397 => 'issueIdentifier' },
	'issuename' => { 397 => 'issueName' },
	'istranslationof' => { 397 => 'isTranslationOf' },
	'jobid' => { 106 => 0xb8 },
	'jobname' => { 389 => 'JobName' },
	'jobref' => { 405 => 'JobRef' },
	'jobrefid' => { 405 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 405 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 405 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 389 => 'JobStatus' },
	'jpegquality' => { 9 => 0x66, 260 => 0x3034, 342 => 0xb047 },
	'jpegsize' => { 260 => 0x303a },
	'jpgfromraw' => { 84 => 0x2007, 95 => 'JpgFromRaw', 262 => 0x2e },
	'jpgfromrawlength' => { 98 => [0x117,0x202] },
	'jpgfromrawstart' => { 98 => [0x111,0x201] },
	'jpgrecordedpixels' => { 272 => '14.1' },
	'jurisdiction' => { 381 => 'jurisdiction' },
	'kelvinwb_01' => { 280 => 0x5 },
	'kelvinwb_02' => { 280 => 0x9 },
	'kelvinwb_03' => { 280 => 0xd },
	'kelvinwb_04' => { 280 => 0x11 },
	'kelvinwb_05' => { 280 => 0x15 },
	'kelvinwb_06' => { 280 => 0x19 },
	'kelvinwb_07' => { 280 => 0x1d },
	'kelvinwb_08' => { 280 => 0x21 },
	'kelvinwb_09' => { 280 => 0x25 },
	'kelvinwb_10' => { 280 => 0x29 },
	'kelvinwb_11' => { 280 => 0x2d },
	'kelvinwb_12' => { 280 => 0x31 },
	'kelvinwb_13' => { 280 => 0x35 },
	'kelvinwb_14' => { 280 => 0x39 },
	'kelvinwb_15' => { 280 => 0x3d },
	'kelvinwb_16' => { 280 => 0x41 },
	'kelvinwb_daylight' => { 280 => 0x1 },
	'key' => { 406 => 'key' },
	'keyword' => { 397 => 'keyword' },
	'keywordinfo' => { 143 => 'Keywords' },
	'keywords' => { 106 => 0x19, 129 => 'Keywords', 247 => 'Keywords', 304 => 'Keywords', 378 => 'keywords', 394 => 'Keywords', 404 => 'Keywords' },
	'killdate' => { 397 => 'killDate' },
	'kodakimageheight' => { 111 => 0xf908, 114 => 0xe, 116 => [0xfa1e,0xfa52], 122 => 0x70 },
	'kodakimagewidth' => { 111 => 0xf907, 114 => 0xc, 116 => [0xfa1d,0xfa51], 122 => 0x6c },
	'kodakinfotype' => { 111 => 0xfa00 },
	'kodaklook' => { 112 => 0xe4c },
	'kodaklookprofile' => { 112 => 0x138a },
	'kodakmaker' => { 122 => 0x8 },
	'kodakmodel' => { 114 => 0x0, 122 => 0x28 },
	'label' => { 250 => 'Label', 404 => 'Label' },
	'labelname1' => { 391 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 391 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 258 => 0x6f },
	'landscapeoutputhighlightpoint' => { 90 => 0x26 },
	'landscapeoutputshadowpoint' => { 90 => 0x27 },
	'landscaperawcolortone' => { 90 => 0x1f },
	'landscaperawcontrast' => { 90 => 0x21 },
	'landscaperawhighlight' => { 90 => 0x77 },
	'landscaperawhighlightpoint' => { 90 => 0x24 },
	'landscaperawlinear' => { 90 => 0x22 },
	'landscaperawsaturation' => { 90 => 0x20 },
	'landscaperawshadow' => { 90 => 0x80 },
	'landscaperawshadowpoint' => { 90 => 0x25 },
	'landscaperawsharpness' => { 90 => 0x23 },
	'landscapeunsharpmaskfineness' => { 90 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 90 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 90 => 0xa2 },
	'language' => { 384 => 'language' },
	'languageidentifier' => { 106 => 0x87 },
	'largestvalidinteriorrectheight' => { 373 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 373 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 373 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 373 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 150 => 0x1b },
	'lastkeywordiptc' => { 148 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 148 => 'LastKeywordXMP' },
	'lastphotodate' => { 373 => 'LastPhotoDate' },
	'lasturl' => { 407 => 'LastURL' },
	'lateralchromaticaberration' => { 342 => 0x2012 },
	'latestageorhigheststage' => { 97 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 97 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 97 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 97 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 97 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 282 => 0x2 },
	'lc10' => { 282 => 0xb },
	'lc11' => { 282 => 0xc },
	'lc12' => { 282 => 0xd },
	'lc14' => { 282 => 0xf },
	'lc15' => { 282 => 0x10 },
	'lc3' => { 282 => 0x4 },
	'lc4' => { 282 => 0x5 },
	'lc5' => { 282 => 0x6 },
	'lc6' => { 282 => 0x7 },
	'lc7' => { 282 => 0x8 },
	'lcddisplayatpoweron' => { 71 => 0x811, 75 => 0xa },
	'lcddisplayreturntoshoot' => { 76 => 0x12 },
	'lcdillumination' => { 226 => '17.5', 227 => '5.2', 232 => '10.3', 233 => '4.2', 236 => '5.4' },
	'lcdilluminationduringbulb' => { 71 => 0x408 },
	'lcdpanels' => { 70 => 0x8 },
	'lcheditor' => { 219 => 0x8ae85e },
	'legacyiptcdigest' => { 395 => 'LegacyIPTCDigest' },
	'legalcode' => { 381 => 'legalcode' },
	'lens' => { 98 => 0xfdea, 185 => 0x84, 380 => 'Lens' },
	'lensafstopbutton' => { 69 => 0x11, 70 => 0x13, 71 => 0x506, 72 => 0x10, 73 => 0x12, 76 => 0x13, 77 => 0x9 },
	'lensaperturerange' => { 322 => [0x30,0x48] },
	'lensdistortionparams' => { 243 => 0x206 },
	'lensdrivenoaf' => { 71 => 0x505 },
	'lensfirmware' => { 314 => 0x20, 319 => 0xa004 },
	'lensfirmwareversion' => { 239 => 0x204, 258 => 0x60 },
	'lensfocalrange' => { 322 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 227 => '55.1' },
	'lensformat' => { 353 => 0x1891, 355 => 0x18bd, 356 => 0x106, 364 => 0x603, 365 => 0x5d },
	'lensfstops' => { 180 => 0x7, 181 => 0xc, 182 => 0xd, 185 => 0x8b, 282 => '0.3' },
	'lensid' => { 380 => 'LensID' },
	'lensidnumber' => { 180 => 0x6, 181 => 0xb, 182 => 0xc },
	'lensinfo' => { 98 => 0xa432, 288 => 0x2a, 380 => 'LensInfo', 388 => 'LensSpecification' },
	'lenskind' => { 282 => 0x1 },
	'lensmake' => { 98 => 0xa433, 135 => 'Make', 388 => 'LensMake' },
	'lensmanualdistortionamount' => { 383 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 148 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 322 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 53 => 0x95, 98 => 0xa434, 135 => 'Model', 148 => 'LensModel', 183 => 0x18a, 239 => 0x203, 256 => 0x303, 288 => 0xc, 388 => 'LensModel' },
	'lensmount' => { 332 => 0x99, 353 => 0x1892, 355 => 0x18be, 356 => 0x105, 364 => 0x604, 365 => 0x5e, 368 => 0x8 },
	'lensparameters' => { 350 => 0x1a23, 353 => 0x1870, 355 => 0x189c, 364 => 0x6ca, 365 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 383 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 383 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 383 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 383 => 'LensProfileEnable' },
	'lensprofilefilename' => { 383 => 'LensProfileFilename' },
	'lensprofilename' => { 383 => 'LensProfileName' },
	'lensprofilesetup' => { 383 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 383 => 'LensProfileVignettingScale' },
	'lensproperties' => { 239 => 0x20b },
	'lensserialnumber' => { 51 => 0x0, 98 => 0xa435, 135 => 'SerialNumber', 239 => 0x202, 258 => 0x52, 314 => 0x30, 380 => 'LensSerialNumber', 388 => 'LensSerialNumber' },
	'lensshutterlock' => { 153 => 0x4a },
	'lensspec' => { 327 => 0x0, 328 => 0x0, 329 => 0x0, 342 => 0xb02a },
	'lensspecfeatures' => { 356 => [0x115,0x116] },
	'lenstemperature' => { 243 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 30 => 0x16, 155 => 0x10c, 156 => 0x49bd, 185 => 0x83, 239 => 0x201, 251 => 0x16, 254 => 0x310, 257 => 0x303, 258 => 0x51, 260 => 0x3405, 283 => 0x0, 284 => 0x0, 285 => 0x1, 286 => 0x1, 287 => 0x1, 289 => 0x0, 319 => 0xa003, 322 => 0x27, 342 => 0xb027, 353 => 0x1896, 355 => 0x18c2, 356 => 0x109, 364 => 0x608, 365 => 0x62 },
	'lenstype2' => { 332 => 0x3f7, 353 => 0x1893, 355 => 0x18bf, 356 => 0x107, 364 => 0x605, 365 => 0x60, 368 => 0x9 },
	'lenszoomposition' => { 362 => 0x19, 363 => 0x1e, 365 => 0x342 },
	'levelgaugepitch' => { 238 => 0x904 },
	'levelgaugeroll' => { 238 => 0x903 },
	'levelindicator' => { 265 => 0x15 },
	'levelorientation' => { 290 => 0x0 },
	'license' => { 381 => 'license' },
	'licensee' => { 396 => 'Licensee' },
	'licenseeid' => { 396 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 396 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 396 => 'LicenseeImageNotes' },
	'licenseename' => { 396 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 396 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 396 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 396 => 'LicenseeTransactionID' },
	'licenseid' => { 396 => 'LicenseID' },
	'licensestartdate' => { 396 => 'LicenseStartDate' },
	'licensetransactiondate' => { 396 => 'LicenseTransactionDate' },
	'licensetype' => { 385 => 'licensetype' },
	'licensor' => { 396 => 'Licensor' },
	'licensorcity' => { 396 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 396 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 396 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 396 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 396 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 396 => 'LicensorImageID' },
	'licensorname' => { 396 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 396 => 'LicensorNotes' },
	'licensorpostalcode' => { 396 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 396 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 396 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 396 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 396 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 396 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 396 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 396 => 'LicensorTransactionID' },
	'licensorurl' => { 396 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 243 => 0x1009 },
	'lightingmode' => { 94 => 0x302a },
	'lightreading' => { 291 => 0x15 },
	'lightsource' => { 98 => 0x9208, 185 => 0x90, 246 => 0x1000, 387 => 'LightSource' },
	'lightsourcespecial' => { 321 => 0x21d },
	'lightswitch' => { 236 => '0.1' },
	'lightvaluecenter' => { 243 => 0x103d },
	'lightvalueperiphery' => { 243 => 0x103e },
	'limitafareamodeselection' => { 227 => '51.1' },
	'linearitylimitblue' => { 262 => 0x10 },
	'linearitylimitgreen' => { 262 => 0xf },
	'linearitylimitred' => { 262 => 0xe },
	'linearityuppermargin' => { 37 => [0x2ba,0x2d1,0x2d5], 39 => 0x1e5, 40 => [0x1fe,0x2de] },
	'linearizationtable' => { 98 => 0xc618 },
	'linearresponselimit' => { 98 => 0xc62e },
	'linkaetoafpoint' => { 272 => '14.2' },
	'linkedencodedrightsexpr' => { 393 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 393 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 393 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 393 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 97 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 229 => '32.1', 236 => '34.1' },
	'liveviewafareamode' => { 233 => '34.1' },
	'liveviewafmethod' => { 346 => 0x20 },
	'liveviewafmode' => { 233 => '34.2' },
	'liveviewafsetting' => { 332 => 0x36 },
	'liveviewbuttonoptions' => { 227 => '50.2' },
	'liveviewexposuresimulation' => { 71 => 0x810 },
	'liveviewfocusmode' => { 332 => [0x8b,0x28b] },
	'liveviewmetering' => { 332 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 227 => '21.2', 230 => '20.2', 231 => '20.2', 233 => '20.2' },
	'liveviewshooting' => { 47 => 0x13 },
	'localcaption' => { 106 => 0x79 },
	'localizedcameramodel' => { 98 => 0xc615 },
	'locallocationname' => { 319 => 0x30 },
	'location' => { 184 => 0x9, 258 => 0x67, 376 => 'Location', 392 => 'Location', 397 => 'location' },
	'locationareacode' => { 382 => 'lac' },
	'locationcreated' => { 393 => 'LocationCreated' },
	'locationcreatedcity' => { 393 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 393 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 393 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 393 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 393 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 393 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 393 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 184 => 0x0 },
	'locationname' => { 319 => 0x31 },
	'locationshown' => { 393 => 'LocationShown' },
	'locationshowncity' => { 393 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 393 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 393 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 393 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 393 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 393 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 393 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 71 => 0x709 },
	'logcomment' => { 406 => 'logComment' },
	'longexposurenoisereduction' => { 52 => 0x4, 71 => 0x201, 72 => 0x1, 73 => 0x2, 74 => 0x1, 75 => 0x1, 76 => 0x2, 77 => 0x1, 258 => 0x49, 330 => 0x2b, 331 => 0x25, 332 => 0x25, 342 => 0x2008, 346 => 0x11, 365 => 0x44 },
	'longexposurenoisereduction2' => { 47 => 0x8 },
	'loop' => { 406 => 'loop' },
	'lowestbiostratigraphiczone' => { 97 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 383 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 383 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 383 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 383 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 383 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 383 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 383 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 383 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 89 => 0x150 },
	'luminancecurvepoints' => { 89 => 0x126 },
	'luminancenoisereduction' => { 90 => 0x5f, 322 => 0x1b },
	'luminancenoisereductioncontrast' => { 383 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 383 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 90 => 0x6d },
	'luminancesmoothing' => { 383 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 71 => 0x40b },
	'lyrics' => { 406 => 'lyrics' },
	'm16cversion' => { 254 => 0x333 },
	'macro' => { 103 => 0x1020, 104 => 0x202, 243 => 0x202, 312 => 0x21, 321 => 0x202, 342 => 0xb040 },
	'macroled' => { 241 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 47 => 0x10 },
	'macromode' => { 30 => 0x1, 150 => 0xb, 238 => 0x300, 258 => 0x1c, 313 => 0x1009 },
	'magicfilter' => { 238 => 0x52c },
	'magnifiedview' => { 73 => 0x11, 75 => 0x9 },
	'maindialexposurecomp' => { 234 => '0.6' },
	'make' => { 85 => 0x0, 98 => 0x10f, 128 => 'Make', 250 => 'Make', 262 => 0x10f, 402 => 'Make' },
	'makernote' => { 387 => 'MakerNote' },
	'makernoteapple' => { 96 => 'MakN', 98 => 0x927c },
	'makernotecanon' => { 96 => 'MakN', 98 => 0x927c },
	'makernotecasio' => { 96 => 'MakN', 98 => 0x927c },
	'makernotecasio2' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteflir' => { 96 => 'MakN', 98 => 0x927c },
	'makernotefujifilm' => { 96 => 'MakN', 98 => 0x927c },
	'makernotege' => { 96 => 'MakN', 98 => 0x927c },
	'makernotege2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehasselblad' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotehp6' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteisl' => { 96 => 'MakN', 98 => 0x927c },
	'makernotejvc' => { 96 => 'MakN', 98 => 0x927c },
	'makernotejvctext' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak10' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak11' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak1a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak1b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak5' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak6a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak6b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak7' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak8a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak8b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak8c' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodak9' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekodakunknown' => { 96 => 'MakN', 98 => 0x927c },
	'makernotekyocera' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica2' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica3' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica4' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica5' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteleica6' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteminolta' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteminolta2' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteminolta3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenikon' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenikon2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenikon3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotenintendo' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteoffset' => { 321 => 0xff },
	'makernoteolympus' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteolympus2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepanasonic' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepanasonic2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax5' => { 96 => 'MakN', 98 => 0x927c },
	'makernotepentax6' => { 96 => 'MakN', 98 => 0x927c },
	'makernotephaseone' => { 96 => 'MakN', 98 => 0x927c },
	'makernotereconyx' => { 96 => 'MakN', 98 => 0x927c },
	'makernotericoh' => { 96 => 'MakN', 98 => 0x927c },
	'makernotericoh2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotericohtext' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesafety' => { 98 => 0xc635 },
	'makernotesamsung1a' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesamsung1b' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesamsung2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesanyo' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesanyoc4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesanyopatch' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesigma' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony2' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony3' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony4' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesony5' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesonyericsson' => { 96 => 'MakN', 98 => 0x927c },
	'makernotesonysrf' => { 96 => 'MakN', 98 => 0x927c },
	'makernotetype' => { 313 => 0x1 },
	'makernoteunknown' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteunknownbinary' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteunknowntext' => { 96 => 'MakN', 98 => 0x927c },
	'makernoteversion' => { 155 => 0x0, 185 => 0x1, 243 => 0x0, 258 => 0x8000, 317 => 0x0, 319 => 0x1, 322 => [0x1d,0x1f], 333 => 0x2000 },
	'managedfrom' => { 407 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 407 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 407 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 407 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 407 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 407 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 407 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 407 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 407 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 407 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 407 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 407 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 407 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 407 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 407 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 407 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 407 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 407 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 407 => 'Manager' },
	'managervariant' => { 407 => 'ManagerVariant' },
	'manageto' => { 407 => 'ManageTo' },
	'manageui' => { 407 => 'ManageUI' },
	'manifest' => { 407 => 'Manifest' },
	'manifestlinkform' => { 407 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 407 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 407 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 407 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 407 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 407 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 407 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 407 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 407 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 407 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 407 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 407 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 407 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 407 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 407 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 407 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 407 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 407 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 407 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 407 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 407 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 407 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 238 => 0x900, 258 => 0x86 },
	'manometerreading' => { 238 => 0x901 },
	'manualafpointselectpattern' => { 71 => 0x513 },
	'manualflash' => { 241 => 0x1209 },
	'manualflashoutput' => { 30 => 0x29, 228 => '8.2', 229 => '22.2', 230 => '23.1', 231 => '23.2', 232 => '16.2', 233 => '23.2', 234 => '8.2', 235 => '23.2', 236 => '24.2', 313 => 0x100c },
	'manualflashstrength' => { 238 => 0x406 },
	'manualfocusdistance' => { 185 => 0x85, 243 => 0x100c, 321 => 0x223 },
	'manualtv' => { 70 => 0x5, 71 => 0x705 },
	'manufacturedate' => { 271 => 0x1 },
	'manufacturedate1' => { 315 => 0x4 },
	'manufacturedate2' => { 315 => 0x5 },
	'marked' => { 394 => 'Marked', 410 => 'Marked' },
	'markers' => { 406 => 'markers' },
	'markerscomment' => { 406 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 406 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 406 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 406 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 406 => [\'markers','markersCuePointType'] },
	'markersduration' => { 406 => [\'markers','markersDuration'] },
	'markerslocation' => { 406 => [\'markers','markersLocation'] },
	'markersname' => { 406 => [\'markers','markersName'] },
	'markersprobability' => { 406 => [\'markers','markersProbability'] },
	'markersspeaker' => { 406 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 406 => [\'markers','markersStartTime'] },
	'markerstarget' => { 406 => [\'markers','markersTarget'] },
	'markerstype' => { 406 => [\'markers','markersType'] },
	'maskedareas' => { 98 => 0xc68e },
	'masterdocumentid' => { 106 => 0xb9 },
	'mastergain' => { 190 => 0x50 },
	'matrixmetering' => { 227 => '50.1' },
	'maxaperture' => { 30 => 0x1a, 118 => 0x6103, 135 => 'MaxAperture', 150 => 0x17, 156 => 0x49c5, 239 => 0x20a, 282 => '14.1', 356 => 0x0 },
	'maxapertureatmaxfocal' => { 103 => 0x1407, 135 => 'MaxApertureAtMaxFocal', 180 => 0xb, 181 => 0x10, 182 => 0x11, 239 => 0x206 },
	'maxapertureatminfocal' => { 103 => 0x1406, 180 => 0xa, 181 => 0xf, 182 => 0x10, 239 => 0x205 },
	'maxaperturevalue' => { 98 => 0x9205, 387 => 'MaxApertureValue' },
	'maxavailheight' => { 393 => 'MaxAvailHeight' },
	'maxavailwidth' => { 393 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 226 => 0xb, 227 => 0xc, 232 => 0xc, 233 => 0xb },
	'maxfaces' => { 242 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 30 => 0x17, 103 => 0x1405, 135 => 'MaxFocalLength', 180 => 0x9, 181 => 0xe, 182 => 0xf, 239 => 0x208, 353 => 0x127c, 354 => 0x1138, 355 => 0x330 },
	'maximumdensityrange' => { 108 => 0x8c },
	'maxpagesize' => { 411 => 'MaxPageSize' },
	'maxpagesizeh' => { 411 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 411 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 411 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 98 => 0x119 },
	'maxstorage' => { 401 => 'maxstorage' },
	'mb-d10batteries' => { 226 => '12.6' },
	'mb-d10batterytype' => { 232 => '13.3' },
	'mb-d11batterytype' => { 233 => '2.3' },
	'mb-d80batteries' => { 234 => '6.5' },
	'mb-d80batterytype' => { 236 => '3.2' },
	'mcuversion' => { 180 => 0xc, 181 => 0x11, 182 => 0x12 },
	'md5digest' => { 136 => 'zmd5' },
	'measuredev' => { 26 => 0x9, 65 => 0x3, 84 => 0x1814, 128 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 65 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 156 => 0x690, 254 => 0x312, 260 => 0x3407 },
	'measuredrggb' => { 54 => 0x1 },
	'measuredrggbdata' => { 36 => 0x287 },
	'measurementaccuracy' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 97 => 'MeasurementOrFact' },
	'measurementremarks' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 97 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 396 => 'MediaConstraints' },
	'mediacreatedate' => { 305 => 0x1 },
	'mediamodifydate' => { 305 => 0x2 },
	'mediasummarycode' => { 396 => 'MediaSummaryCode' },
	'memoaudioquality' => { 71 => 0x812 },
	'memorycardconfiguration' => { 336 => 0x16 },
	'menubuttondisplayposition' => { 69 => 0xb, 72 => 0xa, 73 => 0xb, 76 => 0xb },
	'menubuttonreturn' => { 77 => 0xb },
	'menumonitorofftime' => { 226 => '26.1', 227 => '22.1', 232 => '8.2', 233 => '21.1', 236 => '22.1' },
	'metadatadate' => { 404 => 'MetadataDate' },
	'metadatamoddate' => { 406 => 'metadataModDate' },
	'metaversion' => { 348 => 0x34 },
	'meterinfo1row1' => { 343 => 0x0 },
	'meterinfo1row2' => { 343 => 0x6c },
	'meterinfo1row3' => { 343 => 0xd8 },
	'meterinfo1row4' => { 343 => 0x144 },
	'meterinfo1row5' => { 343 => 0x1b0 },
	'meterinfo1row6' => { 343 => 0x21c },
	'meterinfo1row7' => { 343 => 0x288 },
	'meterinfo2row1' => { 343 => 0x2f4 },
	'meterinfo2row2' => { 343 => 0x378 },
	'meterinfo2row3' => { 343 => 0x3fc },
	'meterinfo2row4' => { 343 => 0x480 },
	'meterinfo2row5' => { 343 => 0x504 },
	'meterinfo2row6' => { 343 => 0x588 },
	'meterinfo2row7' => { 343 => 0x60c },
	'meterinfo2row8' => { 343 => 0x690 },
	'meterinfo2row9' => { 343 => 0x714 },
	'metering' => { 228 => '6.1' },
	'meteringmode' => { 30 => 0x11, 98 => 0x9207, 114 => 0x1c, 150 => 0x7, 151 => 0x25, 153 => 0x12, 238 => 0x202, 291 => 0x17, 322 => 0x9, 330 => 0x15, 331 => 0x13, 332 => 0x7, 346 => 0x3, 349 => 0x1174, 350 => 0x1178, 351 => 0x1154, 352 => 0x11d0, 353 => 0x11ac, 354 => 0x1064, 355 => 0x25c, 387 => 'MeteringMode' },
	'meteringmode2' => { 272 => '2.1' },
	'meteringmode3' => { 272 => '16.1' },
	'meteringoffscaleindicator' => { 153 => 0x53 },
	'meteringtime' => { 226 => '22.2', 228 => '3.2', 229 => '17.1', 230 => '18.1', 232 => '7.3', 233 => '18.1', 234 => '3.2', 236 => '19.1' },
	'mieversion' => { 136 => '0Vers' },
	'minaperture' => { 30 => 0x1b, 135 => 'MinAperture', 282 => '0.2', 356 => 0x1 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 30 => 0x18, 103 => 0x1404, 135 => 'MinFocalLength', 180 => 0x8, 181 => 0xd, 182 => 0xe, 239 => 0x207, 353 => 0x127a, 354 => 0x1136, 355 => 0x32e },
	'minfocusdistance' => { 282 => 0x3 },
	'minoltadate' => { 150 => 0x15 },
	'minoltaimagesize' => { 150 => 0x4, 151 => 0xc, 152 => 0x2, 155 => 0x103 },
	'minoltamodelid' => { 150 => 0x25 },
	'minoltaquality' => { 150 => 0x5, 151 => 0xd, 152 => 0x3, 155 => [0x102,0x103] },
	'minoltatime' => { 150 => 0x16 },
	'minormodelagedisclosure' => { 396 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 98 => 0x118 },
	'mirrorlockup' => { 69 => 0xc, 70 => 0xc, 71 => 0x60f, 72 => 0xb, 73 => 0xc, 74 => 0x6, 75 => 0x6, 76 => 0xc, 77 => 0x3 },
	'mobilecountrycode' => { 382 => 'mcc' },
	'mobilenetworkcode' => { 382 => 'mnc' },
	'moddate' => { 250 => 'modify-date', 394 => 'ModDate' },
	'modedialposition' => { 336 => 0x14 },
	'model' => { 85 => 0x6, 98 => 0x110, 128 => 'Model', 250 => 'Model', 262 => 0x110, 402 => 'Model' },
	'modelage' => { 393 => 'ModelAge' },
	'modelid' => { 237 => 0x0 },
	'modelingflash' => { 226 => '21.4', 227 => '31.1', 232 => '26.4', 233 => '30.2', 234 => '7.4', 235 => '30.1', 236 => '31.3' },
	'modelreleaseid' => { 396 => 'ModelReleaseID' },
	'modelreleasestatus' => { 396 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 357 => 0x52, 358 => 0x46 },
	'modificationdate' => { 397 => 'modificationDate' },
	'modifiedcolortemp' => { 55 => 0x9 },
	'modifieddigitalgain' => { 55 => 0xb },
	'modifiedparamflag' => { 48 => 0x1 },
	'modifiedpicturestyle' => { 55 => 0xa },
	'modifiedsaturation' => { 238 => 0x504 },
	'modifiedsensorbluelevel' => { 55 => 0x5 },
	'modifiedsensorredlevel' => { 55 => 0x4 },
	'modifiedsharpness' => { 55 => 0x2 },
	'modifiedsharpnessfreq' => { 55 => 0x3 },
	'modifiedtonecurve' => { 55 => 0x1 },
	'modifiedwhitebalance' => { 55 => 0x8 },
	'modifiedwhitebalanceblue' => { 55 => 0x7 },
	'modifiedwhitebalancered' => { 55 => 0x6 },
	'modifydate' => { 98 => 0x132, 129 => 'ModifyDate', 247 => 'ModDate', 248 => 'tIME', 304 => 'ModDate', 306 => 0x2, 404 => 'ModifyDate' },
	'moirefilter' => { 98 => 0xfe58, 383 => 'MoireFilter' },
	'monitordisplayoff' => { 153 => 0x4c },
	'monitorofftime' => { 226 => '18.2', 228 => '3.1', 234 => '3.1' },
	'monochromecontrast' => { 90 => 0x3c },
	'monochromefiltereffect' => { 90 => 0x3a, 291 => 0x73 },
	'monochromelinear' => { 90 => 0x3d },
	'monochromeoutputhighlightpoint' => { 90 => 0x41 },
	'monochromeoutputshadowpoint' => { 90 => 0x42 },
	'monochromerawhighlight' => { 90 => 0x7a },
	'monochromerawhighlightpoint' => { 90 => 0x3f },
	'monochromerawshadow' => { 90 => 0x83 },
	'monochromerawshadowpoint' => { 90 => 0x40 },
	'monochromesharpness' => { 90 => 0x3e },
	'monochrometoning' => { 291 => 0x74 },
	'monochrometoningeffect' => { 90 => 0x3b },
	'monochromeunsharpmaskfineness' => { 90 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 90 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 90 => 0xb4 },
	'monthdaycreated' => { 114 => 0x12, 123 => 0xe },
	'moonphase' => { 309 => 0x12 },
	'morepermissions' => { 381 => 'morePermissions' },
	'motionsensitivity' => { 309 => 0x29 },
	'moviefunctionbutton' => { 227 => '41.1' },
	'moviefunctionbuttonplusdials' => { 227 => '52.1' },
	'moviepreviewbutton' => { 227 => '41.2' },
	'moviepreviewbuttonplusdials' => { 227 => '52.2' },
	'movieshutterbutton' => { 227 => '38.3' },
	'moviesubselectorassignment' => { 227 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 227 => '53.1' },
	'multiburstimageheight' => { 342 => 0x1002 },
	'multiburstimagewidth' => { 342 => 0x1001 },
	'multiburstmode' => { 342 => 0x1000 },
	'multicontrollerwhilemetering' => { 71 => 0x517 },
	'multiexposure' => { 57 => 0x1 },
	'multiexposureautogain' => { 186 => 0x3 },
	'multiexposurecontrol' => { 57 => 0x2 },
	'multiexposuremode' => { 186 => 0x1 },
	'multiexposureshots' => { 57 => 0x3, 186 => 0x2 },
	'multiframenoisereduction' => { 332 => 0x35, 342 => 0x200b, 346 => 0x15 },
	'multifunctionlock' => { 71 => 0x70f },
	'multipleexposuremode' => { 242 => 0x101c },
	'multipleexposureset' => { 272 => '10.1' },
	'multisample' => { 190 => 0x40 },
	'multiselector' => { 226 => '9.4', 227 => '10.3', 232 => '27.4' },
	'multiselectorliveview' => { 226 => '4.3' },
	'multiselectorliveviewmode' => { 200 => 0x18c2 },
	'multiselectorplaybackmode' => { 226 => ['13.5','9.2'], 227 => '10.2', 232 => '27.2' },
	'multiselectorshootmode' => { 226 => '9.1', 227 => '10.1', 232 => '27.1' },
	'mycolormode' => { 58 => 0x2 },
	'nativedigest' => { 387 => 'NativeDigest', 402 => 'NativeDigest' },
	'ncdfileinfo' => { 112 => 0x414 },
	'ndfilter' => { 65 => 0x1c, 238 => 0x204, 313 => 0x1019 },
	'nefbitdepth' => { 185 => 0xe22 },
	'nefcompression' => { 185 => 0x93 },
	'neflinearizationtable' => { 185 => 0x96 },
	'neutraldensityfilter' => { 291 => 0x88 },
	'neutraloutputhighlightpoint' => { 90 => 0x2f },
	'neutraloutputshadowpoint' => { 90 => 0x30 },
	'neutralrawcolortone' => { 90 => 0x28 },
	'neutralrawcontrast' => { 90 => 0x2a },
	'neutralrawhighlight' => { 90 => 0x78 },
	'neutralrawhighlightpoint' => { 90 => 0x2d },
	'neutralrawlinear' => { 90 => 0x2b },
	'neutralrawsaturation' => { 90 => 0x29 },
	'neutralrawshadow' => { 90 => 0x81 },
	'neutralrawshadowpoint' => { 90 => 0x2e },
	'neutralrawsharpness' => { 90 => 0x2c },
	'neutralunsharpmaskfineness' => { 90 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 90 => 0xa8 },
	'neutraunsharpmaskstrength' => { 90 => 0xa4 },
	'newrawimagedigest' => { 98 => 0xc7a7 },
	'newsphotoversion' => { 108 => 0x0 },
	'nickname' => { 404 => 'Nickname' },
	'nikoncapturedata' => { 185 => 0xe01 },
	'nikoncaptureeditversions' => { 185 => 0xe13 },
	'nikoncaptureoutput' => { 185 => 0xe1e },
	'nikoncaptureversion' => { 185 => 0xe09 },
	'nikoniccprofile' => { 185 => 0xe1d },
	'nikonimagesize' => { 197 => '723.1', 198 => '732.1', 206 => 0x2c4 },
	'noisefilter' => { 238 => 0x527 },
	'noiseprofile' => { 98 => 0xc761 },
	'noisereduction' => { 103 => 0x100b, 151 => 0xb0, 152 => 0x60, 153 => 0x3f, 185 => 0x95, 219 => 0x753dcbc0, 220 => 0x17, 238 => 0x50a, 243 => 0x103a, 258 => 0x2d, 291 => 0x49, 313 => 0x100f, 315 => 0x2a },
	'noisereduction2' => { 242 => 0x1010 },
	'noisereductionapplied' => { 98 => 0xc6f7 },
	'noisereductionintensity' => { 220 => 0x9 },
	'noisereductionmethod' => { 220 => 0x11 },
	'noisereductionmode' => { 369 => 0x801e },
	'noisereductionsharpness' => { 220 => 0xd },
	'noisereductionvalue' => { 369 => 0x8027 },
	'nomemorycard' => { 226 => '22.1', 227 => '4.2', 228 => '0.3', 229 => '2.4', 230 => '3.2', 231 => '3.2', 232 => '33.7', 233 => '3.2', 234 => '0.3', 236 => '4.5' },
	'nominalmaxaperture' => { 282 => 0xa },
	'nominalminaperture' => { 282 => '10.1' },
	'normalwhitelevel' => { 37 => [0x2b8,0x2cf,0x2d3], 39 => 0x1e3, 40 => [0x1fc,0x2dc] },
	'notes' => { 370 => 'Notes', 378 => 'notes' },
	'npages' => { 411 => 'NPages' },
	'nrwdata' => { 185 => 0x14 },
	'nullrecord' => { 84 => 0x0 },
	'number' => { 397 => 'number' },
	'numberofbeats' => { 406 => 'numberOfBeats' },
	'numberoffocuspoints' => { 231 => '0.2', 233 => '0.3' },
	'numfacepositions' => { 252 => 0x0 },
	'numindexentries' => { 108 => 0x54 },
	'numwbentries' => { 263 => 0x0, 264 => 0x0 },
	'object' => { 397 => 'object' },
	'objectattributereference' => { 106 => 0x4 },
	'objectcycle' => { 106 => 0x4b },
	'objectdistance' => { 93 => 0x6, 94 => 0x2022 },
	'objectname' => { 106 => 0x5 },
	'objectpreviewdata' => { 106 => 0xca },
	'objectpreviewfileformat' => { 106 => 0xc8 },
	'objectpreviewfileversion' => { 106 => 0xc9 },
	'objecttypereference' => { 106 => 0x3 },
	'occurrence' => { 97 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 97 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 97 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 97 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 97 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 97 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 97 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 97 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 97 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 97 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 97 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 97 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 97 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 97 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 97 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 97 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 97 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 97 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 97 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 97 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 97 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 97 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 97 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 97 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 387 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 387 => [\'OECF','OECFNames'] },
	'oecfrows' => { 387 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 387 => [\'OECF','OECFValues'] },
	'offsetschema' => { 98 => 0xea1d },
	'okbutton' => { 233 => '15.1', 236 => '16.1' },
	'oldsubfiletype' => { 98 => 0xff },
	'olympusimageheight' => { 243 => 0x102f },
	'olympusimagewidth' => { 243 => 0x102e },
	'onetouchwb' => { 243 => 0x302 },
	'opticalzoom' => { 116 => 0xfa3d, 118 => [0x6006,0xf006], 119 => 0x1000, 120 => 0xf, 123 => 0x1e, 135 => 'OpticalZoom' },
	'opticalzoomcode' => { 65 => 0xa },
	'opticalzoommode' => { 258 => 0x34 },
	'opticalzoomon' => { 321 => 0x219 },
	'optionenddate' => { 399 => 'optionEndDate' },
	'opto-electricconvfactor' => { 387 => 'OECF' },
	'ordernumber' => { 103 => 0x8002 },
	'organisationinimagecode' => { 393 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 393 => 'OrganisationInImageName' },
	'organization' => { 397 => 'organization' },
	'orientation' => { 98 => 0x112, 262 => 0x112, 402 => 'Orientation' },
	'orientation2' => { 346 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 71 => 0x516 },
	'originalbestqualitysize' => { 98 => 0xc792 },
	'originaldecisiondata' => { 95 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 53 => 0x83 },
	'originaldefaultcropsize' => { 98 => 0xc793 },
	'originaldefaultfinalsize' => { 98 => 0xc791 },
	'originaldirectory' => { 256 => 0x408 },
	'originaldocumentid' => { 407 => 'OriginalDocumentID' },
	'originalfilename' => { 84 => 0x816, 112 => 0x3e9, 124 => 0x20, 256 => 0x407, 374 => 'OriginalFilename' },
	'originalimageheight' => { 67 => 0xc, 102 => 0x1 },
	'originalimagewidth' => { 67 => 0xb, 102 => 0x0 },
	'originalrawfiledata' => { 98 => 0xc68c },
	'originalrawfiledigest' => { 98 => 0xc71d },
	'originalrawfilename' => { 98 => 0xc68b },
	'originaltransmissionreference' => { 106 => 0x67 },
	'originatingprogram' => { 106 => 0x41 },
	'originplatform' => { 397 => 'originPlatform' },
	'os' => { 385 => 'os' },
	'otherconditions' => { 396 => 'OtherConditions' },
	'otherconstraints' => { 396 => 'OtherConstraints' },
	'otherimage' => { 95 => 'OtherImage' },
	'otherimageinfo' => { 396 => 'OtherImageInfo' },
	'otherimagelength' => { 98 => 0x202 },
	'otherimagestart' => { 98 => 0x201 },
	'otherlicensedocuments' => { 396 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 396 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 396 => 'OtherLicenseRequirements' },
	'outcue' => { 406 => 'outCue' },
	'outcuescale' => { 406 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 406 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 164 => 0x3 },
	'outputimagewidth' => { 164 => 0x2 },
	'outputprofile' => { 112 => 0x138b },
	'outputresolution' => { 164 => 0x4 },
	'owner' => { 410 => 'Owner' },
	'ownerid' => { 106 => 0xbc },
	'ownername' => { 14 => 0x10f, 53 => 0x9, 84 => 0x810, 98 => [0xa430,0xfde8], 128 => 'OwnerName', 380 => 'OwnerName', 388 => 'CameraOwnerName' },
	'padding' => { 98 => 0xea1c },
	'pageimage' => { 404 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 404 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 404 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 404 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 404 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 404 => 'PageInfo' },
	'pagename' => { 98 => 0x11d },
	'pagenumber' => { 98 => 0x129 },
	'pagerange' => { 397 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 383 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 383 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 258 => 0x26 },
	'panasonicimageheight' => { 258 => 0x4c },
	'panasonicimagewidth' => { 258 => 0x4b },
	'panasonicrawversion' => { 262 => 0x1 },
	'panasonictitle' => { 98 => 0xc6d2 },
	'panasonictitle2' => { 98 => 0xc6d3 },
	'panoramacropbottom' => { 347 => 0x7 },
	'panoramacropleft' => { 347 => 0x4 },
	'panoramacropright' => { 347 => 0x6 },
	'panoramacroptop' => { 347 => 0x5 },
	'panoramadirection' => { 61 => 0x5, 347 => 0x3 },
	'panoramaframeheight' => { 347 => 0x9 },
	'panoramaframenumber' => { 61 => 0x2 },
	'panoramaframewidth' => { 347 => 0x8 },
	'panoramafullheight' => { 347 => 0x2 },
	'panoramafullwidth' => { 347 => 0x1 },
	'panoramamode' => { 114 => 0x3c, 238 => 0x601 },
	'panoramasize3d' => { 332 => 0x38 },
	'panoramasourceheight' => { 347 => 0xb },
	'panoramasourcewidth' => { 347 => 0xa },
	'panoramicstitchcameramotion' => { 146 => 'PanoramicStitchCameraMotion', 147 => 0x1 },
	'panoramicstitchmaptype' => { 146 => 'PanoramicStitchMapType', 147 => 0x2 },
	'panoramicstitchphi0' => { 146 => 'PanoramicStitchPhi0', 147 => 0x5 },
	'panoramicstitchphi1' => { 146 => 'PanoramicStitchPhi1', 147 => 0x6 },
	'panoramicstitchtheta0' => { 146 => 'PanoramicStitchTheta0', 147 => 0x3 },
	'panoramicstitchtheta1' => { 146 => 'PanoramicStitchTheta1', 147 => 0x4 },
	'panoramicstitchversion' => { 147 => 0x0 },
	'pantry' => { 407 => 'Pantry' },
	'parallax' => { 103 => 0xb211, 237 => 0x28 },
	'parametricdarks' => { 383 => 'ParametricDarks' },
	'parametrichighlights' => { 383 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 383 => 'ParametricHighlightSplit' },
	'parametriclights' => { 383 => 'ParametricLights' },
	'parametricmidtonesplit' => { 383 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 383 => 'ParametricShadows' },
	'parametricshadowsplit' => { 383 => 'ParametricShadowSplit' },
	'parentmeid' => { 374 => 'ParentMEID' },
	'parentreference1' => { 391 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 391 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 406 => 'partOfCompilation' },
	'patientbirthdate' => { 371 => 'PatientDOB' },
	'patientid' => { 371 => 'PatientID' },
	'patientname' => { 371 => 'PatientName' },
	'patientsex' => { 371 => 'PatientSex' },
	'pdfversion' => { 394 => 'PDFVersion' },
	'pentaximagesize' => { 291 => 0x9 },
	'pentaxmodelid' => { 271 => 0x0, 291 => 0x5 },
	'pentaxmodeltype' => { 291 => 0x1 },
	'pentaxversion' => { 291 => 0x0 },
	'people' => { 372 => 'People', 376 => 'People' },
	'perchannelblacklevel' => { 36 => 0xc4, 37 => [0x2b4,0x2cb,0x2cf], 38 => 0x108, 39 => 0x1df, 40 => [0x1f8,0x2d8] },
	'peripheralillumcentralradius' => { 369 => 0x8030 },
	'peripheralillumcentralvalue' => { 369 => 0x8031 },
	'peripheralillumination' => { 90 => 0x68 },
	'peripheralilluminationcorr' => { 52 => 0x1 },
	'peripheralilluminationon' => { 90 => 0x64 },
	'peripheralillumperiphvalue' => { 369 => 0x8032 },
	'peripherallighting' => { 67 => 0x2 },
	'peripherallightingsetting' => { 68 => 0x5 },
	'peripherallightingvalue' => { 67 => 0x6 },
	'permissions' => { 399 => 'permissions' },
	'permits' => { 381 => 'permits' },
	'person' => { 397 => 'person' },
	'personality' => { 374 => 'Personality' },
	'personinimage' => { 393 => 'PersonInImage' },
	'personinimagecharacteristic' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 393 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 393 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 383 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 383 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 383 => 'PerspectiveRotate' },
	'perspectivescale' => { 383 => 'PerspectiveScale' },
	'perspectiveupright' => { 383 => 'PerspectiveUpright' },
	'perspectivevertical' => { 383 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 79 => 0x1 },
	'pf10retainprogramshift' => { 79 => 0xb },
	'pf13drivepriority' => { 79 => 0xe },
	'pf14disablefocussearch' => { 79 => 0xf },
	'pf15disableafassistbeam' => { 79 => 0x10 },
	'pf16autofocuspointshoot' => { 79 => 0x11 },
	'pf17disableafpointsel' => { 79 => 0x12 },
	'pf18enableautoafpointsel' => { 79 => 0x13 },
	'pf19continuousshootspeed' => { 79 => 0x14 },
	'pf19shootingspeedhigh' => { 78 => 0xa },
	'pf19shootingspeedlow' => { 78 => 0x9 },
	'pf1disableshootingmodes' => { 79 => 0x2 },
	'pf1value' => { 78 => 0x1 },
	'pf20limitcontinousshots' => { 79 => 0x15 },
	'pf20maxcontinousshots' => { 78 => 0xb },
	'pf21enablequietoperation' => { 79 => 0x16 },
	'pf23felocktime' => { 78 => 0xd },
	'pf23postreleasetime' => { 78 => 0xe },
	'pf23settimerlengths' => { 79 => 0x18 },
	'pf23shutterbuttontime' => { 78 => 0xc },
	'pf24lightlcdduringbulb' => { 79 => 0x19 },
	'pf25aemode' => { 78 => 0xf },
	'pf25afmode' => { 78 => 0x12 },
	'pf25afpointsel' => { 78 => 0x13 },
	'pf25colormatrix' => { 78 => 0x17 },
	'pf25defaultclearsettings' => { 79 => 0x1a },
	'pf25drivemode' => { 78 => 0x11 },
	'pf25imagesize' => { 78 => 0x14 },
	'pf25meteringmode' => { 78 => 0x10 },
	'pf25parameters' => { 78 => 0x16 },
	'pf25wbmode' => { 78 => 0x15 },
	'pf26shortenreleaselag' => { 79 => 0x1b },
	'pf27reversedialrotation' => { 79 => 0x1c },
	'pf27value' => { 78 => 0x18 },
	'pf28noquickdialexpcomp' => { 79 => 0x1d },
	'pf29quickdialswitchoff' => { 79 => 0x1e },
	'pf2disablemeteringmodes' => { 79 => 0x3 },
	'pf2value' => { 78 => 0x2 },
	'pf30enlargementmode' => { 79 => 0x1f },
	'pf31originaldecisiondata' => { 79 => 0x20 },
	'pf3manualexposuremetering' => { 79 => 0x4 },
	'pf3value' => { 78 => 0x3 },
	'pf4exposuretimelimits' => { 79 => 0x5 },
	'pf4exposuretimemax' => { 78 => 0x5 },
	'pf4exposuretimemin' => { 78 => 0x4 },
	'pf5aperturelimits' => { 79 => 0x6 },
	'pf5aperturemax' => { 78 => 0x7 },
	'pf5aperturemin' => { 78 => 0x6 },
	'pf6presetshootingmodes' => { 79 => 0x7 },
	'pf7bracketcontinuousshoot' => { 79 => 0x8 },
	'pf8bracketshots' => { 78 => 0x8 },
	'pf8setbracketshots' => { 79 => 0x9 },
	'pf9changebracketsequence' => { 79 => 0xa },
	'phasedetectaf' => { 161 => 0x6 },
	'phonenumber' => { 129 => 'Phone' },
	'photoeffect' => { 30 => 0x28 },
	'photoeffecthistoryxml' => { 219 => 0xe9651831 },
	'photoeffects' => { 219 => 0xab5eca5e },
	'photoeffectsblue' => { 221 => 0x8 },
	'photoeffectsgreen' => { 221 => 0x6 },
	'photoeffectsred' => { 221 => 0x4 },
	'photoeffectstype' => { 221 => 0x0 },
	'photographicsensitivity' => { 388 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 226 => '17.6', 232 => '33.6' },
	'photometricinterpretation' => { 98 => 0x106, 402 => 'PhotometricInterpretation' },
	'photoshopbgrthumbnail' => { 302 => 0x409 },
	'photoshopquality' => { 301 => 0x0 },
	'photoshopthumbnail' => { 302 => 0x40c },
	'photostyle' => { 258 => 0x89 },
	'picklabel' => { 386 => 'PickLabel' },
	'pictinfo' => { 321 => 0x208 },
	'picturecontrol' => { 219 => 0xe2173c47 },
	'picturecontrolactive' => { 222 => 0x0 },
	'picturecontroladjust' => { 187 => 0x30 },
	'picturecontrolbase' => { 187 => 0x18 },
	'picturecontroldata' => { 185 => [0xbd,0x23] },
	'picturecontrolmode' => { 222 => 0x13 },
	'picturecontrolname' => { 187 => 0x4 },
	'picturecontrolquickadjust' => { 187 => 0x31 },
	'pictureeffect' => { 342 => 0x200e },
	'pictureeffect2' => { 349 => 0x1163, 350 => 0x1167, 351 => 0x1143, 352 => 0x11bf, 353 => 0x119b, 354 => 0x1053, 355 => 0x24b, 365 => 0x46 },
	'picturefinish' => { 151 => 0x71 },
	'picturemode' => { 103 => 0x1031, 238 => 0x520, 291 => [0xb,0x33], 322 => 0x3d },
	'picturemode2' => { 272 => 0x0 },
	'picturemodebwfilter' => { 238 => 0x525 },
	'picturemodecontrast' => { 238 => 0x523 },
	'picturemodeeffect' => { 238 => 0x52d },
	'picturemodehue' => { 238 => 0x522 },
	'picturemodesaturation' => { 238 => 0x521 },
	'picturemodesharpness' => { 238 => 0x524 },
	'picturemodetone' => { 238 => 0x526 },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 63 => 0xa, 90 => 0x2 },
	'picturewizard' => { 319 => 0x21 },
	'picturewizardcolor' => { 318 => 0x1 },
	'picturewizardcontrast' => { 318 => 0x4 },
	'picturewizardmode' => { 318 => 0x0 },
	'picturewizardsaturation' => { 318 => 0x2 },
	'picturewizardsharpness' => { 318 => 0x3 },
	'pitch' => { 227 => '4.1' },
	'pitchangle' => { 200 => 0x350f, 258 => 0x91, 290 => 0x2 },
	'pixelsperunitx' => { 249 => 0x0 },
	'pixelsperunity' => { 249 => 0x4 },
	'pixelunits' => { 249 => 0x8 },
	'planarconfiguration' => { 98 => 0x11c, 402 => 'PlanarConfiguration' },
	'platenames' => { 411 => 'PlateNames' },
	'playbackmenustime' => { 229 => '20.1', 230 => '21.1', 231 => '21.1' },
	'playbackmonitorofftime' => { 226 => '25.2', 227 => '36.1', 232 => '8.1', 233 => '35.1', 236 => '21.1' },
	'playbackzoom' => { 227 => '37.1' },
	'playdisplay' => { 153 => 0x4e },
	'plusversion' => { 396 => 'Version' },
	'pmversion' => { 300 => 'PMVersion' },
	'pngwarning' => { 250 => 'Warning' },
	'poilevel' => { 184 => 0x8 },
	'portraitoutputhighlightpoint' => { 90 => 0x1d },
	'portraitoutputshadowpoint' => { 90 => 0x1e },
	'portraitrawcolortone' => { 90 => 0x16 },
	'portraitrawcontrast' => { 90 => 0x18 },
	'portraitrawhighlight' => { 90 => 0x76 },
	'portraitrawhighlightpoint' => { 90 => 0x1b },
	'portraitrawlinear' => { 90 => 0x19 },
	'portraitrawsaturation' => { 90 => 0x17 },
	'portraitrawshadow' => { 90 => 0x7f },
	'portraitrawshadowpoint' => { 90 => 0x1c },
	'portraitrawsharpness' => { 90 => 0x1a },
	'portraitrefiner' => { 94 => 0x302b },
	'portraitunsharpmaskfineness' => { 90 => 0x9a },
	'portraitunsharpmaskstrength' => { 90 => 0x98 },
	'portraitunsharpmaskthreshold' => { 90 => 0x9c },
	'poseheadingdegrees' => { 373 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 373 => 'PosePitchDegrees' },
	'poserolldegrees' => { 373 => 'PoseRollDegrees' },
	'postalcode' => { 133 => 'PostalCode' },
	'postcropvignetteamount' => { 383 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 383 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 383 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 383 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 383 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 383 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 340 => 0xb },
	'potentialface2position' => { 340 => 0x15 },
	'potentialface3position' => { 340 => 0x1f },
	'potentialface4position' => { 340 => 0x29 },
	'potentialface5position' => { 340 => 0x33 },
	'potentialface6position' => { 340 => 0x3d },
	'potentialface7position' => { 340 => 0x47 },
	'potentialface8position' => { 340 => 0x51 },
	'powersource' => { 270 => '0.1' },
	'poweruptime' => { 185 => 0xb6 },
	'precaptureframes' => { 243 => 0x300 },
	'predictor' => { 98 => 0x13d },
	'preflashreturnstrength' => { 198 => 0x28a },
	'prefs' => { 106 => 0xdd, 300 => 'Prefs' },
	'preservedfilename' => { 407 => 'PreservedFileName' },
	'presetwhitebalance' => { 153 => 0x24, 369 => 0x8002 },
	'presetwhitebalanceadj' => { 369 => 0x8014 },
	'previewapplicationname' => { 98 => 0xc716 },
	'previewapplicationversion' => { 98 => 0xc717 },
	'previewbutton' => { 226 => ['14.1','15.1'], 227 => '15.1', 232 => '29.1', 233 => '14.1' },
	'previewbuttonplusdials' => { 226 => ['14.2','15.2'], 227 => '15.2', 232 => '31.2' },
	'previewcolorspace' => { 98 => 0xc71a },
	'previewcropbottom' => { 299 => 0xef },
	'previewcropleft' => { 299 => 0xec },
	'previewcropright' => { 299 => 0xee },
	'previewcroptop' => { 299 => 0xed },
	'previewdate' => { 307 => 0x0 },
	'previewdatetime' => { 98 => 0xc71b },
	'previewimage' => { 94 => 0x2000, 95 => 'PreviewImage', 99 => 'PreviewImage', 101 => 0x4, 138 => 'data', 155 => 0x81, 243 => 0x280, 257 => 0x300, 342 => 0x2001 },
	'previewimageborders' => { 291 => 0x3e },
	'previewimageheight' => { 62 => 0x4, 116 => 0xfa58 },
	'previewimagelength' => { 62 => 0x2, 94 => 0x3, 98 => [0x117,0x202], 155 => 0x89, 188 => 0x202, 238 => 0x102, 243 => 0x1037, 291 => 0x3, 312 => 0x1e, 317 => 0x3, 322 => [0x1b,0x1d], 333 => 0x202 },
	'previewimagename' => { 138 => '1Name' },
	'previewimagesize' => { 94 => 0x2, 121 => 0x2, 138 => 'ImageSize', 291 => 0x2, 322 => [0x1c,0x1e], 342 => 0xb02c },
	'previewimagestart' => { 62 => 0x5, 94 => 0x4, 98 => [0x111,0x201], 155 => 0x88, 188 => 0x201, 238 => 0x101, 243 => 0x1036, 291 => 0x4, 312 => 0x1c, 317 => 0x2, 322 => [0x1a,0x1c], 333 => 0x201 },
	'previewimagetype' => { 138 => '0Type' },
	'previewimagevalid' => { 238 => 0x100, 243 => 0x1035 },
	'previewimagewidth' => { 62 => 0x3, 116 => 0xfa57 },
	'previewquality' => { 62 => 0x1 },
	'previewsettingsdigest' => { 98 => 0xc719 },
	'previewsettingsname' => { 98 => 0xc718 },
	'primaryafpoint' => { 161 => 0x7 },
	'primarychromaticities' => { 98 => 0x13f, 402 => 'PrimaryChromaticities' },
	'printim' => { 98 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 153 => 0x1d, 330 => 0x28 },
	'privatertkinfo' => { 375 => 'privateRTKInfo' },
	'processingsoftware' => { 98 => 0xb },
	'processversion' => { 383 => 'ProcessVersion' },
	'producer' => { 247 => 'Producer', 394 => 'Producer' },
	'productid' => { 107 => 0x32 },
	'productinimage' => { 393 => 'ProductInImage' },
	'productinimagedescription' => { 393 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 393 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 393 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 271 => 0x2 },
	'productorserviceconstraints' => { 396 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 98 => 0xc6f4 },
	'profilecopyright' => { 98 => 0xc6fe },
	'profileembedpolicy' => { 98 => 0xc6fd },
	'profilehuesatmapdata1' => { 98 => 0xc6fa },
	'profilehuesatmapdata2' => { 98 => 0xc6fb },
	'profilehuesatmapdims' => { 98 => 0xc6f9 },
	'profilehuesatmapencoding' => { 98 => 0xc7a3 },
	'profilelooktabledata' => { 98 => 0xc726 },
	'profilelooktabledims' => { 98 => 0xc725 },
	'profilelooktableencoding' => { 98 => 0xc7a4 },
	'profilename' => { 98 => 0xc6f8 },
	'profiletonecurve' => { 98 => 0xc6fc },
	'programiso' => { 258 => 0x3c },
	'programline' => { 272 => '1.1' },
	'programmode' => { 158 => 0x5 },
	'programshift' => { 185 => 0xd },
	'programversion' => { 106 => 0x46 },
	'prohibits' => { 381 => 'prohibits' },
	'projectiontype' => { 373 => 'ProjectionType' },
	'projectname' => { 406 => 'projectName' },
	'projectref' => { 406 => 'projectRef' },
	'projectrefpath' => { 406 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 406 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 396 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 396 => 'PropertyReleaseStatus' },
	'province-state' => { 106 => 0x5f },
	'publicationdate' => { 397 => 'publicationDate' },
	'publicationname' => { 397 => 'publicationName' },
	'publisher' => { 384 => 'publisher' },
	'pulldown' => { 406 => 'pullDown' },
	'quality' => { 0 => 0x1, 30 => 0x3, 93 => 0x2, 94 => 0x3002, 103 => 0x1000, 114 => 0x9, 185 => 0x4, 209 => 0x3, 243 => 0x201, 254 => 0x300, 291 => 0x8, 297 => 0x2, 322 => 0x16, 330 => 0x56, 331 => 0x56, 332 => 0xb, 342 => 0x102 },
	'quality2' => { 349 => 0x1170, 350 => 0x1174, 351 => 0x1150, 353 => 0x11a8, 354 => 0x1060, 355 => 0x258, 357 => 0x29, 358 => 0x25, 359 => 0x2a },
	'qualitymode' => { 94 => 0x8 },
	'quantizationmethod' => { 108 => 0x78 },
	'quickadjust' => { 222 => 0x2a },
	'quickcontroldialinmeter' => { 71 => 0x703 },
	'quickfix' => { 219 => 0x416391c6 },
	'quickshot' => { 321 => 0x213 },
	'rangefinder' => { 229 => '4.1', 230 => '5.1', 231 => '5.1' },
	'rasterizedcaption' => { 106 => 0x7d },
	'rating' => { 98 => 0x4746, 103 => 0x1431, 299 => 0xdf, 342 => 0x2002, 378 => 'rating', 385 => 'rating', 404 => 'Rating' },
	'ratingpercent' => { 98 => 0x4749, 148 => 'Rating' },
	'rawandjpgrecording' => { 69 => 0x8, 155 => 0x109, 272 => 0xd },
	'rawbrightnessadj' => { 89 => 0x38 },
	'rawcoloradj' => { 89 => 0x2e },
	'rawcompressionmode' => { 319 => 0x45 },
	'rawcropbottom' => { 299 => 0xd4 },
	'rawcropleft' => { 299 => 0xd1 },
	'rawcropright' => { 299 => 0xd3 },
	'rawcroptop' => { 299 => 0xd2 },
	'rawcustomsaturation' => { 89 => 0x30 },
	'rawcustomtone' => { 89 => 0x34 },
	'rawdata' => { 319 => 0xa048 },
	'rawdatauniqueid' => { 98 => 0xc65d },
	'rawdepth' => { 157 => 0x10 },
	'rawdevartfilter' => { 245 => 0x121 },
	'rawdevautogradation' => { 245 => 0x119 },
	'rawdevcolorspace' => { 244 => 0x108, 245 => 0x109 },
	'rawdevcontrastvalue' => { 244 => 0x106, 245 => 0x105 },
	'rawdeveditstatus' => { 244 => 0x10b },
	'rawdevelopmentprocess' => { 291 => 0x62 },
	'rawdevengine' => { 244 => 0x109, 245 => 0x10b },
	'rawdevexposurebiasvalue' => { 244 => 0x100, 245 => 0x100 },
	'rawdevgradation' => { 245 => 0x112 },
	'rawdevgraypoint' => { 244 => 0x103, 245 => 0x104 },
	'rawdevmemorycoloremphasis' => { 244 => 0x105, 245 => 0x108 },
	'rawdevnoisereduction' => { 244 => 0x10a, 245 => 0x10a },
	'rawdevpicturemode' => { 245 => 0x10c },
	'rawdevpm_bwfilter' => { 245 => 0x110 },
	'rawdevpmcontrast' => { 245 => 0x10e },
	'rawdevpmnoisefilter' => { 245 => 0x120 },
	'rawdevpmpicturetone' => { 245 => 0x111 },
	'rawdevpmsaturation' => { 245 => 0x10d },
	'rawdevpmsharpness' => { 245 => 0x10f },
	'rawdevsaturation3' => { 245 => 0x113 },
	'rawdevsaturationemphasis' => { 244 => 0x104, 245 => 0x107 },
	'rawdevsettings' => { 244 => 0x10c },
	'rawdevsharpnessvalue' => { 244 => 0x107, 245 => 0x106 },
	'rawdevversion' => { 244 => 0x0, 245 => 0x0 },
	'rawdevwbfineadjustment' => { 244 => 0x102, 245 => 0x103 },
	'rawdevwhitebalance' => { 245 => 0x101 },
	'rawdevwhitebalancevalue' => { 244 => 0x101, 245 => 0x102 },
	'rawfile' => { 98 => 0xfe4c },
	'rawfilename' => { 383 => 'RawFileName' },
	'rawimagecenter' => { 185 => 0x99 },
	'rawimagedigest' => { 98 => 0xc71c },
	'rawimagesize' => { 291 => 0x39 },
	'rawinfoversion' => { 246 => 0x0 },
	'rawjpgheight' => { 86 => 0x4 },
	'rawjpgquality' => { 47 => 0x6, 86 => 0x1 },
	'rawjpgsize' => { 47 => 0x7, 86 => 0x2 },
	'rawjpgwidth' => { 86 => 0x3 },
	'rawmeasuredrggb' => { 35 => 0x26a, 37 => 0x280, 39 => 0x194, 40 => [0x1ad,0x26b] },
	'rawrppused' => { 378 => 'rawrppused' },
	'rawtopreviewgain' => { 98 => 0xc7a8 },
	'reardisplay' => { 226 => '12.3', 227 => '6.2' },
	'recognizedface1age' => { 253 => 0x20 },
	'recognizedface1name' => { 253 => 0x4 },
	'recognizedface1position' => { 253 => 0x18 },
	'recognizedface2age' => { 253 => 0x50 },
	'recognizedface2name' => { 253 => 0x34 },
	'recognizedface2position' => { 253 => 0x48 },
	'recognizedface3age' => { 253 => 0x80 },
	'recognizedface3name' => { 253 => 0x64 },
	'recognizedface3position' => { 253 => 0x78 },
	'recognizedfaceflags' => { 258 => 0x63 },
	'recommendedexposureindex' => { 98 => 0x8832, 388 => 'RecommendedExposureIndex' },
	'record' => { 97 => 'Record' },
	'recordbasisofrecord' => { 97 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 97 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 97 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 97 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 97 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 97 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 153 => 0x4d },
	'recorddynamicproperties' => { 97 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 84 => 0x1804 },
	'recordinformationwithheld' => { 97 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 313 => 0x1000 },
	'recordingmode' => { 93 => 0x1, 297 => 0x1 },
	'recordinstitutioncode' => { 97 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 97 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 30 => 0x9, 94 => 0x3000 },
	'recordownerinstitutioncode' => { 97 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 321 => 0x217 },
	'redbalance' => { 169 => 0x270, 243 => 0x1017, 262 => 0x11, 291 => 0x1c },
	'redcurvelimits' => { 89 => 0x18a },
	'redcurvepoints' => { 89 => 0x160 },
	'redeyecorrection' => { 223 => 0x0 },
	'redeyeinfo' => { 383 => 'RedEyeInfo' },
	'redeyereduction' => { 153 => 0x41, 330 => 0x6a, 332 => 0x28 },
	'redhue' => { 383 => 'RedHue' },
	'redsaturation' => { 383 => 'RedSaturation' },
	'reductionmatrix1' => { 98 => 0xc625 },
	'reductionmatrix2' => { 98 => 0xc626 },
	'reelname' => { 98 => 0xc789 },
	'reference1' => { 391 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 391 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 98 => 0x214, 402 => 'ReferenceBlackWhite' },
	'referencedate' => { 106 => 0x2f },
	'referencenumber' => { 106 => 0x32 },
	'references' => { 129 => 'References' },
	'referenceservice' => { 106 => 0x2d },
	'regionappliedtodimensions' => { 144 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 144 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 144 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 144 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 144 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 144 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 144 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 144 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 144 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 144 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 144 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 144 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 396 => 'RegionConstraints' },
	'regiondescription' => { 144 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 144 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 144 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 144 => 'Regions' },
	'regioninfodateregionsvalid' => { 145 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 145 => 'RegionInfo' },
	'regioninforegions' => { 145 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 144 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 144 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 145 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 145 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 144 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 144 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 393 => 'RegistryId' },
	'registryitemid' => { 393 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 393 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 127 => 'data' },
	'relatedaudiofilename' => { 127 => '1Name' },
	'relatedaudiofiletype' => { 127 => '0Type' },
	'relatedimagefileformat' => { 98 => 0x1000 },
	'relatedimageheight' => { 98 => 0x1002 },
	'relatedimagewidth' => { 98 => 0x1001 },
	'relatedresourceid' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 98 => 0xa004, 387 => 'RelatedSoundFile' },
	'relatedvideofile' => { 141 => 'data' },
	'relatedvideofilename' => { 141 => '1Name' },
	'relatedvideofiletype' => { 141 => '0Type' },
	'relation' => { 384 => 'relation' },
	'relationshipaccordingto' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 97 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 406 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 406 => 'relativeTimestamp' },
	'relativetimestampscale' => { 406 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 406 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 226 => '17.8', 227 => '18.5', 232 => '33.8', 233 => '17.6' },
	'releasedate' => { 106 => 0x1e, 406 => 'releaseDate' },
	'releasemode' => { 94 => 0x3001, 342 => 0xb049 },
	'releasemode2' => { 349 => 0x112c, 350 => [0x112c,0x8], 351 => [0x1108,0x8], 352 => [0x1184,0x8], 353 => [0x1160,0x8], 354 => [0x4,0x1018], 355 => [0x4,0x210], 356 => 0x3f, 357 => 0x10, 358 => 0x10, 359 => 0x9, 365 => 0x34 },
	'releasemode3' => { 349 => 0x1128, 350 => 0x1128, 351 => 0x1104, 352 => 0x1180, 353 => 0x115c, 354 => 0x1014, 355 => 0x20c },
	'releasesetting' => { 84 => 0x1016 },
	'releasetime' => { 106 => 0x23 },
	'remoteonduration' => { 228 => '3.4', 229 => '17.2', 230 => '18.2', 231 => '18.2', 233 => '18.2', 234 => '4.3', 236 => '19.2' },
	'renditionclass' => { 407 => 'RenditionClass' },
	'renditionof' => { 407 => 'RenditionOf' },
	'renditionofalternatepaths' => { 407 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 407 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 407 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 407 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 407 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 407 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 407 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 407 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 407 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 407 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 407 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 407 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 407 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 407 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 407 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 407 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 407 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 407 => 'RenditionParams' },
	'repeatingflashcount' => { 174 => 0xd, 175 => 0xe, 176 => 0xe, 232 => '17.2', 233 => '24.2', 234 => '9.2', 235 => '24.2', 236 => '25.2' },
	'repeatingflashcountbuilt-in' => { 207 => 0x4db },
	'repeatingflashcountexternal' => { 207 => 0x4c3 },
	'repeatingflashoutput' => { 232 => '17.1', 233 => '24.1', 234 => '9.1', 235 => '24.1', 236 => '25.1' },
	'repeatingflashoutputexternal' => { 207 => 0x4c0 },
	'repeatingflashrate' => { 174 => 0xc, 175 => 0xd, 176 => 0xd, 232 => '18.1', 233 => '25.1', 234 => '10.1', 235 => '25.1', 236 => '26.1' },
	'repeatingflashratebuilt-in' => { 207 => 0x4da },
	'repeatingflashrateexternal' => { 207 => 0x4c2 },
	'requires' => { 381 => 'requires' },
	'resampleparams' => { 406 => 'resampleParams' },
	'resampleparamsquality' => { 406 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 321 => 0x21e },
	'resolution' => { 134 => 'Resolution' },
	'resolutionmode' => { 322 => 0x4 },
	'resolutionunit' => { 98 => 0x128, 109 => 0x2, 402 => 'ResolutionUnit' },
	'resourceid' => { 97 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 97 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 97 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 71 => 0x612 },
	'restrictions' => { 399 => 'restrictions' },
	'retouchareafeather' => { 383 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 383 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 383 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 383 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 383 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 383 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 383 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 383 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 383 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 383 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 383 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 383 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 383 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 383 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 383 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 383 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 383 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 383 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 383 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 383 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 383 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 383 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 383 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 383 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 383 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 383 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 383 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 383 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 383 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 383 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 383 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 383 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 383 => 'RetouchAreas' },
	'retouchareaseed' => { 383 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 383 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 383 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 383 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 185 => 0x9e },
	'retouchinfo' => { 383 => 'RetouchInfo' },
	'reuse' => { 396 => 'Reuse' },
	'reuseallowed' => { 409 => 'ReuseAllowed' },
	'reuseprohibited' => { 399 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 231 => '5.2' },
	'reverseindicators' => { 226 => '12.1', 227 => '6.1', 229 => '4.3', 230 => '5.2', 231 => '5.4', 232 => '33.5', 233 => '5.1', 236 => '6.2' },
	'reverseshutterspeedaperture' => { 231 => '5.3' },
	'revision' => { 385 => 'revision' },
	'rgbcurvelimits' => { 89 => 0x238 },
	'rgbcurvepoints' => { 89 => 0x20e },
	'richtextcomment' => { 390 => 'RichTextComment' },
	'ricohdate' => { 312 => 0x6 },
	'ricohimageheight' => { 312 => 0x2 },
	'ricohimagewidth' => { 312 => 0x0 },
	'rightascension' => { 137 => 'RightAscension' },
	'rights' => { 384 => 'rights' },
	'rightsagent' => { 397 => 'rightsAgent', 399 => 'rightsAgent' },
	'rightsowner' => { 399 => 'rightsOwner' },
	'rollangle' => { 200 => 0x350b, 258 => 0x90, 290 => 0x1 },
	'romoperationmode' => { 84 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 83 => 0x3, 89 => 0x26e, 102 => 0x4, 137 => 'Rotation', 151 => [0x65,0x50], 152 => 0x46, 153 => 0x5a, 156 => 0x10, 206 => '590.1', 219 => 0x76a43207, 258 => 0x30, 272 => '17.2', 299 => 0xd8, 330 => 0x3f, 331 => 0x3f, 341 => 0x10 },
	'routedto' => { 389 => 'RoutedTo' },
	'routing' => { 304 => 'Routing' },
	'routingnotes' => { 389 => 'RoutingNotes' },
	'rowsperstrip' => { 98 => 0x116 },
	'rpp' => { 378 => 'rpp' },
	'safetyshift' => { 71 => 0x108 },
	'safetyshiftinavortv' => { 69 => 0x10, 70 => 0x10, 72 => 0xf, 73 => 0x10, 76 => 0x10 },
	'samplebits' => { 127 => 'SampleBits' },
	'samplerate' => { 127 => 'SampleRate' },
	'samplesperpixel' => { 98 => 0x115, 402 => 'SamplesPerPixel' },
	'samplestructure' => { 108 => 0x5a },
	'samsungmodelid' => { 319 => 0x3 },
	'sanyoquality' => { 321 => 0x201 },
	'sanyothumbnail' => { 321 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 30 => 0xe, 41 => 0x1, 93 => 0xd, 94 => [0x3013,0x1f], 98 => [0xa409,0xfe55], 103 => 0x1003, 128 => 'Saturation', 150 => 0x1f, 151 => 0x32, 152 => 0x28, 153 => 0x1a, 158 => 0x1, 185 => [0x94,0xaa], 187 => 0x35, 258 => 0x40, 260 => 0x300d, 291 => 0x1f, 297 => 0xd, 309 => 0x27, 312 => 0x28, 313 => 0x1013, 322 => 0x10, 330 => 0x1e, 331 => 0x1b, 342 => 0x2005, 383 => 'Saturation', 387 => 'Saturation' },
	'saturationadj' => { 89 => 0x116, 218 => 0x1, 222 => 0x2e, 369 => 0x8016 },
	'saturationadjustmentaqua' => { 383 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 383 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 383 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 383 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 383 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 383 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 383 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 383 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 60 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 59 => 0x68, 60 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 59 => 0x38, 60 => 0x38 },
	'saturationmonochrome' => { 59 => 0x80, 60 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 59 => 0x50, 60 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 59 => 0x20, 60 => 0x20 },
	'saturationsetting' => { 246 => 0x1010, 332 => 0x11, 346 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 59 => 0x8, 60 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 59 => 0x98, 60 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 59 => 0xb0, 60 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 59 => 0xc8, 60 => 0xe0 },
	'saveid' => { 407 => 'SaveID' },
	'scaletype' => { 406 => 'scaleType' },
	'scanimageenhancer' => { 190 => 0x60 },
	'scanningdirection' => { 108 => 0x64 },
	'scene' => { 392 => 'Scene', 406 => 'scene' },
	'scenearea' => { 241 => 0x211, 243 => 0x1031 },
	'sceneassist' => { 185 => 0x9c },
	'scenecapturetype' => { 98 => 0xa406, 387 => 'SceneCaptureType' },
	'scenedetect' => { 241 => 0x210, 243 => 0x1030 },
	'scenedetectdata' => { 241 => 0x212, 243 => 0x1033 },
	'scenemode' => { 116 => 0xfa02, 155 => 0x100, 185 => 0x8f, 238 => 0x509, 243 => 0x403, 258 => 0x8001, 266 => 0xf, 342 => 0xb023 },
	'scenemodeused' => { 118 => [0x6002,0xf002] },
	'sceneselect' => { 321 => 0x21f },
	'scenetype' => { 98 => 0xa301, 387 => 'SceneType' },
	'screentips' => { 226 => '12.7', 227 => '5.3', 232 => '13.1', 233 => '4.4', 236 => '5.1' },
	'section' => { 397 => 'section' },
	'securityclassification' => { 98 => 0x9212 },
	'selectableafpoint' => { 71 => 0x509 },
	'selectafareaselectmode' => { 71 => 0x512 },
	'selftimer' => { 30 => 0x2, 258 => 0x2e, 321 => 0x214 },
	'selftimer2' => { 65 => 0x1d },
	'selftimerinterval' => { 233 => '19.2' },
	'selftimermode' => { 98 => 0x882b },
	'selftimershotcount' => { 227 => '20.2', 229 => '18.2', 230 => '19.2', 231 => '19.2', 233 => '19.3', 236 => '20.2' },
	'selftimershotinterval' => { 227 => '20.3' },
	'selftimertime' => { 84 => 0x1806, 153 => 0x1f, 226 => '18.1', 227 => '20.1', 228 => '3.3', 229 => '18.1', 230 => '19.1', 231 => '19.1', 232 => '7.2', 233 => '19.1', 234 => '3.3', 236 => '20.1' },
	'seminfo' => { 98 => 0x8546 },
	'sensingmethod' => { 98 => 0xa217, 387 => 'SensingMethod' },
	'sensitivityadjust' => { 291 => 0x40 },
	'sensitivitysteps' => { 272 => ['14.3','17.4'], 274 => 0x1 },
	'sensitivitytype' => { 98 => 0x8830, 388 => 'SensitivityType' },
	'sensorareas' => { 319 => 0xa010 },
	'sensorbitdepth' => { 260 => 0x312d },
	'sensorbluelevel' => { 63 => 0x5 },
	'sensorcalibration' => { 242 => 0x805 },
	'sensorcleaning' => { 77 => 0xd },
	'sensorfullheight' => { 111 => 0xf904 },
	'sensorfullwidth' => { 111 => 0xf903 },
	'sensorheight' => { 111 => 0xf901, 116 => 0xfa21, 157 => 0x8, 260 => 0x312c, 313 => 0x1602 },
	'sensorpixelsize' => { 185 => 0x9a },
	'sensorredlevel' => { 63 => 0x4 },
	'sensorserialnumber' => { 112 => 0x9ce },
	'sensorsize' => { 128 => 'SensorSize', 291 => 0x35 },
	'sensortemperature' => { 241 => 0x1500, 243 => 0x1007, 322 => [0x39,0x55] },
	'sensorwidth' => { 111 => 0xf900, 116 => 0xfa20, 157 => 0xa, 260 => 0x312b, 313 => 0x1601 },
	'sequence' => { 309 => 0x7 },
	'sequencefilenumber' => { 350 => 0x4, 351 => 0x4, 352 => 0x4, 353 => 0x4, 357 => 0xc, 358 => 0xc, 359 => 0x1a },
	'sequenceimagenumber' => { 350 => 0x0, 351 => 0x0, 352 => 0x0, 353 => 0x0, 357 => 0x8, 358 => 0x8, 359 => 0x12, 365 => 0x24 },
	'sequencelength' => { 357 => 0x22, 358 => 0x1e, 359 => [0x16,0x1e] },
	'sequencenumber' => { 65 => 0x9, 94 => 0x301c, 103 => 0x1101, 114 => 0x1d, 207 => 0x51c, 258 => 0x2b, 332 => [0x10c,0x30c], 342 => 0xb04a },
	'sequenceshotinterval' => { 321 => 0x224 },
	'sequentialshot' => { 321 => 0x20e },
	'serialnumber' => { 53 => 0xc, 84 => 0x180b, 98 => [0xa431,0xfde9], 111 => 0xfa04, 113 => 0xfa00, 115 => 0xc354, 116 => 0xfa19, 125 => 0x0, 128 => 'SerialNumber', 185 => [0xa0,0x1d], 239 => 0x101, 243 => [0x404,0x101a], 254 => 0x303, 260 => 0x3103, 291 => 0x229, 309 => 0x15, 313 => 0x5, 322 => 0x2, 380 => 'SerialNumber', 388 => 'BodySerialNumber' },
	'serialnumberformat' => { 53 => 0x15, 84 => 0x183b },
	'seriesdatetime' => { 371 => 'SeriesDateTime' },
	'seriesdescription' => { 371 => 'SeriesDescription' },
	'seriesmodality' => { 371 => 'SeriesModality' },
	'seriesnumber' => { 371 => 'SeriesNumber' },
	'serviceidentifier' => { 107 => 0x1e },
	'setbuttoncrosskeysfunc' => { 74 => 0x0, 75 => 0x0 },
	'setbuttonwhenshooting' => { 69 => 0x1, 71 => 0x704, 77 => 0xc },
	'setfunctionwhenshooting' => { 72 => 0x0, 73 => 0x1, 76 => 0x1 },
	'shadingcompensation' => { 238 => 0x50c, 258 => 0x8a },
	'shadingcompensation2' => { 242 => 0x1012 },
	'shadow' => { 322 => 0xe },
	'shadowcorrection' => { 291 => 0x79 },
	'shadowprotection' => { 218 => 0x0 },
	'shadows' => { 98 => 0xfe52, 377 => 'Shadows', 383 => 'Shadows' },
	'shadows2012' => { 383 => 'Shadows2012' },
	'shadowscale' => { 98 => 0xc633 },
	'shadowtint' => { 383 => 'ShadowTint' },
	'shadowtone' => { 103 => 0x1040 },
	'shakereduction' => { 292 => 0x1, 293 => 0x1 },
	'sharpendetail' => { 383 => 'SharpenDetail' },
	'sharpenedgemasking' => { 383 => 'SharpenEdgeMasking' },
	'sharpening' => { 260 => 0x300b },
	'sharpeningadj' => { 222 => 0x2b },
	'sharpenradius' => { 383 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 30 => 0xf, 63 => 0x2, 93 => 0xb, 94 => [0x3011,0x21], 98 => [0xa40a,0xfe56], 103 => 0x1001, 114 => 0x6b, 123 => 0x37, 128 => 'Sharpness', 150 => 0x21, 151 => 0x30, 152 => 0x26, 153 => 0x18, 158 => 0x3, 185 => 0x6, 187 => 0x32, 243 => 0x100f, 258 => 0x41, 291 => 0x21, 297 => 0xb, 309 => 0x26, 312 => 0x22, 313 => [0x1003,0x1014], 322 => 0x11, 330 => 0x1c, 331 => 0x19, 342 => 0x2006, 365 => 0x52, 383 => 'Sharpness', 387 => 'Sharpness' },
	'sharpnessadj' => { 89 => 0x25a, 369 => 0x801a },
	'sharpnessauto' => { 60 => 0x94 },
	'sharpnessfactor' => { 243 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 59 => 0x64, 60 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 63 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 59 => 0x34, 60 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 59 => 0x7c, 60 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 59 => 0x4c, 60 => 0x4c },
	'sharpnessovershoot' => { 369 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 59 => 0x1c, 60 => 0x1c },
	'sharpnesssetting' => { 238 => 0x506, 246 => 0x1013, 332 => 0x12, 346 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 59 => 0x4, 60 => 0x4 },
	'sharpnessthreshold' => { 369 => 0x801d },
	'sharpnessundershoot' => { 369 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 59 => 0x94, 60 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 59 => 0xac, 60 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 59 => 0xc4, 60 => 0xdc },
	'shootinginfodisplay' => { 226 => '13.2', 227 => '5.1', 232 => '10.2', 233 => '4.1', 236 => '5.3' },
	'shootinginfomonitorofftime' => { 226 => '26.2', 227 => '22.2', 232 => '9.1', 233 => '21.2', 236 => '22.2' },
	'shootingmode' => { 128 => 'ShootingMode', 185 => 0x89, 258 => 0x1f },
	'shootingmodesetting' => { 228 => '5.1' },
	'shortdescription' => { 385 => 'shortdescription' },
	'shortdocumentid' => { 106 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 71 => 0x80d },
	'shotdate' => { 406 => 'shotDate' },
	'shotday' => { 406 => 'shotDay' },
	'shotlocation' => { 406 => 'shotLocation' },
	'shotname' => { 406 => 'shotName' },
	'shotnumber' => { 406 => 'shotNumber' },
	'shotnumbersincepowerup' => { 345 => 0x44e, 357 => 0x1a, 358 => 0x16, 359 => 0xa },
	'shotnumbersincepowerup2' => { 332 => 0x200 },
	'shotsize' => { 406 => 'shotSize' },
	'shutter-aelock' => { 69 => 0x4, 71 => 0x701, 72 => 0x3, 73 => 0x4, 74 => 0x3, 75 => 0x3, 76 => 0x4, 77 => 0x2 },
	'shutteraelbutton' => { 70 => 0x4 },
	'shutterbuttonafonbutton' => { 71 => 0x701 },
	'shuttercount' => { 10 => 0x176, 47 => 0x1, 185 => 0xa7, 191 => [0x6a,0x157,0x24d], 192 => 0x286, 193 => 0x279, 194 => 0x284, 195 => 0x242, 196 => 0x280, 197 => 0x276, 198 => [0x27d,0x27f], 199 => 0x246, 201 => 0x2d6, 202 => 0x321, 203 => 0xbd8, 204 => 0x287, 205 => 0x320, 206 => 0x24a, 207 => 0x5fb, 208 => 0x2d5, 291 => 0x5d, 341 => 0x846, 344 => [0x125,0x14a] },
	'shuttercurtainsync' => { 69 => 0xf, 70 => 0xf, 71 => 0x305, 72 => 0xe, 73 => 0xf, 74 => 0x8, 75 => 0x8, 76 => 0xf, 77 => 0x8 },
	'shuttermode' => { 114 => 0x1b },
	'shutterreleasebuttonae-l' => { 226 => '17.7', 227 => '18.4', 229 => '16.1', 230 => '17.1', 231 => '17.1', 232 => '7.1', 233 => '17.5', 236 => '18.2' },
	'shutterreleasemethod' => { 84 => 0x1010 },
	'shutterreleasenocfcard' => { 69 => 0x2, 70 => 0x2, 77 => 0xf },
	'shutterreleasetiming' => { 84 => 0x1011 },
	'shutterreleasewithoutlens' => { 71 => 0x711 },
	'shutterspeedlock' => { 227 => '38.1' },
	'shutterspeedrange' => { 71 => 0x10c },
	'shutterspeedsetting' => { 153 => 0x6, 330 => 0x2f, 331 => 0x28, 332 => 0x0 },
	'shutterspeedvalue' => { 80 => 0x1, 98 => 0x9201, 243 => 0x1000, 387 => 'ShutterSpeedValue' },
	'shuttertype' => { 103 => 0x1050, 258 => 0x9f },
	'sidecarforextension' => { 395 => 'SidecarForExtension' },
	'similarityindex' => { 106 => 0xe4 },
	'singleframebracketing' => { 153 => 0x21 },
	'slaveflashmeteringsegments' => { 291 => 0x20b },
	'slowshutter' => { 65 => 0x8 },
	'slowsync' => { 103 => 0x1030 },
	'smartrange' => { 319 => 0xa012 },
	'smileshutter' => { 332 => 0x31 },
	'smileshuttermode' => { 332 => 0x27 },
	'smoothness' => { 98 => 0xfe57, 383 => 'Smoothness' },
	'softskineffect' => { 342 => 0x200f },
	'software' => { 98 => 0x131, 129 => 'Software', 250 => 'Software', 322 => 0x18, 402 => 'Software' },
	'softwareversion' => { 321 => 0x207 },
	'sonydatetime' => { 348 => 0x6, 350 => 0x1b6, 351 => 0x210, 352 => 0x1fe, 353 => 0x22c },
	'sonydatetime2' => { 356 => 0x51 },
	'sonyexposuretime' => { 356 => 0x3a },
	'sonyexposuretime2' => { 365 => 0xe },
	'sonyfnumber' => { 356 => 0x3c, 365 => 0x14 },
	'sonyimageheight' => { 348 => 0x1a, 357 => 0x44, 358 => 0x3f, 359 => 0x47 },
	'sonyimagesize' => { 153 => 0x3b, 330 => 0x54, 331 => 0x54, 332 => 0x9 },
	'sonyimagewidth' => { 348 => 0x1c },
	'sonyiso' => { 350 => 0x1218, 351 => 0x11f4, 352 => 0x1270, 353 => [0x1254,0x1258,0x1280], 354 => 0x113c, 355 => 0x344, 365 => 0x4 },
	'sonymaxaperturevalue' => { 365 => 0x16 },
	'sonymodelid' => { 342 => 0xb001 },
	'sonyquality' => { 153 => 0x3c },
	'source' => { 106 => 0x73, 250 => 'Source', 384 => 'source', 385 => 'source', 395 => 'Source' },
	'sourcedirectoryindex' => { 278 => 0x0 },
	'sourcefileindex' => { 278 => 0x2 },
	'sourcephotoscount' => { 373 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 387 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 387 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 387 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 387 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 387 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 406 => 'speakerPlacement' },
	'specialeffectlevel' => { 94 => 0x3030 },
	'specialeffectmode' => { 94 => 0x2076 },
	'specialeffectsetting' => { 94 => 0x3031 },
	'specialinstructions' => { 106 => 0x28 },
	'specialmode' => { 243 => 0x200, 321 => 0x200 },
	'spectralsensitivity' => { 98 => 0x8824, 387 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 37 => [0x2b9,0x2d0,0x2d4], 39 => 0x1e4, 40 => [0x1fd,0x2dd] },
	'splittoningbalance' => { 383 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 383 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 383 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 383 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 383 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 150 => 0x2d },
	'spotfocuspointy' => { 150 => 0x2e },
	'spotmeteringmode' => { 30 => 0x27 },
	'spotmeterlinktoafpoint' => { 71 => 0x107 },
	'sractive' => { 272 => '17.1' },
	'srawquality' => { 30 => 0x2e },
	'srfocallength' => { 292 => 0x3 },
	'srhalfpresstime' => { 292 => 0x2 },
	'srresult' => { 292 => 0x0, 293 => 0x0 },
	'standardoutputhighlightpoint' => { 90 => 0x14 },
	'standardoutputsensitivity' => { 98 => 0x8831, 388 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 90 => 0x15 },
	'standardrawcolortone' => { 90 => 0xd },
	'standardrawcontrast' => { 90 => 0xf },
	'standardrawhighlight' => { 90 => 0x75 },
	'standardrawhighlightpoint' => { 90 => 0x12 },
	'standardrawlinear' => { 90 => 0x10 },
	'standardrawsaturation' => { 90 => 0xe },
	'standardrawshadow' => { 90 => 0x7e },
	'standardrawshadowpoint' => { 90 => 0x13 },
	'standardrawsharpness' => { 90 => 0x11 },
	'standardunsharpmaskfineness' => { 90 => 0x94 },
	'standardunsharpmaskstrength' => { 90 => 0x92 },
	'standardunsharpmaskthreshold' => { 90 => 0x96 },
	'standbytimer' => { 227 => '19.1', 231 => '18.1' },
	'startingpage' => { 397 => 'startingPage' },
	'startmovieshooting' => { 71 => 0x70d },
	'starttimecode' => { 406 => 'startTimecode' },
	'starttimecodetimeformat' => { 406 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 406 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 406 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 133 => 'State', 258 => 0x6b, 395 => 'State' },
	'status' => { 372 => 'Status', 376 => 'Status' },
	'stitchingsoftware' => { 373 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 349 => 0x113e, 350 => 0x113e, 351 => 0x111a, 352 => 0x1196, 353 => 0x1172, 354 => 0x102a, 355 => 0x222, 365 => 0xa },
	'storagemethod' => { 157 => 0x12 },
	'storebyorientation' => { 227 => '46.3' },
	'straightenangle' => { 219 => 0x2fc08431 },
	'stretchmode' => { 406 => 'stretchMode' },
	'studydatetime' => { 371 => 'StudyDateTime' },
	'studydescription' => { 371 => 'StudyDescription' },
	'studyid' => { 371 => 'StudyID' },
	'studyphysician' => { 371 => 'StudyPhysician' },
	'sub-location' => { 106 => 0x5c },
	'subfiledata' => { 136 => 'data' },
	'subfiledirectory' => { 136 => '1Directory' },
	'subfilemimetype' => { 136 => '2MIME' },
	'subfilename' => { 136 => '1Name' },
	'subfileresource' => { 136 => 'rsrc' },
	'subfiletype' => { 98 => 0xfe, 136 => '0Type' },
	'subject' => { 247 => 'Subject', 304 => 'Subject', 384 => 'subject', 394 => 'Subject', 407 => 'subject' },
	'subjectarea' => { 98 => 0x9214, 387 => 'SubjectArea' },
	'subjectcode' => { 392 => 'SubjectCode' },
	'subjectdistance' => { 98 => 0x9206, 114 => 0x3e, 387 => 'SubjectDistance' },
	'subjectdistancerange' => { 98 => 0xa40c, 387 => 'SubjectDistanceRange' },
	'subjectlocation' => { 98 => 0xa214, 387 => 'SubjectLocation' },
	'subjectprogram' => { 150 => 0x22 },
	'subjectreference' => { 106 => 0xc },
	'sublabels4' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 391 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 391 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 98 => 0x9290 },
	'subsectimedigitized' => { 98 => 0x9292 },
	'subsectimeoriginal' => { 98 => 0x9291 },
	'subsection1' => { 397 => 'subsection1' },
	'subsection2' => { 397 => 'subsection2' },
	'subsection3' => { 397 => 'subsection3' },
	'subsection4' => { 397 => 'subsection4' },
	'subselector' => { 227 => '49.1' },
	'subselectorassignment' => { 227 => '48.1' },
	'subselectorplusdials' => { 227 => '49.2' },
	'subversionfilename' => { 391 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 391 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 391 => 'SubVersions' },
	'superimposeddisplay' => { 69 => 0xa, 71 => 0x510, 72 => 0x9, 73 => 0xa, 76 => 0xa, 77 => 0xe },
	'supermacro' => { 53 => 0x1a },
	'supplementalcategories' => { 106 => 0x14, 395 => 'SupplementalCategories' },
	'supplementaltype' => { 108 => 0x37 },
	'svisosetting' => { 272 => 0x14 },
	'sweeppanoramadirection' => { 258 => 0x93, 332 => 0x33 },
	'sweeppanoramafieldofview' => { 258 => 0x94 },
	'sweeppanoramasize' => { 332 => 0x32 },
	'switchtoregisteredafpoint' => { 70 => 0x12, 71 => 0x50a },
	'tagged' => { 299 => 0xdd, 300 => 'Tagged', 378 => 'tagged' },
	'tagslist' => { 386 => 'TagsList' },
	'tagstructure' => { 391 => 'TagStructure' },
	'takenumber' => { 406 => 'takeNumber' },
	'tapename' => { 406 => 'tapeName' },
	'targetaperture' => { 65 => 0x4 },
	'targetcompressionratio' => { 82 => 0x1 },
	'targetdistancesetting' => { 84 => 0x1807 },
	'targetexposuretime' => { 65 => 0x5 },
	'targetimagetype' => { 84 => 0x100a },
	'taxon' => { 97 => 'Taxon' },
	'taxonacceptednameusage' => { 97 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 97 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 97 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 97 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 97 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 97 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 97 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 97 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 97 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 97 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 97 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 97 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 97 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 97 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 97 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 97 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 97 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 97 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 97 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 97 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 97 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 97 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 97 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 97 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 97 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 97 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 97 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 97 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 97 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 97 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 97 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 97 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 97 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 397 => 'teaser' },
	'teleconverter' => { 155 => 0x105, 342 => 0x105 },
	'tempo' => { 406 => 'tempo' },
	'termsandconditionstext' => { 396 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 396 => 'TermsAndConditionsURL' },
	'testname' => { 99 => 'TestName' },
	'textencoding' => { 184 => 0x4 },
	'textlayername' => { 395 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 395 => 'TextLayers' },
	'textlayertext' => { 395 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 258 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 98 => 0x107 },
	'thumbnailfilename' => { 84 => 0x817 },
	'thumbnailformat' => { 404 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 116 => 0xfa55, 404 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 84 => 0x2008, 95 => 'ThumbnailImage', 101 => 0x3, 139 => 'data', 243 => 0x100, 404 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 139 => '1Name' },
	'thumbnailimagesize' => { 139 => 'ImageSize' },
	'thumbnailimagetype' => { 139 => '0Type' },
	'thumbnailimagevalidarea' => { 53 => 0x13 },
	'thumbnaillength' => { 98 => 0x202 },
	'thumbnailoffset' => { 98 => 0x201 },
	'thumbnails' => { 404 => 'Thumbnails' },
	'thumbnailwidth' => { 116 => 0xfa54, 404 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 397 => 'ticker' },
	'tiffmeteringimage' => { 156 => 0x104c, 341 => 0x1110 },
	'tilelength' => { 98 => 0x143 },
	'tilewidth' => { 98 => 0x142 },
	'time' => { 112 => 0x401, 291 => 0x7 },
	'timecodes' => { 98 => 0xc763 },
	'timecreated' => { 106 => 0x3c, 114 => 0x14, 123 => 0x10, 300 => 'TimeCreated' },
	'timeperiod' => { 397 => 'timePeriod' },
	'timerfunctionbutton' => { 228 => '5.2', 229 => '12.1', 230 => '13.1' },
	'timerlength' => { 71 => 0x80c },
	'timerrecording' => { 258 => 0x96 },
	'timescaleparams' => { 406 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 406 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 406 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 406 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 107 => 0x50 },
	'timesignature' => { 406 => 'timeSignature' },
	'timesincepoweron' => { 258 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 237 => 0x8, 250 => 'TimeStamp', 379 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 66 => 0x1, 211 => 0x0 },
	'timezonecity' => { 66 => 0x2 },
	'timezonecode' => { 87 => 0x1 },
	'timezoneinfo' => { 87 => 0x2 },
	'timezoneoffset' => { 98 => 0x882a },
	'tint' => { 383 => 'Tint' },
	'title' => { 129 => 'Title', 247 => 'Title', 250 => 'Title', 258 => 0x65, 304 => 'Title', 384 => 'title', 394 => 'Title', 404 => 'Title' },
	'tonecomp' => { 185 => 0x81 },
	'tonecurve' => { 63 => 0x1, 291 => 0x402, 383 => 'ToneCurve' },
	'tonecurveactive' => { 89 => 0x110 },
	'tonecurveadobergb' => { 319 => 0xa043 },
	'tonecurveadobergbdefault' => { 319 => 0xa041 },
	'tonecurveblue' => { 383 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 369 => 0x9003 },
	'tonecurvebluey' => { 369 => 0x9007 },
	'tonecurvebrightnessx' => { 369 => 0x9000 },
	'tonecurvebrightnessy' => { 369 => 0x9004 },
	'tonecurvefilename' => { 112 => 0x1391 },
	'tonecurvegreen' => { 383 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 369 => 0x9002 },
	'tonecurvegreeny' => { 369 => 0x9006 },
	'tonecurveinterpolation' => { 89 => 0x159 },
	'tonecurvemode' => { 89 => 0x113 },
	'tonecurvename' => { 383 => 'ToneCurveName' },
	'tonecurvename2012' => { 383 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 89 => 0x3c },
	'tonecurvepv2012' => { 383 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 383 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 383 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 383 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 383 => 'ToneCurveRed' },
	'tonecurveredx' => { 369 => 0x9001 },
	'tonecurveredy' => { 369 => 0x9005 },
	'tonecurves' => { 291 => 0x403 },
	'tonecurvesrgb' => { 319 => 0xa042 },
	'tonecurvesrgbdefault' => { 319 => 0xa040 },
	'tonelevel' => { 238 => 0x52e },
	'toningeffect' => { 47 => 0xf, 185 => 0xb3, 187 => 0x38, 313 => 0x1015 },
	'toningeffectauto' => { 60 => 0xa4 },
	'toningeffectfaithful' => { 59 => 0x74, 60 => 0x74 },
	'toningeffectlandscape' => { 59 => 0x44, 60 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 59 => 0x8c, 60 => 0x8c },
	'toningeffectneutral' => { 59 => 0x5c, 60 => 0x5c },
	'toningeffectportrait' => { 59 => 0x2c, 60 => 0x2c },
	'toningeffectstandard' => { 59 => 0x14, 60 => 0x14 },
	'toningeffectuserdef1' => { 59 => 0xa4, 60 => 0xbc },
	'toningeffectuserdef2' => { 59 => 0xbc, 60 => 0xd4 },
	'toningeffectuserdef3' => { 59 => 0xd4, 60 => 0xec },
	'toningsaturation' => { 187 => 0x39 },
	'totalzoom' => { 114 => 0x62 },
	'touchae' => { 258 => 0xab },
	'trackcreatedate' => { 308 => 0x1 },
	'trackmodifydate' => { 308 => 0x2 },
	'tracknumber' => { 406 => 'trackNumber' },
	'tracks' => { 406 => 'Tracks' },
	'tracksframerate' => { 406 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 406 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 406 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 406 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 406 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 406 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 406 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 406 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 406 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 406 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 406 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 406 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 406 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 406 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 406 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 406 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 406 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 136 => 'zmie' },
	'transferfunction' => { 98 => 0x12d, 402 => 'TransferFunction' },
	'transform' => { 258 => [0x8012,0x59] },
	'transmissionreference' => { 395 => 'TransmissionReference' },
	'trapped' => { 247 => 'Trapped', 394 => 'Trapped' },
	'trashbuttonfunction' => { 71 => 0x710 },
	'travelday' => { 258 => 0x36 },
	'triggermode' => { 309 => 0x6 },
	'tstop' => { 98 => 0xc772 },
	'ttl_da_adown' => { 279 => 0x5 },
	'ttl_da_aup' => { 279 => 0x4 },
	'ttl_da_bdown' => { 279 => 0x7 },
	'ttl_da_bup' => { 279 => 0x6 },
	'tungstenawb' => { 269 => 0x1 },
	'tvexposuretimesetting' => { 272 => 0x12 },
	'type' => { 384 => 'type', 401 => 'type' },
	'typestatus' => { 97 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 98 => 0xc614 },
	'uniquedocumentid' => { 106 => 0xbb },
	'uniqueobjectname' => { 107 => 0x64 },
	'unknownblock' => { 291 => 0x405 },
	'unknownblock1' => { 242 => 0x635 },
	'unknownblock2' => { 242 => 0x636 },
	'unknownblock3' => { 242 => 0x1103 },
	'unknownblock4' => { 242 => 0x1104 },
	'unknowncontrast' => { 90 => 0x45 },
	'unknownev' => { 112 => 0x1 },
	'unknownlinear' => { 90 => 0x46 },
	'unknownnumber' => { 84 => 0x180b },
	'unknownoutputhighlightpoint' => { 90 => 0x4a },
	'unknownoutputshadowpoint' => { 90 => 0x4b },
	'unknownrawhighlight' => { 90 => 0x7b },
	'unknownrawhighlightpoint' => { 90 => 0x48 },
	'unknownrawshadow' => { 90 => 0x84 },
	'unknownrawshadowpoint' => { 90 => 0x49 },
	'unknownsharpness' => { 90 => 0x47 },
	'unknowntemperature' => { 100 => 0x4 },
	'unsharp1color' => { 224 => 0x13 },
	'unsharp1halowidth' => { 224 => 0x19 },
	'unsharp1intensity' => { 224 => 0x17 },
	'unsharp1threshold' => { 224 => 0x1b },
	'unsharp2color' => { 224 => 0x2e },
	'unsharp2halowidth' => { 224 => 0x34 },
	'unsharp2intensity' => { 224 => 0x32 },
	'unsharp2threshold' => { 224 => 0x36 },
	'unsharp3color' => { 224 => 0x49 },
	'unsharp3halowidth' => { 224 => 0x4f },
	'unsharp3intensity' => { 224 => 0x4d },
	'unsharp3threshold' => { 224 => 0x51 },
	'unsharp4color' => { 224 => 0x64 },
	'unsharp4halowidth' => { 224 => 0x6a },
	'unsharp4intensity' => { 224 => 0x68 },
	'unsharp4threshold' => { 224 => 0x6c },
	'unsharpcount' => { 224 => 0x0 },
	'unsharpmask' => { 90 => 0x90, 219 => 0x76a43200 },
	'uprightcentermode' => { 383 => 'UprightCenterMode' },
	'uprightcenternormx' => { 383 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 383 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 383 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 383 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 383 => 'UprightFocalMode' },
	'uprightpreview' => { 383 => 'UprightPreview' },
	'uprighttransform_0' => { 383 => 'UprightTransform_0' },
	'uprighttransform_1' => { 383 => 'UprightTransform_1' },
	'uprighttransform_2' => { 383 => 'UprightTransform_2' },
	'uprighttransform_3' => { 383 => 'UprightTransform_3' },
	'uprighttransform_4' => { 383 => 'UprightTransform_4' },
	'uprighttransformcount' => { 383 => 'UprightTransformCount' },
	'uprightversion' => { 383 => 'UprightVersion' },
	'urgency' => { 106 => 0xa, 395 => 'Urgency' },
	'url' => { 129 => 'URL', 250 => 'URL', 302 => 0x40b, 397 => 'url' },
	'usablemeteringmodes' => { 71 => 0x10a },
	'usableshootingmodes' => { 71 => 0x109 },
	'usage' => { 398 => 'usage' },
	'usagefee' => { 399 => 'usageFee' },
	'usageterms' => { 410 => 'UsageTerms' },
	'useguidelines' => { 381 => 'useGuidelines' },
	'usepanoramaviewer' => { 373 => 'UsePanoramaViewer' },
	'usercomment' => { 84 => 0x805, 98 => 0x9286, 387 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 59 => 0xd8, 60 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 59 => 0xda, 60 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 59 => 0xdc, 60 => 0xf4 },
	'userfields' => { 376 => 'UserFields' },
	'userlabel' => { 309 => 0x2b },
	'userprofile' => { 254 => 0x302, 260 => 0x3038 },
	'usmlenselectronicmf' => { 70 => 0x7, 71 => 0x501 },
	'utmeasting' => { 140 => 'Easting' },
	'utmmapdatum' => { 140 => 'Datum' },
	'utmnorthing' => { 140 => 'Northing' },
	'utmzone' => { 140 => 'Zone' },
	'uv-irfiltercorrection' => { 254 => 0x325 },
	'validbits' => { 242 => 0x611, 243 => 0x102c },
	'validpixeldepth' => { 246 => 0x611 },
	'variousmodes' => { 114 => 0x26 },
	'variousmodes2' => { 114 => 0x3a },
	'variprogram' => { 185 => 0xab },
	'version' => { 103 => 0x0, 304 => 'Version', 383 => 'Version' },
	'versioncreatedate' => { 369 => 0xd100 },
	'versionid' => { 407 => 'VersionID' },
	'versionidentifier' => { 397 => 'versionIdentifier' },
	'versionmodifydate' => { 369 => 0xd101 },
	'versions' => { 407 => 'Versions' },
	'versionscomments' => { 407 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 407 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 407 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 407 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 407 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 407 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 407 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 407 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 407 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 407 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 407 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 226 => '3.2', 227 => '47.2' },
	'verticalfuncbutton' => { 227 => '42.2' },
	'verticalfuncbuttonplusdials' => { 227 => '43.1' },
	'verticalmultiselector' => { 227 => '42.1' },
	'vfdisplayillumination' => { 71 => 0x510 },
	'vibrance' => { 377 => 'Vibrance', 383 => 'Vibrance' },
	'vibrationreduction' => { 191 => [0x75,0x82,0x1ae], 199 => '586.1', 206 => '590.2', 210 => 0x4 },
	'videoalphamode' => { 406 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 406 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 406 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 406 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 56 => 0x74 },
	'videocolorspace' => { 406 => 'videoColorSpace' },
	'videocompressor' => { 406 => 'videoCompressor' },
	'videofieldorder' => { 406 => 'videoFieldOrder' },
	'videoframerate' => { 406 => 'videoFrameRate' },
	'videoframesize' => { 406 => 'videoFrameSize' },
	'videoframesizeh' => { 406 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 406 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 406 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 406 => 'videoModDate' },
	'videopixelaspectratio' => { 406 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 406 => 'videoPixelDepth' },
	'videoquality' => { 94 => 0x4003 },
	'viewfinderdisplay' => { 226 => '12.4', 227 => '6.3' },
	'viewfinderwarning' => { 226 => '13.4', 233 => '3.5', 234 => '6.2', 236 => '4.4' },
	'viewfinderwarnings' => { 71 => 0x40a },
	'viewinfoduringexposure' => { 71 => 0x407 },
	'viewingmode' => { 332 => 0x2f, 346 => 0x18 },
	'viewingmode2' => { 332 => [0x85,0x285] },
	'vignetteamount' => { 383 => 'VignetteAmount' },
	'vignettecontrol' => { 185 => 0x2a, 219 => 0x76a43205 },
	'vignettecontrolintensity' => { 219 => 0xac6bd5c0 },
	'vignettemidpoint' => { 383 => 'VignetteMidpoint' },
	'vignetting' => { 313 => 0x1011, 319 => 0xa052 },
	'vignettingcorrection' => { 281 => 0x2, 319 => 0xa053, 342 => 0x2011 },
	'vignettingsetting' => { 319 => 0xa054 },
	'voicememo' => { 321 => 0x216 },
	'volume' => { 397 => 'volume' },
	'vr_0x66' => { 191 => 0x66 },
	'vrdoffset' => { 53 => 0xd0 },
	'vrmode' => { 210 => 0x6 },
	'wb_bluelevel3500k' => { 156 => 0x19a },
	'wb_bluelevel6500k' => { 156 => 0x18a },
	'wb_bluelevelcustom' => { 156 => 0x18e },
	'wb_bluelevelscloudy' => { 156 => 0x106 },
	'wb_bluelevelsdaylight' => { 156 => 0xea },
	'wb_bluelevelsflash' => { 156 => 0x122 },
	'wb_bluelevelsfluorescent' => { 156 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 156 => 0x254 },
	'wb_bluelevelsshade' => { 156 => 0x176 },
	'wb_bluelevelstungsten' => { 156 => 0xce },
	'wb_gbrglevels' => { 156 => 0xae, 159 => 0x4 },
	'wb_glevel' => { 242 => 0x11f },
	'wb_glevel3000k' => { 242 => 0x113 },
	'wb_glevel3300k' => { 242 => 0x114 },
	'wb_glevel3600k' => { 242 => 0x115 },
	'wb_glevel3900k' => { 242 => 0x116 },
	'wb_glevel4000k' => { 242 => 0x117 },
	'wb_glevel4300k' => { 242 => 0x118 },
	'wb_glevel4500k' => { 242 => 0x119 },
	'wb_glevel4800k' => { 242 => 0x11a },
	'wb_glevel5300k' => { 242 => 0x11b },
	'wb_glevel6000k' => { 242 => 0x11c },
	'wb_glevel6600k' => { 242 => 0x11d },
	'wb_glevel7500k' => { 242 => 0x11e },
	'wb_grbglevels' => { 168 => 0x0 },
	'wb_rbgglevels' => { 165 => 0x0 },
	'wb_rblevels' => { 185 => 0xc, 242 => 0x100 },
	'wb_rblevels1' => { 263 => 0x2 },
	'wb_rblevels2' => { 263 => 0x5 },
	'wb_rblevels3' => { 263 => 0x8 },
	'wb_rblevels3000k' => { 242 => 0x102 },
	'wb_rblevels3300k' => { 242 => 0x103 },
	'wb_rblevels3500k' => { 156 => 0x430 },
	'wb_rblevels3600k' => { 242 => 0x104 },
	'wb_rblevels3900k' => { 242 => 0x105 },
	'wb_rblevels4' => { 263 => 0xb },
	'wb_rblevels4000k' => { 242 => 0x106 },
	'wb_rblevels4300k' => { 242 => 0x107 },
	'wb_rblevels4500k' => { 242 => 0x108 },
	'wb_rblevels4800k' => { 242 => 0x109 },
	'wb_rblevels5' => { 263 => 0xe },
	'wb_rblevels5300k' => { 242 => 0x10a },
	'wb_rblevels6' => { 263 => 0x11 },
	'wb_rblevels6000k' => { 242 => 0x10b },
	'wb_rblevels6500k' => { 156 => 0x420 },
	'wb_rblevels6600k' => { 242 => 0x10c },
	'wb_rblevels7' => { 263 => 0x14 },
	'wb_rblevels7500k' => { 242 => 0x10d },
	'wb_rblevelsauto' => { 246 => 0x110 },
	'wb_rblevelscloudy' => { 156 => 0x3f0, 158 => 0x10, 246 => 0x121 },
	'wb_rblevelscoolwhitef' => { 156 => 0x308, 158 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 246 => 0x132 },
	'wb_rblevelscustom' => { 156 => 0x424 },
	'wb_rblevelscwb1' => { 242 => 0x10e },
	'wb_rblevelscwb2' => { 242 => 0x10f },
	'wb_rblevelscwb3' => { 242 => 0x110 },
	'wb_rblevelscwb4' => { 242 => 0x111 },
	'wb_rblevelsdaylight' => { 156 => [0x3ec,0x528], 158 => 0xc },
	'wb_rblevelsdaylightf' => { 158 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 246 => 0x130 },
	'wb_rblevelsdaywhitef' => { 158 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 246 => 0x131 },
	'wb_rblevelseveningsunlight' => { 246 => 0x124 },
	'wb_rblevelsfineweather' => { 246 => 0x122 },
	'wb_rblevelsflash' => { 156 => [0x3f4,0x304], 158 => 0x18 },
	'wb_rblevelsshade' => { 156 => 0x418, 158 => 0x20, 246 => 0x120 },
	'wb_rblevelstungsten' => { 156 => 0x3e8, 158 => 0x8, 246 => 0x123 },
	'wb_rblevelsunknown' => { 158 => 0x1c },
	'wb_rblevelsused' => { 246 => 0x100 },
	'wb_rblevelswhitef' => { 158 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 246 => 0x133 },
	'wb_redlevel3500k' => { 156 => 0x198 },
	'wb_redlevel6500k' => { 156 => 0x188 },
	'wb_redlevelcustom' => { 156 => 0x18c },
	'wb_redlevelscloudy' => { 156 => 0xf8 },
	'wb_redlevelsdaylight' => { 156 => 0xdc },
	'wb_redlevelsflash' => { 156 => 0x114 },
	'wb_redlevelsfluorescent' => { 156 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 156 => 0x1be },
	'wb_redlevelsshade' => { 156 => 0x168 },
	'wb_redlevelstungsten' => { 156 => 0xc0 },
	'wb_rgbglevels' => { 167 => 0x0 },
	'wb_rgblevels' => { 156 => [0x546,0x96], 255 => 0xd, 256 => 0x413, 260 => 0x3036, 349 => 0x117c, 350 => 0x1180, 351 => 0x115c, 352 => 0x11d8, 353 => 0x11b4, 354 => 0x106c, 355 => 0x264 },
	'wb_rgblevels1' => { 264 => 0x2 },
	'wb_rgblevels2' => { 264 => 0x6 },
	'wb_rgblevels3' => { 264 => 0xa },
	'wb_rgblevels4' => { 264 => 0xe },
	'wb_rgblevels5' => { 264 => 0x12 },
	'wb_rgblevels6' => { 264 => 0x16 },
	'wb_rgblevels7' => { 264 => 0x1a },
	'wb_rggbblacklevels' => { 31 => 0x25 },
	'wb_rggblevels' => { 159 => 0x4, 166 => 0x0 },
	'wb_rggblevelsasshot' => { 33 => 0x0, 34 => 0x19, 35 => 0x22, 36 => 0x3f, 39 => 0x3f, 40 => 0x3f },
	'wb_rggblevelsauto' => { 31 => 0x1, 33 => 0x5, 34 => 0x1e, 35 => 0x18, 36 => 0x44, 39 => 0x44, 40 => 0x44, 319 => 0xa022 },
	'wb_rggblevelsblack' => { 319 => 0xa028 },
	'wb_rggblevelscloudy' => { 31 => 0xd, 33 => 0x1e, 34 => 0x2d, 35 => 0x31, 36 => 0x58, 39 => 0x71, 40 => 0x8a, 291 => 0x20f, 298 => 0x14 },
	'wb_rggblevelscustom' => { 31 => 0x1d, 36 => 0x80 },
	'wb_rggblevelscustom1' => { 34 => 0x41 },
	'wb_rggblevelscustom2' => { 34 => 0x46 },
	'wb_rggblevelsdaylight' => { 31 => 0x5, 33 => 0x14, 34 => 0x23, 35 => 0x27, 36 => 0x4e, 39 => 0x67, 40 => 0x80, 291 => 0x20d, 298 => 0x2 },
	'wb_rggblevelsflash' => { 31 => 0x19, 33 => 0x32, 34 => 0x3c, 35 => 0x45, 36 => 0x6c, 39 => 0x85, 40 => 0x9e, 291 => 0x214, 298 => 0x41 },
	'wb_rggblevelsfluorescent' => { 31 => 0x15, 33 => 0x28, 34 => 0x37, 35 => 0x3b, 36 => 0x62, 39 => 0x7b, 40 => 0x94 },
	'wb_rggblevelsfluorescentd' => { 291 => 0x211, 298 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 298 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 291 => 0x212, 298 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 291 => 0x213, 298 => 0x38 },
	'wb_rggblevelsilluminator1' => { 319 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 319 => 0xa024 },
	'wb_rggblevelskelvin' => { 31 => 0x21, 33 => 0x2d, 35 => 0x40, 36 => 0x67, 39 => 0x80, 40 => 0x99 },
	'wb_rggblevelsmeasured' => { 33 => 0xa, 36 => 0x49, 39 => 0x49, 40 => 0x49 },
	'wb_rggblevelspc1' => { 35 => 0x90, 36 => 0x71 },
	'wb_rggblevelspc2' => { 35 => 0x95, 36 => 0x76 },
	'wb_rggblevelspc3' => { 35 => 0x9a, 36 => 0x7b },
	'wb_rggblevelsshade' => { 31 => 0x9, 33 => 0x19, 34 => 0x28, 35 => 0x2c, 36 => 0x53, 39 => 0x6c, 40 => 0x85, 291 => 0x20e, 298 => 0xb },
	'wb_rggblevelstungsten' => { 31 => 0x11, 33 => 0x23, 34 => 0x32, 35 => 0x36, 36 => 0x5d, 39 => 0x76, 40 => 0x8f, 291 => 0x210, 298 => 0x1d },
	'wb_rggblevelsuncorrected' => { 319 => 0xa021 },
	'wb_rggblevelsunknown' => { 33 => 0xf, 35 => 0x1d, 39 => 0x4e, 40 => 0x4e, 298 => 0x53 },
	'wb_rggblevelsunknown10' => { 33 => 0x5f, 35 => 0x72, 39 => 0x9e, 40 => 0x7b },
	'wb_rggblevelsunknown11' => { 33 => 0x64, 35 => 0x77, 39 => 0xa3, 40 => 0xa3 },
	'wb_rggblevelsunknown12' => { 33 => 0x69, 35 => 0x7c, 39 => 0xa8, 40 => 0xa8 },
	'wb_rggblevelsunknown13' => { 33 => 0x6e, 35 => 0x81, 39 => 0xad, 40 => 0xad },
	'wb_rggblevelsunknown14' => { 35 => 0x86, 39 => 0xb2, 40 => 0xb2 },
	'wb_rggblevelsunknown15' => { 35 => 0x8b, 39 => 0xb7, 40 => 0xb7 },
	'wb_rggblevelsunknown16' => { 35 => 0x9f, 40 => 0xbc },
	'wb_rggblevelsunknown17' => { 40 => 0xc1 },
	'wb_rggblevelsunknown18' => { 40 => 0xc6 },
	'wb_rggblevelsunknown19' => { 40 => 0xcb },
	'wb_rggblevelsunknown2' => { 33 => 0x37, 35 => 0x4a, 39 => 0x53, 40 => 0x53 },
	'wb_rggblevelsunknown20' => { 40 => 0xd0 },
	'wb_rggblevelsunknown3' => { 33 => 0x3c, 35 => 0x4f, 39 => 0x58, 40 => 0x58 },
	'wb_rggblevelsunknown4' => { 33 => 0x41, 35 => 0x54, 39 => 0x5d, 40 => 0x5d },
	'wb_rggblevelsunknown5' => { 33 => 0x46, 35 => 0x59, 39 => 0x62, 40 => 0x62 },
	'wb_rggblevelsunknown6' => { 33 => 0x4b, 35 => 0x5e, 39 => 0x8a, 40 => 0x67 },
	'wb_rggblevelsunknown7' => { 33 => 0x50, 35 => 0x63, 39 => 0x8f, 40 => 0x6c },
	'wb_rggblevelsunknown8' => { 33 => 0x55, 35 => 0x68, 39 => 0x94, 40 => 0x71 },
	'wb_rggblevelsunknown9' => { 33 => 0x5a, 35 => 0x6d, 39 => 0x99, 40 => 0x76 },
	'wb_rggblevelsuserselected' => { 298 => 0x5c },
	'wbadjbluebalance' => { 225 => 0x8 },
	'wbadjcolortemp' => { 89 => 0x1a },
	'wbadjlighting' => { 225 => 0x14 },
	'wbadjmode' => { 225 => 0x10 },
	'wbadjredbalance' => { 225 => 0x0 },
	'wbadjrggblevels' => { 89 => 0x6 },
	'wbadjtemperature' => { 225 => 0x18 },
	'wbadjtint' => { 225 => 0x25 },
	'wbbluelevel' => { 254 => 0x324, 258 => 0x8006, 262 => 0x26 },
	'wbbracketmode' => { 47 => 0x9 },
	'wbbracketshotnumber' => { 156 => 0x2b, 313 => 0x101a },
	'wbbracketvalueab' => { 47 => 0xc },
	'wbbracketvaluegm' => { 47 => 0xd },
	'wbfinetuneactive' => { 89 => 0x24 },
	'wbfinetunesaturation' => { 89 => 0x28 },
	'wbfinetunetone' => { 89 => 0x2c },
	'wbgreenlevel' => { 254 => 0x323, 258 => 0x8005, 262 => 0x25 },
	'wbmediaimagesizesetting' => { 71 => 0x708 },
	'wbmode' => { 158 => 0x4, 243 => 0x1015 },
	'wbredlevel' => { 254 => 0x322, 258 => 0x8004, 262 => 0x24 },
	'wbscale' => { 159 => 0x0 },
	'wbshiftab' => { 63 => 0xc, 258 => 0x46, 273 => 0x10 },
	'wbshiftab_gm' => { 342 => 0x2014 },
	'wbshiftgm' => { 63 => 0xd, 258 => 0x47, 273 => 0x11 },
	'wbtype1' => { 263 => 0x1, 264 => 0x1 },
	'wbtype2' => { 263 => 0x4, 264 => 0x5 },
	'wbtype3' => { 263 => 0x7, 264 => 0x9 },
	'wbtype4' => { 263 => 0xa, 264 => 0xd },
	'wbtype5' => { 263 => 0xd, 264 => 0x11 },
	'wbtype6' => { 263 => 0x10, 264 => 0x15 },
	'wbtype7' => { 263 => 0x13, 264 => 0x19 },
	'webstatement' => { 410 => 'WebStatement' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 63 => 0x8, 65 => 0x7, 93 => 0x7, 94 => [0x19,0x2012], 98 => [0xa403,0xfe4e], 103 => 0x1002, 112 => 0x3fc, 113 => 0xfa0d, 114 => 0x40, 150 => 0x3, 151 => 0xe, 152 => 0x4, 153 => 0xb, 155 => 0x115, 185 => 0x5, 209 => 0x7, 254 => 0x304, 258 => 0x3, 260 => 0x3033, 291 => 0x19, 297 => 0x7, 312 => 0x26, 313 => 0x1003, 322 => [0x3c,0x7,0x58], 330 => 0xf, 331 => 0xe, 342 => [0x115,0xb054], 383 => 'WhiteBalance', 387 => 'WhiteBalance' },
	'whitebalance2' => { 238 => 0x500 },
	'whitebalanceadj' => { 89 => 0x18, 219 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 269 => 0x0 },
	'whitebalancebias' => { 94 => 0x2011, 243 => 0x304, 258 => 0x23 },
	'whitebalanceblue' => { 63 => 0x7 },
	'whitebalancebracket' => { 238 => 0x502, 243 => 0x303 },
	'whitebalancebracketing' => { 153 => 0x22, 156 => 0x2c, 341 => 0x2c },
	'whitebalancecomp' => { 246 => 0x1001 },
	'whitebalancefinetune' => { 103 => 0x100a, 153 => 0x38, 155 => 0x112, 185 => 0xb, 313 => 0x1004, 330 => 0x6, 331 => 0x5, 342 => 0x112 },
	'whitebalancemode' => { 291 => 0x1a },
	'whitebalancered' => { 63 => 0x6 },
	'whitebalanceset' => { 272 => 0xa },
	'whitebalancesetting' => { 153 => 0x23, 330 => 0x5, 331 => 0x4, 332 => 0x16, 346 => 0xd },
	'whitebalancetemperature' => { 238 => 0x501 },
	'whiteboard' => { 243 => 0x301 },
	'whitelevel' => { 98 => 0xc61d, 291 => 0x7e },
	'whitepoint' => { 98 => 0x13e, 291 => 0x201, 402 => 'WhitePoint' },
	'whites2012' => { 383 => 'Whites2012' },
	'wideadapter' => { 313 => 0x1017 },
	'widefocuszone' => { 150 => 0x2f },
	'widerange' => { 321 => 0x20f },
	'wordcount' => { 397 => 'wordCount' },
	'workcolorspace' => { 89 => 0x270 },
	'worktodo' => { 389 => 'WorkToDo' },
	'worldtimelocation' => { 258 => 0x3a, 291 => 0x22, 296 => '0.1' },
	'writer-editor' => { 106 => 0x7a },
	'x3filllight' => { 322 => 0x12 },
	'xml' => { 110 => 'xml ' },
	'xmp' => { 88 => 0xffff00f6, 99 => 'XMP' },
	'xmptoolkit' => { 403 => 'xmptk' },
	'xpauthor' => { 98 => 0x9c9d },
	'xpcomment' => { 98 => 0x9c9c },
	'xpkeywords' => { 98 => 0x9c9e },
	'xposition' => { 98 => 0x11e },
	'xpsubject' => { 98 => 0x9c9f },
	'xptitle' => { 98 => 0x9c9b },
	'xresolution' => { 98 => 0x11a, 109 => 0x3, 303 => 0x0, 402 => 'XResolution' },
	'xyresolution' => { 102 => 0x3 },
	'yawangle' => { 200 => 0x3513 },
	'ycbcrcoefficients' => { 98 => 0x211, 402 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 98 => 0x213, 402 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 98 => 0x212, 402 => 'YCbCrSubSampling' },
	'yearcreated' => { 114 => 0x10, 123 => 0xc },
	'yposition' => { 98 => 0x11f },
	'yresolution' => { 98 => 0x11b, 109 => 0x5, 303 => 0x4, 402 => 'YResolution' },
	'zonematching' => { 155 => 0x10a, 158 => [0x3a,0x4a], 342 => 0xb024 },
	'zonematchingmode' => { 153 => 0x14 },
	'zonematchingon' => { 152 => 0x75 },
	'zonematchingvalue' => { 330 => 0x1f },
	'zoomedpreviewlength' => { 243 => 0xf05 },
	'zoomedpreviewsize' => { 243 => 0xf06 },
	'zoomedpreviewstart' => { 243 => 0xf04 },
	'zoomsourcewidth' => { 30 => 0x24 },
	'zoomstepcount' => { 241 => 0x300, 243 => 0x100d },
	'zoomtargetwidth' => { 30 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'platform' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencetemperature' => 1,
	'referencevirtual' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsdaylight' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2015, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
