#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9Firmware3',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD6',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::ShotInfoZ7II',
	'Image::ExifTool::Nikon::ShotInfoZ9',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 109 => 0x69 },
	'about' => { 503 => 'about' },
	'aboutcvterm' => { 495 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 495 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 495 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 495 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 495 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 116 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 509 => 'absPeakAudioFilePath' },
	'academicfield' => { 499 => 'academicField' },
	'acceleration' => { 119 => 0x9404, 489 => 'Acceleration' },
	'accelerationtracking' => { 84 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 394 => 0x3 },
	'accelerometerdata' => { 384 => 'vrot' },
	'accelerometerx' => { 324 => 0x8d },
	'accelerometery' => { 324 => 0x8e },
	'accelerometerz' => { 324 => 0x8c },
	'accessoryserialnumber' => { 324 => 0x54 },
	'accessorytype' => { 324 => 0x53 },
	'actionadvised' => { 131 => 0x2a },
	'activearea' => { 119 => 0xc68d },
	'actived-lighting' => { 227 => 0x22, 274 => 0x24 },
	'actived-lightingmode' => { 274 => 0x25 },
	'adaptervoltage' => { 138 => 0x407 },
	'addaspectratioinfo' => { 84 => 0x80e },
	'addiptcinformation' => { 84 => 0x815 },
	'additionalmodelinformation' => { 495 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 84 => 0x80f, 85 => 0x11, 86 => 0x13, 89 => 0x14 },
	'address' => { 161 => 'Address' },
	'adjustmentmode' => { 401 => 0x15 },
	'adlbracketingstep' => { 252 => 0x883 },
	'adlbracketingtype' => { 252 => 0x884 },
	'adobe' => { 120 => 'Adobe' },
	'adultcontentwarning' => { 311 => 'AdultContentWarning', 502 => 'adultContentWarning' },
	'advancedfilter' => { 127 => 0x1201 },
	'advancedraw' => { 276 => 0x76a43203 },
	'advancedscenetype' => { 324 => 0x3d },
	'advisory' => { 507 => 'Advisory' },
	'ae_iso' => { 332 => 0x2, 333 => 0x4, 334 => 0x12 },
	'aeaperture' => { 332 => 0x1, 333 => 0x3, 334 => 0x11 },
	'aeaperturesteps' => { 332 => 0x8, 333 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 84 => 0x104 },
	'aebbracketvalue' => { 77 => 0x11 },
	'aebracketingsteps' => { 251 => 0x174c, 252 => 0x87b, 261 => 0x1756 },
	'aebsequence' => { 84 => 0x105 },
	'aebsequenceautocancel' => { 82 => 0x9, 83 => 0x9, 85 => 0x8, 86 => 0x9, 89 => 0x9, 90 => 0x7 },
	'aebshotcount' => { 84 => 0x106 },
	'aebxv' => { 332 => 0x4, 333 => 0x6 },
	'aeerror' => { 333 => 0x8 },
	'aeexposuretime' => { 332 => 0x0, 333 => 0x2, 334 => 0x10 },
	'aelbutton' => { 184 => 0x45 },
	'aelexposureindicator' => { 184 => 0x51 },
	'aelock' => { 184 => 0x5b, 285 => '4.2', 294 => '4.2', 301 => 0x201, 359 => 0x48, 411 => 0x40, 412 => 0x40, 413 => [0x86,0x286] },
	'aelockbutton' => { 283 => '16.1', 285 => '4.1', 288 => '15.1', 289 => '16.1', 290 => '16.1', 292 => '30.1', 293 => '16.1', 294 => '4.1', 296 => '17.1', 298 => '17.1' },
	'aelockbuttonplusdials' => { 283 => '16.2', 292 => '32.1', 296 => '44.1' },
	'aelockformb-d80' => { 298 => '3.1' },
	'aelockmetermodeafterfocus' => { 84 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 332 => 0x9, 333 => 0x10, 334 => 0x1c },
	'aemaxaperture2' => { 332 => 0xa, 333 => 0x11, 334 => 0x1d },
	'aemeteringmode' => { 332 => 0xc },
	'aemeteringmode2' => { 332 => '13.1' },
	'aemeteringsegments' => { 187 => 0x628, 359 => 0x209 },
	'aemicroadjustment' => { 84 => 0x110 },
	'aeminaperture' => { 332 => 0xb, 333 => 0x12, 334 => 0x1e },
	'aeminexposuretime' => { 332 => 0x5, 333 => 0x13, 334 => 0x1f },
	'aeprogrammode' => { 332 => 0x6 },
	'aeprojectlink' => { 483 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 483 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 483 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 483 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 483 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 483 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 332 => 0xd },
	'aexv' => { 332 => 0x3, 333 => 0x5 },
	'af-assistilluminator' => { 299 => 0x19 },
	'af-cfocusdisplay' => { 299 => 0x234 },
	'af-cpriority' => { 128 => '0.2' },
	'af-cpriorityselection' => { 283 => '1.1', 284 => '1.1', 286 => '1.1', 287 => '1.1', 289 => '0.1', 290 => '0.1', 291 => '0.1', 292 => '1.1', 293 => '0.1', 296 => '1.1', 297 => '1.1', 299 => 0x3 },
	'af-csetting' => { 124 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 124 => '0.2' },
	'af-ctrackingsensitivity' => { 124 => '0.1' },
	'af-czoneareaswitching' => { 124 => '0.3' },
	'af-onbutton' => { 286 => '70.1', 287 => '70.1', 297 => '70.1' },
	'af-onformb-d10' => { 283 => '3.3', 292 => '3.2' },
	'af-onformb-d11' => { 293 => '2.2' },
	'af-onformb-d12' => { 296 => '50.1' },
	'af-onoutoffocusrelease' => { 299 => 0x10 },
	'af-spriority' => { 128 => '0.1' },
	'af-spriorityselection' => { 283 => '1.2', 284 => '1.2', 286 => '1.2', 287 => '1.2', 291 => '0.2', 292 => '1.2', 293 => '0.2', 296 => '1.2', 297 => '1.2', 299 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 283 => '2.1', 284 => '2.1', 286 => '78.3', 287 => '78.3', 292 => '2.1', 296 => '2.1', 297 => '78.3', 299 => 0xf },
	'afadjustment' => { 359 => 0x72, 368 => 0x267 },
	'afandmeteringbuttons' => { 84 => 0x701 },
	'afaperture' => { 220 => 0x5, 221 => 0x5, 225 => 0x5 },
	'afareaheight' => { 193 => [0x1a,0x34,0x50], 194 => 0x48 },
	'afareaillumination' => { 184 => 0x4b, 294 => '15.3' },
	'afareamode' => { 126 => '0.3', 180 => 0x33, 184 => 0xe, 192 => 0x0, 193 => 0x5, 194 => 0x5, 231 => 0x210, 232 => 0x224, 324 => 0xf, 391 => 0x1205, 404 => [0xa,0x3a], 411 => 0x11, 412 => 0x10, 413 => 0x24, 424 => 0xb043, 449 => 0x17 },
	'afareamodesetting' => { 285 => '11.1', 288 => '0.1', 294 => '16.1', 298 => '2.1', 424 => 0x201c },
	'afareapointsize' => { 126 => '0.4' },
	'afareas' => { 301 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 84 => 0x51b },
	'afareawidth' => { 193 => [0x18,0x32,0x4e], 194 => 0x46 },
	'afareaxposition' => { 193 => [0x14,0x2e,0x4a], 194 => 0x42, 391 => 0x1203 },
	'afareaxposition1' => { 391 => 0x1201 },
	'afareayposition' => { 193 => [0x16,0x30,0x4c], 194 => 0x44, 391 => 0x1204 },
	'afareayposition1' => { 391 => 0x1202 },
	'afareazonesize' => { 126 => '0.5' },
	'afassist' => { 82 => 0x5, 90 => 0x5, 184 => 0x48, 283 => '2.5', 285 => '0.2', 288 => '0.2', 289 => '1.1', 290 => '1.1', 291 => '1.3', 292 => '2.4', 293 => '1.3', 294 => '0.2', 296 => '2.4', 298 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 84 => 0x50e, 85 => 0x4, 86 => 0x5, 87 => 0x4, 88 => 0x4, 89 => 0x5 },
	'afassistlamp' => { 324 => 0x31 },
	'afbuttonpressed' => { 413 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 335 => 0x6 },
	'afduringliveview' => { 84 => 0x511 },
	'affinea' => { 476 => 'AffineA' },
	'affineb' => { 476 => 'AffineB' },
	'affinec' => { 476 => 'AffineC' },
	'affined' => { 476 => 'AffineD' },
	'affinetune' => { 195 => 0x0, 231 => 0x5b0, 232 => 0x5e0, 301 => 0x306 },
	'affinetuneadj' => { 195 => 0x2, 244 => 0x2d1, 245 => 0x2dc, 301 => 0x307 },
	'affinetuneadjtele' => { 195 => 0x3 },
	'affinetuneindex' => { 195 => 0x1 },
	'affinex' => { 476 => 'AffineX' },
	'affiney' => { 476 => 'AffineY' },
	'afhold' => { 335 => 0x1fd },
	'afilluminator' => { 411 => 0x29, 424 => 0xb044 },
	'afimageheight' => { 193 => [0x12,0x2c,0x48], 194 => 0x40 },
	'afimagewidth' => { 193 => [0x10,0x2a,0x46], 194 => 0x3e },
	'afintegrationtime' => { 335 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 404 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 408 => 0x131 },
	'afmicroadjregisteredlenses' => { 408 => '305.1' },
	'afmicroadjustment' => { 84 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 408 => 0x130 },
	'afmode' => { 113 => 0x3009, 127 => 0x1022, 180 => 0x16, 401 => 0x5 },
	'afmoderestrictions' => { 284 => '50.3', 286 => '48.3', 287 => '48.3', 296 => '48.3', 297 => '48.3' },
	'afonaelockbuttonswitch' => { 84 => 0x702 },
	'afonbutton' => { 283 => '3.1', 284 => '47.1', 299 => 0x83 },
	'afpoint' => { 34 => 0x13, 112 => 0x18, 180 => 0x15, 192 => 0x1, 304 => 0x308, 401 => 0x1f, 404 => [0x37,0x7], 408 => 0x19, 409 => 0x18, 410 => [0x18,0x20] },
	'afpointactivationarea' => { 83 => 0x11, 89 => 0x11 },
	'afpointareaexpansion' => { 84 => 0x508 },
	'afpointatshutterrelease' => { 404 => [0x39,0x9] },
	'afpointautoselection' => { 84 => 0x50b },
	'afpointbrightness' => { 84 => 0x50d, 283 => '2.4', 284 => '46.5', 286 => '2.2', 287 => '2.2', 296 => '2.3', 297 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 84 => 0x50c },
	'afpointillumination' => { 83 => 0xa, 283 => '2.3', 284 => '46.2', 286 => '47.2', 287 => '47.2', 291 => '1.2', 292 => '2.3', 293 => '1.2', 296 => '47.2', 297 => '47.2', 298 => '2.4' },
	'afpointinfocus' => { 404 => [0x38,0x8] },
	'afpointmode' => { 340 => 0x3 },
	'afpointposition' => { 113 => 0x2021, 324 => 0x4d },
	'afpointregistration' => { 82 => 0x7 },
	'afpoints' => { 183 => 0x10 },
	'afpointsel' => { 299 => 0xb },
	'afpointselected' => { 184 => 0xd, 301 => 0x305, 359 => 0xe, 408 => 0x15, 409 => 0x14, 410 => [0x14,0x1c], 424 => 0x201e },
	'afpointselected2' => { 340 => 0x4 },
	'afpointselection' => { 83 => 0xb, 283 => '1.3', 284 => '1.3', 292 => '1.3', 296 => '1.3', 297 => '1.3' },
	'afpointselectionmethod' => { 84 => 0x50f, 85 => 0xc, 86 => 0xd, 89 => 0xd },
	'afpointsetting' => { 411 => 0x12, 412 => 0x11 },
	'afpointsinfocus' => { 77 => 0xe, 192 => 0x2, 193 => 0x30, 335 => 0xb, 336 => 0x4, 359 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 83 => 0xd },
	'afpointsselected' => { 193 => 0x1c, 336 => '4.1', 457 => 0x4 },
	'afpointsspecial' => { 336 => '4.2' },
	'afpointsunknown1' => { 335 => 0x0 },
	'afpointsunknown2' => { 335 => 0x2 },
	'afpointsused' => { 193 => [0xa,0x8], 404 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 335 => 0x4 },
	'afresponse' => { 227 => 0xad },
	'afresult' => { 306 => 0x1038 },
	'afsearch' => { 301 => 0x303 },
	'afsensoractive' => { 180 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 391 => 0x1200 },
	'afstatus_00_b4' => { 407 => 0x0 },
	'afstatus_01_c4' => { 407 => 0x2 },
	'afstatus_02_d4' => { 407 => 0x4 },
	'afstatus_03_e4' => { 407 => 0x6 },
	'afstatus_04_f4' => { 407 => 0x8 },
	'afstatus_05_g4' => { 407 => 0xa },
	'afstatus_06_h4' => { 407 => 0xc },
	'afstatus_07_b3' => { 407 => 0xe },
	'afstatus_08_c3' => { 407 => 0x10 },
	'afstatus_09_d3' => { 407 => 0x12 },
	'afstatus_10_e3' => { 407 => 0x14 },
	'afstatus_11_f3' => { 407 => 0x16 },
	'afstatus_12_g3' => { 407 => 0x18 },
	'afstatus_13_h3' => { 407 => 0x1a },
	'afstatus_14_b2' => { 407 => 0x1c },
	'afstatus_15_c2' => { 407 => 0x1e },
	'afstatus_16_d2' => { 407 => 0x20 },
	'afstatus_17_e2' => { 407 => 0x22 },
	'afstatus_18_f2' => { 407 => 0x24 },
	'afstatus_19_g2' => { 407 => 0x26 },
	'afstatus_20_h2' => { 407 => 0x28 },
	'afstatus_21_c1' => { 407 => 0x2a },
	'afstatus_22_d1' => { 407 => 0x2c },
	'afstatus_23_e1' => { 407 => 0x2e },
	'afstatus_24_f1' => { 407 => 0x30 },
	'afstatus_25_g1' => { 407 => 0x32 },
	'afstatus_26_a7_vertical' => { 407 => 0x34 },
	'afstatus_27_a6_vertical' => { 407 => 0x36 },
	'afstatus_28_a5_vertical' => { 407 => 0x38 },
	'afstatus_29_c7_vertical' => { 407 => 0x3a },
	'afstatus_30_c6_vertical' => { 407 => 0x3c },
	'afstatus_31_c5_vertical' => { 407 => 0x3e },
	'afstatus_32_e7_vertical' => { 407 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 407 => 0x42 },
	'afstatus_34_e5_vertical' => { 407 => 0x44 },
	'afstatus_35_g7_vertical' => { 407 => 0x46 },
	'afstatus_36_g6_vertical' => { 407 => 0x48 },
	'afstatus_37_g5_vertical' => { 407 => 0x4a },
	'afstatus_38_i7_vertical' => { 407 => 0x4c },
	'afstatus_39_i6_vertical' => { 407 => 0x4e },
	'afstatus_40_i5_vertical' => { 407 => 0x50 },
	'afstatus_41_a7' => { 407 => 0x52 },
	'afstatus_42_b7' => { 407 => 0x54 },
	'afstatus_43_c7' => { 407 => 0x56 },
	'afstatus_44_d7' => { 407 => 0x58 },
	'afstatus_45_e7' => { 407 => 0x5a },
	'afstatus_46_f7' => { 407 => 0x5c },
	'afstatus_47_g7' => { 407 => 0x5e },
	'afstatus_48_h7' => { 407 => 0x60 },
	'afstatus_49_i7' => { 407 => 0x62 },
	'afstatus_50_a6' => { 407 => 0x64 },
	'afstatus_51_b6' => { 407 => 0x66 },
	'afstatus_52_c6' => { 407 => 0x68 },
	'afstatus_53_d6' => { 407 => 0x6a },
	'afstatus_54_e6_center' => { 407 => 0x6c },
	'afstatus_55_f6' => { 407 => 0x6e },
	'afstatus_56_g6' => { 407 => 0x70 },
	'afstatus_57_h6' => { 407 => 0x72 },
	'afstatus_58_i6' => { 407 => 0x74 },
	'afstatus_59_a5' => { 407 => 0x76 },
	'afstatus_60_b5' => { 407 => 0x78 },
	'afstatus_61_c5' => { 407 => 0x7a },
	'afstatus_62_d5' => { 407 => 0x7c },
	'afstatus_63_e5' => { 407 => 0x7e },
	'afstatus_64_f5' => { 407 => 0x80 },
	'afstatus_65_g5' => { 407 => 0x82 },
	'afstatus_66_h5' => { 407 => 0x84 },
	'afstatus_67_i5' => { 407 => 0x86 },
	'afstatus_68_c11' => { 407 => 0x88 },
	'afstatus_69_d11' => { 407 => 0x8a },
	'afstatus_70_e11' => { 407 => 0x8c },
	'afstatus_71_f11' => { 407 => 0x8e },
	'afstatus_72_g11' => { 407 => 0x90 },
	'afstatus_73_b10' => { 407 => 0x92 },
	'afstatus_74_c10' => { 407 => 0x94 },
	'afstatus_75_d10' => { 407 => 0x96 },
	'afstatus_76_e10' => { 407 => 0x98 },
	'afstatus_77_f10' => { 407 => 0x9a },
	'afstatus_78_g10' => { 407 => 0x9c },
	'afstatus_79_h10' => { 407 => 0x9e },
	'afstatus_80_b9' => { 407 => 0xa0 },
	'afstatus_81_c9' => { 407 => 0xa2 },
	'afstatus_82_d9' => { 407 => 0xa4 },
	'afstatus_83_e9' => { 407 => 0xa6 },
	'afstatus_84_f9' => { 407 => 0xa8 },
	'afstatus_85_g9' => { 407 => 0xaa },
	'afstatus_86_h9' => { 407 => 0xac },
	'afstatus_87_b8' => { 407 => 0xae },
	'afstatus_88_c8' => { 407 => 0xb0 },
	'afstatus_89_d8' => { 407 => 0xb2 },
	'afstatus_90_e8' => { 407 => 0xb4 },
	'afstatus_91_f8' => { 407 => 0xb6 },
	'afstatus_92_g8' => { 407 => 0xb8 },
	'afstatus_93_h8' => { 407 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 407 => 0xbc },
	'afstatusactivesensor' => { 180 => 0x2, 404 => [0x4,0x3b], 408 => 0x1e, 409 => 0x1b, 410 => [0x1b,0x21] },
	'afstatusbottom' => { 180 => 0x8, 408 => 0x2a, 409 => 0x21, 410 => 0x21 },
	'afstatusbottom-left' => { 180 => 0x12, 409 => 0x2b, 410 => 0x2b },
	'afstatusbottom-right' => { 180 => 0x6, 409 => 0x1f, 410 => 0x1f },
	'afstatusbottomassist-left' => { 408 => 0x28 },
	'afstatusbottomassist-right' => { 408 => 0x2c },
	'afstatusbottomhorizontal' => { 405 => 0x10, 406 => 0x1c },
	'afstatusbottomvertical' => { 405 => 0x16, 406 => 0x26 },
	'afstatuscenter-10' => { 408 => 0x34 },
	'afstatuscenter-11' => { 408 => 0x36 },
	'afstatuscenter-12' => { 408 => 0x38 },
	'afstatuscenter-14' => { 408 => 0x3c },
	'afstatuscenter-7' => { 408 => 0x2e },
	'afstatuscenter-9' => { 408 => 0x32 },
	'afstatuscenter-horizontal' => { 408 => 0x30 },
	'afstatuscenter-vertical' => { 408 => 0x3a },
	'afstatuscenterf2-8' => { 408 => 0x4c },
	'afstatuscenterhorizontal' => { 180 => 0x2f, 405 => 0xc, 406 => 0x18, 409 => 0x2f, 410 => 0x2f },
	'afstatuscentervertical' => { 180 => 0xc, 405 => 0x14, 406 => 0x22, 409 => 0x25, 410 => 0x25 },
	'afstatusfarleft' => { 405 => 0x6, 408 => 0x26 },
	'afstatusfarlefthorizontal' => { 406 => 0x4 },
	'afstatusfarleftvertical' => { 406 => 0x12 },
	'afstatusfarright' => { 405 => 0x18, 408 => 0x44 },
	'afstatusfarrighthorizontal' => { 406 => 0x2c },
	'afstatusfarrightvertical' => { 406 => 0x34 },
	'afstatusleft' => { 180 => 0x2d, 405 => 0x2, 408 => 0x22, 409 => 0x2d, 410 => 0x2d },
	'afstatuslefthorizontal' => { 406 => 0x6 },
	'afstatusleftvertical' => { 406 => 0xe },
	'afstatuslower-left' => { 405 => 0x4, 408 => 0x24 },
	'afstatuslower-lefthorizontal' => { 406 => 0xa },
	'afstatuslower-leftvertical' => { 406 => 0x10 },
	'afstatuslower-middle' => { 405 => 0x22, 406 => 0x24 },
	'afstatuslower-right' => { 405 => 0x1e, 408 => 0x4a },
	'afstatuslower-righthorizontal' => { 406 => 0x32 },
	'afstatuslower-rightvertical' => { 406 => 0x3a },
	'afstatuslowerfarleft' => { 406 => 0x8 },
	'afstatuslowerfarright' => { 406 => 0x30 },
	'afstatusmiddlehorizontal' => { 180 => 0xa, 409 => 0x23, 410 => 0x23 },
	'afstatusnearleft' => { 405 => 0xe, 406 => 0x1a },
	'afstatusnearright' => { 405 => 0xa, 406 => 0x16 },
	'afstatusright' => { 180 => 0x31, 405 => 0x1c, 408 => 0x48, 409 => 0x31, 410 => 0x31 },
	'afstatusrighthorizontal' => { 406 => 0x2e },
	'afstatusrightvertical' => { 406 => 0x38 },
	'afstatustop' => { 180 => 0xe, 408 => 0x40, 409 => 0x27, 410 => 0x27 },
	'afstatustop-left' => { 180 => 0x10, 409 => 0x29, 410 => 0x29 },
	'afstatustop-right' => { 180 => 0x4, 409 => 0x1d, 410 => 0x1d },
	'afstatustopassist-left' => { 408 => 0x3e },
	'afstatustopassist-right' => { 408 => 0x42 },
	'afstatustophorizontal' => { 405 => 0x8, 406 => 0x14 },
	'afstatustopvertical' => { 405 => 0x12, 406 => 0x1e },
	'afstatusupper-left' => { 405 => 0x0, 408 => 0x20 },
	'afstatusupper-lefthorizontal' => { 406 => 0x2 },
	'afstatusupper-leftvertical' => { 406 => 0xc },
	'afstatusupper-middle' => { 405 => 0x20, 406 => 0x20 },
	'afstatusupper-right' => { 405 => 0x1a, 408 => 0x46 },
	'afstatusupper-righthorizontal' => { 406 => 0x2a },
	'afstatusupper-rightvertical' => { 406 => 0x36 },
	'afstatusupperfarleft' => { 406 => 0x0 },
	'afstatusupperfarright' => { 406 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 424 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 404 => 0x2 },
	'afwithshutter' => { 411 => 0x2a },
	'aggregateissuenumber' => { 499 => 'aggregateIssueNumber' },
	'aggregationtype' => { 499 => 'aggregationType' },
	'agreement' => { 502 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 138 => 0xe4e },
	'airplanemode' => { 231 => 0x624, 232 => 0x654 },
	'aiservocontinuousshooting' => { 83 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 84 => 0x519 },
	'aiservoimagepriority' => { 84 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 84 => 0x51a },
	'aiservotrackingmethod' => { 84 => 0x504 },
	'aiservotrackingsensitivity' => { 83 => 0x14, 84 => 0x502 },
	'aisubjecttrackingmode' => { 301 => 0x309 },
	'album' => { 376 => ['albm',"\xa9alb"], 378 => 'album', 384 => ['albm',"\xa9alb"], 509 => 'album' },
	'albumartist' => { 179 => 'WM/AlbumArtist', 376 => 'aART', 384 => 'albr' },
	'albumcoverurl' => { 179 => 'WM/AlbumCoverURL' },
	'albumtitle' => { 179 => 'WM/AlbumTitle' },
	'albumtitleid' => { 376 => 'atID' },
	'alreadyapplied' => { 482 => 'AlreadyApplied', 484 => 'AlreadyApplied' },
	'alternatetitle' => { 499 => 'alternateTitle' },
	'alternatetitlea-lang' => { 499 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 499 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 499 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 196 => 0x6 },
	'alttapename' => { 509 => 'altTapeName' },
	'alttextaccessibility' => { 494 => 'AltTextAccessibility' },
	'alttimecode' => { 509 => 'altTimecode' },
	'alttimecodetimeformat' => { 509 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 509 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 509 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 387 => 0x5c },
	'ambientlight' => { 387 => 0x5e },
	'ambienttemperature' => { 119 => 0x9400, 385 => 0x14, 386 => 0x46, 387 => 0x50, 449 => 0x4, 489 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 385 => 0x13, 386 => 0x44, 387 => 0x4e },
	'analogbalance' => { 119 => 0xc627 },
	'analogcaptureiso' => { 138 => 0x89e },
	'analogisotable' => { 138 => 0x89d },
	'androidversion' => { 378 => 'com.android.version' },
	'angleadj' => { 103 => 0x10003, 109 => 0x8b },
	'angleinforoll' => { 478 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 478 => 'AngleInfoYaw' },
	'anti-blur' => { 424 => 0xb04b },
	'antialiasstrength' => { 119 => 0xc632 },
	'aperturelock' => { 284 => '38.2', 286 => '38.2', 287 => '38.2', 296 => '38.2', 297 => '38.2', 299 => 0xb8 },
	'aperturemode' => { 384 => 'apmd' },
	'aperturerange' => { 84 => 0x10d },
	'apertureringuse' => { 340 => '1.4' },
	'aperturesetting' => { 184 => 0x7, 411 => 0x30, 412 => 0x29, 413 => 0x1 },
	'aperturevalue' => { 93 => 0x2, 119 => 0x9202, 306 => 0x1002, 368 => 0x401, 488 => 'ApertureValue' },
	'appinfo' => { 462 => 'AppInfo' },
	'appinfoapplication' => { 462 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 462 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 462 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 310 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 378 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 376 => 'apID' },
	'applestoreaccounttype' => { 376 => 'akID' },
	'applestorecatalogid' => { 376 => 'cnID' },
	'applestorecountry' => { 376 => 'sfID' },
	'applicationkeystring' => { 138 => 0x400 },
	'applicationnotes' => { 119 => 0x2bc, 329 => 0x2bc },
	'applicationrecordversion' => { 131 => 0x0 },
	'applyshootingmeteringmode' => { 84 => 0x10e },
	'approved' => { 490 => 'Approved' },
	'approvedby' => { 490 => 'ApprovedBy' },
	'approximatefnumber' => { 319 => 0x313, 326 => 0x3406 },
	'approximatefocusdistance' => { 479 => 'ApproximateFocusDistance' },
	'appversion' => { 493 => 'AppVersion' },
	'aps-csizecapture' => { 443 => 0x114, 444 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 103 => 0x20914 },
	'armidentifier' => { 132 => 0x78 },
	'armversion' => { 132 => 0x7a },
	'arranger' => { 376 => "\xa9arg", 384 => "\xa9arg" },
	'arrangerkeywords' => { 384 => "\xa9ark" },
	'artdirector' => { 376 => "\xa9ard" },
	'artfilter' => { 301 => 0x529 },
	'artfiltereffect' => { 301 => 0x52f },
	'artist' => { 119 => 0x13b, 314 => 'Artist', 359 => 0x22e, 376 => "\xa9ART", 378 => 'artist', 384 => "\xa9ART", 505 => 'Artist', 509 => 'artist' },
	'artmode' => { 113 => 0x301b },
	'artmodeparameters' => { 113 => 0x310b },
	'artwork' => { 378 => 'artwork' },
	'artworkcircadatecreated' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 495 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 495 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 305 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 305 => 0x1112, 359 => 0x80, 411 => 0x55, 412 => 0x55, 413 => 0xa },
	'assetid' => { 472 => 'AssetID' },
	'asshoticcprofile' => { 119 => 0xc68f },
	'asshotneutral' => { 119 => 0xc628 },
	'asshotpreprofilematrix' => { 119 => 0xc690 },
	'asshotprofilename' => { 119 => 0xc6f6 },
	'asshotwhitexy' => { 119 => 0xc629 },
	'assignbktbutton' => { 283 => '4.2', 284 => '16.1', 286 => '16.1', 287 => '16.1', 296 => '16.1', 297 => '16.1' },
	'assignfuncbutton' => { 84 => 0x70b },
	'assignmb-d17af-onbutton' => { 287 => '79.1' },
	'assignmb-d17funcbutton' => { 287 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 287 => '68.1' },
	'assignmb-d18af-onbutton' => { 297 => '79.1' },
	'assignmb-d18funcbutton' => { 297 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 297 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 286 => '75.1', 287 => '75.1', 297 => '75.1' },
	'assignmoviefunc2button' => { 286 => '82.1', 287 => '82.1', 297 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 286 => '75.2', 287 => '75.2', 297 => '75.2' },
	'assignmovierecordbutton' => { 284 => '43.2', 296 => '45.1', 299 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 286 => '45.1', 287 => '45.1', 297 => '45.1' },
	'assignmoviesubselector' => { 286 => '74.1', 287 => '74.1', 297 => '74.1' },
	'assignmoviesubselectorplusdials' => { 286 => '76.1', 287 => '76.1', 297 => '76.1' },
	'assignremotefnbutton' => { 284 => '54.1', 296 => '51.1' },
	'assistbuttonfunction' => { 82 => 0xd },
	'atcaptureusercrop' => { 138 => 0x943 },
	'attributionname' => { 480 => 'attributionName' },
	'attributionurl' => { 480 => 'attributionURL' },
	'audio' => { 324 => 0x20 },
	'audiobitrate' => { 67 => 0x6c, 495 => 'audioBitRate' },
	'audiobitratemode' => { 495 => 'audioBitRateMode' },
	'audiobitspersample' => { 495 => 'audioBitsPerSample' },
	'audiobutton' => { 299 => 0x17b },
	'audiobuttonplaybackmode' => { 299 => 0x1b9 },
	'audiochannelcount' => { 495 => 'audioChannelCount' },
	'audiochannels' => { 67 => 0x70 },
	'audiochanneltype' => { 509 => 'audioChannelType' },
	'audiocompression' => { 84 => 0x816, 155 => 'Compression' },
	'audiocompressor' => { 509 => 'audioCompressor' },
	'audiodata' => { 464 => 'Data' },
	'audioduration' => { 131 => 0x99 },
	'audiogain' => { 378 => 'player.movie.audio.gain' },
	'audiomimetype' => { 464 => 'Mime' },
	'audiomoddate' => { 509 => 'audioModDate' },
	'audiooutcue' => { 131 => 0x9a },
	'audiosamplerate' => { 67 => 0x6e, 509 => 'audioSampleRate' },
	'audiosampletype' => { 509 => 'audioSampleType' },
	'audiosamplingrate' => { 131 => 0x97 },
	'audiosamplingresolution' => { 131 => 0x98 },
	'audiotype' => { 131 => 0x96 },
	'author' => { 157 => 'Author', 310 => 'Author', 314 => 'Author', 375 => 'Author', 376 => ['auth',"\xa9aut"], 378 => 'author', 384 => 'auth', 477 => 'author', 496 => 'Author', 507 => 'Author' },
	'authorsposition' => { 497 => 'AuthorsPosition' },
	'authorurl' => { 179 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 84 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 350 => '0.1' },
	'autobracket' => { 401 => 0x19 },
	'autobracketing' => { 127 => 0x1100, 359 => 0x18, 391 => 0x1007 },
	'autobracketingmode' => { 295 => '12.3' },
	'autobracketingset' => { 295 => '12.1' },
	'autobracketmodem' => { 283 => '21.2', 284 => '13.3', 286 => '13.2', 287 => '13.2', 292 => '26.2', 296 => '13.3', 297 => '13.2', 299 => 0x5f },
	'autobracketorder' => { 184 => 0x43, 283 => '21.3', 284 => '13.2', 286 => '13.1', 287 => '13.1', 292 => '26.3', 293 => '12.2', 294 => '2.2', 295 => '12.2', 296 => '13.2', 297 => '13.1', 298 => '13.2', 299 => 0x61 },
	'autobracketset' => { 283 => '21.1', 284 => '13.1', 288 => '11.1', 289 => '12.1', 290 => '12.1', 292 => '26.1', 293 => '12.1', 294 => '2.1', 296 => '13.1', 298 => '13.1' },
	'autobrightness' => { 482 => 'AutoBrightness', 484 => 'AutoBrightness' },
	'autocontrast' => { 482 => 'AutoContrast', 484 => 'AutoContrast' },
	'autodistortioncontrol' => { 206 => 0x4, 230 => 0x143 },
	'autodynamicrange' => { 127 => 0x140b },
	'autoexposure' => { 482 => 'AutoExposure', 484 => 'AutoExposure' },
	'autoexposurebracketing' => { 77 => 0x10 },
	'autoflashisosensitivity' => { 286 => '38.5', 287 => '38.5', 297 => '38.5', 299 => 0x5b },
	'autofocus' => { 304 => 0x209 },
	'autofocusmoderestrictions' => { 299 => 0x107 },
	'autofp' => { 294 => '7.3', 298 => '31.4' },
	'autoiso' => { 77 => 0x1, 113 => 0x3008, 231 => 0x142, 232 => 0x156, 285 => '1.1', 294 => '1.1' },
	'autoisomax' => { 285 => '1.2', 294 => '1.2' },
	'autoisominshutterspeed' => { 285 => '1.3', 294 => '1.3' },
	'autolateralca' => { 482 => 'AutoLateralCA', 484 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 62 => 0x2, 84 => 0x204, 103 => 0x20500, 109 => 0x6f },
	'autolightingoptimizeron' => { 103 => '0x20500.0', 109 => 0x6e },
	'autoportraitframed' => { 424 => 0x2016 },
	'autoredeye' => { 276 => 0xfe28a44f },
	'autorotate' => { 77 => 0x1b },
	'autoshadows' => { 482 => 'AutoShadows', 484 => 'AutoShadows' },
	'autotone' => { 482 => 'AutoTone', 484 => 'AutoTone' },
	'autotonedigest' => { 482 => 'AutoToneDigest', 484 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 482 => 'AutoToneDigestNoSat', 484 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 482 => 'AutoWhiteVersion', 484 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 227 => 0x82 },
	'avaperturesetting' => { 340 => 0x13 },
	'averageblacklevel' => { 45 => 0xe7, 47 => 0xfb, 48 => 0x114, 49 => 0x146 },
	'averagelv' => { 187 => 0x38 },
	'avsettingwithoutlens' => { 84 => 0x707 },
	'azimuth' => { 165 => 'Azimuth' },
	'babyage' => { 324 => [0x8010,0x33] },
	'babyname' => { 324 => 0x66 },
	'backgroundalpha' => { 504 => 'bgalpha' },
	'balance' => { 378 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 340 => 0x15 },
	'baseiso' => { 77 => 0x2, 97 => 0x101c, 138 => 0x903, 326 => 0x312a, 455 => 0x6 },
	'baseisodaylight' => { 138 => 0x910 },
	'baseisoflash' => { 138 => 0x913 },
	'baseisofluorescent' => { 138 => 0x912 },
	'baseisotungsten' => { 138 => 0x911 },
	'baselineexposure' => { 119 => 0xc62a },
	'baselineexposureoffset' => { 119 => 0xc7a5 },
	'baselinenoise' => { 119 => 0xc62b },
	'baselinesharpness' => { 119 => 0xc62c },
	'baseurl' => { 507 => 'BaseURL' },
	'bass' => { 378 => 'player.movie.audio.bass' },
	'batterylevel' => { 324 => 0x38, 411 => 0x51, 415 => 0xc, 416 => 0x4, 417 => 0x4, 456 => 0x7 },
	'batterylevelgrip1' => { 456 => 0x6 },
	'batterylevelgrip2' => { 456 => 0x8 },
	'batteryorder' => { 283 => '12.5', 292 => '13.2', 293 => '2.1', 296 => '3.1' },
	'batterystate' => { 184 => 0x60, 411 => 0x50, 417 => 0x14 },
	'batterytemperature' => { 415 => 0x1, 417 => 0x2, 456 => 0x5 },
	'batterytype' => { 64 => 0x38, 387 => 0x66 },
	'batteryunknown' => { 415 => 0x2, 417 => 0x0 },
	'batteryvoltage' => { 138 => 0x408, 385 => 0x2a, 386 => 0x49, 387 => 0x62, 415 => 0x8 },
	'batteryvoltage1' => { 417 => 0x6 },
	'batteryvoltage2' => { 417 => 0x8 },
	'batteryvoltageavg' => { 387 => 0x64 },
	'bayergreensplit' => { 119 => 0xc62d },
	'bayerpattern' => { 137 => 0xf902, 188 => 0x17 },
	'beatsperminute' => { 376 => 'tmpo' },
	'beatspliceparams' => { 509 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 509 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 509 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 509 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 509 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 509 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 283 => '13.1', 284 => '5.4', 285 => '0.1', 288 => '2.1', 289 => '3.1', 290 => '3.1', 292 => '10.1', 294 => '0.1', 296 => '5.5', 298 => '4.1' },
	'beeppitch' => { 293 => '3.1' },
	'beepvolume' => { 293 => '4.5' },
	'bestqualityscale' => { 119 => 0xc65c },
	'bestshotmode' => { 113 => 0x3007 },
	'bitdepth' => { 162 => 'BitDepth', 188 => 0x11, 241 => 0x41 },
	'bitspercomponent' => { 133 => 0x87 },
	'bitspersample' => { 119 => 0x102, 329 => 0xa, 505 => 'BitsPerSample' },
	'blackacquirerows' => { 138 => 0x18ba },
	'blacklevel' => { 119 => 0xc61a, 204 => 0x20, 227 => 0x3d, 306 => [0x401,0x1012], 368 => 0x21d, 431 => [0x7300,0x7310] },
	'blacklevel2' => { 305 => 0x600, 309 => 0x600 },
	'blacklevelblue' => { 329 => 0x1e },
	'blacklevelbottom' => { 138 => 0x3f0 },
	'blackleveldata' => { 368 => 0x223 },
	'blackleveldeltah' => { 119 => 0xc61b },
	'blackleveldeltav' => { 119 => 0xc61c },
	'blacklevelgreen' => { 329 => 0x1d },
	'blacklevelred' => { 329 => 0x1c },
	'blacklevelrepeatdim' => { 119 => 0xc619 },
	'blacklevelrough' => { 138 => 0x40e },
	'blacklevelroughafter' => { 138 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 138 => 0x3ef },
	'blackpoint' => { 359 => 0x200 },
	'blacks2012' => { 482 => 'Blacks2012', 484 => 'Blacks2012' },
	'blacksadj' => { 459 => 0x9018 },
	'bleachbypasstoning' => { 359 => 0x7f },
	'blockshotafresponse' => { 286 => '1.5', 287 => '1.5', 297 => '1.5', 299 => 0x7 },
	'blogtitle' => { 499 => 'blogTitle' },
	'blogurl' => { 499 => 'blogURL' },
	'bluebalance' => { 306 => 0x1018, 329 => 0x12, 359 => 0x1b },
	'bluecurvelimits' => { 108 => 0x1fe },
	'bluecurvepoints' => { 107 => 0x79, 108 => 0x1d4 },
	'bluehsl' => { 103 => 0x20915 },
	'bluehue' => { 482 => 'BlueHue', 484 => 'BlueHue' },
	'bluesaturation' => { 482 => 'BlueSaturation', 484 => 'BlueSaturation' },
	'bluratinfinity' => { 468 => 'BlurAtInfinity' },
	'blurcontrol' => { 359 => 0x82 },
	'blurwarning' => { 127 => 0x1300 },
	'bodybatteryadload' => { 338 => 0x3 },
	'bodybatteryadnoload' => { 338 => 0x2 },
	'bodybatterystate' => { 338 => '1.1' },
	'bodybatteryvoltage1' => { 338 => 0x2 },
	'bodybatteryvoltage2' => { 338 => 0x4 },
	'bodybatteryvoltage3' => { 338 => 0x6 },
	'bodybatteryvoltage4' => { 338 => 0x8 },
	'bodyfirmware' => { 392 => 0x0 },
	'bodyfirmwareversion' => { 302 => 0x104, 303 => 0x100, 306 => 0x104 },
	'bodyserialnumber' => { 392 => 0x10 },
	'bookedition' => { 499 => 'bookEdition' },
	'bootloaderversion' => { 386 => 0x26 },
	'bracketincrement' => { 231 => 0x21a, 232 => 0x22e },
	'bracketmode' => { 57 => 0x3 },
	'bracketprogram' => { 231 => 0x218, 232 => 0x22c },
	'bracketsequence' => { 113 => 0x301d },
	'bracketset' => { 231 => 0x216, 232 => 0x22a },
	'bracketsettings' => { 324 => 0x45 },
	'bracketshotnumber' => { 57 => 0x5, 340 => 0x9, 422 => 0x2b },
	'bracketshotnumber2' => { 422 => 0x2d },
	'bracketstep' => { 181 => 0xe },
	'bracketvalue' => { 57 => 0x4 },
	'brightness' => { 119 => 0xfe53, 156 => 'Brightness', 176 => 'Brightness', 181 => 0x2c, 235 => 0x34, 236 => 0x39, 237 => 0x41, 378 => 'player.movie.visual.brightness', 385 => 0x25, 387 => 0x54, 411 => 0x22, 424 => 0x2007, 482 => 'Brightness', 484 => 'Brightness' },
	'brightnessadj' => { 108 => 0x114, 269 => 0x0, 279 => 0x2d, 459 => 0x8018 },
	'brightnessvalue' => { 119 => 0x9203, 187 => [0x691,0x49c3], 306 => 0x1003, 429 => 0x1e, 433 => 0x1140, 434 => 0x1140, 435 => 0x111c, 436 => 0x1198, 437 => 0x1174, 438 => 0x102c, 439 => 0x224, 440 => 0x224, 441 => 0x219, 488 => 'BrightnessValue' },
	'buildnumber' => { 191 => 0x5500 },
	'bulbduration' => { 77 => 0x18 },
	'burstcount' => { 138 => 0x40d },
	'burstgroupid' => { 229 => 0x4 },
	'burstid' => { 465 => 'BurstID' },
	'burstmode' => { 140 => 0xa, 324 => 0x2a },
	'burstmode2' => { 140 => 0x18 },
	'burstprimary' => { 465 => 'BurstPrimary' },
	'burstshot' => { 401 => 0x34 },
	'burstspeed' => { 324 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 84 => 0x70a },
	'bwadjustment' => { 127 => 0x1049 },
	'bwfilter' => { 181 => 0x2a, 189 => 0x39 },
	'bwmagentagreen' => { 127 => 0x104b },
	'bwmode' => { 306 => 0x203 },
	'by-line' => { 131 => 0x50 },
	'by-linetitle' => { 131 => 0x55 },
	'bytecount' => { 499 => 'byteCount' },
	'c14configuration' => { 138 => 0x1964 },
	'cacheversion' => { 119 => 0xc7aa },
	'calibratedfocallength' => { 116 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 116 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 116 => 'CalibratedOpticalCenterY' },
	'calibration' => { 401 => [0x24,0x30] },
	'calibrationhistory' => { 138 => 0x9c9 },
	'calibrationilluminant1' => { 119 => 0xc65a },
	'calibrationilluminant2' => { 119 => 0xc65b },
	'calibrationilluminant3' => { 119 => 0xcd31 },
	'calibrationversion' => { 138 => 0x9c6 },
	'callforimage' => { 472 => 'CallForImage' },
	'camera' => { 462 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 384 => 'angl', 509 => 'cameraAngle' },
	'cameraappinfo' => { 462 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 462 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 462 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 462 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 466 => 'CameraBurstID' },
	'cameracalibration' => { 401 => 0x11f },
	'cameracalibration1' => { 119 => 0xc623 },
	'cameracalibration2' => { 119 => 0xc624 },
	'cameracalibration3' => { 119 => 0xcd32 },
	'cameracalibrationsig' => { 119 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 462 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 462 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 462 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 462 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 462 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 462 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 462 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 462 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 462 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 462 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 462 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 462 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 378 => 'direction.facing' },
	'camerae-mountversion' => { 458 => 0xb },
	'cameraelevationangle' => { 119 => 0x9405, 489 => 'CameraElevationAngle' },
	'camerafilename' => { 472 => 'CameraFilename' },
	'cameraid' => { 306 => 0x209, 384 => 'cmid', 400 => 0x209 },
	'cameraidentifier' => { 378 => 'camera.identifier' },
	'cameraimage' => { 462 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 462 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 462 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 462 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 462 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 462 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 462 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 462 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 462 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 462 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 462 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 462 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 462 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 462 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 119 => 0xc7a1, 509 => 'cameraLabel' },
	'cameralightestimate' => { 462 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 462 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 462 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 462 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 462 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 472 => 'CameraMakeModel' },
	'cameramodel' => { 368 => 0x410, 509 => 'cameraModel' },
	'cameramodelid' => { 176 => 'CameraModelID' },
	'cameramodelrestriction' => { 482 => 'CameraModelRestriction', 484 => 'CameraModelRestriction' },
	'cameramotion' => { 378 => 'direction.motion' },
	'cameramove' => { 509 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 324 => 0x8f, 363 => 0x1, 368 => 0x100, 417 => [0x16,0x18], 446 => 0x28, 447 => 0x24, 448 => 0x29 },
	'cameraowner' => { 141 => 0xc353 },
	'cameraparameters' => { 306 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 115 => 0x9, 384 => "\xa9gpt" },
	'camerapointcloud' => { 462 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 462 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 462 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 462 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 462 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 462 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 462 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 462 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 462 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 462 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 462 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 462 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 462 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 482 => 'CameraProfile', 484 => 'CameraProfile' },
	'cameraprofiledigest' => { 482 => 'CameraProfileDigest', 484 => 'CameraProfileDigest' },
	'cameraprofiles' => { 497 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 497 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 497 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 497 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 497 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 497 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 497 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 497 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 497 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 497 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 497 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 497 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 497 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 497 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 497 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 497 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 109 => 0xe1 },
	'camerarawcontrast' => { 109 => 0xe3 },
	'camerarawhighlightpoint' => { 109 => 0xe6 },
	'camerarawlinear' => { 109 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 109 => 0xe8 },
	'camerarawoutputshadowpoint' => { 109 => 0xe9 },
	'camerarawsaturation' => { 109 => 0xe2 },
	'camerarawshadowpoint' => { 109 => 0xe7 },
	'camerarawsharpness' => { 109 => 0xe5 },
	'cameraroll' => { 115 => 0xb, 384 => "\xa9grl" },
	'cameras' => { 462 => 'Cameras' },
	'cameraserialnumber' => { 119 => 0xc62f, 178 => 'CameraSerialNumber', 472 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 301 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 77 => 0xc, 138 => 0x406, 305 => 0x1306, 319 => 0x320, 326 => 0x3402, 359 => 0x47, 398 => 0x43, 450 => 0x5 },
	'cameratemperature4' => { 364 => 0x14 },
	'cameratemperature5' => { 364 => 0x16 },
	'cameratemperaturerangemax' => { 121 => 0x5 },
	'cameratemperaturerangemin' => { 121 => 0x6 },
	'cameratrait' => { 462 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 77 => 0x1a, 306 => 0x207 },
	'cameratype2' => { 302 => 0x100 },
	'cameravendorinfo' => { 462 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 462 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 462 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 462 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 115 => 0xa, 384 => "\xa9gyw" },
	'camreverse' => { 116 => 'CamReverse' },
	'canondr4' => { 120 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 97 => 0x805 },
	'canonfilelength' => { 64 => 0xe },
	'canonfirmwareversion' => { 64 => 0x7, 97 => 0x80b },
	'canonflashinfo' => { 97 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 64 => 0x6, 97 => 0x815 },
	'canonlogversion' => { 63 => 0xb },
	'canonmodelid' => { 64 => 0x10, 97 => 0x1834 },
	'canonvrd' => { 120 => 'CanonVRD' },
	'caption' => { 477 => 'caption' },
	'caption-abstract' => { 131 => 0x78 },
	'captionsauthornames' => { 487 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 487 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 497 => 'CaptionWriter' },
	'captureframerate' => { 113 => 0x4001 },
	'captureheightnormal' => { 138 => 0x1839 },
	'capturelook' => { 138 => 0xc48 },
	'capturemode' => { 378 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 470 => 'CaptureSoftware' },
	'capturewidthnormal' => { 138 => 0x1838 },
	'capturewidthtest' => { 138 => 0x1842 },
	'cardshutterlock' => { 184 => 0x49 },
	'casioimagesize' => { 113 => 0x9 },
	'catalogsets' => { 131 => 0xff, 463 => 'CatalogSets', 475 => 'CatalogSets' },
	'categories' => { 64 => 0x23, 477 => 'categories' },
	'category' => { 131 => 0xf, 179 => 'WM/Category', 300 => 0x30, 376 => 'catg', 497 => 'Category' },
	'cbcrgain' => { 398 => 0xa036 },
	'cbcrgaindefault' => { 398 => 0xa035 },
	'cbcrmatrix' => { 398 => 0xa034 },
	'cbcrmatrixdefault' => { 398 => 0xa033 },
	'ccdboardversion' => { 319 => 0x331 },
	'ccdscanmode' => { 306 => 0x1039 },
	'ccdsensitivity' => { 266 => 0x6 },
	'ccdversion' => { 319 => 0x330 },
	'ccvavgluminancenits' => { 492 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 492 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 492 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 492 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 492 => 'ccv_white_xy' },
	'cellglobalid' => { 481 => 'cgi' },
	'celllength' => { 119 => 0x109 },
	'cellr' => { 481 => 'r' },
	'celltowerid' => { 481 => 'cellid' },
	'cellwidth' => { 119 => 0x108 },
	'centerafarea' => { 294 => '15.1' },
	'centerfocuspoint' => { 298 => '2.2' },
	'centerpixel' => { 138 => 0x40c },
	'centerweightedareasize' => { 283 => '7.1', 284 => '8.1', 286 => '8.1', 287 => '8.1', 291 => '7.1', 292 => '5.1', 293 => '7.1', 294 => '6.3', 296 => '8.1', 297 => '8.1', 298 => '8.1', 299 => 0x1f },
	'certificate' => { 513 => 'Certificate' },
	'cfainterpolationalgorithm' => { 138 => 0xe60 },
	'cfainterpolationmetric' => { 138 => 0xe61 },
	'cfaoffsetcols' => { 138 => 0xc71 },
	'cfaoffsetrows' => { 138 => 0xc6f },
	'cfapattern' => { 119 => 0xa302, 329 => 0x9, 488 => 'CFAPattern' },
	'cfapattern2' => { 119 => 0x828e },
	'cfapatterncolumns' => { 488 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 488 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 488 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 119 => 0x828d },
	'cfazipperfixthreshold' => { 138 => 0xe62 },
	'channel' => { 499 => 'channel' },
	'channela-lang' => { 499 => [\'channel','channelA-lang'] },
	'channelchannel' => { 499 => [\'channel','channelChannel'] },
	'channels' => { 155 => 'Channels' },
	'channelsubchannel1' => { 499 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 499 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 499 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 499 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 384 => 'chpl' },
	'checkmark' => { 103 => 0x10101, 108 => 0x26a },
	'checkmark2' => { 109 => 0x8e },
	'childfontfiles' => { 514 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 283 => '10.3', 284 => '11.2', 299 => 0x10b },
	'chromablurradius' => { 119 => 0xc631 },
	'chromanoisecolorspace' => { 138 => 0xe6d },
	'chromanoiseedgemapthresh' => { 138 => 0xe6c },
	'chromanoisehighfthresh' => { 138 => 0xe6a },
	'chromanoiselowfthresh' => { 138 => 0xe6b },
	'chromaticaberration' => { 103 => 0x20703, 109 => 0x66, 398 => 0xa051 },
	'chromaticaberrationb' => { 482 => 'ChromaticAberrationB', 484 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 103 => 0x20708, 109 => 0x6b },
	'chromaticaberrationcorr' => { 79 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 119 => 0x7034, 349 => 0x1, 459 => 0x900d },
	'chromaticaberrationcorrparams' => { 119 => 0x7035, 454 => 0x66a, 455 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 103 => '0x20703.0', 109 => 0x62 },
	'chromaticaberrationr' => { 482 => 'ChromaticAberrationR', 484 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 103 => 0x20707, 109 => 0x6a },
	'chromaticaberrationsetting' => { 80 => 0x6 },
	'chrominancenoisereduction' => { 103 => 0x20601, 109 => 0x5e, 401 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 109 => 0x60 },
	'circadatecreated' => { 495 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 482 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 484 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 482 => 'CircularGradientBasedCorrections', 484 => 'CircularGradientBasedCorrections' },
	'city' => { 131 => 0x5a, 161 => 'City', 324 => 0x6d, 497 => 'City' },
	'city2' => { 324 => 0x80 },
	'clarity' => { 127 => 0x100f, 236 => 0x35, 237 => 0x3d, 424 => 0x2036, 482 => 'Clarity', 484 => 'Clarity' },
	'clarity2012' => { 482 => 'Clarity2012', 484 => 'Clarity2012' },
	'claritycontrol' => { 359 => 0x96 },
	'classification' => { 384 => 'clsf' },
	'classifystate' => { 131 => 0xe1 },
	'clearretouch' => { 324 => 0x7c },
	'clearretouchvalue' => { 324 => 0xa3 },
	'client' => { 509 => 'client' },
	'clientname' => { 490 => 'ClientName' },
	'clipboardaspectratio' => { 482 => 'ClipboardAspectRatio', 484 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 482 => 'ClipboardOrientation', 484 => 'ClipboardOrientation' },
	'clipfilename' => { 384 => 'clfn' },
	'clipid' => { 384 => 'clid' },
	'clmodeshootingspeed' => { 283 => '10.2', 284 => '11.3', 286 => '11.2', 287 => '11.2', 292 => '11.2', 293 => '10.2', 296 => '11.2', 297 => '11.2', 298 => '11.1', 299 => 0x3b },
	'cluster' => { 482 => 'Cluster', 484 => 'Cluster' },
	'cmcontrast' => { 309 => 0x2022 },
	'cmddialsreverserotation' => { 299 => 0xba },
	'cmexposurecompensation' => { 309 => 0x2000 },
	'cmhue' => { 309 => 0x2021 },
	'cmsaturation' => { 309 => 0x2020 },
	'cmsharpness' => { 309 => 0x2023 },
	'cmwhitebalance' => { 309 => 0x2001 },
	'cmwhitebalancecomp' => { 309 => 0x2002 },
	'cmwhitebalancegraypoint' => { 309 => 0x2010 },
	'codec' => { 169 => 'Codec' },
	'codedcharacterset' => { 132 => 0x5a },
	'codeversion' => { 384 => 'cver' },
	'collection' => { 314 => 'Collection' },
	'collectionname' => { 170 => [\'Collections','CollectionsCollectionName'], 384 => 'coll' },
	'collections' => { 170 => 'Collections', 477 => 'collections' },
	'collectionuri' => { 170 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 378 => 'player.movie.visual.color', 498 => 'color' },
	'coloraberrationcontrol' => { 276 => 0xc89224b },
	'coloradjustment' => { 401 => 0x14 },
	'coloradjustmentmode' => { 400 => 0x210 },
	'coloranta' => { 514 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 514 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 514 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 514 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 514 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 514 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 514 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 514 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 514 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 514 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 514 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 514 => 'Colorants' },
	'colorantswatchname' => { 514 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 514 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 514 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 514 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 156 => 'ColorBalance' },
	'colorbalanceadj' => { 276 => 0x76a43202 },
	'colorbalanceblue' => { 181 => 0x1e },
	'colorbalancegreen' => { 181 => 0x1d },
	'colorbalancered' => { 181 => 0x1c },
	'colorbalanceversion' => { 203 => 0x4, 204 => 0x4, 205 => 0x0 },
	'colorblur' => { 109 => 0x65 },
	'colorbluron' => { 103 => 0x20704 },
	'colorbooster' => { 276 => 0x5f0e7d23 },
	'colorboostlevel' => { 270 => 0x1 },
	'colorboosttype' => { 270 => 0x0 },
	'colorchromeeffect' => { 127 => 0x1048 },
	'colorchromefxblue' => { 127 => 0x104e },
	'colorclass' => { 370 => 0xde, 371 => 'ColorClass' },
	'colorcompensationfilter' => { 184 => [0x3a,0x5f], 186 => 0x111, 424 => 0xb022 },
	'colorcompensationfiltercustom' => { 411 => 0xd, 412 => 0xc },
	'colorcompensationfilterset' => { 411 => 0x8, 412 => 0x7, 413 => 0x18, 429 => 0xf },
	'colorcontrol' => { 306 => 0x102b },
	'colorcorrection' => { 459 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 301 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0 },
	'coloreffect' => { 324 => 0x28 },
	'colorfilter' => { 112 => 0x17, 113 => 0x3017, 181 => 0x29, 189 => [0x38,0x4d,0x4f], 366 => 0x17 },
	'colorgain' => { 241 => 0x51 },
	'colorgradeblending' => { 482 => 'ColorGradeBlending', 484 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 482 => 'ColorGradeGlobalHue', 484 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 482 => 'ColorGradeGlobalLum', 484 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 482 => 'ColorGradeGlobalSat', 484 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 482 => 'ColorGradeHighlightLum', 484 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 482 => 'ColorGradeMidtoneHue', 484 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 482 => 'ColorGradeMidtoneLum', 484 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 482 => 'ColorGradeMidtoneSat', 484 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 482 => 'ColorGradeShadowLum', 484 => 'ColorGradeShadowLum' },
	'colorhue' => { 103 => 0x20900, 227 => 0x8d },
	'colorimetricreference' => { 119 => 0xc6bf },
	'colorlabel' => { 487 => 'ColorLabel' },
	'colormatrix' => { 63 => 0xa, 305 => 0x200, 306 => 0x1011, 398 => 0xa030 },
	'colormatrix1' => { 119 => 0xc621, 368 => 0x106 },
	'colormatrix2' => { 119 => 0xc622, 309 => 0x200, 368 => 0x226 },
	'colormatrix3' => { 119 => 0xcd33 },
	'colormatrixa' => { 359 => 0x203 },
	'colormatrixa2' => { 359 => 0x21c },
	'colormatrixadobergb' => { 398 => 0xa032 },
	'colormatrixb' => { 359 => 0x204 },
	'colormatrixb2' => { 359 => 0x21d },
	'colormatrixnumber' => { 306 => 0x1019 },
	'colormatrixsrgb' => { 398 => 0xa031 },
	'colormode' => { 113 => 0x3015, 127 => 0x1210, 140 => 0x66, 181 => 0x28, 184 => 0x16, 186 => 0x101, 187 => 0x36, 189 => 0x7, 227 => 0x3, 266 => 0x4, 324 => 0x32, 401 => 0x2c, 424 => 0xb029, 497 => 'ColorMode' },
	'colormoirereduction' => { 103 => 0x20670, 277 => 0x15 },
	'colormoirereductionmode' => { 277 => 0x5 },
	'colormoirereductionon' => { 103 => '0x20670.0' },
	'colornoisereduction' => { 459 => 0x8029, 482 => 'ColorNoiseReduction', 484 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 482 => 'ColorNoiseReductionDetail', 484 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 277 => 0x18 },
	'colornoisereductionsharpness' => { 277 => 0x1c },
	'colornoisereductionsmoothness' => { 482 => 'ColorNoiseReductionSmoothness', 484 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 123 => 0x2 },
	'colorprofile' => { 181 => 0x33 },
	'colorprofilesettings' => { 301 => 0x539 },
	'colorrepresentation' => { 133 => 0x3c },
	'colorsaturationadj' => { 103 => 0x20305 },
	'colorsequence' => { 133 => 0x41 },
	'colorspace' => { 51 => 0x3, 64 => 0xb4, 97 => 0x10b4, 119 => 0xa001, 135 => 0x3, 162 => 'ColorSpace', 182 => 0x2f, 183 => 0x25, 184 => 0x17, 227 => 0x1e, 301 => 0x507, 359 => 0x37, 398 => 0xa011, 401 => 0xb, 411 => 0x1b, 412 => 0x83, 413 => 0xe, 429 => 0x6, 488 => 'ColorSpace' },
	'colorspace2' => { 63 => 0x9 },
	'colorspecapproximation' => { 135 => 0x2 },
	'colorspecdata' => { 135 => 0x3 },
	'colorspecmethod' => { 135 => 0x0 },
	'colorspecprecedence' => { 135 => 0x1 },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x6d, 43 => 0x26, 44 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x72, 43 => 0x1c, 44 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0xdb, 43 => 0x35, 44 => 0x5c, 47 => 0x75, 48 => 0x8e, 49 => 0x93, 50 => 0x96, 359 => 0x55 },
	'colortempcustom' => { 44 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0xd1, 43 => 0x2b, 44 => 0x52, 47 => 0x6b, 48 => 0x84, 49 => 0x89, 50 => 0x8c, 359 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 64 => 0xae, 74 => 0x9, 97 => 0x10ae, 127 => 0x1005, 138 => 0x846, 156 => 'ColorTemperature', 182 => [0x6e,0x49], 183 => 0x3f, 184 => [0x39,0x5e], 186 => 0x10b, 189 => [0x3c,0x4c,0x4e], 319 => 0x321, 359 => 0x50, 391 => 0x1308, 424 => 0xb021, 482 => 'Temperature', 484 => 'Temperature' },
	'colortemperatureadj' => { 459 => 0x8013 },
	'colortemperatureauto' => { 227 => 0x4f },
	'colortemperaturebg' => { 306 => 0x1013 },
	'colortemperaturecustom' => { 411 => 0xc, 412 => 0xb },
	'colortemperaturerg' => { 306 => 0x1014 },
	'colortemperatureset' => { 411 => 0x7, 412 => 0x6 },
	'colortemperaturesetting' => { 184 => 0x25, 413 => 0x17, 429 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0xef, 43 => 0x49, 44 => 0x70, 47 => 0x89, 48 => 0xa2, 49 => 0xa7, 50 => 0xaa, 359 => 0x5a },
	'colortempflashdata' => { 44 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0xe5, 43 => 0x3f, 44 => 0x66, 47 => 0x7f, 48 => 0x98, 49 => 0x9d, 50 => 0xa0 },
	'colortempfluorescentd' => { 359 => 0x57 },
	'colortempfluorescentn' => { 359 => 0x58 },
	'colortempfluorescentw' => { 359 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0xea, 43 => 0x44, 44 => 0x6b, 47 => 0x84, 48 => 0x9d, 49 => 0xa2, 50 => 0xa5, 324 => 0x44, 391 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 42 => 0x77, 44 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x55 },
	'colortemppc1' => { 43 => 0x94, 44 => 0x75 },
	'colortemppc2' => { 43 => 0x99, 44 => 0x7a },
	'colortemppc3' => { 43 => 0x9e, 44 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0xd6, 43 => 0x30, 44 => 0x57, 47 => 0x70, 48 => 0x89, 49 => 0x8e, 50 => 0x91, 359 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0xe0, 43 => 0x3a, 44 => 0x61, 47 => 0x7a, 48 => 0x93, 49 => 0x98, 50 => 0x9b, 359 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x7c, 43 => 0x21, 47 => 0x52, 48 => 0x52, 49 => 0x52, 50 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0xa9, 43 => 0x76, 47 => 0xa2, 48 => 0x7f, 49 => 0x7f, 50 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => [0xae,0xb3], 43 => 0x7b, 47 => 0xa7, 48 => 0xa7, 49 => 0x84, 50 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0xb8, 43 => 0x80, 47 => 0xac, 48 => 0xac, 49 => 0xac, 50 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0xbd, 43 => 0x85, 47 => 0xb1, 48 => 0xb1, 49 => 0xb1, 50 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0xc2, 43 => 0x8a, 47 => 0xb6, 48 => 0xb6, 49 => 0xb6, 50 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0xc7, 43 => 0x8f, 47 => 0xbb, 48 => 0xbb, 49 => 0xbb, 50 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xcc, 43 => 0xa3, 48 => 0xc0, 49 => 0xc0, 50 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 42 => 0xf4, 48 => 0xc5, 49 => 0xc5, 50 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 42 => 0xf9, 48 => 0xca, 49 => 0xca, 50 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 42 => 0xfe, 48 => 0xcf, 49 => 0xcf, 50 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x81, 43 => 0x4e, 47 => 0x57, 48 => 0x57, 49 => 0x57, 50 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 42 => 0x103, 48 => 0xd4, 49 => 0xd4, 50 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 42 => 0x108, 49 => 0xd9, 50 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 42 => 0x10d, 49 => 0xde, 50 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 42 => 0x112, 49 => 0xe3, 50 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 42 => 0x117, 49 => 0xe8, 50 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 42 => 0x11c, 49 => 0xed, 50 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 42 => 0x121, 49 => 0xf2, 50 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 42 => 0x126, 49 => 0xf7, 50 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 49 => 0xfc, 50 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 49 => 0x101, 50 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x86, 43 => 0x53, 47 => 0x5c, 48 => 0x5c, 49 => 0x5c, 50 => 0x64 },
	'colortempunknown30' => { 49 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x8b, 43 => 0x58, 47 => 0x61, 48 => 0x61, 49 => 0x61, 50 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x90, 43 => 0x5d, 47 => 0x66, 48 => 0x66, 49 => 0x66, 50 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x95, 43 => 0x62, 47 => 0x8e, 48 => 0x6b, 49 => 0x6b, 50 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x9a, 43 => 0x67, 47 => 0x93, 48 => 0x70, 49 => 0x70, 50 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x9f, 43 => 0x6c, 47 => 0x98, 48 => 0x75, 49 => 0x75, 50 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0xa4, 43 => 0x71, 47 => 0x9d, 48 => 0x7a, 49 => 0x7a, 50 => 0x82 },
	'colortint' => { 323 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 51 => 0x2, 63 => 0x8 },
	'colortoneadj' => { 103 => 0x20304, 108 => 0x11e },
	'colortoneauto' => { 71 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 70 => 0x6c, 71 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 70 => 0x3c, 71 => 0x3c },
	'colortonemonochrome' => { 70 => 0x84, 71 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 70 => 0x54, 71 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 70 => 0x24, 71 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 70 => 0xc, 71 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 70 => 0x9c, 71 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 70 => 0xb4, 71 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 70 => 0xcc, 71 => 0xe4 },
	'comlenblksize' => { 138 => 0xfde8 },
	'commanddialplaybackmode' => { 299 => 0x1cb },
	'commanddials' => { 294 => '5.1' },
	'commanddialsaperturesetting' => { 283 => '17.3', 284 => '18.3', 286 => '18.3', 287 => '18.3', 292 => '33.3', 293 => '17.3', 296 => '18.3', 297 => '18.3' },
	'commanddialschangemainsub' => { 283 => '17.2', 284 => '18.1', 286 => '18.1', 287 => '18.1', 292 => '33.2', 293 => '17.2', 296 => '18.1', 297 => '18.1' },
	'commanddialsmenuandplayback' => { 283 => '17.4', 284 => '18.2', 286 => '18.2', 287 => '18.2', 292 => '33.4', 293 => '17.4', 296 => '18.2', 297 => '18.2' },
	'commanddialsreverserotation' => { 283 => '17.1', 284 => '6.4', 286 => '6.2', 287 => '6.2', 288 => '16.2', 289 => '17.2', 292 => '33.1', 293 => '17.1', 296 => '6.2', 297 => '6.2', 298 => '18.1' },
	'commanderchannel' => { 294 => '10.2', 295 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 294 => '13.1', 295 => '31.1' },
	'commandergroupa_ttlcomp' => { 298 => '32.1' },
	'commandergroupamanualoutput' => { 294 => '13.2', 295 => '28.2' },
	'commandergroupamode' => { 294 => '11.2', 295 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 294 => '14.1', 295 => '32.1' },
	'commandergroupb_ttlcomp' => { 298 => '33.1' },
	'commandergroupbmanualoutput' => { 294 => '14.2', 295 => '29.2' },
	'commandergroupbmode' => { 294 => '11.3', 295 => '29.1' },
	'commanderinternalflash' => { 294 => '11.1', 295 => '27.1' },
	'commanderinternalmanualoutput' => { 294 => '12.2', 295 => '27.2' },
	'commanderinternalttlchannel' => { 292 => '18.2' },
	'commanderinternalttlcomp' => { 294 => '12.1', 295 => '30.2', 298 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 292 => '20.1', 293 => '26.1' },
	'commanderinternalttlcompgroupa' => { 292 => '21.1', 293 => '27.1' },
	'commanderinternalttlcompgroupb' => { 292 => '22.1', 293 => '28.1' },
	'comment' => { 0 => 0x2, 120 => 'Comment', 157 => 'Comment', 314 => 'Comment', 376 => "\xa9cmt", 378 => 'comment', 384 => "\xa9cmt" },
	'compass' => { 394 => 0x4 },
	'compatibleversion' => { 482 => 'CompatibleVersion', 484 => 'CompatibleVersion' },
	'compilation' => { 376 => 'cpil' },
	'compimageimagespersequence' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 489 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 499 => 'complianceProfile' },
	'componentsconfiguration' => { 119 => 0x9101, 162 => 'Components', 488 => 'ComponentsConfiguration' },
	'componentversion' => { 97 => 0x80c },
	'composer' => { 179 => 'WM/Composer', 376 => ["\xa9com","\xa9wrt"], 384 => ["\xa9com","\xa9wrt"], 509 => 'composer' },
	'composerkeywords' => { 384 => "\xa9cok" },
	'compositeimage' => { 119 => 0xa460, 489 => 'CompositeImage' },
	'compositeimagecount' => { 119 => 0xa461, 489 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 119 => 0xa462, 489 => 'CompositeImageExposureTimes' },
	'composition' => { 472 => 'Composition' },
	'compositionadjust' => { 358 => '0.1' },
	'compositionadjustrotation' => { 358 => 0x7 },
	'compositionadjustx' => { 358 => 0x5 },
	'compositionadjusty' => { 358 => 0x6 },
	'compressedbitsperpixel' => { 119 => 0x9102, 488 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 186 => 0x40, 306 => 0x40 },
	'compression' => { 119 => 0x103, 329 => 0xb, 505 => 'Compression' },
	'compressionfactor' => { 301 => 0x50d },
	'compressionformat' => { 63 => 0x4 },
	'compressionratio' => { 162 => 'Compression', 306 => 0x1034 },
	'compressorversion' => { 384 => 'CNCV' },
	'condadobvfactor' => { 138 => 0xf3e },
	'condadodaybvthresh' => { 138 => 0xf3c },
	'condadodayoffsets' => { 138 => 0xf42 },
	'condadofluoffsets' => { 138 => 0xf44 },
	'condadofluthresh' => { 138 => 0xf41 },
	'condadoillfactor' => { 138 => 0xf3f },
	'condadoneurange' => { 138 => 0xf3d },
	'condadotunoffsets' => { 138 => 0xf43 },
	'condadotunthresh' => { 138 => 0xf40 },
	'conductor' => { 179 => 'WM/Conductor', 376 => "\xa9con" },
	'confidence' => { 467 => 'Confidence' },
	'confidencelevel' => { 478 => 'ConfidenceLevel' },
	'confidencemime' => { 467 => 'ConfidenceMime' },
	'constrainedcropheight' => { 108 => 0x266, 370 => 0xd6 },
	'constrainedcropwidth' => { 108 => 0x262, 370 => 0xd5 },
	'contact' => { 131 => 0x76 },
	'contactinfo' => { 482 => 'ContactInfo', 484 => 'ContactInfo', 498 => 'contactInfo' },
	'container' => { 462 => 'Container' },
	'containerdirectory' => { 462 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 462 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 462 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 462 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 462 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 462 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 495 => 'ContainerFormat' },
	'containerformatidentifier' => { 495 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 495 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 376 => "\xa9day", 384 => ['@day',"\xa9day"] },
	'contentdistributor' => { 179 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 384 => 'cdis' },
	'contentid' => { 384 => 'ccid' },
	'contentlocationcode' => { 131 => 0x1a },
	'contentlocationname' => { 131 => 0x1b },
	'contenttype' => { 499 => 'contentType' },
	'continuousbracketing' => { 184 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodedisplay' => { 299 => 0x51 },
	'continuousmodeliveview' => { 297 => '77.2' },
	'continuousshootingspeed' => { 84 => 0x610 },
	'continuousshotlimit' => { 84 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 112 => 0xc, 113 => [0x3012,0x20], 119 => [0xa408,0xfe54], 127 => [0x1004,0x1006], 156 => 'Contrast', 176 => 'Contrast', 181 => 0x20, 182 => 0x31, 183 => 0x27, 184 => 0x19, 189 => 0x2, 235 => 0x33, 236 => 0x37, 237 => 0x3f, 306 => 0x1029, 324 => 0x39, 326 => 0x300a, 359 => 0x20, 366 => 0xc, 378 => 'player.movie.visual.contrast', 385 => 0x24, 387 => 0x52, 391 => 0x1012, 401 => 0xd, 411 => 0x1d, 412 => 0x1a, 424 => 0x2004, 482 => 'Contrast', 484 => 'Contrast', 488 => 'Contrast' },
	'contrast2012' => { 482 => 'Contrast2012', 484 => 'Contrast2012' },
	'contrastadj' => { 103 => 0x20303, 108 => 0x115, 279 => 0x2c, 459 => 0x8017 },
	'contrastauto' => { 71 => 0x90 },
	'contrastcurve' => { 227 => 0x8c },
	'contrastdetectaf' => { 193 => 0x4 },
	'contrastdetectafarea' => { 359 => 0x231 },
	'contrastdetectafinfocus' => { 193 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 70 => 0x60, 71 => 0x60 },
	'contrasthighlight' => { 359 => 0x6d },
	'contrasthighlightshadowadj' => { 359 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 70 => 0x30, 71 => 0x30 },
	'contrastmode' => { 324 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 70 => 0x78, 71 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 70 => 0x48, 71 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 70 => 0x18, 71 => 0x18 },
	'contrastsetting' => { 301 => 0x505, 309 => 0x1012, 413 => 0x10, 429 => 0x8 },
	'contrastshadow' => { 359 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 70 => 0x0, 71 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 70 => 0x90, 71 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 70 => 0xa8, 71 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 70 => 0xc0, 71 => 0xd8 },
	'contributedmedia' => { 509 => 'contributedMedia' },
	'contributedmediaduration' => { 509 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 509 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 509 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 509 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 509 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 509 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 509 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 509 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 509 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 509 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 485 => 'contributor', 495 => 'Contributor' },
	'contributoridentifier' => { 495 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 495 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 495 => [\'Contributor','ContributorRole'] },
	'contributors' => { 157 => 'Contributors' },
	'controldialset' => { 184 => 0x46 },
	'controlledvocabularyterm' => { 495 => 'CVterm' },
	'controllerboardversion' => { 319 => 0x332 },
	'controlmode' => { 77 => 0x12 },
	'controlringresponse' => { 299 => 0x1d5 },
	'controlringrotation' => { 84 => 0x712 },
	'conversionlens' => { 302 => 0x403, 324 => 0x35 },
	'converter' => { 119 => 0xfe4d, 266 => 0xb, 482 => 'Converter', 484 => 'Converter' },
	'converttograyscale' => { 482 => 'ConvertToGrayscale', 484 => 'ConvertToGrayscale' },
	'cookingequipment' => { 501 => 'cookingEquipment' },
	'cookingmethod' => { 501 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 119 => 0x8298, 157 => 'Copyright', 314 => 'Copyright', 359 => 0x22f, 375 => 'Copyright', 376 => ['cprt',"\xa9cpy"], 378 => 'copyright', 384 => ['cprt',"\xa9cpy"], 482 => 'Copyright', 484 => 'Copyright', 496 => 'Copyright', 502 => 'copyright', 505 => 'Copyright', 509 => 'copyright' },
	'copyrightflag' => { 373 => 0x40a },
	'copyrightnotice' => { 131 => 0x74 },
	'copyrightowner' => { 311 => 'CopyrightOwner' },
	'copyrightownerid' => { 311 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 311 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 311 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 311 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 311 => 'CopyrightStatus' },
	'copyrightyear' => { 495 => 'CopyrightYear', 499 => 'copyrightYear' },
	'coringfilter' => { 305 => 0x310, 306 => 0x102d, 309 => 0x310 },
	'coringvalues' => { 305 => 0x311, 309 => 0x311 },
	'corporateentity' => { 499 => 'corporateEntity' },
	'correlatedcolortemp' => { 323 => 0x35b },
	'country' => { 161 => 'Country', 324 => 0x69, 497 => 'Country' },
	'country-primarylocationcode' => { 131 => 0x64 },
	'country-primarylocationname' => { 131 => 0x65 },
	'countrycode' => { 226 => 0x5, 371 => 'CountryCode', 494 => 'CountryCode' },
	'course' => { 501 => 'course' },
	'coverage' => { 485 => 'coverage' },
	'coverart' => { 376 => 'covr' },
	'coverdate' => { 499 => 'coverDate' },
	'coverdisplaydate' => { 499 => 'coverDisplayDate' },
	'coveruri' => { 384 => 'cvru' },
	'cpufirmwareversion' => { 359 => 0x28 },
	'crc32' => { 486 => 'crc32' },
	'createdate' => { 119 => 0x9004, 157 => 'CreateDate', 310 => 'CreationDate', 314 => 'create-date', 375 => 'CreationDate', 381 => 0x1, 507 => 'CreateDate' },
	'creationdate' => { 378 => 'creationdate', 496 => 'CreationDate', 499 => 'creationDate' },
	'creationtime' => { 314 => 'Creation Time' },
	'creativestyle' => { 411 => 0x1a, 412 => 0x18, 422 => 0x41, 424 => 0xb020, 455 => 0x4a },
	'creativestylesetting' => { 413 => 0xf, 429 => 0x7 },
	'creativestylewaschanged' => { 459 => 0x8001 },
	'creator' => { 310 => 'Creator', 375 => 'Creator', 485 => 'creator', 495 => 'Creator', 496 => 'Creator' },
	'creatoraddress' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 178 => 'CreatorAppId' },
	'creatorcity' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 494 => 'CreatorContactInfo' },
	'creatorcountry' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 495 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 495 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 178 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 495 => [\'Creator','CreatorRole'] },
	'creatortool' => { 507 => 'CreatorTool' },
	'creatorworkemail' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 494 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 131 => 0x6e, 497 => 'Credit' },
	'creditline' => { 502 => 'creditLine' },
	'creditlinereq' => { 512 => 'CreditLineReq' },
	'creditlinerequired' => { 311 => 'CreditLineRequired' },
	'cropactive' => { 101 => 0x0, 108 => 0x244 },
	'cropangle' => { 482 => 'CropAngle', 484 => 'CropAngle' },
	'croparea' => { 227 => 0x45, 459 => 0x9011 },
	'cropaspectratio' => { 103 => 0x30101, 108 => 0x260 },
	'cropaspectratiocustom' => { 103 => 0x30102 },
	'cropbottom' => { 123 => 0x9, 271 => 0x36, 329 => 0x31, 370 => 0xdc, 482 => 'CropBottom', 484 => 'CropBottom' },
	'cropbottommargin' => { 53 => 0x3 },
	'cropcircleactive' => { 109 => 0xd6 },
	'cropcircleradius' => { 109 => 0xd9 },
	'cropcirclex' => { 109 => 0xd7 },
	'cropcircley' => { 109 => 0xd8 },
	'cropconstraintowarp' => { 482 => 'CropConstrainToWarp', 484 => 'CropConstrainToWarp' },
	'croph' => { 476 => 'CropH' },
	'cropheight' => { 101 => 0x6, 108 => 0x24c, 305 => 0x615, 309 => 0x615, 482 => 'CropHeight', 484 => 'CropHeight' },
	'crophispeed' => { 227 => 0x1b },
	'cropleft' => { 108 => 0x246, 123 => 0x6, 271 => 0x1e, 305 => 0x612, 309 => 0x612, 329 => 0x30, 370 => 0xd9, 482 => 'CropLeft', 484 => 'CropLeft' },
	'cropleftmargin' => { 53 => 0x0 },
	'cropmode' => { 127 => 0x104d, 391 => 0x1018 },
	'croporiginalheight' => { 101 => 0xb },
	'croporiginalwidth' => { 101 => 0xa },
	'cropoutputheight' => { 271 => 0xce },
	'cropoutputheightinches' => { 271 => 0x96 },
	'cropoutputpixels' => { 271 => 0xd6 },
	'cropoutputresolution' => { 271 => 0xb6 },
	'cropoutputscale' => { 271 => 0xbe },
	'cropoutputwidth' => { 271 => 0xc6 },
	'cropoutputwidthinches' => { 271 => 0x8e },
	'croppedareaimageheightpixels' => { 470 => 'CroppedAreaImageHeightPixels', 471 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 470 => 'CroppedAreaImageWidthPixels', 471 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 470 => 'CroppedAreaLeftPixels', 471 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 470 => 'CroppedAreaTopPixels', 471 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 391 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 391 => 0x1603 },
	'cropping' => { 459 => 0x9010 },
	'cropright' => { 123 => 0x8, 271 => 0x2e, 329 => 0x32, 370 => 0xdb, 482 => 'CropRight', 484 => 'CropRight' },
	'croprightmargin' => { 53 => 0x1 },
	'croprotatedoriginalheight' => { 101 => 0x2 },
	'croprotatedoriginalwidth' => { 101 => 0x1 },
	'croprotation' => { 101 => 0x8, 123 => 0xb },
	'cropscaledresolution' => { 271 => 0x9e },
	'cropsourceresolution' => { 271 => 0xae },
	'croptop' => { 108 => 0x248, 123 => 0x7, 271 => 0x26, 305 => 0x613, 309 => 0x613, 329 => 0x2f, 370 => 0xda, 482 => 'CropTop', 484 => 'CropTop' },
	'croptopmargin' => { 53 => 0x2 },
	'cropunit' => { 482 => 'CropUnit', 484 => 'CropUnit' },
	'cropunits' => { 482 => 'CropUnits', 484 => 'CropUnits' },
	'cropw' => { 476 => 'CropW' },
	'cropwidth' => { 101 => 0x5, 108 => 0x24a, 305 => 0x614, 309 => 0x614, 482 => 'CropWidth', 484 => 'CropWidth' },
	'cropx' => { 101 => 0x3, 476 => 'CropX' },
	'cropy' => { 101 => 0x4, 476 => 'CropY' },
	'crossprocess' => { 359 => 0x7b },
	'crossprocessparams' => { 359 => 0x235 },
	'cuisine' => { 501 => 'cuisine' },
	'currenticcprofile' => { 119 => 0xc691 },
	'currentpreprofilematrix' => { 119 => 0xc692 },
	'currentversion' => { 459 => 0xd000 },
	'curve0x' => { 476 => 'Curve0x' },
	'curve0y' => { 476 => 'Curve0y' },
	'curve1x' => { 476 => 'Curve1x' },
	'curve1y' => { 476 => 'Curve1y' },
	'curve2x' => { 476 => 'Curve2x' },
	'curve2y' => { 476 => 'Curve2y' },
	'curve3x' => { 476 => 'Curve3x' },
	'curve3y' => { 476 => 'Curve3y' },
	'curve4x' => { 476 => 'Curve4x' },
	'curve4y' => { 476 => 'Curve4y' },
	'curves' => { 276 => 0x76a43201 },
	'custom1' => { 311 => 'Custom1' },
	'custom10' => { 311 => 'Custom10' },
	'custom2' => { 311 => 'Custom2' },
	'custom3' => { 311 => 'Custom3' },
	'custom4' => { 311 => 'Custom4' },
	'custom5' => { 311 => 'Custom5' },
	'custom6' => { 311 => 'Custom6' },
	'custom7' => { 311 => 'Custom7' },
	'custom8' => { 311 => 'Custom8' },
	'custom9' => { 311 => 'Custom9' },
	'customcolortone' => { 109 => 0x4c },
	'customcontrast' => { 109 => 0x4e },
	'customcontrols' => { 84 => 0x70c },
	'customdefaultunsharpfineness' => { 109 => 0xbe },
	'customdefaultunsharpstrength' => { 109 => 0xbc },
	'customdefaultunsharpthreshold' => { 109 => 0xc0 },
	'customilluminant' => { 138 => 0x405 },
	'customizedials' => { 84 => 0x715 },
	'customlinear' => { 109 => 0x4f },
	'customoutputhighlightpoint' => { 109 => 0x53 },
	'customoutputshadowpoint' => { 109 => 0x54 },
	'custompicturestyle' => { 103 => 0x10021 },
	'custompicturestyledata' => { 103 => 0xf0500 },
	'custompicturestylefilename' => { 64 => 0x4010 },
	'customrawhighlight' => { 109 => 0x7c },
	'customrawhighlightpoint' => { 109 => 0x51 },
	'customrawshadow' => { 109 => 0x85 },
	'customrawshadowpoint' => { 109 => 0x52 },
	'customrendered' => { 119 => 0xa401, 191 => 0x6420, 488 => 'CustomRendered' },
	'customsaturation' => { 109 => 0x4d, 301 => 0x503 },
	'customsettingsalldefault' => { 283 => '0.2', 292 => '0.2' },
	'customsettingsbank' => { 283 => '0.1', 284 => '0.1', 286 => '0.1', 287 => '0.1', 292 => '0.1', 296 => '0.2', 297 => '0.2', 299 => 0x1 },
	'customsharpness' => { 109 => 0x50 },
	'customunsharpmaskfineness' => { 109 => 0xb8 },
	'customunsharpmaskstrength' => { 109 => 0xb6 },
	'customunsharpmaskthreshold' => { 109 => 0xba },
	'customwb_rblevels' => { 429 => 0x1a },
	'customwb_rgblevels' => { 412 => 0x8, 413 => 0x19 },
	'customwbbluelevel' => { 184 => 0x36 },
	'customwberror' => { 184 => 0x37 },
	'customwbgreenlevel' => { 184 => 0x35 },
	'customwbredlevel' => { 184 => 0x34 },
	'customwbsetting' => { 184 => 0x26 },
	'cx' => { 384 => '_cx_' },
	'cy' => { 384 => '_cy_' },
	'd-lightinghq' => { 276 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 272 => 0x2 },
	'd-lightinghqhighlight' => { 272 => 0x1 },
	'd-lightinghqselected' => { 276 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 272 => 0x0 },
	'd-lightinghs' => { 276 => 0xce5554aa },
	'd-lightinghsadjustment' => { 273 => 0x0 },
	'd-lightinghscolorboost' => { 273 => 0x1 },
	'd-rangeoptimizerhighlight' => { 459 => 0x8024 },
	'd-rangeoptimizermode' => { 459 => 0x8022 },
	'd-rangeoptimizershadow' => { 459 => 0x802d },
	'd-rangeoptimizervalue' => { 459 => 0x8023 },
	'darkblacksegrows' => { 138 => 0x18d8 },
	'darkfocusenvironment' => { 324 => 0x8003 },
	'darkframecountfactor' => { 138 => 0xc85 },
	'darkframelongexposure' => { 138 => 0xc84 },
	'darkframeshortexposure' => { 138 => 0xc83 },
	'darkpedestal' => { 138 => 0xc7f },
	'datacompressionmethod' => { 133 => 0x6e },
	'dataimprint' => { 181 => 0x34 },
	'dataonscreen' => { 495 => 'DataOnScreen' },
	'dataonscreenregion' => { 495 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 495 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 495 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 495 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 495 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 495 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 495 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 495 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 359 => 0x3d },
	'date' => { 359 => 0x6, 485 => 'date' },
	'dateacquired' => { 178 => 'DateAcquired', 179 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 131 => 0x37, 497 => 'DateCreated' },
	'datedisplayformat' => { 268 => 0x3 },
	'dateidentified' => { 118 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 288 => '4.2' },
	'daterecieved' => { 499 => 'dateRecieved' },
	'datesent' => { 132 => 0x46 },
	'datestampmode' => { 64 => 0x1c, 227 => 0x9d },
	'datetime' => { 477 => 'datetime', 505 => 'DateTime' },
	'datetimedigitized' => { 488 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 100 => 0x0, 119 => 0x9003, 154 => 0x14, 157 => 'OriginalDate', 379 => 'IDIT', 384 => 'date', 385 => 0xb, 386 => 0x3b, 387 => 0x3e, 488 => 'DateTimeOriginal' },
	'datetimestamp' => { 140 => 0x64 },
	'datetimeutc' => { 301 => 0x908 },
	'daylightsavings' => { 78 => 0x3, 268 => 0x2 },
	'dayofweek' => { 386 => 0x42, 387 => 0x4a },
	'dccontinent' => { 118 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 118 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 118 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 118 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 118 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 118 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 118 => 'Event' },
	'dcfootprintspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 118 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 118 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 118 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 118 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 118 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 118 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 118 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 118 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 118 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 118 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 118 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 118 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 118 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 165 => 'Declination' },
	'decposition' => { 181 => 0x32 },
	'defaultautogray' => { 482 => 'DefaultAutoGray', 484 => 'DefaultAutoGray' },
	'defaultautotone' => { 482 => 'DefaultAutoTone', 484 => 'DefaultAutoTone' },
	'defaultblackrender' => { 119 => 0xc7a6 },
	'defaultcroporigin' => { 119 => 0xc61f },
	'defaultcropsize' => { 119 => 0xc620 },
	'defaulteraseoption' => { 84 => 0x813 },
	'defaultscale' => { 119 => 0xc61e },
	'defaultsspecifictoiso' => { 482 => 'DefaultsSpecificToISO', 484 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 482 => 'DefaultsSpecificToSerial', 484 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 119 => 0xc7b5 },
	'defectisocode' => { 138 => 0x90f },
	'defringe' => { 482 => 'Defringe', 484 => 'Defringe' },
	'defringegreenamount' => { 482 => 'DefringeGreenAmount', 484 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 482 => 'DefringeGreenHueHi', 484 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 482 => 'DefringeGreenHueLo', 484 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 482 => 'DefringePurpleAmount', 484 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 482 => 'DefringePurpleHueHi', 484 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 482 => 'DefringePurpleHueLo', 484 => 'DefringePurpleHueLo' },
	'dehaze' => { 482 => 'Dehaze', 484 => 'Dehaze' },
	'deletedimagecount' => { 227 => 0xa6, 242 => 0x6e },
	'deprecatedon' => { 480 => 'deprecatedOn' },
	'depthfar' => { 119 => 0xc7eb },
	'depthformat' => { 119 => 0xc7e9 },
	'depthimage' => { 467 => 'Data' },
	'depthmeasuretype' => { 119 => 0xc7ed },
	'depthnear' => { 119 => 0xc7ea },
	'depthunits' => { 119 => 0xc7ec },
	'derivedfrom' => { 510 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 510 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 510 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 510 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 510 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 510 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 510 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 510 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 510 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 510 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 510 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 510 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 510 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 510 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 510 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 510 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 510 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 510 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 510 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 510 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 510 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 510 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 510 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 510 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 314 => 'Description', 376 => ['desc','dscp',"\xa9des"], 378 => 'description', 384 => 'dscp', 482 => 'Description', 484 => 'Description', 485 => 'description', 507 => 'Description' },
	'destination' => { 132 => 0x5 },
	'destinationcity' => { 359 => 0x24, 365 => 0x3 },
	'destinationcitycode' => { 366 => 0x1001 },
	'destinationdst' => { 359 => 0x26, 365 => '0.3' },
	'developmentdynamicrange' => { 127 => 0x1403 },
	'deviantmatrixcustom' => { 138 => 0x7de },
	'deviantmatrixdaylight' => { 138 => 0x7da },
	'deviantmatrixflash' => { 138 => 0x7dd },
	'deviantmatrixfluorescent' => { 138 => 0x7dc },
	'deviantmatrixtungsten' => { 138 => 0x7db },
	'deviantwhitecustom' => { 138 => 0x842 },
	'deviantwhitedaylight' => { 138 => 0x83e },
	'deviantwhiteflash' => { 138 => 0x841 },
	'deviantwhitefluorescent' => { 138 => 0x840 },
	'deviantwhitetungsten' => { 138 => 0x83f },
	'device' => { 499 => 'device' },
	'devicesettingdescription' => { 488 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 488 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 488 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 488 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 398 => 0x2 },
	'dewarpdata' => { 116 => 'DewarpData' },
	'dewarpflag' => { 116 => 'DewarpFlag' },
	'dialdirectiontvav' => { 84 => 0x706 },
	'dietaryneeds' => { 501 => 'dietaryNeeds' },
	'diffractioncompensation' => { 230 => 0x142, 231 => 0x1a2, 232 => 0x1b6, 256 => 0xc4a0 },
	'diffractioncorrection' => { 324 => 0xbc, 349 => 0x3 },
	'diffractioncorrectionon' => { 103 => 0x2070b },
	'digitalcreationdate' => { 131 => 0x3e },
	'digitalcreationtime' => { 131 => 0x3f },
	'digitaldeehighlightadj' => { 241 => 0x202 },
	'digitaldeeshadowadj' => { 241 => 0x200 },
	'digitaldeethreshold' => { 241 => 0x201 },
	'digitalfilter' => { 401 => 0x59 },
	'digitalfilter01' => { 346 => 0x5 },
	'digitalfilter02' => { 346 => 0x16 },
	'digitalfilter03' => { 346 => 0x27 },
	'digitalfilter04' => { 346 => 0x38 },
	'digitalfilter05' => { 346 => 0x49 },
	'digitalfilter06' => { 346 => 0x5a },
	'digitalfilter07' => { 346 => 0x6b },
	'digitalfilter08' => { 346 => 0x7c },
	'digitalfilter09' => { 346 => 0x8d },
	'digitalfilter10' => { 346 => 0x9e },
	'digitalfilter11' => { 346 => 0xaf },
	'digitalfilter12' => { 346 => 0xc0 },
	'digitalfilter13' => { 346 => 0xd1 },
	'digitalfilter14' => { 346 => 0xe2 },
	'digitalfilter15' => { 346 => 0xf3 },
	'digitalfilter16' => { 346 => 0x104 },
	'digitalfilter17' => { 346 => 0x115 },
	'digitalfilter18' => { 346 => 0x126 },
	'digitalfilter19' => { 346 => 0x137 },
	'digitalfilter20' => { 346 => 0x148 },
	'digitalgain' => { 74 => 0xb },
	'digitalgem' => { 215 => 0x0 },
	'digitalice' => { 241 => 0x100 },
	'digitalimageguid' => { 495 => 'DigImageGUID' },
	'digitallensoptimizer' => { 62 => 0xa },
	'digitallensoptimizersetting' => { 80 => 0x9 },
	'digitalroc' => { 239 => 0x0 },
	'digitalsourcefiletype' => { 495 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 495 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 112 => 0xa, 127 => 0x1044, 140 => 0x68, 151 => 0x22, 152 => 0x1e, 156 => 'DigitalZoom', 181 => 0xc, 227 => 0x86, 266 => 0xa, 306 => 0x204, 359 => 0x1e, 366 => 0xa, 400 => 0x204, 446 => 0x12, 447 => 0x12 },
	'digitalzoomon' => { 400 => 0x21b },
	'digitalzoomratio' => { 119 => 0xa404, 435 => 0x200, 437 => 0x21c, 488 => 'DigitalZoomRatio' },
	'director' => { 179 => 'WM/Director', 376 => "\xa9dir", 378 => 'director', 384 => "\xa9dir", 509 => 'director' },
	'directorphotography' => { 509 => 'directorPhotography' },
	'directory' => { 120 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 208 => 0x3, 387 => 0x12 },
	'disableautocreation' => { 465 => 'DisableAutoCreation' },
	'disclaimer' => { 314 => 'Disclaimer' },
	'discnumber' => { 509 => 'discNumber' },
	'dishtype' => { 501 => 'dishType' },
	'disknumber' => { 376 => 'disk' },
	'displayallafpoints' => { 84 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 374 => 0x2 },
	'displayedunitsy' => { 374 => 0x6 },
	'displayname' => { 378 => 'displayname', 498 => 'displayName' },
	'distance1' => { 140 => 0x28 },
	'distance2' => { 140 => 0x2c },
	'distance3' => { 140 => 0x30 },
	'distance4' => { 140 => 0x34 },
	'distortion' => { 398 => 0xa050 },
	'distortioncompensation' => { 459 => 0x8040 },
	'distortioncontrol' => { 242 => 0x10 },
	'distortioncorrection' => { 79 => 0x3, 103 => 0x20705, 109 => 0x67, 119 => 0x7036, 301 => 0x50b, 328 => '7.1', 349 => 0x0, 454 => 0x601, 455 => 0x5b },
	'distortioncorrection2' => { 305 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 479 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 103 => '0x20705.0', 109 => 0x63 },
	'distortioncorrectionsetting' => { 80 => 0x7, 424 => 0x2013 },
	'distortioncorrectionvalue' => { 79 => 0x9 },
	'distortioncorrparams' => { 119 => 0x7037, 434 => 0x1a23, 437 => 0x1870, 439 => 0x189c, 440 => 0x18cc, 441 => 0x17d0, 454 => 0x6ca, 455 => 0x64 },
	'distortioncorrparamsnumber' => { 437 => 0x1899, 439 => 0x18c5, 440 => 0x18f5, 441 => 0x17f9 },
	'distortioncorrparamspresent' => { 437 => 0x1898, 439 => 0x18c4, 440 => 0x18f4, 441 => 0x17f8, 443 => 0x10b, 444 => 0x10b, 454 => 0x600, 455 => 0x5a },
	'distortioneffect' => { 103 => 0x20709 },
	'distortionn' => { 328 => 0xc },
	'distortionparam02' => { 328 => 0x2 },
	'distortionparam04' => { 328 => 0x4 },
	'distortionparam08' => { 328 => 0x8 },
	'distortionparam09' => { 328 => 0x9 },
	'distortionparam11' => { 328 => 0xb },
	'distortionscale' => { 328 => 0x5 },
	'distributor' => { 499 => 'distributor' },
	'distributorproductid' => { 498 => 'distributorProductID' },
	'dloon' => { 103 => '0x20706.0', 109 => 0xdc },
	'dlosetting' => { 103 => 0x20706, 109 => 0xdd },
	'dlosettingapplied' => { 102 => 0x4 },
	'dloshootingdistance' => { 109 => 0xde },
	'dloversion' => { 102 => 0x5 },
	'dmcomment' => { 509 => 'comment' },
	'dmdithermatrix' => { 138 => 0xc7a },
	'dmdithermatrixheight' => { 138 => 0xc7c },
	'dmdithermatrixwidth' => { 138 => 0xc7b },
	'dngadobedata' => { 119 => 0xc634 },
	'dngbackwardversion' => { 119 => 0xc613 },
	'dngignoresidecars' => { 482 => 'DNGIgnoreSidecars', 484 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 119 => 0xc630 },
	'dngprivatedata' => { 119 => 0xc634 },
	'dngversion' => { 119 => 0xc612 },
	'document' => { 314 => 'Document' },
	'documentancestors' => { 497 => 'DocumentAncestors' },
	'documenthistory' => { 131 => 0xe7 },
	'documentid' => { 510 => 'DocumentID' },
	'documentname' => { 119 => 0x10d },
	'documentnotes' => { 131 => 0xe6 },
	'doi' => { 499 => 'doi' },
	'dopesheet' => { 495 => 'Dopesheet' },
	'dopesheetlink' => { 495 => 'DopesheetLink' },
	'dopesheetlinklink' => { 495 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 495 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 138 => 0xc82 },
	'dpp' => { 477 => 'dpp' },
	'dr4cameramodel' => { 104 => 0x3 },
	'drangepriority' => { 127 => 0x1443 },
	'drangepriorityauto' => { 127 => 0x1444 },
	'drangepriorityfixed' => { 127 => 0x1445 },
	'drivemode' => { 113 => 0x3103, 125 => '0.1', 181 => 0x6, 184 => 0x1e, 187 => 0xe, 191 => 0x64d0, 301 => 0x600, 359 => 0x34, 391 => 0x1002, 401 => 0x3, 411 => 0x4, 412 => 0x7e, 413 => 0x34 },
	'drivemode2' => { 184 => 0xa, 340 => 0x7, 422 => 0xe, 429 => 0x1 },
	'drivemodesetting' => { 413 => 0x4 },
	'drivespeed' => { 125 => '0.2' },
	'dspfirmwareversion' => { 359 => 0x27 },
	'duration' => { 67 => 0x6a, 155 => 'Duration', 169 => 'Duration', 501 => 'duration', 509 => 'duration' },
	'durationscale' => { 509 => [\'duration','durationScale'] },
	'durationvalue' => { 509 => [\'duration','durationValue'] },
	'dustremovaldata' => { 64 => 0x97 },
	'dxcropalert' => { 231 => 0x23c, 232 => 0x250 },
	'dynamicafarea' => { 283 => '1.4', 292 => '1.4' },
	'dynamicareaafassist' => { 299 => 0x18 },
	'dynamicareaafdisplay' => { 284 => '46.1', 286 => '47.1', 287 => '47.1', 296 => '47.1', 297 => '47.1' },
	'dynamicrange' => { 127 => 0x1400 },
	'dynamicrangeboost' => { 324 => 0xee },
	'dynamicrangeexpansion' => { 359 => 0x69, 391 => 0x100e },
	'dynamicrangemax' => { 108 => 0x7c },
	'dynamicrangemin' => { 108 => 0x7a },
	'dynamicrangeoptimizer' => { 184 => 0x15, 424 => [0xb025,0xb04f], 433 => 0x1144, 434 => [0x1144,0x324], 435 => [0x1120,0x300], 436 => [0x119c,0x37c], 437 => [0x1178,0x328], 438 => [0x1030,0x50], 439 => [0x228,0x50], 440 => [0x228,0x50], 441 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 422 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 411 => 0x19, 412 => 0x17, 413 => 0xd, 422 => 0x79, 429 => 0x5 },
	'dynamicrangeoptimizermode' => { 187 => 0x15, 411 => 0x18, 412 => 0x16, 422 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 184 => 0x27, 413 => 0xc, 429 => 0x4 },
	'dynamicrangesetting' => { 127 => 0x1402 },
	'e-dialinprogram' => { 340 => '1.3' },
	'earliestageorloweststage' => { 118 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 462 => 'EarthPos' },
	'earthposaltitude' => { 462 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 462 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 462 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 462 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 462 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 462 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 462 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 462 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 298 => '6.1' },
	'easyexposurecompensation' => { 283 => '6.4', 284 => '6.5', 286 => '6.3', 287 => '6.3', 291 => '5.1', 292 => '4.4', 293 => '5.2', 296 => '6.3', 297 => '6.3', 299 => 0x1d },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 138 => 0x930 },
	'edgemapx1' => { 138 => 0x931 },
	'edgemapx2' => { 138 => 0x932 },
	'edgemapx3' => { 138 => 0x934 },
	'edgemapx4' => { 138 => 0x935 },
	'edgenoisereduction' => { 277 => 0x4, 459 => 0x8028 },
	'edit1' => { 384 => "\xa9ed1" },
	'edit2' => { 384 => "\xa9ed2" },
	'edit3' => { 384 => "\xa9ed3" },
	'edit4' => { 384 => "\xa9ed4" },
	'edit5' => { 384 => "\xa9ed5" },
	'edit6' => { 384 => "\xa9ed6" },
	'edit7' => { 384 => "\xa9ed7" },
	'edit8' => { 384 => "\xa9ed8" },
	'edit9' => { 384 => "\xa9ed9" },
	'edition' => { 499 => 'edition' },
	'editorialupdate' => { 131 => 0x8 },
	'editstatus' => { 131 => 0x7, 371 => 'EditStatus', 477 => 'EditStatus' },
	'editversionname' => { 276 => 0x3d136244 },
	'effectivelv' => { 359 => 0x2d },
	'effectivemaxaperture' => { 220 => 0x12, 221 => 0x13, 225 => 0x14 },
	'eissn' => { 499 => 'eIssn' },
	'electricalblackcolumns' => { 138 => 0x1810 },
	'electronicfront-curtainshutter' => { 286 => '5.2', 287 => '5.2', 296 => '5.3', 297 => '5.2' },
	'electronicfrontcurtainshutter' => { 424 => 0x201a },
	'elevation' => { 165 => 'Elevation' },
	'email' => { 157 => 'EMail' },
	'embargodate' => { 502 => 'embargoDate' },
	'embdencrightsexpr' => { 495 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 495 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 495 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 495 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 497 => 'EmbeddedXMPDigest' },
	'emissivity' => { 121 => 0x3 },
	'emptyslotrelease' => { 231 => 0x625, 232 => 0x655 },
	'enablechromanoisereduction' => { 138 => 0xe6e },
	'enablesharpening' => { 138 => 0x92e },
	'encodedby' => { 179 => 'WM/EncodedBy', 376 => "\xa9enc" },
	'encodedwith' => { 378 => 'Encoded_With' },
	'encoder' => { 376 => "\xa9too", 384 => "\xa9too" },
	'encoderid' => { 384 => "\xa9enc" },
	'encodingtime' => { 179 => 'WM/EncodingTime' },
	'encryptionkey' => { 398 => 0xa020 },
	'endingpage' => { 499 => 'endingPage' },
	'enduser' => { 311 => 'EndUser' },
	'enduserid' => { 311 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 311 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 231 => 0x648, 232 => 0x678 },
	'engineer' => { 509 => 'engineer' },
	'enhancedarktones' => { 269 => 0x8 },
	'enhancedetailsalreadyapplied' => { 479 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 479 => 'EnhanceDetailsVersion' },
	'enhancement' => { 112 => 0x16, 113 => 0x3016 },
	'enhanceparams' => { 119 => 0xc7ee },
	'enhancer' => { 305 => 0x300 },
	'enhancervalues' => { 305 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 479 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 479 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 479 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 132 => 0x28 },
	'envelopepriority' => { 132 => 0x3c },
	'enveloperecordversion' => { 132 => 0x0 },
	'episode' => { 495 => 'Episode' },
	'episodeglobaluniqueid' => { 376 => 'egid' },
	'episodeidentifier' => { 495 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 495 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 495 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 306 => 0x20c },
	'epsonimagewidth' => { 306 => 0x20b },
	'epsonsoftware' => { 306 => 0x20d },
	'equipmentinstitution' => { 461 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 461 => 'EquipmentManufacturer' },
	'equipmentversion' => { 302 => 0x0 },
	'ettlii' => { 84 => 0x304, 85 => 0xd, 86 => 0xe, 87 => 0x7, 88 => 0x7, 89 => 0xe },
	'event' => { 463 => 'Event', 475 => 'Event', 495 => 'Event', 499 => 'event' },
	'eventalias' => { 498 => 'eventAlias' },
	'eventdate' => { 118 => [\'Event','EventEventDate'] },
	'eventday' => { 118 => [\'Event','EventDay'] },
	'eventearliestdate' => { 118 => [\'Event','EventEarliestDate'] },
	'eventend' => { 498 => 'eventEnd' },
	'eventenddayofyear' => { 118 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 118 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 118 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 118 => [\'Event','EventHabitat'] },
	'eventid' => { 118 => [\'Event','EventEventID'], 495 => 'EventId' },
	'eventlatestdate' => { 118 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 118 => [\'Event','EventMonth'] },
	'eventnumber' => { 385 => 0x9, 386 => 0x37, 387 => 0x3a },
	'eventparenteventid' => { 118 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 118 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 118 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 118 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 118 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 118 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 498 => 'eventStart' },
	'eventstartdayofyear' => { 118 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 498 => 'eventSubtype' },
	'eventtime' => { 118 => [\'Event','EventEventTime'] },
	'eventtype' => { 498 => 'eventType' },
	'eventverbatimeventdate' => { 118 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 118 => [\'Event','EventYear'] },
	'evfgrid' => { 299 => 0x165 },
	'evfimageframe' => { 299 => 0x164 },
	'evfreleaseindicator' => { 299 => 0x24f },
	'evfwarmdisplaybrightness' => { 299 => 0x24d },
	'evfwarmdisplaymode' => { 299 => 0x24b },
	'evsteps' => { 340 => '1.2', 342 => 0x0 },
	'evstepsize' => { 288 => '5.1', 289 => '6.1', 290 => '6.1', 294 => '0.7' },
	'exclusivecoverage' => { 472 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 502 => 'exclusivityEndDate' },
	'excursiontolerance' => { 133 => 0x82 },
	'executiveproducer' => { 376 => "\xa9xpd" },
	'exif' => { 120 => 'EXIF' },
	'exifbyteorder' => { 120 => 'ExifByteOrder' },
	'exifcamerainfo' => { 131 => 0xe8 },
	'exifimageheight' => { 119 => 0xa003, 488 => 'PixelYDimension' },
	'exifimagewidth' => { 119 => 0xa002, 488 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 120 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 119 => 0x9000, 488 => 'ExifVersion' },
	'exitpupilposition' => { 220 => 0x4, 221 => 0x4, 225 => 0x4 },
	'expirationdate' => { 131 => 0x25, 502 => 'expirationDate' },
	'expirationtime' => { 131 => 0x26 },
	'exposure' => { 119 => 0xfe51, 482 => 'Exposure', 484 => 'Exposure' },
	'exposure2012' => { 482 => 'Exposure2012', 484 => 'Exposure2012' },
	'exposureadj' => { 274 => 0x0 },
	'exposureadj2' => { 274 => 0x12 },
	'exposureadjust' => { 401 => 0xc },
	'exposurebracketingindicatorlast' => { 184 => 0x52 },
	'exposurebracketshotnumber' => { 187 => 0x2d, 422 => 0x2f },
	'exposurebracketstepsize' => { 340 => 0x8 },
	'exposurebracketvalue' => { 227 => 0x19 },
	'exposurecompautocancel' => { 84 => 0x113 },
	'exposurecompensation' => { 77 => 0x6, 93 => 0x0, 119 => 0x9204, 140 => 0x24, 156 => 'ExposureComp', 176 => 'ExposureCompensation', 181 => 0xd, 182 => 0x53, 183 => 0x1e, 187 => 0x49c0, 306 => 0x1006, 359 => 0x16, 368 => 0x402, 398 => 0xa013, 401 => [0xc,0x35,0x4d], 433 => 0x114c, 434 => 0x114c, 435 => 0x1128, 437 => 0x1180, 438 => 0x1038, 439 => 0x230, 440 => 0x230, 441 => 0x223, 488 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 429 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 184 => 0x47, 187 => 0x2a },
	'exposurecompensationset' => { 411 => 0x3, 412 => 0x3, 413 => 0x3, 429 => 0x1e },
	'exposurecompensationsetting' => { 184 => 0x1 },
	'exposurecompstepsize' => { 283 => '6.3', 284 => '7.3', 286 => '7.3', 287 => '7.3', 292 => '4.3', 296 => '7.3', 297 => '7.3' },
	'exposurecontrolstep' => { 291 => '6.1', 293 => '6.1' },
	'exposurecontrolstepsize' => { 283 => '6.2', 284 => '7.1', 286 => '7.1', 287 => '7.1', 292 => '4.2', 296 => '7.1', 297 => '7.1', 298 => '7.1', 299 => 0x1b },
	'exposurecount' => { 127 => 0x1032 },
	'exposuredelaymode' => { 283 => '10.1', 284 => '11.1', 286 => '11.1', 287 => '11.1', 288 => '9.1', 289 => '10.1', 290 => '10.1', 292 => '10.4', 293 => '10.1', 294 => '6.4', 296 => '11.1', 297 => '11.1', 298 => '11.2' },
	'exposuredifference' => { 227 => 0xe },
	'exposuregaincustom' => { 138 => 0x89c },
	'exposuregaindaylight' => { 138 => 0x898 },
	'exposuregainflash' => { 138 => 0x89b },
	'exposuregainfluorescent' => { 138 => 0x89a },
	'exposuregaintungsten' => { 138 => 0x899 },
	'exposureindex' => { 119 => 0xa215, 488 => 'ExposureIndex' },
	'exposureindicator' => { 184 => 0x50 },
	'exposurelevelincrements' => { 82 => 0x6, 83 => 0x6, 84 => 0x101, 85 => 0x5, 86 => 0x6, 87 => 0x5, 88 => 0x5, 89 => 0x6, 90 => 0x4, 411 => 0x58, 412 => 0x58 },
	'exposurelockused' => { 470 => 'ExposureLockUsed' },
	'exposuremode' => { 119 => 0xa402, 156 => 'ExposureMode', 181 => 0x1, 182 => 0xa, 183 => 0x0, 184 => 0x0, 187 => 0x34, 301 => 0x200, 321 => 0x40d, 401 => 0x8, 424 => 0xb041, 488 => 'ExposureMode' },
	'exposuremodeinmanual' => { 84 => 0x10b },
	'exposureprogram' => { 119 => 0x8822, 391 => 0x1001, 404 => [0x17e,0x43], 411 => 0x3c, 412 => 0x3c, 413 => 0x5, 417 => 0x14, 422 => 0x3f, 429 => 0x2, 433 => 0x1175, 434 => 0x1179, 435 => 0x1155, 436 => 0x11d1, 437 => 0x11ad, 438 => 0x1065, 439 => 0x25d, 440 => 0x25d, 441 => 0x24c, 451 => 0xb, 452 => 0xc, 453 => 0xb, 455 => 0x48, 488 => 'ExposureProgram' },
	'exposureshift' => { 301 => 0x203 },
	'exposurestandardadjustment' => { 424 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 77 => 0x16, 119 => 0x829a, 137 => 0xfd05, 140 => 0x20, 142 => 0xfa24, 144 => 0xf104, 147 => 0x12, 149 => 0x38, 151 => 0x14, 152 => 0x10, 154 => 0x10, 156 => 'ExposureTime', 181 => 0x9, 182 => 0x35, 183 => 0x48, 184 => 0x8, 187 => 0x49b8, 359 => 0x12, 398 => 0xa018, 401 => [0x32,0x4a], 411 => 0x0, 412 => 0x0, 429 => [0x21,0x23,0x27], 455 => 0x10, 488 => 'ExposureTime' },
	'exposuretime2' => { 401 => [0x33,0x4b] },
	'exposuretuning' => { 227 => 0x1c },
	'exposurevalue' => { 138 => 0x3 },
	'exposurewarning' => { 127 => 0x1302 },
	'exrauto' => { 127 => 0x1033 },
	'exrmode' => { 127 => 0x1034 },
	'extdescraccessibility' => { 494 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 231 => 0x114, 232 => 0x124 },
	'extendedshutterspeeds' => { 299 => 0x102 },
	'extendedwbdetect' => { 301 => 0x902 },
	'extender' => { 302 => 0x301 },
	'extenderfirmwareversion' => { 302 => 0x304 },
	'extendermagnification' => { 158 => 'Magnification' },
	'extendermake' => { 158 => 'Make' },
	'extendermodel' => { 158 => 'Model', 302 => 0x303 },
	'extenderserialnumber' => { 158 => 'SerialNumber', 302 => 0x302 },
	'extenderstatus' => { 357 => 0x3 },
	'externalflash' => { 304 => 0x1201 },
	'externalflashae1' => { 306 => 0x101f },
	'externalflashae1_0' => { 306 => 0x101b },
	'externalflashae2' => { 306 => 0x1020 },
	'externalflashae2_0' => { 306 => 0x101c },
	'externalflashbounce' => { 304 => 0x1204, 306 => 0x1026, 347 => 0x1a },
	'externalflashcompensation' => { 211 => 0x1b },
	'externalflashexposurecomp' => { 227 => 0x17, 347 => 0x19 },
	'externalflashfirmware' => { 209 => 0x6, 210 => 0x6, 211 => 0x6, 212 => 0x6, 213 => 0x6, 214 => 0x6 },
	'externalflashflags' => { 209 => 0x8, 210 => 0x8, 211 => 0x8, 212 => 0x8, 214 => 0x8 },
	'externalflashguidenumber' => { 304 => 0x1203, 347 => '24.1' },
	'externalflashgvalue' => { 306 => 0x1025 },
	'externalflashmode' => { 306 => 0x1028, 347 => 0x2 },
	'externalflashreadystate' => { 213 => '9.1' },
	'externalflashstatus' => { 213 => '8.2' },
	'externalflashzoom' => { 304 => 0x1205, 306 => 0x1027 },
	'externalflashzoomoverride' => { 213 => '8.1' },
	'externalmetadatalink' => { 495 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 319 => 0x311, 322 => 0x311, 323 => 0x311, 326 => 0x3408 },
	'extrainfoversion' => { 415 => 0x1a },
	'eyestartaf' => { 184 => 0x40 },
	'fac100per' => { 138 => 0xe94 },
	'fac170per' => { 138 => 0xe93 },
	'fac18per' => { 138 => 0xe92 },
	'face10position' => { 110 => 0x3f4, 111 => 0x1ec, 207 => 0x28, 344 => 0x12 },
	'face10size' => { 345 => 0x12 },
	'face11position' => { 207 => 0x2c, 344 => 0x14 },
	'face11size' => { 345 => 0x14 },
	'face12position' => { 207 => 0x30, 344 => 0x16 },
	'face12size' => { 345 => 0x16 },
	'face13position' => { 344 => 0x18 },
	'face13size' => { 345 => 0x18 },
	'face14position' => { 344 => 0x1a },
	'face14size' => { 345 => 0x1a },
	'face15position' => { 344 => 0x1c },
	'face15size' => { 345 => 0x1c },
	'face16position' => { 344 => 0x1e },
	'face16size' => { 345 => 0x1e },
	'face17position' => { 344 => 0x20 },
	'face17size' => { 345 => 0x20 },
	'face18position' => { 344 => 0x22 },
	'face18size' => { 345 => 0x22 },
	'face19position' => { 344 => 0x24 },
	'face19size' => { 345 => 0x24 },
	'face1position' => { 54 => 0x8, 110 => 0xd, 111 => 0x18, 207 => 0x4, 316 => 0x1, 344 => 0x0, 388 => 0xbc, 418 => 0x1, 419 => 0x0, 420 => 0x0, 421 => 0x5b },
	'face1size' => { 345 => 0x0 },
	'face20position' => { 344 => 0x26 },
	'face20size' => { 345 => 0x26 },
	'face21position' => { 344 => 0x28 },
	'face21size' => { 345 => 0x28 },
	'face22position' => { 344 => 0x2a },
	'face22size' => { 345 => 0x2a },
	'face23position' => { 344 => 0x2c },
	'face23size' => { 345 => 0x2c },
	'face24position' => { 344 => 0x2e },
	'face24size' => { 345 => 0x2e },
	'face25position' => { 344 => 0x30 },
	'face25size' => { 345 => 0x30 },
	'face26position' => { 344 => 0x32 },
	'face26size' => { 345 => 0x32 },
	'face27position' => { 344 => 0x34 },
	'face27size' => { 345 => 0x34 },
	'face28position' => { 344 => 0x36 },
	'face28size' => { 345 => 0x36 },
	'face29position' => { 344 => 0x38 },
	'face29size' => { 345 => 0x38 },
	'face2position' => { 54 => 0xa, 110 => 0x7c, 111 => 0x4c, 207 => 0x8, 316 => 0x5, 344 => 0x2, 388 => 0xc8, 418 => 0x6, 419 => 0x20, 420 => 0x25, 421 => 0x65 },
	'face2size' => { 345 => 0x2 },
	'face30position' => { 344 => 0x3a },
	'face30size' => { 345 => 0x3a },
	'face31position' => { 344 => 0x3c },
	'face31size' => { 345 => 0x3c },
	'face32position' => { 344 => 0x3e },
	'face32size' => { 345 => 0x3e },
	'face3position' => { 54 => 0xc, 110 => 0xeb, 111 => 0x80, 207 => 0xc, 316 => 0x9, 344 => 0x4, 388 => 0xd4, 418 => 0xb, 419 => 0x40, 420 => 0x4a, 421 => 0x6f },
	'face3size' => { 345 => 0x4 },
	'face4position' => { 54 => 0xe, 110 => 0x15a, 111 => 0xb4, 207 => 0x10, 316 => 0xd, 344 => 0x6, 388 => 0xe0, 418 => 0x10, 419 => 0x60, 420 => 0x6f, 421 => 0x79 },
	'face4size' => { 345 => 0x6 },
	'face5position' => { 54 => 0x10, 110 => 0x1c9, 111 => 0xe8, 207 => 0x14, 316 => 0x11, 344 => 0x8, 388 => 0xec, 418 => 0x15, 419 => 0x80, 420 => 0x94 },
	'face5size' => { 345 => 0x8 },
	'face6position' => { 54 => 0x12, 110 => 0x238, 111 => 0x11c, 207 => 0x18, 344 => 0xa, 388 => 0xf8, 418 => 0x1a, 419 => 0xa0, 420 => 0xb9 },
	'face6size' => { 345 => 0xa },
	'face7position' => { 54 => 0x14, 110 => 0x2a7, 111 => 0x150, 207 => 0x1c, 344 => 0xc, 388 => 0x104, 418 => 0x1f, 419 => 0xc0, 420 => 0xde },
	'face7size' => { 345 => 0xc },
	'face8position' => { 54 => 0x16, 110 => 0x316, 111 => 0x184, 207 => 0x20, 344 => 0xe, 388 => 0x110, 418 => 0x24, 419 => 0xe0, 420 => 0x103 },
	'face8size' => { 345 => 0xe },
	'face9position' => { 54 => 0x18, 110 => 0x385, 111 => 0x1b8, 207 => 0x24, 344 => 0x10 },
	'face9size' => { 345 => 0x10 },
	'facebalanceorigi' => { 476 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 476 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 476 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 476 => 'FaceBalanceWarmth' },
	'facedetect' => { 359 => 0x76, 398 => 0x100 },
	'facedetectarea' => { 305 => 0x1201 },
	'facedetectframecrop' => { 305 => 0x1207 },
	'facedetectframesize' => { 54 => 0x3, 110 => 0x1, 111 => 0x4, 207 => 0x1, 305 => 0x1203, 359 => 0x77, 388 => 0xb6 },
	'facedetection' => { 413 => 0x30, 429 => 0x19 },
	'faceelementpositions' => { 127 => 0x4203 },
	'faceelementselected' => { 127 => 0x4005 },
	'faceelementtypes' => { 127 => 0x4201 },
	'faceid' => { 478 => 'FaceID' },
	'faceinfounknown' => { 113 => 0x2089 },
	'facename' => { 398 => 0x123 },
	'faceorientation' => { 111 => 0x8 },
	'faceposition' => { 343 => 0x2, 399 => 0x4 },
	'facepositions' => { 127 => 0x4103 },
	'facerecognition' => { 398 => 0x120 },
	'facesdetected' => { 54 => 0x2, 55 => 0x2, 56 => 0x3, 110 => 0x0, 111 => 0x2, 113 => 0x211c, 127 => 0x4100, 207 => 0x3, 305 => 0x1200, 324 => 0x3f, 343 => 0x0, 388 => 0xb5, 399 => 0x0, 418 => 0x0, 421 => 0x3, 432 => 0x30 },
	'facesrecognized' => { 317 => 0x0 },
	'facewidth' => { 55 => 0x1 },
	'fade' => { 424 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 109 => 0x38 },
	'faithfuloutputshadowpoint' => { 109 => 0x39 },
	'faithfulrawcolortone' => { 109 => 0x31 },
	'faithfulrawcontrast' => { 109 => 0x33 },
	'faithfulrawhighlight' => { 109 => 0x79 },
	'faithfulrawhighlightpoint' => { 109 => 0x36 },
	'faithfulrawlinear' => { 109 => 0x34 },
	'faithfulrawsaturation' => { 109 => 0x32 },
	'faithfulrawshadow' => { 109 => 0x82 },
	'faithfulrawshadowpoint' => { 109 => 0x37 },
	'faithfulrawsharpness' => { 109 => 0x35 },
	'faithfulunsharpmaskfineness' => { 109 => 0xac },
	'faithfulunsharpmaskstrength' => { 109 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 109 => 0xae },
	'far' => { 467 => 'Far' },
	'fastresetlinetime' => { 138 => 0x1860 },
	'feedidentifier' => { 495 => 'FeedIdentifier' },
	'femicroadjustment' => { 84 => 0x111 },
	'ffid' => { 486 => 'ffid' },
	'field' => { 498 => 'field' },
	'fieldcount' => { 306 => 0x103f },
	'fieldofview' => { 384 => "FOV\x00" },
	'fifoenonepixeldelay' => { 138 => 0x1901 },
	'filecreatedate' => { 120 => 'FileCreateDate' },
	'filedatarate' => { 509 => 'fileDataRate' },
	'fileformat' => { 95 => 0x0, 132 => 0x14, 401 => [0x22,0x26], 424 => 0xb000 },
	'filegroupid' => { 120 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 325 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 120 => 'FileModifyDate' },
	'filename' => { 120 => 'FileName' },
	'filenameasdelivered' => { 311 => 'FileNameAsDelivered' },
	'filenumber' => { 57 => 0x1, 64 => 0x8, 97 => 0x1817, 114 => 'Canon-FileNumber', 208 => 0x4, 387 => 0x10 },
	'filenumbermemory' => { 181 => 0x1a },
	'filenumbersequence' => { 283 => '12.2', 288 => '3.1', 289 => '4.1', 290 => '4.1', 292 => '11.1', 293 => '4.3', 298 => '5.2', 299 => 0x48 },
	'filepermissions' => { 120 => 'FilePermissions' },
	'filesource' => { 119 => 0xa300, 127 => 0x8000, 488 => 'FileSource' },
	'fileuserid' => { 120 => 'FileUserID' },
	'fileversion' => { 132 => 0x16 },
	'fillflashautoreduction' => { 82 => 0xe, 83 => 0xe, 90 => 0xa },
	'filllight' => { 482 => 'FillLight', 484 => 'FillLight' },
	'fillorder' => { 119 => 0x10a },
	'filmgraineffect' => { 301 => 0x538 },
	'filmmode' => { 127 => 0x1401, 321 => 0x412, 324 => 0x42 },
	'filmtype' => { 241 => 0x2 },
	'filtereffect' => { 57 => 0xe, 235 => 0x37, 236 => 0x3f, 237 => 0x47, 324 => 0xa1 },
	'filtereffectauto' => { 71 => 0xa0 },
	'filtereffectfaithful' => { 70 => 0x70, 71 => 0x70 },
	'filtereffectlandscape' => { 70 => 0x40, 71 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 70 => 0x88, 71 => 0x88 },
	'filtereffectneutral' => { 70 => 0x58, 71 => 0x58 },
	'filtereffectportrait' => { 70 => 0x28, 71 => 0x28 },
	'filtereffectstandard' => { 70 => 0x10, 71 => 0x10 },
	'filtereffectuserdef1' => { 70 => 0xa0, 71 => 0xb8 },
	'filtereffectuserdef2' => { 70 => 0xb8, 71 => 0xd0 },
	'filtereffectuserdef3' => { 70 => 0xd0, 71 => 0xe8 },
	'finderdisplayduringexposure' => { 83 => 0x1 },
	'finesharpness' => { 359 => 0x70 },
	'finetuneoptcenterweighted' => { 283 => '7.2', 284 => '9.1', 286 => '9.1', 287 => '9.1', 291 => '8.1', 296 => '9.1', 297 => '9.1', 298 => '9.1', 299 => 0x23 },
	'finetuneopthighlightweighted' => { 286 => '46.1', 287 => '46.1', 296 => '46.1', 297 => '46.1', 299 => 0x27 },
	'finetuneoptmatrixmetering' => { 283 => '8.1', 284 => '8.2', 286 => '8.2', 287 => '8.2', 291 => '7.2', 292 => '6.1', 296 => '8.2', 297 => '8.2', 298 => '8.2', 299 => 0x21 },
	'finetuneoptspotmetering' => { 283 => '8.2', 284 => '9.2', 286 => '9.2', 287 => '9.2', 291 => '8.2', 292 => '6.2', 296 => '9.2', 297 => '9.2', 298 => '9.2', 299 => 0x25 },
	'finishexposure' => { 138 => 0xdbd },
	'finishfiletype' => { 138 => 0xdb8 },
	'finishlook' => { 138 => 0xdbc },
	'finishnoise' => { 138 => 0xdba },
	'finishresolution' => { 138 => 0xdb9 },
	'finishsharpening' => { 138 => 0xdbb },
	'firmware' => { 306 => 0x405, 401 => [0x8c,0x17,0x3b], 479 => 'Firmware' },
	'firmware2' => { 401 => 0x57 },
	'firmwaredate' => { 112 => 0x15, 113 => 0x2001, 385 => 0x4, 387 => 0x30 },
	'firmwareid' => { 188 => 0x0 },
	'firmwarename' => { 398 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 64 => 0x1e, 389 => 0x0 },
	'firmwarerevision2' => { 389 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 138 => [0x415,0xce5], 154 => 0x57, 156 => 'FirmwareVersion', 322 => 0x320, 324 => 0x2, 326 => 0x3109, 359 => 0x230, 384 => ['CNFV','FIRM'], 386 => 0x18, 387 => 0x2a, 391 => 0x2 },
	'firmwareversions' => { 368 => 0x301 },
	'firstphotodate' => { 470 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 311 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 131 => 0x16, 477 => 'FixtureIdentifier' },
	'flash' => { 114 => 'XMP-Flash', 119 => 0x9209, 152 => 0x22, 182 => 0x1f, 183 => 0x15, 387 => 0x5a, 488 => 'Flash' },
	'flashaction' => { 411 => 0x3e, 412 => 0x3e, 424 => 0x2017, 429 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 411 => 0x4c, 412 => 0x4c, 429 => 0x77 },
	'flashactionexternal' => { 429 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 44 => 0x249 },
	'flashbias' => { 324 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashburstpriority' => { 299 => 0x111 },
	'flashbuttonfunction' => { 84 => 0x70e },
	'flashchargelevel' => { 306 => 0x1010 },
	'flashcolorfilter' => { 211 => 0x10, 212 => 0x10, 214 => 0x10 },
	'flashcommandermode' => { 209 => '9.1', 210 => '9.1', 211 => '9.1', 212 => '9.1', 214 => '9.1' },
	'flashcompensation' => { 138 => 0x3f3, 209 => 0xa, 210 => 0xa, 211 => 0xa, 212 => 0x27, 213 => 0xa, 214 => 0xa, 479 => 'FlashCompensation' },
	'flashcontrol' => { 411 => 0x23, 412 => 0x1f, 413 => 0x21 },
	'flashcontrolbuilt-in' => { 292 => '16.1', 293 => '23.1', 295 => '23.1', 296 => '24.1' },
	'flashcontrolmode' => { 209 => '9.2', 210 => '9.2', 211 => '9.2', 212 => '9.2', 214 => '9.2', 230 => 0x148, 231 => 0x1a8, 232 => 0x1bc, 256 => 0xc4a6, 301 => 0x404 },
	'flashcurtain' => { 324 => 0x48 },
	'flashdefault' => { 184 => 0x42 },
	'flashdevice' => { 306 => 0x1005 },
	'flashdistance' => { 113 => 0x2034 },
	'flashenergy' => { 119 => 0xa20b, 488 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 227 => 0x18 },
	'flashexposurecomp' => { 77 => 0xf, 127 => 0x1011, 159 => 'ExposureComp', 181 => 0x23, 186 => 0x104, 187 => 0x49c1, 227 => 0x12, 301 => 0x401, 306 => 0x1023, 359 => 0x4d, 391 => 0x100b, 401 => [0x3a,0x56], 424 => 0x104 },
	'flashexposurecomp2' => { 260 => 0x4d2 },
	'flashexposurecomp3' => { 211 => 0x1d },
	'flashexposurecomp4' => { 211 => 0x27 },
	'flashexposurecomparea' => { 284 => '38.4', 286 => '38.4', 287 => '38.4', 296 => '38.4', 297 => '38.4', 299 => 0x59 },
	'flashexposurecompset' => { 184 => 0x10, 332 => 0xe, 411 => 0x14, 412 => 0x12, 413 => 0x23, 429 => 0x1f },
	'flashexposurecompset2' => { 429 => [0x26,0x2c] },
	'flashexposureindicator' => { 184 => 0x54 },
	'flashexposureindicatorlast' => { 184 => 0x56 },
	'flashexposureindicatornext' => { 184 => 0x55 },
	'flashexposurelock' => { 57 => 0x19 },
	'flashfired' => { 140 => 0x5d, 159 => 'Fired', 181 => 0x14, 259 => '590.3', 488 => [\'Flash','FlashFired'] },
	'flashfiring' => { 84 => 0x306, 85 => 0x6, 86 => 0x7, 89 => 0x7 },
	'flashfirmwareversion' => { 302 => 0x1002 },
	'flashfocallength' => { 209 => 0xb, 210 => 0xc, 211 => 0xc, 212 => 0xc, 213 => 0xc, 214 => 0x26 },
	'flashfunction' => { 187 => 0x31, 488 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 209 => 0xe, 210 => 0xf, 211 => 0xf, 212 => 0xf, 213 => 0xf, 214 => 0xf, 230 => 0x14e, 231 => 0x1ae, 232 => 0x1c2, 256 => 0xc4ac },
	'flashgroupacompensation' => { 209 => 0x11, 210 => 0x12, 211 => 0x13, 212 => 0x28, 213 => 0x28, 214 => 0x28 },
	'flashgroupacontrolmode' => { 209 => 0xf, 210 => '16.1', 211 => '17.1', 212 => '17.1', 213 => '17.1', 214 => '17.1' },
	'flashgroupaoutput' => { 209 => 0x11, 210 => 0x12, 211 => 0x13, 212 => 0x28, 213 => 0x28, 214 => 0x28 },
	'flashgroupbcompensation' => { 209 => 0x12, 210 => 0x13, 211 => 0x14, 212 => 0x29, 213 => 0x29, 214 => 0x29 },
	'flashgroupbcontrolmode' => { 209 => 0x10, 210 => '17.1', 211 => '18.1', 212 => '18.1', 213 => '18.1', 214 => '18.1' },
	'flashgroupboutput' => { 209 => 0x12, 210 => 0x13, 211 => 0x14, 212 => 0x29, 213 => 0x29, 214 => 0x29 },
	'flashgroupccompensation' => { 210 => 0x14, 211 => 0x15, 212 => 0x2a, 213 => 0x2a, 214 => 0x2a },
	'flashgroupccontrolmode' => { 210 => '17.2', 211 => '18.2', 212 => '18.2', 213 => '18.2', 214 => '18.2' },
	'flashgroupcoutput' => { 210 => 0x14, 211 => 0x15, 212 => 0x2a, 213 => 0x2a, 214 => 0x2a },
	'flashguidenumber' => { 77 => 0xd, 94 => 0x0, 159 => 'GuideNumber' },
	'flashilluminationpattern' => { 214 => 0x25 },
	'flashintensity' => { 112 => [0x19,0x5], 301 => 0x405 },
	'flashlevel' => { 285 => 0x9, 424 => 0xb048 },
	'flashmake' => { 159 => 'Make' },
	'flashmanufacturer' => { 178 => 'FlashManufacturer' },
	'flashmastercompensation' => { 230 => 0x162, 231 => 0x1aa, 232 => 0x1be, 256 => 0xc4c0 },
	'flashmastercontrolmode' => { 230 => 0x160, 256 => 0xc4be },
	'flashmasteroutput' => { 230 => 0x166, 256 => 0xc4c4 },
	'flashmetering' => { 181 => 0x3f, 184 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 359 => 0x20a },
	'flashmode' => { 112 => 0x4, 138 => 0x3f2, 140 => 0x5c, 151 => 0x27, 159 => 'Mode', 181 => 0x2, 182 => 0x20, 183 => 0x16, 184 => 0xf, 227 => 0x87, 301 => 0x400, 306 => 0x1004, 359 => 0xc, 366 => 0x4, 390 => 0x20, 391 => 0x100a, 400 => 0x225, 411 => 0x13, 412 => 0x7f, 413 => 0x20, 429 => 0x10, 433 => 0x1138, 434 => 0x1138, 435 => 0x1114, 436 => 0x1190, 437 => 0x116c, 438 => 0x1024, 439 => 0x21c, 440 => 0x21c, 441 => 0x211, 488 => [\'Flash','FlashMode'] },
	'flashmodel' => { 159 => 'Model', 178 => 'FlashModel', 302 => 0x1001 },
	'flashoptions' => { 340 => 0x2 },
	'flashoptions2' => { 340 => 0x10 },
	'flashoutput' => { 44 => 0x248, 77 => 0x21, 209 => 0xa, 210 => 0xa, 211 => 0xa, 212 => 0x27, 214 => 0x21, 230 => 0x152, 231 => 0x1b2, 232 => 0x1c6, 256 => 0xc4b0 },
	'flashpixversion' => { 119 => 0xa000, 488 => 'FlashpixVersion' },
	'flashredeyemode' => { 488 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 230 => 0x15c, 231 => 0x1bc, 256 => 0xc4ba, 301 => 0x403 },
	'flashreturn' => { 488 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 159 => 'SerialNumber', 302 => 0x1003 },
	'flashsetting' => { 227 => 0x8 },
	'flashshutterspeed' => { 283 => '20.2', 284 => '23.2', 286 => '23.2', 287 => '23.2', 292 => '15.2', 293 => '22.2', 294 => '7.2', 295 => '22.2', 296 => '23.2', 297 => '23.2', 298 => '23.1', 299 => 0x57 },
	'flashsource' => { 209 => 0x4, 210 => 0x4, 211 => 0x4, 212 => 0x4, 213 => 0x4, 214 => 0x4 },
	'flashstatus' => { 347 => 0x0, 429 => [0x82,0x86], 443 => 0x31, 444 => 0x39, 445 => 0x39 },
	'flashstatusbuilt-in' => { 413 => [0x87,0x287] },
	'flashstatusexternal' => { 413 => [0x88,0x288] },
	'flashsyncspeed' => { 283 => '20.1', 284 => '23.1', 286 => '23.1', 287 => '23.1', 292 => '15.1', 293 => '22.1', 295 => '22.1', 296 => '23.1', 297 => '23.1', 299 => 0x53 },
	'flashsyncspeedav' => { 82 => 0x3, 84 => 0x10f, 85 => 0x2, 86 => 0x3, 87 => 0x2, 88 => 0x2, 89 => 0x3, 90 => 0x6 },
	'flashthreshold' => { 94 => 0x1 },
	'flashtype' => { 159 => 'Type', 184 => 0x59, 227 => 0x9, 302 => 0x1000 },
	'flashwarning' => { 293 => '30.1', 294 => '7.1', 298 => '31.1', 324 => 0x62 },
	'flashwirelessoption' => { 230 => 0x15a, 231 => 0x1c8, 256 => 0xc4c6 },
	'flexiblespotposition' => { 424 => 0x201d },
	'flickadvancedirection' => { 299 => 0x25f },
	'flickerreduce' => { 400 => 0x218 },
	'flickerreduction' => { 127 => 0x1446, 252 => 0xe84 },
	'flickerreductionindicator' => { 252 => 0x5e2 },
	'flickerreductionshooting' => { 231 => 0x1a4, 232 => 0x1b8 },
	'flightpitchdegree' => { 116 => 'FlightPitchDegree' },
	'flightrolldegree' => { 116 => 'FlightRollDegree' },
	'flightxspeed' => { 116 => 'FlightXSpeed' },
	'flightyawdegree' => { 116 => 'FlightYawDegree' },
	'flightyspeed' => { 116 => 'FlightYSpeed' },
	'flightzspeed' => { 116 => 'FlightZSpeed' },
	'fliphorizontal' => { 276 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 77 => 0x15, 119 => 0x829d, 137 => 0xfd04, 140 => 0x1e, 142 => 0xfa23, 144 => 0xf103, 147 => 0x13, 149 => 0x3c, 151 => 0x1c, 152 => 0x18, 154 => 0xc, 163 => 'FNumber', 181 => 0xa, 182 => 0x36, 183 => 0x47, 184 => 0x9, 187 => 0x49c7, 225 => 0x38, 323 => 0x35a, 359 => 0x13, 398 => 0xa019, 401 => [0x31,0x49], 411 => 0x1, 412 => 0x1, 429 => [0x20,0x22,0x26], 488 => 'FNumber' },
	'focaldistance' => { 468 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 59 => 0x1, 113 => 0x1d, 119 => 0x920a, 147 => 0x1d, 163 => 'FocalLength', 181 => 0x12, 220 => 0xa, 221 => 0xb, 225 => [0xc,0x3c], 318 => 0x1, 359 => 0x1d, 368 => 0x403, 391 => 0x1500, 410 => 0xe, 437 => 0x1278, 438 => 0x1134, 439 => 0x32c, 440 => 0x32c, 441 => 0x30a, 488 => 'FocalLength' },
	'focallength2' => { 429 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 119 => 0xa405, 398 => 0xa01a, 488 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 410 => 0x10 },
	'focalplaneafpointarea' => { 442 => 0x2 },
	'focalplaneafpointlocation1' => { 442 => 0x6 },
	'focalplaneafpointlocation10' => { 442 => 0x2a },
	'focalplaneafpointlocation11' => { 442 => 0x2e },
	'focalplaneafpointlocation12' => { 442 => 0x32 },
	'focalplaneafpointlocation13' => { 442 => 0x36 },
	'focalplaneafpointlocation14' => { 442 => 0x3a },
	'focalplaneafpointlocation15' => { 442 => 0x3e },
	'focalplaneafpointlocation2' => { 442 => 0xa },
	'focalplaneafpointlocation3' => { 442 => 0xe },
	'focalplaneafpointlocation4' => { 442 => 0x12 },
	'focalplaneafpointlocation5' => { 442 => 0x16 },
	'focalplaneafpointlocation6' => { 442 => 0x1a },
	'focalplaneafpointlocation7' => { 442 => 0x1e },
	'focalplaneafpointlocation8' => { 442 => 0x22 },
	'focalplaneafpointlocation9' => { 442 => 0x26 },
	'focalplaneafpointsused' => { 442 => 0x1 },
	'focalplanediagonal' => { 302 => 0x103, 306 => 0x205 },
	'focalplaneresolutionunit' => { 119 => 0xa210, 488 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 119 => 0xa20e, 488 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 59 => 0x2 },
	'focalplanexunknown' => { 59 => 0x2 },
	'focalplaneyresolution' => { 119 => 0xa20f, 488 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 59 => 0x3 },
	'focalplaneyunknown' => { 59 => 0x3 },
	'focalpointx' => { 468 => 'FocalPointX' },
	'focalpointy' => { 468 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 59 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 266 => 0x8 },
	'focusarea' => { 181 => 0x31 },
	'focusareaselection' => { 294 => '15.2' },
	'focusbracket' => { 324 => 0xbd },
	'focusbracketstepsize' => { 301 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 84 => 0x515 },
	'focusdistance' => { 163 => 'FocusDistance', 181 => 0x13, 187 => 0x49bb, 220 => 0x9, 221 => 0xa, 225 => [0xb,0x4e], 304 => 0x305, 318 => 0x0, 322 => 0x304, 323 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 57 => 0x15, 77 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 225 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 57 => 0x14, 77 => 0x13 },
	'focusholdbutton' => { 184 => 0x44 },
	'focusinfoversion' => { 304 => 0x0 },
	'focusingscreen' => { 83 => 0x0, 84 => 0x80b, 89 => 0x0 },
	'focuslocation' => { 424 => 0x2027 },
	'focuslocked' => { 180 => 0x14 },
	'focusmode' => { 34 => 0x7, 112 => 0x3, 113 => [0x3003,0xd], 127 => 0x1021, 138 => 0x3f5, 140 => 0x38, 156 => 'FocusMode', 181 => 0x30, 183 => 0xe, 184 => 0xc, 227 => 0x7, 301 => 0x301, 306 => 0x100b, 324 => 0x7, 359 => 0xd, 366 => 0x3, 391 => 0x1006, 404 => [0xb,0x5], 410 => [0x15,0x1d], 411 => 0x4d, 412 => 0x4d, 424 => [0xb042,0xb04e,0x201b], 429 => 0x13, 449 => 0x16 },
	'focusmode2' => { 126 => '0.1', 340 => '3.1', 429 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 285 => '10.1', 408 => 0x14, 409 => 0x15, 411 => 0x10, 412 => 0xf, 413 => 0x6 },
	'focusmodeswitch' => { 184 => 0x58, 411 => 0x2e },
	'focuspeakingdisplay' => { 299 => 0x235 },
	'focuspeakinghighlightcolor' => { 299 => 0x4b },
	'focuspeakinglevel' => { 299 => 0x49 },
	'focuspixel' => { 127 => 0x1023 },
	'focuspointlock' => { 299 => 0x1d3 },
	'focuspointpersistence' => { 299 => 0x105 },
	'focuspointwrap' => { 283 => '2.2', 284 => '2.2', 286 => '2.1', 287 => '2.1', 291 => '1.1', 292 => '2.2', 293 => '1.1', 296 => '2.2', 297 => '2.1', 298 => '2.5', 299 => 0x16 },
	'focusposition' => { 1 => 0x2f, 220 => 0x8, 221 => 0x8, 359 => 0x10, 422 => 0x9bb },
	'focusposition2' => { 429 => [0x29,0x2b,0x2f], 449 => 0x2d, 452 => 0x20 },
	'focuspositionhorizontal' => { 193 => 0x2f, 194 => 0x43 },
	'focuspositionvertical' => { 193 => 0x31, 194 => 0x45 },
	'focusprocess' => { 301 => 0x302 },
	'focusrange' => { 34 => 0x12, 306 => 0x100a },
	'focusrangeindex' => { 350 => '3.1' },
	'focusresult' => { 194 => 0x4a },
	'focusringrotation' => { 84 => 0x713 },
	'focussetting' => { 401 => 0x6 },
	'focusshiftautoreset' => { 232 => 0x6da },
	'focusshiftexposurelock' => { 230 => 0xe8, 231 => 0xf4, 232 => 0x104, 256 => 0xc446 },
	'focusshiftinterval' => { 230 => 0xe4, 231 => 0xf0, 232 => 0x100, 256 => 0xc442 },
	'focusshiftnumbershots' => { 230 => 0xdc, 231 => 0xe8, 232 => 0xf8, 256 => 0xc43a },
	'focusshiftshooting' => { 265 => 0xb4 },
	'focusshiftstepwidth' => { 230 => 0xe0, 231 => 0xec, 232 => 0xfc, 256 => 0xc43e },
	'focusstatus' => { 410 => 0x19, 411 => 0x53, 412 => 0x53 },
	'focusstepcount' => { 304 => 0x301, 306 => 0x100e },
	'focusstepinfinity' => { 304 => 0x303, 306 => 0x103b },
	'focusstepnear' => { 304 => 0x304, 306 => 0x103c },
	'focustrackinglockon' => { 283 => ['1.5','4.1'], 284 => '1.4', 291 => '0.4', 292 => '3.1', 293 => '0.4', 296 => '1.4' },
	'focuswarning' => { 127 => 0x1301 },
	'foldername' => { 181 => 0x27 },
	'foldernumber' => { 411 => 0x9a, 413 => [0x402,0x114,0x316] },
	'fontcomposite' => { 514 => [\'Fonts','FontsComposite'] },
	'fontface' => { 514 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 514 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 514 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 514 => [\'Fonts','FontsFontName'] },
	'fonts' => { 514 => 'Fonts' },
	'fonttype' => { 514 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 514 => [\'Fonts','FontsVersionString'] },
	'for' => { 375 => 'For' },
	'forcewrite' => { 120 => 'ForceWrite' },
	'format' => { 384 => "\xa9fmt", 467 => 'Format', 485 => 'format', 507 => 'Format' },
	'forwardlock' => { 504 => 'forwardlock' },
	'forwardmatrix1' => { 119 => 0xc714 },
	'forwardmatrix2' => { 119 => 0xc715 },
	'forwardmatrix3' => { 119 => 0xcd34 },
	'fossilspecimen' => { 118 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 118 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 67 => [0x2,0x4] },
	'frameheight' => { 127 => 0x3822 },
	'framenum' => { 370 => 0xd7 },
	'framenumber' => { 127 => 0x8003, 187 => 0x3c, 359 => 0x29 },
	'framerate' => { 67 => [0x1,0x6], 119 => 0xc764, 127 => 0x3820 },
	'framereadouttime' => { 378 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 127 => 0x3821 },
	'framing' => { 498 => 'framing' },
	'freebytes' => { 97 => 0x1 },
	'freememorycardimages' => { 182 => [0x37,0x54], 183 => [0x2d,0x4a], 184 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 127 => 0x1010 },
	'fujimodel' => { 127 => 0x1447 },
	'fujimodel2' => { 127 => 0x1448 },
	'fullhdhighspeedrec' => { 127 => 0x3824 },
	'fullimagesize' => { 424 => 0xb02b },
	'fullpanoheightpixels' => { 470 => 'FullPanoHeightPixels', 471 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 470 => 'FullPanoWidthPixels', 471 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 391 => 0x100d },
	'fullsizeimage' => { 162 => 'data' },
	'fullsizeimagename' => { 162 => '1Name' },
	'fullsizeimagetype' => { 162 => '0Type' },
	'func1button' => { 286 => '14.1', 287 => '14.1', 297 => '14.1', 299 => 0x63 },
	'func1buttonplaybackmode' => { 299 => 0x1a5 },
	'func1buttonplusdials' => { 286 => '42.1', 287 => '42.1', 297 => '42.1' },
	'func2button' => { 286 => '80.1', 287 => '80.1', 297 => '80.1', 299 => 0x73 },
	'func2buttonplaybackmode' => { 299 => 0x1a7 },
	'func2buttonplusdials' => { 286 => '81.1' },
	'func3button' => { 286 => '83.1', 299 => 0x119 },
	'func3buttonplaybackmode' => { 299 => 0x1a9 },
	'func4button' => { 299 => 0x175 },
	'func4buttonplaybackmode' => { 299 => 0x1af },
	'funcbutton' => { 283 => ['14.1','15.1'], 284 => '14.1', 292 => '28.1', 293 => '13.1', 296 => '14.1', 298 => '14.1' },
	'funcbuttonplusdials' => { 283 => ['14.2','15.2'], 284 => '14.2', 292 => '31.1', 296 => '42.1' },
	'functionbutton' => { 290 => '13.1', 294 => '5.2' },
	'gainbase' => { 305 => 0x610 },
	'gaincontrol' => { 119 => 0xa407, 488 => 'GainControl' },
	'gamma' => { 119 => 0xa500, 138 => 0x8fe, 312 => 'gAMA', 329 => 0x11c, 489 => 'Gamma' },
	'gammablackpoint' => { 105 => 0xc },
	'gammacolortone' => { 105 => 0x3 },
	'gammacompensatedvalue' => { 133 => 0x91 },
	'gammacontrast' => { 105 => 0x2 },
	'gammacurveoutputrange' => { 105 => 0xf },
	'gammahighlight' => { 105 => 0xa },
	'gammalinear' => { 103 => 0x20200 },
	'gammamidpoint' => { 105 => 0xe },
	'gammasaturation' => { 105 => 0x4 },
	'gammashadow' => { 105 => 0x9 },
	'gammasharpnessstrength' => { 105 => 0x8 },
	'gammaunsharpmaskfineness' => { 105 => 0x6 },
	'gammaunsharpmaskstrength' => { 105 => 0x5 },
	'gammaunsharpmaskthreshold' => { 105 => 0x7 },
	'gammawhitepoint' => { 105 => 0xd },
	'garminsettings' => { 384 => 'pmcc' },
	'garminsoftware' => { 384 => 'uuid' },
	'gdalmetadata' => { 119 => 0xa480 },
	'gdalnodata' => { 119 => 0xa481 },
	'geimagesize' => { 127 => 0x1304 },
	'gemake' => { 129 => 0x300 },
	'gemodel' => { 129 => 0x207 },
	'genre' => { 376 => ['gnre',"\xa9gen"], 378 => 'genre', 384 => ['gnre',"\xa9gen"], 495 => 'Genre', 499 => 'genre', 509 => 'genre' },
	'genrecvid' => { 495 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 495 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 495 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 495 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 376 => 'geID' },
	'geography' => { 500 => 'geography' },
	'geologicalcontext' => { 118 => 'GeologicalContext' },
	'geologicalcontextbed' => { 118 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 118 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 118 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 118 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 118 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 120 => 'Geosync' },
	'geotag' => { 120 => 'Geotag' },
	'geotiffasciiparams' => { 119 => 0x87b1 },
	'geotiffdirectory' => { 119 => 0x87af },
	'geotiffdoubleparams' => { 119 => 0x87b0 },
	'geotime' => { 120 => 'Geotime' },
	'giftftppriority' => { 472 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 116 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 116 => 'GimbalReverse' },
	'gimbalrolldegree' => { 116 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 116 => 'GimbalYawDegree' },
	'globalaltitude' => { 373 => 0x419 },
	'globalangle' => { 373 => 0x40d },
	'good' => { 509 => 'good' },
	'googlehostheader' => { 376 => 'gshh' },
	'googlepingmessage' => { 376 => 'gspm' },
	'googlepingurl' => { 376 => 'gspu' },
	'googleplusuploadcode' => { 119 => 0x9009 },
	'googlesourcedata' => { 376 => 'gssd' },
	'googlestarttime' => { 376 => 'gsst' },
	'googletrackduration' => { 376 => 'gstd' },
	'goprotype' => { 384 => 'GoPr' },
	'gpsaltitude' => { 130 => 0x6, 160 => 'Altitude', 488 => 'GPSAltitude' },
	'gpsaltituderef' => { 130 => 0x5, 488 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 130 => 0x1c, 488 => 'GPSAreaInformation' },
	'gpscoordinates' => { 376 => "\xa9xyz", 378 => 'location.ISO6709', 384 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 130 => 0x1d },
	'gpsdatetime' => { 160 => 'DateTime', 488 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 130 => 0x18, 160 => 'Bearing', 488 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 130 => 0x17, 488 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 130 => 0x1a, 160 => 'Distance', 488 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 130 => 0x19, 488 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 130 => 0x14, 488 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 130 => 0x13 },
	'gpsdestlongitude' => { 130 => 0x16, 488 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 130 => 0x15 },
	'gpsdifferential' => { 130 => 0x1e, 160 => 'Differential', 488 => 'GPSDifferential' },
	'gpsdop' => { 130 => 0xb, 488 => 'GPSDOP' },
	'gpshpositioningerror' => { 130 => 0x1f, 488 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 130 => 0x11, 488 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 130 => 0x10, 488 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 114 => 'GPS-GPSLatitude', 116 => 'GpsLatitude', 130 => 0x2, 160 => 'Latitude', 488 => 'GPSLatitude' },
	'gpslatituderef' => { 130 => 0x1 },
	'gpslongitude' => { 114 => 'GPS-GPSLongitude', 116 => 'GpsLongitude', 130 => 0x4, 160 => 'Longitude', 488 => 'GPSLongitude' },
	'gpslongituderef' => { 130 => 0x3 },
	'gpslongtitude' => { 116 => 'GpsLongtitude' },
	'gpsmapdatum' => { 130 => 0x12, 160 => 'Datum', 488 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 130 => 0xa, 160 => 'MeasureMode', 488 => 'GPSMeasureMode' },
	'gpsposition' => { 114 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 130 => 0x1b, 488 => 'GPSProcessingMethod' },
	'gpssatellites' => { 130 => 0x8, 160 => 'Satellites', 488 => 'GPSSatellites' },
	'gpsspeed' => { 130 => 0xd, 160 => 'Speed', 488 => 'GPSSpeed' },
	'gpsspeedref' => { 130 => 0xc, 488 => 'GPSSpeedRef' },
	'gpsstatus' => { 130 => 0x9, 488 => 'GPSStatus' },
	'gpsstring' => { 138 => 0x402 },
	'gpstimestamp' => { 130 => 0x7 },
	'gpstrack' => { 130 => 0xf, 160 => 'Heading', 488 => 'GPSTrack' },
	'gpstrackref' => { 130 => 0xe, 488 => 'GPSTrackRef' },
	'gpsversionid' => { 130 => 0x0, 488 => 'GPSVersionID' },
	'gradation' => { 301 => 0x50f },
	'gradientbasedcorractive' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 482 => 'GradientBasedCorrections', 484 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 482 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 484 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 482 => 'GrainAmount', 484 => 'GrainAmount' },
	'graineffectroughness' => { 127 => 0x1047 },
	'graineffectsize' => { 127 => 0x104c },
	'grainfrequency' => { 482 => 'GrainFrequency', 484 => 'GrainFrequency' },
	'grainseed' => { 482 => 'GrainSeed', 484 => 'GrainSeed' },
	'grainsize' => { 482 => 'GrainSize', 484 => 'GrainSize' },
	'graymixeraqua' => { 482 => 'GrayMixerAqua', 484 => 'GrayMixerAqua' },
	'graymixerblue' => { 482 => 'GrayMixerBlue', 484 => 'GrayMixerBlue' },
	'graymixergreen' => { 482 => 'GrayMixerGreen', 484 => 'GrayMixerGreen' },
	'graymixermagenta' => { 482 => 'GrayMixerMagenta', 484 => 'GrayMixerMagenta' },
	'graymixerorange' => { 482 => 'GrayMixerOrange', 484 => 'GrayMixerOrange' },
	'graymixerpurple' => { 482 => 'GrayMixerPurple', 484 => 'GrayMixerPurple' },
	'graymixerred' => { 482 => 'GrayMixerRed', 484 => 'GrayMixerRed' },
	'graymixeryellow' => { 482 => 'GrayMixerYellow', 484 => 'GrayMixerYellow' },
	'graypoint' => { 459 => 0x8021 },
	'grayresponseunit' => { 119 => 0x122 },
	'greencurvelimits' => { 108 => 0x1c4 },
	'greencurvepoints' => { 107 => 0x53, 108 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 103 => 0x20913 },
	'greenhue' => { 482 => 'GreenHue', 484 => 'GreenHue' },
	'greensaturation' => { 482 => 'GreenSaturation', 484 => 'GreenSaturation' },
	'griddisplay' => { 283 => '13.3', 284 => '4.3', 286 => '4.2', 287 => '4.2', 288 => '2.2', 292 => '10.5', 293 => '3.4', 294 => '6.1', 296 => '4.4', 297 => '4.2', 298 => '4.2' },
	'gripbatteryadload' => { 338 => 0x5 },
	'gripbatteryadnoload' => { 338 => 0x4 },
	'gripbatterystate' => { 338 => '1.2' },
	'group' => { 482 => 'Group', 484 => 'Group' },
	'groupareaafillumination' => { 284 => '46.4', 287 => '47.4', 296 => '47.4' },
	'grouping' => { 376 => ['grup',"\xa9grp"], 384 => "\xa9grp" },
	'guid' => { 376 => 'GUID' },
	'h2resetblackpixels' => { 138 => 0x18a6 },
	'h3resetblackcolumns' => { 138 => 0x18ce },
	'h3resetblackpixels' => { 138 => 0x18b0 },
	'halftonehints' => { 119 => 0x141 },
	'hardlink' => { 120 => 'HardLink' },
	'hasalternative' => { 499 => 'hasAlternative' },
	'hascorrection' => { 499 => 'hasCorrection' },
	'hascorrectiona-lang' => { 499 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 499 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 499 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 482 => 'HasCrop', 484 => 'HasCrop' },
	'hasextendedxmp' => { 511 => 'HasExtendedXMP' },
	'hassettings' => { 482 => 'HasSettings', 484 => 'HasSettings' },
	'hastranslation' => { 499 => 'hasTranslation' },
	'hasvisibleoverprint' => { 514 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 514 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 230 => 0x35a },
	'hdmioutputresolution' => { 231 => 0x610, 232 => 0x640 },
	'hdmiviewassist' => { 299 => 0x20f },
	'hdr' => { 60 => 0x1, 216 => 0x4, 217 => 0x4, 324 => 0x9e, 359 => 0x85, 424 => 0x200a },
	'hdreditmode' => { 482 => 'HDREditMode', 484 => 'HDREditMode' },
	'hdreffect' => { 60 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 216 => 0x5, 217 => 0x5, 413 => 0x2e, 429 => 0x17 },
	'hdrlevel2' => { 216 => 0x7 },
	'hdrpmakernote' => { 465 => 'hdrp_makernote' },
	'hdrsetting' => { 413 => 0x2d, 429 => 0x16, 433 => 0x1148, 434 => 0x1148, 435 => 0x1124, 436 => 0x11a0, 437 => 0x117c, 438 => 0x1034, 439 => 0x22c, 440 => 0x22c, 441 => 0x21f },
	'hdrshot' => { 324 => 0x76 },
	'hdrsmoothing' => { 216 => 0x6 },
	'hdvideo' => { 376 => 'hdvd' },
	'headline' => { 131 => 0x69, 495 => 'Headline', 497 => 'Headline' },
	'hierarchicalkeywords' => { 171 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 171 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 171 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 171 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 171 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 474 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 232 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 232 => 0x27c },
	'highisomultiplierblue' => { 329 => 0x1a },
	'highisomultipliergreen' => { 329 => 0x19 },
	'highisomultiplierred' => { 329 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 62 => 0x5, 84 => 0x202, 227 => 0xb1, 359 => 0x71, 411 => 0x2c, 412 => 0x26, 413 => 0x26, 424 => 0x2009, 429 => 0x12, 455 => 0x42 },
	'highisonoisereduction2' => { 424 => 0xb050 },
	'highlight' => { 401 => 0xf },
	'highlight2012' => { 482 => 'Highlight2012', 484 => 'Highlight2012' },
	'highlightadj' => { 103 => 0x2030c },
	'highlightcolordistortreduct' => { 459 => 0x8026 },
	'highlightlinearitylimit' => { 398 => 0xa025 },
	'highlightprotection' => { 275 => 0x6 },
	'highlightrecovery' => { 482 => 'HighlightRecovery', 484 => 'HighlightRecovery' },
	'highlights' => { 424 => 0x2033, 476 => 'Highlights' },
	'highlights2012' => { 482 => 'Highlights2012', 484 => 'Highlights2012' },
	'highlightsadj' => { 459 => 0x9019 },
	'highlightshadow' => { 324 => 0xad },
	'highlighttone' => { 127 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 62 => 0x3, 84 => 0x203 },
	'highlightwarning' => { 324 => 0x8002 },
	'highlowkeyadj' => { 359 => 0x6c },
	'highspeedsync' => { 184 => 0x5, 299 => 0x55, 411 => 0x2, 412 => 0x2 },
	'hintversion' => { 384 => 'hinv' },
	'histogramxml' => { 276 => 0x83a1a25 },
	'history' => { 497 => 'History', 510 => 'History' },
	'historyaction' => { 510 => [\'History','HistoryAction'] },
	'historychanged' => { 510 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 510 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 510 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 510 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 510 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 138 => 0xc88 },
	'holefilldeltathreshold' => { 138 => 0xc7e },
	'hometowncity' => { 113 => 0x3006, 359 => 0x23, 365 => 0x2 },
	'hometowncitycode' => { 366 => 0x1000 },
	'hometowndst' => { 359 => 0x25, 365 => '0.2' },
	'hostcomputer' => { 119 => 0x13c },
	'hostsoftwarerendering' => { 138 => 0xce7 },
	'hue' => { 189 => 0x3b, 236 => 0x3d, 237 => 0x45, 359 => 0x67 },
	'hueadj' => { 279 => 0x2f, 459 => 0x8019 },
	'hueadjust' => { 391 => 0x1016 },
	'hueadjustment' => { 182 => 0x4a, 183 => 0x40, 227 => 0x92, 235 => 0x36 },
	'hueadjustmentaqua' => { 482 => 'HueAdjustmentAqua', 484 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 482 => 'HueAdjustmentBlue', 484 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 482 => 'HueAdjustmentGreen', 484 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 482 => 'HueAdjustmentMagenta', 484 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 482 => 'HueAdjustmentOrange', 484 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 482 => 'HueAdjustmentPurple', 484 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 482 => 'HueAdjustmentRed', 484 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 482 => 'HueAdjustmentYellow', 484 => 'HueAdjustmentYellow' },
	'huesetting' => { 309 => 0x1011 },
	'humanobservation' => { 118 => 'HumanObservation' },
	'humanobservationday' => { 118 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 118 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 118 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 118 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 118 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 118 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 118 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 118 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 118 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 118 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 118 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 118 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 118 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 118 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 118 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 118 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 118 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 118 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 118 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 118 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 119 => 0x9401, 489 => 'Humidity' },
	'icc_profile' => { 120 => 'ICC_Profile' },
	'iccprofilename' => { 497 => 'ICCProfile' },
	'iconuri' => { 384 => 'icnu' },
	'idccreativestyle' => { 459 => 0x8000 },
	'idcpreviewlength' => { 459 => 0x202 },
	'idcpreviewstart' => { 459 => 0x201 },
	'identification' => { 118 => 'Identification' },
	'identificationid' => { 118 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 118 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 118 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 118 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 118 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 118 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 118 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 485 => 'identifier', 507 => 'Identifier' },
	'ifcameramodel' => { 138 => 0x9c8 },
	'illuminantdata1' => { 119 => 0xcd35 },
	'illuminantdata2' => { 119 => 0xcd36 },
	'illuminantdata3' => { 119 => 0xcd37 },
	'illumination' => { 294 => '0.5', 386 => 0x48 },
	'imageabsolutex' => { 138 => 0x3fe },
	'imageabsolutey' => { 138 => 0x3ff },
	'imageadjustment' => { 227 => 0x80, 266 => 0x5 },
	'imagealterationconstraints' => { 311 => 'ImageAlterationConstraints' },
	'imagearea' => { 246 => 0x10, 249 => 0x10 },
	'imageareaoffset' => { 359 => 0x38 },
	'imageauthentication' => { 227 => 0x20 },
	'imageboundary' => { 227 => 0x16 },
	'imagecapturereqestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 127 => 0x1438, 227 => 0xa5, 427 => 0x11b },
	'imagecreator' => { 311 => 'ImageCreator' },
	'imagecreatorid' => { 311 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 311 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 311 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 138 => 0x41f },
	'imagecropy' => { 138 => 0x420 },
	'imagedata' => { 469 => 'Data' },
	'imagedatasize' => { 227 => 0xa2 },
	'imagedescription' => { 119 => 0x10e, 505 => 'ImageDescription' },
	'imageduplicationconstraints' => { 311 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 276 => 0xfe443a45 },
	'imageeditcount' => { 359 => 0x41 },
	'imageediting' => { 359 => 0x32 },
	'imageeffects' => { 391 => 0x1010 },
	'imagefileconstraints' => { 311 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 311 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 311 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 127 => 0x1436 },
	'imageheight' => { 119 => 0x101, 188 => 0xc, 368 => 0x10d, 467 => 'ImageHeight', 505 => 'ImageLength' },
	'imagehistory' => { 119 => 0x9213, 487 => 'ImageHistory' },
	'imageidnumber' => { 319 => 0x340 },
	'imagemimetype' => { 469 => 'Mime' },
	'imagenumber' => { 119 => 0x9211, 156 => 'ImageNumber', 182 => 0xae, 183 => 0x5e, 368 => 0x113, 411 => 0x9b, 413 => [0x400,'276.1',0x314], 479 => 'ImageNumber' },
	'imagenumber2' => { 183 => 0x62 },
	'imageoptimization' => { 227 => 0xa9 },
	'imageorientation' => { 131 => 0x83 },
	'imageprocessing' => { 227 => 0x1a },
	'imageprocessingfiledatecreated' => { 138 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 138 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 305 => 0x0 },
	'imagequality' => { 156 => 'ImageQuality', 248 => '723.2', 249 => '732.2', 259 => '708.1', 324 => 0x1 },
	'imagequality2' => { 301 => 0x603 },
	'imagerank' => { 472 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 138 => 0x600 },
	'imagerboardversion' => { 138 => 0x439 },
	'imagercols' => { 138 => 0x17d4 },
	'imageref' => { 493 => 'ImageRef' },
	'imageregion' => { 495 => 'ImageRegion' },
	'imageregionboundary' => { 495 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 495 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 495 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 495 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 495 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 495 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 495 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 495 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 495 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 495 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 138 => 0x944 },
	'imageresolutionjpg' => { 138 => 0x945 },
	'imagereview' => { 285 => '0.4', 294 => '0.4' },
	'imagereviewmonitorofftime' => { 284 => '21.1', 286 => '21.1', 287 => '21.1', 291 => '20.1', 296 => '21.1', 297 => '21.1', 299 => 0x39 },
	'imagereviewtime' => { 283 => '25.1', 285 => '2.1', 288 => '19.1', 289 => '20.1', 290 => '20.1', 292 => '9.2', 293 => '20.1', 298 => '21.2' },
	'imagerfiledatecreated' => { 138 => 0x9c5 },
	'imagerfileproductionlevel' => { 138 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 138 => 0x9c7 },
	'imagerotated' => { 151 => 0x2a },
	'imagerpowerondelaymsec' => { 138 => 0x5fd },
	'imagerrows' => { 138 => 0x17de },
	'imagesegmentlines' => { 138 => 0x184d },
	'imagesegmentstartline' => { 138 => 0x184c },
	'imagesize' => { 162 => 'ImageSize' },
	'imagesizeraw' => { 227 => 0x3e },
	'imagesizerestriction' => { 502 => 'imageSizeRestriction' },
	'imagesourcedata' => { 119 => 0x935c },
	'imagespace' => { 138 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 113 => 0x3020, 127 => 0x1422, 156 => 'ImageStabilization', 182 => 0xbd, 183 => 0x71, 184 => 0x57, 185 => 0x0, 186 => [0x18,0x107,0x113], 187 => 0x49c2, 227 => 0xac, 301 => 0x604, 304 => 0x1600, 324 => 0x1a, 416 => 0x12, 417 => 0x11, 424 => 0xb026 },
	'imagestabilization2' => { 415 => 0xa },
	'imagestabilizationsetting' => { 187 => 0x14, 411 => 0x3d, 412 => 0x3d, 422 => 0x14 },
	'imagestyle' => { 411 => 0x2d, 412 => 0x27 },
	'imagesupplier' => { 311 => 'ImageSupplier' },
	'imagesupplierid' => { 311 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 311 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 311 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 121 => 0x1 },
	'imagetemperaturemin' => { 121 => 0x2 },
	'imagetone' => { 359 => 0x4f },
	'imagetype' => { 131 => 0x82, 311 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 64 => 0x28, 119 => 0xa420, 487 => 'ImageUniqueID', 488 => 'ImageUniqueID' },
	'imagewidth' => { 119 => 0x100, 188 => 0xe, 368 => 0x10c, 467 => 'ImageWidth', 505 => 'ImageWidth' },
	'inclinationangle' => { 459 => 0x900f },
	'inclinationcorrection' => { 459 => 0x900e },
	'incrementaltemperature' => { 482 => 'IncrementalTemperature', 484 => 'IncrementalTemperature' },
	'incrementaltint' => { 482 => 'IncrementalTint', 484 => 'IncrementalTint' },
	'industry' => { 499 => 'industry', 500 => 'industry' },
	'infobuttonwhenshooting' => { 84 => 0x409 },
	'information' => { 378 => 'information', 384 => "\xa9inf" },
	'infourl' => { 384 => 'infu' },
	'infraredilluminator' => { 385 => 0x28 },
	'ingredientexclusion' => { 501 => 'ingredientExclusion' },
	'ingredients' => { 510 => 'Ingredients' },
	'ingredientsalternatepaths' => { 510 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 510 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 510 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 510 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 510 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 510 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 510 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 510 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 510 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 510 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 510 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 510 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 510 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 510 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 510 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 510 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 510 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 510 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 510 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 510 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 510 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 510 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 510 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 84 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 470 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 470 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 179 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 470 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 470 => 'InitialViewHeadingDegrees', 471 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 470 => 'InitialViewPitchDegrees', 471 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 470 => 'InitialViewRollDegrees', 471 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 283 => '4.4' },
	'initialzoomsetting' => { 283 => '9.3', 292 => '27.3' },
	'inkset' => { 119 => 0x14c },
	'inputprofile' => { 138 => 0x1389 },
	'instanceid' => { 510 => 'InstanceID' },
	'instantplaybacksetup' => { 184 => 0x3e },
	'instantplaybacktime' => { 184 => 0x3d },
	'instructions' => { 497 => 'Instructions' },
	'instrument' => { 509 => 'instrument' },
	'integrationtime' => { 138 => 0x423 },
	'intellectualgenre' => { 494 => 'IntellectualGenre' },
	'intelligentauto' => { 424 => 0xb052, 451 => 0xd, 452 => 0xe, 453 => 0xd },
	'intelligentcontrast' => { 52 => 0x4 },
	'intelligentd-range' => { 324 => 0x79 },
	'intelligentexposure' => { 324 => 0x5d },
	'intelligentresolution' => { 324 => 0x70 },
	'interchangecolorspace' => { 133 => 0x40 },
	'intergraphmatrix' => { 119 => 0x8480 },
	'internalflash' => { 181 => 0x2b, 283 => '23.1', 285 => '8.1', 288 => '22.1', 290 => '23.1', 294 => '8.1', 298 => '24.1', 304 => 0x1208 },
	'internalflashae1' => { 306 => 0x1021 },
	'internalflashae1_0' => { 306 => 0x101d },
	'internalflashae2' => { 306 => 0x1022 },
	'internalflashae2_0' => { 306 => 0x101e },
	'internalflashmode' => { 347 => 0x1 },
	'internalflashstrength' => { 347 => 0x3 },
	'internalflashtable' => { 306 => 0x1024 },
	'internallensserialnumber' => { 398 => 0xa005 },
	'internalndfilter' => { 324 => 0x9d },
	'internalserialnumber' => { 64 => 0x96, 76 => 0x9, 127 => 0x10, 187 => 0x49dc, 300 => 0x18, 302 => 0x102, 321 => 0x500, 324 => 0x25, 339 => 0x4, 391 => 0x5, 443 => [0x7c,0xf0], 444 => 0x88, 445 => [0x88,0x8a] },
	'interopindex' => { 119 => 0x1, 489 => 'InteroperabilityIndex' },
	'interopversion' => { 119 => 0x2 },
	'interval' => { 252 => 0xd0 },
	'intervaldurationhours' => { 230 => 0xa0 },
	'intervaldurationminutes' => { 230 => 0xa4 },
	'intervaldurationseconds' => { 230 => 0xa8 },
	'intervalexposuresmoothing' => { 230 => 0xb8, 256 => 0xc416 },
	'intervalframe' => { 252 => 0xd4 },
	'intervallength' => { 181 => 0x10 },
	'intervalmode' => { 181 => 0x26 },
	'intervalnumber' => { 181 => 0x11 },
	'intervalpriority' => { 230 => 0xba, 256 => 0xc418 },
	'intervals' => { 230 => 0xb0, 231 => 0xbc, 232 => 0xcc, 256 => 0xc40e },
	'intervalshooting' => { 256 => 0x760c, 264 => 0x760c, 265 => 0xbc, 359 => 0x92 },
	'introtime' => { 509 => 'introTime' },
	'introtimescale' => { 509 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 509 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 138 => 0xdae },
	'ipfcameramodel' => { 138 => 0xe4d },
	'iptc' => { 120 => 'IPTC' },
	'iptc-naa' => { 119 => 0x83bb, 329 => 0x83bb },
	'iptcbitspersample' => { 133 => 0x56 },
	'iptcdigest' => { 373 => 0x425 },
	'iptcimageheight' => { 133 => 0x1e },
	'iptcimagerotation' => { 133 => 0x66 },
	'iptcimagewidth' => { 133 => 0x14 },
	'iptclastedited' => { 495 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 133 => 0xa },
	'iptcpixelheight' => { 133 => 0x32 },
	'iptcpixelwidth' => { 133 => 0x28 },
	'isalternativeof' => { 499 => 'isAlternativeOf' },
	'isbn' => { 499 => 'isbn' },
	'iscorrectionof' => { 499 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 109 => 0x3 },
	'ismergedhdr' => { 479 => 'IsMergedHDR' },
	'ismergedpanorama' => { 479 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 112 => 0x14, 113 => [0x3014,0x14], 119 => 0x8827, 137 => 0xfd06, 138 => 0x1784, 140 => 0x60, 142 => [0xfa2e,0xfa46], 143 => [0x27,0x28], 144 => 0xf105, 147 => 0x14, 149 => 0x4e, 151 => 0x1e, 152 => 0x1a, 154 => 0x34, 156 => 'ISO', 181 => 0x8, 187 => 0x49ba, 218 => 0x0, 227 => 0x2, 324 => 0xd1, 329 => 0x17, 359 => [0x8b,0x14], 366 => 0x14, 368 => 0x105, 398 => 0xa014, 401 => 0x86, 422 => 0x6f, 429 => [0x1f,0x21,0x25], 488 => 'ISOSpeedRatings' },
	'iso2' => { 218 => 0x6, 243 => 0x265, 244 => 0x25c, 245 => 0x265, 246 => 0x221, 247 => 0x25d, 248 => 0x256, 249 => 0x25d, 253 => 0x2b5, 257 => 0x265, 263 => 0x2b5 },
	'isoauto' => { 340 => '14.4' },
	'isoautoflashlimit' => { 231 => 0x146, 232 => 0x15a },
	'isoautohilimit' => { 231 => 0x144, 232 => 0x158, 251 => 0x18eb, 252 => 0xe82, 261 => 0x185d },
	'isoautomax' => { 423 => 0x4 },
	'isoautomin' => { 423 => 0x2 },
	'isoautoparameters' => { 359 => 0x7a },
	'isoautoshuttertime' => { 231 => 0x14e, 232 => 0x162, 251 => 0x18ea, 252 => 0xe81, 261 => 0x185c },
	'isocalibrationgain' => { 138 => 0x89f },
	'isodisplay' => { 286 => '4.1', 287 => '4.1', 288 => '2.3', 289 => '3.3', 290 => '3.3', 293 => '3.3', 296 => '4.3', 297 => '4.1', 298 => '4.3' },
	'isoexpansion' => { 84 => 0x103, 85 => 0x7, 86 => 0x8, 89 => 0x8, 218 => 0x4 },
	'isoexpansion2' => { 218 => 0xa },
	'isofloor' => { 340 => 0x6 },
	'isoselected' => { 323 => 0x359 },
	'isoselection' => { 227 => 0xf },
	'isosensitivitystep' => { 291 => '6.2', 293 => '6.2' },
	'isosetting' => { 140 => 0x5e, 152 => 0x14, 156 => 'ISOSetting', 181 => 0x24, 182 => 0x26, 183 => 0x1c, 184 => 0x13, 189 => 0x6, 227 => 0x13, 340 => '17.3', 390 => 0x27, 411 => 0x16, 412 => 0x14, 413 => 0x2, 422 => 0x6d, 423 => 0x0 },
	'isospeed' => { 119 => 0x8833, 489 => 'ISOSpeed' },
	'isospeedexpansion' => { 83 => 0x3 },
	'isospeedincrements' => { 84 => 0x102 },
	'isospeedlatitudeyyy' => { 119 => 0x8834, 489 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 119 => 0x8835, 489 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 84 => 0x103 },
	'isostepsize' => { 283 => '6.1', 284 => '7.2', 286 => '7.2', 287 => '7.2', 292 => '4.1', 296 => '7.2', 297 => '7.2', 299 => 0x15d },
	'isovalue' => { 306 => 0x1001 },
	'isrccode' => { 384 => "\xa9isr" },
	'issn' => { 499 => 'issn' },
	'issueidentifier' => { 499 => 'issueIdentifier' },
	'issuename' => { 499 => 'issueName' },
	'issueteaser' => { 499 => 'issueTeaser' },
	'issuetype' => { 499 => 'issueType' },
	'istranslationof' => { 499 => 'isTranslationOf' },
	'itemsubtype' => { 178 => 'ItemSubType' },
	'itunesu' => { 376 => 'itnu' },
	'jobid' => { 131 => 0xb8 },
	'jobname' => { 490 => 'JobName' },
	'jobref' => { 508 => 'JobRef' },
	'jobrefid' => { 508 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 508 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 508 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 490 => 'JobStatus' },
	'jpeg-heifswitch' => { 424 => 0x2039 },
	'jpeghandling' => { 482 => 'JPEGHandling', 484 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 324 => 0x43, 326 => 0x3034, 424 => 0xb047 },
	'jpegsize' => { 326 => 0x303a },
	'jpgcompression' => { 252 => 0x7d4 },
	'jpgfromraw' => { 97 => 0x2007, 114 => 'Exif-JpgFromRaw', 329 => 0x2e },
	'jpgfromrawlength' => { 119 => [0x117,0x202] },
	'jpgfromrawstart' => { 119 => [0x111,0x201] },
	'jpgrecordedpixels' => { 340 => '14.1' },
	'jurisdiction' => { 480 => 'jurisdiction' },
	'keepexposure' => { 299 => 0x237 },
	'kelvinwb_01' => { 348 => 0x5 },
	'kelvinwb_02' => { 348 => 0x9 },
	'kelvinwb_03' => { 348 => 0xd },
	'kelvinwb_04' => { 348 => 0x11 },
	'kelvinwb_05' => { 348 => 0x15 },
	'kelvinwb_06' => { 348 => 0x19 },
	'kelvinwb_07' => { 348 => 0x1d },
	'kelvinwb_08' => { 348 => 0x21 },
	'kelvinwb_09' => { 348 => 0x25 },
	'kelvinwb_10' => { 348 => 0x29 },
	'kelvinwb_11' => { 348 => 0x2d },
	'kelvinwb_12' => { 348 => 0x31 },
	'kelvinwb_13' => { 348 => 0x35 },
	'kelvinwb_14' => { 348 => 0x39 },
	'kelvinwb_15' => { 348 => 0x3d },
	'kelvinwb_16' => { 348 => 0x41 },
	'kelvinwb_daylight' => { 348 => 0x1 },
	'kerneldenominators' => { 138 => 0x933 },
	'key' => { 509 => 'key' },
	'keystonecompensation' => { 305 => 0x1900 },
	'keystonedirection' => { 305 => 0x1901 },
	'keystonevalue' => { 305 => 0x1906 },
	'keyword' => { 376 => 'keyw', 499 => 'keyword' },
	'keywordinfo' => { 171 => 'Keywords' },
	'keywords' => { 131 => 0x19, 157 => 'Keywords', 310 => 'Keywords', 375 => 'Keywords', 378 => 'keywords', 477 => 'keywords', 496 => 'Keywords', 507 => 'Keywords' },
	'killdate' => { 499 => 'killDate' },
	'killdatea-platform' => { 499 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 499 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 137 => 0xf908, 140 => 0xe, 142 => [0xfa1e,0xfa52], 148 => 0x70 },
	'kodakimagewidth' => { 137 => 0xf907, 140 => 0xc, 142 => [0xfa1d,0xfa51], 148 => 0x6c },
	'kodakinfotype' => { 137 => 0xfa00 },
	'kodaklook' => { 138 => 0xe4c },
	'kodaklookprofile' => { 138 => 0x138a },
	'kodakmaker' => { 148 => 0x8 },
	'kodakmodel' => { 140 => 0x0, 148 => 0x28 },
	'kodaktag' => { 138 => 0x3ea },
	'kodakversion' => { 138 => 0x0 },
	'label' => { 314 => 'Label', 507 => 'Label' },
	'labelname1' => { 493 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 493 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 324 => 0x6f },
	'landscapeoutputhighlightpoint' => { 109 => 0x26 },
	'landscapeoutputshadowpoint' => { 109 => 0x27 },
	'landscaperawcolortone' => { 109 => 0x1f },
	'landscaperawcontrast' => { 109 => 0x21 },
	'landscaperawhighlight' => { 109 => 0x77 },
	'landscaperawhighlightpoint' => { 109 => 0x24 },
	'landscaperawlinear' => { 109 => 0x22 },
	'landscaperawsaturation' => { 109 => 0x20 },
	'landscaperawshadow' => { 109 => 0x80 },
	'landscaperawshadowpoint' => { 109 => 0x25 },
	'landscaperawsharpness' => { 109 => 0x23 },
	'landscapeunsharpmaskfineness' => { 109 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 109 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 109 => 0xa2 },
	'language' => { 231 => 0x592, 232 => 0x5c2, 485 => 'language' },
	'languageidentifier' => { 131 => 0x87 },
	'largestvalidinteriorrectheight' => { 470 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 470 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 470 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 470 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 181 => 0x1b },
	'lastkeywordiptc' => { 178 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 178 => 'LastKeywordXMP' },
	'lastphotodate' => { 470 => 'LastPhotoDate' },
	'lasturl' => { 510 => 'LastURL' },
	'lateralchromaticaberration' => { 424 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 479 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 118 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 118 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 118 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 116 => 'Latitude' },
	'lc1' => { 350 => 0x2 },
	'lc10' => { 350 => 0xb },
	'lc11' => { 350 => 0xc },
	'lc12' => { 350 => 0xd },
	'lc14' => { 350 => 0xf },
	'lc15' => { 350 => 0x10 },
	'lc3' => { 350 => 0x4 },
	'lc4' => { 350 => 0x5 },
	'lc5' => { 350 => 0x6 },
	'lc6' => { 350 => 0x7 },
	'lc7' => { 350 => 0x8 },
	'lc8' => { 350 => 0x9 },
	'lcddisplayatpoweron' => { 84 => 0x811, 88 => 0xa },
	'lcddisplayreturntoshoot' => { 89 => 0x12 },
	'lcdillumination' => { 283 => '17.5', 284 => '5.2', 286 => '5.1', 287 => '5.1', 292 => '10.3', 293 => '4.2', 296 => '5.2', 297 => '5.1', 298 => '5.4', 299 => 0x101 },
	'lcdilluminationduringbulb' => { 84 => 0x408 },
	'lcdmatrix' => { 138 => 0xe74 },
	'lcdmatrixchickfix' => { 138 => 0xe75 },
	'lcdmatrixmarvin' => { 138 => 0xe76 },
	'lcdpanels' => { 83 => 0x8 },
	'lcheditor' => { 276 => 0x8ae85e },
	'legacyiptcdigest' => { 497 => 'LegacyIPTCDigest' },
	'legalcode' => { 480 => 'legalcode' },
	'lens' => { 119 => 0xfdea, 227 => 0x84, 479 => 'Lens' },
	'lensafstopbutton' => { 82 => 0x11, 83 => 0x13, 84 => 0x506, 85 => 0x10, 86 => 0x12, 89 => 0x13, 90 => 0x9 },
	'lensaperturerange' => { 401 => [0x30,0x48] },
	'lenscontrolring' => { 299 => 0xad },
	'lenscorrectionsettings' => { 487 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 479 => 'LensDistortInfo' },
	'lensdistortionparams' => { 306 => 0x206 },
	'lensdriveend' => { 225 => 0x56 },
	'lensdrivenoaf' => { 84 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 413 => 0x3f0, 458 => 0xd },
	'lensfirmware' => { 392 => 0x20, 398 => 0xa004 },
	'lensfirmwareversion' => { 302 => 0x204, 324 => 0x60, 413 => 0x3f3, 458 => 0x14 },
	'lensfocallength' => { 103 => 0xf0512, 350 => 0x9 },
	'lensfocalrange' => { 401 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 284 => '55.1', 286 => '52.1', 287 => '52.1', 296 => '52.1', 297 => '52.1' },
	'lensformat' => { 437 => 0x1891, 439 => 0x18bd, 440 => 0x18ed, 441 => 0x17f1, 443 => 0x106, 444 => 0x106, 454 => 0x603, 455 => 0x5d },
	'lensfstops' => { 219 => 0x7, 220 => 0xc, 221 => 0xd, 225 => 0xe, 227 => 0x8b, 350 => '0.3' },
	'lensfunc1button' => { 299 => 0x9f },
	'lensfunc2button' => { 299 => 0xa7 },
	'lensid' => { 225 => 0x30, 479 => 'LensID' },
	'lensidnumber' => { 219 => 0x6, 220 => 0xb, 221 => 0xc, 225 => 0xd },
	'lensinfo' => { 119 => 0xa432, 356 => 0x2a, 479 => 'LensInfo', 489 => 'LensSpecification' },
	'lenskind' => { 350 => 0x1 },
	'lensmake' => { 119 => 0xa433, 163 => 'Make', 489 => 'LensMake' },
	'lensmanualdistortionamount' => { 482 => 'LensManualDistortionAmount', 484 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 178 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 401 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 64 => 0x95, 119 => 0xa434, 163 => 'Model', 178 => 'LensModel', 222 => 0x18a, 223 => 0x18b, 224 => 0x2ac, 302 => 0x203, 356 => 0xc, 368 => 0x412, 489 => 'LensModel' },
	'lensmodulationoptimizer' => { 127 => 0x1045 },
	'lensmount' => { 413 => 0x99, 437 => 0x1892, 439 => 0x18be, 440 => 0x18ee, 441 => 0x17f2, 443 => 0x105, 444 => 0x105, 454 => 0x604, 455 => 0x5e },
	'lensmount2' => { 458 => 0x8 },
	'lensmounttype' => { 225 => 0x35 },
	'lenspositionabsolute' => { 225 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 482 => 'LensProfileChromaticAberrationScale', 484 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 482 => 'LensProfileDigest', 484 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 482 => 'LensProfileDistortionScale', 484 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 482 => 'LensProfileEnable', 484 => 'LensProfileEnable' },
	'lensprofilefilename' => { 482 => 'LensProfileFilename', 484 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 482 => 'LensProfileIsEmbedded', 484 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 482 => 'LensProfileMatchKeyCameraModelName', 484 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 482 => 'LensProfileMatchKeyExifMake', 484 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 482 => 'LensProfileMatchKeyExifModel', 484 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 482 => 'LensProfileMatchKeyIsRaw', 484 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 482 => 'LensProfileMatchKeyLensID', 484 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 482 => 'LensProfileMatchKeyLensInfo', 484 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 482 => 'LensProfileMatchKeyLensName', 484 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 482 => 'LensProfileMatchKeySensorFormatFactor', 484 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 482 => 'LensProfileName', 484 => 'LensProfileName' },
	'lensprofilesetup' => { 482 => 'LensProfileSetup', 484 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 482 => 'LensProfileVignettingScale', 484 => 'LensProfileVignettingScale' },
	'lensproperties' => { 302 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 61 => 0x0, 119 => 0xa435, 163 => 'SerialNumber', 302 => 0x202, 322 => 0x321, 324 => 0x52, 384 => 'LENS', 392 => 0x30, 479 => 'LensSerialNumber', 489 => 'LensSerialNumber' },
	'lensshutterlock' => { 184 => 0x4a },
	'lensspec' => { 408 => 0x0, 409 => 0x0, 410 => 0x0, 424 => 0xb02a },
	'lensspecfeatures' => { 443 => [0x115,0x116], 444 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 306 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 186 => 0x10c, 187 => 0x49bd, 227 => 0x83, 302 => 0x201, 315 => 0x16, 319 => 0x310, 321 => 0x303, 322 => 0x303, 324 => 0x51, 326 => 0x3405, 351 => 0x0, 352 => 0x0, 353 => 0x1, 354 => 0x1, 355 => 0x1, 357 => 0x0, 398 => 0xa003, 401 => 0x27, 424 => 0xb027, 437 => 0x1896, 439 => 0x18c2, 440 => 0x18f2, 441 => 0x17f6, 443 => 0x109, 444 => 0x109, 454 => 0x608, 455 => 0x62 },
	'lenstype2' => { 413 => 0x3f7, 437 => 0x1893, 439 => 0x18bf, 440 => 0x18ef, 441 => 0x17f3, 443 => 0x107, 444 => 0x107, 454 => 0x605, 455 => 0x60 },
	'lenstype3' => { 458 => 0x9 },
	'lenstypemake' => { 324 => 0xc4 },
	'lenstypemodel' => { 324 => [0xc5,0xe4] },
	'lenszoomposition' => { 451 => 0x19, 452 => 0x1e, 455 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 332 => 0x15 },
	'levelmeter' => { 384 => ['Lvlm','lvlm'] },
	'levelorientation' => { 358 => 0x0 },
	'license' => { 480 => 'license' },
	'licensee' => { 311 => 'Licensee' },
	'licenseeid' => { 311 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 311 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 311 => 'LicenseeImageNotes' },
	'licenseename' => { 311 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 311 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 311 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 311 => 'LicenseeTransactionID' },
	'licenseid' => { 311 => 'LicenseID' },
	'licensestartdate' => { 311 => 'LicenseStartDate' },
	'licensetransactiondate' => { 311 => 'LicenseTransactionDate' },
	'licensetype' => { 486 => 'licensetype' },
	'licensor' => { 311 => 'Licensor' },
	'licensorcity' => { 311 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 311 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 311 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 311 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 311 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 311 => 'LicensorImageID' },
	'licensorname' => { 311 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 311 => 'LicensorNotes' },
	'licensorpostalcode' => { 311 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 311 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 311 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 311 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 311 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 311 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 311 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 311 => 'LicensorTransactionID' },
	'licensorurl' => { 311 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 306 => 0x1009 },
	'lightingmode' => { 113 => 0x302a },
	'lightreading' => { 359 => 0x15 },
	'lightsource' => { 119 => 0x9208, 227 => 0x90, 309 => 0x1000, 488 => 'LightSource' },
	'lightsourcespecial' => { 400 => 0x21d },
	'lightswitch' => { 296 => '0.1', 298 => '0.1' },
	'lightvaluecenter' => { 306 => 0x103d },
	'lightvalueperiphery' => { 306 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 299 => 0x153 },
	'limitaf-areamodeseldynamic_l' => { 299 => 0x151 },
	'limitaf-areamodeseldynamic_m' => { 299 => 0x150 },
	'limitaf-areamodeseldynamic_s' => { 299 => 0x14f },
	'limitaf-areamodeselpinpoint' => { 299 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 299 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 299 => 0x13 },
	'limitafareamodeselauto' => { 299 => 0x15 },
	'limitafareamodeselection' => { 284 => '51.1', 286 => '49.1', 287 => '49.1', 296 => '49.1', 297 => '49.1' },
	'limitreleasemodeselc120' => { 299 => '269.4' },
	'limitreleasemodeselc30' => { 299 => '269.3' },
	'limitreleasemodeselch' => { 299 => '269.2' },
	'limitreleasemodeselcl' => { 299 => '269.1' },
	'limitreleasemodeselself' => { 299 => '269.5' },
	'limitselectableimagearea16to9' => { 299 => 0x47 },
	'limitselectableimagearea1to1' => { 299 => 0x46 },
	'limitselectableimageareadx' => { 299 => 0x45 },
	'linearitylimitblue' => { 329 => 0x10 },
	'linearitylimitgreen' => { 329 => 0xf },
	'linearitylimitred' => { 329 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 42 => 0x282, 45 => [0x2ba,0x2d1,0x2d5], 47 => 0x1e5, 48 => [0x1fe,0x2de], 49 => [0x232,0x310], 50 => 0x31e },
	'linearizationtable' => { 119 => 0xc618 },
	'linearresponselimit' => { 119 => 0xc62e },
	'link' => { 499 => 'link' },
	'linkaetoafpoint' => { 340 => '14.2' },
	'linkedencodedrightsexpr' => { 495 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 495 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 495 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 495 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 138 => 0x904 },
	'lithostratigraphicterms' => { 118 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 378 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 378 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 378 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 288 => '32.1', 298 => '34.1' },
	'liveviewafareamode' => { 293 => '34.1' },
	'liveviewafmethod' => { 429 => 0x20 },
	'liveviewafmode' => { 293 => '34.2' },
	'liveviewafsetting' => { 413 => 0x36 },
	'liveviewbuttonoptions' => { 284 => '50.2', 286 => '48.2', 287 => '48.2', 296 => '48.2', 297 => '48.2' },
	'liveviewexposuresimulation' => { 84 => 0x810 },
	'liveviewfocusmode' => { 413 => [0x8b,0x28b] },
	'liveviewmetering' => { 413 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 284 => '21.2', 286 => '21.2', 287 => '21.2', 289 => '20.2', 290 => '20.2', 291 => '20.2', 293 => '20.2', 296 => '21.2', 297 => '21.2' },
	'liveviewshooting' => { 57 => 0x13 },
	'livingspecimen' => { 118 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 118 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 131 => 0x79 },
	'localizedcameramodel' => { 119 => 0xc615 },
	'locallocationname' => { 398 => 0x30 },
	'location' => { 226 => 0x9, 324 => 0x67, 475 => 'Location', 494 => 'Location', 498 => 'location', 499 => 'location' },
	'locationaccuracyhorizontal' => { 378 => 'location.accuracy.horizontal' },
	'locationareacode' => { 481 => 'lac' },
	'locationbody' => { 378 => 'location.body' },
	'locationcreated' => { 495 => 'LocationCreated' },
	'locationcreatedcity' => { 495 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 495 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 495 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 495 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 495 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 495 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 495 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 495 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 495 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 495 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 495 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 495 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 378 => 'location.date' },
	'locationinformation' => { 384 => 'loci' },
	'locationinfoversion' => { 226 => 0x0 },
	'locationname' => { 378 => 'location.name', 398 => 0x31 },
	'locationnote' => { 378 => 'location.note' },
	'locationrole' => { 378 => 'location.role' },
	'locationshown' => { 495 => 'LocationShown' },
	'locationshowncity' => { 495 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 495 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 495 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 495 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 495 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 495 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 495 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 495 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 495 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 495 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 495 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 495 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 84 => 0x709 },
	'logcomment' => { 509 => 'logComment' },
	'logscale' => { 138 => 0x902 },
	'longdescription' => { 376 => 'ldes' },
	'longexposurenoisereduction' => { 62 => 0x4, 84 => 0x201, 85 => 0x1, 86 => 0x2, 87 => 0x1, 88 => 0x1, 89 => 0x2, 90 => 0x1, 324 => 0x49, 411 => 0x2b, 412 => 0x25, 413 => 0x25, 424 => 0x2008, 429 => 0x11, 455 => 0x44 },
	'longexposurenoisereduction2' => { 57 => 0x8 },
	'longexposurenrused' => { 324 => 0xbe },
	'longitude' => { 116 => 'Longitude' },
	'look' => { 482 => 'Look', 484 => 'Look' },
	'lookamount' => { 482 => [\'Look','LookAmount'], 484 => [\'Look','LookAmount'] },
	'lookcluster' => { 482 => [\'Look','LookCluster'], 484 => [\'Look','LookCluster'] },
	'lookcopyright' => { 482 => [\'Look','LookCopyright'], 484 => [\'Look','LookCopyright'] },
	'lookgroup' => { 482 => [\'Look','LookGroup'], 484 => [\'Look','LookGroup'] },
	'lookname' => { 482 => 'LookName', 484 => 'LookName' },
	'lookparameters' => { 482 => [\'Look','LookParameters'], 484 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 482 => [\'Look','LookParametersCameraProfile'], 484 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 482 => [\'Look','LookParametersClarity2012'], 484 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 482 => [\'Look','LookParametersConvertToGrayscale'], 484 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 482 => [\'Look','LookParametersLookTable'], 484 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 482 => [\'Look','LookParametersProcessVersion'], 484 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 482 => [\'Look','LookParametersToneCurvePV2012'], 484 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 482 => [\'Look','LookParametersToneCurvePV2012Blue'], 484 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 482 => [\'Look','LookParametersToneCurvePV2012Green'], 484 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 482 => [\'Look','LookParametersToneCurvePV2012Red'], 484 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 482 => [\'Look','LookParametersVersion'], 484 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 482 => [\'Look','LookSupportsAmount'], 484 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 482 => [\'Look','LookSupportsMonochrome'], 484 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 482 => [\'Look','LookSupportsOutputReferred'], 484 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 482 => [\'Look','LookUUID'], 484 => [\'Look','LookUUID'] },
	'loop' => { 509 => 'loop' },
	'loopstyle' => { 384 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 482 => 'LuminanceAdjustmentAqua', 484 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 482 => 'LuminanceAdjustmentBlue', 484 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 482 => 'LuminanceAdjustmentGreen', 484 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 482 => 'LuminanceAdjustmentMagenta', 484 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 482 => 'LuminanceAdjustmentOrange', 484 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 482 => 'LuminanceAdjustmentPurple', 484 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 482 => 'LuminanceAdjustmentRed', 484 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 482 => 'LuminanceAdjustmentYellow', 484 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 108 => 0x150 },
	'luminancecurvepoints' => { 108 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 103 => 0x20600, 109 => 0x5f, 401 => 0x1b },
	'luminancenoisereductioncontrast' => { 482 => 'LuminanceNoiseReductionContrast', 484 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 482 => 'LuminanceNoiseReductionDetail', 484 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 109 => 0x6d },
	'luminancesmoothing' => { 482 => 'LuminanceSmoothing', 484 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 84 => [0x40b,0x40c] },
	'lyrics' => { 376 => "\xa9lyr", 384 => "\xa9lyr", 509 => 'lyrics' },
	'lyricsuri' => { 384 => 'lrcu' },
	'm16cversion' => { 319 => 0x333 },
	'macatom' => { 483 => 'macAtom' },
	'macatomapplicationcode' => { 483 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 483 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 483 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 118 => 'MachineObservation' },
	'machineobservationday' => { 118 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 118 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 118 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 118 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 118 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 118 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 118 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 118 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 118 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 118 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 118 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 118 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 118 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 118 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 118 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 118 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 118 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 118 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 118 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 118 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 127 => 0x1020, 129 => 0x202, 151 => 0x2b, 306 => 0x202, 390 => 0x21, 400 => 0x202, 424 => 0xb040 },
	'macroled' => { 304 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 57 => 0x10 },
	'macromode' => { 34 => 0x1, 181 => 0xb, 301 => 0x300, 324 => 0x1c, 391 => 0x1009 },
	'magentahsl' => { 103 => 0x20917 },
	'magicfilter' => { 301 => 0x52c },
	'magnifiedview' => { 86 => 0x11, 88 => 0x9 },
	'mainboardversion' => { 138 => 0x438 },
	'maindialexposurecomp' => { 294 => '0.6' },
	'mainingredient' => { 501 => 'mainIngredient' },
	'majorversion' => { 473 => 'MajorVersion' },
	'make' => { 98 => 0x0, 115 => 0x1, 119 => 0x10f, 156 => 'Make', 314 => 'Make', 329 => 0x10f, 378 => 'make', 384 => ['@mak',"\xa9mak"], 498 => 'make', 505 => 'Make' },
	'makernote' => { 488 => 'MakerNote' },
	'makernoteapple' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecanon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedji' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedjiinfo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteflir' => { 117 => 'MakN', 119 => 0x927c },
	'makernotefujifilm' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehasselblad' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteisl' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvc' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvctext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak10' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak11' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak12' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak7' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8c' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak9' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodakunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekyocera' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica10' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica3' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica4' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica5' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica7' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica8' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica9' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotemotorola' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenintendo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteoffset' => { 400 => 0xff },
	'makernoteolympus' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax6' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentaxunknown' => { 384 => 'PXMN' },
	'makernotephaseone' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohpentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohtext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesafety' => { 119 => 0xc635 },
	'makernotesamsung1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyo' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyoc4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyopatch' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesigma' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonyericsson' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonysrf' => { 117 => 'MakN', 119 => 0x927c },
	'makernotetype' => { 391 => 0x1 },
	'makernoteunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknownbinary' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknowntext' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 186 => 0x0, 227 => 0x1, 306 => 0x0, 324 => 0x8000, 395 => 0x0, 398 => 0x1, 401 => [0x1d,0x1f], 414 => 0x2000 },
	'makerurl' => { 384 => "\xa9mal" },
	'managedfrom' => { 510 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 510 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 510 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 510 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 510 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 510 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 510 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 510 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 510 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 510 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 510 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 510 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 510 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 510 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 510 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 510 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 510 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 510 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 510 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 510 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 510 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 510 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 510 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 510 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 510 => 'Manager' },
	'managervariant' => { 510 => 'ManagerVariant' },
	'manageto' => { 510 => 'ManageTo' },
	'manageui' => { 510 => 'ManageUI' },
	'manifest' => { 510 => 'Manifest' },
	'manifestlinkform' => { 510 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 510 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 510 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 510 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 510 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 510 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 510 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 510 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 510 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 510 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 510 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 510 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 510 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 510 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 510 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 510 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 510 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 510 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 510 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 510 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 510 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 510 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 510 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 510 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 510 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 510 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 510 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 510 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 301 => 0x900, 324 => 0x86 },
	'manometerreading' => { 301 => 0x901 },
	'manualafpointselectpattern' => { 84 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 304 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 285 => '8.2', 288 => '22.2', 289 => '23.1', 290 => '23.2', 292 => '16.2', 293 => '23.2', 294 => '8.2', 295 => '23.2', 298 => '24.2', 391 => 0x100c },
	'manualflashstrength' => { 301 => 0x406 },
	'manualfocusdistance' => { 227 => 0x85, 306 => 0x100c, 400 => 0x223 },
	'manualfocuspointillumination' => { 299 => 0x17 },
	'manualfocusringinafmode' => { 299 => 0x1a },
	'manualtv' => { 83 => 0x5, 84 => 0x705 },
	'manufacturedate' => { 191 => 0x6705, 339 => 0x1 },
	'manufacturedate1' => { 393 => 0x4 },
	'manufacturedate2' => { 393 => 0x5 },
	'manufacturer' => { 467 => 'Manufacturer', 498 => 'manufacturer' },
	'mariahchromablursize' => { 138 => 0xf0d },
	'mariahmaphithreshold' => { 138 => 0xf0c },
	'mariahmaplothreshold' => { 138 => 0xf0b },
	'mariahsigmathreshold' => { 138 => 0xf0e },
	'mariahtexturethreshold' => { 138 => 0xf0a },
	'marked' => { 496 => 'Marked', 513 => 'Marked' },
	'markers' => { 509 => 'markers' },
	'markerscomment' => { 509 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 509 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 509 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 509 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 509 => [\'markers','markersCuePointType'] },
	'markersduration' => { 509 => [\'markers','markersDuration'] },
	'markerslocation' => { 509 => [\'markers','markersLocation'] },
	'markersname' => { 509 => [\'markers','markersName'] },
	'markersprobability' => { 509 => [\'markers','markersProbability'] },
	'markersspeaker' => { 509 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 509 => [\'markers','markersStartTime'] },
	'markerstarget' => { 509 => [\'markers','markersTarget'] },
	'markerstype' => { 509 => [\'markers','markersType'] },
	'maskedareas' => { 119 => 0xc68e },
	'maskgroupbasedcorractive' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 482 => 'MaskGroupBasedCorrections', 484 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 482 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 484 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 131 => 0xb9 },
	'mastergain' => { 241 => 0x50 },
	'materialsample' => { 118 => 'MaterialSample' },
	'materialsampleid' => { 118 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 284 => '50.1', 286 => '48.1', 287 => '48.1', 296 => '48.1', 297 => '48.1', 299 => 0x233 },
	'matrixselectk' => { 138 => 0x91b },
	'matrixselectthreshold' => { 138 => 0x91a },
	'matrixselectthreshold1' => { 138 => 0x91e },
	'matrixselectthreshold2' => { 138 => 0x91f },
	'matrixstructure' => { 383 => 0xa },
	'maxaperture' => { 34 => 0x1a, 138 => 0x3f9, 144 => 0x6103, 163 => 'MaxAperture', 181 => 0x17, 187 => 0x49c5, 225 => 0x36, 302 => 0x20a, 350 => '14.1' },
	'maxapertureatmaxfocal' => { 127 => 0x1407, 163 => 'MaxApertureAtMaxFocal', 219 => 0xb, 220 => 0x10, 221 => 0x11, 225 => 0x12, 302 => 0x206 },
	'maxapertureatminfocal' => { 127 => 0x1406, 219 => 0xa, 220 => 0xf, 221 => 0x10, 225 => 0x11, 302 => 0x205 },
	'maxaperturevalue' => { 119 => 0x9205, 368 => 0x414, 488 => 'MaxApertureValue' },
	'maxavailheight' => { 495 => 'MaxAvailHeight' },
	'maxavailwidth' => { 495 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 283 => 0xb, 284 => 0xc, 286 => '12.1', 287 => '12.1', 292 => 0xc, 293 => 0xb, 296 => '12.1', 297 => '12.1', 299 => 0x3d },
	'maxfaces' => { 305 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 127 => 0x1405, 163 => 'MaxFocalLength', 219 => 0x9, 220 => 0xe, 221 => 0xf, 225 => 0x10, 302 => 0x208, 437 => 0x127c, 438 => 0x1138, 439 => 0x330, 440 => 0x330, 441 => 0x30e },
	'maximumdensityrange' => { 133 => 0x8c },
	'maxpagesize' => { 514 => 'MaxPageSize' },
	'maxpagesizeh' => { 514 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 514 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 514 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 138 => 0xc7d },
	'maxsamplevalue' => { 119 => 0x119 },
	'maxstorage' => { 504 => 'maxstorage' },
	'mb-d10batteries' => { 283 => '12.6' },
	'mb-d10batterytype' => { 292 => '13.3' },
	'mb-d11batterytype' => { 293 => '2.3' },
	'mb-d12batterytype' => { 296 => '3.2' },
	'mb-d80batteries' => { 294 => '6.5' },
	'mb-d80batterytype' => { 298 => '3.2' },
	'mcuversion' => { 219 => 0xc, 220 => 0x11, 221 => 0x12, 225 => 0x13 },
	'md5digest' => { 164 => 'zmd5' },
	'mditemfindercomment' => { 173 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 173 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 173 => 'MDItemFSLabel' },
	'mditemusertags' => { 173 => 'MDItemUserTags' },
	'meal' => { 501 => 'meal' },
	'measuredev' => { 28 => 0x9, 77 => 0x3, 97 => 0x1814, 156 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 77 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 187 => 0x690, 319 => 0x312, 322 => 0x312, 323 => 0x312, 326 => 0x3407 },
	'measuredrggb' => { 65 => 0x1 },
	'measuredrggbdata' => { 44 => 0x287 },
	'measurementaccuracy' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 118 => 'MeasurementOrFact' },
	'measurementremarks' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 467 => 'MeasureType' },
	'mechanicalshuttercount' => { 227 => 0x37 },
	'mediaclassprimaryid' => { 179 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 179 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 311 => 'MediaConstraints' },
	'mediacreatedate' => { 380 => 0x1 },
	'mediaeventiddate' => { 472 => 'MediaEventIdDate' },
	'mediagroupuuid' => { 1 => 0x11 },
	'mediamodifydate' => { 380 => 0x2 },
	'mediasummarycode' => { 311 => 'MediaSummaryCode' },
	'mediatype' => { 376 => 'stik' },
	'memoaudioquality' => { 84 => 0x812 },
	'memorycardconfiguration' => { 417 => 0x16 },
	'memorycardnumber' => { 208 => 0x2 },
	'menubuttondisplayposition' => { 82 => 0xb, 85 => 0xa, 86 => 0xb, 89 => 0xb },
	'menubuttonreturn' => { 90 => 0xb },
	'menumonitorofftime' => { 283 => '26.1', 284 => '22.1', 286 => '22.1', 287 => '22.1', 291 => '21.1', 292 => '8.2', 293 => '21.1', 296 => '22.1', 297 => '22.1', 298 => '22.1', 299 => 0x35 },
	'menusettingsz7iioffset' => { 264 => 0xceb6 },
	'metadataauthority' => { 495 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 495 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 495 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 507 => 'MetadataDate' },
	'metadatalastedited' => { 495 => 'metadataLastEdited' },
	'metadatalasteditor' => { 495 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 495 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 495 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 509 => 'metadataModDate' },
	'metaversion' => { 432 => 0x34 },
	'meterinfo1row1' => { 425 => 0x0, 426 => 0x0 },
	'meterinfo1row2' => { 425 => 0x6c, 426 => 0x5a },
	'meterinfo1row3' => { 425 => 0xd8, 426 => 0xb4 },
	'meterinfo1row4' => { 425 => 0x144, 426 => 0x10e },
	'meterinfo1row5' => { 425 => 0x1b0, 426 => 0x168 },
	'meterinfo1row6' => { 425 => 0x21c, 426 => 0x1c2 },
	'meterinfo1row7' => { 425 => 0x288, 426 => 0x21c },
	'meterinfo2row1' => { 425 => 0x2f4, 426 => 0x276 },
	'meterinfo2row2' => { 425 => 0x378, 426 => 0x2e4 },
	'meterinfo2row3' => { 425 => 0x3fc, 426 => 0x352 },
	'meterinfo2row4' => { 425 => 0x480, 426 => 0x3c0 },
	'meterinfo2row5' => { 425 => 0x504, 426 => 0x42e },
	'meterinfo2row6' => { 425 => 0x588, 426 => 0x49c },
	'meterinfo2row7' => { 425 => 0x60c, 426 => 0x50a },
	'meterinfo2row8' => { 425 => 0x690, 426 => 0x578 },
	'meterinfo2row9' => { 425 => 0x714, 426 => 0x5e6 },
	'metering' => { 285 => '6.1' },
	'meteringmode' => { 34 => 0x11, 119 => 0x9207, 140 => 0x1c, 181 => 0x7, 182 => 0x25, 184 => 0x12, 301 => 0x202, 359 => 0x17, 401 => 0x9, 411 => 0x15, 412 => 0x13, 413 => 0x7, 429 => 0x3, 433 => 0x1174, 434 => 0x1178, 435 => 0x1154, 436 => 0x11d0, 437 => 0x11ac, 438 => 0x1064, 439 => 0x25c, 440 => 0x25c, 441 => 0x24b, 488 => 'MeteringMode' },
	'meteringmode2' => { 340 => '2.1', 424 => 0x202c },
	'meteringmode3' => { 340 => '16.1' },
	'meteringoffscaleindicator' => { 184 => 0x53 },
	'meteringtime' => { 283 => '22.2', 285 => '3.2', 288 => '17.1', 289 => '18.1', 292 => '7.3', 293 => '18.1', 294 => '3.2', 298 => '19.1' },
	'micro1version' => { 386 => 0x1f },
	'micro2version' => { 386 => 0x2d },
	'microphoneattenuator' => { 231 => 0x2d2, 232 => 0x2fa },
	'microphonefrequencyresponse' => { 231 => 0x2d4, 232 => 0x2fc },
	'microphonejackpower' => { 231 => 0x2fa, 232 => 0x322 },
	'microphonesensitivity' => { 231 => 0x2d0, 232 => 0x2f8 },
	'microvideo' => { 465 => 'MicroVideo' },
	'microvideooffset' => { 465 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 465 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 465 => 'MicroVideoVersion' },
	'midrangesharpness' => { 237 => 0x3b },
	'mieversion' => { 164 => '0Vers' },
	'mime' => { 467 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 138 => 0x3f8, 163 => 'MinAperture', 350 => '0.2' },
	'minaperturevalue' => { 368 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 127 => 0x1404, 163 => 'MinFocalLength', 219 => 0x8, 220 => 0xd, 221 => 0xe, 225 => 0xf, 302 => 0x207, 437 => 0x127a, 438 => 0x1136, 439 => 0x32e, 440 => 0x32e, 441 => 0x30c },
	'minfocusdistance' => { 350 => 0x3 },
	'minimumiso' => { 324 => 0xe8 },
	'minintegrationrows' => { 138 => 0x1874 },
	'minoltadate' => { 181 => 0x15 },
	'minoltaimagesize' => { 181 => 0x4, 182 => 0xc, 183 => 0x2, 186 => 0x103 },
	'minoltamodelid' => { 181 => 0x25 },
	'minoltaquality' => { 181 => 0x5, 182 => 0xd, 183 => 0x3, 186 => [0x102,0x103] },
	'minoltatime' => { 181 => 0x16 },
	'minormodelagedisclosure' => { 311 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 473 => 'MinorVersion' },
	'minsamplevalue' => { 119 => 0x118 },
	'mirrorlockup' => { 82 => 0xc, 83 => 0xc, 84 => 0x60f, 85 => 0xb, 86 => 0xc, 87 => 0x6, 88 => 0x6, 89 => 0xc, 90 => 0x3 },
	'mobilecountrycode' => { 481 => 'mcc' },
	'mobilenetworkcode' => { 481 => 'mnc' },
	'moddate' => { 314 => 'modify-date', 496 => 'ModDate' },
	'modedialposition' => { 417 => 0x14 },
	'model' => { 98 => 0x6, 119 => 0x110, 156 => 'Model', 314 => 'Model', 329 => 0x110, 359 => 0x23f, 378 => 'model', 384 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 401 => 0x84, 467 => 'Model', 498 => 'model', 505 => 'Model' },
	'modelage' => { 495 => 'ModelAge' },
	'modelid' => { 300 => 0x0 },
	'modelingflash' => { 283 => '21.4', 284 => '31.1', 286 => '31.1', 287 => '31.1', 292 => '26.4', 293 => '30.2', 294 => '7.4', 295 => '30.1', 296 => '31.1', 297 => '31.1', 298 => '31.3', 299 => 0x5d },
	'modelreleaseid' => { 311 => 'ModelReleaseID' },
	'modelreleasestatus' => { 311 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 446 => 0x52, 447 => 0x46, 448 => 0x53 },
	'modeltiepoint' => { 119 => 0x8482 },
	'modeltransform' => { 119 => 0x85d8 },
	'modelyear' => { 498 => 'modelYear' },
	'modificationdate' => { 499 => 'modificationDate' },
	'modifiedcolortemp' => { 66 => 0x9 },
	'modifieddigitalgain' => { 66 => 0xb },
	'modifiedparamflag' => { 58 => 0x1 },
	'modifiedpicturestyle' => { 66 => 0xa },
	'modifiedsaturation' => { 301 => 0x504 },
	'modifiedsensorbluelevel' => { 66 => 0x5 },
	'modifiedsensorredlevel' => { 66 => 0x4 },
	'modifiedsharpness' => { 66 => 0x2 },
	'modifiedsharpnessfreq' => { 66 => 0x3 },
	'modifiedtonecurve' => { 66 => 0x1 },
	'modifiedwhitebalance' => { 66 => 0x8 },
	'modifiedwhitebalanceblue' => { 66 => 0x7 },
	'modifiedwhitebalancered' => { 66 => 0x6 },
	'modifydate' => { 119 => 0x132, 157 => 'ModifyDate', 310 => 'ModDate', 312 => 'tIME', 375 => 'ModDate', 381 => 0x2, 507 => 'ModifyDate' },
	'moirefilter' => { 119 => 0xfe58, 482 => 'MoireFilter', 484 => 'MoireFilter' },
	'monitorbrightness' => { 231 => 0x59a, 232 => 0x5ca },
	'monitordisplayoff' => { 184 => 0x4c },
	'monitormatrix' => { 138 => 0x8fc },
	'monitorofftime' => { 283 => '18.2', 285 => '3.1', 294 => '3.1' },
	'monochromecolor' => { 301 => 0x53b },
	'monochromecontrast' => { 109 => 0x3c },
	'monochromefiltereffect' => { 103 => 0x20307, 109 => 0x3a, 324 => 0xac, 359 => 0x73 },
	'monochromegraineffect' => { 324 => 0xd2 },
	'monochromelinear' => { 109 => 0x3d },
	'monochromeoutputhighlightpoint' => { 109 => 0x41 },
	'monochromeoutputshadowpoint' => { 109 => 0x42 },
	'monochromeprofilesettings' => { 301 => 0x537 },
	'monochromerawhighlight' => { 109 => 0x7a },
	'monochromerawhighlightpoint' => { 109 => 0x3f },
	'monochromerawshadow' => { 109 => 0x83 },
	'monochromerawshadowpoint' => { 109 => 0x40 },
	'monochromesharpness' => { 109 => 0x3e },
	'monochrometoning' => { 359 => 0x74 },
	'monochrometoningeffect' => { 103 => 0x20306, 109 => 0x3b },
	'monochromeunsharpmaskfineness' => { 109 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 109 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 109 => 0xb4 },
	'monochromevignetting' => { 301 => 0x53a },
	'monthdaycreated' => { 140 => 0x12, 149 => 0xe },
	'mood' => { 179 => 'WM/Mood' },
	'moonphase' => { 385 => 0x12, 386 => 0x43, 387 => 0x4c },
	'morepermissions' => { 480 => 'morePermissions' },
	'motionphotovideo' => { 379 => 'mpvd' },
	'motionsensitivity' => { 385 => 0x29, 387 => 0x60 },
	'movementcount' => { 376 => "\xa9mvc" },
	'movementname' => { 376 => "\xa9mvn" },
	'movementnumber' => { 376 => "\xa9mvi" },
	'movieactived-lighting' => { 230 => 0x238, 231 => 0x2b8, 232 => 0x2e0 },
	'movieaelockbuttonassignment' => { 296 => '40.1' },
	'movieaf-onbutton' => { 299 => 0xcb },
	'movieafareamode' => { 231 => 0x2c6, 232 => 0x2ee, 299 => 0x203 },
	'movieafspeed' => { 299 => 0xdd },
	'movieafspeedapply' => { 299 => 0xdf },
	'movieaftrackingsensitivity' => { 299 => 0xe1 },
	'movieaperturelock' => { 299 => 0x259 },
	'movieautodistortioncontrol' => { 230 => 0x242 },
	'moviediffractioncompensation' => { 230 => 0x241 },
	'moviedxcropalert' => { 231 => 0x2fb, 232 => 0x323 },
	'movieelectronicvr' => { 231 => 0x2cc, 232 => 0x2f4 },
	'movieevfgrid' => { 299 => 0x21d },
	'movieflickerreduction' => { 231 => 0x2c0, 232 => 0x2e8 },
	'moviefocusmode' => { 230 => 0x248, 231 => 0x2c4, 232 => 0x2ec },
	'moviefocuspointlock' => { 299 => 0x226 },
	'movieframerate' => { 230 => 0x1f8, 231 => 0x2f4, 232 => 0x31c },
	'movieframesize' => { 230 => 0x1f6, 231 => 0x2f2, 232 => 0x31a },
	'moviefunc1button' => { 286 => '41.1', 287 => '41.1', 297 => '41.1', 299 => 0xc3 },
	'moviefunc2button' => { 299 => 0xc7 },
	'moviefunc3button' => { 299 => 0x127 },
	'moviefunctionbutton' => { 284 => '41.1', 296 => '41.1' },
	'moviefunctionbuttonplusdials' => { 284 => '52.1' },
	'moviehighisonoisereduction' => { 230 => 0x23c, 231 => 0x2ba, 232 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 299 => 0x215 },
	'moviehighreszoom' => { 232 => 0x32c },
	'movieimagearea' => { 231 => 0x25c, 232 => 0x286 },
	'movieisoautocontrolmanualmode' => { 231 => 0x26a, 232 => 0x294 },
	'movieisoautohilimit' => { 231 => 0x268, 232 => 0x292 },
	'movieisoautomanualmode' => { 230 => 0x204, 231 => 0x26c, 232 => 0x296 },
	'movielenscontrolring' => { 299 => 0xd7 },
	'moviemeteringmode' => { 231 => 0x2c2, 232 => 0x2ea },
	'moviemidtonedisplayrange' => { 299 => 0x219 },
	'moviemidtonedisplayvalue' => { 299 => 0x217 },
	'moviemultiselector' => { 299 => 0xd9 },
	'moviepreviewbutton' => { 284 => '41.2', 286 => '41.2', 287 => '41.2', 296 => '41.2', 297 => '41.2' },
	'moviepreviewbuttonplusdials' => { 284 => '52.2' },
	'movierecordbuttonplaybackmode' => { 299 => 0x1b5 },
	'movieshutterbutton' => { 284 => '38.3', 286 => '38.3', 287 => '38.3', 296 => '38.3', 297 => '38.3' },
	'movieshutterspeedlock' => { 299 => 0x225 },
	'movieslowmotion' => { 230 => 0x1fa },
	'moviesoundrecording' => { 231 => 0x2ce, 232 => 0x2f6 },
	'moviesubjectdetection' => { 231 => 0x2fc, 232 => 0x324 },
	'moviesubselectorassignment' => { 284 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 284 => '53.1' },
	'movietonemap' => { 231 => 0x2ec, 232 => 0x314 },
	'movietype' => { 230 => 0x1fe, 231 => 0x266, 232 => 0x290, 256 => 0xc55c },
	'movievibrationreduction' => { 230 => 0x24e },
	'movievibrationreductionsameasphoto' => { 230 => 0x24f },
	'movievignettecontrol' => { 230 => 0x23e, 231 => 0x1a0, 232 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 230 => 0x240 },
	'movievrmode' => { 231 => 0x2c8, 232 => 0x2f0 },
	'moviezebrapattern' => { 299 => 0x213 },
	'multiburstimageheight' => { 424 => 0x1002 },
	'multiburstimagewidth' => { 424 => 0x1001 },
	'multiburstmode' => { 424 => 0x1000 },
	'multicontrollerwhilemetering' => { 84 => 0x517 },
	'multiexposure' => { 68 => 0x1, 324 => 0xb4 },
	'multiexposureautogain' => { 233 => 0x3 },
	'multiexposurecontrol' => { 68 => 0x2 },
	'multiexposuremode' => { 233 => 0x1, 234 => 0x1 },
	'multiexposureoverlaymode' => { 234 => 0x3 },
	'multiexposureshots' => { 68 => 0x3, 231 => 0x8e, 232 => 0x9c, 233 => 0x2, 234 => 0x2 },
	'multiframenoisereduction' => { 413 => 0x35, 424 => 0x200b, 429 => 0x15 },
	'multiframenreffect' => { 424 => 0x2023 },
	'multifunctionlock' => { 84 => 0x70f },
	'multipleexposuremode' => { 231 => 0x8c, 232 => 0x9a, 305 => 0x101c },
	'multipleexposureset' => { 340 => '10.1' },
	'multisample' => { 241 => 0x40 },
	'multiselector' => { 283 => '9.4', 284 => '10.3', 286 => '10.3', 287 => '10.3', 292 => '27.4', 296 => '10.3', 297 => '10.3' },
	'multiselectorliveview' => { 283 => '4.3', 286 => '37.1', 287 => '37.1', 296 => '37.1', 297 => '37.1' },
	'multiselectorliveviewmode' => { 251 => 0x18c2 },
	'multiselectorplaybackmode' => { 283 => ['13.5','9.2'], 284 => '10.2', 287 => '10.2', 292 => '27.2', 296 => '10.2', 297 => '10.2', 299 => 0xb3 },
	'multiselectorshootmode' => { 283 => '9.1', 284 => '10.1', 286 => '10.1', 287 => '10.1', 292 => '27.1', 296 => '10.1', 297 => '10.1', 299 => 0xaf },
	'multishot' => { 329 => 0x121 },
	'mute' => { 378 => 'player.movie.audio.mute' },
	'mycolormode' => { 69 => 0x2 },
	'name' => { 384 => 'name', 482 => 'Name', 484 => 'Name' },
	'narrator' => { 376 => "\xa9nrt" },
	'nationalcatalognumber' => { 499 => 'nationalCatalogNumber' },
	'nativedigest' => { 488 => 'NativeDigest', 505 => 'NativeDigest' },
	'ndfilter' => { 77 => 0x1c, 301 => 0x204, 391 => 0x1019 },
	'near' => { 467 => 'Near' },
	'nefbitdepth' => { 227 => 0xe22 },
	'nefcompression' => { 227 => 0x93, 228 => 0xa },
	'neflinearizationtable' => { 227 => 0x96 },
	'negativecachelargepreviewsize' => { 482 => 'NegativeCacheLargePreviewSize', 484 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 482 => 'NegativeCacheMaximumSize', 484 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 482 => 'NegativeCachePath', 484 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 479 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 359 => 0x88 },
	'neutraloutputhighlightpoint' => { 109 => 0x2f },
	'neutraloutputshadowpoint' => { 109 => 0x30 },
	'neutralrawcolortone' => { 109 => 0x28 },
	'neutralrawcontrast' => { 109 => 0x2a },
	'neutralrawhighlight' => { 109 => 0x78 },
	'neutralrawhighlightpoint' => { 109 => 0x2d },
	'neutralrawlinear' => { 109 => 0x2b },
	'neutralrawsaturation' => { 109 => 0x29 },
	'neutralrawshadow' => { 109 => 0x81 },
	'neutralrawshadowpoint' => { 109 => 0x2e },
	'neutralrawsharpness' => { 109 => 0x2c },
	'neutralunsharpmaskfineness' => { 109 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 109 => 0xa8 },
	'neutraunsharpmaskstrength' => { 109 => 0xa4 },
	'newrawimagedigest' => { 119 => 0xc7a7 },
	'newsphotoversion' => { 133 => 0x0 },
	'nickname' => { 507 => 'Nickname' },
	'nikoncapturedata' => { 227 => 0xe01 },
	'nikoncaptureeditversions' => { 227 => 0xe13 },
	'nikoncaptureoffsets' => { 227 => 0xe0e },
	'nikoncaptureoutput' => { 227 => 0xe1e },
	'nikoncaptureversion' => { 227 => 0xe09 },
	'nikoniccprofile' => { 227 => 0xe1d },
	'nikonimagesize' => { 248 => '723.1', 249 => '732.1', 259 => 0x2c4 },
	'nikonmeteringmode' => { 230 => 0x146, 252 => 0x2ea4, 261 => 0x175e },
	'nikonsettings' => { 227 => 0x4e },
	'noisefilter' => { 301 => 0x527 },
	'noiseprofile' => { 119 => 0xc761 },
	'noisereduction' => { 127 => [0x100b,0x100e], 182 => 0xb0, 183 => 0x60, 184 => 0x3f, 227 => 0x95, 276 => 0x753dcbc0, 277 => 0x17, 301 => 0x50a, 306 => 0x103a, 324 => 0x2d, 359 => 0x49, 391 => 0x100f, 393 => 0x2a },
	'noisereduction2' => { 305 => 0x1010 },
	'noisereductionapplied' => { 119 => 0xc6f7 },
	'noisereductionintensity' => { 277 => 0x9 },
	'noisereductionmethod' => { 277 => 0x11 },
	'noisereductionmode' => { 459 => 0x801e },
	'noisereductionparametersatcapture' => { 138 => 0xe73 },
	'noisereductionparameterscamera' => { 138 => 0xe72 },
	'noisereductionparametershost3mp' => { 138 => 0xe71 },
	'noisereductionparametershost6mp' => { 138 => 0xe70 },
	'noisereductionparametershostrgb' => { 138 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 138 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 138 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 138 => 0xe63 },
	'noisereductionparams' => { 329 => 0x1b },
	'noisereductionsharpness' => { 277 => 0xd },
	'noisereductionstrength' => { 324 => 0xd6 },
	'noisereductionvalue' => { 459 => 0x8027 },
	'nomemorycard' => { 283 => '22.1', 284 => '4.2', 285 => '0.3', 288 => '2.4', 289 => '3.2', 290 => '3.2', 292 => '33.7', 293 => '3.2', 294 => '0.3', 296 => '4.2', 298 => '4.5' },
	'nominalmaxaperture' => { 350 => 0xa },
	'nominalminaperture' => { 350 => '10.1' },
	'normallinetime' => { 138 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 42 => 0x280, 45 => [0x2b8,0x2cf,0x2d3], 46 => 0x569, 47 => 0x1e3, 48 => [0x1fc,0x2dc], 49 => [0x230,0x30e], 50 => 0x31c },
	'notes' => { 460 => 'Notes', 477 => 'notes' },
	'npages' => { 514 => 'NPages' },
	'nullrecord' => { 97 => 0x0 },
	'numafpoints' => { 336 => 0x2 },
	'number' => { 499 => 'number' },
	'numberofbeats' => { 509 => 'numberOfBeats' },
	'numberoffocuspoints' => { 286 => '1.3', 287 => '1.3', 290 => '0.2', 291 => '0.3', 293 => '0.3' },
	'numfaceelements' => { 127 => 0x4200 },
	'numfacepositions' => { 316 => 0x0 },
	'numindexentries' => { 133 => 0x54 },
	'numwbentries' => { 330 => 0x0, 331 => 0x0 },
	'object' => { 499 => 'object' },
	'objectattributereference' => { 131 => 0x4 },
	'objectcycle' => { 131 => 0x4b, 477 => 'ObjectCycle' },
	'objectdescription' => { 498 => 'objectDescription' },
	'objectdistance' => { 112 => 0x6, 113 => 0x2022 },
	'objectname' => { 131 => 0x5 },
	'objectpreviewdata' => { 131 => 0xca },
	'objectpreviewfileformat' => { 131 => 0xc8 },
	'objectpreviewfileversion' => { 131 => 0xc9 },
	'objectsubtype' => { 498 => 'objectSubtype' },
	'objecttype' => { 498 => 'objectType' },
	'objecttypereference' => { 131 => 0x3 },
	'occurrence' => { 118 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 118 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 118 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 118 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 118 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 118 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 118 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 118 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 118 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 118 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 118 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 118 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 118 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 118 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 118 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 118 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 118 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 118 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 118 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 118 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 118 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 118 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 118 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 118 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 118 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 118 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 118 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 118 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 118 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 118 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 488 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 488 => [\'OECF','OECFNames'] },
	'oecfrows' => { 488 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 488 => [\'OECF','OECFValues'] },
	'offsaledate' => { 499 => 'offSaleDate' },
	'offsaledatea-platform' => { 499 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 499 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 138 => 0x190a },
	'offsetschema' => { 119 => 0xea1d },
	'offsettime' => { 119 => 0x9010 },
	'offsettimedigitized' => { 119 => 0x9012 },
	'offsettimeoriginal' => { 119 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 293 => '15.1', 298 => '16.1' },
	'oldsubfiletype' => { 119 => 0xff },
	'olympusimageheight' => { 306 => 0x102f },
	'olympusimagewidth' => { 306 => 0x102e },
	'omenatcapturestrength' => { 138 => 0xa60 },
	'omenautostrength' => { 138 => 0xa5f },
	'omenearlystrength' => { 138 => 0xa5e },
	'omenfocallengthlimit' => { 138 => 0xa62 },
	'omeninitialipfstrength' => { 138 => 0xa5d },
	'omensurfaceindex' => { 138 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 306 => 0x302 },
	'onsaledate' => { 499 => 'onSaleDate' },
	'onsaledatea-platform' => { 499 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 499 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 499 => 'onSaleDay' },
	'onsaledaya-platform' => { 499 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 499 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 119 => 0xc740 },
	'opcodelist2' => { 119 => 0xc741 },
	'opcodelist3' => { 119 => 0xc74e },
	'opticalzoom' => { 142 => 0xfa3d, 144 => [0x6006,0xf006], 145 => 0x1000, 146 => 0xf, 149 => 0x1e, 151 => 0x20, 152 => 0x1c, 163 => 'OpticalZoom' },
	'opticalzoomcode' => { 77 => 0xa },
	'opticalzoommode' => { 324 => 0x34 },
	'opticalzoomon' => { 400 => 0x219 },
	'optionenddate' => { 502 => 'optionEndDate' },
	'opto-electricconvfactor' => { 488 => 'OECF' },
	'orangehsl' => { 103 => 0x20911 },
	'ordernumber' => { 127 => 0x8002 },
	'organisationinimagecode' => { 495 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 495 => 'OrganisationInImageName' },
	'organism' => { 118 => 'Organism' },
	'organismassociatedoccurrences' => { 118 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 118 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 118 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 118 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 118 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 118 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 118 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 499 => 'organization' },
	'orientation' => { 119 => 0x112, 329 => 0x112, 498 => 'orientation', 505 => 'Orientation' },
	'orientation2' => { 429 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 84 => 0x516 },
	'originalalbumtitle' => { 179 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 179 => 'WM/OriginalArtist', 376 => "\xa9ope" },
	'originalbestqualitysize' => { 119 => 0xc792 },
	'originalcreatedatetime' => { 472 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 114 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 64 => 0x83 },
	'originaldefaultcropsize' => { 119 => 0xc793 },
	'originaldefaultfinalsize' => { 119 => 0xc791 },
	'originaldirectory' => { 321 => 0x408 },
	'originaldocumentid' => { 510 => 'OriginalDocumentID' },
	'originalfilename' => { 97 => 0x816, 138 => 0x3e9, 150 => 0x20, 321 => 0x407, 472 => 'OriginalFilename' },
	'originalimageheight' => { 79 => 0xc, 123 => 0x1 },
	'originalimagesize' => { 162 => 'OriginalImageSize' },
	'originalimagewidth' => { 79 => 0xb, 123 => 0x0 },
	'originallyricist' => { 179 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 119 => 0xc68c },
	'originalrawfiledigest' => { 119 => 0xc71d },
	'originalrawfilename' => { 119 => 0xc68b },
	'originaltransmissionreference' => { 131 => 0x67 },
	'originatingprogram' => { 131 => 0x41, 477 => 'OriginatingProgram' },
	'originplatform' => { 499 => 'originPlatform' },
	'os' => { 486 => 'os' },
	'otherconditions' => { 311 => 'OtherConditions' },
	'otherconstraints' => { 311 => 'OtherConstraints' },
	'otherimage' => { 114 => 'Exif-OtherImage' },
	'otherimageinfo' => { 311 => 'OtherImageInfo' },
	'otherimagelength' => { 119 => 0x202 },
	'otherimagestart' => { 119 => 0x201 },
	'otherlicensedocuments' => { 311 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 311 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 311 => 'OtherLicenseRequirements' },
	'outcue' => { 509 => 'outCue' },
	'outcuescale' => { 509 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 509 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 197 => 0x3 },
	'outputimagewidth' => { 197 => 0x2 },
	'outputlut' => { 324 => 0xa7 },
	'outputprofile' => { 138 => 0x138b },
	'outputresolution' => { 197 => 0x4 },
	'overclockcols' => { 138 => 0x189c },
	'overclockrows' => { 138 => 0x18c4 },
	'overridelookvignette' => { 482 => 'OverrideLookVignette', 484 => 'OverrideLookVignette' },
	'owner' => { 513 => 'Owner' },
	'ownerid' => { 131 => 0xbc },
	'ownername' => { 15 => 0x10f, 64 => 0x9, 97 => 0x810, 119 => [0xa430,0xfde8], 156 => 'OwnerName', 479 => 'OwnerName', 489 => 'CameraOwnerName' },
	'padding' => { 119 => 0xea1c },
	'pagecount' => { 499 => 'pageCount' },
	'pageimage' => { 507 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 507 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 507 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 507 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 507 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 507 => 'PageInfo' },
	'pagename' => { 119 => 0x11d },
	'pagenumber' => { 119 => 0x129 },
	'pageprogressiondirection' => { 499 => 'pageProgressionDirection' },
	'pagerange' => { 499 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 482 => 'PaintBasedCorrections', 484 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 482 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 484 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 327 => 0x0 },
	'panasonicexifversion' => { 324 => 0x26 },
	'panasonicimageheight' => { 324 => 0x4c },
	'panasonicimagewidth' => { 324 => 0x4b },
	'panasonicrawversion' => { 329 => 0x1 },
	'panasonictitle' => { 119 => 0xc6d2 },
	'panasonictitle2' => { 119 => 0xc6d3 },
	'panoramaangle' => { 127 => 0x1153 },
	'panoramacropbottom' => { 430 => 0x7 },
	'panoramacropleft' => { 430 => 0x4 },
	'panoramacropright' => { 430 => 0x6 },
	'panoramacroptop' => { 430 => 0x5 },
	'panoramadirection' => { 72 => 0x5, 127 => 0x1154, 430 => 0x3 },
	'panoramaframeheight' => { 430 => 0x9 },
	'panoramaframenumber' => { 72 => 0x2 },
	'panoramaframewidth' => { 430 => 0x8 },
	'panoramafullheight' => { 430 => 0x2 },
	'panoramafullwidth' => { 430 => 0x1 },
	'panoramamode' => { 140 => 0x3c, 301 => 0x601 },
	'panoramasize3d' => { 413 => 0x38 },
	'panoramasourceheight' => { 430 => 0xb },
	'panoramasourcewidth' => { 430 => 0xa },
	'panoramicstitchcameramotion' => { 176 => 'PanoramicStitchCameraMotion', 177 => 0x1 },
	'panoramicstitchmaptype' => { 176 => 'PanoramicStitchMapType', 177 => 0x2 },
	'panoramicstitchphi0' => { 176 => 'PanoramicStitchPhi0', 177 => 0x5 },
	'panoramicstitchphi1' => { 176 => 'PanoramicStitchPhi1', 177 => 0x6 },
	'panoramicstitchtheta0' => { 176 => 'PanoramicStitchTheta0', 177 => 0x3 },
	'panoramicstitchtheta1' => { 176 => 'PanoramicStitchTheta1', 177 => 0x4 },
	'panoramicstitchversion' => { 177 => 0x0 },
	'pantry' => { 510 => 'Pantry' },
	'pantryinstanceid' => { 510 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 127 => 0xb211, 300 => 0x28 },
	'parametricdarks' => { 482 => 'ParametricDarks', 484 => 'ParametricDarks' },
	'parametrichighlights' => { 482 => 'ParametricHighlights', 484 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 482 => 'ParametricHighlightSplit', 484 => 'ParametricHighlightSplit' },
	'parametriclights' => { 482 => 'ParametricLights', 484 => 'ParametricLights' },
	'parametricmidtonesplit' => { 482 => 'ParametricMidtoneSplit', 484 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 482 => 'ParametricShadows', 484 => 'ParametricShadows' },
	'parametricshadowsplit' => { 482 => 'ParametricShadowSplit', 484 => 'ParametricShadowSplit' },
	'parentalrating' => { 179 => 'WM/ParentalRating' },
	'parentid' => { 495 => 'parentId' },
	'parentmediaeventid' => { 472 => 'ParentMediaEventID' },
	'parentmeid' => { 472 => 'ParentMEID' },
	'parentproductid' => { 376 => '@ppi' },
	'parentreference1' => { 493 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 493 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 376 => '@PST' },
	'parenttitle' => { 376 => '@pti' },
	'partialactivecols1' => { 138 => 0x17e8 },
	'partialactivecols2' => { 138 => 0x17f2 },
	'partialactiverows1' => { 138 => 0x17fc },
	'partialactiverows2' => { 138 => 0x1806 },
	'partofcompilation' => { 509 => 'partOfCompilation' },
	'patientbirthdate' => { 461 => 'PatientDOB' },
	'patientid' => { 461 => 'PatientID' },
	'patientname' => { 461 => 'PatientName' },
	'patientsex' => { 461 => 'PatientSex' },
	'patternareaheight' => { 138 => 0x963 },
	'patternareawidth' => { 138 => 0x962 },
	'patterncorrectionfactorscale' => { 138 => 0x969 },
	'patterncropcols1' => { 138 => 0x96c },
	'patterncropcols2' => { 138 => 0x96d },
	'patterncroprows1' => { 138 => 0x96a },
	'patterncroprows2' => { 138 => 0x96b },
	'patternimagerheight' => { 138 => 0x961 },
	'patternimagerwidth' => { 138 => 0x960 },
	'patternx' => { 138 => 0x966 },
	'patterny' => { 138 => 0x967 },
	'pdfversion' => { 496 => 'PDFVersion' },
	'pentaximagesize' => { 359 => 0x9 },
	'pentaxmodelid' => { 339 => 0x0, 359 => 0x5 },
	'pentaxmodeltype' => { 359 => 0x1 },
	'pentaxversion' => { 359 => 0x0 },
	'people' => { 463 => 'People', 475 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 42 => 0x16b, 44 => 0xc4, 45 => [0x2b4,0x2cb,0x2cf], 46 => [0x108,0x14d], 47 => 0x1df, 48 => [0x1f8,0x2d8], 49 => [0x22c,0x30a], 50 => 0x149 },
	'performer' => { 376 => 'perf', 384 => 'perf' },
	'performerkeywords' => { 384 => "\xa9prk" },
	'performers' => { 384 => "\xa9prf" },
	'performerurl' => { 384 => "\xa9prl" },
	'period' => { 179 => 'WM/Period' },
	'peripheralillumcentralradius' => { 459 => 0x8030 },
	'peripheralillumcentralvalue' => { 459 => 0x8031 },
	'peripheralillumination' => { 103 => 0x20702, 109 => 0x68 },
	'peripheralilluminationcorr' => { 62 => 0x1, 349 => 0x2 },
	'peripheralilluminationon' => { 103 => '0x20702.0', 109 => 0x64 },
	'peripheralillumperiphvalue' => { 459 => 0x8032 },
	'peripherallighting' => { 79 => 0x2, 127 => 0x3804 },
	'peripherallightingsetting' => { 80 => 0x5 },
	'peripherallightingvalue' => { 79 => 0x6 },
	'permissions' => { 502 => 'permissions' },
	'permits' => { 480 => 'permits' },
	'person' => { 499 => 'person' },
	'personality' => { 472 => 'Personality' },
	'personheard' => { 495 => 'PersonHeard' },
	'personheardidentifier' => { 495 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 495 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 495 => 'PersonInImage' },
	'personinimagecharacteristic' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 495 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 495 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 482 => 'PerspectiveAspect', 484 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 482 => 'PerspectiveHorizontal', 484 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 482 => 'PerspectiveRotate', 484 => 'PerspectiveRotate' },
	'perspectivescale' => { 482 => 'PerspectiveScale', 484 => 'PerspectiveScale' },
	'perspectiveupright' => { 482 => 'PerspectiveUpright', 484 => 'PerspectiveUpright' },
	'perspectivevertical' => { 482 => 'PerspectiveVertical', 484 => 'PerspectiveVertical' },
	'perspectivex' => { 482 => 'PerspectiveX', 484 => 'PerspectiveX' },
	'perspectivey' => { 482 => 'PerspectiveY', 484 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 92 => 0x1 },
	'pf10retainprogramshift' => { 92 => 0xb },
	'pf13drivepriority' => { 92 => 0xe },
	'pf14disablefocussearch' => { 92 => 0xf },
	'pf15disableafassistbeam' => { 92 => 0x10 },
	'pf16autofocuspointshoot' => { 92 => 0x11 },
	'pf17disableafpointsel' => { 92 => 0x12 },
	'pf18enableautoafpointsel' => { 92 => 0x13 },
	'pf19continuousshootspeed' => { 92 => 0x14 },
	'pf19shootingspeedhigh' => { 91 => 0xa },
	'pf19shootingspeedlow' => { 91 => 0x9 },
	'pf1disableshootingmodes' => { 92 => 0x2 },
	'pf1value' => { 91 => 0x1 },
	'pf20limitcontinousshots' => { 92 => 0x15 },
	'pf20maxcontinousshots' => { 91 => 0xb },
	'pf21enablequietoperation' => { 92 => 0x16 },
	'pf23felocktime' => { 91 => 0xd },
	'pf23postreleasetime' => { 91 => 0xe },
	'pf23settimerlengths' => { 92 => 0x18 },
	'pf23shutterbuttontime' => { 91 => 0xc },
	'pf24lightlcdduringbulb' => { 92 => 0x19 },
	'pf25aemode' => { 91 => 0xf },
	'pf25afmode' => { 91 => 0x12 },
	'pf25afpointsel' => { 91 => 0x13 },
	'pf25colormatrix' => { 91 => 0x17 },
	'pf25defaultclearsettings' => { 92 => 0x1a },
	'pf25drivemode' => { 91 => 0x11 },
	'pf25imagesize' => { 91 => 0x14 },
	'pf25meteringmode' => { 91 => 0x10 },
	'pf25parameters' => { 91 => 0x16 },
	'pf25wbmode' => { 91 => 0x15 },
	'pf26shortenreleaselag' => { 92 => 0x1b },
	'pf27reversedialrotation' => { 92 => 0x1c },
	'pf27value' => { 91 => 0x18 },
	'pf28noquickdialexpcomp' => { 92 => 0x1d },
	'pf29quickdialswitchoff' => { 92 => 0x1e },
	'pf2disablemeteringmodes' => { 92 => 0x3 },
	'pf2value' => { 91 => 0x2 },
	'pf30enlargementmode' => { 92 => 0x1f },
	'pf31originaldecisiondata' => { 92 => 0x20 },
	'pf3manualexposuremetering' => { 92 => 0x4 },
	'pf3value' => { 91 => 0x3 },
	'pf4exposuretimelimits' => { 92 => 0x5 },
	'pf4exposuretimemax' => { 91 => 0x5 },
	'pf4exposuretimemin' => { 91 => 0x4 },
	'pf5aperturelimits' => { 92 => 0x6 },
	'pf5aperturemax' => { 91 => 0x7 },
	'pf5aperturemin' => { 91 => 0x6 },
	'pf6presetshootingmodes' => { 92 => 0x7 },
	'pf7bracketcontinuousshoot' => { 92 => 0x8 },
	'pf8bracketshots' => { 91 => 0x8 },
	'pf8setbracketshots' => { 92 => 0x9 },
	'pf9changebracketsequence' => { 92 => 0xa },
	'phasedetectaf' => { 193 => 0x6 },
	'phonenumber' => { 157 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 276 => 0xe9651831 },
	'photoeffects' => { 276 => 0xab5eca5e },
	'photoeffectsblue' => { 278 => 0x8 },
	'photoeffectsgreen' => { 278 => 0x6 },
	'photoeffectsred' => { 278 => 0x4 },
	'photoeffectstype' => { 278 => 0x0 },
	'photographicsensitivity' => { 489 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 283 => '17.6', 292 => '33.6' },
	'photometricinterpretation' => { 119 => 0x106, 505 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 231 => 0x112, 232 => 0x122, 252 => 0xe7d, 262 => 0xfbd },
	'photoshootingmenubankimagearea' => { 231 => 0x134, 232 => 0x148, 252 => '3716.1', 262 => 0x791 },
	'photoshopbgrthumbnail' => { 373 => 0x409 },
	'photoshopquality' => { 372 => 0x0 },
	'photoshopthumbnail' => { 373 => 0x40c },
	'photostyle' => { 324 => 0x89 },
	'picasawebgphotoid' => { 487 => 'picasawebGPhotoId' },
	'picklabel' => { 487 => 'PickLabel' },
	'pictinfo' => { 400 => 0x208 },
	'picturecontrol' => { 276 => 0xe2173c47 },
	'picturecontrolactive' => { 279 => 0x0 },
	'picturecontroladjust' => { 235 => 0x30, 236 => 0x30, 237 => 0x36 },
	'picturecontrolbase' => { 235 => 0x18, 236 => 0x18, 237 => 0x1c },
	'picturecontroldata' => { 227 => [0xbd,0x23] },
	'picturecontrolmode' => { 279 => 0x13 },
	'picturecontrolname' => { 235 => 0x4, 236 => 0x4, 237 => 0x8 },
	'picturecontrolquickadjust' => { 235 => 0x31, 236 => 0x31, 237 => 0x37 },
	'pictureeffect' => { 424 => 0x200e },
	'pictureeffect2' => { 433 => 0x1163, 434 => 0x1167, 435 => 0x1143, 436 => 0x11bf, 437 => 0x119b, 438 => 0x1053, 439 => 0x24b, 440 => 0x24b, 441 => 0x23c, 455 => 0x46 },
	'picturefinish' => { 182 => 0x71 },
	'picturemode' => { 127 => 0x1031, 301 => 0x520, 359 => [0xb,0x33], 401 => 0x3d },
	'picturemode2' => { 340 => 0x0 },
	'picturemodebwfilter' => { 301 => 0x525 },
	'picturemodecontrast' => { 301 => 0x523 },
	'picturemodeeffect' => { 301 => 0x52d },
	'picturemodehue' => { 301 => 0x522 },
	'picturemodesaturation' => { 301 => 0x521 },
	'picturemodesharpness' => { 301 => 0x524 },
	'picturemodetone' => { 301 => 0x526 },
	'pictureprofile' => { 433 => [0x115e,0x115f], 434 => [0x1162,0x1163], 435 => [0x113e,0x113f], 436 => [0x11ba,0x11bb], 437 => [0x1196,0x1197], 438 => [0x104e,0x104f], 439 => [0x246,0x247], 440 => [0x246,0x247], 441 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 74 => 0xa, 103 => 0x20301, 109 => 0x2 },
	'picturestylepc' => { 64 => 0x4009 },
	'picturestyleuserdef' => { 64 => 0x4008 },
	'picturewizard' => { 398 => 0x21 },
	'picturewizardcolor' => { 397 => 0x1 },
	'picturewizardcontrast' => { 397 => 0x4 },
	'picturewizardmode' => { 397 => 0x0 },
	'picturewizardsaturation' => { 397 => 0x2 },
	'picturewizardsharpness' => { 397 => 0x3 },
	'pipelineversion' => { 176 => 'PipelineVersion' },
	'pitch' => { 115 => 0x6, 284 => '4.1', 296 => '4.1', 384 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 251 => 0x350f, 252 => 0x2c28, 256 => 0xc21e, 261 => 0x36f8, 262 => 0x2eff, 264 => 0xce36, 265 => 0x80c9, 301 => 0x904, 324 => 0x91, 358 => 0x2, 396 => 0x1 },
	'pitchshift' => { 378 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 377 => 'pasp' },
	'pixelclockfrequency' => { 138 => 0x40b },
	'pixelcorrectionoffset' => { 138 => 0x972 },
	'pixelcorrectionscale' => { 138 => 0x971 },
	'pixelscale' => { 119 => 0x830e },
	'pixelshiftinfo' => { 424 => 0x202f },
	'pixelshiftoffset' => { 127 => 0x1106 },
	'pixelshiftresolution' => { 360 => 0x0 },
	'pixelshiftshots' => { 127 => 0x1105 },
	'pixelsperunitx' => { 313 => 0x0 },
	'pixelsperunity' => { 313 => 0x4 },
	'pixelunits' => { 313 => 0x8 },
	'planarconfiguration' => { 119 => 0x11c, 505 => 'PlanarConfiguration' },
	'plane' => { 462 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 462 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 462 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 462 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 462 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 462 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 462 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 462 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 462 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 462 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 462 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 462 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 462 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 462 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 462 => 'Planes' },
	'planningref' => { 495 => 'PlanningRef' },
	'planningrefidentifier' => { 495 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 495 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 495 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 514 => 'PlateNames' },
	'platform' => { 499 => 'platform' },
	'playallframes' => { 384 => 'AllF' },
	'playbackflickdown' => { 299 => 0x159 },
	'playbackflickup' => { 299 => 0x155 },
	'playbackmenustime' => { 288 => '20.1', 289 => '21.1', 290 => '21.1' },
	'playbackmonitorofftime' => { 283 => '25.2', 284 => '36.1', 286 => '36.1', 287 => '36.1', 291 => '35.1', 292 => '8.1', 293 => '35.1', 296 => '36.1', 297 => '36.1', 298 => '21.1', 299 => 0x33 },
	'playbackzoom' => { 284 => '37.1' },
	'playdisplay' => { 184 => 0x4e },
	'playerversion' => { 378 => 'player.version' },
	'playgap' => { 376 => 'pgap' },
	'playlistid' => { 376 => 'plID' },
	'playmode' => { 384 => 'SDLN' },
	'playselection' => { 384 => 'SelO' },
	'plusversion' => { 311 => 'Version' },
	'pmversion' => { 371 => 'PMVersion' },
	'pngwarning' => { 314 => 'Warning' },
	'podcast' => { 376 => 'pcst' },
	'podcasturl' => { 376 => 'purl' },
	'poilevel' => { 226 => 0x8 },
	'portraitimpressionbalance' => { 264 => 0x7fa0 },
	'portraitnote' => { 465 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 109 => 0x1d },
	'portraitoutputshadowpoint' => { 109 => 0x1e },
	'portraitrawcolortone' => { 109 => 0x16 },
	'portraitrawcontrast' => { 109 => 0x18 },
	'portraitrawhighlight' => { 109 => 0x76 },
	'portraitrawhighlightpoint' => { 109 => 0x1b },
	'portraitrawlinear' => { 109 => 0x19 },
	'portraitrawsaturation' => { 109 => 0x17 },
	'portraitrawshadow' => { 109 => 0x7f },
	'portraitrawshadowpoint' => { 109 => 0x1c },
	'portraitrawsharpness' => { 109 => 0x1a },
	'portraitrefiner' => { 113 => 0x302b },
	'portraitrequest' => { 465 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 109 => 0x9a },
	'portraitunsharpmaskstrength' => { 109 => 0x98 },
	'portraitunsharpmaskthreshold' => { 109 => 0x9c },
	'portraitversion' => { 465 => 'PortraitVersion' },
	'pose' => { 462 => 'Pose' },
	'poseheadingdegrees' => { 470 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 470 => 'PosePitchDegrees' },
	'posepositionx' => { 462 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 462 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 462 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 470 => 'PoseRollDegrees' },
	'poserotationw' => { 462 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 462 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 462 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 462 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 462 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 498 => 'positionDescriptor' },
	'postalcode' => { 161 => 'PostalCode' },
	'postcropvignetteamount' => { 482 => 'PostCropVignetteAmount', 484 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 482 => 'PostCropVignetteFeather', 484 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 482 => 'PostCropVignetteHighlightContrast', 484 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 482 => 'PostCropVignetteMidpoint', 484 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 482 => 'PostCropVignetteRoundness', 484 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 482 => 'PostCropVignetteStyle', 484 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 324 => 0xbf },
	'postreleaseburstlength' => { 232 => 0x714 },
	'potentialface1position' => { 421 => 0xb },
	'potentialface2position' => { 421 => 0x15 },
	'potentialface3position' => { 421 => 0x1f },
	'potentialface4position' => { 421 => 0x29 },
	'potentialface5position' => { 421 => 0x33 },
	'potentialface6position' => { 421 => 0x3d },
	'potentialface7position' => { 421 => 0x47 },
	'potentialface8position' => { 421 => 0x51 },
	'powersource' => { 338 => '0.1' },
	'poweruptime' => { 227 => 0xb6 },
	'preaf' => { 126 => '0.2' },
	'precaptureframes' => { 306 => 0x300 },
	'predictor' => { 119 => 0x13d },
	'preflashreturnstrength' => { 249 => 0x28a },
	'prefs' => { 131 => 0xdd, 371 => 'Prefs' },
	'prereadfastresetcount' => { 138 => 0x187e },
	'prereleaseburstlength' => { 232 => 0x712 },
	'preservedfilename' => { 510 => 'PreservedFileName' },
	'preservedspecimen' => { 118 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 118 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 482 => 'PresetType', 484 => 'PresetType' },
	'presetwhitebalance' => { 184 => 0x24, 459 => 0x8002 },
	'presetwhitebalanceadj' => { 459 => 0x8014 },
	'pressure' => { 119 => 0x9402, 489 => 'Pressure' },
	'previewapplicationname' => { 119 => 0xc716 },
	'previewapplicationversion' => { 119 => 0xc717 },
	'previewbutton' => { 283 => ['14.1','15.1'], 284 => '15.1', 286 => '15.1', 287 => '15.1', 292 => '29.1', 293 => '14.1', 296 => '15.1', 297 => '15.1' },
	'previewbuttonplusdials' => { 283 => ['14.2','15.2'], 284 => '15.2', 286 => '43.1', 287 => '43.1', 292 => '31.2', 296 => '43.1', 297 => '43.1' },
	'previewcolorspace' => { 119 => 0xc71a },
	'previewcropbottom' => { 370 => 0xef },
	'previewcropleft' => { 370 => 0xec },
	'previewcropright' => { 370 => 0xee },
	'previewcroptop' => { 370 => 0xed },
	'previewdate' => { 382 => 0x0 },
	'previewdatetime' => { 119 => 0xc71b },
	'previewimage' => { 113 => 0x2000, 114 => 'Exif-PreviewImage', 120 => 'PreviewImage', 122 => 0x4, 166 => 'data', 186 => 0x81, 306 => 0x280, 322 => 0x300, 384 => 'mcvr', 424 => 0x2001 },
	'previewimageborders' => { 359 => 0x3e },
	'previewimageheight' => { 73 => 0x4, 142 => 0xfa58 },
	'previewimagelength' => { 73 => 0x2, 113 => 0x3, 119 => [0x117,0x202], 186 => 0x89, 238 => 0x202, 301 => 0x102, 306 => 0x1037, 359 => 0x3, 390 => 0x1e, 395 => 0x3, 401 => [0x1b,0x1d], 414 => 0x202 },
	'previewimagename' => { 166 => '1Name' },
	'previewimagesize' => { 113 => 0x2, 147 => 0x2, 166 => 'ImageSize', 359 => 0x2, 401 => [0x1c,0x1e], 424 => 0xb02c, 459 => 0x9012 },
	'previewimagestart' => { 73 => 0x5, 113 => 0x4, 119 => [0x111,0x201], 186 => 0x88, 238 => 0x201, 301 => 0x101, 306 => 0x1036, 359 => 0x4, 390 => 0x1c, 395 => 0x2, 401 => [0x1a,0x1c], 414 => 0x201 },
	'previewimagetype' => { 166 => '0Type' },
	'previewimagevalid' => { 301 => 0x100, 306 => 0x1035 },
	'previewimagewidth' => { 73 => 0x3, 142 => 0xfa57 },
	'previewquality' => { 73 => 0x1 },
	'previewsettingsdigest' => { 119 => 0xc719 },
	'previewsettingsname' => { 119 => 0xc718 },
	'primaryafpoint' => { 193 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 119 => 0x13f, 505 => 'PrimaryChromaticities' },
	'primaryftp' => { 472 => 'PrimaryFTP' },
	'primaryslot' => { 252 => 0xe7f, 262 => 0xfbf },
	'printim' => { 119 => 0xc4a5 },
	'prioritysetinawb' => { 424 => 0x202b },
	'prioritysetupshutterrelease' => { 184 => 0x1d, 411 => 0x28 },
	'privatertkinfo' => { 474 => 'privateRTKInfo' },
	'processbordercolsleft' => { 138 => 0xc61 },
	'processbordercolsright' => { 138 => 0xc62 },
	'processborderrowsbottom' => { 138 => 0xc64 },
	'processborderrowstop' => { 138 => 0xc63 },
	'processingsoftware' => { 119 => 0xb },
	'processversion' => { 482 => 'ProcessVersion', 484 => 'ProcessVersion' },
	'producer' => { 179 => 'WM/Producer', 310 => 'Producer', 376 => "\xa9prd", 378 => 'producer', 384 => "\xa9prd", 496 => 'Producer' },
	'producerkeywords' => { 384 => "\xa9pdk" },
	'productcode' => { 499 => 'productCode' },
	'productid' => { 132 => 0x32, 376 => 'prID', 498 => 'productID' },
	'productidtype' => { 498 => 'productIDType' },
	'productinimage' => { 495 => 'ProductInImage' },
	'productinimagedescription' => { 495 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 495 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 495 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 495 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 339 => 0x2 },
	'productorserviceconstraints' => { 311 => 'ProductOrServiceConstraints' },
	'productversion' => { 376 => 'VERS' },
	'profession' => { 499 => 'profession' },
	'profile' => { 462 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 119 => 0xc6f4 },
	'profilecameraindices' => { 462 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 119 => 0xc6fe },
	'profileembedpolicy' => { 119 => 0xc6fd },
	'profilegaintablemap' => { 119 => 0xcd2d },
	'profilehuesatmapdata1' => { 119 => 0xc6fa },
	'profilehuesatmapdata2' => { 119 => 0xc6fb },
	'profilehuesatmapdata3' => { 119 => 0xcd39 },
	'profilehuesatmapdims' => { 119 => 0xc6f9 },
	'profilehuesatmapencoding' => { 119 => 0xc7a3 },
	'profilelooktabledata' => { 119 => 0xc726 },
	'profilelooktabledims' => { 119 => 0xc725 },
	'profilelooktableencoding' => { 119 => 0xc7a4 },
	'profilename' => { 119 => 0xc6f8, 312 => 'iCCP-name' },
	'profiles' => { 462 => 'Profiles' },
	'profiletonecurve' => { 119 => 0xc6fc },
	'profiletype' => { 462 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 324 => 0x3c },
	'programline' => { 340 => '1.1' },
	'programmode' => { 189 => 0x5 },
	'programshift' => { 227 => 0xd },
	'programversion' => { 131 => 0x46 },
	'prohibits' => { 480 => 'prohibits' },
	'projectiontype' => { 470 => 'ProjectionType', 471 => 'ProjectionType' },
	'projectname' => { 509 => 'projectName' },
	'projectref' => { 509 => 'projectRef' },
	'projectrefpath' => { 509 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 509 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 179 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 311 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 311 => 'PropertyReleaseStatus' },
	'provider' => { 179 => 'WM/Provider' },
	'province-state' => { 131 => 0x5f },
	'publicationdate' => { 499 => 'publicationDate' },
	'publicationdatea-platform' => { 499 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 499 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 499 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 499 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 499 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 495 => 'PublicationEvent' },
	'publicationeventdate' => { 495 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 495 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 495 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 499 => 'publicationName' },
	'publisher' => { 179 => 'WM/Publisher', 376 => "\xa9pub", 378 => 'publisher', 485 => 'publisher' },
	'publishingfrequency' => { 499 => 'publishingFrequency' },
	'pulldown' => { 509 => 'pullDown' },
	'purchasedate' => { 376 => 'purd' },
	'purplehsl' => { 103 => 0x20916 },
	'pxshiftperiphedgenr' => { 459 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 459 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 112 => 0x2, 113 => 0x3002, 127 => 0x1000, 140 => 0x9, 227 => 0x4, 266 => 0x3, 306 => 0x201, 319 => 0x300, 359 => 0x8, 366 => 0x2, 401 => 0x16, 411 => 0x56, 412 => 0x56, 413 => 0xb, 424 => [0x102,0x202e] },
	'quality2' => { 433 => 0x1170, 434 => 0x1174, 435 => 0x1150, 437 => 0x11a8, 438 => 0x1060, 439 => 0x258, 440 => 0x258, 441 => 0x247, 446 => 0x29, 447 => 0x25, 448 => 0x2a },
	'qualitybutton' => { 299 => 0x17d },
	'qualitybuttonplaybackmode' => { 299 => 0x1bf },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 113 => 0x8 },
	'quantizationmethod' => { 133 => 0x78 },
	'quickadjust' => { 279 => 0x2a },
	'quickcontroldialinmeter' => { 84 => 0x703 },
	'quickfix' => { 276 => 0x416391c6 },
	'quickshot' => { 400 => 0x213 },
	'quiettime' => { 138 => 0x188a },
	'rads' => { 384 => 'rads' },
	'rangefinder' => { 288 => '4.1', 289 => '5.1', 290 => '5.1' },
	'rangemask' => { 482 => 'RangeMaskMapInfo', 484 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 484 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 484 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 484 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 484 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 484 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 482 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 484 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 131 => 0x7d },
	'rating' => { 119 => 0x4746, 127 => 0x1431, 370 => 0xdf, 376 => 'rtng', 384 => 'rtng', 424 => 0x2002, 477 => 'rating', 486 => 'rating', 495 => 'Rating', 499 => 'rating', 507 => 'Rating' },
	'ratingpercent' => { 119 => 0x4749, 178 => 'Rating', 376 => 'rate', 507 => 'RatingPercent' },
	'ratingregion' => { 495 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 495 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 495 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 495 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 495 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 495 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 495 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 495 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 495 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 495 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 495 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 495 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 495 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 495 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 495 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 495 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 495 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 495 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 82 => 0x8, 186 => 0x109, 340 => 0xd },
	'rawbrightnessadj' => { 103 => 0x20001, 108 => 0x38 },
	'rawburstimagecount' => { 75 => 0x2 },
	'rawburstimagenum' => { 75 => 0x1 },
	'rawcoloradj' => { 108 => 0x2e },
	'rawcropbottom' => { 370 => 0xd4 },
	'rawcropleft' => { 370 => 0xd1 },
	'rawcropright' => { 370 => 0xd3 },
	'rawcroptop' => { 370 => 0xd2 },
	'rawcustomsaturation' => { 108 => 0x30 },
	'rawcustomtone' => { 108 => 0x34 },
	'rawdata' => { 398 => 0xa048 },
	'rawdatabyteorder' => { 398 => 0x40 },
	'rawdatacfapattern' => { 398 => 0x50 },
	'rawdatauniqueid' => { 119 => 0xc65d },
	'rawdepth' => { 188 => 0x10 },
	'rawdevartfilter' => { 308 => 0x121 },
	'rawdevautogradation' => { 308 => 0x119 },
	'rawdevcolorspace' => { 307 => 0x108, 308 => 0x109 },
	'rawdevcontrastvalue' => { 307 => 0x106, 308 => 0x105 },
	'rawdeveditstatus' => { 307 => 0x10b },
	'rawdevelopmentprocess' => { 359 => 0x62 },
	'rawdevengine' => { 307 => 0x109, 308 => 0x10b },
	'rawdevexposurebiasvalue' => { 307 => 0x100, 308 => 0x100 },
	'rawdevgradation' => { 308 => 0x112 },
	'rawdevgraypoint' => { 307 => 0x103, 308 => 0x104 },
	'rawdevmemorycoloremphasis' => { 307 => 0x105, 308 => 0x108 },
	'rawdevnoisereduction' => { 307 => 0x10a, 308 => 0x10a },
	'rawdevpicturemode' => { 308 => 0x10c },
	'rawdevpm_bwfilter' => { 308 => 0x110 },
	'rawdevpmcontrast' => { 308 => 0x10e },
	'rawdevpmnoisefilter' => { 308 => 0x120 },
	'rawdevpmpicturetone' => { 308 => 0x111 },
	'rawdevpmsaturation' => { 308 => 0x10d },
	'rawdevpmsharpness' => { 308 => 0x10f },
	'rawdevsaturation3' => { 308 => 0x113 },
	'rawdevsaturationemphasis' => { 307 => 0x104, 308 => 0x107 },
	'rawdevsettings' => { 307 => 0x10c },
	'rawdevsharpnessvalue' => { 307 => 0x107, 308 => 0x106 },
	'rawdevversion' => { 307 => 0x0, 308 => 0x0 },
	'rawdevwbfineadjustment' => { 307 => 0x102, 308 => 0x103 },
	'rawdevwhitebalance' => { 308 => 0x101 },
	'rawdevwhitebalancevalue' => { 307 => 0x101, 308 => 0x102 },
	'rawfile' => { 119 => 0xfe4c },
	'rawfilename' => { 482 => 'RawFileName', 484 => 'RawFileName' },
	'rawfiletype' => { 424 => 0x2029 },
	'rawformat' => { 329 => 0x2d, 368 => 0x10e },
	'rawimagecenter' => { 227 => 0x99 },
	'rawimagedigest' => { 119 => 0xc71c },
	'rawimagesize' => { 359 => 0x39 },
	'rawinfoversion' => { 309 => 0x0 },
	'rawjpgheight' => { 99 => 0x4 },
	'rawjpgquality' => { 57 => 0x6, 99 => 0x1 },
	'rawjpgsize' => { 57 => 0x7, 99 => 0x2 },
	'rawjpgwidth' => { 99 => 0x3 },
	'rawmeasuredrggb' => { 43 => 0x26a, 45 => 0x280, 47 => 0x194, 48 => [0x1ad,0x26b] },
	'rawrppused' => { 477 => 'rawrppused' },
	'rawtopreviewgain' => { 119 => 0xc7a8 },
	'readouttypeactual' => { 138 => 0x1903 },
	'readouttyperequested' => { 138 => 0x1902 },
	'reardisplay' => { 283 => '12.3', 284 => '6.2' },
	'recdevice' => { 495 => 'RecDevice' },
	'recdeviceattlensdescription' => { 495 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 495 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 495 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 495 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 495 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 501 => 'recipeEndingPage' },
	'recipepagerange' => { 501 => 'recipePageRange' },
	'recipesource' => { 501 => 'recipeSource' },
	'recipestartingpage' => { 501 => 'recipeStartingPage' },
	'recipetitle' => { 501 => 'recipeTitle' },
	'recognizedface1age' => { 317 => 0x20 },
	'recognizedface1name' => { 317 => 0x4 },
	'recognizedface1position' => { 317 => 0x18 },
	'recognizedface2age' => { 317 => 0x50 },
	'recognizedface2name' => { 317 => 0x34 },
	'recognizedface2position' => { 317 => 0x48 },
	'recognizedface3age' => { 317 => 0x80 },
	'recognizedface3name' => { 317 => 0x64 },
	'recognizedface3position' => { 317 => 0x78 },
	'recognizedfaceflags' => { 324 => 0x63 },
	'recommendedexposureindex' => { 119 => 0x8832, 489 => 'RecommendedExposureIndex' },
	'record' => { 118 => 'Record' },
	'recordbasisofrecord' => { 118 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 118 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 118 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 118 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 118 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 118 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 184 => 0x4d },
	'recorddynamicproperties' => { 118 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 97 => 0x1804 },
	'recordinformationwithheld' => { 118 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 384 => "\xa9phg" },
	'recordingformat' => { 391 => 0x1000 },
	'recordingmode' => { 112 => 0x1, 366 => 0x1 },
	'recordinstitutioncode' => { 118 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 118 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 384 => "\xa9lab" },
	'recordlabelurl' => { 384 => "\xa9lal" },
	'recordlocationdata' => { 231 => 0x660, 232 => 0x690 },
	'recordmode' => { 34 => 0x9, 113 => 0x3000 },
	'recordownerinstitutioncode' => { 118 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 400 => 0x217 },
	'redbalance' => { 306 => 0x1017, 329 => 0x11, 359 => 0x1c },
	'redcurvelimits' => { 108 => 0x18a },
	'redcurvepoints' => { 107 => 0x2d, 108 => 0x160 },
	'redeyecorrection' => { 280 => 0x0 },
	'redeyeinfo' => { 482 => 'RedEyeInfo', 484 => 'RedEyeInfo' },
	'redeyereduction' => { 184 => 0x41, 411 => 0x6a, 413 => 0x28 },
	'redeyeremoval' => { 324 => 0xb9 },
	'redhsl' => { 103 => 0x20910 },
	'redhue' => { 482 => 'RedHue', 484 => 'RedHue' },
	'redsaturation' => { 482 => 'RedSaturation', 484 => 'RedSaturation' },
	'reductionmatrix1' => { 119 => 0xc625 },
	'reductionmatrix2' => { 119 => 0xc626 },
	'reductionmatrix3' => { 119 => 0xcd3a },
	'reelname' => { 119 => 0xc789, 384 => 'reel' },
	'reference1' => { 493 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 493 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 119 => 0x214, 505 => 'ReferenceBlackWhite' },
	'referencedate' => { 131 => 0x2f },
	'referencenumber' => { 131 => 0x32 },
	'references' => { 157 => 'References' },
	'referenceservice' => { 131 => 0x2d },
	'regionappliedtodimensions' => { 172 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 172 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 172 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 172 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 172 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 172 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 172 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 172 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 172 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 172 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 172 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 172 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 311 => 'RegionConstraints' },
	'regiondescription' => { 172 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 172 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 172 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 172 => 'Regions' },
	'regioninfodateregionsvalid' => { 175 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 175 => 'RegionInfo' },
	'regioninforegions' => { 175 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 172 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 172 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 175 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 172 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 172 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 172 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 495 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 495 => 'RegistryId' },
	'registryitemid' => { 495 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 495 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 155 => 'data' },
	'relatedaudiofilename' => { 155 => '1Name' },
	'relatedaudiofiletype' => { 155 => '0Type' },
	'relatedimagefileformat' => { 119 => 0x1000 },
	'relatedimageheight' => { 119 => 0x1002 },
	'relatedimagewidth' => { 119 => 0x1001 },
	'relatedresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 119 => 0xa004, 488 => 'RelatedSoundFile' },
	'relatedvideofile' => { 169 => 'data' },
	'relatedvideofilename' => { 169 => '1Name' },
	'relatedvideofiletype' => { 169 => '0Type' },
	'relation' => { 485 => 'relation' },
	'relationshipaccordingto' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 116 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 509 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 509 => 'relativeTimestamp' },
	'relativetimestampscale' => { 509 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 509 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 283 => '17.8', 284 => '18.5', 286 => '18.4', 287 => '18.4', 292 => '33.8', 293 => '17.6', 296 => '18.5', 297 => '18.4' },
	'releasedate' => { 131 => 0x1e, 376 => 'rldt', 477 => 'ReleaseDate', 509 => 'releaseDate' },
	'releasemode' => { 113 => 0x3001, 251 => 0x184d, 424 => 0xb049 },
	'releasemode2' => { 433 => 0x112c, 434 => [0x112c,0x8], 435 => [0x1108,0x8], 436 => [0x1184,0x8], 437 => [0x1160,0x8], 438 => [0x4,0x1018], 439 => [0x4,0x210], 440 => [0x4,0x210], 441 => [0x4,0x208], 443 => [0x67,0x3f], 444 => [0x6b,0x6d,0x73,0x4b], 445 => [0x6b,0x4b], 446 => 0x10, 447 => 0x10, 448 => 0x9, 455 => 0x34 },
	'releasemode3' => { 433 => 0x1128, 434 => 0x1128, 435 => 0x1104, 436 => 0x1180, 437 => 0x115c, 438 => 0x1014, 439 => 0x20c, 440 => 0x20c, 441 => 0x204 },
	'releaseready' => { 495 => 'ReleaseReady' },
	'releasesetting' => { 97 => 0x1016 },
	'releasetime' => { 131 => 0x23, 477 => 'ReleaseTime' },
	'remoteonduration' => { 285 => '3.4', 288 => '17.2', 289 => '18.2', 290 => '18.2', 291 => '18.2', 293 => '18.2', 294 => '4.3', 298 => '19.2' },
	'renditionclass' => { 510 => 'RenditionClass' },
	'renditionof' => { 510 => 'RenditionOf' },
	'renditionofalternatepaths' => { 510 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 510 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 510 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 510 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 510 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 510 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 510 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 510 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 510 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 510 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 510 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 510 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 510 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 510 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 510 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 510 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 510 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 510 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 510 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 510 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 510 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 510 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 510 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 510 => 'RenditionParams' },
	'repeatingflashcount' => { 209 => 0xd, 210 => 0xe, 211 => 0xe, 212 => 0xe, 213 => 0xe, 214 => 0xe, 292 => '17.2', 293 => '24.2', 294 => '9.2', 295 => '24.2', 298 => '25.2' },
	'repeatingflashcountbuilt-in' => { 260 => 0x4db },
	'repeatingflashcountexternal' => { 260 => 0x4c3 },
	'repeatingflashoutput' => { 292 => '17.1', 293 => '24.1', 294 => '9.1', 295 => '24.1', 298 => '25.1' },
	'repeatingflashoutputexternal' => { 260 => 0x4c0 },
	'repeatingflashrate' => { 209 => 0xc, 210 => 0xd, 211 => 0xd, 212 => 0xd, 213 => 0xd, 214 => 0xd, 292 => '18.1', 293 => '25.1', 294 => '10.1', 295 => '25.1', 298 => '26.1' },
	'repeatingflashratebuilt-in' => { 260 => 0x4da },
	'repeatingflashrateexternal' => { 260 => 0x4c2 },
	'requirements' => { 384 => "\xa9req" },
	'requires' => { 480 => 'requires' },
	'resampleparams' => { 509 => 'resampleParams' },
	'resampleparamsquality' => { 509 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 138 => 0xe50 },
	'resamplingkerneldenominators067' => { 138 => 0xe4f },
	'resamplingkerneldenominators100' => { 138 => 0xe51 },
	'resaved' => { 400 => 0x21e },
	'resetblacksegrows' => { 138 => 0x181a },
	'resolution' => { 162 => 'Resolution' },
	'resolutionmode' => { 401 => [0x87,0x4] },
	'resolutionunit' => { 119 => 0x128, 134 => 0x2, 505 => 'ResolutionUnit' },
	'resourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 118 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 84 => 0x612 },
	'restrictions' => { 502 => 'restrictions' },
	'retouchareafeather' => { 482 => [\'RetouchAreas','RetouchAreasFeather'], 484 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 482 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 484 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 482 => [\'RetouchAreas','RetouchAreasMasksAngle'], 484 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 482 => [\'RetouchAreas','RetouchAreasMasksBottom'], 484 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 482 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 484 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 482 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 484 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 482 => [\'RetouchAreas','RetouchAreasMasksDabs'], 484 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 482 => [\'RetouchAreas','RetouchAreasMasksFeather'], 484 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 482 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 484 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 482 => [\'RetouchAreas','RetouchAreasMasksFlow'], 484 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 482 => [\'RetouchAreas','RetouchAreasMasksFullX'], 484 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 482 => [\'RetouchAreas','RetouchAreasMasksFullY'], 484 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 482 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 484 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 482 => [\'RetouchAreas','RetouchAreasMasksLeft'], 484 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasks'], 484 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 482 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 484 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 482 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 484 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 482 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 484 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 482 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 484 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 482 => [\'RetouchAreas','RetouchAreasMasksRadius'], 484 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 482 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 484 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 482 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 484 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 482 => [\'RetouchAreas','RetouchAreasMasksRight'], 484 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 482 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 484 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 482 => [\'RetouchAreas','RetouchAreasMasks'], 484 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 482 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 484 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 482 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 484 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 482 => [\'RetouchAreas','RetouchAreasMasksTop'], 484 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 482 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 484 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 482 => [\'RetouchAreas','RetouchAreasMasksVersion'], 484 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 482 => [\'RetouchAreas','RetouchAreasMasksWhat'], 484 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 482 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 484 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 482 => [\'RetouchAreas','RetouchAreasMasksX'], 484 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 482 => [\'RetouchAreas','RetouchAreasMasksY'], 484 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 482 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 484 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 482 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 484 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 482 => [\'RetouchAreas','RetouchAreasMethod'], 484 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 482 => [\'RetouchAreas','RetouchAreasOffsetY'], 484 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 482 => [\'RetouchAreas','RetouchAreasOpacity'], 484 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 482 => 'RetouchAreas', 484 => 'RetouchAreas' },
	'retouchareaseed' => { 482 => [\'RetouchAreas','RetouchAreasSeed'], 484 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 482 => [\'RetouchAreas','RetouchAreasSourceState'], 484 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 482 => [\'RetouchAreas','RetouchAreasSourceX'], 484 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 482 => [\'RetouchAreas','RetouchAreasSpotType'], 484 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 227 => 0x9e },
	'retouchinfo' => { 482 => 'RetouchInfo', 484 => 'RetouchInfo' },
	'retouchnefprocessing' => { 240 => 0x5 },
	'retractlensonpoweroff' => { 84 => 0x814 },
	'reuse' => { 311 => 'Reuse' },
	'reuseallowed' => { 512 => 'ReuseAllowed' },
	'reuseprohibited' => { 502 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 290 => '5.2' },
	'reversefocusring' => { 299 => 0x163 },
	'reverseindicators' => { 283 => '12.1', 284 => '6.1', 286 => '6.1', 287 => '6.1', 288 => '4.3', 289 => '5.2', 290 => '5.4', 292 => '33.5', 293 => '5.1', 296 => '6.1', 297 => '6.1', 298 => '6.2', 299 => 0xc1 },
	'reverseshutterspeedaperture' => { 290 => '5.3' },
	'revision' => { 486 => 'revision' },
	'rflensmffocusringsensitivity' => { 84 => 0x714 },
	'rflenstype' => { 57 => 0x3d },
	'rgbcurvelimits' => { 108 => 0x238 },
	'rgbcurvepoints' => { 107 => 0x7, 108 => 0x20e },
	'rgbtables' => { 119 => 0xcd3b },
	'richtextcomment' => { 491 => 'RichTextComment' },
	'ricohdate' => { 390 => 0x6 },
	'ricohimageheight' => { 390 => 0x2 },
	'ricohimagewidth' => { 390 => 0x0 },
	'rightalbedo' => { 473 => 'RightAlbedo' },
	'rightascension' => { 165 => 'RightAscension' },
	'rights' => { 485 => 'rights' },
	'rightsagent' => { 502 => 'rightsAgent' },
	'rightsowner' => { 502 => 'rightsOwner' },
	'roll' => { 115 => 0x8, 384 => ['roll',"\xa9frl"] },
	'rollangle' => { 127 => 0x144d, 251 => 0x350b, 252 => 0x2c24, 256 => 0xc21a, 261 => 0x36f4, 262 => 0x2efb, 264 => 0xce32, 265 => 0x80c5, 301 => 0x903, 324 => 0x90, 358 => 0x1, 396 => 0x2 },
	'romoperationmode' => { 97 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 96 => 0x3, 103 => 0x10002, 108 => 0x26e, 114 => 'QuickTime-Rotation', 123 => 0x4, 165 => 'Rotation', 182 => [0x65,0x50], 183 => 0x46, 184 => 0x5a, 187 => 0x10, 251 => 0x3693, 252 => 0xca, 259 => '590.1', 276 => 0x76a43207, 324 => 0x30, 340 => '17.2', 370 => 0xd8, 377 => 'irot', 411 => 0x3f, 412 => 0x3f, 422 => 0x10 },
	'routedto' => { 490 => 'RoutedTo' },
	'routing' => { 375 => 'Routing' },
	'routingdestinations' => { 472 => 'RoutingDestinations' },
	'routingexclusions' => { 472 => 'RoutingExclusions' },
	'routingnotes' => { 490 => 'RoutingNotes' },
	'rowsperstrip' => { 119 => 0x116 },
	'rpp' => { 477 => 'rpp' },
	'rtkflag' => { 116 => 'RtkFlag' },
	'rtkstdhgt' => { 116 => 'RtkStdHgt' },
	'rtkstdlat' => { 116 => 'RtkStdLat' },
	'rtkstdlon' => { 116 => 'RtkStdLon' },
	'safetyshift' => { 84 => 0x108 },
	'safetyshiftinavortv' => { 82 => 0x10, 83 => 0x10, 85 => 0xf, 86 => 0x10, 89 => 0x10 },
	'sameexposurefornewaperture' => { 84 => 0x112 },
	'samplebits' => { 155 => 'SampleBits' },
	'samplepagerange' => { 499 => 'samplePageRange' },
	'samplerate' => { 155 => 'SampleRate' },
	'samplesperpixel' => { 119 => 0x115, 329 => 0x8, 505 => 'SamplesPerPixel' },
	'samplestructure' => { 133 => 0x5a },
	'samsungmodelid' => { 398 => 0x3 },
	'sanyoquality' => { 400 => 0x201 },
	'sanyothumbnail' => { 400 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 51 => 0x1, 63 => 0x7, 112 => 0xd, 113 => [0x3013,0x1f], 119 => [0xa409,0xfe55], 127 => 0x1003, 156 => 'Saturation', 181 => 0x1f, 182 => 0x32, 183 => 0x28, 184 => 0x1a, 189 => 0x1, 227 => 0xaa, 235 => 0x35, 236 => 0x3b, 237 => 0x43, 324 => 0x40, 326 => 0x300d, 359 => 0x1f, 366 => 0xd, 385 => 0x27, 387 => 0x58, 390 => 0x28, 391 => 0x1013, 401 => 0x10, 411 => 0x1e, 412 => 0x1b, 424 => 0x2005, 482 => 'Saturation', 484 => 'Saturation', 488 => 'Saturation' },
	'saturationadj' => { 103 => 0x20901, 108 => 0x116, 227 => 0x94, 275 => 0x1, 279 => 0x2e, 459 => 0x8016 },
	'saturationadjustmentaqua' => { 482 => 'SaturationAdjustmentAqua', 484 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 482 => 'SaturationAdjustmentBlue', 484 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 482 => 'SaturationAdjustmentGreen', 484 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 482 => 'SaturationAdjustmentMagenta', 484 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 482 => 'SaturationAdjustmentOrange', 484 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 482 => 'SaturationAdjustmentPurple', 484 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 482 => 'SaturationAdjustmentRed', 484 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 482 => 'SaturationAdjustmentYellow', 484 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 71 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 70 => 0x68, 71 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 70 => 0x38, 71 => 0x38 },
	'saturationmonochrome' => { 70 => 0x80, 71 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 70 => 0x50, 71 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 70 => 0x20, 71 => 0x20 },
	'saturationsetting' => { 309 => 0x1010, 413 => 0x11, 429 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 70 => 0x8, 71 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 70 => 0x98, 71 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 70 => 0xb0, 71 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 70 => 0xc8, 71 => 0xe0 },
	'saveid' => { 510 => 'SaveID' },
	'sbaanalysiscomplete' => { 138 => 0xc35 },
	'sbablack' => { 138 => 0xc25 },
	'sbagmoffset' => { 138 => 0xc4a },
	'sbagray' => { 138 => 0xc26 },
	'sbagreenmagentabal' => { 138 => 0xc33 },
	'sbahighgray' => { 138 => 0xc46 },
	'sbailloffset' => { 138 => 0xc49 },
	'sbailluminantbal' => { 138 => 0xc34 },
	'sbalowgray' => { 138 => 0xc47 },
	'sbaneutralbal' => { 138 => 0xc32 },
	'sbawhite' => { 138 => 0xc27 },
	'scaletype' => { 509 => 'scaleType' },
	'scanimageenhancer' => { 241 => 0x60 },
	'scanningdirection' => { 133 => 0x64 },
	'scene' => { 384 => 'scen', 494 => 'Scene', 509 => 'scene' },
	'scenearea' => { 304 => 0x211, 306 => 0x1031 },
	'sceneassist' => { 227 => 0x9c },
	'scenecapturetype' => { 119 => 0xa406, 488 => 'SceneCaptureType' },
	'scenedetect' => { 304 => 0x210, 306 => 0x1030 },
	'scenedetectdata' => { 304 => 0x212, 306 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 142 => 0xfa02, 186 => 0x100, 227 => 0x8f, 301 => 0x509, 306 => 0x403, 324 => 0x8001, 333 => 0xf, 424 => 0xb023 },
	'scenemodeused' => { 144 => [0x6002,0xf002] },
	'scenerecognition' => { 127 => 0x1425 },
	'scenereferred' => { 492 => 'scene_referred' },
	'sceneselect' => { 400 => 0x21f },
	'scenetype' => { 119 => 0xa301, 488 => 'SceneType' },
	'screentips' => { 283 => '12.7', 284 => '5.3', 292 => '13.1', 293 => '4.4', 296 => '5.4', 298 => '5.1' },
	'scriptversion' => { 138 => 0x1770 },
	'sdrblend' => { 482 => 'SDRBlend', 484 => 'SDRBlend' },
	'sdrbrightness' => { 482 => 'SDRBrightness', 484 => 'SDRBrightness' },
	'sdrcontrast' => { 482 => 'SDRContrast', 484 => 'SDRContrast' },
	'sdrhighlights' => { 482 => 'SDRHighlights', 484 => 'SDRHighlights' },
	'sdrshadows' => { 482 => 'SDRShadows', 484 => 'SDRShadows' },
	'sdrwhites' => { 482 => 'SDRWhites', 484 => 'SDRWhites' },
	'season' => { 495 => 'Season', 498 => 'season' },
	'seasonidentifier' => { 495 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 495 => [\'Season','SeasonName'] },
	'seasonnumber' => { 495 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 472 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 231 => 0x22c, 232 => 0x240, 251 => 0x1d0, 261 => 0x1d0 },
	'section' => { 499 => 'section' },
	'securityclassification' => { 119 => 0x9212 },
	'selectableafpoint' => { 84 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 84 => 0x512 },
	'selfdata' => { 116 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 324 => 0x2e, 400 => 0x214, 433 => 0x1134, 434 => 0x1134, 435 => 0x1110, 436 => 0x118c, 437 => 0x1168, 438 => 0x1020, 439 => 0x218, 440 => 0x218, 441 => 0x210 },
	'selftimer2' => { 77 => 0x1d },
	'selftimerinterval' => { 293 => '19.2' },
	'selftimermode' => { 119 => 0x882b },
	'selftimershotcount' => { 284 => '20.2', 286 => '20.3', 287 => '20.3', 288 => '18.2', 289 => '19.2', 290 => '19.2', 291 => '19.3', 293 => '19.3', 296 => '20.3', 297 => '20.3', 298 => '20.2', 299 => 0x2d },
	'selftimershotinterval' => { 284 => '20.3', 286 => '20.2', 287 => '20.2', 291 => '19.2', 296 => '20.2', 297 => '20.2', 299 => 0x31 },
	'selftimertime' => { 97 => 0x1806, 184 => 0x1f, 283 => '18.1', 284 => '20.1', 285 => '3.3', 286 => '20.1', 287 => '20.1', 288 => '18.1', 289 => '19.1', 290 => '19.1', 291 => '19.1', 292 => '7.2', 293 => '19.1', 294 => '3.3', 296 => '20.1', 297 => '20.1', 298 => '20.1', 299 => 0x2b },
	'sellingagency' => { 499 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 119 => 0x8546 },
	'sensingmethod' => { 119 => 0xa217, 488 => 'SensingMethod' },
	'sensitivityadjust' => { 359 => 0x40 },
	'sensitivitysteps' => { 340 => ['14.3','17.4'], 342 => 0x1 },
	'sensitivitytype' => { 119 => 0x8830, 489 => 'SensitivityType' },
	'sensor' => { 191 => 0x665e },
	'sensorarea' => { 306 => 0x400 },
	'sensorareas' => { 398 => 0xa010 },
	'sensorbitdepth' => { 326 => 0x312d },
	'sensorbluelevel' => { 74 => 0x5 },
	'sensorcalibration' => { 305 => 0x805 },
	'sensorcleaning' => { 90 => 0xd },
	'sensorfullheight' => { 137 => 0xf904 },
	'sensorfullwidth' => { 137 => 0xf903 },
	'sensorheight' => { 137 => 0xf901, 142 => 0xfa21, 188 => 0x8, 326 => 0x312c, 368 => 0x109, 391 => 0x1602 },
	'sensorimageheight' => { 138 => 0x3ee },
	'sensorimagewidth' => { 138 => 0x3ed },
	'sensorleftborder' => { 138 => 0x3eb },
	'sensorleftmargin' => { 368 => 0x10a },
	'sensorpixelsize' => { 227 => 0x9a },
	'sensorredlevel' => { 74 => 0x4 },
	'sensorserialnumber' => { 138 => 0x9ce },
	'sensorshield' => { 231 => 0x66d, 232 => 0x69d },
	'sensorsize' => { 156 => 'SensorSize', 359 => 0x35 },
	'sensortemperature' => { 304 => 0x1500, 306 => 0x1007, 364 => 0xc, 368 => 0x210, 401 => [0x39,0x55] },
	'sensortemperature2' => { 364 => 0xe, 368 => 0x211 },
	'sensortopborder' => { 138 => 0x3ec },
	'sensortopmargin' => { 368 => 0x10b },
	'sensortype' => { 324 => 0xca },
	'sensorwidth' => { 137 => 0xf900, 142 => 0xfa20, 188 => 0xa, 326 => 0x312b, 368 => 0x108, 391 => 0x1601 },
	'sequence' => { 385 => 0x7, 386 => 0x35, 387 => 0x36 },
	'sequencefilenumber' => { 434 => 0x4, 435 => 0x4, 436 => 0x4, 437 => 0x4, 446 => 0xc, 447 => 0xc, 448 => 0x1a },
	'sequenceimagenumber' => { 434 => 0x0, 435 => 0x0, 436 => 0x0, 437 => 0x0, 446 => 0x8, 447 => 0x8, 448 => 0x12, 455 => 0x24 },
	'sequencelength' => { 446 => 0x22, 447 => 0x1e, 448 => [0x16,0x1e] },
	'sequencename' => { 498 => 'sequenceName' },
	'sequencenumber' => { 77 => 0x9, 113 => 0x301c, 127 => 0x1101, 140 => 0x1d, 260 => 0x51c, 324 => 0x2b, 413 => [0x10c,0x30c], 424 => 0xb04a, 498 => 'sequenceNumber' },
	'sequenceshotinterval' => { 400 => 0x224 },
	'sequencetotalnumber' => { 498 => 'sequenceTotalNumber' },
	'sequentialshot' => { 400 => 0x20e },
	'serialnumber' => { 64 => 0xc, 97 => 0x180b, 119 => [0xa431,0xfde9], 137 => 0xfa04, 139 => 0xfa00, 141 => 0xc354, 142 => 0xfa19, 153 => 0x0, 156 => 'SerialNumber', 191 => 0x5501, 227 => [0xa0,0x1d], 302 => 0x101, 306 => [0x404,0x101a], 319 => 0x303, 321 => 0x305, 326 => 0x3103, 359 => 0x229, 368 => 0x102, 369 => 0x407, 384 => ['SNum','slno'], 385 => 0x15, 386 => 0x4b, 387 => 0x7e, 391 => 0x5, 398 => 0xa002, 401 => 0x2, 424 => 0x2031, 479 => 'SerialNumber', 489 => 'BodySerialNumber' },
	'serialnumberformat' => { 64 => 0x15, 97 => 0x183b },
	'serialnumberhash' => { 384 => 'CAME' },
	'series' => { 495 => 'Series' },
	'seriesdatetime' => { 461 => 'SeriesDateTime' },
	'seriesdescription' => { 461 => 'SeriesDescription' },
	'seriesidentifier' => { 495 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 461 => 'SeriesModality' },
	'seriesname' => { 495 => [\'Series','SeriesName'] },
	'seriesnumber' => { 461 => 'SeriesNumber', 499 => 'seriesNumber' },
	'seriestitle' => { 499 => 'seriesTitle' },
	'serviceidentifier' => { 132 => 0x1e },
	'servingsize' => { 501 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 87 => 0x0, 88 => 0x0 },
	'setbuttonwhenshooting' => { 82 => 0x1, 84 => 0x704, 90 => 0xc },
	'setclockfromlocationdata' => { 231 => 0x61d, 232 => 0x64d },
	'setfunctionwhenshooting' => { 85 => 0x0, 86 => 0x1, 89 => 0x1 },
	'setting' => { 498 => 'setting' },
	'shadingcompensation' => { 301 => 0x50c, 324 => 0x8a },
	'shadingcompensation2' => { 305 => 0x1012 },
	'shadow' => { 401 => 0xe },
	'shadowadj' => { 103 => 0x2030b },
	'shadowcorrection' => { 359 => 0x79 },
	'shadowprotection' => { 275 => 0x0 },
	'shadows' => { 119 => 0xfe52, 424 => 0x2032, 476 => 'Shadows', 482 => 'Shadows', 484 => 'Shadows' },
	'shadows2012' => { 482 => 'Shadows2012', 484 => 'Shadows2012' },
	'shadowsadj' => { 459 => 0x901a },
	'shadowscale' => { 119 => 0xc633 },
	'shadowtint' => { 482 => 'ShadowTint', 484 => 'ShadowTint' },
	'shadowtone' => { 127 => 0x1040 },
	'shakereduction' => { 361 => 0x1, 362 => 0x1 },
	'shareduserrating' => { 179 => 'WM/SharedUserRating' },
	'sharpendetail' => { 482 => 'SharpenDetail', 484 => 'SharpenDetail' },
	'sharpenedgemasking' => { 482 => 'SharpenEdgeMasking', 484 => 'SharpenEdgeMasking' },
	'sharpening' => { 326 => 0x300b },
	'sharpeningadj' => { 279 => 0x2b },
	'sharpeningkernel' => { 138 => 0x92f },
	'sharpenradius' => { 482 => 'SharpenRadius', 484 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 63 => 0x6, 74 => 0x2, 112 => 0xb, 113 => [0x3011,0x21], 119 => [0xa40a,0xfe56], 127 => 0x1001, 140 => 0x6b, 149 => 0x37, 156 => 'Sharpness', 181 => 0x21, 182 => 0x30, 183 => 0x26, 184 => 0x18, 189 => 0x3, 227 => 0x6, 235 => 0x32, 236 => 0x33, 237 => 0x39, 306 => 0x100f, 324 => 0x41, 359 => 0x21, 366 => 0xb, 385 => 0x26, 387 => 0x56, 390 => 0x22, 391 => [0x1003,0x1014], 401 => 0x11, 411 => 0x1c, 412 => 0x19, 424 => 0x2006, 455 => 0x52, 482 => 'Sharpness', 484 => 'Sharpness', 488 => 'Sharpness' },
	'sharpnessadj' => { 103 => 0x20310, 108 => 0x25a, 459 => 0x801a },
	'sharpnessadjon' => { 103 => '0x20310.0' },
	'sharpnessauto' => { 71 => 0x94 },
	'sharpnessfactor' => { 306 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 70 => 0x64, 71 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 74 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 70 => 0x34, 71 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 70 => 0x7c, 71 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 70 => 0x4c, 71 => 0x4c },
	'sharpnessovershoot' => { 459 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 70 => 0x1c, 71 => 0x1c },
	'sharpnessrange' => { 424 => 0x2035 },
	'sharpnesssetting' => { 301 => 0x506, 309 => 0x1013, 413 => 0x12, 429 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 70 => 0x4, 71 => 0x4 },
	'sharpnessstrength' => { 103 => 0x20311 },
	'sharpnessthreshold' => { 459 => 0x801d },
	'sharpnessundershoot' => { 459 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 70 => 0x94, 71 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 70 => 0xac, 71 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 70 => 0xc4, 71 => 0xdc },
	'shiftcols' => { 138 => 0xc70 },
	'shootid' => { 498 => 'shootID' },
	'shootingdistance' => { 103 => 0x20701 },
	'shootinginfodisplay' => { 283 => '13.2', 284 => '5.1', 292 => '10.2', 293 => '4.1', 296 => '5.1', 298 => '5.3' },
	'shootinginfomonitorofftime' => { 283 => '26.2', 284 => '22.2', 286 => '22.2', 287 => '22.2', 291 => '21.2', 292 => '9.1', 293 => '21.2', 296 => '22.2', 297 => '22.2', 298 => '22.2', 299 => 0x37 },
	'shootingmode' => { 156 => 'ShootingMode', 227 => 0x89, 324 => 0x1f },
	'shootingmodesetting' => { 285 => '5.1' },
	'shortdescription' => { 486 => 'shortdescription' },
	'shortdocumentid' => { 131 => 0xba },
	'shortname' => { 482 => 'ShortName', 484 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 84 => 0x80d },
	'shorttitle' => { 376 => '@sti' },
	'shotdate' => { 509 => 'shotDate' },
	'shotday' => { 509 => 'shotDay' },
	'shotlocation' => { 509 => 'shotLocation' },
	'shotlogdata' => { 465 => 'shot_log_data' },
	'shotname' => { 384 => 'shot', 509 => 'shotName' },
	'shotnumber' => { 509 => 'shotNumber' },
	'shotnumbersincepowerup' => { 428 => 0x44e, 446 => 0x1a, 447 => 0x16, 448 => 0xa },
	'shotnumbersincepowerup2' => { 413 => 0x200 },
	'shotsize' => { 509 => 'shotSize' },
	'shotsperinterval' => { 230 => 0xb4, 231 => 0xc0, 232 => 0xd0, 256 => 0xc412 },
	'showmovement' => { 376 => 'shwm' },
	'shownevent' => { 495 => 'EventExt' },
	'showneventidentifier' => { 495 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 495 => [\'EventExt','EventExtName'] },
	'shutter' => { 443 => 0x20, 444 => 0x26, 445 => 0x26 },
	'shutter-aelock' => { 82 => 0x4, 84 => 0x701, 85 => 0x3, 86 => 0x4, 87 => 0x3, 88 => 0x3, 89 => 0x4, 90 => 0x2 },
	'shutteraelbutton' => { 83 => 0x4 },
	'shutterbuttonafonbutton' => { 84 => 0x701 },
	'shuttercount' => { 11 => 0x176, 57 => 0x1, 227 => 0xa7, 242 => [0x6a,0x157,0x24d], 243 => 0x286, 244 => 0x279, 245 => 0x284, 246 => 0x242, 247 => 0x280, 248 => 0x276, 249 => [0x27d,0x27f], 250 => 0x246, 253 => 0x2d6, 254 => 0x321, 255 => 0xbd8, 257 => 0x287, 258 => 0x320, 259 => 0x24a, 260 => 0x5fb, 263 => 0x2d5, 359 => 0x5d, 422 => 0x846, 427 => [0x125,0x14a], 443 => 0x32, 444 => 0x3a, 445 => 0x3a },
	'shuttercount2' => { 443 => 0x4c, 444 => [0x50,0x52,0x58], 445 => 0x50 },
	'shuttercount3' => { 443 => [0x1a0,0x1aa,0x1bd], 444 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 82 => 0xf, 83 => 0xf, 84 => 0x305, 85 => 0xe, 86 => 0xf, 87 => 0x8, 88 => 0x8, 89 => 0xf, 90 => 0x8 },
	'shuttermode' => { 57 => 0x17, 140 => 0x1b, 227 => 0x34 },
	'shutterreleasebuttonae-l' => { 283 => '17.7', 284 => '18.4', 286 => '78.4', 287 => '78.4', 288 => '16.1', 289 => '17.1', 290 => '17.1', 291 => '17.1', 292 => '7.1', 293 => '17.5', 296 => '18.4', 297 => '78.4', 298 => '18.2', 299 => 0x29 },
	'shutterreleasemethod' => { 97 => 0x1010 },
	'shutterreleasenocfcard' => { 82 => 0x2, 83 => 0x2, 90 => 0xf },
	'shutterreleasetiming' => { 97 => 0x1011 },
	'shutterreleasewithoutlens' => { 84 => 0x711 },
	'shutterspeedlock' => { 284 => '38.1', 286 => '38.1', 287 => '38.1', 296 => '38.1', 297 => '38.1', 299 => 0xb7 },
	'shutterspeedrange' => { 84 => 0x10c },
	'shutterspeedsetting' => { 184 => 0x6, 411 => 0x2f, 412 => 0x28, 413 => 0x0 },
	'shutterspeedvalue' => { 93 => 0x1, 119 => 0x9201, 306 => 0x1000, 368 => 0x400, 488 => 'ShutterSpeedValue' },
	'shuttertype' => { 127 => 0x1050, 324 => 0x9f, 359 => 0x87 },
	'sidecarforextension' => { 497 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 138 => 0xe0d },
	'sigmascalingfactorcamera' => { 138 => 0xe0c },
	'sigmascalingfactorlowres' => { 138 => 0xe0b },
	'sigmasizetable' => { 138 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 227 => 0xbf },
	'similarityindex' => { 131 => 0xe4 },
	'singleframebracketing' => { 184 => 0x21 },
	'skilllevel' => { 501 => 'skillLevel' },
	'skintonecorrection' => { 359 => 0x95 },
	'skiplinetime' => { 138 => 0x184e },
	'slaveflashmeteringsegments' => { 359 => 0x20b },
	'slideshowname' => { 498 => 'slideshowName' },
	'slideshownumber' => { 498 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 498 => 'slideshowTotalNumber' },
	'slowshutter' => { 77 => 0x8 },
	'slowsync' => { 127 => 0x1030 },
	'smartalbumcolor' => { 398 => 0x20 },
	'smartrange' => { 398 => 0xa012 },
	'smileshutter' => { 413 => 0x31 },
	'smileshuttermode' => { 413 => 0x27 },
	'smoothness' => { 119 => 0xfe57, 482 => 'Smoothness', 484 => 'Smoothness' },
	'snapshot' => { 495 => 'SnapshotLink' },
	'snapshotformat' => { 495 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 495 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 495 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 495 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 495 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 477 => 'Snapshots' },
	'snapshotusedvideoframe' => { 495 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 495 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 495 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 495 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 495 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 424 => 0x200f },
	'software' => { 119 => 0x131, 157 => 'Software', 314 => 'Software', 368 => 0x203, 378 => 'software', 401 => 0x18, 467 => 'Software', 505 => 'Software' },
	'softwareversion' => { 384 => ['@swr',"\xa9swr"], 400 => 0x207 },
	'soloist' => { 376 => "\xa9sol" },
	'songwriter' => { 384 => "\xa9swf" },
	'songwriterkeywords' => { 384 => "\xa9swk" },
	'sonycropsize' => { 119 => 0x74c8 },
	'sonycroptopleft' => { 119 => 0x74c7 },
	'sonydatetime' => { 432 => 0x6, 434 => 0x1b6, 435 => 0x210, 436 => 0x1fe, 437 => 0x22c },
	'sonydatetime2' => { 443 => 0x51 },
	'sonyexposuretime' => { 443 => 0x3a, 444 => 0x46, 445 => [0x66,0x46] },
	'sonyexposuretime2' => { 455 => 0xe },
	'sonyfnumber' => { 443 => 0x3c, 444 => 0x48, 445 => [0x68,0x48], 455 => 0x14 },
	'sonyimageheight' => { 432 => 0x1a, 446 => 0x44, 447 => 0x3f, 448 => 0x47 },
	'sonyimageheightmax' => { 455 => 0x40 },
	'sonyimagesize' => { 184 => 0x3b, 411 => 0x54, 412 => 0x54, 413 => 0x9 },
	'sonyimagewidth' => { 432 => 0x1c },
	'sonyimagewidthmax' => { 455 => 0x3e },
	'sonyiso' => { 434 => 0x1218, 435 => 0x11f4, 436 => 0x1270, 437 => [0x1254,0x1258,0x1280], 438 => 0x113c, 439 => 0x344, 440 => 0x346, 441 => 0x320, 455 => 0x4 },
	'sonymaxaperture' => { 443 => 0x0, 444 => 0x0 },
	'sonymaxaperturevalue' => { 455 => 0x16 },
	'sonyminaperture' => { 443 => 0x1, 444 => 0x1 },
	'sonymodelid' => { 424 => 0xb001 },
	'sonyquality' => { 184 => 0x3c },
	'sonytimeminsec' => { 444 => 0x61 },
	'sortalbum' => { 376 => 'soal' },
	'sortalbumartist' => { 376 => 'soaa' },
	'sortartist' => { 376 => 'soar' },
	'sortcomposer' => { 376 => 'soco' },
	'sortname' => { 376 => 'sonm', 482 => 'SortName', 484 => 'SortName' },
	'sortshow' => { 376 => 'sosn' },
	'soundengineer' => { 376 => "\xa9sne" },
	'source' => { 131 => 0x73, 314 => 'Source', 485 => 'source', 486 => 'source', 497 => 'Source' },
	'sourcecount' => { 471 => 'SourceCount' },
	'sourcecredits' => { 384 => "\xa9src" },
	'sourcedirectoryindex' => { 346 => 0x0 },
	'sourcefileindex' => { 346 => 0x2 },
	'sourcephotoscount' => { 470 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 138 => 0x1390 },
	'spatialfrequencyresponse' => { 488 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 488 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 488 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 488 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 488 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 509 => 'speakerPlacement' },
	'specialeffectlevel' => { 113 => 0x3030 },
	'specialeffectmode' => { 113 => 0x2076 },
	'specialeffectsetting' => { 113 => 0x3031 },
	'specialinstructions' => { 131 => 0x28 },
	'specialmode' => { 306 => 0x200, 400 => 0x200 },
	'specialoccasion' => { 501 => 'specialOccasion' },
	'specialtypeid' => { 465 => 'SpecialTypeID' },
	'spectralsensitivity' => { 119 => 0x8824, 488 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 42 => 0x281, 45 => [0x2b9,0x2d0,0x2d4], 46 => 0x56a, 47 => 0x1e4, 48 => [0x1fd,0x2dd], 49 => [0x231,0x30f], 50 => 0x31d },
	'speedx' => { 115 => 0x3, 384 => "\xa9xsp" },
	'speedy' => { 115 => 0x4, 384 => "\xa9ysp" },
	'speedz' => { 115 => 0x5, 384 => "\xa9zsp" },
	'spherical' => { 471 => 'Spherical' },
	'sphericalvideoxml' => { 120 => 'SphericalVideoXML' },
	'splitcolumn' => { 368 => 0x222 },
	'splittoningbalance' => { 482 => 'SplitToningBalance', 484 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 482 => 'SplitToningHighlightHue', 484 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 482 => 'SplitToningHighlightSaturation', 484 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 482 => 'SplitToningShadowHue', 484 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 482 => 'SplitToningShadowSaturation', 484 => 'SplitToningShadowSaturation' },
	'sport' => { 499 => 'sport' },
	'spotfocuspointx' => { 181 => 0x2d },
	'spotfocuspointy' => { 181 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 84 => 0x107 },
	'sractive' => { 340 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 361 => 0x3 },
	'srgbrendering' => { 312 => 'sRGB' },
	'srhalfpresstime' => { 361 => 0x2 },
	'srresult' => { 361 => 0x0, 362 => 0x0 },
	'stackedimage' => { 301 => 0x804 },
	'standardmatrixcustom' => { 138 => 0x7d4 },
	'standardmatrixdaylight' => { 138 => 0x7d0 },
	'standardmatrixflash' => { 138 => 0x7d3 },
	'standardmatrixfluorescent' => { 138 => 0x7d2 },
	'standardmatrixtungsten' => { 138 => 0x7d1 },
	'standardoutputhighlightpoint' => { 109 => 0x14 },
	'standardoutputsensitivity' => { 119 => 0x8831, 489 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 109 => 0x15 },
	'standardrawcolortone' => { 109 => 0xd },
	'standardrawcontrast' => { 109 => 0xf },
	'standardrawhighlight' => { 109 => 0x75 },
	'standardrawhighlightpoint' => { 109 => 0x12 },
	'standardrawlinear' => { 109 => 0x10 },
	'standardrawsaturation' => { 109 => 0xe },
	'standardrawshadow' => { 109 => 0x7e },
	'standardrawshadowpoint' => { 109 => 0x13 },
	'standardrawsharpness' => { 109 => 0x11 },
	'standardunsharpmaskfineness' => { 109 => 0x94 },
	'standardunsharpmaskstrength' => { 109 => 0x92 },
	'standardunsharpmaskthreshold' => { 109 => 0x96 },
	'standardwhitecustom' => { 138 => 0x838 },
	'standardwhitedaylight' => { 138 => 0x834 },
	'standardwhiteflash' => { 138 => 0x837 },
	'standardwhitefluorescent' => { 138 => 0x836 },
	'standardwhitetungsten' => { 138 => 0x835 },
	'standbytimer' => { 284 => '19.1', 286 => '19.1', 287 => '19.1', 290 => '18.1', 291 => '18.1', 296 => '19.1', 297 => '19.1' },
	'starlightview' => { 299 => 0x249 },
	'startingpage' => { 499 => 'startingPage' },
	'startmovieshooting' => { 84 => 0x70d },
	'starttimecode' => { 384 => "\xa9TIM", 509 => 'startTimecode' },
	'starttimecodetimeformat' => { 509 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 509 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 509 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 384 => "\xa9TSZ", 509 => 'startTimeSampleSize' },
	'starttimescale' => { 384 => "\xa9TSC", 509 => 'startTimeScale' },
	'state' => { 161 => 'State', 324 => 0x6b, 497 => 'State' },
	'status' => { 463 => 'Status', 475 => 'Status' },
	'stereomode' => { 471 => 'StereoMode' },
	'stitched' => { 471 => 'Stitched' },
	'stitchingsoftware' => { 470 => 'StitchingSoftware', 471 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 433 => 0x113e, 434 => 0x113e, 435 => 0x111a, 436 => 0x1196, 437 => 0x1172, 438 => 0x102a, 439 => 0x222, 440 => 0x222, 441 => 0x217, 455 => 0xa },
	'storagemethod' => { 188 => 0x12 },
	'storebyorientation' => { 284 => '46.3', 286 => '47.3', 287 => '47.3', 296 => '47.3', 297 => '47.3', 299 => 0xd },
	'storedescription' => { 376 => 'sdes' },
	'storylineidentifier' => { 495 => 'StorylineIdentifier' },
	'straightenangle' => { 276 => 0x2fc08431 },
	'streamready' => { 495 => 'StreamReady' },
	'streamtype' => { 176 => 'StreamType' },
	'stretchmode' => { 509 => 'stretchMode' },
	'studydatetime' => { 461 => 'StudyDateTime' },
	'studydescription' => { 461 => 'StudyDescription' },
	'studyid' => { 461 => 'StudyID' },
	'studyphysician' => { 461 => 'StudyPhysician' },
	'styleperiod' => { 495 => 'StylePeriod' },
	'sub-location' => { 131 => 0x5c },
	'subcommanddialplaybackmode' => { 299 => 0x1cf },
	'subfiledata' => { 164 => 'data' },
	'subfiledirectory' => { 164 => '1Directory' },
	'subfilemimetype' => { 164 => '2MIME' },
	'subfilename' => { 164 => '1Name' },
	'subfileresource' => { 164 => 'rsrc' },
	'subfiletype' => { 119 => 0xfe, 164 => '0Type' },
	'subject' => { 310 => 'Subject', 375 => 'Subject', 485 => 'subject', 496 => 'Subject', 510 => 'subject' },
	'subjectarea' => { 119 => 0x9214, 488 => 'SubjectArea' },
	'subjectcode' => { 494 => 'SubjectCode' },
	'subjectdetection' => { 231 => 0x23e, 232 => 0x252 },
	'subjectdistance' => { 119 => 0x9206, 140 => 0x3e, 488 => 'SubjectDistance' },
	'subjectdistancerange' => { 119 => 0xa40c, 488 => 'SubjectDistanceRange' },
	'subjectlocation' => { 119 => 0xa214, 488 => 'SubjectLocation' },
	'subjectmotion' => { 286 => '78.2', 287 => '78.2', 297 => '78.2', 299 => 0x103 },
	'subjectprogram' => { 181 => 0x22 },
	'subjectreference' => { 131 => 0xc },
	'sublabels1' => { 493 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 493 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 114 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 114 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 114 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 119 => 0x9290 },
	'subsectimedigitized' => { 119 => 0x9292 },
	'subsectimeoriginal' => { 119 => 0x9291 },
	'subsection1' => { 499 => 'subsection1' },
	'subsection2' => { 499 => 'subsection2' },
	'subsection3' => { 499 => 'subsection3' },
	'subsection4' => { 499 => 'subsection4' },
	'subselector' => { 284 => '49.1', 286 => '71.1', 287 => '71.1', 297 => '71.1', 299 => 0x8f },
	'subselectorassignment' => { 284 => '48.1' },
	'subselectorcenter' => { 286 => '72.1', 287 => '72.1', 297 => '72.1' },
	'subselectorplusdials' => { 284 => '49.2', 286 => '73.1', 287 => '73.1', 297 => '73.1' },
	'subtitle' => { 179 => 'WM/SubTitle', 376 => "\xa9st3", 384 => "\xa9snm", 499 => 'subtitle' },
	'subtitlekeywords' => { 384 => "\xa9snk" },
	'subversionfilename' => { 493 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 493 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 493 => 'SubVersions' },
	'superimposeddisplay' => { 82 => 0xa, 84 => 0x510, 85 => 0x9, 86 => 0xa, 89 => 0xa, 90 => 0xe },
	'supermacro' => { 64 => 0x1a },
	'supplementalcategories' => { 131 => 0x14, 497 => 'SupplementalCategories' },
	'supplementaltype' => { 133 => 0x37 },
	'supplementdisplayid' => { 499 => 'supplementDisplayID' },
	'supplementstartingpage' => { 499 => 'supplementStartingPage' },
	'supplementtitle' => { 499 => 'supplementTitle' },
	'supplychainsource' => { 495 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 495 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 495 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 482 => 'SupportsAmount', 484 => 'SupportsAmount' },
	'supportscolor' => { 482 => 'SupportsColor', 484 => 'SupportsColor' },
	'supportshighdynamicrange' => { 482 => 'SupportsHighDynamicRange', 484 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 482 => 'SupportsMonochrome', 484 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 482 => 'SupportsNormalDynamicRange', 484 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 482 => 'SupportsOutputReferred', 484 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 482 => 'SupportsSceneReferred', 484 => 'SupportsSceneReferred' },
	'svisosetting' => { 340 => 0x14 },
	'swatchcoloranta' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 514 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 514 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 514 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 514 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 514 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 324 => 0x93, 413 => 0x33 },
	'sweeppanoramafieldofview' => { 324 => 0x94 },
	'sweeppanoramasize' => { 413 => 0x32 },
	'switchtoregisteredafpoint' => { 83 => 0x12, 84 => 0x50a },
	'symlink' => { 120 => 'SymLink' },
	'syncreleasemode' => { 286 => '77.1', 287 => '77.1', 297 => '77.1', 299 => 0x41 },
	'system' => { 368 => 0x204 },
	'tagged' => { 370 => 0xdd, 371 => 'Tagged', 477 => 'tagged' },
	'tagslist' => { 487 => 'TagsList' },
	'tagstructure' => { 493 => 'TagStructure' },
	'takenumber' => { 509 => 'takeNumber' },
	'tapename' => { 509 => 'tapeName' },
	'targetaperture' => { 77 => 0x4 },
	'targetcompressionratio' => { 95 => 0x1 },
	'targetdistancesetting' => { 97 => 0x1807 },
	'targetexposuretime' => { 77 => 0x5 },
	'targetimagetype' => { 97 => 0x100a },
	'targetprinter' => { 119 => 0x151 },
	'taxon' => { 118 => 'Taxon' },
	'taxonacceptednameusage' => { 118 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 118 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 118 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 118 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 118 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 118 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 118 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 118 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 118 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 118 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 118 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 118 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 118 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 118 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 118 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 118 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 118 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 118 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 118 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 118 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 118 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 118 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 118 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 118 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 118 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 118 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 118 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 118 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 118 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 118 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 118 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 118 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 118 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 118 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 138 => 0x196f },
	'tda1edgepolarity' => { 138 => 0x1971 },
	'tda1gain' => { 138 => 0x1970 },
	'tda1offset' => { 138 => 0x196e },
	'tda2bandwidth' => { 138 => 0x1979 },
	'tda2edgepolarity' => { 138 => 0x197b },
	'tda2gain' => { 138 => 0x197a },
	'tda2offset' => { 138 => 0x1978 },
	'tda3bandwidth' => { 138 => 0x1983 },
	'tda3edgepolarity' => { 138 => 0x1985 },
	'tda3gain' => { 138 => 0x1984 },
	'tda3offset' => { 138 => 0x1982 },
	'tda4bandwidth' => { 138 => 0x198d },
	'tda4edgepolarity' => { 138 => 0x198f },
	'tda4gain' => { 138 => 0x198e },
	'tda4offset' => { 138 => 0x198c },
	'teaser' => { 499 => 'teaser' },
	'teleconverter' => { 186 => 0x105, 424 => 0x105 },
	'tempampgainx100' => { 138 => 0x1914 },
	'tempo' => { 509 => 'tempo' },
	'temporalcoverage' => { 495 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 495 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 495 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 311 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 311 => 'TermsAndConditionsURL' },
	'testname' => { 120 => 'TestName' },
	'textencoding' => { 226 => 0x4 },
	'textlayername' => { 497 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 497 => 'TextLayers' },
	'textlayertext' => { 497 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 324 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 482 => 'Texture', 484 => 'Texture' },
	'three-dtrackingfacedetection' => { 286 => '1.4', 287 => '1.4', 297 => '1.4' },
	'three-dtrackingwatcharea' => { 286 => '78.1', 287 => '78.1', 297 => '78.1' },
	'thresholding' => { 119 => 0x107 },
	'thumbnailfilename' => { 97 => 0x817 },
	'thumbnailformat' => { 507 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 142 => 0xfa55, 507 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 97 => 0x2008, 114 => 'Exif-ThumbnailImage', 122 => 0x3, 167 => 'data', 306 => 0x100, 384 => 'thmb', 507 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 167 => '1Name' },
	'thumbnailimagesize' => { 167 => 'ImageSize' },
	'thumbnailimagetype' => { 167 => '0Type' },
	'thumbnailimagevalidarea' => { 64 => 0x13 },
	'thumbnaillength' => { 119 => 0x202 },
	'thumbnailoffset' => { 119 => 0x201 },
	'thumbnailpng' => { 384 => 'thmb' },
	'thumbnails' => { 507 => 'Thumbnails' },
	'thumbnailwidth' => { 142 => 0xfa54, 507 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 499 => 'ticker' },
	'tiffhandling' => { 482 => 'TIFFHandling', 484 => 'TIFFHandling' },
	'tiffmeteringimage' => { 187 => 0x104c, 422 => 0x1110 },
	'tilelength' => { 119 => 0x143 },
	'tilewidth' => { 119 => 0x142 },
	'time' => { 138 => 0x401, 359 => 0x7 },
	'timecodes' => { 119 => 0xc763 },
	'timecreated' => { 131 => 0x3c, 140 => 0x14, 149 => 0x10, 371 => 'TimeCreated' },
	'timelapseshotnumber' => { 327 => 0x10 },
	'timeperiod' => { 499 => 'timePeriod' },
	'timerfunctionbutton' => { 285 => '5.2', 288 => '12.1', 289 => '13.1' },
	'timerlength' => { 84 => 0x80c },
	'timerrecording' => { 324 => 0x96 },
	'timescaleparams' => { 509 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 509 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 509 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 509 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 132 => 0x50 },
	'timeshot' => { 472 => 'TimeShot' },
	'timesignature' => { 509 => 'timeSignature' },
	'timesincepoweron' => { 324 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 300 => 0x8, 314 => 'TimeStamp', 324 => 0xaf, 471 => 'Timestamp', 478 => 'Timestamp', 493 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 78 => 0x1, 231 => 0x594, 232 => 0x5c4, 268 => 0x0, 394 => 0xa },
	'timezonecity' => { 78 => 0x2 },
	'timezonecode' => { 100 => 0x1 },
	'timezoneinfo' => { 100 => 0x2 },
	'timezoneoffset' => { 119 => 0x882a },
	'tint' => { 378 => 'player.movie.visual.tint', 482 => 'Tint', 484 => 'Tint' },
	'title' => { 157 => 'Title', 310 => 'Title', 314 => 'Title', 324 => 0x65, 375 => 'Title', 376 => ['titl',"\xa9nam"], 378 => 'title', 384 => ['titl',"\xa9nam"], 485 => 'title', 496 => 'Title', 507 => 'Title' },
	'togglestyleamount' => { 482 => 'ToggleStyleAmount', 484 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 482 => 'ToggleStyleDigest', 484 => 'ToggleStyleDigest' },
	'tonecomp' => { 227 => 0x81 },
	'tonecurve' => { 74 => 0x1, 359 => 0x402, 482 => 'ToneCurve', 484 => 'ToneCurve' },
	'tonecurveactive' => { 108 => 0x110 },
	'tonecurveadobergb' => { 398 => 0xa043 },
	'tonecurveadobergbdefault' => { 398 => 0xa041 },
	'tonecurveblue' => { 482 => 'ToneCurveBlue', 484 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 459 => 0x9003 },
	'tonecurvebluey' => { 459 => 0x9007 },
	'tonecurvebrightness' => { 103 => 0x20410 },
	'tonecurvebrightnessx' => { 459 => 0x9000 },
	'tonecurvebrightnessy' => { 459 => 0x9004 },
	'tonecurvecolorspace' => { 107 => 0x0 },
	'tonecurvecontrast' => { 103 => 0x20411 },
	'tonecurvegreen' => { 482 => 'ToneCurveGreen', 484 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 459 => 0x9002 },
	'tonecurvegreeny' => { 459 => 0x9006 },
	'tonecurveinputrange' => { 107 => 0x3 },
	'tonecurveinterpolation' => { 108 => 0x159 },
	'tonecurvemode' => { 108 => 0x113 },
	'tonecurvename' => { 482 => 'ToneCurveName', 484 => 'ToneCurveName' },
	'tonecurvename2012' => { 482 => 'ToneCurveName2012', 484 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 103 => '0x20400.1' },
	'tonecurveoutputrange' => { 107 => 0x5 },
	'tonecurveprofilename' => { 138 => 0x1391 },
	'tonecurveproperty' => { 108 => 0x3c },
	'tonecurvepv2012' => { 482 => 'ToneCurvePV2012', 484 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 482 => 'ToneCurvePV2012Blue', 484 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 482 => 'ToneCurvePV2012Green', 484 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 482 => 'ToneCurvePV2012Red', 484 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 482 => 'ToneCurveRed', 484 => 'ToneCurveRed' },
	'tonecurveredx' => { 459 => 0x9001 },
	'tonecurveredy' => { 459 => 0x9005 },
	'tonecurves' => { 359 => 0x403 },
	'tonecurveshape' => { 107 => 0x1 },
	'tonecurvesrgb' => { 398 => 0xa042 },
	'tonecurvesrgbdefault' => { 398 => 0xa040 },
	'tonecurvex' => { 107 => 0xa },
	'tonecurvey' => { 107 => 0xb },
	'tonelevel' => { 301 => 0x52e },
	'tonemapstrength' => { 482 => 'ToneMapStrength', 484 => 'ToneMapStrength' },
	'toningeffect' => { 57 => 0xf, 227 => 0xb3, 235 => 0x38, 236 => 0x40, 237 => 0x48, 391 => 0x1015 },
	'toningeffectauto' => { 71 => 0xa4 },
	'toningeffectfaithful' => { 70 => 0x74, 71 => 0x74 },
	'toningeffectlandscape' => { 70 => 0x44, 71 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 70 => 0x8c, 71 => 0x8c },
	'toningeffectneutral' => { 70 => 0x5c, 71 => 0x5c },
	'toningeffectportrait' => { 70 => 0x2c, 71 => 0x2c },
	'toningeffectstandard' => { 70 => 0x14, 71 => 0x14 },
	'toningeffectuserdef1' => { 70 => 0xa4, 71 => 0xbc },
	'toningeffectuserdef2' => { 70 => 0xbc, 71 => 0xd4 },
	'toningeffectuserdef3' => { 70 => 0xd4, 71 => 0xec },
	'toningsaturation' => { 235 => 0x39, 236 => 0x41, 237 => 0x49 },
	'totalzoom' => { 140 => 0x62 },
	'touchae' => { 324 => 0xab },
	'track' => { 376 => "\xa9trk", 384 => "\xa9trk" },
	'trackcreatedate' => { 383 => 0x1 },
	'trackmodifydate' => { 383 => 0x2 },
	'tracknumber' => { 376 => 'trkn', 509 => 'trackNumber' },
	'tracks' => { 509 => 'Tracks' },
	'tracksframerate' => { 509 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 509 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 509 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 509 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 509 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 509 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 509 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 509 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 509 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 509 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 509 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 509 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 509 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 509 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 509 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 509 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 509 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 384 => 'kgtt' },
	'trailer' => { 120 => 'Trailer' },
	'trailersignature' => { 164 => 'zmie' },
	'transcript' => { 495 => 'Transcript' },
	'transcriptlink' => { 495 => 'TranscriptLink' },
	'transcriptlinklink' => { 495 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 495 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 119 => 0x12d, 505 => 'TransferFunction' },
	'transfertimenormal' => { 138 => 0x1888 },
	'transfertimetest' => { 138 => 0x1889 },
	'transform' => { 324 => [0x8012,0x59] },
	'transmissionreference' => { 497 => 'TransmissionReference' },
	'trapped' => { 310 => 'Trapped', 496 => 'Trapped' },
	'trashbuttonfunction' => { 84 => 0x710 },
	'travelday' => { 324 => 0x36 },
	'treble' => { 378 => 'player.movie.audio.treble' },
	'triggermode' => { 385 => 0x6, 386 => 0x34, 387 => 0x34 },
	'tstop' => { 119 => 0xc772 },
	'ttl_da_adown' => { 347 => 0x5 },
	'ttl_da_aup' => { 347 => 0x4 },
	'ttl_da_bdown' => { 347 => 0x7 },
	'ttl_da_bup' => { 347 => 0x6 },
	'tungstenawb' => { 337 => 0x1 },
	'tvepisode' => { 376 => 'tves' },
	'tvepisodeid' => { 376 => 'tven' },
	'tvexposuretimesetting' => { 340 => 0x12 },
	'tvnetworkname' => { 376 => 'tvnn' },
	'tvseason' => { 376 => 'tvsn' },
	'tvshow' => { 376 => 'tvsh' },
	'type' => { 466 => 'Type', 485 => 'type', 504 => 'type' },
	'typestatus' => { 118 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 119 => 0xc614 },
	'uniquedocumentid' => { 131 => 0xbb },
	'uniquematrixauto' => { 138 => 0x7e9 },
	'uniquematrixcustom' => { 138 => 0x7e8 },
	'uniquematrixdaylight' => { 138 => 0x7e4 },
	'uniquematrixflash' => { 138 => 0x7e7 },
	'uniquematrixfluorescent' => { 138 => 0x7e6 },
	'uniquematrixtungsten' => { 138 => 0x7e5 },
	'uniqueobjectname' => { 132 => 0x64 },
	'units' => { 467 => 'Units' },
	'unknown_aacr' => { 376 => 'AACR' },
	'unknown_cdek' => { 376 => 'CDEK' },
	'unknown_cdet' => { 376 => 'CDET' },
	'unknownblock' => { 359 => 0x405 },
	'unknownblock1' => { 305 => 0x635 },
	'unknownblock2' => { 305 => 0x636 },
	'unknownblock3' => { 305 => 0x1103 },
	'unknownblock4' => { 305 => 0x1104 },
	'unknowncontrast' => { 109 => 0x45 },
	'unknowndate' => { 368 => 0x212 },
	'unknownev' => { 138 => 0x1 },
	'unknownlinear' => { 109 => 0x46 },
	'unknownnumber' => { 97 => 0x180b },
	'unknownoutputhighlightpoint' => { 109 => 0x4a },
	'unknownoutputshadowpoint' => { 109 => 0x4b },
	'unknownrawhighlight' => { 109 => 0x7b },
	'unknownrawhighlightpoint' => { 109 => 0x48 },
	'unknownrawshadow' => { 109 => 0x84 },
	'unknownrawshadowpoint' => { 109 => 0x49 },
	'unknownsharpness' => { 109 => 0x47 },
	'unknowntags' => { 384 => 'TAGS' },
	'unknowntemperature' => { 121 => 0x4 },
	'unknownthumbnail' => { 384 => 'thmb' },
	'unsharp1color' => { 281 => 0x13 },
	'unsharp1halowidth' => { 281 => 0x19 },
	'unsharp1intensity' => { 281 => 0x17 },
	'unsharp1threshold' => { 281 => 0x1b },
	'unsharp2color' => { 281 => 0x2e },
	'unsharp2halowidth' => { 281 => 0x34 },
	'unsharp2intensity' => { 281 => 0x32 },
	'unsharp2threshold' => { 281 => 0x36 },
	'unsharp3color' => { 281 => 0x49 },
	'unsharp3halowidth' => { 281 => 0x4f },
	'unsharp3intensity' => { 281 => 0x4d },
	'unsharp3threshold' => { 281 => 0x51 },
	'unsharp4color' => { 281 => 0x64 },
	'unsharp4halowidth' => { 281 => 0x6a },
	'unsharp4intensity' => { 281 => 0x68 },
	'unsharp4threshold' => { 281 => 0x6c },
	'unsharpcount' => { 281 => 0x0 },
	'unsharpmask' => { 109 => 0x90, 276 => 0x76a43200 },
	'unsharpmaskfineness' => { 103 => 0x20309 },
	'unsharpmaskstrength' => { 103 => 0x20308 },
	'unsharpmaskthreshold' => { 103 => 0x2030a },
	'uprightcentermode' => { 482 => 'UprightCenterMode', 484 => 'UprightCenterMode' },
	'uprightcenternormx' => { 482 => 'UprightCenterNormX', 484 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 482 => 'UprightCenterNormY', 484 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 482 => 'UprightDependentDigest', 484 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 482 => 'UprightFocalLength35mm', 484 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 482 => 'UprightFocalMode', 484 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 482 => 'UprightFourSegments_0', 484 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 482 => 'UprightFourSegments_1', 484 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 482 => 'UprightFourSegments_2', 484 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 482 => 'UprightFourSegments_3', 484 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 482 => 'UprightFourSegmentsCount', 484 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 482 => 'UprightGuidedDependentDigest', 484 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 482 => 'UprightPreview', 484 => 'UprightPreview' },
	'uprighttransform_0' => { 482 => 'UprightTransform_0', 484 => 'UprightTransform_0' },
	'uprighttransform_1' => { 482 => 'UprightTransform_1', 484 => 'UprightTransform_1' },
	'uprighttransform_2' => { 482 => 'UprightTransform_2', 484 => 'UprightTransform_2' },
	'uprighttransform_3' => { 482 => 'UprightTransform_3', 484 => 'UprightTransform_3' },
	'uprighttransform_4' => { 482 => 'UprightTransform_4', 484 => 'UprightTransform_4' },
	'uprighttransform_5' => { 482 => 'UprightTransform_5', 484 => 'UprightTransform_5' },
	'uprighttransformcount' => { 482 => 'UprightTransformCount', 484 => 'UprightTransformCount' },
	'uprightversion' => { 482 => 'UprightVersion', 484 => 'UprightVersion' },
	'urgency' => { 131 => 0xa, 497 => 'Urgency' },
	'url' => { 157 => 'URL', 314 => 'URL', 373 => 0x40b, 499 => 'url' },
	'url_list' => { 373 => 0x41e },
	'urla-platform' => { 499 => [\'url','urlA-platform'] },
	'urlurl' => { 499 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 84 => 0x10a },
	'usableshootingmodes' => { 84 => 0x109 },
	'usage' => { 500 => 'usage' },
	'usageterms' => { 513 => 'UsageTerms' },
	'usbpowerdelivery' => { 231 => 0x664, 232 => 0x694 },
	'usedialwithouthold' => { 299 => 0xbf },
	'useguidelines' => { 480 => 'useGuidelines' },
	'usepanoramaviewer' => { 470 => 'UsePanoramaViewer' },
	'usercollection' => { 378 => 'collection.user' },
	'usercomment' => { 97 => 0x805, 119 => 0x9286, 488 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 70 => 0xd8, 71 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 70 => 0xda, 71 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 70 => 0xdc, 71 => 0xf4 },
	'userfields' => { 475 => 'UserFields' },
	'userlabel' => { 385 => 0x2b, 386 => 0x5a, 387 => 0x68 },
	'userprofile' => { 319 => 0x302, 323 => 0x34c, 326 => 0x3038 },
	'userrating' => { 378 => 'rating.user', 384 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 83 => 0x7, 84 => 0x501 },
	'uspsnumber' => { 499 => 'uspsNumber' },
	'utmeasting' => { 168 => 'Easting' },
	'utmmapdatum' => { 168 => 'Datum' },
	'utmnorthing' => { 168 => 'Northing' },
	'utmzone' => { 168 => 'Zone' },
	'uuid' => { 482 => 'UUID', 484 => 'UUID' },
	'uv-irfiltercorrection' => { 319 => 0x325 },
	'validbits' => { 305 => 0x611, 306 => 0x102c },
	'validpixeldepth' => { 309 => 0x611 },
	'variablelowpassfilter' => { 424 => 0x2028 },
	'variousmodes' => { 140 => 0x26 },
	'variousmodes2' => { 140 => 0x3a },
	'variprogram' => { 227 => 0xab },
	'varraydacnominalvalues' => { 138 => 0x191e },
	'vendor' => { 384 => 'vndr' },
	'vendorinfo' => { 462 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 462 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 462 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 462 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 118 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 127 => 0x0, 375 => 'Version', 378 => 'version', 482 => 'Version', 484 => 'Version' },
	'versioncreatedate' => { 459 => 0xd100 },
	'versionid' => { 510 => 'VersionID' },
	'versionidentifier' => { 499 => 'versionIdentifier' },
	'versionmodifydate' => { 459 => 0xd101 },
	'versions' => { 510 => 'Versions' },
	'versionscomments' => { 510 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 510 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 510 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 510 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 510 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 510 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 510 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 510 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 510 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 510 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 510 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 283 => '3.2', 284 => '47.2', 286 => '79.1', 299 => 0x11d },
	'verticalclockoverlaps' => { 138 => 0x412 },
	'verticalfuncbutton' => { 284 => '42.2', 286 => '67.1', 299 => 0x115 },
	'verticalfuncbuttonplaybackmode' => { 299 => 0x1b7 },
	'verticalfuncbuttonplusdials' => { 284 => '43.1' },
	'verticalfuncplusdials' => { 286 => '68.1' },
	'verticalmovieafonbutton' => { 299 => 0x1f9 },
	'verticalmoviefuncbutton' => { 299 => 0x1e1 },
	'verticalmultiselector' => { 284 => '42.1', 286 => '66.1', 287 => '66.1', 297 => '66.1', 299 => 0x18f },
	'verticalmultiselectorplaybackmode' => { 299 => 0x125 },
	'vfdisplayillumination' => { 2 => 0x11, 84 => [0x510,0x51d] },
	'vibrance' => { 476 => 'Vibrance', 482 => 'Vibrance', 484 => 'Vibrance' },
	'vibrationreduction' => { 242 => [0x75,0x82,0x1ae], 250 => '586.1', 259 => '590.2', 267 => 0x4 },
	'videoalphamode' => { 509 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 509 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 509 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 509 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 495 => 'videoBitRate' },
	'videobitratemode' => { 495 => 'videoBitRateMode' },
	'videoburstmode' => { 324 => 0xbb },
	'videoburstresolution' => { 324 => 0xb3 },
	'videocodec' => { 67 => 0x74 },
	'videocolorspace' => { 509 => 'videoColorSpace' },
	'videocompression' => { 127 => 0x3806 },
	'videocompressor' => { 509 => 'videoCompressor' },
	'videodisplayaspectratio' => { 495 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 495 => 'videoEncodingProfile' },
	'videofieldorder' => { 509 => 'videoFieldOrder' },
	'videoframerate' => { 324 => 0x27, 509 => 'videoFrameRate' },
	'videoframesize' => { 509 => 'videoFrameSize' },
	'videoframesizeh' => { 509 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 509 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 509 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 509 => 'videoModDate' },
	'videopixelaspectratio' => { 509 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 509 => 'videoPixelDepth' },
	'videopreburst' => { 324 => 0xc1 },
	'videoquality' => { 113 => 0x4003 },
	'videorecordingmode' => { 127 => 0x3803 },
	'videoshottype' => { 495 => 'VideoShotType' },
	'videoshottypeidentifier' => { 495 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 495 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 495 => 'videoStreamsCount' },
	'viewfinder' => { 368 => 0x455 },
	'viewfinderdisplay' => { 283 => '12.4', 284 => '6.3' },
	'viewfinderwarning' => { 283 => '13.4', 293 => '3.5', 294 => '6.2', 298 => '4.4' },
	'viewfinderwarnings' => { 84 => 0x40a },
	'viewinfoduringexposure' => { 84 => 0x407 },
	'viewingmode' => { 413 => 0x2f, 429 => 0x18 },
	'viewingmode2' => { 413 => [0x85,0x285] },
	'viewpoint' => { 498 => 'viewpoint' },
	'vignetteamount' => { 482 => 'VignetteAmount', 484 => 'VignetteAmount' },
	'vignettecontrol' => { 227 => 0x2a, 276 => 0x76a43205 },
	'vignettecontrolintensity' => { 276 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 479 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 482 => 'VignetteMidpoint', 484 => 'VignetteMidpoint' },
	'vignetting' => { 391 => 0x1011, 398 => 0xa052 },
	'vignettingcorrection' => { 119 => 0x7031, 398 => 0xa053, 424 => 0x2011 },
	'vignettingcorrparams' => { 119 => 0x7032, 454 => 0x64a, 455 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 398 => 0xa054 },
	'virtualhorizonstyle' => { 299 => 0x167 },
	'visualcolor' => { 495 => 'VisualColour' },
	'visualtechnique' => { 498 => 'visualTechnique' },
	'voicememo' => { 400 => 0x216 },
	'volume' => { 499 => 'volume' },
	'vr_0x66' => { 242 => 0x66 },
	'vrdoffset' => { 64 => 0xd0 },
	'vrmode' => { 231 => 0x212, 232 => 0x226, 267 => 0x6 },
	'vrtype' => { 267 => 0x8 },
	'waterdepth' => { 119 => 0x9403, 489 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 187 => 0x19a },
	'wb_bluelevel6500k' => { 187 => 0x18a },
	'wb_bluelevelcustom' => { 187 => 0x18e },
	'wb_bluelevelscloudy' => { 187 => 0x106 },
	'wb_bluelevelsdaylight' => { 187 => 0xea },
	'wb_bluelevelsflash' => { 187 => 0x122 },
	'wb_bluelevelsfluorescent' => { 187 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 187 => 0x254 },
	'wb_bluelevelsshade' => { 187 => 0x176 },
	'wb_bluelevelstungsten' => { 187 => 0xce },
	'wb_gbrglevels' => { 187 => 0xae, 190 => 0x4 },
	'wb_glevel' => { 305 => 0x11f },
	'wb_glevel3000k' => { 305 => 0x113 },
	'wb_glevel3300k' => { 305 => 0x114 },
	'wb_glevel3600k' => { 305 => 0x115 },
	'wb_glevel3900k' => { 305 => 0x116 },
	'wb_glevel4000k' => { 305 => 0x117 },
	'wb_glevel4300k' => { 305 => 0x118 },
	'wb_glevel4500k' => { 305 => 0x119 },
	'wb_glevel4800k' => { 305 => 0x11a },
	'wb_glevel5300k' => { 305 => 0x11b },
	'wb_glevel6000k' => { 305 => 0x11c },
	'wb_glevel6600k' => { 305 => 0x11d },
	'wb_glevel7500k' => { 305 => 0x11e },
	'wb_grbglevels' => { 201 => 0x0, 431 => 0x7303 },
	'wb_grbglevelsauto' => { 81 => 0x2, 431 => 0x7302 },
	'wb_grbglevelscloudy' => { 81 => 0x12 },
	'wb_grbglevelscustom1' => { 81 => 0x42 },
	'wb_grbglevelscustom2' => { 81 => 0x4a },
	'wb_grbglevelsdaylight' => { 81 => 0xa },
	'wb_grbglevelsflash' => { 81 => 0x32 },
	'wb_grbglevelsfluorescent' => { 81 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 81 => 0x2a },
	'wb_grbglevelstungsten' => { 81 => 0x1a },
	'wb_grbglevelsunderwater' => { 81 => 0x3a },
	'wb_rbgglevels' => { 198 => 0x0 },
	'wb_rblevels' => { 202 => 0x270, 227 => 0xc, 305 => 0x100 },
	'wb_rblevels1' => { 330 => 0x2 },
	'wb_rblevels2' => { 330 => 0x5 },
	'wb_rblevels3' => { 330 => 0x8 },
	'wb_rblevels3000k' => { 305 => 0x102 },
	'wb_rblevels3300k' => { 305 => 0x103 },
	'wb_rblevels3500k' => { 187 => 0x430 },
	'wb_rblevels3600k' => { 305 => 0x104 },
	'wb_rblevels3900k' => { 305 => 0x105 },
	'wb_rblevels4' => { 330 => 0xb },
	'wb_rblevels4000k' => { 305 => 0x106 },
	'wb_rblevels4300k' => { 305 => 0x107 },
	'wb_rblevels4500k' => { 305 => 0x108 },
	'wb_rblevels4800k' => { 305 => 0x109 },
	'wb_rblevels5' => { 330 => 0xe },
	'wb_rblevels5300k' => { 305 => 0x10a },
	'wb_rblevels6' => { 330 => 0x11 },
	'wb_rblevels6000k' => { 305 => 0x10b },
	'wb_rblevels6500k' => { 187 => 0x420 },
	'wb_rblevels6600k' => { 305 => 0x10c },
	'wb_rblevels7' => { 330 => 0x14 },
	'wb_rblevels7500k' => { 305 => 0x10d },
	'wb_rblevelsauto' => { 202 => 0x272, 309 => 0x110 },
	'wb_rblevelscloudy' => { 187 => 0x3f0, 189 => 0x10, 202 => 0x296, 309 => 0x121 },
	'wb_rblevelscoolwhitef' => { 187 => 0x308, 189 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 309 => 0x132 },
	'wb_rblevelscustom' => { 187 => 0x424, 189 => 0x1c },
	'wb_rblevelscwb1' => { 305 => 0x10e },
	'wb_rblevelscwb2' => { 305 => 0x10f },
	'wb_rblevelscwb3' => { 305 => 0x110 },
	'wb_rblevelscwb4' => { 305 => 0x111 },
	'wb_rblevelsdaylight' => { 187 => [0x3ec,0x528], 189 => 0xc, 202 => 0x274 },
	'wb_rblevelsdaylightf' => { 189 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 309 => 0x130 },
	'wb_rblevelsdaywhitef' => { 189 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 309 => 0x131 },
	'wb_rblevelseveningsunlight' => { 309 => 0x124 },
	'wb_rblevelsfineweather' => { 309 => 0x122 },
	'wb_rblevelsflash' => { 187 => [0x3f4,0x304], 189 => 0x18, 202 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 202 => 0x290 },
	'wb_rblevelsincandescent' => { 202 => 0x282 },
	'wb_rblevelsshade' => { 187 => 0x418, 189 => 0x20, 202 => 0x2b2, 309 => 0x120 },
	'wb_rblevelstungsten' => { 187 => 0x3e8, 189 => 0x8, 309 => 0x123 },
	'wb_rblevelsused' => { 309 => 0x100 },
	'wb_rblevelswhitef' => { 189 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 309 => 0x133 },
	'wb_redlevel3500k' => { 187 => 0x198 },
	'wb_redlevel6500k' => { 187 => 0x188 },
	'wb_redlevelcustom' => { 187 => 0x18c },
	'wb_redlevelscloudy' => { 187 => 0xf8 },
	'wb_redlevelsdaylight' => { 187 => 0xdc },
	'wb_redlevelsflash' => { 187 => 0x114 },
	'wb_redlevelsfluorescent' => { 187 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 187 => 0x1be },
	'wb_redlevelsshade' => { 187 => 0x168 },
	'wb_redlevelstungsten' => { 187 => 0xc0 },
	'wb_rgbglevels' => { 200 => 0x0 },
	'wb_rgblevels' => { 187 => [0x546,0x96], 320 => 0xd, 321 => 0x413, 326 => 0x3036, 368 => 0x107, 433 => 0x117c, 434 => 0x1180, 435 => 0x115c, 436 => 0x11d8, 437 => 0x11b4, 438 => 0x106c, 439 => 0x264, 440 => 0x264, 441 => 0x252 },
	'wb_rgblevels1' => { 331 => 0x2 },
	'wb_rgblevels2' => { 331 => 0x6 },
	'wb_rgblevels2500k' => { 431 => 0x782d },
	'wb_rgblevels3' => { 331 => 0xa },
	'wb_rgblevels3200k' => { 431 => 0x782c },
	'wb_rgblevels4' => { 331 => 0xe },
	'wb_rgblevels4500k' => { 431 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 331 => 0x12 },
	'wb_rgblevels6' => { 331 => 0x16 },
	'wb_rgblevels6000k' => { 431 => 0x782b },
	'wb_rgblevels7' => { 331 => 0x1a },
	'wb_rgblevels8500k' => { 431 => 0x782a },
	'wb_rgblevelsauto' => { 402 => 0x0 },
	'wb_rgblevelscloudy' => { 431 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 402 => 0x15 },
	'wb_rgblevelscustom2' => { 402 => 0x18 },
	'wb_rgblevelscustom3' => { 402 => 0x1b },
	'wb_rgblevelsdaylight' => { 402 => 0x3, 431 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 402 => 0x12, 431 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 402 => 0xf, 431 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 431 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 431 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 431 => 0x7828 },
	'wb_rgblevelsincandescent' => { 402 => 0xc },
	'wb_rgblevelsovercast' => { 402 => 0x9 },
	'wb_rgblevelsshade' => { 402 => 0x6, 431 => 0x7825 },
	'wb_rgblevelstungsten' => { 431 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 403 => 0x0 },
	'wb_rgblevelsunknown1' => { 403 => 0x3 },
	'wb_rgblevelsunknown2' => { 403 => 0x6 },
	'wb_rgblevelsunknown3' => { 403 => 0x9 },
	'wb_rgblevelsunknown4' => { 403 => 0xc },
	'wb_rgblevelsunknown5' => { 403 => 0xf },
	'wb_rgblevelsunknown6' => { 403 => 0x12 },
	'wb_rgblevelsunknown7' => { 403 => 0x15 },
	'wb_rgblevelsunknown8' => { 403 => 0x18 },
	'wb_rgblevelsunknown9' => { 403 => 0x1b },
	'wb_rgbmuldaylight' => { 138 => 0x852 },
	'wb_rgbmulflash' => { 138 => 0x855 },
	'wb_rgbmulfluorescent' => { 138 => 0x854 },
	'wb_rgbmultungsten' => { 138 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 190 => 0x4, 199 => 0x0, 203 => 0x13e8, 204 => 0x38, 431 => 0x7313 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x69, 43 => 0x22, 44 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x6e, 43 => 0x18, 44 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x4c, 203 => 0x1478, 204 => 0x114, 398 => 0xa022, 431 => 0x7312 },
	'wb_rggblevelsblack' => { 398 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0xd7, 43 => 0x31, 44 => 0x58, 47 => 0x71, 48 => 0x8a, 49 => 0x8f, 50 => 0x92, 203 => 0x1408, 204 => 0x60, 359 => 0x20f, 367 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 44 => 0x80, 203 => 0x1468, 204 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0xcd, 43 => 0x27, 44 => 0x4e, 47 => 0x67, 48 => 0x80, 49 => 0x85, 50 => 0x88, 203 => 0x13f8, 204 => 0x4c, 359 => 0x20d, 367 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0xeb, 43 => 0x45, 44 => 0x6c, 47 => 0x85, 48 => 0x9e, 49 => 0xa3, 50 => 0xa6, 203 => 0x1448, 359 => 0x214, 367 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0xe1, 43 => 0x3b, 44 => 0x62, 47 => 0x7b, 48 => 0x94, 49 => 0x99, 50 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 204 => 0xc4, 359 => 0x211, 367 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 367 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 204 => 0xb0, 359 => 0x212, 367 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 203 => 0x1438, 204 => 0x9c, 359 => 0x213, 367 => 0x38 },
	'wb_rggblevelshtmercury' => { 204 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 398 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 398 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0xe6, 43 => 0x40, 44 => 0x67, 47 => 0x80, 48 => 0x99, 49 => 0x9e, 50 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 42 => 0x73, 44 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x51 },
	'wb_rggblevelspc1' => { 43 => 0x90, 44 => 0x71 },
	'wb_rggblevelspc2' => { 43 => 0x95, 44 => 0x76 },
	'wb_rggblevelspc3' => { 43 => 0x9a, 44 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0xd2, 43 => 0x2c, 44 => 0x53, 47 => 0x6c, 48 => 0x85, 49 => 0x8a, 50 => 0x8d, 204 => 0x74, 359 => 0x20e, 367 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0xdc, 43 => 0x36, 44 => 0x5d, 47 => 0x76, 48 => 0x8f, 49 => 0x94, 50 => 0x97, 203 => 0x1428, 204 => 0x88, 359 => 0x210, 367 => 0x1d },
	'wb_rggblevelsuncorrected' => { 398 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x78, 43 => 0x1d, 47 => 0x4e, 48 => 0x4e, 49 => 0x4e, 50 => 0x56, 367 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0xa5, 43 => 0x72, 47 => 0x9e, 48 => 0x7b, 49 => 0x7b, 50 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => [0xaa,0xaf], 43 => 0x77, 47 => 0xa3, 48 => 0xa3, 49 => 0x80, 50 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0xb4, 43 => 0x7c, 47 => 0xa8, 48 => 0xa8, 49 => 0xa8, 50 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0xb9, 43 => 0x81, 47 => 0xad, 48 => 0xad, 49 => 0xad, 50 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0xbe, 43 => 0x86, 47 => 0xb2, 48 => 0xb2, 49 => 0xb2, 50 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0xc3, 43 => 0x8b, 47 => 0xb7, 48 => 0xb7, 49 => 0xb7, 50 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0xc8, 43 => 0x9f, 48 => 0xbc, 49 => 0xbc, 50 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 42 => 0xf0, 48 => 0xc1, 49 => 0xc1, 50 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 42 => 0xf5, 48 => 0xc6, 49 => 0xc6, 50 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 42 => 0xfa, 48 => 0xcb, 49 => 0xcb, 50 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x7d, 43 => 0x4a, 47 => 0x53, 48 => 0x53, 49 => 0x53, 50 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 42 => 0xff, 48 => 0xd0, 49 => 0xd0, 50 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 42 => 0x104, 49 => 0xd5, 50 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 42 => 0x109, 49 => 0xda, 50 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 42 => 0x10e, 49 => 0xdf, 50 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 42 => 0x113, 49 => 0xe4, 50 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 42 => 0x118, 49 => 0xe9, 50 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 42 => 0x11d, 49 => 0xee, 50 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 42 => 0x122, 49 => 0xf3, 50 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 49 => 0xf8, 50 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 49 => 0xfd, 50 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x82, 43 => 0x4f, 47 => 0x58, 48 => 0x58, 49 => 0x58, 50 => 0x60 },
	'wb_rggblevelsunknown30' => { 49 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x87, 43 => 0x54, 47 => 0x5d, 48 => 0x5d, 49 => 0x5d, 50 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x8c, 43 => 0x59, 47 => 0x62, 48 => 0x62, 49 => 0x62, 50 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x91, 43 => 0x5e, 47 => 0x8a, 48 => 0x67, 49 => 0x67, 50 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x96, 43 => 0x63, 47 => 0x8f, 48 => 0x6c, 49 => 0x6c, 50 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x9b, 43 => 0x68, 47 => 0x94, 48 => 0x71, 49 => 0x71, 50 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0xa0, 43 => 0x6d, 47 => 0x99, 48 => 0x76, 49 => 0x76, 50 => 0x7e },
	'wb_rggblevelsuserselected' => { 367 => 0x5c },
	'wbadjblueamber' => { 103 => 0x20106 },
	'wbadjbluebalance' => { 282 => 0x8 },
	'wbadjcolortemp' => { 103 => 0x20102, 108 => 0x1a },
	'wbadjlighting' => { 282 => 0x14 },
	'wbadjmagentagreen' => { 103 => 0x20105 },
	'wbadjmode' => { 282 => 0x10 },
	'wbadjredbalance' => { 282 => 0x0 },
	'wbadjrggblevels' => { 103 => 0x20125, 108 => 0x6 },
	'wbadjtemperature' => { 282 => 0x18 },
	'wbadjtint' => { 282 => 0x25 },
	'wbbluelevel' => { 319 => 0x324, 324 => 0x8006, 329 => 0x26 },
	'wbbracketingsteps' => { 251 => 0x174d, 252 => 0x87c, 261 => 0x1757 },
	'wbbracketmode' => { 57 => 0x9 },
	'wbbracketshotnumber' => { 187 => 0x2b, 391 => 0x101a },
	'wbbracketvalueab' => { 57 => 0xc },
	'wbbracketvaluegm' => { 57 => 0xd },
	'wbfinetuneactive' => { 108 => 0x24 },
	'wbfinetunesaturation' => { 108 => 0x28 },
	'wbfinetunetone' => { 108 => 0x2c },
	'wbgreenlevel' => { 319 => 0x323, 324 => 0x8005, 329 => 0x25 },
	'wbmediaimagesizesetting' => { 84 => 0x708 },
	'wbmode' => { 189 => 0x4, 306 => 0x1015 },
	'wbredlevel' => { 319 => 0x322, 324 => 0x8004, 329 => 0x24 },
	'wbscale' => { 190 => 0x0 },
	'wbshiftab' => { 74 => 0xc, 324 => 0x46, 341 => 0x10 },
	'wbshiftab_gm' => { 424 => 0x2014 },
	'wbshiftab_gm_precise' => { 424 => 0x2026 },
	'wbshiftcreativecontrol' => { 324 => 0x92 },
	'wbshiftgm' => { 74 => 0xd, 324 => 0x47, 341 => 0x11 },
	'wbshiftintelligentauto' => { 324 => 0x8b },
	'wbtype1' => { 330 => 0x1, 331 => 0x1 },
	'wbtype2' => { 330 => 0x4, 331 => 0x5 },
	'wbtype3' => { 330 => 0x7, 331 => 0x9 },
	'wbtype4' => { 330 => 0xa, 331 => 0xd },
	'wbtype5' => { 330 => 0xd, 331 => 0x11 },
	'wbtype6' => { 330 => 0x10, 331 => 0x15 },
	'wbtype7' => { 330 => 0x13, 331 => 0x19 },
	'webstatement' => { 513 => 'WebStatement' },
	'weightedflatsubject' => { 474 => 'weightedFlatSubject' },
	'what' => { 482 => 'What', 484 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 74 => 0x8, 77 => 0x7, 112 => 0x7, 113 => [0x19,0x2012], 119 => [0xa403,0xfe4e], 127 => 0x1002, 138 => 0x3fc, 139 => 0xfa0d, 140 => 0x40, 151 => 0x1a, 181 => 0x3, 182 => 0xe, 183 => 0x4, 184 => 0xb, 186 => 0x115, 227 => 0x5, 266 => 0x7, 319 => 0x304, 324 => 0x3, 326 => 0x3033, 359 => 0x19, 366 => 0x7, 390 => 0x26, 391 => 0x1003, 401 => [0x88,0x3c,0x7,0x58], 411 => 0xf, 412 => 0xe, 424 => [0x115,0xb054], 482 => 'WhiteBalance', 484 => 'WhiteBalance', 488 => 'WhiteBalance' },
	'whitebalance0' => { 176 => 'WhiteBalance0' },
	'whitebalance1' => { 176 => 'WhiteBalance1' },
	'whitebalance2' => { 176 => 'WhiteBalance2', 301 => 0x500 },
	'whitebalanceadj' => { 103 => 0x20101, 108 => 0x18, 276 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 337 => 0x0 },
	'whitebalancebias' => { 113 => 0x2011, 306 => 0x304, 324 => 0x23 },
	'whitebalanceblue' => { 74 => 0x7 },
	'whitebalancebracket' => { 301 => 0x502, 306 => 0x303 },
	'whitebalancebracketing' => { 184 => 0x22, 187 => 0x2c, 422 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 299 => 0x1c5 },
	'whitebalancecomp' => { 309 => 0x1001 },
	'whitebalancedetected' => { 138 => 0x3fb },
	'whitebalancefinetune' => { 127 => 0x100a, 184 => 0x38, 186 => 0x112, 227 => [0xb,0x3f], 391 => 0x1004, 411 => 0x6, 412 => 0x5, 424 => 0x112 },
	'whitebalancemode' => { 138 => 0x3fa, 359 => 0x1a },
	'whitebalancered' => { 74 => 0x6 },
	'whitebalanceset' => { 340 => 0xa },
	'whitebalancesetting' => { 184 => 0x23, 411 => 0x5, 412 => 0x4, 413 => 0x16, 429 => 0xd },
	'whitebalancesetup' => { 398 => 0x41 },
	'whitebalancetemperature' => { 301 => 0x501 },
	'whiteboard' => { 306 => 0x301 },
	'whitelevel' => { 119 => 0xc61d, 359 => 0x7e, 431 => 0x787f },
	'whitepoint' => { 119 => 0x13e, 323 => 0x35d, 359 => 0x201, 505 => 'WhitePoint' },
	'whites2012' => { 482 => 'Whites2012', 484 => 'Whites2012' },
	'whitesadj' => { 459 => 0x9017 },
	'wideadapter' => { 391 => 0x1017 },
	'widefocuszone' => { 181 => 0x2f },
	'widerange' => { 400 => 0x20f },
	'windmode' => { 138 => 0x3f4 },
	'windnoisereduction' => { 231 => 0x2d6, 232 => 0x2fe },
	'windowlocation' => { 384 => 'WLOC' },
	'windowsatom' => { 483 => 'windowsAtom' },
	'windowsatomextension' => { 483 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 483 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 483 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 499 => 'wordCount' },
	'work' => { 376 => "\xa9wrk" },
	'workcolorspace' => { 103 => 0x10200, 108 => 0x270 },
	'workflowtag' => { 495 => 'WorkflowTag' },
	'workflowtagcvid' => { 495 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 495 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 495 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 495 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 490 => 'WorkToDo' },
	'worldtimelocation' => { 324 => 0x3a, 359 => 0x22, 365 => '0.1' },
	'writer' => { 179 => 'WM/Writer' },
	'writer-editor' => { 131 => 0x7a },
	'x3filllight' => { 401 => 0x12 },
	'xattrquarantine' => { 174 => 'com.apple.quarantine' },
	'xilinxversion' => { 138 => 0x414 },
	'xml' => { 136 => 'xml ' },
	'xmp' => { 106 => 0xffff00f6, 120 => 'XMP' },
	'xmptoolkit' => { 506 => 'xmptk' },
	'xpauthor' => { 119 => 0x9c9d },
	'xpcomment' => { 119 => 0x9c9c },
	'xpkeywords' => { 119 => 0x9c9e },
	'xposition' => { 119 => 0x11e },
	'xpsubject' => { 119 => 0x9c9f },
	'xptitle' => { 119 => 0x9c9b },
	'xresolution' => { 119 => 0x11a, 134 => 0x3, 374 => 0x0, 505 => 'XResolution' },
	'xyresolution' => { 123 => 0x3 },
	'yaw' => { 115 => 0x7, 384 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 251 => 0x3513, 252 => 0x2c2c, 256 => 0xc222, 261 => 0x36fc, 262 => 0x2f03, 264 => 0xce3a, 265 => 0x80cd, 396 => 0x0 },
	'ycbcrcoefficients' => { 119 => 0x211, 505 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 119 => 0x213, 505 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 119 => 0x212, 505 => 'YCbCrSubSampling' },
	'year' => { 376 => 'yrrc', 378 => 'year', 384 => 'yrrc' },
	'yearcreated' => { 140 => 0x10, 149 => 0xc },
	'yellowhsl' => { 103 => 0x20912 },
	'yield' => { 501 => 'yield' },
	'yposition' => { 119 => 0x11f },
	'yresolution' => { 119 => 0x11b, 134 => 0x5, 374 => 0x4, 505 => 'YResolution' },
	'zebrapatterntonerange' => { 299 => 0x211 },
	'zoneidentifier' => { 120 => 'ZoneIdentifier' },
	'zonematching' => { 186 => 0x10a, 189 => [0x3a,0x4a], 424 => 0xb024 },
	'zonematchingmode' => { 184 => 0x14 },
	'zonematchingon' => { 183 => 0x75 },
	'zonematchingvalue' => { 411 => 0x1f },
	'zoomedpreviewlength' => { 306 => 0xf05 },
	'zoomedpreviewsize' => { 306 => 0xf06 },
	'zoomedpreviewstart' => { 306 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 304 => 0x300, 306 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsz9' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menusettingsz7ii' => 1,
	'menusettingsz9' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
