#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 105 => 0x69 },
	'about' => { 476 => 'about' },
	'aboutcvterm' => { 468 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 468 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 468 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 468 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 468 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 112 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 482 => 'absPeakAudioFilePath' },
	'academicfield' => { 472 => 'academicField' },
	'acceleration' => { 115 => 0x9404, 463 => 'Acceleration' },
	'accelerationtracking' => { 80 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 373 => 0x3 },
	'accelerometerx' => { 303 => 0x8d },
	'accelerometery' => { 303 => 0x8e },
	'accelerometerz' => { 303 => 0x8c },
	'accessoryserialnumber' => { 303 => 0x54 },
	'accessorytype' => { 303 => 0x53 },
	'actionadvised' => { 127 => 0x2a },
	'activearea' => { 115 => 0xc68d },
	'actived-lighting' => { 216 => 0x22, 254 => 0x24 },
	'actived-lightingmode' => { 254 => 0x25 },
	'adaptervoltage' => { 133 => 0x407 },
	'addaspectratioinfo' => { 80 => 0x80e },
	'addiptcinformation' => { 80 => 0x815 },
	'additionalmodelinformation' => { 468 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 80 => 0x80f, 81 => 0x11, 82 => 0x13, 85 => 0x14 },
	'address' => { 154 => 'Address' },
	'adjustmentmode' => { 380 => 0x15 },
	'adlbracketingstep' => { 235 => 0x883 },
	'adlbracketingtype' => { 235 => 0x884 },
	'adobe' => { 116 => 'Adobe' },
	'adultcontentwarning' => { 290 => 'AdultContentWarning', 475 => 'adultContentWarning' },
	'advancedfilter' => { 123 => 0x1201 },
	'advancedraw' => { 256 => 0x76a43203 },
	'advancedscenetype' => { 303 => 0x3d },
	'advisory' => { 480 => 'Advisory' },
	'ae_iso' => { 311 => 0x2, 312 => 0x4, 313 => 0x12 },
	'aeaperture' => { 311 => 0x1, 312 => 0x3, 313 => 0x11 },
	'aeaperturesteps' => { 311 => 0x8, 312 => 0xb },
	'aebautocancel' => { 80 => 0x104 },
	'aebbracketvalue' => { 74 => 0x11 },
	'aebracketingsteps' => { 234 => 0x174c, 235 => 0x87b, 243 => 0x1756 },
	'aebsequence' => { 80 => 0x105 },
	'aebsequenceautocancel' => { 78 => 0x9, 79 => 0x9, 81 => 0x8, 82 => 0x9, 85 => 0x9, 86 => 0x7 },
	'aebshotcount' => { 80 => 0x106 },
	'aebxv' => { 311 => 0x4, 312 => 0x6 },
	'aeerror' => { 312 => 0x8 },
	'aeexposuretime' => { 311 => 0x0, 312 => 0x2, 313 => 0x10 },
	'aelbutton' => { 176 => 0x45 },
	'aelexposureindicator' => { 176 => 0x51 },
	'aelock' => { 176 => 0x5b, 265 => '4.2', 274 => '4.2', 280 => 0x201, 338 => 0x48, 388 => 0x40, 389 => 0x40, 390 => [0x86,0x286] },
	'aelockbutton' => { 263 => '16.1', 265 => '4.1', 268 => '15.1', 269 => '16.1', 270 => '16.1', 272 => '30.1', 273 => '16.1', 274 => '4.1', 276 => '17.1', 278 => '17.1' },
	'aelockbuttonplusdials' => { 263 => '16.2', 272 => '32.1', 276 => '44.1' },
	'aelockformb-d80' => { 278 => '3.1' },
	'aelockmetermodeafterfocus' => { 80 => 0x114 },
	'aemaxaperture' => { 311 => 0x9, 312 => 0x10, 313 => 0x1c },
	'aemaxaperture2' => { 311 => 0xa, 312 => 0x11, 313 => 0x1d },
	'aemeteringmode' => { 311 => 0xc },
	'aemeteringmode2' => { 311 => '13.1' },
	'aemeteringsegments' => { 179 => 0x628, 338 => 0x209 },
	'aemicroadjustment' => { 80 => 0x110 },
	'aeminaperture' => { 311 => 0xb, 312 => 0x12, 313 => 0x1e },
	'aeminexposuretime' => { 311 => 0x5, 312 => 0x13, 313 => 0x1f },
	'aeprogrammode' => { 311 => 0x6 },
	'aeprojectlink' => { 457 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 457 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 457 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 457 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 457 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 457 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 311 => 0xd },
	'aexv' => { 311 => 0x3, 312 => 0x5 },
	'af-cpriority' => { 124 => '0.2' },
	'af-cpriorityselection' => { 263 => '1.1', 264 => '1.1', 266 => '1.1', 267 => '1.1', 269 => '0.1', 270 => '0.1', 271 => '0.1', 272 => '1.1', 273 => '0.1', 276 => '1.1', 277 => '1.1' },
	'af-csetting' => { 120 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 120 => '0.2' },
	'af-ctrackingsensitivity' => { 120 => '0.1' },
	'af-czoneareaswitching' => { 120 => '0.3' },
	'af-onbutton' => { 266 => '70.1', 267 => '70.1', 277 => '70.1' },
	'af-onformb-d10' => { 263 => '3.3', 272 => '3.2' },
	'af-onformb-d11' => { 273 => '2.2' },
	'af-onformb-d12' => { 276 => '50.1' },
	'af-spriority' => { 124 => '0.1' },
	'af-spriorityselection' => { 263 => '1.2', 264 => '1.2', 266 => '1.2', 267 => '1.2', 271 => '0.2', 272 => '1.2', 273 => '0.2', 276 => '1.2', 277 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 263 => '2.1', 264 => '2.1', 266 => '78.3', 267 => '78.3', 272 => '2.1', 276 => '2.1', 277 => '78.3' },
	'afadjustment' => { 338 => 0x72, 347 => 0x267 },
	'afandmeteringbuttons' => { 80 => 0x701 },
	'afaperture' => { 209 => 0x5, 210 => 0x5, 214 => 0x5 },
	'afareaheight' => { 185 => [0x1a,0x34,0x50] },
	'afareaillumination' => { 176 => 0x4b, 274 => '15.3' },
	'afareamode' => { 122 => '0.2', 172 => 0x33, 176 => 0xe, 184 => 0x0, 185 => 0x5, 303 => 0xf, 370 => 0x1205, 381 => [0xa,0x3a], 388 => 0x11, 389 => 0x10, 390 => 0x24, 401 => 0xb043, 424 => 0x17 },
	'afareamodesetting' => { 265 => '11.1', 268 => '0.1', 274 => '16.1', 278 => '2.1', 401 => 0x201c },
	'afareapointsize' => { 122 => '0.3' },
	'afareas' => { 280 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 80 => 0x51b },
	'afareawidth' => { 185 => [0x18,0x32,0x4e] },
	'afareaxposition' => { 185 => [0x14,0x2e,0x4a], 370 => 0x1203 },
	'afareaxposition1' => { 370 => 0x1201 },
	'afareayposition' => { 185 => [0x16,0x30,0x4c], 370 => 0x1204 },
	'afareayposition1' => { 370 => 0x1202 },
	'afareazonesize' => { 122 => '0.4' },
	'afassist' => { 78 => 0x5, 86 => 0x5, 176 => 0x48, 263 => '2.5', 265 => '0.2', 268 => '0.2', 269 => '1.1', 270 => '1.1', 271 => '1.3', 272 => '2.4', 273 => '1.3', 274 => '0.2', 276 => '2.4', 278 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 80 => 0x50e, 81 => 0x4, 82 => 0x5, 83 => 0x4, 84 => 0x4, 85 => 0x5 },
	'afassistlamp' => { 303 => 0x31 },
	'afbuttonpressed' => { 390 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 314 => 0x6 },
	'afduringliveview' => { 80 => 0x511 },
	'affinea' => { 450 => 'AffineA' },
	'affineb' => { 450 => 'AffineB' },
	'affinec' => { 450 => 'AffineC' },
	'affined' => { 450 => 'AffineD' },
	'affinetune' => { 186 => 0x0, 280 => 0x306 },
	'affinetuneadj' => { 186 => 0x2, 227 => 0x2d1, 228 => 0x2dc, 280 => 0x307 },
	'affinetuneindex' => { 186 => 0x1 },
	'affinex' => { 450 => 'AffineX' },
	'affiney' => { 450 => 'AffineY' },
	'afhold' => { 314 => 0x1fd },
	'afilluminator' => { 388 => 0x29, 401 => 0xb044 },
	'afimageheight' => { 185 => [0x12,0x2c,0x48] },
	'afimagewidth' => { 185 => [0x10,0x2a,0x46] },
	'afintegrationtime' => { 314 => 0x7 },
	'afmicroadj' => { 381 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 385 => 0x131 },
	'afmicroadjregisteredlenses' => { 385 => '305.1' },
	'afmicroadjustment' => { 80 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 385 => 0x130 },
	'afmode' => { 109 => 0x3009, 123 => 0x1022, 172 => 0x16, 380 => 0x5 },
	'afmoderestrictions' => { 264 => '50.3', 266 => '48.3', 267 => '48.3', 276 => '48.3', 277 => '48.3' },
	'afonaelockbuttonswitch' => { 80 => 0x702 },
	'afonbutton' => { 263 => '3.1', 264 => '47.1' },
	'afpoint' => { 34 => 0x13, 108 => 0x18, 172 => 0x15, 184 => 0x1, 283 => 0x308, 380 => 0x1f, 381 => [0x37,0x7], 385 => 0x19, 386 => 0x18, 387 => [0x18,0x20] },
	'afpointactivationarea' => { 79 => 0x11, 85 => 0x11 },
	'afpointareaexpansion' => { 80 => 0x508 },
	'afpointatshutterrelease' => { 381 => [0x39,0x9] },
	'afpointautoselection' => { 80 => 0x50b },
	'afpointbrightness' => { 80 => 0x50d, 263 => '2.4', 264 => '46.5', 266 => '2.2', 267 => '2.2', 276 => '2.3', 277 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 80 => 0x50c },
	'afpointillumination' => { 79 => 0xa, 263 => '2.3', 264 => '46.2', 266 => '47.2', 267 => '47.2', 271 => '1.2', 272 => '2.3', 273 => '1.2', 276 => '47.2', 277 => '47.2', 278 => '2.4' },
	'afpointinfocus' => { 381 => [0x38,0x8] },
	'afpointmode' => { 319 => 0x3 },
	'afpointposition' => { 109 => 0x2021, 303 => 0x4d },
	'afpointregistration' => { 78 => 0x7 },
	'afpoints' => { 175 => 0x10 },
	'afpointselected' => { 176 => 0xd, 280 => 0x305, 338 => 0xe, 385 => 0x15, 386 => 0x14, 387 => [0x14,0x1c], 401 => 0x201e },
	'afpointselected2' => { 319 => 0x4 },
	'afpointselection' => { 79 => 0xb, 263 => '1.3', 264 => '1.3', 272 => '1.3', 276 => '1.3', 277 => '1.3' },
	'afpointselectionmethod' => { 80 => 0x50f, 81 => 0xc, 82 => 0xd, 85 => 0xd },
	'afpointsetting' => { 388 => 0x12, 389 => 0x11 },
	'afpointsinfocus' => { 74 => 0xe, 184 => 0x2, 314 => 0xb, 315 => 0x4, 338 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 79 => 0xd },
	'afpointsselected' => { 315 => '4.1', 432 => 0x4 },
	'afpointsspecial' => { 315 => '4.2' },
	'afpointsunknown1' => { 314 => 0x0 },
	'afpointsunknown2' => { 314 => 0x2 },
	'afpointsused' => { 185 => 0x8, 381 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 314 => 0x4 },
	'afresponse' => { 216 => 0xad },
	'afresult' => { 285 => 0x1038 },
	'afsearch' => { 280 => 0x303 },
	'afsensoractive' => { 172 => 0x1 },
	'afstatus' => { 370 => 0x1200 },
	'afstatus_00_b4' => { 384 => 0x0 },
	'afstatus_01_c4' => { 384 => 0x2 },
	'afstatus_02_d4' => { 384 => 0x4 },
	'afstatus_03_e4' => { 384 => 0x6 },
	'afstatus_04_f4' => { 384 => 0x8 },
	'afstatus_05_g4' => { 384 => 0xa },
	'afstatus_06_h4' => { 384 => 0xc },
	'afstatus_07_b3' => { 384 => 0xe },
	'afstatus_08_c3' => { 384 => 0x10 },
	'afstatus_09_d3' => { 384 => 0x12 },
	'afstatus_10_e3' => { 384 => 0x14 },
	'afstatus_11_f3' => { 384 => 0x16 },
	'afstatus_12_g3' => { 384 => 0x18 },
	'afstatus_13_h3' => { 384 => 0x1a },
	'afstatus_14_b2' => { 384 => 0x1c },
	'afstatus_15_c2' => { 384 => 0x1e },
	'afstatus_16_d2' => { 384 => 0x20 },
	'afstatus_17_e2' => { 384 => 0x22 },
	'afstatus_18_f2' => { 384 => 0x24 },
	'afstatus_19_g2' => { 384 => 0x26 },
	'afstatus_20_h2' => { 384 => 0x28 },
	'afstatus_21_c1' => { 384 => 0x2a },
	'afstatus_22_d1' => { 384 => 0x2c },
	'afstatus_23_e1' => { 384 => 0x2e },
	'afstatus_24_f1' => { 384 => 0x30 },
	'afstatus_25_g1' => { 384 => 0x32 },
	'afstatus_26_a7_vertical' => { 384 => 0x34 },
	'afstatus_27_a6_vertical' => { 384 => 0x36 },
	'afstatus_28_a5_vertical' => { 384 => 0x38 },
	'afstatus_29_c7_vertical' => { 384 => 0x3a },
	'afstatus_30_c6_vertical' => { 384 => 0x3c },
	'afstatus_31_c5_vertical' => { 384 => 0x3e },
	'afstatus_32_e7_vertical' => { 384 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 384 => 0x42 },
	'afstatus_34_e5_vertical' => { 384 => 0x44 },
	'afstatus_35_g7_vertical' => { 384 => 0x46 },
	'afstatus_36_g6_vertical' => { 384 => 0x48 },
	'afstatus_37_g5_vertical' => { 384 => 0x4a },
	'afstatus_38_i7_vertical' => { 384 => 0x4c },
	'afstatus_39_i6_vertical' => { 384 => 0x4e },
	'afstatus_40_i5_vertical' => { 384 => 0x50 },
	'afstatus_41_a7' => { 384 => 0x52 },
	'afstatus_42_b7' => { 384 => 0x54 },
	'afstatus_43_c7' => { 384 => 0x56 },
	'afstatus_44_d7' => { 384 => 0x58 },
	'afstatus_45_e7' => { 384 => 0x5a },
	'afstatus_46_f7' => { 384 => 0x5c },
	'afstatus_47_g7' => { 384 => 0x5e },
	'afstatus_48_h7' => { 384 => 0x60 },
	'afstatus_49_i7' => { 384 => 0x62 },
	'afstatus_50_a6' => { 384 => 0x64 },
	'afstatus_51_b6' => { 384 => 0x66 },
	'afstatus_52_c6' => { 384 => 0x68 },
	'afstatus_53_d6' => { 384 => 0x6a },
	'afstatus_54_e6_center' => { 384 => 0x6c },
	'afstatus_55_f6' => { 384 => 0x6e },
	'afstatus_56_g6' => { 384 => 0x70 },
	'afstatus_57_h6' => { 384 => 0x72 },
	'afstatus_58_i6' => { 384 => 0x74 },
	'afstatus_59_a5' => { 384 => 0x76 },
	'afstatus_60_b5' => { 384 => 0x78 },
	'afstatus_61_c5' => { 384 => 0x7a },
	'afstatus_62_d5' => { 384 => 0x7c },
	'afstatus_63_e5' => { 384 => 0x7e },
	'afstatus_64_f5' => { 384 => 0x80 },
	'afstatus_65_g5' => { 384 => 0x82 },
	'afstatus_66_h5' => { 384 => 0x84 },
	'afstatus_67_i5' => { 384 => 0x86 },
	'afstatus_68_c11' => { 384 => 0x88 },
	'afstatus_69_d11' => { 384 => 0x8a },
	'afstatus_70_e11' => { 384 => 0x8c },
	'afstatus_71_f11' => { 384 => 0x8e },
	'afstatus_72_g11' => { 384 => 0x90 },
	'afstatus_73_b10' => { 384 => 0x92 },
	'afstatus_74_c10' => { 384 => 0x94 },
	'afstatus_75_d10' => { 384 => 0x96 },
	'afstatus_76_e10' => { 384 => 0x98 },
	'afstatus_77_f10' => { 384 => 0x9a },
	'afstatus_78_g10' => { 384 => 0x9c },
	'afstatus_79_h10' => { 384 => 0x9e },
	'afstatus_80_b9' => { 384 => 0xa0 },
	'afstatus_81_c9' => { 384 => 0xa2 },
	'afstatus_82_d9' => { 384 => 0xa4 },
	'afstatus_83_e9' => { 384 => 0xa6 },
	'afstatus_84_f9' => { 384 => 0xa8 },
	'afstatus_85_g9' => { 384 => 0xaa },
	'afstatus_86_h9' => { 384 => 0xac },
	'afstatus_87_b8' => { 384 => 0xae },
	'afstatus_88_c8' => { 384 => 0xb0 },
	'afstatus_89_d8' => { 384 => 0xb2 },
	'afstatus_90_e8' => { 384 => 0xb4 },
	'afstatus_91_f8' => { 384 => 0xb6 },
	'afstatus_92_g8' => { 384 => 0xb8 },
	'afstatus_93_h8' => { 384 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 384 => 0xbc },
	'afstatusactivesensor' => { 172 => 0x2, 381 => [0x4,0x3b], 385 => 0x1e, 386 => 0x1b, 387 => [0x1b,0x21] },
	'afstatusbottom' => { 172 => 0x8, 385 => 0x2a, 386 => 0x21, 387 => 0x21 },
	'afstatusbottom-left' => { 172 => 0x12, 386 => 0x2b, 387 => 0x2b },
	'afstatusbottom-right' => { 172 => 0x6, 386 => 0x1f, 387 => 0x1f },
	'afstatusbottomassist-left' => { 385 => 0x28 },
	'afstatusbottomassist-right' => { 385 => 0x2c },
	'afstatusbottomhorizontal' => { 382 => 0x10, 383 => 0x1c },
	'afstatusbottomvertical' => { 382 => 0x16, 383 => 0x26 },
	'afstatuscenter-10' => { 385 => 0x34 },
	'afstatuscenter-11' => { 385 => 0x36 },
	'afstatuscenter-12' => { 385 => 0x38 },
	'afstatuscenter-14' => { 385 => 0x3c },
	'afstatuscenter-7' => { 385 => 0x2e },
	'afstatuscenter-9' => { 385 => 0x32 },
	'afstatuscenter-horizontal' => { 385 => 0x30 },
	'afstatuscenter-vertical' => { 385 => 0x3a },
	'afstatuscenterf2-8' => { 385 => 0x4c },
	'afstatuscenterhorizontal' => { 172 => 0x2f, 382 => 0xc, 383 => 0x18, 386 => 0x2f, 387 => 0x2f },
	'afstatuscentervertical' => { 172 => 0xc, 382 => 0x14, 383 => 0x22, 386 => 0x25, 387 => 0x25 },
	'afstatusfarleft' => { 382 => 0x6, 385 => 0x26 },
	'afstatusfarlefthorizontal' => { 383 => 0x4 },
	'afstatusfarleftvertical' => { 383 => 0x12 },
	'afstatusfarright' => { 382 => 0x18, 385 => 0x44 },
	'afstatusfarrighthorizontal' => { 383 => 0x2c },
	'afstatusfarrightvertical' => { 383 => 0x34 },
	'afstatusleft' => { 172 => 0x2d, 382 => 0x2, 385 => 0x22, 386 => 0x2d, 387 => 0x2d },
	'afstatuslefthorizontal' => { 383 => 0x6 },
	'afstatusleftvertical' => { 383 => 0xe },
	'afstatuslower-left' => { 382 => 0x4, 385 => 0x24 },
	'afstatuslower-lefthorizontal' => { 383 => 0xa },
	'afstatuslower-leftvertical' => { 383 => 0x10 },
	'afstatuslower-middle' => { 382 => 0x22, 383 => 0x24 },
	'afstatuslower-right' => { 382 => 0x1e, 385 => 0x4a },
	'afstatuslower-righthorizontal' => { 383 => 0x32 },
	'afstatuslower-rightvertical' => { 383 => 0x3a },
	'afstatuslowerfarleft' => { 383 => 0x8 },
	'afstatuslowerfarright' => { 383 => 0x30 },
	'afstatusmiddlehorizontal' => { 172 => 0xa, 386 => 0x23, 387 => 0x23 },
	'afstatusnearleft' => { 382 => 0xe, 383 => 0x1a },
	'afstatusnearright' => { 382 => 0xa, 383 => 0x16 },
	'afstatusright' => { 172 => 0x31, 382 => 0x1c, 385 => 0x48, 386 => 0x31, 387 => 0x31 },
	'afstatusrighthorizontal' => { 383 => 0x2e },
	'afstatusrightvertical' => { 383 => 0x38 },
	'afstatustop' => { 172 => 0xe, 385 => 0x40, 386 => 0x27, 387 => 0x27 },
	'afstatustop-left' => { 172 => 0x10, 386 => 0x29, 387 => 0x29 },
	'afstatustop-right' => { 172 => 0x4, 386 => 0x1d, 387 => 0x1d },
	'afstatustopassist-left' => { 385 => 0x3e },
	'afstatustopassist-right' => { 385 => 0x42 },
	'afstatustophorizontal' => { 382 => 0x8, 383 => 0x14 },
	'afstatustopvertical' => { 382 => 0x12, 383 => 0x1e },
	'afstatusupper-left' => { 382 => 0x0, 385 => 0x20 },
	'afstatusupper-lefthorizontal' => { 383 => 0x2 },
	'afstatusupper-leftvertical' => { 383 => 0xc },
	'afstatusupper-middle' => { 382 => 0x20, 383 => 0x20 },
	'afstatusupper-right' => { 382 => 0x1a, 385 => 0x46 },
	'afstatusupper-righthorizontal' => { 383 => 0x2a },
	'afstatusupper-rightvertical' => { 383 => 0x36 },
	'afstatusupperfarleft' => { 383 => 0x0 },
	'afstatusupperfarright' => { 383 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 401 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 381 => 0x2 },
	'afwithshutter' => { 388 => 0x2a },
	'aggregateissuenumber' => { 472 => 'aggregateIssueNumber' },
	'aggregationtype' => { 472 => 'aggregationType' },
	'agreement' => { 475 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 133 => 0xe4e },
	'aiservocontinuousshooting' => { 79 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 80 => 0x519 },
	'aiservoimagepriority' => { 80 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 80 => 0x51a },
	'aiservotrackingmethod' => { 80 => 0x504 },
	'aiservotrackingsensitivity' => { 79 => 0x14, 80 => 0x502 },
	'album' => { 355 => ['albm',"\xa9alb"], 357 => 'album', 363 => ['albm',"\xa9alb"], 482 => 'album' },
	'albumartist' => { 355 => 'aART', 363 => 'albr' },
	'albumtitleid' => { 355 => 'atID' },
	'alreadyapplied' => { 456 => 'AlreadyApplied', 458 => 'AlreadyApplied' },
	'alternatetitle' => { 472 => 'alternateTitle' },
	'alternatetitlea-lang' => { 472 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 472 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 472 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 187 => 0x6 },
	'alttapename' => { 482 => 'altTapeName' },
	'alttimecode' => { 482 => 'altTimecode' },
	'alttimecodetimeformat' => { 482 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 482 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 482 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 366 => 0x5c },
	'ambientlight' => { 366 => 0x5e },
	'ambienttemperature' => { 115 => 0x9400, 364 => 0x14, 365 => 0x46, 366 => 0x50, 424 => 0x4, 463 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 364 => 0x13, 365 => 0x44, 366 => 0x4e },
	'analogbalance' => { 115 => 0xc627 },
	'analogcaptureiso' => { 133 => 0x89e },
	'analogisotable' => { 133 => 0x89d },
	'androidversion' => { 357 => 'com.android.version' },
	'angleadj' => { 99 => 0x10003, 105 => 0x8b },
	'angleinforoll' => { 452 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 452 => 'AngleInfoYaw' },
	'anti-blur' => { 401 => 0xb04b },
	'antialiasstrength' => { 115 => 0xc632 },
	'aperturelock' => { 264 => '38.2', 266 => '38.2', 267 => '38.2', 276 => '38.2', 277 => '38.2' },
	'aperturemode' => { 363 => 'apmd' },
	'aperturerange' => { 80 => 0x10d },
	'apertureringuse' => { 319 => '1.4' },
	'aperturesetting' => { 176 => 0x7, 388 => 0x30, 389 => 0x29, 390 => 0x1 },
	'aperturevalue' => { 89 => 0x2, 115 => 0x9202, 285 => 0x1002, 347 => 0x401, 462 => 'ApertureValue' },
	'applekeywords' => { 289 => 'AAPL:Keywords' },
	'applestoreaccount' => { 355 => 'apID' },
	'applestoreaccounttype' => { 355 => 'akID' },
	'applestorecatalogid' => { 355 => 'cnID' },
	'applestorecountry' => { 355 => 'sfID' },
	'applicationkeystring' => { 133 => 0x400 },
	'applicationnotes' => { 115 => 0x2bc, 308 => 0x2bc },
	'applicationrecordversion' => { 127 => 0x0 },
	'applyshootingmeteringmode' => { 80 => 0x10e },
	'approved' => { 464 => 'Approved' },
	'approvedby' => { 464 => 'ApprovedBy' },
	'approximatefnumber' => { 298 => 0x313, 305 => 0x3406 },
	'approximatefocusdistance' => { 453 => 'ApproximateFocusDistance' },
	'appversion' => { 466 => 'AppVersion' },
	'aps-csizecapture' => { 419 => 0x114, 420 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 99 => 0x20914 },
	'armidentifier' => { 128 => 0x78 },
	'armversion' => { 128 => 0x7a },
	'arranger' => { 363 => "\xa9arg" },
	'arrangerkeywords' => { 363 => "\xa9ark" },
	'artfilter' => { 280 => 0x529 },
	'artfiltereffect' => { 280 => 0x52f },
	'artist' => { 115 => 0x13b, 293 => 'Artist', 338 => 0x22e, 355 => "\xa9ART", 357 => 'artist', 363 => "\xa9ART", 478 => 'Artist', 482 => 'artist' },
	'artmode' => { 109 => 0x301b },
	'artmodeparameters' => { 109 => 0x310b },
	'artwork' => { 357 => 'artwork' },
	'artworkcircadatecreated' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 468 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 468 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 284 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 284 => 0x1112, 338 => 0x80, 388 => 0x55, 389 => 0x55, 390 => 0xa },
	'assetid' => { 446 => 'AssetID' },
	'asshoticcprofile' => { 115 => 0xc68f },
	'asshotneutral' => { 115 => 0xc628 },
	'asshotpreprofilematrix' => { 115 => 0xc690 },
	'asshotprofilename' => { 115 => 0xc6f6 },
	'asshotwhitexy' => { 115 => 0xc629 },
	'assignbktbutton' => { 263 => '4.2', 264 => '16.1', 266 => '16.1', 267 => '16.1', 276 => '16.1', 277 => '16.1' },
	'assignfuncbutton' => { 80 => 0x70b },
	'assignmb-d17af-onbutton' => { 267 => '79.1' },
	'assignmb-d17funcbutton' => { 267 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 267 => '68.1' },
	'assignmb-d18af-onbutton' => { 277 => '79.1' },
	'assignmb-d18funcbutton' => { 277 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 277 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 266 => '75.1', 267 => '75.1', 277 => '75.1' },
	'assignmoviefunc2button' => { 266 => '82.1', 267 => '82.1', 277 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 266 => '75.2', 267 => '75.2', 277 => '75.2' },
	'assignmovierecordbutton' => { 264 => '43.2', 276 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 266 => '45.1', 267 => '45.1', 277 => '45.1' },
	'assignmoviesubselector' => { 266 => '74.1', 267 => '74.1', 277 => '74.1' },
	'assignmoviesubselectorplusdials' => { 266 => '76.1', 267 => '76.1', 277 => '76.1' },
	'assignremotefnbutton' => { 264 => '54.1', 276 => '51.1' },
	'assistbuttonfunction' => { 78 => 0xd },
	'atcaptureusercrop' => { 133 => 0x943 },
	'attributionname' => { 454 => 'attributionName' },
	'attributionurl' => { 454 => 'attributionURL' },
	'audio' => { 303 => 0x20 },
	'audiobitrate' => { 64 => 0x6c, 468 => 'audioBitRate' },
	'audiobitratemode' => { 468 => 'audioBitRateMode' },
	'audiobitspersample' => { 468 => 'audioBitsPerSample' },
	'audiochannelcount' => { 468 => 'audioChannelCount' },
	'audiochannels' => { 64 => 0x70 },
	'audiochanneltype' => { 482 => 'audioChannelType' },
	'audiocompression' => { 80 => 0x816, 148 => 'Compression' },
	'audiocompressor' => { 482 => 'audioCompressor' },
	'audiodata' => { 438 => 'Data' },
	'audioduration' => { 127 => 0x99 },
	'audiogain' => { 357 => 'player.movie.audio.gain' },
	'audiomimetype' => { 438 => 'Mime' },
	'audiomoddate' => { 482 => 'audioModDate' },
	'audiooutcue' => { 127 => 0x9a },
	'audiosamplerate' => { 64 => 0x6e, 482 => 'audioSampleRate' },
	'audiosampletype' => { 482 => 'audioSampleType' },
	'audiosamplingrate' => { 127 => 0x97 },
	'audiosamplingresolution' => { 127 => 0x98 },
	'audiotype' => { 127 => 0x96 },
	'author' => { 150 => 'Author', 289 => 'Author', 293 => 'Author', 354 => 'Author', 355 => ['auth',"\xa9aut"], 357 => 'author', 363 => 'auth', 451 => 'author', 469 => 'Author', 480 => 'Author' },
	'authorsposition' => { 470 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 80 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 329 => '0.1' },
	'autobracket' => { 380 => 0x19 },
	'autobracketing' => { 123 => 0x1100, 338 => 0x18, 370 => 0x1007 },
	'autobracketingmode' => { 275 => '12.3' },
	'autobracketingset' => { 275 => '12.1' },
	'autobracketmodem' => { 263 => '21.2', 264 => '13.3', 266 => '13.2', 267 => '13.2', 272 => '26.2', 276 => '13.3', 277 => '13.2' },
	'autobracketorder' => { 176 => 0x43, 263 => '21.3', 264 => '13.2', 266 => '13.1', 267 => '13.1', 272 => '26.3', 273 => '12.2', 274 => '2.2', 275 => '12.2', 276 => '13.2', 277 => '13.1', 278 => '13.2' },
	'autobracketset' => { 263 => '21.1', 264 => '13.1', 268 => '11.1', 269 => '12.1', 270 => '12.1', 272 => '26.1', 273 => '12.1', 274 => '2.1', 276 => '13.1', 278 => '13.1' },
	'autobrightness' => { 456 => 'AutoBrightness', 458 => 'AutoBrightness' },
	'autocontrast' => { 456 => 'AutoContrast', 458 => 'AutoContrast' },
	'autodistortioncontrol' => { 197 => 0x4 },
	'autodynamicrange' => { 123 => 0x140b },
	'autoexposure' => { 456 => 'AutoExposure', 458 => 'AutoExposure' },
	'autoexposurebracketing' => { 74 => 0x10 },
	'autoflashisosensitivity' => { 266 => '38.5', 267 => '38.5', 277 => '38.5' },
	'autofocus' => { 283 => 0x209 },
	'autofp' => { 274 => '7.3', 278 => '31.4' },
	'autoiso' => { 74 => 0x1, 109 => 0x3008, 265 => '1.1', 274 => '1.1' },
	'autoisomax' => { 265 => '1.2', 274 => '1.2' },
	'autoisominshutterspeed' => { 265 => '1.3', 274 => '1.3' },
	'autolateralca' => { 456 => 'AutoLateralCA', 458 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 60 => 0x2, 80 => 0x204, 99 => 0x20500, 105 => 0x6f },
	'autolightingoptimizeron' => { 99 => '0x20500.0', 105 => 0x6e },
	'autoportraitframed' => { 401 => 0x2016 },
	'autoredeye' => { 256 => 0xfe28a44f },
	'autorotate' => { 74 => 0x1b },
	'autoshadows' => { 456 => 'AutoShadows', 458 => 'AutoShadows' },
	'autotone' => { 456 => 'AutoTone', 458 => 'AutoTone' },
	'autowhiteversion' => { 456 => 'AutoWhiteVersion', 458 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 216 => 0x82 },
	'avaperturesetting' => { 319 => 0x13 },
	'averageblacklevel' => { 43 => 0xe7, 45 => 0xfb, 46 => 0x114, 47 => 0x146 },
	'averagelv' => { 179 => 0x38 },
	'avsettingwithoutlens' => { 80 => 0x707 },
	'azimuth' => { 158 => 'Azimuth' },
	'babyage' => { 303 => [0x8010,0x33] },
	'babyname' => { 303 => 0x66 },
	'backgroundalpha' => { 477 => 'bgalpha' },
	'balance' => { 357 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 319 => 0x15 },
	'baseiso' => { 74 => 0x2, 93 => 0x101c, 133 => 0x903, 305 => 0x312a, 430 => 0x6 },
	'baseisodaylight' => { 133 => 0x910 },
	'baseisoflash' => { 133 => 0x913 },
	'baseisofluorescent' => { 133 => 0x912 },
	'baseisotungsten' => { 133 => 0x911 },
	'baselineexposure' => { 115 => 0xc62a },
	'baselineexposureoffset' => { 115 => 0xc7a5 },
	'baselinenoise' => { 115 => 0xc62b },
	'baselinesharpness' => { 115 => 0xc62c },
	'baseurl' => { 480 => 'BaseURL' },
	'bass' => { 357 => 'player.movie.audio.bass' },
	'batterylevel' => { 388 => 0x51, 392 => 0xc, 393 => 0x4, 394 => 0x4, 431 => 0x7 },
	'batterylevelgrip1' => { 431 => 0x6 },
	'batterylevelgrip2' => { 431 => 0x8 },
	'batteryorder' => { 263 => '12.5', 272 => '13.2', 273 => '2.1', 276 => '3.1' },
	'batterystate' => { 176 => 0x60, 388 => 0x50, 394 => 0x14 },
	'batterytemperature' => { 392 => 0x1, 394 => 0x2, 431 => 0x5 },
	'batterytype' => { 61 => 0x38, 366 => 0x66 },
	'batteryunknown' => { 392 => 0x2, 394 => 0x0 },
	'batteryvoltage' => { 133 => 0x408, 364 => 0x2a, 365 => 0x49, 366 => 0x62, 392 => 0x8 },
	'batteryvoltage1' => { 394 => 0x6 },
	'batteryvoltage2' => { 394 => 0x8 },
	'batteryvoltageavg' => { 366 => 0x64 },
	'bayergreensplit' => { 115 => 0xc62d },
	'bayerpattern' => { 132 => 0xf902, 180 => 0x17 },
	'beatsperminute' => { 355 => 'tmpo' },
	'beatspliceparams' => { 482 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 482 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 482 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 482 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 482 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 482 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 263 => '13.1', 264 => '5.4', 265 => '0.1', 268 => '2.1', 269 => '3.1', 270 => '3.1', 272 => '10.1', 274 => '0.1', 276 => '5.5', 278 => '4.1' },
	'beeppitch' => { 273 => '3.1' },
	'beepvolume' => { 273 => '4.5' },
	'bestqualityscale' => { 115 => 0xc65c },
	'bestshotmode' => { 109 => 0x3007 },
	'bitdepth' => { 155 => 'BitDepth', 180 => 0x11, 224 => 0x41 },
	'bitspercomponent' => { 129 => 0x87 },
	'bitspersample' => { 115 => 0x102, 308 => 0xa, 478 => 'BitsPerSample' },
	'blackacquirerows' => { 133 => 0x18ba },
	'blacklevel' => { 115 => 0xc61a, 195 => 0x20, 216 => 0x3d, 285 => [0x401,0x1012], 347 => 0x21d },
	'blacklevel2' => { 284 => 0x600, 288 => 0x600 },
	'blacklevelblue' => { 308 => 0x1e },
	'blacklevelbottom' => { 133 => 0x3f0 },
	'blackleveldata' => { 347 => 0x223 },
	'blackleveldeltah' => { 115 => 0xc61b },
	'blackleveldeltav' => { 115 => 0xc61c },
	'blacklevelgreen' => { 308 => 0x1d },
	'blacklevelred' => { 308 => 0x1c },
	'blacklevelrepeatdim' => { 115 => 0xc619 },
	'blacklevelrough' => { 133 => 0x40e },
	'blacklevelroughafter' => { 133 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 133 => 0x3ef },
	'blackpoint' => { 338 => 0x200 },
	'blacks2012' => { 456 => 'Blacks2012', 458 => 'Blacks2012' },
	'blacksadj' => { 434 => 0x9018 },
	'bleachbypasstoning' => { 338 => 0x7f },
	'blockshotafresponse' => { 266 => '1.5', 267 => '1.5', 277 => '1.5' },
	'blogtitle' => { 472 => 'blogTitle' },
	'blogurl' => { 472 => 'blogURL' },
	'bluebalance' => { 285 => 0x1018, 308 => 0x12, 338 => 0x1b },
	'bluecurvelimits' => { 104 => 0x1fe },
	'bluecurvepoints' => { 103 => 0x79, 104 => 0x1d4 },
	'bluehsl' => { 99 => 0x20915 },
	'bluehue' => { 456 => 'BlueHue', 458 => 'BlueHue' },
	'bluesaturation' => { 456 => 'BlueSaturation', 458 => 'BlueSaturation' },
	'bluratinfinity' => { 442 => 'BlurAtInfinity' },
	'blurcontrol' => { 338 => 0x82 },
	'blurwarning' => { 123 => 0x1300 },
	'bodybatteryadload' => { 317 => 0x3 },
	'bodybatteryadnoload' => { 317 => 0x2 },
	'bodybatterystate' => { 317 => '1.1' },
	'bodybatteryvoltage1' => { 317 => 0x2 },
	'bodybatteryvoltage2' => { 317 => 0x4 },
	'bodybatteryvoltage3' => { 317 => 0x6 },
	'bodybatteryvoltage4' => { 317 => 0x8 },
	'bodyfirmware' => { 371 => 0x0 },
	'bodyfirmwareversion' => { 281 => 0x104, 282 => 0x100, 285 => 0x104 },
	'bodyserialnumber' => { 371 => 0x10 },
	'bookedition' => { 472 => 'bookEdition' },
	'bootloaderversion' => { 365 => 0x26 },
	'bracketmode' => { 55 => 0x3 },
	'bracketsequence' => { 109 => 0x301d },
	'bracketsettings' => { 303 => 0x45 },
	'bracketshotnumber' => { 55 => 0x5, 319 => 0x9, 399 => 0x2b },
	'bracketshotnumber2' => { 399 => 0x2d },
	'bracketstep' => { 173 => 0xe },
	'bracketvalue' => { 55 => 0x4 },
	'brightness' => { 115 => 0xfe53, 149 => 'Brightness', 169 => 'Brightness', 173 => 0x2c, 218 => 0x34, 219 => 0x39, 220 => 0x41, 357 => 'player.movie.visual.brightness', 364 => 0x25, 366 => 0x54, 388 => 0x22, 401 => 0x2007, 456 => 'Brightness', 458 => 'Brightness' },
	'brightnessadj' => { 104 => 0x114, 249 => 0x0, 259 => 0x2d, 434 => 0x8018 },
	'brightnessvalue' => { 115 => 0x9203, 179 => [0x691,0x49c3], 285 => 0x1003, 406 => 0x1e, 409 => 0x1140, 410 => 0x1140, 411 => 0x111c, 412 => 0x1198, 413 => 0x1174, 414 => 0x102c, 415 => 0x224, 416 => 0x224, 417 => 0x219, 462 => 'BrightnessValue' },
	'buildnumber' => { 183 => 0x5500 },
	'bulbduration' => { 74 => 0x18 },
	'burstcount' => { 133 => 0x40d },
	'burstid' => { 439 => 'BurstID' },
	'burstmode' => { 135 => 0xa, 303 => 0x2a },
	'burstmode2' => { 135 => 0x18 },
	'burstprimary' => { 439 => 'BurstPrimary' },
	'burstshot' => { 380 => 0x34 },
	'burstspeed' => { 303 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 80 => 0x70a },
	'bwadjustment' => { 123 => 0x1049 },
	'bwfilter' => { 173 => 0x2a, 181 => 0x39 },
	'bwmode' => { 285 => 0x203 },
	'by-line' => { 127 => 0x50 },
	'by-linetitle' => { 127 => 0x55 },
	'bytecount' => { 472 => 'byteCount' },
	'c14configuration' => { 133 => 0x1964 },
	'cacheversion' => { 115 => 0xc7aa },
	'calibratedfocallength' => { 112 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 112 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 112 => 'CalibratedOpticalCenterY' },
	'calibration' => { 380 => [0x24,0x30] },
	'calibrationhistory' => { 133 => 0x9c9 },
	'calibrationilluminant1' => { 115 => 0xc65a },
	'calibrationilluminant2' => { 115 => 0xc65b },
	'calibrationversion' => { 133 => 0x9c6 },
	'callforimage' => { 446 => 'CallForImage' },
	'cameraangle' => { 363 => 'angl', 482 => 'cameraAngle' },
	'cameraburstid' => { 440 => 'CameraBurstID' },
	'cameracalibration1' => { 115 => 0xc623 },
	'cameracalibration2' => { 115 => 0xc624 },
	'cameracalibrationsig' => { 115 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradirection' => { 357 => 'direction.facing' },
	'camerae-mountversion' => { 433 => 0xb },
	'cameraelevationangle' => { 115 => 0x9405, 463 => 'CameraElevationAngle' },
	'camerafilename' => { 446 => 'CameraFilename' },
	'cameraid' => { 285 => 0x209, 363 => 'cmid', 379 => 0x209 },
	'cameraidentifier' => { 357 => 'camera.identifier' },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 115 => 0xc7a1, 482 => 'cameraLabel' },
	'cameramakemodel' => { 446 => 'CameraMakeModel' },
	'cameramodel' => { 347 => 0x410, 482 => 'cameraModel' },
	'cameramodelid' => { 169 => 'CameraModelID' },
	'cameramotion' => { 357 => 'direction.motion' },
	'cameramove' => { 482 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => 0x36, 24 => 0x7d, 25 => 0x83, 26 => 0x84, 28 => 0x35, 29 => 0x96, 303 => 0x8f, 342 => 0x1, 347 => 0x100, 394 => [0x16,0x18], 421 => 0x28, 422 => 0x24, 423 => 0x29 },
	'cameraowner' => { 136 => 0xc353 },
	'cameraparameters' => { 285 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 111 => 0x9, 363 => "\xa9gpt" },
	'cameraprofile' => { 456 => 'CameraProfile', 458 => 'CameraProfile' },
	'cameraprofiledigest' => { 456 => 'CameraProfileDigest', 458 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 105 => 0xe1 },
	'camerarawcontrast' => { 105 => 0xe3 },
	'camerarawhighlightpoint' => { 105 => 0xe6 },
	'camerarawlinear' => { 105 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 105 => 0xe8 },
	'camerarawoutputshadowpoint' => { 105 => 0xe9 },
	'camerarawsaturation' => { 105 => 0xe2 },
	'camerarawshadowpoint' => { 105 => 0xe7 },
	'camerarawsharpness' => { 105 => 0xe5 },
	'cameraroll' => { 111 => 0xb, 363 => "\xa9grl" },
	'cameraserialnumber' => { 115 => 0xc62f, 171 => 'CameraSerialNumber', 446 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 280 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 74 => 0xc, 133 => 0x406, 284 => 0x1306, 298 => 0x320, 305 => 0x3402, 338 => 0x47, 377 => 0x43, 425 => 0x5 },
	'cameratemperature4' => { 343 => 0x14 },
	'cameratemperature5' => { 343 => 0x16 },
	'cameratemperaturerangemax' => { 117 => 0x5 },
	'cameratemperaturerangemin' => { 117 => 0x6 },
	'cameratype' => { 74 => 0x1a, 285 => 0x207 },
	'cameratype2' => { 281 => 0x100 },
	'camerayaw' => { 111 => 0xa, 363 => "\xa9gyw" },
	'camreverse' => { 112 => 'CamReverse' },
	'canondr4' => { 116 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 93 => 0x805 },
	'canonfilelength' => { 61 => 0xe },
	'canonfirmwareversion' => { 61 => 0x7, 93 => 0x80b },
	'canonflashinfo' => { 93 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 61 => 0x6, 93 => 0x815 },
	'canonmodelid' => { 61 => 0x10, 93 => 0x1834 },
	'canonvrd' => { 116 => 'CanonVRD' },
	'caption' => { 451 => 'caption' },
	'caption-abstract' => { 127 => 0x78 },
	'captionsauthornames' => { 461 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 461 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 470 => 'CaptionWriter' },
	'captureframerate' => { 109 => 0x4001 },
	'captureheightnormal' => { 133 => 0x1839 },
	'capturelook' => { 133 => 0xc48 },
	'capturemode' => { 357 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 444 => 'CaptureSoftware' },
	'capturewidthnormal' => { 133 => 0x1838 },
	'capturewidthtest' => { 133 => 0x1842 },
	'cardshutterlock' => { 176 => 0x49 },
	'casioimagesize' => { 109 => 0x9 },
	'catalogsets' => { 127 => 0xff, 437 => 'CatalogSets', 449 => 'CatalogSets' },
	'categories' => { 61 => 0x23, 451 => 'categories' },
	'category' => { 127 => 0xf, 279 => 0x30, 355 => 'catg', 470 => 'Category' },
	'cbcrgain' => { 377 => 0xa036 },
	'cbcrgaindefault' => { 377 => 0xa035 },
	'cbcrmatrix' => { 377 => 0xa034 },
	'cbcrmatrixdefault' => { 377 => 0xa033 },
	'ccdboardversion' => { 298 => 0x331 },
	'ccdscanmode' => { 285 => 0x1039 },
	'ccdsensitivity' => { 246 => 0x6 },
	'ccdversion' => { 298 => 0x330 },
	'cellglobalid' => { 455 => 'cgi' },
	'celllength' => { 115 => 0x109 },
	'cellr' => { 455 => 'r' },
	'celltowerid' => { 455 => 'cellid' },
	'cellwidth' => { 115 => 0x108 },
	'centerafarea' => { 274 => '15.1' },
	'centerfocuspoint' => { 278 => '2.2' },
	'centerpixel' => { 133 => 0x40c },
	'centerweightedareasize' => { 263 => '7.1', 264 => '8.1', 266 => '8.1', 267 => '8.1', 271 => '7.1', 272 => '5.1', 273 => '7.1', 274 => '6.3', 276 => '8.1', 277 => '8.1', 278 => '8.1' },
	'certificate' => { 486 => 'Certificate' },
	'cfainterpolationalgorithm' => { 133 => 0xe60 },
	'cfainterpolationmetric' => { 133 => 0xe61 },
	'cfaoffsetcols' => { 133 => 0xc71 },
	'cfaoffsetrows' => { 133 => 0xc6f },
	'cfapattern' => { 115 => 0xa302, 308 => 0x9, 462 => 'CFAPattern' },
	'cfapattern2' => { 115 => 0x828e },
	'cfapatterncolumns' => { 462 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 462 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 462 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 115 => 0x828d },
	'cfazipperfixthreshold' => { 133 => 0xe62 },
	'channel' => { 472 => 'channel' },
	'channela-lang' => { 472 => [\'channel','channelA-lang'] },
	'channelchannel' => { 472 => [\'channel','channelChannel'] },
	'channels' => { 148 => 'Channels' },
	'channelsubchannel1' => { 472 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 472 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 472 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 472 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 363 => 'chpl' },
	'checkmark' => { 99 => 0x10101, 104 => 0x26a },
	'checkmark2' => { 105 => 0x8e },
	'childfontfiles' => { 487 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 263 => '10.3', 264 => '11.2' },
	'chromablurradius' => { 115 => 0xc631 },
	'chromanoisecolorspace' => { 133 => 0xe6d },
	'chromanoiseedgemapthresh' => { 133 => 0xe6c },
	'chromanoisehighfthresh' => { 133 => 0xe6a },
	'chromanoiselowfthresh' => { 133 => 0xe6b },
	'chromaticaberration' => { 99 => 0x20703, 105 => 0x66, 377 => 0xa051 },
	'chromaticaberrationb' => { 456 => 'ChromaticAberrationB', 458 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 99 => 0x20708, 105 => 0x6b },
	'chromaticaberrationcorr' => { 76 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 115 => 0x7034, 328 => 0x1, 434 => 0x900d },
	'chromaticaberrationcorrparams' => { 115 => 0x7035, 429 => 0x66a, 430 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 99 => '0x20703.0', 105 => 0x62 },
	'chromaticaberrationr' => { 456 => 'ChromaticAberrationR', 458 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 99 => 0x20707, 105 => 0x6a },
	'chromaticaberrationsetting' => { 77 => 0x6 },
	'chrominancenoisereduction' => { 99 => 0x20601, 105 => 0x5e, 380 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 105 => 0x60 },
	'circadatecreated' => { 468 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 458 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 456 => 'CircularGradientBasedCorrections', 458 => 'CircularGradientBasedCorrections' },
	'city' => { 127 => 0x5a, 154 => 'City', 303 => 0x6d, 470 => 'City' },
	'city2' => { 303 => 0x80 },
	'clarity' => { 219 => 0x35, 220 => 0x3d, 456 => 'Clarity', 458 => 'Clarity' },
	'clarity2012' => { 456 => 'Clarity2012', 458 => 'Clarity2012' },
	'claritycontrol' => { 338 => 0x96 },
	'classifystate' => { 127 => 0xe1 },
	'clearretouch' => { 303 => 0x7c },
	'clearretouchvalue' => { 303 => 0xa3 },
	'client' => { 482 => 'client' },
	'clientname' => { 464 => 'ClientName' },
	'clipfilename' => { 363 => 'clfn' },
	'clipid' => { 363 => 'clid' },
	'clmodeshootingspeed' => { 263 => '10.2', 264 => '11.3', 266 => '11.2', 267 => '11.2', 272 => '11.2', 273 => '10.2', 276 => '11.2', 277 => '11.2', 278 => '11.1' },
	'cmcontrast' => { 288 => 0x2022 },
	'cmexposurecompensation' => { 288 => 0x2000 },
	'cmhue' => { 288 => 0x2021 },
	'cmsaturation' => { 288 => 0x2020 },
	'cmsharpness' => { 288 => 0x2023 },
	'cmwhitebalance' => { 288 => 0x2001 },
	'cmwhitebalancecomp' => { 288 => 0x2002 },
	'cmwhitebalancegraypoint' => { 288 => 0x2010 },
	'codec' => { 162 => 'Codec' },
	'codedcharacterset' => { 128 => 0x5a },
	'codeversion' => { 363 => 'cver' },
	'collection' => { 293 => 'Collection' },
	'collectionname' => { 163 => [\'Collections','CollectionsCollectionName'], 363 => 'coll' },
	'collections' => { 163 => 'Collections', 451 => 'collections' },
	'collectionuri' => { 163 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 357 => 'player.movie.visual.color', 471 => 'color' },
	'coloraberrationcontrol' => { 256 => 0xc89224b },
	'coloradjustment' => { 380 => 0x14 },
	'coloradjustmentmode' => { 379 => 0x210 },
	'coloranta' => { 487 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 487 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 487 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 487 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 487 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 487 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 487 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 487 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 487 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 487 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 487 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 487 => 'Colorants' },
	'colorantswatchname' => { 487 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 487 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 487 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 487 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 149 => 'ColorBalance' },
	'colorbalanceadj' => { 256 => 0x76a43202 },
	'colorbalanceblue' => { 173 => 0x1e },
	'colorbalancegreen' => { 173 => 0x1d },
	'colorbalancered' => { 173 => 0x1c },
	'colorbalanceversion' => { 194 => 0x4, 195 => 0x4, 196 => 0x0 },
	'colorblur' => { 105 => 0x65 },
	'colorbluron' => { 99 => 0x20704 },
	'colorbooster' => { 256 => 0x5f0e7d23 },
	'colorboostlevel' => { 250 => 0x1 },
	'colorboosttype' => { 250 => 0x0 },
	'colorchromeeffect' => { 123 => 0x1048 },
	'colorclass' => { 349 => 0xde, 350 => 'ColorClass' },
	'colorcompensationfilter' => { 176 => [0x3a,0x5f], 178 => 0x111, 401 => 0xb022 },
	'colorcompensationfiltercustom' => { 388 => 0xd, 389 => 0xc },
	'colorcompensationfilterset' => { 388 => 0x8, 389 => 0x7, 390 => 0x18, 406 => 0xf },
	'colorcontrol' => { 285 => 0x102b },
	'colorcorrection' => { 434 => 0x8015 },
	'colorcreatoreffect' => { 280 => 0x532 },
	'colordataversion' => { 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0 },
	'coloreffect' => { 303 => 0x28 },
	'colorfilter' => { 108 => 0x17, 109 => 0x3017, 173 => 0x29, 181 => [0x38,0x4d,0x4f], 345 => 0x17 },
	'colorgain' => { 224 => 0x51 },
	'colorhue' => { 99 => 0x20900, 216 => 0x8d },
	'colorimetricreference' => { 115 => 0xc6bf },
	'colorlabel' => { 461 => 'ColorLabel' },
	'colormatrix' => { 284 => 0x200, 285 => 0x1011, 377 => 0xa030 },
	'colormatrix1' => { 115 => 0xc621, 347 => 0x106 },
	'colormatrix2' => { 115 => 0xc622, 288 => 0x200, 347 => 0x226 },
	'colormatrixa' => { 338 => 0x203 },
	'colormatrixadobergb' => { 377 => 0xa032 },
	'colormatrixb' => { 338 => 0x204 },
	'colormatrixnumber' => { 285 => 0x1019 },
	'colormatrixsrgb' => { 377 => 0xa031 },
	'colormode' => { 109 => 0x3015, 123 => 0x1210, 135 => 0x66, 173 => 0x28, 176 => 0x16, 178 => 0x101, 179 => 0x36, 181 => 0x7, 216 => 0x3, 246 => 0x4, 303 => 0x32, 380 => 0x2c, 401 => 0xb029, 470 => 'ColorMode' },
	'colormoirereduction' => { 99 => 0x20670, 257 => 0x15 },
	'colormoirereductionmode' => { 257 => 0x5 },
	'colormoirereductionon' => { 99 => '0x20670.0' },
	'colornoisereduction' => { 434 => 0x8029, 456 => 'ColorNoiseReduction', 458 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 456 => 'ColorNoiseReductionDetail', 458 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 257 => 0x18 },
	'colornoisereductionsharpness' => { 257 => 0x1c },
	'colornoisereductionsmoothness' => { 456 => 'ColorNoiseReductionSmoothness', 458 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 119 => 0x2 },
	'colorprofile' => { 173 => 0x33 },
	'colorprofilesettings' => { 280 => 0x539 },
	'colorrepresentation' => { 129 => 0x3c },
	'colorsaturationadj' => { 99 => 0x20305 },
	'colorsequence' => { 129 => 0x41 },
	'colorspace' => { 49 => 0x3, 61 => 0xb4, 93 => 0x10b4, 115 => 0xa001, 155 => 'ColorSpace', 174 => 0x2f, 175 => 0x25, 176 => 0x17, 216 => 0x1e, 280 => 0x507, 338 => 0x37, 377 => 0xa011, 380 => 0xb, 388 => 0x1b, 389 => 0x83, 390 => 0xe, 406 => 0x6, 462 => 'ColorSpace' },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x26, 42 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x43, 48 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x1c, 42 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x48, 48 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0x35, 42 => 0x5c, 45 => 0x75, 46 => 0x8e, 47 => 0x93, 48 => 0x96, 338 => 0x55 },
	'colortempcustom' => { 42 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x2b, 42 => 0x52, 45 => 0x6b, 46 => 0x84, 47 => 0x89, 48 => 0x8c, 338 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 61 => 0xae, 71 => 0x9, 93 => 0x10ae, 123 => 0x1005, 133 => 0x846, 149 => 'ColorTemperature', 174 => [0x6e,0x49], 175 => 0x3f, 176 => [0x39,0x5e], 178 => 0x10b, 181 => [0x3c,0x4c,0x4e], 298 => 0x321, 338 => 0x50, 370 => 0x1308, 401 => 0xb021, 456 => 'Temperature', 458 => 'Temperature' },
	'colortemperatureadj' => { 434 => 0x8013 },
	'colortemperatureauto' => { 216 => 0x4f },
	'colortemperaturebg' => { 285 => 0x1013 },
	'colortemperaturecustom' => { 388 => 0xc, 389 => 0xb },
	'colortemperaturerg' => { 285 => 0x1014 },
	'colortemperatureset' => { 388 => 0x7, 389 => 0x6 },
	'colortemperaturesetting' => { 176 => 0x25, 390 => 0x17, 406 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0x49, 42 => 0x70, 45 => 0x89, 46 => 0xa2, 47 => 0xa7, 48 => 0xaa, 338 => 0x5a },
	'colortempflashdata' => { 42 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0x3f, 42 => 0x66, 45 => 0x7f, 46 => 0x98, 47 => 0x9d, 48 => 0xa0 },
	'colortempfluorescentd' => { 338 => 0x57 },
	'colortempfluorescentn' => { 338 => 0x58 },
	'colortempfluorescentw' => { 338 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0x44, 42 => 0x6b, 45 => 0x84, 46 => 0x9d, 47 => 0xa2, 48 => 0xa5, 303 => 0x44, 370 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 42 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x4d, 48 => 0x55 },
	'colortemppc1' => { 41 => 0x94, 42 => 0x75 },
	'colortemppc2' => { 41 => 0x99, 42 => 0x7a },
	'colortemppc3' => { 41 => 0x9e, 42 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x30, 42 => 0x57, 45 => 0x70, 46 => 0x89, 47 => 0x8e, 48 => 0x91, 338 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0x3a, 42 => 0x61, 45 => 0x7a, 46 => 0x93, 47 => 0x98, 48 => 0x9b, 338 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x21, 45 => 0x52, 46 => 0x52, 47 => 0x52, 48 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x76, 45 => 0xa2, 46 => 0x7f, 47 => 0x7f, 48 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0x7b, 45 => 0xa7, 46 => 0xa7, 47 => 0x84, 48 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0x80, 45 => 0xac, 46 => 0xac, 47 => 0xac, 48 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0x85, 45 => 0xb1, 46 => 0xb1, 47 => 0xb1, 48 => 0xb9 },
	'colortempunknown14' => { 41 => 0x8a, 45 => 0xb6, 46 => 0xb6, 47 => 0xb6, 48 => 0xbe },
	'colortempunknown15' => { 41 => 0x8f, 45 => 0xbb, 46 => 0xbb, 47 => 0xbb, 48 => 0xc3 },
	'colortempunknown16' => { 41 => 0xa3, 46 => 0xc0, 47 => 0xc0, 48 => 0xc8 },
	'colortempunknown17' => { 46 => 0xc5, 47 => 0xc5, 48 => 0xcd },
	'colortempunknown18' => { 46 => 0xca, 47 => 0xca, 48 => 0xd2 },
	'colortempunknown19' => { 46 => 0xcf, 47 => 0xcf, 48 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x4e, 45 => 0x57, 46 => 0x57, 47 => 0x57, 48 => 0x5f },
	'colortempunknown20' => { 46 => 0xd4, 47 => 0xd4, 48 => 0xdc },
	'colortempunknown21' => { 47 => 0xd9, 48 => 0xe1 },
	'colortempunknown22' => { 47 => 0xde, 48 => 0xe6 },
	'colortempunknown23' => { 47 => 0xe3, 48 => 0xeb },
	'colortempunknown24' => { 47 => 0xe8, 48 => 0xf0 },
	'colortempunknown25' => { 47 => 0xed, 48 => 0xf5 },
	'colortempunknown26' => { 47 => 0xf2, 48 => 0xfa },
	'colortempunknown27' => { 47 => 0xf7, 48 => 0xff },
	'colortempunknown28' => { 47 => 0xfc, 48 => 0x104 },
	'colortempunknown29' => { 47 => 0x101, 48 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x53, 45 => 0x5c, 46 => 0x5c, 47 => 0x5c, 48 => 0x64 },
	'colortempunknown30' => { 47 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x58, 45 => 0x61, 46 => 0x61, 47 => 0x61, 48 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x5d, 45 => 0x66, 46 => 0x66, 47 => 0x66, 48 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x62, 45 => 0x8e, 46 => 0x6b, 47 => 0x6b, 48 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x67, 45 => 0x93, 46 => 0x70, 47 => 0x70, 48 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x6c, 45 => 0x98, 46 => 0x75, 47 => 0x75, 48 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x71, 45 => 0x9d, 46 => 0x7a, 47 => 0x7a, 48 => 0x82 },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 49 => 0x2 },
	'colortoneadj' => { 99 => 0x20304, 104 => 0x11e },
	'colortoneauto' => { 68 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 67 => 0x6c, 68 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 67 => 0x3c, 68 => 0x3c },
	'colortonemonochrome' => { 67 => 0x84, 68 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 67 => 0x54, 68 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 67 => 0x24, 68 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 67 => 0xc, 68 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 67 => 0x9c, 68 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 67 => 0xb4, 68 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 67 => 0xcc, 68 => 0xe4 },
	'comlenblksize' => { 133 => 0xfde8 },
	'commanddials' => { 274 => '5.1' },
	'commanddialsaperturesetting' => { 263 => '17.3', 264 => '18.3', 266 => '18.3', 267 => '18.3', 272 => '33.3', 273 => '17.3', 276 => '18.3', 277 => '18.3' },
	'commanddialschangemainsub' => { 263 => '17.2', 264 => '18.1', 266 => '18.1', 267 => '18.1', 272 => '33.2', 273 => '17.2', 276 => '18.1', 277 => '18.1' },
	'commanddialsmenuandplayback' => { 263 => '17.4', 264 => '18.2', 266 => '18.2', 267 => '18.2', 272 => '33.4', 273 => '17.4', 276 => '18.2', 277 => '18.2' },
	'commanddialsreverserotation' => { 263 => '17.1', 264 => '6.4', 266 => '6.2', 267 => '6.2', 268 => '16.2', 269 => '17.2', 272 => '33.1', 273 => '17.1', 276 => '6.2', 277 => '6.2', 278 => '18.1' },
	'commanderchannel' => { 274 => '10.2', 275 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 274 => '13.1', 275 => '31.1' },
	'commandergroupa_ttlcomp' => { 278 => '32.1' },
	'commandergroupamanualoutput' => { 274 => '13.2', 275 => '28.2' },
	'commandergroupamode' => { 274 => '11.2', 275 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 274 => '14.1', 275 => '32.1' },
	'commandergroupb_ttlcomp' => { 278 => '33.1' },
	'commandergroupbmanualoutput' => { 274 => '14.2', 275 => '29.2' },
	'commandergroupbmode' => { 274 => '11.3', 275 => '29.1' },
	'commanderinternalflash' => { 274 => '11.1', 275 => '27.1' },
	'commanderinternalmanualoutput' => { 274 => '12.2', 275 => '27.2' },
	'commanderinternalttlchannel' => { 272 => '18.2' },
	'commanderinternalttlcomp' => { 274 => '12.1', 275 => '30.2', 278 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 272 => '20.1', 273 => '26.1' },
	'commanderinternalttlcompgroupa' => { 272 => '21.1', 273 => '27.1' },
	'commanderinternalttlcompgroupb' => { 272 => '22.1', 273 => '28.1' },
	'comment' => { 0 => 0x2, 116 => 'Comment', 150 => 'Comment', 293 => 'Comment', 355 => "\xa9cmt", 357 => 'comment', 363 => "\xa9cmt" },
	'compass' => { 373 => 0x4 },
	'compilation' => { 355 => 'cpil' },
	'complianceprofile' => { 472 => 'complianceProfile' },
	'componentsconfiguration' => { 115 => 0x9101, 155 => 'Components', 462 => 'ComponentsConfiguration' },
	'componentversion' => { 93 => 0x80c },
	'composer' => { 355 => ["\xa9com","\xa9wrt"], 363 => ["\xa9com","\xa9wrt"], 482 => 'composer' },
	'composerkeywords' => { 363 => "\xa9cok" },
	'compositeimage' => { 115 => 0xa460 },
	'compositeimagecount' => { 115 => 0xa461 },
	'compositeimageexposuretimes' => { 115 => 0xa462 },
	'composition' => { 446 => 'Composition' },
	'compositionadjust' => { 337 => '0.1' },
	'compositionadjustrotation' => { 337 => 0x7 },
	'compositionadjustx' => { 337 => 0x5 },
	'compositionadjusty' => { 337 => 0x6 },
	'compressedbitsperpixel' => { 115 => 0x9102, 462 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 178 => 0x40, 285 => 0x40 },
	'compression' => { 115 => 0x103, 308 => 0xb, 478 => 'Compression' },
	'compressionfactor' => { 280 => 0x50d },
	'compressionratio' => { 155 => 'Compression', 285 => 0x1034 },
	'compressorversion' => { 363 => 'CNCV' },
	'condadobvfactor' => { 133 => 0xf3e },
	'condadodaybvthresh' => { 133 => 0xf3c },
	'condadodayoffsets' => { 133 => 0xf42 },
	'condadofluoffsets' => { 133 => 0xf44 },
	'condadofluthresh' => { 133 => 0xf41 },
	'condadoillfactor' => { 133 => 0xf3f },
	'condadoneurange' => { 133 => 0xf3d },
	'condadotunoffsets' => { 133 => 0xf43 },
	'condadotunthresh' => { 133 => 0xf40 },
	'confidence' => { 441 => 'Confidence' },
	'confidencelevel' => { 452 => 'ConfidenceLevel' },
	'confidencemime' => { 441 => 'ConfidenceMime' },
	'constrainedcropheight' => { 104 => 0x266, 349 => 0xd6 },
	'constrainedcropwidth' => { 104 => 0x262, 349 => 0xd5 },
	'contact' => { 127 => 0x76 },
	'contactinfo' => { 471 => 'contactInfo' },
	'containerformat' => { 468 => 'ContainerFormat' },
	'containerformatidentifier' => { 468 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 468 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 355 => "\xa9day", 363 => "\xa9day" },
	'contentdistributorid' => { 363 => 'cdis' },
	'contentid' => { 363 => 'ccid' },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 127 => 0x1a },
	'contentlocationname' => { 127 => 0x1b },
	'contenttype' => { 472 => 'contentType' },
	'continuousbracketing' => { 176 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodeliveview' => { 277 => '77.2' },
	'continuousshootingspeed' => { 80 => 0x610 },
	'continuousshotlimit' => { 80 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 108 => 0xc, 109 => [0x3012,0x20], 115 => [0xa408,0xfe54], 123 => [0x1004,0x1006], 149 => 'Contrast', 169 => 'Contrast', 173 => 0x20, 174 => 0x31, 175 => 0x27, 176 => 0x19, 181 => 0x2, 218 => 0x33, 219 => 0x37, 220 => 0x3f, 285 => 0x1029, 303 => 0x39, 305 => 0x300a, 338 => 0x20, 345 => 0xc, 357 => 'player.movie.visual.contrast', 364 => 0x24, 366 => 0x52, 370 => 0x1012, 380 => 0xd, 388 => 0x1d, 389 => 0x1a, 401 => 0x2004, 456 => 'Contrast', 458 => 'Contrast', 462 => 'Contrast' },
	'contrast2012' => { 456 => 'Contrast2012', 458 => 'Contrast2012' },
	'contrastadj' => { 99 => 0x20303, 104 => 0x115, 259 => 0x2c, 434 => 0x8017 },
	'contrastauto' => { 68 => 0x90 },
	'contrastcurve' => { 216 => 0x8c },
	'contrastdetectaf' => { 185 => 0x4 },
	'contrastdetectafarea' => { 338 => 0x231 },
	'contrastdetectafinfocus' => { 185 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 67 => 0x60, 68 => 0x60 },
	'contrasthighlight' => { 338 => 0x6d },
	'contrasthighlightshadowadj' => { 338 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 67 => 0x30, 68 => 0x30 },
	'contrastmode' => { 303 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 67 => 0x78, 68 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 67 => 0x48, 68 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 67 => 0x18, 68 => 0x18 },
	'contrastsetting' => { 280 => 0x505, 288 => 0x1012, 390 => 0x10, 406 => 0x8 },
	'contrastshadow' => { 338 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 67 => 0x0, 68 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 67 => 0x90, 68 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 67 => 0xa8, 68 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 67 => 0xc0, 68 => 0xd8 },
	'contributedmedia' => { 482 => 'contributedMedia' },
	'contributedmediaduration' => { 482 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 482 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 482 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 482 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 482 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 482 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 482 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 482 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 482 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 482 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 459 => 'contributor', 468 => 'Contributor' },
	'contributoridentifier' => { 468 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 468 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 468 => [\'Contributor','ContributorRole'] },
	'contributors' => { 150 => 'Contributors' },
	'controldialset' => { 176 => 0x46 },
	'controlledvocabularyterm' => { 468 => 'CVterm' },
	'controllerboardversion' => { 298 => 0x332 },
	'controlmode' => { 74 => 0x12 },
	'controlringrotation' => { 80 => 0x712 },
	'conversionlens' => { 281 => 0x403, 303 => 0x35 },
	'converter' => { 115 => 0xfe4d, 246 => 0xb, 456 => 'Converter', 458 => 'Converter' },
	'converttograyscale' => { 456 => 'ConvertToGrayscale', 458 => 'ConvertToGrayscale' },
	'cookingequipment' => { 474 => 'cookingEquipment' },
	'cookingmethod' => { 474 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 115 => 0x8298, 150 => 'Copyright', 293 => 'Copyright', 338 => 0x22f, 354 => 'Copyright', 355 => ['cprt',"\xa9cpy"], 357 => 'copyright', 363 => ['cprt',"\xa9cpy"], 469 => 'Copyright', 475 => 'copyright', 478 => 'Copyright', 482 => 'copyright' },
	'copyrightflag' => { 352 => 0x40a },
	'copyrightnotice' => { 127 => 0x74 },
	'copyrightowner' => { 290 => 'CopyrightOwner' },
	'copyrightownerid' => { 290 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 290 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 290 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 290 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 290 => 'CopyrightStatus' },
	'copyrightyear' => { 468 => 'CopyrightYear', 472 => 'copyrightYear' },
	'coringfilter' => { 284 => 0x310, 285 => 0x102d, 288 => 0x310 },
	'coringvalues' => { 284 => 0x311, 288 => 0x311 },
	'corporateentity' => { 472 => 'corporateEntity' },
	'country' => { 154 => 'Country', 303 => 0x69, 470 => 'Country' },
	'country-primarylocationcode' => { 127 => 0x64 },
	'country-primarylocationname' => { 127 => 0x65 },
	'countrycode' => { 215 => 0x5, 350 => 'CountryCode', 467 => 'CountryCode' },
	'course' => { 474 => 'course' },
	'coverage' => { 459 => 'coverage' },
	'coverart' => { 355 => 'covr' },
	'coverdate' => { 472 => 'coverDate' },
	'coverdisplaydate' => { 472 => 'coverDisplayDate' },
	'coveruri' => { 363 => 'cvru' },
	'cpufirmwareversion' => { 338 => 0x28 },
	'crc32' => { 460 => 'crc32' },
	'createdate' => { 115 => 0x9004, 150 => 'CreateDate', 289 => 'CreationDate', 293 => 'create-date', 354 => 'CreationDate', 360 => 0x1, 480 => 'CreateDate' },
	'creationdate' => { 357 => 'creationdate', 469 => 'CreationDate', 472 => 'creationDate' },
	'creationtime' => { 293 => 'Creation Time' },
	'creativestyle' => { 388 => 0x1a, 389 => 0x18, 399 => 0x41, 401 => 0xb020, 430 => 0x4a },
	'creativestylesetting' => { 390 => 0xf, 406 => 0x7 },
	'creativestylewaschanged' => { 434 => 0x8001 },
	'creator' => { 289 => 'Creator', 354 => 'Creator', 459 => 'creator', 468 => 'Creator', 469 => 'Creator' },
	'creatoraddress' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 171 => 'CreatorAppId' },
	'creatorcity' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 467 => 'CreatorContactInfo' },
	'creatorcountry' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 468 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 468 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 171 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 468 => [\'Creator','CreatorRole'] },
	'creatortool' => { 480 => 'CreatorTool' },
	'creatorworkemail' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 467 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 127 => 0x6e, 470 => 'Credit' },
	'creditline' => { 475 => 'creditLine' },
	'creditlinereq' => { 485 => 'CreditLineReq' },
	'creditlinerequired' => { 290 => 'CreditLineRequired' },
	'cropactive' => { 97 => 0x0, 104 => 0x244 },
	'cropangle' => { 456 => 'CropAngle', 458 => 'CropAngle' },
	'croparea' => { 216 => 0x45, 434 => 0x9011 },
	'cropaspectratio' => { 99 => 0x30101, 104 => 0x260 },
	'cropaspectratiocustom' => { 99 => 0x30102 },
	'cropbottom' => { 119 => 0x9, 251 => 0x36, 308 => 0x31, 349 => 0xdc, 456 => 'CropBottom', 458 => 'CropBottom' },
	'cropbottommargin' => { 51 => 0x3 },
	'cropcircleactive' => { 105 => 0xd6 },
	'cropcircleradius' => { 105 => 0xd9 },
	'cropcirclex' => { 105 => 0xd7 },
	'cropcircley' => { 105 => 0xd8 },
	'cropconstraintowarp' => { 456 => 'CropConstrainToWarp', 458 => 'CropConstrainToWarp' },
	'croph' => { 450 => 'CropH' },
	'cropheight' => { 97 => 0x6, 104 => 0x24c, 284 => 0x615, 288 => 0x615, 456 => 'CropHeight', 458 => 'CropHeight' },
	'crophispeed' => { 216 => 0x1b },
	'cropleft' => { 104 => 0x246, 119 => 0x6, 251 => 0x1e, 284 => 0x612, 288 => 0x612, 308 => 0x30, 349 => 0xd9, 456 => 'CropLeft', 458 => 'CropLeft' },
	'cropleftmargin' => { 51 => 0x0 },
	'cropmode' => { 123 => 0x104d, 370 => 0x1018 },
	'croporiginalheight' => { 97 => 0xb },
	'croporiginalwidth' => { 97 => 0xa },
	'cropoutputheight' => { 251 => 0xce },
	'cropoutputheightinches' => { 251 => 0x96 },
	'cropoutputpixels' => { 251 => 0xd6 },
	'cropoutputresolution' => { 251 => 0xb6 },
	'cropoutputscale' => { 251 => 0xbe },
	'cropoutputwidth' => { 251 => 0xc6 },
	'cropoutputwidthinches' => { 251 => 0x8e },
	'croppedareaimageheightpixels' => { 444 => 'CroppedAreaImageHeightPixels', 445 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 444 => 'CroppedAreaImageWidthPixels', 445 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 444 => 'CroppedAreaLeftPixels', 445 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 444 => 'CroppedAreaTopPixels', 445 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 370 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 370 => 0x1603 },
	'cropping' => { 434 => 0x9010 },
	'cropright' => { 119 => 0x8, 251 => 0x2e, 308 => 0x32, 349 => 0xdb, 456 => 'CropRight', 458 => 'CropRight' },
	'croprightmargin' => { 51 => 0x1 },
	'croprotatedoriginalheight' => { 97 => 0x2 },
	'croprotatedoriginalwidth' => { 97 => 0x1 },
	'croprotation' => { 97 => 0x8, 119 => 0xb },
	'cropscaledresolution' => { 251 => 0x9e },
	'cropsourceresolution' => { 251 => 0xae },
	'croptop' => { 104 => 0x248, 119 => 0x7, 251 => 0x26, 284 => 0x613, 288 => 0x613, 308 => 0x2f, 349 => 0xda, 456 => 'CropTop', 458 => 'CropTop' },
	'croptopmargin' => { 51 => 0x2 },
	'cropunit' => { 456 => 'CropUnit', 458 => 'CropUnit' },
	'cropunits' => { 456 => 'CropUnits', 458 => 'CropUnits' },
	'cropw' => { 450 => 'CropW' },
	'cropwidth' => { 97 => 0x5, 104 => 0x24a, 284 => 0x614, 288 => 0x614, 456 => 'CropWidth', 458 => 'CropWidth' },
	'cropx' => { 97 => 0x3, 450 => 'CropX' },
	'cropy' => { 97 => 0x4, 450 => 'CropY' },
	'crossprocess' => { 338 => 0x7b },
	'crossprocessparams' => { 338 => 0x235 },
	'cuisine' => { 474 => 'cuisine' },
	'currenticcprofile' => { 115 => 0xc691 },
	'currentpreprofilematrix' => { 115 => 0xc692 },
	'currentversion' => { 434 => 0xd000 },
	'curve0x' => { 450 => 'Curve0x' },
	'curve0y' => { 450 => 'Curve0y' },
	'curve1x' => { 450 => 'Curve1x' },
	'curve1y' => { 450 => 'Curve1y' },
	'curve2x' => { 450 => 'Curve2x' },
	'curve2y' => { 450 => 'Curve2y' },
	'curve3x' => { 450 => 'Curve3x' },
	'curve3y' => { 450 => 'Curve3y' },
	'curve4x' => { 450 => 'Curve4x' },
	'curve4y' => { 450 => 'Curve4y' },
	'curves' => { 256 => 0x76a43201 },
	'custom1' => { 290 => 'Custom1' },
	'custom10' => { 290 => 'Custom10' },
	'custom2' => { 290 => 'Custom2' },
	'custom3' => { 290 => 'Custom3' },
	'custom4' => { 290 => 'Custom4' },
	'custom5' => { 290 => 'Custom5' },
	'custom6' => { 290 => 'Custom6' },
	'custom7' => { 290 => 'Custom7' },
	'custom8' => { 290 => 'Custom8' },
	'custom9' => { 290 => 'Custom9' },
	'customcolortone' => { 105 => 0x4c },
	'customcontrast' => { 105 => 0x4e },
	'customcontrols' => { 80 => 0x70c },
	'customdefaultunsharpfineness' => { 105 => 0xbe },
	'customdefaultunsharpstrength' => { 105 => 0xbc },
	'customdefaultunsharpthreshold' => { 105 => 0xc0 },
	'customilluminant' => { 133 => 0x405 },
	'customizedials' => { 80 => 0x715 },
	'customlinear' => { 105 => 0x4f },
	'customoutputhighlightpoint' => { 105 => 0x53 },
	'customoutputshadowpoint' => { 105 => 0x54 },
	'custompicturestyle' => { 99 => 0x10021 },
	'custompicturestyledata' => { 99 => 0xf0500 },
	'custompicturestylefilename' => { 61 => 0x4010 },
	'customrawhighlight' => { 105 => 0x7c },
	'customrawhighlightpoint' => { 105 => 0x51 },
	'customrawshadow' => { 105 => 0x85 },
	'customrawshadowpoint' => { 105 => 0x52 },
	'customrendered' => { 115 => 0xa401, 462 => 'CustomRendered' },
	'customsaturation' => { 105 => 0x4d, 280 => 0x503 },
	'customsettingsalldefault' => { 263 => '0.2', 272 => '0.2' },
	'customsettingsbank' => { 263 => '0.1', 264 => '0.1', 266 => '0.1', 267 => '0.1', 272 => '0.1', 276 => '0.2', 277 => '0.2' },
	'customsharpness' => { 105 => 0x50 },
	'customunsharpmaskfineness' => { 105 => 0xb8 },
	'customunsharpmaskstrength' => { 105 => 0xb6 },
	'customunsharpmaskthreshold' => { 105 => 0xba },
	'customwb_rblevels' => { 406 => 0x1a },
	'customwb_rgblevels' => { 389 => 0x8, 390 => 0x19 },
	'customwbbluelevel' => { 176 => 0x36 },
	'customwberror' => { 176 => 0x37 },
	'customwbgreenlevel' => { 176 => 0x35 },
	'customwbredlevel' => { 176 => 0x34 },
	'customwbsetting' => { 176 => 0x26 },
	'cx' => { 363 => '_cx_' },
	'cy' => { 363 => '_cy_' },
	'd-lightinghq' => { 256 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 252 => 0x2 },
	'd-lightinghqhighlight' => { 252 => 0x1 },
	'd-lightinghqselected' => { 256 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 252 => 0x0 },
	'd-lightinghs' => { 256 => 0xce5554aa },
	'd-lightinghsadjustment' => { 253 => 0x0 },
	'd-lightinghscolorboost' => { 253 => 0x1 },
	'd-rangeoptimizerhighlight' => { 434 => 0x8024 },
	'd-rangeoptimizermode' => { 434 => 0x8022 },
	'd-rangeoptimizershadow' => { 434 => 0x802d },
	'd-rangeoptimizervalue' => { 434 => 0x8023 },
	'darkblacksegrows' => { 133 => 0x18d8 },
	'darkfocusenvironment' => { 303 => 0x8003 },
	'darkframecountfactor' => { 133 => 0xc85 },
	'darkframelongexposure' => { 133 => 0xc84 },
	'darkframeshortexposure' => { 133 => 0xc83 },
	'darkpedestal' => { 133 => 0xc7f },
	'datacompressionmethod' => { 129 => 0x6e },
	'dataimprint' => { 173 => 0x34 },
	'dataonscreen' => { 468 => 'DataOnScreen' },
	'dataonscreenregion' => { 468 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 468 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 468 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 468 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 468 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 468 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 468 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 468 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 338 => 0x3d },
	'date' => { 338 => 0x6, 459 => 'date' },
	'dateacquired' => { 171 => 'DateAcquired' },
	'datecreated' => { 127 => 0x37, 470 => 'DateCreated' },
	'datedisplayformat' => { 248 => 0x3 },
	'dateidentified' => { 114 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 268 => '4.2' },
	'daterecieved' => { 472 => 'dateRecieved' },
	'datesent' => { 128 => 0x46 },
	'datestampmode' => { 61 => 0x1c, 216 => 0x9d },
	'datetime' => { 451 => 'datetime', 478 => 'DateTime' },
	'datetimedigitized' => { 462 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 96 => 0x0, 115 => 0x9003, 147 => 0x14, 150 => 'OriginalDate', 358 => 'IDIT', 363 => 'date', 364 => 0xb, 365 => 0x3b, 366 => 0x3e, 462 => 'DateTimeOriginal' },
	'datetimestamp' => { 135 => 0x64 },
	'datetimeutc' => { 280 => 0x908 },
	'daylightsavings' => { 75 => 0x3, 248 => 0x2 },
	'dayofweek' => { 365 => 0x42, 366 => 0x4a },
	'dccontinent' => { 114 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 114 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 114 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 114 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 114 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 114 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 114 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 114 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 114 => 'Event' },
	'dcfootprintspatialfit' => { 114 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 114 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 114 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 114 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 114 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 114 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 114 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 114 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 114 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 114 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 114 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 114 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 114 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 114 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 114 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 114 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 114 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 114 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 114 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 114 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 158 => 'Declination' },
	'decposition' => { 173 => 0x32 },
	'defaultautogray' => { 456 => 'DefaultAutoGray', 458 => 'DefaultAutoGray' },
	'defaultautotone' => { 456 => 'DefaultAutoTone', 458 => 'DefaultAutoTone' },
	'defaultblackrender' => { 115 => 0xc7a6 },
	'defaultcroporigin' => { 115 => 0xc61f },
	'defaultcropsize' => { 115 => 0xc620 },
	'defaulteraseoption' => { 80 => 0x813 },
	'defaultscale' => { 115 => 0xc61e },
	'defaultsspecifictoiso' => { 456 => 'DefaultsSpecificToISO', 458 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 456 => 'DefaultsSpecificToSerial', 458 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 115 => 0xc7b5 },
	'defectisocode' => { 133 => 0x90f },
	'defringe' => { 456 => 'Defringe', 458 => 'Defringe' },
	'defringegreenamount' => { 456 => 'DefringeGreenAmount', 458 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 456 => 'DefringeGreenHueHi', 458 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 456 => 'DefringeGreenHueLo', 458 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 456 => 'DefringePurpleAmount', 458 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 456 => 'DefringePurpleHueHi', 458 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 456 => 'DefringePurpleHueLo', 458 => 'DefringePurpleHueLo' },
	'dehaze' => { 456 => 'Dehaze', 458 => 'Dehaze' },
	'deletedimagecount' => { 216 => 0xa6, 225 => 0x6e },
	'deprecatedon' => { 454 => 'deprecatedOn' },
	'depthimage' => { 441 => 'Data' },
	'derivedfrom' => { 483 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 483 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 483 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 483 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 483 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 483 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 483 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 483 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 483 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 483 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 483 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 483 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 483 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 483 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 483 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 483 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 483 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 483 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 483 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 483 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 483 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 483 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 483 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 483 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 293 => 'Description', 355 => ['desc','dscp',"\xa9des"], 357 => 'description', 363 => 'dscp', 459 => 'description', 480 => 'Description' },
	'destination' => { 128 => 0x5 },
	'destinationcity' => { 338 => 0x24, 344 => 0x3 },
	'destinationcitycode' => { 345 => 0x1001 },
	'destinationdst' => { 338 => 0x26, 344 => '0.3' },
	'developmentdynamicrange' => { 123 => 0x1403 },
	'deviantmatrixcustom' => { 133 => 0x7de },
	'deviantmatrixdaylight' => { 133 => 0x7da },
	'deviantmatrixflash' => { 133 => 0x7dd },
	'deviantmatrixfluorescent' => { 133 => 0x7dc },
	'deviantmatrixtungsten' => { 133 => 0x7db },
	'deviantwhitecustom' => { 133 => 0x842 },
	'deviantwhitedaylight' => { 133 => 0x83e },
	'deviantwhiteflash' => { 133 => 0x841 },
	'deviantwhitefluorescent' => { 133 => 0x840 },
	'deviantwhitetungsten' => { 133 => 0x83f },
	'device' => { 472 => 'device' },
	'devicesettingdescription' => { 462 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 462 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 462 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 462 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 377 => 0x2 },
	'dewarpdata' => { 112 => 'DewarpData' },
	'dewarpflag' => { 112 => 'DewarpFlag' },
	'dialdirectiontvav' => { 80 => 0x706 },
	'dietaryneeds' => { 474 => 'dietaryNeeds' },
	'diffractioncorrection' => { 303 => 0xbc, 328 => 0x3 },
	'diffractioncorrectionon' => { 99 => 0x2070b },
	'digitalcreationdate' => { 127 => 0x3e },
	'digitalcreationtime' => { 127 => 0x3f },
	'digitaldeehighlightadj' => { 224 => 0x202 },
	'digitaldeeshadowadj' => { 224 => 0x200 },
	'digitaldeethreshold' => { 224 => 0x201 },
	'digitalfilter' => { 380 => 0x59 },
	'digitalfilter01' => { 325 => 0x5 },
	'digitalfilter02' => { 325 => 0x16 },
	'digitalfilter03' => { 325 => 0x27 },
	'digitalfilter04' => { 325 => 0x38 },
	'digitalfilter05' => { 325 => 0x49 },
	'digitalfilter06' => { 325 => 0x5a },
	'digitalfilter07' => { 325 => 0x6b },
	'digitalfilter08' => { 325 => 0x7c },
	'digitalfilter09' => { 325 => 0x8d },
	'digitalfilter10' => { 325 => 0x9e },
	'digitalfilter11' => { 325 => 0xaf },
	'digitalfilter12' => { 325 => 0xc0 },
	'digitalfilter13' => { 325 => 0xd1 },
	'digitalfilter14' => { 325 => 0xe2 },
	'digitalfilter15' => { 325 => 0xf3 },
	'digitalfilter16' => { 325 => 0x104 },
	'digitalfilter17' => { 325 => 0x115 },
	'digitalfilter18' => { 325 => 0x126 },
	'digitalfilter19' => { 325 => 0x137 },
	'digitalfilter20' => { 325 => 0x148 },
	'digitalgain' => { 71 => 0xb },
	'digitalgem' => { 205 => 0x0 },
	'digitalice' => { 224 => 0x100 },
	'digitalimageguid' => { 468 => 'DigImageGUID' },
	'digitalroc' => { 222 => 0x0 },
	'digitalsourcefiletype' => { 468 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 468 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 108 => 0xa, 123 => 0x1044, 135 => 0x68, 149 => 'DigitalZoom', 173 => 0xc, 216 => 0x86, 246 => 0xa, 285 => 0x204, 338 => 0x1e, 345 => 0xa, 379 => 0x204, 421 => 0x12, 422 => 0x12 },
	'digitalzoomon' => { 379 => 0x21b },
	'digitalzoomratio' => { 115 => 0xa404, 411 => 0x200, 413 => 0x21c, 462 => 'DigitalZoomRatio' },
	'director' => { 357 => 'director', 363 => "\xa9dir", 482 => 'director' },
	'directorphotography' => { 482 => 'directorPhotography' },
	'directory' => { 116 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 199 => 0x3, 366 => 0x12 },
	'disableautocreation' => { 439 => 'DisableAutoCreation' },
	'disclaimer' => { 293 => 'Disclaimer' },
	'discnumber' => { 482 => 'discNumber' },
	'dishtype' => { 474 => 'dishType' },
	'disknumber' => { 355 => 'disk' },
	'displayallafpoints' => { 80 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 353 => 0x2 },
	'displayedunitsy' => { 353 => 0x6 },
	'displayname' => { 357 => 'displayname', 471 => 'displayName' },
	'distance1' => { 135 => 0x28 },
	'distance2' => { 135 => 0x2c },
	'distance3' => { 135 => 0x30 },
	'distance4' => { 135 => 0x34 },
	'distortion' => { 377 => 0xa050 },
	'distortioncompensation' => { 434 => 0x8040 },
	'distortioncontrol' => { 225 => 0x10 },
	'distortioncorrection' => { 76 => 0x3, 99 => 0x20705, 105 => 0x67, 115 => 0x7036, 280 => 0x50b, 307 => '7.1', 328 => 0x0, 429 => 0x601, 430 => 0x5b },
	'distortioncorrection2' => { 284 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 453 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 99 => '0x20705.0', 105 => 0x63 },
	'distortioncorrectionsetting' => { 77 => 0x7, 401 => 0x2013 },
	'distortioncorrectionvalue' => { 76 => 0x9 },
	'distortioncorrparams' => { 115 => 0x7037, 410 => 0x1a23, 413 => 0x1870, 415 => 0x189c, 416 => 0x18cc, 417 => 0x17d0, 429 => 0x6ca, 430 => 0x64 },
	'distortioncorrparamsnumber' => { 413 => 0x1899, 415 => 0x18c5, 416 => 0x18f5, 417 => 0x17f9 },
	'distortioncorrparamspresent' => { 413 => 0x1898, 415 => 0x18c4, 416 => 0x18f4, 417 => 0x17f8, 419 => 0x10b, 420 => 0x10b, 429 => 0x600, 430 => 0x5a },
	'distortioneffect' => { 99 => 0x20709 },
	'distortionn' => { 307 => 0xc },
	'distortionparam02' => { 307 => 0x2 },
	'distortionparam04' => { 307 => 0x4 },
	'distortionparam08' => { 307 => 0x8 },
	'distortionparam09' => { 307 => 0x9 },
	'distortionparam11' => { 307 => 0xb },
	'distortionscale' => { 307 => 0x5 },
	'distributor' => { 472 => 'distributor' },
	'distributorproductid' => { 471 => 'distributorProductID' },
	'dloon' => { 99 => '0x20706.0', 105 => 0xdc },
	'dlosetting' => { 99 => 0x20706, 105 => 0xdd },
	'dlosettingapplied' => { 98 => 0x4 },
	'dloshootingdistance' => { 105 => 0xde },
	'dloversion' => { 98 => 0x5 },
	'dmcomment' => { 482 => 'comment' },
	'dmdithermatrix' => { 133 => 0xc7a },
	'dmdithermatrixheight' => { 133 => 0xc7c },
	'dmdithermatrixwidth' => { 133 => 0xc7b },
	'dngadobedata' => { 115 => 0xc634 },
	'dngbackwardversion' => { 115 => 0xc613 },
	'dngignoresidecars' => { 456 => 'DNGIgnoreSidecars', 458 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 115 => 0xc630 },
	'dngprivatedata' => { 115 => 0xc634 },
	'dngversion' => { 115 => 0xc612 },
	'document' => { 293 => 'Document' },
	'documentancestors' => { 470 => 'DocumentAncestors' },
	'documenthistory' => { 127 => 0xe7 },
	'documentid' => { 483 => 'DocumentID' },
	'documentname' => { 115 => 0x10d },
	'documentnotes' => { 127 => 0xe6 },
	'doi' => { 472 => 'doi' },
	'dopesheet' => { 468 => 'Dopesheet' },
	'dopesheetlink' => { 468 => 'DopesheetLink' },
	'dopesheetlinklink' => { 468 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 468 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 133 => 0xc82 },
	'dpp' => { 451 => 'dpp' },
	'dr4cameramodel' => { 100 => 0x3 },
	'drangepriority' => { 123 => 0x1443 },
	'drangepriorityauto' => { 123 => 0x1444 },
	'drangepriorityfixed' => { 123 => 0x1445 },
	'drivemode' => { 109 => 0x3103, 121 => '0.1', 173 => 0x6, 176 => 0x1e, 179 => 0xe, 280 => 0x600, 338 => 0x34, 370 => 0x1002, 380 => 0x3, 388 => 0x4, 389 => 0x7e, 390 => 0x34 },
	'drivemode2' => { 176 => 0xa, 319 => 0x7, 399 => 0xe, 406 => 0x1 },
	'drivemodesetting' => { 390 => 0x4 },
	'drivespeed' => { 121 => '0.2' },
	'dspfirmwareversion' => { 338 => 0x27 },
	'duration' => { 64 => 0x6a, 148 => 'Duration', 162 => 'Duration', 474 => 'duration', 482 => 'duration' },
	'durationscale' => { 482 => [\'duration','durationScale'] },
	'durationvalue' => { 482 => [\'duration','durationValue'] },
	'dustremovaldata' => { 61 => 0x97 },
	'dynamicafarea' => { 263 => '1.4', 272 => '1.4' },
	'dynamicareaafdisplay' => { 264 => '46.1', 266 => '47.1', 267 => '47.1', 276 => '47.1', 277 => '47.1' },
	'dynamicrange' => { 123 => 0x1400 },
	'dynamicrangeexpansion' => { 338 => 0x69, 370 => 0x100e },
	'dynamicrangemax' => { 104 => 0x7c },
	'dynamicrangemin' => { 104 => 0x7a },
	'dynamicrangeoptimizer' => { 176 => 0x15, 401 => [0xb025,0xb04f], 409 => 0x1144, 410 => [0x1144,0x324], 411 => [0x1120,0x300], 412 => [0x119c,0x37c], 413 => [0x1178,0x328], 414 => [0x1030,0x50], 415 => [0x228,0x50], 416 => [0x228,0x50], 417 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 399 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 388 => 0x19, 389 => 0x17, 390 => 0xd, 399 => 0x79, 406 => 0x5 },
	'dynamicrangeoptimizermode' => { 179 => 0x15, 388 => 0x18, 389 => 0x16, 399 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 176 => 0x27, 390 => 0xc, 406 => 0x4 },
	'dynamicrangesetting' => { 123 => 0x1402 },
	'e-dialinprogram' => { 319 => '1.3' },
	'earliestageorloweststage' => { 114 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 114 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 114 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 114 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 114 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 278 => '6.1' },
	'easyexposurecompensation' => { 263 => '6.4', 264 => '6.5', 266 => '6.3', 267 => '6.3', 271 => '5.1', 272 => '4.4', 273 => '5.2', 276 => '6.3', 277 => '6.3' },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 133 => 0x930 },
	'edgemapx1' => { 133 => 0x931 },
	'edgemapx2' => { 133 => 0x932 },
	'edgemapx3' => { 133 => 0x934 },
	'edgemapx4' => { 133 => 0x935 },
	'edgenoisereduction' => { 257 => 0x4, 434 => 0x8028 },
	'edit1' => { 363 => "\xa9ed1" },
	'edit2' => { 363 => "\xa9ed2" },
	'edit3' => { 363 => "\xa9ed3" },
	'edit4' => { 363 => "\xa9ed4" },
	'edit5' => { 363 => "\xa9ed5" },
	'edit6' => { 363 => "\xa9ed6" },
	'edit7' => { 363 => "\xa9ed7" },
	'edit8' => { 363 => "\xa9ed8" },
	'edit9' => { 363 => "\xa9ed9" },
	'edition' => { 472 => 'edition' },
	'editorialupdate' => { 127 => 0x8 },
	'editstatus' => { 127 => 0x7, 350 => 'EditStatus', 451 => 'EditStatus' },
	'editversionname' => { 256 => 0x3d136244 },
	'effectivelv' => { 338 => 0x2d },
	'effectivemaxaperture' => { 209 => 0x12, 210 => 0x13, 214 => 0x14 },
	'eissn' => { 472 => 'eIssn' },
	'electricalblackcolumns' => { 133 => 0x1810 },
	'electronicfront-curtainshutter' => { 266 => '5.2', 267 => '5.2', 276 => '5.3', 277 => '5.2' },
	'electronicfrontcurtainshutter' => { 401 => 0x201a },
	'elevation' => { 158 => 'Elevation' },
	'email' => { 150 => 'EMail' },
	'embargodate' => { 475 => 'embargoDate' },
	'embdencrightsexpr' => { 468 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 468 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 468 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 468 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 470 => 'EmbeddedXMPDigest' },
	'emissivity' => { 117 => 0x3 },
	'enablechromanoisereduction' => { 133 => 0xe6e },
	'enablesharpening' => { 133 => 0x92e },
	'encodedby' => { 355 => "\xa9enc" },
	'encodedwith' => { 357 => 'Encoded_With' },
	'encoder' => { 355 => "\xa9too", 363 => "\xa9too" },
	'encoderid' => { 363 => "\xa9enc" },
	'encryptionkey' => { 377 => 0xa020 },
	'endingpage' => { 472 => 'endingPage' },
	'enduser' => { 290 => 'EndUser' },
	'enduserid' => { 290 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 290 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 482 => 'engineer' },
	'enhancedarktones' => { 249 => 0x8 },
	'enhancement' => { 108 => 0x16, 109 => 0x3016 },
	'enhancer' => { 284 => 0x300 },
	'enhancervalues' => { 284 => 0x301 },
	'envelopenumber' => { 128 => 0x28 },
	'envelopepriority' => { 128 => 0x3c },
	'enveloperecordversion' => { 128 => 0x0 },
	'episode' => { 468 => 'Episode' },
	'episodeglobaluniqueid' => { 355 => 'egid' },
	'episodeidentifier' => { 468 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 468 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 468 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 285 => 0x20c },
	'epsonimagewidth' => { 285 => 0x20b },
	'epsonsoftware' => { 285 => 0x20d },
	'equipmentinstitution' => { 436 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 436 => 'EquipmentManufacturer' },
	'equipmentversion' => { 281 => 0x0 },
	'ettlii' => { 80 => 0x304, 81 => 0xd, 82 => 0xe, 83 => 0x7, 84 => 0x7, 85 => 0xe },
	'event' => { 437 => 'Event', 449 => 'Event', 468 => 'Event', 472 => 'event' },
	'eventalias' => { 471 => 'eventAlias' },
	'eventdate' => { 114 => [\'Event','EventEventDate'] },
	'eventday' => { 114 => [\'Event','EventDay'] },
	'eventearliestdate' => { 114 => [\'Event','EventEarliestDate'] },
	'eventend' => { 471 => 'eventEnd' },
	'eventenddayofyear' => { 114 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 114 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 114 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 114 => [\'Event','EventHabitat'] },
	'eventid' => { 114 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 114 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 114 => [\'Event','EventMonth'] },
	'eventnumber' => { 364 => 0x9, 365 => 0x37, 366 => 0x3a },
	'eventparenteventid' => { 114 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 114 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 114 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 114 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 114 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 114 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 471 => 'eventStart' },
	'eventstartdayofyear' => { 114 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 471 => 'eventSubtype' },
	'eventtime' => { 114 => [\'Event','EventEventTime'] },
	'eventtype' => { 471 => 'eventType' },
	'eventverbatimeventdate' => { 114 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 114 => [\'Event','EventYear'] },
	'evsteps' => { 319 => '1.2', 321 => 0x0 },
	'evstepsize' => { 268 => '5.1', 269 => '6.1', 270 => '6.1', 274 => '0.7' },
	'exclusivecoverage' => { 446 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 475 => 'exclusivityEndDate' },
	'excursiontolerance' => { 129 => 0x82 },
	'exif' => { 116 => 'EXIF' },
	'exifbyteorder' => { 116 => 'ExifByteOrder' },
	'exifcamerainfo' => { 127 => 0xe8 },
	'exifimageheight' => { 115 => 0xa003, 462 => 'PixelYDimension' },
	'exifimagewidth' => { 115 => 0xa002, 462 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 116 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 115 => 0x9000, 462 => 'ExifVersion' },
	'exitpupilposition' => { 209 => 0x4, 210 => 0x4, 214 => 0x4 },
	'expirationdate' => { 127 => 0x25, 475 => 'expirationDate' },
	'expirationtime' => { 127 => 0x26 },
	'exposure' => { 115 => 0xfe51, 456 => 'Exposure', 458 => 'Exposure' },
	'exposure2012' => { 456 => 'Exposure2012', 458 => 'Exposure2012' },
	'exposureadj' => { 254 => 0x0 },
	'exposureadj2' => { 254 => 0x12 },
	'exposureadjust' => { 380 => 0xc },
	'exposurebracketingindicatorlast' => { 176 => 0x52 },
	'exposurebracketshotnumber' => { 179 => 0x2d, 399 => 0x2f },
	'exposurebracketstepsize' => { 319 => 0x8 },
	'exposurebracketvalue' => { 216 => 0x19 },
	'exposurecompautocancel' => { 80 => 0x113 },
	'exposurecompensation' => { 74 => 0x6, 89 => 0x0, 115 => 0x9204, 135 => 0x24, 149 => 'ExposureComp', 169 => 'ExposureCompensation', 173 => 0xd, 174 => 0x53, 175 => 0x1e, 179 => 0x49c0, 285 => 0x1006, 338 => 0x16, 347 => 0x402, 377 => 0xa013, 380 => [0xc,0x35,0x4d], 409 => 0x114c, 410 => 0x114c, 411 => 0x1128, 413 => 0x1180, 414 => 0x1038, 415 => 0x230, 416 => 0x230, 417 => 0x223, 462 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 406 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 176 => 0x47, 179 => 0x2a },
	'exposurecompensationset' => { 388 => 0x3, 389 => 0x3, 390 => 0x3, 406 => 0x1e },
	'exposurecompensationsetting' => { 176 => 0x1 },
	'exposurecompstepsize' => { 263 => '6.3', 264 => '7.3', 266 => '7.3', 267 => '7.3', 272 => '4.3', 276 => '7.3', 277 => '7.3' },
	'exposurecontrolstep' => { 271 => '6.1', 273 => '6.1' },
	'exposurecontrolstepsize' => { 263 => '6.2', 264 => '7.1', 266 => '7.1', 267 => '7.1', 272 => '4.2', 276 => '7.1', 277 => '7.1', 278 => '7.1' },
	'exposurecount' => { 123 => 0x1032 },
	'exposuredelaymode' => { 263 => '10.1', 264 => '11.1', 266 => '11.1', 267 => '11.1', 268 => '9.1', 269 => '10.1', 270 => '10.1', 272 => '10.4', 273 => '10.1', 274 => '6.4', 276 => '11.1', 277 => '11.1', 278 => '11.2' },
	'exposuredifference' => { 216 => 0xe },
	'exposuregaincustom' => { 133 => 0x89c },
	'exposuregaindaylight' => { 133 => 0x898 },
	'exposuregainflash' => { 133 => 0x89b },
	'exposuregainfluorescent' => { 133 => 0x89a },
	'exposuregaintungsten' => { 133 => 0x899 },
	'exposureindex' => { 115 => 0xa215, 462 => 'ExposureIndex' },
	'exposureindicator' => { 176 => 0x50 },
	'exposurelevelincrements' => { 78 => 0x6, 79 => 0x6, 80 => 0x101, 81 => 0x5, 82 => 0x6, 83 => 0x5, 84 => 0x5, 85 => 0x6, 86 => 0x4, 388 => 0x58, 389 => 0x58 },
	'exposurelockused' => { 444 => 'ExposureLockUsed' },
	'exposuremode' => { 115 => 0xa402, 149 => 'ExposureMode', 173 => 0x1, 174 => 0xa, 175 => 0x0, 176 => 0x0, 179 => 0x34, 280 => 0x200, 300 => 0x40d, 380 => 0x8, 401 => 0xb041, 462 => 'ExposureMode' },
	'exposuremodeinmanual' => { 80 => 0x10b },
	'exposureprogram' => { 115 => 0x8822, 370 => 0x1001, 381 => [0x17e,0x43], 388 => 0x3c, 389 => 0x3c, 390 => 0x5, 394 => 0x14, 399 => 0x3f, 406 => 0x2, 409 => 0x1175, 410 => 0x1179, 411 => 0x1155, 412 => 0x11d1, 413 => 0x11ad, 414 => 0x1065, 415 => 0x25d, 416 => 0x25d, 417 => 0x24c, 426 => 0xb, 427 => 0xc, 428 => 0xb, 430 => 0x48, 462 => 'ExposureProgram' },
	'exposureshift' => { 280 => 0x203 },
	'exposurestandardadjustment' => { 401 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 74 => 0x16, 115 => 0x829a, 132 => 0xfd05, 135 => 0x20, 137 => 0xfa24, 139 => 0xf104, 142 => 0x12, 144 => 0x38, 147 => 0x10, 149 => 'ExposureTime', 173 => 0x9, 174 => 0x35, 175 => 0x48, 176 => 0x8, 179 => 0x49b8, 338 => 0x12, 377 => 0xa018, 380 => [0x32,0x4a], 388 => 0x0, 389 => 0x0, 406 => [0x21,0x23,0x27], 430 => 0x10, 462 => 'ExposureTime' },
	'exposuretime2' => { 380 => [0x33,0x4b] },
	'exposuretuning' => { 216 => 0x1c },
	'exposurevalue' => { 133 => 0x3 },
	'exposurewarning' => { 123 => 0x1302 },
	'exrauto' => { 123 => 0x1033 },
	'exrmode' => { 123 => 0x1034 },
	'extendedwbdetect' => { 280 => 0x902 },
	'extender' => { 281 => 0x301 },
	'extenderfirmwareversion' => { 281 => 0x304 },
	'extendermagnification' => { 151 => 'Magnification' },
	'extendermake' => { 151 => 'Make' },
	'extendermodel' => { 151 => 'Model', 281 => 0x303 },
	'extenderserialnumber' => { 151 => 'SerialNumber', 281 => 0x302 },
	'extenderstatus' => { 336 => 0x3 },
	'externalflash' => { 283 => 0x1201 },
	'externalflashae1' => { 285 => 0x101f },
	'externalflashae1_0' => { 285 => 0x101b },
	'externalflashae2' => { 285 => 0x1020 },
	'externalflashae2_0' => { 285 => 0x101c },
	'externalflashbounce' => { 283 => 0x1204, 285 => 0x1026, 326 => 0x1a },
	'externalflashcompensation' => { 202 => 0x1b },
	'externalflashexposurecomp' => { 216 => 0x17, 326 => 0x19 },
	'externalflashfirmware' => { 200 => 0x6, 201 => 0x6, 202 => 0x6, 203 => 0x6, 204 => 0x6 },
	'externalflashflags' => { 200 => 0x8, 201 => 0x8, 202 => 0x8, 203 => 0x8 },
	'externalflashguidenumber' => { 283 => 0x1203, 326 => '24.1' },
	'externalflashgvalue' => { 285 => 0x1025 },
	'externalflashmode' => { 285 => 0x1028, 326 => 0x2 },
	'externalflashreadystate' => { 204 => '9.1' },
	'externalflashstatus' => { 204 => '8.2' },
	'externalflashzoom' => { 283 => 0x1205, 285 => 0x1027 },
	'externalflashzoomoverride' => { 204 => '8.1' },
	'externalmetadatalink' => { 468 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 298 => 0x311, 301 => 0x311, 302 => 0x311, 305 => 0x3408 },
	'extrainfoversion' => { 392 => 0x1a },
	'eyestartaf' => { 176 => 0x40 },
	'fac100per' => { 133 => 0xe94 },
	'fac170per' => { 133 => 0xe93 },
	'fac18per' => { 133 => 0xe92 },
	'face10position' => { 106 => 0x3f4, 107 => 0x1ec, 198 => 0x28, 323 => 0x12 },
	'face10size' => { 324 => 0x12 },
	'face11position' => { 198 => 0x2c, 323 => 0x14 },
	'face11size' => { 324 => 0x14 },
	'face12position' => { 198 => 0x30, 323 => 0x16 },
	'face12size' => { 324 => 0x16 },
	'face13position' => { 323 => 0x18 },
	'face13size' => { 324 => 0x18 },
	'face14position' => { 323 => 0x1a },
	'face14size' => { 324 => 0x1a },
	'face15position' => { 323 => 0x1c },
	'face15size' => { 324 => 0x1c },
	'face16position' => { 323 => 0x1e },
	'face16size' => { 324 => 0x1e },
	'face17position' => { 323 => 0x20 },
	'face17size' => { 324 => 0x20 },
	'face18position' => { 323 => 0x22 },
	'face18size' => { 324 => 0x22 },
	'face19position' => { 323 => 0x24 },
	'face19size' => { 324 => 0x24 },
	'face1position' => { 52 => 0x8, 106 => 0xd, 107 => 0x18, 198 => 0x4, 295 => 0x1, 323 => 0x0, 367 => 0xbc, 395 => 0x1, 396 => 0x0, 397 => 0x0, 398 => 0x5b },
	'face1size' => { 324 => 0x0 },
	'face20position' => { 323 => 0x26 },
	'face20size' => { 324 => 0x26 },
	'face21position' => { 323 => 0x28 },
	'face21size' => { 324 => 0x28 },
	'face22position' => { 323 => 0x2a },
	'face22size' => { 324 => 0x2a },
	'face23position' => { 323 => 0x2c },
	'face23size' => { 324 => 0x2c },
	'face24position' => { 323 => 0x2e },
	'face24size' => { 324 => 0x2e },
	'face25position' => { 323 => 0x30 },
	'face25size' => { 324 => 0x30 },
	'face26position' => { 323 => 0x32 },
	'face26size' => { 324 => 0x32 },
	'face27position' => { 323 => 0x34 },
	'face27size' => { 324 => 0x34 },
	'face28position' => { 323 => 0x36 },
	'face28size' => { 324 => 0x36 },
	'face29position' => { 323 => 0x38 },
	'face29size' => { 324 => 0x38 },
	'face2position' => { 52 => 0xa, 106 => 0x7c, 107 => 0x4c, 198 => 0x8, 295 => 0x5, 323 => 0x2, 367 => 0xc8, 395 => 0x6, 396 => 0x20, 397 => 0x25, 398 => 0x65 },
	'face2size' => { 324 => 0x2 },
	'face30position' => { 323 => 0x3a },
	'face30size' => { 324 => 0x3a },
	'face31position' => { 323 => 0x3c },
	'face31size' => { 324 => 0x3c },
	'face32position' => { 323 => 0x3e },
	'face32size' => { 324 => 0x3e },
	'face3position' => { 52 => 0xc, 106 => 0xeb, 107 => 0x80, 198 => 0xc, 295 => 0x9, 323 => 0x4, 367 => 0xd4, 395 => 0xb, 396 => 0x40, 397 => 0x4a, 398 => 0x6f },
	'face3size' => { 324 => 0x4 },
	'face4position' => { 52 => 0xe, 106 => 0x15a, 107 => 0xb4, 198 => 0x10, 295 => 0xd, 323 => 0x6, 367 => 0xe0, 395 => 0x10, 396 => 0x60, 397 => 0x6f, 398 => 0x79 },
	'face4size' => { 324 => 0x6 },
	'face5position' => { 52 => 0x10, 106 => 0x1c9, 107 => 0xe8, 198 => 0x14, 295 => 0x11, 323 => 0x8, 367 => 0xec, 395 => 0x15, 396 => 0x80, 397 => 0x94 },
	'face5size' => { 324 => 0x8 },
	'face6position' => { 52 => 0x12, 106 => 0x238, 107 => 0x11c, 198 => 0x18, 323 => 0xa, 367 => 0xf8, 395 => 0x1a, 396 => 0xa0, 397 => 0xb9 },
	'face6size' => { 324 => 0xa },
	'face7position' => { 52 => 0x14, 106 => 0x2a7, 107 => 0x150, 198 => 0x1c, 323 => 0xc, 367 => 0x104, 395 => 0x1f, 396 => 0xc0, 397 => 0xde },
	'face7size' => { 324 => 0xc },
	'face8position' => { 52 => 0x16, 106 => 0x316, 107 => 0x184, 198 => 0x20, 323 => 0xe, 367 => 0x110, 395 => 0x24, 396 => 0xe0, 397 => 0x103 },
	'face8size' => { 324 => 0xe },
	'face9position' => { 52 => 0x18, 106 => 0x385, 107 => 0x1b8, 198 => 0x24, 323 => 0x10 },
	'face9size' => { 324 => 0x10 },
	'facebalanceorigi' => { 450 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 450 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 450 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 450 => 'FaceBalanceWarmth' },
	'facedetect' => { 338 => 0x76, 377 => 0x100 },
	'facedetectarea' => { 284 => 0x1201 },
	'facedetectframecrop' => { 284 => 0x1207 },
	'facedetectframesize' => { 52 => 0x3, 106 => 0x1, 107 => 0x4, 198 => 0x1, 284 => 0x1203, 338 => 0x77, 367 => 0xb6 },
	'facedetection' => { 390 => 0x30, 406 => 0x19 },
	'faceelementpositions' => { 123 => 0x4203 },
	'faceelementselected' => { 123 => 0x4005 },
	'faceelementtypes' => { 123 => 0x4201 },
	'faceid' => { 452 => 'FaceID' },
	'faceinfounknown' => { 109 => 0x2089 },
	'facename' => { 377 => 0x123 },
	'faceorientation' => { 107 => 0x8 },
	'faceposition' => { 322 => 0x2, 378 => 0x4 },
	'facepositions' => { 123 => 0x4103 },
	'facerecognition' => { 377 => 0x120 },
	'facesdetected' => { 52 => 0x2, 53 => 0x2, 54 => 0x3, 106 => 0x0, 107 => 0x2, 109 => 0x211c, 123 => 0x4100, 198 => 0x3, 284 => 0x1200, 303 => 0x3f, 322 => 0x0, 367 => 0xb5, 378 => 0x0, 395 => 0x0, 398 => 0x3, 408 => 0x30 },
	'facesrecognized' => { 296 => 0x0 },
	'facewidth' => { 53 => 0x1 },
	'faithfuloutputhighlightpoint' => { 105 => 0x38 },
	'faithfuloutputshadowpoint' => { 105 => 0x39 },
	'faithfulrawcolortone' => { 105 => 0x31 },
	'faithfulrawcontrast' => { 105 => 0x33 },
	'faithfulrawhighlight' => { 105 => 0x79 },
	'faithfulrawhighlightpoint' => { 105 => 0x36 },
	'faithfulrawlinear' => { 105 => 0x34 },
	'faithfulrawsaturation' => { 105 => 0x32 },
	'faithfulrawshadow' => { 105 => 0x82 },
	'faithfulrawshadowpoint' => { 105 => 0x37 },
	'faithfulrawsharpness' => { 105 => 0x35 },
	'faithfulunsharpmaskfineness' => { 105 => 0xac },
	'faithfulunsharpmaskstrength' => { 105 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 105 => 0xae },
	'far' => { 441 => 'Far' },
	'fastresetlinetime' => { 133 => 0x1860 },
	'feedidentifier' => { 468 => 'FeedIdentifier' },
	'femicroadjustment' => { 80 => 0x111 },
	'ffid' => { 460 => 'ffid' },
	'field' => { 471 => 'field' },
	'fieldcount' => { 285 => 0x103f },
	'fieldofview' => { 363 => "FOV\x00" },
	'fifoenonepixeldelay' => { 133 => 0x1901 },
	'filecreatedate' => { 116 => 'FileCreateDate' },
	'filedatarate' => { 482 => 'fileDataRate' },
	'fileformat' => { 91 => 0x0, 128 => 0x14, 380 => [0x22,0x26], 401 => 0xb000 },
	'filegroupid' => { 116 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 304 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 116 => 'FileModifyDate' },
	'filename' => { 116 => 'FileName' },
	'filenameasdelivered' => { 290 => 'FileNameAsDelivered' },
	'filenumber' => { 55 => 0x1, 61 => 0x8, 93 => 0x1817, 110 => 'Canon::FileNumber', 199 => 0x4, 366 => 0x10 },
	'filenumbermemory' => { 173 => 0x1a },
	'filenumbersequence' => { 263 => '12.2', 268 => '3.1', 269 => '4.1', 270 => '4.1', 272 => '11.1', 273 => '4.3', 278 => '5.2' },
	'filepermissions' => { 116 => 'FilePermissions' },
	'filesource' => { 115 => 0xa300, 123 => 0x8000, 462 => 'FileSource' },
	'fileuserid' => { 116 => 'FileUserID' },
	'fileversion' => { 128 => 0x16 },
	'fillflashautoreduction' => { 78 => 0xe, 79 => 0xe, 86 => 0xa },
	'filllight' => { 456 => 'FillLight', 458 => 'FillLight' },
	'fillorder' => { 115 => 0x10a },
	'filmgraineffect' => { 280 => 0x538 },
	'filmmode' => { 123 => 0x1401, 300 => 0x412, 303 => 0x42 },
	'filmtype' => { 224 => 0x2 },
	'filtereffect' => { 55 => 0xe, 218 => 0x37, 219 => 0x3f, 220 => 0x47 },
	'filtereffectauto' => { 68 => 0xa0 },
	'filtereffectfaithful' => { 67 => 0x70, 68 => 0x70 },
	'filtereffectlandscape' => { 67 => 0x40, 68 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 67 => 0x88, 68 => 0x88 },
	'filtereffectneutral' => { 67 => 0x58, 68 => 0x58 },
	'filtereffectportrait' => { 67 => 0x28, 68 => 0x28 },
	'filtereffectstandard' => { 67 => 0x10, 68 => 0x10 },
	'filtereffectuserdef1' => { 67 => 0xa0, 68 => 0xb8 },
	'filtereffectuserdef2' => { 67 => 0xb8, 68 => 0xd0 },
	'filtereffectuserdef3' => { 67 => 0xd0, 68 => 0xe8 },
	'finderdisplayduringexposure' => { 79 => 0x1 },
	'finesharpness' => { 338 => 0x70 },
	'finetuneoptcenterweighted' => { 263 => '7.2', 264 => '9.1', 266 => '9.1', 267 => '9.1', 271 => '8.1', 276 => '9.1', 277 => '9.1', 278 => '9.1' },
	'finetuneopthighlightweighted' => { 266 => '46.1', 267 => '46.1', 276 => '46.1', 277 => '46.1' },
	'finetuneoptmatrixmetering' => { 263 => '8.1', 264 => '8.2', 266 => '8.2', 267 => '8.2', 271 => '7.2', 272 => '6.1', 276 => '8.2', 277 => '8.2', 278 => '8.2' },
	'finetuneoptspotmetering' => { 263 => '8.2', 264 => '9.2', 266 => '9.2', 267 => '9.2', 271 => '8.2', 272 => '6.2', 276 => '9.2', 277 => '9.2', 278 => '9.2' },
	'finishexposure' => { 133 => 0xdbd },
	'finishfiletype' => { 133 => 0xdb8 },
	'finishlook' => { 133 => 0xdbc },
	'finishnoise' => { 133 => 0xdba },
	'finishresolution' => { 133 => 0xdb9 },
	'finishsharpening' => { 133 => 0xdbb },
	'firmware' => { 285 => 0x405, 380 => [0x8c,0x17,0x3b], 453 => 'Firmware' },
	'firmware2' => { 380 => 0x57 },
	'firmwaredate' => { 108 => 0x15, 109 => 0x2001, 364 => 0x4, 366 => 0x30 },
	'firmwareid' => { 180 => 0x0 },
	'firmwarename' => { 377 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 61 => 0x1e, 368 => 0x0 },
	'firmwarerevision2' => { 368 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 133 => [0x415,0xce5], 147 => 0x57, 149 => 'FirmwareVersion', 301 => 0x320, 303 => 0x2, 305 => 0x3109, 338 => 0x230, 363 => ['CNFV','FIRM'], 365 => 0x18, 366 => 0x2a, 370 => 0x2 },
	'firmwareversions' => { 347 => 0x301 },
	'firstphotodate' => { 444 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 290 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 127 => 0x16, 451 => 'FixtureIdentifier' },
	'flash' => { 110 => 'XMP::Flash', 115 => 0x9209, 174 => 0x1f, 175 => 0x15, 366 => 0x5a, 462 => 'Flash' },
	'flashaction' => { 388 => 0x3e, 389 => 0x3e, 401 => 0x2017, 406 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 388 => 0x4c, 389 => 0x4c, 406 => 0x77 },
	'flashactionexternal' => { 406 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 42 => 0x249 },
	'flashbias' => { 303 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashbuttonfunction' => { 80 => 0x70e },
	'flashchargelevel' => { 285 => 0x1010 },
	'flashcolorfilter' => { 202 => 0x10, 203 => 0x10 },
	'flashcommandermode' => { 200 => '9.1', 201 => '9.1', 202 => '9.1', 203 => '9.1' },
	'flashcompensation' => { 133 => 0x3f3, 200 => 0xa, 201 => 0xa, 202 => 0xa, 203 => 0x27, 204 => 0xa, 453 => 'FlashCompensation' },
	'flashcontrol' => { 388 => 0x23, 389 => 0x1f, 390 => 0x21 },
	'flashcontrolbuilt-in' => { 272 => '16.1', 273 => '23.1', 275 => '23.1', 276 => '24.1' },
	'flashcontrolmode' => { 200 => '9.2', 201 => '9.2', 202 => '9.2', 203 => '9.2', 280 => 0x404 },
	'flashcurtain' => { 303 => 0x48 },
	'flashdefault' => { 176 => 0x42 },
	'flashdevice' => { 285 => 0x1005 },
	'flashdistance' => { 109 => 0x2034 },
	'flashenergy' => { 115 => 0xa20b, 462 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 216 => 0x18 },
	'flashexposurecomp' => { 74 => 0xf, 123 => 0x1011, 152 => 'ExposureComp', 173 => 0x23, 178 => 0x104, 179 => 0x49c1, 216 => 0x12, 280 => 0x401, 285 => 0x1023, 338 => 0x4d, 370 => 0x100b, 380 => [0x3a,0x56], 401 => 0x104 },
	'flashexposurecomp2' => { 242 => 0x4d2 },
	'flashexposurecomp3' => { 202 => 0x1d },
	'flashexposurecomp4' => { 202 => 0x27 },
	'flashexposurecomparea' => { 264 => '38.4', 266 => '38.4', 267 => '38.4', 276 => '38.4', 277 => '38.4' },
	'flashexposurecompset' => { 176 => 0x10, 311 => 0xe, 388 => 0x14, 389 => 0x12, 390 => 0x23, 406 => 0x1f },
	'flashexposurecompset2' => { 406 => [0x26,0x2c] },
	'flashexposureindicator' => { 176 => 0x54 },
	'flashexposureindicatorlast' => { 176 => 0x56 },
	'flashexposureindicatornext' => { 176 => 0x55 },
	'flashexposurelock' => { 55 => 0x19 },
	'flashfired' => { 135 => 0x5d, 152 => 'Fired', 173 => 0x14, 241 => '590.3', 462 => [\'Flash','FlashFired'] },
	'flashfiring' => { 80 => 0x306, 81 => 0x6, 82 => 0x7, 85 => 0x7 },
	'flashfirmwareversion' => { 281 => 0x1002 },
	'flashfocallength' => { 200 => 0xb, 201 => 0xc, 202 => 0xc, 203 => 0xc, 204 => 0xc },
	'flashfunction' => { 179 => 0x31, 462 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 200 => 0xe, 201 => 0xf, 202 => 0xf, 203 => 0xf, 204 => 0xf },
	'flashgroupacompensation' => { 200 => 0x11, 201 => 0x12, 202 => 0x13, 203 => 0x28, 204 => 0x28 },
	'flashgroupacontrolmode' => { 200 => 0xf, 201 => '16.1', 202 => '17.1', 203 => '17.1', 204 => '17.1' },
	'flashgroupaoutput' => { 200 => 0x11, 201 => 0x12, 202 => 0x13, 203 => 0x28, 204 => 0x28 },
	'flashgroupbcompensation' => { 200 => 0x12, 201 => 0x13, 202 => 0x14, 203 => 0x29, 204 => 0x29 },
	'flashgroupbcontrolmode' => { 200 => 0x10, 201 => '17.1', 202 => '18.1', 203 => '18.1', 204 => '18.1' },
	'flashgroupboutput' => { 200 => 0x12, 201 => 0x13, 202 => 0x14, 203 => 0x29, 204 => 0x29 },
	'flashgroupccompensation' => { 201 => 0x14, 202 => 0x15, 203 => 0x2a, 204 => 0x2a },
	'flashgroupccontrolmode' => { 201 => '17.2', 202 => '18.2', 203 => '18.2', 204 => '18.2' },
	'flashgroupcoutput' => { 201 => 0x14, 202 => 0x15, 203 => 0x2a, 204 => 0x2a },
	'flashguidenumber' => { 74 => 0xd, 90 => 0x0, 152 => 'GuideNumber' },
	'flashintensity' => { 108 => [0x19,0x5], 280 => 0x405 },
	'flashlevel' => { 265 => 0x9, 401 => 0xb048 },
	'flashmake' => { 152 => 'Make' },
	'flashmanufacturer' => { 171 => 'FlashManufacturer' },
	'flashmetering' => { 173 => 0x3f, 176 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 338 => 0x20a },
	'flashmode' => { 108 => 0x4, 133 => 0x3f2, 135 => 0x5c, 152 => 'Mode', 173 => 0x2, 174 => 0x20, 175 => 0x16, 176 => 0xf, 216 => 0x87, 280 => 0x400, 285 => 0x1004, 338 => 0xc, 345 => 0x4, 369 => 0x20, 370 => 0x100a, 379 => 0x225, 388 => 0x13, 389 => 0x7f, 390 => 0x20, 406 => 0x10, 409 => 0x1138, 410 => 0x1138, 411 => 0x1114, 412 => 0x1190, 413 => 0x116c, 414 => 0x1024, 415 => 0x21c, 416 => 0x21c, 417 => 0x211, 462 => [\'Flash','FlashMode'] },
	'flashmodel' => { 152 => 'Model', 171 => 'FlashModel', 281 => 0x1001 },
	'flashoptions' => { 319 => 0x2 },
	'flashoptions2' => { 319 => 0x10 },
	'flashoutput' => { 42 => 0x248, 74 => 0x21, 200 => 0xa, 201 => 0xa, 202 => 0xa, 203 => 0x27 },
	'flashpixversion' => { 115 => 0xa000, 462 => 'FlashpixVersion' },
	'flashredeyemode' => { 462 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 280 => 0x403 },
	'flashreturn' => { 462 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 152 => 'SerialNumber', 281 => 0x1003 },
	'flashsetting' => { 216 => 0x8 },
	'flashshutterspeed' => { 263 => '20.2', 264 => '23.2', 266 => '23.2', 267 => '23.2', 272 => '15.2', 273 => '22.2', 274 => '7.2', 275 => '22.2', 276 => '23.2', 277 => '23.2', 278 => '23.1' },
	'flashsource' => { 200 => 0x4, 201 => 0x4, 202 => 0x4, 203 => 0x4, 204 => 0x4 },
	'flashstatus' => { 326 => 0x0, 406 => [0x82,0x86], 419 => 0x31, 420 => 0x39 },
	'flashstatusbuilt-in' => { 390 => [0x87,0x287] },
	'flashstatusexternal' => { 390 => [0x88,0x288] },
	'flashsyncspeed' => { 263 => '20.1', 264 => '23.1', 266 => '23.1', 267 => '23.1', 272 => '15.1', 273 => '22.1', 275 => '22.1', 276 => '23.1', 277 => '23.1' },
	'flashsyncspeedav' => { 78 => 0x3, 80 => 0x10f, 81 => 0x2, 82 => 0x3, 83 => 0x2, 84 => 0x2, 85 => 0x3, 86 => 0x6 },
	'flashthreshold' => { 90 => 0x1 },
	'flashtype' => { 152 => 'Type', 176 => 0x59, 216 => 0x9, 281 => 0x1000 },
	'flashwarning' => { 273 => '30.1', 274 => '7.1', 278 => '31.1', 303 => 0x62 },
	'flexiblespotposition' => { 401 => 0x201d },
	'flickerreduce' => { 379 => 0x218 },
	'flickerreduction' => { 123 => 0x1446, 235 => 0xe84 },
	'flickerreductionindicator' => { 235 => 0x5e2 },
	'flightpitchdegree' => { 112 => 'FlightPitchDegree' },
	'flightrolldegree' => { 112 => 'FlightRollDegree' },
	'flightxspeed' => { 112 => 'FlightXSpeed' },
	'flightyawdegree' => { 112 => 'FlightYawDegree' },
	'flightyspeed' => { 112 => 'FlightYSpeed' },
	'flightzspeed' => { 112 => 'FlightZSpeed' },
	'fliphorizontal' => { 256 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 74 => 0x15, 115 => 0x829d, 132 => 0xfd04, 135 => 0x1e, 137 => 0xfa23, 139 => 0xf103, 142 => 0x13, 144 => 0x3c, 147 => 0xc, 156 => 'FNumber', 173 => 0xa, 174 => 0x36, 175 => 0x47, 176 => 0x9, 179 => 0x49c7, 214 => 0x38, 338 => 0x13, 377 => 0xa019, 380 => [0x31,0x49], 388 => 0x1, 389 => 0x1, 406 => [0x20,0x22,0x26], 462 => 'FNumber' },
	'focaldistance' => { 442 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 57 => 0x1, 109 => 0x1d, 115 => 0x920a, 142 => 0x1d, 156 => 'FocalLength', 173 => 0x12, 209 => 0xa, 210 => 0xb, 214 => [0xc,0x3c], 297 => 0x1, 338 => 0x1d, 347 => 0x403, 370 => 0x1500, 387 => 0xe, 413 => 0x1278, 414 => 0x1134, 415 => 0x32c, 416 => 0x32c, 417 => 0x30a, 462 => 'FocalLength' },
	'focallength2' => { 406 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 115 => 0xa405, 377 => 0xa01a, 462 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 387 => 0x10 },
	'focalplaneafpointarea' => { 418 => 0x2 },
	'focalplaneafpointlocation1' => { 418 => 0x6 },
	'focalplaneafpointlocation10' => { 418 => 0x2a },
	'focalplaneafpointlocation11' => { 418 => 0x2e },
	'focalplaneafpointlocation12' => { 418 => 0x32 },
	'focalplaneafpointlocation13' => { 418 => 0x36 },
	'focalplaneafpointlocation14' => { 418 => 0x3a },
	'focalplaneafpointlocation15' => { 418 => 0x3e },
	'focalplaneafpointlocation2' => { 418 => 0xa },
	'focalplaneafpointlocation3' => { 418 => 0xe },
	'focalplaneafpointlocation4' => { 418 => 0x12 },
	'focalplaneafpointlocation5' => { 418 => 0x16 },
	'focalplaneafpointlocation6' => { 418 => 0x1a },
	'focalplaneafpointlocation7' => { 418 => 0x1e },
	'focalplaneafpointlocation8' => { 418 => 0x22 },
	'focalplaneafpointlocation9' => { 418 => 0x26 },
	'focalplaneafpointsused' => { 418 => 0x1 },
	'focalplanediagonal' => { 281 => 0x103, 285 => 0x205 },
	'focalplaneresolutionunit' => { 115 => 0xa210, 462 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 115 => 0xa20e, 462 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 57 => 0x2 },
	'focalplanexunknown' => { 57 => 0x2 },
	'focalplaneyresolution' => { 115 => 0xa20f, 462 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 57 => 0x3 },
	'focalplaneyunknown' => { 57 => 0x3 },
	'focalpointx' => { 442 => 'FocalPointX' },
	'focalpointy' => { 442 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 57 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 246 => 0x8 },
	'focusarea' => { 173 => 0x31 },
	'focusareaselection' => { 274 => '15.2' },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 80 => 0x515 },
	'focusdistance' => { 156 => 'FocusDistance', 173 => 0x13, 179 => 0x49bb, 209 => 0x9, 210 => 0xa, 214 => [0xb,0x4f], 283 => 0x305, 297 => 0x0, 301 => 0x304, 302 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 55 => 0x15, 74 => 0x14 },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 55 => 0x14, 74 => 0x13 },
	'focusholdbutton' => { 176 => 0x44 },
	'focusinfoversion' => { 283 => 0x0 },
	'focusingscreen' => { 79 => 0x0, 80 => 0x80b, 85 => 0x0 },
	'focuslocation' => { 401 => 0x2027 },
	'focuslocked' => { 172 => 0x14 },
	'focusmode' => { 34 => 0x7, 108 => 0x3, 109 => [0x3003,0xd], 123 => 0x1021, 133 => 0x3f5, 135 => 0x38, 149 => 'FocusMode', 173 => 0x30, 175 => 0xe, 176 => 0xc, 216 => 0x7, 280 => 0x301, 285 => 0x100b, 303 => 0x7, 338 => 0xd, 345 => 0x3, 370 => 0x1006, 381 => [0xb,0x5], 387 => [0x15,0x1d], 388 => 0x4d, 389 => 0x4d, 401 => [0xb042,0xb04e,0x201b], 406 => 0x13, 424 => 0x16 },
	'focusmode2' => { 122 => '0.1', 319 => '3.1', 406 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 265 => '10.1', 385 => 0x14, 386 => 0x15, 388 => 0x10, 389 => 0xf, 390 => 0x6 },
	'focusmodeswitch' => { 176 => 0x58, 388 => 0x2e },
	'focuspixel' => { 123 => 0x1023 },
	'focuspointwrap' => { 263 => '2.2', 264 => '2.2', 266 => '2.1', 267 => '2.1', 271 => '1.1', 272 => '2.2', 273 => '1.1', 276 => '2.2', 277 => '2.1', 278 => '2.5' },
	'focusposition' => { 209 => 0x8, 210 => 0x8, 214 => 0x9, 338 => 0x10, 399 => 0x9bb },
	'focusposition2' => { 406 => [0x29,0x2b,0x2f], 424 => 0x2d, 427 => 0x20 },
	'focusprocess' => { 280 => 0x302 },
	'focusrange' => { 34 => 0x12, 285 => 0x100a },
	'focusrangeindex' => { 329 => '3.1' },
	'focusringrotation' => { 80 => 0x713 },
	'focussetting' => { 380 => 0x6 },
	'focusstatus' => { 387 => 0x19, 388 => 0x53, 389 => 0x53 },
	'focusstepcount' => { 283 => 0x301, 285 => 0x100e },
	'focusstepinfinity' => { 283 => 0x303, 285 => 0x103b },
	'focusstepnear' => { 283 => 0x304, 285 => 0x103c },
	'focustrackinglockon' => { 263 => ['1.5','4.1'], 264 => '1.4', 271 => '0.4', 272 => '3.1', 273 => '0.4', 276 => '1.4' },
	'focuswarning' => { 123 => 0x1301 },
	'foldername' => { 173 => 0x27 },
	'foldernumber' => { 388 => 0x9a, 390 => [0x402,0x114,0x316] },
	'fontcomposite' => { 487 => [\'Fonts','FontsComposite'] },
	'fontface' => { 487 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 487 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 487 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 487 => [\'Fonts','FontsFontName'] },
	'fonts' => { 487 => 'Fonts' },
	'fonttype' => { 487 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 487 => [\'Fonts','FontsVersionString'] },
	'for' => { 354 => 'For' },
	'forcewrite' => { 116 => 'ForceWrite' },
	'format' => { 363 => "\xa9fmt", 441 => 'Format', 459 => 'format', 480 => 'Format' },
	'forwardlock' => { 477 => 'forwardlock' },
	'forwardmatrix1' => { 115 => 0xc714 },
	'forwardmatrix2' => { 115 => 0xc715 },
	'fossilspecimen' => { 114 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 114 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 64 => [0x2,0x4] },
	'frameheight' => { 123 => 0x3822 },
	'framenum' => { 349 => 0xd7 },
	'framenumber' => { 123 => 0x8003, 179 => 0x3c, 338 => 0x29 },
	'framerate' => { 64 => [0x1,0x6], 115 => 0xc764, 123 => 0x3820 },
	'framereadouttime' => { 357 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 123 => 0x3821 },
	'framing' => { 471 => 'framing' },
	'freebytes' => { 93 => 0x1 },
	'freememorycardimages' => { 174 => [0x37,0x54], 175 => [0x2d,0x4a], 176 => 0x32 },
	'fujiflashmode' => { 123 => 0x1010 },
	'fullhdhighspeedrec' => { 123 => 0x3824 },
	'fullimagesize' => { 401 => 0xb02b },
	'fullpanoheightpixels' => { 444 => 'FullPanoHeightPixels', 445 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 444 => 'FullPanoWidthPixels', 445 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 370 => 0x100d },
	'fullsizeimage' => { 155 => 'data' },
	'fullsizeimagename' => { 155 => '1Name' },
	'fullsizeimagetype' => { 155 => '0Type' },
	'func1button' => { 266 => '14.1', 267 => '14.1', 277 => '14.1' },
	'func1buttonplusdials' => { 266 => '42.1', 267 => '42.1', 277 => '42.1' },
	'func2button' => { 266 => '80.1', 267 => '80.1', 277 => '80.1' },
	'func2buttonplusdials' => { 266 => '81.1' },
	'func3button' => { 266 => '83.1' },
	'funcbutton' => { 263 => ['14.1','15.1'], 264 => '14.1', 272 => '28.1', 273 => '13.1', 276 => '14.1', 278 => '14.1' },
	'funcbuttonplusdials' => { 263 => ['14.2','15.2'], 264 => '14.2', 272 => '31.1', 276 => '42.1' },
	'functionbutton' => { 270 => '13.1', 274 => '5.2' },
	'gainbase' => { 284 => 0x610 },
	'gaincontrol' => { 115 => 0xa407, 462 => 'GainControl' },
	'gamma' => { 115 => 0xa500, 133 => 0x8fe, 308 => 0x11c, 463 => 'Gamma' },
	'gammablackpoint' => { 101 => 0xc },
	'gammacolortone' => { 101 => 0x3 },
	'gammacompensatedvalue' => { 129 => 0x91 },
	'gammacontrast' => { 101 => 0x2 },
	'gammacurveoutputrange' => { 101 => 0xf },
	'gammahighlight' => { 101 => 0xa },
	'gammalinear' => { 99 => 0x20200 },
	'gammamidpoint' => { 101 => 0xe },
	'gammasaturation' => { 101 => 0x4 },
	'gammashadow' => { 101 => 0x9 },
	'gammasharpnessstrength' => { 101 => 0x8 },
	'gammaunsharpmaskfineness' => { 101 => 0x6 },
	'gammaunsharpmaskstrength' => { 101 => 0x5 },
	'gammaunsharpmaskthreshold' => { 101 => 0x7 },
	'gammawhitepoint' => { 101 => 0xd },
	'gdalmetadata' => { 115 => 0xa480 },
	'gdalnodata' => { 115 => 0xa481 },
	'geimagesize' => { 123 => 0x1304 },
	'gemake' => { 125 => 0x300 },
	'gemodel' => { 125 => 0x207 },
	'genre' => { 355 => ['gnre',"\xa9gen"], 357 => 'genre', 363 => ['gnre',"\xa9gen"], 468 => 'Genre', 472 => 'genre', 482 => 'genre' },
	'genrecvid' => { 468 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 468 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 468 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 468 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 355 => 'geID' },
	'geography' => { 473 => 'geography' },
	'geologicalcontext' => { 114 => 'GeologicalContext' },
	'geologicalcontextbed' => { 114 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 114 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 114 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 114 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 114 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 116 => 'Geosync' },
	'geotag' => { 116 => 'Geotag' },
	'geotiffasciiparams' => { 115 => 0x87b1 },
	'geotiffdirectory' => { 115 => 0x87af },
	'geotiffdoubleparams' => { 115 => 0x87b0 },
	'geotime' => { 116 => 'Geotime' },
	'giftftppriority' => { 446 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 112 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 112 => 'GimbalReverse' },
	'gimbalrolldegree' => { 112 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 112 => 'GimbalYawDegree' },
	'globalaltitude' => { 352 => 0x419 },
	'globalangle' => { 352 => 0x40d },
	'good' => { 482 => 'good' },
	'googlehostheader' => { 355 => 'gshh' },
	'googlepingmessage' => { 355 => 'gspm' },
	'googlepingurl' => { 355 => 'gspu' },
	'googleplusuploadcode' => { 115 => 0x9009 },
	'googlesourcedata' => { 355 => 'gssd' },
	'googlestarttime' => { 355 => 'gsst' },
	'googletrackduration' => { 355 => 'gstd' },
	'goprotype' => { 363 => 'GoPr' },
	'gpsaltitude' => { 126 => 0x6, 153 => 'Altitude', 462 => 'GPSAltitude' },
	'gpsaltituderef' => { 126 => 0x5, 462 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 126 => 0x1c, 462 => 'GPSAreaInformation' },
	'gpscoordinates' => { 357 => 'location.ISO6709', 363 => "\xa9xyz" },
	'gpsdatestamp' => { 126 => 0x1d },
	'gpsdatetime' => { 153 => 'DateTime', 462 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 126 => 0x18, 153 => 'Bearing', 462 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 126 => 0x17, 462 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 126 => 0x1a, 153 => 'Distance', 462 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 126 => 0x19, 462 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 126 => 0x14, 462 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 126 => 0x13 },
	'gpsdestlongitude' => { 126 => 0x16, 462 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 126 => 0x15 },
	'gpsdifferential' => { 126 => 0x1e, 153 => 'Differential', 462 => 'GPSDifferential' },
	'gpsdop' => { 126 => 0xb, 462 => 'GPSDOP' },
	'gpshpositioningerror' => { 126 => 0x1f, 462 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 126 => 0x11, 462 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 126 => 0x10, 462 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 112 => 'GpsLatitude', 126 => 0x2, 153 => 'Latitude', 462 => 'GPSLatitude' },
	'gpslatituderef' => { 126 => 0x1 },
	'gpslongitude' => { 112 => 'GpsLongitude', 126 => 0x4, 153 => 'Longitude', 462 => 'GPSLongitude' },
	'gpslongituderef' => { 126 => 0x3 },
	'gpslongtitude' => { 112 => 'GpsLongtitude' },
	'gpsmapdatum' => { 126 => 0x12, 153 => 'Datum', 462 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 126 => 0xa, 153 => 'MeasureMode', 462 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 126 => 0x1b, 462 => 'GPSProcessingMethod' },
	'gpssatellites' => { 126 => 0x8, 153 => 'Satellites', 462 => 'GPSSatellites' },
	'gpsspeed' => { 126 => 0xd, 153 => 'Speed', 462 => 'GPSSpeed' },
	'gpsspeedref' => { 126 => 0xc, 462 => 'GPSSpeedRef' },
	'gpsstatus' => { 126 => 0x9, 462 => 'GPSStatus' },
	'gpsstring' => { 133 => 0x402 },
	'gpstimestamp' => { 126 => 0x7 },
	'gpstrack' => { 126 => 0xf, 153 => 'Heading', 462 => 'GPSTrack' },
	'gpstrackref' => { 126 => 0xe, 462 => 'GPSTrackRef' },
	'gpsversionid' => { 126 => 0x0, 462 => 'GPSVersionID' },
	'gradation' => { 280 => 0x50f },
	'gradientbasedcorractive' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 456 => 'GradientBasedCorrections', 458 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 458 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 456 => 'GrainAmount', 458 => 'GrainAmount' },
	'graineffect' => { 123 => 0x1047 },
	'grainfrequency' => { 456 => 'GrainFrequency', 458 => 'GrainFrequency' },
	'grainsize' => { 456 => 'GrainSize', 458 => 'GrainSize' },
	'graymixeraqua' => { 456 => 'GrayMixerAqua', 458 => 'GrayMixerAqua' },
	'graymixerblue' => { 456 => 'GrayMixerBlue', 458 => 'GrayMixerBlue' },
	'graymixergreen' => { 456 => 'GrayMixerGreen', 458 => 'GrayMixerGreen' },
	'graymixermagenta' => { 456 => 'GrayMixerMagenta', 458 => 'GrayMixerMagenta' },
	'graymixerorange' => { 456 => 'GrayMixerOrange', 458 => 'GrayMixerOrange' },
	'graymixerpurple' => { 456 => 'GrayMixerPurple', 458 => 'GrayMixerPurple' },
	'graymixerred' => { 456 => 'GrayMixerRed', 458 => 'GrayMixerRed' },
	'graymixeryellow' => { 456 => 'GrayMixerYellow', 458 => 'GrayMixerYellow' },
	'graypoint' => { 434 => 0x8021 },
	'grayresponseunit' => { 115 => 0x122 },
	'greencurvelimits' => { 104 => 0x1c4 },
	'greencurvepoints' => { 103 => 0x53, 104 => 0x19a },
	'greenhsl' => { 99 => 0x20913 },
	'greenhue' => { 456 => 'GreenHue', 458 => 'GreenHue' },
	'greensaturation' => { 456 => 'GreenSaturation', 458 => 'GreenSaturation' },
	'griddisplay' => { 263 => '13.3', 264 => '4.3', 266 => '4.2', 267 => '4.2', 268 => '2.2', 272 => '10.5', 273 => '3.4', 274 => '6.1', 276 => '4.4', 277 => '4.2', 278 => '4.2' },
	'gripbatteryadload' => { 317 => 0x5 },
	'gripbatteryadnoload' => { 317 => 0x4 },
	'gripbatterystate' => { 317 => '1.2' },
	'groupareaafillumination' => { 264 => '46.4', 267 => '47.4', 276 => '47.4' },
	'grouping' => { 355 => ['grup',"\xa9grp"], 363 => "\xa9grp" },
	'guid' => { 355 => 'GUID' },
	'h2resetblackpixels' => { 133 => 0x18a6 },
	'h3resetblackcolumns' => { 133 => 0x18ce },
	'h3resetblackpixels' => { 133 => 0x18b0 },
	'halftonehints' => { 115 => 0x141 },
	'hardlink' => { 116 => 'HardLink' },
	'hasalternative' => { 472 => 'hasAlternative' },
	'hascorrection' => { 472 => 'hasCorrection' },
	'hascorrectiona-lang' => { 472 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 472 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 472 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 456 => 'HasCrop', 458 => 'HasCrop' },
	'hasextendedxmp' => { 484 => 'HasExtendedXMP' },
	'hassettings' => { 456 => 'HasSettings', 458 => 'HasSettings' },
	'hastranslation' => { 472 => 'hasTranslation' },
	'hasvisibleoverprint' => { 487 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 487 => 'HasVisibleTransparency' },
	'hdr' => { 58 => 0x1, 206 => 0x4, 303 => 0x9e, 338 => 0x85, 401 => 0x200a },
	'hdreffect' => { 58 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 206 => 0x0 },
	'hdrlevel' => { 206 => 0x5, 390 => 0x2e, 406 => 0x17 },
	'hdrlevel2' => { 206 => 0x7 },
	'hdrpmakernote' => { 439 => 'hdrp_makernote' },
	'hdrsetting' => { 390 => 0x2d, 406 => 0x16, 409 => 0x1148, 410 => 0x1148, 411 => 0x1124, 412 => 0x11a0, 413 => 0x117c, 414 => 0x1034, 415 => 0x22c, 416 => 0x22c, 417 => 0x21f },
	'hdrshot' => { 303 => 0x76 },
	'hdrsmoothing' => { 206 => 0x6 },
	'hdvideo' => { 355 => 'hdvd' },
	'headline' => { 127 => 0x69, 468 => 'Headline', 470 => 'Headline' },
	'hierarchicalkeywords' => { 164 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 164 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 164 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 164 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 164 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 164 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 164 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 448 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 114 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 308 => 0x1a },
	'highisomultipliergreen' => { 308 => 0x19 },
	'highisomultiplierred' => { 308 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 60 => 0x5, 80 => 0x202, 216 => 0xb1, 338 => 0x71, 388 => 0x2c, 389 => 0x26, 390 => 0x26, 401 => 0x2009, 406 => 0x12, 430 => 0x42 },
	'highisonoisereduction2' => { 401 => 0xb050 },
	'highlight' => { 380 => 0xf },
	'highlight2012' => { 456 => 'Highlight2012', 458 => 'Highlight2012' },
	'highlightadj' => { 99 => 0x2030c },
	'highlightcolordistortreduct' => { 434 => 0x8026 },
	'highlightlinearitylimit' => { 377 => 0xa025 },
	'highlightprotection' => { 255 => 0x6 },
	'highlightrecovery' => { 456 => 'HighlightRecovery', 458 => 'HighlightRecovery' },
	'highlights' => { 450 => 'Highlights' },
	'highlights2012' => { 456 => 'Highlights2012', 458 => 'Highlights2012' },
	'highlightsadj' => { 434 => 0x9019 },
	'highlightshadow' => { 303 => 0xad },
	'highlighttone' => { 123 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 60 => 0x3, 80 => 0x203 },
	'highlightwarning' => { 303 => 0x8002 },
	'highlowkeyadj' => { 338 => 0x6c },
	'highspeedsync' => { 176 => 0x5, 388 => 0x2, 389 => 0x2 },
	'hintversion' => { 363 => 'hinv' },
	'histogramxml' => { 256 => 0x83a1a25 },
	'history' => { 470 => 'History', 483 => 'History' },
	'historyaction' => { 483 => [\'History','HistoryAction'] },
	'historychanged' => { 483 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 483 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 483 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 483 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 483 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 133 => 0xc88 },
	'holefilldeltathreshold' => { 133 => 0xc7e },
	'hometowncity' => { 109 => 0x3006, 338 => 0x23, 344 => 0x2 },
	'hometowncitycode' => { 345 => 0x1000 },
	'hometowndst' => { 338 => 0x25, 344 => '0.2' },
	'hostcomputer' => { 115 => 0x13c },
	'hostsoftwarerendering' => { 133 => 0xce7 },
	'hue' => { 181 => 0x3b, 219 => 0x3d, 220 => 0x45, 338 => 0x67 },
	'hueadj' => { 259 => 0x2f, 434 => 0x8019 },
	'hueadjust' => { 370 => 0x1016 },
	'hueadjustment' => { 174 => 0x4a, 175 => 0x40, 216 => 0x92, 218 => 0x36 },
	'hueadjustmentaqua' => { 456 => 'HueAdjustmentAqua', 458 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 456 => 'HueAdjustmentBlue', 458 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 456 => 'HueAdjustmentGreen', 458 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 456 => 'HueAdjustmentMagenta', 458 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 456 => 'HueAdjustmentOrange', 458 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 456 => 'HueAdjustmentPurple', 458 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 456 => 'HueAdjustmentRed', 458 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 456 => 'HueAdjustmentYellow', 458 => 'HueAdjustmentYellow' },
	'huesetting' => { 288 => 0x1011 },
	'humanobservation' => { 114 => 'HumanObservation' },
	'humanobservationday' => { 114 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 114 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 114 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 114 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 114 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 114 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 114 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 114 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 114 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 114 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 114 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 114 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 114 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 114 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 114 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 114 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 114 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 114 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 114 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 114 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 115 => 0x9401, 463 => 'Humidity' },
	'icc_profile' => { 116 => 'ICC_Profile' },
	'iccprofilename' => { 470 => 'ICCProfile' },
	'iconuri' => { 363 => 'icnu' },
	'idccreativestyle' => { 434 => 0x8000 },
	'idcpreviewlength' => { 434 => 0x202 },
	'idcpreviewstart' => { 434 => 0x201 },
	'identification' => { 114 => 'Identification' },
	'identificationid' => { 114 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 114 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 114 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 114 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 114 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 114 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 459 => 'identifier', 480 => 'Identifier' },
	'ifcameramodel' => { 133 => 0x9c8 },
	'illumination' => { 274 => '0.5', 365 => 0x48 },
	'imageabsolutex' => { 133 => 0x3fe },
	'imageabsolutey' => { 133 => 0x3ff },
	'imageadjustment' => { 216 => 0x80, 246 => 0x5 },
	'imagealterationconstraints' => { 290 => 'ImageAlterationConstraints' },
	'imagearea' => { 229 => 0x10, 232 => 0x10 },
	'imageareaoffset' => { 338 => 0x38 },
	'imageauthentication' => { 216 => 0x20 },
	'imageboundary' => { 216 => 0x16 },
	'imagecount' => { 123 => 0x1438, 216 => 0xa5, 404 => 0x11b },
	'imagecreator' => { 290 => 'ImageCreator' },
	'imagecreatorid' => { 290 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 290 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 290 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 133 => 0x41f },
	'imagecropy' => { 133 => 0x420 },
	'imagedata' => { 443 => 'Data' },
	'imagedatasize' => { 216 => 0xa2 },
	'imagedescription' => { 115 => 0x10e, 478 => 'ImageDescription' },
	'imageduplicationconstraints' => { 290 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 256 => 0xfe443a45 },
	'imageeditcount' => { 338 => 0x41 },
	'imageediting' => { 338 => 0x32 },
	'imageeffects' => { 370 => 0x1010 },
	'imagefileconstraints' => { 290 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 290 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 290 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 123 => 0x1436 },
	'imageheight' => { 115 => 0x101, 180 => 0xc, 347 => 0x10d, 441 => 'ImageHeight', 478 => 'ImageLength' },
	'imagehistory' => { 115 => 0x9213, 461 => 'ImageHistory' },
	'imageidnumber' => { 298 => 0x340 },
	'imagemimetype' => { 443 => 'Mime' },
	'imagenumber' => { 115 => 0x9211, 149 => 'ImageNumber', 174 => 0xae, 175 => 0x5e, 347 => 0x113, 388 => 0x9b, 390 => [0x400,'276.1',0x314], 453 => 'ImageNumber' },
	'imagenumber2' => { 175 => 0x62 },
	'imageoptimization' => { 216 => 0xa9 },
	'imageorientation' => { 127 => 0x83 },
	'imageprocessing' => { 216 => 0x1a },
	'imageprocessingfiledatecreated' => { 133 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 133 => 0xc80 },
	'imageprocessingversion' => { 284 => 0x0 },
	'imagequality' => { 149 => 'ImageQuality', 231 => '723.2', 232 => '732.2', 241 => '708.1', 303 => 0x1 },
	'imagequality2' => { 280 => 0x603 },
	'imagerank' => { 446 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 133 => 0x600 },
	'imagerboardversion' => { 133 => 0x439 },
	'imagercols' => { 133 => 0x17d4 },
	'imageref' => { 466 => 'ImageRef' },
	'imageregion' => { 468 => 'ImageRegion' },
	'imageregionboundary' => { 468 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 468 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 468 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 468 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 468 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 468 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 468 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 468 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 468 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 468 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 133 => 0x944 },
	'imageresolutionjpg' => { 133 => 0x945 },
	'imagereview' => { 265 => '0.4', 274 => '0.4' },
	'imagereviewmonitorofftime' => { 264 => '21.1', 266 => '21.1', 267 => '21.1', 271 => '20.1', 276 => '21.1', 277 => '21.1' },
	'imagereviewtime' => { 263 => '25.1', 265 => '2.1', 268 => '19.1', 269 => '20.1', 270 => '20.1', 272 => '9.2', 273 => '20.1', 278 => '21.2' },
	'imagerfiledatecreated' => { 133 => 0x9c5 },
	'imagerfileproductionlevel' => { 133 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 133 => 0x9c7 },
	'imagerpowerondelaymsec' => { 133 => 0x5fd },
	'imagerrows' => { 133 => 0x17de },
	'imagesegmentlines' => { 133 => 0x184d },
	'imagesegmentstartline' => { 133 => 0x184c },
	'imagesize' => { 155 => 'ImageSize' },
	'imagesizerestriction' => { 475 => 'imageSizeRestriction' },
	'imagesourcedata' => { 115 => 0x935c },
	'imagespace' => { 133 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 109 => 0x3020, 123 => 0x1422, 149 => 'ImageStabilization', 174 => 0xbd, 175 => 0x71, 176 => 0x57, 177 => 0x0, 178 => [0x18,0x107,0x113], 179 => 0x49c2, 216 => 0xac, 280 => 0x604, 283 => 0x1600, 303 => 0x1a, 393 => 0x12, 394 => 0x11, 401 => 0xb026 },
	'imagestabilization2' => { 392 => 0xa },
	'imagestabilizationsetting' => { 179 => 0x14, 388 => 0x3d, 389 => 0x3d, 399 => 0x14 },
	'imagestyle' => { 388 => 0x2d, 389 => 0x27 },
	'imagesupplier' => { 290 => 'ImageSupplier' },
	'imagesupplierid' => { 290 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 290 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 290 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 117 => 0x1 },
	'imagetemperaturemin' => { 117 => 0x2 },
	'imagetone' => { 338 => 0x4f },
	'imagetype' => { 127 => 0x82, 290 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 61 => 0x28, 115 => 0xa420, 461 => 'ImageUniqueID', 462 => 'ImageUniqueID' },
	'imagewidth' => { 115 => 0x100, 180 => 0xe, 347 => 0x10c, 441 => 'ImageWidth', 478 => 'ImageWidth' },
	'inclinationangle' => { 434 => 0x900f },
	'inclinationcorrection' => { 434 => 0x900e },
	'incrementaltemperature' => { 456 => 'IncrementalTemperature', 458 => 'IncrementalTemperature' },
	'incrementaltint' => { 456 => 'IncrementalTint', 458 => 'IncrementalTint' },
	'industry' => { 472 => 'industry', 473 => 'industry' },
	'infobuttonwhenshooting' => { 80 => 0x409 },
	'information' => { 357 => 'information', 363 => "\xa9inf" },
	'infourl' => { 363 => 'infu' },
	'infraredilluminator' => { 364 => 0x28 },
	'ingredientexclusion' => { 474 => 'ingredientExclusion' },
	'ingredients' => { 483 => 'Ingredients' },
	'ingredientsalternatepaths' => { 483 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 483 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 483 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 483 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 483 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 483 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 483 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 483 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 483 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 483 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 483 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 483 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 483 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 483 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 483 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 483 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 483 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 483 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 483 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 483 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 483 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 483 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 483 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 80 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 444 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 444 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 444 => 'InitialViewHeadingDegrees', 445 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 444 => 'InitialViewPitchDegrees', 445 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 444 => 'InitialViewRollDegrees', 445 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 263 => '4.4' },
	'initialzoomsetting' => { 263 => '9.3', 272 => '27.3' },
	'inkset' => { 115 => 0x14c },
	'inputprofile' => { 133 => 0x1389 },
	'instanceid' => { 483 => 'InstanceID' },
	'instantplaybacksetup' => { 176 => 0x3e },
	'instantplaybacktime' => { 176 => 0x3d },
	'instructions' => { 470 => 'Instructions' },
	'instrument' => { 482 => 'instrument' },
	'integrationtime' => { 133 => 0x423 },
	'intellectualgenre' => { 467 => 'IntellectualGenre' },
	'intelligentauto' => { 401 => 0xb052, 426 => 0xd, 427 => 0xe, 428 => 0xd },
	'intelligentcontrast' => { 50 => 0x4 },
	'intelligentd-range' => { 303 => 0x79 },
	'intelligentexposure' => { 303 => 0x5d },
	'intelligentresolution' => { 303 => 0x70 },
	'interchangecolorspace' => { 129 => 0x40 },
	'intergraphmatrix' => { 115 => 0x8480 },
	'internalflash' => { 173 => 0x2b, 263 => '23.1', 265 => '8.1', 268 => '22.1', 270 => '23.1', 274 => '8.1', 278 => '24.1', 283 => 0x1208 },
	'internalflashae1' => { 285 => 0x1021 },
	'internalflashae1_0' => { 285 => 0x101d },
	'internalflashae2' => { 285 => 0x1022 },
	'internalflashae2_0' => { 285 => 0x101e },
	'internalflashmode' => { 326 => 0x1 },
	'internalflashstrength' => { 326 => 0x3 },
	'internalflashtable' => { 285 => 0x1024 },
	'internallensserialnumber' => { 377 => 0xa005 },
	'internalndfilter' => { 303 => 0x9d },
	'internalserialnumber' => { 61 => 0x96, 73 => 0x9, 123 => 0x10, 179 => 0x49dc, 279 => 0x18, 281 => 0x102, 300 => 0x500, 303 => 0x25, 318 => 0x4, 370 => 0x5, 419 => [0x7c,0xf0], 420 => 0x88 },
	'interopindex' => { 115 => 0x1, 463 => 'InteroperabilityIndex' },
	'interopversion' => { 115 => 0x2 },
	'intervallength' => { 173 => 0x10 },
	'intervalmode' => { 173 => 0x26 },
	'intervalnumber' => { 173 => 0x11 },
	'intervalshooting' => { 338 => 0x92 },
	'introtime' => { 482 => 'introTime' },
	'introtimescale' => { 482 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 482 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 133 => 0xdae },
	'ipfcameramodel' => { 133 => 0xe4d },
	'iptc' => { 116 => 'IPTC' },
	'iptc-naa' => { 115 => 0x83bb, 308 => 0x83bb },
	'iptcbitspersample' => { 129 => 0x56 },
	'iptcdigest' => { 352 => 0x425 },
	'iptcimageheight' => { 129 => 0x1e },
	'iptcimagerotation' => { 129 => 0x66 },
	'iptcimagewidth' => { 129 => 0x14 },
	'iptclastedited' => { 468 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 129 => 0xa },
	'iptcpixelheight' => { 129 => 0x32 },
	'iptcpixelwidth' => { 129 => 0x28 },
	'isalternativeof' => { 472 => 'isAlternativeOf' },
	'isbn' => { 472 => 'isbn' },
	'iscorrectionof' => { 472 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 105 => 0x3 },
	'ismergedhdr' => { 453 => 'IsMergedHDR' },
	'ismergedpanorama' => { 453 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 108 => 0x14, 109 => [0x3014,0x14], 115 => 0x8827, 132 => 0xfd06, 133 => 0x1784, 135 => 0x60, 137 => [0xfa2e,0xfa46], 138 => [0x27,0x28], 139 => 0xf105, 142 => 0x14, 144 => 0x4e, 147 => 0x34, 149 => 'ISO', 173 => 0x8, 179 => 0x49ba, 207 => 0x0, 216 => 0x2, 303 => 0xd1, 308 => 0x17, 338 => [0x8b,0x14], 345 => 0x14, 347 => 0x105, 377 => 0xa014, 380 => 0x86, 399 => 0x6f, 406 => [0x1f,0x21,0x25], 462 => 'ISOSpeedRatings' },
	'iso2' => { 207 => 0x6, 226 => 0x265, 227 => 0x25c, 228 => 0x265, 229 => 0x221, 230 => 0x25d, 231 => 0x256, 232 => 0x25d, 236 => 0x2b5, 239 => 0x265, 245 => 0x2b5 },
	'isoauto' => { 319 => '14.4' },
	'isoautohilimit' => { 234 => 0x18eb, 235 => 0xe82, 243 => 0x185d },
	'isoautomax' => { 400 => 0x4 },
	'isoautomin' => { 400 => 0x2 },
	'isoautoparameters' => { 338 => 0x7a },
	'isoautoshuttertime' => { 234 => 0x18ea, 235 => 0xe81, 243 => 0x185c },
	'isocalibrationgain' => { 133 => 0x89f },
	'isodisplay' => { 266 => '4.1', 267 => '4.1', 268 => '2.3', 269 => '3.3', 270 => '3.3', 273 => '3.3', 276 => '4.3', 277 => '4.1', 278 => '4.3' },
	'isoexpansion' => { 80 => 0x103, 81 => 0x7, 82 => 0x8, 85 => 0x8, 207 => 0x4 },
	'isoexpansion2' => { 207 => 0xa },
	'isofloor' => { 319 => 0x6 },
	'isoselection' => { 216 => 0xf },
	'isosensitivitystep' => { 271 => '6.2', 273 => '6.2' },
	'isosetting' => { 135 => 0x5e, 149 => 'ISOSetting', 173 => 0x24, 174 => 0x26, 175 => 0x1c, 176 => 0x13, 181 => 0x6, 216 => 0x13, 319 => '17.3', 369 => 0x27, 388 => 0x16, 389 => 0x14, 390 => 0x2, 399 => 0x6d, 400 => 0x0 },
	'isospeed' => { 115 => 0x8833, 463 => 'ISOSpeed' },
	'isospeedexpansion' => { 79 => 0x3 },
	'isospeedincrements' => { 80 => 0x102 },
	'isospeedlatitudeyyy' => { 115 => 0x8834, 463 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 115 => 0x8835, 463 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 80 => 0x103 },
	'isostepsize' => { 263 => '6.1', 264 => '7.2', 266 => '7.2', 267 => '7.2', 272 => '4.1', 276 => '7.2', 277 => '7.2' },
	'isovalue' => { 285 => 0x1001 },
	'isrccode' => { 363 => "\xa9isr" },
	'issn' => { 472 => 'issn' },
	'issueidentifier' => { 472 => 'issueIdentifier' },
	'issuename' => { 472 => 'issueName' },
	'issueteaser' => { 472 => 'issueTeaser' },
	'issuetype' => { 472 => 'issueType' },
	'istranslationof' => { 472 => 'isTranslationOf' },
	'itemsubtype' => { 171 => 'ItemSubType' },
	'itunesu' => { 355 => 'itnu' },
	'jobid' => { 127 => 0xb8 },
	'jobname' => { 464 => 'JobName' },
	'jobref' => { 481 => 'JobRef' },
	'jobrefid' => { 481 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 481 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 481 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 464 => 'JobStatus' },
	'jpeghandling' => { 456 => 'JPEGHandling', 458 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 303 => 0x43, 305 => 0x3034, 401 => 0xb047 },
	'jpegsize' => { 305 => 0x303a },
	'jpgcompression' => { 235 => 0x7d4 },
	'jpgfromraw' => { 93 => 0x2007, 110 => 'Exif::JpgFromRaw', 308 => 0x2e },
	'jpgfromrawlength' => { 115 => [0x117,0x202] },
	'jpgfromrawstart' => { 115 => [0x111,0x201] },
	'jpgrecordedpixels' => { 319 => '14.1' },
	'jurisdiction' => { 454 => 'jurisdiction' },
	'kelvinwb_01' => { 327 => 0x5 },
	'kelvinwb_02' => { 327 => 0x9 },
	'kelvinwb_03' => { 327 => 0xd },
	'kelvinwb_04' => { 327 => 0x11 },
	'kelvinwb_05' => { 327 => 0x15 },
	'kelvinwb_06' => { 327 => 0x19 },
	'kelvinwb_07' => { 327 => 0x1d },
	'kelvinwb_08' => { 327 => 0x21 },
	'kelvinwb_09' => { 327 => 0x25 },
	'kelvinwb_10' => { 327 => 0x29 },
	'kelvinwb_11' => { 327 => 0x2d },
	'kelvinwb_12' => { 327 => 0x31 },
	'kelvinwb_13' => { 327 => 0x35 },
	'kelvinwb_14' => { 327 => 0x39 },
	'kelvinwb_15' => { 327 => 0x3d },
	'kelvinwb_16' => { 327 => 0x41 },
	'kelvinwb_daylight' => { 327 => 0x1 },
	'kerneldenominators' => { 133 => 0x933 },
	'key' => { 482 => 'key' },
	'keystonecompensation' => { 284 => 0x1900 },
	'keystonedirection' => { 284 => 0x1901 },
	'keystonevalue' => { 284 => 0x1906 },
	'keyword' => { 355 => 'keyw', 472 => 'keyword' },
	'keywordinfo' => { 164 => 'Keywords' },
	'keywords' => { 127 => 0x19, 150 => 'Keywords', 289 => 'Keywords', 354 => 'Keywords', 357 => 'keywords', 451 => 'keywords', 469 => 'Keywords', 480 => 'Keywords' },
	'killdate' => { 472 => 'killDate' },
	'killdatea-platform' => { 472 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 472 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 132 => 0xf908, 135 => 0xe, 137 => [0xfa1e,0xfa52], 143 => 0x70 },
	'kodakimagewidth' => { 132 => 0xf907, 135 => 0xc, 137 => [0xfa1d,0xfa51], 143 => 0x6c },
	'kodakinfotype' => { 132 => 0xfa00 },
	'kodaklook' => { 133 => 0xe4c },
	'kodaklookprofile' => { 133 => 0x138a },
	'kodakmaker' => { 143 => 0x8 },
	'kodakmodel' => { 135 => 0x0, 143 => 0x28 },
	'kodaktag' => { 133 => 0x3ea },
	'kodakversion' => { 133 => 0x0 },
	'label' => { 293 => 'Label', 480 => 'Label' },
	'labelname1' => { 466 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 466 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 303 => 0x6f },
	'landscapeoutputhighlightpoint' => { 105 => 0x26 },
	'landscapeoutputshadowpoint' => { 105 => 0x27 },
	'landscaperawcolortone' => { 105 => 0x1f },
	'landscaperawcontrast' => { 105 => 0x21 },
	'landscaperawhighlight' => { 105 => 0x77 },
	'landscaperawhighlightpoint' => { 105 => 0x24 },
	'landscaperawlinear' => { 105 => 0x22 },
	'landscaperawsaturation' => { 105 => 0x20 },
	'landscaperawshadow' => { 105 => 0x80 },
	'landscaperawshadowpoint' => { 105 => 0x25 },
	'landscaperawsharpness' => { 105 => 0x23 },
	'landscapeunsharpmaskfineness' => { 105 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 105 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 105 => 0xa2 },
	'language' => { 459 => 'language' },
	'languageidentifier' => { 127 => 0x87 },
	'largestvalidinteriorrectheight' => { 444 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 444 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 444 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 444 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 173 => 0x1b },
	'lastkeywordiptc' => { 171 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 171 => 'LastKeywordXMP' },
	'lastphotodate' => { 444 => 'LastPhotoDate' },
	'lasturl' => { 483 => 'LastURL' },
	'lateralchromaticaberration' => { 401 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 453 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 114 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 114 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 114 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 114 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 114 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 112 => 'Latitude' },
	'lc1' => { 329 => 0x2 },
	'lc10' => { 329 => 0xb },
	'lc11' => { 329 => 0xc },
	'lc12' => { 329 => 0xd },
	'lc14' => { 329 => 0xf },
	'lc15' => { 329 => 0x10 },
	'lc3' => { 329 => 0x4 },
	'lc4' => { 329 => 0x5 },
	'lc5' => { 329 => 0x6 },
	'lc6' => { 329 => 0x7 },
	'lc7' => { 329 => 0x8 },
	'lc8' => { 329 => 0x9 },
	'lcddisplayatpoweron' => { 80 => 0x811, 84 => 0xa },
	'lcddisplayreturntoshoot' => { 85 => 0x12 },
	'lcdillumination' => { 263 => '17.5', 264 => '5.2', 266 => '5.1', 267 => '5.1', 272 => '10.3', 273 => '4.2', 276 => '5.2', 277 => '5.1', 278 => '5.4' },
	'lcdilluminationduringbulb' => { 80 => 0x408 },
	'lcdmatrix' => { 133 => 0xe74 },
	'lcdmatrixchickfix' => { 133 => 0xe75 },
	'lcdmatrixmarvin' => { 133 => 0xe76 },
	'lcdpanels' => { 79 => 0x8 },
	'lcheditor' => { 256 => 0x8ae85e },
	'legacyiptcdigest' => { 470 => 'LegacyIPTCDigest' },
	'legalcode' => { 454 => 'legalcode' },
	'lens' => { 115 => 0xfdea, 216 => 0x84, 453 => 'Lens' },
	'lensafstopbutton' => { 78 => 0x11, 79 => 0x13, 80 => 0x506, 81 => 0x10, 82 => 0x12, 85 => 0x13, 86 => 0x9 },
	'lensaperturerange' => { 380 => [0x30,0x48] },
	'lenscorrectionsettings' => { 461 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 453 => 'LensDistortInfo' },
	'lensdistortionparams' => { 285 => 0x206 },
	'lensdrivenoaf' => { 80 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 390 => 0x3f0, 433 => 0xd },
	'lensfirmware' => { 371 => 0x20, 377 => 0xa004 },
	'lensfirmwareversion' => { 281 => 0x204, 303 => 0x60, 390 => 0x3f3, 433 => 0x14 },
	'lensfocallength' => { 99 => 0xf0512, 329 => 0x9 },
	'lensfocalrange' => { 380 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 264 => '55.1', 266 => '52.1', 267 => '52.1', 276 => '52.1', 277 => '52.1' },
	'lensformat' => { 413 => 0x1891, 415 => 0x18bd, 416 => 0x18ed, 417 => 0x17f1, 419 => 0x106, 420 => 0x106, 429 => 0x603, 430 => 0x5d },
	'lensfstops' => { 208 => 0x7, 209 => 0xc, 210 => 0xd, 214 => 0xe, 216 => 0x8b, 329 => '0.3' },
	'lensid' => { 214 => 0x30, 453 => 'LensID' },
	'lensidnumber' => { 208 => 0x6, 209 => 0xb, 210 => 0xc, 214 => 0xd },
	'lensinfo' => { 115 => 0xa432, 335 => 0x2a, 453 => 'LensInfo', 463 => 'LensSpecification' },
	'lenskind' => { 329 => 0x1 },
	'lensmake' => { 115 => 0xa433, 156 => 'Make', 463 => 'LensMake' },
	'lensmanualdistortionamount' => { 456 => 'LensManualDistortionAmount', 458 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 171 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 380 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 61 => 0x95, 115 => 0xa434, 156 => 'Model', 171 => 'LensModel', 211 => 0x18a, 212 => 0x18b, 213 => 0x2ac, 281 => 0x203, 335 => 0xc, 347 => 0x412, 463 => 'LensModel' },
	'lensmodulationoptimizer' => { 123 => 0x1045 },
	'lensmount' => { 390 => 0x99, 413 => 0x1892, 415 => 0x18be, 416 => 0x18ee, 417 => 0x17f2, 419 => 0x105, 420 => 0x105, 429 => 0x604, 430 => 0x5e },
	'lensmount2' => { 433 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 456 => 'LensProfileChromaticAberrationScale', 458 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 456 => 'LensProfileDigest', 458 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 456 => 'LensProfileDistortionScale', 458 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 456 => 'LensProfileEnable', 458 => 'LensProfileEnable' },
	'lensprofilefilename' => { 456 => 'LensProfileFilename', 458 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 456 => 'LensProfileMatchKeyCameraModelName', 458 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 456 => 'LensProfileMatchKeyExifMake', 458 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 456 => 'LensProfileMatchKeyExifModel', 458 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 456 => 'LensProfileMatchKeyIsRaw', 458 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 456 => 'LensProfileMatchKeyLensID', 458 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 456 => 'LensProfileMatchKeyLensInfo', 458 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 456 => 'LensProfileMatchKeyLensName', 458 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 456 => 'LensProfileMatchKeySensorFormatFactor', 458 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 456 => 'LensProfileName', 458 => 'LensProfileName' },
	'lensprofilesetup' => { 456 => 'LensProfileSetup', 458 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 456 => 'LensProfileVignettingScale', 458 => 'LensProfileVignettingScale' },
	'lensproperties' => { 281 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 59 => 0x0, 115 => 0xa435, 156 => 'SerialNumber', 281 => 0x202, 301 => 0x321, 303 => 0x52, 363 => 'LENS', 371 => 0x30, 453 => 'LensSerialNumber', 463 => 'LensSerialNumber' },
	'lensshutterlock' => { 176 => 0x4a },
	'lensspec' => { 385 => 0x0, 386 => 0x0, 387 => 0x0, 401 => 0xb02a },
	'lensspecfeatures' => { 419 => [0x115,0x116], 420 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 285 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 178 => 0x10c, 179 => 0x49bd, 216 => 0x83, 281 => 0x201, 294 => 0x16, 298 => 0x310, 300 => 0x303, 301 => 0x303, 303 => 0x51, 305 => 0x3405, 330 => 0x0, 331 => 0x0, 332 => 0x1, 333 => 0x1, 334 => 0x1, 336 => 0x0, 377 => 0xa003, 380 => 0x27, 401 => 0xb027, 413 => 0x1896, 415 => 0x18c2, 416 => 0x18f2, 417 => 0x17f6, 419 => 0x109, 420 => 0x109, 429 => 0x608, 430 => 0x62 },
	'lenstype2' => { 390 => 0x3f7, 413 => 0x1893, 415 => 0x18bf, 416 => 0x18ef, 417 => 0x17f3, 419 => 0x107, 420 => 0x107, 429 => 0x605, 430 => 0x60 },
	'lenstype3' => { 433 => 0x9 },
	'lenszoomposition' => { 426 => 0x19, 427 => 0x1e, 430 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 311 => 0x15 },
	'levelmeter' => { 363 => ['Lvlm','lvlm'] },
	'levelorientation' => { 337 => 0x0 },
	'license' => { 454 => 'license' },
	'licensee' => { 290 => 'Licensee' },
	'licenseeid' => { 290 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 290 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 290 => 'LicenseeImageNotes' },
	'licenseename' => { 290 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 290 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 290 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 290 => 'LicenseeTransactionID' },
	'licenseid' => { 290 => 'LicenseID' },
	'licensestartdate' => { 290 => 'LicenseStartDate' },
	'licensetransactiondate' => { 290 => 'LicenseTransactionDate' },
	'licensetype' => { 460 => 'licensetype' },
	'licensor' => { 290 => 'Licensor' },
	'licensorcity' => { 290 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 290 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 290 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 290 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 290 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 290 => 'LicensorImageID' },
	'licensorname' => { 290 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 290 => 'LicensorNotes' },
	'licensorpostalcode' => { 290 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 290 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 290 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 290 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 290 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 290 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 290 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 290 => 'LicensorTransactionID' },
	'licensorurl' => { 290 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 285 => 0x1009 },
	'lightingmode' => { 109 => 0x302a },
	'lightreading' => { 338 => 0x15 },
	'lightsource' => { 115 => 0x9208, 216 => 0x90, 288 => 0x1000, 462 => 'LightSource' },
	'lightsourcespecial' => { 379 => 0x21d },
	'lightswitch' => { 276 => '0.1', 278 => '0.1' },
	'lightvaluecenter' => { 285 => 0x103d },
	'lightvalueperiphery' => { 285 => 0x103e },
	'limitafareamodeselection' => { 264 => '51.1', 266 => '49.1', 267 => '49.1', 276 => '49.1', 277 => '49.1' },
	'linearitylimitblue' => { 308 => 0x10 },
	'linearitylimitgreen' => { 308 => 0xf },
	'linearitylimitred' => { 308 => 0xe },
	'linearityuppermargin' => { 43 => [0x2ba,0x2d1,0x2d5], 45 => 0x1e5, 46 => [0x1fe,0x2de], 47 => [0x232,0x310], 48 => 0x31e },
	'linearizationtable' => { 115 => 0xc618 },
	'linearresponselimit' => { 115 => 0xc62e },
	'link' => { 472 => 'link' },
	'linkaetoafpoint' => { 319 => '14.2' },
	'linkedencodedrightsexpr' => { 468 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 468 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 468 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 468 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 133 => 0x904 },
	'lithostratigraphicterms' => { 114 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 268 => '32.1', 278 => '34.1' },
	'liveviewafareamode' => { 273 => '34.1' },
	'liveviewafmethod' => { 406 => 0x20 },
	'liveviewafmode' => { 273 => '34.2' },
	'liveviewafsetting' => { 390 => 0x36 },
	'liveviewbuttonoptions' => { 264 => '50.2', 266 => '48.2', 267 => '48.2', 276 => '48.2', 277 => '48.2' },
	'liveviewexposuresimulation' => { 80 => 0x810 },
	'liveviewfocusmode' => { 390 => [0x8b,0x28b] },
	'liveviewmetering' => { 390 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 264 => '21.2', 266 => '21.2', 267 => '21.2', 269 => '20.2', 270 => '20.2', 271 => '20.2', 273 => '20.2', 276 => '21.2', 277 => '21.2' },
	'liveviewshooting' => { 55 => 0x13 },
	'livingspecimen' => { 114 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 114 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 127 => 0x79 },
	'localizedcameramodel' => { 115 => 0xc615 },
	'locallocationname' => { 377 => 0x30 },
	'location' => { 215 => 0x9, 303 => 0x67, 449 => 'Location', 467 => 'Location', 471 => 'location', 472 => 'location' },
	'locationareacode' => { 455 => 'lac' },
	'locationbody' => { 357 => 'location.body' },
	'locationcreated' => { 468 => 'LocationCreated' },
	'locationcreatedcity' => { 468 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 468 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 468 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 468 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 468 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 468 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 468 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 468 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 468 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 468 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 468 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 468 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 357 => 'location.date' },
	'locationinfoversion' => { 215 => 0x0 },
	'locationname' => { 357 => 'location.name', 377 => 0x31 },
	'locationnote' => { 357 => 'location.note' },
	'locationrole' => { 357 => 'location.role' },
	'locationshown' => { 468 => 'LocationShown' },
	'locationshowncity' => { 468 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 468 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 468 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 468 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 468 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 468 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 468 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 468 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 468 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 468 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 468 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 468 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 80 => 0x709 },
	'logcomment' => { 482 => 'logComment' },
	'logscale' => { 133 => 0x902 },
	'longdescription' => { 355 => 'ldes' },
	'longexposurenoisereduction' => { 60 => 0x4, 80 => 0x201, 81 => 0x1, 82 => 0x2, 83 => 0x1, 84 => 0x1, 85 => 0x2, 86 => 0x1, 303 => 0x49, 388 => 0x2b, 389 => 0x25, 390 => 0x25, 401 => 0x2008, 406 => 0x11, 430 => 0x44 },
	'longexposurenoisereduction2' => { 55 => 0x8 },
	'longitude' => { 112 => 'Longitude' },
	'loop' => { 482 => 'loop' },
	'loopstyle' => { 363 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 114 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 456 => 'LuminanceAdjustmentAqua', 458 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 456 => 'LuminanceAdjustmentBlue', 458 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 456 => 'LuminanceAdjustmentGreen', 458 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 456 => 'LuminanceAdjustmentMagenta', 458 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 456 => 'LuminanceAdjustmentOrange', 458 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 456 => 'LuminanceAdjustmentPurple', 458 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 456 => 'LuminanceAdjustmentRed', 458 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 456 => 'LuminanceAdjustmentYellow', 458 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 104 => 0x150 },
	'luminancecurvepoints' => { 104 => 0x126 },
	'luminancenoisereduction' => { 99 => 0x20600, 105 => 0x5f, 380 => 0x1b },
	'luminancenoisereductioncontrast' => { 456 => 'LuminanceNoiseReductionContrast', 458 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 456 => 'LuminanceNoiseReductionDetail', 458 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 105 => 0x6d },
	'luminancesmoothing' => { 456 => 'LuminanceSmoothing', 458 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 80 => [0x40b,0x40c] },
	'lyrics' => { 355 => "\xa9lyr", 363 => "\xa9lyr", 482 => 'lyrics' },
	'lyricsuri' => { 363 => 'lrcu' },
	'm16cversion' => { 298 => 0x333 },
	'macatom' => { 457 => 'macAtom' },
	'macatomapplicationcode' => { 457 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 457 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 457 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 114 => 'MachineObservation' },
	'machineobservationday' => { 114 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 114 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 114 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 114 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 114 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 114 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 114 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 114 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 114 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 114 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 114 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 114 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 114 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 114 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 114 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 114 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 114 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 114 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 114 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 114 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 123 => 0x1020, 125 => 0x202, 285 => 0x202, 369 => 0x21, 379 => 0x202, 401 => 0xb040 },
	'macroled' => { 283 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 55 => 0x10 },
	'macromode' => { 34 => 0x1, 173 => 0xb, 280 => 0x300, 303 => 0x1c, 370 => 0x1009 },
	'magentahsl' => { 99 => 0x20917 },
	'magicfilter' => { 280 => 0x52c },
	'magnifiedview' => { 82 => 0x11, 84 => 0x9 },
	'mainboardversion' => { 133 => 0x438 },
	'maindialexposurecomp' => { 274 => '0.6' },
	'mainingredient' => { 474 => 'mainIngredient' },
	'majorversion' => { 447 => 'MajorVersion' },
	'make' => { 94 => 0x0, 111 => 0x1, 115 => 0x10f, 149 => 'Make', 293 => 'Make', 308 => 0x10f, 357 => 'make', 363 => "\xa9mak", 471 => 'make', 478 => 'Make' },
	'makernote' => { 462 => 'MakerNote' },
	'makernoteapple' => { 113 => 'MakN', 115 => 0x927c },
	'makernotecanon' => { 113 => 'MakN', 115 => 0x927c },
	'makernotecasio' => { 113 => 'MakN', 115 => 0x927c },
	'makernotecasio2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotedji' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteflir' => { 113 => 'MakN', 115 => 0x927c },
	'makernotefujifilm' => { 113 => 'MakN', 115 => 0x927c },
	'makernotege' => { 113 => 'MakN', 115 => 0x927c },
	'makernotege2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehasselblad' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotehp6' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteisl' => { 113 => 'MakN', 115 => 0x927c },
	'makernotejvc' => { 113 => 'MakN', 115 => 0x927c },
	'makernotejvctext' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak10' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak11' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak12' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak1a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak1b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak5' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak6a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak6b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak7' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak8a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak8b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak8c' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodak9' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekodakunknown' => { 113 => 'MakN', 115 => 0x927c },
	'makernotekyocera' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica10' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica2' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica3' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica4' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica5' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica6' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica7' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica8' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteleica9' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteminolta' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteminolta2' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteminolta3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotemotorola' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenikon' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenikon2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenikon3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotenintendo' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteoffset' => { 379 => 0xff },
	'makernoteolympus' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteolympus2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepanasonic' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepanasonic2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepanasonic3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax5' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentax6' => { 113 => 'MakN', 115 => 0x927c },
	'makernotepentaxunknown' => { 363 => 'PXMN' },
	'makernotephaseone' => { 113 => 'MakN', 115 => 0x927c },
	'makernotereconyx' => { 113 => 'MakN', 115 => 0x927c },
	'makernotereconyx2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotereconyx3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericoh' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericoh2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericohpentax' => { 113 => 'MakN', 115 => 0x927c },
	'makernotericohtext' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesafety' => { 115 => 0xc635 },
	'makernotesamsung1a' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesamsung1b' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesamsung2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesanyo' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesanyoc4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesanyopatch' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesigma' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony2' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony3' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony4' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesony5' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesonyericsson' => { 113 => 'MakN', 115 => 0x927c },
	'makernotesonysrf' => { 113 => 'MakN', 115 => 0x927c },
	'makernotetype' => { 370 => 0x1 },
	'makernoteunknown' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteunknownbinary' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteunknowntext' => { 113 => 'MakN', 115 => 0x927c },
	'makernoteversion' => { 178 => 0x0, 216 => 0x1, 285 => 0x0, 303 => 0x8000, 374 => 0x0, 377 => 0x1, 380 => [0x1d,0x1f], 391 => 0x2000 },
	'makerurl' => { 363 => "\xa9mal" },
	'managedfrom' => { 483 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 483 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 483 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 483 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 483 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 483 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 483 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 483 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 483 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 483 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 483 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 483 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 483 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 483 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 483 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 483 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 483 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 483 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 483 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 483 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 483 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 483 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 483 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 483 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 483 => 'Manager' },
	'managervariant' => { 483 => 'ManagerVariant' },
	'manageto' => { 483 => 'ManageTo' },
	'manageui' => { 483 => 'ManageUI' },
	'manifest' => { 483 => 'Manifest' },
	'manifestlinkform' => { 483 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 483 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 483 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 483 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 483 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 483 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 483 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 483 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 483 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 483 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 483 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 483 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 483 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 483 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 483 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 483 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 483 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 483 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 483 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 483 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 483 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 483 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 483 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 483 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 483 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 483 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 483 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 483 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 280 => 0x900, 303 => 0x86 },
	'manometerreading' => { 280 => 0x901 },
	'manualafpointselectpattern' => { 80 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 283 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 265 => '8.2', 268 => '22.2', 269 => '23.1', 270 => '23.2', 272 => '16.2', 273 => '23.2', 274 => '8.2', 275 => '23.2', 278 => '24.2', 370 => 0x100c },
	'manualflashstrength' => { 280 => 0x406 },
	'manualfocusdistance' => { 216 => 0x85, 285 => 0x100c, 379 => 0x223 },
	'manualtv' => { 79 => 0x5, 80 => 0x705 },
	'manufacturedate' => { 183 => 0x6705, 318 => 0x1 },
	'manufacturedate1' => { 372 => 0x4 },
	'manufacturedate2' => { 372 => 0x5 },
	'manufacturer' => { 441 => 'Manufacturer', 471 => 'manufacturer' },
	'mariahchromablursize' => { 133 => 0xf0d },
	'mariahmaphithreshold' => { 133 => 0xf0c },
	'mariahmaplothreshold' => { 133 => 0xf0b },
	'mariahsigmathreshold' => { 133 => 0xf0e },
	'mariahtexturethreshold' => { 133 => 0xf0a },
	'marked' => { 469 => 'Marked', 486 => 'Marked' },
	'markers' => { 482 => 'markers' },
	'markerscomment' => { 482 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 482 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 482 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 482 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 482 => [\'markers','markersCuePointType'] },
	'markersduration' => { 482 => [\'markers','markersDuration'] },
	'markerslocation' => { 482 => [\'markers','markersLocation'] },
	'markersname' => { 482 => [\'markers','markersName'] },
	'markersprobability' => { 482 => [\'markers','markersProbability'] },
	'markersspeaker' => { 482 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 482 => [\'markers','markersStartTime'] },
	'markerstarget' => { 482 => [\'markers','markersTarget'] },
	'markerstype' => { 482 => [\'markers','markersType'] },
	'maskedareas' => { 115 => 0xc68e },
	'masterdocumentid' => { 127 => 0xb9 },
	'mastergain' => { 224 => 0x50 },
	'materialsample' => { 114 => 'MaterialSample' },
	'materialsampleid' => { 114 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 264 => '50.1', 266 => '48.1', 267 => '48.1', 276 => '48.1', 277 => '48.1' },
	'matrixselectk' => { 133 => 0x91b },
	'matrixselectthreshold' => { 133 => 0x91a },
	'matrixselectthreshold1' => { 133 => 0x91e },
	'matrixselectthreshold2' => { 133 => 0x91f },
	'matrixstructure' => { 362 => 0xa },
	'maxaperture' => { 34 => 0x1a, 133 => 0x3f9, 139 => 0x6103, 156 => 'MaxAperture', 173 => 0x17, 179 => 0x49c5, 214 => 0x36, 281 => 0x20a, 329 => '14.1' },
	'maxapertureatmaxfocal' => { 123 => 0x1407, 156 => 'MaxApertureAtMaxFocal', 208 => 0xb, 209 => 0x10, 210 => 0x11, 214 => 0x12, 281 => 0x206 },
	'maxapertureatminfocal' => { 123 => 0x1406, 208 => 0xa, 209 => 0xf, 210 => 0x10, 214 => 0x11, 281 => 0x205 },
	'maxaperturevalue' => { 115 => 0x9205, 347 => 0x414, 462 => 'MaxApertureValue' },
	'maxavailheight' => { 468 => 'MaxAvailHeight' },
	'maxavailwidth' => { 468 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 263 => 0xb, 264 => 0xc, 266 => '12.1', 267 => '12.1', 272 => 0xc, 273 => 0xb, 276 => '12.1', 277 => '12.1' },
	'maxfaces' => { 284 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 123 => 0x1405, 156 => 'MaxFocalLength', 208 => 0x9, 209 => 0xe, 210 => 0xf, 214 => 0x10, 281 => 0x208, 413 => 0x127c, 414 => 0x1138, 415 => 0x330, 416 => 0x330, 417 => 0x30e },
	'maximumdensityrange' => { 129 => 0x8c },
	'maxpagesize' => { 487 => 'MaxPageSize' },
	'maxpagesizeh' => { 487 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 487 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 487 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 133 => 0xc7d },
	'maxsamplevalue' => { 115 => 0x119 },
	'maxstorage' => { 477 => 'maxstorage' },
	'mb-d10batteries' => { 263 => '12.6' },
	'mb-d10batterytype' => { 272 => '13.3' },
	'mb-d11batterytype' => { 273 => '2.3' },
	'mb-d12batterytype' => { 276 => '3.2' },
	'mb-d80batteries' => { 274 => '6.5' },
	'mb-d80batterytype' => { 278 => '3.2' },
	'mcuversion' => { 208 => 0xc, 209 => 0x11, 210 => 0x12, 214 => 0x13 },
	'md5digest' => { 157 => 'zmd5' },
	'mditemfindercomment' => { 166 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 166 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 166 => 'MDItemFSLabel' },
	'mditemusertags' => { 166 => 'MDItemUserTags' },
	'meal' => { 474 => 'meal' },
	'measuredev' => { 28 => 0x9, 74 => 0x3, 93 => 0x1814, 149 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 74 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 179 => 0x690, 298 => 0x312, 301 => 0x312, 302 => 0x312, 305 => 0x3407 },
	'measuredrggb' => { 62 => 0x1 },
	'measuredrggbdata' => { 42 => 0x287 },
	'measurementaccuracy' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 114 => 'MeasurementOrFact' },
	'measurementremarks' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 114 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 441 => 'MeasureType' },
	'mechanicalshuttercount' => { 216 => 0x37 },
	'mediaconstraints' => { 290 => 'MediaConstraints' },
	'mediacreatedate' => { 359 => 0x1 },
	'mediaeventiddate' => { 446 => 'MediaEventIdDate' },
	'mediamodifydate' => { 359 => 0x2 },
	'mediasummarycode' => { 290 => 'MediaSummaryCode' },
	'mediatype' => { 355 => 'stik' },
	'memoaudioquality' => { 80 => 0x812 },
	'memorycardconfiguration' => { 394 => 0x16 },
	'memorycardnumber' => { 199 => 0x2 },
	'menubuttondisplayposition' => { 78 => 0xb, 81 => 0xa, 82 => 0xb, 85 => 0xb },
	'menubuttonreturn' => { 86 => 0xb },
	'menumonitorofftime' => { 263 => '26.1', 264 => '22.1', 266 => '22.1', 267 => '22.1', 271 => '21.1', 272 => '8.2', 273 => '21.1', 276 => '22.1', 277 => '22.1', 278 => '22.1' },
	'metadatadate' => { 480 => 'MetadataDate' },
	'metadatamoddate' => { 482 => 'metadataModDate' },
	'metaversion' => { 408 => 0x34 },
	'meterinfo1row1' => { 402 => 0x0, 403 => 0x0 },
	'meterinfo1row2' => { 402 => 0x6c, 403 => 0x5a },
	'meterinfo1row3' => { 402 => 0xd8, 403 => 0xb4 },
	'meterinfo1row4' => { 402 => 0x144, 403 => 0x10e },
	'meterinfo1row5' => { 402 => 0x1b0, 403 => 0x168 },
	'meterinfo1row6' => { 402 => 0x21c, 403 => 0x1c2 },
	'meterinfo1row7' => { 402 => 0x288, 403 => 0x21c },
	'meterinfo2row1' => { 402 => 0x2f4, 403 => 0x276 },
	'meterinfo2row2' => { 402 => 0x378, 403 => 0x2e4 },
	'meterinfo2row3' => { 402 => 0x3fc, 403 => 0x352 },
	'meterinfo2row4' => { 402 => 0x480, 403 => 0x3c0 },
	'meterinfo2row5' => { 402 => 0x504, 403 => 0x42e },
	'meterinfo2row6' => { 402 => 0x588, 403 => 0x49c },
	'meterinfo2row7' => { 402 => 0x60c, 403 => 0x50a },
	'meterinfo2row8' => { 402 => 0x690, 403 => 0x578 },
	'meterinfo2row9' => { 402 => 0x714, 403 => 0x5e6 },
	'metering' => { 265 => '6.1' },
	'meteringmode' => { 34 => 0x11, 115 => 0x9207, 135 => 0x1c, 173 => 0x7, 174 => 0x25, 176 => 0x12, 280 => 0x202, 338 => 0x17, 380 => 0x9, 388 => 0x15, 389 => 0x13, 390 => 0x7, 406 => 0x3, 409 => 0x1174, 410 => 0x1178, 411 => 0x1154, 412 => 0x11d0, 413 => 0x11ac, 414 => 0x1064, 415 => 0x25c, 416 => 0x25c, 417 => 0x24b, 462 => 'MeteringMode' },
	'meteringmode2' => { 319 => '2.1', 401 => 0x202c },
	'meteringmode3' => { 319 => '16.1' },
	'meteringoffscaleindicator' => { 176 => 0x53 },
	'meteringtime' => { 263 => '22.2', 265 => '3.2', 268 => '17.1', 269 => '18.1', 272 => '7.3', 273 => '18.1', 274 => '3.2', 278 => '19.1' },
	'micro1version' => { 365 => 0x1f },
	'micro2version' => { 365 => 0x2d },
	'midrangesharpness' => { 220 => 0x3b },
	'mieversion' => { 157 => '0Vers' },
	'mime' => { 441 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 133 => 0x3f8, 156 => 'MinAperture', 329 => '0.2' },
	'minaperturevalue' => { 347 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 123 => 0x1404, 156 => 'MinFocalLength', 208 => 0x8, 209 => 0xd, 210 => 0xe, 214 => 0xf, 281 => 0x207, 413 => 0x127a, 414 => 0x1136, 415 => 0x32e, 416 => 0x32e, 417 => 0x30c },
	'minfocusdistance' => { 329 => 0x3 },
	'minintegrationrows' => { 133 => 0x1874 },
	'minoltadate' => { 173 => 0x15 },
	'minoltaimagesize' => { 173 => 0x4, 174 => 0xc, 175 => 0x2, 178 => 0x103 },
	'minoltamodelid' => { 173 => 0x25 },
	'minoltaquality' => { 173 => 0x5, 174 => 0xd, 175 => 0x3, 178 => [0x102,0x103] },
	'minoltatime' => { 173 => 0x16 },
	'minormodelagedisclosure' => { 290 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 447 => 'MinorVersion' },
	'minsamplevalue' => { 115 => 0x118 },
	'mirrorlockup' => { 78 => 0xc, 79 => 0xc, 80 => 0x60f, 81 => 0xb, 82 => 0xc, 83 => 0x6, 84 => 0x6, 85 => 0xc, 86 => 0x3 },
	'mobilecountrycode' => { 455 => 'mcc' },
	'mobilenetworkcode' => { 455 => 'mnc' },
	'moddate' => { 293 => 'modify-date', 469 => 'ModDate' },
	'modedialposition' => { 394 => 0x14 },
	'model' => { 94 => 0x6, 115 => 0x110, 149 => 'Model', 293 => 'Model', 308 => 0x110, 338 => 0x23f, 357 => 'model', 363 => ['CNMN','cmnm',"\xa9mdl","\xa9mod"], 380 => 0x84, 441 => 'Model', 471 => 'model', 478 => 'Model' },
	'modelage' => { 468 => 'ModelAge' },
	'modelid' => { 279 => 0x0 },
	'modelingflash' => { 263 => '21.4', 264 => '31.1', 266 => '31.1', 267 => '31.1', 272 => '26.4', 273 => '30.2', 274 => '7.4', 275 => '30.1', 276 => '31.1', 277 => '31.1', 278 => '31.3' },
	'modelreleaseid' => { 290 => 'ModelReleaseID' },
	'modelreleasestatus' => { 290 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 421 => 0x52, 422 => 0x46, 423 => 0x53 },
	'modeltiepoint' => { 115 => 0x8482 },
	'modeltransform' => { 115 => 0x85d8 },
	'modelyear' => { 471 => 'modelYear' },
	'modificationdate' => { 472 => 'modificationDate' },
	'modifiedcolortemp' => { 63 => 0x9 },
	'modifieddigitalgain' => { 63 => 0xb },
	'modifiedparamflag' => { 56 => 0x1 },
	'modifiedpicturestyle' => { 63 => 0xa },
	'modifiedsaturation' => { 280 => 0x504 },
	'modifiedsensorbluelevel' => { 63 => 0x5 },
	'modifiedsensorredlevel' => { 63 => 0x4 },
	'modifiedsharpness' => { 63 => 0x2 },
	'modifiedsharpnessfreq' => { 63 => 0x3 },
	'modifiedtonecurve' => { 63 => 0x1 },
	'modifiedwhitebalance' => { 63 => 0x8 },
	'modifiedwhitebalanceblue' => { 63 => 0x7 },
	'modifiedwhitebalancered' => { 63 => 0x6 },
	'modifydate' => { 115 => 0x132, 150 => 'ModifyDate', 289 => 'ModDate', 291 => 'tIME', 354 => 'ModDate', 360 => 0x2, 480 => 'ModifyDate' },
	'moirefilter' => { 115 => 0xfe58, 456 => 'MoireFilter', 458 => 'MoireFilter' },
	'monitordisplayoff' => { 176 => 0x4c },
	'monitormatrix' => { 133 => 0x8fc },
	'monitorofftime' => { 263 => '18.2', 265 => '3.1', 274 => '3.1' },
	'monochromecolor' => { 280 => 0x53b },
	'monochromecontrast' => { 105 => 0x3c },
	'monochromefiltereffect' => { 99 => 0x20307, 105 => 0x3a, 338 => 0x73 },
	'monochromelinear' => { 105 => 0x3d },
	'monochromeoutputhighlightpoint' => { 105 => 0x41 },
	'monochromeoutputshadowpoint' => { 105 => 0x42 },
	'monochromeprofilesettings' => { 280 => 0x537 },
	'monochromerawhighlight' => { 105 => 0x7a },
	'monochromerawhighlightpoint' => { 105 => 0x3f },
	'monochromerawshadow' => { 105 => 0x83 },
	'monochromerawshadowpoint' => { 105 => 0x40 },
	'monochromesharpness' => { 105 => 0x3e },
	'monochrometoning' => { 338 => 0x74 },
	'monochrometoningeffect' => { 99 => 0x20306, 105 => 0x3b },
	'monochromeunsharpmaskfineness' => { 105 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 105 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 105 => 0xb4 },
	'monochromevignetting' => { 280 => 0x53a },
	'monthdaycreated' => { 135 => 0x12, 144 => 0xe },
	'moonphase' => { 364 => 0x12, 365 => 0x43, 366 => 0x4c },
	'morepermissions' => { 454 => 'morePermissions' },
	'motionsensitivity' => { 364 => 0x29, 366 => 0x60 },
	'movieaelockbuttonassignment' => { 276 => '40.1' },
	'moviefunc1button' => { 266 => '41.1', 267 => '41.1', 277 => '41.1' },
	'moviefunctionbutton' => { 264 => '41.1', 276 => '41.1' },
	'moviefunctionbuttonplusdials' => { 264 => '52.1' },
	'moviepreviewbutton' => { 264 => '41.2', 266 => '41.2', 267 => '41.2', 276 => '41.2', 277 => '41.2' },
	'moviepreviewbuttonplusdials' => { 264 => '52.2' },
	'movieshutterbutton' => { 264 => '38.3', 266 => '38.3', 267 => '38.3', 276 => '38.3', 277 => '38.3' },
	'moviesubselectorassignment' => { 264 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 264 => '53.1' },
	'multiburstimageheight' => { 401 => 0x1002 },
	'multiburstimagewidth' => { 401 => 0x1001 },
	'multiburstmode' => { 401 => 0x1000 },
	'multicontrollerwhilemetering' => { 80 => 0x517 },
	'multiexposure' => { 65 => 0x1, 303 => 0xb4 },
	'multiexposureautogain' => { 217 => 0x3 },
	'multiexposurecontrol' => { 65 => 0x2 },
	'multiexposuremode' => { 217 => 0x1 },
	'multiexposureshots' => { 65 => 0x3, 217 => 0x2 },
	'multiframenoisereduction' => { 390 => 0x35, 401 => 0x200b, 406 => 0x15 },
	'multiframenreffect' => { 401 => 0x2023 },
	'multifunctionlock' => { 80 => 0x70f },
	'multipleexposuremode' => { 284 => 0x101c },
	'multipleexposureset' => { 319 => '10.1' },
	'multisample' => { 224 => 0x40 },
	'multiselector' => { 263 => '9.4', 264 => '10.3', 266 => '10.3', 267 => '10.3', 272 => '27.4', 276 => '10.3', 277 => '10.3' },
	'multiselectorliveview' => { 263 => '4.3', 266 => '37.1', 267 => '37.1', 276 => '37.1', 277 => '37.1' },
	'multiselectorliveviewmode' => { 234 => 0x18c2 },
	'multiselectorplaybackmode' => { 263 => ['13.5','9.2'], 264 => '10.2', 267 => '10.2', 272 => '27.2', 276 => '10.2', 277 => '10.2' },
	'multiselectorshootmode' => { 263 => '9.1', 264 => '10.1', 266 => '10.1', 267 => '10.1', 272 => '27.1', 276 => '10.1', 277 => '10.1' },
	'multishot' => { 308 => 0x121 },
	'mute' => { 357 => 'player.movie.audio.mute' },
	'mycolormode' => { 66 => 0x2 },
	'name' => { 363 => 'name' },
	'narrator' => { 355 => "\xa9nrt" },
	'nationalcatalognumber' => { 472 => 'nationalCatalogNumber' },
	'nativedigest' => { 462 => 'NativeDigest', 478 => 'NativeDigest' },
	'ndfilter' => { 74 => 0x1c, 280 => 0x204, 370 => 0x1019 },
	'near' => { 441 => 'Near' },
	'nefbitdepth' => { 216 => 0xe22 },
	'nefcompression' => { 216 => 0x93 },
	'neflinearizationtable' => { 216 => 0x96 },
	'negativecachelargepreviewsize' => { 456 => 'NegativeCacheLargePreviewSize', 458 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 456 => 'NegativeCacheMaximumSize', 458 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 456 => 'NegativeCachePath', 458 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 338 => 0x88 },
	'neutraloutputhighlightpoint' => { 105 => 0x2f },
	'neutraloutputshadowpoint' => { 105 => 0x30 },
	'neutralrawcolortone' => { 105 => 0x28 },
	'neutralrawcontrast' => { 105 => 0x2a },
	'neutralrawhighlight' => { 105 => 0x78 },
	'neutralrawhighlightpoint' => { 105 => 0x2d },
	'neutralrawlinear' => { 105 => 0x2b },
	'neutralrawsaturation' => { 105 => 0x29 },
	'neutralrawshadow' => { 105 => 0x81 },
	'neutralrawshadowpoint' => { 105 => 0x2e },
	'neutralrawsharpness' => { 105 => 0x2c },
	'neutralunsharpmaskfineness' => { 105 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 105 => 0xa8 },
	'neutraunsharpmaskstrength' => { 105 => 0xa4 },
	'newrawimagedigest' => { 115 => 0xc7a7 },
	'newsphotoversion' => { 129 => 0x0 },
	'nickname' => { 480 => 'Nickname' },
	'nikoncapturedata' => { 216 => 0xe01 },
	'nikoncaptureeditversions' => { 216 => 0xe13 },
	'nikoncaptureoffsets' => { 216 => 0xe0e },
	'nikoncaptureoutput' => { 216 => 0xe1e },
	'nikoncaptureversion' => { 216 => 0xe09 },
	'nikoniccprofile' => { 216 => 0xe1d },
	'nikonimagesize' => { 231 => '723.1', 232 => '732.1', 241 => 0x2c4 },
	'nikonmeteringmode' => { 235 => 0x2ea4, 243 => 0x175e },
	'noisefilter' => { 280 => 0x527 },
	'noiseprofile' => { 115 => 0xc761 },
	'noisereduction' => { 123 => [0x100b,0x100e], 174 => 0xb0, 175 => 0x60, 176 => 0x3f, 216 => 0x95, 256 => 0x753dcbc0, 257 => 0x17, 280 => 0x50a, 285 => 0x103a, 303 => 0x2d, 338 => 0x49, 370 => 0x100f, 372 => 0x2a },
	'noisereduction2' => { 284 => 0x1010 },
	'noisereductionapplied' => { 115 => 0xc6f7 },
	'noisereductionintensity' => { 257 => 0x9 },
	'noisereductionmethod' => { 257 => 0x11 },
	'noisereductionmode' => { 434 => 0x801e },
	'noisereductionparametersatcapture' => { 133 => 0xe73 },
	'noisereductionparameterscamera' => { 133 => 0xe72 },
	'noisereductionparametershost3mp' => { 133 => 0xe71 },
	'noisereductionparametershost6mp' => { 133 => 0xe70 },
	'noisereductionparametershostrgb' => { 133 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 133 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 133 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 133 => 0xe63 },
	'noisereductionparams' => { 308 => 0x1b },
	'noisereductionsharpness' => { 257 => 0xd },
	'noisereductionstrength' => { 303 => 0xd6 },
	'noisereductionvalue' => { 434 => 0x8027 },
	'nomemorycard' => { 263 => '22.1', 264 => '4.2', 265 => '0.3', 268 => '2.4', 269 => '3.2', 270 => '3.2', 272 => '33.7', 273 => '3.2', 274 => '0.3', 276 => '4.2', 278 => '4.5' },
	'nominalmaxaperture' => { 329 => 0xa },
	'nominalminaperture' => { 329 => '10.1' },
	'normallinetime' => { 133 => 0x186a },
	'normalwhitelevel' => { 43 => [0x2b8,0x2cf,0x2d3], 44 => 0x569, 45 => 0x1e3, 46 => [0x1fc,0x2dc], 47 => [0x230,0x30e], 48 => 0x31c },
	'notes' => { 435 => 'Notes', 451 => 'notes' },
	'npages' => { 487 => 'NPages' },
	'nullrecord' => { 93 => 0x0 },
	'numafpoints' => { 315 => 0x2 },
	'number' => { 472 => 'number' },
	'numberofbeats' => { 482 => 'numberOfBeats' },
	'numberoffocuspoints' => { 266 => '1.3', 267 => '1.3', 270 => '0.2', 271 => '0.3', 273 => '0.3' },
	'numfaceelements' => { 123 => 0x4200 },
	'numfacepositions' => { 295 => 0x0 },
	'numindexentries' => { 129 => 0x54 },
	'numwbentries' => { 309 => 0x0, 310 => 0x0 },
	'object' => { 472 => 'object' },
	'objectattributereference' => { 127 => 0x4 },
	'objectcycle' => { 127 => 0x4b, 451 => 'ObjectCycle' },
	'objectdescription' => { 471 => 'objectDescription' },
	'objectdistance' => { 108 => 0x6, 109 => 0x2022 },
	'objectname' => { 127 => 0x5 },
	'objectpreviewdata' => { 127 => 0xca },
	'objectpreviewfileformat' => { 127 => 0xc8 },
	'objectpreviewfileversion' => { 127 => 0xc9 },
	'objectsubtype' => { 471 => 'objectSubtype' },
	'objecttype' => { 471 => 'objectType' },
	'objecttypereference' => { 127 => 0x3 },
	'occurrence' => { 114 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 114 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 114 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 114 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 114 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 114 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 114 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 114 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 114 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 114 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 114 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 114 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 114 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 114 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 114 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 114 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 114 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 114 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 114 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 114 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 114 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 114 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 114 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 114 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 114 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 114 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 462 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 462 => [\'OECF','OECFNames'] },
	'oecfrows' => { 462 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 462 => [\'OECF','OECFValues'] },
	'offsaledate' => { 472 => 'offSaleDate' },
	'offsaledatea-platform' => { 472 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 472 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 133 => 0x190a },
	'offsetschema' => { 115 => 0xea1d },
	'offsettime' => { 115 => 0x9010 },
	'offsettimedigitized' => { 115 => 0x9012 },
	'offsettimeoriginal' => { 115 => 0x9011 },
	'okbutton' => { 273 => '15.1', 278 => '16.1' },
	'oldsubfiletype' => { 115 => 0xff },
	'olympusimageheight' => { 285 => 0x102f },
	'olympusimagewidth' => { 285 => 0x102e },
	'omenatcapturestrength' => { 133 => 0xa60 },
	'omenautostrength' => { 133 => 0xa5f },
	'omenearlystrength' => { 133 => 0xa5e },
	'omenfocallengthlimit' => { 133 => 0xa62 },
	'omeninitialipfstrength' => { 133 => 0xa5d },
	'omensurfaceindex' => { 133 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 285 => 0x302 },
	'onsaledate' => { 472 => 'onSaleDate' },
	'onsaledatea-platform' => { 472 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 472 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 472 => 'onSaleDay' },
	'onsaledaya-platform' => { 472 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 472 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 115 => 0xc740 },
	'opcodelist2' => { 115 => 0xc741 },
	'opcodelist3' => { 115 => 0xc74e },
	'opticalzoom' => { 137 => 0xfa3d, 139 => [0x6006,0xf006], 140 => 0x1000, 141 => 0xf, 144 => 0x1e, 156 => 'OpticalZoom' },
	'opticalzoomcode' => { 74 => 0xa },
	'opticalzoommode' => { 303 => 0x34 },
	'opticalzoomon' => { 379 => 0x219 },
	'optionenddate' => { 475 => 'optionEndDate' },
	'opto-electricconvfactor' => { 462 => 'OECF' },
	'orangehsl' => { 99 => 0x20911 },
	'ordernumber' => { 123 => 0x8002 },
	'organisationinimagecode' => { 468 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 468 => 'OrganisationInImageName' },
	'organism' => { 114 => 'Organism' },
	'organismassociatedoccurrences' => { 114 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 114 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 114 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 114 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 114 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 114 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 114 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 472 => 'organization' },
	'orientation' => { 115 => 0x112, 308 => 0x112, 471 => 'orientation', 478 => 'Orientation' },
	'orientation2' => { 406 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 80 => 0x516 },
	'originalbestqualitysize' => { 115 => 0xc792 },
	'originalcreatedatetime' => { 446 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 110 => 'Canon::OriginalDecisionData' },
	'originaldecisiondataoffset' => { 61 => 0x83 },
	'originaldefaultcropsize' => { 115 => 0xc793 },
	'originaldefaultfinalsize' => { 115 => 0xc791 },
	'originaldirectory' => { 300 => 0x408 },
	'originaldocumentid' => { 483 => 'OriginalDocumentID' },
	'originalfilename' => { 93 => 0x816, 133 => 0x3e9, 145 => 0x20, 300 => 0x407, 446 => 'OriginalFilename' },
	'originalimageheight' => { 76 => 0xc, 119 => 0x1 },
	'originalimagewidth' => { 76 => 0xb, 119 => 0x0 },
	'originalrawfiledata' => { 115 => 0xc68c },
	'originalrawfiledigest' => { 115 => 0xc71d },
	'originalrawfilename' => { 115 => 0xc68b },
	'originaltransmissionreference' => { 127 => 0x67 },
	'originatingprogram' => { 127 => 0x41, 451 => 'OriginatingProgram' },
	'originplatform' => { 472 => 'originPlatform' },
	'os' => { 460 => 'os' },
	'otherconditions' => { 290 => 'OtherConditions' },
	'otherconstraints' => { 290 => 'OtherConstraints' },
	'otherimage' => { 110 => 'Exif::OtherImage' },
	'otherimageinfo' => { 290 => 'OtherImageInfo' },
	'otherimagelength' => { 115 => 0x202 },
	'otherimagestart' => { 115 => 0x201 },
	'otherlicensedocuments' => { 290 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 290 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 290 => 'OtherLicenseRequirements' },
	'outcue' => { 482 => 'outCue' },
	'outcuescale' => { 482 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 482 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 188 => 0x3 },
	'outputimagewidth' => { 188 => 0x2 },
	'outputlut' => { 303 => 0xa7 },
	'outputprofile' => { 133 => 0x138b },
	'outputresolution' => { 188 => 0x4 },
	'overclockcols' => { 133 => 0x189c },
	'overclockrows' => { 133 => 0x18c4 },
	'owner' => { 486 => 'Owner' },
	'ownerid' => { 127 => 0xbc },
	'ownername' => { 15 => 0x10f, 61 => 0x9, 93 => 0x810, 115 => [0xa430,0xfde8], 149 => 'OwnerName', 453 => 'OwnerName', 463 => 'CameraOwnerName' },
	'padding' => { 115 => 0xea1c },
	'pagecount' => { 472 => 'pageCount' },
	'pageimage' => { 480 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 480 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 480 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 480 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 480 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 480 => 'PageInfo' },
	'pagename' => { 115 => 0x11d },
	'pagenumber' => { 115 => 0x129 },
	'pageprogressiondirection' => { 472 => 'pageProgressionDirection' },
	'pagerange' => { 472 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 456 => 'PaintBasedCorrections', 458 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 458 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 306 => 0x0 },
	'panasonicexifversion' => { 303 => 0x26 },
	'panasonicimageheight' => { 303 => 0x4c },
	'panasonicimagewidth' => { 303 => 0x4b },
	'panasonicrawversion' => { 308 => 0x1 },
	'panasonictitle' => { 115 => 0xc6d2 },
	'panasonictitle2' => { 115 => 0xc6d3 },
	'panoramaangle' => { 123 => 0x1153 },
	'panoramacropbottom' => { 407 => 0x7 },
	'panoramacropleft' => { 407 => 0x4 },
	'panoramacropright' => { 407 => 0x6 },
	'panoramacroptop' => { 407 => 0x5 },
	'panoramadirection' => { 69 => 0x5, 123 => 0x1154, 407 => 0x3 },
	'panoramaframeheight' => { 407 => 0x9 },
	'panoramaframenumber' => { 69 => 0x2 },
	'panoramaframewidth' => { 407 => 0x8 },
	'panoramafullheight' => { 407 => 0x2 },
	'panoramafullwidth' => { 407 => 0x1 },
	'panoramamode' => { 135 => 0x3c, 280 => 0x601 },
	'panoramasize3d' => { 390 => 0x38 },
	'panoramasourceheight' => { 407 => 0xb },
	'panoramasourcewidth' => { 407 => 0xa },
	'panoramicstitchcameramotion' => { 169 => 'PanoramicStitchCameraMotion', 170 => 0x1 },
	'panoramicstitchmaptype' => { 169 => 'PanoramicStitchMapType', 170 => 0x2 },
	'panoramicstitchphi0' => { 169 => 'PanoramicStitchPhi0', 170 => 0x5 },
	'panoramicstitchphi1' => { 169 => 'PanoramicStitchPhi1', 170 => 0x6 },
	'panoramicstitchtheta0' => { 169 => 'PanoramicStitchTheta0', 170 => 0x3 },
	'panoramicstitchtheta1' => { 169 => 'PanoramicStitchTheta1', 170 => 0x4 },
	'panoramicstitchversion' => { 170 => 0x0 },
	'pantry' => { 483 => 'Pantry' },
	'pantryinstanceid' => { 483 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 123 => 0xb211, 279 => 0x28 },
	'parametricdarks' => { 456 => 'ParametricDarks', 458 => 'ParametricDarks' },
	'parametrichighlights' => { 456 => 'ParametricHighlights', 458 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 456 => 'ParametricHighlightSplit', 458 => 'ParametricHighlightSplit' },
	'parametriclights' => { 456 => 'ParametricLights', 458 => 'ParametricLights' },
	'parametricmidtonesplit' => { 456 => 'ParametricMidtoneSplit', 458 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 456 => 'ParametricShadows', 458 => 'ParametricShadows' },
	'parametricshadowsplit' => { 456 => 'ParametricShadowSplit', 458 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 446 => 'ParentMediaEventID' },
	'parentmeid' => { 446 => 'ParentMEID' },
	'parentproductid' => { 355 => '@ppi' },
	'parentreference1' => { 466 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 466 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 355 => '@PST' },
	'parenttitle' => { 355 => '@pti' },
	'partialactivecols1' => { 133 => 0x17e8 },
	'partialactivecols2' => { 133 => 0x17f2 },
	'partialactiverows1' => { 133 => 0x17fc },
	'partialactiverows2' => { 133 => 0x1806 },
	'partofcompilation' => { 482 => 'partOfCompilation' },
	'patientbirthdate' => { 436 => 'PatientDOB' },
	'patientid' => { 436 => 'PatientID' },
	'patientname' => { 436 => 'PatientName' },
	'patientsex' => { 436 => 'PatientSex' },
	'patternareaheight' => { 133 => 0x963 },
	'patternareawidth' => { 133 => 0x962 },
	'patterncorrectionfactorscale' => { 133 => 0x969 },
	'patterncropcols1' => { 133 => 0x96c },
	'patterncropcols2' => { 133 => 0x96d },
	'patterncroprows1' => { 133 => 0x96a },
	'patterncroprows2' => { 133 => 0x96b },
	'patternimagerheight' => { 133 => 0x961 },
	'patternimagerwidth' => { 133 => 0x960 },
	'patternx' => { 133 => 0x966 },
	'patterny' => { 133 => 0x967 },
	'pdfversion' => { 469 => 'PDFVersion' },
	'pentaximagesize' => { 338 => 0x9 },
	'pentaxmodelid' => { 318 => 0x0, 338 => 0x5 },
	'pentaxmodeltype' => { 338 => 0x1 },
	'pentaxversion' => { 338 => 0x0 },
	'people' => { 437 => 'People', 449 => 'People' },
	'perchannelblacklevel' => { 42 => 0xc4, 43 => [0x2b4,0x2cb,0x2cf], 44 => [0x108,0x14d], 45 => 0x1df, 46 => [0x1f8,0x2d8], 47 => [0x22c,0x30a], 48 => 0x149 },
	'performer' => { 355 => 'perf', 363 => 'perf' },
	'performerkeywords' => { 363 => "\xa9prk" },
	'performers' => { 363 => "\xa9prf" },
	'performerurl' => { 363 => "\xa9prl" },
	'peripheralillumcentralradius' => { 434 => 0x8030 },
	'peripheralillumcentralvalue' => { 434 => 0x8031 },
	'peripheralillumination' => { 99 => 0x20702, 105 => 0x68 },
	'peripheralilluminationcorr' => { 60 => 0x1, 328 => 0x2 },
	'peripheralilluminationon' => { 99 => '0x20702.0', 105 => 0x64 },
	'peripheralillumperiphvalue' => { 434 => 0x8032 },
	'peripherallighting' => { 76 => 0x2, 123 => 0x3804 },
	'peripherallightingsetting' => { 77 => 0x5 },
	'peripherallightingvalue' => { 76 => 0x6 },
	'permissions' => { 475 => 'permissions' },
	'permits' => { 454 => 'permits' },
	'person' => { 472 => 'person' },
	'personality' => { 446 => 'Personality' },
	'personheard' => { 468 => 'PersonHeard' },
	'personheardidentifier' => { 468 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 468 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 468 => 'PersonInImage' },
	'personinimagecharacteristic' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 468 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 468 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 456 => 'PerspectiveAspect', 458 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 456 => 'PerspectiveHorizontal', 458 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 456 => 'PerspectiveRotate', 458 => 'PerspectiveRotate' },
	'perspectivescale' => { 456 => 'PerspectiveScale', 458 => 'PerspectiveScale' },
	'perspectiveupright' => { 456 => 'PerspectiveUpright', 458 => 'PerspectiveUpright' },
	'perspectivevertical' => { 456 => 'PerspectiveVertical', 458 => 'PerspectiveVertical' },
	'perspectivex' => { 456 => 'PerspectiveX', 458 => 'PerspectiveX' },
	'perspectivey' => { 456 => 'PerspectiveY', 458 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 88 => 0x1 },
	'pf10retainprogramshift' => { 88 => 0xb },
	'pf13drivepriority' => { 88 => 0xe },
	'pf14disablefocussearch' => { 88 => 0xf },
	'pf15disableafassistbeam' => { 88 => 0x10 },
	'pf16autofocuspointshoot' => { 88 => 0x11 },
	'pf17disableafpointsel' => { 88 => 0x12 },
	'pf18enableautoafpointsel' => { 88 => 0x13 },
	'pf19continuousshootspeed' => { 88 => 0x14 },
	'pf19shootingspeedhigh' => { 87 => 0xa },
	'pf19shootingspeedlow' => { 87 => 0x9 },
	'pf1disableshootingmodes' => { 88 => 0x2 },
	'pf1value' => { 87 => 0x1 },
	'pf20limitcontinousshots' => { 88 => 0x15 },
	'pf20maxcontinousshots' => { 87 => 0xb },
	'pf21enablequietoperation' => { 88 => 0x16 },
	'pf23felocktime' => { 87 => 0xd },
	'pf23postreleasetime' => { 87 => 0xe },
	'pf23settimerlengths' => { 88 => 0x18 },
	'pf23shutterbuttontime' => { 87 => 0xc },
	'pf24lightlcdduringbulb' => { 88 => 0x19 },
	'pf25aemode' => { 87 => 0xf },
	'pf25afmode' => { 87 => 0x12 },
	'pf25afpointsel' => { 87 => 0x13 },
	'pf25colormatrix' => { 87 => 0x17 },
	'pf25defaultclearsettings' => { 88 => 0x1a },
	'pf25drivemode' => { 87 => 0x11 },
	'pf25imagesize' => { 87 => 0x14 },
	'pf25meteringmode' => { 87 => 0x10 },
	'pf25parameters' => { 87 => 0x16 },
	'pf25wbmode' => { 87 => 0x15 },
	'pf26shortenreleaselag' => { 88 => 0x1b },
	'pf27reversedialrotation' => { 88 => 0x1c },
	'pf27value' => { 87 => 0x18 },
	'pf28noquickdialexpcomp' => { 88 => 0x1d },
	'pf29quickdialswitchoff' => { 88 => 0x1e },
	'pf2disablemeteringmodes' => { 88 => 0x3 },
	'pf2value' => { 87 => 0x2 },
	'pf30enlargementmode' => { 88 => 0x1f },
	'pf31originaldecisiondata' => { 88 => 0x20 },
	'pf3manualexposuremetering' => { 88 => 0x4 },
	'pf3value' => { 87 => 0x3 },
	'pf4exposuretimelimits' => { 88 => 0x5 },
	'pf4exposuretimemax' => { 87 => 0x5 },
	'pf4exposuretimemin' => { 87 => 0x4 },
	'pf5aperturelimits' => { 88 => 0x6 },
	'pf5aperturemax' => { 87 => 0x7 },
	'pf5aperturemin' => { 87 => 0x6 },
	'pf6presetshootingmodes' => { 88 => 0x7 },
	'pf7bracketcontinuousshoot' => { 88 => 0x8 },
	'pf8bracketshots' => { 87 => 0x8 },
	'pf8setbracketshots' => { 88 => 0x9 },
	'pf9changebracketsequence' => { 88 => 0xa },
	'phasedetectaf' => { 185 => 0x6 },
	'phonenumber' => { 150 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 256 => 0xe9651831 },
	'photoeffects' => { 256 => 0xab5eca5e },
	'photoeffectsblue' => { 258 => 0x8 },
	'photoeffectsgreen' => { 258 => 0x6 },
	'photoeffectsred' => { 258 => 0x4 },
	'photoeffectstype' => { 258 => 0x0 },
	'photographicsensitivity' => { 463 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 263 => '17.6', 272 => '33.6' },
	'photometricinterpretation' => { 115 => 0x106, 478 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 235 => 0xe7d, 244 => 0xfbd },
	'photoshootingmenubankimagearea' => { 235 => '3716.1', 244 => 0x791 },
	'photoshopbgrthumbnail' => { 352 => 0x409 },
	'photoshopquality' => { 351 => 0x0 },
	'photoshopthumbnail' => { 352 => 0x40c },
	'photostyle' => { 303 => 0x89 },
	'picklabel' => { 461 => 'PickLabel' },
	'pictinfo' => { 379 => 0x208 },
	'picturecontrol' => { 256 => 0xe2173c47 },
	'picturecontrolactive' => { 259 => 0x0 },
	'picturecontroladjust' => { 218 => 0x30, 219 => 0x30, 220 => 0x36 },
	'picturecontrolbase' => { 218 => 0x18, 219 => 0x18, 220 => 0x1c },
	'picturecontroldata' => { 216 => [0xbd,0x23] },
	'picturecontrolmode' => { 259 => 0x13 },
	'picturecontrolname' => { 218 => 0x4, 219 => 0x4, 220 => 0x8 },
	'picturecontrolquickadjust' => { 218 => 0x31, 219 => 0x31, 220 => 0x37 },
	'pictureeffect' => { 401 => 0x200e },
	'pictureeffect2' => { 409 => 0x1163, 410 => 0x1167, 411 => 0x1143, 412 => 0x11bf, 413 => 0x119b, 414 => 0x1053, 415 => 0x24b, 416 => 0x24b, 417 => 0x23c, 430 => 0x46 },
	'picturefinish' => { 174 => 0x71 },
	'picturemode' => { 123 => 0x1031, 280 => 0x520, 338 => [0xb,0x33], 380 => 0x3d },
	'picturemode2' => { 319 => 0x0 },
	'picturemodebwfilter' => { 280 => 0x525 },
	'picturemodecontrast' => { 280 => 0x523 },
	'picturemodeeffect' => { 280 => 0x52d },
	'picturemodehue' => { 280 => 0x522 },
	'picturemodesaturation' => { 280 => 0x521 },
	'picturemodesharpness' => { 280 => 0x524 },
	'picturemodetone' => { 280 => 0x526 },
	'pictureprofile' => { 409 => [0x115e,0x115f], 410 => [0x1162,0x1163], 411 => [0x113e,0x113f], 412 => [0x11ba,0x11bb], 413 => [0x1196,0x1197], 414 => [0x104e,0x104f], 415 => [0x246,0x247], 416 => [0x246,0x247], 417 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 71 => 0xa, 99 => 0x20301, 105 => 0x2 },
	'picturestylepc' => { 61 => 0x4009 },
	'picturestyleuserdef' => { 61 => 0x4008 },
	'picturewizard' => { 377 => 0x21 },
	'picturewizardcolor' => { 376 => 0x1 },
	'picturewizardcontrast' => { 376 => 0x4 },
	'picturewizardmode' => { 376 => 0x0 },
	'picturewizardsaturation' => { 376 => 0x2 },
	'picturewizardsharpness' => { 376 => 0x3 },
	'pipelineversion' => { 169 => 'PipelineVersion' },
	'pitch' => { 111 => 0x6, 264 => '4.1', 276 => '4.1', 363 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 234 => 0x350f, 235 => 0x2c28, 243 => 0x36f8, 280 => 0x904, 303 => 0x91, 337 => 0x2, 375 => 0x1 },
	'pitchshift' => { 357 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 356 => 'pasp' },
	'pixelclockfrequency' => { 133 => 0x40b },
	'pixelcorrectionoffset' => { 133 => 0x972 },
	'pixelcorrectionscale' => { 133 => 0x971 },
	'pixelscale' => { 115 => 0x830e },
	'pixelshiftinfo' => { 401 => 0x202f },
	'pixelshiftresolution' => { 339 => 0x0 },
	'pixelsperunitx' => { 292 => 0x0 },
	'pixelsperunity' => { 292 => 0x4 },
	'pixelunits' => { 292 => 0x8 },
	'planarconfiguration' => { 115 => 0x11c, 478 => 'PlanarConfiguration' },
	'planningref' => { 468 => 'PlanningRef' },
	'planningrefidentifier' => { 468 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 468 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 468 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 487 => 'PlateNames' },
	'platform' => { 472 => 'platform' },
	'playallframes' => { 363 => 'AllF' },
	'playbackmenustime' => { 268 => '20.1', 269 => '21.1', 270 => '21.1' },
	'playbackmonitorofftime' => { 263 => '25.2', 264 => '36.1', 266 => '36.1', 267 => '36.1', 271 => '35.1', 272 => '8.1', 273 => '35.1', 276 => '36.1', 277 => '36.1', 278 => '21.1' },
	'playbackzoom' => { 264 => '37.1' },
	'playdisplay' => { 176 => 0x4e },
	'playerversion' => { 357 => 'player.version' },
	'playgap' => { 355 => 'pgap' },
	'playlistid' => { 355 => 'plID' },
	'playmode' => { 363 => 'SDLN' },
	'playselection' => { 363 => 'SelO' },
	'plusversion' => { 290 => 'Version' },
	'pmversion' => { 350 => 'PMVersion' },
	'pngwarning' => { 293 => 'Warning' },
	'podcast' => { 355 => 'pcst' },
	'podcasturl' => { 355 => 'purl' },
	'poilevel' => { 215 => 0x8 },
	'portraitnote' => { 439 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 105 => 0x1d },
	'portraitoutputshadowpoint' => { 105 => 0x1e },
	'portraitrawcolortone' => { 105 => 0x16 },
	'portraitrawcontrast' => { 105 => 0x18 },
	'portraitrawhighlight' => { 105 => 0x76 },
	'portraitrawhighlightpoint' => { 105 => 0x1b },
	'portraitrawlinear' => { 105 => 0x19 },
	'portraitrawsaturation' => { 105 => 0x17 },
	'portraitrawshadow' => { 105 => 0x7f },
	'portraitrawshadowpoint' => { 105 => 0x1c },
	'portraitrawsharpness' => { 105 => 0x1a },
	'portraitrefiner' => { 109 => 0x302b },
	'portraitrequest' => { 439 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 105 => 0x9a },
	'portraitunsharpmaskstrength' => { 105 => 0x98 },
	'portraitunsharpmaskthreshold' => { 105 => 0x9c },
	'portraitversion' => { 439 => 'PortraitVersion' },
	'poseheadingdegrees' => { 444 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 444 => 'PosePitchDegrees' },
	'poserolldegrees' => { 444 => 'PoseRollDegrees' },
	'positiondescriptor' => { 471 => 'positionDescriptor' },
	'postalcode' => { 154 => 'PostalCode' },
	'postcropvignetteamount' => { 456 => 'PostCropVignetteAmount', 458 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 456 => 'PostCropVignetteFeather', 458 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 456 => 'PostCropVignetteHighlightContrast', 458 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 456 => 'PostCropVignetteMidpoint', 458 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 456 => 'PostCropVignetteRoundness', 458 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 456 => 'PostCropVignetteStyle', 458 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 398 => 0xb },
	'potentialface2position' => { 398 => 0x15 },
	'potentialface3position' => { 398 => 0x1f },
	'potentialface4position' => { 398 => 0x29 },
	'potentialface5position' => { 398 => 0x33 },
	'potentialface6position' => { 398 => 0x3d },
	'potentialface7position' => { 398 => 0x47 },
	'potentialface8position' => { 398 => 0x51 },
	'powersource' => { 317 => '0.1' },
	'poweruptime' => { 216 => 0xb6 },
	'precaptureframes' => { 285 => 0x300 },
	'predictor' => { 115 => 0x13d },
	'preflashreturnstrength' => { 232 => 0x28a },
	'prefs' => { 127 => 0xdd, 350 => 'Prefs' },
	'prereadfastresetcount' => { 133 => 0x187e },
	'preservedfilename' => { 483 => 'PreservedFileName' },
	'preservedspecimen' => { 114 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 114 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 176 => 0x24, 434 => 0x8002 },
	'presetwhitebalanceadj' => { 434 => 0x8014 },
	'pressure' => { 115 => 0x9402, 463 => 'Pressure' },
	'previewapplicationname' => { 115 => 0xc716 },
	'previewapplicationversion' => { 115 => 0xc717 },
	'previewbutton' => { 263 => ['14.1','15.1'], 264 => '15.1', 266 => '15.1', 267 => '15.1', 272 => '29.1', 273 => '14.1', 276 => '15.1', 277 => '15.1' },
	'previewbuttonplusdials' => { 263 => ['14.2','15.2'], 264 => '15.2', 266 => '43.1', 267 => '43.1', 272 => '31.2', 276 => '43.1', 277 => '43.1' },
	'previewcolorspace' => { 115 => 0xc71a },
	'previewcropbottom' => { 349 => 0xef },
	'previewcropleft' => { 349 => 0xec },
	'previewcropright' => { 349 => 0xee },
	'previewcroptop' => { 349 => 0xed },
	'previewdate' => { 361 => 0x0 },
	'previewdatetime' => { 115 => 0xc71b },
	'previewimage' => { 109 => 0x2000, 110 => 'Exif::PreviewImage', 116 => 'PreviewImage', 118 => 0x4, 159 => 'data', 178 => 0x81, 285 => 0x280, 301 => 0x300, 401 => 0x2001 },
	'previewimageborders' => { 338 => 0x3e },
	'previewimageheight' => { 70 => 0x4, 137 => 0xfa58 },
	'previewimagelength' => { 70 => 0x2, 109 => 0x3, 115 => [0x117,0x202], 178 => 0x89, 221 => 0x202, 280 => 0x102, 285 => 0x1037, 338 => 0x3, 369 => 0x1e, 374 => 0x3, 380 => [0x1b,0x1d], 391 => 0x202 },
	'previewimagename' => { 159 => '1Name' },
	'previewimagesize' => { 109 => 0x2, 142 => 0x2, 159 => 'ImageSize', 338 => 0x2, 380 => [0x1c,0x1e], 401 => 0xb02c, 434 => 0x9012 },
	'previewimagestart' => { 70 => 0x5, 109 => 0x4, 115 => [0x111,0x201], 178 => 0x88, 221 => 0x201, 280 => 0x101, 285 => 0x1036, 338 => 0x4, 369 => 0x1c, 374 => 0x2, 380 => [0x1a,0x1c], 391 => 0x201 },
	'previewimagetype' => { 159 => '0Type' },
	'previewimagevalid' => { 280 => 0x100, 285 => 0x1035 },
	'previewimagewidth' => { 70 => 0x3, 137 => 0xfa57 },
	'previewquality' => { 70 => 0x1 },
	'previewsettingsdigest' => { 115 => 0xc719 },
	'previewsettingsname' => { 115 => 0xc718 },
	'primaryafpoint' => { 185 => [0x44,0x7] },
	'primarychromaticities' => { 115 => 0x13f, 478 => 'PrimaryChromaticities' },
	'primaryftp' => { 446 => 'PrimaryFTP' },
	'primaryslot' => { 235 => 0xe7f, 244 => 0xfbf },
	'printim' => { 115 => 0xc4a5 },
	'prioritysetinawb' => { 401 => 0x202b },
	'prioritysetupshutterrelease' => { 176 => 0x1d, 388 => 0x28 },
	'privatertkinfo' => { 448 => 'privateRTKInfo' },
	'processbordercolsleft' => { 133 => 0xc61 },
	'processbordercolsright' => { 133 => 0xc62 },
	'processborderrowsbottom' => { 133 => 0xc64 },
	'processborderrowstop' => { 133 => 0xc63 },
	'processingsoftware' => { 115 => 0xb },
	'processversion' => { 456 => 'ProcessVersion', 458 => 'ProcessVersion' },
	'producer' => { 289 => 'Producer', 357 => 'producer', 363 => "\xa9prd", 469 => 'Producer' },
	'producerkeywords' => { 363 => "\xa9pdk" },
	'productcode' => { 472 => 'productCode' },
	'productid' => { 128 => 0x32, 355 => 'prID', 471 => 'productID' },
	'productidtype' => { 471 => 'productIDType' },
	'productinimage' => { 468 => 'ProductInImage' },
	'productinimagedescription' => { 468 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 468 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 468 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 318 => 0x2 },
	'productorserviceconstraints' => { 290 => 'ProductOrServiceConstraints' },
	'productversion' => { 355 => 'VERS' },
	'profession' => { 472 => 'profession' },
	'profilecalibrationsig' => { 115 => 0xc6f4 },
	'profilecopyright' => { 115 => 0xc6fe },
	'profileembedpolicy' => { 115 => 0xc6fd },
	'profilehuesatmapdata1' => { 115 => 0xc6fa },
	'profilehuesatmapdata2' => { 115 => 0xc6fb },
	'profilehuesatmapdims' => { 115 => 0xc6f9 },
	'profilehuesatmapencoding' => { 115 => 0xc7a3 },
	'profilelooktabledata' => { 115 => 0xc726 },
	'profilelooktabledims' => { 115 => 0xc725 },
	'profilelooktableencoding' => { 115 => 0xc7a4 },
	'profilename' => { 115 => 0xc6f8 },
	'profiletonecurve' => { 115 => 0xc6fc },
	'programiso' => { 303 => 0x3c },
	'programline' => { 319 => '1.1' },
	'programmode' => { 181 => 0x5 },
	'programshift' => { 216 => 0xd },
	'programversion' => { 127 => 0x46 },
	'prohibits' => { 454 => 'prohibits' },
	'projectiontype' => { 444 => 'ProjectionType', 445 => 'ProjectionType' },
	'projectname' => { 482 => 'projectName' },
	'projectref' => { 482 => 'projectRef' },
	'projectrefpath' => { 482 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 482 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 290 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 290 => 'PropertyReleaseStatus' },
	'province-state' => { 127 => 0x5f },
	'publicationdate' => { 472 => 'publicationDate' },
	'publicationdatea-platform' => { 472 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 472 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 472 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 472 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 472 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 468 => 'PublicationEvent' },
	'publicationeventdate' => { 468 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 468 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 468 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 472 => 'publicationName' },
	'publisher' => { 355 => "\xa9pub", 357 => 'publisher', 459 => 'publisher' },
	'publishingfrequency' => { 472 => 'publishingFrequency' },
	'pulldown' => { 482 => 'pullDown' },
	'purchasedate' => { 355 => 'purd' },
	'purplehsl' => { 99 => 0x20916 },
	'pxshiftperiphedgenr' => { 434 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 434 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 108 => 0x2, 109 => 0x3002, 123 => 0x1000, 135 => 0x9, 216 => 0x4, 246 => 0x3, 285 => 0x201, 298 => 0x300, 338 => 0x8, 345 => 0x2, 380 => 0x16, 388 => 0x56, 389 => 0x56, 390 => 0xb, 401 => [0x102,0x202e] },
	'quality2' => { 409 => 0x1170, 410 => 0x1174, 411 => 0x1150, 413 => 0x11a8, 414 => 0x1060, 415 => 0x258, 416 => 0x258, 417 => 0x247, 421 => 0x29, 422 => 0x25, 423 => 0x2a },
	'qualitymode' => { 109 => 0x8 },
	'quantizationmethod' => { 129 => 0x78 },
	'quickadjust' => { 259 => 0x2a },
	'quickcontroldialinmeter' => { 80 => 0x703 },
	'quickfix' => { 256 => 0x416391c6 },
	'quickshot' => { 379 => 0x213 },
	'quiettime' => { 133 => 0x188a },
	'rads' => { 363 => 'rads' },
	'rangefinder' => { 268 => '4.1', 269 => '5.1', 270 => '5.1' },
	'rasterizedcaption' => { 127 => 0x7d },
	'rating' => { 115 => 0x4746, 123 => 0x1431, 349 => 0xdf, 355 => 'rtng', 401 => 0x2002, 451 => 'rating', 460 => 'rating', 468 => 'Rating', 472 => 'rating', 480 => 'Rating' },
	'ratingpercent' => { 115 => 0x4749, 171 => 'Rating', 355 => 'rate' },
	'ratingregion' => { 468 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 468 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 468 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 468 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 468 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 468 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 468 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 468 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 468 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 468 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 468 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 468 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 468 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 468 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 468 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 468 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 468 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 468 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 78 => 0x8, 178 => 0x109, 319 => 0xd },
	'rawbrightnessadj' => { 99 => 0x20001, 104 => 0x38 },
	'rawburstimagecount' => { 72 => 0x2 },
	'rawburstimagenum' => { 72 => 0x1 },
	'rawcoloradj' => { 104 => 0x2e },
	'rawcropbottom' => { 349 => 0xd4 },
	'rawcropleft' => { 349 => 0xd1 },
	'rawcropright' => { 349 => 0xd3 },
	'rawcroptop' => { 349 => 0xd2 },
	'rawcustomsaturation' => { 104 => 0x30 },
	'rawcustomtone' => { 104 => 0x34 },
	'rawdata' => { 377 => 0xa048 },
	'rawdatabyteorder' => { 377 => 0x40 },
	'rawdatacfapattern' => { 377 => 0x50 },
	'rawdatauniqueid' => { 115 => 0xc65d },
	'rawdepth' => { 180 => 0x10 },
	'rawdevartfilter' => { 287 => 0x121 },
	'rawdevautogradation' => { 287 => 0x119 },
	'rawdevcolorspace' => { 286 => 0x108, 287 => 0x109 },
	'rawdevcontrastvalue' => { 286 => 0x106, 287 => 0x105 },
	'rawdeveditstatus' => { 286 => 0x10b },
	'rawdevelopmentprocess' => { 338 => 0x62 },
	'rawdevengine' => { 286 => 0x109, 287 => 0x10b },
	'rawdevexposurebiasvalue' => { 286 => 0x100, 287 => 0x100 },
	'rawdevgradation' => { 287 => 0x112 },
	'rawdevgraypoint' => { 286 => 0x103, 287 => 0x104 },
	'rawdevmemorycoloremphasis' => { 286 => 0x105, 287 => 0x108 },
	'rawdevnoisereduction' => { 286 => 0x10a, 287 => 0x10a },
	'rawdevpicturemode' => { 287 => 0x10c },
	'rawdevpm_bwfilter' => { 287 => 0x110 },
	'rawdevpmcontrast' => { 287 => 0x10e },
	'rawdevpmnoisefilter' => { 287 => 0x120 },
	'rawdevpmpicturetone' => { 287 => 0x111 },
	'rawdevpmsaturation' => { 287 => 0x10d },
	'rawdevpmsharpness' => { 287 => 0x10f },
	'rawdevsaturation3' => { 287 => 0x113 },
	'rawdevsaturationemphasis' => { 286 => 0x104, 287 => 0x107 },
	'rawdevsettings' => { 286 => 0x10c },
	'rawdevsharpnessvalue' => { 286 => 0x107, 287 => 0x106 },
	'rawdevversion' => { 286 => 0x0, 287 => 0x0 },
	'rawdevwbfineadjustment' => { 286 => 0x102, 287 => 0x103 },
	'rawdevwhitebalance' => { 287 => 0x101 },
	'rawdevwhitebalancevalue' => { 286 => 0x101, 287 => 0x102 },
	'rawfile' => { 115 => 0xfe4c },
	'rawfilename' => { 456 => 'RawFileName', 458 => 'RawFileName' },
	'rawfiletype' => { 401 => 0x2029 },
	'rawformat' => { 308 => 0x2d, 347 => 0x10e },
	'rawimagecenter' => { 216 => 0x99 },
	'rawimagedigest' => { 115 => 0xc71c },
	'rawimagesize' => { 338 => 0x39 },
	'rawinfoversion' => { 288 => 0x0 },
	'rawjpgheight' => { 95 => 0x4 },
	'rawjpgquality' => { 55 => 0x6, 95 => 0x1 },
	'rawjpgsize' => { 55 => 0x7, 95 => 0x2 },
	'rawjpgwidth' => { 95 => 0x3 },
	'rawmeasuredrggb' => { 41 => 0x26a, 43 => 0x280, 45 => 0x194, 46 => [0x1ad,0x26b] },
	'rawrppused' => { 451 => 'rawrppused' },
	'rawtopreviewgain' => { 115 => 0xc7a8 },
	'readouttypeactual' => { 133 => 0x1903 },
	'readouttyperequested' => { 133 => 0x1902 },
	'reardisplay' => { 263 => '12.3', 264 => '6.2' },
	'recdevice' => { 468 => 'RecDevice' },
	'recdeviceattlensdescription' => { 468 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 468 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 468 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 468 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 468 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 474 => 'recipeEndingPage' },
	'recipepagerange' => { 474 => 'recipePageRange' },
	'recipesource' => { 474 => 'recipeSource' },
	'recipestartingpage' => { 474 => 'recipeStartingPage' },
	'recipetitle' => { 474 => 'recipeTitle' },
	'recognizedface1age' => { 296 => 0x20 },
	'recognizedface1name' => { 296 => 0x4 },
	'recognizedface1position' => { 296 => 0x18 },
	'recognizedface2age' => { 296 => 0x50 },
	'recognizedface2name' => { 296 => 0x34 },
	'recognizedface2position' => { 296 => 0x48 },
	'recognizedface3age' => { 296 => 0x80 },
	'recognizedface3name' => { 296 => 0x64 },
	'recognizedface3position' => { 296 => 0x78 },
	'recognizedfaceflags' => { 303 => 0x63 },
	'recommendedexposureindex' => { 115 => 0x8832, 463 => 'RecommendedExposureIndex' },
	'record' => { 114 => 'Record' },
	'recordbasisofrecord' => { 114 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 114 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 114 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 114 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 114 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 114 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 176 => 0x4d },
	'recorddynamicproperties' => { 114 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 93 => 0x1804 },
	'recordinformationwithheld' => { 114 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 363 => "\xa9phg" },
	'recordingformat' => { 370 => 0x1000 },
	'recordingmode' => { 108 => 0x1, 345 => 0x1 },
	'recordinstitutioncode' => { 114 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 114 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 363 => "\xa9lab" },
	'recordlabelurl' => { 363 => "\xa9lal" },
	'recordmode' => { 34 => 0x9, 109 => 0x3000 },
	'recordownerinstitutioncode' => { 114 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 379 => 0x217 },
	'redbalance' => { 285 => 0x1017, 308 => 0x11, 338 => 0x1c },
	'redcurvelimits' => { 104 => 0x18a },
	'redcurvepoints' => { 103 => 0x2d, 104 => 0x160 },
	'redeyecorrection' => { 260 => 0x0 },
	'redeyeinfo' => { 456 => 'RedEyeInfo', 458 => 'RedEyeInfo' },
	'redeyereduction' => { 176 => 0x41, 388 => 0x6a, 390 => 0x28 },
	'redeyeremoval' => { 303 => 0xb9 },
	'redhsl' => { 99 => 0x20910 },
	'redhue' => { 456 => 'RedHue', 458 => 'RedHue' },
	'redsaturation' => { 456 => 'RedSaturation', 458 => 'RedSaturation' },
	'reductionmatrix1' => { 115 => 0xc625 },
	'reductionmatrix2' => { 115 => 0xc626 },
	'reelname' => { 115 => 0xc789, 363 => 'reel' },
	'reference1' => { 466 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 466 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 115 => 0x214, 478 => 'ReferenceBlackWhite' },
	'referencedate' => { 127 => 0x2f },
	'referencenumber' => { 127 => 0x32 },
	'references' => { 150 => 'References' },
	'referenceservice' => { 127 => 0x2d },
	'regionappliedtodimensions' => { 165 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 165 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 165 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 165 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 165 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 165 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 165 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 165 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 165 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 165 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 165 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 165 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 290 => 'RegionConstraints' },
	'regiondescription' => { 165 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 165 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 165 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 165 => 'Regions' },
	'regioninfodateregionsvalid' => { 168 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 168 => 'RegionInfo' },
	'regioninforegions' => { 168 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 165 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 165 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 168 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 168 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 168 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 168 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 168 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 165 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 165 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 165 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 468 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 468 => 'RegistryId' },
	'registryitemid' => { 468 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 468 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 148 => 'data' },
	'relatedaudiofilename' => { 148 => '1Name' },
	'relatedaudiofiletype' => { 148 => '0Type' },
	'relatedimagefileformat' => { 115 => 0x1000 },
	'relatedimageheight' => { 115 => 0x1002 },
	'relatedimagewidth' => { 115 => 0x1001 },
	'relatedresourceid' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 115 => 0xa004, 462 => 'RelatedSoundFile' },
	'relatedvideofile' => { 162 => 'data' },
	'relatedvideofilename' => { 162 => '1Name' },
	'relatedvideofiletype' => { 162 => '0Type' },
	'relation' => { 459 => 'relation' },
	'relationshipaccordingto' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 114 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 112 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 482 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 482 => 'relativeTimestamp' },
	'relativetimestampscale' => { 482 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 482 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 263 => '17.8', 264 => '18.5', 266 => '18.4', 267 => '18.4', 272 => '33.8', 273 => '17.6', 276 => '18.5', 277 => '18.4' },
	'releasedate' => { 127 => 0x1e, 355 => 'rldt', 451 => 'ReleaseDate', 482 => 'releaseDate' },
	'releasemode' => { 109 => 0x3001, 234 => 0x184d, 401 => 0xb049 },
	'releasemode2' => { 409 => 0x112c, 410 => [0x112c,0x8], 411 => [0x1108,0x8], 412 => [0x1184,0x8], 413 => [0x1160,0x8], 414 => [0x4,0x1018], 415 => [0x4,0x210], 416 => [0x4,0x210], 417 => [0x4,0x208], 419 => [0x67,0x3f], 420 => [0x6b,0x6d,0x73,0x4b], 421 => 0x10, 422 => 0x10, 423 => 0x9, 430 => 0x34 },
	'releasemode3' => { 409 => 0x1128, 410 => 0x1128, 411 => 0x1104, 412 => 0x1180, 413 => 0x115c, 414 => 0x1014, 415 => 0x20c, 416 => 0x20c, 417 => 0x204 },
	'releaseready' => { 468 => 'ReleaseReady' },
	'releasesetting' => { 93 => 0x1016 },
	'releasetime' => { 127 => 0x23, 451 => 'ReleaseTime' },
	'remoteonduration' => { 265 => '3.4', 268 => '17.2', 269 => '18.2', 270 => '18.2', 271 => '18.2', 273 => '18.2', 274 => '4.3', 278 => '19.2' },
	'renditionclass' => { 483 => 'RenditionClass' },
	'renditionof' => { 483 => 'RenditionOf' },
	'renditionofalternatepaths' => { 483 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 483 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 483 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 483 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 483 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 483 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 483 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 483 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 483 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 483 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 483 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 483 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 483 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 483 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 483 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 483 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 483 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 483 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 483 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 483 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 483 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 483 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 483 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 483 => 'RenditionParams' },
	'repeatingflashcount' => { 200 => 0xd, 201 => 0xe, 202 => 0xe, 203 => 0xe, 204 => 0xe, 272 => '17.2', 273 => '24.2', 274 => '9.2', 275 => '24.2', 278 => '25.2' },
	'repeatingflashcountbuilt-in' => { 242 => 0x4db },
	'repeatingflashcountexternal' => { 242 => 0x4c3 },
	'repeatingflashoutput' => { 272 => '17.1', 273 => '24.1', 274 => '9.1', 275 => '24.1', 278 => '25.1' },
	'repeatingflashoutputexternal' => { 242 => 0x4c0 },
	'repeatingflashrate' => { 200 => 0xc, 201 => 0xd, 202 => 0xd, 203 => 0xd, 204 => 0xd, 272 => '18.1', 273 => '25.1', 274 => '10.1', 275 => '25.1', 278 => '26.1' },
	'repeatingflashratebuilt-in' => { 242 => 0x4da },
	'repeatingflashrateexternal' => { 242 => 0x4c2 },
	'requirements' => { 363 => "\xa9req" },
	'requires' => { 454 => 'requires' },
	'resampleparams' => { 482 => 'resampleParams' },
	'resampleparamsquality' => { 482 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 133 => 0xe50 },
	'resamplingkerneldenominators067' => { 133 => 0xe4f },
	'resamplingkerneldenominators100' => { 133 => 0xe51 },
	'resaved' => { 379 => 0x21e },
	'resetblacksegrows' => { 133 => 0x181a },
	'resolution' => { 155 => 'Resolution' },
	'resolutionmode' => { 380 => [0x87,0x4] },
	'resolutionunit' => { 115 => 0x128, 130 => 0x2, 478 => 'ResolutionUnit' },
	'resourceid' => { 114 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 114 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 114 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 80 => 0x612 },
	'restrictions' => { 475 => 'restrictions' },
	'retouchareafeather' => { 456 => [\'RetouchAreas','RetouchAreasFeather'], 458 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 456 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 458 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 456 => [\'RetouchAreas','RetouchAreasMasksAngle'], 458 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 456 => [\'RetouchAreas','RetouchAreasMasksBottom'], 458 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 456 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 458 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 456 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 458 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 456 => [\'RetouchAreas','RetouchAreasMasksDabs'], 458 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 456 => [\'RetouchAreas','RetouchAreasMasksFeather'], 458 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 456 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 458 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 456 => [\'RetouchAreas','RetouchAreasMasksFlow'], 458 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 456 => [\'RetouchAreas','RetouchAreasMasksFullX'], 458 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 456 => [\'RetouchAreas','RetouchAreasMasksFullY'], 458 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 456 => [\'RetouchAreas','RetouchAreasMasksLeft'], 458 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 456 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 458 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 456 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 458 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 456 => [\'RetouchAreas','RetouchAreasMasksRadius'], 458 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 456 => [\'RetouchAreas','RetouchAreasMasksRight'], 458 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 456 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 458 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 456 => [\'RetouchAreas','RetouchAreasMasks'], 458 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 456 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 458 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 456 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 458 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 456 => [\'RetouchAreas','RetouchAreasMasksTop'], 458 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 456 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 458 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 456 => [\'RetouchAreas','RetouchAreasMasksVersion'], 458 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 456 => [\'RetouchAreas','RetouchAreasMasksWhat'], 458 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 456 => [\'RetouchAreas','RetouchAreasMasksX'], 458 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 456 => [\'RetouchAreas','RetouchAreasMasksY'], 458 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 456 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 458 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 456 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 458 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 456 => [\'RetouchAreas','RetouchAreasMethod'], 458 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 456 => [\'RetouchAreas','RetouchAreasOffsetY'], 458 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 456 => [\'RetouchAreas','RetouchAreasOpacity'], 458 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 456 => 'RetouchAreas', 458 => 'RetouchAreas' },
	'retouchareaseed' => { 456 => [\'RetouchAreas','RetouchAreasSeed'], 458 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 456 => [\'RetouchAreas','RetouchAreasSourceState'], 458 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 456 => [\'RetouchAreas','RetouchAreasSourceX'], 458 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 456 => [\'RetouchAreas','RetouchAreasSpotType'], 458 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 216 => 0x9e },
	'retouchinfo' => { 456 => 'RetouchInfo', 458 => 'RetouchInfo' },
	'retouchnefprocessing' => { 223 => 0x5 },
	'retractlensonpoweroff' => { 80 => 0x814 },
	'reuse' => { 290 => 'Reuse' },
	'reuseallowed' => { 485 => 'ReuseAllowed' },
	'reuseprohibited' => { 475 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 270 => '5.2' },
	'reverseindicators' => { 263 => '12.1', 264 => '6.1', 266 => '6.1', 267 => '6.1', 268 => '4.3', 269 => '5.2', 270 => '5.4', 272 => '33.5', 273 => '5.1', 276 => '6.1', 277 => '6.1', 278 => '6.2' },
	'reverseshutterspeedaperture' => { 270 => '5.3' },
	'revision' => { 460 => 'revision' },
	'rflensmffocusringsensitivity' => { 80 => 0x714 },
	'rgbcurvelimits' => { 104 => 0x238 },
	'rgbcurvepoints' => { 103 => 0x7, 104 => 0x20e },
	'richtextcomment' => { 465 => 'RichTextComment' },
	'ricohdate' => { 369 => 0x6 },
	'ricohimageheight' => { 369 => 0x2 },
	'ricohimagewidth' => { 369 => 0x0 },
	'rightalbedo' => { 447 => 'RightAlbedo' },
	'rightascension' => { 158 => 'RightAscension' },
	'rights' => { 459 => 'rights' },
	'rightsagent' => { 475 => 'rightsAgent' },
	'rightsowner' => { 475 => 'rightsOwner' },
	'roll' => { 111 => 0x8, 363 => ['roll',"\xa9frl"] },
	'rollangle' => { 234 => 0x350b, 235 => 0x2c24, 243 => 0x36f4, 280 => 0x903, 303 => 0x90, 337 => 0x1, 375 => 0x2 },
	'romoperationmode' => { 93 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 92 => 0x3, 99 => 0x10002, 104 => 0x26e, 110 => 'QuickTime::Rotation', 119 => 0x4, 158 => 'Rotation', 174 => [0x65,0x50], 175 => 0x46, 176 => 0x5a, 179 => 0x10, 234 => 0x3693, 235 => 0xca, 241 => '590.1', 256 => 0x76a43207, 303 => 0x30, 319 => '17.2', 349 => 0xd8, 356 => 'irot', 388 => 0x3f, 389 => 0x3f, 399 => 0x10 },
	'routedto' => { 464 => 'RoutedTo' },
	'routing' => { 354 => 'Routing' },
	'routingdestinations' => { 446 => 'RoutingDestinations' },
	'routingexclusions' => { 446 => 'RoutingExclusions' },
	'routingnotes' => { 464 => 'RoutingNotes' },
	'rowsperstrip' => { 115 => 0x116 },
	'rpp' => { 451 => 'rpp' },
	'rtkflag' => { 112 => 'RtkFlag' },
	'rtkstdhgt' => { 112 => 'RtkStdHgt' },
	'rtkstdlat' => { 112 => 'RtkStdLat' },
	'rtkstdlon' => { 112 => 'RtkStdLon' },
	'safetyshift' => { 80 => 0x108 },
	'safetyshiftinavortv' => { 78 => 0x10, 79 => 0x10, 81 => 0xf, 82 => 0x10, 85 => 0x10 },
	'sameexposurefornewaperture' => { 80 => 0x112 },
	'samplebits' => { 148 => 'SampleBits' },
	'samplepagerange' => { 472 => 'samplePageRange' },
	'samplerate' => { 148 => 'SampleRate' },
	'samplesperpixel' => { 115 => 0x115, 308 => 0x8, 478 => 'SamplesPerPixel' },
	'samplestructure' => { 129 => 0x5a },
	'samsungmodelid' => { 377 => 0x3 },
	'sanyoquality' => { 379 => 0x201 },
	'sanyothumbnail' => { 379 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 49 => 0x1, 108 => 0xd, 109 => [0x3013,0x1f], 115 => [0xa409,0xfe55], 123 => 0x1003, 149 => 'Saturation', 173 => 0x1f, 174 => 0x32, 175 => 0x28, 176 => 0x1a, 181 => 0x1, 216 => 0xaa, 218 => 0x35, 219 => 0x3b, 220 => 0x43, 303 => 0x40, 305 => 0x300d, 338 => 0x1f, 345 => 0xd, 364 => 0x27, 366 => 0x58, 369 => 0x28, 370 => 0x1013, 380 => 0x10, 388 => 0x1e, 389 => 0x1b, 401 => 0x2005, 456 => 'Saturation', 458 => 'Saturation', 462 => 'Saturation' },
	'saturationadj' => { 99 => 0x20901, 104 => 0x116, 216 => 0x94, 255 => 0x1, 259 => 0x2e, 434 => 0x8016 },
	'saturationadjustmentaqua' => { 456 => 'SaturationAdjustmentAqua', 458 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 456 => 'SaturationAdjustmentBlue', 458 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 456 => 'SaturationAdjustmentGreen', 458 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 456 => 'SaturationAdjustmentMagenta', 458 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 456 => 'SaturationAdjustmentOrange', 458 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 456 => 'SaturationAdjustmentPurple', 458 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 456 => 'SaturationAdjustmentRed', 458 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 456 => 'SaturationAdjustmentYellow', 458 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 68 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 67 => 0x68, 68 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 67 => 0x38, 68 => 0x38 },
	'saturationmonochrome' => { 67 => 0x80, 68 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 67 => 0x50, 68 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 67 => 0x20, 68 => 0x20 },
	'saturationsetting' => { 288 => 0x1010, 390 => 0x11, 406 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 67 => 0x8, 68 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 67 => 0x98, 68 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 67 => 0xb0, 68 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 67 => 0xc8, 68 => 0xe0 },
	'saveid' => { 483 => 'SaveID' },
	'sbaanalysiscomplete' => { 133 => 0xc35 },
	'sbablack' => { 133 => 0xc25 },
	'sbagmoffset' => { 133 => 0xc4a },
	'sbagray' => { 133 => 0xc26 },
	'sbagreenmagentabal' => { 133 => 0xc33 },
	'sbahighgray' => { 133 => 0xc46 },
	'sbailloffset' => { 133 => 0xc49 },
	'sbailluminantbal' => { 133 => 0xc34 },
	'sbalowgray' => { 133 => 0xc47 },
	'sbaneutralbal' => { 133 => 0xc32 },
	'sbawhite' => { 133 => 0xc27 },
	'scaletype' => { 482 => 'scaleType' },
	'scanimageenhancer' => { 224 => 0x60 },
	'scanningdirection' => { 129 => 0x64 },
	'scene' => { 363 => 'scen', 467 => 'Scene', 482 => 'scene' },
	'scenearea' => { 283 => 0x211, 285 => 0x1031 },
	'sceneassist' => { 216 => 0x9c },
	'scenecapturetype' => { 115 => 0xa406, 462 => 'SceneCaptureType' },
	'scenedetect' => { 283 => 0x210, 285 => 0x1030 },
	'scenedetectdata' => { 283 => 0x212, 285 => 0x1033 },
	'scenemode' => { 137 => 0xfa02, 178 => 0x100, 216 => 0x8f, 280 => 0x509, 285 => 0x403, 303 => 0x8001, 312 => 0xf, 401 => 0xb023 },
	'scenemodeused' => { 139 => [0x6002,0xf002] },
	'scenerecognition' => { 123 => 0x1425 },
	'sceneselect' => { 379 => 0x21f },
	'scenetype' => { 115 => 0xa301, 462 => 'SceneType' },
	'screentips' => { 263 => '12.7', 264 => '5.3', 272 => '13.1', 273 => '4.4', 276 => '5.4', 278 => '5.1' },
	'scriptversion' => { 133 => 0x1770 },
	'season' => { 468 => 'Season', 471 => 'season' },
	'seasonidentifier' => { 468 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 468 => [\'Season','SeasonName'] },
	'seasonnumber' => { 468 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 446 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 234 => 0x1d0, 243 => 0x1d0 },
	'section' => { 472 => 'section' },
	'securityclassification' => { 115 => 0x9212 },
	'selectableafpoint' => { 80 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 80 => 0x512 },
	'selfdata' => { 112 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 303 => 0x2e, 379 => 0x214, 409 => 0x1134, 410 => 0x1134, 411 => 0x1110, 412 => 0x118c, 413 => 0x1168, 414 => 0x1020, 415 => 0x218, 416 => 0x218, 417 => 0x210 },
	'selftimer2' => { 74 => 0x1d },
	'selftimerinterval' => { 273 => '19.2' },
	'selftimermode' => { 115 => 0x882b },
	'selftimershotcount' => { 264 => '20.2', 266 => '20.3', 267 => '20.3', 268 => '18.2', 269 => '19.2', 270 => '19.2', 271 => '19.3', 273 => '19.3', 276 => '20.3', 277 => '20.3', 278 => '20.2' },
	'selftimershotinterval' => { 264 => '20.3', 266 => '20.2', 267 => '20.2', 271 => '19.2', 276 => '20.2', 277 => '20.2' },
	'selftimertime' => { 93 => 0x1806, 176 => 0x1f, 263 => '18.1', 264 => '20.1', 265 => '3.3', 266 => '20.1', 267 => '20.1', 268 => '18.1', 269 => '19.1', 270 => '19.1', 271 => '19.1', 272 => '7.2', 273 => '19.1', 274 => '3.3', 276 => '20.1', 277 => '20.1', 278 => '20.1' },
	'sellingagency' => { 472 => 'sellingAgency' },
	'seminfo' => { 115 => 0x8546 },
	'sensingmethod' => { 115 => 0xa217, 462 => 'SensingMethod' },
	'sensitivityadjust' => { 338 => 0x40 },
	'sensitivitysteps' => { 319 => ['14.3','17.4'], 321 => 0x1 },
	'sensitivitytype' => { 115 => 0x8830, 463 => 'SensitivityType' },
	'sensor' => { 183 => 0x665e },
	'sensorarea' => { 285 => 0x400 },
	'sensorareas' => { 377 => 0xa010 },
	'sensorbitdepth' => { 305 => 0x312d },
	'sensorbluelevel' => { 71 => 0x5 },
	'sensorcalibration' => { 284 => 0x805 },
	'sensorcleaning' => { 86 => 0xd },
	'sensorfullheight' => { 132 => 0xf904 },
	'sensorfullwidth' => { 132 => 0xf903 },
	'sensorheight' => { 132 => 0xf901, 137 => 0xfa21, 180 => 0x8, 305 => 0x312c, 347 => 0x109, 370 => 0x1602 },
	'sensorimageheight' => { 133 => 0x3ee },
	'sensorimagewidth' => { 133 => 0x3ed },
	'sensorleftborder' => { 133 => 0x3eb },
	'sensorleftmargin' => { 347 => 0x10a },
	'sensorpixelsize' => { 216 => 0x9a },
	'sensorredlevel' => { 71 => 0x4 },
	'sensorserialnumber' => { 133 => 0x9ce },
	'sensorsize' => { 149 => 'SensorSize', 338 => 0x35 },
	'sensortemperature' => { 283 => 0x1500, 285 => 0x1007, 343 => 0xc, 347 => 0x210, 380 => [0x39,0x55] },
	'sensortemperature2' => { 343 => 0xe, 347 => 0x211 },
	'sensortopborder' => { 133 => 0x3ec },
	'sensortopmargin' => { 347 => 0x10b },
	'sensorwidth' => { 132 => 0xf900, 137 => 0xfa20, 180 => 0xa, 305 => 0x312b, 347 => 0x108, 370 => 0x1601 },
	'sequence' => { 364 => 0x7, 365 => 0x35, 366 => 0x36 },
	'sequencefilenumber' => { 410 => 0x4, 411 => 0x4, 412 => 0x4, 413 => 0x4, 421 => 0xc, 422 => 0xc, 423 => 0x1a },
	'sequenceimagenumber' => { 410 => 0x0, 411 => 0x0, 412 => 0x0, 413 => 0x0, 421 => 0x8, 422 => 0x8, 423 => 0x12, 430 => 0x24 },
	'sequencelength' => { 421 => 0x22, 422 => 0x1e, 423 => [0x16,0x1e] },
	'sequencename' => { 471 => 'sequenceName' },
	'sequencenumber' => { 74 => 0x9, 109 => 0x301c, 123 => 0x1101, 135 => 0x1d, 242 => 0x51c, 303 => 0x2b, 390 => [0x10c,0x30c], 401 => 0xb04a, 471 => 'sequenceNumber' },
	'sequenceshotinterval' => { 379 => 0x224 },
	'sequencetotalnumber' => { 471 => 'sequenceTotalNumber' },
	'sequentialshot' => { 379 => 0x20e },
	'serialnumber' => { 61 => 0xc, 93 => 0x180b, 115 => [0xa431,0xfde9], 132 => 0xfa04, 134 => 0xfa00, 136 => 0xc354, 137 => 0xfa19, 146 => 0x0, 149 => 'SerialNumber', 183 => 0x5501, 216 => [0xa0,0x1d], 281 => 0x101, 285 => [0x404,0x101a], 298 => 0x303, 300 => 0x305, 305 => 0x3103, 338 => 0x229, 347 => 0x102, 348 => 0x407, 363 => ['SNum','slno'], 364 => 0x15, 365 => 0x4b, 366 => 0x7e, 370 => 0x5, 377 => 0xa002, 380 => 0x2, 401 => 0x2031, 453 => 'SerialNumber', 463 => 'BodySerialNumber' },
	'serialnumberformat' => { 61 => 0x15, 93 => 0x183b },
	'serialnumberhash' => { 363 => 'CAME' },
	'series' => { 468 => 'Series' },
	'seriesdatetime' => { 436 => 'SeriesDateTime' },
	'seriesdescription' => { 436 => 'SeriesDescription' },
	'seriesidentifier' => { 468 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 436 => 'SeriesModality' },
	'seriesname' => { 468 => [\'Series','SeriesName'] },
	'seriesnumber' => { 436 => 'SeriesNumber', 472 => 'seriesNumber' },
	'seriestitle' => { 472 => 'seriesTitle' },
	'serviceidentifier' => { 128 => 0x1e },
	'servingsize' => { 474 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 83 => 0x0, 84 => 0x0 },
	'setbuttonwhenshooting' => { 78 => 0x1, 80 => 0x704, 86 => 0xc },
	'setfunctionwhenshooting' => { 81 => 0x0, 82 => 0x1, 85 => 0x1 },
	'setting' => { 471 => 'setting' },
	'shadingcompensation' => { 280 => 0x50c, 303 => 0x8a },
	'shadingcompensation2' => { 284 => 0x1012 },
	'shadow' => { 380 => 0xe },
	'shadowadj' => { 99 => 0x2030b },
	'shadowcorrection' => { 338 => 0x79 },
	'shadowprotection' => { 255 => 0x0 },
	'shadows' => { 115 => 0xfe52, 450 => 'Shadows', 456 => 'Shadows', 458 => 'Shadows' },
	'shadows2012' => { 456 => 'Shadows2012', 458 => 'Shadows2012' },
	'shadowsadj' => { 434 => 0x901a },
	'shadowscale' => { 115 => 0xc633 },
	'shadowtint' => { 456 => 'ShadowTint', 458 => 'ShadowTint' },
	'shadowtone' => { 123 => 0x1040 },
	'shakereduction' => { 340 => 0x1, 341 => 0x1 },
	'sharpendetail' => { 456 => 'SharpenDetail', 458 => 'SharpenDetail' },
	'sharpenedgemasking' => { 456 => 'SharpenEdgeMasking', 458 => 'SharpenEdgeMasking' },
	'sharpening' => { 305 => 0x300b },
	'sharpeningadj' => { 259 => 0x2b },
	'sharpeningkernel' => { 133 => 0x92f },
	'sharpenradius' => { 456 => 'SharpenRadius', 458 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 71 => 0x2, 108 => 0xb, 109 => [0x3011,0x21], 115 => [0xa40a,0xfe56], 123 => 0x1001, 135 => 0x6b, 144 => 0x37, 149 => 'Sharpness', 173 => 0x21, 174 => 0x30, 175 => 0x26, 176 => 0x18, 181 => 0x3, 216 => 0x6, 218 => 0x32, 219 => 0x33, 220 => 0x39, 285 => 0x100f, 303 => 0x41, 338 => 0x21, 345 => 0xb, 364 => 0x26, 366 => 0x56, 369 => 0x22, 370 => [0x1003,0x1014], 380 => 0x11, 388 => 0x1c, 389 => 0x19, 401 => 0x2006, 430 => 0x52, 456 => 'Sharpness', 458 => 'Sharpness', 462 => 'Sharpness' },
	'sharpnessadj' => { 99 => 0x20310, 104 => 0x25a, 434 => 0x801a },
	'sharpnessadjon' => { 99 => '0x20310.0' },
	'sharpnessauto' => { 68 => 0x94 },
	'sharpnessfactor' => { 285 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 67 => 0x64, 68 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 71 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 67 => 0x34, 68 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 67 => 0x7c, 68 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 67 => 0x4c, 68 => 0x4c },
	'sharpnessovershoot' => { 434 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 67 => 0x1c, 68 => 0x1c },
	'sharpnesssetting' => { 280 => 0x506, 288 => 0x1013, 390 => 0x12, 406 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 67 => 0x4, 68 => 0x4 },
	'sharpnessstrength' => { 99 => 0x20311 },
	'sharpnessthreshold' => { 434 => 0x801d },
	'sharpnessundershoot' => { 434 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 67 => 0x94, 68 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 67 => 0xac, 68 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 67 => 0xc4, 68 => 0xdc },
	'shiftcols' => { 133 => 0xc70 },
	'shootid' => { 471 => 'shootID' },
	'shootingdistance' => { 99 => 0x20701 },
	'shootinginfodisplay' => { 263 => '13.2', 264 => '5.1', 272 => '10.2', 273 => '4.1', 276 => '5.1', 278 => '5.3' },
	'shootinginfomonitorofftime' => { 263 => '26.2', 264 => '22.2', 266 => '22.2', 267 => '22.2', 271 => '21.2', 272 => '9.1', 273 => '21.2', 276 => '22.2', 277 => '22.2', 278 => '22.2' },
	'shootingmode' => { 149 => 'ShootingMode', 216 => 0x89, 303 => 0x1f },
	'shootingmodesetting' => { 265 => '5.1' },
	'shortdescription' => { 460 => 'shortdescription' },
	'shortdocumentid' => { 127 => 0xba },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 80 => 0x80d },
	'shorttitle' => { 355 => '@sti' },
	'shotdate' => { 482 => 'shotDate' },
	'shotday' => { 482 => 'shotDay' },
	'shotlocation' => { 482 => 'shotLocation' },
	'shotname' => { 363 => 'shot', 482 => 'shotName' },
	'shotnumber' => { 482 => 'shotNumber' },
	'shotnumbersincepowerup' => { 405 => 0x44e, 421 => 0x1a, 422 => 0x16, 423 => 0xa },
	'shotnumbersincepowerup2' => { 390 => 0x200 },
	'shotsize' => { 482 => 'shotSize' },
	'shownevent' => { 468 => 'EventExt' },
	'showneventidentifier' => { 468 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 468 => [\'EventExt','EventExtName'] },
	'shutter' => { 419 => 0x20, 420 => 0x26 },
	'shutter-aelock' => { 78 => 0x4, 80 => 0x701, 81 => 0x3, 82 => 0x4, 83 => 0x3, 84 => 0x3, 85 => 0x4, 86 => 0x2 },
	'shutteraelbutton' => { 79 => 0x4 },
	'shutterbuttonafonbutton' => { 80 => 0x701 },
	'shuttercount' => { 11 => 0x176, 55 => 0x1, 216 => 0xa7, 225 => [0x6a,0x157,0x24d], 226 => 0x286, 227 => 0x279, 228 => 0x284, 229 => 0x242, 230 => 0x280, 231 => 0x276, 232 => [0x27d,0x27f], 233 => 0x246, 236 => 0x2d6, 237 => 0x321, 238 => 0xbd8, 239 => 0x287, 240 => 0x320, 241 => 0x24a, 242 => 0x5fb, 245 => 0x2d5, 338 => 0x5d, 399 => 0x846, 404 => [0x125,0x14a], 419 => 0x32, 420 => 0x3a },
	'shuttercount2' => { 419 => 0x4c, 420 => [0x50,0x52,0x58] },
	'shuttercount3' => { 419 => [0x1a0,0x1aa,0x1bd], 420 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 78 => 0xf, 79 => 0xf, 80 => 0x305, 81 => 0xe, 82 => 0xf, 83 => 0x8, 84 => 0x8, 85 => 0xf, 86 => 0x8 },
	'shuttermode' => { 135 => 0x1b, 216 => 0x34 },
	'shutterreleasebuttonae-l' => { 263 => '17.7', 264 => '18.4', 266 => '78.4', 267 => '78.4', 268 => '16.1', 269 => '17.1', 270 => '17.1', 271 => '17.1', 272 => '7.1', 273 => '17.5', 276 => '18.4', 277 => '78.4', 278 => '18.2' },
	'shutterreleasemethod' => { 93 => 0x1010 },
	'shutterreleasenocfcard' => { 78 => 0x2, 79 => 0x2, 86 => 0xf },
	'shutterreleasetiming' => { 93 => 0x1011 },
	'shutterreleasewithoutlens' => { 80 => 0x711 },
	'shutterspeedlock' => { 264 => '38.1', 266 => '38.1', 267 => '38.1', 276 => '38.1', 277 => '38.1' },
	'shutterspeedrange' => { 80 => 0x10c },
	'shutterspeedsetting' => { 176 => 0x6, 388 => 0x2f, 389 => 0x28, 390 => 0x0 },
	'shutterspeedvalue' => { 89 => 0x1, 115 => 0x9201, 285 => 0x1000, 347 => 0x400, 462 => 'ShutterSpeedValue' },
	'shuttertype' => { 123 => 0x1050, 303 => 0x9f },
	'sidecarforextension' => { 470 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 133 => 0xe0d },
	'sigmascalingfactorcamera' => { 133 => 0xe0c },
	'sigmascalingfactorlowres' => { 133 => 0xe0b },
	'sigmasizetable' => { 133 => 0xe0f },
	'similarityindex' => { 127 => 0xe4 },
	'singleframebracketing' => { 176 => 0x21 },
	'skilllevel' => { 474 => 'skillLevel' },
	'skintonecorrection' => { 338 => 0x95 },
	'skiplinetime' => { 133 => 0x184e },
	'slaveflashmeteringsegments' => { 338 => 0x20b },
	'slideshowname' => { 471 => 'slideshowName' },
	'slideshownumber' => { 471 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 471 => 'slideshowTotalNumber' },
	'slowshutter' => { 74 => 0x8 },
	'slowsync' => { 123 => 0x1030 },
	'smartalbumcolor' => { 377 => 0x20 },
	'smartrange' => { 377 => 0xa012 },
	'smileshutter' => { 390 => 0x31 },
	'smileshuttermode' => { 390 => 0x27 },
	'smoothness' => { 115 => 0xfe57, 456 => 'Smoothness', 458 => 'Smoothness' },
	'snapshot' => { 468 => 'SnapshotLink' },
	'snapshotformat' => { 468 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 468 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 468 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 468 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 468 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 451 => 'Snapshots' },
	'snapshotusedvideoframe' => { 468 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 468 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 468 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 468 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 468 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 401 => 0x200f },
	'software' => { 115 => 0x131, 150 => 'Software', 293 => 'Software', 347 => 0x203, 357 => 'software', 380 => 0x18, 441 => 'Software', 478 => 'Software' },
	'softwareversion' => { 363 => "\xa9swr", 379 => 0x207 },
	'songwriter' => { 363 => "\xa9swf" },
	'songwriterkeywords' => { 363 => "\xa9swk" },
	'sonycropsize' => { 115 => 0x74c8 },
	'sonycroptopleft' => { 115 => 0x74c7 },
	'sonydatetime' => { 408 => 0x6, 410 => 0x1b6, 411 => 0x210, 412 => 0x1fe, 413 => 0x22c },
	'sonydatetime2' => { 419 => 0x51 },
	'sonyexposuretime' => { 419 => 0x3a, 420 => 0x46 },
	'sonyexposuretime2' => { 430 => 0xe },
	'sonyfnumber' => { 419 => 0x3c, 420 => 0x48, 430 => 0x14 },
	'sonyimageheight' => { 408 => 0x1a, 421 => 0x44, 422 => 0x3f, 423 => 0x47 },
	'sonyimageheightmax' => { 430 => 0x40 },
	'sonyimagesize' => { 176 => 0x3b, 388 => 0x54, 389 => 0x54, 390 => 0x9 },
	'sonyimagewidth' => { 408 => 0x1c },
	'sonyimagewidthmax' => { 430 => 0x3e },
	'sonyiso' => { 410 => 0x1218, 411 => 0x11f4, 412 => 0x1270, 413 => [0x1254,0x1258,0x1280], 414 => 0x113c, 415 => 0x344, 416 => 0x346, 417 => 0x320, 430 => 0x4 },
	'sonymaxaperture' => { 419 => 0x0, 420 => 0x0 },
	'sonymaxaperturevalue' => { 430 => 0x16 },
	'sonyminaperture' => { 419 => 0x1, 420 => 0x1 },
	'sonymodelid' => { 401 => 0xb001 },
	'sonyquality' => { 176 => 0x3c },
	'sonytimeminsec' => { 420 => 0x61 },
	'sortalbum' => { 355 => 'soal' },
	'sortalbumartist' => { 355 => 'soaa' },
	'sortartist' => { 355 => 'soar' },
	'sortcomposer' => { 355 => 'soco' },
	'sortname' => { 355 => 'sonm' },
	'sortshow' => { 355 => 'sosn' },
	'source' => { 127 => 0x73, 293 => 'Source', 459 => 'source', 460 => 'source', 470 => 'Source' },
	'sourcecount' => { 445 => 'SourceCount' },
	'sourcecredits' => { 363 => "\xa9src" },
	'sourcedirectoryindex' => { 325 => 0x0 },
	'sourcefileindex' => { 325 => 0x2 },
	'sourcephotoscount' => { 444 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 133 => 0x1390 },
	'spatialfrequencyresponse' => { 462 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 462 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 462 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 462 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 462 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 482 => 'speakerPlacement' },
	'specialeffectlevel' => { 109 => 0x3030 },
	'specialeffectmode' => { 109 => 0x2076 },
	'specialeffectsetting' => { 109 => 0x3031 },
	'specialinstructions' => { 127 => 0x28 },
	'specialmode' => { 285 => 0x200, 379 => 0x200 },
	'specialoccasion' => { 474 => 'specialOccasion' },
	'specialtypeid' => { 439 => 'SpecialTypeID' },
	'spectralsensitivity' => { 115 => 0x8824, 462 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => [0x2b9,0x2d0,0x2d4], 44 => 0x56a, 45 => 0x1e4, 46 => [0x1fd,0x2dd], 47 => [0x231,0x30f], 48 => 0x31d },
	'speedx' => { 111 => 0x3, 363 => "\xa9xsp" },
	'speedy' => { 111 => 0x4, 363 => "\xa9ysp" },
	'speedz' => { 111 => 0x5, 363 => "\xa9zsp" },
	'spherical' => { 445 => 'Spherical' },
	'splitcolumn' => { 347 => 0x222 },
	'splittoningbalance' => { 456 => 'SplitToningBalance', 458 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 456 => 'SplitToningHighlightHue', 458 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 456 => 'SplitToningHighlightSaturation', 458 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 456 => 'SplitToningShadowHue', 458 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 456 => 'SplitToningShadowSaturation', 458 => 'SplitToningShadowSaturation' },
	'sport' => { 472 => 'sport' },
	'spotfocuspointx' => { 173 => 0x2d },
	'spotfocuspointy' => { 173 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 80 => 0x107 },
	'sractive' => { 319 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 340 => 0x3 },
	'srhalfpresstime' => { 340 => 0x2 },
	'srresult' => { 340 => 0x0, 341 => 0x0 },
	'stackedimage' => { 280 => 0x804 },
	'standardmatrixcustom' => { 133 => 0x7d4 },
	'standardmatrixdaylight' => { 133 => 0x7d0 },
	'standardmatrixflash' => { 133 => 0x7d3 },
	'standardmatrixfluorescent' => { 133 => 0x7d2 },
	'standardmatrixtungsten' => { 133 => 0x7d1 },
	'standardoutputhighlightpoint' => { 105 => 0x14 },
	'standardoutputsensitivity' => { 115 => 0x8831, 463 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 105 => 0x15 },
	'standardrawcolortone' => { 105 => 0xd },
	'standardrawcontrast' => { 105 => 0xf },
	'standardrawhighlight' => { 105 => 0x75 },
	'standardrawhighlightpoint' => { 105 => 0x12 },
	'standardrawlinear' => { 105 => 0x10 },
	'standardrawsaturation' => { 105 => 0xe },
	'standardrawshadow' => { 105 => 0x7e },
	'standardrawshadowpoint' => { 105 => 0x13 },
	'standardrawsharpness' => { 105 => 0x11 },
	'standardunsharpmaskfineness' => { 105 => 0x94 },
	'standardunsharpmaskstrength' => { 105 => 0x92 },
	'standardunsharpmaskthreshold' => { 105 => 0x96 },
	'standardwhitecustom' => { 133 => 0x838 },
	'standardwhitedaylight' => { 133 => 0x834 },
	'standardwhiteflash' => { 133 => 0x837 },
	'standardwhitefluorescent' => { 133 => 0x836 },
	'standardwhitetungsten' => { 133 => 0x835 },
	'standbytimer' => { 264 => '19.1', 266 => '19.1', 267 => '19.1', 270 => '18.1', 271 => '18.1', 276 => '19.1', 277 => '19.1' },
	'startingpage' => { 472 => 'startingPage' },
	'startmovieshooting' => { 80 => 0x70d },
	'starttimecode' => { 363 => "\xa9TIM", 482 => 'startTimecode' },
	'starttimecodetimeformat' => { 482 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 482 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 482 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 363 => "\xa9TSZ", 482 => 'startTimeSampleSize' },
	'starttimescale' => { 363 => "\xa9TSC", 482 => 'startTimeScale' },
	'state' => { 154 => 'State', 303 => 0x6b, 470 => 'State' },
	'status' => { 437 => 'Status', 449 => 'Status' },
	'stereomode' => { 445 => 'StereoMode' },
	'stitched' => { 445 => 'Stitched' },
	'stitchingsoftware' => { 444 => 'StitchingSoftware', 445 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 409 => 0x113e, 410 => 0x113e, 411 => 0x111a, 412 => 0x1196, 413 => 0x1172, 414 => 0x102a, 415 => 0x222, 416 => 0x222, 417 => 0x217, 430 => 0xa },
	'storagemethod' => { 180 => 0x12 },
	'storebyorientation' => { 264 => '46.3', 266 => '47.3', 267 => '47.3', 276 => '47.3', 277 => '47.3' },
	'storylineidentifier' => { 468 => 'StorylineIdentifier' },
	'straightenangle' => { 256 => 0x2fc08431 },
	'streamready' => { 468 => 'StreamReady' },
	'streamtype' => { 169 => 'StreamType' },
	'stretchmode' => { 482 => 'stretchMode' },
	'studydatetime' => { 436 => 'StudyDateTime' },
	'studydescription' => { 436 => 'StudyDescription' },
	'studyid' => { 436 => 'StudyID' },
	'studyphysician' => { 436 => 'StudyPhysician' },
	'styleperiod' => { 468 => 'StylePeriod' },
	'sub-location' => { 127 => 0x5c },
	'subfiledata' => { 157 => 'data' },
	'subfiledirectory' => { 157 => '1Directory' },
	'subfilemimetype' => { 157 => '2MIME' },
	'subfilename' => { 157 => '1Name' },
	'subfileresource' => { 157 => 'rsrc' },
	'subfiletype' => { 115 => 0xfe, 157 => '0Type' },
	'subject' => { 289 => 'Subject', 354 => 'Subject', 459 => 'subject', 469 => 'Subject', 483 => 'subject' },
	'subjectarea' => { 115 => 0x9214, 462 => 'SubjectArea' },
	'subjectcode' => { 467 => 'SubjectCode' },
	'subjectdistance' => { 115 => 0x9206, 135 => 0x3e, 462 => 'SubjectDistance' },
	'subjectdistancerange' => { 115 => 0xa40c, 462 => 'SubjectDistanceRange' },
	'subjectlocation' => { 115 => 0xa214, 462 => 'SubjectLocation' },
	'subjectmotion' => { 266 => '78.2', 267 => '78.2', 277 => '78.2' },
	'subjectprogram' => { 173 => 0x22 },
	'subjectreference' => { 127 => 0xc },
	'sublabels4' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 466 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 466 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 110 => 'Exif::SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 110 => 'Exif::SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 110 => 'Exif::SubSecModifyDate' },
	'subsectime' => { 115 => 0x9290 },
	'subsectimedigitized' => { 115 => 0x9292 },
	'subsectimeoriginal' => { 115 => 0x9291 },
	'subsection1' => { 472 => 'subsection1' },
	'subsection2' => { 472 => 'subsection2' },
	'subsection3' => { 472 => 'subsection3' },
	'subsection4' => { 472 => 'subsection4' },
	'subselector' => { 264 => '49.1', 266 => '71.1', 267 => '71.1', 277 => '71.1' },
	'subselectorassignment' => { 264 => '48.1' },
	'subselectorcenter' => { 266 => '72.1', 267 => '72.1', 277 => '72.1' },
	'subselectorplusdials' => { 264 => '49.2', 266 => '73.1', 267 => '73.1', 277 => '73.1' },
	'subtitle' => { 363 => "\xa9snm", 472 => 'subtitle' },
	'subtitlekeywords' => { 363 => "\xa9snk" },
	'subversionfilename' => { 466 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 466 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 466 => 'SubVersions' },
	'superimposeddisplay' => { 78 => 0xa, 80 => 0x510, 81 => 0x9, 82 => 0xa, 85 => 0xa, 86 => 0xe },
	'supermacro' => { 61 => 0x1a },
	'supplementalcategories' => { 127 => 0x14, 470 => 'SupplementalCategories' },
	'supplementaltype' => { 129 => 0x37 },
	'supplementdisplayid' => { 472 => 'supplementDisplayID' },
	'supplementstartingpage' => { 472 => 'supplementStartingPage' },
	'supplementtitle' => { 472 => 'supplementTitle' },
	'supplychainsource' => { 468 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 468 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 468 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 319 => 0x14 },
	'swatchcoloranta' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 487 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 487 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 487 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 487 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 487 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 303 => 0x93, 390 => 0x33 },
	'sweeppanoramafieldofview' => { 303 => 0x94 },
	'sweeppanoramasize' => { 390 => 0x32 },
	'switchtoregisteredafpoint' => { 79 => 0x12, 80 => 0x50a },
	'symlink' => { 116 => 'SymLink' },
	'syncreleasemode' => { 266 => '77.1', 267 => '77.1', 277 => '77.1' },
	'system' => { 347 => 0x204 },
	'tagged' => { 349 => 0xdd, 350 => 'Tagged', 451 => 'tagged' },
	'tagslist' => { 461 => 'TagsList' },
	'tagstructure' => { 466 => 'TagStructure' },
	'takenumber' => { 482 => 'takeNumber' },
	'tapename' => { 482 => 'tapeName' },
	'targetaperture' => { 74 => 0x4 },
	'targetcompressionratio' => { 91 => 0x1 },
	'targetdistancesetting' => { 93 => 0x1807 },
	'targetexposuretime' => { 74 => 0x5 },
	'targetimagetype' => { 93 => 0x100a },
	'targetprinter' => { 115 => 0x151 },
	'taxon' => { 114 => 'Taxon' },
	'taxonacceptednameusage' => { 114 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 114 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 114 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 114 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 114 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 114 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 114 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 114 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 114 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 114 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 114 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 114 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 114 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 114 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 114 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 114 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 114 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 114 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 114 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 114 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 114 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 114 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 114 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 114 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 114 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 114 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 114 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 114 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 114 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 114 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 114 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 114 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 114 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 133 => 0x196f },
	'tda1edgepolarity' => { 133 => 0x1971 },
	'tda1gain' => { 133 => 0x1970 },
	'tda1offset' => { 133 => 0x196e },
	'tda2bandwidth' => { 133 => 0x1979 },
	'tda2edgepolarity' => { 133 => 0x197b },
	'tda2gain' => { 133 => 0x197a },
	'tda2offset' => { 133 => 0x1978 },
	'tda3bandwidth' => { 133 => 0x1983 },
	'tda3edgepolarity' => { 133 => 0x1985 },
	'tda3gain' => { 133 => 0x1984 },
	'tda3offset' => { 133 => 0x1982 },
	'tda4bandwidth' => { 133 => 0x198d },
	'tda4edgepolarity' => { 133 => 0x198f },
	'tda4gain' => { 133 => 0x198e },
	'tda4offset' => { 133 => 0x198c },
	'teaser' => { 472 => 'teaser' },
	'teleconverter' => { 178 => 0x105, 401 => 0x105 },
	'tempampgainx100' => { 133 => 0x1914 },
	'tempo' => { 482 => 'tempo' },
	'temporalcoverage' => { 468 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 468 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 468 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 290 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 290 => 'TermsAndConditionsURL' },
	'testname' => { 116 => 'TestName' },
	'textencoding' => { 215 => 0x4 },
	'textlayername' => { 470 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 470 => 'TextLayers' },
	'textlayertext' => { 470 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 303 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 456 => 'Texture', 458 => 'Texture' },
	'three-dtrackingfacedetection' => { 266 => '1.4', 267 => '1.4', 277 => '1.4' },
	'three-dtrackingwatcharea' => { 266 => '78.1', 267 => '78.1', 277 => '78.1' },
	'thresholding' => { 115 => 0x107 },
	'thumbnailfilename' => { 93 => 0x817 },
	'thumbnailformat' => { 480 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 137 => 0xfa55, 480 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 93 => 0x2008, 110 => 'Exif::ThumbnailImage', 118 => 0x3, 160 => 'data', 285 => 0x100, 363 => 'thmb', 480 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 160 => '1Name' },
	'thumbnailimagesize' => { 160 => 'ImageSize' },
	'thumbnailimagetype' => { 160 => '0Type' },
	'thumbnailimagevalidarea' => { 61 => 0x13 },
	'thumbnaillength' => { 115 => 0x202 },
	'thumbnailoffset' => { 115 => 0x201 },
	'thumbnailpng' => { 363 => 'thmb' },
	'thumbnails' => { 480 => 'Thumbnails' },
	'thumbnailwidth' => { 137 => 0xfa54, 480 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 472 => 'ticker' },
	'tiffhandling' => { 456 => 'TIFFHandling', 458 => 'TIFFHandling' },
	'tiffmeteringimage' => { 179 => 0x104c, 399 => 0x1110 },
	'tilelength' => { 115 => 0x143 },
	'tilewidth' => { 115 => 0x142 },
	'time' => { 133 => 0x401, 338 => 0x7 },
	'timecodes' => { 115 => 0xc763 },
	'timecreated' => { 127 => 0x3c, 135 => 0x14, 144 => 0x10, 350 => 'TimeCreated' },
	'timelapseshotnumber' => { 306 => 0x10 },
	'timeperiod' => { 472 => 'timePeriod' },
	'timerfunctionbutton' => { 265 => '5.2', 268 => '12.1', 269 => '13.1' },
	'timerlength' => { 80 => 0x80c },
	'timerrecording' => { 303 => 0x96 },
	'timescaleparams' => { 482 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 482 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 482 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 482 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 128 => 0x50 },
	'timeshot' => { 446 => 'TimeShot' },
	'timesignature' => { 482 => 'timeSignature' },
	'timesincepoweron' => { 303 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 279 => 0x8, 293 => 'TimeStamp', 303 => 0xaf, 445 => 'Timestamp', 452 => 'Timestamp', 466 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 75 => 0x1, 248 => 0x0, 373 => 0xa },
	'timezonecity' => { 75 => 0x2 },
	'timezonecode' => { 96 => 0x1 },
	'timezoneinfo' => { 96 => 0x2 },
	'timezoneoffset' => { 115 => 0x882a },
	'tint' => { 357 => 'player.movie.visual.tint', 456 => 'Tint', 458 => 'Tint' },
	'title' => { 150 => 'Title', 289 => 'Title', 293 => 'Title', 303 => 0x65, 354 => 'Title', 355 => ['titl',"\xa9nam"], 357 => 'title', 363 => ['titl',"\xa9nam"], 459 => 'title', 469 => 'Title', 480 => 'Title' },
	'tonecomp' => { 216 => 0x81 },
	'tonecurve' => { 71 => 0x1, 338 => 0x402, 456 => 'ToneCurve', 458 => 'ToneCurve' },
	'tonecurveactive' => { 104 => 0x110 },
	'tonecurveadobergb' => { 377 => 0xa043 },
	'tonecurveadobergbdefault' => { 377 => 0xa041 },
	'tonecurveblue' => { 456 => 'ToneCurveBlue', 458 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 434 => 0x9003 },
	'tonecurvebluey' => { 434 => 0x9007 },
	'tonecurvebrightness' => { 99 => 0x20410 },
	'tonecurvebrightnessx' => { 434 => 0x9000 },
	'tonecurvebrightnessy' => { 434 => 0x9004 },
	'tonecurvecolorspace' => { 103 => 0x0 },
	'tonecurvecontrast' => { 99 => 0x20411 },
	'tonecurvegreen' => { 456 => 'ToneCurveGreen', 458 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 434 => 0x9002 },
	'tonecurvegreeny' => { 434 => 0x9006 },
	'tonecurveinputrange' => { 103 => 0x3 },
	'tonecurveinterpolation' => { 104 => 0x159 },
	'tonecurvemode' => { 104 => 0x113 },
	'tonecurvename' => { 456 => 'ToneCurveName', 458 => 'ToneCurveName' },
	'tonecurvename2012' => { 456 => 'ToneCurveName2012', 458 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 99 => '0x20400.1' },
	'tonecurveoutputrange' => { 103 => 0x5 },
	'tonecurveprofilename' => { 133 => 0x1391 },
	'tonecurveproperty' => { 104 => 0x3c },
	'tonecurvepv2012' => { 456 => 'ToneCurvePV2012', 458 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 456 => 'ToneCurvePV2012Blue', 458 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 456 => 'ToneCurvePV2012Green', 458 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 456 => 'ToneCurvePV2012Red', 458 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 456 => 'ToneCurveRed', 458 => 'ToneCurveRed' },
	'tonecurveredx' => { 434 => 0x9001 },
	'tonecurveredy' => { 434 => 0x9005 },
	'tonecurves' => { 338 => 0x403 },
	'tonecurveshape' => { 103 => 0x1 },
	'tonecurvesrgb' => { 377 => 0xa042 },
	'tonecurvesrgbdefault' => { 377 => 0xa040 },
	'tonecurvex' => { 103 => 0xa },
	'tonecurvey' => { 103 => 0xb },
	'tonelevel' => { 280 => 0x52e },
	'tonemapstrength' => { 456 => 'ToneMapStrength', 458 => 'ToneMapStrength' },
	'toningeffect' => { 55 => 0xf, 216 => 0xb3, 218 => 0x38, 219 => 0x40, 220 => 0x48, 370 => 0x1015 },
	'toningeffectauto' => { 68 => 0xa4 },
	'toningeffectfaithful' => { 67 => 0x74, 68 => 0x74 },
	'toningeffectlandscape' => { 67 => 0x44, 68 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 67 => 0x8c, 68 => 0x8c },
	'toningeffectneutral' => { 67 => 0x5c, 68 => 0x5c },
	'toningeffectportrait' => { 67 => 0x2c, 68 => 0x2c },
	'toningeffectstandard' => { 67 => 0x14, 68 => 0x14 },
	'toningeffectuserdef1' => { 67 => 0xa4, 68 => 0xbc },
	'toningeffectuserdef2' => { 67 => 0xbc, 68 => 0xd4 },
	'toningeffectuserdef3' => { 67 => 0xd4, 68 => 0xec },
	'toningsaturation' => { 218 => 0x39, 219 => 0x41, 220 => 0x49 },
	'totalzoom' => { 135 => 0x62 },
	'touchae' => { 303 => 0xab },
	'track' => { 355 => "\xa9trk", 363 => "\xa9trk" },
	'trackcreatedate' => { 362 => 0x1 },
	'trackmodifydate' => { 362 => 0x2 },
	'tracknumber' => { 355 => 'trkn', 482 => 'trackNumber' },
	'tracks' => { 482 => 'Tracks' },
	'tracksframerate' => { 482 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 482 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 482 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 482 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 482 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 482 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 482 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 482 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 482 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 482 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 482 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 482 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 482 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 482 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 482 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 482 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 482 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 363 => 'kgtt' },
	'trailersignature' => { 157 => 'zmie' },
	'transcript' => { 468 => 'Transcript' },
	'transcriptlink' => { 468 => 'TranscriptLink' },
	'transcriptlinklink' => { 468 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 468 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 115 => 0x12d, 478 => 'TransferFunction' },
	'transfertimenormal' => { 133 => 0x1888 },
	'transfertimetest' => { 133 => 0x1889 },
	'transform' => { 303 => [0x8012,0x59] },
	'transmissionreference' => { 470 => 'TransmissionReference' },
	'trapped' => { 289 => 'Trapped', 469 => 'Trapped' },
	'trashbuttonfunction' => { 80 => 0x710 },
	'travelday' => { 303 => 0x36 },
	'trebel' => { 357 => 'player.movie.audio.treble' },
	'triggermode' => { 364 => 0x6, 365 => 0x34, 366 => 0x34 },
	'tstop' => { 115 => 0xc772 },
	'ttl_da_adown' => { 326 => 0x5 },
	'ttl_da_aup' => { 326 => 0x4 },
	'ttl_da_bdown' => { 326 => 0x7 },
	'ttl_da_bup' => { 326 => 0x6 },
	'tungstenawb' => { 316 => 0x1 },
	'tvepisode' => { 355 => 'tves' },
	'tvepisodeid' => { 355 => 'tven' },
	'tvexposuretimesetting' => { 319 => 0x12 },
	'tvnetworkname' => { 355 => 'tvnn' },
	'tvseason' => { 355 => 'tvsn' },
	'tvshow' => { 355 => 'tvsh' },
	'type' => { 459 => 'type', 477 => 'type' },
	'typestatus' => { 114 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 115 => 0xc614 },
	'uniquedocumentid' => { 127 => 0xbb },
	'uniquematrixauto' => { 133 => 0x7e9 },
	'uniquematrixcustom' => { 133 => 0x7e8 },
	'uniquematrixdaylight' => { 133 => 0x7e4 },
	'uniquematrixflash' => { 133 => 0x7e7 },
	'uniquematrixfluorescent' => { 133 => 0x7e6 },
	'uniquematrixtungsten' => { 133 => 0x7e5 },
	'uniqueobjectname' => { 128 => 0x64 },
	'units' => { 441 => 'Units' },
	'unknown_aacr' => { 355 => 'AACR' },
	'unknown_cdek' => { 355 => 'CDEK' },
	'unknown_cdet' => { 355 => 'CDET' },
	'unknownblock' => { 338 => 0x405 },
	'unknownblock1' => { 284 => 0x635 },
	'unknownblock2' => { 284 => 0x636 },
	'unknownblock3' => { 284 => 0x1103 },
	'unknownblock4' => { 284 => 0x1104 },
	'unknowncontrast' => { 105 => 0x45 },
	'unknowndate' => { 347 => 0x212 },
	'unknownev' => { 133 => 0x1 },
	'unknownlinear' => { 105 => 0x46 },
	'unknownnumber' => { 93 => 0x180b },
	'unknownoutputhighlightpoint' => { 105 => 0x4a },
	'unknownoutputshadowpoint' => { 105 => 0x4b },
	'unknownrawhighlight' => { 105 => 0x7b },
	'unknownrawhighlightpoint' => { 105 => 0x48 },
	'unknownrawshadow' => { 105 => 0x84 },
	'unknownrawshadowpoint' => { 105 => 0x49 },
	'unknownsharpness' => { 105 => 0x47 },
	'unknowntags' => { 363 => 'TAGS' },
	'unknowntemperature' => { 117 => 0x4 },
	'unknownthumbnail' => { 363 => 'thmb' },
	'unsharp1color' => { 261 => 0x13 },
	'unsharp1halowidth' => { 261 => 0x19 },
	'unsharp1intensity' => { 261 => 0x17 },
	'unsharp1threshold' => { 261 => 0x1b },
	'unsharp2color' => { 261 => 0x2e },
	'unsharp2halowidth' => { 261 => 0x34 },
	'unsharp2intensity' => { 261 => 0x32 },
	'unsharp2threshold' => { 261 => 0x36 },
	'unsharp3color' => { 261 => 0x49 },
	'unsharp3halowidth' => { 261 => 0x4f },
	'unsharp3intensity' => { 261 => 0x4d },
	'unsharp3threshold' => { 261 => 0x51 },
	'unsharp4color' => { 261 => 0x64 },
	'unsharp4halowidth' => { 261 => 0x6a },
	'unsharp4intensity' => { 261 => 0x68 },
	'unsharp4threshold' => { 261 => 0x6c },
	'unsharpcount' => { 261 => 0x0 },
	'unsharpmask' => { 105 => 0x90, 256 => 0x76a43200 },
	'unsharpmaskfineness' => { 99 => 0x20309 },
	'unsharpmaskstrength' => { 99 => 0x20308 },
	'unsharpmaskthreshold' => { 99 => 0x2030a },
	'uprightcentermode' => { 456 => 'UprightCenterMode', 458 => 'UprightCenterMode' },
	'uprightcenternormx' => { 456 => 'UprightCenterNormX', 458 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 456 => 'UprightCenterNormY', 458 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 456 => 'UprightDependentDigest', 458 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 456 => 'UprightFocalLength35mm', 458 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 456 => 'UprightFocalMode', 458 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 456 => 'UprightFourSegmentsCount', 458 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 456 => 'UprightPreview', 458 => 'UprightPreview' },
	'uprighttransform_0' => { 456 => 'UprightTransform_0', 458 => 'UprightTransform_0' },
	'uprighttransform_1' => { 456 => 'UprightTransform_1', 458 => 'UprightTransform_1' },
	'uprighttransform_2' => { 456 => 'UprightTransform_2', 458 => 'UprightTransform_2' },
	'uprighttransform_3' => { 456 => 'UprightTransform_3', 458 => 'UprightTransform_3' },
	'uprighttransform_4' => { 456 => 'UprightTransform_4', 458 => 'UprightTransform_4' },
	'uprighttransform_5' => { 456 => 'UprightTransform_5', 458 => 'UprightTransform_5' },
	'uprighttransformcount' => { 456 => 'UprightTransformCount', 458 => 'UprightTransformCount' },
	'uprightversion' => { 456 => 'UprightVersion', 458 => 'UprightVersion' },
	'urgency' => { 127 => 0xa, 470 => 'Urgency' },
	'url' => { 150 => 'URL', 293 => 'URL', 352 => 0x40b, 472 => 'url' },
	'url_list' => { 352 => 0x41e },
	'urla-platform' => { 472 => [\'url','urlA-platform'] },
	'urlurl' => { 472 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 80 => 0x10a },
	'usableshootingmodes' => { 80 => 0x109 },
	'usage' => { 473 => 'usage' },
	'usageterms' => { 486 => 'UsageTerms' },
	'useguidelines' => { 454 => 'useGuidelines' },
	'usepanoramaviewer' => { 444 => 'UsePanoramaViewer' },
	'usercollection' => { 357 => 'collection.user' },
	'usercomment' => { 93 => 0x805, 115 => 0x9286, 462 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 67 => 0xd8, 68 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 67 => 0xda, 68 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 67 => 0xdc, 68 => 0xf4 },
	'userfields' => { 449 => 'UserFields' },
	'userlabel' => { 364 => 0x2b, 365 => 0x5a, 366 => 0x68 },
	'userprofile' => { 298 => 0x302, 305 => 0x3038 },
	'userrating' => { 357 => 'rating.user' },
	'usmlenselectronicmf' => { 2 => 0x7, 79 => 0x7, 80 => 0x501 },
	'uspsnumber' => { 472 => 'uspsNumber' },
	'utmeasting' => { 161 => 'Easting' },
	'utmmapdatum' => { 161 => 'Datum' },
	'utmnorthing' => { 161 => 'Northing' },
	'utmzone' => { 161 => 'Zone' },
	'uv-irfiltercorrection' => { 298 => 0x325 },
	'validbits' => { 284 => 0x611, 285 => 0x102c },
	'validpixeldepth' => { 288 => 0x611 },
	'variablelowpassfilter' => { 401 => 0x2028 },
	'variousmodes' => { 135 => 0x26 },
	'variousmodes2' => { 135 => 0x3a },
	'variprogram' => { 216 => 0xab },
	'varraydacnominalvalues' => { 133 => 0x191e },
	'vendor' => { 363 => 'vndr' },
	'version' => { 123 => 0x0, 354 => 'Version', 357 => 'version', 456 => 'Version', 458 => 'Version' },
	'versioncreatedate' => { 434 => 0xd100 },
	'versionid' => { 483 => 'VersionID' },
	'versionidentifier' => { 472 => 'versionIdentifier' },
	'versionmodifydate' => { 434 => 0xd101 },
	'versions' => { 483 => 'Versions' },
	'versionscomments' => { 483 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 483 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 483 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 483 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 483 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 483 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 483 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 483 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 483 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 483 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 483 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 263 => '3.2', 264 => '47.2', 266 => '79.1' },
	'verticalclockoverlaps' => { 133 => 0x412 },
	'verticalfuncbutton' => { 264 => '42.2', 266 => '67.1' },
	'verticalfuncbuttonplusdials' => { 264 => '43.1' },
	'verticalfuncplusdials' => { 266 => '68.1' },
	'verticalmultiselector' => { 264 => '42.1', 266 => '66.1', 267 => '66.1', 277 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 80 => [0x510,0x51d] },
	'vibrance' => { 450 => 'Vibrance', 456 => 'Vibrance', 458 => 'Vibrance' },
	'vibrationreduction' => { 225 => [0x75,0x82,0x1ae], 233 => '586.1', 241 => '590.2', 247 => 0x4 },
	'videoalphamode' => { 482 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 482 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 482 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 482 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 468 => 'videoBitRate' },
	'videobitratemode' => { 468 => 'videoBitRateMode' },
	'videoburstmode' => { 303 => 0xbb },
	'videocodec' => { 64 => 0x74 },
	'videocolorspace' => { 482 => 'videoColorSpace' },
	'videocompression' => { 123 => 0x3806 },
	'videocompressor' => { 482 => 'videoCompressor' },
	'videodisplayaspectratio' => { 468 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 468 => 'videoEncodingProfile' },
	'videofieldorder' => { 482 => 'videoFieldOrder' },
	'videoframerate' => { 482 => 'videoFrameRate' },
	'videoframesize' => { 482 => 'videoFrameSize' },
	'videoframesizeh' => { 482 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 482 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 482 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 482 => 'videoModDate' },
	'videopixelaspectratio' => { 482 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 482 => 'videoPixelDepth' },
	'videoquality' => { 109 => 0x4003 },
	'videorecordingmode' => { 123 => 0x3803 },
	'videoshottype' => { 468 => 'VideoShotType' },
	'videoshottypeidentifier' => { 468 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 468 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 468 => 'videoStreamsCount' },
	'viewfinder' => { 347 => 0x455 },
	'viewfinderdisplay' => { 263 => '12.4', 264 => '6.3' },
	'viewfinderwarning' => { 263 => '13.4', 273 => '3.5', 274 => '6.2', 278 => '4.4' },
	'viewfinderwarnings' => { 80 => 0x40a },
	'viewinfoduringexposure' => { 80 => 0x407 },
	'viewingmode' => { 390 => 0x2f, 406 => 0x18 },
	'viewingmode2' => { 390 => [0x85,0x285] },
	'viewpoint' => { 471 => 'viewpoint' },
	'vignetteamount' => { 456 => 'VignetteAmount', 458 => 'VignetteAmount' },
	'vignettecontrol' => { 216 => 0x2a, 256 => 0x76a43205 },
	'vignettecontrolintensity' => { 256 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 453 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 456 => 'VignetteMidpoint', 458 => 'VignetteMidpoint' },
	'vignetting' => { 370 => 0x1011, 377 => 0xa052 },
	'vignettingcorrection' => { 115 => 0x7031, 377 => 0xa053, 401 => 0x2011 },
	'vignettingcorrparams' => { 115 => 0x7032, 429 => 0x64a, 430 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 377 => 0xa054 },
	'visualcolor' => { 468 => 'VisualColour' },
	'visualtechnique' => { 471 => 'visualTechnique' },
	'voicememo' => { 379 => 0x216 },
	'volume' => { 472 => 'volume' },
	'vr_0x66' => { 225 => 0x66 },
	'vrdoffset' => { 61 => 0xd0 },
	'vrmode' => { 247 => 0x6 },
	'waterdepth' => { 115 => 0x9403, 463 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 179 => 0x19a },
	'wb_bluelevel6500k' => { 179 => 0x18a },
	'wb_bluelevelcustom' => { 179 => 0x18e },
	'wb_bluelevelscloudy' => { 179 => 0x106 },
	'wb_bluelevelsdaylight' => { 179 => 0xea },
	'wb_bluelevelsflash' => { 179 => 0x122 },
	'wb_bluelevelsfluorescent' => { 179 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 179 => 0x254 },
	'wb_bluelevelsshade' => { 179 => 0x176 },
	'wb_bluelevelstungsten' => { 179 => 0xce },
	'wb_gbrglevels' => { 179 => 0xae, 182 => 0x4 },
	'wb_glevel' => { 284 => 0x11f },
	'wb_glevel3000k' => { 284 => 0x113 },
	'wb_glevel3300k' => { 284 => 0x114 },
	'wb_glevel3600k' => { 284 => 0x115 },
	'wb_glevel3900k' => { 284 => 0x116 },
	'wb_glevel4000k' => { 284 => 0x117 },
	'wb_glevel4300k' => { 284 => 0x118 },
	'wb_glevel4500k' => { 284 => 0x119 },
	'wb_glevel4800k' => { 284 => 0x11a },
	'wb_glevel5300k' => { 284 => 0x11b },
	'wb_glevel6000k' => { 284 => 0x11c },
	'wb_glevel6600k' => { 284 => 0x11d },
	'wb_glevel7500k' => { 284 => 0x11e },
	'wb_grbglevels' => { 192 => 0x0 },
	'wb_rbgglevels' => { 189 => 0x0 },
	'wb_rblevels' => { 193 => 0x270, 216 => 0xc, 284 => 0x100 },
	'wb_rblevels1' => { 309 => 0x2 },
	'wb_rblevels2' => { 309 => 0x5 },
	'wb_rblevels3' => { 309 => 0x8 },
	'wb_rblevels3000k' => { 284 => 0x102 },
	'wb_rblevels3300k' => { 284 => 0x103 },
	'wb_rblevels3500k' => { 179 => 0x430 },
	'wb_rblevels3600k' => { 284 => 0x104 },
	'wb_rblevels3900k' => { 284 => 0x105 },
	'wb_rblevels4' => { 309 => 0xb },
	'wb_rblevels4000k' => { 284 => 0x106 },
	'wb_rblevels4300k' => { 284 => 0x107 },
	'wb_rblevels4500k' => { 284 => 0x108 },
	'wb_rblevels4800k' => { 284 => 0x109 },
	'wb_rblevels5' => { 309 => 0xe },
	'wb_rblevels5300k' => { 284 => 0x10a },
	'wb_rblevels6' => { 309 => 0x11 },
	'wb_rblevels6000k' => { 284 => 0x10b },
	'wb_rblevels6500k' => { 179 => 0x420 },
	'wb_rblevels6600k' => { 284 => 0x10c },
	'wb_rblevels7' => { 309 => 0x14 },
	'wb_rblevels7500k' => { 284 => 0x10d },
	'wb_rblevelsauto' => { 193 => 0x272, 288 => 0x110 },
	'wb_rblevelscloudy' => { 179 => 0x3f0, 181 => 0x10, 193 => 0x296, 288 => 0x121 },
	'wb_rblevelscoolwhitef' => { 179 => 0x308, 181 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 288 => 0x132 },
	'wb_rblevelscustom' => { 179 => 0x424 },
	'wb_rblevelscwb1' => { 284 => 0x10e },
	'wb_rblevelscwb2' => { 284 => 0x10f },
	'wb_rblevelscwb3' => { 284 => 0x110 },
	'wb_rblevelscwb4' => { 284 => 0x111 },
	'wb_rblevelsdaylight' => { 179 => [0x3ec,0x528], 181 => 0xc, 193 => 0x274 },
	'wb_rblevelsdaylightf' => { 181 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 288 => 0x130 },
	'wb_rblevelsdaywhitef' => { 181 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 288 => 0x131 },
	'wb_rblevelseveningsunlight' => { 288 => 0x124 },
	'wb_rblevelsfineweather' => { 288 => 0x122 },
	'wb_rblevelsflash' => { 179 => [0x3f4,0x304], 181 => 0x18, 193 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 193 => 0x290 },
	'wb_rblevelsincandescent' => { 193 => 0x282 },
	'wb_rblevelsshade' => { 179 => 0x418, 181 => 0x20, 193 => 0x2b2, 288 => 0x120 },
	'wb_rblevelstungsten' => { 179 => 0x3e8, 181 => 0x8, 288 => 0x123 },
	'wb_rblevelsunknown' => { 181 => 0x1c },
	'wb_rblevelsused' => { 288 => 0x100 },
	'wb_rblevelswhitef' => { 181 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 288 => 0x133 },
	'wb_redlevel3500k' => { 179 => 0x198 },
	'wb_redlevel6500k' => { 179 => 0x188 },
	'wb_redlevelcustom' => { 179 => 0x18c },
	'wb_redlevelscloudy' => { 179 => 0xf8 },
	'wb_redlevelsdaylight' => { 179 => 0xdc },
	'wb_redlevelsflash' => { 179 => 0x114 },
	'wb_redlevelsfluorescent' => { 179 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 179 => 0x1be },
	'wb_redlevelsshade' => { 179 => 0x168 },
	'wb_redlevelstungsten' => { 179 => 0xc0 },
	'wb_rgbglevels' => { 191 => 0x0 },
	'wb_rgblevels' => { 179 => [0x546,0x96], 299 => 0xd, 300 => 0x413, 305 => 0x3036, 347 => 0x107, 409 => 0x117c, 410 => 0x1180, 411 => 0x115c, 412 => 0x11d8, 413 => 0x11b4, 414 => 0x106c, 415 => 0x264, 416 => 0x264, 417 => 0x252 },
	'wb_rgblevels1' => { 310 => 0x2 },
	'wb_rgblevels2' => { 310 => 0x6 },
	'wb_rgblevels3' => { 310 => 0xa },
	'wb_rgblevels4' => { 310 => 0xe },
	'wb_rgblevels5' => { 310 => 0x12 },
	'wb_rgblevels6' => { 310 => 0x16 },
	'wb_rgblevels7' => { 310 => 0x1a },
	'wb_rgbmuldaylight' => { 133 => 0x852 },
	'wb_rgbmulflash' => { 133 => 0x855 },
	'wb_rgbmulfluorescent' => { 133 => 0x854 },
	'wb_rgbmultungsten' => { 133 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 182 => 0x4, 190 => 0x0, 194 => 0x13e8, 195 => 0x38 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x22, 42 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x3f, 48 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x18, 42 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x44, 48 => 0x4c, 194 => 0x1478, 195 => 0x114, 377 => 0xa022 },
	'wb_rggblevelsblack' => { 377 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0x31, 42 => 0x58, 45 => 0x71, 46 => 0x8a, 47 => 0x8f, 48 => 0x92, 194 => 0x1408, 195 => 0x60, 338 => 0x20f, 346 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 42 => 0x80, 194 => 0x1468, 195 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x27, 42 => 0x4e, 45 => 0x67, 46 => 0x80, 47 => 0x85, 48 => 0x88, 194 => 0x13f8, 195 => 0x4c, 338 => 0x20d, 346 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0x45, 42 => 0x6c, 45 => 0x85, 46 => 0x9e, 47 => 0xa3, 48 => 0xa6, 194 => 0x1448, 338 => 0x214, 346 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0x3b, 42 => 0x62, 45 => 0x7b, 46 => 0x94, 47 => 0x99, 48 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 195 => 0xc4, 338 => 0x211, 346 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 346 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 195 => 0xb0, 338 => 0x212, 346 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 194 => 0x1438, 195 => 0x9c, 338 => 0x213, 346 => 0x38 },
	'wb_rggblevelshtmercury' => { 195 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 377 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 377 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0x40, 42 => 0x67, 45 => 0x80, 46 => 0x99, 47 => 0x9e, 48 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 42 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x49, 48 => 0x51 },
	'wb_rggblevelspc1' => { 41 => 0x90, 42 => 0x71 },
	'wb_rggblevelspc2' => { 41 => 0x95, 42 => 0x76 },
	'wb_rggblevelspc3' => { 41 => 0x9a, 42 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x2c, 42 => 0x53, 45 => 0x6c, 46 => 0x85, 47 => 0x8a, 48 => 0x8d, 195 => 0x74, 338 => 0x20e, 346 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0x36, 42 => 0x5d, 45 => 0x76, 46 => 0x8f, 47 => 0x94, 48 => 0x97, 194 => 0x1428, 195 => 0x88, 338 => 0x210, 346 => 0x1d },
	'wb_rggblevelsuncorrected' => { 377 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x1d, 45 => 0x4e, 46 => 0x4e, 47 => 0x4e, 48 => 0x56, 346 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x72, 45 => 0x9e, 46 => 0x7b, 47 => 0x7b, 48 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0x77, 45 => 0xa3, 46 => 0xa3, 47 => 0x80, 48 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0x7c, 45 => 0xa8, 46 => 0xa8, 47 => 0xa8, 48 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0x81, 45 => 0xad, 46 => 0xad, 47 => 0xad, 48 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0x86, 45 => 0xb2, 46 => 0xb2, 47 => 0xb2, 48 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0x8b, 45 => 0xb7, 46 => 0xb7, 47 => 0xb7, 48 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0x9f, 46 => 0xbc, 47 => 0xbc, 48 => 0xc4 },
	'wb_rggblevelsunknown17' => { 46 => 0xc1, 47 => 0xc1, 48 => 0xc9 },
	'wb_rggblevelsunknown18' => { 46 => 0xc6, 47 => 0xc6, 48 => 0xce },
	'wb_rggblevelsunknown19' => { 46 => 0xcb, 47 => 0xcb, 48 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x4a, 45 => 0x53, 46 => 0x53, 47 => 0x53, 48 => 0x5b },
	'wb_rggblevelsunknown20' => { 46 => 0xd0, 47 => 0xd0, 48 => 0xd8 },
	'wb_rggblevelsunknown21' => { 47 => 0xd5, 48 => 0xdd },
	'wb_rggblevelsunknown22' => { 47 => 0xda, 48 => 0xe2 },
	'wb_rggblevelsunknown23' => { 47 => 0xdf, 48 => 0xe7 },
	'wb_rggblevelsunknown24' => { 47 => 0xe4, 48 => 0xec },
	'wb_rggblevelsunknown25' => { 47 => 0xe9, 48 => 0xf1 },
	'wb_rggblevelsunknown26' => { 47 => 0xee, 48 => 0xf6 },
	'wb_rggblevelsunknown27' => { 47 => 0xf3, 48 => 0xfb },
	'wb_rggblevelsunknown28' => { 47 => 0xf8, 48 => 0x100 },
	'wb_rggblevelsunknown29' => { 47 => 0xfd, 48 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x4f, 45 => 0x58, 46 => 0x58, 47 => 0x58, 48 => 0x60 },
	'wb_rggblevelsunknown30' => { 47 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x54, 45 => 0x5d, 46 => 0x5d, 47 => 0x5d, 48 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x59, 45 => 0x62, 46 => 0x62, 47 => 0x62, 48 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x5e, 45 => 0x8a, 46 => 0x67, 47 => 0x67, 48 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x63, 45 => 0x8f, 46 => 0x6c, 47 => 0x6c, 48 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x68, 45 => 0x94, 46 => 0x71, 47 => 0x71, 48 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x6d, 45 => 0x99, 46 => 0x76, 47 => 0x76, 48 => 0x7e },
	'wb_rggblevelsuserselected' => { 346 => 0x5c },
	'wbadjblueamber' => { 99 => 0x20106 },
	'wbadjbluebalance' => { 262 => 0x8 },
	'wbadjcolortemp' => { 99 => 0x20102, 104 => 0x1a },
	'wbadjlighting' => { 262 => 0x14 },
	'wbadjmagentagreen' => { 99 => 0x20105 },
	'wbadjmode' => { 262 => 0x10 },
	'wbadjredbalance' => { 262 => 0x0 },
	'wbadjrggblevels' => { 99 => 0x20125, 104 => 0x6 },
	'wbadjtemperature' => { 262 => 0x18 },
	'wbadjtint' => { 262 => 0x25 },
	'wbbluelevel' => { 298 => 0x324, 303 => 0x8006, 308 => 0x26 },
	'wbbracketingsteps' => { 234 => 0x174d, 235 => 0x87c, 243 => 0x1757 },
	'wbbracketmode' => { 55 => 0x9 },
	'wbbracketshotnumber' => { 179 => 0x2b, 370 => 0x101a },
	'wbbracketvalueab' => { 55 => 0xc },
	'wbbracketvaluegm' => { 55 => 0xd },
	'wbfinetuneactive' => { 104 => 0x24 },
	'wbfinetunesaturation' => { 104 => 0x28 },
	'wbfinetunetone' => { 104 => 0x2c },
	'wbgreenlevel' => { 298 => 0x323, 303 => 0x8005, 308 => 0x25 },
	'wbmediaimagesizesetting' => { 80 => 0x708 },
	'wbmode' => { 181 => 0x4, 285 => 0x1015 },
	'wbredlevel' => { 298 => 0x322, 303 => 0x8004, 308 => 0x24 },
	'wbscale' => { 182 => 0x0 },
	'wbshiftab' => { 71 => 0xc, 303 => 0x46, 320 => 0x10 },
	'wbshiftab_gm' => { 401 => 0x2014 },
	'wbshiftab_gm_precise' => { 401 => 0x2026 },
	'wbshiftcreativecontrol' => { 303 => 0x92 },
	'wbshiftgm' => { 71 => 0xd, 303 => 0x47, 320 => 0x11 },
	'wbshiftintelligentauto' => { 303 => 0x8b },
	'wbtype1' => { 309 => 0x1, 310 => 0x1 },
	'wbtype2' => { 309 => 0x4, 310 => 0x5 },
	'wbtype3' => { 309 => 0x7, 310 => 0x9 },
	'wbtype4' => { 309 => 0xa, 310 => 0xd },
	'wbtype5' => { 309 => 0xd, 310 => 0x11 },
	'wbtype6' => { 309 => 0x10, 310 => 0x15 },
	'wbtype7' => { 309 => 0x13, 310 => 0x19 },
	'webstatement' => { 486 => 'WebStatement' },
	'what' => { 456 => 'What', 458 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 71 => 0x8, 74 => 0x7, 108 => 0x7, 109 => [0x19,0x2012], 115 => [0xa403,0xfe4e], 123 => 0x1002, 133 => 0x3fc, 134 => 0xfa0d, 135 => 0x40, 173 => 0x3, 174 => 0xe, 175 => 0x4, 176 => 0xb, 178 => 0x115, 216 => 0x5, 246 => 0x7, 298 => 0x304, 303 => 0x3, 305 => 0x3033, 338 => 0x19, 345 => 0x7, 369 => 0x26, 370 => 0x1003, 380 => [0x88,0x3c,0x7,0x58], 388 => 0xf, 389 => 0xe, 401 => [0x115,0xb054], 456 => 'WhiteBalance', 458 => 'WhiteBalance', 462 => 'WhiteBalance' },
	'whitebalance0' => { 169 => 'WhiteBalance0' },
	'whitebalance1' => { 169 => 'WhiteBalance1' },
	'whitebalance2' => { 169 => 'WhiteBalance2', 280 => 0x500 },
	'whitebalanceadj' => { 99 => 0x20101, 104 => 0x18, 256 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 316 => 0x0 },
	'whitebalancebias' => { 109 => 0x2011, 285 => 0x304, 303 => 0x23 },
	'whitebalanceblue' => { 71 => 0x7 },
	'whitebalancebracket' => { 280 => 0x502, 285 => 0x303 },
	'whitebalancebracketing' => { 176 => 0x22, 179 => 0x2c, 399 => 0x2c },
	'whitebalancecomp' => { 288 => 0x1001 },
	'whitebalancedetected' => { 133 => 0x3fb },
	'whitebalancefinetune' => { 123 => 0x100a, 176 => 0x38, 178 => 0x112, 216 => 0xb, 370 => 0x1004, 388 => 0x6, 389 => 0x5, 401 => 0x112 },
	'whitebalancemode' => { 133 => 0x3fa, 338 => 0x1a },
	'whitebalancered' => { 71 => 0x6 },
	'whitebalanceset' => { 319 => 0xa },
	'whitebalancesetting' => { 176 => 0x23, 388 => 0x5, 389 => 0x4, 390 => 0x16, 406 => 0xd },
	'whitebalancesetup' => { 377 => 0x41 },
	'whitebalancetemperature' => { 280 => 0x501 },
	'whiteboard' => { 285 => 0x301 },
	'whitelevel' => { 115 => 0xc61d, 338 => 0x7e },
	'whitepoint' => { 115 => 0x13e, 338 => 0x201, 478 => 'WhitePoint' },
	'whites2012' => { 456 => 'Whites2012', 458 => 'Whites2012' },
	'whitesadj' => { 434 => 0x9017 },
	'wideadapter' => { 370 => 0x1017 },
	'widefocuszone' => { 173 => 0x2f },
	'widerange' => { 379 => 0x20f },
	'windmode' => { 133 => 0x3f4 },
	'windowlocation' => { 363 => 'WLOC' },
	'windowsatom' => { 457 => 'windowsAtom' },
	'windowsatomextension' => { 457 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 457 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 457 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 472 => 'wordCount' },
	'workcolorspace' => { 99 => 0x10200, 104 => 0x270 },
	'workflowtag' => { 468 => 'WorkflowTag' },
	'workflowtagcvid' => { 468 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 468 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 468 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 468 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 464 => 'WorkToDo' },
	'worldtimelocation' => { 303 => 0x3a, 338 => 0x22, 344 => '0.1' },
	'writer-editor' => { 127 => 0x7a },
	'x3filllight' => { 380 => 0x12 },
	'xattrquarantine' => { 167 => 'com.apple.quarantine' },
	'xilinxversion' => { 133 => 0x414 },
	'xml' => { 131 => 'xml ' },
	'xmp' => { 102 => 0xffff00f6, 116 => 'XMP' },
	'xmptoolkit' => { 479 => 'xmptk' },
	'xpauthor' => { 115 => 0x9c9d },
	'xpcomment' => { 115 => 0x9c9c },
	'xpkeywords' => { 115 => 0x9c9e },
	'xposition' => { 115 => 0x11e },
	'xpsubject' => { 115 => 0x9c9f },
	'xptitle' => { 115 => 0x9c9b },
	'xresolution' => { 115 => 0x11a, 130 => 0x3, 353 => 0x0, 478 => 'XResolution' },
	'xyresolution' => { 119 => 0x3 },
	'yaw' => { 111 => 0x7, 363 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 234 => 0x3513, 235 => 0x2c2c, 243 => 0x36fc, 375 => 0x0 },
	'ycbcrcoefficients' => { 115 => 0x211, 478 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 115 => 0x213, 478 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 115 => 0x212, 478 => 'YCbCrSubSampling' },
	'year' => { 355 => 'yrrc', 357 => 'year' },
	'yearcreated' => { 135 => 0x10, 144 => 0xc },
	'yellowhsl' => { 99 => 0x20912 },
	'yield' => { 474 => 'yield' },
	'yposition' => { 115 => 0x11f },
	'yresolution' => { 115 => 0x11b, 130 => 0x5, 353 => 0x4, 478 => 'YResolution' },
	'zonematching' => { 178 => 0x10a, 181 => [0x3a,0x4a], 401 => 0xb024 },
	'zonematchingmode' => { 176 => 0x14 },
	'zonematchingon' => { 175 => 0x75 },
	'zonematchingvalue' => { 388 => 0x1f },
	'zoomedpreviewlength' => { 285 => 0xf05 },
	'zoomedpreviewsize' => { 285 => 0xf06 },
	'zoomedpreviewstart' => { 285 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 283 => 0x300, 285 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'acceldata' => 1,
	'accelerometerdata' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airspeed' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaformat' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'dualshotversion' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kinds' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'moviefragment' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playcounter' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2019, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
