#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.16';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 103 => 0x69 },
	'about' => { 460 => 'about' },
	'aboutcvterm' => { 452 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 452 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 452 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 452 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 452 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 110 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 466 => 'absPeakAudioFilePath' },
	'academicfield' => { 456 => 'academicField' },
	'acceleration' => { 113 => 0x9404, 447 => 'Acceleration' },
	'accelerationtracking' => { 78 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 361 => 0x3 },
	'accelerometerx' => { 297 => 0x8d },
	'accelerometery' => { 297 => 0x8e },
	'accelerometerz' => { 297 => 0x8c },
	'accessoryserialnumber' => { 297 => 0x54 },
	'accessorytype' => { 297 => 0x53 },
	'actionadvised' => { 125 => 0x2a },
	'activearea' => { 113 => 0xc68d },
	'actived-lighting' => { 211 => 0x22, 248 => 0x24 },
	'actived-lightingmode' => { 248 => 0x25 },
	'adaptervoltage' => { 131 => 0x407 },
	'addaspectratioinfo' => { 78 => 0x80e },
	'addiptcinformation' => { 78 => 0x815 },
	'additionalmodelinformation' => { 452 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 78 => 0x80f, 79 => 0x11, 80 => 0x13, 83 => 0x14 },
	'address' => { 152 => 'Address' },
	'adjustmentmode' => { 368 => 0x15 },
	'adlbracketingstep' => { 229 => 0x883 },
	'adlbracketingtype' => { 229 => 0x884 },
	'adobe' => { 114 => 'Adobe' },
	'adultcontentwarning' => { 284 => 'AdultContentWarning', 459 => 'adultContentWarning' },
	'advancedfilter' => { 121 => 0x1201 },
	'advancedraw' => { 250 => 0x76a43203 },
	'advancedscenetype' => { 297 => 0x3d },
	'advisory' => { 464 => 'Advisory' },
	'ae_iso' => { 305 => 0x2, 306 => 0x4, 307 => 0x12 },
	'aeaperture' => { 305 => 0x1, 306 => 0x3, 307 => 0x11 },
	'aeaperturesteps' => { 305 => 0x8, 306 => 0xb },
	'aebautocancel' => { 78 => 0x104 },
	'aebbracketvalue' => { 72 => 0x11 },
	'aebracketingsteps' => { 228 => 0x174c, 229 => 0x87b, 237 => 0x1756 },
	'aebsequence' => { 78 => 0x105 },
	'aebsequenceautocancel' => { 76 => 0x9, 77 => 0x9, 79 => 0x8, 80 => 0x9, 83 => 0x9, 84 => 0x7 },
	'aebshotcount' => { 78 => 0x106 },
	'aebxv' => { 305 => 0x4, 306 => 0x6 },
	'aeerror' => { 306 => 0x8 },
	'aeexposuretime' => { 305 => 0x0, 306 => 0x2, 307 => 0x10 },
	'aelbutton' => { 174 => 0x45 },
	'aelexposureindicator' => { 174 => 0x51 },
	'aelock' => { 174 => 0x5b, 259 => '4.2', 268 => '4.2', 274 => 0x201, 332 => 0x48, 376 => 0x40, 377 => 0x40, 378 => [0x86,0x286] },
	'aelockbutton' => { 257 => '16.1', 259 => '4.1', 262 => '15.1', 263 => '16.1', 264 => '16.1', 266 => '30.1', 267 => '16.1', 268 => '4.1', 270 => '17.1', 272 => '17.1' },
	'aelockbuttonplusdials' => { 257 => '16.2', 266 => '32.1', 270 => '44.1' },
	'aelockformb-d80' => { 272 => '3.1' },
	'aelockmetermodeafterfocus' => { 78 => 0x114 },
	'aemaxaperture' => { 305 => 0x9, 306 => 0x10, 307 => 0x1c },
	'aemaxaperture2' => { 305 => 0xa, 306 => 0x11, 307 => 0x1d },
	'aemeteringmode' => { 305 => 0xc },
	'aemeteringmode2' => { 305 => '13.1' },
	'aemeteringsegments' => { 177 => 0x628, 332 => 0x209 },
	'aemicroadjustment' => { 78 => 0x110 },
	'aeminaperture' => { 305 => 0xb, 306 => 0x12, 307 => 0x1e },
	'aeminexposuretime' => { 305 => 0x5, 306 => 0x13, 307 => 0x1f },
	'aeprogrammode' => { 305 => 0x6 },
	'aeprojectlink' => { 441 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 441 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 441 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 441 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 441 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 441 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 305 => 0xd },
	'aexv' => { 305 => 0x3, 306 => 0x5 },
	'af-cpriority' => { 122 => '0.2' },
	'af-cpriorityselection' => { 257 => '1.1', 258 => '1.1', 260 => '1.1', 261 => '1.1', 263 => '0.1', 264 => '0.1', 265 => '0.1', 266 => '1.1', 267 => '0.1', 270 => '1.1', 271 => '1.1' },
	'af-csetting' => { 118 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 118 => '0.2' },
	'af-ctrackingsensitivity' => { 118 => '0.1' },
	'af-czoneareaswitching' => { 118 => '0.3' },
	'af-onbutton' => { 260 => '70.1', 261 => '70.1', 271 => '70.1' },
	'af-onformb-d10' => { 257 => '3.3', 266 => '3.2' },
	'af-onformb-d11' => { 267 => '2.2' },
	'af-onformb-d12' => { 270 => '50.1' },
	'af-spriority' => { 122 => '0.1' },
	'af-spriorityselection' => { 257 => '1.2', 258 => '1.2', 260 => '1.4', 261 => '1.4', 265 => '0.2', 266 => '1.2', 267 => '0.2', 270 => '1.2', 271 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 257 => '2.1', 258 => '2.1', 260 => '78.3', 261 => '78.3', 266 => '2.1', 270 => '2.1', 271 => '78.3' },
	'afadjustment' => { 332 => 0x72, 341 => 0x267 },
	'afandmeteringbuttons' => { 78 => 0x701 },
	'afaperture' => { 207 => 0x5, 208 => 0x5 },
	'afareaheight' => { 183 => [0x1a,0x50] },
	'afareaillumination' => { 174 => 0x4b, 268 => '15.3' },
	'afareamode' => { 120 => '0.2', 170 => 0x33, 174 => 0xe, 182 => 0x0, 183 => 0x5, 297 => 0xf, 358 => 0x1205, 369 => [0xa,0x3a], 376 => 0x11, 377 => 0x10, 378 => 0x24, 388 => 0xb043, 411 => 0x17 },
	'afareamodesetting' => { 259 => '11.1', 262 => '0.1', 268 => '16.1', 272 => '2.1', 388 => 0x201c },
	'afareapointsize' => { 120 => '0.3' },
	'afareas' => { 274 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 78 => 0x51b },
	'afareawidth' => { 183 => [0x18,0x4e] },
	'afareaxposition' => { 183 => [0x14,0x4a], 358 => 0x1203 },
	'afareaxposition1' => { 358 => 0x1201 },
	'afareayposition' => { 183 => [0x16,0x4c], 358 => 0x1204 },
	'afareayposition1' => { 358 => 0x1202 },
	'afareazonesize' => { 120 => '0.4' },
	'afassist' => { 76 => 0x5, 84 => 0x5, 174 => 0x48, 257 => '2.5', 259 => '0.2', 262 => '0.2', 263 => '1.1', 264 => '1.1', 265 => '1.3', 266 => '2.4', 267 => '1.3', 268 => '0.2', 270 => '2.4', 272 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 78 => 0x50e, 79 => 0x4, 80 => 0x5, 81 => 0x4, 82 => 0x4, 83 => 0x5 },
	'afassistlamp' => { 297 => 0x31 },
	'afbuttonpressed' => { 378 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 308 => 0x6 },
	'afduringliveview' => { 78 => 0x511 },
	'affinea' => { 435 => 'AffineA' },
	'affineb' => { 435 => 'AffineB' },
	'affinec' => { 435 => 'AffineC' },
	'affined' => { 435 => 'AffineD' },
	'affinetune' => { 184 => 0x0, 274 => 0x306 },
	'affinetuneadj' => { 184 => 0x2, 221 => 0x2d1, 222 => 0x2dc, 274 => 0x307 },
	'affinetuneindex' => { 184 => 0x1 },
	'affinex' => { 435 => 'AffineX' },
	'affiney' => { 435 => 'AffineY' },
	'afhold' => { 308 => 0x1fd },
	'afilluminator' => { 376 => 0x29, 388 => 0xb044 },
	'afimageheight' => { 183 => [0x12,0x48] },
	'afimagewidth' => { 183 => [0x10,0x46] },
	'afintegrationtime' => { 308 => 0x7 },
	'afmicroadj' => { 369 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 373 => 0x131 },
	'afmicroadjregisteredlenses' => { 373 => '305.1' },
	'afmicroadjustment' => { 78 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 373 => 0x130 },
	'afmode' => { 107 => 0x3009, 121 => 0x1022, 170 => 0x16, 368 => 0x5 },
	'afmoderestrictions' => { 258 => '50.3', 260 => '48.3', 261 => '48.3', 270 => '48.3', 271 => '48.3' },
	'afonaelockbuttonswitch' => { 78 => 0x702 },
	'afonbutton' => { 257 => '3.1', 258 => '47.1' },
	'afpoint' => { 33 => 0x13, 106 => 0x18, 170 => 0x15, 182 => 0x1, 277 => 0x308, 368 => 0x1f, 369 => [0x37,0x7], 373 => 0x19, 374 => 0x18, 375 => [0x18,0x20] },
	'afpointactivationarea' => { 77 => 0x11, 83 => 0x11 },
	'afpointareaexpansion' => { 78 => 0x508 },
	'afpointatshutterrelease' => { 369 => [0x39,0x9] },
	'afpointautoselection' => { 78 => 0x50b },
	'afpointbrightness' => { 78 => 0x50d, 257 => '2.4', 258 => '46.5', 260 => '2.2', 261 => '2.2', 270 => '2.3', 271 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 78 => 0x50c },
	'afpointillumination' => { 77 => 0xa, 257 => '2.3', 258 => '46.2', 260 => '47.2', 261 => '47.2', 265 => '1.2', 266 => '2.3', 267 => '1.2', 270 => '47.2', 271 => '47.2', 272 => '2.4' },
	'afpointinfocus' => { 369 => [0x38,0x8] },
	'afpointmode' => { 313 => 0x3 },
	'afpointposition' => { 107 => 0x2021, 297 => 0x4d },
	'afpointregistration' => { 76 => 0x7 },
	'afpoints' => { 173 => 0x10 },
	'afpointselected' => { 174 => 0xd, 274 => 0x305, 332 => 0xe, 373 => 0x15, 374 => 0x14, 375 => [0x14,0x1c], 388 => 0x201e },
	'afpointselected2' => { 313 => 0x4 },
	'afpointselection' => { 77 => 0xb, 257 => '1.3', 258 => '1.3', 266 => '1.3', 270 => '1.3', 271 => '1.3' },
	'afpointselectionmethod' => { 78 => 0x50f, 79 => 0xc, 80 => 0xd, 83 => 0xd },
	'afpointsetting' => { 376 => 0x12, 377 => 0x11 },
	'afpointsinfocus' => { 72 => 0xe, 182 => 0x2, 308 => 0xb, 309 => 0x4, 332 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 77 => 0xd },
	'afpointsselected' => { 309 => '4.1', 419 => 0x4 },
	'afpointsspecial' => { 309 => '4.2' },
	'afpointsunknown1' => { 308 => 0x0 },
	'afpointsunknown2' => { 308 => 0x2 },
	'afpointsused' => { 183 => 0x8, 369 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 308 => 0x4 },
	'afresponse' => { 211 => 0xad },
	'afresult' => { 279 => 0x1038 },
	'afsearch' => { 274 => 0x303 },
	'afsensoractive' => { 170 => 0x1 },
	'afstatus' => { 358 => 0x1200 },
	'afstatus_00_b4' => { 372 => 0x0 },
	'afstatus_01_c4' => { 372 => 0x2 },
	'afstatus_02_d4' => { 372 => 0x4 },
	'afstatus_03_e4' => { 372 => 0x6 },
	'afstatus_04_f4' => { 372 => 0x8 },
	'afstatus_05_g4' => { 372 => 0xa },
	'afstatus_06_h4' => { 372 => 0xc },
	'afstatus_07_b3' => { 372 => 0xe },
	'afstatus_08_c3' => { 372 => 0x10 },
	'afstatus_09_d3' => { 372 => 0x12 },
	'afstatus_10_e3' => { 372 => 0x14 },
	'afstatus_11_f3' => { 372 => 0x16 },
	'afstatus_12_g3' => { 372 => 0x18 },
	'afstatus_13_h3' => { 372 => 0x1a },
	'afstatus_14_b2' => { 372 => 0x1c },
	'afstatus_15_c2' => { 372 => 0x1e },
	'afstatus_16_d2' => { 372 => 0x20 },
	'afstatus_17_e2' => { 372 => 0x22 },
	'afstatus_18_f2' => { 372 => 0x24 },
	'afstatus_19_g2' => { 372 => 0x26 },
	'afstatus_20_h2' => { 372 => 0x28 },
	'afstatus_21_c1' => { 372 => 0x2a },
	'afstatus_22_d1' => { 372 => 0x2c },
	'afstatus_23_e1' => { 372 => 0x2e },
	'afstatus_24_f1' => { 372 => 0x30 },
	'afstatus_25_g1' => { 372 => 0x32 },
	'afstatus_26_a7_vertical' => { 372 => 0x34 },
	'afstatus_27_a6_vertical' => { 372 => 0x36 },
	'afstatus_28_a5_vertical' => { 372 => 0x38 },
	'afstatus_29_c7_vertical' => { 372 => 0x3a },
	'afstatus_30_c6_vertical' => { 372 => 0x3c },
	'afstatus_31_c5_vertical' => { 372 => 0x3e },
	'afstatus_32_e7_vertical' => { 372 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 372 => 0x42 },
	'afstatus_34_e5_vertical' => { 372 => 0x44 },
	'afstatus_35_g7_vertical' => { 372 => 0x46 },
	'afstatus_36_g6_vertical' => { 372 => 0x48 },
	'afstatus_37_g5_vertical' => { 372 => 0x4a },
	'afstatus_38_i7_vertical' => { 372 => 0x4c },
	'afstatus_39_i6_vertical' => { 372 => 0x4e },
	'afstatus_40_i5_vertical' => { 372 => 0x50 },
	'afstatus_41_a7' => { 372 => 0x52 },
	'afstatus_42_b7' => { 372 => 0x54 },
	'afstatus_43_c7' => { 372 => 0x56 },
	'afstatus_44_d7' => { 372 => 0x58 },
	'afstatus_45_e7' => { 372 => 0x5a },
	'afstatus_46_f7' => { 372 => 0x5c },
	'afstatus_47_g7' => { 372 => 0x5e },
	'afstatus_48_h7' => { 372 => 0x60 },
	'afstatus_49_i7' => { 372 => 0x62 },
	'afstatus_50_a6' => { 372 => 0x64 },
	'afstatus_51_b6' => { 372 => 0x66 },
	'afstatus_52_c6' => { 372 => 0x68 },
	'afstatus_53_d6' => { 372 => 0x6a },
	'afstatus_54_e6_center' => { 372 => 0x6c },
	'afstatus_55_f6' => { 372 => 0x6e },
	'afstatus_56_g6' => { 372 => 0x70 },
	'afstatus_57_h6' => { 372 => 0x72 },
	'afstatus_58_i6' => { 372 => 0x74 },
	'afstatus_59_a5' => { 372 => 0x76 },
	'afstatus_60_b5' => { 372 => 0x78 },
	'afstatus_61_c5' => { 372 => 0x7a },
	'afstatus_62_d5' => { 372 => 0x7c },
	'afstatus_63_e5' => { 372 => 0x7e },
	'afstatus_64_f5' => { 372 => 0x80 },
	'afstatus_65_g5' => { 372 => 0x82 },
	'afstatus_66_h5' => { 372 => 0x84 },
	'afstatus_67_i5' => { 372 => 0x86 },
	'afstatus_68_c11' => { 372 => 0x88 },
	'afstatus_69_d11' => { 372 => 0x8a },
	'afstatus_70_e11' => { 372 => 0x8c },
	'afstatus_71_f11' => { 372 => 0x8e },
	'afstatus_72_g11' => { 372 => 0x90 },
	'afstatus_73_b10' => { 372 => 0x92 },
	'afstatus_74_c10' => { 372 => 0x94 },
	'afstatus_75_d10' => { 372 => 0x96 },
	'afstatus_76_e10' => { 372 => 0x98 },
	'afstatus_77_f10' => { 372 => 0x9a },
	'afstatus_78_g10' => { 372 => 0x9c },
	'afstatus_79_h10' => { 372 => 0x9e },
	'afstatus_80_b9' => { 372 => 0xa0 },
	'afstatus_81_c9' => { 372 => 0xa2 },
	'afstatus_82_d9' => { 372 => 0xa4 },
	'afstatus_83_e9' => { 372 => 0xa6 },
	'afstatus_84_f9' => { 372 => 0xa8 },
	'afstatus_85_g9' => { 372 => 0xaa },
	'afstatus_86_h9' => { 372 => 0xac },
	'afstatus_87_b8' => { 372 => 0xae },
	'afstatus_88_c8' => { 372 => 0xb0 },
	'afstatus_89_d8' => { 372 => 0xb2 },
	'afstatus_90_e8' => { 372 => 0xb4 },
	'afstatus_91_f8' => { 372 => 0xb6 },
	'afstatus_92_g8' => { 372 => 0xb8 },
	'afstatus_93_h8' => { 372 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 372 => 0xbc },
	'afstatusactivesensor' => { 170 => 0x2, 369 => [0x4,0x3b], 373 => 0x1e, 374 => 0x1b, 375 => [0x1b,0x21] },
	'afstatusbottom' => { 170 => 0x8, 373 => 0x2a, 374 => 0x21, 375 => 0x21 },
	'afstatusbottom-left' => { 170 => 0x12, 374 => 0x2b, 375 => 0x2b },
	'afstatusbottom-right' => { 170 => 0x6, 374 => 0x1f, 375 => 0x1f },
	'afstatusbottomassist-left' => { 373 => 0x28 },
	'afstatusbottomassist-right' => { 373 => 0x2c },
	'afstatusbottomhorizontal' => { 370 => 0x10, 371 => 0x1c },
	'afstatusbottomvertical' => { 370 => 0x16, 371 => 0x26 },
	'afstatuscenter-10' => { 373 => 0x34 },
	'afstatuscenter-11' => { 373 => 0x36 },
	'afstatuscenter-12' => { 373 => 0x38 },
	'afstatuscenter-14' => { 373 => 0x3c },
	'afstatuscenter-7' => { 373 => 0x2e },
	'afstatuscenter-9' => { 373 => 0x32 },
	'afstatuscenter-horizontal' => { 373 => 0x30 },
	'afstatuscenter-vertical' => { 373 => 0x3a },
	'afstatuscenterf2-8' => { 373 => 0x4c },
	'afstatuscenterhorizontal' => { 170 => 0x2f, 370 => 0xc, 371 => 0x18, 374 => 0x2f, 375 => 0x2f },
	'afstatuscentervertical' => { 170 => 0xc, 370 => 0x14, 371 => 0x22, 374 => 0x25, 375 => 0x25 },
	'afstatusfarleft' => { 370 => 0x6, 373 => 0x26 },
	'afstatusfarlefthorizontal' => { 371 => 0x4 },
	'afstatusfarleftvertical' => { 371 => 0x12 },
	'afstatusfarright' => { 370 => 0x18, 373 => 0x44 },
	'afstatusfarrighthorizontal' => { 371 => 0x2c },
	'afstatusfarrightvertical' => { 371 => 0x34 },
	'afstatusleft' => { 170 => 0x2d, 370 => 0x2, 373 => 0x22, 374 => 0x2d, 375 => 0x2d },
	'afstatuslefthorizontal' => { 371 => 0x6 },
	'afstatusleftvertical' => { 371 => 0xe },
	'afstatuslower-left' => { 370 => 0x4, 373 => 0x24 },
	'afstatuslower-lefthorizontal' => { 371 => 0xa },
	'afstatuslower-leftvertical' => { 371 => 0x10 },
	'afstatuslower-middle' => { 370 => 0x22, 371 => 0x24 },
	'afstatuslower-right' => { 370 => 0x1e, 373 => 0x4a },
	'afstatuslower-righthorizontal' => { 371 => 0x32 },
	'afstatuslower-rightvertical' => { 371 => 0x3a },
	'afstatuslowerfarleft' => { 371 => 0x8 },
	'afstatuslowerfarright' => { 371 => 0x30 },
	'afstatusmiddlehorizontal' => { 170 => 0xa, 374 => 0x23, 375 => 0x23 },
	'afstatusnearleft' => { 370 => 0xe, 371 => 0x1a },
	'afstatusnearright' => { 370 => 0xa, 371 => 0x16 },
	'afstatusright' => { 170 => 0x31, 370 => 0x1c, 373 => 0x48, 374 => 0x31, 375 => 0x31 },
	'afstatusrighthorizontal' => { 371 => 0x2e },
	'afstatusrightvertical' => { 371 => 0x38 },
	'afstatustop' => { 170 => 0xe, 373 => 0x40, 374 => 0x27, 375 => 0x27 },
	'afstatustop-left' => { 170 => 0x10, 374 => 0x29, 375 => 0x29 },
	'afstatustop-right' => { 170 => 0x4, 374 => 0x1d, 375 => 0x1d },
	'afstatustopassist-left' => { 373 => 0x3e },
	'afstatustopassist-right' => { 373 => 0x42 },
	'afstatustophorizontal' => { 370 => 0x8, 371 => 0x14 },
	'afstatustopvertical' => { 370 => 0x12, 371 => 0x1e },
	'afstatusupper-left' => { 370 => 0x0, 373 => 0x20 },
	'afstatusupper-lefthorizontal' => { 371 => 0x2 },
	'afstatusupper-leftvertical' => { 371 => 0xc },
	'afstatusupper-middle' => { 370 => 0x20, 371 => 0x20 },
	'afstatusupper-right' => { 370 => 0x1a, 373 => 0x46 },
	'afstatusupper-righthorizontal' => { 371 => 0x2a },
	'afstatusupper-rightvertical' => { 371 => 0x36 },
	'afstatusupperfarleft' => { 371 => 0x0 },
	'afstatusupperfarright' => { 371 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 388 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 369 => 0x2 },
	'afwithshutter' => { 376 => 0x2a },
	'aggregateissuenumber' => { 456 => 'aggregateIssueNumber' },
	'aggregationtype' => { 456 => 'aggregationType' },
	'agreement' => { 459 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 131 => 0xe4e },
	'aiservocontinuousshooting' => { 77 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 78 => 0x519 },
	'aiservoimagepriority' => { 78 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 78 => 0x51a },
	'aiservotrackingmethod' => { 78 => 0x504 },
	'aiservotrackingsensitivity' => { 77 => 0x14, 78 => 0x502 },
	'album' => { 466 => 'album' },
	'alreadyapplied' => { 442 => 'AlreadyApplied' },
	'alternatetitle' => { 456 => 'alternateTitle' },
	'alternatetitlea-lang' => { 456 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 456 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 456 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 185 => 0x6 },
	'alttapename' => { 466 => 'altTapeName' },
	'alttimecode' => { 466 => 'altTimecode' },
	'alttimecodetimeformat' => { 466 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 466 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 466 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 113 => 0x9400, 353 => 0x14, 354 => 0x46, 411 => 0x4, 447 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 353 => 0x13, 354 => 0x44 },
	'analogbalance' => { 113 => 0xc627 },
	'analogcaptureiso' => { 131 => 0x89e },
	'analogisotable' => { 131 => 0x89d },
	'angleadj' => { 97 => 0x10003, 103 => 0x8b },
	'angleinforoll' => { 437 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 437 => 'AngleInfoYaw' },
	'anti-blur' => { 388 => 0xb04b },
	'antialiasstrength' => { 113 => 0xc632 },
	'aperturelock' => { 258 => '38.2', 260 => '38.2', 261 => '38.2', 270 => '38.2', 271 => '38.2' },
	'aperturerange' => { 78 => 0x10d },
	'apertureringuse' => { 313 => '1.4' },
	'aperturesetting' => { 174 => 0x7, 376 => 0x30, 377 => 0x29, 378 => 0x1 },
	'aperturevalue' => { 87 => 0x2, 113 => 0x9202, 279 => 0x1002, 341 => 0x401, 446 => 'ApertureValue' },
	'applekeywords' => { 283 => 'AAPL:Keywords' },
	'applicationkeystring' => { 131 => 0x400 },
	'applicationnotes' => { 113 => 0x2bc, 302 => 0x2bc },
	'applicationrecordversion' => { 125 => 0x0 },
	'applyshootingmeteringmode' => { 78 => 0x10e },
	'approved' => { 448 => 'Approved' },
	'approvedby' => { 448 => 'ApprovedBy' },
	'approximatefnumber' => { 292 => 0x313, 299 => 0x3406 },
	'approximatefocusdistance' => { 438 => 'ApproximateFocusDistance' },
	'appversion' => { 450 => 'AppVersion' },
	'aquahsl' => { 97 => 0x20914 },
	'armidentifier' => { 126 => 0x78 },
	'armversion' => { 126 => 0x7a },
	'artfilter' => { 274 => 0x529 },
	'artfiltereffect' => { 274 => 0x52f },
	'artist' => { 113 => 0x13b, 287 => 'Artist', 332 => 0x22e, 462 => 'Artist', 466 => 'artist' },
	'artmode' => { 107 => 0x301b },
	'artmodeparameters' => { 107 => 0x310b },
	'artworkcircadatecreated' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 452 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 452 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 278 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 278 => 0x1112, 332 => 0x80, 376 => 0x55, 377 => 0x55, 378 => 0xa },
	'assetid' => { 431 => 'AssetID' },
	'asshoticcprofile' => { 113 => 0xc68f },
	'asshotneutral' => { 113 => 0xc628 },
	'asshotpreprofilematrix' => { 113 => 0xc690 },
	'asshotprofilename' => { 113 => 0xc6f6 },
	'asshotwhitexy' => { 113 => 0xc629 },
	'assignbktbutton' => { 257 => '4.2', 258 => '16.1', 260 => '16.1', 261 => '16.1', 270 => '16.1', 271 => '16.1' },
	'assignfuncbutton' => { 78 => 0x70b },
	'assignmb-d17af-onbutton' => { 261 => '79.1' },
	'assignmb-d17funcbutton' => { 261 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 261 => '68.1' },
	'assignmb-d18af-onbutton' => { 271 => '79.1' },
	'assignmb-d18funcbutton' => { 271 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 271 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 260 => '75.1', 261 => '75.1', 271 => '75.1' },
	'assignmoviefunc2button' => { 260 => '82.1', 261 => '82.1', 271 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 260 => '75.2', 261 => '75.2', 271 => '75.2' },
	'assignmovierecordbutton' => { 258 => '43.2', 270 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 260 => '45.1', 261 => '45.1', 271 => '45.1' },
	'assignmoviesubselector' => { 260 => '74.1', 261 => '74.1', 271 => '74.1' },
	'assignmoviesubselectorplusdials' => { 260 => '76.1', 261 => '76.1', 271 => '76.1' },
	'assignremotefnbutton' => { 258 => '54.1', 270 => '51.1' },
	'assistbuttonfunction' => { 76 => 0xd },
	'atcaptureusercrop' => { 131 => 0x943 },
	'attributionname' => { 439 => 'attributionName' },
	'attributionurl' => { 439 => 'attributionURL' },
	'audio' => { 297 => 0x20 },
	'audiobitrate' => { 63 => 0x6c, 452 => 'audioBitRate' },
	'audiobitratemode' => { 452 => 'audioBitRateMode' },
	'audiobitspersample' => { 452 => 'audioBitsPerSample' },
	'audiochannelcount' => { 452 => 'audioChannelCount' },
	'audiochannels' => { 63 => 0x70 },
	'audiochanneltype' => { 466 => 'audioChannelType' },
	'audiocompression' => { 146 => 'Compression' },
	'audiocompressor' => { 466 => 'audioCompressor' },
	'audiodata' => { 425 => 'Data' },
	'audioduration' => { 125 => 0x99 },
	'audiomimetype' => { 425 => 'Mime' },
	'audiomoddate' => { 466 => 'audioModDate' },
	'audiooutcue' => { 125 => 0x9a },
	'audiosamplerate' => { 63 => 0x6e, 466 => 'audioSampleRate' },
	'audiosampletype' => { 466 => 'audioSampleType' },
	'audiosamplingrate' => { 125 => 0x97 },
	'audiosamplingresolution' => { 125 => 0x98 },
	'audiotype' => { 125 => 0x96 },
	'author' => { 148 => 'Author', 283 => 'Author', 287 => 'Author', 348 => 'Author', 436 => 'author', 453 => 'Author', 464 => 'Author' },
	'authorsposition' => { 454 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 78 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 323 => '0.1' },
	'autobracket' => { 368 => 0x19 },
	'autobracketing' => { 121 => 0x1100, 332 => 0x18, 358 => 0x1007 },
	'autobracketingmode' => { 269 => '12.3' },
	'autobracketingset' => { 269 => '12.1' },
	'autobracketmodem' => { 257 => '21.2', 258 => '13.3', 260 => '13.2', 261 => '13.2', 266 => '26.2', 270 => '13.3', 271 => '13.2' },
	'autobracketorder' => { 174 => 0x43, 257 => '21.3', 258 => '13.2', 260 => '13.1', 261 => '13.1', 266 => '26.3', 267 => '12.2', 268 => '2.2', 269 => '12.2', 270 => '13.2', 271 => '13.1', 272 => '13.2' },
	'autobracketset' => { 257 => '21.1', 258 => '13.1', 262 => '11.1', 263 => '12.1', 264 => '12.1', 266 => '26.1', 267 => '12.1', 268 => '2.1', 270 => '13.1', 272 => '13.1' },
	'autobrightness' => { 442 => 'AutoBrightness' },
	'autocontrast' => { 442 => 'AutoContrast' },
	'autodistortioncontrol' => { 195 => 0x4 },
	'autodynamicrange' => { 121 => 0x140b },
	'autoexposure' => { 442 => 'AutoExposure' },
	'autoexposurebracketing' => { 72 => 0x10 },
	'autoflashisosensitivity' => { 260 => '38.5', 261 => '38.5', 271 => '38.5' },
	'autofocus' => { 277 => 0x209 },
	'autofp' => { 268 => '7.3', 272 => '31.4' },
	'autoiso' => { 72 => 0x1, 107 => 0x3008, 259 => '1.1', 268 => '1.1' },
	'autoisomax' => { 259 => '1.2', 268 => '1.2' },
	'autoisominshutterspeed' => { 259 => '1.3', 268 => '1.3' },
	'autolateralca' => { 442 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 59 => 0x2, 78 => 0x204, 97 => 0x20500, 103 => 0x6f },
	'autolightingoptimizeron' => { 97 => '0x20500.0', 103 => 0x6e },
	'autoportraitframed' => { 388 => 0x2016 },
	'autoredeye' => { 250 => 0xfe28a44f },
	'autorotate' => { 72 => 0x1b },
	'autoshadows' => { 442 => 'AutoShadows' },
	'autowhiteversion' => { 442 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 211 => 0x82 },
	'avaperturesetting' => { 313 => 0x13 },
	'averageblacklevel' => { 42 => 0xe7, 44 => 0xfb, 45 => 0x114, 46 => 0x146 },
	'averagelv' => { 177 => 0x38 },
	'avsettingwithoutlens' => { 78 => 0x707 },
	'azimuth' => { 156 => 'Azimuth' },
	'babyage' => { 297 => [0x8010,0x33] },
	'babyname' => { 297 => 0x66 },
	'backgroundalpha' => { 461 => 'bgalpha' },
	'baseexposurecompensation' => { 313 => 0x15 },
	'baseiso' => { 72 => 0x2, 91 => 0x101c, 131 => 0x903, 299 => 0x312a, 417 => 0x6 },
	'baseisodaylight' => { 131 => 0x910 },
	'baseisoflash' => { 131 => 0x913 },
	'baseisofluorescent' => { 131 => 0x912 },
	'baseisotungsten' => { 131 => 0x911 },
	'baselineexposure' => { 113 => 0xc62a },
	'baselineexposureoffset' => { 113 => 0xc7a5 },
	'baselinenoise' => { 113 => 0xc62b },
	'baselinesharpness' => { 113 => 0xc62c },
	'baseurl' => { 464 => 'BaseURL' },
	'batterylevel' => { 376 => 0x51, 380 => 0xc, 381 => 0x4, 382 => 0x4, 418 => 0x7 },
	'batterylevelgrip1' => { 418 => 0x6 },
	'batterylevelgrip2' => { 418 => 0x8 },
	'batteryorder' => { 257 => '12.5', 266 => '13.2', 267 => '2.1', 270 => '3.1' },
	'batterystate' => { 174 => 0x60, 376 => 0x50, 382 => 0x14 },
	'batterytemperature' => { 380 => 0x1, 382 => 0x2, 418 => 0x5 },
	'batterytype' => { 60 => 0x38 },
	'batteryunknown' => { 380 => 0x2, 382 => 0x0 },
	'batteryvoltage' => { 131 => 0x408, 353 => 0x2a, 354 => 0x49, 380 => 0x8 },
	'batteryvoltage1' => { 382 => 0x6 },
	'batteryvoltage2' => { 382 => 0x8 },
	'bayergreensplit' => { 113 => 0xc62d },
	'bayerpattern' => { 130 => 0xf902, 178 => 0x17 },
	'beatspliceparams' => { 466 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 466 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 466 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 466 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 466 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 466 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 257 => '13.1', 258 => '5.4', 259 => '0.1', 262 => '2.1', 263 => '3.1', 264 => '3.1', 266 => '10.1', 268 => '0.1', 270 => '5.5', 272 => '4.1' },
	'beeppitch' => { 267 => '3.1' },
	'beepvolume' => { 267 => '4.5' },
	'bestqualityscale' => { 113 => 0xc65c },
	'bestshotmode' => { 107 => 0x3007 },
	'bitdepth' => { 153 => 'BitDepth', 178 => 0x11, 218 => 0x41 },
	'bitspercomponent' => { 127 => 0x87 },
	'bitspersample' => { 113 => 0x102, 302 => 0xa, 462 => 'BitsPerSample' },
	'blackacquirerows' => { 131 => 0x18ba },
	'blacklevel' => { 113 => 0xc61a, 193 => 0x20, 211 => 0x3d, 279 => [0x401,0x1012], 341 => 0x21d },
	'blacklevel2' => { 278 => 0x600, 282 => 0x600 },
	'blacklevelblue' => { 302 => 0x1e },
	'blacklevelbottom' => { 131 => 0x3f0 },
	'blackleveldata' => { 341 => 0x223 },
	'blackleveldeltah' => { 113 => 0xc61b },
	'blackleveldeltav' => { 113 => 0xc61c },
	'blacklevelgreen' => { 302 => 0x1d },
	'blacklevelred' => { 302 => 0x1c },
	'blacklevelrepeatdim' => { 113 => 0xc619 },
	'blacklevelrough' => { 131 => 0x40e },
	'blacklevelroughafter' => { 131 => 0x416 },
	'blackleveltop' => { 131 => 0x3ef },
	'blackpoint' => { 332 => 0x200 },
	'blacks2012' => { 442 => 'Blacks2012' },
	'blacksadj' => { 421 => 0x9018 },
	'bleachbypasstoning' => { 332 => 0x7f },
	'blockshotafresponse' => { 260 => '1.5', 261 => '1.5', 271 => '1.5' },
	'blogtitle' => { 456 => 'blogTitle' },
	'blogurl' => { 456 => 'blogURL' },
	'bluebalance' => { 279 => 0x1018, 302 => 0x12, 332 => 0x1b },
	'bluecurvelimits' => { 102 => 0x1fe },
	'bluecurvepoints' => { 101 => 0x79, 102 => 0x1d4 },
	'bluehsl' => { 97 => 0x20915 },
	'bluehue' => { 442 => 'BlueHue' },
	'bluesaturation' => { 442 => 'BlueSaturation' },
	'bluratinfinity' => { 427 => 'BlurAtInfinity' },
	'blurcontrol' => { 332 => 0x82 },
	'blurwarning' => { 121 => 0x1300 },
	'bodybatteryadload' => { 311 => 0x3 },
	'bodybatteryadnoload' => { 311 => 0x2 },
	'bodybatterystate' => { 311 => '1.1' },
	'bodybatteryvoltage1' => { 311 => 0x2 },
	'bodybatteryvoltage2' => { 311 => 0x4 },
	'bodybatteryvoltage3' => { 311 => 0x6 },
	'bodybatteryvoltage4' => { 311 => 0x8 },
	'bodyfirmware' => { 359 => 0x0 },
	'bodyfirmwareversion' => { 275 => 0x104, 276 => 0x100, 279 => 0x104 },
	'bodyserialnumber' => { 359 => 0x10 },
	'bookedition' => { 456 => 'bookEdition' },
	'bootloaderversion' => { 354 => 0x26 },
	'bracketmode' => { 54 => 0x3 },
	'bracketsequence' => { 107 => 0x301d },
	'bracketsettings' => { 297 => 0x45 },
	'bracketshotnumber' => { 54 => 0x5, 313 => 0x9, 387 => 0x2b },
	'bracketshotnumber2' => { 387 => 0x2d },
	'bracketstep' => { 171 => 0xe },
	'bracketvalue' => { 54 => 0x4 },
	'brightness' => { 113 => 0xfe53, 147 => 'Brightness', 167 => 'Brightness', 171 => 0x2c, 213 => 0x34, 214 => 0x39, 353 => 0x25, 376 => 0x22, 388 => 0x2007, 442 => 'Brightness' },
	'brightnessadj' => { 102 => 0x114, 243 => 0x0, 253 => 0x2d, 421 => 0x8018 },
	'brightnessvalue' => { 113 => 0x9203, 177 => [0x691,0x49c3], 279 => 0x1003, 393 => 0x1e, 396 => 0x1140, 397 => 0x1140, 398 => 0x111c, 399 => 0x1198, 400 => 0x1174, 401 => 0x102c, 402 => 0x224, 403 => 0x224, 404 => 0x219, 446 => 'BrightnessValue' },
	'bulbduration' => { 72 => 0x18 },
	'burstcount' => { 131 => 0x40d },
	'burstmode' => { 133 => 0xa, 297 => 0x2a },
	'burstmode2' => { 133 => 0x18 },
	'burstshot' => { 368 => 0x34 },
	'burstspeed' => { 297 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 78 => 0x70a },
	'bwadjustment' => { 121 => 0x1049 },
	'bwfilter' => { 171 => 0x2a, 179 => 0x39 },
	'bwmode' => { 279 => 0x203 },
	'by-line' => { 125 => 0x50 },
	'by-linetitle' => { 125 => 0x55 },
	'bytecount' => { 456 => 'byteCount' },
	'c14configuration' => { 131 => 0x1964 },
	'cacheversion' => { 113 => 0xc7aa },
	'calibration' => { 368 => [0x24,0x30] },
	'calibrationhistory' => { 131 => 0x9c9 },
	'calibrationilluminant1' => { 113 => 0xc65a },
	'calibrationilluminant2' => { 113 => 0xc65b },
	'calibrationversion' => { 131 => 0x9c6 },
	'callforimage' => { 431 => 'CallForImage' },
	'cameraangle' => { 466 => 'cameraAngle' },
	'cameracalibration1' => { 113 => 0xc623 },
	'cameracalibration2' => { 113 => 0xc624 },
	'cameracalibrationsig' => { 113 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 36 => 0x0 },
	'cameracolorcalibration02' => { 35 => 0x4, 36 => 0x5 },
	'cameracolorcalibration03' => { 35 => 0x8, 36 => 0xa },
	'cameracolorcalibration04' => { 35 => 0xc, 36 => 0xf },
	'cameracolorcalibration05' => { 35 => 0x10, 36 => 0x14 },
	'cameracolorcalibration06' => { 35 => 0x14, 36 => 0x19 },
	'cameracolorcalibration07' => { 35 => 0x18, 36 => 0x1e },
	'cameracolorcalibration08' => { 35 => 0x1c, 36 => 0x23 },
	'cameracolorcalibration09' => { 35 => 0x20, 36 => 0x28 },
	'cameracolorcalibration10' => { 35 => 0x24, 36 => 0x2d },
	'cameracolorcalibration11' => { 35 => 0x28, 36 => 0x32 },
	'cameracolorcalibration12' => { 35 => 0x2c, 36 => 0x37 },
	'cameracolorcalibration13' => { 35 => 0x30, 36 => 0x3c },
	'cameracolorcalibration14' => { 35 => 0x34, 36 => 0x41 },
	'cameracolorcalibration15' => { 35 => 0x38, 36 => 0x46 },
	'camerae-mountversion' => { 420 => 0xb },
	'cameraelevationangle' => { 113 => 0x9405, 447 => 'CameraElevationAngle' },
	'camerafilename' => { 431 => 'CameraFilename' },
	'cameraid' => { 279 => 0x209, 367 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 113 => 0xc7a1, 466 => 'cameraLabel' },
	'cameramakemodel' => { 431 => 'CameraMakeModel' },
	'cameramodel' => { 341 => 0x410, 466 => 'cameraModel' },
	'cameramodelid' => { 167 => 'CameraModelID' },
	'cameramove' => { 466 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 297 => 0x8f, 336 => 0x1, 341 => 0x100, 382 => [0x16,0x18], 408 => 0x28, 409 => 0x24, 410 => 0x29 },
	'cameraowner' => { 134 => 0xc353 },
	'cameraparameters' => { 279 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 109 => 0x9 },
	'cameraprofile' => { 442 => 'CameraProfile' },
	'cameraprofiledigest' => { 442 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 103 => 0xe1 },
	'camerarawcontrast' => { 103 => 0xe3 },
	'camerarawhighlightpoint' => { 103 => 0xe6 },
	'camerarawlinear' => { 103 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 103 => 0xe8 },
	'camerarawoutputshadowpoint' => { 103 => 0xe9 },
	'camerarawsaturation' => { 103 => 0xe2 },
	'camerarawshadowpoint' => { 103 => 0xe7 },
	'camerarawsharpness' => { 103 => 0xe5 },
	'cameraroll' => { 109 => 0xb },
	'cameraserialnumber' => { 113 => 0xc62f, 169 => 'CameraSerialNumber', 431 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 274 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 72 => 0xc, 131 => 0x406, 278 => 0x1306, 292 => 0x320, 299 => 0x3402, 332 => 0x47, 365 => 0x43, 412 => 0x5 },
	'cameratemperature4' => { 337 => 0x14 },
	'cameratemperature5' => { 337 => 0x16 },
	'cameratemperaturerangemax' => { 115 => 0x5 },
	'cameratemperaturerangemin' => { 115 => 0x6 },
	'cameratype' => { 72 => 0x1a, 279 => 0x207 },
	'cameratype2' => { 275 => 0x100 },
	'camerayaw' => { 109 => 0xa },
	'canondr4' => { 114 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 91 => 0x805 },
	'canonfilelength' => { 60 => 0xe },
	'canonfirmwareversion' => { 60 => 0x7, 91 => 0x80b },
	'canonflashinfo' => { 91 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 60 => 0x6, 91 => 0x815 },
	'canonmodelid' => { 60 => 0x10, 91 => 0x1834 },
	'canonvrd' => { 114 => 'CanonVRD' },
	'caption' => { 436 => 'caption' },
	'caption-abstract' => { 125 => 0x78 },
	'captionsauthornames' => { 445 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 445 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 454 => 'CaptionWriter' },
	'captureframerate' => { 107 => 0x4001 },
	'captureheightnormal' => { 131 => 0x1839 },
	'capturelook' => { 131 => 0xc48 },
	'capturesoftware' => { 429 => 'CaptureSoftware' },
	'capturewidthnormal' => { 131 => 0x1838 },
	'capturewidthtest' => { 131 => 0x1842 },
	'cardshutterlock' => { 174 => 0x49 },
	'casioimagesize' => { 107 => 0x9 },
	'catalogsets' => { 125 => 0xff, 424 => 'CatalogSets', 434 => 'CatalogSets' },
	'categories' => { 60 => 0x23, 436 => 'categories' },
	'category' => { 125 => 0xf, 273 => 0x30, 454 => 'Category' },
	'cbcrgain' => { 365 => 0xa036 },
	'cbcrgaindefault' => { 365 => 0xa035 },
	'cbcrmatrix' => { 365 => 0xa034 },
	'cbcrmatrixdefault' => { 365 => 0xa033 },
	'ccdboardversion' => { 292 => 0x331 },
	'ccdscanmode' => { 279 => 0x1039 },
	'ccdsensitivity' => { 240 => 0x6 },
	'ccdversion' => { 292 => 0x330 },
	'cellglobalid' => { 440 => 'cgi' },
	'celllength' => { 113 => 0x109 },
	'cellr' => { 440 => 'r' },
	'celltowerid' => { 440 => 'cellid' },
	'cellwidth' => { 113 => 0x108 },
	'centerafarea' => { 268 => '15.1' },
	'centerfocuspoint' => { 272 => '2.2' },
	'centerpixel' => { 131 => 0x40c },
	'centerweightedareasize' => { 257 => '7.1', 258 => '8.1', 260 => '8.1', 261 => '8.1', 265 => '7.1', 266 => '5.1', 267 => '7.1', 268 => '6.3', 270 => '8.1', 271 => '8.1', 272 => '8.1' },
	'certificate' => { 470 => 'Certificate' },
	'cfainterpolationalgorithm' => { 131 => 0xe60 },
	'cfainterpolationmetric' => { 131 => 0xe61 },
	'cfaoffsetcols' => { 131 => 0xc71 },
	'cfaoffsetrows' => { 131 => 0xc6f },
	'cfapattern' => { 113 => 0xa302, 302 => 0x9, 446 => 'CFAPattern' },
	'cfapattern2' => { 113 => 0x828e },
	'cfapatterncolumns' => { 446 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 446 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 446 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 113 => 0x828d },
	'cfazipperfixthreshold' => { 131 => 0xe62 },
	'channel' => { 456 => 'channel' },
	'channela-lang' => { 456 => [\'channel','channelA-lang'] },
	'channelchannel' => { 456 => [\'channel','channelChannel'] },
	'channels' => { 146 => 'Channels' },
	'channelsubchannel1' => { 456 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 456 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 456 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 456 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 97 => 0x10101, 102 => 0x26a },
	'checkmark2' => { 103 => 0x8e },
	'childfontfiles' => { 471 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 257 => '10.3', 258 => '11.2' },
	'chromablurradius' => { 113 => 0xc631 },
	'chromanoisecolorspace' => { 131 => 0xe6d },
	'chromanoiseedgemapthresh' => { 131 => 0xe6c },
	'chromanoisehighfthresh' => { 131 => 0xe6a },
	'chromanoiselowfthresh' => { 131 => 0xe6b },
	'chromaticaberration' => { 97 => 0x20703, 103 => 0x66, 365 => 0xa051 },
	'chromaticaberrationb' => { 442 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 97 => 0x20708, 103 => 0x6b },
	'chromaticaberrationcorr' => { 74 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 113 => 0x7034, 322 => 0x1, 421 => 0x900d },
	'chromaticaberrationcorrparams' => { 113 => 0x7035, 416 => 0x66a, 417 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 97 => '0x20703.0', 103 => 0x62 },
	'chromaticaberrationr' => { 442 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 97 => 0x20707, 103 => 0x6a },
	'chromaticaberrationsetting' => { 75 => 0x6 },
	'chrominancenoisereduction' => { 97 => 0x20601, 103 => 0x5e, 368 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 103 => 0x60 },
	'circadatecreated' => { 452 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 442 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 442 => 'CircularGradientBasedCorrections' },
	'city' => { 125 => 0x5a, 152 => 'City', 297 => 0x6d, 454 => 'City' },
	'city2' => { 297 => 0x80 },
	'clarity' => { 214 => 0x35, 442 => 'Clarity' },
	'clarity2012' => { 442 => 'Clarity2012' },
	'claritycontrol' => { 332 => 0x96 },
	'classifystate' => { 125 => 0xe1 },
	'clearretouch' => { 297 => 0x7c },
	'clearretouchvalue' => { 297 => 0xa3 },
	'client' => { 466 => 'client' },
	'clientname' => { 448 => 'ClientName' },
	'clmodeshootingspeed' => { 257 => '10.2', 258 => '11.3', 260 => '11.2', 261 => '11.2', 266 => '11.2', 267 => '10.2', 270 => '11.2', 271 => '11.2', 272 => '11.1' },
	'cmcontrast' => { 282 => 0x2022 },
	'cmexposurecompensation' => { 282 => 0x2000 },
	'cmhue' => { 282 => 0x2021 },
	'cmsaturation' => { 282 => 0x2020 },
	'cmsharpness' => { 282 => 0x2023 },
	'cmwhitebalance' => { 282 => 0x2001 },
	'cmwhitebalancecomp' => { 282 => 0x2002 },
	'cmwhitebalancegraypoint' => { 282 => 0x2010 },
	'codec' => { 160 => 'Codec' },
	'codedcharacterset' => { 126 => 0x5a },
	'collection' => { 287 => 'Collection' },
	'collectionname' => { 161 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 161 => 'Collections', 436 => 'collections' },
	'collectionuri' => { 161 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 455 => 'color' },
	'coloraberrationcontrol' => { 250 => 0xc89224b },
	'coloradjustment' => { 368 => 0x14 },
	'coloradjustmentmode' => { 367 => 0x210 },
	'coloranta' => { 471 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 471 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 471 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 471 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 471 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 471 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 471 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 471 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 471 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 471 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 471 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 471 => 'Colorants' },
	'colorantswatchname' => { 471 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 471 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 471 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 471 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 147 => 'ColorBalance' },
	'colorbalanceadj' => { 250 => 0x76a43202 },
	'colorbalanceblue' => { 171 => 0x1e },
	'colorbalancegreen' => { 171 => 0x1d },
	'colorbalancered' => { 171 => 0x1c },
	'colorbalanceversion' => { 192 => 0x4, 193 => 0x4, 194 => 0x0 },
	'colorblur' => { 103 => 0x65 },
	'colorbluron' => { 97 => 0x20704 },
	'colorbooster' => { 250 => 0x5f0e7d23 },
	'colorboostlevel' => { 244 => 0x1 },
	'colorboosttype' => { 244 => 0x0 },
	'colorchromeeffect' => { 121 => 0x1048 },
	'colorclass' => { 343 => 0xde, 344 => 'ColorClass' },
	'colorcompensationfilter' => { 174 => [0x3a,0x5f], 176 => 0x111, 388 => 0xb022 },
	'colorcompensationfiltercustom' => { 376 => 0xd, 377 => 0xc },
	'colorcompensationfilterset' => { 376 => 0x8, 377 => 0x7, 378 => 0x18, 393 => 0xf },
	'colorcontrol' => { 279 => 0x102b },
	'colorcorrection' => { 421 => 0x8015 },
	'colorcreatoreffect' => { 274 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0 },
	'coloreffect' => { 297 => 0x28 },
	'colorfilter' => { 106 => 0x17, 107 => 0x3017, 171 => 0x29, 179 => [0x38,0x4d,0x4f], 339 => 0x17 },
	'colorgain' => { 218 => 0x51 },
	'colorhue' => { 97 => 0x20900, 211 => 0x8d },
	'colorimetricreference' => { 113 => 0xc6bf },
	'colorlabel' => { 445 => 'ColorLabel' },
	'colormatrix' => { 278 => 0x200, 279 => 0x1011, 365 => 0xa030 },
	'colormatrix1' => { 113 => 0xc621, 341 => 0x106 },
	'colormatrix2' => { 113 => 0xc622, 282 => 0x200, 341 => 0x226 },
	'colormatrixa' => { 332 => 0x203 },
	'colormatrixadobergb' => { 365 => 0xa032 },
	'colormatrixb' => { 332 => 0x204 },
	'colormatrixnumber' => { 279 => 0x1019 },
	'colormatrixsrgb' => { 365 => 0xa031 },
	'colormode' => { 107 => 0x3015, 121 => 0x1210, 133 => 0x66, 171 => 0x28, 174 => 0x16, 176 => 0x101, 177 => 0x36, 179 => 0x7, 211 => 0x3, 240 => 0x4, 297 => 0x32, 368 => 0x2c, 388 => 0xb029, 454 => 'ColorMode' },
	'colormoirereduction' => { 97 => 0x20670, 251 => 0x15 },
	'colormoirereductionmode' => { 251 => 0x5 },
	'colormoirereductionon' => { 97 => '0x20670.0' },
	'colornoisereduction' => { 421 => 0x8029, 442 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 442 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 251 => 0x18 },
	'colornoisereductionsharpness' => { 251 => 0x1c },
	'colornoisereductionsmoothness' => { 442 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 117 => 0x2 },
	'colorprofile' => { 171 => 0x33 },
	'colorprofilesettings' => { 274 => 0x539 },
	'colorrepresentation' => { 127 => 0x3c },
	'colorsaturationadj' => { 97 => 0x20305 },
	'colorsequence' => { 127 => 0x41 },
	'colorspace' => { 48 => 0x3, 60 => 0xb4, 91 => 0x10b4, 113 => 0xa001, 153 => 'ColorSpace', 172 => 0x2f, 173 => 0x25, 174 => 0x17, 211 => 0x1e, 274 => 0x507, 332 => 0x37, 365 => 0xa011, 368 => 0xb, 376 => 0x1b, 377 => 0x83, 378 => 0xe, 393 => 0x6, 446 => 'ColorSpace' },
	'colortempasshot' => { 37 => 0x4, 38 => 0x7, 39 => 0x1d, 40 => 0x26, 41 => 0x43, 44 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x4b },
	'colortempauto' => { 37 => 0x9, 38 => 0xf, 39 => 0x22, 40 => 0x1c, 41 => 0x48, 44 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x50 },
	'colortempcloudy' => { 37 => 0x22, 38 => 0x37, 39 => 0x31, 40 => 0x35, 41 => 0x5c, 44 => 0x75, 45 => 0x8e, 46 => 0x93, 47 => 0x96, 332 => 0x55 },
	'colortempcustom' => { 41 => 0x84 },
	'colortempcustom1' => { 39 => 0x45 },
	'colortempcustom2' => { 39 => 0x4a },
	'colortempdaylight' => { 37 => 0x18, 38 => 0x27, 39 => 0x27, 40 => 0x2b, 41 => 0x52, 44 => 0x6b, 45 => 0x84, 46 => 0x89, 47 => 0x8c, 332 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 60 => 0xae, 70 => 0x9, 91 => 0x10ae, 121 => 0x1005, 131 => 0x846, 147 => 'ColorTemperature', 172 => [0x6e,0x49], 173 => 0x3f, 174 => [0x39,0x5e], 176 => 0x10b, 179 => [0x3c,0x4c,0x4e], 292 => 0x321, 332 => 0x50, 358 => 0x1308, 388 => 0xb021, 442 => 'Temperature' },
	'colortemperatureadj' => { 421 => 0x8013 },
	'colortemperatureauto' => { 211 => 0x4f },
	'colortemperaturebg' => { 279 => 0x1013 },
	'colortemperaturecustom' => { 376 => 0xc, 377 => 0xb },
	'colortemperaturerg' => { 279 => 0x1014 },
	'colortemperatureset' => { 376 => 0x7, 377 => 0x6 },
	'colortemperaturesetting' => { 174 => 0x25, 378 => 0x17, 393 => 0xe },
	'colortempflash' => { 37 => 0x36, 38 => 0x57, 39 => 0x40, 40 => 0x49, 41 => 0x70, 44 => 0x89, 45 => 0xa2, 46 => 0xa7, 47 => 0xaa, 332 => 0x5a },
	'colortempflashdata' => { 41 => 0x24a },
	'colortempfluorescent' => { 37 => 0x2c, 38 => 0x47, 39 => 0x3b, 40 => 0x3f, 41 => 0x66, 44 => 0x7f, 45 => 0x98, 46 => 0x9d, 47 => 0xa0 },
	'colortempfluorescentd' => { 332 => 0x57 },
	'colortempfluorescentn' => { 332 => 0x58 },
	'colortempfluorescentw' => { 332 => 0x59 },
	'colortempkelvin' => { 37 => 0x31, 38 => 0x4f, 40 => 0x44, 41 => 0x6b, 44 => 0x84, 45 => 0x9d, 46 => 0xa2, 47 => 0xa5, 297 => 0x44, 358 => 0x1307 },
	'colortempmeasured' => { 37 => 0xe, 38 => 0x17, 41 => 0x4d, 44 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x55 },
	'colortemppc1' => { 40 => 0x94, 41 => 0x75 },
	'colortemppc2' => { 40 => 0x99, 41 => 0x7a },
	'colortemppc3' => { 40 => 0x9e, 41 => 0x7f },
	'colortempshade' => { 37 => 0x1d, 38 => 0x2f, 39 => 0x2c, 40 => 0x30, 41 => 0x57, 44 => 0x70, 45 => 0x89, 46 => 0x8e, 47 => 0x91, 332 => 0x54 },
	'colortemptungsten' => { 37 => 0x27, 38 => 0x3f, 39 => 0x36, 40 => 0x3a, 41 => 0x61, 44 => 0x7a, 45 => 0x93, 46 => 0x98, 47 => 0x9b, 332 => 0x56 },
	'colortempunknown' => { 37 => 0x13, 38 => 0x1f, 40 => 0x21, 44 => 0x52, 45 => 0x52, 46 => 0x52, 47 => 0x5a },
	'colortempunknown10' => { 37 => 0x63, 38 => 0x9f, 40 => 0x76, 44 => 0xa2, 45 => 0x7f, 46 => 0x7f, 47 => 0x87 },
	'colortempunknown11' => { 37 => 0x68, 38 => 0xa7, 40 => 0x7b, 44 => 0xa7, 45 => 0xa7, 46 => 0x84, 47 => 0xaf },
	'colortempunknown12' => { 37 => 0x6d, 38 => 0xaf, 40 => 0x80, 44 => 0xac, 45 => 0xac, 46 => 0xac, 47 => 0xb4 },
	'colortempunknown13' => { 37 => 0x72, 38 => 0xb7, 40 => 0x85, 44 => 0xb1, 45 => 0xb1, 46 => 0xb1, 47 => 0xb9 },
	'colortempunknown14' => { 40 => 0x8a, 44 => 0xb6, 45 => 0xb6, 46 => 0xb6, 47 => 0xbe },
	'colortempunknown15' => { 40 => 0x8f, 44 => 0xbb, 45 => 0xbb, 46 => 0xbb, 47 => 0xc3 },
	'colortempunknown16' => { 40 => 0xa3, 45 => 0xc0, 46 => 0xc0, 47 => 0xc8 },
	'colortempunknown17' => { 45 => 0xc5, 46 => 0xc5, 47 => 0xcd },
	'colortempunknown18' => { 45 => 0xca, 46 => 0xca, 47 => 0xd2 },
	'colortempunknown19' => { 45 => 0xcf, 46 => 0xcf, 47 => 0xd7 },
	'colortempunknown2' => { 37 => 0x3b, 38 => 0x5f, 40 => 0x4e, 44 => 0x57, 45 => 0x57, 46 => 0x57, 47 => 0x5f },
	'colortempunknown20' => { 45 => 0xd4, 46 => 0xd4, 47 => 0xdc },
	'colortempunknown21' => { 46 => 0xd9, 47 => 0xe1 },
	'colortempunknown22' => { 46 => 0xde, 47 => 0xe6 },
	'colortempunknown23' => { 46 => 0xe3, 47 => 0xeb },
	'colortempunknown24' => { 46 => 0xe8, 47 => 0xf0 },
	'colortempunknown25' => { 46 => 0xed, 47 => 0xf5 },
	'colortempunknown26' => { 46 => 0xf2, 47 => 0xfa },
	'colortempunknown27' => { 46 => 0xf7, 47 => 0xff },
	'colortempunknown28' => { 46 => 0xfc, 47 => 0x104 },
	'colortempunknown29' => { 46 => 0x101, 47 => 0x109 },
	'colortempunknown3' => { 37 => 0x40, 38 => 0x67, 40 => 0x53, 44 => 0x5c, 45 => 0x5c, 46 => 0x5c, 47 => 0x64 },
	'colortempunknown30' => { 46 => 0x106 },
	'colortempunknown4' => { 37 => 0x45, 38 => 0x6f, 40 => 0x58, 44 => 0x61, 45 => 0x61, 46 => 0x61, 47 => 0x69 },
	'colortempunknown5' => { 37 => 0x4a, 38 => 0x77, 40 => 0x5d, 44 => 0x66, 45 => 0x66, 46 => 0x66, 47 => 0x6e },
	'colortempunknown6' => { 37 => 0x4f, 38 => 0x7f, 40 => 0x62, 44 => 0x8e, 45 => 0x6b, 46 => 0x6b, 47 => 0x73 },
	'colortempunknown7' => { 37 => 0x54, 38 => 0x87, 40 => 0x67, 44 => 0x93, 45 => 0x70, 46 => 0x70, 47 => 0x78 },
	'colortempunknown8' => { 37 => 0x59, 38 => 0x8f, 40 => 0x6c, 44 => 0x98, 45 => 0x75, 46 => 0x75, 47 => 0x7d },
	'colortempunknown9' => { 37 => 0x5e, 38 => 0x97, 40 => 0x71, 44 => 0x9d, 45 => 0x7a, 46 => 0x7a, 47 => 0x82 },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 48 => 0x2 },
	'colortoneadj' => { 97 => 0x20304, 102 => 0x11e },
	'colortoneauto' => { 67 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 66 => 0x6c, 67 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 66 => 0x3c, 67 => 0x3c },
	'colortonemonochrome' => { 66 => 0x84, 67 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 66 => 0x54, 67 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 66 => 0x24, 67 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 66 => 0xc, 67 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 66 => 0x9c, 67 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 66 => 0xb4, 67 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 66 => 0xcc, 67 => 0xe4 },
	'comlenblksize' => { 131 => 0xfde8 },
	'commanddials' => { 268 => '5.1' },
	'commanddialsaperturesetting' => { 257 => '17.3', 258 => '18.3', 260 => '18.3', 261 => '18.3', 266 => '33.3', 267 => '17.3', 270 => '18.3', 271 => '18.3' },
	'commanddialschangemainsub' => { 257 => '17.2', 258 => '18.1', 260 => '18.1', 261 => '18.1', 266 => '33.2', 267 => '17.2', 270 => '18.1', 271 => '18.1' },
	'commanddialsmenuandplayback' => { 257 => '17.4', 258 => '18.2', 260 => '18.2', 261 => '18.2', 266 => '33.4', 267 => '17.4', 270 => '18.2', 271 => '18.2' },
	'commanddialsreverserotation' => { 257 => '17.1', 258 => '6.4', 260 => '6.2', 261 => '6.2', 262 => '16.2', 263 => '17.2', 266 => '33.1', 267 => '17.1', 270 => '6.2', 271 => '6.2', 272 => '18.1' },
	'commanderchannel' => { 268 => '10.2', 269 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 268 => '13.1', 269 => '31.1' },
	'commandergroupa_ttlcomp' => { 272 => '32.1' },
	'commandergroupamanualoutput' => { 268 => '13.2', 269 => '28.2' },
	'commandergroupamode' => { 268 => '11.2', 269 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 268 => '14.1', 269 => '32.1' },
	'commandergroupb_ttlcomp' => { 272 => '33.1' },
	'commandergroupbmanualoutput' => { 268 => '14.2', 269 => '29.2' },
	'commandergroupbmode' => { 268 => '11.3', 269 => '29.1' },
	'commanderinternalflash' => { 268 => '11.1', 269 => '27.1' },
	'commanderinternalmanualoutput' => { 268 => '12.2', 269 => '27.2' },
	'commanderinternalttlchannel' => { 266 => '18.2' },
	'commanderinternalttlcomp' => { 268 => '12.1', 269 => '30.2', 272 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 266 => '20.1', 267 => '26.1' },
	'commanderinternalttlcompgroupa' => { 266 => '21.1', 267 => '27.1' },
	'commanderinternalttlcompgroupb' => { 266 => '22.1', 267 => '28.1' },
	'comment' => { 0 => 0x2, 114 => 'Comment', 148 => 'Comment', 287 => 'Comment' },
	'compass' => { 361 => 0x4 },
	'complianceprofile' => { 456 => 'complianceProfile' },
	'componentsconfiguration' => { 113 => 0x9101, 153 => 'Components', 446 => 'ComponentsConfiguration' },
	'componentversion' => { 91 => 0x80c },
	'composer' => { 466 => 'composer' },
	'composition' => { 431 => 'Composition' },
	'compositionadjust' => { 331 => '0.1' },
	'compositionadjustrotation' => { 331 => 0x7 },
	'compositionadjustx' => { 331 => 0x5 },
	'compositionadjusty' => { 331 => 0x6 },
	'compressedbitsperpixel' => { 113 => 0x9102, 446 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 176 => 0x40, 279 => 0x40 },
	'compression' => { 113 => 0x103, 302 => 0xb, 462 => 'Compression' },
	'compressionfactor' => { 274 => 0x50d },
	'compressionratio' => { 153 => 'Compression', 279 => 0x1034 },
	'condadobvfactor' => { 131 => 0xf3e },
	'condadodaybvthresh' => { 131 => 0xf3c },
	'condadodayoffsets' => { 131 => 0xf42 },
	'condadofluoffsets' => { 131 => 0xf44 },
	'condadofluthresh' => { 131 => 0xf41 },
	'condadoillfactor' => { 131 => 0xf3f },
	'condadoneurange' => { 131 => 0xf3d },
	'condadotunoffsets' => { 131 => 0xf43 },
	'condadotunthresh' => { 131 => 0xf40 },
	'confidence' => { 426 => 'Confidence' },
	'confidencelevel' => { 437 => 'ConfidenceLevel' },
	'confidencemime' => { 426 => 'ConfidenceMime' },
	'constrainedcropheight' => { 102 => 0x266, 343 => 0xd6 },
	'constrainedcropwidth' => { 102 => 0x262, 343 => 0xd5 },
	'contact' => { 125 => 0x76 },
	'contactinfo' => { 455 => 'contactInfo' },
	'containerformat' => { 452 => 'ContainerFormat' },
	'containerformatidentifier' => { 452 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 452 => [\'ContainerFormat','ContainerFormatName'] },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 125 => 0x1a },
	'contentlocationname' => { 125 => 0x1b },
	'contenttype' => { 456 => 'contentType' },
	'continuousbracketing' => { 174 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousmodeliveview' => { 271 => '77.2' },
	'continuousshootingspeed' => { 78 => 0x610 },
	'continuousshotlimit' => { 78 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 106 => 0xc, 107 => [0x3012,0x20], 113 => [0xa408,0xfe54], 121 => [0x1004,0x1006], 147 => 'Contrast', 167 => 'Contrast', 171 => 0x20, 172 => 0x31, 173 => 0x27, 174 => 0x19, 179 => 0x2, 213 => 0x33, 214 => 0x37, 279 => 0x1029, 297 => 0x39, 299 => 0x300a, 332 => 0x20, 339 => 0xc, 353 => 0x24, 358 => 0x1012, 368 => 0xd, 376 => 0x1d, 377 => 0x1a, 388 => 0x2004, 442 => 'Contrast', 446 => 'Contrast' },
	'contrast2012' => { 442 => 'Contrast2012' },
	'contrastadj' => { 97 => 0x20303, 102 => 0x115, 253 => 0x2c, 421 => 0x8017 },
	'contrastauto' => { 67 => 0x90 },
	'contrastcurve' => { 211 => 0x8c },
	'contrastdetectaf' => { 183 => 0x4 },
	'contrastdetectafarea' => { 332 => 0x231 },
	'contrastdetectafinfocus' => { 183 => [0x1c,0x52] },
	'contrastfaithful' => { 18 => 0xec, 66 => 0x60, 67 => 0x60 },
	'contrasthighlight' => { 332 => 0x6d },
	'contrasthighlightshadowadj' => { 332 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 66 => 0x30, 67 => 0x30 },
	'contrastmode' => { 297 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 66 => 0x78, 67 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 66 => 0x48, 67 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 66 => 0x18, 67 => 0x18 },
	'contrastsetting' => { 274 => 0x505, 282 => 0x1012, 378 => 0x10, 393 => 0x8 },
	'contrastshadow' => { 332 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 66 => 0x0, 67 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 66 => 0x90, 67 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 66 => 0xa8, 67 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 66 => 0xc0, 67 => 0xd8 },
	'contributedmedia' => { 466 => 'contributedMedia' },
	'contributedmediaduration' => { 466 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 466 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 466 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 466 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 466 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 466 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 466 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 466 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 466 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 466 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 443 => 'contributor', 452 => 'Contributor' },
	'contributoridentifier' => { 452 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 452 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 452 => [\'Contributor','ContributorRole'] },
	'contributors' => { 148 => 'Contributors' },
	'controldialset' => { 174 => 0x46 },
	'controlledvocabularyterm' => { 452 => 'CVterm' },
	'controllerboardversion' => { 292 => 0x332 },
	'controlmode' => { 72 => 0x12 },
	'controlringrotation' => { 78 => 0x712 },
	'conversionlens' => { 275 => 0x403, 297 => 0x35 },
	'converter' => { 113 => 0xfe4d, 240 => 0xb, 442 => 'Converter' },
	'converttograyscale' => { 442 => 'ConvertToGrayscale' },
	'cookingequipment' => { 458 => 'cookingEquipment' },
	'cookingmethod' => { 458 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 113 => 0x8298, 148 => 'Copyright', 287 => 'Copyright', 332 => 0x22f, 348 => 'Copyright', 453 => 'Copyright', 459 => 'copyright', 462 => 'Copyright', 466 => 'copyright' },
	'copyrightflag' => { 346 => 0x40a },
	'copyrightnotice' => { 125 => 0x74 },
	'copyrightowner' => { 284 => 'CopyrightOwner' },
	'copyrightownerid' => { 284 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 284 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 284 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 284 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 284 => 'CopyrightStatus' },
	'copyrightyear' => { 452 => 'CopyrightYear', 456 => 'copyrightYear' },
	'coringfilter' => { 278 => 0x310, 279 => 0x102d, 282 => 0x310 },
	'coringvalues' => { 278 => 0x311, 282 => 0x311 },
	'corporateentity' => { 456 => 'corporateEntity' },
	'country' => { 152 => 'Country', 297 => 0x69, 454 => 'Country' },
	'country-primarylocationcode' => { 125 => 0x64 },
	'country-primarylocationname' => { 125 => 0x65 },
	'countrycode' => { 210 => 0x5, 344 => 'CountryCode', 451 => 'CountryCode' },
	'course' => { 458 => 'course' },
	'coverage' => { 443 => 'coverage' },
	'coverdate' => { 456 => 'coverDate' },
	'coverdisplaydate' => { 456 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 332 => 0x28 },
	'crc32' => { 444 => 'crc32' },
	'createdate' => { 113 => 0x9004, 148 => 'CreateDate', 283 => 'CreationDate', 287 => 'create-date', 348 => 'CreationDate', 350 => 0x1, 464 => 'CreateDate' },
	'creationdate' => { 453 => 'CreationDate', 456 => 'creationDate' },
	'creationtime' => { 287 => 'Creation Time' },
	'creativestyle' => { 376 => 0x1a, 377 => 0x18, 387 => 0x41, 388 => 0xb020, 417 => 0x4a },
	'creativestylesetting' => { 378 => 0xf, 393 => 0x7 },
	'creativestylewaschanged' => { 421 => 0x8001 },
	'creator' => { 283 => 'Creator', 348 => 'Creator', 443 => 'creator', 452 => 'Creator', 453 => 'Creator' },
	'creatoraddress' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 169 => 'CreatorAppId' },
	'creatorcity' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 451 => 'CreatorContactInfo' },
	'creatorcountry' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 452 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 452 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 169 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 452 => [\'Creator','CreatorRole'] },
	'creatortool' => { 464 => 'CreatorTool' },
	'creatorworkemail' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 451 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 125 => 0x6e, 454 => 'Credit' },
	'creditline' => { 459 => 'creditLine' },
	'creditlinereq' => { 469 => 'CreditLineReq' },
	'creditlinerequired' => { 284 => 'CreditLineRequired' },
	'cropactive' => { 95 => 0x0, 102 => 0x244 },
	'cropangle' => { 442 => 'CropAngle' },
	'croparea' => { 421 => 0x9011 },
	'cropaspectratio' => { 97 => 0x30101, 102 => 0x260 },
	'cropaspectratiocustom' => { 97 => 0x30102 },
	'cropbottom' => { 117 => 0x9, 245 => 0x36, 302 => 0x31, 343 => 0xdc, 442 => 'CropBottom' },
	'cropbottommargin' => { 50 => 0x3 },
	'cropcircleactive' => { 103 => 0xd6 },
	'cropcircleradius' => { 103 => 0xd9 },
	'cropcirclex' => { 103 => 0xd7 },
	'cropcircley' => { 103 => 0xd8 },
	'cropconstraintowarp' => { 442 => 'CropConstrainToWarp' },
	'croph' => { 435 => 'CropH' },
	'cropheight' => { 95 => 0x6, 102 => 0x24c, 278 => 0x615, 282 => 0x615, 442 => 'CropHeight' },
	'crophispeed' => { 211 => 0x1b },
	'cropleft' => { 102 => 0x246, 117 => 0x6, 245 => 0x1e, 278 => 0x612, 282 => 0x612, 302 => 0x30, 343 => 0xd9, 442 => 'CropLeft' },
	'cropleftmargin' => { 50 => 0x0 },
	'cropmode' => { 121 => 0x104d },
	'cropmode35mm' => { 358 => 0x1018 },
	'croporiginalheight' => { 95 => 0xb },
	'croporiginalwidth' => { 95 => 0xa },
	'cropoutputheight' => { 245 => 0xce },
	'cropoutputheightinches' => { 245 => 0x96 },
	'cropoutputpixels' => { 245 => 0xd6 },
	'cropoutputresolution' => { 245 => 0xb6 },
	'cropoutputscale' => { 245 => 0xbe },
	'cropoutputwidth' => { 245 => 0xc6 },
	'cropoutputwidthinches' => { 245 => 0x8e },
	'croppedareaimageheightpixels' => { 429 => 'CroppedAreaImageHeightPixels', 430 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 429 => 'CroppedAreaImageWidthPixels', 430 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 429 => 'CroppedAreaLeftPixels', 430 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 429 => 'CroppedAreaTopPixels', 430 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 358 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 358 => 0x1603 },
	'cropping' => { 421 => 0x9010 },
	'cropright' => { 117 => 0x8, 245 => 0x2e, 302 => 0x32, 343 => 0xdb, 442 => 'CropRight' },
	'croprightmargin' => { 50 => 0x1 },
	'croprotatedoriginalheight' => { 95 => 0x2 },
	'croprotatedoriginalwidth' => { 95 => 0x1 },
	'croprotation' => { 95 => 0x8, 117 => 0xb },
	'cropscaledresolution' => { 245 => 0x9e },
	'cropsourceresolution' => { 245 => 0xae },
	'croptop' => { 102 => 0x248, 117 => 0x7, 245 => 0x26, 278 => 0x613, 282 => 0x613, 302 => 0x2f, 343 => 0xda, 442 => 'CropTop' },
	'croptopmargin' => { 50 => 0x2 },
	'cropunit' => { 442 => 'CropUnit' },
	'cropunits' => { 442 => 'CropUnits' },
	'cropw' => { 435 => 'CropW' },
	'cropwidth' => { 95 => 0x5, 102 => 0x24a, 278 => 0x614, 282 => 0x614, 442 => 'CropWidth' },
	'cropx' => { 95 => 0x3, 435 => 'CropX' },
	'cropy' => { 95 => 0x4, 435 => 'CropY' },
	'crossprocess' => { 332 => 0x7b },
	'crossprocessparams' => { 332 => 0x235 },
	'cuisine' => { 458 => 'cuisine' },
	'currenticcprofile' => { 113 => 0xc691 },
	'currentpreprofilematrix' => { 113 => 0xc692 },
	'currentversion' => { 421 => 0xd000 },
	'curve0x' => { 435 => 'Curve0x' },
	'curve0y' => { 435 => 'Curve0y' },
	'curve1x' => { 435 => 'Curve1x' },
	'curve1y' => { 435 => 'Curve1y' },
	'curve2x' => { 435 => 'Curve2x' },
	'curve2y' => { 435 => 'Curve2y' },
	'curve3x' => { 435 => 'Curve3x' },
	'curve3y' => { 435 => 'Curve3y' },
	'curve4x' => { 435 => 'Curve4x' },
	'curve4y' => { 435 => 'Curve4y' },
	'curves' => { 250 => 0x76a43201 },
	'custom1' => { 284 => 'Custom1' },
	'custom10' => { 284 => 'Custom10' },
	'custom2' => { 284 => 'Custom2' },
	'custom3' => { 284 => 'Custom3' },
	'custom4' => { 284 => 'Custom4' },
	'custom5' => { 284 => 'Custom5' },
	'custom6' => { 284 => 'Custom6' },
	'custom7' => { 284 => 'Custom7' },
	'custom8' => { 284 => 'Custom8' },
	'custom9' => { 284 => 'Custom9' },
	'customcolortone' => { 103 => 0x4c },
	'customcontrast' => { 103 => 0x4e },
	'customcontrols' => { 78 => 0x70c },
	'customdefaultunsharpfineness' => { 103 => 0xbe },
	'customdefaultunsharpstrength' => { 103 => 0xbc },
	'customdefaultunsharpthreshold' => { 103 => 0xc0 },
	'customilluminant' => { 131 => 0x405 },
	'customizedials' => { 78 => 0x715 },
	'customlinear' => { 103 => 0x4f },
	'customoutputhighlightpoint' => { 103 => 0x53 },
	'customoutputshadowpoint' => { 103 => 0x54 },
	'custompicturestyle' => { 97 => 0x10021 },
	'custompicturestyledata' => { 97 => 0xf0500 },
	'custompicturestylefilename' => { 60 => 0x4010 },
	'customrawhighlight' => { 103 => 0x7c },
	'customrawhighlightpoint' => { 103 => 0x51 },
	'customrawshadow' => { 103 => 0x85 },
	'customrawshadowpoint' => { 103 => 0x52 },
	'customrendered' => { 113 => 0xa401, 446 => 'CustomRendered' },
	'customsaturation' => { 103 => 0x4d, 274 => 0x503 },
	'customsettingsalldefault' => { 257 => '0.2', 266 => '0.2' },
	'customsettingsbank' => { 257 => '0.1', 258 => '0.1', 260 => '0.1', 261 => '0.1', 266 => '0.1', 270 => '0.2', 271 => '0.2' },
	'customsharpness' => { 103 => 0x50 },
	'customunsharpmaskfineness' => { 103 => 0xb8 },
	'customunsharpmaskstrength' => { 103 => 0xb6 },
	'customunsharpmaskthreshold' => { 103 => 0xba },
	'customwb_rblevels' => { 393 => 0x1a },
	'customwb_rgblevels' => { 377 => 0x8, 378 => 0x19 },
	'customwbbluelevel' => { 174 => 0x36 },
	'customwberror' => { 174 => 0x37 },
	'customwbgreenlevel' => { 174 => 0x35 },
	'customwbredlevel' => { 174 => 0x34 },
	'customwbsetting' => { 174 => 0x26 },
	'd-lightinghq' => { 250 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 246 => 0x2 },
	'd-lightinghqhighlight' => { 246 => 0x1 },
	'd-lightinghqselected' => { 250 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 246 => 0x0 },
	'd-lightinghs' => { 250 => 0xce5554aa },
	'd-lightinghsadjustment' => { 247 => 0x0 },
	'd-lightinghscolorboost' => { 247 => 0x1 },
	'd-rangeoptimizerhighlight' => { 421 => 0x8024 },
	'd-rangeoptimizermode' => { 421 => 0x8022 },
	'd-rangeoptimizershadow' => { 421 => 0x802d },
	'd-rangeoptimizervalue' => { 421 => 0x8023 },
	'd810meteringmode' => { 237 => 0x175e },
	'darkblacksegrows' => { 131 => 0x18d8 },
	'darkfocusenvironment' => { 297 => 0x8003 },
	'darkframecountfactor' => { 131 => 0xc85 },
	'darkframelongexposure' => { 131 => 0xc84 },
	'darkframeshortexposure' => { 131 => 0xc83 },
	'darkpedestal' => { 131 => 0xc7f },
	'data' => { 426 => 'Data' },
	'datacompressionmethod' => { 127 => 0x6e },
	'dataimprint' => { 171 => 0x34 },
	'dataonscreen' => { 452 => 'DataOnScreen' },
	'dataonscreenregion' => { 452 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 452 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 452 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 452 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 452 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 452 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 452 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 452 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 332 => 0x3d },
	'date' => { 332 => 0x6, 443 => 'date' },
	'dateacquired' => { 169 => 'DateAcquired' },
	'datecreated' => { 125 => 0x37, 454 => 'DateCreated' },
	'datedisplayformat' => { 242 => 0x3 },
	'dateidentified' => { 112 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 262 => '4.2' },
	'daterecieved' => { 456 => 'dateRecieved' },
	'datesent' => { 126 => 0x46 },
	'datestampmode' => { 60 => 0x1c },
	'datetime' => { 436 => 'datetime', 462 => 'DateTime' },
	'datetimedigitized' => { 446 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 94 => 0x0, 113 => 0x9003, 145 => 0x14, 148 => 'OriginalDate', 353 => 0xb, 354 => 0x3b, 446 => 'DateTimeOriginal' },
	'datetimestamp' => { 133 => 0x64 },
	'datetimeutc' => { 274 => 0x908 },
	'daylightsavings' => { 73 => 0x3, 242 => 0x2 },
	'dayofweek' => { 354 => 0x42 },
	'dccontinent' => { 112 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 112 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 112 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 112 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 112 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 112 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 112 => 'Event' },
	'dcfootprintspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 112 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 112 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 112 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 112 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 112 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 112 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 112 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 112 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 112 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 112 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 112 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 112 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 156 => 'Declination' },
	'decposition' => { 171 => 0x32 },
	'defaultautogray' => { 442 => 'DefaultAutoGray' },
	'defaultautotone' => { 442 => 'DefaultAutoTone' },
	'defaultblackrender' => { 113 => 0xc7a6 },
	'defaultcroporigin' => { 113 => 0xc61f },
	'defaultcropsize' => { 113 => 0xc620 },
	'defaulteraseoption' => { 78 => 0x813 },
	'defaultscale' => { 113 => 0xc61e },
	'defaultsspecifictoiso' => { 442 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 442 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 113 => 0xc7b5 },
	'defectisocode' => { 131 => 0x90f },
	'defringe' => { 442 => 'Defringe' },
	'defringegreenamount' => { 442 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 442 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 442 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 442 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 442 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 442 => 'DefringePurpleHueLo' },
	'dehaze' => { 442 => 'Dehaze' },
	'deletedimagecount' => { 211 => 0xa6, 219 => 0x6e },
	'deprecatedon' => { 439 => 'deprecatedOn' },
	'derivedfrom' => { 467 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 467 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 467 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 467 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 467 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 467 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 467 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 467 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 467 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 467 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 467 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 467 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 467 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 467 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 467 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 467 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 467 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 467 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 467 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 467 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 467 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 467 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 467 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 467 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 287 => 'Description', 443 => 'description', 464 => 'Description' },
	'destination' => { 126 => 0x5 },
	'destinationcity' => { 332 => 0x24, 338 => 0x3 },
	'destinationcitycode' => { 339 => 0x1001 },
	'destinationdst' => { 332 => 0x26, 338 => '0.3' },
	'developmentdynamicrange' => { 121 => 0x1403 },
	'deviantmatrixcustom' => { 131 => 0x7de },
	'deviantmatrixdaylight' => { 131 => 0x7da },
	'deviantmatrixflash' => { 131 => 0x7dd },
	'deviantmatrixfluorescent' => { 131 => 0x7dc },
	'deviantmatrixtungsten' => { 131 => 0x7db },
	'deviantwhitecustom' => { 131 => 0x842 },
	'deviantwhitedaylight' => { 131 => 0x83e },
	'deviantwhiteflash' => { 131 => 0x841 },
	'deviantwhitefluorescent' => { 131 => 0x840 },
	'deviantwhitetungsten' => { 131 => 0x83f },
	'device' => { 456 => 'device' },
	'devicesettingdescription' => { 446 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 446 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 446 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 446 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 365 => 0x2 },
	'dialdirectiontvav' => { 78 => 0x706 },
	'dietaryneeds' => { 458 => 'dietaryNeeds' },
	'diffractioncorrection' => { 297 => 0xbc, 322 => 0x3 },
	'diffractioncorrectionon' => { 97 => 0x2070b },
	'digitalcreationdate' => { 125 => 0x3e },
	'digitalcreationtime' => { 125 => 0x3f },
	'digitaldeehighlightadj' => { 218 => 0x202 },
	'digitaldeeshadowadj' => { 218 => 0x200 },
	'digitaldeethreshold' => { 218 => 0x201 },
	'digitalfilter' => { 368 => 0x59 },
	'digitalfilter01' => { 319 => 0x5 },
	'digitalfilter02' => { 319 => 0x16 },
	'digitalfilter03' => { 319 => 0x27 },
	'digitalfilter04' => { 319 => 0x38 },
	'digitalfilter05' => { 319 => 0x49 },
	'digitalfilter06' => { 319 => 0x5a },
	'digitalfilter07' => { 319 => 0x6b },
	'digitalfilter08' => { 319 => 0x7c },
	'digitalfilter09' => { 319 => 0x8d },
	'digitalfilter10' => { 319 => 0x9e },
	'digitalfilter11' => { 319 => 0xaf },
	'digitalfilter12' => { 319 => 0xc0 },
	'digitalfilter13' => { 319 => 0xd1 },
	'digitalfilter14' => { 319 => 0xe2 },
	'digitalfilter15' => { 319 => 0xf3 },
	'digitalfilter16' => { 319 => 0x104 },
	'digitalfilter17' => { 319 => 0x115 },
	'digitalfilter18' => { 319 => 0x126 },
	'digitalfilter19' => { 319 => 0x137 },
	'digitalfilter20' => { 319 => 0x148 },
	'digitalgain' => { 70 => 0xb },
	'digitalgem' => { 203 => 0x0 },
	'digitalice' => { 218 => 0x100 },
	'digitalimageguid' => { 452 => 'DigImageGUID' },
	'digitalroc' => { 216 => 0x0 },
	'digitalsourcefiletype' => { 452 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 452 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 106 => 0xa, 121 => 0x1044, 133 => 0x68, 147 => 'DigitalZoom', 171 => 0xc, 211 => 0x86, 240 => 0xa, 279 => 0x204, 332 => 0x1e, 339 => 0xa, 367 => 0x204, 408 => 0x12, 409 => 0x12 },
	'digitalzoomon' => { 367 => 0x21b },
	'digitalzoomratio' => { 113 => 0xa404, 398 => 0x200, 400 => 0x21c, 446 => 'DigitalZoomRatio' },
	'director' => { 466 => 'director' },
	'directorphotography' => { 466 => 'directorPhotography' },
	'directory' => { 114 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 197 => 0x3 },
	'disclaimer' => { 287 => 'Disclaimer' },
	'discnumber' => { 466 => 'discNumber' },
	'dishtype' => { 458 => 'dishType' },
	'displayallafpoints' => { 78 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 347 => 0x2 },
	'displayedunitsy' => { 347 => 0x6 },
	'displayname' => { 455 => 'displayName' },
	'distance1' => { 133 => 0x28 },
	'distance2' => { 133 => 0x2c },
	'distance3' => { 133 => 0x30 },
	'distance4' => { 133 => 0x34 },
	'distortion' => { 365 => 0xa050 },
	'distortioncompensation' => { 421 => 0x8040 },
	'distortioncontrol' => { 219 => 0x10 },
	'distortioncorrection' => { 97 => 0x20705, 103 => 0x67, 113 => 0x7036, 274 => 0x50b, 301 => '7.1', 322 => 0x0, 416 => 0x601, 417 => 0x5b },
	'distortioncorrection2' => { 278 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 438 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 97 => '0x20705.0', 103 => 0x63 },
	'distortioncorrectionsetting' => { 388 => 0x2013 },
	'distortioncorrparams' => { 113 => 0x7037, 397 => 0x1a23, 400 => 0x1870, 402 => 0x189c, 403 => 0x18cc, 404 => 0x17d0, 416 => 0x6ca, 417 => 0x64 },
	'distortioncorrparamsnumber' => { 400 => 0x1899, 402 => 0x18c5, 403 => 0x18f5, 404 => 0x17f9 },
	'distortioncorrparamspresent' => { 400 => 0x1898, 402 => 0x18c4, 403 => 0x18f4, 404 => 0x17f8, 406 => 0x10b, 407 => 0x10b, 416 => 0x600, 417 => 0x5a },
	'distortioneffect' => { 97 => 0x20709 },
	'distortionn' => { 301 => 0xc },
	'distortionparam02' => { 301 => 0x2 },
	'distortionparam04' => { 301 => 0x4 },
	'distortionparam08' => { 301 => 0x8 },
	'distortionparam09' => { 301 => 0x9 },
	'distortionparam11' => { 301 => 0xb },
	'distortionscale' => { 301 => 0x5 },
	'distributor' => { 456 => 'distributor' },
	'distributorproductid' => { 455 => 'distributorProductID' },
	'dloon' => { 97 => '0x20706.0', 103 => 0xdc },
	'dlosetting' => { 97 => 0x20706, 103 => 0xdd },
	'dlosettingapplied' => { 96 => 0x4 },
	'dloshootingdistance' => { 103 => 0xde },
	'dloversion' => { 96 => 0x5 },
	'dmcomment' => { 466 => 'comment' },
	'dmdithermatrix' => { 131 => 0xc7a },
	'dmdithermatrixheight' => { 131 => 0xc7c },
	'dmdithermatrixwidth' => { 131 => 0xc7b },
	'dngadobedata' => { 113 => 0xc634 },
	'dngbackwardversion' => { 113 => 0xc613 },
	'dngignoresidecars' => { 442 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 113 => 0xc630 },
	'dngprivatedata' => { 113 => 0xc634 },
	'dngversion' => { 113 => 0xc612 },
	'document' => { 287 => 'Document' },
	'documentancestors' => { 454 => 'DocumentAncestors' },
	'documenthistory' => { 125 => 0xe7 },
	'documentid' => { 467 => 'DocumentID' },
	'documentname' => { 113 => 0x10d },
	'documentnotes' => { 125 => 0xe6 },
	'doi' => { 456 => 'doi' },
	'dopesheet' => { 452 => 'Dopesheet' },
	'dopesheetlink' => { 452 => 'DopesheetLink' },
	'dopesheetlinklink' => { 452 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 452 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 131 => 0xc82 },
	'dpp' => { 436 => 'dpp' },
	'dr4cameramodel' => { 98 => 0x3 },
	'drangepriority' => { 121 => 0x1443 },
	'drangepriorityauto' => { 121 => 0x1444 },
	'drangepriorityfixed' => { 121 => 0x1445 },
	'drivemode' => { 107 => 0x3103, 119 => '0.1', 171 => 0x6, 174 => 0x1e, 177 => 0xe, 274 => 0x600, 332 => 0x34, 358 => 0x1002, 368 => 0x3, 376 => 0x4, 377 => 0x7e, 378 => 0x34 },
	'drivemode2' => { 174 => 0xa, 313 => 0x7, 387 => 0xe, 393 => 0x1 },
	'drivemodesetting' => { 378 => 0x4 },
	'drivespeed' => { 119 => '0.2' },
	'dspfirmwareversion' => { 332 => 0x27 },
	'duration' => { 63 => 0x6a, 146 => 'Duration', 160 => 'Duration', 458 => 'duration', 466 => 'duration' },
	'durationscale' => { 466 => [\'duration','durationScale'] },
	'durationvalue' => { 466 => [\'duration','durationValue'] },
	'dustremovaldata' => { 60 => 0x97 },
	'dynamicafarea' => { 257 => '1.4', 266 => '1.4' },
	'dynamicareaafdisplay' => { 258 => '46.1', 260 => '47.1', 261 => '47.1', 270 => '47.1', 271 => '47.1' },
	'dynamicrange' => { 121 => 0x1400 },
	'dynamicrangeexpansion' => { 332 => 0x69, 358 => 0x100e },
	'dynamicrangemax' => { 102 => 0x7c },
	'dynamicrangemin' => { 102 => 0x7a },
	'dynamicrangeoptimizer' => { 174 => 0x15, 388 => [0xb025,0xb04f], 396 => 0x1144, 397 => [0x1144,0x324], 398 => [0x1120,0x300], 399 => [0x119c,0x37c], 400 => [0x1178,0x328], 401 => [0x1030,0x50], 402 => [0x228,0x50], 403 => [0x228,0x50], 404 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 387 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 376 => 0x19, 377 => 0x17, 378 => 0xd, 387 => 0x79, 393 => 0x5 },
	'dynamicrangeoptimizermode' => { 177 => 0x15, 376 => 0x18, 377 => 0x16, 387 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 174 => 0x27, 378 => 0xc, 393 => 0x4 },
	'dynamicrangesetting' => { 121 => 0x1402 },
	'e-dialinprogram' => { 313 => '1.3' },
	'earliestageorloweststage' => { 112 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 272 => '6.1' },
	'easyexposurecompensation' => { 257 => '6.4', 258 => '6.5', 260 => '6.3', 261 => '6.3', 265 => '5.1', 266 => '4.4', 267 => '5.2', 270 => '6.3', 271 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgemapslope' => { 131 => 0x930 },
	'edgemapx1' => { 131 => 0x931 },
	'edgemapx2' => { 131 => 0x932 },
	'edgemapx3' => { 131 => 0x934 },
	'edgemapx4' => { 131 => 0x935 },
	'edgenoisereduction' => { 251 => 0x4, 421 => 0x8028 },
	'edition' => { 456 => 'edition' },
	'editorialupdate' => { 125 => 0x8 },
	'editstatus' => { 125 => 0x7, 344 => 'EditStatus', 436 => 'EditStatus' },
	'editversionname' => { 250 => 0x3d136244 },
	'effectivelv' => { 332 => 0x2d },
	'effectivemaxaperture' => { 207 => 0x12, 208 => 0x13 },
	'eissn' => { 456 => 'eIssn' },
	'electricalblackcolumns' => { 131 => 0x1810 },
	'electronicfront-curtainshutter' => { 260 => '5.2', 261 => '5.2', 270 => '5.3', 271 => '5.2' },
	'electronicfrontcurtainshutter' => { 388 => 0x201a },
	'elevation' => { 156 => 'Elevation' },
	'email' => { 148 => 'EMail' },
	'embargodate' => { 459 => 'embargoDate' },
	'embdencrightsexpr' => { 452 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 452 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 452 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 452 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 454 => 'EmbeddedXMPDigest' },
	'emissivity' => { 115 => 0x3 },
	'enablechromanoisereduction' => { 131 => 0xe6e },
	'enablesharpening' => { 131 => 0x92e },
	'encryptionkey' => { 365 => 0xa020 },
	'endingpage' => { 456 => 'endingPage' },
	'enduser' => { 284 => 'EndUser' },
	'enduserid' => { 284 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 284 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 466 => 'engineer' },
	'enhancedarktones' => { 243 => 0x8 },
	'enhancement' => { 106 => 0x16, 107 => 0x3016 },
	'enhancer' => { 278 => 0x300 },
	'enhancervalues' => { 278 => 0x301 },
	'envelopenumber' => { 126 => 0x28 },
	'envelopepriority' => { 126 => 0x3c },
	'enveloperecordversion' => { 126 => 0x0 },
	'episode' => { 452 => 'Episode' },
	'episodeidentifier' => { 452 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 452 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 452 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 279 => 0x20c },
	'epsonimagewidth' => { 279 => 0x20b },
	'epsonsoftware' => { 279 => 0x20d },
	'equipmentinstitution' => { 423 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 423 => 'EquipmentManufacturer' },
	'equipmentversion' => { 275 => 0x0 },
	'ettlii' => { 78 => 0x304, 79 => 0xd, 80 => 0xe, 81 => 0x7, 82 => 0x7, 83 => 0xe },
	'event' => { 424 => 'Event', 434 => 'Event', 452 => 'Event', 456 => 'event' },
	'eventalias' => { 455 => 'eventAlias' },
	'eventdate' => { 112 => [\'Event','EventEventDate'] },
	'eventday' => { 112 => [\'Event','EventDay'] },
	'eventearliestdate' => { 112 => [\'Event','EventEarliestDate'] },
	'eventend' => { 455 => 'eventEnd' },
	'eventenddayofyear' => { 112 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 112 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 112 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 112 => [\'Event','EventHabitat'] },
	'eventid' => { 112 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 112 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 112 => [\'Event','EventMonth'] },
	'eventnumber' => { 353 => 0x9, 354 => 0x37 },
	'eventparenteventid' => { 112 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 112 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 112 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 112 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 112 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 112 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 455 => 'eventStart' },
	'eventstartdayofyear' => { 112 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 455 => 'eventSubtype' },
	'eventtime' => { 112 => [\'Event','EventEventTime'] },
	'eventtype' => { 455 => 'eventType' },
	'eventverbatimeventdate' => { 112 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 112 => [\'Event','EventYear'] },
	'evsteps' => { 313 => '1.2', 315 => 0x0 },
	'evstepsize' => { 262 => '5.1', 263 => '6.1', 264 => '6.1', 268 => '0.7' },
	'exclusivecoverage' => { 431 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 459 => 'exclusivityEndDate' },
	'excursiontolerance' => { 127 => 0x82 },
	'exif' => { 114 => 'EXIF' },
	'exifbyteorder' => { 114 => 'ExifByteOrder' },
	'exifcamerainfo' => { 125 => 0xe8 },
	'exifimageheight' => { 113 => 0xa003, 446 => 'PixelYDimension' },
	'exifimagewidth' => { 113 => 0xa002, 446 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 114 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 113 => 0x9000, 446 => 'ExifVersion' },
	'exitpupilposition' => { 207 => 0x4, 208 => 0x4 },
	'expirationdate' => { 125 => 0x25, 459 => 'expirationDate' },
	'expirationtime' => { 125 => 0x26 },
	'exposure' => { 113 => 0xfe51, 442 => 'Exposure' },
	'exposure2012' => { 442 => 'Exposure2012' },
	'exposureadj' => { 248 => 0x0 },
	'exposureadj2' => { 248 => 0x12 },
	'exposureadjust' => { 368 => 0xc },
	'exposurebracketingindicatorlast' => { 174 => 0x52 },
	'exposurebracketshotnumber' => { 177 => 0x2d, 387 => 0x2f },
	'exposurebracketstepsize' => { 313 => 0x8 },
	'exposurebracketvalue' => { 211 => 0x19 },
	'exposurecompautocancel' => { 78 => 0x113 },
	'exposurecompensation' => { 72 => 0x6, 87 => 0x0, 113 => 0x9204, 133 => 0x24, 147 => 'ExposureComp', 167 => 'ExposureCompensation', 171 => 0xd, 172 => 0x53, 173 => 0x1e, 177 => 0x49c0, 279 => 0x1006, 332 => 0x16, 341 => 0x402, 365 => 0xa013, 368 => [0xc,0x35,0x4d], 396 => 0x114c, 397 => 0x114c, 398 => 0x1128, 400 => 0x1180, 401 => 0x1038, 402 => 0x230, 403 => 0x230, 404 => 0x223, 446 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 393 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 174 => 0x47, 177 => 0x2a },
	'exposurecompensationset' => { 376 => 0x3, 377 => 0x3, 378 => 0x3, 393 => 0x1e },
	'exposurecompensationsetting' => { 174 => 0x1 },
	'exposurecompstepsize' => { 257 => '6.3', 258 => '7.3', 260 => '7.3', 261 => '7.3', 266 => '4.3', 270 => '7.3', 271 => '7.3' },
	'exposurecontrolstep' => { 265 => '6.1', 267 => '6.1' },
	'exposurecontrolstepsize' => { 257 => '6.2', 258 => '7.1', 260 => '7.1', 261 => '7.1', 266 => '4.2', 270 => '7.1', 271 => '7.1', 272 => '7.1' },
	'exposurecount' => { 121 => 0x1032 },
	'exposuredelaymode' => { 257 => '10.1', 258 => '11.1', 260 => '11.1', 261 => '11.1', 262 => '9.1', 263 => '10.1', 264 => '10.1', 266 => '10.4', 267 => '10.1', 268 => '6.4', 270 => '11.1', 271 => '11.1', 272 => '11.2' },
	'exposuredifference' => { 211 => 0xe },
	'exposuregaincustom' => { 131 => 0x89c },
	'exposuregaindaylight' => { 131 => 0x898 },
	'exposuregainflash' => { 131 => 0x89b },
	'exposuregainfluorescent' => { 131 => 0x89a },
	'exposuregaintungsten' => { 131 => 0x899 },
	'exposureindex' => { 113 => 0xa215, 446 => 'ExposureIndex' },
	'exposureindicator' => { 174 => 0x50 },
	'exposurelevelincrements' => { 76 => 0x6, 77 => 0x6, 78 => 0x101, 79 => 0x5, 80 => 0x6, 81 => 0x5, 82 => 0x5, 83 => 0x6, 84 => 0x4, 376 => 0x58, 377 => 0x58 },
	'exposurelockused' => { 429 => 'ExposureLockUsed' },
	'exposuremode' => { 113 => 0xa402, 147 => 'ExposureMode', 171 => 0x1, 172 => 0xa, 173 => 0x0, 174 => 0x0, 177 => 0x34, 274 => 0x200, 294 => 0x40d, 368 => 0x8, 388 => 0xb041, 446 => 'ExposureMode' },
	'exposuremodeinmanual' => { 78 => 0x10b },
	'exposureprogram' => { 113 => 0x8822, 358 => 0x1001, 369 => [0x17e,0x43], 376 => 0x3c, 377 => 0x3c, 378 => 0x5, 382 => 0x14, 387 => 0x3f, 393 => 0x2, 396 => 0x1175, 397 => 0x1179, 398 => 0x1155, 399 => 0x11d1, 400 => 0x11ad, 401 => 0x1065, 402 => 0x25d, 403 => 0x25d, 404 => 0x24c, 413 => 0xb, 414 => 0xc, 415 => 0xb, 417 => 0x48, 446 => 'ExposureProgram' },
	'exposureshift' => { 274 => 0x203 },
	'exposurestandardadjustment' => { 388 => 0x202d },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 72 => 0x16, 113 => 0x829a, 130 => 0xfd05, 133 => 0x20, 135 => 0xfa24, 137 => 0xf104, 140 => 0x12, 142 => 0x38, 145 => 0x10, 147 => 'ExposureTime', 171 => 0x9, 172 => 0x35, 173 => 0x48, 174 => 0x8, 177 => 0x49b8, 332 => 0x12, 365 => 0xa018, 368 => [0x32,0x4a], 376 => 0x0, 377 => 0x0, 393 => [0x21,0x23,0x27], 417 => 0x10, 446 => 'ExposureTime' },
	'exposuretime2' => { 368 => [0x33,0x4b] },
	'exposuretuning' => { 211 => 0x1c },
	'exposurevalue' => { 131 => 0x3 },
	'exposurewarning' => { 121 => 0x1302 },
	'exrauto' => { 121 => 0x1033 },
	'exrmode' => { 121 => 0x1034 },
	'extendedwbdetect' => { 274 => 0x902 },
	'extender' => { 275 => 0x301 },
	'extenderfirmwareversion' => { 275 => 0x304 },
	'extendermagnification' => { 149 => 'Magnification' },
	'extendermake' => { 149 => 'Make' },
	'extendermodel' => { 149 => 'Model', 275 => 0x303 },
	'extenderserialnumber' => { 149 => 'SerialNumber', 275 => 0x302 },
	'extenderstatus' => { 330 => 0x3 },
	'externalflash' => { 277 => 0x1201 },
	'externalflashae1' => { 279 => 0x101f },
	'externalflashae1_0' => { 279 => 0x101b },
	'externalflashae2' => { 279 => 0x1020 },
	'externalflashae2_0' => { 279 => 0x101c },
	'externalflashbounce' => { 277 => 0x1204, 279 => 0x1026, 320 => 0x1a },
	'externalflashcompensation' => { 200 => 0x1b },
	'externalflashexposurecomp' => { 211 => 0x17, 320 => 0x19 },
	'externalflashfirmware' => { 198 => 0x6, 199 => 0x6, 200 => 0x6, 201 => 0x6, 202 => 0x6 },
	'externalflashflags' => { 198 => 0x8, 199 => 0x8, 200 => 0x8, 201 => 0x8 },
	'externalflashguidenumber' => { 277 => 0x1203, 320 => '24.1' },
	'externalflashgvalue' => { 279 => 0x1025 },
	'externalflashmode' => { 279 => 0x1028, 320 => 0x2 },
	'externalflashreadystate' => { 202 => '9.1' },
	'externalflashstatus' => { 202 => '8.2' },
	'externalflashzoom' => { 277 => 0x1205, 279 => 0x1027 },
	'externalflashzoomoverride' => { 202 => '8.1' },
	'externalmetadatalink' => { 452 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 292 => 0x311, 295 => 0x311, 296 => 0x311, 299 => 0x3408 },
	'extrainfoversion' => { 380 => 0x1a },
	'eyestartaf' => { 174 => 0x40 },
	'fac100per' => { 131 => 0xe94 },
	'fac170per' => { 131 => 0xe93 },
	'fac18per' => { 131 => 0xe92 },
	'face10position' => { 104 => 0x3f4, 105 => 0x1ec, 196 => 0x28, 317 => 0x12 },
	'face10size' => { 318 => 0x12 },
	'face11position' => { 196 => 0x2c, 317 => 0x14 },
	'face11size' => { 318 => 0x14 },
	'face12position' => { 196 => 0x30, 317 => 0x16 },
	'face12size' => { 318 => 0x16 },
	'face13position' => { 317 => 0x18 },
	'face13size' => { 318 => 0x18 },
	'face14position' => { 317 => 0x1a },
	'face14size' => { 318 => 0x1a },
	'face15position' => { 317 => 0x1c },
	'face15size' => { 318 => 0x1c },
	'face16position' => { 317 => 0x1e },
	'face16size' => { 318 => 0x1e },
	'face17position' => { 317 => 0x20 },
	'face17size' => { 318 => 0x20 },
	'face18position' => { 317 => 0x22 },
	'face18size' => { 318 => 0x22 },
	'face19position' => { 317 => 0x24 },
	'face19size' => { 318 => 0x24 },
	'face1position' => { 51 => 0x8, 104 => 0xd, 105 => 0x18, 196 => 0x4, 289 => 0x1, 317 => 0x0, 355 => 0xbc, 383 => 0x1, 384 => 0x0, 385 => 0x0, 386 => 0x5b },
	'face1size' => { 318 => 0x0 },
	'face20position' => { 317 => 0x26 },
	'face20size' => { 318 => 0x26 },
	'face21position' => { 317 => 0x28 },
	'face21size' => { 318 => 0x28 },
	'face22position' => { 317 => 0x2a },
	'face22size' => { 318 => 0x2a },
	'face23position' => { 317 => 0x2c },
	'face23size' => { 318 => 0x2c },
	'face24position' => { 317 => 0x2e },
	'face24size' => { 318 => 0x2e },
	'face25position' => { 317 => 0x30 },
	'face25size' => { 318 => 0x30 },
	'face26position' => { 317 => 0x32 },
	'face26size' => { 318 => 0x32 },
	'face27position' => { 317 => 0x34 },
	'face27size' => { 318 => 0x34 },
	'face28position' => { 317 => 0x36 },
	'face28size' => { 318 => 0x36 },
	'face29position' => { 317 => 0x38 },
	'face29size' => { 318 => 0x38 },
	'face2position' => { 51 => 0xa, 104 => 0x7c, 105 => 0x4c, 196 => 0x8, 289 => 0x5, 317 => 0x2, 355 => 0xc8, 383 => 0x6, 384 => 0x20, 385 => 0x25, 386 => 0x65 },
	'face2size' => { 318 => 0x2 },
	'face30position' => { 317 => 0x3a },
	'face30size' => { 318 => 0x3a },
	'face31position' => { 317 => 0x3c },
	'face31size' => { 318 => 0x3c },
	'face32position' => { 317 => 0x3e },
	'face32size' => { 318 => 0x3e },
	'face3position' => { 51 => 0xc, 104 => 0xeb, 105 => 0x80, 196 => 0xc, 289 => 0x9, 317 => 0x4, 355 => 0xd4, 383 => 0xb, 384 => 0x40, 385 => 0x4a, 386 => 0x6f },
	'face3size' => { 318 => 0x4 },
	'face4position' => { 51 => 0xe, 104 => 0x15a, 105 => 0xb4, 196 => 0x10, 289 => 0xd, 317 => 0x6, 355 => 0xe0, 383 => 0x10, 384 => 0x60, 385 => 0x6f, 386 => 0x79 },
	'face4size' => { 318 => 0x6 },
	'face5position' => { 51 => 0x10, 104 => 0x1c9, 105 => 0xe8, 196 => 0x14, 289 => 0x11, 317 => 0x8, 355 => 0xec, 383 => 0x15, 384 => 0x80, 385 => 0x94 },
	'face5size' => { 318 => 0x8 },
	'face6position' => { 51 => 0x12, 104 => 0x238, 105 => 0x11c, 196 => 0x18, 317 => 0xa, 355 => 0xf8, 383 => 0x1a, 384 => 0xa0, 385 => 0xb9 },
	'face6size' => { 318 => 0xa },
	'face7position' => { 51 => 0x14, 104 => 0x2a7, 105 => 0x150, 196 => 0x1c, 317 => 0xc, 355 => 0x104, 383 => 0x1f, 384 => 0xc0, 385 => 0xde },
	'face7size' => { 318 => 0xc },
	'face8position' => { 51 => 0x16, 104 => 0x316, 105 => 0x184, 196 => 0x20, 317 => 0xe, 355 => 0x110, 383 => 0x24, 384 => 0xe0, 385 => 0x103 },
	'face8size' => { 318 => 0xe },
	'face9position' => { 51 => 0x18, 104 => 0x385, 105 => 0x1b8, 196 => 0x24, 317 => 0x10 },
	'face9size' => { 318 => 0x10 },
	'facebalanceorigi' => { 435 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 435 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 435 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 435 => 'FaceBalanceWarmth' },
	'facedetect' => { 332 => 0x76, 365 => 0x100 },
	'facedetectarea' => { 278 => 0x1201 },
	'facedetectframecrop' => { 278 => 0x1207 },
	'facedetectframesize' => { 51 => 0x3, 104 => 0x1, 105 => 0x4, 196 => 0x1, 278 => 0x1203, 332 => 0x77, 355 => 0xb6 },
	'facedetection' => { 378 => 0x30, 393 => 0x19 },
	'faceelementpositions' => { 121 => 0x4203 },
	'faceelementtypes' => { 121 => 0x4201 },
	'faceid' => { 437 => 'FaceID' },
	'faceinfounknown' => { 107 => 0x2089 },
	'facename' => { 365 => 0x123 },
	'faceorientation' => { 105 => 0x8 },
	'faceposition' => { 316 => 0x2, 366 => 0x4 },
	'facepositions' => { 121 => 0x4103 },
	'facerecognition' => { 365 => 0x120 },
	'facesdetected' => { 51 => 0x2, 52 => 0x2, 53 => 0x3, 104 => 0x0, 105 => 0x2, 107 => 0x211c, 121 => 0x4100, 196 => 0x3, 278 => 0x1200, 297 => 0x3f, 316 => 0x0, 355 => 0xb5, 366 => 0x0, 383 => 0x0, 386 => 0x3, 395 => 0x30 },
	'facesrecognized' => { 290 => 0x0 },
	'facewidth' => { 52 => 0x1 },
	'faithfuloutputhighlightpoint' => { 103 => 0x38 },
	'faithfuloutputshadowpoint' => { 103 => 0x39 },
	'faithfulrawcolortone' => { 103 => 0x31 },
	'faithfulrawcontrast' => { 103 => 0x33 },
	'faithfulrawhighlight' => { 103 => 0x79 },
	'faithfulrawhighlightpoint' => { 103 => 0x36 },
	'faithfulrawlinear' => { 103 => 0x34 },
	'faithfulrawsaturation' => { 103 => 0x32 },
	'faithfulrawshadow' => { 103 => 0x82 },
	'faithfulrawshadowpoint' => { 103 => 0x37 },
	'faithfulrawsharpness' => { 103 => 0x35 },
	'faithfulunsharpmaskfineness' => { 103 => 0xac },
	'faithfulunsharpmaskstrength' => { 103 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 103 => 0xae },
	'far' => { 426 => 'Far' },
	'fastresetlinetime' => { 131 => 0x1860 },
	'feedidentifier' => { 452 => 'FeedIdentifier' },
	'femicroadjustment' => { 78 => 0x111 },
	'ffid' => { 444 => 'ffid' },
	'field' => { 455 => 'field' },
	'fieldcount' => { 279 => 0x103f },
	'fifoenonepixeldelay' => { 131 => 0x1901 },
	'filecreatedate' => { 114 => 'FileCreateDate' },
	'filedatarate' => { 466 => 'fileDataRate' },
	'fileformat' => { 89 => 0x0, 126 => 0x14, 368 => [0x22,0x26], 388 => 0xb000 },
	'filegroupid' => { 114 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 298 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 114 => 'FileModifyDate' },
	'filename' => { 114 => 'FileName' },
	'filenameasdelivered' => { 284 => 'FileNameAsDelivered' },
	'filenumber' => { 54 => 0x1, 60 => 0x8, 91 => 0x1817, 108 => 'FileNumber', 197 => 0x4 },
	'filenumbermemory' => { 171 => 0x1a },
	'filenumbersequence' => { 257 => '12.2', 262 => '3.1', 263 => '4.1', 264 => '4.1', 266 => '11.1', 267 => '4.3', 272 => '5.2' },
	'filepermissions' => { 114 => 'FilePermissions' },
	'filesource' => { 113 => 0xa300, 121 => 0x8000, 446 => 'FileSource' },
	'fileuserid' => { 114 => 'FileUserID' },
	'fileversion' => { 126 => 0x16 },
	'fillflashautoreduction' => { 76 => 0xe, 77 => 0xe, 84 => 0xa },
	'filllight' => { 442 => 'FillLight' },
	'fillorder' => { 113 => 0x10a },
	'filmgraineffect' => { 274 => 0x538 },
	'filmmode' => { 121 => 0x1401, 294 => 0x412, 297 => 0x42 },
	'filmtype' => { 218 => 0x2 },
	'filtereffect' => { 54 => 0xe, 213 => 0x37, 214 => 0x3f },
	'filtereffectauto' => { 67 => 0xa0 },
	'filtereffectfaithful' => { 66 => 0x70, 67 => 0x70 },
	'filtereffectlandscape' => { 66 => 0x40, 67 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 66 => 0x88, 67 => 0x88 },
	'filtereffectneutral' => { 66 => 0x58, 67 => 0x58 },
	'filtereffectportrait' => { 66 => 0x28, 67 => 0x28 },
	'filtereffectstandard' => { 66 => 0x10, 67 => 0x10 },
	'filtereffectuserdef1' => { 66 => 0xa0, 67 => 0xb8 },
	'filtereffectuserdef2' => { 66 => 0xb8, 67 => 0xd0 },
	'filtereffectuserdef3' => { 66 => 0xd0, 67 => 0xe8 },
	'finderdisplayduringexposure' => { 77 => 0x1 },
	'finesharpness' => { 332 => 0x70 },
	'finetuneoptcenterweighted' => { 257 => '7.2', 258 => '9.1', 260 => '9.1', 261 => '9.1', 265 => '8.1', 270 => '9.1', 271 => '9.1', 272 => '9.1' },
	'finetuneopthighlightweighted' => { 260 => '46.1', 261 => '46.1', 270 => '46.1', 271 => '46.1' },
	'finetuneoptmatrixmetering' => { 257 => '8.1', 258 => '8.2', 260 => '8.2', 261 => '8.2', 265 => '7.2', 266 => '6.1', 270 => '8.2', 271 => '8.2', 272 => '8.2' },
	'finetuneoptspotmetering' => { 257 => '8.2', 258 => '9.2', 260 => '9.2', 261 => '9.2', 265 => '8.2', 266 => '6.2', 270 => '9.2', 271 => '9.2', 272 => '9.2' },
	'finishexposure' => { 131 => 0xdbd },
	'finishfiletype' => { 131 => 0xdb8 },
	'finishlook' => { 131 => 0xdbc },
	'finishnoise' => { 131 => 0xdba },
	'finishresolution' => { 131 => 0xdb9 },
	'finishsharpening' => { 131 => 0xdbb },
	'firmware' => { 279 => 0x405, 368 => [0x17,0x3b,0x57], 438 => 'Firmware' },
	'firmwaredate' => { 106 => 0x15, 107 => 0x2001, 353 => 0x4 },
	'firmwareid' => { 178 => 0x0 },
	'firmwarename' => { 365 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 60 => 0x1e, 356 => 0x0 },
	'firmwarerevision2' => { 356 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 131 => [0x415,0xce5], 145 => 0x57, 147 => 'FirmwareVersion', 295 => 0x320, 297 => 0x2, 299 => 0x3109, 332 => 0x230, 354 => 0x18, 358 => 0x2 },
	'firmwareversions' => { 341 => 0x301 },
	'firstphotodate' => { 429 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 284 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 125 => 0x16, 436 => 'FixtureIdentifier' },
	'flash' => { 108 => 'Flash', 113 => 0x9209, 172 => 0x1f, 173 => 0x15, 446 => 'Flash' },
	'flashaction' => { 376 => 0x3e, 377 => 0x3e, 388 => 0x2017, 393 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 376 => 0x4c, 377 => 0x4c, 393 => 0x77 },
	'flashactionexternal' => { 393 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 41 => 0x249 },
	'flashbias' => { 297 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 78 => 0x70e },
	'flashchargelevel' => { 279 => 0x1010 },
	'flashcolorfilter' => { 200 => 0x10, 201 => 0x10 },
	'flashcommandermode' => { 198 => '9.1', 199 => '9.1', 200 => '9.1', 201 => '9.1' },
	'flashcompensation' => { 131 => 0x3f3, 198 => 0xa, 199 => 0xa, 200 => 0xa, 201 => 0x27, 202 => 0xa, 438 => 'FlashCompensation' },
	'flashcontrol' => { 376 => 0x23, 377 => 0x1f, 378 => 0x21 },
	'flashcontrolbuilt-in' => { 266 => '16.1', 267 => '23.1', 269 => '23.1', 270 => '24.1' },
	'flashcontrolmode' => { 198 => '9.2', 199 => '9.2', 200 => '9.2', 201 => '9.2', 274 => 0x404 },
	'flashcurtain' => { 297 => 0x48 },
	'flashdefault' => { 174 => 0x42 },
	'flashdevice' => { 279 => 0x1005 },
	'flashdistance' => { 107 => 0x2034 },
	'flashenergy' => { 113 => 0xa20b, 446 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 211 => 0x18 },
	'flashexposurecomp' => { 72 => 0xf, 121 => 0x1011, 150 => 'ExposureComp', 171 => 0x23, 176 => 0x104, 177 => 0x49c1, 211 => 0x12, 274 => 0x401, 279 => 0x1023, 332 => 0x4d, 358 => 0x100b, 368 => [0x3a,0x56], 388 => 0x104 },
	'flashexposurecomp2' => { 236 => 0x4d2 },
	'flashexposurecomp3' => { 200 => 0x1d },
	'flashexposurecomp4' => { 200 => 0x27 },
	'flashexposurecomparea' => { 258 => '38.4', 260 => '38.4', 261 => '38.4', 270 => '38.4', 271 => '38.4' },
	'flashexposurecompset' => { 174 => 0x10, 305 => 0xe, 376 => 0x14, 377 => 0x12, 378 => 0x23, 393 => 0x1f },
	'flashexposurecompset2' => { 393 => [0x26,0x2c] },
	'flashexposureindicator' => { 174 => 0x54 },
	'flashexposureindicatorlast' => { 174 => 0x56 },
	'flashexposureindicatornext' => { 174 => 0x55 },
	'flashexposurelock' => { 54 => 0x19 },
	'flashfired' => { 133 => 0x5d, 150 => 'Fired', 171 => 0x14, 235 => '590.3', 446 => [\'Flash','FlashFired'] },
	'flashfiring' => { 78 => 0x306, 79 => 0x6, 80 => 0x7, 83 => 0x7 },
	'flashfirmwareversion' => { 275 => 0x1002 },
	'flashfocallength' => { 198 => 0xb, 199 => 0xc, 200 => 0xc, 201 => 0xc, 202 => 0xc },
	'flashfunction' => { 177 => 0x31, 446 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 198 => 0xe, 199 => 0xf, 200 => 0xf, 201 => 0xf, 202 => 0xf },
	'flashgroupacompensation' => { 198 => 0x11, 199 => 0x12, 200 => 0x13, 201 => 0x28, 202 => 0x28 },
	'flashgroupacontrolmode' => { 198 => 0xf, 199 => '16.1', 200 => '17.1', 201 => '17.1', 202 => '17.1' },
	'flashgroupaoutput' => { 198 => 0x11, 199 => 0x12, 200 => 0x13, 201 => 0x28, 202 => 0x28 },
	'flashgroupbcompensation' => { 198 => 0x12, 199 => 0x13, 200 => 0x14, 201 => 0x29, 202 => 0x29 },
	'flashgroupbcontrolmode' => { 198 => 0x10, 199 => '17.1', 200 => '18.1', 201 => '18.1', 202 => '18.1' },
	'flashgroupboutput' => { 198 => 0x12, 199 => 0x13, 200 => 0x14, 201 => 0x29, 202 => 0x29 },
	'flashgroupccompensation' => { 199 => 0x14, 200 => 0x15, 201 => 0x2a, 202 => 0x2a },
	'flashgroupccontrolmode' => { 199 => '17.2', 200 => '18.2', 201 => '18.2', 202 => '18.2' },
	'flashgroupcoutput' => { 199 => 0x14, 200 => 0x15, 201 => 0x2a, 202 => 0x2a },
	'flashguidenumber' => { 72 => 0xd, 88 => 0x0, 150 => 'GuideNumber' },
	'flashintensity' => { 106 => [0x19,0x5], 274 => 0x405 },
	'flashlevel' => { 259 => 0x9, 388 => 0xb048 },
	'flashmake' => { 150 => 'Make' },
	'flashmanufacturer' => { 169 => 'FlashManufacturer' },
	'flashmetering' => { 171 => 0x3f, 174 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 332 => 0x20a },
	'flashmode' => { 106 => 0x4, 131 => 0x3f2, 133 => 0x5c, 150 => 'Mode', 171 => 0x2, 172 => 0x20, 173 => 0x16, 174 => 0xf, 211 => 0x87, 274 => 0x400, 279 => 0x1004, 332 => 0xc, 339 => 0x4, 357 => 0x20, 358 => 0x100a, 367 => 0x225, 376 => 0x13, 377 => 0x7f, 378 => 0x20, 393 => 0x10, 396 => 0x1138, 397 => 0x1138, 398 => 0x1114, 399 => 0x1190, 400 => 0x116c, 401 => 0x1024, 402 => 0x21c, 403 => 0x21c, 404 => 0x211, 446 => [\'Flash','FlashMode'] },
	'flashmodel' => { 150 => 'Model', 169 => 'FlashModel', 275 => 0x1001 },
	'flashoptions' => { 313 => 0x2 },
	'flashoptions2' => { 313 => 0x10 },
	'flashoutput' => { 41 => 0x248, 72 => 0x21, 198 => 0xa, 199 => 0xa, 200 => 0xa, 201 => 0x27 },
	'flashpixversion' => { 113 => 0xa000, 446 => 'FlashpixVersion' },
	'flashredeyemode' => { 446 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 274 => 0x403 },
	'flashreturn' => { 446 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 150 => 'SerialNumber', 275 => 0x1003 },
	'flashsetting' => { 211 => 0x8 },
	'flashshutterspeed' => { 257 => '20.2', 258 => '23.2', 260 => '23.2', 261 => '23.2', 266 => '15.2', 267 => '22.2', 268 => '7.2', 269 => '22.2', 270 => '23.2', 271 => '23.2', 272 => '23.1' },
	'flashsource' => { 198 => 0x4, 199 => 0x4, 200 => 0x4, 201 => 0x4, 202 => 0x4 },
	'flashstatus' => { 320 => 0x0, 393 => [0x82,0x86], 406 => 0x31, 407 => 0x39 },
	'flashstatusbuilt-in' => { 378 => [0x87,0x287] },
	'flashstatusexternal' => { 378 => [0x88,0x288] },
	'flashsyncspeed' => { 257 => '20.1', 258 => '23.1', 260 => '23.1', 261 => '23.1', 266 => '15.1', 267 => '22.1', 269 => '22.1', 270 => '23.1', 271 => '23.1' },
	'flashsyncspeedav' => { 76 => 0x3, 78 => 0x10f, 79 => 0x2, 80 => 0x3, 81 => 0x2, 82 => 0x2, 83 => 0x3, 84 => 0x6 },
	'flashthreshold' => { 88 => 0x1 },
	'flashtype' => { 150 => 'Type', 174 => 0x59, 211 => 0x9, 275 => 0x1000 },
	'flashwarning' => { 267 => '30.1', 268 => '7.1', 272 => '31.1', 297 => 0x62 },
	'flexiblespotposition' => { 388 => 0x201d },
	'flickerreduce' => { 367 => 0x218 },
	'flickerreduction' => { 121 => 0x1446, 229 => 0xe84 },
	'flickerreductionindicator' => { 229 => 0x5e2 },
	'flightpitchdegree' => { 110 => 'FlightPitchDegree' },
	'flightrolldegree' => { 110 => 'FlightRollDegree' },
	'flightyawdegree' => { 110 => 'FlightYawDegree' },
	'fliphorizontal' => { 250 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 72 => 0x15, 113 => 0x829d, 130 => 0xfd04, 133 => 0x1e, 135 => 0xfa23, 137 => 0xf103, 140 => 0x13, 142 => 0x3c, 145 => 0xc, 154 => 'FNumber', 171 => 0xa, 172 => 0x36, 173 => 0x47, 174 => 0x9, 177 => 0x49c7, 332 => 0x13, 365 => 0xa019, 368 => [0x31,0x49], 376 => 0x1, 377 => 0x1, 393 => [0x20,0x22,0x26], 446 => 'FNumber' },
	'focaldistance' => { 427 => 'FocalDistance' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 56 => 0x1, 107 => 0x1d, 113 => 0x920a, 140 => 0x1d, 154 => 'FocalLength', 171 => 0x12, 207 => 0xa, 208 => 0xb, 291 => 0x1, 332 => 0x1d, 341 => 0x403, 358 => 0x1500, 375 => 0xe, 400 => 0x1278, 401 => 0x1134, 402 => 0x32c, 403 => 0x32c, 404 => 0x30a, 446 => 'FocalLength' },
	'focallength2' => { 393 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 113 => 0xa405, 365 => 0xa01a, 446 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 375 => 0x10 },
	'focalplaneafpointarea' => { 405 => 0x2 },
	'focalplaneafpointlocation1' => { 405 => 0x6 },
	'focalplaneafpointlocation10' => { 405 => 0x2a },
	'focalplaneafpointlocation11' => { 405 => 0x2e },
	'focalplaneafpointlocation12' => { 405 => 0x32 },
	'focalplaneafpointlocation13' => { 405 => 0x36 },
	'focalplaneafpointlocation14' => { 405 => 0x3a },
	'focalplaneafpointlocation15' => { 405 => 0x3e },
	'focalplaneafpointlocation2' => { 405 => 0xa },
	'focalplaneafpointlocation3' => { 405 => 0xe },
	'focalplaneafpointlocation4' => { 405 => 0x12 },
	'focalplaneafpointlocation5' => { 405 => 0x16 },
	'focalplaneafpointlocation6' => { 405 => 0x1a },
	'focalplaneafpointlocation7' => { 405 => 0x1e },
	'focalplaneafpointlocation8' => { 405 => 0x22 },
	'focalplaneafpointlocation9' => { 405 => 0x26 },
	'focalplaneafpointsused' => { 405 => 0x1 },
	'focalplanediagonal' => { 275 => 0x103, 279 => 0x205 },
	'focalplaneresolutionunit' => { 113 => 0xa210, 446 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 113 => 0xa20e, 446 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 56 => 0x2 },
	'focalplanexunknown' => { 56 => 0x2 },
	'focalplaneyresolution' => { 113 => 0xa20f, 446 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 56 => 0x3 },
	'focalplaneyunknown' => { 56 => 0x3 },
	'focalpointx' => { 427 => 'FocalPointX' },
	'focalpointy' => { 427 => 'FocalPointY' },
	'focaltype' => { 9 => 0x2d, 56 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 240 => 0x8 },
	'focusarea' => { 171 => 0x31 },
	'focusareaselection' => { 268 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 78 => 0x515 },
	'focusdistance' => { 154 => 'FocusDistance', 171 => 0x13, 177 => 0x49bb, 207 => 0x9, 208 => 0xa, 277 => 0x305, 291 => 0x0, 295 => 0x304, 296 => 0x304 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 54 => 0x15, 72 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 54 => 0x14, 72 => 0x13 },
	'focusholdbutton' => { 174 => 0x44 },
	'focusinfoversion' => { 277 => 0x0 },
	'focusingscreen' => { 77 => 0x0, 78 => 0x80b, 83 => 0x0 },
	'focuslocation' => { 388 => 0x2027 },
	'focuslocked' => { 170 => 0x14 },
	'focusmode' => { 33 => 0x7, 106 => 0x3, 107 => [0x3003,0xd], 121 => 0x1021, 131 => 0x3f5, 133 => 0x38, 147 => 'FocusMode', 171 => 0x30, 173 => 0xe, 174 => 0xc, 211 => 0x7, 274 => 0x301, 279 => 0x100b, 297 => 0x7, 332 => 0xd, 339 => 0x3, 358 => 0x1006, 369 => [0xb,0x5], 375 => [0x15,0x1d], 376 => 0x4d, 377 => 0x4d, 388 => [0xb042,0xb04e,0x201b], 393 => 0x13, 411 => 0x16 },
	'focusmode2' => { 120 => '0.1', 313 => '3.1', 393 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 259 => '10.1', 373 => 0x14, 374 => 0x15, 376 => 0x10, 377 => 0xf, 378 => 0x6 },
	'focusmodeswitch' => { 174 => 0x58, 376 => 0x2e },
	'focuspixel' => { 121 => 0x1023 },
	'focuspointwrap' => { 257 => '2.2', 258 => '2.2', 260 => '2.1', 261 => '2.1', 265 => '1.1', 266 => '2.2', 267 => '1.1', 270 => '2.2', 271 => '2.1', 272 => '2.5' },
	'focusposition' => { 207 => 0x8, 208 => 0x8, 332 => 0x10, 387 => 0x9bb },
	'focusposition2' => { 393 => [0x29,0x2b,0x2f], 411 => 0x2d, 414 => 0x20 },
	'focusprocess' => { 274 => 0x302 },
	'focusrange' => { 33 => 0x12, 279 => 0x100a },
	'focusrangeindex' => { 323 => '3.1' },
	'focusringrotation' => { 78 => 0x713 },
	'focussetting' => { 368 => 0x6 },
	'focusstatus' => { 375 => 0x19, 376 => 0x53, 377 => 0x53 },
	'focusstepcount' => { 277 => 0x301, 279 => 0x100e },
	'focusstepinfinity' => { 277 => 0x303, 279 => 0x103b },
	'focusstepnear' => { 277 => 0x304, 279 => 0x103c },
	'focustrackinglockon' => { 257 => ['1.5','4.1'], 258 => '1.4', 265 => '0.4', 266 => '3.1', 267 => '0.4', 270 => '1.4' },
	'focuswarning' => { 121 => 0x1301 },
	'foldername' => { 171 => 0x27 },
	'foldernumber' => { 376 => 0x9a, 378 => [0x402,0x114,0x316] },
	'fontcomposite' => { 471 => [\'Fonts','FontsComposite'] },
	'fontface' => { 471 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 471 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 471 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 471 => [\'Fonts','FontsFontName'] },
	'fonts' => { 471 => 'Fonts' },
	'fonttype' => { 471 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 471 => [\'Fonts','FontsVersionString'] },
	'for' => { 348 => 'For' },
	'forcewrite' => { 114 => 'ForceWrite' },
	'format' => { 426 => 'Format', 443 => 'format', 464 => 'Format' },
	'forwardlock' => { 461 => 'forwardlock' },
	'forwardmatrix1' => { 113 => 0xc714 },
	'forwardmatrix2' => { 113 => 0xc715 },
	'fossilspecimen' => { 112 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 112 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 63 => [0x2,0x4] },
	'frameheight' => { 121 => 0x3822 },
	'framenum' => { 343 => 0xd7 },
	'framenumber' => { 121 => 0x8003, 177 => 0x3c, 332 => 0x29 },
	'framerate' => { 63 => [0x1,0x6], 113 => 0xc764, 121 => 0x3820 },
	'framewidth' => { 121 => 0x3821 },
	'framing' => { 455 => 'framing' },
	'freebytes' => { 91 => 0x1 },
	'freememorycardimages' => { 172 => [0x37,0x54], 173 => [0x2d,0x4a], 174 => 0x32 },
	'fujiflashmode' => { 121 => 0x1010 },
	'fullimagesize' => { 388 => 0xb02b },
	'fullpanoheightpixels' => { 429 => 'FullPanoHeightPixels', 430 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 429 => 'FullPanoWidthPixels', 430 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 358 => 0x100d },
	'fullsizeimage' => { 153 => 'data' },
	'fullsizeimagename' => { 153 => '1Name' },
	'fullsizeimagetype' => { 153 => '0Type' },
	'func1button' => { 260 => '14.1', 261 => '14.1', 271 => '14.1' },
	'func1buttonplusdials' => { 260 => '42.1', 261 => '42.1', 271 => '42.1' },
	'func2button' => { 260 => '80.1', 261 => '80.1', 271 => '80.1' },
	'func2buttonplusdials' => { 260 => '81.1' },
	'func3button' => { 260 => '83.1' },
	'funcbutton' => { 257 => ['14.1','15.1'], 258 => '14.1', 266 => '28.1', 267 => '13.1', 270 => '14.1', 272 => '14.1' },
	'funcbuttonplusdials' => { 257 => ['14.2','15.2'], 258 => '14.2', 266 => '31.1', 270 => '42.1' },
	'functionbutton' => { 264 => '13.1', 268 => '5.2' },
	'gainbase' => { 278 => 0x610 },
	'gaincontrol' => { 113 => 0xa407, 446 => 'GainControl' },
	'gamma' => { 113 => 0xa500, 131 => 0x8fe, 302 => 0x11c, 447 => 'Gamma' },
	'gammablackpoint' => { 99 => 0xc },
	'gammacolortone' => { 99 => 0x3 },
	'gammacompensatedvalue' => { 127 => 0x91 },
	'gammacontrast' => { 99 => 0x2 },
	'gammacurveoutputrange' => { 99 => 0xf },
	'gammahighlight' => { 99 => 0xa },
	'gammalinear' => { 97 => 0x20200 },
	'gammamidpoint' => { 99 => 0xe },
	'gammasaturation' => { 99 => 0x4 },
	'gammashadow' => { 99 => 0x9 },
	'gammasharpnessstrength' => { 99 => 0x8 },
	'gammaunsharpmaskfineness' => { 99 => 0x6 },
	'gammaunsharpmaskstrength' => { 99 => 0x5 },
	'gammaunsharpmaskthreshold' => { 99 => 0x7 },
	'gammawhitepoint' => { 99 => 0xd },
	'geimagesize' => { 121 => 0x1304 },
	'gemake' => { 123 => 0x300 },
	'gemodel' => { 123 => 0x207 },
	'genre' => { 452 => 'Genre', 456 => 'genre', 466 => 'genre' },
	'genrecvid' => { 452 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 452 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 452 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 452 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 457 => 'geography' },
	'geologicalcontext' => { 112 => 'GeologicalContext' },
	'geologicalcontextbed' => { 112 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 112 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 112 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 112 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 112 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 114 => 'Geosync' },
	'geotag' => { 114 => 'Geotag' },
	'geotiffasciiparams' => { 113 => 0x87b1 },
	'geotiffdirectory' => { 113 => 0x87af },
	'geotiffdoubleparams' => { 113 => 0x87b0 },
	'geotime' => { 114 => 'Geotime' },
	'giftftppriority' => { 431 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 110 => 'GimbalPitchDegree' },
	'gimbalrolldegree' => { 110 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 110 => 'GimbalYawDegree' },
	'globalaltitude' => { 346 => 0x419 },
	'globalangle' => { 346 => 0x40d },
	'good' => { 466 => 'good' },
	'googleplusuploadcode' => { 113 => 0x9009 },
	'gpsaltitude' => { 124 => 0x6, 151 => 'Altitude', 446 => 'GPSAltitude' },
	'gpsaltituderef' => { 124 => 0x5, 446 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 124 => 0x1c, 446 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 124 => 0x1d },
	'gpsdatetime' => { 151 => 'DateTime', 446 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 124 => 0x18, 151 => 'Bearing', 446 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 124 => 0x17, 446 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 124 => 0x1a, 151 => 'Distance', 446 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 124 => 0x19, 446 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 124 => 0x14, 446 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 124 => 0x13 },
	'gpsdestlongitude' => { 124 => 0x16, 446 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 124 => 0x15 },
	'gpsdifferential' => { 124 => 0x1e, 151 => 'Differential', 446 => 'GPSDifferential' },
	'gpsdop' => { 124 => 0xb, 446 => 'GPSDOP' },
	'gpshpositioningerror' => { 124 => 0x1f, 446 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 124 => 0x11, 446 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 124 => 0x10, 446 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 124 => 0x2, 151 => 'Latitude', 446 => 'GPSLatitude' },
	'gpslatituderef' => { 124 => 0x1 },
	'gpslongitude' => { 124 => 0x4, 151 => 'Longitude', 446 => 'GPSLongitude' },
	'gpslongituderef' => { 124 => 0x3 },
	'gpsmapdatum' => { 124 => 0x12, 151 => 'Datum', 446 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 124 => 0xa, 151 => 'MeasureMode', 446 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 124 => 0x1b, 446 => 'GPSProcessingMethod' },
	'gpssatellites' => { 124 => 0x8, 151 => 'Satellites', 446 => 'GPSSatellites' },
	'gpsspeed' => { 124 => 0xd, 151 => 'Speed', 446 => 'GPSSpeed' },
	'gpsspeedref' => { 124 => 0xc, 446 => 'GPSSpeedRef' },
	'gpsstatus' => { 124 => 0x9, 446 => 'GPSStatus' },
	'gpsstring' => { 131 => 0x402 },
	'gpstimestamp' => { 124 => 0x7 },
	'gpstrack' => { 124 => 0xf, 151 => 'Heading', 446 => 'GPSTrack' },
	'gpstrackref' => { 124 => 0xe, 446 => 'GPSTrackRef' },
	'gpsversionid' => { 124 => 0x0, 446 => 'GPSVersionID' },
	'gradation' => { 274 => 0x50f },
	'gradientbasedcorractive' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 442 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 442 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 442 => 'GrainAmount' },
	'graineffect' => { 121 => 0x1047 },
	'grainfrequency' => { 442 => 'GrainFrequency' },
	'grainsize' => { 442 => 'GrainSize' },
	'graymixeraqua' => { 442 => 'GrayMixerAqua' },
	'graymixerblue' => { 442 => 'GrayMixerBlue' },
	'graymixergreen' => { 442 => 'GrayMixerGreen' },
	'graymixermagenta' => { 442 => 'GrayMixerMagenta' },
	'graymixerorange' => { 442 => 'GrayMixerOrange' },
	'graymixerpurple' => { 442 => 'GrayMixerPurple' },
	'graymixerred' => { 442 => 'GrayMixerRed' },
	'graymixeryellow' => { 442 => 'GrayMixerYellow' },
	'graypoint' => { 421 => 0x8021 },
	'grayresponseunit' => { 113 => 0x122 },
	'greencurvelimits' => { 102 => 0x1c4 },
	'greencurvepoints' => { 101 => 0x53, 102 => 0x19a },
	'greenhsl' => { 97 => 0x20913 },
	'greenhue' => { 442 => 'GreenHue' },
	'greensaturation' => { 442 => 'GreenSaturation' },
	'griddisplay' => { 257 => '13.3', 258 => '4.3', 260 => '4.2', 261 => '4.2', 262 => '2.2', 266 => '10.5', 267 => '3.4', 268 => '6.1', 270 => '4.4', 271 => '4.2', 272 => '4.2' },
	'gripbatteryadload' => { 311 => 0x5 },
	'gripbatteryadnoload' => { 311 => 0x4 },
	'gripbatterystate' => { 311 => '1.2' },
	'groupareaafillumination' => { 258 => '46.4', 261 => '47.4', 270 => '47.4' },
	'h2resetblackpixels' => { 131 => 0x18a6 },
	'h3resetblackcolumns' => { 131 => 0x18ce },
	'h3resetblackpixels' => { 131 => 0x18b0 },
	'halftonehints' => { 113 => 0x141 },
	'hardlink' => { 114 => 'HardLink' },
	'hasalternative' => { 456 => 'hasAlternative' },
	'hascorrection' => { 456 => 'hasCorrection' },
	'hascorrectiona-lang' => { 456 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 456 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 456 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 442 => 'HasCrop' },
	'hasextendedxmp' => { 468 => 'HasExtendedXMP' },
	'hassettings' => { 442 => 'HasSettings' },
	'hastranslation' => { 456 => 'hasTranslation' },
	'hasvisibleoverprint' => { 471 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 471 => 'HasVisibleTransparency' },
	'hdr' => { 57 => 0x1, 204 => 0x4, 297 => 0x9e, 332 => 0x85, 388 => 0x200a },
	'hdreffect' => { 57 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 204 => 0x0 },
	'hdrlevel' => { 204 => 0x5, 378 => 0x2e, 393 => 0x17 },
	'hdrlevel2' => { 204 => 0x7 },
	'hdrsetting' => { 378 => 0x2d, 393 => 0x16, 396 => 0x1148, 397 => 0x1148, 398 => 0x1124, 399 => 0x11a0, 400 => 0x117c, 401 => 0x1034, 402 => 0x22c, 403 => 0x22c, 404 => 0x21f },
	'hdrshot' => { 297 => 0x76 },
	'hdrsmoothing' => { 204 => 0x6 },
	'headline' => { 125 => 0x69, 452 => 'Headline', 454 => 'Headline' },
	'hierarchicalkeywords' => { 162 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 162 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 162 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 162 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 162 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 162 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 433 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 302 => 0x1a },
	'highisomultipliergreen' => { 302 => 0x19 },
	'highisomultiplierred' => { 302 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 59 => 0x5, 78 => 0x202, 211 => 0xb1, 332 => 0x71, 376 => 0x2c, 377 => 0x26, 378 => 0x26, 388 => 0x2009, 393 => 0x12, 417 => 0x42 },
	'highisonoisereduction2' => { 388 => 0xb050 },
	'highlight' => { 368 => 0xf },
	'highlightadj' => { 97 => 0x2030c },
	'highlightcolordistortreduct' => { 421 => 0x8026 },
	'highlightlinearitylimit' => { 365 => 0xa025 },
	'highlightprotection' => { 249 => 0x6 },
	'highlightrecovery' => { 442 => 'HighlightRecovery' },
	'highlights' => { 435 => 'Highlights' },
	'highlights2012' => { 442 => 'Highlights2012' },
	'highlightsadj' => { 421 => 0x9019 },
	'highlightshadow' => { 297 => 0xad },
	'highlighttone' => { 121 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 59 => 0x3, 78 => 0x203 },
	'highlightwarning' => { 297 => 0x8002 },
	'highlowkeyadj' => { 332 => 0x6c },
	'highspeedsync' => { 174 => 0x5, 376 => 0x2, 377 => 0x2 },
	'histogramxml' => { 250 => 0x83a1a25 },
	'history' => { 454 => 'History', 467 => 'History' },
	'historyaction' => { 467 => [\'History','HistoryAction'] },
	'historychanged' => { 467 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 467 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 467 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 467 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 467 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 131 => 0xc88 },
	'holefilldeltathreshold' => { 131 => 0xc7e },
	'hometowncity' => { 107 => 0x3006, 332 => 0x23, 338 => 0x2 },
	'hometowncitycode' => { 339 => 0x1000 },
	'hometowndst' => { 332 => 0x25, 338 => '0.2' },
	'hostcomputer' => { 113 => 0x13c },
	'hostsoftwarerendering' => { 131 => 0xce7 },
	'hue' => { 179 => 0x3b, 214 => 0x3d, 332 => 0x67 },
	'hueadj' => { 253 => 0x2f, 421 => 0x8019 },
	'hueadjust' => { 358 => 0x1016 },
	'hueadjustment' => { 172 => 0x4a, 173 => 0x40, 211 => 0x92, 213 => 0x36 },
	'hueadjustmentaqua' => { 442 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 442 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 442 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 442 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 442 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 442 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 442 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 442 => 'HueAdjustmentYellow' },
	'huesetting' => { 282 => 0x1011 },
	'humanobservation' => { 112 => 'HumanObservation' },
	'humanobservationday' => { 112 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 112 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 112 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 112 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 112 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 112 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 112 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 112 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 112 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 112 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 112 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 112 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 112 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 112 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 112 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 112 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 112 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 112 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 112 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 112 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 113 => 0x9401, 447 => 'Humidity' },
	'icc_profile' => { 114 => 'ICC_Profile' },
	'iccprofilename' => { 454 => 'ICCProfile' },
	'idccreativestyle' => { 421 => 0x8000 },
	'idcpreviewlength' => { 421 => 0x202 },
	'idcpreviewstart' => { 421 => 0x201 },
	'identification' => { 112 => 'Identification' },
	'identificationid' => { 112 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 112 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 112 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 112 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 112 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 112 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 443 => 'identifier', 464 => 'Identifier' },
	'ifcameramodel' => { 131 => 0x9c8 },
	'illumination' => { 268 => '0.5', 354 => 0x48 },
	'imageabsolutex' => { 131 => 0x3fe },
	'imageabsolutey' => { 131 => 0x3ff },
	'imageadjustment' => { 211 => 0x80, 240 => 0x5 },
	'imagealterationconstraints' => { 284 => 'ImageAlterationConstraints' },
	'imagearea' => { 223 => 0x10, 226 => 0x10 },
	'imageareaoffset' => { 332 => 0x38 },
	'imageauthentication' => { 211 => 0x20 },
	'imageboundary' => { 211 => 0x16 },
	'imagecount' => { 121 => 0x1438, 211 => 0xa5, 391 => 0x11b, 406 => 0x32, 407 => 0x3a },
	'imagecount2' => { 406 => 0x4c, 407 => [0x52,0x58] },
	'imagecount3' => { 406 => [0x1a0,0x1aa,0x1bd], 407 => [0x19f,0x1cb,0x1cd] },
	'imagecreator' => { 284 => 'ImageCreator' },
	'imagecreatorid' => { 284 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 284 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 284 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 131 => 0x41f },
	'imagecropy' => { 131 => 0x420 },
	'imagedata' => { 428 => 'Data' },
	'imagedatasize' => { 211 => 0xa2 },
	'imagedescription' => { 113 => 0x10e, 462 => 'ImageDescription' },
	'imageduplicationconstraints' => { 284 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 250 => 0xfe443a45 },
	'imageeditcount' => { 332 => 0x41 },
	'imageediting' => { 332 => 0x32 },
	'imageeffects' => { 358 => 0x1010 },
	'imagefileconstraints' => { 284 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 284 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 284 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 121 => 0x1436 },
	'imageheight' => { 113 => 0x101, 178 => 0xc, 341 => 0x10d, 426 => 'ImageHeight', 462 => 'ImageLength' },
	'imagehistory' => { 113 => 0x9213, 445 => 'ImageHistory' },
	'imageidnumber' => { 292 => 0x340 },
	'imagemimetype' => { 428 => 'Mime' },
	'imagenumber' => { 113 => 0x9211, 147 => 'ImageNumber', 172 => 0xae, 173 => 0x5e, 341 => 0x113, 376 => 0x9b, 378 => [0x400,'276.1',0x314], 438 => 'ImageNumber' },
	'imagenumber2' => { 173 => 0x62 },
	'imageoptimization' => { 211 => 0xa9 },
	'imageorientation' => { 125 => 0x83 },
	'imageprocessing' => { 211 => 0x1a },
	'imageprocessingfiledatecreated' => { 131 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 131 => 0xc80 },
	'imageprocessingversion' => { 278 => 0x0 },
	'imagequality' => { 147 => 'ImageQuality', 225 => '723.2', 226 => '732.2', 235 => '708.1', 297 => 0x1 },
	'imagequality2' => { 274 => 0x603 },
	'imagerank' => { 431 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 131 => 0x600 },
	'imagerboardversion' => { 131 => 0x439 },
	'imagercols' => { 131 => 0x17d4 },
	'imageref' => { 450 => 'ImageRef' },
	'imageresolution' => { 131 => 0x944 },
	'imageresolutionjpg' => { 131 => 0x945 },
	'imagereview' => { 259 => '0.4', 268 => '0.4' },
	'imagereviewmonitorofftime' => { 258 => '21.1', 260 => '21.1', 261 => '21.1', 265 => '20.1', 270 => '21.1', 271 => '21.1' },
	'imagereviewtime' => { 257 => '25.1', 259 => '2.1', 262 => '19.1', 263 => '20.1', 264 => '20.1', 266 => '9.2', 267 => '20.1', 272 => '21.2' },
	'imagerfiledatecreated' => { 131 => 0x9c5 },
	'imagerfileproductionlevel' => { 131 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 131 => 0x9c7 },
	'imagerpowerondelaymsec' => { 131 => 0x5fd },
	'imagerrows' => { 131 => 0x17de },
	'imagesegmentlines' => { 131 => 0x184d },
	'imagesegmentstartline' => { 131 => 0x184c },
	'imagesize' => { 153 => 'ImageSize' },
	'imagesizerestriction' => { 459 => 'imageSizeRestriction' },
	'imagesourcedata' => { 113 => 0x935c },
	'imagespace' => { 131 => 0x909 },
	'imagestabilization' => { 33 => 0x22, 107 => 0x3020, 121 => 0x1422, 147 => 'ImageStabilization', 172 => 0xbd, 173 => 0x71, 174 => 0x57, 175 => 0x0, 176 => [0x18,0x107,0x113], 177 => 0x49c2, 211 => 0xac, 274 => 0x604, 277 => 0x1600, 297 => 0x1a, 381 => 0x12, 382 => 0x11, 388 => 0xb026 },
	'imagestabilization2' => { 380 => 0xa },
	'imagestabilizationsetting' => { 177 => 0x14, 376 => 0x3d, 377 => 0x3d, 387 => 0x14 },
	'imagestyle' => { 376 => 0x2d, 377 => 0x27 },
	'imagesupplier' => { 284 => 'ImageSupplier' },
	'imagesupplierid' => { 284 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 284 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 284 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 115 => 0x1 },
	'imagetemperaturemin' => { 115 => 0x2 },
	'imagetone' => { 332 => 0x4f },
	'imagetype' => { 125 => 0x82, 284 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 60 => 0x28, 113 => 0xa420, 445 => 'ImageUniqueID', 446 => 'ImageUniqueID' },
	'imagewidth' => { 113 => 0x100, 178 => 0xe, 341 => 0x10c, 426 => 'ImageWidth', 462 => 'ImageWidth' },
	'inclinationangle' => { 421 => 0x900f },
	'inclinationcorrection' => { 421 => 0x900e },
	'incrementaltemperature' => { 442 => 'IncrementalTemperature' },
	'incrementaltint' => { 442 => 'IncrementalTint' },
	'industry' => { 456 => 'industry', 457 => 'industry' },
	'infobuttonwhenshooting' => { 78 => 0x409 },
	'infraredilluminator' => { 353 => 0x28 },
	'ingredientexclusion' => { 458 => 'ingredientExclusion' },
	'ingredients' => { 467 => 'Ingredients' },
	'ingredientsalternatepaths' => { 467 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 467 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 467 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 467 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 467 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 467 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 467 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 467 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 467 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 467 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 467 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 467 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 467 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 467 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 467 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 467 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 467 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 467 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 467 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 467 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 467 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 467 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 467 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 78 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 429 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 429 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 429 => 'InitialViewHeadingDegrees', 430 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 429 => 'InitialViewPitchDegrees', 430 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 429 => 'InitialViewRollDegrees', 430 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 257 => '4.4' },
	'initialzoomsetting' => { 257 => '9.3', 266 => '27.3' },
	'inkset' => { 113 => 0x14c },
	'inputprofile' => { 131 => 0x1389 },
	'instanceid' => { 467 => 'InstanceID' },
	'instantplaybacksetup' => { 174 => 0x3e },
	'instantplaybacktime' => { 174 => 0x3d },
	'instructions' => { 454 => 'Instructions' },
	'instrument' => { 466 => 'instrument' },
	'integrationtime' => { 131 => 0x423 },
	'intellectualgenre' => { 451 => 'IntellectualGenre' },
	'intelligentauto' => { 388 => 0xb052, 413 => 0xd, 414 => 0xe, 415 => 0xd },
	'intelligentcontrast' => { 49 => 0x4 },
	'intelligentd-range' => { 297 => 0x79 },
	'intelligentexposure' => { 297 => 0x5d },
	'intelligentresolution' => { 297 => 0x70 },
	'interchangecolorspace' => { 127 => 0x40 },
	'internalflash' => { 171 => 0x2b, 257 => '23.1', 259 => '8.1', 262 => '22.1', 264 => '23.1', 268 => '8.1', 272 => '24.1', 277 => 0x1208 },
	'internalflashae1' => { 279 => 0x1021 },
	'internalflashae1_0' => { 279 => 0x101d },
	'internalflashae2' => { 279 => 0x1022 },
	'internalflashae2_0' => { 279 => 0x101e },
	'internalflashmode' => { 320 => 0x1 },
	'internalflashstrength' => { 320 => 0x3 },
	'internalflashtable' => { 279 => 0x1024 },
	'internallensserialnumber' => { 365 => 0xa005 },
	'internalndfilter' => { 297 => 0x9d },
	'internalserialnumber' => { 60 => 0x96, 71 => 0x9, 121 => 0x10, 177 => 0x49dc, 273 => 0x18, 275 => 0x102, 294 => 0x500, 297 => 0x25, 312 => 0x4, 358 => 0x5, 406 => [0x7c,0xf0], 407 => 0x88 },
	'interopindex' => { 113 => 0x1, 447 => 'InteroperabilityIndex' },
	'interopversion' => { 113 => 0x2 },
	'intervallength' => { 171 => 0x10 },
	'intervalmode' => { 171 => 0x26 },
	'intervalnumber' => { 171 => 0x11 },
	'intervalshooting' => { 332 => 0x92 },
	'introtime' => { 466 => 'introTime' },
	'introtimescale' => { 466 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 466 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 131 => 0xdae },
	'ipfcameramodel' => { 131 => 0xe4d },
	'iptc' => { 114 => 'IPTC' },
	'iptc-naa' => { 113 => 0x83bb, 302 => 0x83bb },
	'iptcbitspersample' => { 127 => 0x56 },
	'iptcdigest' => { 346 => 0x425 },
	'iptcimageheight' => { 127 => 0x1e },
	'iptcimagerotation' => { 127 => 0x66 },
	'iptcimagewidth' => { 127 => 0x14 },
	'iptclastedited' => { 452 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 127 => 0xa },
	'iptcpixelheight' => { 127 => 0x32 },
	'iptcpixelwidth' => { 127 => 0x28 },
	'isalternativeof' => { 456 => 'isAlternativeOf' },
	'isbn' => { 456 => 'isbn' },
	'iscorrectionof' => { 456 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 103 => 0x3 },
	'ismergedhdr' => { 438 => 'IsMergedHDR' },
	'ismergedpanorama' => { 438 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 106 => 0x14, 107 => [0x3014,0x14], 113 => 0x8827, 130 => 0xfd06, 131 => 0x1784, 133 => 0x60, 135 => [0xfa2e,0xfa46], 136 => [0x27,0x28], 137 => 0xf105, 140 => 0x14, 142 => 0x4e, 145 => 0x34, 147 => 'ISO', 171 => 0x8, 177 => 0x49ba, 205 => 0x0, 211 => 0x2, 302 => 0x17, 332 => [0x8b,0x14], 339 => 0x14, 341 => 0x105, 365 => 0xa014, 387 => 0x6f, 393 => [0x1f,0x21,0x25], 446 => 'ISOSpeedRatings' },
	'iso2' => { 205 => 0x6, 220 => 0x265, 221 => 0x25c, 222 => 0x265, 223 => 0x221, 224 => 0x25d, 225 => 0x256, 226 => 0x25d, 230 => 0x2b5, 233 => 0x265, 239 => 0x2b5 },
	'isoauto' => { 313 => '14.4' },
	'isoautohilimit' => { 228 => 0x18eb, 229 => 0xe82, 237 => 0x185d },
	'isoautoparameters' => { 332 => 0x7a },
	'isoautoshuttertime' => { 228 => 0x18ea, 229 => 0xe81, 237 => 0x185c },
	'isocalibrationgain' => { 131 => 0x89f },
	'isodisplay' => { 260 => '4.1', 261 => '4.1', 262 => '2.3', 263 => '3.3', 264 => '3.3', 267 => '3.3', 270 => '4.3', 271 => '4.1', 272 => '4.3' },
	'isoexpansion' => { 78 => 0x103, 79 => 0x7, 80 => 0x8, 83 => 0x8, 205 => 0x4 },
	'isoexpansion2' => { 205 => 0xa },
	'isofloor' => { 313 => 0x6 },
	'isoselection' => { 211 => 0xf },
	'isosensitivitystep' => { 265 => '6.2', 267 => '6.2' },
	'isosetting' => { 133 => 0x5e, 147 => 'ISOSetting', 171 => 0x24, 172 => 0x26, 173 => 0x1c, 174 => 0x13, 179 => 0x6, 211 => 0x13, 313 => '17.3', 357 => 0x27, 376 => 0x16, 377 => 0x14, 378 => 0x2, 387 => 0x6d },
	'isospeed' => { 113 => 0x8833, 447 => 'ISOSpeed' },
	'isospeedexpansion' => { 77 => 0x3 },
	'isospeedincrements' => { 78 => 0x102 },
	'isospeedlatitudeyyy' => { 113 => 0x8834, 447 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 113 => 0x8835, 447 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 78 => 0x103 },
	'isostepsize' => { 257 => '6.1', 258 => '7.2', 260 => '7.2', 261 => '7.2', 266 => '4.1', 270 => '7.2', 271 => '7.2' },
	'isovalue' => { 279 => 0x1001 },
	'issn' => { 456 => 'issn' },
	'issueidentifier' => { 456 => 'issueIdentifier' },
	'issuename' => { 456 => 'issueName' },
	'issueteaser' => { 456 => 'issueTeaser' },
	'issuetype' => { 456 => 'issueType' },
	'istranslationof' => { 456 => 'isTranslationOf' },
	'itemsubtype' => { 169 => 'ItemSubType' },
	'jobid' => { 125 => 0xb8 },
	'jobname' => { 448 => 'JobName' },
	'jobref' => { 465 => 'JobRef' },
	'jobrefid' => { 465 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 465 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 465 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 448 => 'JobStatus' },
	'jpeghandling' => { 442 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 297 => 0x43, 299 => 0x3034, 388 => 0xb047 },
	'jpegsize' => { 299 => 0x303a },
	'jpgcompression' => { 229 => 0x7d4 },
	'jpgfromraw' => { 91 => 0x2007, 108 => 'JpgFromRaw', 302 => 0x2e },
	'jpgfromrawlength' => { 113 => [0x117,0x202] },
	'jpgfromrawstart' => { 113 => [0x111,0x201] },
	'jpgrecordedpixels' => { 313 => '14.1' },
	'jurisdiction' => { 439 => 'jurisdiction' },
	'kelvinwb_01' => { 321 => 0x5 },
	'kelvinwb_02' => { 321 => 0x9 },
	'kelvinwb_03' => { 321 => 0xd },
	'kelvinwb_04' => { 321 => 0x11 },
	'kelvinwb_05' => { 321 => 0x15 },
	'kelvinwb_06' => { 321 => 0x19 },
	'kelvinwb_07' => { 321 => 0x1d },
	'kelvinwb_08' => { 321 => 0x21 },
	'kelvinwb_09' => { 321 => 0x25 },
	'kelvinwb_10' => { 321 => 0x29 },
	'kelvinwb_11' => { 321 => 0x2d },
	'kelvinwb_12' => { 321 => 0x31 },
	'kelvinwb_13' => { 321 => 0x35 },
	'kelvinwb_14' => { 321 => 0x39 },
	'kelvinwb_15' => { 321 => 0x3d },
	'kelvinwb_16' => { 321 => 0x41 },
	'kelvinwb_daylight' => { 321 => 0x1 },
	'kerneldenominators' => { 131 => 0x933 },
	'key' => { 466 => 'key' },
	'keystonecompensation' => { 278 => 0x1900 },
	'keystonedirection' => { 278 => 0x1901 },
	'keystonevalue' => { 278 => 0x1906 },
	'keyword' => { 456 => 'keyword' },
	'keywordinfo' => { 162 => 'Keywords' },
	'keywords' => { 125 => 0x19, 148 => 'Keywords', 283 => 'Keywords', 348 => 'Keywords', 436 => 'keywords', 453 => 'Keywords', 464 => 'Keywords' },
	'killdate' => { 456 => 'killDate' },
	'killdatea-platform' => { 456 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 456 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 130 => 0xf908, 133 => 0xe, 135 => [0xfa1e,0xfa52], 141 => 0x70 },
	'kodakimagewidth' => { 130 => 0xf907, 133 => 0xc, 135 => [0xfa1d,0xfa51], 141 => 0x6c },
	'kodakinfotype' => { 130 => 0xfa00 },
	'kodaklook' => { 131 => 0xe4c },
	'kodaklookprofile' => { 131 => 0x138a },
	'kodakmaker' => { 141 => 0x8 },
	'kodakmodel' => { 133 => 0x0, 141 => 0x28 },
	'kodaktag' => { 131 => 0x3ea },
	'kodakversion' => { 131 => 0x0 },
	'label' => { 287 => 'Label', 464 => 'Label' },
	'labelname1' => { 450 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 450 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 297 => 0x6f },
	'landscapeoutputhighlightpoint' => { 103 => 0x26 },
	'landscapeoutputshadowpoint' => { 103 => 0x27 },
	'landscaperawcolortone' => { 103 => 0x1f },
	'landscaperawcontrast' => { 103 => 0x21 },
	'landscaperawhighlight' => { 103 => 0x77 },
	'landscaperawhighlightpoint' => { 103 => 0x24 },
	'landscaperawlinear' => { 103 => 0x22 },
	'landscaperawsaturation' => { 103 => 0x20 },
	'landscaperawshadow' => { 103 => 0x80 },
	'landscaperawshadowpoint' => { 103 => 0x25 },
	'landscaperawsharpness' => { 103 => 0x23 },
	'landscapeunsharpmaskfineness' => { 103 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 103 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 103 => 0xa2 },
	'language' => { 443 => 'language' },
	'languageidentifier' => { 125 => 0x87 },
	'largestvalidinteriorrectheight' => { 429 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 429 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 429 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 429 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 171 => 0x1b },
	'lastkeywordiptc' => { 169 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 169 => 'LastKeywordXMP' },
	'lastphotodate' => { 429 => 'LastPhotoDate' },
	'lasturl' => { 467 => 'LastURL' },
	'lateralchromaticaberration' => { 388 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 438 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 112 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 112 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 112 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 323 => 0x2 },
	'lc10' => { 323 => 0xb },
	'lc11' => { 323 => 0xc },
	'lc12' => { 323 => 0xd },
	'lc14' => { 323 => 0xf },
	'lc15' => { 323 => 0x10 },
	'lc3' => { 323 => 0x4 },
	'lc4' => { 323 => 0x5 },
	'lc5' => { 323 => 0x6 },
	'lc6' => { 323 => 0x7 },
	'lc7' => { 323 => 0x8 },
	'lc8' => { 323 => 0x9 },
	'lcddisplayatpoweron' => { 78 => 0x811, 82 => 0xa },
	'lcddisplayreturntoshoot' => { 83 => 0x12 },
	'lcdillumination' => { 257 => '17.5', 258 => '5.2', 260 => '5.1', 261 => '5.1', 266 => '10.3', 267 => '4.2', 270 => '5.2', 271 => '5.1', 272 => '5.4' },
	'lcdilluminationduringbulb' => { 78 => 0x408 },
	'lcdmatrix' => { 131 => 0xe74 },
	'lcdmatrixchickfix' => { 131 => 0xe75 },
	'lcdmatrixmarvin' => { 131 => 0xe76 },
	'lcdpanels' => { 77 => 0x8 },
	'lcheditor' => { 250 => 0x8ae85e },
	'legacyiptcdigest' => { 454 => 'LegacyIPTCDigest' },
	'legalcode' => { 439 => 'legalcode' },
	'lens' => { 113 => 0xfdea, 211 => 0x84, 438 => 'Lens' },
	'lensafstopbutton' => { 76 => 0x11, 77 => 0x13, 78 => 0x506, 79 => 0x10, 80 => 0x12, 83 => 0x13, 84 => 0x9 },
	'lensaperturerange' => { 368 => [0x30,0x48] },
	'lenscorrectionsettings' => { 445 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 438 => 'LensDistortInfo' },
	'lensdistortionparams' => { 279 => 0x206 },
	'lensdrivenoaf' => { 78 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 378 => 0x3f0, 420 => 0xd },
	'lensfirmware' => { 359 => 0x20, 365 => 0xa004 },
	'lensfirmwareversion' => { 275 => 0x204, 297 => 0x60, 378 => 0x3f3, 420 => 0x14 },
	'lensfocallength' => { 97 => 0xf0512, 323 => 0x9 },
	'lensfocalrange' => { 368 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 258 => '55.1', 260 => '52.1', 261 => '52.1', 270 => '52.1', 271 => '52.1' },
	'lensformat' => { 400 => 0x1891, 402 => 0x18bd, 403 => 0x18ed, 404 => 0x17f1, 406 => 0x106, 407 => 0x106, 416 => 0x603, 417 => 0x5d },
	'lensfstops' => { 206 => 0x7, 207 => 0xc, 208 => 0xd, 211 => 0x8b, 323 => '0.3' },
	'lensid' => { 438 => 'LensID' },
	'lensidnumber' => { 206 => 0x6, 207 => 0xb, 208 => 0xc },
	'lensinfo' => { 113 => 0xa432, 329 => 0x2a, 438 => 'LensInfo', 447 => 'LensSpecification' },
	'lenskind' => { 323 => 0x1 },
	'lensmake' => { 113 => 0xa433, 154 => 'Make', 447 => 'LensMake' },
	'lensmanualdistortionamount' => { 442 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 169 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 368 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 60 => 0x95, 113 => 0xa434, 154 => 'Model', 169 => 'LensModel', 209 => 0x18a, 275 => 0x203, 329 => 0xc, 341 => 0x412, 447 => 'LensModel' },
	'lensmodulationoptimizer' => { 121 => 0x1045 },
	'lensmount' => { 378 => 0x99, 400 => 0x1892, 402 => 0x18be, 403 => 0x18ee, 404 => 0x17f2, 406 => 0x105, 407 => 0x105, 416 => 0x604, 417 => 0x5e },
	'lensmount2' => { 420 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 442 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 442 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 442 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 442 => 'LensProfileEnable' },
	'lensprofilefilename' => { 442 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 442 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 442 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 442 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 442 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 442 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 442 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 442 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 442 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 442 => 'LensProfileName' },
	'lensprofilesetup' => { 442 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 442 => 'LensProfileVignettingScale' },
	'lensproperties' => { 275 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 58 => 0x0, 113 => 0xa435, 154 => 'SerialNumber', 275 => 0x202, 295 => 0x321, 297 => 0x52, 359 => 0x30, 438 => 'LensSerialNumber', 447 => 'LensSerialNumber' },
	'lensshutterlock' => { 174 => 0x4a },
	'lensspec' => { 373 => 0x0, 374 => 0x0, 375 => 0x0, 388 => 0xb02a },
	'lensspecfeatures' => { 406 => [0x115,0x116], 407 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 279 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 176 => 0x10c, 177 => 0x49bd, 211 => 0x83, 275 => 0x201, 288 => 0x16, 292 => 0x310, 294 => 0x303, 295 => 0x303, 297 => 0x51, 299 => 0x3405, 324 => 0x0, 325 => 0x0, 326 => 0x1, 327 => 0x1, 328 => 0x1, 330 => 0x0, 365 => 0xa003, 368 => 0x27, 388 => 0xb027, 400 => 0x1896, 402 => 0x18c2, 403 => 0x18f2, 404 => 0x17f6, 406 => 0x109, 407 => 0x109, 416 => 0x608, 417 => 0x62 },
	'lenstype2' => { 378 => 0x3f7, 400 => 0x1893, 402 => 0x18bf, 403 => 0x18ef, 404 => 0x17f3, 406 => 0x107, 407 => 0x107, 416 => 0x605, 417 => 0x60 },
	'lenstype3' => { 420 => 0x9 },
	'lenszoomposition' => { 413 => 0x19, 414 => 0x1e, 417 => [0x342,0x35a] },
	'levelindicator' => { 305 => 0x15 },
	'levelorientation' => { 331 => 0x0 },
	'license' => { 439 => 'license' },
	'licensee' => { 284 => 'Licensee' },
	'licenseeid' => { 284 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 284 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 284 => 'LicenseeImageNotes' },
	'licenseename' => { 284 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 284 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 284 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 284 => 'LicenseeTransactionID' },
	'licenseid' => { 284 => 'LicenseID' },
	'licensestartdate' => { 284 => 'LicenseStartDate' },
	'licensetransactiondate' => { 284 => 'LicenseTransactionDate' },
	'licensetype' => { 444 => 'licensetype' },
	'licensor' => { 284 => 'Licensor' },
	'licensorcity' => { 284 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 284 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 284 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 284 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 284 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 284 => 'LicensorImageID' },
	'licensorname' => { 284 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 284 => 'LicensorNotes' },
	'licensorpostalcode' => { 284 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 284 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 284 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 284 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 284 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 284 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 284 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 284 => 'LicensorTransactionID' },
	'licensorurl' => { 284 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 279 => 0x1009 },
	'lightingmode' => { 107 => 0x302a },
	'lightreading' => { 332 => 0x15 },
	'lightsource' => { 113 => 0x9208, 211 => 0x90, 282 => 0x1000, 446 => 'LightSource' },
	'lightsourcespecial' => { 367 => 0x21d },
	'lightswitch' => { 270 => '0.1', 272 => '0.1' },
	'lightvaluecenter' => { 279 => 0x103d },
	'lightvalueperiphery' => { 279 => 0x103e },
	'limitafareamodeselection' => { 258 => '51.1', 260 => '49.1', 261 => '49.1', 270 => '49.1', 271 => '49.1' },
	'linearitylimitblue' => { 302 => 0x10 },
	'linearitylimitgreen' => { 302 => 0xf },
	'linearitylimitred' => { 302 => 0xe },
	'linearityuppermargin' => { 42 => [0x2ba,0x2d1,0x2d5], 44 => 0x1e5, 45 => [0x1fe,0x2de], 46 => [0x232,0x310], 47 => 0x31e },
	'linearizationtable' => { 113 => 0xc618 },
	'linearresponselimit' => { 113 => 0xc62e },
	'link' => { 456 => 'link' },
	'linkaetoafpoint' => { 313 => '14.2' },
	'linkedencodedrightsexpr' => { 452 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 452 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 452 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 452 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 131 => 0x904 },
	'lithostratigraphicterms' => { 112 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 262 => '32.1', 272 => '34.1' },
	'liveviewafareamode' => { 267 => '34.1' },
	'liveviewafmethod' => { 393 => 0x20 },
	'liveviewafmode' => { 267 => '34.2' },
	'liveviewafsetting' => { 378 => 0x36 },
	'liveviewbuttonoptions' => { 258 => '50.2', 260 => '48.2', 261 => '48.2', 270 => '48.2', 271 => '48.2' },
	'liveviewexposuresimulation' => { 78 => 0x810 },
	'liveviewfocusmode' => { 378 => [0x8b,0x28b] },
	'liveviewmetering' => { 378 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 258 => '21.2', 260 => '21.2', 261 => '21.2', 263 => '20.2', 264 => '20.2', 265 => '20.2', 267 => '20.2', 270 => '21.2', 271 => '21.2' },
	'liveviewshooting' => { 54 => 0x13 },
	'livingspecimen' => { 112 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 112 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 125 => 0x79 },
	'localizedcameramodel' => { 113 => 0xc615 },
	'locallocationname' => { 365 => 0x30 },
	'location' => { 210 => 0x9, 297 => 0x67, 434 => 'Location', 451 => 'Location', 455 => 'location', 456 => 'location' },
	'locationareacode' => { 440 => 'lac' },
	'locationcreated' => { 452 => 'LocationCreated' },
	'locationcreatedcity' => { 452 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 452 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 452 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 452 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 452 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 452 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 452 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 452 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 452 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 452 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 452 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 452 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 210 => 0x0 },
	'locationname' => { 365 => 0x31 },
	'locationshown' => { 452 => 'LocationShown' },
	'locationshowncity' => { 452 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 452 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 452 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 452 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 452 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 452 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 452 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 452 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 452 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 452 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 452 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 452 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 78 => 0x709 },
	'logcomment' => { 466 => 'logComment' },
	'logscale' => { 131 => 0x902 },
	'longexposurenoisereduction' => { 59 => 0x4, 78 => 0x201, 79 => 0x1, 80 => 0x2, 81 => 0x1, 82 => 0x1, 83 => 0x2, 84 => 0x1, 297 => 0x49, 376 => 0x2b, 377 => 0x25, 378 => 0x25, 388 => 0x2008, 393 => 0x11, 417 => 0x44 },
	'longexposurenoisereduction2' => { 54 => 0x8 },
	'loop' => { 466 => 'loop' },
	'lowestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 442 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 442 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 442 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 442 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 442 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 442 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 442 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 442 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 102 => 0x150 },
	'luminancecurvepoints' => { 102 => 0x126 },
	'luminancenoisereduction' => { 97 => 0x20600, 103 => 0x5f, 368 => 0x1b },
	'luminancenoisereductioncontrast' => { 442 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 442 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 103 => 0x6d },
	'luminancesmoothing' => { 442 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 78 => [0x40b,0x40c] },
	'lyrics' => { 466 => 'lyrics' },
	'm16cversion' => { 292 => 0x333 },
	'macatom' => { 441 => 'macAtom' },
	'macatomapplicationcode' => { 441 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 441 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 441 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 112 => 'MachineObservation' },
	'machineobservationday' => { 112 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 112 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 112 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 112 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 112 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 112 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 112 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 112 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 112 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 112 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 112 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 112 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 112 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 112 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 112 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 112 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 112 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 112 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 112 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 112 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 121 => 0x1020, 123 => 0x202, 279 => 0x202, 357 => 0x21, 367 => 0x202, 388 => 0xb040 },
	'macroled' => { 277 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 54 => 0x10 },
	'macromode' => { 33 => 0x1, 171 => 0xb, 274 => 0x300, 297 => 0x1c, 358 => 0x1009 },
	'magentahsl' => { 97 => 0x20917 },
	'magicfilter' => { 274 => 0x52c },
	'magnifiedview' => { 80 => 0x11, 82 => 0x9 },
	'mainboardversion' => { 131 => 0x438 },
	'maindialexposurecomp' => { 268 => '0.6' },
	'mainingredient' => { 458 => 'mainIngredient' },
	'majorversion' => { 432 => 'MajorVersion' },
	'make' => { 92 => 0x0, 109 => 0x1, 113 => 0x10f, 147 => 'Make', 287 => 'Make', 302 => 0x10f, 455 => 'make', 462 => 'Make' },
	'makernote' => { 446 => 'MakerNote' },
	'makernoteapple' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecanon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotedji' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteflir' => { 111 => 'MakN', 113 => 0x927c },
	'makernotefujifilm' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehasselblad' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteisl' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvc' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvctext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak10' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak11' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak12' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak7' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8c' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak9' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodakunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekyocera' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica3' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica4' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica5' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica7' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica8' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica9' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotemotorola' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenintendo' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteoffset' => { 367 => 0xff },
	'makernoteolympus' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteolympus2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax6' => { 111 => 'MakN', 113 => 0x927c },
	'makernotephaseone' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericohtext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesafety' => { 113 => 0xc635 },
	'makernotesamsung1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyo' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyoc4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyopatch' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesigma' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonyericsson' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonysrf' => { 111 => 'MakN', 113 => 0x927c },
	'makernotetype' => { 358 => 0x1 },
	'makernoteunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknownbinary' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknowntext' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteversion' => { 176 => 0x0, 211 => 0x1, 279 => 0x0, 297 => 0x8000, 362 => 0x0, 365 => 0x1, 368 => [0x1d,0x1f], 379 => 0x2000 },
	'managedfrom' => { 467 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 467 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 467 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 467 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 467 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 467 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 467 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 467 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 467 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 467 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 467 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 467 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 467 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 467 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 467 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 467 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 467 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 467 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 467 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 467 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 467 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 467 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 467 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 467 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 467 => 'Manager' },
	'managervariant' => { 467 => 'ManagerVariant' },
	'manageto' => { 467 => 'ManageTo' },
	'manageui' => { 467 => 'ManageUI' },
	'manifest' => { 467 => 'Manifest' },
	'manifestlinkform' => { 467 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 467 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 467 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 467 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 467 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 467 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 467 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 467 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 467 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 467 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 467 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 467 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 467 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 467 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 467 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 467 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 467 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 467 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 467 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 467 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 467 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 467 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 467 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 467 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 467 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 467 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 467 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 467 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 274 => 0x900, 297 => 0x86 },
	'manometerreading' => { 274 => 0x901 },
	'manualafpointselectpattern' => { 78 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 277 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 259 => '8.2', 262 => '22.2', 263 => '23.1', 264 => '23.2', 266 => '16.2', 267 => '23.2', 268 => '8.2', 269 => '23.2', 272 => '24.2', 358 => 0x100c },
	'manualflashstrength' => { 274 => 0x406 },
	'manualfocusdistance' => { 211 => 0x85, 279 => 0x100c, 367 => 0x223 },
	'manualtv' => { 77 => 0x5, 78 => 0x705 },
	'manufacturedate' => { 181 => 0x6705, 312 => 0x1 },
	'manufacturedate1' => { 360 => 0x4 },
	'manufacturedate2' => { 360 => 0x5 },
	'manufacturer' => { 426 => 'Manufacturer', 455 => 'manufacturer' },
	'mariahchromablursize' => { 131 => 0xf0d },
	'mariahmaphithreshold' => { 131 => 0xf0c },
	'mariahmaplothreshold' => { 131 => 0xf0b },
	'mariahsigmathreshold' => { 131 => 0xf0e },
	'mariahtexturethreshold' => { 131 => 0xf0a },
	'marked' => { 453 => 'Marked', 470 => 'Marked' },
	'markers' => { 466 => 'markers' },
	'markerscomment' => { 466 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 466 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 466 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 466 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 466 => [\'markers','markersCuePointType'] },
	'markersduration' => { 466 => [\'markers','markersDuration'] },
	'markerslocation' => { 466 => [\'markers','markersLocation'] },
	'markersname' => { 466 => [\'markers','markersName'] },
	'markersprobability' => { 466 => [\'markers','markersProbability'] },
	'markersspeaker' => { 466 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 466 => [\'markers','markersStartTime'] },
	'markerstarget' => { 466 => [\'markers','markersTarget'] },
	'markerstype' => { 466 => [\'markers','markersType'] },
	'maskedareas' => { 113 => 0xc68e },
	'masterdocumentid' => { 125 => 0xb9 },
	'mastergain' => { 218 => 0x50 },
	'materialsample' => { 112 => 'MaterialSample' },
	'materialsampleid' => { 112 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 258 => '50.1', 260 => '48.1', 261 => '48.1', 270 => '48.1', 271 => '48.1' },
	'matrixselectk' => { 131 => 0x91b },
	'matrixselectthreshold' => { 131 => 0x91a },
	'matrixselectthreshold1' => { 131 => 0x91e },
	'matrixselectthreshold2' => { 131 => 0x91f },
	'matrixstructure' => { 352 => 0xa },
	'maxaperture' => { 33 => 0x1a, 131 => 0x3f9, 137 => 0x6103, 154 => 'MaxAperture', 171 => 0x17, 177 => 0x49c5, 275 => 0x20a, 323 => '14.1' },
	'maxapertureatmaxfocal' => { 121 => 0x1407, 154 => 'MaxApertureAtMaxFocal', 206 => 0xb, 207 => 0x10, 208 => 0x11, 275 => 0x206 },
	'maxapertureatminfocal' => { 121 => 0x1406, 206 => 0xa, 207 => 0xf, 208 => 0x10, 275 => 0x205 },
	'maxaperturevalue' => { 113 => 0x9205, 341 => 0x414, 446 => 'MaxApertureValue' },
	'maxavailheight' => { 452 => 'MaxAvailHeight' },
	'maxavailwidth' => { 452 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 257 => 0xb, 258 => 0xc, 260 => '12.1', 261 => '12.1', 266 => 0xc, 267 => 0xb, 270 => '12.1', 271 => '12.1' },
	'maxfaces' => { 278 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 121 => 0x1405, 154 => 'MaxFocalLength', 206 => 0x9, 207 => 0xe, 208 => 0xf, 275 => 0x208, 400 => 0x127c, 401 => 0x1138, 402 => 0x330, 403 => 0x330, 404 => 0x30e },
	'maximumdensityrange' => { 127 => 0x8c },
	'maxpagesize' => { 471 => 'MaxPageSize' },
	'maxpagesizeh' => { 471 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 471 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 471 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 131 => 0xc7d },
	'maxsamplevalue' => { 113 => 0x119 },
	'maxstorage' => { 461 => 'maxstorage' },
	'mb-d10batteries' => { 257 => '12.6' },
	'mb-d10batterytype' => { 266 => '13.3' },
	'mb-d11batterytype' => { 267 => '2.3' },
	'mb-d12batterytype' => { 270 => '3.2' },
	'mb-d80batteries' => { 268 => '6.5' },
	'mb-d80batterytype' => { 272 => '3.2' },
	'mcuversion' => { 206 => 0xc, 207 => 0x11, 208 => 0x12 },
	'md5digest' => { 155 => 'zmd5' },
	'mditemfindercomment' => { 164 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 164 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 164 => 'MDItemFSLabel' },
	'mditemusertags' => { 164 => 'MDItemUserTags' },
	'meal' => { 458 => 'meal' },
	'measuredev' => { 27 => 0x9, 72 => 0x3, 91 => 0x1814, 147 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 72 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 177 => 0x690, 292 => 0x312, 295 => 0x312, 296 => 0x312, 299 => 0x3407 },
	'measuredrggb' => { 61 => 0x1 },
	'measuredrggbdata' => { 41 => 0x287 },
	'measurementaccuracy' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 112 => 'MeasurementOrFact' },
	'measurementremarks' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 426 => 'MeasureType' },
	'mechanicalshuttercount' => { 211 => 0x37 },
	'mediaconstraints' => { 284 => 'MediaConstraints' },
	'mediacreatedate' => { 349 => 0x1 },
	'mediaeventiddate' => { 431 => 'MediaEventIdDate' },
	'mediamodifydate' => { 349 => 0x2 },
	'mediasummarycode' => { 284 => 'MediaSummaryCode' },
	'memoaudioquality' => { 78 => 0x812 },
	'memorycardconfiguration' => { 382 => 0x16 },
	'memorycardnumber' => { 197 => 0x2 },
	'menubuttondisplayposition' => { 76 => 0xb, 79 => 0xa, 80 => 0xb, 83 => 0xb },
	'menubuttonreturn' => { 84 => 0xb },
	'menumonitorofftime' => { 257 => '26.1', 258 => '22.1', 260 => '22.1', 261 => '22.1', 265 => '21.1', 266 => '8.2', 267 => '21.1', 270 => '22.1', 271 => '22.1', 272 => '22.1' },
	'metadatadate' => { 464 => 'MetadataDate' },
	'metadatamoddate' => { 466 => 'metadataModDate' },
	'metaversion' => { 395 => 0x34 },
	'meterinfo1row1' => { 389 => 0x0, 390 => 0x0 },
	'meterinfo1row2' => { 389 => 0x6c, 390 => 0x5a },
	'meterinfo1row3' => { 389 => 0xd8, 390 => 0xb4 },
	'meterinfo1row4' => { 389 => 0x144, 390 => 0x10e },
	'meterinfo1row5' => { 389 => 0x1b0, 390 => 0x168 },
	'meterinfo1row6' => { 389 => 0x21c, 390 => 0x1c2 },
	'meterinfo1row7' => { 389 => 0x288, 390 => 0x21c },
	'meterinfo2row1' => { 389 => 0x2f4, 390 => 0x276 },
	'meterinfo2row2' => { 389 => 0x378, 390 => 0x2e4 },
	'meterinfo2row3' => { 389 => 0x3fc, 390 => 0x352 },
	'meterinfo2row4' => { 389 => 0x480, 390 => 0x3c0 },
	'meterinfo2row5' => { 389 => 0x504, 390 => 0x42e },
	'meterinfo2row6' => { 389 => 0x588, 390 => 0x49c },
	'meterinfo2row7' => { 389 => 0x60c, 390 => 0x50a },
	'meterinfo2row8' => { 389 => 0x690, 390 => 0x578 },
	'meterinfo2row9' => { 389 => 0x714, 390 => 0x5e6 },
	'metering' => { 259 => '6.1' },
	'meteringmode' => { 33 => 0x11, 113 => 0x9207, 133 => 0x1c, 171 => 0x7, 172 => 0x25, 174 => 0x12, 274 => 0x202, 332 => 0x17, 368 => 0x9, 376 => 0x15, 377 => 0x13, 378 => 0x7, 393 => 0x3, 396 => 0x1174, 397 => 0x1178, 398 => 0x1154, 399 => 0x11d0, 400 => 0x11ac, 401 => 0x1064, 402 => 0x25c, 403 => 0x25c, 404 => 0x24b, 446 => 'MeteringMode' },
	'meteringmode2' => { 313 => '2.1', 388 => 0x202c },
	'meteringmode3' => { 313 => '16.1' },
	'meteringoffscaleindicator' => { 174 => 0x53 },
	'meteringtime' => { 257 => '22.2', 259 => '3.2', 262 => '17.1', 263 => '18.1', 266 => '7.3', 267 => '18.1', 268 => '3.2', 272 => '19.1' },
	'micro1version' => { 354 => 0x1f },
	'micro2version' => { 354 => 0x2d },
	'mieversion' => { 155 => '0Vers' },
	'mime' => { 426 => 'Mime' },
	'minaperture' => { 33 => 0x1b, 131 => 0x3f8, 154 => 'MinAperture', 323 => '0.2' },
	'minaperturevalue' => { 341 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 121 => 0x1404, 154 => 'MinFocalLength', 206 => 0x8, 207 => 0xd, 208 => 0xe, 275 => 0x207, 400 => 0x127a, 401 => 0x1136, 402 => 0x32e, 403 => 0x32e, 404 => 0x30c },
	'minfocusdistance' => { 323 => 0x3 },
	'minintegrationrows' => { 131 => 0x1874 },
	'minoltadate' => { 171 => 0x15 },
	'minoltaimagesize' => { 171 => 0x4, 172 => 0xc, 173 => 0x2, 176 => 0x103 },
	'minoltamodelid' => { 171 => 0x25 },
	'minoltaquality' => { 171 => 0x5, 172 => 0xd, 173 => 0x3, 176 => [0x102,0x103] },
	'minoltatime' => { 171 => 0x16 },
	'minormodelagedisclosure' => { 284 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 432 => 'MinorVersion' },
	'minsamplevalue' => { 113 => 0x118 },
	'mirrorlockup' => { 76 => 0xc, 77 => 0xc, 78 => 0x60f, 79 => 0xb, 80 => 0xc, 81 => 0x6, 82 => 0x6, 83 => 0xc, 84 => 0x3 },
	'mobilecountrycode' => { 440 => 'mcc' },
	'mobilenetworkcode' => { 440 => 'mnc' },
	'moddate' => { 287 => 'modify-date', 453 => 'ModDate' },
	'modedialposition' => { 382 => 0x14 },
	'model' => { 92 => 0x6, 113 => 0x110, 147 => 'Model', 287 => 'Model', 302 => 0x110, 332 => 0x23f, 368 => 0x84, 426 => 'Model', 455 => 'model', 462 => 'Model' },
	'modelage' => { 452 => 'ModelAge' },
	'modelid' => { 273 => 0x0 },
	'modelingflash' => { 257 => '21.4', 258 => '31.1', 260 => '31.1', 261 => '31.1', 266 => '26.4', 267 => '30.2', 268 => '7.4', 269 => '30.1', 270 => '31.1', 271 => '31.1', 272 => '31.3' },
	'modelreleaseid' => { 284 => 'ModelReleaseID' },
	'modelreleasestatus' => { 284 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 408 => 0x52, 409 => 0x46, 410 => 0x53 },
	'modelyear' => { 455 => 'modelYear' },
	'modificationdate' => { 456 => 'modificationDate' },
	'modifiedcolortemp' => { 62 => 0x9 },
	'modifieddigitalgain' => { 62 => 0xb },
	'modifiedparamflag' => { 55 => 0x1 },
	'modifiedpicturestyle' => { 62 => 0xa },
	'modifiedsaturation' => { 274 => 0x504 },
	'modifiedsensorbluelevel' => { 62 => 0x5 },
	'modifiedsensorredlevel' => { 62 => 0x4 },
	'modifiedsharpness' => { 62 => 0x2 },
	'modifiedsharpnessfreq' => { 62 => 0x3 },
	'modifiedtonecurve' => { 62 => 0x1 },
	'modifiedwhitebalance' => { 62 => 0x8 },
	'modifiedwhitebalanceblue' => { 62 => 0x7 },
	'modifiedwhitebalancered' => { 62 => 0x6 },
	'modifydate' => { 113 => 0x132, 148 => 'ModifyDate', 283 => 'ModDate', 285 => 'tIME', 348 => 'ModDate', 350 => 0x2, 464 => 'ModifyDate' },
	'moirefilter' => { 113 => 0xfe58, 442 => 'MoireFilter' },
	'monitordisplayoff' => { 174 => 0x4c },
	'monitormatrix' => { 131 => 0x8fc },
	'monitorofftime' => { 257 => '18.2', 259 => '3.1', 268 => '3.1' },
	'monochromecolor' => { 274 => 0x53b },
	'monochromecontrast' => { 103 => 0x3c },
	'monochromefiltereffect' => { 97 => 0x20307, 103 => 0x3a, 332 => 0x73 },
	'monochromelinear' => { 103 => 0x3d },
	'monochromeoutputhighlightpoint' => { 103 => 0x41 },
	'monochromeoutputshadowpoint' => { 103 => 0x42 },
	'monochromeprofilesettings' => { 274 => 0x537 },
	'monochromerawhighlight' => { 103 => 0x7a },
	'monochromerawhighlightpoint' => { 103 => 0x3f },
	'monochromerawshadow' => { 103 => 0x83 },
	'monochromerawshadowpoint' => { 103 => 0x40 },
	'monochromesharpness' => { 103 => 0x3e },
	'monochrometoning' => { 332 => 0x74 },
	'monochrometoningeffect' => { 97 => 0x20306, 103 => 0x3b },
	'monochromeunsharpmaskfineness' => { 103 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 103 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 103 => 0xb4 },
	'monochromevignetting' => { 274 => 0x53a },
	'monthdaycreated' => { 133 => 0x12, 142 => 0xe },
	'moonphase' => { 353 => 0x12, 354 => 0x43 },
	'morepermissions' => { 439 => 'morePermissions' },
	'motionsensitivity' => { 353 => 0x29 },
	'movieaelockbuttonassignment' => { 270 => '40.1' },
	'moviefunc1button' => { 260 => '41.1', 261 => '41.1', 271 => '41.1' },
	'moviefunctionbutton' => { 258 => '41.1', 270 => '41.1' },
	'moviefunctionbuttonplusdials' => { 258 => '52.1' },
	'moviepreviewbutton' => { 258 => '41.2', 260 => '41.2', 261 => '41.2', 270 => '41.2', 271 => '41.2' },
	'moviepreviewbuttonplusdials' => { 258 => '52.2' },
	'movieshutterbutton' => { 258 => '38.3', 260 => '38.3', 261 => '38.3', 270 => '38.3', 271 => '38.3' },
	'moviesubselectorassignment' => { 258 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 258 => '53.1' },
	'multiburstimageheight' => { 388 => 0x1002 },
	'multiburstimagewidth' => { 388 => 0x1001 },
	'multiburstmode' => { 388 => 0x1000 },
	'multicontrollerwhilemetering' => { 78 => 0x517 },
	'multiexposure' => { 64 => 0x1, 297 => 0xb4 },
	'multiexposureautogain' => { 212 => 0x3 },
	'multiexposurecontrol' => { 64 => 0x2 },
	'multiexposuremode' => { 212 => 0x1 },
	'multiexposureshots' => { 64 => 0x3, 212 => 0x2 },
	'multiframenoisereduction' => { 378 => 0x35, 388 => 0x200b, 393 => 0x15 },
	'multiframenreffect' => { 388 => 0x2023 },
	'multifunctionlock' => { 78 => 0x70f },
	'multipleexposuremode' => { 278 => 0x101c },
	'multipleexposureset' => { 313 => '10.1' },
	'multisample' => { 218 => 0x40 },
	'multiselector' => { 257 => '9.4', 258 => '10.3', 260 => '10.3', 261 => '10.3', 266 => '27.4', 270 => '10.3', 271 => '10.3' },
	'multiselectorliveview' => { 257 => '4.3', 260 => '37.1', 261 => '37.1', 270 => '37.1', 271 => '37.1' },
	'multiselectorliveviewmode' => { 228 => 0x18c2 },
	'multiselectorplaybackmode' => { 257 => ['13.5','9.2'], 258 => '10.2', 261 => '10.2', 266 => '27.2', 270 => '10.2', 271 => '10.2' },
	'multiselectorshootmode' => { 257 => '9.1', 258 => '10.1', 260 => '10.1', 261 => '10.1', 266 => '27.1', 270 => '10.1', 271 => '10.1' },
	'multishot' => { 302 => 0x121 },
	'mycolormode' => { 65 => 0x2 },
	'nationalcatalognumber' => { 456 => 'nationalCatalogNumber' },
	'nativedigest' => { 446 => 'NativeDigest', 462 => 'NativeDigest' },
	'ndfilter' => { 72 => 0x1c, 274 => 0x204, 358 => 0x1019 },
	'near' => { 426 => 'Near' },
	'nefbitdepth' => { 211 => 0xe22 },
	'nefcompression' => { 211 => 0x93 },
	'neflinearizationtable' => { 211 => 0x96 },
	'negativecachelargepreviewsize' => { 442 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 442 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 442 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 332 => 0x88 },
	'neutraloutputhighlightpoint' => { 103 => 0x2f },
	'neutraloutputshadowpoint' => { 103 => 0x30 },
	'neutralrawcolortone' => { 103 => 0x28 },
	'neutralrawcontrast' => { 103 => 0x2a },
	'neutralrawhighlight' => { 103 => 0x78 },
	'neutralrawhighlightpoint' => { 103 => 0x2d },
	'neutralrawlinear' => { 103 => 0x2b },
	'neutralrawsaturation' => { 103 => 0x29 },
	'neutralrawshadow' => { 103 => 0x81 },
	'neutralrawshadowpoint' => { 103 => 0x2e },
	'neutralrawsharpness' => { 103 => 0x2c },
	'neutralunsharpmaskfineness' => { 103 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 103 => 0xa8 },
	'neutraunsharpmaskstrength' => { 103 => 0xa4 },
	'newrawimagedigest' => { 113 => 0xc7a7 },
	'newsphotoversion' => { 127 => 0x0 },
	'nickname' => { 464 => 'Nickname' },
	'nikoncapturedata' => { 211 => 0xe01 },
	'nikoncaptureeditversions' => { 211 => 0xe13 },
	'nikoncaptureoutput' => { 211 => 0xe1e },
	'nikoncaptureversion' => { 211 => 0xe09 },
	'nikoniccprofile' => { 211 => 0xe1d },
	'nikonimagesize' => { 225 => '723.1', 226 => '732.1', 235 => 0x2c4 },
	'noisefilter' => { 274 => 0x527 },
	'noiseprofile' => { 113 => 0xc761 },
	'noisereduction' => { 121 => [0x100b,0x100e], 172 => 0xb0, 173 => 0x60, 174 => 0x3f, 211 => 0x95, 250 => 0x753dcbc0, 251 => 0x17, 274 => 0x50a, 279 => 0x103a, 297 => 0x2d, 332 => 0x49, 358 => 0x100f, 360 => 0x2a },
	'noisereduction2' => { 278 => 0x1010 },
	'noisereductionapplied' => { 113 => 0xc6f7 },
	'noisereductionintensity' => { 251 => 0x9 },
	'noisereductionmethod' => { 251 => 0x11 },
	'noisereductionmode' => { 421 => 0x801e },
	'noisereductionparametersatcapture' => { 131 => 0xe73 },
	'noisereductionparameterscamera' => { 131 => 0xe72 },
	'noisereductionparametershost3mp' => { 131 => 0xe71 },
	'noisereductionparametershost6mp' => { 131 => 0xe70 },
	'noisereductionparametershostrgb' => { 131 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 131 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 131 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 131 => 0xe63 },
	'noisereductionparams' => { 302 => 0x1b },
	'noisereductionsharpness' => { 251 => 0xd },
	'noisereductionvalue' => { 421 => 0x8027 },
	'nomemorycard' => { 257 => '22.1', 258 => '4.2', 259 => '0.3', 262 => '2.4', 263 => '3.2', 264 => '3.2', 266 => '33.7', 267 => '3.2', 268 => '0.3', 270 => '4.2', 272 => '4.5' },
	'nominalmaxaperture' => { 323 => 0xa },
	'nominalminaperture' => { 323 => '10.1' },
	'normallinetime' => { 131 => 0x186a },
	'normalwhitelevel' => { 42 => [0x2b8,0x2cf,0x2d3], 44 => 0x1e3, 45 => [0x1fc,0x2dc], 46 => [0x230,0x30e], 47 => 0x31c },
	'notes' => { 422 => 'Notes', 436 => 'notes' },
	'npages' => { 471 => 'NPages' },
	'nullrecord' => { 91 => 0x0 },
	'numafpoints' => { 309 => 0x2 },
	'number' => { 456 => 'number' },
	'numberofbeats' => { 466 => 'numberOfBeats' },
	'numberoffocuspoints' => { 260 => '1.2', 261 => '1.2', 264 => '0.2', 265 => '0.3', 267 => '0.3' },
	'numfaceelements' => { 121 => 0x4200 },
	'numfacepositions' => { 289 => 0x0 },
	'numindexentries' => { 127 => 0x54 },
	'numwbentries' => { 303 => 0x0, 304 => 0x0 },
	'object' => { 456 => 'object' },
	'objectattributereference' => { 125 => 0x4 },
	'objectcycle' => { 125 => 0x4b, 436 => 'ObjectCycle' },
	'objectdescription' => { 455 => 'objectDescription' },
	'objectdistance' => { 106 => 0x6, 107 => 0x2022 },
	'objectname' => { 125 => 0x5 },
	'objectpreviewdata' => { 125 => 0xca },
	'objectpreviewfileformat' => { 125 => 0xc8 },
	'objectpreviewfileversion' => { 125 => 0xc9 },
	'objectsubtype' => { 455 => 'objectSubtype' },
	'objecttype' => { 455 => 'objectType' },
	'objecttypereference' => { 125 => 0x3 },
	'occurrence' => { 112 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 112 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 112 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 112 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 112 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 112 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 112 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 112 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 112 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 112 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 112 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 112 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 112 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 112 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 112 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 112 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 112 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 112 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 112 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 112 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 112 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 112 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 112 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 112 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 112 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 112 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 446 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 446 => [\'OECF','OECFNames'] },
	'oecfrows' => { 446 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 446 => [\'OECF','OECFValues'] },
	'offsaledate' => { 456 => 'offSaleDate' },
	'offsaledatea-platform' => { 456 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 456 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 131 => 0x190a },
	'offsetschema' => { 113 => 0xea1d },
	'offsettime' => { 113 => 0x9010 },
	'offsettimedigitized' => { 113 => 0x9012 },
	'offsettimeoriginal' => { 113 => 0x9011 },
	'okbutton' => { 267 => '15.1', 272 => '16.1' },
	'oldsubfiletype' => { 113 => 0xff },
	'olympusimageheight' => { 279 => 0x102f },
	'olympusimagewidth' => { 279 => 0x102e },
	'omenatcapturestrength' => { 131 => 0xa60 },
	'omenautostrength' => { 131 => 0xa5f },
	'omenearlystrength' => { 131 => 0xa5e },
	'omenfocallengthlimit' => { 131 => 0xa62 },
	'omeninitialipfstrength' => { 131 => 0xa5d },
	'omensurfaceindex' => { 131 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 279 => 0x302 },
	'onsaledate' => { 456 => 'onSaleDate' },
	'onsaledatea-platform' => { 456 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 456 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 456 => 'onSaleDay' },
	'onsaledaya-platform' => { 456 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 456 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 113 => 0xc740 },
	'opcodelist2' => { 113 => 0xc741 },
	'opcodelist3' => { 113 => 0xc74e },
	'opticalzoom' => { 135 => 0xfa3d, 137 => [0x6006,0xf006], 138 => 0x1000, 139 => 0xf, 142 => 0x1e, 154 => 'OpticalZoom' },
	'opticalzoomcode' => { 72 => 0xa },
	'opticalzoommode' => { 297 => 0x34 },
	'opticalzoomon' => { 367 => 0x219 },
	'optionenddate' => { 459 => 'optionEndDate' },
	'opto-electricconvfactor' => { 446 => 'OECF' },
	'orangehsl' => { 97 => 0x20911 },
	'ordernumber' => { 121 => 0x8002 },
	'organisationinimagecode' => { 452 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 452 => 'OrganisationInImageName' },
	'organism' => { 112 => 'Organism' },
	'organismassociatedoccurrences' => { 112 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 112 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 112 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 112 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 112 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 112 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 112 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 456 => 'organization' },
	'orientation' => { 113 => 0x112, 302 => 0x112, 455 => 'orientation', 462 => 'Orientation' },
	'orientation2' => { 393 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 78 => 0x516 },
	'originalbestqualitysize' => { 113 => 0xc792 },
	'originalcreatedatetime' => { 431 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 108 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 60 => 0x83 },
	'originaldefaultcropsize' => { 113 => 0xc793 },
	'originaldefaultfinalsize' => { 113 => 0xc791 },
	'originaldirectory' => { 294 => 0x408 },
	'originaldocumentid' => { 467 => 'OriginalDocumentID' },
	'originalfilename' => { 91 => 0x816, 131 => 0x3e9, 143 => 0x20, 294 => 0x407, 431 => 'OriginalFilename' },
	'originalimageheight' => { 74 => 0xc, 117 => 0x1 },
	'originalimagewidth' => { 74 => 0xb, 117 => 0x0 },
	'originalrawfiledata' => { 113 => 0xc68c },
	'originalrawfiledigest' => { 113 => 0xc71d },
	'originalrawfilename' => { 113 => 0xc68b },
	'originaltransmissionreference' => { 125 => 0x67 },
	'originatingprogram' => { 125 => 0x41, 436 => 'OriginatingProgram' },
	'originplatform' => { 456 => 'originPlatform' },
	'os' => { 444 => 'os' },
	'otherconditions' => { 284 => 'OtherConditions' },
	'otherconstraints' => { 284 => 'OtherConstraints' },
	'otherimage' => { 108 => 'OtherImage' },
	'otherimageinfo' => { 284 => 'OtherImageInfo' },
	'otherimagelength' => { 113 => 0x202 },
	'otherimagestart' => { 113 => 0x201 },
	'otherlicensedocuments' => { 284 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 284 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 284 => 'OtherLicenseRequirements' },
	'outcue' => { 466 => 'outCue' },
	'outcuescale' => { 466 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 466 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 186 => 0x3 },
	'outputimagewidth' => { 186 => 0x2 },
	'outputlut' => { 297 => 0xa7 },
	'outputprofile' => { 131 => 0x138b },
	'outputresolution' => { 186 => 0x4 },
	'overclockcols' => { 131 => 0x189c },
	'overclockrows' => { 131 => 0x18c4 },
	'owner' => { 470 => 'Owner' },
	'ownerid' => { 125 => 0xbc },
	'ownername' => { 14 => 0x10f, 60 => 0x9, 91 => 0x810, 113 => [0xa430,0xfde8], 147 => 'OwnerName', 438 => 'OwnerName', 447 => 'CameraOwnerName' },
	'padding' => { 113 => 0xea1c },
	'pagecount' => { 456 => 'pageCount' },
	'pageimage' => { 464 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 464 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 464 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 464 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 464 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 464 => 'PageInfo' },
	'pagename' => { 113 => 0x11d },
	'pagenumber' => { 113 => 0x129 },
	'pageprogressiondirection' => { 456 => 'pageProgressionDirection' },
	'pagerange' => { 456 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 442 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 442 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 300 => 0x0 },
	'panasonicexifversion' => { 297 => 0x26 },
	'panasonicimageheight' => { 297 => 0x4c },
	'panasonicimagewidth' => { 297 => 0x4b },
	'panasonicrawversion' => { 302 => 0x1 },
	'panasonictitle' => { 113 => 0xc6d2 },
	'panasonictitle2' => { 113 => 0xc6d3 },
	'panoramaangle' => { 121 => 0x1153 },
	'panoramacropbottom' => { 394 => 0x7 },
	'panoramacropleft' => { 394 => 0x4 },
	'panoramacropright' => { 394 => 0x6 },
	'panoramacroptop' => { 394 => 0x5 },
	'panoramadirection' => { 68 => 0x5, 121 => 0x1154, 394 => 0x3 },
	'panoramaframeheight' => { 394 => 0x9 },
	'panoramaframenumber' => { 68 => 0x2 },
	'panoramaframewidth' => { 394 => 0x8 },
	'panoramafullheight' => { 394 => 0x2 },
	'panoramafullwidth' => { 394 => 0x1 },
	'panoramamode' => { 133 => 0x3c, 274 => 0x601 },
	'panoramasize3d' => { 378 => 0x38 },
	'panoramasourceheight' => { 394 => 0xb },
	'panoramasourcewidth' => { 394 => 0xa },
	'panoramicstitchcameramotion' => { 167 => 'PanoramicStitchCameraMotion', 168 => 0x1 },
	'panoramicstitchmaptype' => { 167 => 'PanoramicStitchMapType', 168 => 0x2 },
	'panoramicstitchphi0' => { 167 => 'PanoramicStitchPhi0', 168 => 0x5 },
	'panoramicstitchphi1' => { 167 => 'PanoramicStitchPhi1', 168 => 0x6 },
	'panoramicstitchtheta0' => { 167 => 'PanoramicStitchTheta0', 168 => 0x3 },
	'panoramicstitchtheta1' => { 167 => 'PanoramicStitchTheta1', 168 => 0x4 },
	'panoramicstitchversion' => { 168 => 0x0 },
	'pantry' => { 467 => 'Pantry' },
	'parallax' => { 121 => 0xb211, 273 => 0x28 },
	'parametricdarks' => { 442 => 'ParametricDarks' },
	'parametrichighlights' => { 442 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 442 => 'ParametricHighlightSplit' },
	'parametriclights' => { 442 => 'ParametricLights' },
	'parametricmidtonesplit' => { 442 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 442 => 'ParametricShadows' },
	'parametricshadowsplit' => { 442 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 431 => 'ParentMediaEventID' },
	'parentmeid' => { 431 => 'ParentMEID' },
	'parentreference1' => { 450 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 450 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partialactivecols1' => { 131 => 0x17e8 },
	'partialactivecols2' => { 131 => 0x17f2 },
	'partialactiverows1' => { 131 => 0x17fc },
	'partialactiverows2' => { 131 => 0x1806 },
	'partofcompilation' => { 466 => 'partOfCompilation' },
	'patientbirthdate' => { 423 => 'PatientDOB' },
	'patientid' => { 423 => 'PatientID' },
	'patientname' => { 423 => 'PatientName' },
	'patientsex' => { 423 => 'PatientSex' },
	'patternareaheight' => { 131 => 0x963 },
	'patternareawidth' => { 131 => 0x962 },
	'patterncorrectionfactorscale' => { 131 => 0x969 },
	'patterncropcols1' => { 131 => 0x96c },
	'patterncropcols2' => { 131 => 0x96d },
	'patterncroprows1' => { 131 => 0x96a },
	'patterncroprows2' => { 131 => 0x96b },
	'patternimagerheight' => { 131 => 0x961 },
	'patternimagerwidth' => { 131 => 0x960 },
	'patternx' => { 131 => 0x966 },
	'patterny' => { 131 => 0x967 },
	'pdfversion' => { 453 => 'PDFVersion' },
	'pentaximagesize' => { 332 => 0x9 },
	'pentaxmodelid' => { 312 => 0x0, 332 => 0x5 },
	'pentaxmodeltype' => { 332 => 0x1 },
	'pentaxversion' => { 332 => 0x0 },
	'people' => { 424 => 'People', 434 => 'People' },
	'perchannelblacklevel' => { 41 => 0xc4, 42 => [0x2b4,0x2cb,0x2cf], 43 => [0x108,0x14d], 44 => 0x1df, 45 => [0x1f8,0x2d8], 46 => [0x22c,0x30a], 47 => 0x149 },
	'peripheralillumcentralradius' => { 421 => 0x8030 },
	'peripheralillumcentralvalue' => { 421 => 0x8031 },
	'peripheralillumination' => { 97 => 0x20702, 103 => 0x68 },
	'peripheralilluminationcorr' => { 59 => 0x1, 322 => 0x2 },
	'peripheralilluminationon' => { 97 => '0x20702.0', 103 => 0x64 },
	'peripheralillumperiphvalue' => { 421 => 0x8032 },
	'peripherallighting' => { 74 => 0x2 },
	'peripherallightingsetting' => { 75 => 0x5 },
	'peripherallightingvalue' => { 74 => 0x6 },
	'permissions' => { 459 => 'permissions' },
	'permits' => { 439 => 'permits' },
	'person' => { 456 => 'person' },
	'personality' => { 431 => 'Personality' },
	'personheard' => { 452 => 'PersonHeard' },
	'personheardidentifier' => { 452 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 452 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 452 => 'PersonInImage' },
	'personinimagecharacteristic' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 452 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 452 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 442 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 442 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 442 => 'PerspectiveRotate' },
	'perspectivescale' => { 442 => 'PerspectiveScale' },
	'perspectiveupright' => { 442 => 'PerspectiveUpright' },
	'perspectivevertical' => { 442 => 'PerspectiveVertical' },
	'perspectivex' => { 442 => 'PerspectiveX' },
	'perspectivey' => { 442 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 86 => 0x1 },
	'pf10retainprogramshift' => { 86 => 0xb },
	'pf13drivepriority' => { 86 => 0xe },
	'pf14disablefocussearch' => { 86 => 0xf },
	'pf15disableafassistbeam' => { 86 => 0x10 },
	'pf16autofocuspointshoot' => { 86 => 0x11 },
	'pf17disableafpointsel' => { 86 => 0x12 },
	'pf18enableautoafpointsel' => { 86 => 0x13 },
	'pf19continuousshootspeed' => { 86 => 0x14 },
	'pf19shootingspeedhigh' => { 85 => 0xa },
	'pf19shootingspeedlow' => { 85 => 0x9 },
	'pf1disableshootingmodes' => { 86 => 0x2 },
	'pf1value' => { 85 => 0x1 },
	'pf20limitcontinousshots' => { 86 => 0x15 },
	'pf20maxcontinousshots' => { 85 => 0xb },
	'pf21enablequietoperation' => { 86 => 0x16 },
	'pf23felocktime' => { 85 => 0xd },
	'pf23postreleasetime' => { 85 => 0xe },
	'pf23settimerlengths' => { 86 => 0x18 },
	'pf23shutterbuttontime' => { 85 => 0xc },
	'pf24lightlcdduringbulb' => { 86 => 0x19 },
	'pf25aemode' => { 85 => 0xf },
	'pf25afmode' => { 85 => 0x12 },
	'pf25afpointsel' => { 85 => 0x13 },
	'pf25colormatrix' => { 85 => 0x17 },
	'pf25defaultclearsettings' => { 86 => 0x1a },
	'pf25drivemode' => { 85 => 0x11 },
	'pf25imagesize' => { 85 => 0x14 },
	'pf25meteringmode' => { 85 => 0x10 },
	'pf25parameters' => { 85 => 0x16 },
	'pf25wbmode' => { 85 => 0x15 },
	'pf26shortenreleaselag' => { 86 => 0x1b },
	'pf27reversedialrotation' => { 86 => 0x1c },
	'pf27value' => { 85 => 0x18 },
	'pf28noquickdialexpcomp' => { 86 => 0x1d },
	'pf29quickdialswitchoff' => { 86 => 0x1e },
	'pf2disablemeteringmodes' => { 86 => 0x3 },
	'pf2value' => { 85 => 0x2 },
	'pf30enlargementmode' => { 86 => 0x1f },
	'pf31originaldecisiondata' => { 86 => 0x20 },
	'pf3manualexposuremetering' => { 86 => 0x4 },
	'pf3value' => { 85 => 0x3 },
	'pf4exposuretimelimits' => { 86 => 0x5 },
	'pf4exposuretimemax' => { 85 => 0x5 },
	'pf4exposuretimemin' => { 85 => 0x4 },
	'pf5aperturelimits' => { 86 => 0x6 },
	'pf5aperturemax' => { 85 => 0x7 },
	'pf5aperturemin' => { 85 => 0x6 },
	'pf6presetshootingmodes' => { 86 => 0x7 },
	'pf7bracketcontinuousshoot' => { 86 => 0x8 },
	'pf8bracketshots' => { 85 => 0x8 },
	'pf8setbracketshots' => { 86 => 0x9 },
	'pf9changebracketsequence' => { 86 => 0xa },
	'phasedetectaf' => { 183 => 0x6 },
	'phonenumber' => { 148 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 250 => 0xe9651831 },
	'photoeffects' => { 250 => 0xab5eca5e },
	'photoeffectsblue' => { 252 => 0x8 },
	'photoeffectsgreen' => { 252 => 0x6 },
	'photoeffectsred' => { 252 => 0x4 },
	'photoeffectstype' => { 252 => 0x0 },
	'photographicsensitivity' => { 447 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 257 => '17.6', 266 => '33.6' },
	'photometricinterpretation' => { 113 => 0x106, 462 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 229 => 0xe7d, 238 => 0xfbd },
	'photoshootingmenubankimagearea' => { 229 => '3716.1', 238 => 0x791 },
	'photoshopbgrthumbnail' => { 346 => 0x409 },
	'photoshopquality' => { 345 => 0x0 },
	'photoshopthumbnail' => { 346 => 0x40c },
	'photostyle' => { 297 => 0x89 },
	'picklabel' => { 445 => 'PickLabel' },
	'pictinfo' => { 367 => 0x208 },
	'picturecontrol' => { 250 => 0xe2173c47 },
	'picturecontrolactive' => { 253 => 0x0 },
	'picturecontroladjust' => { 213 => 0x30, 214 => 0x30 },
	'picturecontrolbase' => { 213 => 0x18, 214 => 0x18 },
	'picturecontroldata' => { 211 => [0xbd,0x23] },
	'picturecontrolmode' => { 253 => 0x13 },
	'picturecontrolname' => { 213 => 0x4, 214 => 0x4 },
	'picturecontrolquickadjust' => { 213 => 0x31, 214 => 0x31 },
	'pictureeffect' => { 388 => 0x200e },
	'pictureeffect2' => { 396 => 0x1163, 397 => 0x1167, 398 => 0x1143, 399 => 0x11bf, 400 => 0x119b, 401 => 0x1053, 402 => 0x24b, 403 => 0x24b, 404 => 0x23c, 417 => 0x46 },
	'picturefinish' => { 172 => 0x71 },
	'picturemode' => { 121 => 0x1031, 274 => 0x520, 332 => [0xb,0x33], 368 => 0x3d },
	'picturemode2' => { 313 => 0x0 },
	'picturemodebwfilter' => { 274 => 0x525 },
	'picturemodecontrast' => { 274 => 0x523 },
	'picturemodeeffect' => { 274 => 0x52d },
	'picturemodehue' => { 274 => 0x522 },
	'picturemodesaturation' => { 274 => 0x521 },
	'picturemodesharpness' => { 274 => 0x524 },
	'picturemodetone' => { 274 => 0x526 },
	'pictureprofile' => { 396 => [0x115e,0x115f], 397 => [0x1162,0x1163], 398 => [0x113e,0x113f], 399 => [0x11ba,0x11bb], 400 => [0x1196,0x1197], 401 => [0x104e,0x104f], 402 => [0x246,0x247], 403 => [0x246,0x247], 404 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 70 => 0xa, 97 => 0x20301, 103 => 0x2 },
	'picturewizard' => { 365 => 0x21 },
	'picturewizardcolor' => { 364 => 0x1 },
	'picturewizardcontrast' => { 364 => 0x4 },
	'picturewizardmode' => { 364 => 0x0 },
	'picturewizardsaturation' => { 364 => 0x2 },
	'picturewizardsharpness' => { 364 => 0x3 },
	'pipelineversion' => { 167 => 'PipelineVersion' },
	'pitch' => { 109 => 0x6, 258 => '4.1', 270 => '4.1' },
	'pitchangle' => { 228 => 0x350f, 229 => 0x2c28, 237 => 0x36f8, 274 => 0x904, 297 => 0x91, 331 => 0x2, 363 => 0x1 },
	'pixelclockfrequency' => { 131 => 0x40b },
	'pixelcorrectionoffset' => { 131 => 0x972 },
	'pixelcorrectionscale' => { 131 => 0x971 },
	'pixelshiftinfo' => { 388 => 0x202f },
	'pixelshiftresolution' => { 333 => 0x0 },
	'pixelsperunitx' => { 286 => 0x0 },
	'pixelsperunity' => { 286 => 0x4 },
	'pixelunits' => { 286 => 0x8 },
	'planarconfiguration' => { 113 => 0x11c, 462 => 'PlanarConfiguration' },
	'planningref' => { 452 => 'PlanningRef' },
	'planningrefidentifier' => { 452 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 452 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 452 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 471 => 'PlateNames' },
	'platform' => { 456 => 'platform' },
	'playbackmenustime' => { 262 => '20.1', 263 => '21.1', 264 => '21.1' },
	'playbackmonitorofftime' => { 257 => '25.2', 258 => '36.1', 260 => '36.1', 261 => '36.1', 265 => '35.1', 266 => '8.1', 267 => '35.1', 270 => '36.1', 271 => '36.1', 272 => '21.1' },
	'playbackzoom' => { 258 => '37.1' },
	'playdisplay' => { 174 => 0x4e },
	'plusversion' => { 284 => 'Version' },
	'pmversion' => { 344 => 'PMVersion' },
	'pngwarning' => { 287 => 'Warning' },
	'poilevel' => { 210 => 0x8 },
	'portraitoutputhighlightpoint' => { 103 => 0x1d },
	'portraitoutputshadowpoint' => { 103 => 0x1e },
	'portraitrawcolortone' => { 103 => 0x16 },
	'portraitrawcontrast' => { 103 => 0x18 },
	'portraitrawhighlight' => { 103 => 0x76 },
	'portraitrawhighlightpoint' => { 103 => 0x1b },
	'portraitrawlinear' => { 103 => 0x19 },
	'portraitrawsaturation' => { 103 => 0x17 },
	'portraitrawshadow' => { 103 => 0x7f },
	'portraitrawshadowpoint' => { 103 => 0x1c },
	'portraitrawsharpness' => { 103 => 0x1a },
	'portraitrefiner' => { 107 => 0x302b },
	'portraitunsharpmaskfineness' => { 103 => 0x9a },
	'portraitunsharpmaskstrength' => { 103 => 0x98 },
	'portraitunsharpmaskthreshold' => { 103 => 0x9c },
	'poseheadingdegrees' => { 429 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 429 => 'PosePitchDegrees' },
	'poserolldegrees' => { 429 => 'PoseRollDegrees' },
	'positiondescriptor' => { 455 => 'positionDescriptor' },
	'postalcode' => { 152 => 'PostalCode' },
	'postcropvignetteamount' => { 442 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 442 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 442 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 442 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 442 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 442 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 386 => 0xb },
	'potentialface2position' => { 386 => 0x15 },
	'potentialface3position' => { 386 => 0x1f },
	'potentialface4position' => { 386 => 0x29 },
	'potentialface5position' => { 386 => 0x33 },
	'potentialface6position' => { 386 => 0x3d },
	'potentialface7position' => { 386 => 0x47 },
	'potentialface8position' => { 386 => 0x51 },
	'powersource' => { 311 => '0.1' },
	'poweruptime' => { 211 => 0xb6 },
	'precaptureframes' => { 279 => 0x300 },
	'predictor' => { 113 => 0x13d },
	'preflashreturnstrength' => { 226 => 0x28a },
	'prefs' => { 125 => 0xdd, 344 => 'Prefs' },
	'prereadfastresetcount' => { 131 => 0x187e },
	'preservedfilename' => { 467 => 'PreservedFileName' },
	'preservedspecimen' => { 112 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 112 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 174 => 0x24, 421 => 0x8002 },
	'presetwhitebalanceadj' => { 421 => 0x8014 },
	'pressure' => { 113 => 0x9402, 447 => 'Pressure' },
	'previewapplicationname' => { 113 => 0xc716 },
	'previewapplicationversion' => { 113 => 0xc717 },
	'previewbutton' => { 257 => ['14.1','15.1'], 258 => '15.1', 260 => '15.1', 261 => '15.1', 266 => '29.1', 267 => '14.1', 270 => '15.1', 271 => '15.1' },
	'previewbuttonplusdials' => { 257 => ['14.2','15.2'], 258 => '15.2', 260 => '43.1', 261 => '43.1', 266 => '31.2', 270 => '43.1', 271 => '43.1' },
	'previewcolorspace' => { 113 => 0xc71a },
	'previewcropbottom' => { 343 => 0xef },
	'previewcropleft' => { 343 => 0xec },
	'previewcropright' => { 343 => 0xee },
	'previewcroptop' => { 343 => 0xed },
	'previewdate' => { 351 => 0x0 },
	'previewdatetime' => { 113 => 0xc71b },
	'previewimage' => { 107 => 0x2000, 108 => 'PreviewImage', 114 => 'PreviewImage', 116 => 0x4, 157 => 'data', 176 => 0x81, 279 => 0x280, 295 => 0x300, 388 => 0x2001 },
	'previewimageborders' => { 332 => 0x3e },
	'previewimageheight' => { 69 => 0x4, 135 => 0xfa58 },
	'previewimagelength' => { 69 => 0x2, 107 => 0x3, 113 => [0x117,0x202], 176 => 0x89, 215 => 0x202, 274 => 0x102, 279 => 0x1037, 332 => 0x3, 357 => 0x1e, 362 => 0x3, 368 => [0x1b,0x1d], 379 => 0x202 },
	'previewimagename' => { 157 => '1Name' },
	'previewimagesize' => { 107 => 0x2, 140 => 0x2, 157 => 'ImageSize', 332 => 0x2, 368 => [0x1c,0x1e], 388 => 0xb02c, 421 => 0x9012 },
	'previewimagestart' => { 69 => 0x5, 107 => 0x4, 113 => [0x111,0x201], 176 => 0x88, 215 => 0x201, 274 => 0x101, 279 => 0x1036, 332 => 0x4, 357 => 0x1c, 362 => 0x2, 368 => [0x1a,0x1c], 379 => 0x201 },
	'previewimagetype' => { 157 => '0Type' },
	'previewimagevalid' => { 274 => 0x100, 279 => 0x1035 },
	'previewimagewidth' => { 69 => 0x3, 135 => 0xfa57 },
	'previewquality' => { 69 => 0x1 },
	'previewsettingsdigest' => { 113 => 0xc719 },
	'previewsettingsname' => { 113 => 0xc718 },
	'primaryafpoint' => { 183 => [0x44,0x7] },
	'primarychromaticities' => { 113 => 0x13f, 462 => 'PrimaryChromaticities' },
	'primaryftp' => { 431 => 'PrimaryFTP' },
	'primaryslot' => { 229 => 0xe7f, 238 => 0xfbf },
	'printim' => { 113 => 0xc4a5 },
	'prioritysetinawb' => { 388 => 0x202b },
	'prioritysetupshutterrelease' => { 174 => 0x1d, 376 => 0x28 },
	'privatertkinfo' => { 433 => 'privateRTKInfo' },
	'processbordercolsleft' => { 131 => 0xc61 },
	'processbordercolsright' => { 131 => 0xc62 },
	'processborderrowsbottom' => { 131 => 0xc64 },
	'processborderrowstop' => { 131 => 0xc63 },
	'processingsoftware' => { 113 => 0xb },
	'processversion' => { 442 => 'ProcessVersion' },
	'producer' => { 283 => 'Producer', 453 => 'Producer' },
	'productcode' => { 456 => 'productCode' },
	'productid' => { 126 => 0x32, 455 => 'productID' },
	'productidtype' => { 455 => 'productIDType' },
	'productinimage' => { 452 => 'ProductInImage' },
	'productinimagedescription' => { 452 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 452 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 452 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 312 => 0x2 },
	'productorserviceconstraints' => { 284 => 'ProductOrServiceConstraints' },
	'profession' => { 456 => 'profession' },
	'profilecalibrationsig' => { 113 => 0xc6f4 },
	'profilecopyright' => { 113 => 0xc6fe },
	'profileembedpolicy' => { 113 => 0xc6fd },
	'profilehuesatmapdata1' => { 113 => 0xc6fa },
	'profilehuesatmapdata2' => { 113 => 0xc6fb },
	'profilehuesatmapdims' => { 113 => 0xc6f9 },
	'profilehuesatmapencoding' => { 113 => 0xc7a3 },
	'profilelooktabledata' => { 113 => 0xc726 },
	'profilelooktabledims' => { 113 => 0xc725 },
	'profilelooktableencoding' => { 113 => 0xc7a4 },
	'profilename' => { 113 => 0xc6f8 },
	'profiletonecurve' => { 113 => 0xc6fc },
	'programiso' => { 297 => 0x3c },
	'programline' => { 313 => '1.1' },
	'programmode' => { 179 => 0x5 },
	'programshift' => { 211 => 0xd },
	'programversion' => { 125 => 0x46 },
	'prohibits' => { 439 => 'prohibits' },
	'projectiontype' => { 429 => 'ProjectionType', 430 => 'ProjectionType' },
	'projectname' => { 466 => 'projectName' },
	'projectref' => { 466 => 'projectRef' },
	'projectrefpath' => { 466 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 466 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 284 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 284 => 'PropertyReleaseStatus' },
	'province-state' => { 125 => 0x5f },
	'publicationdate' => { 456 => 'publicationDate' },
	'publicationdatea-platform' => { 456 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 456 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 456 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 456 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 456 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 452 => 'PublicationEvent' },
	'publicationeventdate' => { 452 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 452 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 452 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 456 => 'publicationName' },
	'publisher' => { 443 => 'publisher' },
	'publishingfrequency' => { 456 => 'publishingFrequency' },
	'pulldown' => { 466 => 'pullDown' },
	'purplehsl' => { 97 => 0x20916 },
	'pxshiftperiphedgenr' => { 421 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 421 => 0x9014 },
	'quality' => { 0 => 0x1, 33 => 0x3, 106 => 0x2, 107 => 0x3002, 121 => 0x1000, 133 => 0x9, 211 => 0x4, 240 => 0x3, 279 => 0x201, 292 => 0x300, 332 => 0x8, 339 => 0x2, 368 => 0x16, 376 => 0x56, 377 => 0x56, 378 => 0xb, 388 => [0x102,0x202e] },
	'quality2' => { 396 => 0x1170, 397 => 0x1174, 398 => 0x1150, 400 => 0x11a8, 401 => 0x1060, 402 => 0x258, 403 => 0x258, 404 => 0x247, 408 => 0x29, 409 => 0x25, 410 => 0x2a },
	'qualitymode' => { 107 => 0x8 },
	'quantizationmethod' => { 127 => 0x78 },
	'quickadjust' => { 253 => 0x2a },
	'quickcontroldialinmeter' => { 78 => 0x703 },
	'quickfix' => { 250 => 0x416391c6 },
	'quickshot' => { 367 => 0x213 },
	'quiettime' => { 131 => 0x188a },
	'rangefinder' => { 262 => '4.1', 263 => '5.1', 264 => '5.1' },
	'rasterizedcaption' => { 125 => 0x7d },
	'rating' => { 113 => 0x4746, 121 => 0x1431, 343 => 0xdf, 388 => 0x2002, 436 => 'rating', 444 => 'rating', 452 => 'Rating', 456 => 'rating', 464 => 'Rating' },
	'ratingpercent' => { 113 => 0x4749, 169 => 'Rating' },
	'ratingratingregion' => { 452 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 452 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 452 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 452 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 452 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 452 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 452 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 452 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 452 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 452 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 452 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 452 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 452 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 452 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 452 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 452 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 452 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 452 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 76 => 0x8, 176 => 0x109, 313 => 0xd },
	'rawbrightnessadj' => { 97 => 0x20001, 102 => 0x38 },
	'rawcoloradj' => { 102 => 0x2e },
	'rawcropbottom' => { 343 => 0xd4 },
	'rawcropleft' => { 343 => 0xd1 },
	'rawcropright' => { 343 => 0xd3 },
	'rawcroptop' => { 343 => 0xd2 },
	'rawcustomsaturation' => { 102 => 0x30 },
	'rawcustomtone' => { 102 => 0x34 },
	'rawdata' => { 365 => 0xa048 },
	'rawdatabyteorder' => { 365 => 0x40 },
	'rawdatacfapattern' => { 365 => 0x50 },
	'rawdatauniqueid' => { 113 => 0xc65d },
	'rawdepth' => { 178 => 0x10 },
	'rawdevartfilter' => { 281 => 0x121 },
	'rawdevautogradation' => { 281 => 0x119 },
	'rawdevcolorspace' => { 280 => 0x108, 281 => 0x109 },
	'rawdevcontrastvalue' => { 280 => 0x106, 281 => 0x105 },
	'rawdeveditstatus' => { 280 => 0x10b },
	'rawdevelopmentprocess' => { 332 => 0x62 },
	'rawdevengine' => { 280 => 0x109, 281 => 0x10b },
	'rawdevexposurebiasvalue' => { 280 => 0x100, 281 => 0x100 },
	'rawdevgradation' => { 281 => 0x112 },
	'rawdevgraypoint' => { 280 => 0x103, 281 => 0x104 },
	'rawdevmemorycoloremphasis' => { 280 => 0x105, 281 => 0x108 },
	'rawdevnoisereduction' => { 280 => 0x10a, 281 => 0x10a },
	'rawdevpicturemode' => { 281 => 0x10c },
	'rawdevpm_bwfilter' => { 281 => 0x110 },
	'rawdevpmcontrast' => { 281 => 0x10e },
	'rawdevpmnoisefilter' => { 281 => 0x120 },
	'rawdevpmpicturetone' => { 281 => 0x111 },
	'rawdevpmsaturation' => { 281 => 0x10d },
	'rawdevpmsharpness' => { 281 => 0x10f },
	'rawdevsaturation3' => { 281 => 0x113 },
	'rawdevsaturationemphasis' => { 280 => 0x104, 281 => 0x107 },
	'rawdevsettings' => { 280 => 0x10c },
	'rawdevsharpnessvalue' => { 280 => 0x107, 281 => 0x106 },
	'rawdevversion' => { 280 => 0x0, 281 => 0x0 },
	'rawdevwbfineadjustment' => { 280 => 0x102, 281 => 0x103 },
	'rawdevwhitebalance' => { 281 => 0x101 },
	'rawdevwhitebalancevalue' => { 280 => 0x101, 281 => 0x102 },
	'rawfile' => { 113 => 0xfe4c },
	'rawfilename' => { 442 => 'RawFileName' },
	'rawfiletype' => { 388 => 0x2029 },
	'rawformat' => { 302 => 0x2d, 341 => 0x10e },
	'rawimagecenter' => { 211 => 0x99 },
	'rawimagedigest' => { 113 => 0xc71c },
	'rawimagesize' => { 332 => 0x39 },
	'rawinfoversion' => { 282 => 0x0 },
	'rawjpgheight' => { 93 => 0x4 },
	'rawjpgquality' => { 54 => 0x6, 93 => 0x1 },
	'rawjpgsize' => { 54 => 0x7, 93 => 0x2 },
	'rawjpgwidth' => { 93 => 0x3 },
	'rawmeasuredrggb' => { 40 => 0x26a, 42 => 0x280, 44 => 0x194, 45 => [0x1ad,0x26b] },
	'rawrppused' => { 436 => 'rawrppused' },
	'rawtopreviewgain' => { 113 => 0xc7a8 },
	'readouttypeactual' => { 131 => 0x1903 },
	'readouttyperequested' => { 131 => 0x1902 },
	'reardisplay' => { 257 => '12.3', 258 => '6.2' },
	'recdevice' => { 452 => 'RecDevice' },
	'recdeviceattlensdescription' => { 452 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 452 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 452 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 452 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 452 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 458 => 'recipeEndingPage' },
	'recipepagerange' => { 458 => 'recipePageRange' },
	'recipesource' => { 458 => 'recipeSource' },
	'recipestartingpage' => { 458 => 'recipeStartingPage' },
	'recipetitle' => { 458 => 'recipeTitle' },
	'recognizedface1age' => { 290 => 0x20 },
	'recognizedface1name' => { 290 => 0x4 },
	'recognizedface1position' => { 290 => 0x18 },
	'recognizedface2age' => { 290 => 0x50 },
	'recognizedface2name' => { 290 => 0x34 },
	'recognizedface2position' => { 290 => 0x48 },
	'recognizedface3age' => { 290 => 0x80 },
	'recognizedface3name' => { 290 => 0x64 },
	'recognizedface3position' => { 290 => 0x78 },
	'recognizedfaceflags' => { 297 => 0x63 },
	'recommendedexposureindex' => { 113 => 0x8832, 447 => 'RecommendedExposureIndex' },
	'record' => { 112 => 'Record' },
	'recordbasisofrecord' => { 112 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 112 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 112 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 112 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 112 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 112 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 174 => 0x4d },
	'recorddynamicproperties' => { 112 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 91 => 0x1804 },
	'recordinformationwithheld' => { 112 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 358 => 0x1000 },
	'recordingmode' => { 106 => 0x1, 339 => 0x1 },
	'recordinstitutioncode' => { 112 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 112 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 107 => 0x3000 },
	'recordownerinstitutioncode' => { 112 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 367 => 0x217 },
	'redbalance' => { 279 => 0x1017, 302 => 0x11, 332 => 0x1c },
	'redcurvelimits' => { 102 => 0x18a },
	'redcurvepoints' => { 101 => 0x2d, 102 => 0x160 },
	'redeyecorrection' => { 254 => 0x0 },
	'redeyeinfo' => { 442 => 'RedEyeInfo' },
	'redeyereduction' => { 174 => 0x41, 376 => 0x6a, 378 => 0x28 },
	'redeyeremoval' => { 297 => 0xb9 },
	'redhsl' => { 97 => 0x20910 },
	'redhue' => { 442 => 'RedHue' },
	'redsaturation' => { 442 => 'RedSaturation' },
	'reductionmatrix1' => { 113 => 0xc625 },
	'reductionmatrix2' => { 113 => 0xc626 },
	'reelname' => { 113 => 0xc789 },
	'reference1' => { 450 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 450 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 113 => 0x214, 462 => 'ReferenceBlackWhite' },
	'referencedate' => { 125 => 0x2f },
	'referencenumber' => { 125 => 0x32 },
	'references' => { 148 => 'References' },
	'referenceservice' => { 125 => 0x2d },
	'regionappliedtodimensions' => { 163 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 163 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 163 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 163 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 163 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 163 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 163 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 163 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 163 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 163 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 163 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 163 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 284 => 'RegionConstraints' },
	'regiondescription' => { 163 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 163 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 163 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 163 => 'Regions' },
	'regioninfodateregionsvalid' => { 166 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 166 => 'RegionInfo' },
	'regioninforegions' => { 166 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 163 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 163 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 166 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 166 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 163 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 163 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 163 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 452 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 452 => 'RegistryId' },
	'registryitemid' => { 452 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 452 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 146 => 'data' },
	'relatedaudiofilename' => { 146 => '1Name' },
	'relatedaudiofiletype' => { 146 => '0Type' },
	'relatedimagefileformat' => { 113 => 0x1000 },
	'relatedimageheight' => { 113 => 0x1002 },
	'relatedimagewidth' => { 113 => 0x1001 },
	'relatedresourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 113 => 0xa004, 446 => 'RelatedSoundFile' },
	'relatedvideofile' => { 160 => 'data' },
	'relatedvideofilename' => { 160 => '1Name' },
	'relatedvideofiletype' => { 160 => '0Type' },
	'relation' => { 443 => 'relation' },
	'relationshipaccordingto' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 110 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 466 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 466 => 'relativeTimestamp' },
	'relativetimestampscale' => { 466 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 466 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 257 => '17.8', 258 => '18.5', 260 => '18.4', 261 => '18.4', 266 => '33.8', 267 => '17.6', 270 => '18.5', 271 => '18.4' },
	'releasedate' => { 125 => 0x1e, 436 => 'ReleaseDate', 466 => 'releaseDate' },
	'releasemode' => { 107 => 0x3001, 228 => 0x184d, 388 => 0xb049 },
	'releasemode2' => { 396 => 0x112c, 397 => [0x112c,0x8], 398 => [0x1108,0x8], 399 => [0x1184,0x8], 400 => [0x1160,0x8], 401 => [0x4,0x1018], 402 => [0x4,0x210], 403 => [0x4,0x210], 404 => [0x4,0x208], 406 => [0x67,0x3f], 407 => [0x73,0x4b], 408 => 0x10, 409 => 0x10, 410 => 0x9, 417 => 0x34 },
	'releasemode3' => { 396 => 0x1128, 397 => 0x1128, 398 => 0x1104, 399 => 0x1180, 400 => 0x115c, 401 => 0x1014, 402 => 0x20c, 403 => 0x20c, 404 => 0x204 },
	'releaseready' => { 452 => 'ReleaseReady' },
	'releasesetting' => { 91 => 0x1016 },
	'releasetime' => { 125 => 0x23, 436 => 'ReleaseTime' },
	'remoteonduration' => { 259 => '3.4', 262 => '17.2', 263 => '18.2', 264 => '18.2', 265 => '18.2', 267 => '18.2', 268 => '4.3', 272 => '19.2' },
	'renditionclass' => { 467 => 'RenditionClass' },
	'renditionof' => { 467 => 'RenditionOf' },
	'renditionofalternatepaths' => { 467 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 467 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 467 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 467 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 467 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 467 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 467 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 467 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 467 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 467 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 467 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 467 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 467 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 467 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 467 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 467 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 467 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 467 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 467 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 467 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 467 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 467 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 467 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 467 => 'RenditionParams' },
	'repeatingflashcount' => { 198 => 0xd, 199 => 0xe, 200 => 0xe, 201 => 0xe, 202 => 0xe, 266 => '17.2', 267 => '24.2', 268 => '9.2', 269 => '24.2', 272 => '25.2' },
	'repeatingflashcountbuilt-in' => { 236 => 0x4db },
	'repeatingflashcountexternal' => { 236 => 0x4c3 },
	'repeatingflashoutput' => { 266 => '17.1', 267 => '24.1', 268 => '9.1', 269 => '24.1', 272 => '25.1' },
	'repeatingflashoutputexternal' => { 236 => 0x4c0 },
	'repeatingflashrate' => { 198 => 0xc, 199 => 0xd, 200 => 0xd, 201 => 0xd, 202 => 0xd, 266 => '18.1', 267 => '25.1', 268 => '10.1', 269 => '25.1', 272 => '26.1' },
	'repeatingflashratebuilt-in' => { 236 => 0x4da },
	'repeatingflashrateexternal' => { 236 => 0x4c2 },
	'requires' => { 439 => 'requires' },
	'resampleparams' => { 466 => 'resampleParams' },
	'resampleparamsquality' => { 466 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 131 => 0xe50 },
	'resamplingkerneldenominators067' => { 131 => 0xe4f },
	'resamplingkerneldenominators100' => { 131 => 0xe51 },
	'resaved' => { 367 => 0x21e },
	'resetblacksegrows' => { 131 => 0x181a },
	'resolution' => { 153 => 'Resolution' },
	'resolutionmode' => { 368 => 0x4 },
	'resolutionunit' => { 113 => 0x128, 128 => 0x2, 462 => 'ResolutionUnit' },
	'resourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 112 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 78 => 0x612 },
	'restrictions' => { 459 => 'restrictions' },
	'retouchareafeather' => { 442 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 442 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 442 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 442 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 442 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 442 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 442 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 442 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 442 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 442 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 442 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 442 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 442 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 442 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 442 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 442 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 442 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 442 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 442 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 442 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 442 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 442 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 442 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 442 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 442 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 442 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 442 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 442 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 442 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 442 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 442 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 442 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 442 => 'RetouchAreas' },
	'retouchareaseed' => { 442 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 442 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 442 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 442 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 211 => 0x9e },
	'retouchinfo' => { 442 => 'RetouchInfo' },
	'retouchnefprocessing' => { 217 => 0x5 },
	'retractlensonpoweroff' => { 78 => 0x814 },
	'reuse' => { 284 => 'Reuse' },
	'reuseallowed' => { 469 => 'ReuseAllowed' },
	'reuseprohibited' => { 459 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 264 => '5.2' },
	'reverseindicators' => { 257 => '12.1', 258 => '6.1', 260 => '6.1', 261 => '6.1', 262 => '4.3', 263 => '5.2', 264 => '5.4', 266 => '33.5', 267 => '5.1', 270 => '6.1', 271 => '6.1', 272 => '6.2' },
	'reverseshutterspeedaperture' => { 264 => '5.3' },
	'revision' => { 444 => 'revision' },
	'rflensmffocusringsensitivity' => { 78 => 0x714 },
	'rgbcurvelimits' => { 102 => 0x238 },
	'rgbcurvepoints' => { 101 => 0x7, 102 => 0x20e },
	'richtextcomment' => { 449 => 'RichTextComment' },
	'ricohdate' => { 357 => 0x6 },
	'ricohimageheight' => { 357 => 0x2 },
	'ricohimagewidth' => { 357 => 0x0 },
	'rightalbedo' => { 432 => 'RightAlbedo' },
	'rightascension' => { 156 => 'RightAscension' },
	'rights' => { 443 => 'rights' },
	'rightsagent' => { 459 => 'rightsAgent' },
	'rightsowner' => { 459 => 'rightsOwner' },
	'roll' => { 109 => 0x8 },
	'rollangle' => { 228 => 0x350b, 229 => 0x2c24, 237 => 0x36f4, 274 => 0x903, 297 => 0x90, 331 => 0x1, 363 => 0x2 },
	'romoperationmode' => { 91 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 90 => 0x3, 97 => 0x10002, 102 => 0x26e, 108 => 'Rotation', 117 => 0x4, 156 => 'Rotation', 172 => [0x65,0x50], 173 => 0x46, 174 => 0x5a, 177 => 0x10, 228 => 0x3693, 229 => 0xca, 235 => '590.1', 250 => 0x76a43207, 297 => 0x30, 313 => '17.2', 343 => 0xd8, 376 => 0x3f, 377 => 0x3f, 387 => 0x10 },
	'routedto' => { 448 => 'RoutedTo' },
	'routing' => { 348 => 'Routing' },
	'routingdestinations' => { 431 => 'RoutingDestinations' },
	'routingexclusions' => { 431 => 'RoutingExclusions' },
	'routingnotes' => { 448 => 'RoutingNotes' },
	'rowsperstrip' => { 113 => 0x116 },
	'rpp' => { 436 => 'rpp' },
	'safetyshift' => { 78 => 0x108 },
	'safetyshiftinavortv' => { 76 => 0x10, 77 => 0x10, 79 => 0xf, 80 => 0x10, 83 => 0x10 },
	'sameexposurefornewaperture' => { 78 => 0x112 },
	'samplebits' => { 146 => 'SampleBits' },
	'samplepagerange' => { 456 => 'samplePageRange' },
	'samplerate' => { 146 => 'SampleRate' },
	'samplesperpixel' => { 113 => 0x115, 302 => 0x8, 462 => 'SamplesPerPixel' },
	'samplestructure' => { 127 => 0x5a },
	'samsungmodelid' => { 365 => 0x3 },
	'sanyoquality' => { 367 => 0x201 },
	'sanyothumbnail' => { 367 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 48 => 0x1, 106 => 0xd, 107 => [0x3013,0x1f], 113 => [0xa409,0xfe55], 121 => 0x1003, 147 => 'Saturation', 171 => 0x1f, 172 => 0x32, 173 => 0x28, 174 => 0x1a, 179 => 0x1, 211 => [0x94,0xaa], 213 => 0x35, 214 => 0x3b, 297 => 0x40, 299 => 0x300d, 332 => 0x1f, 339 => 0xd, 353 => 0x27, 357 => 0x28, 358 => 0x1013, 368 => 0x10, 376 => 0x1e, 377 => 0x1b, 388 => 0x2005, 442 => 'Saturation', 446 => 'Saturation' },
	'saturationadj' => { 97 => 0x20901, 102 => 0x116, 249 => 0x1, 253 => 0x2e, 421 => 0x8016 },
	'saturationadjustmentaqua' => { 442 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 442 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 442 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 442 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 442 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 442 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 442 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 442 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 67 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 66 => 0x68, 67 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 66 => 0x38, 67 => 0x38 },
	'saturationmonochrome' => { 66 => 0x80, 67 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 66 => 0x50, 67 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 66 => 0x20, 67 => 0x20 },
	'saturationsetting' => { 282 => 0x1010, 378 => 0x11, 393 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 66 => 0x8, 67 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 66 => 0x98, 67 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 66 => 0xb0, 67 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 66 => 0xc8, 67 => 0xe0 },
	'saveid' => { 467 => 'SaveID' },
	'sbaanalysiscomplete' => { 131 => 0xc35 },
	'sbablack' => { 131 => 0xc25 },
	'sbagmoffset' => { 131 => 0xc4a },
	'sbagray' => { 131 => 0xc26 },
	'sbagreenmagentabal' => { 131 => 0xc33 },
	'sbahighgray' => { 131 => 0xc46 },
	'sbailloffset' => { 131 => 0xc49 },
	'sbailluminantbal' => { 131 => 0xc34 },
	'sbalowgray' => { 131 => 0xc47 },
	'sbaneutralbal' => { 131 => 0xc32 },
	'sbawhite' => { 131 => 0xc27 },
	'scaletype' => { 466 => 'scaleType' },
	'scanimageenhancer' => { 218 => 0x60 },
	'scanningdirection' => { 127 => 0x64 },
	'scene' => { 451 => 'Scene', 466 => 'scene' },
	'scenearea' => { 277 => 0x211, 279 => 0x1031 },
	'sceneassist' => { 211 => 0x9c },
	'scenecapturetype' => { 113 => 0xa406, 446 => 'SceneCaptureType' },
	'scenedetect' => { 277 => 0x210, 279 => 0x1030 },
	'scenedetectdata' => { 277 => 0x212, 279 => 0x1033 },
	'scenemode' => { 135 => 0xfa02, 176 => 0x100, 211 => 0x8f, 274 => 0x509, 279 => 0x403, 297 => 0x8001, 306 => 0xf, 388 => 0xb023 },
	'scenemodeused' => { 137 => [0x6002,0xf002] },
	'scenerecognition' => { 121 => 0x1425 },
	'sceneselect' => { 367 => 0x21f },
	'scenetype' => { 113 => 0xa301, 446 => 'SceneType' },
	'screentips' => { 257 => '12.7', 258 => '5.3', 266 => '13.1', 267 => '4.4', 270 => '5.4', 272 => '5.1' },
	'scriptversion' => { 131 => 0x1770 },
	'season' => { 452 => 'Season', 455 => 'season' },
	'seasonidentifier' => { 452 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 452 => [\'Season','SeasonName'] },
	'seasonnumber' => { 452 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 431 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 228 => 0x1d0, 237 => 0x1d0 },
	'section' => { 456 => 'section' },
	'securityclassification' => { 113 => 0x9212 },
	'selectableafpoint' => { 78 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 78 => 0x512 },
	'selftimer' => { 33 => 0x2, 297 => 0x2e, 367 => 0x214, 396 => 0x1134, 397 => 0x1134, 398 => 0x1110, 399 => 0x118c, 400 => 0x1168, 401 => 0x1020, 402 => 0x218, 403 => 0x218, 404 => 0x210 },
	'selftimer2' => { 72 => 0x1d },
	'selftimerinterval' => { 267 => '19.2' },
	'selftimermode' => { 113 => 0x882b },
	'selftimershotcount' => { 258 => '20.2', 260 => '20.3', 261 => '20.3', 262 => '18.2', 263 => '19.2', 264 => '19.2', 265 => '19.3', 267 => '19.3', 270 => '20.3', 271 => '20.3', 272 => '20.2' },
	'selftimershotinterval' => { 258 => '20.3', 260 => '20.2', 261 => '20.2', 265 => '19.2', 270 => '20.2', 271 => '20.2' },
	'selftimertime' => { 91 => 0x1806, 174 => 0x1f, 257 => '18.1', 258 => '20.1', 259 => '3.3', 260 => '20.1', 261 => '20.1', 262 => '18.1', 263 => '19.1', 264 => '19.1', 265 => '19.1', 266 => '7.2', 267 => '19.1', 268 => '3.3', 270 => '20.1', 271 => '20.1', 272 => '20.1' },
	'sellingagency' => { 456 => 'sellingAgency' },
	'seminfo' => { 113 => 0x8546 },
	'sensingmethod' => { 113 => 0xa217, 446 => 'SensingMethod' },
	'sensitivityadjust' => { 332 => 0x40 },
	'sensitivitysteps' => { 313 => ['14.3','17.4'], 315 => 0x1 },
	'sensitivitytype' => { 113 => 0x8830, 447 => 'SensitivityType' },
	'sensor' => { 181 => 0x665e },
	'sensorareas' => { 365 => 0xa010 },
	'sensorbitdepth' => { 299 => 0x312d },
	'sensorbluelevel' => { 70 => 0x5 },
	'sensorcalibration' => { 278 => 0x805 },
	'sensorcleaning' => { 84 => 0xd },
	'sensorfullheight' => { 130 => 0xf904 },
	'sensorfullwidth' => { 130 => 0xf903 },
	'sensorheight' => { 130 => 0xf901, 135 => 0xfa21, 178 => 0x8, 299 => 0x312c, 341 => 0x109, 358 => 0x1602 },
	'sensorimageheight' => { 131 => 0x3ee },
	'sensorimagewidth' => { 131 => 0x3ed },
	'sensorleftborder' => { 131 => 0x3eb },
	'sensorleftmargin' => { 341 => 0x10a },
	'sensorpixelsize' => { 211 => 0x9a },
	'sensorredlevel' => { 70 => 0x4 },
	'sensorserialnumber' => { 131 => 0x9ce },
	'sensorsize' => { 147 => 'SensorSize', 332 => 0x35 },
	'sensortemperature' => { 277 => 0x1500, 279 => 0x1007, 337 => 0xc, 341 => 0x210, 368 => [0x39,0x55] },
	'sensortemperature2' => { 337 => 0xe, 341 => 0x211 },
	'sensortopborder' => { 131 => 0x3ec },
	'sensortopmargin' => { 341 => 0x10b },
	'sensorwidth' => { 130 => 0xf900, 135 => 0xfa20, 178 => 0xa, 299 => 0x312b, 341 => 0x108, 358 => 0x1601 },
	'sequence' => { 353 => 0x7, 354 => 0x35 },
	'sequencefilenumber' => { 397 => 0x4, 398 => 0x4, 399 => 0x4, 400 => 0x4, 408 => 0xc, 409 => 0xc, 410 => 0x1a },
	'sequenceimagenumber' => { 397 => 0x0, 398 => 0x0, 399 => 0x0, 400 => 0x0, 408 => 0x8, 409 => 0x8, 410 => 0x12, 417 => 0x24 },
	'sequencelength' => { 408 => 0x22, 409 => 0x1e, 410 => [0x16,0x1e] },
	'sequencename' => { 455 => 'sequenceName' },
	'sequencenumber' => { 72 => 0x9, 107 => 0x301c, 121 => 0x1101, 133 => 0x1d, 236 => 0x51c, 297 => 0x2b, 378 => [0x10c,0x30c], 388 => 0xb04a, 455 => 'sequenceNumber' },
	'sequenceshotinterval' => { 367 => 0x224 },
	'sequencetotalnumber' => { 455 => 'sequenceTotalNumber' },
	'sequentialshot' => { 367 => 0x20e },
	'serialnumber' => { 60 => 0xc, 91 => 0x180b, 113 => [0xa431,0xfde9], 130 => 0xfa04, 132 => 0xfa00, 134 => 0xc354, 135 => 0xfa19, 144 => 0x0, 147 => 'SerialNumber', 211 => [0xa0,0x1d], 275 => 0x101, 279 => [0x404,0x101a], 292 => 0x303, 294 => 0x305, 299 => 0x3103, 332 => 0x229, 341 => 0x102, 342 => 0x407, 353 => 0x15, 354 => 0x4b, 358 => 0x5, 365 => 0xa002, 368 => 0x2, 388 => 0x2031, 438 => 'SerialNumber', 447 => 'BodySerialNumber' },
	'serialnumberformat' => { 60 => 0x15, 91 => 0x183b },
	'series' => { 452 => 'Series' },
	'seriesdatetime' => { 423 => 'SeriesDateTime' },
	'seriesdescription' => { 423 => 'SeriesDescription' },
	'seriesidentifier' => { 452 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 423 => 'SeriesModality' },
	'seriesname' => { 452 => [\'Series','SeriesName'] },
	'seriesnumber' => { 423 => 'SeriesNumber', 456 => 'seriesNumber' },
	'seriestitle' => { 456 => 'seriesTitle' },
	'serviceidentifier' => { 126 => 0x1e },
	'servingsize' => { 458 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 81 => 0x0, 82 => 0x0 },
	'setbuttonwhenshooting' => { 76 => 0x1, 78 => 0x704, 84 => 0xc },
	'setfunctionwhenshooting' => { 79 => 0x0, 80 => 0x1, 83 => 0x1 },
	'setting' => { 455 => 'setting' },
	'shadingcompensation' => { 274 => 0x50c, 297 => 0x8a },
	'shadingcompensation2' => { 278 => 0x1012 },
	'shadow' => { 368 => 0xe },
	'shadowadj' => { 97 => 0x2030b },
	'shadowcorrection' => { 332 => 0x79 },
	'shadowprotection' => { 249 => 0x0 },
	'shadows' => { 113 => 0xfe52, 435 => 'Shadows', 442 => 'Shadows' },
	'shadows2012' => { 442 => 'Shadows2012' },
	'shadowsadj' => { 421 => 0x901a },
	'shadowscale' => { 113 => 0xc633 },
	'shadowtint' => { 442 => 'ShadowTint' },
	'shadowtone' => { 121 => 0x1040 },
	'shakereduction' => { 334 => 0x1, 335 => 0x1 },
	'sharpendetail' => { 442 => 'SharpenDetail' },
	'sharpenedgemasking' => { 442 => 'SharpenEdgeMasking' },
	'sharpening' => { 299 => 0x300b },
	'sharpeningadj' => { 253 => 0x2b },
	'sharpeningkernel' => { 131 => 0x92f },
	'sharpenradius' => { 442 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 70 => 0x2, 106 => 0xb, 107 => [0x3011,0x21], 113 => [0xa40a,0xfe56], 121 => 0x1001, 133 => 0x6b, 142 => 0x37, 147 => 'Sharpness', 171 => 0x21, 172 => 0x30, 173 => 0x26, 174 => 0x18, 179 => 0x3, 211 => 0x6, 213 => 0x32, 214 => 0x33, 279 => 0x100f, 297 => 0x41, 332 => 0x21, 339 => 0xb, 353 => 0x26, 357 => 0x22, 358 => [0x1003,0x1014], 368 => 0x11, 376 => 0x1c, 377 => 0x19, 388 => 0x2006, 417 => 0x52, 442 => 'Sharpness', 446 => 'Sharpness' },
	'sharpnessadj' => { 97 => 0x20310, 102 => 0x25a, 421 => 0x801a },
	'sharpnessadjon' => { 97 => '0x20310.0' },
	'sharpnessauto' => { 67 => 0x94 },
	'sharpnessfactor' => { 279 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 66 => 0x64, 67 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 70 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 66 => 0x34, 67 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 66 => 0x7c, 67 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 66 => 0x4c, 67 => 0x4c },
	'sharpnessovershoot' => { 421 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 66 => 0x1c, 67 => 0x1c },
	'sharpnesssetting' => { 274 => 0x506, 282 => 0x1013, 378 => 0x12, 393 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 66 => 0x4, 67 => 0x4 },
	'sharpnessstrength' => { 97 => 0x20311 },
	'sharpnessthreshold' => { 421 => 0x801d },
	'sharpnessundershoot' => { 421 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 66 => 0x94, 67 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 66 => 0xac, 67 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 66 => 0xc4, 67 => 0xdc },
	'shiftcols' => { 131 => 0xc70 },
	'shootid' => { 455 => 'shootID' },
	'shootingdistance' => { 97 => 0x20701 },
	'shootinginfodisplay' => { 257 => '13.2', 258 => '5.1', 266 => '10.2', 267 => '4.1', 270 => '5.1', 272 => '5.3' },
	'shootinginfomonitorofftime' => { 257 => '26.2', 258 => '22.2', 260 => '22.2', 261 => '22.2', 265 => '21.2', 266 => '9.1', 267 => '21.2', 270 => '22.2', 271 => '22.2', 272 => '22.2' },
	'shootingmode' => { 147 => 'ShootingMode', 211 => 0x89, 297 => 0x1f },
	'shootingmodesetting' => { 259 => '5.1' },
	'shortdescription' => { 444 => 'shortdescription' },
	'shortdocumentid' => { 125 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 78 => 0x80d },
	'shotdate' => { 466 => 'shotDate' },
	'shotday' => { 466 => 'shotDay' },
	'shotlocation' => { 466 => 'shotLocation' },
	'shotname' => { 466 => 'shotName' },
	'shotnumber' => { 466 => 'shotNumber' },
	'shotnumbersincepowerup' => { 392 => 0x44e, 408 => 0x1a, 409 => 0x16, 410 => 0xa },
	'shotnumbersincepowerup2' => { 378 => 0x200 },
	'shotsize' => { 466 => 'shotSize' },
	'shownevent' => { 452 => 'EventExt' },
	'showneventidentifier' => { 452 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 452 => [\'EventExt','EventExtName'] },
	'shutter-aelock' => { 76 => 0x4, 78 => 0x701, 79 => 0x3, 80 => 0x4, 81 => 0x3, 82 => 0x3, 83 => 0x4, 84 => 0x2 },
	'shutteraelbutton' => { 77 => 0x4 },
	'shutterbuttonafonbutton' => { 78 => 0x701 },
	'shuttercount' => { 10 => 0x176, 54 => 0x1, 211 => 0xa7, 219 => [0x6a,0x157,0x24d], 220 => 0x286, 221 => 0x279, 222 => 0x284, 223 => 0x242, 224 => 0x280, 225 => 0x276, 226 => [0x27d,0x27f], 227 => 0x246, 230 => 0x2d6, 231 => 0x321, 232 => 0xbd8, 233 => 0x287, 234 => 0x320, 235 => 0x24a, 236 => 0x5fb, 239 => 0x2d5, 332 => 0x5d, 387 => 0x846, 391 => [0x125,0x14a] },
	'shuttercurtainsync' => { 76 => 0xf, 77 => 0xf, 78 => 0x305, 79 => 0xe, 80 => 0xf, 81 => 0x8, 82 => 0x8, 83 => 0xf, 84 => 0x8 },
	'shuttermode' => { 133 => 0x1b },
	'shutterreleasebuttonae-l' => { 257 => '17.7', 258 => '18.4', 260 => '78.4', 261 => '78.4', 262 => '16.1', 263 => '17.1', 264 => '17.1', 265 => '17.1', 266 => '7.1', 267 => '17.5', 270 => '18.4', 271 => '78.4', 272 => '18.2' },
	'shutterreleasemethod' => { 91 => 0x1010 },
	'shutterreleasenocfcard' => { 76 => 0x2, 77 => 0x2, 84 => 0xf },
	'shutterreleasetiming' => { 91 => 0x1011 },
	'shutterreleasewithoutlens' => { 78 => 0x711 },
	'shutterspeedlock' => { 258 => '38.1', 260 => '38.1', 261 => '38.1', 270 => '38.1', 271 => '38.1' },
	'shutterspeedrange' => { 78 => 0x10c },
	'shutterspeedsetting' => { 174 => 0x6, 376 => 0x2f, 377 => 0x28, 378 => 0x0 },
	'shutterspeedvalue' => { 87 => 0x1, 113 => 0x9201, 279 => 0x1000, 341 => 0x400, 446 => 'ShutterSpeedValue' },
	'shuttertype' => { 121 => 0x1050, 297 => 0x9f },
	'sidecarforextension' => { 454 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 131 => 0xe0d },
	'sigmascalingfactorcamera' => { 131 => 0xe0c },
	'sigmascalingfactorlowres' => { 131 => 0xe0b },
	'sigmasizetable' => { 131 => 0xe0f },
	'similarityindex' => { 125 => 0xe4 },
	'singleframebracketing' => { 174 => 0x21 },
	'skilllevel' => { 458 => 'skillLevel' },
	'skintonecorrection' => { 332 => 0x95 },
	'skiplinetime' => { 131 => 0x184e },
	'slaveflashmeteringsegments' => { 332 => 0x20b },
	'slideshowname' => { 455 => 'slideshowName' },
	'slideshownumber' => { 455 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 455 => 'slideshowTotalNumber' },
	'slowshutter' => { 72 => 0x8 },
	'slowsync' => { 121 => 0x1030 },
	'smartalbumcolor' => { 365 => 0x20 },
	'smartrange' => { 365 => 0xa012 },
	'smileshutter' => { 378 => 0x31 },
	'smileshuttermode' => { 378 => 0x27 },
	'smoothness' => { 113 => 0xfe57, 442 => 'Smoothness' },
	'snapshot' => { 452 => 'SnapshotLink' },
	'snapshotformat' => { 452 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 452 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 452 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 452 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 452 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 436 => 'Snapshots' },
	'snapshotusedvideoframe' => { 452 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 452 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 452 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 452 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 452 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 388 => 0x200f },
	'software' => { 113 => 0x131, 148 => 'Software', 287 => 'Software', 341 => 0x203, 368 => 0x18, 426 => 'Software', 462 => 'Software' },
	'softwareversion' => { 367 => 0x207 },
	'sonydatetime' => { 395 => 0x6, 397 => 0x1b6, 398 => 0x210, 399 => 0x1fe, 400 => 0x22c },
	'sonydatetime2' => { 406 => 0x51 },
	'sonyexposuretime' => { 406 => 0x3a, 407 => 0x46 },
	'sonyexposuretime2' => { 417 => 0xe },
	'sonyfnumber' => { 406 => 0x3c, 407 => 0x48, 417 => 0x14 },
	'sonyimageheight' => { 395 => 0x1a, 408 => 0x44, 409 => 0x3f, 410 => 0x47 },
	'sonyimageheightmax' => { 417 => 0x40 },
	'sonyimagesize' => { 174 => 0x3b, 376 => 0x54, 377 => 0x54, 378 => 0x9 },
	'sonyimagewidth' => { 395 => 0x1c },
	'sonyimagewidthmax' => { 417 => 0x3e },
	'sonyiso' => { 397 => 0x1218, 398 => 0x11f4, 399 => 0x1270, 400 => [0x1254,0x1258,0x1280], 401 => 0x113c, 402 => 0x344, 403 => 0x346, 404 => 0x320, 417 => 0x4 },
	'sonymaxaperture' => { 406 => 0x0, 407 => 0x0 },
	'sonymaxaperturevalue' => { 417 => 0x16 },
	'sonyminaperture' => { 406 => 0x1, 407 => 0x1 },
	'sonymodelid' => { 388 => 0xb001 },
	'sonyquality' => { 174 => 0x3c },
	'sonytimeminsec' => { 407 => 0x61 },
	'source' => { 125 => 0x73, 287 => 'Source', 443 => 'source', 444 => 'source', 454 => 'Source' },
	'sourcecount' => { 430 => 'SourceCount' },
	'sourcedirectoryindex' => { 319 => 0x0 },
	'sourcefileindex' => { 319 => 0x2 },
	'sourcephotoscount' => { 429 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 131 => 0x1390 },
	'spatialfrequencyresponse' => { 446 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 446 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 446 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 446 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 446 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 466 => 'speakerPlacement' },
	'specialeffectlevel' => { 107 => 0x3030 },
	'specialeffectmode' => { 107 => 0x2076 },
	'specialeffectsetting' => { 107 => 0x3031 },
	'specialinstructions' => { 125 => 0x28 },
	'specialmode' => { 279 => 0x200, 367 => 0x200 },
	'specialoccasion' => { 458 => 'specialOccasion' },
	'spectralsensitivity' => { 113 => 0x8824, 446 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 42 => [0x2b9,0x2d0,0x2d4], 44 => 0x1e4, 45 => [0x1fd,0x2dd], 46 => [0x231,0x30f], 47 => 0x31d },
	'speedx' => { 109 => 0x3 },
	'speedy' => { 109 => 0x4 },
	'speedz' => { 109 => 0x5 },
	'spherical' => { 430 => 'Spherical' },
	'splitcolumn' => { 341 => 0x222 },
	'splittoningbalance' => { 442 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 442 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 442 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 442 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 442 => 'SplitToningShadowSaturation' },
	'sport' => { 456 => 'sport' },
	'spotfocuspointx' => { 171 => 0x2d },
	'spotfocuspointy' => { 171 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 78 => 0x107 },
	'sractive' => { 313 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 334 => 0x3 },
	'srhalfpresstime' => { 334 => 0x2 },
	'srresult' => { 334 => 0x0, 335 => 0x0 },
	'stackedimage' => { 274 => 0x804 },
	'standardmatrixcustom' => { 131 => 0x7d4 },
	'standardmatrixdaylight' => { 131 => 0x7d0 },
	'standardmatrixflash' => { 131 => 0x7d3 },
	'standardmatrixfluorescent' => { 131 => 0x7d2 },
	'standardmatrixtungsten' => { 131 => 0x7d1 },
	'standardoutputhighlightpoint' => { 103 => 0x14 },
	'standardoutputsensitivity' => { 113 => 0x8831, 447 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 103 => 0x15 },
	'standardrawcolortone' => { 103 => 0xd },
	'standardrawcontrast' => { 103 => 0xf },
	'standardrawhighlight' => { 103 => 0x75 },
	'standardrawhighlightpoint' => { 103 => 0x12 },
	'standardrawlinear' => { 103 => 0x10 },
	'standardrawsaturation' => { 103 => 0xe },
	'standardrawshadow' => { 103 => 0x7e },
	'standardrawshadowpoint' => { 103 => 0x13 },
	'standardrawsharpness' => { 103 => 0x11 },
	'standardunsharpmaskfineness' => { 103 => 0x94 },
	'standardunsharpmaskstrength' => { 103 => 0x92 },
	'standardunsharpmaskthreshold' => { 103 => 0x96 },
	'standardwhitecustom' => { 131 => 0x838 },
	'standardwhitedaylight' => { 131 => 0x834 },
	'standardwhiteflash' => { 131 => 0x837 },
	'standardwhitefluorescent' => { 131 => 0x836 },
	'standardwhitetungsten' => { 131 => 0x835 },
	'standbytimer' => { 258 => '19.1', 260 => '19.1', 261 => '19.1', 264 => '18.1', 265 => '18.1', 270 => '19.1', 271 => '19.1' },
	'startingpage' => { 456 => 'startingPage' },
	'startmovieshooting' => { 78 => 0x70d },
	'starttimecode' => { 466 => 'startTimecode' },
	'starttimecodetimeformat' => { 466 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 466 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 466 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 466 => 'startTimeSampleSize' },
	'starttimescale' => { 466 => 'startTimeScale' },
	'state' => { 152 => 'State', 297 => 0x6b, 454 => 'State' },
	'status' => { 424 => 'Status', 434 => 'Status' },
	'stereomode' => { 430 => 'StereoMode' },
	'stitched' => { 430 => 'Stitched' },
	'stitchingsoftware' => { 429 => 'StitchingSoftware', 430 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 396 => 0x113e, 397 => 0x113e, 398 => 0x111a, 399 => 0x1196, 400 => 0x1172, 401 => 0x102a, 402 => 0x222, 403 => 0x222, 404 => 0x217, 417 => 0xa },
	'storagemethod' => { 178 => 0x12 },
	'storebyorientation' => { 258 => '46.3', 260 => '47.3', 261 => '47.3', 270 => '47.3', 271 => '47.3' },
	'storylineidentifier' => { 452 => 'StorylineIdentifier' },
	'straightenangle' => { 250 => 0x2fc08431 },
	'streamready' => { 452 => 'StreamReady' },
	'streamtype' => { 167 => 'StreamType' },
	'stretchmode' => { 466 => 'stretchMode' },
	'studydatetime' => { 423 => 'StudyDateTime' },
	'studydescription' => { 423 => 'StudyDescription' },
	'studyid' => { 423 => 'StudyID' },
	'studyphysician' => { 423 => 'StudyPhysician' },
	'styleperiod' => { 452 => 'StylePeriod' },
	'sub-location' => { 125 => 0x5c },
	'subfiledata' => { 155 => 'data' },
	'subfiledirectory' => { 155 => '1Directory' },
	'subfilemimetype' => { 155 => '2MIME' },
	'subfilename' => { 155 => '1Name' },
	'subfileresource' => { 155 => 'rsrc' },
	'subfiletype' => { 113 => 0xfe, 155 => '0Type' },
	'subject' => { 283 => 'Subject', 348 => 'Subject', 443 => 'subject', 453 => 'Subject', 467 => 'subject' },
	'subjectarea' => { 113 => 0x9214, 446 => 'SubjectArea' },
	'subjectcode' => { 451 => 'SubjectCode' },
	'subjectdistance' => { 113 => 0x9206, 133 => 0x3e, 446 => 'SubjectDistance' },
	'subjectdistancerange' => { 113 => 0xa40c, 446 => 'SubjectDistanceRange' },
	'subjectlocation' => { 113 => 0xa214, 446 => 'SubjectLocation' },
	'subjectmotion' => { 260 => '78.2', 261 => '78.2', 271 => '78.2' },
	'subjectprogram' => { 171 => 0x22 },
	'subjectreference' => { 125 => 0xc },
	'sublabels4' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 450 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 450 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 108 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 108 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 108 => 'SubSecModifyDate' },
	'subsectime' => { 113 => 0x9290 },
	'subsectimedigitized' => { 113 => 0x9292 },
	'subsectimeoriginal' => { 113 => 0x9291 },
	'subsection1' => { 456 => 'subsection1' },
	'subsection2' => { 456 => 'subsection2' },
	'subsection3' => { 456 => 'subsection3' },
	'subsection4' => { 456 => 'subsection4' },
	'subselector' => { 258 => '49.1', 260 => '71.1', 261 => '71.1', 271 => '71.1' },
	'subselectorassignment' => { 258 => '48.1' },
	'subselectorcenter' => { 260 => '72.1', 261 => '72.1', 271 => '72.1' },
	'subselectorplusdials' => { 258 => '49.2', 260 => '73.1', 261 => '73.1', 271 => '73.1' },
	'subtitle' => { 456 => 'subtitle' },
	'subversionfilename' => { 450 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 450 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 450 => 'SubVersions' },
	'superimposeddisplay' => { 76 => 0xa, 78 => 0x510, 79 => 0x9, 80 => 0xa, 83 => 0xa, 84 => 0xe },
	'supermacro' => { 60 => 0x1a },
	'supplementalcategories' => { 125 => 0x14, 454 => 'SupplementalCategories' },
	'supplementaltype' => { 127 => 0x37 },
	'supplementdisplayid' => { 456 => 'supplementDisplayID' },
	'supplementstartingpage' => { 456 => 'supplementStartingPage' },
	'supplementtitle' => { 456 => 'supplementTitle' },
	'supplychainsource' => { 452 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 452 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 452 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 313 => 0x14 },
	'swatchcoloranta' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 471 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 471 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 471 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 471 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 471 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 297 => 0x93, 378 => 0x33 },
	'sweeppanoramafieldofview' => { 297 => 0x94 },
	'sweeppanoramasize' => { 378 => 0x32 },
	'switchtoregisteredafpoint' => { 77 => 0x12, 78 => 0x50a },
	'syncreleasemode' => { 260 => '77.1', 261 => '77.1', 271 => '77.1' },
	'system' => { 341 => 0x204 },
	'tagged' => { 343 => 0xdd, 344 => 'Tagged', 436 => 'tagged' },
	'tagslist' => { 445 => 'TagsList' },
	'tagstructure' => { 450 => 'TagStructure' },
	'takenumber' => { 466 => 'takeNumber' },
	'tapename' => { 466 => 'tapeName' },
	'targetaperture' => { 72 => 0x4 },
	'targetcompressionratio' => { 89 => 0x1 },
	'targetdistancesetting' => { 91 => 0x1807 },
	'targetexposuretime' => { 72 => 0x5 },
	'targetimagetype' => { 91 => 0x100a },
	'targetprinter' => { 113 => 0x151 },
	'taxon' => { 112 => 'Taxon' },
	'taxonacceptednameusage' => { 112 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 112 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 112 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 112 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 112 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 112 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 112 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 112 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 112 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 112 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 112 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 112 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 112 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 112 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 112 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 112 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 112 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 112 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 112 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 112 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 112 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 112 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 112 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 112 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 112 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 112 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 112 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 112 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 112 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 112 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 112 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 112 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 112 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 131 => 0x196f },
	'tda1edgepolarity' => { 131 => 0x1971 },
	'tda1gain' => { 131 => 0x1970 },
	'tda1offset' => { 131 => 0x196e },
	'tda2bandwidth' => { 131 => 0x1979 },
	'tda2edgepolarity' => { 131 => 0x197b },
	'tda2gain' => { 131 => 0x197a },
	'tda2offset' => { 131 => 0x1978 },
	'tda3bandwidth' => { 131 => 0x1983 },
	'tda3edgepolarity' => { 131 => 0x1985 },
	'tda3gain' => { 131 => 0x1984 },
	'tda3offset' => { 131 => 0x1982 },
	'tda4bandwidth' => { 131 => 0x198d },
	'tda4edgepolarity' => { 131 => 0x198f },
	'tda4gain' => { 131 => 0x198e },
	'tda4offset' => { 131 => 0x198c },
	'teaser' => { 456 => 'teaser' },
	'teleconverter' => { 176 => 0x105, 388 => 0x105 },
	'tempampgainx100' => { 131 => 0x1914 },
	'tempo' => { 466 => 'tempo' },
	'temporalcoverage' => { 452 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 452 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 452 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 284 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 284 => 'TermsAndConditionsURL' },
	'testname' => { 114 => 'TestName' },
	'textencoding' => { 210 => 0x4 },
	'textlayername' => { 454 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 454 => 'TextLayers' },
	'textlayertext' => { 454 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 297 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 260 => '1.3', 261 => '1.3', 271 => '1.4' },
	'three-dtrackingwatcharea' => { 260 => '78.1', 261 => '78.1', 271 => '78.1' },
	'thresholding' => { 113 => 0x107 },
	'thumbnailfilename' => { 91 => 0x817 },
	'thumbnailformat' => { 464 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 135 => 0xfa55, 464 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 91 => 0x2008, 108 => 'ThumbnailImage', 116 => 0x3, 158 => 'data', 279 => 0x100, 464 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 158 => '1Name' },
	'thumbnailimagesize' => { 158 => 'ImageSize' },
	'thumbnailimagetype' => { 158 => '0Type' },
	'thumbnailimagevalidarea' => { 60 => 0x13 },
	'thumbnaillength' => { 113 => 0x202 },
	'thumbnailoffset' => { 113 => 0x201 },
	'thumbnails' => { 464 => 'Thumbnails' },
	'thumbnailwidth' => { 135 => 0xfa54, 464 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 456 => 'ticker' },
	'tiffhandling' => { 442 => 'TIFFHandling' },
	'tiffmeteringimage' => { 177 => 0x104c, 387 => 0x1110 },
	'tilelength' => { 113 => 0x143 },
	'tilewidth' => { 113 => 0x142 },
	'time' => { 131 => 0x401, 332 => 0x7 },
	'timecodes' => { 113 => 0xc763 },
	'timecreated' => { 125 => 0x3c, 133 => 0x14, 142 => 0x10, 344 => 'TimeCreated' },
	'timelapseshotnumber' => { 300 => 0x10 },
	'timeperiod' => { 456 => 'timePeriod' },
	'timerfunctionbutton' => { 259 => '5.2', 262 => '12.1', 263 => '13.1' },
	'timerlength' => { 78 => 0x80c },
	'timerrecording' => { 297 => 0x96 },
	'timescaleparams' => { 466 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 466 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 466 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 466 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 126 => 0x50 },
	'timeshot' => { 431 => 'TimeShot' },
	'timesignature' => { 466 => 'timeSignature' },
	'timesincepoweron' => { 297 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 273 => 0x8, 287 => 'TimeStamp', 297 => 0xaf, 430 => 'Timestamp', 437 => 'Timestamp', 450 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 73 => 0x1, 242 => 0x0, 361 => 0xa },
	'timezonecity' => { 73 => 0x2 },
	'timezonecode' => { 94 => 0x1 },
	'timezoneinfo' => { 94 => 0x2 },
	'timezoneoffset' => { 113 => 0x882a },
	'tint' => { 442 => 'Tint' },
	'title' => { 148 => 'Title', 283 => 'Title', 287 => 'Title', 297 => 0x65, 348 => 'Title', 443 => 'title', 453 => 'Title', 464 => 'Title' },
	'tonecomp' => { 211 => 0x81 },
	'tonecurve' => { 70 => 0x1, 332 => 0x402, 442 => 'ToneCurve' },
	'tonecurveactive' => { 102 => 0x110 },
	'tonecurveadobergb' => { 365 => 0xa043 },
	'tonecurveadobergbdefault' => { 365 => 0xa041 },
	'tonecurveblue' => { 442 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 421 => 0x9003 },
	'tonecurvebluey' => { 421 => 0x9007 },
	'tonecurvebrightness' => { 97 => 0x20410 },
	'tonecurvebrightnessx' => { 421 => 0x9000 },
	'tonecurvebrightnessy' => { 421 => 0x9004 },
	'tonecurvecolorspace' => { 101 => 0x0 },
	'tonecurvecontrast' => { 97 => 0x20411 },
	'tonecurvegreen' => { 442 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 421 => 0x9002 },
	'tonecurvegreeny' => { 421 => 0x9006 },
	'tonecurveinputrange' => { 101 => 0x3 },
	'tonecurveinterpolation' => { 102 => 0x159 },
	'tonecurvemode' => { 102 => 0x113 },
	'tonecurvename' => { 442 => 'ToneCurveName' },
	'tonecurvename2012' => { 442 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 97 => '0x20400.1' },
	'tonecurveoutputrange' => { 101 => 0x5 },
	'tonecurveprofilename' => { 131 => 0x1391 },
	'tonecurveproperty' => { 102 => 0x3c },
	'tonecurvepv2012' => { 442 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 442 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 442 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 442 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 442 => 'ToneCurveRed' },
	'tonecurveredx' => { 421 => 0x9001 },
	'tonecurveredy' => { 421 => 0x9005 },
	'tonecurves' => { 332 => 0x403 },
	'tonecurveshape' => { 101 => 0x1 },
	'tonecurvesrgb' => { 365 => 0xa042 },
	'tonecurvesrgbdefault' => { 365 => 0xa040 },
	'tonecurvex' => { 101 => 0xa },
	'tonecurvey' => { 101 => 0xb },
	'tonelevel' => { 274 => 0x52e },
	'tonemapstrength' => { 442 => 'ToneMapStrength' },
	'toningeffect' => { 54 => 0xf, 211 => 0xb3, 213 => 0x38, 214 => 0x40, 358 => 0x1015 },
	'toningeffectauto' => { 67 => 0xa4 },
	'toningeffectfaithful' => { 66 => 0x74, 67 => 0x74 },
	'toningeffectlandscape' => { 66 => 0x44, 67 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 66 => 0x8c, 67 => 0x8c },
	'toningeffectneutral' => { 66 => 0x5c, 67 => 0x5c },
	'toningeffectportrait' => { 66 => 0x2c, 67 => 0x2c },
	'toningeffectstandard' => { 66 => 0x14, 67 => 0x14 },
	'toningeffectuserdef1' => { 66 => 0xa4, 67 => 0xbc },
	'toningeffectuserdef2' => { 66 => 0xbc, 67 => 0xd4 },
	'toningeffectuserdef3' => { 66 => 0xd4, 67 => 0xec },
	'toningsaturation' => { 213 => 0x39, 214 => 0x41 },
	'totalzoom' => { 133 => 0x62 },
	'touchae' => { 297 => 0xab },
	'trackcreatedate' => { 352 => 0x1 },
	'trackmodifydate' => { 352 => 0x2 },
	'tracknumber' => { 466 => 'trackNumber' },
	'tracks' => { 466 => 'Tracks' },
	'tracksframerate' => { 466 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 466 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 466 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 466 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 466 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 466 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 466 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 466 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 466 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 466 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 466 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 466 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 466 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 466 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 466 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 466 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 466 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 155 => 'zmie' },
	'transcript' => { 452 => 'Transcript' },
	'transcriptlink' => { 452 => 'TranscriptLink' },
	'transcriptlinklink' => { 452 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 452 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 113 => 0x12d, 462 => 'TransferFunction' },
	'transfertimenormal' => { 131 => 0x1888 },
	'transfertimetest' => { 131 => 0x1889 },
	'transform' => { 297 => [0x8012,0x59] },
	'transmissionreference' => { 454 => 'TransmissionReference' },
	'trapped' => { 283 => 'Trapped', 453 => 'Trapped' },
	'trashbuttonfunction' => { 78 => 0x710 },
	'travelday' => { 297 => 0x36 },
	'triggermode' => { 353 => 0x6, 354 => 0x34 },
	'tstop' => { 113 => 0xc772 },
	'ttl_da_adown' => { 320 => 0x5 },
	'ttl_da_aup' => { 320 => 0x4 },
	'ttl_da_bdown' => { 320 => 0x7 },
	'ttl_da_bup' => { 320 => 0x6 },
	'tungstenawb' => { 310 => 0x1 },
	'tvexposuretimesetting' => { 313 => 0x12 },
	'type' => { 443 => 'type', 461 => 'type' },
	'typestatus' => { 112 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 113 => 0xc614 },
	'uniquedocumentid' => { 125 => 0xbb },
	'uniquematrixauto' => { 131 => 0x7e9 },
	'uniquematrixcustom' => { 131 => 0x7e8 },
	'uniquematrixdaylight' => { 131 => 0x7e4 },
	'uniquematrixflash' => { 131 => 0x7e7 },
	'uniquematrixfluorescent' => { 131 => 0x7e6 },
	'uniquematrixtungsten' => { 131 => 0x7e5 },
	'uniqueobjectname' => { 126 => 0x64 },
	'units' => { 426 => 'Units' },
	'unknownblock' => { 332 => 0x405 },
	'unknownblock1' => { 278 => 0x635 },
	'unknownblock2' => { 278 => 0x636 },
	'unknownblock3' => { 278 => 0x1103 },
	'unknownblock4' => { 278 => 0x1104 },
	'unknowncontrast' => { 103 => 0x45 },
	'unknowndate' => { 341 => 0x212 },
	'unknownev' => { 131 => 0x1 },
	'unknownlinear' => { 103 => 0x46 },
	'unknownnumber' => { 91 => 0x180b },
	'unknownoutputhighlightpoint' => { 103 => 0x4a },
	'unknownoutputshadowpoint' => { 103 => 0x4b },
	'unknownrawhighlight' => { 103 => 0x7b },
	'unknownrawhighlightpoint' => { 103 => 0x48 },
	'unknownrawshadow' => { 103 => 0x84 },
	'unknownrawshadowpoint' => { 103 => 0x49 },
	'unknownsharpness' => { 103 => 0x47 },
	'unknowntemperature' => { 115 => 0x4 },
	'unsharp1color' => { 255 => 0x13 },
	'unsharp1halowidth' => { 255 => 0x19 },
	'unsharp1intensity' => { 255 => 0x17 },
	'unsharp1threshold' => { 255 => 0x1b },
	'unsharp2color' => { 255 => 0x2e },
	'unsharp2halowidth' => { 255 => 0x34 },
	'unsharp2intensity' => { 255 => 0x32 },
	'unsharp2threshold' => { 255 => 0x36 },
	'unsharp3color' => { 255 => 0x49 },
	'unsharp3halowidth' => { 255 => 0x4f },
	'unsharp3intensity' => { 255 => 0x4d },
	'unsharp3threshold' => { 255 => 0x51 },
	'unsharp4color' => { 255 => 0x64 },
	'unsharp4halowidth' => { 255 => 0x6a },
	'unsharp4intensity' => { 255 => 0x68 },
	'unsharp4threshold' => { 255 => 0x6c },
	'unsharpcount' => { 255 => 0x0 },
	'unsharpmask' => { 103 => 0x90, 250 => 0x76a43200 },
	'unsharpmaskfineness' => { 97 => 0x20309 },
	'unsharpmaskstrength' => { 97 => 0x20308 },
	'unsharpmaskthreshold' => { 97 => 0x2030a },
	'uprightcentermode' => { 442 => 'UprightCenterMode' },
	'uprightcenternormx' => { 442 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 442 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 442 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 442 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 442 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 442 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 442 => 'UprightPreview' },
	'uprighttransform_0' => { 442 => 'UprightTransform_0' },
	'uprighttransform_1' => { 442 => 'UprightTransform_1' },
	'uprighttransform_2' => { 442 => 'UprightTransform_2' },
	'uprighttransform_3' => { 442 => 'UprightTransform_3' },
	'uprighttransform_4' => { 442 => 'UprightTransform_4' },
	'uprighttransform_5' => { 442 => 'UprightTransform_5' },
	'uprighttransformcount' => { 442 => 'UprightTransformCount' },
	'uprightversion' => { 442 => 'UprightVersion' },
	'urgency' => { 125 => 0xa, 454 => 'Urgency' },
	'url' => { 148 => 'URL', 287 => 'URL', 346 => 0x40b, 456 => 'url' },
	'url_list' => { 346 => 0x41e },
	'urla-platform' => { 456 => [\'url','urlA-platform'] },
	'urlurl' => { 456 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 78 => 0x10a },
	'usableshootingmodes' => { 78 => 0x109 },
	'usage' => { 457 => 'usage' },
	'usageterms' => { 470 => 'UsageTerms' },
	'useguidelines' => { 439 => 'useGuidelines' },
	'usepanoramaviewer' => { 429 => 'UsePanoramaViewer' },
	'usercomment' => { 91 => 0x805, 113 => 0x9286, 446 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 66 => 0xd8, 67 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 66 => 0xda, 67 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 66 => 0xdc, 67 => 0xf4 },
	'userfields' => { 434 => 'UserFields' },
	'userlabel' => { 353 => 0x2b, 354 => 0x5a },
	'userprofile' => { 292 => 0x302, 299 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 77 => 0x7, 78 => 0x501 },
	'uspsnumber' => { 456 => 'uspsNumber' },
	'utmeasting' => { 159 => 'Easting' },
	'utmmapdatum' => { 159 => 'Datum' },
	'utmnorthing' => { 159 => 'Northing' },
	'utmzone' => { 159 => 'Zone' },
	'uv-irfiltercorrection' => { 292 => 0x325 },
	'validbits' => { 278 => 0x611, 279 => 0x102c },
	'validpixeldepth' => { 282 => 0x611 },
	'variablelowpassfilter' => { 388 => 0x2028 },
	'variousmodes' => { 133 => 0x26 },
	'variousmodes2' => { 133 => 0x3a },
	'variprogram' => { 211 => 0xab },
	'varraydacnominalvalues' => { 131 => 0x191e },
	'version' => { 121 => 0x0, 348 => 'Version', 442 => 'Version' },
	'versioncreatedate' => { 421 => 0xd100 },
	'versionid' => { 467 => 'VersionID' },
	'versionidentifier' => { 456 => 'versionIdentifier' },
	'versionmodifydate' => { 421 => 0xd101 },
	'versions' => { 467 => 'Versions' },
	'versionscomments' => { 467 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 467 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 467 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 467 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 467 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 467 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 467 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 467 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 467 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 467 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 467 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 257 => '3.2', 258 => '47.2', 260 => '79.1' },
	'verticalclockoverlaps' => { 131 => 0x412 },
	'verticalfuncbutton' => { 258 => '42.2', 260 => '67.1' },
	'verticalfuncbuttonplusdials' => { 258 => '43.1' },
	'verticalfuncplusdials' => { 260 => '68.1' },
	'verticalmultiselector' => { 258 => '42.1', 260 => '66.1', 261 => '66.1', 271 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 78 => [0x510,0x51d] },
	'vibrance' => { 435 => 'Vibrance', 442 => 'Vibrance' },
	'vibrationreduction' => { 219 => [0x75,0x82,0x1ae], 227 => '586.1', 235 => '590.2', 241 => 0x4 },
	'videoalphamode' => { 466 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 466 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 466 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 466 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 452 => 'videoBitRate' },
	'videobitratemode' => { 452 => 'videoBitRateMode' },
	'videoburstmode' => { 297 => 0xbb },
	'videocodec' => { 63 => 0x74 },
	'videocolorspace' => { 466 => 'videoColorSpace' },
	'videocompressor' => { 466 => 'videoCompressor' },
	'videodisplayaspectratio' => { 452 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 452 => 'videoEncodingProfile' },
	'videofieldorder' => { 466 => 'videoFieldOrder' },
	'videoframerate' => { 466 => 'videoFrameRate' },
	'videoframesize' => { 466 => 'videoFrameSize' },
	'videoframesizeh' => { 466 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 466 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 466 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 466 => 'videoModDate' },
	'videopixelaspectratio' => { 466 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 466 => 'videoPixelDepth' },
	'videoquality' => { 107 => 0x4003 },
	'videoshottype' => { 452 => 'VideoShotType' },
	'videoshottypeidentifier' => { 452 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 452 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 452 => 'videoStreamsCount' },
	'viewfinder' => { 341 => 0x455 },
	'viewfinderdisplay' => { 257 => '12.4', 258 => '6.3' },
	'viewfinderwarning' => { 257 => '13.4', 267 => '3.5', 268 => '6.2', 272 => '4.4' },
	'viewfinderwarnings' => { 78 => 0x40a },
	'viewinfoduringexposure' => { 78 => 0x407 },
	'viewingmode' => { 378 => 0x2f, 393 => 0x18 },
	'viewingmode2' => { 378 => [0x85,0x285] },
	'viewpoint' => { 455 => 'viewpoint' },
	'vignetteamount' => { 442 => 'VignetteAmount' },
	'vignettecontrol' => { 211 => 0x2a, 250 => 0x76a43205 },
	'vignettecontrolintensity' => { 250 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 438 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 442 => 'VignetteMidpoint' },
	'vignetting' => { 358 => 0x1011, 365 => 0xa052 },
	'vignettingcorrection' => { 113 => 0x7031, 365 => 0xa053, 388 => 0x2011 },
	'vignettingcorrparams' => { 113 => 0x7032, 416 => 0x64a, 417 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 365 => 0xa054 },
	'visualcolor' => { 452 => 'VisualColour' },
	'visualtechnique' => { 455 => 'visualTechnique' },
	'voicememo' => { 367 => 0x216 },
	'volume' => { 456 => 'volume' },
	'vr_0x66' => { 219 => 0x66 },
	'vrdoffset' => { 60 => 0xd0 },
	'vrmode' => { 241 => 0x6 },
	'waterdepth' => { 113 => 0x9403, 447 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 177 => 0x19a },
	'wb_bluelevel6500k' => { 177 => 0x18a },
	'wb_bluelevelcustom' => { 177 => 0x18e },
	'wb_bluelevelscloudy' => { 177 => 0x106 },
	'wb_bluelevelsdaylight' => { 177 => 0xea },
	'wb_bluelevelsflash' => { 177 => 0x122 },
	'wb_bluelevelsfluorescent' => { 177 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 177 => 0x254 },
	'wb_bluelevelsshade' => { 177 => 0x176 },
	'wb_bluelevelstungsten' => { 177 => 0xce },
	'wb_gbrglevels' => { 177 => 0xae, 180 => 0x4 },
	'wb_glevel' => { 278 => 0x11f },
	'wb_glevel3000k' => { 278 => 0x113 },
	'wb_glevel3300k' => { 278 => 0x114 },
	'wb_glevel3600k' => { 278 => 0x115 },
	'wb_glevel3900k' => { 278 => 0x116 },
	'wb_glevel4000k' => { 278 => 0x117 },
	'wb_glevel4300k' => { 278 => 0x118 },
	'wb_glevel4500k' => { 278 => 0x119 },
	'wb_glevel4800k' => { 278 => 0x11a },
	'wb_glevel5300k' => { 278 => 0x11b },
	'wb_glevel6000k' => { 278 => 0x11c },
	'wb_glevel6600k' => { 278 => 0x11d },
	'wb_glevel7500k' => { 278 => 0x11e },
	'wb_grbglevels' => { 190 => 0x0 },
	'wb_rbgglevels' => { 187 => 0x0 },
	'wb_rblevels' => { 191 => 0x270, 211 => 0xc, 278 => 0x100 },
	'wb_rblevels1' => { 303 => 0x2 },
	'wb_rblevels2' => { 303 => 0x5 },
	'wb_rblevels3' => { 303 => 0x8 },
	'wb_rblevels3000k' => { 278 => 0x102 },
	'wb_rblevels3300k' => { 278 => 0x103 },
	'wb_rblevels3500k' => { 177 => 0x430 },
	'wb_rblevels3600k' => { 278 => 0x104 },
	'wb_rblevels3900k' => { 278 => 0x105 },
	'wb_rblevels4' => { 303 => 0xb },
	'wb_rblevels4000k' => { 278 => 0x106 },
	'wb_rblevels4300k' => { 278 => 0x107 },
	'wb_rblevels4500k' => { 278 => 0x108 },
	'wb_rblevels4800k' => { 278 => 0x109 },
	'wb_rblevels5' => { 303 => 0xe },
	'wb_rblevels5300k' => { 278 => 0x10a },
	'wb_rblevels6' => { 303 => 0x11 },
	'wb_rblevels6000k' => { 278 => 0x10b },
	'wb_rblevels6500k' => { 177 => 0x420 },
	'wb_rblevels6600k' => { 278 => 0x10c },
	'wb_rblevels7' => { 303 => 0x14 },
	'wb_rblevels7500k' => { 278 => 0x10d },
	'wb_rblevelsauto' => { 191 => 0x272, 282 => 0x110 },
	'wb_rblevelscloudy' => { 177 => 0x3f0, 179 => 0x10, 191 => 0x296, 282 => 0x121 },
	'wb_rblevelscoolwhitef' => { 177 => 0x308, 179 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 282 => 0x132 },
	'wb_rblevelscustom' => { 177 => 0x424 },
	'wb_rblevelscwb1' => { 278 => 0x10e },
	'wb_rblevelscwb2' => { 278 => 0x10f },
	'wb_rblevelscwb3' => { 278 => 0x110 },
	'wb_rblevelscwb4' => { 278 => 0x111 },
	'wb_rblevelsdaylight' => { 177 => [0x3ec,0x528], 179 => 0xc, 191 => 0x274 },
	'wb_rblevelsdaylightf' => { 179 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 282 => 0x130 },
	'wb_rblevelsdaywhitef' => { 179 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 282 => 0x131 },
	'wb_rblevelseveningsunlight' => { 282 => 0x124 },
	'wb_rblevelsfineweather' => { 282 => 0x122 },
	'wb_rblevelsflash' => { 177 => [0x3f4,0x304], 179 => 0x18, 191 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 191 => 0x290 },
	'wb_rblevelsincandescent' => { 191 => 0x282 },
	'wb_rblevelsshade' => { 177 => 0x418, 179 => 0x20, 191 => 0x2b2, 282 => 0x120 },
	'wb_rblevelstungsten' => { 177 => 0x3e8, 179 => 0x8, 282 => 0x123 },
	'wb_rblevelsunknown' => { 179 => 0x1c },
	'wb_rblevelsused' => { 282 => 0x100 },
	'wb_rblevelswhitef' => { 179 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 282 => 0x133 },
	'wb_redlevel3500k' => { 177 => 0x198 },
	'wb_redlevel6500k' => { 177 => 0x188 },
	'wb_redlevelcustom' => { 177 => 0x18c },
	'wb_redlevelscloudy' => { 177 => 0xf8 },
	'wb_redlevelsdaylight' => { 177 => 0xdc },
	'wb_redlevelsflash' => { 177 => 0x114 },
	'wb_redlevelsfluorescent' => { 177 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 177 => 0x1be },
	'wb_redlevelsshade' => { 177 => 0x168 },
	'wb_redlevelstungsten' => { 177 => 0xc0 },
	'wb_rgbglevels' => { 189 => 0x0 },
	'wb_rgblevels' => { 177 => [0x546,0x96], 293 => 0xd, 294 => 0x413, 299 => 0x3036, 341 => 0x107, 396 => 0x117c, 397 => 0x1180, 398 => 0x115c, 399 => 0x11d8, 400 => 0x11b4, 401 => 0x106c, 402 => 0x264, 403 => 0x264, 404 => 0x252 },
	'wb_rgblevels1' => { 304 => 0x2 },
	'wb_rgblevels2' => { 304 => 0x6 },
	'wb_rgblevels3' => { 304 => 0xa },
	'wb_rgblevels4' => { 304 => 0xe },
	'wb_rgblevels5' => { 304 => 0x12 },
	'wb_rgblevels6' => { 304 => 0x16 },
	'wb_rgblevels7' => { 304 => 0x1a },
	'wb_rgbmuldaylight' => { 131 => 0x852 },
	'wb_rgbmulflash' => { 131 => 0x855 },
	'wb_rgbmulfluorescent' => { 131 => 0x854 },
	'wb_rgbmultungsten' => { 131 => 0x853 },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 180 => 0x4, 188 => 0x0, 192 => 0x13e8, 193 => 0x38 },
	'wb_rggblevelsasshot' => { 37 => 0x0, 38 => 0x0, 39 => 0x19, 40 => 0x22, 41 => 0x3f, 44 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x47 },
	'wb_rggblevelsauto' => { 34 => 0x1, 37 => 0x5, 38 => 0x8, 39 => 0x1e, 40 => 0x18, 41 => 0x44, 44 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x4c, 192 => 0x1478, 193 => 0x114, 365 => 0xa022 },
	'wb_rggblevelsblack' => { 365 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 37 => 0x1e, 38 => 0x30, 39 => 0x2d, 40 => 0x31, 41 => 0x58, 44 => 0x71, 45 => 0x8a, 46 => 0x8f, 47 => 0x92, 192 => 0x1408, 193 => 0x60, 332 => 0x20f, 340 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 41 => 0x80, 192 => 0x1468, 193 => 0x100 },
	'wb_rggblevelscustom1' => { 39 => 0x41 },
	'wb_rggblevelscustom2' => { 39 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 37 => 0x14, 38 => 0x20, 39 => 0x23, 40 => 0x27, 41 => 0x4e, 44 => 0x67, 45 => 0x80, 46 => 0x85, 47 => 0x88, 192 => 0x13f8, 193 => 0x4c, 332 => 0x20d, 340 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 37 => 0x32, 38 => 0x50, 39 => 0x3c, 40 => 0x45, 41 => 0x6c, 44 => 0x85, 45 => 0x9e, 46 => 0xa3, 47 => 0xa6, 192 => 0x1448, 332 => 0x214, 340 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 37 => 0x28, 38 => 0x40, 39 => 0x37, 40 => 0x3b, 41 => 0x62, 44 => 0x7b, 45 => 0x94, 46 => 0x99, 47 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 193 => 0xc4, 332 => 0x211, 340 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 340 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 193 => 0xb0, 332 => 0x212, 340 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 192 => 0x1438, 193 => 0x9c, 332 => 0x213, 340 => 0x38 },
	'wb_rggblevelshtmercury' => { 193 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 365 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 365 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 37 => 0x2d, 38 => 0x48, 40 => 0x40, 41 => 0x67, 44 => 0x80, 45 => 0x99, 46 => 0x9e, 47 => 0xa1 },
	'wb_rggblevelsmeasured' => { 37 => 0xa, 38 => 0x10, 41 => 0x49, 44 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x51 },
	'wb_rggblevelspc1' => { 40 => 0x90, 41 => 0x71 },
	'wb_rggblevelspc2' => { 40 => 0x95, 41 => 0x76 },
	'wb_rggblevelspc3' => { 40 => 0x9a, 41 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 37 => 0x19, 38 => 0x28, 39 => 0x28, 40 => 0x2c, 41 => 0x53, 44 => 0x6c, 45 => 0x85, 46 => 0x8a, 47 => 0x8d, 193 => 0x74, 332 => 0x20e, 340 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 37 => 0x23, 38 => 0x38, 39 => 0x32, 40 => 0x36, 41 => 0x5d, 44 => 0x76, 45 => 0x8f, 46 => 0x94, 47 => 0x97, 192 => 0x1428, 193 => 0x88, 332 => 0x210, 340 => 0x1d },
	'wb_rggblevelsuncorrected' => { 365 => 0xa021 },
	'wb_rggblevelsunknown' => { 37 => 0xf, 38 => 0x18, 40 => 0x1d, 44 => 0x4e, 45 => 0x4e, 46 => 0x4e, 47 => 0x56, 340 => 0x53 },
	'wb_rggblevelsunknown10' => { 37 => 0x5f, 38 => 0x98, 40 => 0x72, 44 => 0x9e, 45 => 0x7b, 46 => 0x7b, 47 => 0x83 },
	'wb_rggblevelsunknown11' => { 37 => 0x64, 38 => 0xa0, 40 => 0x77, 44 => 0xa3, 45 => 0xa3, 46 => 0x80, 47 => 0xab },
	'wb_rggblevelsunknown12' => { 37 => 0x69, 38 => 0xa8, 40 => 0x7c, 44 => 0xa8, 45 => 0xa8, 46 => 0xa8, 47 => 0xb0 },
	'wb_rggblevelsunknown13' => { 37 => 0x6e, 38 => 0xb0, 40 => 0x81, 44 => 0xad, 45 => 0xad, 46 => 0xad, 47 => 0xb5 },
	'wb_rggblevelsunknown14' => { 40 => 0x86, 44 => 0xb2, 45 => 0xb2, 46 => 0xb2, 47 => 0xba },
	'wb_rggblevelsunknown15' => { 40 => 0x8b, 44 => 0xb7, 45 => 0xb7, 46 => 0xb7, 47 => 0xbf },
	'wb_rggblevelsunknown16' => { 40 => 0x9f, 45 => 0xbc, 46 => 0xbc, 47 => 0xc4 },
	'wb_rggblevelsunknown17' => { 45 => 0xc1, 46 => 0xc1, 47 => 0xc9 },
	'wb_rggblevelsunknown18' => { 45 => 0xc6, 46 => 0xc6, 47 => 0xce },
	'wb_rggblevelsunknown19' => { 45 => 0xcb, 46 => 0xcb, 47 => 0xd3 },
	'wb_rggblevelsunknown2' => { 37 => 0x37, 38 => 0x58, 40 => 0x4a, 44 => 0x53, 45 => 0x53, 46 => 0x53, 47 => 0x5b },
	'wb_rggblevelsunknown20' => { 45 => 0xd0, 46 => 0xd0, 47 => 0xd8 },
	'wb_rggblevelsunknown21' => { 46 => 0xd5, 47 => 0xdd },
	'wb_rggblevelsunknown22' => { 46 => 0xda, 47 => 0xe2 },
	'wb_rggblevelsunknown23' => { 46 => 0xdf, 47 => 0xe7 },
	'wb_rggblevelsunknown24' => { 46 => 0xe4, 47 => 0xec },
	'wb_rggblevelsunknown25' => { 46 => 0xe9, 47 => 0xf1 },
	'wb_rggblevelsunknown26' => { 46 => 0xee, 47 => 0xf6 },
	'wb_rggblevelsunknown27' => { 46 => 0xf3, 47 => 0xfb },
	'wb_rggblevelsunknown28' => { 46 => 0xf8, 47 => 0x100 },
	'wb_rggblevelsunknown29' => { 46 => 0xfd, 47 => 0x105 },
	'wb_rggblevelsunknown3' => { 37 => 0x3c, 38 => 0x60, 40 => 0x4f, 44 => 0x58, 45 => 0x58, 46 => 0x58, 47 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x102 },
	'wb_rggblevelsunknown4' => { 37 => 0x41, 38 => 0x68, 40 => 0x54, 44 => 0x5d, 45 => 0x5d, 46 => 0x5d, 47 => 0x65 },
	'wb_rggblevelsunknown5' => { 37 => 0x46, 38 => 0x70, 40 => 0x59, 44 => 0x62, 45 => 0x62, 46 => 0x62, 47 => 0x6a },
	'wb_rggblevelsunknown6' => { 37 => 0x4b, 38 => 0x78, 40 => 0x5e, 44 => 0x8a, 45 => 0x67, 46 => 0x67, 47 => 0x6f },
	'wb_rggblevelsunknown7' => { 37 => 0x50, 38 => 0x80, 40 => 0x63, 44 => 0x8f, 45 => 0x6c, 46 => 0x6c, 47 => 0x74 },
	'wb_rggblevelsunknown8' => { 37 => 0x55, 38 => 0x88, 40 => 0x68, 44 => 0x94, 45 => 0x71, 46 => 0x71, 47 => 0x79 },
	'wb_rggblevelsunknown9' => { 37 => 0x5a, 38 => 0x90, 40 => 0x6d, 44 => 0x99, 45 => 0x76, 46 => 0x76, 47 => 0x7e },
	'wb_rggblevelsuserselected' => { 340 => 0x5c },
	'wbadjblueamber' => { 97 => 0x20106 },
	'wbadjbluebalance' => { 256 => 0x8 },
	'wbadjcolortemp' => { 97 => 0x20102, 102 => 0x1a },
	'wbadjlighting' => { 256 => 0x14 },
	'wbadjmagentagreen' => { 97 => 0x20105 },
	'wbadjmode' => { 256 => 0x10 },
	'wbadjredbalance' => { 256 => 0x0 },
	'wbadjrggblevels' => { 97 => 0x20125, 102 => 0x6 },
	'wbadjtemperature' => { 256 => 0x18 },
	'wbadjtint' => { 256 => 0x25 },
	'wbbluelevel' => { 292 => 0x324, 297 => 0x8006, 302 => 0x26 },
	'wbbracketingsteps' => { 228 => 0x174d, 229 => 0x87c, 237 => 0x1757 },
	'wbbracketmode' => { 54 => 0x9 },
	'wbbracketshotnumber' => { 177 => 0x2b, 358 => 0x101a },
	'wbbracketvalueab' => { 54 => 0xc },
	'wbbracketvaluegm' => { 54 => 0xd },
	'wbfinetuneactive' => { 102 => 0x24 },
	'wbfinetunesaturation' => { 102 => 0x28 },
	'wbfinetunetone' => { 102 => 0x2c },
	'wbgreenlevel' => { 292 => 0x323, 297 => 0x8005, 302 => 0x25 },
	'wbmediaimagesizesetting' => { 78 => 0x708 },
	'wbmode' => { 179 => 0x4, 279 => 0x1015 },
	'wbredlevel' => { 292 => 0x322, 297 => 0x8004, 302 => 0x24 },
	'wbscale' => { 180 => 0x0 },
	'wbshiftab' => { 70 => 0xc, 297 => 0x46, 314 => 0x10 },
	'wbshiftab_gm' => { 388 => 0x2014 },
	'wbshiftab_gm_precise' => { 388 => 0x2026 },
	'wbshiftcreativecontrol' => { 297 => 0x92 },
	'wbshiftgm' => { 70 => 0xd, 297 => 0x47, 314 => 0x11 },
	'wbshiftintelligentauto' => { 297 => 0x8b },
	'wbtype1' => { 303 => 0x1, 304 => 0x1 },
	'wbtype2' => { 303 => 0x4, 304 => 0x5 },
	'wbtype3' => { 303 => 0x7, 304 => 0x9 },
	'wbtype4' => { 303 => 0xa, 304 => 0xd },
	'wbtype5' => { 303 => 0xd, 304 => 0x11 },
	'wbtype6' => { 303 => 0x10, 304 => 0x15 },
	'wbtype7' => { 303 => 0x13, 304 => 0x19 },
	'webstatement' => { 470 => 'WebStatement' },
	'what' => { 442 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 70 => 0x8, 72 => 0x7, 106 => 0x7, 107 => [0x19,0x2012], 113 => [0xa403,0xfe4e], 121 => 0x1002, 131 => 0x3fc, 132 => 0xfa0d, 133 => 0x40, 171 => 0x3, 172 => 0xe, 173 => 0x4, 174 => 0xb, 176 => 0x115, 211 => 0x5, 240 => 0x7, 292 => 0x304, 297 => 0x3, 299 => 0x3033, 332 => 0x19, 339 => 0x7, 357 => 0x26, 358 => 0x1003, 368 => [0x3c,0x7,0x58], 376 => 0xf, 377 => 0xe, 388 => [0x115,0xb054], 442 => 'WhiteBalance', 446 => 'WhiteBalance' },
	'whitebalance0' => { 167 => 'WhiteBalance0' },
	'whitebalance1' => { 167 => 'WhiteBalance1' },
	'whitebalance2' => { 167 => 'WhiteBalance2', 274 => 0x500 },
	'whitebalanceadj' => { 97 => 0x20101, 102 => 0x18, 250 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 310 => 0x0 },
	'whitebalancebias' => { 107 => 0x2011, 279 => 0x304, 297 => 0x23 },
	'whitebalanceblue' => { 70 => 0x7 },
	'whitebalancebracket' => { 274 => 0x502, 279 => 0x303 },
	'whitebalancebracketing' => { 174 => 0x22, 177 => 0x2c, 387 => 0x2c },
	'whitebalancecomp' => { 282 => 0x1001 },
	'whitebalancedetected' => { 131 => 0x3fb },
	'whitebalancefinetune' => { 121 => 0x100a, 174 => 0x38, 176 => 0x112, 211 => 0xb, 358 => 0x1004, 376 => 0x6, 377 => 0x5, 388 => 0x112 },
	'whitebalancemode' => { 131 => 0x3fa, 332 => 0x1a },
	'whitebalancered' => { 70 => 0x6 },
	'whitebalanceset' => { 313 => 0xa },
	'whitebalancesetting' => { 174 => 0x23, 376 => 0x5, 377 => 0x4, 378 => 0x16, 393 => 0xd },
	'whitebalancesetup' => { 365 => 0x41 },
	'whitebalancetemperature' => { 274 => 0x501 },
	'whiteboard' => { 279 => 0x301 },
	'whitelevel' => { 113 => 0xc61d, 332 => 0x7e },
	'whitepoint' => { 113 => 0x13e, 332 => 0x201, 462 => 'WhitePoint' },
	'whites2012' => { 442 => 'Whites2012' },
	'whitesadj' => { 421 => 0x9017 },
	'wideadapter' => { 358 => 0x1017 },
	'widefocuszone' => { 171 => 0x2f },
	'widerange' => { 367 => 0x20f },
	'windmode' => { 131 => 0x3f4 },
	'windowsatom' => { 441 => 'windowsAtom' },
	'windowsatomextension' => { 441 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 441 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 441 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 456 => 'wordCount' },
	'workcolorspace' => { 97 => 0x10200, 102 => 0x270 },
	'workflowtag' => { 452 => 'WorkflowTag' },
	'workflowtagcvid' => { 452 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 452 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 452 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 452 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 448 => 'WorkToDo' },
	'worldtimelocation' => { 297 => 0x3a, 332 => 0x22, 338 => '0.1' },
	'writer-editor' => { 125 => 0x7a },
	'x3filllight' => { 368 => 0x12 },
	'xattrquarantine' => { 165 => 'com.apple.quarantine' },
	'xilinxversion' => { 131 => 0x414 },
	'xml' => { 129 => 'xml ' },
	'xmp' => { 100 => 0xffff00f6, 114 => 'XMP' },
	'xmptoolkit' => { 463 => 'xmptk' },
	'xpauthor' => { 113 => 0x9c9d },
	'xpcomment' => { 113 => 0x9c9c },
	'xpkeywords' => { 113 => 0x9c9e },
	'xposition' => { 113 => 0x11e },
	'xpsubject' => { 113 => 0x9c9f },
	'xptitle' => { 113 => 0x9c9b },
	'xresolution' => { 113 => 0x11a, 128 => 0x3, 347 => 0x0, 462 => 'XResolution' },
	'xyresolution' => { 117 => 0x3 },
	'yaw' => { 109 => 0x7 },
	'yawangle' => { 228 => 0x3513, 229 => 0x2c2c, 237 => 0x36fc, 363 => 0x0 },
	'ycbcrcoefficients' => { 113 => 0x211, 462 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 113 => 0x213, 462 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 113 => 0x212, 462 => 'YCbCrSubSampling' },
	'yearcreated' => { 133 => 0x10, 142 => 0xc },
	'yellowhsl' => { 97 => 0x20912 },
	'yield' => { 458 => 'yield' },
	'yposition' => { 113 => 0x11f },
	'yresolution' => { 113 => 0x11b, 128 => 0x5, 347 => 0x4, 462 => 'YResolution' },
	'zonematching' => { 176 => 0x10a, 179 => [0x3a,0x4a], 388 => 0xb024 },
	'zonematchingmode' => { 174 => 0x14 },
	'zonematchingon' => { 173 => 0x75 },
	'zonematchingvalue' => { 376 => 0x1f },
	'zoomedpreviewlength' => { 279 => 0xf05 },
	'zoomedpreviewsize' => { 279 => 0xf06 },
	'zoomedpreviewstart' => { 279 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 277 => 0x300, 279 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemailflagged' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingcounter' => 1,
	'bracketinginfooffset' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'cx' => 1,
	'cy' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotinfo' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderid' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpscoordinates' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hiddenslides' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kinds' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelmeter' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'moviefragment' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rads' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailpng' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2018, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
