#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.16';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 103 => 0x69 },
	'about' => { 455 => 'about' },
	'aboutcvterm' => { 447 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 447 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 447 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 447 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 447 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 110 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 461 => 'absPeakAudioFilePath' },
	'academicfield' => { 451 => 'academicField' },
	'acceleration' => { 113 => 0x9404, 442 => 'Acceleration' },
	'accelerationtracking' => { 78 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 357 => 0x3 },
	'accelerometerx' => { 293 => 0x8d },
	'accelerometery' => { 293 => 0x8e },
	'accelerometerz' => { 293 => 0x8c },
	'accessoryserialnumber' => { 293 => 0x54 },
	'accessorytype' => { 293 => 0x53 },
	'actionadvised' => { 121 => 0x2a },
	'activearea' => { 113 => 0xc68d },
	'actived-lighting' => { 207 => 0x22, 244 => 0x24 },
	'actived-lightingmode' => { 244 => 0x25 },
	'adaptervoltage' => { 127 => 0x407 },
	'addaspectratioinfo' => { 78 => 0x80e },
	'additionalmodelinformation' => { 447 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 78 => 0x80f, 79 => 0x11, 80 => 0x13, 83 => 0x14 },
	'address' => { 148 => 'Address' },
	'adjustmentmode' => { 364 => 0x15 },
	'adlbracketingstep' => { 225 => 0x883 },
	'adlbracketingtype' => { 225 => 0x884 },
	'adobe' => { 114 => 'Adobe' },
	'adultcontentwarning' => { 280 => 'AdultContentWarning', 454 => 'adultContentWarning' },
	'advancedfilter' => { 118 => 0x1201 },
	'advancedraw' => { 246 => 0x76a43203 },
	'advancedscenetype' => { 293 => 0x3d },
	'advisory' => { 459 => 'Advisory' },
	'ae_iso' => { 301 => 0x2, 302 => 0x4, 303 => 0x12 },
	'aeaperture' => { 301 => 0x1, 302 => 0x3, 303 => 0x11 },
	'aeaperturesteps' => { 301 => 0x8, 302 => 0xb },
	'aebautocancel' => { 78 => 0x104 },
	'aebbracketvalue' => { 72 => 0x11 },
	'aebracketingsteps' => { 224 => 0x174c, 225 => 0x87b, 233 => 0x1756 },
	'aebsequence' => { 78 => 0x105 },
	'aebsequenceautocancel' => { 76 => 0x9, 77 => 0x9, 79 => 0x8, 80 => 0x9, 83 => 0x9, 84 => 0x7 },
	'aebshotcount' => { 78 => 0x106 },
	'aebxv' => { 301 => 0x4, 302 => 0x6 },
	'aeerror' => { 302 => 0x8 },
	'aeexposuretime' => { 301 => 0x0, 302 => 0x2, 303 => 0x10 },
	'aelbutton' => { 170 => 0x45 },
	'aelexposureindicator' => { 170 => 0x51 },
	'aelock' => { 170 => 0x5b, 255 => '4.2', 264 => '4.2', 270 => 0x201, 328 => 0x48, 372 => 0x40, 373 => 0x40, 374 => [0x86,0x286] },
	'aelockbutton' => { 253 => '16.1', 255 => '4.1', 258 => '15.1', 259 => '16.1', 260 => '16.1', 262 => '30.1', 263 => '16.1', 264 => '4.1', 266 => '17.1', 268 => '17.1' },
	'aelockbuttonplusdials' => { 253 => '16.2', 262 => '32.1', 266 => '44.1' },
	'aelockformb-d80' => { 268 => '3.1' },
	'aemaxaperture' => { 301 => 0x9, 302 => 0x10, 303 => 0x1c },
	'aemaxaperture2' => { 301 => 0xa, 302 => 0x11, 303 => 0x1d },
	'aemeteringmode' => { 301 => 0xc },
	'aemeteringmode2' => { 301 => '13.1' },
	'aemeteringsegments' => { 173 => 0x628, 328 => 0x209 },
	'aemicroadjustment' => { 78 => 0x110 },
	'aeminaperture' => { 301 => 0xb, 302 => 0x12, 303 => 0x1e },
	'aeminexposuretime' => { 301 => 0x5, 302 => 0x13, 303 => 0x1f },
	'aeprogrammode' => { 301 => 0x6 },
	'aeprojectlink' => { 436 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 436 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 436 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 436 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 436 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 436 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 301 => 0xd },
	'aexv' => { 301 => 0x3, 302 => 0x5 },
	'af-cpriorityselection' => { 253 => '1.1', 254 => '1.1', 256 => '1.1', 257 => '1.1', 259 => '0.1', 260 => '0.1', 261 => '0.1', 262 => '1.1', 263 => '0.1', 266 => '1.1', 267 => '1.1' },
	'af-onbutton' => { 256 => '70.1', 257 => '70.1', 267 => '70.1' },
	'af-onformb-d10' => { 253 => '3.3', 262 => '3.2' },
	'af-onformb-d11' => { 263 => '2.2' },
	'af-onformb-d12' => { 266 => '50.1' },
	'af-spriorityselection' => { 253 => '1.2', 254 => '1.2', 256 => '1.4', 257 => '1.4', 261 => '0.2', 262 => '1.2', 263 => '0.2', 266 => '1.2', 267 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 253 => '2.1', 254 => '2.1', 256 => '78.3', 257 => '78.3', 262 => '2.1', 266 => '2.1', 267 => '78.3' },
	'afadjustment' => { 328 => 0x72, 337 => 0x267 },
	'afandmeteringbuttons' => { 78 => 0x701 },
	'afaperture' => { 203 => 0x5, 204 => 0x5 },
	'afareaheight' => { 179 => [0x1a,0x50] },
	'afareaillumination' => { 170 => 0x4b, 264 => '15.3' },
	'afareamode' => { 166 => 0x33, 170 => 0xe, 178 => 0x0, 179 => 0x5, 293 => 0xf, 354 => 0x1205, 365 => [0xa,0x3a], 372 => 0x11, 373 => 0x10, 374 => 0x24, 384 => 0xb043, 407 => 0x17 },
	'afareamodesetting' => { 255 => '11.1', 258 => '0.1', 264 => '16.1', 268 => '2.1', 384 => 0x201c },
	'afareas' => { 270 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 78 => 0x51b },
	'afareawidth' => { 179 => [0x18,0x4e] },
	'afareaxposition' => { 179 => [0x14,0x4a], 354 => 0x1203 },
	'afareaxposition1' => { 354 => 0x1201 },
	'afareayposition' => { 179 => [0x16,0x4c], 354 => 0x1204 },
	'afareayposition1' => { 354 => 0x1202 },
	'afassist' => { 76 => 0x5, 84 => 0x5, 170 => 0x48, 253 => '2.5', 255 => '0.2', 258 => '0.2', 259 => '1.1', 260 => '1.1', 261 => '1.3', 262 => '2.4', 263 => '1.3', 264 => '0.2', 266 => '2.4', 268 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 78 => 0x50e, 79 => 0x4, 80 => 0x5, 81 => 0x4, 82 => 0x4, 83 => 0x5 },
	'afassistlamp' => { 293 => 0x31 },
	'afbuttonpressed' => { 374 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 304 => 0x6 },
	'afduringliveview' => { 78 => 0x511 },
	'affinea' => { 430 => 'AffineA' },
	'affineb' => { 430 => 'AffineB' },
	'affinec' => { 430 => 'AffineC' },
	'affined' => { 430 => 'AffineD' },
	'affinetune' => { 180 => 0x0, 270 => 0x306 },
	'affinetuneadj' => { 180 => 0x2, 217 => 0x2d1, 218 => 0x2dc, 270 => 0x307 },
	'affinetuneindex' => { 180 => 0x1 },
	'affinex' => { 430 => 'AffineX' },
	'affiney' => { 430 => 'AffineY' },
	'afhold' => { 304 => 0x1fd },
	'afilluminator' => { 372 => 0x29, 384 => 0xb044 },
	'afimageheight' => { 179 => [0x12,0x48] },
	'afimagewidth' => { 179 => [0x10,0x46] },
	'afintegrationtime' => { 304 => 0x7 },
	'afmicroadj' => { 365 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 369 => 0x131 },
	'afmicroadjregisteredlenses' => { 369 => '305.1' },
	'afmicroadjustment' => { 78 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 369 => 0x130 },
	'afmode' => { 107 => 0x3009, 118 => 0x1022, 166 => 0x16, 364 => 0x5 },
	'afmoderestrictions' => { 254 => '50.3', 256 => '48.3', 257 => '48.3', 266 => '48.3', 267 => '48.3' },
	'afonaelockbuttonswitch' => { 78 => 0x702 },
	'afonbutton' => { 253 => '3.1', 254 => '47.1' },
	'afpoint' => { 33 => 0x13, 106 => 0x18, 166 => 0x15, 178 => 0x1, 273 => 0x308, 364 => 0x1f, 365 => [0x37,0x7], 369 => 0x19, 370 => 0x18, 371 => [0x18,0x20] },
	'afpointactivationarea' => { 77 => 0x11, 83 => 0x11 },
	'afpointareaexpansion' => { 78 => 0x508 },
	'afpointatshutterrelease' => { 365 => [0x39,0x9] },
	'afpointautoselection' => { 78 => 0x50b },
	'afpointbrightness' => { 78 => 0x50d, 253 => '2.4', 254 => '46.5', 256 => '2.2', 257 => '2.2', 266 => '2.3', 267 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 78 => 0x50c },
	'afpointillumination' => { 77 => 0xa, 253 => '2.3', 254 => '46.2', 256 => '47.2', 257 => '47.2', 261 => '1.2', 262 => '2.3', 263 => '1.2', 266 => '47.2', 267 => '47.2', 268 => '2.4' },
	'afpointinfocus' => { 365 => [0x38,0x8] },
	'afpointmode' => { 309 => 0x3 },
	'afpointposition' => { 107 => 0x2021, 293 => 0x4d },
	'afpointregistration' => { 76 => 0x7 },
	'afpoints' => { 169 => 0x10 },
	'afpointselected' => { 170 => 0xd, 270 => 0x305, 328 => 0xe, 369 => 0x15, 370 => 0x14, 371 => [0x14,0x1c], 384 => 0x201e },
	'afpointselected2' => { 309 => 0x4 },
	'afpointselection' => { 77 => 0xb, 253 => '1.3', 254 => '1.3', 262 => '1.3', 266 => '1.3', 267 => '1.3' },
	'afpointselectionmethod' => { 78 => 0x50f, 79 => 0xc, 80 => 0xd, 83 => 0xd },
	'afpointsetting' => { 372 => 0x12, 373 => 0x11 },
	'afpointsinfocus' => { 72 => 0xe, 178 => 0x2, 304 => 0xb, 305 => 0x4, 328 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 77 => 0xd },
	'afpointsselected' => { 305 => '4.1', 415 => 0x4 },
	'afpointsspecial' => { 305 => '4.2' },
	'afpointsunknown1' => { 304 => 0x0 },
	'afpointsunknown2' => { 304 => 0x2 },
	'afpointsused' => { 179 => 0x8, 365 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 304 => 0x4 },
	'afresponse' => { 207 => 0xad },
	'afresult' => { 275 => 0x1038 },
	'afsearch' => { 270 => 0x303 },
	'afsensoractive' => { 166 => 0x1 },
	'afstatus' => { 354 => 0x1200 },
	'afstatus_00_b4' => { 368 => 0x0 },
	'afstatus_01_c4' => { 368 => 0x2 },
	'afstatus_02_d4' => { 368 => 0x4 },
	'afstatus_03_e4' => { 368 => 0x6 },
	'afstatus_04_f4' => { 368 => 0x8 },
	'afstatus_05_g4' => { 368 => 0xa },
	'afstatus_06_h4' => { 368 => 0xc },
	'afstatus_07_b3' => { 368 => 0xe },
	'afstatus_08_c3' => { 368 => 0x10 },
	'afstatus_09_d3' => { 368 => 0x12 },
	'afstatus_10_e3' => { 368 => 0x14 },
	'afstatus_11_f3' => { 368 => 0x16 },
	'afstatus_12_g3' => { 368 => 0x18 },
	'afstatus_13_h3' => { 368 => 0x1a },
	'afstatus_14_b2' => { 368 => 0x1c },
	'afstatus_15_c2' => { 368 => 0x1e },
	'afstatus_16_d2' => { 368 => 0x20 },
	'afstatus_17_e2' => { 368 => 0x22 },
	'afstatus_18_f2' => { 368 => 0x24 },
	'afstatus_19_g2' => { 368 => 0x26 },
	'afstatus_20_h2' => { 368 => 0x28 },
	'afstatus_21_c1' => { 368 => 0x2a },
	'afstatus_22_d1' => { 368 => 0x2c },
	'afstatus_23_e1' => { 368 => 0x2e },
	'afstatus_24_f1' => { 368 => 0x30 },
	'afstatus_25_g1' => { 368 => 0x32 },
	'afstatus_26_a7_vertical' => { 368 => 0x34 },
	'afstatus_27_a6_vertical' => { 368 => 0x36 },
	'afstatus_28_a5_vertical' => { 368 => 0x38 },
	'afstatus_29_c7_vertical' => { 368 => 0x3a },
	'afstatus_30_c6_vertical' => { 368 => 0x3c },
	'afstatus_31_c5_vertical' => { 368 => 0x3e },
	'afstatus_32_e7_vertical' => { 368 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 368 => 0x42 },
	'afstatus_34_e5_vertical' => { 368 => 0x44 },
	'afstatus_35_g7_vertical' => { 368 => 0x46 },
	'afstatus_36_g6_vertical' => { 368 => 0x48 },
	'afstatus_37_g5_vertical' => { 368 => 0x4a },
	'afstatus_38_i7_vertical' => { 368 => 0x4c },
	'afstatus_39_i6_vertical' => { 368 => 0x4e },
	'afstatus_40_i5_vertical' => { 368 => 0x50 },
	'afstatus_41_a7' => { 368 => 0x52 },
	'afstatus_42_b7' => { 368 => 0x54 },
	'afstatus_43_c7' => { 368 => 0x56 },
	'afstatus_44_d7' => { 368 => 0x58 },
	'afstatus_45_e7' => { 368 => 0x5a },
	'afstatus_46_f7' => { 368 => 0x5c },
	'afstatus_47_g7' => { 368 => 0x5e },
	'afstatus_48_h7' => { 368 => 0x60 },
	'afstatus_49_i7' => { 368 => 0x62 },
	'afstatus_50_a6' => { 368 => 0x64 },
	'afstatus_51_b6' => { 368 => 0x66 },
	'afstatus_52_c6' => { 368 => 0x68 },
	'afstatus_53_d6' => { 368 => 0x6a },
	'afstatus_54_e6_center' => { 368 => 0x6c },
	'afstatus_55_f6' => { 368 => 0x6e },
	'afstatus_56_g6' => { 368 => 0x70 },
	'afstatus_57_h6' => { 368 => 0x72 },
	'afstatus_58_i6' => { 368 => 0x74 },
	'afstatus_59_a5' => { 368 => 0x76 },
	'afstatus_60_b5' => { 368 => 0x78 },
	'afstatus_61_c5' => { 368 => 0x7a },
	'afstatus_62_d5' => { 368 => 0x7c },
	'afstatus_63_e5' => { 368 => 0x7e },
	'afstatus_64_f5' => { 368 => 0x80 },
	'afstatus_65_g5' => { 368 => 0x82 },
	'afstatus_66_h5' => { 368 => 0x84 },
	'afstatus_67_i5' => { 368 => 0x86 },
	'afstatus_68_c11' => { 368 => 0x88 },
	'afstatus_69_d11' => { 368 => 0x8a },
	'afstatus_70_e11' => { 368 => 0x8c },
	'afstatus_71_f11' => { 368 => 0x8e },
	'afstatus_72_g11' => { 368 => 0x90 },
	'afstatus_73_b10' => { 368 => 0x92 },
	'afstatus_74_c10' => { 368 => 0x94 },
	'afstatus_75_d10' => { 368 => 0x96 },
	'afstatus_76_e10' => { 368 => 0x98 },
	'afstatus_77_f10' => { 368 => 0x9a },
	'afstatus_78_g10' => { 368 => 0x9c },
	'afstatus_79_h10' => { 368 => 0x9e },
	'afstatus_80_b9' => { 368 => 0xa0 },
	'afstatus_81_c9' => { 368 => 0xa2 },
	'afstatus_82_d9' => { 368 => 0xa4 },
	'afstatus_83_e9' => { 368 => 0xa6 },
	'afstatus_84_f9' => { 368 => 0xa8 },
	'afstatus_85_g9' => { 368 => 0xaa },
	'afstatus_86_h9' => { 368 => 0xac },
	'afstatus_87_b8' => { 368 => 0xae },
	'afstatus_88_c8' => { 368 => 0xb0 },
	'afstatus_89_d8' => { 368 => 0xb2 },
	'afstatus_90_e8' => { 368 => 0xb4 },
	'afstatus_91_f8' => { 368 => 0xb6 },
	'afstatus_92_g8' => { 368 => 0xb8 },
	'afstatus_93_h8' => { 368 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 368 => 0xbc },
	'afstatusactivesensor' => { 166 => 0x2, 365 => [0x4,0x3b], 369 => 0x1e, 370 => 0x1b, 371 => [0x1b,0x21] },
	'afstatusbottom' => { 166 => 0x8, 369 => 0x2a, 370 => 0x21, 371 => 0x21 },
	'afstatusbottom-left' => { 166 => 0x12, 370 => 0x2b, 371 => 0x2b },
	'afstatusbottom-right' => { 166 => 0x6, 370 => 0x1f, 371 => 0x1f },
	'afstatusbottomassist-left' => { 369 => 0x28 },
	'afstatusbottomassist-right' => { 369 => 0x2c },
	'afstatusbottomhorizontal' => { 366 => 0x10, 367 => 0x1c },
	'afstatusbottomvertical' => { 366 => 0x16, 367 => 0x26 },
	'afstatuscenter-10' => { 369 => 0x34 },
	'afstatuscenter-11' => { 369 => 0x36 },
	'afstatuscenter-12' => { 369 => 0x38 },
	'afstatuscenter-14' => { 369 => 0x3c },
	'afstatuscenter-7' => { 369 => 0x2e },
	'afstatuscenter-9' => { 369 => 0x32 },
	'afstatuscenter-horizontal' => { 369 => 0x30 },
	'afstatuscenter-vertical' => { 369 => 0x3a },
	'afstatuscenterf2-8' => { 369 => 0x4c },
	'afstatuscenterhorizontal' => { 166 => 0x2f, 366 => 0xc, 367 => 0x18, 370 => 0x2f, 371 => 0x2f },
	'afstatuscentervertical' => { 166 => 0xc, 366 => 0x14, 367 => 0x22, 370 => 0x25, 371 => 0x25 },
	'afstatusfarleft' => { 366 => 0x6, 369 => 0x26 },
	'afstatusfarlefthorizontal' => { 367 => 0x4 },
	'afstatusfarleftvertical' => { 367 => 0x12 },
	'afstatusfarright' => { 366 => 0x18, 369 => 0x44 },
	'afstatusfarrighthorizontal' => { 367 => 0x2c },
	'afstatusfarrightvertical' => { 367 => 0x34 },
	'afstatusleft' => { 166 => 0x2d, 366 => 0x2, 369 => 0x22, 370 => 0x2d, 371 => 0x2d },
	'afstatuslefthorizontal' => { 367 => 0x6 },
	'afstatusleftvertical' => { 367 => 0xe },
	'afstatuslower-left' => { 366 => 0x4, 369 => 0x24 },
	'afstatuslower-lefthorizontal' => { 367 => 0xa },
	'afstatuslower-leftvertical' => { 367 => 0x10 },
	'afstatuslower-middle' => { 366 => 0x22, 367 => 0x24 },
	'afstatuslower-right' => { 366 => 0x1e, 369 => 0x4a },
	'afstatuslower-righthorizontal' => { 367 => 0x32 },
	'afstatuslower-rightvertical' => { 367 => 0x3a },
	'afstatuslowerfarleft' => { 367 => 0x8 },
	'afstatuslowerfarright' => { 367 => 0x30 },
	'afstatusmiddlehorizontal' => { 166 => 0xa, 370 => 0x23, 371 => 0x23 },
	'afstatusnearleft' => { 366 => 0xe, 367 => 0x1a },
	'afstatusnearright' => { 366 => 0xa, 367 => 0x16 },
	'afstatusright' => { 166 => 0x31, 366 => 0x1c, 369 => 0x48, 370 => 0x31, 371 => 0x31 },
	'afstatusrighthorizontal' => { 367 => 0x2e },
	'afstatusrightvertical' => { 367 => 0x38 },
	'afstatustop' => { 166 => 0xe, 369 => 0x40, 370 => 0x27, 371 => 0x27 },
	'afstatustop-left' => { 166 => 0x10, 370 => 0x29, 371 => 0x29 },
	'afstatustop-right' => { 166 => 0x4, 370 => 0x1d, 371 => 0x1d },
	'afstatustopassist-left' => { 369 => 0x3e },
	'afstatustopassist-right' => { 369 => 0x42 },
	'afstatustophorizontal' => { 366 => 0x8, 367 => 0x14 },
	'afstatustopvertical' => { 366 => 0x12, 367 => 0x1e },
	'afstatusupper-left' => { 366 => 0x0, 369 => 0x20 },
	'afstatusupper-lefthorizontal' => { 367 => 0x2 },
	'afstatusupper-leftvertical' => { 367 => 0xc },
	'afstatusupper-middle' => { 366 => 0x20, 367 => 0x20 },
	'afstatusupper-right' => { 366 => 0x1a, 369 => 0x46 },
	'afstatusupper-righthorizontal' => { 367 => 0x2a },
	'afstatusupper-rightvertical' => { 367 => 0x36 },
	'afstatusupperfarleft' => { 367 => 0x0 },
	'afstatusupperfarright' => { 367 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 384 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 365 => 0x2 },
	'afwithshutter' => { 372 => 0x2a },
	'aggregateissuenumber' => { 451 => 'aggregateIssueNumber' },
	'aggregationtype' => { 451 => 'aggregationType' },
	'agreement' => { 454 => 'agreement' },
	'aiservocontinuousshooting' => { 77 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 78 => 0x519 },
	'aiservoimagepriority' => { 78 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 78 => 0x51a },
	'aiservotrackingmethod' => { 78 => 0x504 },
	'aiservotrackingsensitivity' => { 77 => 0x14, 78 => 0x502 },
	'album' => { 461 => 'album' },
	'alreadyapplied' => { 437 => 'AlreadyApplied' },
	'alternatetitle' => { 451 => 'alternateTitle' },
	'alternatetitlea-lang' => { 451 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 451 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 451 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 181 => 0x6 },
	'alttapename' => { 461 => 'altTapeName' },
	'alttimecode' => { 461 => 'altTimecode' },
	'alttimecodetimeformat' => { 461 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 461 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 461 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 113 => 0x9400, 349 => 0x14, 350 => 0x46, 407 => 0x4, 442 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 349 => 0x13, 350 => 0x44 },
	'analogbalance' => { 113 => 0xc627 },
	'angleadj' => { 97 => 0x10003, 103 => 0x8b },
	'angleinforoll' => { 432 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 432 => 'AngleInfoYaw' },
	'anti-blur' => { 384 => 0xb04b },
	'antialiasstrength' => { 113 => 0xc632 },
	'aperturelock' => { 254 => '38.2', 256 => '38.2', 257 => '38.2', 266 => '38.2', 267 => '38.2' },
	'aperturerange' => { 78 => 0x10d },
	'apertureringuse' => { 309 => '1.4' },
	'aperturesetting' => { 170 => 0x7, 372 => 0x30, 373 => 0x29, 374 => 0x1 },
	'aperturevalue' => { 87 => 0x2, 113 => 0x9202, 275 => 0x1002, 337 => 0x401, 441 => 'ApertureValue' },
	'applekeywords' => { 279 => 'AAPL:Keywords' },
	'applicationnotes' => { 113 => 0x2bc, 298 => 0x2bc },
	'applicationrecordversion' => { 121 => 0x0 },
	'applyshootingmeteringmode' => { 78 => 0x10e },
	'approved' => { 443 => 'Approved' },
	'approvedby' => { 443 => 'ApprovedBy' },
	'approximatefnumber' => { 288 => 0x313, 295 => 0x3406 },
	'approximatefocusdistance' => { 433 => 'ApproximateFocusDistance' },
	'appversion' => { 445 => 'AppVersion' },
	'aquahsl' => { 97 => 0x20914 },
	'armidentifier' => { 122 => 0x78 },
	'armversion' => { 122 => 0x7a },
	'artfilter' => { 270 => 0x529 },
	'artfiltereffect' => { 270 => 0x52f },
	'artist' => { 113 => 0x13b, 283 => 'Artist', 328 => 0x22e, 457 => 'Artist', 461 => 'artist' },
	'artmode' => { 107 => 0x301b },
	'artmodeparameters' => { 107 => 0x310b },
	'artworkcircadatecreated' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 447 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 447 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 274 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 274 => 0x1112, 328 => 0x80, 372 => 0x55, 373 => 0x55, 374 => 0xa },
	'assetid' => { 427 => 'AssetID' },
	'asshoticcprofile' => { 113 => 0xc68f },
	'asshotneutral' => { 113 => 0xc628 },
	'asshotpreprofilematrix' => { 113 => 0xc690 },
	'asshotprofilename' => { 113 => 0xc6f6 },
	'asshotwhitexy' => { 113 => 0xc629 },
	'assignbktbutton' => { 253 => '4.2', 254 => '16.1', 256 => '16.1', 257 => '16.1', 266 => '16.1', 267 => '16.1' },
	'assignfuncbutton' => { 78 => 0x70b },
	'assignmb-d17af-onbutton' => { 257 => '79.1' },
	'assignmb-d17funcbutton' => { 257 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 257 => '68.1' },
	'assignmb-d18af-onbutton' => { 267 => '79.1' },
	'assignmb-d18funcbutton' => { 267 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 267 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 256 => '75.1', 257 => '75.1', 267 => '75.1' },
	'assignmoviefunc2button' => { 256 => '82.1', 257 => '82.1', 267 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 256 => '75.2', 257 => '75.2', 267 => '75.2' },
	'assignmovierecordbutton' => { 254 => '43.2', 266 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 256 => '45.1', 257 => '45.1', 267 => '45.1' },
	'assignmoviesubselector' => { 256 => '74.1', 257 => '74.1', 267 => '74.1' },
	'assignmoviesubselectorplusdials' => { 256 => '76.1', 257 => '76.1', 267 => '76.1' },
	'assignremotefnbutton' => { 254 => '54.1', 266 => '51.1' },
	'assistbuttonfunction' => { 76 => 0xd },
	'attributionname' => { 434 => 'attributionName' },
	'attributionurl' => { 434 => 'attributionURL' },
	'audio' => { 293 => 0x20 },
	'audiobitrate' => { 63 => 0x6c, 447 => 'audioBitRate' },
	'audiobitratemode' => { 447 => 'audioBitRateMode' },
	'audiobitspersample' => { 447 => 'audioBitsPerSample' },
	'audiochannelcount' => { 447 => 'audioChannelCount' },
	'audiochannels' => { 63 => 0x70 },
	'audiochanneltype' => { 461 => 'audioChannelType' },
	'audiocompression' => { 142 => 'Compression' },
	'audiocompressor' => { 461 => 'audioCompressor' },
	'audiodata' => { 421 => 'Data' },
	'audioduration' => { 121 => 0x99 },
	'audiomimetype' => { 421 => 'Mime' },
	'audiomoddate' => { 461 => 'audioModDate' },
	'audiooutcue' => { 121 => 0x9a },
	'audiosamplerate' => { 63 => 0x6e, 461 => 'audioSampleRate' },
	'audiosampletype' => { 461 => 'audioSampleType' },
	'audiosamplingrate' => { 121 => 0x97 },
	'audiosamplingresolution' => { 121 => 0x98 },
	'audiotype' => { 121 => 0x96 },
	'author' => { 144 => 'Author', 279 => 'Author', 283 => 'Author', 344 => 'Author', 431 => 'author', 448 => 'Author', 459 => 'Author' },
	'authorsposition' => { 449 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 78 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 319 => '0.1' },
	'autobracket' => { 364 => 0x19 },
	'autobracketing' => { 118 => 0x1100, 328 => 0x18, 354 => 0x1007 },
	'autobracketingmode' => { 265 => '12.3' },
	'autobracketingset' => { 265 => '12.1' },
	'autobracketmodem' => { 253 => '21.2', 254 => '13.3', 256 => '13.2', 257 => '13.2', 262 => '26.2', 266 => '13.3', 267 => '13.2' },
	'autobracketorder' => { 170 => 0x43, 253 => '21.3', 254 => '13.2', 256 => '13.1', 257 => '13.1', 262 => '26.3', 263 => '12.2', 264 => '2.2', 265 => '12.2', 266 => '13.2', 267 => '13.1', 268 => '13.2' },
	'autobracketset' => { 253 => '21.1', 254 => '13.1', 258 => '11.1', 259 => '12.1', 260 => '12.1', 262 => '26.1', 263 => '12.1', 264 => '2.1', 266 => '13.1', 268 => '13.1' },
	'autobrightness' => { 437 => 'AutoBrightness' },
	'autocontrast' => { 437 => 'AutoContrast' },
	'autodistortioncontrol' => { 191 => 0x4 },
	'autodynamicrange' => { 118 => 0x140b },
	'autoexposure' => { 437 => 'AutoExposure' },
	'autoexposurebracketing' => { 72 => 0x10 },
	'autoflashisosensitivity' => { 256 => '38.5', 257 => '38.5', 267 => '38.5' },
	'autofocus' => { 273 => 0x209 },
	'autofp' => { 264 => '7.3', 268 => '31.4' },
	'autoiso' => { 72 => 0x1, 107 => 0x3008, 255 => '1.1', 264 => '1.1' },
	'autoisomax' => { 255 => '1.2', 264 => '1.2' },
	'autoisominshutterspeed' => { 255 => '1.3', 264 => '1.3' },
	'autolateralca' => { 437 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 59 => 0x2, 78 => 0x204, 97 => 0x20500, 103 => 0x6f },
	'autolightingoptimizeron' => { 97 => '0x20500.0', 103 => 0x6e },
	'autoportraitframed' => { 384 => 0x2016 },
	'autoredeye' => { 246 => 0xfe28a44f },
	'autorotate' => { 72 => 0x1b },
	'autoshadows' => { 437 => 'AutoShadows' },
	'autowhiteversion' => { 437 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 207 => 0x82 },
	'avaperturesetting' => { 309 => 0x13 },
	'averageblacklevel' => { 42 => 0xe7, 44 => 0xfb, 45 => 0x114, 46 => 0x146 },
	'averagelv' => { 173 => 0x38 },
	'avsettingwithoutlens' => { 78 => 0x707 },
	'azimuth' => { 152 => 'Azimuth' },
	'babyage' => { 293 => [0x8010,0x33] },
	'babyname' => { 293 => 0x66 },
	'backgroundalpha' => { 456 => 'bgalpha' },
	'baseexposurecompensation' => { 309 => 0x15 },
	'baseiso' => { 72 => 0x2, 91 => 0x101c, 127 => 0x903, 295 => 0x312a, 413 => 0x6 },
	'baselineexposure' => { 113 => 0xc62a },
	'baselineexposureoffset' => { 113 => 0xc7a5 },
	'baselinenoise' => { 113 => 0xc62b },
	'baselinesharpness' => { 113 => 0xc62c },
	'baseurl' => { 459 => 'BaseURL' },
	'batterylevel' => { 372 => 0x51, 376 => 0xc, 377 => 0x4, 378 => 0x4, 414 => 0x7 },
	'batterylevelgrip1' => { 414 => 0x6 },
	'batterylevelgrip2' => { 414 => 0x8 },
	'batteryorder' => { 253 => '12.5', 262 => '13.2', 263 => '2.1', 266 => '3.1' },
	'batterystate' => { 170 => 0x60, 372 => 0x50, 378 => 0x14 },
	'batterytemperature' => { 376 => 0x1, 378 => 0x2, 414 => 0x5 },
	'batterytype' => { 60 => 0x38 },
	'batteryunknown' => { 376 => 0x2, 378 => 0x0 },
	'batteryvoltage' => { 127 => 0x408, 349 => 0x2a, 350 => 0x49, 376 => 0x8 },
	'batteryvoltage1' => { 378 => 0x6 },
	'batteryvoltage2' => { 378 => 0x8 },
	'bayergreensplit' => { 113 => 0xc62d },
	'bayerpattern' => { 126 => 0xf902, 174 => 0x17 },
	'beatspliceparams' => { 461 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 461 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 461 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 461 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 461 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 461 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 253 => '13.1', 254 => '5.4', 255 => '0.1', 258 => '2.1', 259 => '3.1', 260 => '3.1', 262 => '10.1', 264 => '0.1', 266 => '5.5', 268 => '4.1' },
	'beeppitch' => { 263 => '3.1' },
	'beepvolume' => { 263 => '4.5' },
	'bestqualityscale' => { 113 => 0xc65c },
	'bestshotmode' => { 107 => 0x3007 },
	'bitdepth' => { 149 => 'BitDepth', 174 => 0x11, 214 => 0x41 },
	'bitspercomponent' => { 123 => 0x87 },
	'bitspersample' => { 113 => 0x102, 298 => 0xa, 457 => 'BitsPerSample' },
	'blacklevel' => { 113 => 0xc61a, 207 => 0x3d, 275 => [0x401,0x1012], 337 => 0x21d },
	'blacklevel2' => { 274 => 0x600, 278 => 0x600 },
	'blacklevelblue' => { 298 => 0x1e },
	'blackleveldata' => { 337 => 0x223 },
	'blackleveldeltah' => { 113 => 0xc61b },
	'blackleveldeltav' => { 113 => 0xc61c },
	'blacklevelgreen' => { 298 => 0x1d },
	'blacklevelred' => { 298 => 0x1c },
	'blacklevelrepeatdim' => { 113 => 0xc619 },
	'blackpoint' => { 328 => 0x200 },
	'blacks2012' => { 437 => 'Blacks2012' },
	'bleachbypasstoning' => { 328 => 0x7f },
	'blockshotafresponse' => { 256 => '1.5', 257 => '1.5', 267 => '1.5' },
	'blogtitle' => { 451 => 'blogTitle' },
	'blogurl' => { 451 => 'blogURL' },
	'bluebalance' => { 275 => 0x1018, 298 => 0x12, 328 => 0x1b },
	'bluecurvelimits' => { 102 => 0x1fe },
	'bluecurvepoints' => { 101 => 0x79, 102 => 0x1d4 },
	'bluehsl' => { 97 => 0x20915 },
	'bluehue' => { 437 => 'BlueHue' },
	'bluesaturation' => { 437 => 'BlueSaturation' },
	'bluratinfinity' => { 423 => 'BlurAtInfinity' },
	'blurcontrol' => { 328 => 0x82 },
	'blurwarning' => { 118 => 0x1300 },
	'bodybatteryadload' => { 307 => 0x3 },
	'bodybatteryadnoload' => { 307 => 0x2 },
	'bodybatterystate' => { 307 => '1.1' },
	'bodybatteryvoltage1' => { 307 => 0x2 },
	'bodybatteryvoltage2' => { 307 => 0x4 },
	'bodybatteryvoltage3' => { 307 => 0x6 },
	'bodybatteryvoltage4' => { 307 => 0x8 },
	'bodyfirmware' => { 355 => 0x0 },
	'bodyfirmwareversion' => { 271 => 0x104, 272 => 0x100, 275 => 0x104 },
	'bodyserialnumber' => { 355 => 0x10 },
	'bookedition' => { 451 => 'bookEdition' },
	'bootloaderversion' => { 350 => 0x26 },
	'bracketmode' => { 54 => 0x3 },
	'bracketsequence' => { 107 => 0x301d },
	'bracketsettings' => { 293 => 0x45 },
	'bracketshotnumber' => { 54 => 0x5, 309 => 0x9, 383 => 0x2b },
	'bracketshotnumber2' => { 383 => 0x2d },
	'bracketstep' => { 167 => 0xe },
	'bracketvalue' => { 54 => 0x4 },
	'brightness' => { 113 => 0xfe53, 143 => 'Brightness', 163 => 'Brightness', 167 => 0x2c, 209 => 0x34, 210 => 0x39, 349 => 0x25, 372 => 0x22, 384 => 0x2007, 437 => 'Brightness' },
	'brightnessadj' => { 102 => 0x114, 239 => 0x0, 249 => 0x2d, 417 => 0x8018 },
	'brightnessvalue' => { 113 => 0x9203, 173 => [0x691,0x49c3], 275 => 0x1003, 389 => 0x1e, 392 => 0x1140, 393 => 0x1140, 394 => 0x111c, 395 => 0x1198, 396 => 0x1174, 397 => 0x102c, 398 => 0x224, 399 => 0x224, 400 => 0x219, 441 => 'BrightnessValue' },
	'bulbduration' => { 72 => 0x18 },
	'burstmode' => { 129 => 0xa, 293 => 0x2a },
	'burstmode2' => { 129 => 0x18 },
	'burstshot' => { 364 => 0x34 },
	'burstspeed' => { 293 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 78 => 0x70a },
	'bwfilter' => { 167 => 0x2a, 175 => 0x39 },
	'bwmode' => { 275 => 0x203 },
	'by-line' => { 121 => 0x50 },
	'by-linetitle' => { 121 => 0x55 },
	'bytecount' => { 451 => 'byteCount' },
	'cacheversion' => { 113 => 0xc7aa },
	'calibration' => { 364 => [0x24,0x30] },
	'calibrationilluminant1' => { 113 => 0xc65a },
	'calibrationilluminant2' => { 113 => 0xc65b },
	'callforimage' => { 427 => 'CallForImage' },
	'cameraangle' => { 461 => 'cameraAngle' },
	'cameracalibration1' => { 113 => 0xc623 },
	'cameracalibration2' => { 113 => 0xc624 },
	'cameracalibrationsig' => { 113 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 36 => 0x0 },
	'cameracolorcalibration02' => { 35 => 0x4, 36 => 0x5 },
	'cameracolorcalibration03' => { 35 => 0x8, 36 => 0xa },
	'cameracolorcalibration04' => { 35 => 0xc, 36 => 0xf },
	'cameracolorcalibration05' => { 35 => 0x10, 36 => 0x14 },
	'cameracolorcalibration06' => { 35 => 0x14, 36 => 0x19 },
	'cameracolorcalibration07' => { 35 => 0x18, 36 => 0x1e },
	'cameracolorcalibration08' => { 35 => 0x1c, 36 => 0x23 },
	'cameracolorcalibration09' => { 35 => 0x20, 36 => 0x28 },
	'cameracolorcalibration10' => { 35 => 0x24, 36 => 0x2d },
	'cameracolorcalibration11' => { 35 => 0x28, 36 => 0x32 },
	'cameracolorcalibration12' => { 35 => 0x2c, 36 => 0x37 },
	'cameracolorcalibration13' => { 35 => 0x30, 36 => 0x3c },
	'cameracolorcalibration14' => { 35 => 0x34, 36 => 0x41 },
	'cameracolorcalibration15' => { 35 => 0x38, 36 => 0x46 },
	'camerae-mountversion' => { 416 => 0xb },
	'cameraelevationangle' => { 113 => 0x9405, 442 => 'CameraElevationAngle' },
	'camerafilename' => { 427 => 'CameraFilename' },
	'cameraid' => { 275 => 0x209, 363 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 113 => 0xc7a1, 461 => 'cameraLabel' },
	'cameramakemodel' => { 427 => 'CameraMakeModel' },
	'cameramodel' => { 337 => 0x410, 461 => 'cameraModel' },
	'cameramodelid' => { 163 => 'CameraModelID' },
	'cameramove' => { 461 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 293 => 0x8f, 332 => 0x1, 337 => 0x100, 378 => [0x16,0x18], 404 => 0x28, 405 => 0x24, 406 => 0x29 },
	'cameraowner' => { 130 => 0xc353 },
	'cameraparameters' => { 275 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 109 => 0x9 },
	'cameraprofile' => { 437 => 'CameraProfile' },
	'cameraprofiledigest' => { 437 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 103 => 0xe1 },
	'camerarawcontrast' => { 103 => 0xe3 },
	'camerarawhighlightpoint' => { 103 => 0xe6 },
	'camerarawlinear' => { 103 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 103 => 0xe8 },
	'camerarawoutputshadowpoint' => { 103 => 0xe9 },
	'camerarawsaturation' => { 103 => 0xe2 },
	'camerarawshadowpoint' => { 103 => 0xe7 },
	'camerarawsharpness' => { 103 => 0xe5 },
	'cameraroll' => { 109 => 0xb },
	'cameraserialnumber' => { 113 => 0xc62f, 165 => 'CameraSerialNumber', 427 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 270 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 72 => 0xc, 127 => 0x406, 274 => 0x1306, 288 => 0x320, 295 => 0x3402, 328 => 0x47, 361 => 0x43, 408 => 0x5 },
	'cameratemperature4' => { 333 => 0x14 },
	'cameratemperature5' => { 333 => 0x16 },
	'cameratemperaturerangemax' => { 115 => 0x5 },
	'cameratemperaturerangemin' => { 115 => 0x6 },
	'cameratype' => { 72 => 0x1a, 275 => 0x207 },
	'cameratype2' => { 271 => 0x100 },
	'camerayaw' => { 109 => 0xa },
	'canondr4' => { 114 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 91 => 0x805 },
	'canonfilelength' => { 60 => 0xe },
	'canonfirmwareversion' => { 60 => 0x7, 91 => 0x80b },
	'canonflashinfo' => { 91 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 60 => 0x6, 91 => 0x815 },
	'canonmodelid' => { 60 => 0x10, 91 => 0x1834 },
	'canonvrd' => { 114 => 'CanonVRD' },
	'caption' => { 431 => 'caption' },
	'caption-abstract' => { 121 => 0x78 },
	'captionsauthornames' => { 440 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 440 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 449 => 'CaptionWriter' },
	'captureframerate' => { 107 => 0x4001 },
	'capturesoftware' => { 425 => 'CaptureSoftware' },
	'cardshutterlock' => { 170 => 0x49 },
	'casioimagesize' => { 107 => 0x9 },
	'catalogsets' => { 121 => 0xff, 420 => 'CatalogSets', 429 => 'CatalogSets' },
	'categories' => { 60 => 0x23, 431 => 'categories' },
	'category' => { 121 => 0xf, 269 => 0x30, 449 => 'Category' },
	'cbcrgain' => { 361 => 0xa036 },
	'cbcrgaindefault' => { 361 => 0xa035 },
	'cbcrmatrix' => { 361 => 0xa034 },
	'cbcrmatrixdefault' => { 361 => 0xa033 },
	'ccdboardversion' => { 288 => 0x331 },
	'ccdscanmode' => { 275 => 0x1039 },
	'ccdsensitivity' => { 236 => 0x6 },
	'ccdversion' => { 288 => 0x330 },
	'cellglobalid' => { 435 => 'cgi' },
	'celllength' => { 113 => 0x109 },
	'cellr' => { 435 => 'r' },
	'celltowerid' => { 435 => 'cellid' },
	'cellwidth' => { 113 => 0x108 },
	'centerafarea' => { 264 => '15.1' },
	'centerfocuspoint' => { 268 => '2.2' },
	'centerweightedareasize' => { 253 => '7.1', 254 => '8.1', 256 => '8.1', 257 => '8.1', 261 => '7.1', 262 => '5.1', 263 => '7.1', 264 => '6.3', 266 => '8.1', 267 => '8.1', 268 => '8.1' },
	'certificate' => { 465 => 'Certificate' },
	'cfapattern' => { 113 => 0xa302, 298 => 0x9, 441 => 'CFAPattern' },
	'cfapattern2' => { 113 => 0x828e },
	'cfapatterncolumns' => { 441 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 441 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 441 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 113 => 0x828d },
	'channel' => { 451 => 'channel' },
	'channela-lang' => { 451 => [\'channel','channelA-lang'] },
	'channelchannel' => { 451 => [\'channel','channelChannel'] },
	'channels' => { 142 => 'Channels' },
	'channelsubchannel1' => { 451 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 451 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 451 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 451 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 97 => 0x10101, 102 => 0x26a },
	'checkmark2' => { 103 => 0x8e },
	'childfontfiles' => { 466 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 253 => '10.3', 254 => '11.2' },
	'chromablurradius' => { 113 => 0xc631 },
	'chromaticaberration' => { 97 => 0x20703, 103 => 0x66, 361 => 0xa051 },
	'chromaticaberrationb' => { 437 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 97 => 0x20708, 103 => 0x6b },
	'chromaticaberrationcorr' => { 74 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 113 => 0x7034, 318 => 0x1 },
	'chromaticaberrationcorrparams' => { 113 => 0x7035, 412 => 0x66a, 413 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 97 => '0x20703.0', 103 => 0x62 },
	'chromaticaberrationr' => { 437 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 97 => 0x20707, 103 => 0x6a },
	'chromaticaberrationsetting' => { 75 => 0x6 },
	'chrominancenoisereduction' => { 97 => 0x20601, 103 => 0x5e, 364 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 103 => 0x60 },
	'circadatecreated' => { 447 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 437 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 437 => 'CircularGradientBasedCorrections' },
	'city' => { 121 => 0x5a, 148 => 'City', 293 => 0x6d, 449 => 'City' },
	'city2' => { 293 => 0x80 },
	'clarity' => { 210 => 0x35, 437 => 'Clarity' },
	'clarity2012' => { 437 => 'Clarity2012' },
	'claritycontrol' => { 328 => 0x96 },
	'classifystate' => { 121 => 0xe1 },
	'clearretouch' => { 293 => 0x7c },
	'clearretouchvalue' => { 293 => 0xa3 },
	'client' => { 461 => 'client' },
	'clientname' => { 443 => 'ClientName' },
	'clmodeshootingspeed' => { 253 => '10.2', 254 => '11.3', 256 => '11.2', 257 => '11.2', 262 => '11.2', 263 => '10.2', 266 => '11.2', 267 => '11.2', 268 => '11.1' },
	'cmcontrast' => { 278 => 0x2022 },
	'cmexposurecompensation' => { 278 => 0x2000 },
	'cmhue' => { 278 => 0x2021 },
	'cmsaturation' => { 278 => 0x2020 },
	'cmsharpness' => { 278 => 0x2023 },
	'cmwhitebalance' => { 278 => 0x2001 },
	'cmwhitebalancecomp' => { 278 => 0x2002 },
	'cmwhitebalancegraypoint' => { 278 => 0x2010 },
	'codec' => { 156 => 'Codec' },
	'codedcharacterset' => { 122 => 0x5a },
	'collection' => { 283 => 'Collection' },
	'collectionname' => { 157 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 157 => 'Collections', 431 => 'collections' },
	'collectionuri' => { 157 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 450 => 'color' },
	'coloraberrationcontrol' => { 246 => 0xc89224b },
	'coloradjustment' => { 364 => 0x14 },
	'coloradjustmentmode' => { 363 => 0x210 },
	'coloranta' => { 466 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 466 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 466 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 466 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 466 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 466 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 466 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 466 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 466 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 466 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 466 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 466 => 'Colorants' },
	'colorantswatchname' => { 466 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 466 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 466 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 466 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 143 => 'ColorBalance' },
	'colorbalanceadj' => { 246 => 0x76a43202 },
	'colorbalanceblue' => { 167 => 0x1e },
	'colorbalancegreen' => { 167 => 0x1d },
	'colorbalancered' => { 167 => 0x1c },
	'colorbalanceversion' => { 188 => 0x4, 189 => 0x4, 190 => 0x0 },
	'colorblur' => { 103 => 0x65 },
	'colorbluron' => { 97 => 0x20704 },
	'colorbooster' => { 246 => 0x5f0e7d23 },
	'colorboostlevel' => { 240 => 0x1 },
	'colorboosttype' => { 240 => 0x0 },
	'colorclass' => { 339 => 0xde, 340 => 'ColorClass' },
	'colorcompensationfilter' => { 170 => [0x3a,0x5f], 172 => 0x111, 384 => 0xb022 },
	'colorcompensationfiltercustom' => { 372 => 0xd, 373 => 0xc },
	'colorcompensationfilterset' => { 372 => 0x8, 373 => 0x7, 374 => 0x18, 389 => 0xf },
	'colorcontrol' => { 275 => 0x102b },
	'colorcorrection' => { 417 => 0x8015 },
	'colorcreatoreffect' => { 270 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0 },
	'coloreffect' => { 293 => 0x28 },
	'colorfilter' => { 106 => 0x17, 107 => 0x3017, 167 => 0x29, 175 => [0x38,0x4d,0x4f], 335 => 0x17 },
	'colorgain' => { 214 => 0x51 },
	'colorhue' => { 97 => 0x20900, 207 => 0x8d },
	'colorimetricreference' => { 113 => 0xc6bf },
	'colorlabel' => { 440 => 'ColorLabel' },
	'colormatrix' => { 274 => 0x200, 275 => 0x1011, 361 => 0xa030 },
	'colormatrix1' => { 113 => 0xc621, 337 => 0x106 },
	'colormatrix2' => { 113 => 0xc622, 278 => 0x200, 337 => 0x226 },
	'colormatrixa' => { 328 => 0x203 },
	'colormatrixadobergb' => { 361 => 0xa032 },
	'colormatrixb' => { 328 => 0x204 },
	'colormatrixnumber' => { 275 => 0x1019 },
	'colormatrixsrgb' => { 361 => 0xa031 },
	'colormode' => { 107 => 0x3015, 118 => 0x1210, 129 => 0x66, 167 => 0x28, 170 => 0x16, 172 => 0x101, 173 => 0x36, 175 => 0x7, 207 => 0x3, 236 => 0x4, 293 => 0x32, 364 => 0x2c, 384 => 0xb029, 449 => 'ColorMode' },
	'colormoirereduction' => { 97 => 0x20670, 247 => 0x15 },
	'colormoirereductionmode' => { 247 => 0x5 },
	'colormoirereductionon' => { 97 => '0x20670.0' },
	'colornoisereduction' => { 417 => 0x8029, 437 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 437 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 247 => 0x18 },
	'colornoisereductionsharpness' => { 247 => 0x1c },
	'colornoisereductionsmoothness' => { 437 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 117 => 0x2 },
	'colorprofile' => { 167 => 0x33 },
	'colorprofilesettings' => { 270 => 0x539 },
	'colorrepresentation' => { 123 => 0x3c },
	'colorsaturationadj' => { 97 => 0x20305 },
	'colorsequence' => { 123 => 0x41 },
	'colorspace' => { 48 => 0x3, 60 => 0xb4, 91 => 0x10b4, 113 => 0xa001, 149 => 'ColorSpace', 168 => 0x2f, 169 => 0x25, 170 => 0x17, 207 => 0x1e, 270 => 0x507, 328 => 0x37, 361 => 0xa011, 364 => 0xb, 372 => 0x1b, 373 => 0x83, 374 => 0xe, 389 => 0x6, 441 => 'ColorSpace' },
	'colortempasshot' => { 37 => 0x4, 38 => 0x7, 39 => 0x1d, 40 => 0x26, 41 => 0x43, 44 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x4b },
	'colortempauto' => { 37 => 0x9, 38 => 0xf, 39 => 0x22, 40 => 0x1c, 41 => 0x48, 44 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x50 },
	'colortempcloudy' => { 37 => 0x22, 38 => 0x37, 39 => 0x31, 40 => 0x35, 41 => 0x5c, 44 => 0x75, 45 => 0x8e, 46 => 0x93, 47 => 0x96, 328 => 0x55 },
	'colortempcustom' => { 41 => 0x84 },
	'colortempcustom1' => { 39 => 0x45 },
	'colortempcustom2' => { 39 => 0x4a },
	'colortempdaylight' => { 37 => 0x18, 38 => 0x27, 39 => 0x27, 40 => 0x2b, 41 => 0x52, 44 => 0x6b, 45 => 0x84, 46 => 0x89, 47 => 0x8c, 328 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 60 => 0xae, 70 => 0x9, 91 => 0x10ae, 118 => 0x1005, 127 => 0x846, 143 => 'ColorTemperature', 168 => [0x6e,0x49], 169 => 0x3f, 170 => [0x39,0x5e], 172 => 0x10b, 175 => [0x3c,0x4c,0x4e], 288 => 0x321, 328 => 0x50, 354 => 0x1308, 384 => 0xb021, 437 => 'Temperature' },
	'colortemperatureadj' => { 417 => 0x8013 },
	'colortemperatureauto' => { 207 => 0x4f },
	'colortemperaturebg' => { 275 => 0x1013 },
	'colortemperaturecustom' => { 372 => 0xc, 373 => 0xb },
	'colortemperaturerg' => { 275 => 0x1014 },
	'colortemperatureset' => { 372 => 0x7, 373 => 0x6 },
	'colortemperaturesetting' => { 170 => 0x25, 374 => 0x17, 389 => 0xe },
	'colortempflash' => { 37 => 0x36, 38 => 0x57, 39 => 0x40, 40 => 0x49, 41 => 0x70, 44 => 0x89, 45 => 0xa2, 46 => 0xa7, 47 => 0xaa, 328 => 0x5a },
	'colortempflashdata' => { 41 => 0x24a },
	'colortempfluorescent' => { 37 => 0x2c, 38 => 0x47, 39 => 0x3b, 40 => 0x3f, 41 => 0x66, 44 => 0x7f, 45 => 0x98, 46 => 0x9d, 47 => 0xa0 },
	'colortempfluorescentd' => { 328 => 0x57 },
	'colortempfluorescentn' => { 328 => 0x58 },
	'colortempfluorescentw' => { 328 => 0x59 },
	'colortempkelvin' => { 37 => 0x31, 38 => 0x4f, 40 => 0x44, 41 => 0x6b, 44 => 0x84, 45 => 0x9d, 46 => 0xa2, 47 => 0xa5, 293 => 0x44, 354 => 0x1307 },
	'colortempmeasured' => { 37 => 0xe, 38 => 0x17, 41 => 0x4d, 44 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x55 },
	'colortemppc1' => { 40 => 0x94, 41 => 0x75 },
	'colortemppc2' => { 40 => 0x99, 41 => 0x7a },
	'colortemppc3' => { 40 => 0x9e, 41 => 0x7f },
	'colortempshade' => { 37 => 0x1d, 38 => 0x2f, 39 => 0x2c, 40 => 0x30, 41 => 0x57, 44 => 0x70, 45 => 0x89, 46 => 0x8e, 47 => 0x91, 328 => 0x54 },
	'colortemptungsten' => { 37 => 0x27, 38 => 0x3f, 39 => 0x36, 40 => 0x3a, 41 => 0x61, 44 => 0x7a, 45 => 0x93, 46 => 0x98, 47 => 0x9b, 328 => 0x56 },
	'colortempunknown' => { 37 => 0x13, 38 => 0x1f, 40 => 0x21, 44 => 0x52, 45 => 0x52, 46 => 0x52, 47 => 0x5a },
	'colortempunknown10' => { 37 => 0x63, 38 => 0x9f, 40 => 0x76, 44 => 0xa2, 45 => 0x7f, 46 => 0x7f, 47 => 0x87 },
	'colortempunknown11' => { 37 => 0x68, 38 => 0xa7, 40 => 0x7b, 44 => 0xa7, 45 => 0xa7, 46 => 0x84, 47 => 0xaf },
	'colortempunknown12' => { 37 => 0x6d, 38 => 0xaf, 40 => 0x80, 44 => 0xac, 45 => 0xac, 46 => 0xac, 47 => 0xb4 },
	'colortempunknown13' => { 37 => 0x72, 38 => 0xb7, 40 => 0x85, 44 => 0xb1, 45 => 0xb1, 46 => 0xb1, 47 => 0xb9 },
	'colortempunknown14' => { 40 => 0x8a, 44 => 0xb6, 45 => 0xb6, 46 => 0xb6, 47 => 0xbe },
	'colortempunknown15' => { 40 => 0x8f, 44 => 0xbb, 45 => 0xbb, 46 => 0xbb, 47 => 0xc3 },
	'colortempunknown16' => { 40 => 0xa3, 45 => 0xc0, 46 => 0xc0, 47 => 0xc8 },
	'colortempunknown17' => { 45 => 0xc5, 46 => 0xc5, 47 => 0xcd },
	'colortempunknown18' => { 45 => 0xca, 46 => 0xca, 47 => 0xd2 },
	'colortempunknown19' => { 45 => 0xcf, 46 => 0xcf, 47 => 0xd7 },
	'colortempunknown2' => { 37 => 0x3b, 38 => 0x5f, 40 => 0x4e, 44 => 0x57, 45 => 0x57, 46 => 0x57, 47 => 0x5f },
	'colortempunknown20' => { 45 => 0xd4, 46 => 0xd4, 47 => 0xdc },
	'colortempunknown21' => { 46 => 0xd9, 47 => 0xe1 },
	'colortempunknown22' => { 46 => 0xde, 47 => 0xe6 },
	'colortempunknown23' => { 46 => 0xe3, 47 => 0xeb },
	'colortempunknown24' => { 46 => 0xe8, 47 => 0xf0 },
	'colortempunknown25' => { 46 => 0xed, 47 => 0xf5 },
	'colortempunknown26' => { 46 => 0xf2, 47 => 0xfa },
	'colortempunknown27' => { 46 => 0xf7, 47 => 0xff },
	'colortempunknown28' => { 46 => 0xfc, 47 => 0x104 },
	'colortempunknown29' => { 46 => 0x101, 47 => 0x109 },
	'colortempunknown3' => { 37 => 0x40, 38 => 0x67, 40 => 0x53, 44 => 0x5c, 45 => 0x5c, 46 => 0x5c, 47 => 0x64 },
	'colortempunknown30' => { 46 => 0x106 },
	'colortempunknown4' => { 37 => 0x45, 38 => 0x6f, 40 => 0x58, 44 => 0x61, 45 => 0x61, 46 => 0x61, 47 => 0x69 },
	'colortempunknown5' => { 37 => 0x4a, 38 => 0x77, 40 => 0x5d, 44 => 0x66, 45 => 0x66, 46 => 0x66, 47 => 0x6e },
	'colortempunknown6' => { 37 => 0x4f, 38 => 0x7f, 40 => 0x62, 44 => 0x8e, 45 => 0x6b, 46 => 0x6b, 47 => 0x73 },
	'colortempunknown7' => { 37 => 0x54, 38 => 0x87, 40 => 0x67, 44 => 0x93, 45 => 0x70, 46 => 0x70, 47 => 0x78 },
	'colortempunknown8' => { 37 => 0x59, 38 => 0x8f, 40 => 0x6c, 44 => 0x98, 45 => 0x75, 46 => 0x75, 47 => 0x7d },
	'colortempunknown9' => { 37 => 0x5e, 38 => 0x97, 40 => 0x71, 44 => 0x9d, 45 => 0x7a, 46 => 0x7a, 47 => 0x82 },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 48 => 0x2 },
	'colortoneadj' => { 97 => 0x20304, 102 => 0x11e },
	'colortoneauto' => { 67 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 66 => 0x6c, 67 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 66 => 0x3c, 67 => 0x3c },
	'colortonemonochrome' => { 66 => 0x84, 67 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 66 => 0x54, 67 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 66 => 0x24, 67 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 66 => 0xc, 67 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 66 => 0x9c, 67 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 66 => 0xb4, 67 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 66 => 0xcc, 67 => 0xe4 },
	'commanddials' => { 264 => '5.1' },
	'commanddialsaperturesetting' => { 253 => '17.3', 254 => '18.3', 256 => '18.3', 257 => '18.3', 262 => '33.3', 263 => '17.3', 266 => '18.3', 267 => '18.3' },
	'commanddialschangemainsub' => { 253 => '17.2', 254 => '18.1', 256 => '18.1', 257 => '18.1', 262 => '33.2', 263 => '17.2', 266 => '18.1', 267 => '18.1' },
	'commanddialsmenuandplayback' => { 253 => '17.4', 254 => '18.2', 256 => '18.2', 257 => '18.2', 262 => '33.4', 263 => '17.4', 266 => '18.2', 267 => '18.2' },
	'commanddialsreverserotation' => { 253 => '17.1', 254 => '6.4', 256 => '6.2', 257 => '6.2', 258 => '16.2', 259 => '17.2', 262 => '33.1', 263 => '17.1', 266 => '6.2', 267 => '6.2', 268 => '18.1' },
	'commanderchannel' => { 264 => '10.2', 265 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 264 => '13.1', 265 => '31.1' },
	'commandergroupa_ttlcomp' => { 268 => '32.1' },
	'commandergroupamanualoutput' => { 264 => '13.2', 265 => '28.2' },
	'commandergroupamode' => { 264 => '11.2', 265 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 264 => '14.1', 265 => '32.1' },
	'commandergroupb_ttlcomp' => { 268 => '33.1' },
	'commandergroupbmanualoutput' => { 264 => '14.2', 265 => '29.2' },
	'commandergroupbmode' => { 264 => '11.3', 265 => '29.1' },
	'commanderinternalflash' => { 264 => '11.1', 265 => '27.1' },
	'commanderinternalmanualoutput' => { 264 => '12.2', 265 => '27.2' },
	'commanderinternalttlchannel' => { 262 => '18.2' },
	'commanderinternalttlcomp' => { 264 => '12.1', 265 => '30.2', 268 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 262 => '20.1', 263 => '26.1' },
	'commanderinternalttlcompgroupa' => { 262 => '21.1', 263 => '27.1' },
	'commanderinternalttlcompgroupb' => { 262 => '22.1', 263 => '28.1' },
	'comment' => { 0 => 0x2, 114 => 'Comment', 144 => 'Comment', 283 => 'Comment' },
	'compass' => { 357 => 0x4 },
	'complianceprofile' => { 451 => 'complianceProfile' },
	'componentsconfiguration' => { 113 => 0x9101, 149 => 'Components', 441 => 'ComponentsConfiguration' },
	'componentversion' => { 91 => 0x80c },
	'composer' => { 461 => 'composer' },
	'composition' => { 427 => 'Composition' },
	'compositionadjust' => { 327 => '0.1' },
	'compositionadjustrotation' => { 327 => 0x7 },
	'compositionadjustx' => { 327 => 0x5 },
	'compositionadjusty' => { 327 => 0x6 },
	'compressedbitsperpixel' => { 113 => 0x9102, 441 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 172 => 0x40, 275 => 0x40 },
	'compression' => { 113 => 0x103, 298 => 0xb, 457 => 'Compression' },
	'compressionfactor' => { 270 => 0x50d },
	'compressionratio' => { 149 => 'Compression', 275 => 0x1034 },
	'confidence' => { 422 => 'Confidence' },
	'confidencelevel' => { 432 => 'ConfidenceLevel' },
	'confidencemime' => { 422 => 'ConfidenceMime' },
	'constrainedcropheight' => { 102 => 0x266, 339 => 0xd6 },
	'constrainedcropwidth' => { 102 => 0x262, 339 => 0xd5 },
	'contact' => { 121 => 0x76 },
	'contactinfo' => { 450 => 'contactInfo' },
	'containerformat' => { 447 => 'ContainerFormat' },
	'containerformatidentifier' => { 447 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 447 => [\'ContainerFormat','ContainerFormatName'] },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 121 => 0x1a },
	'contentlocationname' => { 121 => 0x1b },
	'contenttype' => { 451 => 'contentType' },
	'continuousbracketing' => { 170 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousmodeliveview' => { 267 => '77.2' },
	'continuousshootingspeed' => { 78 => 0x610 },
	'continuousshotlimit' => { 78 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 106 => 0xc, 107 => [0x3012,0x20], 113 => [0xa408,0xfe54], 118 => [0x1004,0x1006], 143 => 'Contrast', 163 => 'Contrast', 167 => 0x20, 168 => 0x31, 169 => 0x27, 170 => 0x19, 175 => 0x2, 209 => 0x33, 210 => 0x37, 275 => 0x1029, 293 => 0x39, 295 => 0x300a, 328 => 0x20, 335 => 0xc, 349 => 0x24, 354 => 0x1012, 364 => 0xd, 372 => 0x1d, 373 => 0x1a, 384 => 0x2004, 437 => 'Contrast', 441 => 'Contrast' },
	'contrast2012' => { 437 => 'Contrast2012' },
	'contrastadj' => { 97 => 0x20303, 102 => 0x115, 249 => 0x2c, 417 => 0x8017 },
	'contrastauto' => { 67 => 0x90 },
	'contrastcurve' => { 207 => 0x8c },
	'contrastdetectaf' => { 179 => 0x4 },
	'contrastdetectafarea' => { 328 => 0x231 },
	'contrastdetectafinfocus' => { 179 => [0x1c,0x52] },
	'contrastfaithful' => { 18 => 0xec, 66 => 0x60, 67 => 0x60 },
	'contrasthighlight' => { 328 => 0x6d },
	'contrasthighlightshadowadj' => { 328 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 66 => 0x30, 67 => 0x30 },
	'contrastmode' => { 293 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 66 => 0x78, 67 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 66 => 0x48, 67 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 66 => 0x18, 67 => 0x18 },
	'contrastsetting' => { 270 => 0x505, 278 => 0x1012, 374 => 0x10, 389 => 0x8 },
	'contrastshadow' => { 328 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 66 => 0x0, 67 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 66 => 0x90, 67 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 66 => 0xa8, 67 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 66 => 0xc0, 67 => 0xd8 },
	'contributedmedia' => { 461 => 'contributedMedia' },
	'contributedmediaduration' => { 461 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 461 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 461 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 461 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 461 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 461 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 461 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 461 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 461 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 461 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 438 => 'contributor', 447 => 'Contributor' },
	'contributoridentifier' => { 447 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 447 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 447 => [\'Contributor','ContributorRole'] },
	'contributors' => { 144 => 'Contributors' },
	'controldialset' => { 170 => 0x46 },
	'controlledvocabularyterm' => { 447 => 'CVterm' },
	'controllerboardversion' => { 288 => 0x332 },
	'controlmode' => { 72 => 0x12 },
	'conversionlens' => { 271 => 0x403, 293 => 0x35 },
	'converter' => { 113 => 0xfe4d, 236 => 0xb, 437 => 'Converter' },
	'converttograyscale' => { 437 => 'ConvertToGrayscale' },
	'cookingequipment' => { 453 => 'cookingEquipment' },
	'cookingmethod' => { 453 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 113 => 0x8298, 144 => 'Copyright', 283 => 'Copyright', 328 => 0x22f, 344 => 'Copyright', 448 => 'Copyright', 454 => 'copyright', 457 => 'Copyright', 461 => 'copyright' },
	'copyrightflag' => { 342 => 0x40a },
	'copyrightnotice' => { 121 => 0x74 },
	'copyrightowner' => { 280 => 'CopyrightOwner' },
	'copyrightownerid' => { 280 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 280 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 280 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 280 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 280 => 'CopyrightStatus' },
	'copyrightyear' => { 447 => 'CopyrightYear', 451 => 'copyrightYear' },
	'coringfilter' => { 274 => 0x310, 275 => 0x102d, 278 => 0x310 },
	'coringvalues' => { 274 => 0x311, 278 => 0x311 },
	'corporateentity' => { 451 => 'corporateEntity' },
	'country' => { 148 => 'Country', 293 => 0x69, 449 => 'Country' },
	'country-primarylocationcode' => { 121 => 0x64 },
	'country-primarylocationname' => { 121 => 0x65 },
	'countrycode' => { 206 => 0x5, 340 => 'CountryCode', 446 => 'CountryCode' },
	'course' => { 453 => 'course' },
	'coverage' => { 438 => 'coverage' },
	'coverdate' => { 451 => 'coverDate' },
	'coverdisplaydate' => { 451 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 328 => 0x28 },
	'crc32' => { 439 => 'crc32' },
	'createdate' => { 113 => 0x9004, 144 => 'CreateDate', 279 => 'CreationDate', 283 => 'create-date', 344 => 'CreationDate', 346 => 0x1, 459 => 'CreateDate' },
	'creationdate' => { 448 => 'CreationDate', 451 => 'creationDate' },
	'creationtime' => { 283 => 'Creation Time' },
	'creativestyle' => { 372 => 0x1a, 373 => 0x18, 383 => 0x41, 384 => 0xb020, 413 => 0x4a },
	'creativestylesetting' => { 374 => 0xf, 389 => 0x7 },
	'creativestylewaschanged' => { 417 => 0x8001 },
	'creator' => { 279 => 'Creator', 344 => 'Creator', 438 => 'creator', 447 => 'Creator', 448 => 'Creator' },
	'creatoraddress' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 165 => 'CreatorAppId' },
	'creatorcity' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 446 => 'CreatorContactInfo' },
	'creatorcountry' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 447 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 447 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 165 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 447 => [\'Creator','CreatorRole'] },
	'creatortool' => { 459 => 'CreatorTool' },
	'creatorworkemail' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 446 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 121 => 0x6e, 449 => 'Credit' },
	'creditline' => { 454 => 'creditLine' },
	'creditlinereq' => { 464 => 'CreditLineReq' },
	'creditlinerequired' => { 280 => 'CreditLineRequired' },
	'cropactive' => { 95 => 0x0, 102 => 0x244 },
	'cropangle' => { 437 => 'CropAngle' },
	'cropaspectratio' => { 97 => 0x30101, 102 => 0x260 },
	'cropaspectratiocustom' => { 97 => 0x30102 },
	'cropbottom' => { 117 => 0x9, 241 => 0x36, 298 => 0x31, 339 => 0xdc, 437 => 'CropBottom' },
	'cropbottommargin' => { 50 => 0x3 },
	'cropcircleactive' => { 103 => 0xd6 },
	'cropcircleradius' => { 103 => 0xd9 },
	'cropcirclex' => { 103 => 0xd7 },
	'cropcircley' => { 103 => 0xd8 },
	'cropconstraintowarp' => { 437 => 'CropConstrainToWarp' },
	'croph' => { 430 => 'CropH' },
	'cropheight' => { 95 => 0x6, 102 => 0x24c, 274 => 0x615, 278 => 0x615, 437 => 'CropHeight' },
	'crophispeed' => { 207 => 0x1b },
	'cropleft' => { 102 => 0x246, 117 => 0x6, 241 => 0x1e, 274 => 0x612, 278 => 0x612, 298 => 0x30, 339 => 0xd9, 437 => 'CropLeft' },
	'cropleftmargin' => { 50 => 0x0 },
	'cropmode35mm' => { 354 => 0x1018 },
	'croporiginalheight' => { 95 => 0xb },
	'croporiginalwidth' => { 95 => 0xa },
	'cropoutputheight' => { 241 => 0xce },
	'cropoutputheightinches' => { 241 => 0x96 },
	'cropoutputpixels' => { 241 => 0xd6 },
	'cropoutputresolution' => { 241 => 0xb6 },
	'cropoutputscale' => { 241 => 0xbe },
	'cropoutputwidth' => { 241 => 0xc6 },
	'cropoutputwidthinches' => { 241 => 0x8e },
	'croppedareaimageheightpixels' => { 425 => 'CroppedAreaImageHeightPixels', 426 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 425 => 'CroppedAreaImageWidthPixels', 426 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 425 => 'CroppedAreaLeftPixels', 426 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 425 => 'CroppedAreaTopPixels', 426 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 354 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 354 => 0x1603 },
	'cropright' => { 117 => 0x8, 241 => 0x2e, 298 => 0x32, 339 => 0xdb, 437 => 'CropRight' },
	'croprightmargin' => { 50 => 0x1 },
	'croprotatedoriginalheight' => { 95 => 0x2 },
	'croprotatedoriginalwidth' => { 95 => 0x1 },
	'croprotation' => { 95 => 0x8, 117 => 0xb },
	'cropscaledresolution' => { 241 => 0x9e },
	'cropsourceresolution' => { 241 => 0xae },
	'croptop' => { 102 => 0x248, 117 => 0x7, 241 => 0x26, 274 => 0x613, 278 => 0x613, 298 => 0x2f, 339 => 0xda, 437 => 'CropTop' },
	'croptopmargin' => { 50 => 0x2 },
	'cropunit' => { 437 => 'CropUnit' },
	'cropunits' => { 437 => 'CropUnits' },
	'cropw' => { 430 => 'CropW' },
	'cropwidth' => { 95 => 0x5, 102 => 0x24a, 274 => 0x614, 278 => 0x614, 437 => 'CropWidth' },
	'cropx' => { 95 => 0x3, 430 => 'CropX' },
	'cropy' => { 95 => 0x4, 430 => 'CropY' },
	'crossprocess' => { 328 => 0x7b },
	'crossprocessparams' => { 328 => 0x235 },
	'cuisine' => { 453 => 'cuisine' },
	'currenticcprofile' => { 113 => 0xc691 },
	'currentpreprofilematrix' => { 113 => 0xc692 },
	'currentversion' => { 417 => 0xd000 },
	'curve0x' => { 430 => 'Curve0x' },
	'curve0y' => { 430 => 'Curve0y' },
	'curve1x' => { 430 => 'Curve1x' },
	'curve1y' => { 430 => 'Curve1y' },
	'curve2x' => { 430 => 'Curve2x' },
	'curve2y' => { 430 => 'Curve2y' },
	'curve3x' => { 430 => 'Curve3x' },
	'curve3y' => { 430 => 'Curve3y' },
	'curve4x' => { 430 => 'Curve4x' },
	'curve4y' => { 430 => 'Curve4y' },
	'curves' => { 246 => 0x76a43201 },
	'custom1' => { 280 => 'Custom1' },
	'custom10' => { 280 => 'Custom10' },
	'custom2' => { 280 => 'Custom2' },
	'custom3' => { 280 => 'Custom3' },
	'custom4' => { 280 => 'Custom4' },
	'custom5' => { 280 => 'Custom5' },
	'custom6' => { 280 => 'Custom6' },
	'custom7' => { 280 => 'Custom7' },
	'custom8' => { 280 => 'Custom8' },
	'custom9' => { 280 => 'Custom9' },
	'customcolortone' => { 103 => 0x4c },
	'customcontrast' => { 103 => 0x4e },
	'customcontrols' => { 78 => 0x70c },
	'customdefaultunsharpfineness' => { 103 => 0xbe },
	'customdefaultunsharpstrength' => { 103 => 0xbc },
	'customdefaultunsharpthreshold' => { 103 => 0xc0 },
	'customlinear' => { 103 => 0x4f },
	'customoutputhighlightpoint' => { 103 => 0x53 },
	'customoutputshadowpoint' => { 103 => 0x54 },
	'custompicturestyle' => { 97 => 0x10021 },
	'custompicturestyledata' => { 97 => 0xf0500 },
	'custompicturestylefilename' => { 60 => 0x4010 },
	'customrawhighlight' => { 103 => 0x7c },
	'customrawhighlightpoint' => { 103 => 0x51 },
	'customrawshadow' => { 103 => 0x85 },
	'customrawshadowpoint' => { 103 => 0x52 },
	'customrendered' => { 113 => 0xa401, 441 => 'CustomRendered' },
	'customsaturation' => { 103 => 0x4d, 270 => 0x503 },
	'customsettingsalldefault' => { 253 => '0.2', 262 => '0.2' },
	'customsettingsbank' => { 253 => '0.1', 254 => '0.1', 256 => '0.1', 257 => '0.1', 262 => '0.1', 266 => '0.2', 267 => '0.2' },
	'customsharpness' => { 103 => 0x50 },
	'customunsharpmaskfineness' => { 103 => 0xb8 },
	'customunsharpmaskstrength' => { 103 => 0xb6 },
	'customunsharpmaskthreshold' => { 103 => 0xba },
	'customwb_rblevels' => { 389 => 0x1a },
	'customwb_rgblevels' => { 373 => 0x8, 374 => 0x19 },
	'customwbbluelevel' => { 170 => 0x36 },
	'customwberror' => { 170 => 0x37 },
	'customwbgreenlevel' => { 170 => 0x35 },
	'customwbredlevel' => { 170 => 0x34 },
	'customwbsetting' => { 170 => 0x26 },
	'd-lightinghq' => { 246 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 242 => 0x2 },
	'd-lightinghqhighlight' => { 242 => 0x1 },
	'd-lightinghqselected' => { 246 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 242 => 0x0 },
	'd-lightinghs' => { 246 => 0xce5554aa },
	'd-lightinghsadjustment' => { 243 => 0x0 },
	'd-lightinghscolorboost' => { 243 => 0x1 },
	'd-rangeoptimizerhighlight' => { 417 => 0x8024 },
	'd-rangeoptimizermode' => { 417 => 0x8022 },
	'd-rangeoptimizershadow' => { 417 => 0x802d },
	'd-rangeoptimizervalue' => { 417 => 0x8023 },
	'd810meteringmode' => { 233 => 0x175e },
	'data' => { 422 => 'Data' },
	'datacompressionmethod' => { 123 => 0x6e },
	'dataimprint' => { 167 => 0x34 },
	'dataonscreen' => { 447 => 'DataOnScreen' },
	'dataonscreenregion' => { 447 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 447 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 447 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 447 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 447 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 447 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 447 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 447 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 328 => 0x3d },
	'date' => { 328 => 0x6, 438 => 'date' },
	'dateacquired' => { 165 => 'DateAcquired' },
	'datecreated' => { 121 => 0x37, 449 => 'DateCreated' },
	'datedisplayformat' => { 238 => 0x3 },
	'dateidentified' => { 112 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 258 => '4.2' },
	'daterecieved' => { 451 => 'dateRecieved' },
	'datesent' => { 122 => 0x46 },
	'datestampmode' => { 60 => 0x1c },
	'datetime' => { 431 => 'datetime', 457 => 'DateTime' },
	'datetimedigitized' => { 441 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 94 => 0x0, 113 => 0x9003, 141 => 0x14, 144 => 'OriginalDate', 349 => 0xb, 350 => 0x3b, 441 => 'DateTimeOriginal' },
	'datetimestamp' => { 129 => 0x64 },
	'datetimeutc' => { 270 => 0x908 },
	'daylightsavings' => { 73 => 0x3, 238 => 0x2 },
	'dayofweek' => { 350 => 0x42 },
	'dccontinent' => { 112 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 112 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 112 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 112 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 112 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 112 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 112 => 'Event' },
	'dcfootprintspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 112 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 112 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 112 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 112 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 112 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 112 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 112 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 112 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 112 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 112 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 112 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 112 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 152 => 'Declination' },
	'decposition' => { 167 => 0x32 },
	'defaultautogray' => { 437 => 'DefaultAutoGray' },
	'defaultautotone' => { 437 => 'DefaultAutoTone' },
	'defaultblackrender' => { 113 => 0xc7a6 },
	'defaultcroporigin' => { 113 => 0xc61f },
	'defaultcropsize' => { 113 => 0xc620 },
	'defaulteraseoption' => { 78 => 0x813 },
	'defaultscale' => { 113 => 0xc61e },
	'defaultsspecifictoiso' => { 437 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 437 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 113 => 0xc7b5 },
	'defringe' => { 437 => 'Defringe' },
	'defringegreenamount' => { 437 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 437 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 437 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 437 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 437 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 437 => 'DefringePurpleHueLo' },
	'dehaze' => { 437 => 'Dehaze' },
	'deletedimagecount' => { 207 => 0xa6, 215 => 0x6e },
	'deprecatedon' => { 434 => 'deprecatedOn' },
	'derivedfrom' => { 462 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 462 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 462 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 462 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 462 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 462 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 462 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 462 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 462 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 462 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 462 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 462 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 462 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 462 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 462 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 462 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 462 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 462 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 462 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 462 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 462 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 462 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 462 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 462 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 283 => 'Description', 438 => 'description', 459 => 'Description' },
	'destination' => { 122 => 0x5 },
	'destinationcity' => { 328 => 0x24, 334 => 0x3 },
	'destinationcitycode' => { 335 => 0x1001 },
	'destinationdst' => { 328 => 0x26, 334 => '0.3' },
	'developmentdynamicrange' => { 118 => 0x1403 },
	'device' => { 451 => 'device' },
	'devicesettingdescription' => { 441 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 441 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 441 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 441 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 361 => 0x2 },
	'dialdirectiontvav' => { 78 => 0x706 },
	'dietaryneeds' => { 453 => 'dietaryNeeds' },
	'diffractioncorrection' => { 293 => 0xbc, 318 => 0x3 },
	'diffractioncorrectionon' => { 97 => 0x2070b },
	'digitalcreationdate' => { 121 => 0x3e },
	'digitalcreationtime' => { 121 => 0x3f },
	'digitaldeehighlightadj' => { 214 => 0x202 },
	'digitaldeeshadowadj' => { 214 => 0x200 },
	'digitaldeethreshold' => { 214 => 0x201 },
	'digitalfilter' => { 364 => 0x59 },
	'digitalfilter01' => { 315 => 0x5 },
	'digitalfilter02' => { 315 => 0x16 },
	'digitalfilter03' => { 315 => 0x27 },
	'digitalfilter04' => { 315 => 0x38 },
	'digitalfilter05' => { 315 => 0x49 },
	'digitalfilter06' => { 315 => 0x5a },
	'digitalfilter07' => { 315 => 0x6b },
	'digitalfilter08' => { 315 => 0x7c },
	'digitalfilter09' => { 315 => 0x8d },
	'digitalfilter10' => { 315 => 0x9e },
	'digitalfilter11' => { 315 => 0xaf },
	'digitalfilter12' => { 315 => 0xc0 },
	'digitalfilter13' => { 315 => 0xd1 },
	'digitalfilter14' => { 315 => 0xe2 },
	'digitalfilter15' => { 315 => 0xf3 },
	'digitalfilter16' => { 315 => 0x104 },
	'digitalfilter17' => { 315 => 0x115 },
	'digitalfilter18' => { 315 => 0x126 },
	'digitalfilter19' => { 315 => 0x137 },
	'digitalfilter20' => { 315 => 0x148 },
	'digitalgain' => { 70 => 0xb },
	'digitalgem' => { 199 => 0x0 },
	'digitalice' => { 214 => 0x100 },
	'digitalimageguid' => { 447 => 'DigImageGUID' },
	'digitalroc' => { 212 => 0x0 },
	'digitalsourcefiletype' => { 447 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 447 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 106 => 0xa, 118 => 0x1044, 129 => 0x68, 143 => 'DigitalZoom', 167 => 0xc, 207 => 0x86, 236 => 0xa, 275 => 0x204, 328 => 0x1e, 335 => 0xa, 363 => 0x204, 404 => 0x12, 405 => 0x12 },
	'digitalzoomon' => { 363 => 0x21b },
	'digitalzoomratio' => { 113 => 0xa404, 394 => 0x200, 396 => 0x21c, 441 => 'DigitalZoomRatio' },
	'director' => { 461 => 'director' },
	'directorphotography' => { 461 => 'directorPhotography' },
	'directory' => { 114 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 193 => 0x3 },
	'disclaimer' => { 283 => 'Disclaimer' },
	'discnumber' => { 461 => 'discNumber' },
	'dishtype' => { 453 => 'dishType' },
	'displayallafpoints' => { 78 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 343 => 0x2 },
	'displayedunitsy' => { 343 => 0x6 },
	'displayname' => { 450 => 'displayName' },
	'distance1' => { 129 => 0x28 },
	'distance2' => { 129 => 0x2c },
	'distance3' => { 129 => 0x30 },
	'distance4' => { 129 => 0x34 },
	'distortion' => { 361 => 0xa050 },
	'distortioncontrol' => { 215 => 0x10 },
	'distortioncorrection' => { 97 => 0x20705, 103 => 0x67, 113 => 0x7036, 270 => 0x50b, 297 => '7.1', 318 => 0x0, 412 => 0x601, 413 => 0x5b },
	'distortioncorrection2' => { 274 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 433 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 97 => '0x20705.0', 103 => 0x63 },
	'distortioncorrectionsetting' => { 384 => 0x2013 },
	'distortioncorrparams' => { 113 => 0x7037, 393 => 0x1a23, 396 => 0x1870, 398 => 0x189c, 399 => 0x18cc, 400 => 0x17d0, 412 => 0x6ca, 413 => 0x64 },
	'distortioncorrparamsnumber' => { 396 => 0x1899, 398 => 0x18c5, 399 => 0x18f5, 400 => 0x17f9 },
	'distortioncorrparamspresent' => { 396 => 0x1898, 398 => 0x18c4, 399 => 0x18f4, 400 => 0x17f8, 402 => 0x10b, 403 => 0x10b, 412 => 0x600, 413 => 0x5a },
	'distortioneffect' => { 97 => 0x20709 },
	'distortionn' => { 297 => 0xc },
	'distortionparam02' => { 297 => 0x2 },
	'distortionparam04' => { 297 => 0x4 },
	'distortionparam08' => { 297 => 0x8 },
	'distortionparam09' => { 297 => 0x9 },
	'distortionparam11' => { 297 => 0xb },
	'distortionscale' => { 297 => 0x5 },
	'distributor' => { 451 => 'distributor' },
	'distributorproductid' => { 450 => 'distributorProductID' },
	'dloon' => { 97 => '0x20706.0', 103 => 0xdc },
	'dlosetting' => { 97 => 0x20706, 103 => 0xdd },
	'dlosettingapplied' => { 96 => 0x4 },
	'dloshootingdistance' => { 103 => 0xde },
	'dloversion' => { 96 => 0x5 },
	'dmcomment' => { 461 => 'comment' },
	'dngadobedata' => { 113 => 0xc634 },
	'dngbackwardversion' => { 113 => 0xc613 },
	'dngignoresidecars' => { 437 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 113 => 0xc630 },
	'dngprivatedata' => { 113 => 0xc634 },
	'dngversion' => { 113 => 0xc612 },
	'document' => { 283 => 'Document' },
	'documentancestors' => { 449 => 'DocumentAncestors' },
	'documenthistory' => { 121 => 0xe7 },
	'documentid' => { 462 => 'DocumentID' },
	'documentname' => { 113 => 0x10d },
	'documentnotes' => { 121 => 0xe6 },
	'doi' => { 451 => 'doi' },
	'dopesheet' => { 447 => 'Dopesheet' },
	'dopesheetlink' => { 447 => 'DopesheetLink' },
	'dopesheetlinklink' => { 447 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 447 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'dpp' => { 431 => 'dpp' },
	'dr4cameramodel' => { 98 => 0x3 },
	'drivemode' => { 107 => 0x3103, 167 => 0x6, 170 => 0x1e, 173 => 0xe, 270 => 0x600, 328 => 0x34, 354 => 0x1002, 364 => 0x3, 372 => 0x4, 373 => 0x7e, 374 => 0x34 },
	'drivemode2' => { 170 => 0xa, 309 => 0x7, 383 => 0xe, 389 => 0x1 },
	'drivemodesetting' => { 374 => 0x4 },
	'dspfirmwareversion' => { 328 => 0x27 },
	'duration' => { 63 => 0x6a, 142 => 'Duration', 156 => 'Duration', 453 => 'duration', 461 => 'duration' },
	'durationscale' => { 461 => [\'duration','durationScale'] },
	'durationvalue' => { 461 => [\'duration','durationValue'] },
	'dustremovaldata' => { 60 => 0x97 },
	'dynamicafarea' => { 253 => '1.4', 262 => '1.4' },
	'dynamicareaafdisplay' => { 254 => '46.1', 256 => '47.1', 257 => '47.1', 266 => '47.1', 267 => '47.1' },
	'dynamicrange' => { 118 => 0x1400 },
	'dynamicrangeexpansion' => { 328 => 0x69, 354 => 0x100e },
	'dynamicrangemax' => { 102 => 0x7c },
	'dynamicrangemin' => { 102 => 0x7a },
	'dynamicrangeoptimizer' => { 170 => 0x15, 384 => [0xb025,0xb04f], 392 => 0x1144, 393 => [0x1144,0x324], 394 => [0x1120,0x300], 395 => [0x119c,0x37c], 396 => [0x1178,0x328], 397 => [0x1030,0x50], 398 => [0x228,0x50], 399 => [0x228,0x50], 400 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 383 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 372 => 0x19, 373 => 0x17, 374 => 0xd, 383 => 0x79, 389 => 0x5 },
	'dynamicrangeoptimizermode' => { 173 => 0x15, 372 => 0x18, 373 => 0x16, 383 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 170 => 0x27, 374 => 0xc, 389 => 0x4 },
	'dynamicrangesetting' => { 118 => 0x1402 },
	'e-dialinprogram' => { 309 => '1.3' },
	'earliestageorloweststage' => { 112 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 268 => '6.1' },
	'easyexposurecompensation' => { 253 => '6.4', 254 => '6.5', 256 => '6.3', 257 => '6.3', 261 => '5.1', 262 => '4.4', 263 => '5.2', 266 => '6.3', 267 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgenoisereduction' => { 247 => 0x4, 417 => 0x8028 },
	'edition' => { 451 => 'edition' },
	'editorialupdate' => { 121 => 0x8 },
	'editstatus' => { 121 => 0x7, 340 => 'EditStatus', 431 => 'EditStatus' },
	'editversionname' => { 246 => 0x3d136244 },
	'effectivelv' => { 328 => 0x2d },
	'effectivemaxaperture' => { 203 => 0x12, 204 => 0x13 },
	'eissn' => { 451 => 'eIssn' },
	'electronicfront-curtainshutter' => { 256 => '5.2', 257 => '5.2', 266 => '5.3', 267 => '5.2' },
	'electronicfrontcurtainshutter' => { 384 => 0x201a },
	'elevation' => { 152 => 'Elevation' },
	'email' => { 144 => 'EMail' },
	'embargodate' => { 454 => 'embargoDate' },
	'embdencrightsexpr' => { 447 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 447 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 447 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 447 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 449 => 'EmbeddedXMPDigest' },
	'emissivity' => { 115 => 0x3 },
	'encryptionkey' => { 361 => 0xa020 },
	'endingpage' => { 451 => 'endingPage' },
	'enduser' => { 280 => 'EndUser' },
	'enduserid' => { 280 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 280 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 461 => 'engineer' },
	'enhancedarktones' => { 239 => 0x8 },
	'enhancement' => { 106 => 0x16, 107 => 0x3016 },
	'enhancer' => { 274 => 0x300 },
	'enhancervalues' => { 274 => 0x301 },
	'envelopenumber' => { 122 => 0x28 },
	'envelopepriority' => { 122 => 0x3c },
	'enveloperecordversion' => { 122 => 0x0 },
	'episode' => { 447 => 'Episode' },
	'episodeidentifier' => { 447 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 447 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 447 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 275 => 0x20c },
	'epsonimagewidth' => { 275 => 0x20b },
	'epsonsoftware' => { 275 => 0x20d },
	'equipmentinstitution' => { 419 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 419 => 'EquipmentManufacturer' },
	'equipmentversion' => { 271 => 0x0 },
	'ettlii' => { 78 => 0x304, 79 => 0xd, 80 => 0xe, 81 => 0x7, 82 => 0x7, 83 => 0xe },
	'event' => { 420 => 'Event', 429 => 'Event', 447 => 'Event', 451 => 'event' },
	'eventalias' => { 450 => 'eventAlias' },
	'eventdate' => { 112 => [\'Event','EventEventDate'] },
	'eventday' => { 112 => [\'Event','EventDay'] },
	'eventearliestdate' => { 112 => [\'Event','EventEarliestDate'] },
	'eventend' => { 450 => 'eventEnd' },
	'eventenddayofyear' => { 112 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 112 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 112 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 112 => [\'Event','EventHabitat'] },
	'eventid' => { 112 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 112 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 112 => [\'Event','EventMonth'] },
	'eventnumber' => { 349 => 0x9, 350 => 0x37 },
	'eventparenteventid' => { 112 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 112 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 112 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 112 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 112 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 112 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 450 => 'eventStart' },
	'eventstartdayofyear' => { 112 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 450 => 'eventSubtype' },
	'eventtime' => { 112 => [\'Event','EventEventTime'] },
	'eventtype' => { 450 => 'eventType' },
	'eventverbatimeventdate' => { 112 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 112 => [\'Event','EventYear'] },
	'evsteps' => { 309 => '1.2', 311 => 0x0 },
	'evstepsize' => { 258 => '5.1', 259 => '6.1', 260 => '6.1', 264 => '0.7' },
	'exclusivecoverage' => { 427 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 454 => 'exclusivityEndDate' },
	'excursiontolerance' => { 123 => 0x82 },
	'exif' => { 114 => 'EXIF' },
	'exifbyteorder' => { 114 => 'ExifByteOrder' },
	'exifcamerainfo' => { 121 => 0xe8 },
	'exifimageheight' => { 113 => 0xa003, 441 => 'PixelYDimension' },
	'exifimagewidth' => { 113 => 0xa002, 441 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 114 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 113 => 0x9000, 441 => 'ExifVersion' },
	'exitpupilposition' => { 203 => 0x4, 204 => 0x4 },
	'expirationdate' => { 121 => 0x25, 454 => 'expirationDate' },
	'expirationtime' => { 121 => 0x26 },
	'exposure' => { 113 => 0xfe51, 437 => 'Exposure' },
	'exposure2012' => { 437 => 'Exposure2012' },
	'exposureadj' => { 244 => 0x0 },
	'exposureadj2' => { 244 => 0x12 },
	'exposureadjust' => { 364 => 0xc },
	'exposurebracketingindicatorlast' => { 170 => 0x52 },
	'exposurebracketshotnumber' => { 173 => 0x2d, 383 => 0x2f },
	'exposurebracketstepsize' => { 309 => 0x8 },
	'exposurebracketvalue' => { 207 => 0x19 },
	'exposurecompensation' => { 72 => 0x6, 87 => 0x0, 113 => 0x9204, 129 => 0x24, 143 => 'ExposureComp', 163 => 'ExposureCompensation', 167 => 0xd, 168 => 0x53, 169 => 0x1e, 173 => 0x49c0, 275 => 0x1006, 328 => 0x16, 337 => 0x402, 361 => 0xa013, 364 => [0xc,0x35,0x4d], 392 => 0x114c, 393 => 0x114c, 394 => 0x1128, 396 => 0x1180, 397 => 0x1038, 398 => 0x230, 399 => 0x230, 400 => 0x223, 441 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 389 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 170 => 0x47, 173 => 0x2a },
	'exposurecompensationset' => { 372 => 0x3, 373 => 0x3, 374 => 0x3, 389 => 0x1e },
	'exposurecompensationsetting' => { 170 => 0x1 },
	'exposurecompstepsize' => { 253 => '6.3', 254 => '7.3', 256 => '7.3', 257 => '7.3', 262 => '4.3', 266 => '7.3', 267 => '7.3' },
	'exposurecontrolstep' => { 261 => '6.1', 263 => '6.1' },
	'exposurecontrolstepsize' => { 253 => '6.2', 254 => '7.1', 256 => '7.1', 257 => '7.1', 262 => '4.2', 266 => '7.1', 267 => '7.1', 268 => '7.1' },
	'exposurecount' => { 118 => 0x1032 },
	'exposuredelaymode' => { 253 => '10.1', 254 => '11.1', 256 => '11.1', 257 => '11.1', 258 => '9.1', 259 => '10.1', 260 => '10.1', 262 => '10.4', 263 => '10.1', 264 => '6.4', 266 => '11.1', 267 => '11.1', 268 => '11.2' },
	'exposuredifference' => { 207 => 0xe },
	'exposureindex' => { 113 => 0xa215, 441 => 'ExposureIndex' },
	'exposureindicator' => { 170 => 0x50 },
	'exposurelevelincrements' => { 76 => 0x6, 77 => 0x6, 78 => 0x101, 79 => 0x5, 80 => 0x6, 81 => 0x5, 82 => 0x5, 83 => 0x6, 84 => 0x4, 372 => 0x58, 373 => 0x58 },
	'exposurelockused' => { 425 => 'ExposureLockUsed' },
	'exposuremode' => { 113 => 0xa402, 143 => 'ExposureMode', 167 => 0x1, 168 => 0xa, 169 => 0x0, 170 => 0x0, 173 => 0x34, 270 => 0x200, 290 => 0x40d, 364 => 0x8, 384 => 0xb041, 441 => 'ExposureMode' },
	'exposuremodeinmanual' => { 78 => 0x10b },
	'exposureprogram' => { 113 => 0x8822, 354 => 0x1001, 365 => [0x17e,0x43], 372 => 0x3c, 373 => 0x3c, 374 => 0x5, 378 => 0x14, 383 => 0x3f, 389 => 0x2, 392 => 0x1175, 393 => 0x1179, 394 => 0x1155, 395 => 0x11d1, 396 => 0x11ad, 397 => 0x1065, 398 => 0x25d, 399 => 0x25d, 400 => 0x24c, 409 => 0xb, 410 => 0xc, 411 => 0xb, 413 => 0x48, 441 => 'ExposureProgram' },
	'exposureshift' => { 270 => 0x203 },
	'exposurestandardadjustment' => { 384 => 0x202d },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 72 => 0x16, 113 => 0x829a, 126 => 0xfd05, 129 => 0x20, 131 => 0xfa24, 133 => 0xf104, 136 => 0x12, 138 => 0x38, 141 => 0x10, 143 => 'ExposureTime', 167 => 0x9, 168 => 0x35, 169 => 0x48, 170 => 0x8, 173 => 0x49b8, 328 => 0x12, 361 => 0xa018, 364 => [0x32,0x4a], 372 => 0x0, 373 => 0x0, 389 => [0x21,0x23,0x27], 413 => 0x10, 441 => 'ExposureTime' },
	'exposuretime2' => { 364 => [0x33,0x4b] },
	'exposuretuning' => { 207 => 0x1c },
	'exposurevalue' => { 127 => 0x3 },
	'exposurewarning' => { 118 => 0x1302 },
	'exrauto' => { 118 => 0x1033 },
	'exrmode' => { 118 => 0x1034 },
	'extendedwbdetect' => { 270 => 0x902 },
	'extender' => { 271 => 0x301 },
	'extenderfirmwareversion' => { 271 => 0x304 },
	'extendermagnification' => { 145 => 'Magnification' },
	'extendermake' => { 145 => 'Make' },
	'extendermodel' => { 145 => 'Model', 271 => 0x303 },
	'extenderserialnumber' => { 145 => 'SerialNumber', 271 => 0x302 },
	'extenderstatus' => { 326 => 0x3 },
	'externalflash' => { 273 => 0x1201 },
	'externalflashae1' => { 275 => 0x101f },
	'externalflashae1_0' => { 275 => 0x101b },
	'externalflashae2' => { 275 => 0x1020 },
	'externalflashae2_0' => { 275 => 0x101c },
	'externalflashbounce' => { 273 => 0x1204, 275 => 0x1026, 316 => 0x1a },
	'externalflashcompensation' => { 196 => 0x1b },
	'externalflashexposurecomp' => { 207 => 0x17, 316 => 0x19 },
	'externalflashfirmware' => { 194 => 0x6, 195 => 0x6, 196 => 0x6, 197 => 0x6, 198 => 0x6 },
	'externalflashflags' => { 194 => 0x8, 195 => 0x8, 196 => 0x8, 197 => 0x8 },
	'externalflashguidenumber' => { 273 => 0x1203, 316 => '24.1' },
	'externalflashgvalue' => { 275 => 0x1025 },
	'externalflashmode' => { 275 => 0x1028, 316 => 0x2 },
	'externalflashreadystate' => { 198 => '9.1' },
	'externalflashstatus' => { 198 => '8.2' },
	'externalflashzoom' => { 273 => 0x1205, 275 => 0x1027 },
	'externalflashzoomoverride' => { 198 => '8.1' },
	'externalmetadatalink' => { 447 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 288 => 0x311, 291 => 0x311, 292 => 0x311, 295 => 0x3408 },
	'extrainfoversion' => { 376 => 0x1a },
	'eyestartaf' => { 170 => 0x40 },
	'face10position' => { 104 => 0x3f4, 105 => 0x1ec, 192 => 0x28, 313 => 0x12 },
	'face10size' => { 314 => 0x12 },
	'face11position' => { 192 => 0x2c, 313 => 0x14 },
	'face11size' => { 314 => 0x14 },
	'face12position' => { 192 => 0x30, 313 => 0x16 },
	'face12size' => { 314 => 0x16 },
	'face13position' => { 313 => 0x18 },
	'face13size' => { 314 => 0x18 },
	'face14position' => { 313 => 0x1a },
	'face14size' => { 314 => 0x1a },
	'face15position' => { 313 => 0x1c },
	'face15size' => { 314 => 0x1c },
	'face16position' => { 313 => 0x1e },
	'face16size' => { 314 => 0x1e },
	'face17position' => { 313 => 0x20 },
	'face17size' => { 314 => 0x20 },
	'face18position' => { 313 => 0x22 },
	'face18size' => { 314 => 0x22 },
	'face19position' => { 313 => 0x24 },
	'face19size' => { 314 => 0x24 },
	'face1position' => { 51 => 0x8, 104 => 0xd, 105 => 0x18, 192 => 0x4, 285 => 0x1, 313 => 0x0, 351 => 0xbc, 379 => 0x1, 380 => 0x0, 381 => 0x0, 382 => 0x5b },
	'face1size' => { 314 => 0x0 },
	'face20position' => { 313 => 0x26 },
	'face20size' => { 314 => 0x26 },
	'face21position' => { 313 => 0x28 },
	'face21size' => { 314 => 0x28 },
	'face22position' => { 313 => 0x2a },
	'face22size' => { 314 => 0x2a },
	'face23position' => { 313 => 0x2c },
	'face23size' => { 314 => 0x2c },
	'face24position' => { 313 => 0x2e },
	'face24size' => { 314 => 0x2e },
	'face25position' => { 313 => 0x30 },
	'face25size' => { 314 => 0x30 },
	'face26position' => { 313 => 0x32 },
	'face26size' => { 314 => 0x32 },
	'face27position' => { 313 => 0x34 },
	'face27size' => { 314 => 0x34 },
	'face28position' => { 313 => 0x36 },
	'face28size' => { 314 => 0x36 },
	'face29position' => { 313 => 0x38 },
	'face29size' => { 314 => 0x38 },
	'face2position' => { 51 => 0xa, 104 => 0x7c, 105 => 0x4c, 192 => 0x8, 285 => 0x5, 313 => 0x2, 351 => 0xc8, 379 => 0x6, 380 => 0x20, 381 => 0x25, 382 => 0x65 },
	'face2size' => { 314 => 0x2 },
	'face30position' => { 313 => 0x3a },
	'face30size' => { 314 => 0x3a },
	'face31position' => { 313 => 0x3c },
	'face31size' => { 314 => 0x3c },
	'face32position' => { 313 => 0x3e },
	'face32size' => { 314 => 0x3e },
	'face3position' => { 51 => 0xc, 104 => 0xeb, 105 => 0x80, 192 => 0xc, 285 => 0x9, 313 => 0x4, 351 => 0xd4, 379 => 0xb, 380 => 0x40, 381 => 0x4a, 382 => 0x6f },
	'face3size' => { 314 => 0x4 },
	'face4position' => { 51 => 0xe, 104 => 0x15a, 105 => 0xb4, 192 => 0x10, 285 => 0xd, 313 => 0x6, 351 => 0xe0, 379 => 0x10, 380 => 0x60, 381 => 0x6f, 382 => 0x79 },
	'face4size' => { 314 => 0x6 },
	'face5position' => { 51 => 0x10, 104 => 0x1c9, 105 => 0xe8, 192 => 0x14, 285 => 0x11, 313 => 0x8, 351 => 0xec, 379 => 0x15, 380 => 0x80, 381 => 0x94 },
	'face5size' => { 314 => 0x8 },
	'face6position' => { 51 => 0x12, 104 => 0x238, 105 => 0x11c, 192 => 0x18, 313 => 0xa, 351 => 0xf8, 379 => 0x1a, 380 => 0xa0, 381 => 0xb9 },
	'face6size' => { 314 => 0xa },
	'face7position' => { 51 => 0x14, 104 => 0x2a7, 105 => 0x150, 192 => 0x1c, 313 => 0xc, 351 => 0x104, 379 => 0x1f, 380 => 0xc0, 381 => 0xde },
	'face7size' => { 314 => 0xc },
	'face8position' => { 51 => 0x16, 104 => 0x316, 105 => 0x184, 192 => 0x20, 313 => 0xe, 351 => 0x110, 379 => 0x24, 380 => 0xe0, 381 => 0x103 },
	'face8size' => { 314 => 0xe },
	'face9position' => { 51 => 0x18, 104 => 0x385, 105 => 0x1b8, 192 => 0x24, 313 => 0x10 },
	'face9size' => { 314 => 0x10 },
	'facebalanceorigi' => { 430 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 430 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 430 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 430 => 'FaceBalanceWarmth' },
	'facedetect' => { 328 => 0x76, 361 => 0x100 },
	'facedetectarea' => { 274 => 0x1201 },
	'facedetectframecrop' => { 274 => 0x1207 },
	'facedetectframesize' => { 51 => 0x3, 104 => 0x1, 105 => 0x4, 192 => 0x1, 274 => 0x1203, 328 => 0x77, 351 => 0xb6 },
	'facedetection' => { 374 => 0x30, 389 => 0x19 },
	'faceelementpositions' => { 118 => 0x4203 },
	'faceelementtypes' => { 118 => 0x4201 },
	'faceid' => { 432 => 'FaceID' },
	'faceinfounknown' => { 107 => 0x2089 },
	'facename' => { 361 => 0x123 },
	'faceorientation' => { 105 => 0x8 },
	'faceposition' => { 312 => 0x2, 362 => 0x4 },
	'facepositions' => { 118 => 0x4103 },
	'facerecognition' => { 361 => 0x120 },
	'facesdetected' => { 51 => 0x2, 52 => 0x2, 53 => 0x3, 104 => 0x0, 105 => 0x2, 107 => 0x211c, 118 => 0x4100, 192 => 0x3, 274 => 0x1200, 293 => 0x3f, 312 => 0x0, 351 => 0xb5, 362 => 0x0, 379 => 0x0, 382 => 0x3, 391 => 0x30 },
	'facesrecognized' => { 286 => 0x0 },
	'facewidth' => { 52 => 0x1 },
	'faithfuloutputhighlightpoint' => { 103 => 0x38 },
	'faithfuloutputshadowpoint' => { 103 => 0x39 },
	'faithfulrawcolortone' => { 103 => 0x31 },
	'faithfulrawcontrast' => { 103 => 0x33 },
	'faithfulrawhighlight' => { 103 => 0x79 },
	'faithfulrawhighlightpoint' => { 103 => 0x36 },
	'faithfulrawlinear' => { 103 => 0x34 },
	'faithfulrawsaturation' => { 103 => 0x32 },
	'faithfulrawshadow' => { 103 => 0x82 },
	'faithfulrawshadowpoint' => { 103 => 0x37 },
	'faithfulrawsharpness' => { 103 => 0x35 },
	'faithfulunsharpmaskfineness' => { 103 => 0xac },
	'faithfulunsharpmaskstrength' => { 103 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 103 => 0xae },
	'far' => { 422 => 'Far' },
	'feedidentifier' => { 447 => 'FeedIdentifier' },
	'femicroadjustment' => { 78 => 0x111 },
	'ffid' => { 439 => 'ffid' },
	'field' => { 450 => 'field' },
	'fieldcount' => { 275 => 0x103f },
	'filecreatedate' => { 114 => 'FileCreateDate' },
	'filedatarate' => { 461 => 'fileDataRate' },
	'fileformat' => { 89 => 0x0, 122 => 0x14, 364 => [0x22,0x26], 384 => 0xb000 },
	'filegroupid' => { 114 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 294 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 114 => 'FileModifyDate' },
	'filename' => { 114 => 'FileName' },
	'filenameasdelivered' => { 280 => 'FileNameAsDelivered' },
	'filenumber' => { 54 => 0x1, 60 => 0x8, 91 => 0x1817, 108 => 'FileNumber', 193 => 0x4 },
	'filenumbermemory' => { 167 => 0x1a },
	'filenumbersequence' => { 253 => '12.2', 258 => '3.1', 259 => '4.1', 260 => '4.1', 262 => '11.1', 263 => '4.3', 268 => '5.2' },
	'filepermissions' => { 114 => 'FilePermissions' },
	'filesource' => { 113 => 0xa300, 118 => 0x8000, 441 => 'FileSource' },
	'fileuserid' => { 114 => 'FileUserID' },
	'fileversion' => { 122 => 0x16 },
	'fillflashautoreduction' => { 76 => 0xe, 77 => 0xe, 84 => 0xa },
	'filllight' => { 437 => 'FillLight' },
	'fillorder' => { 113 => 0x10a },
	'filmgraineffect' => { 270 => 0x538 },
	'filmmode' => { 118 => 0x1401, 290 => 0x412, 293 => 0x42 },
	'filmtype' => { 214 => 0x2 },
	'filtereffect' => { 54 => 0xe, 209 => 0x37, 210 => 0x3f },
	'filtereffectauto' => { 67 => 0xa0 },
	'filtereffectfaithful' => { 66 => 0x70, 67 => 0x70 },
	'filtereffectlandscape' => { 66 => 0x40, 67 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 66 => 0x88, 67 => 0x88 },
	'filtereffectneutral' => { 66 => 0x58, 67 => 0x58 },
	'filtereffectportrait' => { 66 => 0x28, 67 => 0x28 },
	'filtereffectstandard' => { 66 => 0x10, 67 => 0x10 },
	'filtereffectuserdef1' => { 66 => 0xa0, 67 => 0xb8 },
	'filtereffectuserdef2' => { 66 => 0xb8, 67 => 0xd0 },
	'filtereffectuserdef3' => { 66 => 0xd0, 67 => 0xe8 },
	'finderdisplayduringexposure' => { 77 => 0x1 },
	'finesharpness' => { 328 => 0x70 },
	'finetuneoptcenterweighted' => { 253 => '7.2', 254 => '9.1', 256 => '9.1', 257 => '9.1', 261 => '8.1', 266 => '9.1', 267 => '9.1', 268 => '9.1' },
	'finetuneopthighlightweighted' => { 256 => '46.1', 257 => '46.1', 266 => '46.1', 267 => '46.1' },
	'finetuneoptmatrixmetering' => { 253 => '8.1', 254 => '8.2', 256 => '8.2', 257 => '8.2', 261 => '7.2', 262 => '6.1', 266 => '8.2', 267 => '8.2', 268 => '8.2' },
	'finetuneoptspotmetering' => { 253 => '8.2', 254 => '9.2', 256 => '9.2', 257 => '9.2', 261 => '8.2', 262 => '6.2', 266 => '9.2', 267 => '9.2', 268 => '9.2' },
	'firmware' => { 275 => 0x405, 364 => [0x17,0x3b,0x57], 433 => 'Firmware' },
	'firmwaredate' => { 106 => 0x15, 107 => 0x2001, 349 => 0x4 },
	'firmwareid' => { 174 => 0x0 },
	'firmwarename' => { 361 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 60 => 0x1e, 352 => 0x0 },
	'firmwarerevision2' => { 352 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 127 => 0xce5, 141 => 0x57, 143 => 'FirmwareVersion', 291 => 0x320, 293 => 0x2, 295 => 0x3109, 328 => 0x230, 350 => 0x18, 354 => 0x2 },
	'firmwareversions' => { 337 => 0x301 },
	'firstphotodate' => { 425 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 280 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 121 => 0x16, 431 => 'FixtureIdentifier' },
	'flash' => { 108 => 'Flash', 113 => 0x9209, 168 => 0x1f, 169 => 0x15, 441 => 'Flash' },
	'flashaction' => { 372 => 0x3e, 373 => 0x3e, 384 => 0x2017, 389 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 372 => 0x4c, 373 => 0x4c, 389 => 0x77 },
	'flashactionexternal' => { 389 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 41 => 0x249 },
	'flashbias' => { 293 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 78 => 0x70e },
	'flashchargelevel' => { 275 => 0x1010 },
	'flashcolorfilter' => { 196 => 0x10, 197 => 0x10 },
	'flashcommandermode' => { 194 => '9.1', 195 => '9.1', 196 => '9.1', 197 => '9.1' },
	'flashcompensation' => { 194 => 0xa, 195 => 0xa, 196 => 0xa, 197 => 0x27, 198 => 0xa, 433 => 'FlashCompensation' },
	'flashcontrol' => { 372 => 0x23, 373 => 0x1f, 374 => 0x21 },
	'flashcontrolbuilt-in' => { 262 => '16.1', 263 => '23.1', 265 => '23.1', 266 => '24.1' },
	'flashcontrolmode' => { 194 => '9.2', 195 => '9.2', 196 => '9.2', 197 => '9.2', 270 => 0x404 },
	'flashcurtain' => { 293 => 0x48 },
	'flashdefault' => { 170 => 0x42 },
	'flashdevice' => { 275 => 0x1005 },
	'flashdistance' => { 107 => 0x2034 },
	'flashenergy' => { 113 => 0xa20b, 441 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 207 => 0x18 },
	'flashexposurecomp' => { 72 => 0xf, 118 => 0x1011, 146 => 'ExposureComp', 167 => 0x23, 172 => 0x104, 173 => 0x49c1, 207 => 0x12, 270 => 0x401, 275 => 0x1023, 328 => 0x4d, 354 => 0x100b, 364 => [0x3a,0x56], 384 => 0x104 },
	'flashexposurecomp2' => { 232 => 0x4d2 },
	'flashexposurecomp3' => { 196 => 0x1d },
	'flashexposurecomp4' => { 196 => 0x27 },
	'flashexposurecomparea' => { 254 => '38.4', 256 => '38.4', 257 => '38.4', 266 => '38.4', 267 => '38.4' },
	'flashexposurecompset' => { 170 => 0x10, 301 => 0xe, 372 => 0x14, 373 => 0x12, 374 => 0x23, 389 => 0x1f },
	'flashexposurecompset2' => { 389 => [0x26,0x2c] },
	'flashexposureindicator' => { 170 => 0x54 },
	'flashexposureindicatorlast' => { 170 => 0x56 },
	'flashexposureindicatornext' => { 170 => 0x55 },
	'flashexposurelock' => { 54 => 0x19 },
	'flashfired' => { 129 => 0x5d, 146 => 'Fired', 167 => 0x14, 231 => '590.3', 293 => 0x8007, 441 => [\'Flash','FlashFired'] },
	'flashfiring' => { 78 => 0x306, 79 => 0x6, 80 => 0x7, 83 => 0x7 },
	'flashfirmwareversion' => { 271 => 0x1002 },
	'flashfocallength' => { 194 => 0xb, 195 => 0xc, 196 => 0xc, 197 => 0xc, 198 => 0xc },
	'flashfunction' => { 173 => 0x31, 441 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 194 => 0xe, 195 => 0xf, 196 => 0xf, 197 => 0xf, 198 => 0xf },
	'flashgroupacompensation' => { 194 => 0x11, 195 => 0x12, 196 => 0x13, 197 => 0x28, 198 => 0x28 },
	'flashgroupacontrolmode' => { 194 => 0xf, 195 => '16.1', 196 => '17.1', 197 => '17.1', 198 => '17.1' },
	'flashgroupaoutput' => { 194 => 0x11, 195 => 0x12, 196 => 0x13, 197 => 0x28, 198 => 0x28 },
	'flashgroupbcompensation' => { 194 => 0x12, 195 => 0x13, 196 => 0x14, 197 => 0x29, 198 => 0x29 },
	'flashgroupbcontrolmode' => { 194 => 0x10, 195 => '17.1', 196 => '18.1', 197 => '18.1', 198 => '18.1' },
	'flashgroupboutput' => { 194 => 0x12, 195 => 0x13, 196 => 0x14, 197 => 0x29, 198 => 0x29 },
	'flashgroupccompensation' => { 195 => 0x14, 196 => 0x15, 197 => 0x2a, 198 => 0x2a },
	'flashgroupccontrolmode' => { 195 => '17.2', 196 => '18.2', 197 => '18.2', 198 => '18.2' },
	'flashgroupcoutput' => { 195 => 0x14, 196 => 0x15, 197 => 0x2a, 198 => 0x2a },
	'flashguidenumber' => { 72 => 0xd, 88 => 0x0, 146 => 'GuideNumber' },
	'flashintensity' => { 106 => [0x19,0x5], 270 => 0x405 },
	'flashlevel' => { 255 => 0x9, 384 => 0xb048 },
	'flashmake' => { 146 => 'Make' },
	'flashmanufacturer' => { 165 => 'FlashManufacturer' },
	'flashmetering' => { 167 => 0x3f, 170 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 328 => 0x20a },
	'flashmode' => { 106 => 0x4, 129 => 0x5c, 146 => 'Mode', 167 => 0x2, 168 => 0x20, 169 => 0x16, 170 => 0xf, 207 => 0x87, 270 => 0x400, 275 => 0x1004, 328 => 0xc, 335 => 0x4, 353 => 0x20, 354 => 0x100a, 363 => 0x225, 372 => 0x13, 373 => 0x7f, 374 => 0x20, 389 => 0x10, 392 => 0x1138, 393 => 0x1138, 394 => 0x1114, 395 => 0x1190, 396 => 0x116c, 397 => 0x1024, 398 => 0x21c, 399 => 0x21c, 400 => 0x211, 441 => [\'Flash','FlashMode'] },
	'flashmodel' => { 146 => 'Model', 165 => 'FlashModel', 271 => 0x1001 },
	'flashoptions' => { 309 => 0x2 },
	'flashoptions2' => { 309 => 0x10 },
	'flashoutput' => { 41 => 0x248, 72 => 0x21, 194 => 0xa, 195 => 0xa, 196 => 0xa, 197 => 0x27 },
	'flashpixversion' => { 113 => 0xa000, 441 => 'FlashpixVersion' },
	'flashredeyemode' => { 441 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 270 => 0x403 },
	'flashreturn' => { 441 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 146 => 'SerialNumber', 271 => 0x1003 },
	'flashsetting' => { 207 => 0x8 },
	'flashshutterspeed' => { 253 => '20.2', 254 => '23.2', 256 => '23.2', 257 => '23.2', 262 => '15.2', 263 => '22.2', 264 => '7.2', 265 => '22.2', 266 => '23.2', 267 => '23.2', 268 => '23.1' },
	'flashsource' => { 194 => 0x4, 195 => 0x4, 196 => 0x4, 197 => 0x4, 198 => 0x4 },
	'flashstatus' => { 316 => 0x0, 389 => [0x82,0x86], 402 => 0x31, 403 => 0x39 },
	'flashstatusbuilt-in' => { 374 => [0x87,0x287] },
	'flashstatusexternal' => { 374 => [0x88,0x288] },
	'flashsyncspeed' => { 253 => '20.1', 254 => '23.1', 256 => '23.1', 257 => '23.1', 262 => '15.1', 263 => '22.1', 265 => '22.1', 266 => '23.1', 267 => '23.1' },
	'flashsyncspeedav' => { 76 => 0x3, 78 => 0x10f, 79 => 0x2, 80 => 0x3, 81 => 0x2, 82 => 0x2, 83 => 0x3, 84 => 0x6 },
	'flashthreshold' => { 88 => 0x1 },
	'flashtype' => { 146 => 'Type', 170 => 0x59, 207 => 0x9, 271 => 0x1000 },
	'flashwarning' => { 263 => '30.1', 264 => '7.1', 268 => '31.1', 293 => 0x62 },
	'flexiblespotposition' => { 384 => 0x201d },
	'flickerreduce' => { 363 => 0x218 },
	'flickerreduction' => { 225 => 0xe84 },
	'flickerreductionindicator' => { 225 => 0x5e2 },
	'flightpitchdegree' => { 110 => 'FlightPitchDegree' },
	'flightrolldegree' => { 110 => 'FlightRollDegree' },
	'flightyawdegree' => { 110 => 'FlightYawDegree' },
	'fliphorizontal' => { 246 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 72 => 0x15, 113 => 0x829d, 126 => 0xfd04, 129 => 0x1e, 131 => 0xfa23, 133 => 0xf103, 136 => 0x13, 138 => 0x3c, 141 => 0xc, 150 => 'FNumber', 167 => 0xa, 168 => 0x36, 169 => 0x47, 170 => 0x9, 173 => 0x49c7, 328 => 0x13, 361 => 0xa019, 364 => [0x31,0x49], 372 => 0x1, 373 => 0x1, 389 => [0x20,0x22,0x26], 441 => 'FNumber' },
	'focaldistance' => { 423 => 'FocalDistance' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 56 => 0x1, 107 => 0x1d, 113 => 0x920a, 136 => 0x1d, 150 => 'FocalLength', 167 => 0x12, 203 => 0xa, 204 => 0xb, 287 => 0x1, 328 => 0x1d, 337 => 0x403, 354 => 0x1500, 371 => 0xe, 396 => 0x1278, 397 => 0x1134, 398 => 0x32c, 399 => 0x32c, 400 => 0x30a, 441 => 'FocalLength' },
	'focallength2' => { 389 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 113 => 0xa405, 361 => 0xa01a, 441 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 371 => 0x10 },
	'focalplaneafpointarea' => { 401 => 0x2 },
	'focalplaneafpointlocation1' => { 401 => 0x6 },
	'focalplaneafpointlocation10' => { 401 => 0x2a },
	'focalplaneafpointlocation11' => { 401 => 0x2e },
	'focalplaneafpointlocation12' => { 401 => 0x32 },
	'focalplaneafpointlocation13' => { 401 => 0x36 },
	'focalplaneafpointlocation14' => { 401 => 0x3a },
	'focalplaneafpointlocation15' => { 401 => 0x3e },
	'focalplaneafpointlocation2' => { 401 => 0xa },
	'focalplaneafpointlocation3' => { 401 => 0xe },
	'focalplaneafpointlocation4' => { 401 => 0x12 },
	'focalplaneafpointlocation5' => { 401 => 0x16 },
	'focalplaneafpointlocation6' => { 401 => 0x1a },
	'focalplaneafpointlocation7' => { 401 => 0x1e },
	'focalplaneafpointlocation8' => { 401 => 0x22 },
	'focalplaneafpointlocation9' => { 401 => 0x26 },
	'focalplaneafpointsused' => { 401 => 0x1 },
	'focalplanediagonal' => { 271 => 0x103, 275 => 0x205 },
	'focalplaneresolutionunit' => { 113 => 0xa210, 441 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 113 => 0xa20e, 441 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 56 => 0x2 },
	'focalplanexunknown' => { 56 => 0x2 },
	'focalplaneyresolution' => { 113 => 0xa20f, 441 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 56 => 0x3 },
	'focalplaneyunknown' => { 56 => 0x3 },
	'focalpointx' => { 423 => 'FocalPointX' },
	'focalpointy' => { 423 => 'FocalPointY' },
	'focaltype' => { 9 => 0x2d, 56 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 236 => 0x8 },
	'focusarea' => { 167 => 0x31 },
	'focusareaselection' => { 264 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 78 => 0x515 },
	'focusdistance' => { 150 => 'FocusDistance', 167 => 0x13, 173 => 0x49bb, 203 => 0x9, 204 => 0xa, 273 => 0x305, 287 => 0x0, 291 => 0x304, 292 => 0x304 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 54 => 0x15, 72 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 54 => 0x14, 72 => 0x13 },
	'focusholdbutton' => { 170 => 0x44 },
	'focusinfoversion' => { 273 => 0x0 },
	'focusingscreen' => { 77 => 0x0, 78 => 0x80b, 83 => 0x0 },
	'focuslocation' => { 384 => 0x2027 },
	'focuslocked' => { 166 => 0x14 },
	'focusmode' => { 33 => 0x7, 106 => 0x3, 107 => [0x3003,0xd], 118 => 0x1021, 129 => 0x38, 143 => 'FocusMode', 167 => 0x30, 169 => 0xe, 170 => 0xc, 207 => 0x7, 270 => 0x301, 275 => 0x100b, 293 => 0x7, 328 => 0xd, 335 => 0x3, 354 => 0x1006, 365 => [0xb,0x5], 371 => [0x15,0x1d], 372 => 0x4d, 373 => 0x4d, 384 => [0xb042,0xb04e,0x201b], 389 => 0x13, 407 => 0x16 },
	'focusmode2' => { 309 => '3.1', 389 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 255 => '10.1', 369 => 0x14, 370 => 0x15, 372 => 0x10, 373 => 0xf, 374 => 0x6 },
	'focusmodeswitch' => { 170 => 0x58, 372 => 0x2e },
	'focuspixel' => { 118 => 0x1023 },
	'focuspointwrap' => { 253 => '2.2', 254 => '2.2', 256 => '2.1', 257 => '2.1', 261 => '1.1', 262 => '2.2', 263 => '1.1', 266 => '2.2', 267 => '2.1', 268 => '2.5' },
	'focusposition' => { 203 => 0x8, 204 => 0x8, 328 => 0x10, 383 => 0x9bb },
	'focusposition2' => { 389 => [0x29,0x2b,0x2f], 407 => 0x2d, 410 => 0x20 },
	'focusprocess' => { 270 => 0x302 },
	'focusrange' => { 33 => 0x12, 275 => 0x100a },
	'focusrangeindex' => { 319 => '3.1' },
	'focussetting' => { 364 => 0x6 },
	'focusstatus' => { 371 => 0x19, 372 => 0x53, 373 => 0x53 },
	'focusstepcount' => { 273 => 0x301, 275 => 0x100e },
	'focusstepinfinity' => { 273 => 0x303, 275 => 0x103b },
	'focusstepnear' => { 273 => 0x304, 275 => 0x103c },
	'focustrackinglockon' => { 253 => ['1.5','4.1'], 254 => '1.4', 261 => '0.4', 262 => '3.1', 263 => '0.4', 266 => '1.4' },
	'focuswarning' => { 118 => 0x1301 },
	'foldername' => { 167 => 0x27 },
	'foldernumber' => { 372 => 0x9a, 374 => [0x402,0x114,0x316] },
	'fontcomposite' => { 466 => [\'Fonts','FontsComposite'] },
	'fontface' => { 466 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 466 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 466 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 466 => [\'Fonts','FontsFontName'] },
	'fonts' => { 466 => 'Fonts' },
	'fonttype' => { 466 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 466 => [\'Fonts','FontsVersionString'] },
	'for' => { 344 => 'For' },
	'forcewrite' => { 114 => 'ForceWrite' },
	'format' => { 422 => 'Format', 438 => 'format', 459 => 'Format' },
	'forwardlock' => { 456 => 'forwardlock' },
	'forwardmatrix1' => { 113 => 0xc714 },
	'forwardmatrix2' => { 113 => 0xc715 },
	'fossilspecimen' => { 112 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 112 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 63 => [0x2,0x4] },
	'frameheight' => { 118 => 0x3822 },
	'framenum' => { 339 => 0xd7 },
	'framenumber' => { 118 => 0x8003, 173 => 0x3c, 328 => 0x29 },
	'framerate' => { 63 => [0x1,0x6], 113 => 0xc764, 118 => 0x3820 },
	'framewidth' => { 118 => 0x3821 },
	'framing' => { 450 => 'framing' },
	'freebytes' => { 91 => 0x1 },
	'freememorycardimages' => { 168 => [0x37,0x54], 169 => [0x2d,0x4a], 170 => 0x32 },
	'fujiflashmode' => { 118 => 0x1010 },
	'fullimagesize' => { 384 => 0xb02b },
	'fullpanoheightpixels' => { 425 => 'FullPanoHeightPixels', 426 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 425 => 'FullPanoWidthPixels', 426 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 354 => 0x100d },
	'fullsizeimage' => { 149 => 'data' },
	'fullsizeimagename' => { 149 => '1Name' },
	'fullsizeimagetype' => { 149 => '0Type' },
	'func1button' => { 256 => '14.1', 257 => '14.1', 267 => '14.1' },
	'func1buttonplusdials' => { 256 => '42.1', 257 => '42.1', 267 => '42.1' },
	'func2button' => { 256 => '80.1', 257 => '80.1', 267 => '80.1' },
	'func2buttonplusdials' => { 256 => '81.1' },
	'func3button' => { 256 => '83.1' },
	'funcbutton' => { 253 => ['14.1','15.1'], 254 => '14.1', 262 => '28.1', 263 => '13.1', 266 => '14.1', 268 => '14.1' },
	'funcbuttonplusdials' => { 253 => ['14.2','15.2'], 254 => '14.2', 262 => '31.1', 266 => '42.1' },
	'functionbutton' => { 260 => '13.1', 264 => '5.2' },
	'gainbase' => { 274 => 0x610 },
	'gaincontrol' => { 113 => 0xa407, 441 => 'GainControl' },
	'gamma' => { 113 => 0xa500, 298 => 0x11c, 442 => 'Gamma' },
	'gammablackpoint' => { 99 => 0xc },
	'gammacolortone' => { 99 => 0x3 },
	'gammacompensatedvalue' => { 123 => 0x91 },
	'gammacontrast' => { 99 => 0x2 },
	'gammacurveoutputrange' => { 99 => 0xf },
	'gammahighlight' => { 99 => 0xa },
	'gammalinear' => { 97 => 0x20200 },
	'gammamidpoint' => { 99 => 0xe },
	'gammasaturation' => { 99 => 0x4 },
	'gammashadow' => { 99 => 0x9 },
	'gammasharpnessstrength' => { 99 => 0x8 },
	'gammaunsharpmaskfineness' => { 99 => 0x6 },
	'gammaunsharpmaskstrength' => { 99 => 0x5 },
	'gammaunsharpmaskthreshold' => { 99 => 0x7 },
	'gammawhitepoint' => { 99 => 0xd },
	'geimagesize' => { 118 => 0x1304 },
	'gemake' => { 119 => 0x300 },
	'gemodel' => { 119 => 0x207 },
	'genre' => { 447 => 'Genre', 451 => 'genre', 461 => 'genre' },
	'genrecvid' => { 447 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 447 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 447 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 447 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 452 => 'geography' },
	'geologicalcontext' => { 112 => 'GeologicalContext' },
	'geologicalcontextbed' => { 112 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 112 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 112 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 112 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 112 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 114 => 'Geosync' },
	'geotag' => { 114 => 'Geotag' },
	'geotiffasciiparams' => { 113 => 0x87b1 },
	'geotiffdirectory' => { 113 => 0x87af },
	'geotiffdoubleparams' => { 113 => 0x87b0 },
	'geotime' => { 114 => 'Geotime' },
	'giftftppriority' => { 427 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 110 => 'GimbalPitchDegree' },
	'gimbalrolldegree' => { 110 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 110 => 'GimbalYawDegree' },
	'globalaltitude' => { 342 => 0x419 },
	'globalangle' => { 342 => 0x40d },
	'good' => { 461 => 'good' },
	'googleplusuploadcode' => { 113 => 0x9009 },
	'gpsaltitude' => { 120 => 0x6, 147 => 'Altitude', 441 => 'GPSAltitude' },
	'gpsaltituderef' => { 120 => 0x5, 441 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 120 => 0x1c, 441 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 120 => 0x1d },
	'gpsdatetime' => { 147 => 'DateTime', 441 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 120 => 0x18, 147 => 'Bearing', 441 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 120 => 0x17, 441 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 120 => 0x1a, 147 => 'Distance', 441 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 120 => 0x19, 441 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 120 => 0x14, 441 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 120 => 0x13 },
	'gpsdestlongitude' => { 120 => 0x16, 441 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 120 => 0x15 },
	'gpsdifferential' => { 120 => 0x1e, 147 => 'Differential', 441 => 'GPSDifferential' },
	'gpsdop' => { 120 => 0xb, 441 => 'GPSDOP' },
	'gpshpositioningerror' => { 120 => 0x1f, 441 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 120 => 0x11, 441 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 120 => 0x10, 441 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 120 => 0x2, 147 => 'Latitude', 441 => 'GPSLatitude' },
	'gpslatituderef' => { 120 => 0x1 },
	'gpslongitude' => { 120 => 0x4, 147 => 'Longitude', 441 => 'GPSLongitude' },
	'gpslongituderef' => { 120 => 0x3 },
	'gpsmapdatum' => { 120 => 0x12, 147 => 'Datum', 441 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 120 => 0xa, 147 => 'MeasureMode', 441 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 120 => 0x1b, 441 => 'GPSProcessingMethod' },
	'gpssatellites' => { 120 => 0x8, 147 => 'Satellites', 441 => 'GPSSatellites' },
	'gpsspeed' => { 120 => 0xd, 147 => 'Speed', 441 => 'GPSSpeed' },
	'gpsspeedref' => { 120 => 0xc, 441 => 'GPSSpeedRef' },
	'gpsstatus' => { 120 => 0x9, 441 => 'GPSStatus' },
	'gpstimestamp' => { 120 => 0x7 },
	'gpstrack' => { 120 => 0xf, 147 => 'Heading', 441 => 'GPSTrack' },
	'gpstrackref' => { 120 => 0xe, 441 => 'GPSTrackRef' },
	'gpsversionid' => { 120 => 0x0, 441 => 'GPSVersionID' },
	'gradation' => { 270 => 0x50f },
	'gradientbasedcorractive' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 437 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 437 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 437 => 'GrainAmount' },
	'grainfrequency' => { 437 => 'GrainFrequency' },
	'grainsize' => { 437 => 'GrainSize' },
	'graymixeraqua' => { 437 => 'GrayMixerAqua' },
	'graymixerblue' => { 437 => 'GrayMixerBlue' },
	'graymixergreen' => { 437 => 'GrayMixerGreen' },
	'graymixermagenta' => { 437 => 'GrayMixerMagenta' },
	'graymixerorange' => { 437 => 'GrayMixerOrange' },
	'graymixerpurple' => { 437 => 'GrayMixerPurple' },
	'graymixerred' => { 437 => 'GrayMixerRed' },
	'graymixeryellow' => { 437 => 'GrayMixerYellow' },
	'graypoint' => { 417 => 0x8021 },
	'grayresponseunit' => { 113 => 0x122 },
	'greencurvelimits' => { 102 => 0x1c4 },
	'greencurvepoints' => { 101 => 0x53, 102 => 0x19a },
	'greenhsl' => { 97 => 0x20913 },
	'greenhue' => { 437 => 'GreenHue' },
	'greensaturation' => { 437 => 'GreenSaturation' },
	'griddisplay' => { 253 => '13.3', 254 => '4.3', 256 => '4.2', 257 => '4.2', 258 => '2.2', 262 => '10.5', 263 => '3.4', 264 => '6.1', 266 => '4.4', 267 => '4.2', 268 => '4.2' },
	'gripbatteryadload' => { 307 => 0x5 },
	'gripbatteryadnoload' => { 307 => 0x4 },
	'gripbatterystate' => { 307 => '1.2' },
	'groupareaafillumination' => { 254 => '46.4', 257 => '47.4', 266 => '47.4' },
	'halftonehints' => { 113 => 0x141 },
	'hardlink' => { 114 => 'HardLink' },
	'hasalternative' => { 451 => 'hasAlternative' },
	'hascorrection' => { 451 => 'hasCorrection' },
	'hascorrectiona-lang' => { 451 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 451 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 451 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 437 => 'HasCrop' },
	'hasextendedxmp' => { 463 => 'HasExtendedXMP' },
	'hassettings' => { 437 => 'HasSettings' },
	'hastranslation' => { 451 => 'hasTranslation' },
	'hasvisibleoverprint' => { 466 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 466 => 'HasVisibleTransparency' },
	'hdr' => { 57 => 0x1, 200 => 0x4, 293 => 0x9e, 328 => 0x85, 384 => 0x200a },
	'hdreffect' => { 57 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 200 => 0x0 },
	'hdrlevel' => { 200 => 0x5, 374 => 0x2e, 389 => 0x17 },
	'hdrlevel2' => { 200 => 0x7 },
	'hdrsetting' => { 374 => 0x2d, 389 => 0x16, 392 => 0x1148, 393 => 0x1148, 394 => 0x1124, 395 => 0x11a0, 396 => 0x117c, 397 => 0x1034, 398 => 0x22c, 399 => 0x22c, 400 => 0x21f },
	'hdrsmoothing' => { 200 => 0x6 },
	'headline' => { 121 => 0x69, 447 => 'Headline', 449 => 'Headline' },
	'hierarchicalkeywords' => { 158 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 158 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 158 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 158 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 158 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 428 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 298 => 0x1a },
	'highisomultipliergreen' => { 298 => 0x19 },
	'highisomultiplierred' => { 298 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 59 => 0x5, 78 => 0x202, 118 => 0x100e, 207 => 0xb1, 328 => 0x71, 372 => 0x2c, 373 => 0x26, 374 => 0x26, 384 => 0x2009, 389 => 0x12, 413 => 0x42 },
	'highisonoisereduction2' => { 384 => 0xb050 },
	'highlight' => { 364 => 0xf },
	'highlightadj' => { 97 => 0x2030c },
	'highlightcolordistortreduct' => { 417 => 0x8026 },
	'highlightlinearitylimit' => { 361 => 0xa025 },
	'highlightprotection' => { 245 => 0x6 },
	'highlightrecovery' => { 437 => 'HighlightRecovery' },
	'highlights' => { 430 => 'Highlights' },
	'highlights2012' => { 437 => 'Highlights2012' },
	'highlightshadow' => { 293 => 0xad },
	'highlighttone' => { 118 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 59 => 0x3, 78 => 0x203 },
	'highlowkeyadj' => { 328 => 0x6c },
	'highspeedsync' => { 170 => 0x5, 372 => 0x2, 373 => 0x2 },
	'histogramxml' => { 246 => 0x83a1a25 },
	'history' => { 449 => 'History', 462 => 'History' },
	'historyaction' => { 462 => [\'History','HistoryAction'] },
	'historychanged' => { 462 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 462 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 462 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 462 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 462 => [\'History','HistoryWhen'] },
	'hometowncity' => { 107 => 0x3006, 328 => 0x23, 334 => 0x2 },
	'hometowncitycode' => { 335 => 0x1000 },
	'hometowndst' => { 328 => 0x25, 334 => '0.2' },
	'hostcomputer' => { 113 => 0x13c },
	'hue' => { 175 => 0x3b, 210 => 0x3d, 328 => 0x67 },
	'hueadj' => { 249 => 0x2f, 417 => 0x8019 },
	'hueadjust' => { 354 => 0x1016 },
	'hueadjustment' => { 168 => 0x4a, 169 => 0x40, 207 => 0x92, 209 => 0x36 },
	'hueadjustmentaqua' => { 437 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 437 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 437 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 437 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 437 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 437 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 437 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 437 => 'HueAdjustmentYellow' },
	'huesetting' => { 278 => 0x1011 },
	'humanobservation' => { 112 => 'HumanObservation' },
	'humanobservationday' => { 112 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 112 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 112 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 112 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 112 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 112 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 112 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 112 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 112 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 112 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 112 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 112 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 112 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 112 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 112 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 112 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 112 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 112 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 112 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 112 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 113 => 0x9401, 442 => 'Humidity' },
	'icc_profile' => { 114 => 'ICC_Profile' },
	'iccprofilename' => { 449 => 'ICCProfile' },
	'idccreativestyle' => { 417 => 0x8000 },
	'idcpreviewlength' => { 417 => 0x202 },
	'idcpreviewstart' => { 417 => 0x201 },
	'identification' => { 112 => 'Identification' },
	'identificationid' => { 112 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 112 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 112 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 112 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 112 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 112 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 438 => 'identifier', 459 => 'Identifier' },
	'illumination' => { 264 => '0.5', 350 => 0x48 },
	'imageadjustment' => { 207 => 0x80, 236 => 0x5 },
	'imagealterationconstraints' => { 280 => 'ImageAlterationConstraints' },
	'imagearea' => { 219 => 0x10, 222 => 0x10 },
	'imageareaoffset' => { 328 => 0x38 },
	'imageauthentication' => { 207 => 0x20 },
	'imageboundary' => { 207 => 0x16 },
	'imagecount' => { 118 => 0x1438, 207 => 0xa5, 387 => 0x11b, 402 => 0x32, 403 => 0x3a },
	'imagecount2' => { 402 => 0x4c, 403 => [0x52,0x58] },
	'imagecount3' => { 402 => [0x1a0,0x1aa,0x1bd], 403 => [0x19f,0x1cb,0x1cd] },
	'imagecreator' => { 280 => 'ImageCreator' },
	'imagecreatorid' => { 280 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 280 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 280 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedata' => { 424 => 'Data' },
	'imagedatasize' => { 207 => 0xa2 },
	'imagedescription' => { 113 => 0x10e, 457 => 'ImageDescription' },
	'imageduplicationconstraints' => { 280 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 246 => 0xfe443a45 },
	'imageeditcount' => { 328 => 0x41 },
	'imageediting' => { 328 => 0x32 },
	'imageeffects' => { 354 => 0x1010 },
	'imagefileconstraints' => { 280 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 280 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 280 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 118 => 0x1436 },
	'imageheight' => { 113 => 0x101, 174 => 0xc, 337 => 0x10d, 422 => 'ImageHeight', 457 => 'ImageLength' },
	'imagehistory' => { 113 => 0x9213, 440 => 'ImageHistory' },
	'imageidnumber' => { 288 => 0x340 },
	'imagemimetype' => { 424 => 'Mime' },
	'imagenumber' => { 113 => 0x9211, 143 => 'ImageNumber', 168 => 0xae, 169 => 0x5e, 337 => 0x113, 372 => 0x9b, 374 => [0x400,'276.1',0x314], 433 => 'ImageNumber' },
	'imagenumber2' => { 169 => 0x62 },
	'imageoptimization' => { 207 => 0xa9 },
	'imageorientation' => { 121 => 0x83 },
	'imageprocessing' => { 207 => 0x1a },
	'imageprocessingversion' => { 274 => 0x0 },
	'imagequality' => { 143 => 'ImageQuality', 221 => '723.2', 222 => '732.2', 231 => '708.1', 293 => 0x1 },
	'imagequality2' => { 270 => 0x603 },
	'imagerank' => { 427 => 'ImageRank' },
	'imageref' => { 445 => 'ImageRef' },
	'imagereview' => { 255 => '0.4', 264 => '0.4' },
	'imagereviewmonitorofftime' => { 254 => '21.1', 256 => '21.1', 257 => '21.1', 261 => '20.1', 266 => '21.1', 267 => '21.1' },
	'imagereviewtime' => { 253 => '25.1', 255 => '2.1', 258 => '19.1', 259 => '20.1', 260 => '20.1', 262 => '9.2', 263 => '20.1', 268 => '21.2' },
	'imagesize' => { 149 => 'ImageSize' },
	'imagesizerestriction' => { 454 => 'imageSizeRestriction' },
	'imagesourcedata' => { 113 => 0x935c },
	'imagestabilization' => { 33 => 0x22, 107 => 0x3020, 118 => 0x1422, 143 => 'ImageStabilization', 168 => 0xbd, 169 => 0x71, 170 => 0x57, 171 => 0x0, 172 => [0x18,0x107,0x113], 173 => 0x49c2, 207 => 0xac, 270 => 0x604, 273 => 0x1600, 293 => 0x1a, 377 => 0x12, 378 => 0x11, 384 => 0xb026 },
	'imagestabilization2' => { 376 => 0xa },
	'imagestabilizationsetting' => { 173 => 0x14, 372 => 0x3d, 373 => 0x3d, 383 => 0x14 },
	'imagestyle' => { 372 => 0x2d, 373 => 0x27 },
	'imagesupplier' => { 280 => 'ImageSupplier' },
	'imagesupplierid' => { 280 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 280 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 280 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 115 => 0x1 },
	'imagetemperaturemin' => { 115 => 0x2 },
	'imagetone' => { 328 => 0x4f },
	'imagetype' => { 121 => 0x82, 280 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 60 => 0x28, 113 => 0xa420, 440 => 'ImageUniqueID', 441 => 'ImageUniqueID' },
	'imagewidth' => { 113 => 0x100, 174 => 0xe, 337 => 0x10c, 422 => 'ImageWidth', 457 => 'ImageWidth' },
	'incrementaltemperature' => { 437 => 'IncrementalTemperature' },
	'incrementaltint' => { 437 => 'IncrementalTint' },
	'industry' => { 451 => 'industry', 452 => 'industry' },
	'infobuttonwhenshooting' => { 78 => 0x409 },
	'infraredilluminator' => { 349 => 0x28 },
	'ingredientexclusion' => { 453 => 'ingredientExclusion' },
	'ingredients' => { 462 => 'Ingredients' },
	'ingredientsalternatepaths' => { 462 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 462 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 462 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 462 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 462 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 462 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 462 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 462 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 462 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 462 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 462 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 462 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 462 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 462 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 462 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 462 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 462 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 462 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 462 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 462 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 462 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 462 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 462 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 78 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 425 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 425 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 425 => 'InitialViewHeadingDegrees', 426 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 425 => 'InitialViewPitchDegrees', 426 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 425 => 'InitialViewRollDegrees', 426 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 253 => '4.4' },
	'initialzoomsetting' => { 253 => '9.3', 262 => '27.3' },
	'inkset' => { 113 => 0x14c },
	'inputprofile' => { 127 => 0x1389 },
	'instanceid' => { 462 => 'InstanceID' },
	'instantplaybacksetup' => { 170 => 0x3e },
	'instantplaybacktime' => { 170 => 0x3d },
	'instructions' => { 449 => 'Instructions' },
	'instrument' => { 461 => 'instrument' },
	'intellectualgenre' => { 446 => 'IntellectualGenre' },
	'intelligentauto' => { 384 => 0xb052, 409 => 0xd, 410 => 0xe, 411 => 0xd },
	'intelligentcontrast' => { 49 => 0x4 },
	'intelligentd-range' => { 293 => 0x79 },
	'intelligentexposure' => { 293 => 0x5d },
	'intelligentresolution' => { 293 => 0x70 },
	'interchangecolorspace' => { 123 => 0x40 },
	'internalflash' => { 167 => 0x2b, 253 => '23.1', 255 => '8.1', 258 => '22.1', 260 => '23.1', 264 => '8.1', 268 => '24.1', 273 => 0x1208 },
	'internalflashae1' => { 275 => 0x1021 },
	'internalflashae1_0' => { 275 => 0x101d },
	'internalflashae2' => { 275 => 0x1022 },
	'internalflashae2_0' => { 275 => 0x101e },
	'internalflashmode' => { 316 => 0x1 },
	'internalflashstrength' => { 316 => 0x3 },
	'internalflashtable' => { 275 => 0x1024 },
	'internallensserialnumber' => { 361 => 0xa005 },
	'internalndfilter' => { 293 => 0x9d },
	'internalserialnumber' => { 60 => 0x96, 71 => 0x9, 118 => 0x10, 173 => 0x49dc, 269 => 0x18, 271 => 0x102, 290 => 0x500, 293 => 0x25, 308 => 0x4, 354 => 0x5, 402 => [0x7c,0xf0], 403 => 0x88 },
	'interopindex' => { 113 => 0x1, 442 => 'InteroperabilityIndex' },
	'interopversion' => { 113 => 0x2 },
	'intervallength' => { 167 => 0x10 },
	'intervalmode' => { 167 => 0x26 },
	'intervalnumber' => { 167 => 0x11 },
	'intervalshooting' => { 328 => 0x92 },
	'introtime' => { 461 => 'introTime' },
	'introtimescale' => { 461 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 461 => [\'introTime','introTimeValue'] },
	'iptc' => { 114 => 'IPTC' },
	'iptc-naa' => { 113 => 0x83bb, 298 => 0x83bb },
	'iptcbitspersample' => { 123 => 0x56 },
	'iptcdigest' => { 342 => 0x425 },
	'iptcimageheight' => { 123 => 0x1e },
	'iptcimagerotation' => { 123 => 0x66 },
	'iptcimagewidth' => { 123 => 0x14 },
	'iptclastedited' => { 447 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 123 => 0xa },
	'iptcpixelheight' => { 123 => 0x32 },
	'iptcpixelwidth' => { 123 => 0x28 },
	'isalternativeof' => { 451 => 'isAlternativeOf' },
	'isbn' => { 451 => 'isbn' },
	'iscorrectionof' => { 451 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 103 => 0x3 },
	'ismergedhdr' => { 433 => 'IsMergedHDR' },
	'ismergedpanorama' => { 433 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 106 => 0x14, 107 => [0x3014,0x14], 113 => 0x8827, 126 => 0xfd06, 127 => 0x1784, 129 => 0x60, 131 => [0xfa2e,0xfa46], 132 => [0x27,0x28], 133 => 0xf105, 136 => 0x14, 138 => 0x4e, 141 => 0x34, 143 => 'ISO', 167 => 0x8, 173 => 0x49ba, 201 => 0x0, 207 => 0x2, 298 => 0x17, 328 => [0x8b,0x14], 335 => 0x14, 337 => 0x105, 361 => 0xa014, 383 => 0x6f, 389 => [0x1f,0x21,0x25], 441 => 'ISOSpeedRatings' },
	'iso2' => { 201 => 0x6, 216 => 0x265, 217 => 0x25c, 218 => 0x265, 219 => 0x221, 220 => 0x25d, 221 => 0x256, 222 => 0x25d, 226 => 0x2b5, 229 => 0x265, 235 => 0x2b5 },
	'isoauto' => { 309 => '14.4' },
	'isoautohilimit' => { 224 => 0x18eb, 225 => 0xe82, 233 => 0x185d },
	'isoautoparameters' => { 328 => 0x7a },
	'isoautoshuttertime' => { 224 => 0x18ea, 225 => 0xe81, 233 => 0x185c },
	'isodisplay' => { 256 => '4.1', 257 => '4.1', 258 => '2.3', 259 => '3.3', 260 => '3.3', 263 => '3.3', 266 => '4.3', 267 => '4.1', 268 => '4.3' },
	'isoexpansion' => { 78 => 0x103, 79 => 0x7, 80 => 0x8, 83 => 0x8, 201 => 0x4 },
	'isoexpansion2' => { 201 => 0xa },
	'isofloor' => { 309 => 0x6 },
	'isoselection' => { 207 => 0xf },
	'isosensitivitystep' => { 261 => '6.2', 263 => '6.2' },
	'isosetting' => { 129 => 0x5e, 143 => 'ISOSetting', 167 => 0x24, 168 => 0x26, 169 => 0x1c, 170 => 0x13, 175 => 0x6, 207 => 0x13, 309 => '17.3', 353 => 0x27, 372 => 0x16, 373 => 0x14, 374 => 0x2, 383 => 0x6d },
	'isospeed' => { 113 => 0x8833, 442 => 'ISOSpeed' },
	'isospeedexpansion' => { 77 => 0x3 },
	'isospeedincrements' => { 78 => 0x102 },
	'isospeedlatitudeyyy' => { 113 => 0x8834, 442 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 113 => 0x8835, 442 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 78 => 0x103 },
	'isostepsize' => { 253 => '6.1', 254 => '7.2', 256 => '7.2', 257 => '7.2', 262 => '4.1', 266 => '7.2', 267 => '7.2' },
	'isovalue' => { 275 => 0x1001 },
	'issn' => { 451 => 'issn' },
	'issueidentifier' => { 451 => 'issueIdentifier' },
	'issuename' => { 451 => 'issueName' },
	'issueteaser' => { 451 => 'issueTeaser' },
	'issuetype' => { 451 => 'issueType' },
	'istranslationof' => { 451 => 'isTranslationOf' },
	'itemsubtype' => { 165 => 'ItemSubType' },
	'jobid' => { 121 => 0xb8 },
	'jobname' => { 443 => 'JobName' },
	'jobref' => { 460 => 'JobRef' },
	'jobrefid' => { 460 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 460 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 460 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 443 => 'JobStatus' },
	'jpeghandling' => { 437 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 293 => 0x43, 295 => 0x3034, 384 => 0xb047 },
	'jpegsize' => { 295 => 0x303a },
	'jpgcompression' => { 225 => 0x7d4 },
	'jpgfromraw' => { 91 => 0x2007, 108 => 'JpgFromRaw', 298 => 0x2e },
	'jpgfromrawlength' => { 113 => [0x117,0x202] },
	'jpgfromrawstart' => { 113 => [0x111,0x201] },
	'jpgrecordedpixels' => { 309 => '14.1' },
	'jurisdiction' => { 434 => 'jurisdiction' },
	'kelvinwb_01' => { 317 => 0x5 },
	'kelvinwb_02' => { 317 => 0x9 },
	'kelvinwb_03' => { 317 => 0xd },
	'kelvinwb_04' => { 317 => 0x11 },
	'kelvinwb_05' => { 317 => 0x15 },
	'kelvinwb_06' => { 317 => 0x19 },
	'kelvinwb_07' => { 317 => 0x1d },
	'kelvinwb_08' => { 317 => 0x21 },
	'kelvinwb_09' => { 317 => 0x25 },
	'kelvinwb_10' => { 317 => 0x29 },
	'kelvinwb_11' => { 317 => 0x2d },
	'kelvinwb_12' => { 317 => 0x31 },
	'kelvinwb_13' => { 317 => 0x35 },
	'kelvinwb_14' => { 317 => 0x39 },
	'kelvinwb_15' => { 317 => 0x3d },
	'kelvinwb_16' => { 317 => 0x41 },
	'kelvinwb_daylight' => { 317 => 0x1 },
	'key' => { 461 => 'key' },
	'keystonecompensation' => { 274 => 0x1900 },
	'keystonedirection' => { 274 => 0x1901 },
	'keystonevalue' => { 274 => 0x1906 },
	'keyword' => { 451 => 'keyword' },
	'keywordinfo' => { 158 => 'Keywords' },
	'keywords' => { 121 => 0x19, 144 => 'Keywords', 279 => 'Keywords', 344 => 'Keywords', 431 => 'keywords', 448 => 'Keywords', 459 => 'Keywords' },
	'killdate' => { 451 => 'killDate' },
	'killdatea-platform' => { 451 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 451 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 126 => 0xf908, 129 => 0xe, 131 => [0xfa1e,0xfa52], 137 => 0x70 },
	'kodakimagewidth' => { 126 => 0xf907, 129 => 0xc, 131 => [0xfa1d,0xfa51], 137 => 0x6c },
	'kodakinfotype' => { 126 => 0xfa00 },
	'kodaklook' => { 127 => 0xe4c },
	'kodaklookprofile' => { 127 => 0x138a },
	'kodakmaker' => { 137 => 0x8 },
	'kodakmodel' => { 129 => 0x0, 137 => 0x28 },
	'label' => { 283 => 'Label', 459 => 'Label' },
	'labelname1' => { 445 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 445 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 293 => 0x6f },
	'landscapeoutputhighlightpoint' => { 103 => 0x26 },
	'landscapeoutputshadowpoint' => { 103 => 0x27 },
	'landscaperawcolortone' => { 103 => 0x1f },
	'landscaperawcontrast' => { 103 => 0x21 },
	'landscaperawhighlight' => { 103 => 0x77 },
	'landscaperawhighlightpoint' => { 103 => 0x24 },
	'landscaperawlinear' => { 103 => 0x22 },
	'landscaperawsaturation' => { 103 => 0x20 },
	'landscaperawshadow' => { 103 => 0x80 },
	'landscaperawshadowpoint' => { 103 => 0x25 },
	'landscaperawsharpness' => { 103 => 0x23 },
	'landscapeunsharpmaskfineness' => { 103 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 103 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 103 => 0xa2 },
	'language' => { 438 => 'language' },
	'languageidentifier' => { 121 => 0x87 },
	'largestvalidinteriorrectheight' => { 425 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 425 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 425 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 425 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 167 => 0x1b },
	'lastkeywordiptc' => { 165 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 165 => 'LastKeywordXMP' },
	'lastphotodate' => { 425 => 'LastPhotoDate' },
	'lasturl' => { 462 => 'LastURL' },
	'lateralchromaticaberration' => { 384 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 433 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 112 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 112 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 112 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 319 => 0x2 },
	'lc10' => { 319 => 0xb },
	'lc11' => { 319 => 0xc },
	'lc12' => { 319 => 0xd },
	'lc14' => { 319 => 0xf },
	'lc15' => { 319 => 0x10 },
	'lc3' => { 319 => 0x4 },
	'lc4' => { 319 => 0x5 },
	'lc5' => { 319 => 0x6 },
	'lc6' => { 319 => 0x7 },
	'lc7' => { 319 => 0x8 },
	'lc8' => { 319 => 0x9 },
	'lcddisplayatpoweron' => { 78 => 0x811, 82 => 0xa },
	'lcddisplayreturntoshoot' => { 83 => 0x12 },
	'lcdillumination' => { 253 => '17.5', 254 => '5.2', 256 => '5.1', 257 => '5.1', 262 => '10.3', 263 => '4.2', 266 => '5.2', 267 => '5.1', 268 => '5.4' },
	'lcdilluminationduringbulb' => { 78 => 0x408 },
	'lcdpanels' => { 77 => 0x8 },
	'lcheditor' => { 246 => 0x8ae85e },
	'legacyiptcdigest' => { 449 => 'LegacyIPTCDigest' },
	'legalcode' => { 434 => 'legalcode' },
	'lens' => { 113 => 0xfdea, 207 => 0x84, 433 => 'Lens' },
	'lensafstopbutton' => { 76 => 0x11, 77 => 0x13, 78 => 0x506, 79 => 0x10, 80 => 0x12, 83 => 0x13, 84 => 0x9 },
	'lensaperturerange' => { 364 => [0x30,0x48] },
	'lenscorrectionsettings' => { 440 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 433 => 'LensDistortInfo' },
	'lensdistortionparams' => { 275 => 0x206 },
	'lensdrivenoaf' => { 78 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 374 => 0x3f0, 416 => 0xd },
	'lensfirmware' => { 355 => 0x20, 361 => 0xa004 },
	'lensfirmwareversion' => { 271 => 0x204, 293 => 0x60, 374 => 0x3f3, 416 => 0x14 },
	'lensfocallength' => { 97 => 0xf0512, 319 => 0x9 },
	'lensfocalrange' => { 364 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 254 => '55.1', 256 => '52.1', 257 => '52.1', 266 => '52.1', 267 => '52.1' },
	'lensformat' => { 396 => 0x1891, 398 => 0x18bd, 399 => 0x18ed, 400 => 0x17f1, 402 => 0x106, 403 => 0x106, 412 => 0x603, 413 => 0x5d },
	'lensfstops' => { 202 => 0x7, 203 => 0xc, 204 => 0xd, 207 => 0x8b, 319 => '0.3' },
	'lensid' => { 433 => 'LensID' },
	'lensidnumber' => { 202 => 0x6, 203 => 0xb, 204 => 0xc },
	'lensinfo' => { 113 => 0xa432, 325 => 0x2a, 433 => 'LensInfo', 442 => 'LensSpecification' },
	'lenskind' => { 319 => 0x1 },
	'lensmake' => { 113 => 0xa433, 150 => 'Make', 442 => 'LensMake' },
	'lensmanualdistortionamount' => { 437 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 165 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 364 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 60 => 0x95, 113 => 0xa434, 150 => 'Model', 165 => 'LensModel', 205 => 0x18a, 271 => 0x203, 325 => 0xc, 337 => 0x412, 442 => 'LensModel' },
	'lensmount' => { 374 => 0x99, 396 => 0x1892, 398 => 0x18be, 399 => 0x18ee, 400 => 0x17f2, 402 => 0x105, 403 => 0x105, 412 => 0x604, 413 => 0x5e },
	'lensmount2' => { 416 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 437 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 437 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 437 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 437 => 'LensProfileEnable' },
	'lensprofilefilename' => { 437 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 437 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 437 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 437 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 437 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 437 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 437 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 437 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 437 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 437 => 'LensProfileName' },
	'lensprofilesetup' => { 437 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 437 => 'LensProfileVignettingScale' },
	'lensproperties' => { 271 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 58 => 0x0, 113 => 0xa435, 150 => 'SerialNumber', 271 => 0x202, 291 => 0x321, 293 => 0x52, 355 => 0x30, 433 => 'LensSerialNumber', 442 => 'LensSerialNumber' },
	'lensshutterlock' => { 170 => 0x4a },
	'lensspec' => { 369 => 0x0, 370 => 0x0, 371 => 0x0, 384 => 0xb02a },
	'lensspecfeatures' => { 402 => [0x115,0x116], 403 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 275 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 172 => 0x10c, 173 => 0x49bd, 207 => 0x83, 271 => 0x201, 284 => 0x16, 288 => 0x310, 290 => 0x303, 291 => 0x303, 293 => 0x51, 295 => 0x3405, 320 => 0x0, 321 => 0x0, 322 => 0x1, 323 => 0x1, 324 => 0x1, 326 => 0x0, 361 => 0xa003, 364 => 0x27, 384 => 0xb027, 396 => 0x1896, 398 => 0x18c2, 399 => 0x18f2, 400 => 0x17f6, 402 => 0x109, 403 => 0x109, 412 => 0x608, 413 => 0x62 },
	'lenstype2' => { 374 => 0x3f7, 396 => 0x1893, 398 => 0x18bf, 399 => 0x18ef, 400 => 0x17f3, 402 => 0x107, 403 => 0x107, 412 => 0x605, 413 => 0x60 },
	'lenstype3' => { 416 => 0x9 },
	'lenszoomposition' => { 409 => 0x19, 410 => 0x1e, 413 => [0x342,0x35a] },
	'levelindicator' => { 301 => 0x15 },
	'levelorientation' => { 327 => 0x0 },
	'license' => { 434 => 'license' },
	'licensee' => { 280 => 'Licensee' },
	'licenseeid' => { 280 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 280 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 280 => 'LicenseeImageNotes' },
	'licenseename' => { 280 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 280 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 280 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 280 => 'LicenseeTransactionID' },
	'licenseid' => { 280 => 'LicenseID' },
	'licensestartdate' => { 280 => 'LicenseStartDate' },
	'licensetransactiondate' => { 280 => 'LicenseTransactionDate' },
	'licensetype' => { 439 => 'licensetype' },
	'licensor' => { 280 => 'Licensor' },
	'licensorcity' => { 280 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 280 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 280 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 280 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 280 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 280 => 'LicensorImageID' },
	'licensorname' => { 280 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 280 => 'LicensorNotes' },
	'licensorpostalcode' => { 280 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 280 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 280 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 280 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 280 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 280 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 280 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 280 => 'LicensorTransactionID' },
	'licensorurl' => { 280 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 275 => 0x1009 },
	'lightingmode' => { 107 => 0x302a },
	'lightreading' => { 328 => 0x15 },
	'lightsource' => { 113 => 0x9208, 207 => 0x90, 278 => 0x1000, 441 => 'LightSource' },
	'lightsourcespecial' => { 363 => 0x21d },
	'lightswitch' => { 266 => '0.1', 268 => '0.1' },
	'lightvaluecenter' => { 275 => 0x103d },
	'lightvalueperiphery' => { 275 => 0x103e },
	'limitafareamodeselection' => { 254 => '51.1', 256 => '49.1', 257 => '49.1', 266 => '49.1', 267 => '49.1' },
	'linearitylimitblue' => { 298 => 0x10 },
	'linearitylimitgreen' => { 298 => 0xf },
	'linearitylimitred' => { 298 => 0xe },
	'linearityuppermargin' => { 42 => [0x2ba,0x2d1,0x2d5], 44 => 0x1e5, 45 => [0x1fe,0x2de], 46 => [0x232,0x310], 47 => 0x31e },
	'linearizationtable' => { 113 => 0xc618 },
	'linearresponselimit' => { 113 => 0xc62e },
	'link' => { 451 => 'link' },
	'linkaetoafpoint' => { 309 => '14.2' },
	'linkedencodedrightsexpr' => { 447 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 447 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 447 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 447 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 112 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 258 => '32.1', 268 => '34.1' },
	'liveviewafareamode' => { 263 => '34.1' },
	'liveviewafmethod' => { 389 => 0x20 },
	'liveviewafmode' => { 263 => '34.2' },
	'liveviewafsetting' => { 374 => 0x36 },
	'liveviewbuttonoptions' => { 254 => '50.2', 256 => '48.2', 257 => '48.2', 266 => '48.2', 267 => '48.2' },
	'liveviewexposuresimulation' => { 78 => 0x810 },
	'liveviewfocusmode' => { 374 => [0x8b,0x28b] },
	'liveviewmetering' => { 374 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 254 => '21.2', 256 => '21.2', 257 => '21.2', 259 => '20.2', 260 => '20.2', 261 => '20.2', 263 => '20.2', 266 => '21.2', 267 => '21.2' },
	'liveviewshooting' => { 54 => 0x13 },
	'livingspecimen' => { 112 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 112 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 121 => 0x79 },
	'localizedcameramodel' => { 113 => 0xc615 },
	'locallocationname' => { 361 => 0x30 },
	'location' => { 206 => 0x9, 293 => 0x67, 429 => 'Location', 446 => 'Location', 450 => 'location', 451 => 'location' },
	'locationareacode' => { 435 => 'lac' },
	'locationcreated' => { 447 => 'LocationCreated' },
	'locationcreatedcity' => { 447 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 447 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 447 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 447 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 447 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 447 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 447 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 447 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 447 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 447 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 447 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 447 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 206 => 0x0 },
	'locationname' => { 361 => 0x31 },
	'locationshown' => { 447 => 'LocationShown' },
	'locationshowncity' => { 447 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 447 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 447 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 447 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 447 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 447 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 447 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 447 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 447 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 447 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 447 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 447 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 78 => 0x709 },
	'logcomment' => { 461 => 'logComment' },
	'longexposurenoisereduction' => { 59 => 0x4, 78 => 0x201, 79 => 0x1, 80 => 0x2, 81 => 0x1, 82 => 0x1, 83 => 0x2, 84 => 0x1, 293 => 0x49, 372 => 0x2b, 373 => 0x25, 374 => 0x25, 384 => 0x2008, 389 => 0x11, 413 => 0x44 },
	'longexposurenoisereduction2' => { 54 => 0x8 },
	'loop' => { 461 => 'loop' },
	'lowestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 437 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 437 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 437 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 437 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 437 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 437 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 437 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 437 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 102 => 0x150 },
	'luminancecurvepoints' => { 102 => 0x126 },
	'luminancenoisereduction' => { 97 => 0x20600, 103 => 0x5f, 364 => 0x1b },
	'luminancenoisereductioncontrast' => { 437 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 437 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 103 => 0x6d },
	'luminancesmoothing' => { 437 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 78 => [0x40b,0x40c] },
	'lyrics' => { 461 => 'lyrics' },
	'm16cversion' => { 288 => 0x333 },
	'macatom' => { 436 => 'macAtom' },
	'macatomapplicationcode' => { 436 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 436 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 436 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 112 => 'MachineObservation' },
	'machineobservationday' => { 112 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 112 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 112 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 112 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 112 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 112 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 112 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 112 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 112 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 112 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 112 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 112 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 112 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 112 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 112 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 112 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 112 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 112 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 112 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 112 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 118 => 0x1020, 119 => 0x202, 275 => 0x202, 353 => 0x21, 363 => 0x202, 384 => 0xb040 },
	'macroled' => { 273 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 54 => 0x10 },
	'macromode' => { 33 => 0x1, 167 => 0xb, 270 => 0x300, 293 => 0x1c, 354 => 0x1009 },
	'magentahsl' => { 97 => 0x20917 },
	'magicfilter' => { 270 => 0x52c },
	'magnifiedview' => { 80 => 0x11, 82 => 0x9 },
	'maindialexposurecomp' => { 264 => '0.6' },
	'mainingredient' => { 453 => 'mainIngredient' },
	'make' => { 92 => 0x0, 109 => 0x1, 113 => 0x10f, 143 => 'Make', 283 => 'Make', 298 => 0x10f, 450 => 'make', 457 => 'Make' },
	'makernote' => { 441 => 'MakerNote' },
	'makernoteapple' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecanon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotedji' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteflir' => { 111 => 'MakN', 113 => 0x927c },
	'makernotefujifilm' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehasselblad' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteisl' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvc' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvctext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak10' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak11' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak12' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak7' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8c' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak9' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodakunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekyocera' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica3' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica4' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica5' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica7' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica8' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica9' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotemotorola' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenintendo' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteoffset' => { 363 => 0xff },
	'makernoteolympus' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteolympus2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax6' => { 111 => 'MakN', 113 => 0x927c },
	'makernotephaseone' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericohtext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesafety' => { 113 => 0xc635 },
	'makernotesamsung1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyo' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyoc4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyopatch' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesigma' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonyericsson' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonysrf' => { 111 => 'MakN', 113 => 0x927c },
	'makernotetype' => { 354 => 0x1 },
	'makernoteunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknownbinary' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknowntext' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteversion' => { 172 => 0x0, 207 => 0x1, 275 => 0x0, 293 => 0x8000, 358 => 0x0, 361 => 0x1, 364 => [0x1d,0x1f], 375 => 0x2000 },
	'managedfrom' => { 462 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 462 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 462 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 462 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 462 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 462 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 462 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 462 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 462 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 462 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 462 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 462 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 462 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 462 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 462 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 462 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 462 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 462 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 462 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 462 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 462 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 462 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 462 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 462 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 462 => 'Manager' },
	'managervariant' => { 462 => 'ManagerVariant' },
	'manageto' => { 462 => 'ManageTo' },
	'manageui' => { 462 => 'ManageUI' },
	'manifest' => { 462 => 'Manifest' },
	'manifestlinkform' => { 462 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 462 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 462 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 462 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 462 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 462 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 462 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 462 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 462 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 462 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 462 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 462 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 462 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 462 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 462 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 462 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 462 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 462 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 462 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 462 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 462 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 462 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 462 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 462 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 462 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 462 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 462 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 462 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 270 => 0x900, 293 => 0x86 },
	'manometerreading' => { 270 => 0x901 },
	'manualafpointselectpattern' => { 78 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 273 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 255 => '8.2', 258 => '22.2', 259 => '23.1', 260 => '23.2', 262 => '16.2', 263 => '23.2', 264 => '8.2', 265 => '23.2', 268 => '24.2', 354 => 0x100c },
	'manualflashstrength' => { 270 => 0x406 },
	'manualfocusdistance' => { 207 => 0x85, 275 => 0x100c, 363 => 0x223 },
	'manualtv' => { 77 => 0x5, 78 => 0x705 },
	'manufacturedate' => { 177 => 0x6705, 308 => 0x1 },
	'manufacturedate1' => { 356 => 0x4 },
	'manufacturedate2' => { 356 => 0x5 },
	'manufacturer' => { 422 => 'Manufacturer', 450 => 'manufacturer' },
	'marked' => { 448 => 'Marked', 465 => 'Marked' },
	'markers' => { 461 => 'markers' },
	'markerscomment' => { 461 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 461 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 461 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 461 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 461 => [\'markers','markersCuePointType'] },
	'markersduration' => { 461 => [\'markers','markersDuration'] },
	'markerslocation' => { 461 => [\'markers','markersLocation'] },
	'markersname' => { 461 => [\'markers','markersName'] },
	'markersprobability' => { 461 => [\'markers','markersProbability'] },
	'markersspeaker' => { 461 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 461 => [\'markers','markersStartTime'] },
	'markerstarget' => { 461 => [\'markers','markersTarget'] },
	'markerstype' => { 461 => [\'markers','markersType'] },
	'maskedareas' => { 113 => 0xc68e },
	'masterdocumentid' => { 121 => 0xb9 },
	'mastergain' => { 214 => 0x50 },
	'materialsample' => { 112 => 'MaterialSample' },
	'materialsampleid' => { 112 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 254 => '50.1', 256 => '48.1', 257 => '48.1', 266 => '48.1', 267 => '48.1' },
	'matrixstructure' => { 348 => 0xa },
	'maxaperture' => { 33 => 0x1a, 133 => 0x6103, 150 => 'MaxAperture', 167 => 0x17, 173 => 0x49c5, 271 => 0x20a, 319 => '14.1' },
	'maxapertureatmaxfocal' => { 118 => 0x1407, 150 => 'MaxApertureAtMaxFocal', 202 => 0xb, 203 => 0x10, 204 => 0x11, 271 => 0x206 },
	'maxapertureatminfocal' => { 118 => 0x1406, 202 => 0xa, 203 => 0xf, 204 => 0x10, 271 => 0x205 },
	'maxaperturevalue' => { 113 => 0x9205, 337 => 0x414, 441 => 'MaxApertureValue' },
	'maxavailheight' => { 447 => 'MaxAvailHeight' },
	'maxavailwidth' => { 447 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 253 => 0xb, 254 => 0xc, 256 => '12.1', 257 => '12.1', 262 => 0xc, 263 => 0xb, 266 => '12.1', 267 => '12.1' },
	'maxfaces' => { 274 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 118 => 0x1405, 150 => 'MaxFocalLength', 202 => 0x9, 203 => 0xe, 204 => 0xf, 271 => 0x208, 396 => 0x127c, 397 => 0x1138, 398 => 0x330, 399 => 0x330, 400 => 0x30e },
	'maximumdensityrange' => { 123 => 0x8c },
	'maxpagesize' => { 466 => 'MaxPageSize' },
	'maxpagesizeh' => { 466 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 466 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 466 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 113 => 0x119 },
	'maxstorage' => { 456 => 'maxstorage' },
	'mb-d10batteries' => { 253 => '12.6' },
	'mb-d10batterytype' => { 262 => '13.3' },
	'mb-d11batterytype' => { 263 => '2.3' },
	'mb-d12batterytype' => { 266 => '3.2' },
	'mb-d80batteries' => { 264 => '6.5' },
	'mb-d80batterytype' => { 268 => '3.2' },
	'mcuversion' => { 202 => 0xc, 203 => 0x11, 204 => 0x12 },
	'md5digest' => { 151 => 'zmd5' },
	'mditemfindercomment' => { 160 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 160 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 160 => 'MDItemFSLabel' },
	'mditemusertags' => { 160 => 'MDItemUserTags' },
	'meal' => { 453 => 'meal' },
	'measuredev' => { 27 => 0x9, 72 => 0x3, 91 => 0x1814, 143 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 72 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 173 => 0x690, 288 => 0x312, 291 => 0x312, 292 => 0x312, 295 => 0x3407 },
	'measuredrggb' => { 61 => 0x1 },
	'measuredrggbdata' => { 41 => 0x287 },
	'measurementaccuracy' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 112 => 'MeasurementOrFact' },
	'measurementremarks' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 422 => 'MeasureType' },
	'mechanicalshuttercount' => { 207 => 0x37 },
	'mediaconstraints' => { 280 => 'MediaConstraints' },
	'mediacreatedate' => { 345 => 0x1 },
	'mediaeventiddate' => { 427 => 'MediaEventIdDate' },
	'mediamodifydate' => { 345 => 0x2 },
	'mediasummarycode' => { 280 => 'MediaSummaryCode' },
	'memoaudioquality' => { 78 => 0x812 },
	'memorycardconfiguration' => { 378 => 0x16 },
	'memorycardnumber' => { 193 => 0x2 },
	'menubuttondisplayposition' => { 76 => 0xb, 79 => 0xa, 80 => 0xb, 83 => 0xb },
	'menubuttonreturn' => { 84 => 0xb },
	'menumonitorofftime' => { 253 => '26.1', 254 => '22.1', 256 => '22.1', 257 => '22.1', 261 => '21.1', 262 => '8.2', 263 => '21.1', 266 => '22.1', 267 => '22.1', 268 => '22.1' },
	'metadatadate' => { 459 => 'MetadataDate' },
	'metadatamoddate' => { 461 => 'metadataModDate' },
	'metaversion' => { 391 => 0x34 },
	'meterinfo1row1' => { 385 => 0x0, 386 => 0x0 },
	'meterinfo1row2' => { 385 => 0x6c, 386 => 0x5a },
	'meterinfo1row3' => { 385 => 0xd8, 386 => 0xb4 },
	'meterinfo1row4' => { 385 => 0x144, 386 => 0x10e },
	'meterinfo1row5' => { 385 => 0x1b0, 386 => 0x168 },
	'meterinfo1row6' => { 385 => 0x21c, 386 => 0x1c2 },
	'meterinfo1row7' => { 385 => 0x288, 386 => 0x21c },
	'meterinfo2row1' => { 385 => 0x2f4, 386 => 0x276 },
	'meterinfo2row2' => { 385 => 0x378, 386 => 0x2e4 },
	'meterinfo2row3' => { 385 => 0x3fc, 386 => 0x352 },
	'meterinfo2row4' => { 385 => 0x480, 386 => 0x3c0 },
	'meterinfo2row5' => { 385 => 0x504, 386 => 0x42e },
	'meterinfo2row6' => { 385 => 0x588, 386 => 0x49c },
	'meterinfo2row7' => { 385 => 0x60c, 386 => 0x50a },
	'meterinfo2row8' => { 385 => 0x690, 386 => 0x578 },
	'meterinfo2row9' => { 385 => 0x714, 386 => 0x5e6 },
	'metering' => { 255 => '6.1' },
	'meteringmode' => { 33 => 0x11, 113 => 0x9207, 129 => 0x1c, 167 => 0x7, 168 => 0x25, 170 => 0x12, 270 => 0x202, 328 => 0x17, 364 => 0x9, 372 => 0x15, 373 => 0x13, 374 => 0x7, 389 => 0x3, 392 => 0x1174, 393 => 0x1178, 394 => 0x1154, 395 => 0x11d0, 396 => 0x11ac, 397 => 0x1064, 398 => 0x25c, 399 => 0x25c, 400 => 0x24b, 441 => 'MeteringMode' },
	'meteringmode2' => { 309 => '2.1', 384 => 0x202c },
	'meteringmode3' => { 309 => '16.1' },
	'meteringoffscaleindicator' => { 170 => 0x53 },
	'meteringtime' => { 253 => '22.2', 255 => '3.2', 258 => '17.1', 259 => '18.1', 262 => '7.3', 263 => '18.1', 264 => '3.2', 268 => '19.1' },
	'micro1version' => { 350 => 0x1f },
	'micro2version' => { 350 => 0x2d },
	'mieversion' => { 151 => '0Vers' },
	'mime' => { 422 => 'Mime' },
	'minaperture' => { 33 => 0x1b, 150 => 'MinAperture', 319 => '0.2' },
	'minaperturevalue' => { 337 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 118 => 0x1404, 150 => 'MinFocalLength', 202 => 0x8, 203 => 0xd, 204 => 0xe, 271 => 0x207, 396 => 0x127a, 397 => 0x1136, 398 => 0x32e, 399 => 0x32e, 400 => 0x30c },
	'minfocusdistance' => { 319 => 0x3 },
	'minoltadate' => { 167 => 0x15 },
	'minoltaimagesize' => { 167 => 0x4, 168 => 0xc, 169 => 0x2, 172 => 0x103 },
	'minoltamodelid' => { 167 => 0x25 },
	'minoltaquality' => { 167 => 0x5, 168 => 0xd, 169 => 0x3, 172 => [0x102,0x103] },
	'minoltatime' => { 167 => 0x16 },
	'minormodelagedisclosure' => { 280 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 113 => 0x118 },
	'mirrorlockup' => { 76 => 0xc, 77 => 0xc, 78 => 0x60f, 79 => 0xb, 80 => 0xc, 81 => 0x6, 82 => 0x6, 83 => 0xc, 84 => 0x3 },
	'mobilecountrycode' => { 435 => 'mcc' },
	'mobilenetworkcode' => { 435 => 'mnc' },
	'moddate' => { 283 => 'modify-date', 448 => 'ModDate' },
	'modedialposition' => { 378 => 0x14 },
	'model' => { 92 => 0x6, 113 => 0x110, 143 => 'Model', 283 => 'Model', 298 => 0x110, 328 => 0x23f, 364 => 0x84, 422 => 'Model', 450 => 'model', 457 => 'Model' },
	'modelage' => { 447 => 'ModelAge' },
	'modelid' => { 269 => 0x0 },
	'modelingflash' => { 253 => '21.4', 254 => '31.1', 256 => '31.1', 257 => '31.1', 262 => '26.4', 263 => '30.2', 264 => '7.4', 265 => '30.1', 266 => '31.1', 267 => '31.1', 268 => '31.3' },
	'modelreleaseid' => { 280 => 'ModelReleaseID' },
	'modelreleasestatus' => { 280 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 404 => 0x52, 405 => 0x46, 406 => 0x53 },
	'modelyear' => { 450 => 'modelYear' },
	'modificationdate' => { 451 => 'modificationDate' },
	'modifiedcolortemp' => { 62 => 0x9 },
	'modifieddigitalgain' => { 62 => 0xb },
	'modifiedparamflag' => { 55 => 0x1 },
	'modifiedpicturestyle' => { 62 => 0xa },
	'modifiedsaturation' => { 270 => 0x504 },
	'modifiedsensorbluelevel' => { 62 => 0x5 },
	'modifiedsensorredlevel' => { 62 => 0x4 },
	'modifiedsharpness' => { 62 => 0x2 },
	'modifiedsharpnessfreq' => { 62 => 0x3 },
	'modifiedtonecurve' => { 62 => 0x1 },
	'modifiedwhitebalance' => { 62 => 0x8 },
	'modifiedwhitebalanceblue' => { 62 => 0x7 },
	'modifiedwhitebalancered' => { 62 => 0x6 },
	'modifydate' => { 113 => 0x132, 144 => 'ModifyDate', 279 => 'ModDate', 281 => 'tIME', 344 => 'ModDate', 346 => 0x2, 459 => 'ModifyDate' },
	'moirefilter' => { 113 => 0xfe58, 437 => 'MoireFilter' },
	'monitordisplayoff' => { 170 => 0x4c },
	'monitorofftime' => { 253 => '18.2', 255 => '3.1', 264 => '3.1' },
	'monochromecolor' => { 270 => 0x53b },
	'monochromecontrast' => { 103 => 0x3c },
	'monochromefiltereffect' => { 97 => 0x20307, 103 => 0x3a, 328 => 0x73 },
	'monochromelinear' => { 103 => 0x3d },
	'monochromeoutputhighlightpoint' => { 103 => 0x41 },
	'monochromeoutputshadowpoint' => { 103 => 0x42 },
	'monochromeprofilesettings' => { 270 => 0x537 },
	'monochromerawhighlight' => { 103 => 0x7a },
	'monochromerawhighlightpoint' => { 103 => 0x3f },
	'monochromerawshadow' => { 103 => 0x83 },
	'monochromerawshadowpoint' => { 103 => 0x40 },
	'monochromesharpness' => { 103 => 0x3e },
	'monochrometoning' => { 328 => 0x74 },
	'monochrometoningeffect' => { 97 => 0x20306, 103 => 0x3b },
	'monochromeunsharpmaskfineness' => { 103 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 103 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 103 => 0xb4 },
	'monochromevignetting' => { 270 => 0x53a },
	'monthdaycreated' => { 129 => 0x12, 138 => 0xe },
	'moonphase' => { 349 => 0x12, 350 => 0x43 },
	'morepermissions' => { 434 => 'morePermissions' },
	'motionsensitivity' => { 349 => 0x29 },
	'movieaelockbuttonassignment' => { 266 => '40.1' },
	'moviefunc1button' => { 256 => '41.1', 257 => '41.1', 267 => '41.1' },
	'moviefunctionbutton' => { 254 => '41.1', 266 => '41.1' },
	'moviefunctionbuttonplusdials' => { 254 => '52.1' },
	'moviepreviewbutton' => { 254 => '41.2', 256 => '41.2', 257 => '41.2', 266 => '41.2', 267 => '41.2' },
	'moviepreviewbuttonplusdials' => { 254 => '52.2' },
	'movieshutterbutton' => { 254 => '38.3', 256 => '38.3', 257 => '38.3', 266 => '38.3', 267 => '38.3' },
	'moviesubselectorassignment' => { 254 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 254 => '53.1' },
	'multiburstimageheight' => { 384 => 0x1002 },
	'multiburstimagewidth' => { 384 => 0x1001 },
	'multiburstmode' => { 384 => 0x1000 },
	'multicontrollerwhilemetering' => { 78 => 0x517 },
	'multiexposure' => { 64 => 0x1 },
	'multiexposureautogain' => { 208 => 0x3 },
	'multiexposurecontrol' => { 64 => 0x2 },
	'multiexposuremode' => { 208 => 0x1 },
	'multiexposureshots' => { 64 => 0x3, 208 => 0x2 },
	'multiframenoisereduction' => { 374 => 0x35, 384 => 0x200b, 389 => 0x15 },
	'multiframenreffect' => { 384 => 0x2023 },
	'multifunctionlock' => { 78 => 0x70f },
	'multipleexposuremode' => { 274 => 0x101c },
	'multipleexposureset' => { 309 => '10.1' },
	'multisample' => { 214 => 0x40 },
	'multiselector' => { 253 => '9.4', 254 => '10.3', 256 => '10.3', 257 => '10.3', 262 => '27.4', 266 => '10.3', 267 => '10.3' },
	'multiselectorliveview' => { 253 => '4.3', 256 => '37.1', 257 => '37.1', 266 => '37.1', 267 => '37.1' },
	'multiselectorliveviewmode' => { 224 => 0x18c2 },
	'multiselectorplaybackmode' => { 253 => ['13.5','9.2'], 254 => '10.2', 257 => '10.2', 262 => '27.2', 266 => '10.2', 267 => '10.2' },
	'multiselectorshootmode' => { 253 => '9.1', 254 => '10.1', 256 => '10.1', 257 => '10.1', 262 => '27.1', 266 => '10.1', 267 => '10.1' },
	'multishot' => { 298 => 0x121 },
	'mycolormode' => { 65 => 0x2 },
	'nationalcatalognumber' => { 451 => 'nationalCatalogNumber' },
	'nativedigest' => { 441 => 'NativeDigest', 457 => 'NativeDigest' },
	'ncdfileinfo' => { 127 => 0x414 },
	'ndfilter' => { 72 => 0x1c, 270 => 0x204, 354 => 0x1019 },
	'near' => { 422 => 'Near' },
	'nefbitdepth' => { 207 => 0xe22 },
	'nefcompression' => { 207 => 0x93 },
	'neflinearizationtable' => { 207 => 0x96 },
	'negativecachelargepreviewsize' => { 437 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 437 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 437 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 328 => 0x88 },
	'neutraloutputhighlightpoint' => { 103 => 0x2f },
	'neutraloutputshadowpoint' => { 103 => 0x30 },
	'neutralrawcolortone' => { 103 => 0x28 },
	'neutralrawcontrast' => { 103 => 0x2a },
	'neutralrawhighlight' => { 103 => 0x78 },
	'neutralrawhighlightpoint' => { 103 => 0x2d },
	'neutralrawlinear' => { 103 => 0x2b },
	'neutralrawsaturation' => { 103 => 0x29 },
	'neutralrawshadow' => { 103 => 0x81 },
	'neutralrawshadowpoint' => { 103 => 0x2e },
	'neutralrawsharpness' => { 103 => 0x2c },
	'neutralunsharpmaskfineness' => { 103 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 103 => 0xa8 },
	'neutraunsharpmaskstrength' => { 103 => 0xa4 },
	'newrawimagedigest' => { 113 => 0xc7a7 },
	'newsphotoversion' => { 123 => 0x0 },
	'nickname' => { 459 => 'Nickname' },
	'nikoncapturedata' => { 207 => 0xe01 },
	'nikoncaptureeditversions' => { 207 => 0xe13 },
	'nikoncaptureoutput' => { 207 => 0xe1e },
	'nikoncaptureversion' => { 207 => 0xe09 },
	'nikoniccprofile' => { 207 => 0xe1d },
	'nikonimagesize' => { 221 => '723.1', 222 => '732.1', 231 => 0x2c4 },
	'noisefilter' => { 270 => 0x527 },
	'noiseprofile' => { 113 => 0xc761 },
	'noisereduction' => { 118 => 0x100b, 168 => 0xb0, 169 => 0x60, 170 => 0x3f, 207 => 0x95, 246 => 0x753dcbc0, 247 => 0x17, 270 => 0x50a, 275 => 0x103a, 293 => 0x2d, 328 => 0x49, 354 => 0x100f, 356 => 0x2a },
	'noisereduction2' => { 274 => 0x1010 },
	'noisereductionapplied' => { 113 => 0xc6f7 },
	'noisereductionintensity' => { 247 => 0x9 },
	'noisereductionmethod' => { 247 => 0x11 },
	'noisereductionmode' => { 417 => 0x801e },
	'noisereductionparams' => { 298 => 0x1b },
	'noisereductionsharpness' => { 247 => 0xd },
	'noisereductionvalue' => { 417 => 0x8027 },
	'nomemorycard' => { 253 => '22.1', 254 => '4.2', 255 => '0.3', 258 => '2.4', 259 => '3.2', 260 => '3.2', 262 => '33.7', 263 => '3.2', 264 => '0.3', 266 => '4.2', 268 => '4.5' },
	'nominalmaxaperture' => { 319 => 0xa },
	'nominalminaperture' => { 319 => '10.1' },
	'normalwhitelevel' => { 42 => [0x2b8,0x2cf,0x2d3], 44 => 0x1e3, 45 => [0x1fc,0x2dc], 46 => [0x230,0x30e], 47 => 0x31c },
	'notes' => { 418 => 'Notes', 431 => 'notes' },
	'npages' => { 466 => 'NPages' },
	'nullrecord' => { 91 => 0x0 },
	'numafpoints' => { 305 => 0x2 },
	'number' => { 451 => 'number' },
	'numberofbeats' => { 461 => 'numberOfBeats' },
	'numberoffocuspoints' => { 256 => '1.2', 257 => '1.2', 260 => '0.2', 261 => '0.3', 263 => '0.3' },
	'numfaceelements' => { 118 => 0x4200 },
	'numfacepositions' => { 285 => 0x0 },
	'numindexentries' => { 123 => 0x54 },
	'numwbentries' => { 299 => 0x0, 300 => 0x0 },
	'object' => { 451 => 'object' },
	'objectattributereference' => { 121 => 0x4 },
	'objectcycle' => { 121 => 0x4b, 431 => 'ObjectCycle' },
	'objectdescription' => { 450 => 'objectDescription' },
	'objectdistance' => { 106 => 0x6, 107 => 0x2022 },
	'objectname' => { 121 => 0x5 },
	'objectpreviewdata' => { 121 => 0xca },
	'objectpreviewfileformat' => { 121 => 0xc8 },
	'objectpreviewfileversion' => { 121 => 0xc9 },
	'objectsubtype' => { 450 => 'objectSubtype' },
	'objecttype' => { 450 => 'objectType' },
	'objecttypereference' => { 121 => 0x3 },
	'occurrence' => { 112 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 112 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 112 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 112 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 112 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 112 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 112 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 112 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 112 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 112 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 112 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 112 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 112 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 112 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 112 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 112 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 112 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 112 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 112 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 112 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 112 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 112 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 112 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 112 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 112 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 112 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 441 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 441 => [\'OECF','OECFNames'] },
	'oecfrows' => { 441 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 441 => [\'OECF','OECFValues'] },
	'offsaledate' => { 451 => 'offSaleDate' },
	'offsaledatea-platform' => { 451 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 451 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 113 => 0xea1d },
	'offsettime' => { 113 => 0x9010 },
	'offsettimedigitized' => { 113 => 0x9012 },
	'offsettimeoriginal' => { 113 => 0x9011 },
	'okbutton' => { 263 => '15.1', 268 => '16.1' },
	'oldsubfiletype' => { 113 => 0xff },
	'olympusimageheight' => { 275 => 0x102f },
	'olympusimagewidth' => { 275 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 275 => 0x302 },
	'onsaledate' => { 451 => 'onSaleDate' },
	'onsaledatea-platform' => { 451 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 451 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 451 => 'onSaleDay' },
	'onsaledaya-platform' => { 451 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 451 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 113 => 0xc740 },
	'opcodelist2' => { 113 => 0xc741 },
	'opcodelist3' => { 113 => 0xc74e },
	'opticalzoom' => { 131 => 0xfa3d, 133 => [0x6006,0xf006], 134 => 0x1000, 135 => 0xf, 138 => 0x1e, 150 => 'OpticalZoom' },
	'opticalzoomcode' => { 72 => 0xa },
	'opticalzoommode' => { 293 => 0x34 },
	'opticalzoomon' => { 363 => 0x219 },
	'optionenddate' => { 454 => 'optionEndDate' },
	'opto-electricconvfactor' => { 441 => 'OECF' },
	'orangehsl' => { 97 => 0x20911 },
	'ordernumber' => { 118 => 0x8002 },
	'organisationinimagecode' => { 447 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 447 => 'OrganisationInImageName' },
	'organism' => { 112 => 'Organism' },
	'organismassociatedoccurrences' => { 112 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 112 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 112 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 112 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 112 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 112 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 112 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 451 => 'organization' },
	'orientation' => { 113 => 0x112, 298 => 0x112, 450 => 'orientation', 457 => 'Orientation' },
	'orientation2' => { 389 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 78 => 0x516 },
	'originalbestqualitysize' => { 113 => 0xc792 },
	'originalcreatedatetime' => { 427 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 108 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 60 => 0x83 },
	'originaldefaultcropsize' => { 113 => 0xc793 },
	'originaldefaultfinalsize' => { 113 => 0xc791 },
	'originaldirectory' => { 290 => 0x408 },
	'originaldocumentid' => { 462 => 'OriginalDocumentID' },
	'originalfilename' => { 91 => 0x816, 127 => 0x3e9, 139 => 0x20, 290 => 0x407, 427 => 'OriginalFilename' },
	'originalimageheight' => { 74 => 0xc, 117 => 0x1 },
	'originalimagewidth' => { 74 => 0xb, 117 => 0x0 },
	'originalrawfiledata' => { 113 => 0xc68c },
	'originalrawfiledigest' => { 113 => 0xc71d },
	'originalrawfilename' => { 113 => 0xc68b },
	'originaltransmissionreference' => { 121 => 0x67 },
	'originatingprogram' => { 121 => 0x41, 431 => 'OriginatingProgram' },
	'originplatform' => { 451 => 'originPlatform' },
	'os' => { 439 => 'os' },
	'otherconditions' => { 280 => 'OtherConditions' },
	'otherconstraints' => { 280 => 'OtherConstraints' },
	'otherimage' => { 108 => 'OtherImage' },
	'otherimageinfo' => { 280 => 'OtherImageInfo' },
	'otherimagelength' => { 113 => 0x202 },
	'otherimagestart' => { 113 => 0x201 },
	'otherlicensedocuments' => { 280 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 280 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 280 => 'OtherLicenseRequirements' },
	'outcue' => { 461 => 'outCue' },
	'outcuescale' => { 461 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 461 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 182 => 0x3 },
	'outputimagewidth' => { 182 => 0x2 },
	'outputlut' => { 293 => 0xa7 },
	'outputprofile' => { 127 => 0x138b },
	'outputresolution' => { 182 => 0x4 },
	'owner' => { 465 => 'Owner' },
	'ownerid' => { 121 => 0xbc },
	'ownername' => { 14 => 0x10f, 60 => 0x9, 91 => 0x810, 113 => [0xa430,0xfde8], 143 => 'OwnerName', 433 => 'OwnerName', 442 => 'CameraOwnerName' },
	'padding' => { 113 => 0xea1c },
	'pagecount' => { 451 => 'pageCount' },
	'pageimage' => { 459 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 459 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 459 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 459 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 459 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 459 => 'PageInfo' },
	'pagename' => { 113 => 0x11d },
	'pagenumber' => { 113 => 0x129 },
	'pageprogressiondirection' => { 451 => 'pageProgressionDirection' },
	'pagerange' => { 451 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 437 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 437 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 296 => 0x0 },
	'panasonicexifversion' => { 293 => 0x26 },
	'panasonicimageheight' => { 293 => 0x4c },
	'panasonicimagewidth' => { 293 => 0x4b },
	'panasonicrawversion' => { 298 => 0x1 },
	'panasonictitle' => { 113 => 0xc6d2 },
	'panasonictitle2' => { 113 => 0xc6d3 },
	'panoramaangle' => { 118 => 0x1153 },
	'panoramacropbottom' => { 390 => 0x7 },
	'panoramacropleft' => { 390 => 0x4 },
	'panoramacropright' => { 390 => 0x6 },
	'panoramacroptop' => { 390 => 0x5 },
	'panoramadirection' => { 68 => 0x5, 118 => 0x1154, 390 => 0x3 },
	'panoramaframeheight' => { 390 => 0x9 },
	'panoramaframenumber' => { 68 => 0x2 },
	'panoramaframewidth' => { 390 => 0x8 },
	'panoramafullheight' => { 390 => 0x2 },
	'panoramafullwidth' => { 390 => 0x1 },
	'panoramamode' => { 129 => 0x3c, 270 => 0x601 },
	'panoramasize3d' => { 374 => 0x38 },
	'panoramasourceheight' => { 390 => 0xb },
	'panoramasourcewidth' => { 390 => 0xa },
	'panoramicstitchcameramotion' => { 163 => 'PanoramicStitchCameraMotion', 164 => 0x1 },
	'panoramicstitchmaptype' => { 163 => 'PanoramicStitchMapType', 164 => 0x2 },
	'panoramicstitchphi0' => { 163 => 'PanoramicStitchPhi0', 164 => 0x5 },
	'panoramicstitchphi1' => { 163 => 'PanoramicStitchPhi1', 164 => 0x6 },
	'panoramicstitchtheta0' => { 163 => 'PanoramicStitchTheta0', 164 => 0x3 },
	'panoramicstitchtheta1' => { 163 => 'PanoramicStitchTheta1', 164 => 0x4 },
	'panoramicstitchversion' => { 164 => 0x0 },
	'pantry' => { 462 => 'Pantry' },
	'parallax' => { 118 => 0xb211, 269 => 0x28 },
	'parametricdarks' => { 437 => 'ParametricDarks' },
	'parametrichighlights' => { 437 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 437 => 'ParametricHighlightSplit' },
	'parametriclights' => { 437 => 'ParametricLights' },
	'parametricmidtonesplit' => { 437 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 437 => 'ParametricShadows' },
	'parametricshadowsplit' => { 437 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 427 => 'ParentMediaEventID' },
	'parentmeid' => { 427 => 'ParentMEID' },
	'parentreference1' => { 445 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 445 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 461 => 'partOfCompilation' },
	'patientbirthdate' => { 419 => 'PatientDOB' },
	'patientid' => { 419 => 'PatientID' },
	'patientname' => { 419 => 'PatientName' },
	'patientsex' => { 419 => 'PatientSex' },
	'pdfversion' => { 448 => 'PDFVersion' },
	'pentaximagesize' => { 328 => 0x9 },
	'pentaxmodelid' => { 308 => 0x0, 328 => 0x5 },
	'pentaxmodeltype' => { 328 => 0x1 },
	'pentaxversion' => { 328 => 0x0 },
	'people' => { 420 => 'People', 429 => 'People' },
	'perchannelblacklevel' => { 41 => 0xc4, 42 => [0x2b4,0x2cb,0x2cf], 43 => [0x108,0x14d], 44 => 0x1df, 45 => [0x1f8,0x2d8], 46 => [0x22c,0x30a], 47 => 0x149 },
	'peripheralillumcentralradius' => { 417 => 0x8030 },
	'peripheralillumcentralvalue' => { 417 => 0x8031 },
	'peripheralillumination' => { 97 => 0x20702, 103 => 0x68 },
	'peripheralilluminationcorr' => { 59 => 0x1, 318 => 0x2 },
	'peripheralilluminationon' => { 97 => '0x20702.0', 103 => 0x64 },
	'peripheralillumperiphvalue' => { 417 => 0x8032 },
	'peripherallighting' => { 74 => 0x2 },
	'peripherallightingsetting' => { 75 => 0x5 },
	'peripherallightingvalue' => { 74 => 0x6 },
	'permissions' => { 454 => 'permissions' },
	'permits' => { 434 => 'permits' },
	'person' => { 451 => 'person' },
	'personality' => { 427 => 'Personality' },
	'personheard' => { 447 => 'PersonHeard' },
	'personheardidentifier' => { 447 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 447 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 447 => 'PersonInImage' },
	'personinimagecharacteristic' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 447 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 447 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 437 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 437 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 437 => 'PerspectiveRotate' },
	'perspectivescale' => { 437 => 'PerspectiveScale' },
	'perspectiveupright' => { 437 => 'PerspectiveUpright' },
	'perspectivevertical' => { 437 => 'PerspectiveVertical' },
	'perspectivex' => { 437 => 'PerspectiveX' },
	'perspectivey' => { 437 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 86 => 0x1 },
	'pf10retainprogramshift' => { 86 => 0xb },
	'pf13drivepriority' => { 86 => 0xe },
	'pf14disablefocussearch' => { 86 => 0xf },
	'pf15disableafassistbeam' => { 86 => 0x10 },
	'pf16autofocuspointshoot' => { 86 => 0x11 },
	'pf17disableafpointsel' => { 86 => 0x12 },
	'pf18enableautoafpointsel' => { 86 => 0x13 },
	'pf19continuousshootspeed' => { 86 => 0x14 },
	'pf19shootingspeedhigh' => { 85 => 0xa },
	'pf19shootingspeedlow' => { 85 => 0x9 },
	'pf1disableshootingmodes' => { 86 => 0x2 },
	'pf1value' => { 85 => 0x1 },
	'pf20limitcontinousshots' => { 86 => 0x15 },
	'pf20maxcontinousshots' => { 85 => 0xb },
	'pf21enablequietoperation' => { 86 => 0x16 },
	'pf23felocktime' => { 85 => 0xd },
	'pf23postreleasetime' => { 85 => 0xe },
	'pf23settimerlengths' => { 86 => 0x18 },
	'pf23shutterbuttontime' => { 85 => 0xc },
	'pf24lightlcdduringbulb' => { 86 => 0x19 },
	'pf25aemode' => { 85 => 0xf },
	'pf25afmode' => { 85 => 0x12 },
	'pf25afpointsel' => { 85 => 0x13 },
	'pf25colormatrix' => { 85 => 0x17 },
	'pf25defaultclearsettings' => { 86 => 0x1a },
	'pf25drivemode' => { 85 => 0x11 },
	'pf25imagesize' => { 85 => 0x14 },
	'pf25meteringmode' => { 85 => 0x10 },
	'pf25parameters' => { 85 => 0x16 },
	'pf25wbmode' => { 85 => 0x15 },
	'pf26shortenreleaselag' => { 86 => 0x1b },
	'pf27reversedialrotation' => { 86 => 0x1c },
	'pf27value' => { 85 => 0x18 },
	'pf28noquickdialexpcomp' => { 86 => 0x1d },
	'pf29quickdialswitchoff' => { 86 => 0x1e },
	'pf2disablemeteringmodes' => { 86 => 0x3 },
	'pf2value' => { 85 => 0x2 },
	'pf30enlargementmode' => { 86 => 0x1f },
	'pf31originaldecisiondata' => { 86 => 0x20 },
	'pf3manualexposuremetering' => { 86 => 0x4 },
	'pf3value' => { 85 => 0x3 },
	'pf4exposuretimelimits' => { 86 => 0x5 },
	'pf4exposuretimemax' => { 85 => 0x5 },
	'pf4exposuretimemin' => { 85 => 0x4 },
	'pf5aperturelimits' => { 86 => 0x6 },
	'pf5aperturemax' => { 85 => 0x7 },
	'pf5aperturemin' => { 85 => 0x6 },
	'pf6presetshootingmodes' => { 86 => 0x7 },
	'pf7bracketcontinuousshoot' => { 86 => 0x8 },
	'pf8bracketshots' => { 85 => 0x8 },
	'pf8setbracketshots' => { 86 => 0x9 },
	'pf9changebracketsequence' => { 86 => 0xa },
	'phasedetectaf' => { 179 => 0x6 },
	'phonenumber' => { 144 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 246 => 0xe9651831 },
	'photoeffects' => { 246 => 0xab5eca5e },
	'photoeffectsblue' => { 248 => 0x8 },
	'photoeffectsgreen' => { 248 => 0x6 },
	'photoeffectsred' => { 248 => 0x4 },
	'photoeffectstype' => { 248 => 0x0 },
	'photographicsensitivity' => { 442 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 253 => '17.6', 262 => '33.6' },
	'photometricinterpretation' => { 113 => 0x106, 457 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 225 => 0xe7d, 234 => 0xfbd },
	'photoshootingmenubankimagearea' => { 225 => '3716.1', 234 => 0x791 },
	'photoshopbgrthumbnail' => { 342 => 0x409 },
	'photoshopquality' => { 341 => 0x0 },
	'photoshopthumbnail' => { 342 => 0x40c },
	'photostyle' => { 293 => 0x89 },
	'picklabel' => { 440 => 'PickLabel' },
	'pictinfo' => { 363 => 0x208 },
	'picturecontrol' => { 246 => 0xe2173c47 },
	'picturecontrolactive' => { 249 => 0x0 },
	'picturecontroladjust' => { 209 => 0x30, 210 => 0x30 },
	'picturecontrolbase' => { 209 => 0x18, 210 => 0x18 },
	'picturecontroldata' => { 207 => [0xbd,0x23] },
	'picturecontrolmode' => { 249 => 0x13 },
	'picturecontrolname' => { 209 => 0x4, 210 => 0x4 },
	'picturecontrolquickadjust' => { 209 => 0x31, 210 => 0x31 },
	'pictureeffect' => { 384 => 0x200e },
	'pictureeffect2' => { 392 => 0x1163, 393 => 0x1167, 394 => 0x1143, 395 => 0x11bf, 396 => 0x119b, 397 => 0x1053, 398 => 0x24b, 399 => 0x24b, 400 => 0x23c, 413 => 0x46 },
	'picturefinish' => { 168 => 0x71 },
	'picturemode' => { 118 => 0x1031, 270 => 0x520, 328 => [0xb,0x33], 364 => 0x3d },
	'picturemode2' => { 309 => 0x0 },
	'picturemodebwfilter' => { 270 => 0x525 },
	'picturemodecontrast' => { 270 => 0x523 },
	'picturemodeeffect' => { 270 => 0x52d },
	'picturemodehue' => { 270 => 0x522 },
	'picturemodesaturation' => { 270 => 0x521 },
	'picturemodesharpness' => { 270 => 0x524 },
	'picturemodetone' => { 270 => 0x526 },
	'pictureprofile' => { 392 => [0x115e,0x115f], 393 => [0x1162,0x1163], 394 => [0x113e,0x113f], 395 => [0x11ba,0x11bb], 396 => [0x1196,0x1197], 397 => [0x104e,0x104f], 398 => [0x246,0x247], 399 => [0x246,0x247], 400 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 70 => 0xa, 97 => 0x20301, 103 => 0x2 },
	'picturewizard' => { 361 => 0x21 },
	'picturewizardcolor' => { 360 => 0x1 },
	'picturewizardcontrast' => { 360 => 0x4 },
	'picturewizardmode' => { 360 => 0x0 },
	'picturewizardsaturation' => { 360 => 0x2 },
	'picturewizardsharpness' => { 360 => 0x3 },
	'pipelineversion' => { 163 => 'PipelineVersion' },
	'pitch' => { 109 => 0x6, 254 => '4.1', 266 => '4.1' },
	'pitchangle' => { 224 => 0x350f, 225 => 0x2c28, 233 => 0x36f8, 270 => 0x904, 293 => 0x91, 327 => 0x2, 359 => 0x1 },
	'pixelshiftinfo' => { 384 => 0x202f },
	'pixelshiftresolution' => { 329 => 0x0 },
	'pixelsperunitx' => { 282 => 0x0 },
	'pixelsperunity' => { 282 => 0x4 },
	'pixelunits' => { 282 => 0x8 },
	'planarconfiguration' => { 113 => 0x11c, 457 => 'PlanarConfiguration' },
	'planningref' => { 447 => 'PlanningRef' },
	'planningrefidentifier' => { 447 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 447 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 447 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 466 => 'PlateNames' },
	'platform' => { 451 => 'platform' },
	'playbackmenustime' => { 258 => '20.1', 259 => '21.1', 260 => '21.1' },
	'playbackmonitorofftime' => { 253 => '25.2', 254 => '36.1', 256 => '36.1', 257 => '36.1', 261 => '35.1', 262 => '8.1', 263 => '35.1', 266 => '36.1', 267 => '36.1', 268 => '21.1' },
	'playbackzoom' => { 254 => '37.1' },
	'playdisplay' => { 170 => 0x4e },
	'plusversion' => { 280 => 'Version' },
	'pmversion' => { 340 => 'PMVersion' },
	'pngwarning' => { 283 => 'Warning' },
	'poilevel' => { 206 => 0x8 },
	'portraitoutputhighlightpoint' => { 103 => 0x1d },
	'portraitoutputshadowpoint' => { 103 => 0x1e },
	'portraitrawcolortone' => { 103 => 0x16 },
	'portraitrawcontrast' => { 103 => 0x18 },
	'portraitrawhighlight' => { 103 => 0x76 },
	'portraitrawhighlightpoint' => { 103 => 0x1b },
	'portraitrawlinear' => { 103 => 0x19 },
	'portraitrawsaturation' => { 103 => 0x17 },
	'portraitrawshadow' => { 103 => 0x7f },
	'portraitrawshadowpoint' => { 103 => 0x1c },
	'portraitrawsharpness' => { 103 => 0x1a },
	'portraitrefiner' => { 107 => 0x302b },
	'portraitunsharpmaskfineness' => { 103 => 0x9a },
	'portraitunsharpmaskstrength' => { 103 => 0x98 },
	'portraitunsharpmaskthreshold' => { 103 => 0x9c },
	'poseheadingdegrees' => { 425 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 425 => 'PosePitchDegrees' },
	'poserolldegrees' => { 425 => 'PoseRollDegrees' },
	'positiondescriptor' => { 450 => 'positionDescriptor' },
	'postalcode' => { 148 => 'PostalCode' },
	'postcropvignetteamount' => { 437 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 437 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 437 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 437 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 437 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 437 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 382 => 0xb },
	'potentialface2position' => { 382 => 0x15 },
	'potentialface3position' => { 382 => 0x1f },
	'potentialface4position' => { 382 => 0x29 },
	'potentialface5position' => { 382 => 0x33 },
	'potentialface6position' => { 382 => 0x3d },
	'potentialface7position' => { 382 => 0x47 },
	'potentialface8position' => { 382 => 0x51 },
	'powersource' => { 307 => '0.1' },
	'poweruptime' => { 207 => 0xb6 },
	'precaptureframes' => { 275 => 0x300 },
	'predictor' => { 113 => 0x13d },
	'preflashreturnstrength' => { 222 => 0x28a },
	'prefs' => { 121 => 0xdd, 340 => 'Prefs' },
	'preservedfilename' => { 462 => 'PreservedFileName' },
	'preservedspecimen' => { 112 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 112 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 170 => 0x24, 417 => 0x8002 },
	'presetwhitebalanceadj' => { 417 => 0x8014 },
	'pressure' => { 113 => 0x9402, 442 => 'Pressure' },
	'previewapplicationname' => { 113 => 0xc716 },
	'previewapplicationversion' => { 113 => 0xc717 },
	'previewbutton' => { 253 => ['14.1','15.1'], 254 => '15.1', 256 => '15.1', 257 => '15.1', 262 => '29.1', 263 => '14.1', 266 => '15.1', 267 => '15.1' },
	'previewbuttonplusdials' => { 253 => ['14.2','15.2'], 254 => '15.2', 256 => '43.1', 257 => '43.1', 262 => '31.2', 266 => '43.1', 267 => '43.1' },
	'previewcolorspace' => { 113 => 0xc71a },
	'previewcropbottom' => { 339 => 0xef },
	'previewcropleft' => { 339 => 0xec },
	'previewcropright' => { 339 => 0xee },
	'previewcroptop' => { 339 => 0xed },
	'previewdate' => { 347 => 0x0 },
	'previewdatetime' => { 113 => 0xc71b },
	'previewimage' => { 107 => 0x2000, 108 => 'PreviewImage', 114 => 'PreviewImage', 116 => 0x4, 153 => 'data', 172 => 0x81, 275 => 0x280, 291 => 0x300, 384 => 0x2001 },
	'previewimageborders' => { 328 => 0x3e },
	'previewimageheight' => { 69 => 0x4, 131 => 0xfa58 },
	'previewimagelength' => { 69 => 0x2, 107 => 0x3, 113 => [0x117,0x202], 172 => 0x89, 211 => 0x202, 270 => 0x102, 275 => 0x1037, 328 => 0x3, 353 => 0x1e, 358 => 0x3, 364 => [0x1b,0x1d], 375 => 0x202 },
	'previewimagename' => { 153 => '1Name' },
	'previewimagesize' => { 107 => 0x2, 136 => 0x2, 153 => 'ImageSize', 328 => 0x2, 364 => [0x1c,0x1e], 384 => 0xb02c },
	'previewimagestart' => { 69 => 0x5, 107 => 0x4, 113 => [0x111,0x201], 172 => 0x88, 211 => 0x201, 270 => 0x101, 275 => 0x1036, 328 => 0x4, 353 => 0x1c, 358 => 0x2, 364 => [0x1a,0x1c], 375 => 0x201 },
	'previewimagetype' => { 153 => '0Type' },
	'previewimagevalid' => { 270 => 0x100, 275 => 0x1035 },
	'previewimagewidth' => { 69 => 0x3, 131 => 0xfa57 },
	'previewquality' => { 69 => 0x1 },
	'previewsettingsdigest' => { 113 => 0xc719 },
	'previewsettingsname' => { 113 => 0xc718 },
	'primaryafpoint' => { 179 => [0x44,0x7] },
	'primarychromaticities' => { 113 => 0x13f, 457 => 'PrimaryChromaticities' },
	'primaryftp' => { 427 => 'PrimaryFTP' },
	'primaryslot' => { 225 => 0xe7f, 234 => 0xfbf },
	'printim' => { 113 => 0xc4a5 },
	'prioritysetinawb' => { 384 => 0x202b },
	'prioritysetupshutterrelease' => { 170 => 0x1d, 372 => 0x28 },
	'privatertkinfo' => { 428 => 'privateRTKInfo' },
	'processingsoftware' => { 113 => 0xb },
	'processversion' => { 437 => 'ProcessVersion' },
	'producer' => { 279 => 'Producer', 448 => 'Producer' },
	'productcode' => { 451 => 'productCode' },
	'productid' => { 122 => 0x32, 450 => 'productID' },
	'productidtype' => { 450 => 'productIDType' },
	'productinimage' => { 447 => 'ProductInImage' },
	'productinimagedescription' => { 447 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 447 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 447 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 308 => 0x2 },
	'productorserviceconstraints' => { 280 => 'ProductOrServiceConstraints' },
	'profession' => { 451 => 'profession' },
	'profilecalibrationsig' => { 113 => 0xc6f4 },
	'profilecopyright' => { 113 => 0xc6fe },
	'profileembedpolicy' => { 113 => 0xc6fd },
	'profilehuesatmapdata1' => { 113 => 0xc6fa },
	'profilehuesatmapdata2' => { 113 => 0xc6fb },
	'profilehuesatmapdims' => { 113 => 0xc6f9 },
	'profilehuesatmapencoding' => { 113 => 0xc7a3 },
	'profilelooktabledata' => { 113 => 0xc726 },
	'profilelooktabledims' => { 113 => 0xc725 },
	'profilelooktableencoding' => { 113 => 0xc7a4 },
	'profilename' => { 113 => 0xc6f8 },
	'profiletonecurve' => { 113 => 0xc6fc },
	'programiso' => { 293 => 0x3c },
	'programline' => { 309 => '1.1' },
	'programmode' => { 175 => 0x5 },
	'programshift' => { 207 => 0xd },
	'programversion' => { 121 => 0x46 },
	'prohibits' => { 434 => 'prohibits' },
	'projectiontype' => { 425 => 'ProjectionType', 426 => 'ProjectionType' },
	'projectname' => { 461 => 'projectName' },
	'projectref' => { 461 => 'projectRef' },
	'projectrefpath' => { 461 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 461 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 280 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 280 => 'PropertyReleaseStatus' },
	'province-state' => { 121 => 0x5f },
	'publicationdate' => { 451 => 'publicationDate' },
	'publicationdatea-platform' => { 451 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 451 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 451 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 451 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 451 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 447 => 'PublicationEvent' },
	'publicationeventdate' => { 447 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 447 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 447 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 451 => 'publicationName' },
	'publisher' => { 438 => 'publisher' },
	'publishingfrequency' => { 451 => 'publishingFrequency' },
	'pulldown' => { 461 => 'pullDown' },
	'purplehsl' => { 97 => 0x20916 },
	'quality' => { 0 => 0x1, 33 => 0x3, 106 => 0x2, 107 => 0x3002, 118 => 0x1000, 129 => 0x9, 207 => 0x4, 236 => 0x3, 275 => 0x201, 288 => 0x300, 328 => 0x8, 335 => 0x2, 364 => 0x16, 372 => 0x56, 373 => 0x56, 374 => 0xb, 384 => [0x102,0x202e] },
	'quality2' => { 392 => 0x1170, 393 => 0x1174, 394 => 0x1150, 396 => 0x11a8, 397 => 0x1060, 398 => 0x258, 399 => 0x258, 400 => 0x247, 404 => 0x29, 405 => 0x25, 406 => 0x2a },
	'qualitymode' => { 107 => 0x8 },
	'quantizationmethod' => { 123 => 0x78 },
	'quickadjust' => { 249 => 0x2a },
	'quickcontroldialinmeter' => { 78 => 0x703 },
	'quickfix' => { 246 => 0x416391c6 },
	'quickshot' => { 363 => 0x213 },
	'rangefinder' => { 258 => '4.1', 259 => '5.1', 260 => '5.1' },
	'rasterizedcaption' => { 121 => 0x7d },
	'rating' => { 113 => 0x4746, 118 => 0x1431, 339 => 0xdf, 384 => 0x2002, 431 => 'rating', 439 => 'rating', 447 => 'Rating', 451 => 'rating', 459 => 'Rating' },
	'ratingpercent' => { 113 => 0x4749, 165 => 'Rating' },
	'ratingratingregion' => { 447 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 447 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 447 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 447 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 447 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 447 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 447 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 447 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 447 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 447 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 447 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 447 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 447 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 447 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 447 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 447 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 447 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 447 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 76 => 0x8, 172 => 0x109, 309 => 0xd },
	'rawbrightnessadj' => { 97 => 0x20001, 102 => 0x38 },
	'rawcoloradj' => { 102 => 0x2e },
	'rawcropbottom' => { 339 => 0xd4 },
	'rawcropleft' => { 339 => 0xd1 },
	'rawcropright' => { 339 => 0xd3 },
	'rawcroptop' => { 339 => 0xd2 },
	'rawcustomsaturation' => { 102 => 0x30 },
	'rawcustomtone' => { 102 => 0x34 },
	'rawdata' => { 361 => 0xa048 },
	'rawdatabyteorder' => { 361 => 0x40 },
	'rawdatacfapattern' => { 361 => 0x50 },
	'rawdatauniqueid' => { 113 => 0xc65d },
	'rawdepth' => { 174 => 0x10 },
	'rawdevartfilter' => { 277 => 0x121 },
	'rawdevautogradation' => { 277 => 0x119 },
	'rawdevcolorspace' => { 276 => 0x108, 277 => 0x109 },
	'rawdevcontrastvalue' => { 276 => 0x106, 277 => 0x105 },
	'rawdeveditstatus' => { 276 => 0x10b },
	'rawdevelopmentprocess' => { 328 => 0x62 },
	'rawdevengine' => { 276 => 0x109, 277 => 0x10b },
	'rawdevexposurebiasvalue' => { 276 => 0x100, 277 => 0x100 },
	'rawdevgradation' => { 277 => 0x112 },
	'rawdevgraypoint' => { 276 => 0x103, 277 => 0x104 },
	'rawdevmemorycoloremphasis' => { 276 => 0x105, 277 => 0x108 },
	'rawdevnoisereduction' => { 276 => 0x10a, 277 => 0x10a },
	'rawdevpicturemode' => { 277 => 0x10c },
	'rawdevpm_bwfilter' => { 277 => 0x110 },
	'rawdevpmcontrast' => { 277 => 0x10e },
	'rawdevpmnoisefilter' => { 277 => 0x120 },
	'rawdevpmpicturetone' => { 277 => 0x111 },
	'rawdevpmsaturation' => { 277 => 0x10d },
	'rawdevpmsharpness' => { 277 => 0x10f },
	'rawdevsaturation3' => { 277 => 0x113 },
	'rawdevsaturationemphasis' => { 276 => 0x104, 277 => 0x107 },
	'rawdevsettings' => { 276 => 0x10c },
	'rawdevsharpnessvalue' => { 276 => 0x107, 277 => 0x106 },
	'rawdevversion' => { 276 => 0x0, 277 => 0x0 },
	'rawdevwbfineadjustment' => { 276 => 0x102, 277 => 0x103 },
	'rawdevwhitebalance' => { 277 => 0x101 },
	'rawdevwhitebalancevalue' => { 276 => 0x101, 277 => 0x102 },
	'rawfile' => { 113 => 0xfe4c },
	'rawfilename' => { 437 => 'RawFileName' },
	'rawfiletype' => { 384 => 0x2029 },
	'rawformat' => { 298 => 0x2d, 337 => 0x10e },
	'rawimagecenter' => { 207 => 0x99 },
	'rawimagedigest' => { 113 => 0xc71c },
	'rawimagesize' => { 328 => 0x39 },
	'rawinfoversion' => { 278 => 0x0 },
	'rawjpgheight' => { 93 => 0x4 },
	'rawjpgquality' => { 54 => 0x6, 93 => 0x1 },
	'rawjpgsize' => { 54 => 0x7, 93 => 0x2 },
	'rawjpgwidth' => { 93 => 0x3 },
	'rawmeasuredrggb' => { 40 => 0x26a, 42 => 0x280, 44 => 0x194, 45 => [0x1ad,0x26b] },
	'rawrppused' => { 431 => 'rawrppused' },
	'rawtopreviewgain' => { 113 => 0xc7a8 },
	'reardisplay' => { 253 => '12.3', 254 => '6.2' },
	'recdevice' => { 447 => 'RecDevice' },
	'recdeviceattlensdescription' => { 447 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 447 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 447 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 447 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 447 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 453 => 'recipeEndingPage' },
	'recipepagerange' => { 453 => 'recipePageRange' },
	'recipesource' => { 453 => 'recipeSource' },
	'recipestartingpage' => { 453 => 'recipeStartingPage' },
	'recipetitle' => { 453 => 'recipeTitle' },
	'recognizedface1age' => { 286 => 0x20 },
	'recognizedface1name' => { 286 => 0x4 },
	'recognizedface1position' => { 286 => 0x18 },
	'recognizedface2age' => { 286 => 0x50 },
	'recognizedface2name' => { 286 => 0x34 },
	'recognizedface2position' => { 286 => 0x48 },
	'recognizedface3age' => { 286 => 0x80 },
	'recognizedface3name' => { 286 => 0x64 },
	'recognizedface3position' => { 286 => 0x78 },
	'recognizedfaceflags' => { 293 => 0x63 },
	'recommendedexposureindex' => { 113 => 0x8832, 442 => 'RecommendedExposureIndex' },
	'record' => { 112 => 'Record' },
	'recordbasisofrecord' => { 112 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 112 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 112 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 112 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 112 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 112 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 170 => 0x4d },
	'recorddynamicproperties' => { 112 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 91 => 0x1804 },
	'recordinformationwithheld' => { 112 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 354 => 0x1000 },
	'recordingmode' => { 106 => 0x1, 335 => 0x1 },
	'recordinstitutioncode' => { 112 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 112 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 107 => 0x3000 },
	'recordownerinstitutioncode' => { 112 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 363 => 0x217 },
	'redbalance' => { 275 => 0x1017, 298 => 0x11, 328 => 0x1c },
	'redcurvelimits' => { 102 => 0x18a },
	'redcurvepoints' => { 101 => 0x2d, 102 => 0x160 },
	'redeyecorrection' => { 250 => 0x0 },
	'redeyeinfo' => { 437 => 'RedEyeInfo' },
	'redeyereduction' => { 170 => 0x41, 372 => 0x6a, 374 => 0x28 },
	'redhsl' => { 97 => 0x20910 },
	'redhue' => { 437 => 'RedHue' },
	'redsaturation' => { 437 => 'RedSaturation' },
	'reductionmatrix1' => { 113 => 0xc625 },
	'reductionmatrix2' => { 113 => 0xc626 },
	'reelname' => { 113 => 0xc789 },
	'reference1' => { 445 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 445 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 113 => 0x214, 457 => 'ReferenceBlackWhite' },
	'referencedate' => { 121 => 0x2f },
	'referencenumber' => { 121 => 0x32 },
	'references' => { 144 => 'References' },
	'referenceservice' => { 121 => 0x2d },
	'regionappliedtodimensions' => { 159 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 159 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 159 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 159 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 159 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 159 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 159 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 159 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 159 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 159 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 159 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 159 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 280 => 'RegionConstraints' },
	'regiondescription' => { 159 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 159 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 159 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 159 => 'Regions' },
	'regioninfodateregionsvalid' => { 162 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 162 => 'RegionInfo' },
	'regioninforegions' => { 162 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 159 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 159 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 162 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 159 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 159 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 159 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 447 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 447 => 'RegistryId' },
	'registryitemid' => { 447 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 447 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 142 => 'data' },
	'relatedaudiofilename' => { 142 => '1Name' },
	'relatedaudiofiletype' => { 142 => '0Type' },
	'relatedimagefileformat' => { 113 => 0x1000 },
	'relatedimageheight' => { 113 => 0x1002 },
	'relatedimagewidth' => { 113 => 0x1001 },
	'relatedresourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 113 => 0xa004, 441 => 'RelatedSoundFile' },
	'relatedvideofile' => { 156 => 'data' },
	'relatedvideofilename' => { 156 => '1Name' },
	'relatedvideofiletype' => { 156 => '0Type' },
	'relation' => { 438 => 'relation' },
	'relationshipaccordingto' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 110 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 461 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 461 => 'relativeTimestamp' },
	'relativetimestampscale' => { 461 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 461 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 253 => '17.8', 254 => '18.5', 256 => '18.4', 257 => '18.4', 262 => '33.8', 263 => '17.6', 266 => '18.5', 267 => '18.4' },
	'releasedate' => { 121 => 0x1e, 431 => 'ReleaseDate', 461 => 'releaseDate' },
	'releasemode' => { 107 => 0x3001, 224 => 0x184d, 384 => 0xb049 },
	'releasemode2' => { 392 => 0x112c, 393 => [0x112c,0x8], 394 => [0x1108,0x8], 395 => [0x1184,0x8], 396 => [0x1160,0x8], 397 => [0x4,0x1018], 398 => [0x4,0x210], 399 => [0x4,0x210], 400 => [0x4,0x208], 402 => [0x67,0x3f], 403 => [0x73,0x4b], 404 => 0x10, 405 => 0x10, 406 => 0x9, 413 => 0x34 },
	'releasemode3' => { 392 => 0x1128, 393 => 0x1128, 394 => 0x1104, 395 => 0x1180, 396 => 0x115c, 397 => 0x1014, 398 => 0x20c, 399 => 0x20c, 400 => 0x204 },
	'releaseready' => { 447 => 'ReleaseReady' },
	'releasesetting' => { 91 => 0x1016 },
	'releasetime' => { 121 => 0x23, 431 => 'ReleaseTime' },
	'remoteonduration' => { 255 => '3.4', 258 => '17.2', 259 => '18.2', 260 => '18.2', 261 => '18.2', 263 => '18.2', 264 => '4.3', 268 => '19.2' },
	'renditionclass' => { 462 => 'RenditionClass' },
	'renditionof' => { 462 => 'RenditionOf' },
	'renditionofalternatepaths' => { 462 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 462 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 462 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 462 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 462 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 462 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 462 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 462 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 462 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 462 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 462 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 462 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 462 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 462 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 462 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 462 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 462 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 462 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 462 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 462 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 462 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 462 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 462 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 462 => 'RenditionParams' },
	'repeatingflashcount' => { 194 => 0xd, 195 => 0xe, 196 => 0xe, 197 => 0xe, 198 => 0xe, 262 => '17.2', 263 => '24.2', 264 => '9.2', 265 => '24.2', 268 => '25.2' },
	'repeatingflashcountbuilt-in' => { 232 => 0x4db },
	'repeatingflashcountexternal' => { 232 => 0x4c3 },
	'repeatingflashoutput' => { 262 => '17.1', 263 => '24.1', 264 => '9.1', 265 => '24.1', 268 => '25.1' },
	'repeatingflashoutputexternal' => { 232 => 0x4c0 },
	'repeatingflashrate' => { 194 => 0xc, 195 => 0xd, 196 => 0xd, 197 => 0xd, 198 => 0xd, 262 => '18.1', 263 => '25.1', 264 => '10.1', 265 => '25.1', 268 => '26.1' },
	'repeatingflashratebuilt-in' => { 232 => 0x4da },
	'repeatingflashrateexternal' => { 232 => 0x4c2 },
	'requires' => { 434 => 'requires' },
	'resampleparams' => { 461 => 'resampleParams' },
	'resampleparamsquality' => { 461 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 363 => 0x21e },
	'resolution' => { 149 => 'Resolution' },
	'resolutionmode' => { 364 => 0x4 },
	'resolutionunit' => { 113 => 0x128, 124 => 0x2, 457 => 'ResolutionUnit' },
	'resourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 112 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 78 => 0x612 },
	'restrictions' => { 454 => 'restrictions' },
	'retouchareafeather' => { 437 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 437 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 437 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 437 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 437 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 437 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 437 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 437 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 437 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 437 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 437 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 437 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 437 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 437 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 437 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 437 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 437 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 437 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 437 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 437 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 437 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 437 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 437 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 437 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 437 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 437 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 437 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 437 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 437 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 437 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 437 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 437 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 437 => 'RetouchAreas' },
	'retouchareaseed' => { 437 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 437 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 437 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 437 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 207 => 0x9e },
	'retouchinfo' => { 437 => 'RetouchInfo' },
	'retouchnefprocessing' => { 213 => 0x5 },
	'retractlensonpoweroff' => { 78 => 0x814 },
	'reuse' => { 280 => 'Reuse' },
	'reuseallowed' => { 464 => 'ReuseAllowed' },
	'reuseprohibited' => { 454 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 260 => '5.2' },
	'reverseindicators' => { 253 => '12.1', 254 => '6.1', 256 => '6.1', 257 => '6.1', 258 => '4.3', 259 => '5.2', 260 => '5.4', 262 => '33.5', 263 => '5.1', 266 => '6.1', 267 => '6.1', 268 => '6.2' },
	'reverseshutterspeedaperture' => { 260 => '5.3' },
	'revision' => { 439 => 'revision' },
	'rgbcurvelimits' => { 102 => 0x238 },
	'rgbcurvepoints' => { 101 => 0x7, 102 => 0x20e },
	'richtextcomment' => { 444 => 'RichTextComment' },
	'ricohdate' => { 353 => 0x6 },
	'ricohimageheight' => { 353 => 0x2 },
	'ricohimagewidth' => { 353 => 0x0 },
	'rightascension' => { 152 => 'RightAscension' },
	'rights' => { 438 => 'rights' },
	'rightsagent' => { 454 => 'rightsAgent' },
	'rightsowner' => { 454 => 'rightsOwner' },
	'roll' => { 109 => 0x8 },
	'rollangle' => { 224 => 0x350b, 225 => 0x2c24, 233 => 0x36f4, 270 => 0x903, 293 => 0x90, 327 => 0x1, 359 => 0x2 },
	'romoperationmode' => { 91 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 90 => 0x3, 97 => 0x10002, 102 => 0x26e, 108 => 'Rotation', 117 => 0x4, 152 => 'Rotation', 168 => [0x65,0x50], 169 => 0x46, 170 => 0x5a, 173 => 0x10, 224 => 0x3693, 225 => 0xca, 231 => '590.1', 246 => 0x76a43207, 293 => 0x30, 309 => '17.2', 339 => 0xd8, 372 => 0x3f, 373 => 0x3f, 383 => 0x10 },
	'routedto' => { 443 => 'RoutedTo' },
	'routing' => { 344 => 'Routing' },
	'routingdestinations' => { 427 => 'RoutingDestinations' },
	'routingexclusions' => { 427 => 'RoutingExclusions' },
	'routingnotes' => { 443 => 'RoutingNotes' },
	'rowsperstrip' => { 113 => 0x116 },
	'rpp' => { 431 => 'rpp' },
	'safetyshift' => { 78 => 0x108 },
	'safetyshiftinavortv' => { 76 => 0x10, 77 => 0x10, 79 => 0xf, 80 => 0x10, 83 => 0x10 },
	'sameexposurefornewaperture' => { 78 => 0x112 },
	'samplebits' => { 142 => 'SampleBits' },
	'samplepagerange' => { 451 => 'samplePageRange' },
	'samplerate' => { 142 => 'SampleRate' },
	'samplesperpixel' => { 113 => 0x115, 298 => 0x8, 457 => 'SamplesPerPixel' },
	'samplestructure' => { 123 => 0x5a },
	'samsungmodelid' => { 361 => 0x3 },
	'sanyoquality' => { 363 => 0x201 },
	'sanyothumbnail' => { 363 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 48 => 0x1, 106 => 0xd, 107 => [0x3013,0x1f], 113 => [0xa409,0xfe55], 118 => 0x1003, 143 => 'Saturation', 167 => 0x1f, 168 => 0x32, 169 => 0x28, 170 => 0x1a, 175 => 0x1, 207 => [0x94,0xaa], 209 => 0x35, 210 => 0x3b, 293 => 0x40, 295 => 0x300d, 328 => 0x1f, 335 => 0xd, 349 => 0x27, 353 => 0x28, 354 => 0x1013, 364 => 0x10, 372 => 0x1e, 373 => 0x1b, 384 => 0x2005, 437 => 'Saturation', 441 => 'Saturation' },
	'saturationadj' => { 97 => 0x20901, 102 => 0x116, 245 => 0x1, 249 => 0x2e, 417 => 0x8016 },
	'saturationadjustmentaqua' => { 437 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 437 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 437 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 437 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 437 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 437 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 437 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 437 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 67 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 66 => 0x68, 67 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 66 => 0x38, 67 => 0x38 },
	'saturationmonochrome' => { 66 => 0x80, 67 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 66 => 0x50, 67 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 66 => 0x20, 67 => 0x20 },
	'saturationsetting' => { 278 => 0x1010, 374 => 0x11, 389 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 66 => 0x8, 67 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 66 => 0x98, 67 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 66 => 0xb0, 67 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 66 => 0xc8, 67 => 0xe0 },
	'saveid' => { 462 => 'SaveID' },
	'scaletype' => { 461 => 'scaleType' },
	'scanimageenhancer' => { 214 => 0x60 },
	'scanningdirection' => { 123 => 0x64 },
	'scene' => { 446 => 'Scene', 461 => 'scene' },
	'scenearea' => { 273 => 0x211, 275 => 0x1031 },
	'sceneassist' => { 207 => 0x9c },
	'scenecapturetype' => { 113 => 0xa406, 441 => 'SceneCaptureType' },
	'scenedetect' => { 273 => 0x210, 275 => 0x1030 },
	'scenedetectdata' => { 273 => 0x212, 275 => 0x1033 },
	'scenemode' => { 131 => 0xfa02, 172 => 0x100, 207 => 0x8f, 270 => 0x509, 275 => 0x403, 293 => 0x8001, 302 => 0xf, 384 => 0xb023 },
	'scenemodeused' => { 133 => [0x6002,0xf002] },
	'scenerecognition' => { 118 => 0x1425 },
	'sceneselect' => { 363 => 0x21f },
	'scenetype' => { 113 => 0xa301, 441 => 'SceneType' },
	'screentips' => { 253 => '12.7', 254 => '5.3', 262 => '13.1', 263 => '4.4', 266 => '5.4', 268 => '5.1' },
	'season' => { 447 => 'Season', 450 => 'season' },
	'seasonidentifier' => { 447 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 447 => [\'Season','SeasonName'] },
	'seasonnumber' => { 447 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 427 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 224 => 0x1d0, 233 => 0x1d0 },
	'section' => { 451 => 'section' },
	'securityclassification' => { 113 => 0x9212 },
	'selectableafpoint' => { 78 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 78 => 0x512 },
	'selftimer' => { 33 => 0x2, 293 => 0x2e, 363 => 0x214, 392 => 0x1134, 393 => 0x1134, 394 => 0x1110, 395 => 0x118c, 396 => 0x1168, 397 => 0x1020, 398 => 0x218, 399 => 0x218, 400 => 0x210 },
	'selftimer2' => { 72 => 0x1d },
	'selftimerinterval' => { 263 => '19.2' },
	'selftimermode' => { 113 => 0x882b },
	'selftimershotcount' => { 254 => '20.2', 256 => '20.3', 257 => '20.3', 258 => '18.2', 259 => '19.2', 260 => '19.2', 261 => '19.3', 263 => '19.3', 266 => '20.3', 267 => '20.3', 268 => '20.2' },
	'selftimershotinterval' => { 254 => '20.3', 256 => '20.2', 257 => '20.2', 261 => '19.2', 266 => '20.2', 267 => '20.2' },
	'selftimertime' => { 91 => 0x1806, 170 => 0x1f, 253 => '18.1', 254 => '20.1', 255 => '3.3', 256 => '20.1', 257 => '20.1', 258 => '18.1', 259 => '19.1', 260 => '19.1', 261 => '19.1', 262 => '7.2', 263 => '19.1', 264 => '3.3', 266 => '20.1', 267 => '20.1', 268 => '20.1' },
	'sellingagency' => { 451 => 'sellingAgency' },
	'seminfo' => { 113 => 0x8546 },
	'sensingmethod' => { 113 => 0xa217, 441 => 'SensingMethod' },
	'sensitivityadjust' => { 328 => 0x40 },
	'sensitivitysteps' => { 309 => ['14.3','17.4'], 311 => 0x1 },
	'sensitivitytype' => { 113 => 0x8830, 442 => 'SensitivityType' },
	'sensor' => { 177 => 0x665e },
	'sensorareas' => { 361 => 0xa010 },
	'sensorbitdepth' => { 295 => 0x312d },
	'sensorbluelevel' => { 70 => 0x5 },
	'sensorcalibration' => { 274 => 0x805 },
	'sensorcleaning' => { 84 => 0xd },
	'sensorfullheight' => { 126 => 0xf904 },
	'sensorfullwidth' => { 126 => 0xf903 },
	'sensorheight' => { 126 => 0xf901, 131 => 0xfa21, 174 => 0x8, 295 => 0x312c, 337 => 0x109, 354 => 0x1602 },
	'sensorleftmargin' => { 337 => 0x10a },
	'sensorpixelsize' => { 207 => 0x9a },
	'sensorredlevel' => { 70 => 0x4 },
	'sensorserialnumber' => { 127 => 0x9ce },
	'sensorsize' => { 143 => 'SensorSize', 328 => 0x35 },
	'sensortemperature' => { 273 => 0x1500, 275 => 0x1007, 333 => 0xc, 337 => 0x210, 364 => [0x39,0x55] },
	'sensortemperature2' => { 333 => 0xe, 337 => 0x211 },
	'sensortopmargin' => { 337 => 0x10b },
	'sensorwidth' => { 126 => 0xf900, 131 => 0xfa20, 174 => 0xa, 295 => 0x312b, 337 => 0x108, 354 => 0x1601 },
	'sequence' => { 349 => 0x7, 350 => 0x35 },
	'sequencefilenumber' => { 393 => 0x4, 394 => 0x4, 395 => 0x4, 396 => 0x4, 404 => 0xc, 405 => 0xc, 406 => 0x1a },
	'sequenceimagenumber' => { 393 => 0x0, 394 => 0x0, 395 => 0x0, 396 => 0x0, 404 => 0x8, 405 => 0x8, 406 => 0x12, 413 => 0x24 },
	'sequencelength' => { 404 => 0x22, 405 => 0x1e, 406 => [0x16,0x1e] },
	'sequencename' => { 450 => 'sequenceName' },
	'sequencenumber' => { 72 => 0x9, 107 => 0x301c, 118 => 0x1101, 129 => 0x1d, 232 => 0x51c, 293 => 0x2b, 374 => [0x10c,0x30c], 384 => 0xb04a, 450 => 'sequenceNumber' },
	'sequenceshotinterval' => { 363 => 0x224 },
	'sequencetotalnumber' => { 450 => 'sequenceTotalNumber' },
	'sequentialshot' => { 363 => 0x20e },
	'serialnumber' => { 60 => 0xc, 91 => 0x180b, 113 => [0xa431,0xfde9], 126 => 0xfa04, 128 => 0xfa00, 130 => 0xc354, 131 => 0xfa19, 140 => 0x0, 143 => 'SerialNumber', 207 => [0xa0,0x1d], 271 => 0x101, 275 => [0x404,0x101a], 288 => 0x303, 290 => 0x305, 295 => 0x3103, 328 => 0x229, 337 => 0x102, 338 => 0x407, 349 => 0x15, 350 => 0x4b, 354 => 0x5, 361 => 0xa002, 364 => 0x2, 384 => 0x2031, 433 => 'SerialNumber', 442 => 'BodySerialNumber' },
	'serialnumberformat' => { 60 => 0x15, 91 => 0x183b },
	'series' => { 447 => 'Series' },
	'seriesdatetime' => { 419 => 'SeriesDateTime' },
	'seriesdescription' => { 419 => 'SeriesDescription' },
	'seriesidentifier' => { 447 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 419 => 'SeriesModality' },
	'seriesname' => { 447 => [\'Series','SeriesName'] },
	'seriesnumber' => { 419 => 'SeriesNumber', 451 => 'seriesNumber' },
	'seriestitle' => { 451 => 'seriesTitle' },
	'serviceidentifier' => { 122 => 0x1e },
	'servingsize' => { 453 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 81 => 0x0, 82 => 0x0 },
	'setbuttonwhenshooting' => { 76 => 0x1, 78 => 0x704, 84 => 0xc },
	'setfunctionwhenshooting' => { 79 => 0x0, 80 => 0x1, 83 => 0x1 },
	'setting' => { 450 => 'setting' },
	'shadingcompensation' => { 270 => 0x50c, 293 => 0x8a },
	'shadingcompensation2' => { 274 => 0x1012 },
	'shadow' => { 364 => 0xe },
	'shadowadj' => { 97 => 0x2030b },
	'shadowcorrection' => { 328 => 0x79 },
	'shadowprotection' => { 245 => 0x0 },
	'shadows' => { 113 => 0xfe52, 430 => 'Shadows', 437 => 'Shadows' },
	'shadows2012' => { 437 => 'Shadows2012' },
	'shadowscale' => { 113 => 0xc633 },
	'shadowtint' => { 437 => 'ShadowTint' },
	'shadowtone' => { 118 => 0x1040 },
	'shakereduction' => { 330 => 0x1, 331 => 0x1 },
	'sharpendetail' => { 437 => 'SharpenDetail' },
	'sharpenedgemasking' => { 437 => 'SharpenEdgeMasking' },
	'sharpening' => { 295 => 0x300b },
	'sharpeningadj' => { 249 => 0x2b },
	'sharpenradius' => { 437 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 70 => 0x2, 106 => 0xb, 107 => [0x3011,0x21], 113 => [0xa40a,0xfe56], 118 => 0x1001, 129 => 0x6b, 138 => 0x37, 143 => 'Sharpness', 167 => 0x21, 168 => 0x30, 169 => 0x26, 170 => 0x18, 175 => 0x3, 207 => 0x6, 209 => 0x32, 210 => 0x33, 275 => 0x100f, 293 => 0x41, 328 => 0x21, 335 => 0xb, 349 => 0x26, 353 => 0x22, 354 => [0x1003,0x1014], 364 => 0x11, 372 => 0x1c, 373 => 0x19, 384 => 0x2006, 413 => 0x52, 437 => 'Sharpness', 441 => 'Sharpness' },
	'sharpnessadj' => { 97 => 0x20310, 102 => 0x25a, 417 => 0x801a },
	'sharpnessadjon' => { 97 => '0x20310.0' },
	'sharpnessauto' => { 67 => 0x94 },
	'sharpnessfactor' => { 275 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 66 => 0x64, 67 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 70 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 66 => 0x34, 67 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 66 => 0x7c, 67 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 66 => 0x4c, 67 => 0x4c },
	'sharpnessovershoot' => { 417 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 66 => 0x1c, 67 => 0x1c },
	'sharpnesssetting' => { 270 => 0x506, 278 => 0x1013, 374 => 0x12, 389 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 66 => 0x4, 67 => 0x4 },
	'sharpnessstrength' => { 97 => 0x20311 },
	'sharpnessthreshold' => { 417 => 0x801d },
	'sharpnessundershoot' => { 417 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 66 => 0x94, 67 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 66 => 0xac, 67 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 66 => 0xc4, 67 => 0xdc },
	'shootid' => { 450 => 'shootID' },
	'shootingdistance' => { 97 => 0x20701 },
	'shootinginfodisplay' => { 253 => '13.2', 254 => '5.1', 262 => '10.2', 263 => '4.1', 266 => '5.1', 268 => '5.3' },
	'shootinginfomonitorofftime' => { 253 => '26.2', 254 => '22.2', 256 => '22.2', 257 => '22.2', 261 => '21.2', 262 => '9.1', 263 => '21.2', 266 => '22.2', 267 => '22.2', 268 => '22.2' },
	'shootingmode' => { 143 => 'ShootingMode', 207 => 0x89, 293 => 0x1f },
	'shootingmodesetting' => { 255 => '5.1' },
	'shortdescription' => { 439 => 'shortdescription' },
	'shortdocumentid' => { 121 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 78 => 0x80d },
	'shotdate' => { 461 => 'shotDate' },
	'shotday' => { 461 => 'shotDay' },
	'shotlocation' => { 461 => 'shotLocation' },
	'shotname' => { 461 => 'shotName' },
	'shotnumber' => { 461 => 'shotNumber' },
	'shotnumbersincepowerup' => { 388 => 0x44e, 404 => 0x1a, 405 => 0x16, 406 => 0xa },
	'shotnumbersincepowerup2' => { 374 => 0x200 },
	'shotsize' => { 461 => 'shotSize' },
	'shownevent' => { 447 => 'EventExt' },
	'showneventidentifier' => { 447 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 447 => [\'EventExt','EventExtName'] },
	'shutter-aelock' => { 76 => 0x4, 78 => 0x701, 79 => 0x3, 80 => 0x4, 81 => 0x3, 82 => 0x3, 83 => 0x4, 84 => 0x2 },
	'shutteraelbutton' => { 77 => 0x4 },
	'shutterbuttonafonbutton' => { 78 => 0x701 },
	'shuttercount' => { 10 => 0x176, 54 => 0x1, 207 => 0xa7, 215 => [0x6a,0x157,0x24d], 216 => 0x286, 217 => 0x279, 218 => 0x284, 219 => 0x242, 220 => 0x280, 221 => 0x276, 222 => [0x27d,0x27f], 223 => 0x246, 226 => 0x2d6, 227 => 0x321, 228 => 0xbd8, 229 => 0x287, 230 => 0x320, 231 => 0x24a, 232 => 0x5fb, 235 => 0x2d5, 328 => 0x5d, 383 => 0x846, 387 => [0x125,0x14a] },
	'shuttercurtainsync' => { 76 => 0xf, 77 => 0xf, 78 => 0x305, 79 => 0xe, 80 => 0xf, 81 => 0x8, 82 => 0x8, 83 => 0xf, 84 => 0x8 },
	'shuttermode' => { 129 => 0x1b },
	'shutterreleasebuttonae-l' => { 253 => '17.7', 254 => '18.4', 256 => '78.4', 257 => '78.4', 258 => '16.1', 259 => '17.1', 260 => '17.1', 261 => '17.1', 262 => '7.1', 263 => '17.5', 266 => '18.4', 267 => '78.4', 268 => '18.2' },
	'shutterreleasemethod' => { 91 => 0x1010 },
	'shutterreleasenocfcard' => { 76 => 0x2, 77 => 0x2, 84 => 0xf },
	'shutterreleasetiming' => { 91 => 0x1011 },
	'shutterreleasewithoutlens' => { 78 => 0x711 },
	'shutterspeedlock' => { 254 => '38.1', 256 => '38.1', 257 => '38.1', 266 => '38.1', 267 => '38.1' },
	'shutterspeedrange' => { 78 => 0x10c },
	'shutterspeedsetting' => { 170 => 0x6, 372 => 0x2f, 373 => 0x28, 374 => 0x0 },
	'shutterspeedvalue' => { 87 => 0x1, 113 => 0x9201, 275 => 0x1000, 337 => 0x400, 441 => 'ShutterSpeedValue' },
	'shuttertype' => { 118 => 0x1050, 293 => 0x9f },
	'sidecarforextension' => { 449 => 'SidecarForExtension' },
	'similarityindex' => { 121 => 0xe4 },
	'singleframebracketing' => { 170 => 0x21 },
	'skilllevel' => { 453 => 'skillLevel' },
	'skintonecorrection' => { 328 => 0x95 },
	'slaveflashmeteringsegments' => { 328 => 0x20b },
	'slideshowname' => { 450 => 'slideshowName' },
	'slideshownumber' => { 450 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 450 => 'slideshowTotalNumber' },
	'slowshutter' => { 72 => 0x8 },
	'slowsync' => { 118 => 0x1030 },
	'smartalbumcolor' => { 361 => 0x20 },
	'smartrange' => { 361 => 0xa012 },
	'smileshutter' => { 374 => 0x31 },
	'smileshuttermode' => { 374 => 0x27 },
	'smoothness' => { 113 => 0xfe57, 437 => 'Smoothness' },
	'snapshot' => { 447 => 'SnapshotLink' },
	'snapshotformat' => { 447 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 447 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 447 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 447 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 447 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 431 => 'Snapshots' },
	'snapshotusedvideoframe' => { 447 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 447 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 447 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 447 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 447 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 384 => 0x200f },
	'software' => { 113 => 0x131, 144 => 'Software', 283 => 'Software', 337 => 0x203, 364 => 0x18, 422 => 'Software', 457 => 'Software' },
	'softwareversion' => { 363 => 0x207 },
	'sonydatetime' => { 391 => 0x6, 393 => 0x1b6, 394 => 0x210, 395 => 0x1fe, 396 => 0x22c },
	'sonydatetime2' => { 402 => 0x51 },
	'sonyexposuretime' => { 402 => 0x3a, 403 => 0x46 },
	'sonyexposuretime2' => { 413 => 0xe },
	'sonyfnumber' => { 402 => 0x3c, 403 => 0x48, 413 => 0x14 },
	'sonyimageheight' => { 391 => 0x1a, 404 => 0x44, 405 => 0x3f, 406 => 0x47 },
	'sonyimageheightmax' => { 413 => 0x40 },
	'sonyimagesize' => { 170 => 0x3b, 372 => 0x54, 373 => 0x54, 374 => 0x9 },
	'sonyimagewidth' => { 391 => 0x1c },
	'sonyimagewidthmax' => { 413 => 0x3e },
	'sonyiso' => { 393 => 0x1218, 394 => 0x11f4, 395 => 0x1270, 396 => [0x1254,0x1258,0x1280], 397 => 0x113c, 398 => 0x344, 399 => 0x346, 400 => 0x320, 413 => 0x4 },
	'sonymaxaperture' => { 402 => 0x0, 403 => 0x0 },
	'sonymaxaperturevalue' => { 413 => 0x16 },
	'sonyminaperture' => { 402 => 0x1, 403 => 0x1 },
	'sonymodelid' => { 384 => 0xb001 },
	'sonyquality' => { 170 => 0x3c },
	'sonytimeminsec' => { 403 => 0x61 },
	'source' => { 121 => 0x73, 283 => 'Source', 438 => 'source', 439 => 'source', 449 => 'Source' },
	'sourcecount' => { 426 => 'SourceCount' },
	'sourcedirectoryindex' => { 315 => 0x0 },
	'sourcefileindex' => { 315 => 0x2 },
	'sourcephotoscount' => { 425 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 441 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 441 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 441 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 441 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 441 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 461 => 'speakerPlacement' },
	'specialeffectlevel' => { 107 => 0x3030 },
	'specialeffectmode' => { 107 => 0x2076 },
	'specialeffectsetting' => { 107 => 0x3031 },
	'specialinstructions' => { 121 => 0x28 },
	'specialmode' => { 275 => 0x200, 363 => 0x200 },
	'specialoccasion' => { 453 => 'specialOccasion' },
	'spectralsensitivity' => { 113 => 0x8824, 441 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 42 => [0x2b9,0x2d0,0x2d4], 44 => 0x1e4, 45 => [0x1fd,0x2dd], 46 => [0x231,0x30f], 47 => 0x31d },
	'speedx' => { 109 => 0x3 },
	'speedy' => { 109 => 0x4 },
	'speedz' => { 109 => 0x5 },
	'spherical' => { 426 => 'Spherical' },
	'splitcolumn' => { 337 => 0x222 },
	'splittoningbalance' => { 437 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 437 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 437 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 437 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 437 => 'SplitToningShadowSaturation' },
	'sport' => { 451 => 'sport' },
	'spotfocuspointx' => { 167 => 0x2d },
	'spotfocuspointy' => { 167 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 78 => 0x107 },
	'sractive' => { 309 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 330 => 0x3 },
	'srhalfpresstime' => { 330 => 0x2 },
	'srresult' => { 330 => 0x0, 331 => 0x0 },
	'stackedimage' => { 270 => 0x804 },
	'standardoutputhighlightpoint' => { 103 => 0x14 },
	'standardoutputsensitivity' => { 113 => 0x8831, 442 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 103 => 0x15 },
	'standardrawcolortone' => { 103 => 0xd },
	'standardrawcontrast' => { 103 => 0xf },
	'standardrawhighlight' => { 103 => 0x75 },
	'standardrawhighlightpoint' => { 103 => 0x12 },
	'standardrawlinear' => { 103 => 0x10 },
	'standardrawsaturation' => { 103 => 0xe },
	'standardrawshadow' => { 103 => 0x7e },
	'standardrawshadowpoint' => { 103 => 0x13 },
	'standardrawsharpness' => { 103 => 0x11 },
	'standardunsharpmaskfineness' => { 103 => 0x94 },
	'standardunsharpmaskstrength' => { 103 => 0x92 },
	'standardunsharpmaskthreshold' => { 103 => 0x96 },
	'standbytimer' => { 254 => '19.1', 256 => '19.1', 257 => '19.1', 260 => '18.1', 261 => '18.1', 266 => '19.1', 267 => '19.1' },
	'startingpage' => { 451 => 'startingPage' },
	'startmovieshooting' => { 78 => 0x70d },
	'starttimecode' => { 461 => 'startTimecode' },
	'starttimecodetimeformat' => { 461 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 461 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 461 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 461 => 'startTimeSampleSize' },
	'starttimescale' => { 461 => 'startTimeScale' },
	'state' => { 148 => 'State', 293 => 0x6b, 449 => 'State' },
	'status' => { 420 => 'Status', 429 => 'Status' },
	'stereomode' => { 426 => 'StereoMode' },
	'stitched' => { 426 => 'Stitched' },
	'stitchingsoftware' => { 425 => 'StitchingSoftware', 426 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 392 => 0x113e, 393 => 0x113e, 394 => 0x111a, 395 => 0x1196, 396 => 0x1172, 397 => 0x102a, 398 => 0x222, 399 => 0x222, 400 => 0x217, 413 => 0xa },
	'storagemethod' => { 174 => 0x12 },
	'storebyorientation' => { 254 => '46.3', 256 => '47.3', 257 => '47.3', 266 => '47.3', 267 => '47.3' },
	'storylineidentifier' => { 447 => 'StorylineIdentifier' },
	'straightenangle' => { 246 => 0x2fc08431 },
	'streamready' => { 447 => 'StreamReady' },
	'streamtype' => { 163 => 'StreamType' },
	'stretchmode' => { 461 => 'stretchMode' },
	'studydatetime' => { 419 => 'StudyDateTime' },
	'studydescription' => { 419 => 'StudyDescription' },
	'studyid' => { 419 => 'StudyID' },
	'studyphysician' => { 419 => 'StudyPhysician' },
	'styleperiod' => { 447 => 'StylePeriod' },
	'sub-location' => { 121 => 0x5c },
	'subfiledata' => { 151 => 'data' },
	'subfiledirectory' => { 151 => '1Directory' },
	'subfilemimetype' => { 151 => '2MIME' },
	'subfilename' => { 151 => '1Name' },
	'subfileresource' => { 151 => 'rsrc' },
	'subfiletype' => { 113 => 0xfe, 151 => '0Type' },
	'subject' => { 279 => 'Subject', 344 => 'Subject', 438 => 'subject', 448 => 'Subject', 462 => 'subject' },
	'subjectarea' => { 113 => 0x9214, 441 => 'SubjectArea' },
	'subjectcode' => { 446 => 'SubjectCode' },
	'subjectdistance' => { 113 => 0x9206, 129 => 0x3e, 441 => 'SubjectDistance' },
	'subjectdistancerange' => { 113 => 0xa40c, 441 => 'SubjectDistanceRange' },
	'subjectlocation' => { 113 => 0xa214, 441 => 'SubjectLocation' },
	'subjectmotion' => { 256 => '78.2', 257 => '78.2', 267 => '78.2' },
	'subjectprogram' => { 167 => 0x22 },
	'subjectreference' => { 121 => 0xc },
	'sublabels4' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 445 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 445 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 108 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 108 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 108 => 'SubSecModifyDate' },
	'subsectime' => { 113 => 0x9290 },
	'subsectimedigitized' => { 113 => 0x9292 },
	'subsectimeoriginal' => { 113 => 0x9291 },
	'subsection1' => { 451 => 'subsection1' },
	'subsection2' => { 451 => 'subsection2' },
	'subsection3' => { 451 => 'subsection3' },
	'subsection4' => { 451 => 'subsection4' },
	'subselector' => { 254 => '49.1', 256 => '71.1', 257 => '71.1', 267 => '71.1' },
	'subselectorassignment' => { 254 => '48.1' },
	'subselectorcenter' => { 256 => '72.1', 257 => '72.1', 267 => '72.1' },
	'subselectorplusdials' => { 254 => '49.2', 256 => '73.1', 257 => '73.1', 267 => '73.1' },
	'subtitle' => { 451 => 'subtitle' },
	'subversionfilename' => { 445 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 445 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 445 => 'SubVersions' },
	'superimposeddisplay' => { 76 => 0xa, 78 => 0x510, 79 => 0x9, 80 => 0xa, 83 => 0xa, 84 => 0xe },
	'supermacro' => { 60 => 0x1a },
	'supplementalcategories' => { 121 => 0x14, 449 => 'SupplementalCategories' },
	'supplementaltype' => { 123 => 0x37 },
	'supplementdisplayid' => { 451 => 'supplementDisplayID' },
	'supplementstartingpage' => { 451 => 'supplementStartingPage' },
	'supplementtitle' => { 451 => 'supplementTitle' },
	'supplychainsource' => { 447 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 447 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 447 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 309 => 0x14 },
	'swatchcoloranta' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 466 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 466 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 466 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 466 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 466 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 293 => 0x93, 374 => 0x33 },
	'sweeppanoramafieldofview' => { 293 => 0x94 },
	'sweeppanoramasize' => { 374 => 0x32 },
	'switchtoregisteredafpoint' => { 77 => 0x12, 78 => 0x50a },
	'syncreleasemode' => { 256 => '77.1', 257 => '77.1', 267 => '77.1' },
	'system' => { 337 => 0x204 },
	'tagged' => { 339 => 0xdd, 340 => 'Tagged', 431 => 'tagged' },
	'tagslist' => { 440 => 'TagsList' },
	'tagstructure' => { 445 => 'TagStructure' },
	'takenumber' => { 461 => 'takeNumber' },
	'tapename' => { 461 => 'tapeName' },
	'targetaperture' => { 72 => 0x4 },
	'targetcompressionratio' => { 89 => 0x1 },
	'targetdistancesetting' => { 91 => 0x1807 },
	'targetexposuretime' => { 72 => 0x5 },
	'targetimagetype' => { 91 => 0x100a },
	'targetprinter' => { 113 => 0x151 },
	'taxon' => { 112 => 'Taxon' },
	'taxonacceptednameusage' => { 112 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 112 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 112 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 112 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 112 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 112 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 112 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 112 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 112 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 112 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 112 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 112 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 112 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 112 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 112 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 112 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 112 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 112 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 112 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 112 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 112 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 112 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 112 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 112 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 112 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 112 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 112 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 112 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 112 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 112 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 112 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 112 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 112 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 451 => 'teaser' },
	'teleconverter' => { 172 => 0x105, 384 => 0x105 },
	'tempo' => { 461 => 'tempo' },
	'temporalcoverage' => { 447 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 447 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 447 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 280 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 280 => 'TermsAndConditionsURL' },
	'testname' => { 114 => 'TestName' },
	'textencoding' => { 206 => 0x4 },
	'textlayername' => { 449 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 449 => 'TextLayers' },
	'textlayertext' => { 449 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 293 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 256 => '1.3', 257 => '1.3', 267 => '1.4' },
	'three-dtrackingwatcharea' => { 256 => '78.1', 257 => '78.1', 267 => '78.1' },
	'thresholding' => { 113 => 0x107 },
	'thumbnailfilename' => { 91 => 0x817 },
	'thumbnailformat' => { 459 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 131 => 0xfa55, 459 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 91 => 0x2008, 108 => 'ThumbnailImage', 116 => 0x3, 154 => 'data', 275 => 0x100, 459 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 154 => '1Name' },
	'thumbnailimagesize' => { 154 => 'ImageSize' },
	'thumbnailimagetype' => { 154 => '0Type' },
	'thumbnailimagevalidarea' => { 60 => 0x13 },
	'thumbnaillength' => { 113 => 0x202 },
	'thumbnailoffset' => { 113 => 0x201 },
	'thumbnails' => { 459 => 'Thumbnails' },
	'thumbnailwidth' => { 131 => 0xfa54, 459 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 451 => 'ticker' },
	'tiffhandling' => { 437 => 'TIFFHandling' },
	'tiffmeteringimage' => { 173 => 0x104c, 383 => 0x1110 },
	'tilelength' => { 113 => 0x143 },
	'tilewidth' => { 113 => 0x142 },
	'time' => { 127 => 0x401, 328 => 0x7 },
	'timecodes' => { 113 => 0xc763 },
	'timecreated' => { 121 => 0x3c, 129 => 0x14, 138 => 0x10, 340 => 'TimeCreated' },
	'timeperiod' => { 451 => 'timePeriod' },
	'timerfunctionbutton' => { 255 => '5.2', 258 => '12.1', 259 => '13.1' },
	'timerlength' => { 78 => 0x80c },
	'timerrecording' => { 293 => 0x96 },
	'timescaleparams' => { 461 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 461 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 461 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 461 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 122 => 0x50 },
	'timeshot' => { 427 => 'TimeShot' },
	'timesignature' => { 461 => 'timeSignature' },
	'timesincepoweron' => { 293 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 269 => 0x8, 283 => 'TimeStamp', 293 => 0xaf, 426 => 'Timestamp', 432 => 'Timestamp', 445 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 73 => 0x1, 238 => 0x0, 357 => 0xa },
	'timezonecity' => { 73 => 0x2 },
	'timezonecode' => { 94 => 0x1 },
	'timezoneinfo' => { 94 => 0x2 },
	'timezoneoffset' => { 113 => 0x882a },
	'tint' => { 437 => 'Tint' },
	'title' => { 144 => 'Title', 279 => 'Title', 283 => 'Title', 293 => 0x65, 344 => 'Title', 438 => 'title', 448 => 'Title', 459 => 'Title' },
	'tonecomp' => { 207 => 0x81 },
	'tonecurve' => { 70 => 0x1, 328 => 0x402, 437 => 'ToneCurve' },
	'tonecurveactive' => { 102 => 0x110 },
	'tonecurveadobergb' => { 361 => 0xa043 },
	'tonecurveadobergbdefault' => { 361 => 0xa041 },
	'tonecurveblue' => { 437 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 417 => 0x9003 },
	'tonecurvebluey' => { 417 => 0x9007 },
	'tonecurvebrightness' => { 97 => 0x20410 },
	'tonecurvebrightnessx' => { 417 => 0x9000 },
	'tonecurvebrightnessy' => { 417 => 0x9004 },
	'tonecurvecolorspace' => { 101 => 0x0 },
	'tonecurvecontrast' => { 97 => 0x20411 },
	'tonecurvefilename' => { 127 => 0x1391 },
	'tonecurvegreen' => { 437 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 417 => 0x9002 },
	'tonecurvegreeny' => { 417 => 0x9006 },
	'tonecurveinputrange' => { 101 => 0x3 },
	'tonecurveinterpolation' => { 102 => 0x159 },
	'tonecurvemode' => { 102 => 0x113 },
	'tonecurvename' => { 437 => 'ToneCurveName' },
	'tonecurvename2012' => { 437 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 97 => '0x20400.1' },
	'tonecurveoutputrange' => { 101 => 0x5 },
	'tonecurveproperty' => { 102 => 0x3c },
	'tonecurvepv2012' => { 437 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 437 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 437 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 437 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 437 => 'ToneCurveRed' },
	'tonecurveredx' => { 417 => 0x9001 },
	'tonecurveredy' => { 417 => 0x9005 },
	'tonecurves' => { 328 => 0x403 },
	'tonecurveshape' => { 101 => 0x1 },
	'tonecurvesrgb' => { 361 => 0xa042 },
	'tonecurvesrgbdefault' => { 361 => 0xa040 },
	'tonecurvex' => { 101 => 0xa },
	'tonecurvey' => { 101 => 0xb },
	'tonelevel' => { 270 => 0x52e },
	'tonemapstrength' => { 437 => 'ToneMapStrength' },
	'toningeffect' => { 54 => 0xf, 207 => 0xb3, 209 => 0x38, 210 => 0x40, 354 => 0x1015 },
	'toningeffectauto' => { 67 => 0xa4 },
	'toningeffectfaithful' => { 66 => 0x74, 67 => 0x74 },
	'toningeffectlandscape' => { 66 => 0x44, 67 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 66 => 0x8c, 67 => 0x8c },
	'toningeffectneutral' => { 66 => 0x5c, 67 => 0x5c },
	'toningeffectportrait' => { 66 => 0x2c, 67 => 0x2c },
	'toningeffectstandard' => { 66 => 0x14, 67 => 0x14 },
	'toningeffectuserdef1' => { 66 => 0xa4, 67 => 0xbc },
	'toningeffectuserdef2' => { 66 => 0xbc, 67 => 0xd4 },
	'toningeffectuserdef3' => { 66 => 0xd4, 67 => 0xec },
	'toningsaturation' => { 209 => 0x39, 210 => 0x41 },
	'totalzoom' => { 129 => 0x62 },
	'touchae' => { 293 => 0xab },
	'trackcreatedate' => { 348 => 0x1 },
	'trackmodifydate' => { 348 => 0x2 },
	'tracknumber' => { 461 => 'trackNumber' },
	'tracks' => { 461 => 'Tracks' },
	'tracksframerate' => { 461 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 461 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 461 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 461 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 461 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 461 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 461 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 461 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 461 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 461 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 461 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 461 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 461 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 461 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 461 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 461 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 461 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 151 => 'zmie' },
	'transcript' => { 447 => 'Transcript' },
	'transcriptlink' => { 447 => 'TranscriptLink' },
	'transcriptlinklink' => { 447 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 447 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 113 => 0x12d, 457 => 'TransferFunction' },
	'transform' => { 293 => [0x8012,0x59] },
	'transmissionreference' => { 449 => 'TransmissionReference' },
	'trapped' => { 279 => 'Trapped', 448 => 'Trapped' },
	'trashbuttonfunction' => { 78 => 0x710 },
	'travelday' => { 293 => 0x36 },
	'triggermode' => { 349 => 0x6, 350 => 0x34 },
	'tstop' => { 113 => 0xc772 },
	'ttl_da_adown' => { 316 => 0x5 },
	'ttl_da_aup' => { 316 => 0x4 },
	'ttl_da_bdown' => { 316 => 0x7 },
	'ttl_da_bup' => { 316 => 0x6 },
	'tungstenawb' => { 306 => 0x1 },
	'tvexposuretimesetting' => { 309 => 0x12 },
	'type' => { 438 => 'type', 456 => 'type' },
	'typestatus' => { 112 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 113 => 0xc614 },
	'uniquedocumentid' => { 121 => 0xbb },
	'uniqueobjectname' => { 122 => 0x64 },
	'units' => { 422 => 'Units' },
	'unknownblock' => { 328 => 0x405 },
	'unknownblock1' => { 274 => 0x635 },
	'unknownblock2' => { 274 => 0x636 },
	'unknownblock3' => { 274 => 0x1103 },
	'unknownblock4' => { 274 => 0x1104 },
	'unknowncontrast' => { 103 => 0x45 },
	'unknowndate' => { 337 => 0x212 },
	'unknownev' => { 127 => 0x1 },
	'unknownlinear' => { 103 => 0x46 },
	'unknownnumber' => { 91 => 0x180b },
	'unknownoutputhighlightpoint' => { 103 => 0x4a },
	'unknownoutputshadowpoint' => { 103 => 0x4b },
	'unknownrawhighlight' => { 103 => 0x7b },
	'unknownrawhighlightpoint' => { 103 => 0x48 },
	'unknownrawshadow' => { 103 => 0x84 },
	'unknownrawshadowpoint' => { 103 => 0x49 },
	'unknownsharpness' => { 103 => 0x47 },
	'unknowntemperature' => { 115 => 0x4 },
	'unsharp1color' => { 251 => 0x13 },
	'unsharp1halowidth' => { 251 => 0x19 },
	'unsharp1intensity' => { 251 => 0x17 },
	'unsharp1threshold' => { 251 => 0x1b },
	'unsharp2color' => { 251 => 0x2e },
	'unsharp2halowidth' => { 251 => 0x34 },
	'unsharp2intensity' => { 251 => 0x32 },
	'unsharp2threshold' => { 251 => 0x36 },
	'unsharp3color' => { 251 => 0x49 },
	'unsharp3halowidth' => { 251 => 0x4f },
	'unsharp3intensity' => { 251 => 0x4d },
	'unsharp3threshold' => { 251 => 0x51 },
	'unsharp4color' => { 251 => 0x64 },
	'unsharp4halowidth' => { 251 => 0x6a },
	'unsharp4intensity' => { 251 => 0x68 },
	'unsharp4threshold' => { 251 => 0x6c },
	'unsharpcount' => { 251 => 0x0 },
	'unsharpmask' => { 103 => 0x90, 246 => 0x76a43200 },
	'unsharpmaskfineness' => { 97 => 0x20309 },
	'unsharpmaskstrength' => { 97 => 0x20308 },
	'unsharpmaskthreshold' => { 97 => 0x2030a },
	'uprightcentermode' => { 437 => 'UprightCenterMode' },
	'uprightcenternormx' => { 437 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 437 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 437 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 437 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 437 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 437 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 437 => 'UprightPreview' },
	'uprighttransform_0' => { 437 => 'UprightTransform_0' },
	'uprighttransform_1' => { 437 => 'UprightTransform_1' },
	'uprighttransform_2' => { 437 => 'UprightTransform_2' },
	'uprighttransform_3' => { 437 => 'UprightTransform_3' },
	'uprighttransform_4' => { 437 => 'UprightTransform_4' },
	'uprighttransform_5' => { 437 => 'UprightTransform_5' },
	'uprighttransformcount' => { 437 => 'UprightTransformCount' },
	'uprightversion' => { 437 => 'UprightVersion' },
	'urgency' => { 121 => 0xa, 449 => 'Urgency' },
	'url' => { 144 => 'URL', 283 => 'URL', 342 => 0x40b, 451 => 'url' },
	'url_list' => { 342 => 0x41e },
	'urla-platform' => { 451 => [\'url','urlA-platform'] },
	'urlurl' => { 451 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 78 => 0x10a },
	'usableshootingmodes' => { 78 => 0x109 },
	'usage' => { 452 => 'usage' },
	'usageterms' => { 465 => 'UsageTerms' },
	'useguidelines' => { 434 => 'useGuidelines' },
	'usepanoramaviewer' => { 425 => 'UsePanoramaViewer' },
	'usercomment' => { 91 => 0x805, 113 => 0x9286, 441 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 66 => 0xd8, 67 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 66 => 0xda, 67 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 66 => 0xdc, 67 => 0xf4 },
	'userfields' => { 429 => 'UserFields' },
	'userlabel' => { 349 => 0x2b, 350 => 0x5a },
	'userprofile' => { 288 => 0x302, 295 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 77 => 0x7, 78 => 0x501 },
	'uspsnumber' => { 451 => 'uspsNumber' },
	'utmeasting' => { 155 => 'Easting' },
	'utmmapdatum' => { 155 => 'Datum' },
	'utmnorthing' => { 155 => 'Northing' },
	'utmzone' => { 155 => 'Zone' },
	'uv-irfiltercorrection' => { 288 => 0x325 },
	'validbits' => { 274 => 0x611, 275 => 0x102c },
	'validpixeldepth' => { 278 => 0x611 },
	'variablelowpassfilter' => { 384 => 0x2028 },
	'variousmodes' => { 129 => 0x26 },
	'variousmodes2' => { 129 => 0x3a },
	'variprogram' => { 207 => 0xab },
	'version' => { 118 => 0x0, 344 => 'Version', 437 => 'Version' },
	'versioncreatedate' => { 417 => 0xd100 },
	'versionid' => { 462 => 'VersionID' },
	'versionidentifier' => { 451 => 'versionIdentifier' },
	'versionmodifydate' => { 417 => 0xd101 },
	'versions' => { 462 => 'Versions' },
	'versionscomments' => { 462 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 462 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 462 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 462 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 462 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 462 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 462 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 462 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 462 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 462 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 462 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 253 => '3.2', 254 => '47.2', 256 => '79.1' },
	'verticalfuncbutton' => { 254 => '42.2', 256 => '67.1' },
	'verticalfuncbuttonplusdials' => { 254 => '43.1' },
	'verticalfuncplusdials' => { 256 => '68.1' },
	'verticalmultiselector' => { 254 => '42.1', 256 => '66.1', 257 => '66.1', 267 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 78 => [0x510,0x51d] },
	'vibrance' => { 430 => 'Vibrance', 437 => 'Vibrance' },
	'vibrationreduction' => { 215 => [0x75,0x82,0x1ae], 223 => '586.1', 231 => '590.2', 237 => 0x4 },
	'videoalphamode' => { 461 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 461 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 461 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 461 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 447 => 'videoBitRate' },
	'videobitratemode' => { 447 => 'videoBitRateMode' },
	'videocodec' => { 63 => 0x74 },
	'videocolorspace' => { 461 => 'videoColorSpace' },
	'videocompressor' => { 461 => 'videoCompressor' },
	'videodisplayaspectratio' => { 447 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 447 => 'videoEncodingProfile' },
	'videofieldorder' => { 461 => 'videoFieldOrder' },
	'videoframerate' => { 461 => 'videoFrameRate' },
	'videoframesize' => { 461 => 'videoFrameSize' },
	'videoframesizeh' => { 461 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 461 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 461 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 461 => 'videoModDate' },
	'videopixelaspectratio' => { 461 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 461 => 'videoPixelDepth' },
	'videoquality' => { 107 => 0x4003 },
	'videoshottype' => { 447 => 'VideoShotType' },
	'videoshottypeidentifier' => { 447 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 447 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 447 => 'videoStreamsCount' },
	'viewfinder' => { 337 => 0x455 },
	'viewfinderdisplay' => { 253 => '12.4', 254 => '6.3' },
	'viewfinderwarning' => { 253 => '13.4', 263 => '3.5', 264 => '6.2', 268 => '4.4' },
	'viewfinderwarnings' => { 78 => 0x40a },
	'viewinfoduringexposure' => { 78 => 0x407 },
	'viewingmode' => { 374 => 0x2f, 389 => 0x18 },
	'viewingmode2' => { 374 => [0x85,0x285] },
	'viewpoint' => { 450 => 'viewpoint' },
	'vignetteamount' => { 437 => 'VignetteAmount' },
	'vignettecontrol' => { 207 => 0x2a, 246 => 0x76a43205 },
	'vignettecontrolintensity' => { 246 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 433 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 437 => 'VignetteMidpoint' },
	'vignetting' => { 354 => 0x1011, 361 => 0xa052 },
	'vignettingcorrection' => { 113 => 0x7031, 361 => 0xa053, 384 => 0x2011 },
	'vignettingcorrparams' => { 113 => 0x7032, 412 => 0x64a, 413 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 361 => 0xa054 },
	'visualcolor' => { 447 => 'VisualColour' },
	'visualtechnique' => { 450 => 'visualTechnique' },
	'voicememo' => { 363 => 0x216 },
	'volume' => { 451 => 'volume' },
	'vr_0x66' => { 215 => 0x66 },
	'vrdoffset' => { 60 => 0xd0 },
	'vrmode' => { 237 => 0x6 },
	'waterdepth' => { 113 => 0x9403, 442 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 173 => 0x19a },
	'wb_bluelevel6500k' => { 173 => 0x18a },
	'wb_bluelevelcustom' => { 173 => 0x18e },
	'wb_bluelevelscloudy' => { 173 => 0x106 },
	'wb_bluelevelsdaylight' => { 173 => 0xea },
	'wb_bluelevelsflash' => { 173 => 0x122 },
	'wb_bluelevelsfluorescent' => { 173 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 173 => 0x254 },
	'wb_bluelevelsshade' => { 173 => 0x176 },
	'wb_bluelevelstungsten' => { 173 => 0xce },
	'wb_gbrglevels' => { 173 => 0xae, 176 => 0x4 },
	'wb_glevel' => { 274 => 0x11f },
	'wb_glevel3000k' => { 274 => 0x113 },
	'wb_glevel3300k' => { 274 => 0x114 },
	'wb_glevel3600k' => { 274 => 0x115 },
	'wb_glevel3900k' => { 274 => 0x116 },
	'wb_glevel4000k' => { 274 => 0x117 },
	'wb_glevel4300k' => { 274 => 0x118 },
	'wb_glevel4500k' => { 274 => 0x119 },
	'wb_glevel4800k' => { 274 => 0x11a },
	'wb_glevel5300k' => { 274 => 0x11b },
	'wb_glevel6000k' => { 274 => 0x11c },
	'wb_glevel6600k' => { 274 => 0x11d },
	'wb_glevel7500k' => { 274 => 0x11e },
	'wb_grbglevels' => { 186 => 0x0 },
	'wb_rbgglevels' => { 183 => 0x0 },
	'wb_rblevels' => { 187 => 0x270, 207 => 0xc, 274 => 0x100 },
	'wb_rblevels1' => { 299 => 0x2 },
	'wb_rblevels2' => { 299 => 0x5 },
	'wb_rblevels3' => { 299 => 0x8 },
	'wb_rblevels3000k' => { 274 => 0x102 },
	'wb_rblevels3300k' => { 274 => 0x103 },
	'wb_rblevels3500k' => { 173 => 0x430 },
	'wb_rblevels3600k' => { 274 => 0x104 },
	'wb_rblevels3900k' => { 274 => 0x105 },
	'wb_rblevels4' => { 299 => 0xb },
	'wb_rblevels4000k' => { 274 => 0x106 },
	'wb_rblevels4300k' => { 274 => 0x107 },
	'wb_rblevels4500k' => { 274 => 0x108 },
	'wb_rblevels4800k' => { 274 => 0x109 },
	'wb_rblevels5' => { 299 => 0xe },
	'wb_rblevels5300k' => { 274 => 0x10a },
	'wb_rblevels6' => { 299 => 0x11 },
	'wb_rblevels6000k' => { 274 => 0x10b },
	'wb_rblevels6500k' => { 173 => 0x420 },
	'wb_rblevels6600k' => { 274 => 0x10c },
	'wb_rblevels7' => { 299 => 0x14 },
	'wb_rblevels7500k' => { 274 => 0x10d },
	'wb_rblevelsauto' => { 187 => 0x272, 278 => 0x110 },
	'wb_rblevelscloudy' => { 173 => 0x3f0, 175 => 0x10, 187 => 0x296, 278 => 0x121 },
	'wb_rblevelscoolwhitef' => { 173 => 0x308, 175 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 278 => 0x132 },
	'wb_rblevelscustom' => { 173 => 0x424 },
	'wb_rblevelscwb1' => { 274 => 0x10e },
	'wb_rblevelscwb2' => { 274 => 0x10f },
	'wb_rblevelscwb3' => { 274 => 0x110 },
	'wb_rblevelscwb4' => { 274 => 0x111 },
	'wb_rblevelsdaylight' => { 173 => [0x3ec,0x528], 175 => 0xc, 187 => 0x274 },
	'wb_rblevelsdaylightf' => { 175 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 278 => 0x130 },
	'wb_rblevelsdaywhitef' => { 175 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 278 => 0x131 },
	'wb_rblevelseveningsunlight' => { 278 => 0x124 },
	'wb_rblevelsfineweather' => { 278 => 0x122 },
	'wb_rblevelsflash' => { 173 => [0x3f4,0x304], 175 => 0x18, 187 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 187 => 0x290 },
	'wb_rblevelsincandescent' => { 187 => 0x282 },
	'wb_rblevelsshade' => { 173 => 0x418, 175 => 0x20, 187 => 0x2b2, 278 => 0x120 },
	'wb_rblevelstungsten' => { 173 => 0x3e8, 175 => 0x8, 278 => 0x123 },
	'wb_rblevelsunknown' => { 175 => 0x1c },
	'wb_rblevelsused' => { 278 => 0x100 },
	'wb_rblevelswhitef' => { 175 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 278 => 0x133 },
	'wb_redlevel3500k' => { 173 => 0x198 },
	'wb_redlevel6500k' => { 173 => 0x188 },
	'wb_redlevelcustom' => { 173 => 0x18c },
	'wb_redlevelscloudy' => { 173 => 0xf8 },
	'wb_redlevelsdaylight' => { 173 => 0xdc },
	'wb_redlevelsflash' => { 173 => 0x114 },
	'wb_redlevelsfluorescent' => { 173 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 173 => 0x1be },
	'wb_redlevelsshade' => { 173 => 0x168 },
	'wb_redlevelstungsten' => { 173 => 0xc0 },
	'wb_rgbglevels' => { 185 => 0x0 },
	'wb_rgblevels' => { 173 => [0x546,0x96], 289 => 0xd, 290 => 0x413, 295 => 0x3036, 337 => 0x107, 392 => 0x117c, 393 => 0x1180, 394 => 0x115c, 395 => 0x11d8, 396 => 0x11b4, 397 => 0x106c, 398 => 0x264, 399 => 0x264, 400 => 0x252 },
	'wb_rgblevels1' => { 300 => 0x2 },
	'wb_rgblevels2' => { 300 => 0x6 },
	'wb_rgblevels3' => { 300 => 0xa },
	'wb_rgblevels4' => { 300 => 0xe },
	'wb_rgblevels5' => { 300 => 0x12 },
	'wb_rgblevels6' => { 300 => 0x16 },
	'wb_rgblevels7' => { 300 => 0x1a },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 176 => 0x4, 184 => 0x0, 188 => 0x13e8, 189 => 0x38 },
	'wb_rggblevelsasshot' => { 37 => 0x0, 38 => 0x0, 39 => 0x19, 40 => 0x22, 41 => 0x3f, 44 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x47 },
	'wb_rggblevelsauto' => { 34 => 0x1, 37 => 0x5, 38 => 0x8, 39 => 0x1e, 40 => 0x18, 41 => 0x44, 44 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x4c, 188 => 0x1478, 189 => 0x114, 361 => 0xa022 },
	'wb_rggblevelsblack' => { 361 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 37 => 0x1e, 38 => 0x30, 39 => 0x2d, 40 => 0x31, 41 => 0x58, 44 => 0x71, 45 => 0x8a, 46 => 0x8f, 47 => 0x92, 188 => 0x1408, 189 => 0x60, 328 => 0x20f, 336 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 41 => 0x80, 188 => 0x1468, 189 => 0x100 },
	'wb_rggblevelscustom1' => { 39 => 0x41 },
	'wb_rggblevelscustom2' => { 39 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 37 => 0x14, 38 => 0x20, 39 => 0x23, 40 => 0x27, 41 => 0x4e, 44 => 0x67, 45 => 0x80, 46 => 0x85, 47 => 0x88, 188 => 0x13f8, 189 => 0x4c, 328 => 0x20d, 336 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 37 => 0x32, 38 => 0x50, 39 => 0x3c, 40 => 0x45, 41 => 0x6c, 44 => 0x85, 45 => 0x9e, 46 => 0xa3, 47 => 0xa6, 188 => 0x1448, 328 => 0x214, 336 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 37 => 0x28, 38 => 0x40, 39 => 0x37, 40 => 0x3b, 41 => 0x62, 44 => 0x7b, 45 => 0x94, 46 => 0x99, 47 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 189 => 0xc4, 328 => 0x211, 336 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 336 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 189 => 0xb0, 328 => 0x212, 336 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 188 => 0x1438, 189 => 0x9c, 328 => 0x213, 336 => 0x38 },
	'wb_rggblevelshtmercury' => { 189 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 361 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 361 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 37 => 0x2d, 38 => 0x48, 40 => 0x40, 41 => 0x67, 44 => 0x80, 45 => 0x99, 46 => 0x9e, 47 => 0xa1 },
	'wb_rggblevelsmeasured' => { 37 => 0xa, 38 => 0x10, 41 => 0x49, 44 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x51 },
	'wb_rggblevelspc1' => { 40 => 0x90, 41 => 0x71 },
	'wb_rggblevelspc2' => { 40 => 0x95, 41 => 0x76 },
	'wb_rggblevelspc3' => { 40 => 0x9a, 41 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 37 => 0x19, 38 => 0x28, 39 => 0x28, 40 => 0x2c, 41 => 0x53, 44 => 0x6c, 45 => 0x85, 46 => 0x8a, 47 => 0x8d, 189 => 0x74, 328 => 0x20e, 336 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 37 => 0x23, 38 => 0x38, 39 => 0x32, 40 => 0x36, 41 => 0x5d, 44 => 0x76, 45 => 0x8f, 46 => 0x94, 47 => 0x97, 188 => 0x1428, 189 => 0x88, 328 => 0x210, 336 => 0x1d },
	'wb_rggblevelsuncorrected' => { 361 => 0xa021 },
	'wb_rggblevelsunknown' => { 37 => 0xf, 38 => 0x18, 40 => 0x1d, 44 => 0x4e, 45 => 0x4e, 46 => 0x4e, 47 => 0x56, 336 => 0x53 },
	'wb_rggblevelsunknown10' => { 37 => 0x5f, 38 => 0x98, 40 => 0x72, 44 => 0x9e, 45 => 0x7b, 46 => 0x7b, 47 => 0x83 },
	'wb_rggblevelsunknown11' => { 37 => 0x64, 38 => 0xa0, 40 => 0x77, 44 => 0xa3, 45 => 0xa3, 46 => 0x80, 47 => 0xab },
	'wb_rggblevelsunknown12' => { 37 => 0x69, 38 => 0xa8, 40 => 0x7c, 44 => 0xa8, 45 => 0xa8, 46 => 0xa8, 47 => 0xb0 },
	'wb_rggblevelsunknown13' => { 37 => 0x6e, 38 => 0xb0, 40 => 0x81, 44 => 0xad, 45 => 0xad, 46 => 0xad, 47 => 0xb5 },
	'wb_rggblevelsunknown14' => { 40 => 0x86, 44 => 0xb2, 45 => 0xb2, 46 => 0xb2, 47 => 0xba },
	'wb_rggblevelsunknown15' => { 40 => 0x8b, 44 => 0xb7, 45 => 0xb7, 46 => 0xb7, 47 => 0xbf },
	'wb_rggblevelsunknown16' => { 40 => 0x9f, 45 => 0xbc, 46 => 0xbc, 47 => 0xc4 },
	'wb_rggblevelsunknown17' => { 45 => 0xc1, 46 => 0xc1, 47 => 0xc9 },
	'wb_rggblevelsunknown18' => { 45 => 0xc6, 46 => 0xc6, 47 => 0xce },
	'wb_rggblevelsunknown19' => { 45 => 0xcb, 46 => 0xcb, 47 => 0xd3 },
	'wb_rggblevelsunknown2' => { 37 => 0x37, 38 => 0x58, 40 => 0x4a, 44 => 0x53, 45 => 0x53, 46 => 0x53, 47 => 0x5b },
	'wb_rggblevelsunknown20' => { 45 => 0xd0, 46 => 0xd0, 47 => 0xd8 },
	'wb_rggblevelsunknown21' => { 46 => 0xd5, 47 => 0xdd },
	'wb_rggblevelsunknown22' => { 46 => 0xda, 47 => 0xe2 },
	'wb_rggblevelsunknown23' => { 46 => 0xdf, 47 => 0xe7 },
	'wb_rggblevelsunknown24' => { 46 => 0xe4, 47 => 0xec },
	'wb_rggblevelsunknown25' => { 46 => 0xe9, 47 => 0xf1 },
	'wb_rggblevelsunknown26' => { 46 => 0xee, 47 => 0xf6 },
	'wb_rggblevelsunknown27' => { 46 => 0xf3, 47 => 0xfb },
	'wb_rggblevelsunknown28' => { 46 => 0xf8, 47 => 0x100 },
	'wb_rggblevelsunknown29' => { 46 => 0xfd, 47 => 0x105 },
	'wb_rggblevelsunknown3' => { 37 => 0x3c, 38 => 0x60, 40 => 0x4f, 44 => 0x58, 45 => 0x58, 46 => 0x58, 47 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x102 },
	'wb_rggblevelsunknown4' => { 37 => 0x41, 38 => 0x68, 40 => 0x54, 44 => 0x5d, 45 => 0x5d, 46 => 0x5d, 47 => 0x65 },
	'wb_rggblevelsunknown5' => { 37 => 0x46, 38 => 0x70, 40 => 0x59, 44 => 0x62, 45 => 0x62, 46 => 0x62, 47 => 0x6a },
	'wb_rggblevelsunknown6' => { 37 => 0x4b, 38 => 0x78, 40 => 0x5e, 44 => 0x8a, 45 => 0x67, 46 => 0x67, 47 => 0x6f },
	'wb_rggblevelsunknown7' => { 37 => 0x50, 38 => 0x80, 40 => 0x63, 44 => 0x8f, 45 => 0x6c, 46 => 0x6c, 47 => 0x74 },
	'wb_rggblevelsunknown8' => { 37 => 0x55, 38 => 0x88, 40 => 0x68, 44 => 0x94, 45 => 0x71, 46 => 0x71, 47 => 0x79 },
	'wb_rggblevelsunknown9' => { 37 => 0x5a, 38 => 0x90, 40 => 0x6d, 44 => 0x99, 45 => 0x76, 46 => 0x76, 47 => 0x7e },
	'wb_rggblevelsuserselected' => { 336 => 0x5c },
	'wbadjblueamber' => { 97 => 0x20106 },
	'wbadjbluebalance' => { 252 => 0x8 },
	'wbadjcolortemp' => { 97 => 0x20102, 102 => 0x1a },
	'wbadjlighting' => { 252 => 0x14 },
	'wbadjmagentagreen' => { 97 => 0x20105 },
	'wbadjmode' => { 252 => 0x10 },
	'wbadjredbalance' => { 252 => 0x0 },
	'wbadjrggblevels' => { 97 => 0x20125, 102 => 0x6 },
	'wbadjtemperature' => { 252 => 0x18 },
	'wbadjtint' => { 252 => 0x25 },
	'wbbluelevel' => { 288 => 0x324, 293 => 0x8006, 298 => 0x26 },
	'wbbracketingsteps' => { 224 => 0x174d, 225 => 0x87c, 233 => 0x1757 },
	'wbbracketmode' => { 54 => 0x9 },
	'wbbracketshotnumber' => { 173 => 0x2b, 354 => 0x101a },
	'wbbracketvalueab' => { 54 => 0xc },
	'wbbracketvaluegm' => { 54 => 0xd },
	'wbfinetuneactive' => { 102 => 0x24 },
	'wbfinetunesaturation' => { 102 => 0x28 },
	'wbfinetunetone' => { 102 => 0x2c },
	'wbgreenlevel' => { 288 => 0x323, 293 => 0x8005, 298 => 0x25 },
	'wbmediaimagesizesetting' => { 78 => 0x708 },
	'wbmode' => { 175 => 0x4, 275 => 0x1015 },
	'wbredlevel' => { 288 => 0x322, 293 => 0x8004, 298 => 0x24 },
	'wbscale' => { 176 => 0x0 },
	'wbshiftab' => { 70 => 0xc, 293 => 0x46, 310 => 0x10 },
	'wbshiftab_gm' => { 384 => 0x2014 },
	'wbshiftab_gm_precise' => { 384 => 0x2026 },
	'wbshiftgm' => { 70 => 0xd, 293 => 0x47, 310 => 0x11 },
	'wbtype1' => { 299 => 0x1, 300 => 0x1 },
	'wbtype2' => { 299 => 0x4, 300 => 0x5 },
	'wbtype3' => { 299 => 0x7, 300 => 0x9 },
	'wbtype4' => { 299 => 0xa, 300 => 0xd },
	'wbtype5' => { 299 => 0xd, 300 => 0x11 },
	'wbtype6' => { 299 => 0x10, 300 => 0x15 },
	'wbtype7' => { 299 => 0x13, 300 => 0x19 },
	'webstatement' => { 465 => 'WebStatement' },
	'what' => { 437 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 70 => 0x8, 72 => 0x7, 106 => 0x7, 107 => [0x19,0x2012], 113 => [0xa403,0xfe4e], 118 => 0x1002, 127 => 0x3fc, 128 => 0xfa0d, 129 => 0x40, 167 => 0x3, 168 => 0xe, 169 => 0x4, 170 => 0xb, 172 => 0x115, 207 => 0x5, 236 => 0x7, 288 => 0x304, 293 => 0x3, 295 => 0x3033, 328 => 0x19, 335 => 0x7, 353 => 0x26, 354 => 0x1003, 364 => [0x3c,0x7,0x58], 372 => 0xf, 373 => 0xe, 384 => [0x115,0xb054], 437 => 'WhiteBalance', 441 => 'WhiteBalance' },
	'whitebalance0' => { 163 => 'WhiteBalance0' },
	'whitebalance1' => { 163 => 'WhiteBalance1' },
	'whitebalance2' => { 163 => 'WhiteBalance2', 270 => 0x500 },
	'whitebalanceadj' => { 97 => 0x20101, 102 => 0x18, 246 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 306 => 0x0 },
	'whitebalancebias' => { 107 => 0x2011, 275 => 0x304, 293 => 0x23 },
	'whitebalanceblue' => { 70 => 0x7 },
	'whitebalancebracket' => { 270 => 0x502, 275 => 0x303 },
	'whitebalancebracketing' => { 170 => 0x22, 173 => 0x2c, 383 => 0x2c },
	'whitebalancecomp' => { 278 => 0x1001 },
	'whitebalancefinetune' => { 118 => 0x100a, 170 => 0x38, 172 => 0x112, 207 => 0xb, 354 => 0x1004, 372 => 0x6, 373 => 0x5, 384 => 0x112 },
	'whitebalancemode' => { 328 => 0x1a },
	'whitebalancered' => { 70 => 0x6 },
	'whitebalanceset' => { 309 => 0xa },
	'whitebalancesetting' => { 170 => 0x23, 372 => 0x5, 373 => 0x4, 374 => 0x16, 389 => 0xd },
	'whitebalancesetup' => { 361 => 0x41 },
	'whitebalancetemperature' => { 270 => 0x501 },
	'whiteboard' => { 275 => 0x301 },
	'whitelevel' => { 113 => 0xc61d, 328 => 0x7e },
	'whitepoint' => { 113 => 0x13e, 328 => 0x201, 457 => 'WhitePoint' },
	'whites2012' => { 437 => 'Whites2012' },
	'wideadapter' => { 354 => 0x1017 },
	'widefocuszone' => { 167 => 0x2f },
	'widerange' => { 363 => 0x20f },
	'windowsatom' => { 436 => 'windowsAtom' },
	'windowsatomextension' => { 436 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 436 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 436 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 451 => 'wordCount' },
	'workcolorspace' => { 97 => 0x10200, 102 => 0x270 },
	'workflowtag' => { 447 => 'WorkflowTag' },
	'workflowtagcvid' => { 447 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 447 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 447 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 447 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 443 => 'WorkToDo' },
	'worldtimelocation' => { 293 => 0x3a, 328 => 0x22, 334 => '0.1' },
	'writer-editor' => { 121 => 0x7a },
	'x3filllight' => { 364 => 0x12 },
	'xattrquarantine' => { 161 => 'com.apple.quarantine' },
	'xml' => { 125 => 'xml ' },
	'xmp' => { 100 => 0xffff00f6, 114 => 'XMP' },
	'xmptoolkit' => { 458 => 'xmptk' },
	'xpauthor' => { 113 => 0x9c9d },
	'xpcomment' => { 113 => 0x9c9c },
	'xpkeywords' => { 113 => 0x9c9e },
	'xposition' => { 113 => 0x11e },
	'xpsubject' => { 113 => 0x9c9f },
	'xptitle' => { 113 => 0x9c9b },
	'xresolution' => { 113 => 0x11a, 124 => 0x3, 343 => 0x0, 457 => 'XResolution' },
	'xyresolution' => { 117 => 0x3 },
	'yaw' => { 109 => 0x7 },
	'yawangle' => { 224 => 0x3513, 225 => 0x2c2c, 233 => 0x36fc, 359 => 0x0 },
	'ycbcrcoefficients' => { 113 => 0x211, 457 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 113 => 0x213, 457 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 113 => 0x212, 457 => 'YCbCrSubSampling' },
	'yearcreated' => { 129 => 0x10, 138 => 0xc },
	'yellowhsl' => { 97 => 0x20912 },
	'yield' => { 453 => 'yield' },
	'yposition' => { 113 => 0x11f },
	'yresolution' => { 113 => 0x11b, 124 => 0x5, 343 => 0x4, 457 => 'YResolution' },
	'zonematching' => { 172 => 0x10a, 175 => [0x3a,0x4a], 384 => 0xb024 },
	'zonematchingmode' => { 170 => 0x14 },
	'zonematchingon' => { 169 => 0x75 },
	'zonematchingvalue' => { 372 => 0x1f },
	'zoomedpreviewlength' => { 275 => 0xf05 },
	'zoomedpreviewsize' => { 275 => 0xf06 },
	'zoomedpreviewstart' => { 275 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 273 => 0x300, 275 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemailflagged' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketinginfooffset' => 1,
	'bracketingoffset' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'camm6' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'croparea' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'cx' => 1,
	'cy' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaytime' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotinfo' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderid' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpscoordinates' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstrackraw' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hiddenslides' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'levelmeter' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'listtype' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'moviefragment' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rads' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2018, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
