#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.13';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 98 => 0x69 },
	'about' => { 420 => 'about' },
	'aboutcvterm' => { 411 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 411 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 411 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 411 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 411 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 426 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 73 => 0x518 },
	'accelerometer' => { 331 => 0x3 },
	'accelerometerx' => { 270 => 0x8d },
	'accelerometery' => { 270 => 0x8e },
	'accelerometerz' => { 270 => 0x8c },
	'accessoryserialnumber' => { 270 => 0x54 },
	'accessorytype' => { 270 => 0x53 },
	'acedemicfield' => { 416 => 'acedemicField' },
	'actionadvised' => { 114 => 0x2a },
	'activearea' => { 106 => 0xc68d },
	'actived-lighting' => { 194 => 0x22, 228 => 0x24 },
	'actived-lightingmode' => { 228 => 0x25 },
	'adaptervoltage' => { 120 => 0x407 },
	'addaspectratioinfo' => { 73 => 0x80e },
	'additionalmodelinformation' => { 411 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 73 => 0x80f, 74 => 0x11, 75 => 0x13, 78 => 0x14 },
	'address' => { 141 => 'Address' },
	'adjustmentmode' => { 337 => 0x15 },
	'adobe' => { 107 => 'Adobe' },
	'adultcontentwarning' => { 414 => 'AdultContentWarning', 419 => 'adultContentWarning' },
	'advancedfilter' => { 111 => 0x1201 },
	'advancedraw' => { 230 => 0x76a43203 },
	'advancedscenetype' => { 270 => 0x3d },
	'advisory' => { 424 => 'Advisory' },
	'ae_iso' => { 277 => 0x2, 278 => 0x4, 279 => 0x12 },
	'aeaperture' => { 277 => 0x1, 278 => 0x3, 279 => 0x11 },
	'aeaperturesteps' => { 277 => 0x8, 278 => 0xb },
	'aebautocancel' => { 73 => 0x104 },
	'aebbracketvalue' => { 67 => 0x11 },
	'aebsequence' => { 73 => 0x105 },
	'aebsequenceautocancel' => { 71 => 0x9, 72 => 0x9, 74 => 0x8, 75 => 0x9, 78 => 0x9, 79 => 0x7 },
	'aebshotcount' => { 73 => 0x106 },
	'aebxv' => { 277 => 0x4, 278 => 0x6 },
	'aeerror' => { 278 => 0x8 },
	'aeexposuretime' => { 277 => 0x0, 278 => 0x2, 279 => 0x10 },
	'aelbutton' => { 161 => 0x45 },
	'aelexposureindicator' => { 161 => 0x51 },
	'aelock' => { 161 => 0x5b, 239 => '4.2', 245 => '4.2', 250 => 0x201, 303 => 0x48, 345 => 0x40, 346 => 0x40, 347 => [0x86,0x286] },
	'aelockbutton' => { 237 => '16.1', 239 => '4.1', 240 => '15.1', 241 => '16.1', 242 => '16.1', 243 => '30.1', 244 => '16.1', 245 => '4.1', 247 => '17.1', 248 => '17.1' },
	'aelockbuttonplusdials' => { 237 => '16.2', 243 => '32.1', 247 => '44.1' },
	'aelockformb-d80' => { 248 => '3.1' },
	'aemaxaperture' => { 277 => 0x9, 278 => 0x10, 279 => 0x1c },
	'aemaxaperture2' => { 277 => 0xa, 278 => 0x11, 279 => 0x1d },
	'aemeteringmode' => { 277 => 0xc },
	'aemeteringmode2' => { 277 => '13.1' },
	'aemeteringsegments' => { 164 => 0x628, 303 => 0x209 },
	'aemicroadjustment' => { 73 => 0x110 },
	'aeminaperture' => { 277 => 0xb, 278 => 0x12, 279 => 0x1e },
	'aeminexposuretime' => { 277 => 0x5, 278 => 0x13, 279 => 0x1f },
	'aeprogrammode' => { 277 => 0x6 },
	'aeprojectlink' => { 400 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 400 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 400 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 400 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 400 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 400 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 31 => 0x21 },
	'aewhitebalance' => { 277 => 0xd },
	'aexv' => { 277 => 0x3, 278 => 0x5 },
	'af-cpriorityselection' => { 237 => '1.1', 238 => '1.1', 241 => '0.1', 242 => '0.1', 243 => '1.1', 244 => '0.1', 247 => '1.1' },
	'af-onformb-d10' => { 237 => '3.3', 243 => '3.2' },
	'af-onformb-d11' => { 244 => '2.2' },
	'af-onformb-d12' => { 247 => '50.1' },
	'af-spriorityselection' => { 237 => '1.2', 238 => '1.2', 243 => '1.2', 244 => '0.2', 247 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 237 => '2.1', 238 => '2.1', 243 => '2.1', 247 => '2.1' },
	'afadjustment' => { 303 => 0x72 },
	'afandmeteringbuttons' => { 73 => 0x701 },
	'afaperture' => { 190 => 0x5, 191 => 0x5 },
	'afareaheight' => { 170 => 0x1a },
	'afareaillumination' => { 161 => 0x4b, 245 => '15.3' },
	'afareamode' => { 157 => 0x33, 161 => 0xe, 169 => 0x0, 170 => 0x5, 270 => 0xf, 328 => 0x1205, 338 => [0xa,0x3a], 345 => 0x11, 346 => 0x10, 347 => 0x24, 357 => 0xb043, 377 => 0x17 },
	'afareamodesetting' => { 239 => '11.1', 240 => '0.1', 245 => '16.1', 248 => '2.1', 357 => 0x201c },
	'afareas' => { 250 => 0x304 },
	'afareaselectmethod' => { 73 => 0x51b },
	'afareawidth' => { 170 => 0x18 },
	'afareaxposition' => { 170 => 0x14, 328 => 0x1203 },
	'afareaxposition1' => { 328 => 0x1201 },
	'afareayposition' => { 170 => 0x16, 328 => 0x1204 },
	'afareayposition1' => { 328 => 0x1202 },
	'afassist' => { 71 => 0x5, 79 => 0x5, 161 => 0x48, 237 => '2.5', 239 => '0.2', 240 => '0.2', 241 => '1.1', 242 => '1.1', 243 => '2.4', 244 => '1.4', 245 => '0.2', 247 => '2.4', 248 => '2.3' },
	'afassistbeam' => { 73 => 0x50e, 74 => 0x4, 75 => 0x5, 76 => 0x4, 77 => 0x4, 78 => 0x5 },
	'afassistlamp' => { 270 => 0x31 },
	'afbuttonpressed' => { 347 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 280 => 0x6 },
	'afduringliveview' => { 73 => 0x511 },
	'affinea' => { 394 => 'AffineA' },
	'affineb' => { 394 => 'AffineB' },
	'affinec' => { 394 => 'AffineC' },
	'affined' => { 394 => 'AffineD' },
	'affinetune' => { 171 => 0x0, 250 => 0x306 },
	'affinetuneadj' => { 171 => 0x2, 203 => 0x2d1, 204 => 0x2dc, 250 => 0x307 },
	'affinetuneindex' => { 171 => 0x1 },
	'affinex' => { 394 => 'AffineX' },
	'affiney' => { 394 => 'AffineY' },
	'afhold' => { 280 => 0x1fd },
	'afilluminator' => { 345 => 0x29, 357 => 0xb044 },
	'afimageheight' => { 170 => 0x12 },
	'afimagewidth' => { 170 => 0x10 },
	'afintegrationtime' => { 280 => 0x7 },
	'afmicroadj' => { 338 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 342 => 0x131 },
	'afmicroadjregisteredlenses' => { 342 => '305.1' },
	'afmicroadjustment' => { 73 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 342 => 0x130 },
	'afmode' => { 102 => 0x3009, 111 => 0x1022, 157 => 0x16, 337 => 0x5 },
	'afmoderestrictions' => { 238 => '50.3', 247 => '48.3' },
	'afonaelockbuttonswitch' => { 73 => 0x702 },
	'afonbutton' => { 237 => '3.1', 238 => '47.1' },
	'afpoint' => { 31 => 0x13, 101 => 0x18, 157 => 0x15, 169 => 0x1, 253 => 0x308, 337 => 0x1f, 338 => [0x37,0x7], 342 => 0x19, 343 => 0x18, 344 => [0x18,0x20] },
	'afpointactivationarea' => { 72 => 0x11, 78 => 0x11 },
	'afpointareaexpansion' => { 73 => 0x508 },
	'afpointatshutterrelease' => { 338 => [0x39,0x9] },
	'afpointautoselection' => { 73 => 0x50b },
	'afpointbrightness' => { 73 => 0x50d, 237 => '2.4', 238 => '46.5', 247 => '2.3' },
	'afpointdisplayduringfocus' => { 73 => 0x50c },
	'afpointillumination' => { 72 => 0xa, 237 => '2.3', 238 => '46.2', 243 => '2.3', 244 => '1.3', 247 => '47.2', 248 => '2.4' },
	'afpointinfocus' => { 338 => [0x38,0x8] },
	'afpointmode' => { 284 => 0x3 },
	'afpointposition' => { 102 => 0x2021, 270 => 0x4d },
	'afpointregistration' => { 71 => 0x7 },
	'afpoints' => { 160 => 0x10 },
	'afpointselected' => { 161 => 0xd, 250 => 0x305, 303 => 0xe, 342 => 0x15, 343 => 0x14, 344 => [0x14,0x1c], 357 => 0x201e },
	'afpointselected2' => { 284 => 0x4 },
	'afpointselection' => { 72 => 0xb, 237 => '1.3', 238 => '1.3', 243 => '1.3', 247 => '1.3' },
	'afpointselectionmethod' => { 73 => 0x50f, 74 => 0xc, 75 => 0xd, 78 => 0xd },
	'afpointsetting' => { 345 => 0x12, 346 => 0x11 },
	'afpointsinfocus' => { 67 => 0xe, 169 => 0x2, 280 => 0xb, 303 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 72 => 0xd },
	'afpointsselected' => { 384 => 0x4 },
	'afpointsunknown1' => { 280 => 0x0 },
	'afpointsunknown2' => { 280 => 0x2 },
	'afpointsused' => { 170 => 0x8, 338 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 280 => 0x4 },
	'afresponse' => { 194 => 0xad },
	'afresult' => { 255 => 0x1038 },
	'afsearch' => { 250 => 0x303 },
	'afsensoractive' => { 157 => 0x1 },
	'afstatus' => { 328 => 0x1200 },
	'afstatus_00_b4' => { 341 => 0x0 },
	'afstatus_01_c4' => { 341 => 0x2 },
	'afstatus_02_d4' => { 341 => 0x4 },
	'afstatus_03_e4' => { 341 => 0x6 },
	'afstatus_04_f4' => { 341 => 0x8 },
	'afstatus_05_g4' => { 341 => 0xa },
	'afstatus_06_h4' => { 341 => 0xc },
	'afstatus_07_b3' => { 341 => 0xe },
	'afstatus_08_c3' => { 341 => 0x10 },
	'afstatus_09_d3' => { 341 => 0x12 },
	'afstatus_10_e3' => { 341 => 0x14 },
	'afstatus_11_f3' => { 341 => 0x16 },
	'afstatus_12_g3' => { 341 => 0x18 },
	'afstatus_13_h3' => { 341 => 0x1a },
	'afstatus_14_b2' => { 341 => 0x1c },
	'afstatus_15_c2' => { 341 => 0x1e },
	'afstatus_16_d2' => { 341 => 0x20 },
	'afstatus_17_e2' => { 341 => 0x22 },
	'afstatus_18_f2' => { 341 => 0x24 },
	'afstatus_19_g2' => { 341 => 0x26 },
	'afstatus_20_h2' => { 341 => 0x28 },
	'afstatus_21_c1' => { 341 => 0x2a },
	'afstatus_22_d1' => { 341 => 0x2c },
	'afstatus_23_e1' => { 341 => 0x2e },
	'afstatus_24_f1' => { 341 => 0x30 },
	'afstatus_25_g1' => { 341 => 0x32 },
	'afstatus_26_a7_vertical' => { 341 => 0x34 },
	'afstatus_27_a6_vertical' => { 341 => 0x36 },
	'afstatus_28_a5_vertical' => { 341 => 0x38 },
	'afstatus_29_c7_vertical' => { 341 => 0x3a },
	'afstatus_30_c6_vertical' => { 341 => 0x3c },
	'afstatus_31_c5_vertical' => { 341 => 0x3e },
	'afstatus_32_e7_vertical' => { 341 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 341 => 0x42 },
	'afstatus_34_e5_vertical' => { 341 => 0x44 },
	'afstatus_35_g7_vertical' => { 341 => 0x46 },
	'afstatus_36_g6_vertical' => { 341 => 0x48 },
	'afstatus_37_g5_vertical' => { 341 => 0x4a },
	'afstatus_38_i7_vertical' => { 341 => 0x4c },
	'afstatus_39_i6_vertical' => { 341 => 0x4e },
	'afstatus_40_i5_vertical' => { 341 => 0x50 },
	'afstatus_41_a7' => { 341 => 0x52 },
	'afstatus_42_b7' => { 341 => 0x54 },
	'afstatus_43_c7' => { 341 => 0x56 },
	'afstatus_44_d7' => { 341 => 0x58 },
	'afstatus_45_e7' => { 341 => 0x5a },
	'afstatus_46_f7' => { 341 => 0x5c },
	'afstatus_47_g7' => { 341 => 0x5e },
	'afstatus_48_h7' => { 341 => 0x60 },
	'afstatus_49_i7' => { 341 => 0x62 },
	'afstatus_50_a6' => { 341 => 0x64 },
	'afstatus_51_b6' => { 341 => 0x66 },
	'afstatus_52_c6' => { 341 => 0x68 },
	'afstatus_53_d6' => { 341 => 0x6a },
	'afstatus_54_e6_center' => { 341 => 0x6c },
	'afstatus_55_f6' => { 341 => 0x6e },
	'afstatus_56_g6' => { 341 => 0x70 },
	'afstatus_57_h6' => { 341 => 0x72 },
	'afstatus_58_i6' => { 341 => 0x74 },
	'afstatus_59_a5' => { 341 => 0x76 },
	'afstatus_60_b5' => { 341 => 0x78 },
	'afstatus_61_c5' => { 341 => 0x7a },
	'afstatus_62_d5' => { 341 => 0x7c },
	'afstatus_63_e5' => { 341 => 0x7e },
	'afstatus_64_f5' => { 341 => 0x80 },
	'afstatus_65_g5' => { 341 => 0x82 },
	'afstatus_66_h5' => { 341 => 0x84 },
	'afstatus_67_i5' => { 341 => 0x86 },
	'afstatus_68_c11' => { 341 => 0x88 },
	'afstatus_69_d11' => { 341 => 0x8a },
	'afstatus_70_e11' => { 341 => 0x8c },
	'afstatus_71_f11' => { 341 => 0x8e },
	'afstatus_72_g11' => { 341 => 0x90 },
	'afstatus_73_b10' => { 341 => 0x92 },
	'afstatus_74_c10' => { 341 => 0x94 },
	'afstatus_75_d10' => { 341 => 0x96 },
	'afstatus_76_e10' => { 341 => 0x98 },
	'afstatus_77_f10' => { 341 => 0x9a },
	'afstatus_78_g10' => { 341 => 0x9c },
	'afstatus_79_h10' => { 341 => 0x9e },
	'afstatus_80_b9' => { 341 => 0xa0 },
	'afstatus_81_c9' => { 341 => 0xa2 },
	'afstatus_82_d9' => { 341 => 0xa4 },
	'afstatus_83_e9' => { 341 => 0xa6 },
	'afstatus_84_f9' => { 341 => 0xa8 },
	'afstatus_85_g9' => { 341 => 0xaa },
	'afstatus_86_h9' => { 341 => 0xac },
	'afstatus_87_b8' => { 341 => 0xae },
	'afstatus_88_c8' => { 341 => 0xb0 },
	'afstatus_89_d8' => { 341 => 0xb2 },
	'afstatus_90_e8' => { 341 => 0xb4 },
	'afstatus_91_f8' => { 341 => 0xb6 },
	'afstatus_92_g8' => { 341 => 0xb8 },
	'afstatus_93_h8' => { 341 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 341 => 0xbc },
	'afstatusactivesensor' => { 157 => 0x2, 338 => [0x4,0x3b], 342 => 0x1e, 343 => 0x1b, 344 => [0x1b,0x21] },
	'afstatusbottom' => { 157 => 0x8, 342 => 0x2a, 343 => 0x21, 344 => 0x21 },
	'afstatusbottom-left' => { 157 => 0x12, 343 => 0x2b, 344 => 0x2b },
	'afstatusbottom-right' => { 157 => 0x6, 343 => 0x1f, 344 => 0x1f },
	'afstatusbottomassist-left' => { 342 => 0x28 },
	'afstatusbottomassist-right' => { 342 => 0x2c },
	'afstatusbottomhorizontal' => { 339 => 0x10, 340 => 0x1c },
	'afstatusbottomvertical' => { 339 => 0x16, 340 => 0x26 },
	'afstatuscenter-10' => { 342 => 0x34 },
	'afstatuscenter-11' => { 342 => 0x36 },
	'afstatuscenter-12' => { 342 => 0x38 },
	'afstatuscenter-14' => { 342 => 0x3c },
	'afstatuscenter-7' => { 342 => 0x2e },
	'afstatuscenter-9' => { 342 => 0x32 },
	'afstatuscenter-horizontal' => { 342 => 0x30 },
	'afstatuscenter-vertical' => { 342 => 0x3a },
	'afstatuscenterf2-8' => { 342 => 0x4c },
	'afstatuscenterhorizontal' => { 157 => 0x2f, 339 => 0xc, 340 => 0x18, 343 => 0x2f, 344 => 0x2f },
	'afstatuscentervertical' => { 157 => 0xc, 339 => 0x14, 340 => 0x22, 343 => 0x25, 344 => 0x25 },
	'afstatusfarleft' => { 339 => 0x6, 342 => 0x26 },
	'afstatusfarlefthorizontal' => { 340 => 0x4 },
	'afstatusfarleftvertical' => { 340 => 0x12 },
	'afstatusfarright' => { 339 => 0x18, 342 => 0x44 },
	'afstatusfarrighthorizontal' => { 340 => 0x2c },
	'afstatusfarrightvertical' => { 340 => 0x34 },
	'afstatusleft' => { 157 => 0x2d, 339 => 0x2, 342 => 0x22, 343 => 0x2d, 344 => 0x2d },
	'afstatuslefthorizontal' => { 340 => 0x6 },
	'afstatusleftvertical' => { 340 => 0xe },
	'afstatuslower-left' => { 339 => 0x4, 342 => 0x24 },
	'afstatuslower-lefthorizontal' => { 340 => 0xa },
	'afstatuslower-leftvertical' => { 340 => 0x10 },
	'afstatuslower-middle' => { 339 => 0x22, 340 => 0x24 },
	'afstatuslower-right' => { 339 => 0x1e, 342 => 0x4a },
	'afstatuslower-righthorizontal' => { 340 => 0x32 },
	'afstatuslower-rightvertical' => { 340 => 0x3a },
	'afstatuslowerfarleft' => { 340 => 0x8 },
	'afstatuslowerfarright' => { 340 => 0x30 },
	'afstatusmiddlehorizontal' => { 157 => 0xa, 343 => 0x23, 344 => 0x23 },
	'afstatusnearleft' => { 339 => 0xe, 340 => 0x1a },
	'afstatusnearright' => { 339 => 0xa, 340 => 0x16 },
	'afstatusright' => { 157 => 0x31, 339 => 0x1c, 342 => 0x48, 343 => 0x31, 344 => 0x31 },
	'afstatusrighthorizontal' => { 340 => 0x2e },
	'afstatusrightvertical' => { 340 => 0x38 },
	'afstatustop' => { 157 => 0xe, 342 => 0x40, 343 => 0x27, 344 => 0x27 },
	'afstatustop-left' => { 157 => 0x10, 343 => 0x29, 344 => 0x29 },
	'afstatustop-right' => { 157 => 0x4, 343 => 0x1d, 344 => 0x1d },
	'afstatustopassist-left' => { 342 => 0x3e },
	'afstatustopassist-right' => { 342 => 0x42 },
	'afstatustophorizontal' => { 339 => 0x8, 340 => 0x14 },
	'afstatustopvertical' => { 339 => 0x12, 340 => 0x1e },
	'afstatusupper-left' => { 339 => 0x0, 342 => 0x20 },
	'afstatusupper-lefthorizontal' => { 340 => 0x2 },
	'afstatusupper-leftvertical' => { 340 => 0xc },
	'afstatusupper-middle' => { 339 => 0x20, 340 => 0x20 },
	'afstatusupper-right' => { 339 => 0x1a, 342 => 0x46 },
	'afstatusupper-righthorizontal' => { 340 => 0x2a },
	'afstatusupper-rightvertical' => { 340 => 0x36 },
	'afstatusupperfarleft' => { 340 => 0x0 },
	'afstatusupperfarright' => { 340 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 338 => 0x2 },
	'afwithshutter' => { 345 => 0x2a },
	'afzoneselected' => { 357 => 0x201e },
	'aggregateissuenumber' => { 416 => 'aggregateIssueNumber' },
	'aggregationtype' => { 416 => 'aggregationType' },
	'agreement' => { 419 => 'agreement' },
	'aiservocontinuousshooting' => { 72 => 0x15 },
	'aiservofirstimagepriority' => { 73 => 0x519 },
	'aiservoimagepriority' => { 73 => 0x503 },
	'aiservosecondimagepriority' => { 73 => 0x51a },
	'aiservotrackingmethod' => { 73 => 0x504 },
	'aiservotrackingsensitivity' => { 72 => 0x14, 73 => 0x502 },
	'album' => { 426 => 'album' },
	'alreadyapplied' => { 401 => 'AlreadyApplied' },
	'alternatetitle' => { 416 => 'alternateTitle' },
	'alternatetitlea-lang' => { 416 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 416 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 416 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 172 => 0x6 },
	'alttapename' => { 426 => 'altTapeName' },
	'alttimecode' => { 426 => 'altTimecode' },
	'alttimecodetimeformat' => { 426 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 426 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 426 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 324 => 0x14, 377 => 0x4 },
	'ambienttemperaturefahrenheit' => { 324 => 0x13 },
	'analogbalance' => { 106 => 0xc627 },
	'angleadj' => { 92 => 0x10003, 98 => 0x8b },
	'angleinforoll' => { 396 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 396 => 'AngleInfoYaw' },
	'anti-blur' => { 357 => 0xb04b },
	'antialiasstrength' => { 106 => 0xc632 },
	'aperturelock' => { 238 => '38.2', 247 => '38.2' },
	'aperturerange' => { 73 => 0x10d },
	'apertureringuse' => { 284 => '1.4' },
	'aperturesetting' => { 161 => 0x7, 345 => 0x30, 346 => 0x29, 347 => 0x1 },
	'aperturevalue' => { 82 => 0x2, 106 => 0x9202, 255 => 0x1002, 312 => 0x401, 405 => 'ApertureValue' },
	'applekeywords' => { 259 => 'AAPL:Keywords' },
	'applicationnotes' => { 106 => 0x2bc, 274 => 0x2bc },
	'applicationrecordversion' => { 114 => 0x0 },
	'applyshootingmeteringmode' => { 73 => 0x10e },
	'approved' => { 407 => 'Approved' },
	'approvedby' => { 407 => 'ApprovedBy' },
	'approximatefnumber' => { 266 => 0x313, 272 => 0x3406 },
	'approximatefocusdistance' => { 397 => 'ApproximateFocusDistance' },
	'aquahsl' => { 92 => 0x20913 },
	'armidentifier' => { 115 => 0x78 },
	'armversion' => { 115 => 0x7a },
	'artfilter' => { 250 => 0x529 },
	'artfiltereffect' => { 250 => 0x52f },
	'artist' => { 106 => 0x13b, 262 => 'Artist', 303 => 0x22e, 422 => 'Artist', 426 => 'artist' },
	'artmode' => { 102 => 0x301b },
	'artmodeparameters' => { 102 => 0x310b },
	'artworkcircadatecreated' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 411 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 411 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 254 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 254 => 0x1112, 303 => 0x80, 345 => 0x55, 346 => 0x55, 347 => 0xa },
	'asshoticcprofile' => { 106 => 0xc68f },
	'asshotneutral' => { 106 => 0xc628 },
	'asshotpreprofilematrix' => { 106 => 0xc690 },
	'asshotprofilename' => { 106 => 0xc6f6 },
	'asshotwhitexy' => { 106 => 0xc629 },
	'assignbktbutton' => { 237 => '4.2', 238 => '16.1', 247 => '16.1' },
	'assignfuncbutton' => { 73 => 0x70b },
	'assignmovierecordbutton' => { 238 => '43.2', 247 => '45.1' },
	'assignremotefnbutton' => { 238 => '54.1', 247 => '51.1' },
	'assistbuttonfunction' => { 71 => 0xd },
	'attributionname' => { 398 => 'attributionName' },
	'attributionurl' => { 398 => 'attributionURL' },
	'audio' => { 270 => 0x20 },
	'audiobitrate' => { 58 => 0x6c },
	'audiochannels' => { 58 => 0x70 },
	'audiochanneltype' => { 426 => 'audioChannelType' },
	'audiocompression' => { 135 => 'Compression' },
	'audiocompressor' => { 426 => 'audioCompressor' },
	'audioduration' => { 114 => 0x99 },
	'audiomoddate' => { 426 => 'audioModDate' },
	'audiooutcue' => { 114 => 0x9a },
	'audiosamplerate' => { 58 => 0x6e, 426 => 'audioSampleRate' },
	'audiosampletype' => { 426 => 'audioSampleType' },
	'audiosamplingrate' => { 114 => 0x97 },
	'audiosamplingresolution' => { 114 => 0x98 },
	'audiotype' => { 114 => 0x96 },
	'author' => { 137 => 'Author', 259 => 'Author', 262 => 'Author', 319 => 'Author', 395 => 'author', 412 => 'Author', 424 => 'Author' },
	'authorsposition' => { 413 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 73 => 0x51c },
	'autoaperture' => { 294 => '0.1' },
	'autobracket' => { 337 => 0x19 },
	'autobracketing' => { 111 => 0x1100, 303 => 0x18, 328 => 0x1007 },
	'autobracketingmode' => { 246 => '12.3' },
	'autobracketingset' => { 246 => '12.1' },
	'autobracketmodem' => { 237 => '21.2', 238 => '13.3', 243 => '26.2', 247 => '13.3' },
	'autobracketorder' => { 161 => 0x43, 237 => '21.3', 238 => '13.2', 243 => '26.3', 244 => '12.2', 245 => '2.2', 246 => '12.2', 247 => '13.2', 248 => '13.2' },
	'autobracketset' => { 237 => '21.1', 238 => '13.1', 240 => '11.1', 241 => '12.1', 242 => '12.1', 243 => '26.1', 244 => '12.1', 245 => '2.1', 247 => '13.1', 248 => '13.1' },
	'autobrightness' => { 401 => 'AutoBrightness' },
	'autocontrast' => { 401 => 'AutoContrast' },
	'autodistortioncontrol' => { 180 => 0x4 },
	'autodynamicrange' => { 111 => 0x140b },
	'autoexposure' => { 401 => 'AutoExposure' },
	'autoexposurebracketing' => { 67 => 0x10 },
	'autofocus' => { 253 => 0x209 },
	'autofp' => { 245 => '7.3', 248 => '31.4' },
	'autoiso' => { 67 => 0x1, 102 => 0x3008, 239 => '1.1', 245 => '1.1' },
	'autoisomax' => { 239 => '1.2', 245 => '1.2' },
	'autoisominshutterspeed' => { 239 => '1.3', 245 => '1.3' },
	'autolateralca' => { 401 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 54 => 0x2, 73 => 0x204, 92 => 0x20500, 98 => 0x6f },
	'autolightingoptimizeron' => { 92 => '0x20500.0', 98 => 0x6e },
	'autoportraitframed' => { 357 => 0x2016 },
	'autoredeye' => { 230 => 0xfe28a44f },
	'autorotate' => { 67 => 0x1b },
	'autoshadows' => { 401 => 'AutoShadows' },
	'autowhiteversion' => { 401 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 194 => 0x82 },
	'avaperturesetting' => { 284 => 0x13 },
	'averageblacklevel' => { 38 => 0xe7, 40 => 0xfb, 41 => 0x114, 42 => 0x146 },
	'averagelv' => { 164 => 0x38 },
	'avsettingwithoutlens' => { 73 => 0x707 },
	'azimuth' => { 145 => 'Azimuth' },
	'babyage' => { 270 => [0x8010,0x33] },
	'babyname' => { 270 => 0x66 },
	'backgroundalpha' => { 421 => 'bgalpha' },
	'baseexposurecompensation' => { 284 => 0x15 },
	'baseiso' => { 67 => 0x2, 86 => 0x101c, 120 => 0x903, 272 => 0x312a, 382 => 0x6 },
	'baselineexposure' => { 106 => 0xc62a },
	'baselineexposureoffset' => { 106 => 0xc7a5 },
	'baselinenoise' => { 106 => 0xc62b },
	'baselinesharpness' => { 106 => 0xc62c },
	'baseurl' => { 424 => 'BaseURL' },
	'batterylevel' => { 345 => 0x51, 349 => 0xc, 350 => 0x4, 351 => 0x4, 383 => 0x7 },
	'batterylevelgrip1' => { 383 => 0x6 },
	'batterylevelgrip2' => { 383 => 0x8 },
	'batteryorder' => { 237 => '12.5', 243 => '13.2', 244 => '2.1', 247 => '3.1' },
	'batterystate' => { 161 => 0x60, 345 => 0x50, 351 => 0x14 },
	'batterytemperature' => { 349 => 0x1, 351 => 0x2, 383 => 0x5 },
	'batteryunknown' => { 349 => 0x2, 351 => 0x0 },
	'batteryvoltage' => { 120 => 0x408, 324 => 0x2a, 349 => 0x8 },
	'batteryvoltage1' => { 351 => 0x6 },
	'batteryvoltage2' => { 351 => 0x8 },
	'bayergreensplit' => { 106 => 0xc62d },
	'bayerpattern' => { 119 => 0xf902, 165 => 0x17 },
	'beatspliceparams' => { 426 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 426 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 426 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 426 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 426 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 426 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 237 => '13.1', 238 => '5.4', 239 => '0.1', 240 => '2.1', 241 => '3.1', 242 => '3.1', 243 => '10.1', 245 => '0.1', 247 => '5.5', 248 => '4.1' },
	'beeppitch' => { 244 => '3.1' },
	'beepvolume' => { 244 => '4.5' },
	'bestqualityscale' => { 106 => 0xc65c },
	'bestshotmode' => { 102 => 0x3007 },
	'bitdepth' => { 142 => 'BitDepth', 165 => 0x11, 200 => 0x41 },
	'bitspercomponent' => { 116 => 0x87 },
	'bitspersample' => { 106 => 0x102, 422 => 'BitsPerSample' },
	'blacklevel' => { 106 => 0xc61a, 194 => 0x3d, 255 => [0x401,0x1012], 312 => 0x21d },
	'blacklevel1' => { 274 => 0x8 },
	'blacklevel2' => { 254 => 0x600, 258 => 0x600, 274 => 0x9 },
	'blacklevel3' => { 274 => 0xa },
	'blacklevelblue' => { 274 => 0x1e },
	'blackleveldata' => { 312 => 0x223 },
	'blackleveldeltah' => { 106 => 0xc61b },
	'blackleveldeltav' => { 106 => 0xc61c },
	'blacklevelgreen' => { 274 => 0x1d },
	'blacklevelred' => { 274 => 0x1c },
	'blacklevelrepeatdim' => { 106 => 0xc619 },
	'blackpoint' => { 303 => 0x200 },
	'blacks2012' => { 401 => 'Blacks2012' },
	'bleachbypasstoning' => { 303 => 0x7f },
	'blogtitle' => { 416 => 'blogTitle' },
	'blogurl' => { 416 => 'blogURL' },
	'bluebalance' => { 178 => 0x271, 255 => 0x1018, 274 => 0x12, 303 => 0x1b },
	'bluecurvelimits' => { 97 => 0x1fe },
	'bluecurvepoints' => { 96 => 0x79, 97 => 0x1d4 },
	'bluehsl' => { 92 => [0x20914,0x20915] },
	'bluehue' => { 401 => 'BlueHue' },
	'bluesaturation' => { 401 => 'BlueSaturation' },
	'blurcontrol' => { 303 => 0x82 },
	'blurwarning' => { 111 => 0x1300 },
	'bodybatteryadload' => { 282 => 0x3 },
	'bodybatteryadnoload' => { 282 => 0x2 },
	'bodybatterystate' => { 282 => '1.1' },
	'bodybatteryvoltage1' => { 282 => 0x2 },
	'bodybatteryvoltage2' => { 282 => 0x4 },
	'bodybatteryvoltage3' => { 282 => 0x6 },
	'bodybatteryvoltage4' => { 282 => 0x8 },
	'bodyfirmware' => { 329 => 0x0 },
	'bodyfirmwareversion' => { 251 => 0x104, 252 => 0x100, 255 => 0x104 },
	'bodyserialnumber' => { 329 => 0x10 },
	'bookedition' => { 416 => 'bookEdition' },
	'bracketmode' => { 49 => 0x3 },
	'bracketsequence' => { 102 => 0x301d },
	'bracketsettings' => { 270 => 0x45 },
	'bracketshotnumber' => { 49 => 0x5, 284 => 0x9, 356 => 0x2b },
	'bracketshotnumber2' => { 356 => 0x2d },
	'bracketstep' => { 158 => 0xe },
	'bracketvalue' => { 49 => 0x4 },
	'brightness' => { 106 => 0xfe53, 136 => 'Brightness', 154 => 'Brightness', 158 => 0x2c, 196 => 0x34, 324 => 0x25, 345 => 0x22, 357 => 0x2007, 401 => 'Brightness' },
	'brightnessadj' => { 97 => 0x114, 223 => 0x0, 233 => 0x2d, 386 => 0x8018 },
	'brightnessvalue' => { 106 => 0x9203, 164 => [0x691,0x49c3], 255 => 0x1003, 361 => 0x1e, 364 => 0x1140, 365 => 0x1140, 366 => 0x111c, 367 => 0x1198, 368 => 0x1174, 369 => 0x102c, 370 => 0x224, 371 => 0x224, 405 => 'BrightnessValue' },
	'bulbduration' => { 67 => 0x18 },
	'burstmode' => { 122 => 0xa, 270 => 0x2a },
	'burstmode2' => { 122 => 0x18 },
	'burstshot' => { 337 => 0x34 },
	'burstspeed' => { 270 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 73 => 0x70a },
	'bwfilter' => { 158 => 0x2a, 166 => 0x39 },
	'bwmode' => { 255 => 0x203 },
	'by-line' => { 114 => 0x50 },
	'by-linetitle' => { 114 => 0x55 },
	'bytecount' => { 416 => 'byteCount' },
	'calibration' => { 337 => [0x24,0x30] },
	'calibrationilluminant1' => { 106 => 0xc65a },
	'calibrationilluminant2' => { 106 => 0xc65b },
	'cameraangle' => { 426 => 'cameraAngle' },
	'cameracalibration1' => { 106 => 0xc623 },
	'cameracalibration2' => { 106 => 0xc624 },
	'cameracalibrationsig' => { 106 => 0xc6f3 },
	'cameracolorcalibration01' => { 33 => 0x0, 39 => 0xba },
	'cameracolorcalibration02' => { 33 => 0x4, 39 => 0xbf },
	'cameracolorcalibration03' => { 33 => 0x8, 39 => 0xc4 },
	'cameracolorcalibration04' => { 33 => 0xc, 39 => 0xc9 },
	'cameracolorcalibration05' => { 33 => 0x10, 39 => 0xce },
	'cameracolorcalibration06' => { 33 => 0x14, 39 => 0xd3 },
	'cameracolorcalibration07' => { 33 => 0x18, 39 => 0xd8 },
	'cameracolorcalibration08' => { 33 => 0x1c, 39 => 0xdd },
	'cameracolorcalibration09' => { 33 => 0x20, 39 => 0xe2 },
	'cameracolorcalibration10' => { 33 => 0x24, 39 => 0xe7 },
	'cameracolorcalibration11' => { 33 => 0x28, 39 => 0xec },
	'cameracolorcalibration12' => { 33 => 0x2c, 39 => 0xf1 },
	'cameracolorcalibration13' => { 33 => 0x30, 39 => 0xf6 },
	'cameracolorcalibration14' => { 33 => 0x34, 39 => 0xfb },
	'cameracolorcalibration15' => { 33 => 0x38, 39 => 0x100 },
	'camerae-mountversion' => { 385 => 0xb },
	'cameraid' => { 255 => 0x209, 336 => 0x209 },
	'cameraiso' => { 31 => 0x10 },
	'cameralabel' => { 106 => 0xc7a1, 426 => 'cameraLabel' },
	'cameramodel' => { 312 => 0x410, 426 => 'cameraModel' },
	'cameramodelid' => { 154 => 'CameraModelID' },
	'cameramove' => { 426 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 270 => 0x8f, 307 => 0x1, 312 => 0x100, 351 => [0x16,0x18], 374 => 0x28, 375 => 0x24, 376 => 0x29 },
	'cameraowner' => { 123 => 0xc353 },
	'cameraparameters' => { 255 => 0x2050 },
	'camerapicturestyle' => { 26 => 0xaf },
	'cameraprofile' => { 401 => 'CameraProfile' },
	'cameraprofiledigest' => { 401 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 98 => 0xe1 },
	'camerarawcontrast' => { 98 => 0xe3 },
	'camerarawhighlightpoint' => { 98 => 0xe6 },
	'camerarawlinear' => { 98 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 98 => 0xe8 },
	'camerarawoutputshadowpoint' => { 98 => 0xe9 },
	'camerarawsaturation' => { 98 => 0xe2 },
	'camerarawshadowpoint' => { 98 => 0xe7 },
	'camerarawsharpness' => { 98 => 0xe5 },
	'cameraserialnumber' => { 106 => 0xc62f, 156 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 250 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 30 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 67 => 0xc, 120 => 0x406, 254 => 0x1306, 266 => 0x320, 272 => 0x3402, 303 => 0x47, 334 => 0x43, 378 => 0x5 },
	'cameratemperature4' => { 308 => 0x14 },
	'cameratemperature5' => { 308 => 0x16 },
	'cameratemperaturerangemax' => { 108 => 0x5 },
	'cameratemperaturerangemin' => { 108 => 0x6 },
	'cameratype' => { 67 => 0x1a, 255 => 0x207 },
	'cameratype2' => { 251 => 0x100 },
	'canondr4' => { 107 => 'CanonDR4' },
	'canonexposuremode' => { 31 => 0x14 },
	'canonfiledescription' => { 86 => 0x805 },
	'canonfilelength' => { 55 => 0xe },
	'canonfirmwareversion' => { 55 => 0x7, 86 => 0x80b },
	'canonflashinfo' => { 86 => 0x1028 },
	'canonflashmode' => { 31 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 31 => 0xa },
	'canonimagetype' => { 55 => 0x6, 86 => 0x815 },
	'canonmodelid' => { 55 => 0x10, 86 => 0x1834 },
	'canonvrd' => { 107 => 'CanonVRD' },
	'caption' => { 395 => 'caption' },
	'caption-abstract' => { 114 => 0x78 },
	'captionsauthornames' => { 404 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 404 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 413 => 'CaptionWriter' },
	'captureframerate' => { 102 => 0x4001 },
	'capturesoftware' => { 390 => 'CaptureSoftware' },
	'cardshutterlock' => { 161 => 0x49 },
	'casioimagesize' => { 102 => 0x9 },
	'catalogsets' => { 114 => 0xff, 389 => 'CatalogSets', 393 => 'CatalogSets' },
	'categories' => { 55 => 0x23, 395 => 'categories' },
	'category' => { 114 => 0xf, 249 => 0x30, 413 => 'Category' },
	'cbcrgain' => { 334 => 0xa036 },
	'cbcrgaindefault' => { 334 => 0xa035 },
	'cbcrmatrix' => { 334 => 0xa034 },
	'cbcrmatrixdefault' => { 334 => 0xa033 },
	'ccdboardversion' => { 266 => 0x331 },
	'ccdscanmode' => { 255 => 0x1039 },
	'ccdsensitivity' => { 220 => 0x6 },
	'ccdversion' => { 266 => 0x330 },
	'cellglobalid' => { 399 => 'cgi' },
	'celllength' => { 106 => 0x109 },
	'cellr' => { 399 => 'r' },
	'celltowerid' => { 399 => 'cellid' },
	'cellwidth' => { 106 => 0x108 },
	'centerafarea' => { 245 => '15.1' },
	'centerfocuspoint' => { 248 => '2.2' },
	'centerweightedareasize' => { 237 => '7.1', 238 => '8.1', 243 => '5.1', 244 => '7.1', 245 => '6.3', 247 => '8.1', 248 => '8.1' },
	'certificate' => { 430 => 'Certificate' },
	'cfapattern' => { 106 => 0xa302, 405 => 'CFAPattern' },
	'cfapattern2' => { 106 => 0x828e },
	'cfapatterncolumns' => { 405 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 405 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 405 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 106 => 0x828d },
	'channel' => { 416 => 'channel' },
	'channela-lang' => { 416 => [\'channel','channelA-lang'] },
	'channelchannel' => { 416 => [\'channel','channelChannel'] },
	'channels' => { 135 => 'Channels' },
	'channelsubchannel1' => { 416 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 416 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 416 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 416 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 92 => 0x10101, 97 => 0x26a },
	'checkmark2' => { 98 => 0x8e },
	'childfontfiles' => { 431 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 237 => '10.3', 238 => '11.2' },
	'chromablurradius' => { 106 => 0xc631 },
	'chromaticaberration' => { 92 => 0x20703, 98 => 0x66, 334 => 0xa051 },
	'chromaticaberrationb' => { 401 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 92 => 0x20708, 98 => 0x6b },
	'chromaticaberrationcorr' => { 69 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 293 => 0x1 },
	'chromaticaberrationon' => { 92 => '0x20703.0', 98 => 0x62 },
	'chromaticaberrationr' => { 401 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 92 => 0x20707, 98 => 0x6a },
	'chromaticaberrationsetting' => { 70 => 0x6 },
	'chrominancenoisereduction' => { 92 => 0x20601, 98 => 0x5e, 337 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 98 => 0x60 },
	'circgradbasedcorractive' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 401 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 401 => 'CircularGradientBasedCorrections' },
	'city' => { 114 => 0x5a, 141 => 'City', 270 => 0x6d, 413 => 'City' },
	'city2' => { 270 => 0x80 },
	'clarity' => { 401 => 'Clarity' },
	'clarity2012' => { 401 => 'Clarity2012' },
	'classifystate' => { 114 => 0xe1 },
	'clearretouch' => { 270 => 0x7c },
	'clearretouchvalue' => { 270 => 0xa3 },
	'client' => { 426 => 'client' },
	'clientname' => { 407 => 'ClientName' },
	'clmodeshootingspeed' => { 237 => '10.2', 238 => '11.3', 243 => '11.2', 244 => '10.2', 247 => '11.2', 248 => '11.1' },
	'cmcontrast' => { 258 => 0x2022 },
	'cmexposurecompensation' => { 258 => 0x2000 },
	'cmhue' => { 258 => 0x2021 },
	'cmsaturation' => { 258 => 0x2020 },
	'cmsharpness' => { 258 => 0x2023 },
	'cmwhitebalance' => { 258 => 0x2001 },
	'cmwhitebalancecomp' => { 258 => 0x2002 },
	'cmwhitebalancegraypoint' => { 258 => 0x2010 },
	'codec' => { 149 => 'Codec' },
	'codedcharacterset' => { 115 => 0x5a },
	'collectionname' => { 150 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 150 => 'Collections', 395 => 'collections' },
	'collectionuri' => { 150 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 415 => 'color' },
	'coloraberrationcontrol' => { 230 => 0xc89224b },
	'coloradjustment' => { 337 => 0x14 },
	'coloradjustmentmode' => { 336 => 0x210 },
	'coloranta' => { 431 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 431 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 431 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 431 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 431 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 431 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 431 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 431 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 431 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 431 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 431 => 'Colorants' },
	'colorantswatchname' => { 431 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 431 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 431 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 431 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 136 => 'ColorBalance' },
	'colorbalanceadj' => { 230 => 0x76a43202 },
	'colorbalanceblue' => { 158 => 0x1e },
	'colorbalancegreen' => { 158 => 0x1d },
	'colorbalancered' => { 158 => 0x1c },
	'colorbalanceversion' => { 179 => 0x0 },
	'colorblur' => { 98 => 0x65 },
	'colorbluron' => { 92 => 0x20704 },
	'colorbooster' => { 230 => 0x5f0e7d23 },
	'colorboostlevel' => { 224 => 0x1 },
	'colorboosttype' => { 224 => 0x0 },
	'colorclass' => { 314 => 0xde, 315 => 'ColorClass' },
	'colorcompensationfilter' => { 161 => [0x3a,0x5f], 163 => 0x111, 357 => 0xb022 },
	'colorcompensationfiltercustom' => { 345 => 0xd, 346 => 0xc },
	'colorcompensationfilterset' => { 345 => 0x8, 346 => 0x7, 347 => 0x18, 361 => 0xf },
	'colorcontrol' => { 255 => 0x102b },
	'colorcorrection' => { 386 => 0x8015 },
	'colordataversion' => { 37 => 0x0, 38 => 0x0, 40 => 0x0, 41 => 0x0, 42 => 0x0 },
	'coloreffect' => { 270 => 0x28 },
	'colorfilter' => { 101 => 0x17, 102 => 0x3017, 158 => 0x29, 166 => [0x38,0x4d,0x4f], 310 => 0x17 },
	'colorgain' => { 200 => 0x51 },
	'colorhue' => { 92 => 0x20900, 194 => 0x8d },
	'colorimetricreference' => { 106 => 0xc6bf },
	'colorlabel' => { 404 => 'ColorLabel' },
	'colormatrix' => { 254 => 0x200, 255 => 0x1011, 334 => 0xa030 },
	'colormatrix1' => { 106 => 0xc621, 312 => 0x106 },
	'colormatrix2' => { 106 => 0xc622, 258 => 0x200, 312 => 0x226 },
	'colormatrixa' => { 303 => 0x203 },
	'colormatrixadobergb' => { 334 => 0xa032 },
	'colormatrixb' => { 303 => 0x204 },
	'colormatrixnumber' => { 255 => 0x1019 },
	'colormatrixsrgb' => { 334 => 0xa031 },
	'colormode' => { 102 => 0x3015, 111 => 0x1210, 122 => 0x66, 158 => 0x28, 161 => 0x16, 163 => 0x101, 164 => 0x36, 166 => 0x7, 194 => 0x3, 220 => 0x4, 270 => 0x32, 337 => 0x2c, 357 => 0xb029, 413 => 'ColorMode' },
	'colormoirereduction' => { 231 => 0x15 },
	'colormoirereductionmode' => { 231 => 0x5 },
	'colornoisereduction' => { 386 => 0x8029, 401 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 401 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 231 => 0x18 },
	'colornoisereductionsharpness' => { 231 => 0x1c },
	'colornoisereductionsmoothness' => { 401 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 110 => 0x2 },
	'colorprofile' => { 158 => 0x33 },
	'colorrepresentation' => { 116 => 0x3c },
	'colorsaturationadj' => { 92 => 0x20305 },
	'colorsequence' => { 116 => 0x41 },
	'colorspace' => { 43 => 0x3, 55 => 0xb4, 86 => 0x10b4, 106 => 0xa001, 142 => 'ColorSpace', 159 => 0x2f, 160 => 0x25, 161 => 0x17, 194 => 0x1e, 250 => 0x507, 303 => 0x37, 334 => 0xa011, 337 => 0xb, 345 => 0x1b, 346 => 0x83, 347 => 0xe, 361 => 0x6, 405 => 'ColorSpace' },
	'colortempasshot' => { 34 => 0x4, 35 => 0x1d, 36 => 0x26, 37 => 0x43, 40 => 0x43, 41 => 0x43, 42 => 0x43 },
	'colortempauto' => { 34 => 0x9, 35 => 0x22, 36 => 0x1c, 37 => 0x48, 40 => 0x48, 41 => 0x48, 42 => 0x48 },
	'colortempcloudy' => { 34 => 0x22, 35 => 0x31, 36 => 0x35, 37 => 0x5c, 40 => 0x75, 41 => 0x8e, 42 => 0x93, 303 => 0x55 },
	'colortempcustom' => { 37 => 0x84 },
	'colortempcustom1' => { 35 => 0x45 },
	'colortempcustom2' => { 35 => 0x4a },
	'colortempdaylight' => { 34 => 0x18, 35 => 0x27, 36 => 0x2b, 37 => 0x52, 40 => 0x6b, 41 => 0x84, 42 => 0x89, 303 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 55 => 0xae, 65 => 0x9, 86 => 0x10ae, 111 => 0x1005, 120 => 0x846, 136 => 'ColorTemperature', 159 => [0x6e,0x49], 160 => 0x3f, 161 => [0x39,0x5e], 163 => 0x10b, 166 => [0x3c,0x4c,0x4e], 266 => 0x321, 303 => 0x50, 328 => 0x1308, 357 => 0xb021, 401 => 'Temperature' },
	'colortemperatureadj' => { 386 => 0x8013 },
	'colortemperaturebg' => { 255 => 0x1013 },
	'colortemperaturecustom' => { 345 => 0xc, 346 => 0xb },
	'colortemperaturerg' => { 255 => 0x1014 },
	'colortemperatureset' => { 345 => 0x7, 346 => 0x6 },
	'colortemperaturesetting' => { 161 => 0x25, 347 => 0x17, 361 => 0xe },
	'colortempflash' => { 34 => 0x36, 35 => 0x40, 36 => 0x49, 37 => 0x70, 40 => 0x89, 41 => 0xa2, 42 => 0xa7, 303 => 0x5a },
	'colortempflashdata' => { 37 => 0x24a },
	'colortempfluorescent' => { 34 => 0x2c, 35 => 0x3b, 36 => 0x3f, 37 => 0x66, 40 => 0x7f, 41 => 0x98, 42 => 0x9d },
	'colortempfluorescentd' => { 303 => 0x57 },
	'colortempfluorescentn' => { 303 => 0x58 },
	'colortempfluorescentw' => { 303 => 0x59 },
	'colortempkelvin' => { 34 => 0x31, 36 => 0x44, 37 => 0x6b, 40 => 0x84, 41 => 0x9d, 42 => 0xa2, 270 => 0x44, 328 => 0x1307 },
	'colortempmeasured' => { 34 => 0xe, 37 => 0x4d, 40 => 0x4d, 41 => 0x4d, 42 => 0x4d },
	'colortemppc1' => { 36 => 0x94, 37 => 0x75 },
	'colortemppc2' => { 36 => 0x99, 37 => 0x7a },
	'colortemppc3' => { 36 => 0x9e, 37 => 0x7f },
	'colortempshade' => { 34 => 0x1d, 35 => 0x2c, 36 => 0x30, 37 => 0x57, 40 => 0x70, 41 => 0x89, 42 => 0x8e, 303 => 0x54 },
	'colortemptungsten' => { 34 => 0x27, 35 => 0x36, 36 => 0x3a, 37 => 0x61, 40 => 0x7a, 41 => 0x93, 42 => 0x98, 303 => 0x56 },
	'colortempunknown' => { 34 => 0x13, 36 => 0x21, 40 => 0x52, 41 => 0x52, 42 => 0x52 },
	'colortempunknown10' => { 34 => 0x63, 36 => 0x76, 40 => 0xa2, 41 => 0x7f, 42 => 0x7f },
	'colortempunknown11' => { 34 => 0x68, 36 => 0x7b, 40 => 0xa7, 41 => 0xa7, 42 => 0x84 },
	'colortempunknown12' => { 34 => 0x6d, 36 => 0x80, 40 => 0xac, 41 => 0xac, 42 => 0xac },
	'colortempunknown13' => { 34 => 0x72, 36 => 0x85, 40 => 0xb1, 41 => 0xb1, 42 => 0xb1 },
	'colortempunknown14' => { 36 => 0x8a, 40 => 0xb6, 41 => 0xb6, 42 => 0xb6 },
	'colortempunknown15' => { 36 => 0x8f, 40 => 0xbb, 41 => 0xbb, 42 => 0xbb },
	'colortempunknown16' => { 36 => 0xa3, 41 => 0xc0, 42 => 0xc0 },
	'colortempunknown17' => { 41 => 0xc5, 42 => 0xc5 },
	'colortempunknown18' => { 41 => 0xca, 42 => 0xca },
	'colortempunknown19' => { 41 => 0xcf, 42 => 0xcf },
	'colortempunknown2' => { 34 => 0x3b, 36 => 0x4e, 40 => 0x57, 41 => 0x57, 42 => 0x57 },
	'colortempunknown20' => { 41 => 0xd4, 42 => 0xd4 },
	'colortempunknown21' => { 42 => 0xd9 },
	'colortempunknown22' => { 42 => 0xde },
	'colortempunknown23' => { 42 => 0xe3 },
	'colortempunknown24' => { 42 => 0xe8 },
	'colortempunknown25' => { 42 => 0xed },
	'colortempunknown26' => { 42 => 0xf2 },
	'colortempunknown27' => { 42 => 0xf7 },
	'colortempunknown28' => { 42 => 0xfc },
	'colortempunknown29' => { 42 => 0x101 },
	'colortempunknown3' => { 34 => 0x40, 36 => 0x53, 40 => 0x5c, 41 => 0x5c, 42 => 0x5c },
	'colortempunknown30' => { 42 => 0x106 },
	'colortempunknown4' => { 34 => 0x45, 36 => 0x58, 40 => 0x61, 41 => 0x61, 42 => 0x61 },
	'colortempunknown5' => { 34 => 0x4a, 36 => 0x5d, 40 => 0x66, 41 => 0x66, 42 => 0x66 },
	'colortempunknown6' => { 34 => 0x4f, 36 => 0x62, 40 => 0x8e, 41 => 0x6b, 42 => 0x6b },
	'colortempunknown7' => { 34 => 0x54, 36 => 0x67, 40 => 0x93, 41 => 0x70, 42 => 0x70 },
	'colortempunknown8' => { 34 => 0x59, 36 => 0x6c, 40 => 0x98, 41 => 0x75, 42 => 0x75 },
	'colortempunknown9' => { 34 => 0x5e, 36 => 0x71, 40 => 0x9d, 41 => 0x7a, 42 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 31 => 0x2a, 43 => 0x2 },
	'colortoneadj' => { 92 => 0x20304, 97 => 0x11e },
	'colortoneauto' => { 62 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 61 => 0x6c, 62 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 61 => 0x3c, 62 => 0x3c },
	'colortonemonochrome' => { 61 => 0x84, 62 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 61 => 0x54, 62 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 61 => 0x24, 62 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 61 => 0xc, 62 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 61 => 0x9c, 62 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 61 => 0xb4, 62 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 61 => 0xcc, 62 => 0xe4 },
	'commanddials' => { 245 => '5.1' },
	'commanddialsaperturesetting' => { 237 => '17.3', 238 => '18.3', 243 => '33.3', 244 => '17.3', 247 => '18.3' },
	'commanddialschangemainsub' => { 237 => '17.2', 238 => '18.1', 243 => '33.2', 244 => '17.2', 247 => '18.1' },
	'commanddialsmenuandplayback' => { 237 => '17.4', 238 => '18.2', 243 => '33.4', 244 => '17.4', 247 => '18.2' },
	'commanddialsreverserotation' => { 237 => '17.1', 238 => '6.4', 240 => '16.2', 241 => '17.2', 243 => '33.1', 244 => '17.1', 247 => '6.2', 248 => '18.1' },
	'commanderchannel' => { 245 => '10.2', 246 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 245 => '13.1', 246 => '31.1' },
	'commandergroupa_ttlcomp' => { 248 => '32.1' },
	'commandergroupamanualoutput' => { 245 => '13.2', 246 => '28.2' },
	'commandergroupamode' => { 245 => '11.2', 246 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 245 => '14.1', 246 => '32.1' },
	'commandergroupb_ttlcomp' => { 248 => '33.1' },
	'commandergroupbmanualoutput' => { 245 => '14.2', 246 => '29.2' },
	'commandergroupbmode' => { 245 => '11.3', 246 => '29.1' },
	'commanderinternalflash' => { 245 => '11.1', 246 => '27.1' },
	'commanderinternalmanualoutput' => { 245 => '12.2', 246 => '27.2' },
	'commanderinternalttlchannel' => { 243 => '18.2' },
	'commanderinternalttlcomp' => { 245 => '12.1', 246 => '30.2', 248 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 243 => '20.1', 244 => '26.1' },
	'commanderinternalttlcompgroupa' => { 243 => '21.1', 244 => '27.1' },
	'commanderinternalttlcompgroupb' => { 243 => '22.1', 244 => '28.1' },
	'comment' => { 0 => 0x2, 107 => 'Comment', 137 => 'Comment', 262 => 'Comment' },
	'compass' => { 331 => 0x4 },
	'complianceprofile' => { 416 => 'complianceProfile' },
	'componentsconfiguration' => { 106 => 0x9101, 142 => 'Components', 405 => 'ComponentsConfiguration' },
	'componentversion' => { 86 => 0x80c },
	'composer' => { 426 => 'composer' },
	'compositionadjust' => { 302 => '0.1' },
	'compositionadjustrotation' => { 302 => 0x7 },
	'compositionadjustx' => { 302 => 0x5 },
	'compositionadjusty' => { 302 => 0x6 },
	'compressedbitsperpixel' => { 106 => 0x9102, 405 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 163 => 0x40, 255 => 0x40 },
	'compression' => { 106 => 0x103, 422 => 'Compression' },
	'compressionfactor' => { 250 => 0x50d },
	'compressionratio' => { 142 => 'Compression', 255 => 0x1034 },
	'confidencelevel' => { 396 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 97 => 0x266, 314 => 0xd6 },
	'constrainedcropwidth' => { 97 => 0x262, 314 => 0xd5 },
	'contact' => { 114 => 0x76 },
	'contactinfo' => { 415 => 'contactInfo' },
	'contentlocationcode' => { 114 => 0x1a },
	'contentlocationname' => { 114 => 0x1b },
	'contenttype' => { 416 => 'contentType' },
	'continuousbracketing' => { 161 => 0x20 },
	'continuousdrive' => { 31 => 0x5 },
	'continuousshootingspeed' => { 73 => 0x610 },
	'continuousshotlimit' => { 73 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 31 => 0xd, 101 => 0xc, 102 => [0x3012,0x20], 106 => [0xa408,0xfe54], 111 => [0x1004,0x1006], 136 => 'Contrast', 154 => 'Contrast', 158 => 0x20, 159 => 0x31, 160 => 0x27, 161 => 0x19, 166 => 0x2, 196 => 0x33, 255 => 0x1029, 270 => 0x39, 272 => 0x300a, 303 => 0x20, 310 => 0xc, 324 => 0x24, 328 => 0x1012, 337 => 0xd, 345 => 0x1d, 346 => 0x1a, 357 => 0x2004, 401 => 'Contrast', 405 => 'Contrast' },
	'contrast2012' => { 401 => 'Contrast2012' },
	'contrastadj' => { 92 => 0x20303, 97 => 0x115, 233 => 0x2c, 386 => 0x8017 },
	'contrastauto' => { 62 => 0x90 },
	'contrastcurve' => { 194 => 0x8c },
	'contrastdetectaf' => { 170 => 0x4 },
	'contrastdetectafarea' => { 303 => 0x231 },
	'contrastdetectafinfocus' => { 170 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 61 => 0x60, 62 => 0x60 },
	'contrasthighlight' => { 303 => 0x6d },
	'contrasthighlightshadowadj' => { 303 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 61 => 0x30, 62 => 0x30 },
	'contrastmode' => { 270 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 61 => 0x78, 62 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 61 => 0x48, 62 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 61 => 0x18, 62 => 0x18 },
	'contrastsetting' => { 250 => 0x505, 258 => 0x1012, 347 => 0x10, 361 => 0x8 },
	'contrastshadow' => { 303 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 61 => 0x0, 62 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 61 => 0x90, 62 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 61 => 0xa8, 62 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 61 => 0xc0, 62 => 0xd8 },
	'contributedmedia' => { 426 => 'contributedMedia' },
	'contributedmediaduration' => { 426 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 426 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 426 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 426 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 426 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 426 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 426 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 426 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 426 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 426 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 402 => 'contributor' },
	'contributors' => { 137 => 'Contributors' },
	'controldialset' => { 161 => 0x46 },
	'controlledvocabularyterm' => { 411 => 'CVterm' },
	'controllerboardversion' => { 266 => 0x332 },
	'controlmode' => { 67 => 0x12 },
	'conversionlens' => { 251 => 0x403, 270 => 0x35 },
	'converter' => { 106 => 0xfe4d, 220 => 0xb, 401 => 'Converter' },
	'converttograyscale' => { 401 => 'ConvertToGrayscale' },
	'cookingequipment' => { 418 => 'cookingEquipment' },
	'cookingmethod' => { 418 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 106 => 0x8298, 137 => 'Copyright', 262 => 'Copyright', 303 => 0x22f, 319 => 'Copyright', 412 => 'Copyright', 419 => 'copyright', 422 => 'Copyright', 426 => 'copyright' },
	'copyrightflag' => { 317 => 0x40a },
	'copyrightnotice' => { 114 => 0x74 },
	'copyrightowner' => { 414 => 'CopyrightOwner' },
	'copyrightownerid' => { 414 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 414 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 414 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 414 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 414 => 'CopyrightStatus' },
	'copyrightyear' => { 416 => 'copyrightYear' },
	'coringfilter' => { 254 => 0x310, 255 => 0x102d, 258 => 0x310 },
	'coringvalues' => { 254 => 0x311, 258 => 0x311 },
	'corporateentity' => { 416 => 'corporateEntity' },
	'country' => { 141 => 'Country', 270 => 0x69, 413 => 'Country' },
	'country-primarylocationcode' => { 114 => 0x64 },
	'country-primarylocationname' => { 114 => 0x65 },
	'countrycode' => { 193 => 0x5, 315 => 'CountryCode', 410 => 'CountryCode' },
	'course' => { 418 => 'course' },
	'coverage' => { 402 => 'coverage' },
	'coverdate' => { 416 => 'coverDate' },
	'coverdisplaydate' => { 416 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 303 => 0x28 },
	'crc32' => { 403 => 'crc32' },
	'createdate' => { 106 => 0x9004, 137 => 'CreateDate', 259 => 'CreationDate', 262 => 'create-date', 319 => 'CreationDate', 321 => 0x1, 424 => 'CreateDate' },
	'creationdate' => { 412 => 'CreationDate', 416 => 'creationDate' },
	'creationtime' => { 262 => 'Creation Time' },
	'creativestyle' => { 345 => 0x1a, 346 => 0x18, 356 => 0x41, 357 => 0xb020, 382 => 0x4a },
	'creativestylesetting' => { 347 => 0xf, 361 => 0x7 },
	'creativestylewaschanged' => { 386 => 0x8001 },
	'creator' => { 259 => 'Creator', 319 => 'Creator', 402 => 'creator', 412 => 'Creator' },
	'creatoraddress' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 156 => 'CreatorAppId' },
	'creatorcity' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 410 => 'CreatorContactInfo' },
	'creatorcountry' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoropenwithuioptions' => { 156 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 424 => 'CreatorTool' },
	'creatorworkemail' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 410 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 114 => 0x6e, 413 => 'Credit' },
	'creditline' => { 419 => 'creditLine' },
	'creditlinereq' => { 429 => 'CreditLineReq' },
	'creditlinerequired' => { 414 => 'CreditLineRequired' },
	'cropactive' => { 90 => 0x0, 97 => 0x244 },
	'cropangle' => { 401 => 'CropAngle' },
	'cropaspectratio' => { 92 => 0x30101, 97 => 0x260 },
	'cropaspectratiocustom' => { 92 => 0x30102 },
	'cropbottom' => { 110 => 0x9, 225 => 0x36, 274 => 0x31, 314 => 0xdc, 401 => 'CropBottom' },
	'cropbottommargin' => { 45 => 0x3 },
	'cropcircleactive' => { 98 => 0xd6 },
	'cropcircleradius' => { 98 => 0xd9 },
	'cropcirclex' => { 98 => 0xd7 },
	'cropcircley' => { 98 => 0xd8 },
	'cropconstraintowarp' => { 401 => 'CropConstrainToWarp' },
	'croph' => { 394 => 'CropH' },
	'cropheight' => { 90 => 0x6, 97 => 0x24c, 254 => 0x615, 258 => 0x615, 401 => 'CropHeight' },
	'crophispeed' => { 194 => 0x1b },
	'cropleft' => { 97 => 0x246, 110 => 0x6, 225 => 0x1e, 254 => 0x612, 258 => 0x612, 274 => 0x30, 314 => 0xd9, 401 => 'CropLeft' },
	'cropleftmargin' => { 45 => 0x0 },
	'cropmode35mm' => { 328 => 0x1018 },
	'croporiginalheight' => { 90 => 0xb },
	'croporiginalwidth' => { 90 => 0xa },
	'cropoutputheight' => { 225 => 0xce },
	'cropoutputheightinches' => { 225 => 0x96 },
	'cropoutputpixels' => { 225 => 0xd6 },
	'cropoutputresolution' => { 225 => 0xb6 },
	'cropoutputscale' => { 225 => 0xbe },
	'cropoutputwidth' => { 225 => 0xc6 },
	'cropoutputwidthinches' => { 225 => 0x8e },
	'croppedareaimageheightpixels' => { 390 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 390 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 390 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 390 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 328 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 328 => 0x1603 },
	'cropright' => { 110 => 0x8, 225 => 0x2e, 274 => 0x32, 314 => 0xdb, 401 => 'CropRight' },
	'croprightmargin' => { 45 => 0x1 },
	'croprotatedoriginalheight' => { 90 => 0x2 },
	'croprotatedoriginalwidth' => { 90 => 0x1 },
	'croprotation' => { 90 => 0x8, 110 => 0xb },
	'cropscaledresolution' => { 225 => 0x9e },
	'cropsourceresolution' => { 225 => 0xae },
	'croptop' => { 97 => 0x248, 110 => 0x7, 225 => 0x26, 254 => 0x613, 258 => 0x613, 274 => 0x2f, 314 => 0xda, 401 => 'CropTop' },
	'croptopmargin' => { 45 => 0x2 },
	'cropunit' => { 401 => 'CropUnit' },
	'cropunits' => { 401 => 'CropUnits' },
	'cropw' => { 394 => 'CropW' },
	'cropwidth' => { 90 => 0x5, 97 => 0x24a, 254 => 0x614, 258 => 0x614, 401 => 'CropWidth' },
	'cropx' => { 90 => 0x3, 394 => 'CropX' },
	'cropy' => { 90 => 0x4, 394 => 'CropY' },
	'crossprocess' => { 303 => 0x7b },
	'crossprocessparams' => { 303 => 0x235 },
	'cuisine' => { 418 => 'cuisine' },
	'currenticcprofile' => { 106 => 0xc691 },
	'currentpreprofilematrix' => { 106 => 0xc692 },
	'currentversion' => { 386 => 0xd000 },
	'curve0x' => { 394 => 'Curve0x' },
	'curve0y' => { 394 => 'Curve0y' },
	'curve1x' => { 394 => 'Curve1x' },
	'curve1y' => { 394 => 'Curve1y' },
	'curve2x' => { 394 => 'Curve2x' },
	'curve2y' => { 394 => 'Curve2y' },
	'curve3x' => { 394 => 'Curve3x' },
	'curve3y' => { 394 => 'Curve3y' },
	'curve4x' => { 394 => 'Curve4x' },
	'curve4y' => { 394 => 'Curve4y' },
	'curves' => { 230 => 0x76a43201 },
	'custom1' => { 414 => 'Custom1' },
	'custom10' => { 414 => 'Custom10' },
	'custom2' => { 414 => 'Custom2' },
	'custom3' => { 414 => 'Custom3' },
	'custom4' => { 414 => 'Custom4' },
	'custom5' => { 414 => 'Custom5' },
	'custom6' => { 414 => 'Custom6' },
	'custom7' => { 414 => 'Custom7' },
	'custom8' => { 414 => 'Custom8' },
	'custom9' => { 414 => 'Custom9' },
	'customcolortone' => { 98 => 0x4c },
	'customcontrast' => { 98 => 0x4e },
	'customcontrols' => { 73 => 0x70c },
	'customdefaultunsharpfineness' => { 98 => 0xbe },
	'customdefaultunsharpstrength' => { 98 => 0xbc },
	'customdefaultunsharpthreshold' => { 98 => 0xc0 },
	'customlinear' => { 98 => 0x4f },
	'customoutputhighlightpoint' => { 98 => 0x53 },
	'customoutputshadowpoint' => { 98 => 0x54 },
	'custompicturestyle' => { 92 => 0x10021 },
	'custompicturestyledata' => { 92 => 0xf0500 },
	'custompicturestylefilename' => { 55 => 0x4010 },
	'customrawhighlight' => { 98 => 0x7c },
	'customrawhighlightpoint' => { 98 => 0x51 },
	'customrawshadow' => { 98 => 0x85 },
	'customrawshadowpoint' => { 98 => 0x52 },
	'customrendered' => { 106 => 0xa401, 405 => 'CustomRendered' },
	'customsaturation' => { 98 => 0x4d, 250 => 0x503 },
	'customsettingsalldefault' => { 237 => '0.2', 243 => '0.2' },
	'customsettingsbank' => { 237 => '0.1', 238 => '0.1', 243 => '0.1', 247 => '0.2' },
	'customsharpness' => { 98 => 0x50 },
	'customunsharpmaskfineness' => { 98 => 0xb8 },
	'customunsharpmaskstrength' => { 98 => 0xb6 },
	'customunsharpmaskthreshold' => { 98 => 0xba },
	'customwb_rblevels' => { 361 => 0x1a },
	'customwb_rgblevels' => { 346 => 0x8, 347 => 0x19 },
	'customwbbluelevel' => { 161 => 0x36 },
	'customwberror' => { 161 => 0x37 },
	'customwbgreenlevel' => { 161 => 0x35 },
	'customwbredlevel' => { 161 => 0x34 },
	'customwbsetting' => { 161 => 0x26 },
	'd-lightinghq' => { 230 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 226 => 0x2 },
	'd-lightinghqhighlight' => { 226 => 0x1 },
	'd-lightinghqselected' => { 230 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 226 => 0x0 },
	'd-lightinghs' => { 230 => 0xce5554aa },
	'd-lightinghsadjustment' => { 227 => 0x0 },
	'd-lightinghscolorboost' => { 227 => 0x1 },
	'd-rangeoptimizerhighlight' => { 386 => 0x8024 },
	'd-rangeoptimizermode' => { 386 => 0x8022 },
	'd-rangeoptimizershadow' => { 386 => 0x802d },
	'd-rangeoptimizervalue' => { 386 => 0x8023 },
	'd810meteringmode' => { 218 => 0x175e },
	'datacompressionmethod' => { 116 => 0x6e },
	'dataimprint' => { 158 => 0x34 },
	'datascaling' => { 303 => 0x3d },
	'date' => { 303 => 0x6, 402 => 'date' },
	'dateacquired' => { 156 => 'DateAcquired' },
	'datecreated' => { 114 => 0x37, 413 => 'DateCreated' },
	'datedisplayformat' => { 222 => 0x3 },
	'dateidentified' => { 105 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 240 => '4.2' },
	'daterecieved' => { 416 => 'dateRecieved' },
	'datesent' => { 115 => 0x46 },
	'datestampmode' => { 55 => 0x1c },
	'datetime' => { 395 => 'datetime', 422 => 'DateTime' },
	'datetimedigitized' => { 405 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 89 => 0x0, 106 => 0x9003, 134 => 0x14, 137 => 'OriginalDate', 324 => 0xb, 405 => 'DateTimeOriginal' },
	'datetimestamp' => { 122 => 0x64 },
	'datetimeutc' => { 250 => 0x908 },
	'daylightsavings' => { 68 => 0x3, 222 => 0x2 },
	'dccontinent' => { 105 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 105 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 105 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 105 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 105 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 105 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 105 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 105 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 105 => 'Event' },
	'dcfootprintspatialfit' => { 105 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 105 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 105 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 105 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 105 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 105 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 105 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 105 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 105 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 105 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 105 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 105 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 105 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 105 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 105 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 105 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 105 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 105 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 105 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 105 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 145 => 'Declination' },
	'decposition' => { 158 => 0x32 },
	'defaultautogray' => { 401 => 'DefaultAutoGray' },
	'defaultautotone' => { 401 => 'DefaultAutoTone' },
	'defaultblackrender' => { 106 => 0xc7a6 },
	'defaultcroporigin' => { 106 => 0xc61f },
	'defaultcropsize' => { 106 => 0xc620 },
	'defaulteraseoption' => { 73 => 0x813 },
	'defaultscale' => { 106 => 0xc61e },
	'defaultsspecifictoiso' => { 401 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 401 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 106 => 0xc7b5 },
	'defringe' => { 401 => 'Defringe' },
	'defringegreenamount' => { 401 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 401 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 401 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 401 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 401 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 401 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 194 => 0xa6, 201 => 0x6e },
	'deprecatedon' => { 398 => 'deprecatedOn' },
	'derivedfrom' => { 427 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 427 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 427 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 427 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 427 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 427 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 427 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 427 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 427 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 427 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 427 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 427 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 427 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 427 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 427 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 427 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 427 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 427 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 262 => 'Description', 402 => 'description', 424 => 'Description' },
	'destination' => { 115 => 0x5 },
	'destinationcity' => { 303 => 0x24, 309 => 0x3 },
	'destinationcitycode' => { 310 => 0x1001 },
	'destinationdst' => { 303 => 0x26, 309 => '0.3' },
	'developmentdynamicrange' => { 111 => 0x1403 },
	'device' => { 416 => 'device' },
	'devicesettingdescription' => { 405 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 405 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 405 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 405 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 334 => 0x2 },
	'dialdirectiontvav' => { 73 => 0x706 },
	'dietaryneeds' => { 418 => 'dietaryNeeds' },
	'diffractioncorrection' => { 293 => 0x3 },
	'digitalcreationdate' => { 114 => 0x3e },
	'digitalcreationtime' => { 114 => 0x3f },
	'digitaldeehighlightadj' => { 200 => 0x202 },
	'digitaldeeshadowadj' => { 200 => 0x200 },
	'digitaldeethreshold' => { 200 => 0x201 },
	'digitalfilter' => { 337 => 0x59 },
	'digitalfilter01' => { 290 => 0x5 },
	'digitalfilter02' => { 290 => 0x16 },
	'digitalfilter03' => { 290 => 0x27 },
	'digitalfilter04' => { 290 => 0x38 },
	'digitalfilter05' => { 290 => 0x49 },
	'digitalfilter06' => { 290 => 0x5a },
	'digitalfilter07' => { 290 => 0x6b },
	'digitalfilter08' => { 290 => 0x7c },
	'digitalfilter09' => { 290 => 0x8d },
	'digitalfilter10' => { 290 => 0x9e },
	'digitalfilter11' => { 290 => 0xaf },
	'digitalfilter12' => { 290 => 0xc0 },
	'digitalfilter13' => { 290 => 0xd1 },
	'digitalfilter14' => { 290 => 0xe2 },
	'digitalfilter15' => { 290 => 0xf3 },
	'digitalfilter16' => { 290 => 0x104 },
	'digitalfilter17' => { 290 => 0x115 },
	'digitalfilter18' => { 290 => 0x126 },
	'digitalfilter19' => { 290 => 0x137 },
	'digitalfilter20' => { 290 => 0x148 },
	'digitalgain' => { 65 => 0xb },
	'digitalgem' => { 186 => 0x0 },
	'digitalice' => { 200 => 0x100 },
	'digitalimageguid' => { 411 => 'DigImageGUID' },
	'digitalroc' => { 198 => 0x0 },
	'digitalsourcefiletype' => { 411 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 411 => 'DigitalSourceType' },
	'digitalzoom' => { 31 => 0xc, 101 => 0xa, 122 => 0x68, 136 => 'DigitalZoom', 158 => 0xc, 194 => 0x86, 220 => 0xa, 255 => 0x204, 303 => 0x1e, 310 => 0xa, 336 => 0x204, 374 => 0x12, 375 => 0x12 },
	'digitalzoomon' => { 336 => 0x21b },
	'digitalzoomratio' => { 106 => 0xa404, 366 => 0x200, 368 => 0x21c, 405 => 'DigitalZoomRatio' },
	'director' => { 426 => 'director' },
	'directorphotography' => { 426 => 'directorPhotography' },
	'directory' => { 107 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 182 => 0x3 },
	'disclaimer' => { 262 => 'Disclaimer' },
	'discnumber' => { 426 => 'discNumber' },
	'dishtype' => { 418 => 'dishType' },
	'displayallafpoints' => { 73 => 0x514 },
	'displayaperture' => { 31 => 0x23 },
	'displayedunitsx' => { 318 => 0x2 },
	'displayedunitsy' => { 318 => 0x6 },
	'displayname' => { 415 => 'displayName' },
	'distance1' => { 122 => 0x28 },
	'distance2' => { 122 => 0x2c },
	'distance3' => { 122 => 0x30 },
	'distance4' => { 122 => 0x34 },
	'distortion' => { 334 => 0xa050 },
	'distortioncontrol' => { 201 => 0x10 },
	'distortioncorrection' => { 92 => 0x20705, 98 => 0x67, 250 => 0x50b, 273 => '7.1', 293 => 0x0, 381 => 0x601, 382 => 0x5b },
	'distortioncorrection2' => { 254 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 397 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 92 => '0x20705.0', 98 => 0x63 },
	'distortioncorrectionsetting' => { 357 => 0x2013 },
	'distortioneffect' => { 92 => 0x20709 },
	'distortionn' => { 273 => 0xc },
	'distortionparam02' => { 273 => 0x2 },
	'distortionparam04' => { 273 => 0x4 },
	'distortionparam08' => { 273 => 0x8 },
	'distortionparam09' => { 273 => 0x9 },
	'distortionparam11' => { 273 => 0xb },
	'distortionscale' => { 273 => 0x5 },
	'distributor' => { 416 => 'distributor' },
	'distributorproductid' => { 415 => 'distributorProductID' },
	'dloon' => { 92 => '0x20706.0', 98 => 0xdc },
	'dlosetting' => { 92 => 0x20706, 98 => 0xdd },
	'dlosettingapplied' => { 91 => 0x4 },
	'dloshootingdistance' => { 98 => 0xde },
	'dloversion' => { 91 => 0x5 },
	'dmcomment' => { 426 => 'comment' },
	'dngadobedata' => { 106 => 0xc634 },
	'dngbackwardversion' => { 106 => 0xc613 },
	'dngignoresidecars' => { 401 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 106 => 0xc630 },
	'dngprivatedata' => { 106 => 0xc634 },
	'dngversion' => { 106 => 0xc612 },
	'document' => { 262 => 'Document' },
	'documentancestors' => { 413 => 'DocumentAncestors' },
	'documenthistory' => { 114 => 0xe7 },
	'documentid' => { 427 => 'DocumentID' },
	'documentname' => { 106 => 0x10d },
	'documentnotes' => { 114 => 0xe6 },
	'doi' => { 416 => 'doi' },
	'dotrange' => { 106 => 0x150 },
	'dpp' => { 395 => 'dpp' },
	'dr4cameramodel' => { 93 => 0x3 },
	'drivemode' => { 102 => 0x3103, 158 => 0x6, 161 => 0x1e, 164 => 0xe, 250 => 0x600, 303 => 0x34, 328 => 0x1002, 337 => 0x3, 345 => 0x4, 346 => 0x7e, 347 => 0x34 },
	'drivemode2' => { 161 => 0xa, 284 => 0x7, 356 => 0xe, 361 => 0x1 },
	'drivemodesetting' => { 347 => 0x4 },
	'dspfirmwareversion' => { 303 => 0x27 },
	'duration' => { 58 => 0x6a, 135 => 'Duration', 149 => 'Duration', 418 => 'duration', 426 => 'duration' },
	'durationscale' => { 426 => [\'duration','durationScale'] },
	'durationvalue' => { 426 => [\'duration','durationValue'] },
	'dustremovaldata' => { 55 => 0x97 },
	'dynamicafarea' => { 237 => '1.4', 243 => '1.4' },
	'dynamicareaafdisplay' => { 238 => '46.1', 247 => '47.1' },
	'dynamicrange' => { 111 => 0x1400 },
	'dynamicrangeexpansion' => { 303 => 0x69, 328 => 0x100e },
	'dynamicrangemax' => { 97 => 0x7c },
	'dynamicrangemin' => { 97 => 0x7a },
	'dynamicrangeoptimizer' => { 161 => 0x15, 357 => [0xb025,0xb04f], 364 => 0x1144, 365 => [0x1144,0x324], 366 => [0x1120,0x300], 367 => [0x119c,0x37c], 368 => [0x1178,0x328], 369 => [0x1030,0x50], 370 => [0x228,0x50], 371 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 356 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 345 => 0x19, 346 => 0x17, 347 => 0xd, 356 => 0x79, 361 => 0x5 },
	'dynamicrangeoptimizermode' => { 164 => 0x15, 345 => 0x18, 346 => 0x16, 356 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 161 => 0x27, 347 => 0xc, 361 => 0x4 },
	'dynamicrangesetting' => { 111 => 0x1402 },
	'e-dialinprogram' => { 284 => '1.3' },
	'earliestageorloweststage' => { 105 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 105 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 248 => '6.1' },
	'easyexposurecompensation' => { 237 => '6.4', 238 => '6.5', 243 => '4.4', 244 => '5.2', 247 => '6.3' },
	'easymode' => { 31 => 0xb },
	'edgenoisereduction' => { 231 => 0x4, 386 => 0x8028 },
	'edition' => { 416 => 'edition' },
	'editorialupdate' => { 114 => 0x8 },
	'editstatus' => { 114 => 0x7, 315 => 'EditStatus', 395 => 'EditStatus' },
	'editversionname' => { 230 => 0x3d136244 },
	'effectivelv' => { 303 => 0x2d },
	'effectivemaxaperture' => { 190 => 0x12, 191 => 0x13 },
	'eissn' => { 416 => 'eIssn' },
	'electronicfront-curtainshutter' => { 247 => '5.3' },
	'elevation' => { 145 => 'Elevation' },
	'email' => { 137 => 'EMail' },
	'embargodate' => { 419 => 'embargoDate' },
	'embdencrightsexpr' => { 411 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 411 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 411 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 411 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 413 => 'EmbeddedXMPDigest' },
	'emissivity' => { 108 => 0x3 },
	'encryptionkey' => { 334 => 0xa020 },
	'endingpage' => { 416 => 'endingPage' },
	'enduser' => { 414 => 'EndUser' },
	'enduserid' => { 414 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 414 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 426 => 'engineer' },
	'enhancedarktones' => { 223 => 0x8 },
	'enhancement' => { 101 => 0x16, 102 => 0x3016 },
	'enhancer' => { 254 => 0x300 },
	'enhancervalues' => { 254 => 0x301 },
	'envelopenumber' => { 115 => 0x28 },
	'envelopepriority' => { 115 => 0x3c },
	'enveloperecordversion' => { 115 => 0x0 },
	'epsonimageheight' => { 255 => 0x20c },
	'epsonimagewidth' => { 255 => 0x20b },
	'epsonsoftware' => { 255 => 0x20d },
	'equipmentinstitution' => { 388 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 388 => 'EquipmentManufacturer' },
	'equipmentversion' => { 251 => 0x0 },
	'ettlii' => { 73 => 0x304, 74 => 0xd, 75 => 0xe, 76 => 0x7, 77 => 0x7, 78 => 0xe },
	'event' => { 389 => 'Event', 393 => 'Event', 411 => 'Event', 416 => 'event' },
	'eventalias' => { 415 => 'eventAlias' },
	'eventday' => { 105 => [\'Event','EventDay'] },
	'eventearliestdate' => { 105 => [\'Event','EventEarliestDate'] },
	'eventend' => { 415 => 'eventEnd' },
	'eventenddayofyear' => { 105 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 105 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 105 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 105 => [\'Event','EventHabitat'] },
	'eventid' => { 105 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 105 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 105 => [\'Event','EventMonth'] },
	'eventnumber' => { 324 => 0x9 },
	'eventremarks' => { 105 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 105 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 105 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 415 => 'eventStart' },
	'eventstartdayofyear' => { 105 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 415 => 'eventSubtype' },
	'eventtime' => { 105 => [\'Event','EventEventTime'] },
	'eventtype' => { 415 => 'eventType' },
	'eventverbatimeventdate' => { 105 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 105 => [\'Event','EventYear'] },
	'evsteps' => { 284 => '1.2', 286 => 0x0 },
	'evstepsize' => { 240 => '5.1', 241 => '6.1', 242 => '6.1', 245 => '0.7' },
	'exclusivityenddate' => { 419 => 'exclusivityEndDate' },
	'excursiontolerance' => { 116 => 0x82 },
	'exif' => { 107 => 'EXIF' },
	'exifbyteorder' => { 107 => 'ExifByteOrder' },
	'exifcamerainfo' => { 114 => 0xe8 },
	'exifimageheight' => { 106 => 0xa003, 405 => 'PixelYDimension' },
	'exifimagewidth' => { 106 => 0xa002, 405 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 107 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 106 => 0x9000, 405 => 'ExifVersion' },
	'exitpupilposition' => { 190 => 0x4, 191 => 0x4 },
	'expirationdate' => { 114 => 0x25, 419 => 'expirationDate' },
	'expirationtime' => { 114 => 0x26 },
	'exposure' => { 106 => 0xfe51, 401 => 'Exposure' },
	'exposure2012' => { 401 => 'Exposure2012' },
	'exposureadj' => { 228 => 0x0 },
	'exposureadj2' => { 228 => 0x12 },
	'exposureadjust' => { 337 => 0xc },
	'exposurebracketingindicatorlast' => { 161 => 0x52 },
	'exposurebracketshotnumber' => { 164 => 0x2d, 356 => 0x2f },
	'exposurebracketstepsize' => { 284 => 0x8 },
	'exposurebracketvalue' => { 194 => 0x19 },
	'exposurecompensation' => { 67 => 0x6, 82 => 0x0, 106 => 0x9204, 122 => 0x24, 136 => 'ExposureComp', 154 => 'ExposureCompensation', 158 => 0xd, 159 => 0x53, 160 => 0x1e, 164 => 0x49c0, 255 => 0x1006, 303 => 0x16, 312 => 0x402, 334 => 0xa013, 337 => [0xc,0x35,0x4d], 364 => 0x114c, 365 => 0x114c, 366 => 0x1128, 368 => 0x1180, 369 => 0x1038, 370 => 0x230, 371 => 0x230, 405 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 361 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 161 => 0x47, 164 => 0x2a },
	'exposurecompensationset' => { 345 => 0x3, 346 => 0x3, 347 => 0x3, 361 => 0x1e },
	'exposurecompensationsetting' => { 161 => 0x1 },
	'exposurecompstepsize' => { 237 => '6.3', 238 => '7.3', 243 => '4.3', 247 => '7.3' },
	'exposurecontrolstep' => { 244 => '6.1' },
	'exposurecontrolstepsize' => { 237 => '6.2', 238 => '7.1', 243 => '4.2', 247 => '7.1', 248 => '7.1' },
	'exposurecount' => { 111 => 0x1032 },
	'exposuredelaymode' => { 237 => '10.1', 238 => '11.1', 240 => '9.1', 241 => '10.1', 242 => '10.1', 243 => '10.4', 244 => '10.1', 245 => '6.4', 247 => '11.1', 248 => '11.2' },
	'exposuredifference' => { 194 => 0xe },
	'exposureindex' => { 106 => 0xa215, 405 => 'ExposureIndex' },
	'exposureindicator' => { 161 => 0x50 },
	'exposurelevelincrements' => { 71 => 0x6, 72 => 0x6, 73 => 0x101, 74 => 0x5, 75 => 0x6, 76 => 0x5, 77 => 0x5, 78 => 0x6, 79 => 0x4, 345 => 0x58, 346 => 0x58 },
	'exposurelockused' => { 390 => 'ExposureLockUsed' },
	'exposuremode' => { 106 => 0xa402, 136 => 'ExposureMode', 158 => 0x1, 159 => 0xa, 160 => 0x0, 161 => 0x0, 164 => 0x34, 250 => 0x200, 268 => 0x40d, 337 => 0x8, 357 => 0xb041, 405 => 'ExposureMode' },
	'exposuremodeinmanual' => { 73 => 0x10b },
	'exposureprogram' => { 106 => 0x8822, 328 => 0x1001, 338 => [0x17e,0x43], 345 => 0x3c, 346 => 0x3c, 347 => 0x5, 351 => 0x14, 356 => 0x3f, 361 => 0x2, 364 => 0x1175, 365 => 0x1179, 366 => 0x1155, 367 => 0x11d1, 368 => 0x11ad, 369 => 0x1065, 370 => 0x25d, 371 => 0x25d, 382 => 0x48, 405 => 'ExposureProgram' },
	'exposureshift' => { 250 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 67 => 0x16, 106 => 0x829a, 119 => 0xfd05, 122 => 0x20, 124 => 0xfa24, 126 => 0xf104, 129 => 0x12, 131 => 0x38, 134 => 0x10, 136 => 'ExposureTime', 158 => 0x9, 159 => 0x35, 160 => 0x48, 161 => 0x8, 164 => 0x49b8, 303 => 0x12, 334 => 0xa018, 337 => [0x32,0x4a], 345 => 0x0, 346 => 0x0, 361 => [0x21,0x23,0x27], 382 => 0x10, 405 => 'ExposureTime' },
	'exposuretime2' => { 337 => [0x33,0x4b] },
	'exposuretuning' => { 194 => 0x1c },
	'exposurevalue' => { 120 => 0x3 },
	'exposurewarning' => { 111 => 0x1302 },
	'exrauto' => { 111 => 0x1033 },
	'exrmode' => { 111 => 0x1034 },
	'extendedwbdetect' => { 250 => 0x902 },
	'extender' => { 251 => 0x301 },
	'extenderfirmwareversion' => { 251 => 0x304 },
	'extendermagnification' => { 138 => 'Magnification' },
	'extendermake' => { 138 => 'Make' },
	'extendermodel' => { 138 => 'Model', 251 => 0x303 },
	'extenderserialnumber' => { 138 => 'SerialNumber', 251 => 0x302 },
	'extenderstatus' => { 301 => 0x3 },
	'externalflash' => { 253 => 0x1201 },
	'externalflashae1' => { 255 => 0x101f },
	'externalflashae1_0' => { 255 => 0x101b },
	'externalflashae2' => { 255 => 0x1020 },
	'externalflashae2_0' => { 255 => 0x101c },
	'externalflashbounce' => { 253 => 0x1204, 255 => 0x1026, 291 => 0x1a },
	'externalflashcompensation' => { 185 => 0x1b },
	'externalflashexposurecomp' => { 194 => 0x17, 291 => 0x19 },
	'externalflashfirmware' => { 183 => 0x6, 184 => 0x6, 185 => 0x6 },
	'externalflashflags' => { 183 => 0x8, 184 => 0x8, 185 => 0x8 },
	'externalflashguidenumber' => { 253 => 0x1203, 291 => '24.1' },
	'externalflashgvalue' => { 255 => 0x1025 },
	'externalflashmode' => { 255 => 0x1028, 291 => 0x2 },
	'externalflashzoom' => { 253 => 0x1205, 255 => 0x1027 },
	'externalsensorbrightnessvalue' => { 266 => 0x311, 272 => 0x3408 },
	'extrainfoversion' => { 349 => 0x1a },
	'eyestartaf' => { 161 => 0x40 },
	'face10position' => { 99 => 0x3f4, 100 => 0x1ec, 181 => 0x28, 288 => 0x12 },
	'face10size' => { 289 => 0x12 },
	'face11position' => { 181 => 0x2c, 288 => 0x14 },
	'face11size' => { 289 => 0x14 },
	'face12position' => { 181 => 0x30, 288 => 0x16 },
	'face12size' => { 289 => 0x16 },
	'face13position' => { 288 => 0x18 },
	'face13size' => { 289 => 0x18 },
	'face14position' => { 288 => 0x1a },
	'face14size' => { 289 => 0x1a },
	'face15position' => { 288 => 0x1c },
	'face15size' => { 289 => 0x1c },
	'face16position' => { 288 => 0x1e },
	'face16size' => { 289 => 0x1e },
	'face17position' => { 288 => 0x20 },
	'face17size' => { 289 => 0x20 },
	'face18position' => { 288 => 0x22 },
	'face18size' => { 289 => 0x22 },
	'face19position' => { 288 => 0x24 },
	'face19size' => { 289 => 0x24 },
	'face1position' => { 46 => 0x8, 99 => 0xd, 100 => 0x18, 181 => 0x4, 264 => 0x1, 288 => 0x0, 325 => 0xbc, 352 => 0x1, 353 => 0x0, 354 => 0x0, 355 => 0x5b },
	'face1size' => { 289 => 0x0 },
	'face20position' => { 288 => 0x26 },
	'face20size' => { 289 => 0x26 },
	'face21position' => { 288 => 0x28 },
	'face21size' => { 289 => 0x28 },
	'face22position' => { 288 => 0x2a },
	'face22size' => { 289 => 0x2a },
	'face23position' => { 288 => 0x2c },
	'face23size' => { 289 => 0x2c },
	'face24position' => { 288 => 0x2e },
	'face24size' => { 289 => 0x2e },
	'face25position' => { 288 => 0x30 },
	'face25size' => { 289 => 0x30 },
	'face26position' => { 288 => 0x32 },
	'face26size' => { 289 => 0x32 },
	'face27position' => { 288 => 0x34 },
	'face27size' => { 289 => 0x34 },
	'face28position' => { 288 => 0x36 },
	'face28size' => { 289 => 0x36 },
	'face29position' => { 288 => 0x38 },
	'face29size' => { 289 => 0x38 },
	'face2position' => { 46 => 0xa, 99 => 0x7c, 100 => 0x4c, 181 => 0x8, 264 => 0x5, 288 => 0x2, 325 => 0xc8, 352 => 0x6, 353 => 0x20, 354 => 0x25, 355 => 0x65 },
	'face2size' => { 289 => 0x2 },
	'face30position' => { 288 => 0x3a },
	'face30size' => { 289 => 0x3a },
	'face31position' => { 288 => 0x3c },
	'face31size' => { 289 => 0x3c },
	'face32position' => { 288 => 0x3e },
	'face32size' => { 289 => 0x3e },
	'face3position' => { 46 => 0xc, 99 => 0xeb, 100 => 0x80, 181 => 0xc, 264 => 0x9, 288 => 0x4, 325 => 0xd4, 352 => 0xb, 353 => 0x40, 354 => 0x4a, 355 => 0x6f },
	'face3size' => { 289 => 0x4 },
	'face4position' => { 46 => 0xe, 99 => 0x15a, 100 => 0xb4, 181 => 0x10, 264 => 0xd, 288 => 0x6, 325 => 0xe0, 352 => 0x10, 353 => 0x60, 354 => 0x6f, 355 => 0x79 },
	'face4size' => { 289 => 0x6 },
	'face5position' => { 46 => 0x10, 99 => 0x1c9, 100 => 0xe8, 181 => 0x14, 264 => 0x11, 288 => 0x8, 325 => 0xec, 352 => 0x15, 353 => 0x80, 354 => 0x94 },
	'face5size' => { 289 => 0x8 },
	'face6position' => { 46 => 0x12, 99 => 0x238, 100 => 0x11c, 181 => 0x18, 288 => 0xa, 325 => 0xf8, 352 => 0x1a, 353 => 0xa0, 354 => 0xb9 },
	'face6size' => { 289 => 0xa },
	'face7position' => { 46 => 0x14, 99 => 0x2a7, 100 => 0x150, 181 => 0x1c, 288 => 0xc, 325 => 0x104, 352 => 0x1f, 353 => 0xc0, 354 => 0xde },
	'face7size' => { 289 => 0xc },
	'face8position' => { 46 => 0x16, 99 => 0x316, 100 => 0x184, 181 => 0x20, 288 => 0xe, 325 => 0x110, 352 => 0x24, 353 => 0xe0, 354 => 0x103 },
	'face8size' => { 289 => 0xe },
	'face9position' => { 46 => 0x18, 99 => 0x385, 100 => 0x1b8, 181 => 0x24, 288 => 0x10 },
	'face9size' => { 289 => 0x10 },
	'facedetect' => { 303 => 0x76, 334 => 0x100 },
	'facedetectarea' => { 254 => 0x1201 },
	'facedetectframecrop' => { 254 => 0x1207 },
	'facedetectframesize' => { 46 => 0x3, 99 => 0x1, 100 => 0x4, 181 => 0x1, 254 => 0x1203, 303 => 0x77, 325 => 0xb6 },
	'facedetection' => { 347 => 0x30, 361 => 0x19 },
	'faceid' => { 396 => 'FaceID' },
	'faceinfounknown' => { 102 => 0x2089 },
	'facename' => { 334 => 0x123 },
	'faceorientation' => { 100 => 0x8 },
	'faceposition' => { 287 => 0x2, 335 => 0x4 },
	'facepositions' => { 111 => 0x4103 },
	'facerecognition' => { 334 => 0x120 },
	'facesdetected' => { 46 => 0x2, 47 => 0x2, 48 => 0x3, 99 => 0x0, 100 => 0x2, 102 => 0x211c, 111 => 0x4100, 181 => 0x3, 254 => 0x1200, 270 => 0x3f, 287 => 0x0, 325 => 0xb5, 335 => 0x0, 352 => 0x0, 355 => 0x3, 363 => 0x30 },
	'facesrecognized' => { 265 => 0x0 },
	'facewidth' => { 47 => 0x1 },
	'faithfuloutputhighlightpoint' => { 98 => 0x38 },
	'faithfuloutputshadowpoint' => { 98 => 0x39 },
	'faithfulrawcolortone' => { 98 => 0x31 },
	'faithfulrawcontrast' => { 98 => 0x33 },
	'faithfulrawhighlight' => { 98 => 0x79 },
	'faithfulrawhighlightpoint' => { 98 => 0x36 },
	'faithfulrawlinear' => { 98 => 0x34 },
	'faithfulrawsaturation' => { 98 => 0x32 },
	'faithfulrawshadow' => { 98 => 0x82 },
	'faithfulrawshadowpoint' => { 98 => 0x37 },
	'faithfulrawsharpness' => { 98 => 0x35 },
	'faithfulunsharpmaskfineness' => { 98 => 0xac },
	'faithfulunsharpmaskstrength' => { 98 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 98 => 0xae },
	'femicroadjustment' => { 73 => 0x111 },
	'ffid' => { 403 => 'ffid' },
	'field' => { 415 => 'field' },
	'fieldcount' => { 255 => 0x103f },
	'filecreatedate' => { 107 => 'FileCreateDate' },
	'filedatarate' => { 426 => 'fileDataRate' },
	'fileformat' => { 84 => 0x0, 115 => 0x14, 337 => [0x22,0x26], 357 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 271 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 107 => 'FileModifyDate' },
	'filename' => { 107 => 'FileName' },
	'filenameasdelivered' => { 414 => 'FileNameAsDelivered' },
	'filenumber' => { 49 => 0x1, 55 => 0x8, 86 => 0x1817, 103 => 'FileNumber', 182 => 0x4 },
	'filenumbermemory' => { 158 => 0x1a },
	'filenumbersequence' => { 237 => '12.2', 240 => '3.1', 241 => '4.1', 242 => '4.1', 243 => '11.1', 244 => '4.3', 248 => '5.2' },
	'filesource' => { 106 => 0xa300, 111 => 0x8000, 405 => 'FileSource' },
	'fileversion' => { 115 => 0x16 },
	'fillflashautoreduction' => { 71 => 0xe, 72 => 0xe, 79 => 0xa },
	'filllight' => { 401 => 'FillLight' },
	'fillorder' => { 106 => 0x10a },
	'filmmode' => { 111 => 0x1401, 268 => 0x412, 270 => 0x42 },
	'filmtype' => { 200 => 0x2 },
	'filtereffect' => { 49 => 0xe, 196 => 0x37 },
	'filtereffectauto' => { 62 => 0xa0 },
	'filtereffectfaithful' => { 61 => 0x70, 62 => 0x70 },
	'filtereffectlandscape' => { 61 => 0x40, 62 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 61 => 0x88, 62 => 0x88 },
	'filtereffectneutral' => { 61 => 0x58, 62 => 0x58 },
	'filtereffectportrait' => { 61 => 0x28, 62 => 0x28 },
	'filtereffectstandard' => { 61 => 0x10, 62 => 0x10 },
	'filtereffectuserdef1' => { 61 => 0xa0, 62 => 0xb8 },
	'filtereffectuserdef2' => { 61 => 0xb8, 62 => 0xd0 },
	'filtereffectuserdef3' => { 61 => 0xd0, 62 => 0xe8 },
	'finderdisplayduringexposure' => { 72 => 0x1 },
	'finesharpness' => { 303 => 0x70 },
	'finetuneoptcenterweighted' => { 237 => '7.2', 238 => '9.1', 247 => '9.1', 248 => '9.1' },
	'finetuneopthighlightweighted' => { 247 => '46.1' },
	'finetuneoptmatrixmetering' => { 237 => '8.1', 238 => '8.2', 243 => '6.1', 247 => '8.2', 248 => '8.2' },
	'finetuneoptspotmetering' => { 237 => '8.2', 238 => '9.2', 243 => '6.2', 247 => '9.2', 248 => '9.2' },
	'firmware' => { 255 => 0x405, 337 => [0x17,0x3b,0x57], 397 => 'Firmware' },
	'firmwaredate' => { 101 => 0x15, 102 => 0x2001, 324 => 0x4 },
	'firmwareid' => { 165 => 0x0 },
	'firmwarename' => { 334 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 55 => 0x1e, 326 => 0x0 },
	'firmwarerevision2' => { 326 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 120 => 0xce5, 134 => 0x57, 136 => 'FirmwareVersion', 270 => 0x2, 272 => 0x3109, 303 => 0x230, 328 => 0x2 },
	'firmwareversions' => { 312 => 0x301 },
	'firstphotodate' => { 390 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 414 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 114 => 0x16, 395 => 'FixtureIdentifier' },
	'flash' => { 103 => 'Flash', 106 => 0x9209, 159 => 0x1f, 160 => 0x15, 405 => 'Flash' },
	'flashaction' => { 345 => 0x3e, 346 => 0x3e, 357 => 0x2017, 361 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 345 => 0x4c, 346 => 0x4c, 361 => 0x77 },
	'flashactionexternal' => { 361 => [0x78,0x7c] },
	'flashactivity' => { 31 => 0x1c },
	'flashbatterylevel' => { 37 => 0x249 },
	'flashbias' => { 270 => 0x24 },
	'flashbits' => { 31 => 0x1d },
	'flashbuttonfunction' => { 73 => 0x70e },
	'flashchargelevel' => { 255 => 0x1010 },
	'flashcolorfilter' => { 185 => 0x10 },
	'flashcommandermode' => { 183 => '9.1', 184 => '9.1', 185 => '9.1' },
	'flashcompensation' => { 183 => 0xa, 184 => 0xa, 185 => 0xa, 397 => 'FlashCompensation' },
	'flashcontrol' => { 345 => 0x23, 346 => 0x1f, 347 => 0x21 },
	'flashcontrolbuilt-in' => { 243 => '16.1', 244 => '23.1', 246 => '23.1', 247 => '24.1' },
	'flashcontrolmode' => { 183 => '9.2', 184 => '9.2', 185 => '9.2', 250 => 0x404 },
	'flashcurtain' => { 270 => 0x48 },
	'flashdefault' => { 161 => 0x42 },
	'flashdevice' => { 255 => 0x1005 },
	'flashdistance' => { 102 => 0x2034 },
	'flashenergy' => { 106 => 0xa20b, 405 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 194 => 0x18 },
	'flashexposurecomp' => { 67 => 0xf, 111 => 0x1011, 139 => 'ExposureComp', 158 => 0x23, 163 => 0x104, 164 => 0x49c1, 194 => 0x12, 250 => 0x401, 255 => 0x1023, 303 => 0x4d, 328 => 0x100b, 337 => [0x3a,0x56], 357 => 0x104 },
	'flashexposurecomp2' => { 217 => 0x4d2 },
	'flashexposurecomp3' => { 185 => 0x1d },
	'flashexposurecomp4' => { 185 => 0x27 },
	'flashexposurecomparea' => { 238 => '38.4', 247 => '38.4' },
	'flashexposurecompset' => { 161 => 0x10, 277 => 0xe, 345 => 0x14, 346 => 0x12, 347 => 0x23, 361 => 0x1f },
	'flashexposurecompset2' => { 361 => [0x26,0x2c] },
	'flashexposureindicator' => { 161 => 0x54 },
	'flashexposureindicatorlast' => { 161 => 0x56 },
	'flashexposureindicatornext' => { 161 => 0x55 },
	'flashexposurelock' => { 49 => 0x19 },
	'flashfired' => { 122 => 0x5d, 139 => 'Fired', 158 => 0x14, 216 => '590.3', 270 => 0x8007, 405 => [\'Flash','FlashFired'] },
	'flashfiring' => { 73 => 0x306, 74 => 0x6, 75 => 0x7, 78 => 0x7 },
	'flashfirmwareversion' => { 251 => 0x1002 },
	'flashfocallength' => { 183 => 0xb, 184 => 0xc, 185 => 0xc },
	'flashfunction' => { 164 => 0x31, 405 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 183 => 0xe, 184 => 0xf, 185 => 0xf },
	'flashgroupacompensation' => { 183 => 0x11, 184 => 0x12, 185 => 0x13 },
	'flashgroupacontrolmode' => { 183 => 0xf, 184 => '16.1', 185 => '17.1' },
	'flashgroupaoutput' => { 183 => 0x11, 184 => 0x12, 185 => 0x13 },
	'flashgroupbcompensation' => { 183 => 0x12, 184 => 0x13, 185 => 0x14 },
	'flashgroupbcontrolmode' => { 183 => 0x10, 184 => '17.1', 185 => '18.1' },
	'flashgroupboutput' => { 183 => 0x12, 184 => 0x13, 185 => 0x14 },
	'flashgroupccompensation' => { 184 => 0x14, 185 => 0x15 },
	'flashgroupccontrolmode' => { 184 => '17.2', 185 => '18.2' },
	'flashgroupcoutput' => { 184 => 0x14, 185 => 0x15 },
	'flashguidenumber' => { 67 => 0xd, 83 => 0x0, 139 => 'GuideNumber' },
	'flashintensity' => { 101 => [0x19,0x5], 250 => 0x405 },
	'flashlevel' => { 239 => 0x9, 357 => 0xb048 },
	'flashmake' => { 139 => 'Make' },
	'flashmanufacturer' => { 156 => 'FlashManufacturer' },
	'flashmetering' => { 158 => 0x3f, 161 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 303 => 0x20a },
	'flashmode' => { 101 => 0x4, 122 => 0x5c, 139 => 'Mode', 158 => 0x2, 159 => 0x20, 160 => 0x16, 161 => 0xf, 194 => 0x87, 250 => 0x400, 255 => 0x1004, 303 => 0xc, 310 => 0x4, 327 => 0x20, 328 => 0x100a, 336 => 0x225, 345 => 0x13, 346 => 0x7f, 347 => 0x20, 361 => 0x10, 364 => 0x1138, 365 => 0x1138, 366 => 0x1114, 367 => 0x1190, 368 => 0x116c, 369 => 0x1024, 370 => 0x21c, 371 => 0x21c, 405 => [\'Flash','FlashMode'] },
	'flashmodel' => { 139 => 'Model', 156 => 'FlashModel', 251 => 0x1001 },
	'flashoptions' => { 284 => 0x2 },
	'flashoptions2' => { 284 => 0x10 },
	'flashoutput' => { 37 => 0x248, 67 => 0x21, 183 => 0xa, 184 => 0xa, 185 => 0xa },
	'flashpixversion' => { 106 => 0xa000, 405 => 'FlashpixVersion' },
	'flashredeyemode' => { 405 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 250 => 0x403 },
	'flashreturn' => { 405 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 139 => 'SerialNumber', 251 => 0x1003 },
	'flashsetting' => { 194 => 0x8 },
	'flashshutterspeed' => { 237 => '20.2', 238 => '23.2', 243 => '15.2', 244 => '22.2', 245 => '7.2', 246 => '22.2', 247 => '23.2', 248 => '23.1' },
	'flashsource' => { 183 => 0x4, 184 => 0x4, 185 => 0x4 },
	'flashstatus' => { 291 => 0x0, 361 => [0x82,0x86], 373 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 347 => [0x87,0x287] },
	'flashstatusexternal' => { 347 => [0x88,0x288] },
	'flashsyncspeed' => { 237 => '20.1', 238 => '23.1', 243 => '15.1', 244 => '22.1', 246 => '22.1', 247 => '23.1' },
	'flashsyncspeedav' => { 71 => 0x3, 73 => 0x10f, 74 => 0x2, 75 => 0x3, 76 => 0x2, 77 => 0x2, 78 => 0x3, 79 => 0x6 },
	'flashthreshold' => { 83 => 0x1 },
	'flashtype' => { 139 => 'Type', 161 => 0x59, 194 => 0x9, 251 => 0x1000 },
	'flashwarning' => { 244 => '30.1', 245 => '7.1', 248 => '31.1', 270 => 0x62 },
	'flexiblespotposition' => { 357 => 0x201d },
	'flickerreduce' => { 336 => 0x218 },
	'fliphorizontal' => { 230 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 67 => 0x15, 106 => 0x829d, 119 => 0xfd04, 122 => 0x1e, 124 => 0xfa23, 126 => 0xf103, 129 => 0x13, 131 => 0x3c, 134 => 0xc, 143 => 'FNumber', 158 => 0xa, 159 => 0x36, 160 => 0x47, 161 => 0x9, 164 => 0x49c7, 303 => 0x13, 334 => 0xa019, 337 => [0x31,0x49], 345 => 0x1, 346 => 0x1, 361 => [0x20,0x22,0x26], 405 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 51 => 0x1, 102 => 0x1d, 106 => 0x920a, 129 => 0x1d, 143 => 'FocalLength', 158 => 0x12, 190 => 0xa, 191 => 0xb, 303 => 0x1d, 312 => 0x403, 328 => 0x1500, 344 => 0xe, 368 => 0x1278, 369 => 0x1134, 370 => 0x32c, 371 => 0x32c, 405 => 'FocalLength' },
	'focallength2' => { 361 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 106 => 0xa405, 334 => 0xa01a, 405 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 344 => 0x10 },
	'focalplaneafpointarea' => { 372 => 0x2 },
	'focalplaneafpointlocation1' => { 372 => 0x6 },
	'focalplaneafpointlocation10' => { 372 => 0x2a },
	'focalplaneafpointlocation11' => { 372 => 0x2e },
	'focalplaneafpointlocation12' => { 372 => 0x32 },
	'focalplaneafpointlocation13' => { 372 => 0x36 },
	'focalplaneafpointlocation14' => { 372 => 0x3a },
	'focalplaneafpointlocation15' => { 372 => 0x3e },
	'focalplaneafpointlocation2' => { 372 => 0xa },
	'focalplaneafpointlocation3' => { 372 => 0xe },
	'focalplaneafpointlocation4' => { 372 => 0x12 },
	'focalplaneafpointlocation5' => { 372 => 0x16 },
	'focalplaneafpointlocation6' => { 372 => 0x1a },
	'focalplaneafpointlocation7' => { 372 => 0x1e },
	'focalplaneafpointlocation8' => { 372 => 0x22 },
	'focalplaneafpointlocation9' => { 372 => 0x26 },
	'focalplaneafpointsused' => { 372 => 0x1 },
	'focalplanediagonal' => { 251 => 0x103, 255 => 0x205 },
	'focalplaneresolutionunit' => { 106 => 0xa210, 405 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 106 => 0xa20e, 405 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 51 => 0x2 },
	'focalplanexunknown' => { 51 => 0x2 },
	'focalplaneyresolution' => { 106 => 0xa20f, 405 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 51 => 0x3 },
	'focalplaneyunknown' => { 51 => 0x3 },
	'focaltype' => { 9 => 0x2d, 51 => 0x0 },
	'focalunits' => { 31 => 0x19 },
	'focus' => { 220 => 0x8 },
	'focusarea' => { 158 => 0x31 },
	'focusareaselection' => { 245 => '15.2' },
	'focuscontinuous' => { 31 => 0x20 },
	'focusdisplayaiservoandmf' => { 73 => 0x515 },
	'focusdistance' => { 143 => 'FocusDistance', 158 => 0x13, 164 => 0x49bb, 190 => 0x9, 191 => 0xa, 253 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 49 => 0x15, 67 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 49 => 0x14, 67 => 0x13 },
	'focusholdbutton' => { 161 => 0x44 },
	'focusinfoversion' => { 253 => 0x0 },
	'focusingscreen' => { 72 => 0x0, 73 => 0x80b, 78 => 0x0 },
	'focuslocation' => { 357 => 0x2027 },
	'focuslocked' => { 157 => 0x14 },
	'focusmode' => { 31 => 0x7, 101 => 0x3, 102 => [0x3003,0xd], 111 => 0x1021, 122 => 0x38, 136 => 'FocusMode', 158 => 0x30, 160 => 0xe, 161 => 0xc, 194 => 0x7, 250 => 0x301, 255 => 0x100b, 270 => 0x7, 303 => 0xd, 310 => 0x3, 328 => 0x1006, 338 => [0xb,0x5], 344 => [0x15,0x1d], 345 => 0x4d, 346 => 0x4d, 357 => [0xb042,0xb04e,0x201b], 361 => 0x13, 377 => 0x16 },
	'focusmode2' => { 284 => '3.1', 361 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 239 => '10.1', 342 => 0x14, 343 => 0x15, 345 => 0x10, 346 => 0xf, 347 => 0x6 },
	'focusmodeswitch' => { 161 => 0x58, 345 => 0x2e },
	'focuspixel' => { 111 => 0x1023 },
	'focuspointwrap' => { 237 => '2.2', 238 => '2.2', 243 => '2.2', 244 => '1.2', 247 => '2.2', 248 => '2.5' },
	'focusposition' => { 190 => 0x8, 191 => 0x8, 303 => 0x10, 356 => 0x9bb },
	'focusposition2' => { 361 => [0x29,0x2b,0x2f], 377 => 0x2d, 380 => 0x20 },
	'focusprocess' => { 250 => 0x302 },
	'focusrange' => { 31 => 0x12, 255 => 0x100a },
	'focusrangeindex' => { 294 => '3.1' },
	'focussetting' => { 337 => 0x6 },
	'focusstatus' => { 344 => 0x19, 345 => 0x53, 346 => 0x53 },
	'focusstepcount' => { 253 => 0x301, 255 => 0x100e },
	'focusstepinfinity' => { 253 => 0x303, 255 => 0x103b },
	'focusstepnear' => { 253 => 0x304, 255 => 0x103c },
	'focustrackinglockon' => { 237 => ['1.5','4.1'], 238 => '1.4', 243 => '3.1', 244 => '0.4', 247 => '1.4' },
	'focuswarning' => { 111 => 0x1301 },
	'foldername' => { 158 => 0x27 },
	'foldernumber' => { 345 => 0x9a, 347 => [0x402,0x114,0x316] },
	'fontcomposite' => { 431 => [\'Fonts','FontsComposite'] },
	'fontface' => { 431 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 431 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 431 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 431 => [\'Fonts','FontsFontName'] },
	'fonts' => { 431 => 'Fonts' },
	'fonttype' => { 431 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 431 => [\'Fonts','FontsVersionString'] },
	'for' => { 319 => 'For' },
	'format' => { 402 => 'format', 424 => 'Format' },
	'forwardlock' => { 421 => 'forwardlock' },
	'forwardmatrix1' => { 106 => 0xc714 },
	'forwardmatrix2' => { 106 => 0xc715 },
	'framecount' => { 58 => [0x2,0x4] },
	'frameheight' => { 111 => 0x3822 },
	'framenum' => { 314 => 0xd7 },
	'framenumber' => { 111 => 0x8003, 164 => 0x3c, 303 => 0x29 },
	'framerate' => { 58 => [0x1,0x6], 106 => 0xc764, 111 => 0x3820 },
	'framewidth' => { 111 => 0x3821 },
	'framing' => { 415 => 'framing' },
	'freebytes' => { 86 => 0x1 },
	'freememorycardimages' => { 159 => [0x37,0x54], 160 => [0x2d,0x4a], 161 => 0x32 },
	'fujiflashmode' => { 111 => 0x1010 },
	'fullimagesize' => { 357 => 0xb02b },
	'fullpanoheightpixels' => { 390 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 390 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 328 => 0x100d },
	'fullsizeimage' => { 142 => 'data' },
	'fullsizeimagename' => { 142 => '1Name' },
	'fullsizeimagetype' => { 142 => '0Type' },
	'funcbutton' => { 237 => ['14.1','15.1'], 238 => '14.1', 243 => '28.1', 244 => '13.1', 247 => '14.1', 248 => '14.1' },
	'funcbuttonplusdials' => { 237 => ['14.2','15.2'], 238 => '14.2', 243 => '31.1', 247 => '42.1' },
	'functionbutton' => { 242 => '13.1', 245 => '5.2' },
	'gainbase' => { 254 => 0x610 },
	'gaincontrol' => { 106 => 0xa407, 405 => 'GainControl' },
	'gamma' => { 106 => 0xa500, 406 => 'Gamma' },
	'gammablackpoint' => { 94 => 0xc },
	'gammacolortone' => { 94 => 0x3 },
	'gammacompensatedvalue' => { 116 => 0x91 },
	'gammacontrast' => { 94 => 0x2 },
	'gammacurveoutputrange' => { 94 => 0xf },
	'gammahighlight' => { 94 => 0xa },
	'gammalinear' => { 92 => 0x20200 },
	'gammamidpoint' => { 94 => 0xe },
	'gammasaturation' => { 94 => 0x4 },
	'gammashadow' => { 94 => 0x9 },
	'gammasharpnessstrength' => { 94 => 0x8 },
	'gammaunsharpmaskfineness' => { 94 => 0x6 },
	'gammaunsharpmaskstrength' => { 94 => 0x5 },
	'gammaunsharpmaskthreshold' => { 94 => 0x7 },
	'gammawhitepoint' => { 94 => 0xd },
	'geimagesize' => { 111 => 0x1304 },
	'gemake' => { 112 => 0x300 },
	'gemodel' => { 112 => 0x207 },
	'genre' => { 416 => 'genre', 426 => 'genre' },
	'geography' => { 417 => 'geography' },
	'geologicalcontext' => { 105 => 'GeologicalContext' },
	'geologicalcontextbed' => { 105 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 105 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 105 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 105 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 105 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 107 => 'Geosync' },
	'geotag' => { 107 => 'Geotag' },
	'geotiffasciiparams' => { 106 => 0x87b1 },
	'geotiffdirectory' => { 106 => 0x87af },
	'geotiffdoubleparams' => { 106 => 0x87b0 },
	'geotime' => { 107 => 'Geotime' },
	'globalaltitude' => { 317 => 0x419 },
	'globalangle' => { 317 => 0x40d },
	'good' => { 426 => 'good' },
	'googleplusuploadcode' => { 106 => 0x9009 },
	'gpsaltitude' => { 113 => 0x6, 140 => 'Altitude', 405 => 'GPSAltitude' },
	'gpsaltituderef' => { 113 => 0x5, 405 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 113 => 0x1c, 405 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 113 => 0x1d },
	'gpsdatetime' => { 140 => 'DateTime', 405 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 113 => 0x18, 140 => 'Bearing', 405 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 113 => 0x17, 405 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 113 => 0x1a, 140 => 'Distance', 405 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 113 => 0x19, 405 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 113 => 0x14, 405 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 113 => 0x13 },
	'gpsdestlongitude' => { 113 => 0x16, 405 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 113 => 0x15 },
	'gpsdifferential' => { 113 => 0x1e, 140 => 'Differential', 405 => 'GPSDifferential' },
	'gpsdop' => { 113 => 0xb, 405 => 'GPSDOP' },
	'gpshpositioningerror' => { 113 => 0x1f, 405 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 113 => 0x11, 405 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 113 => 0x10, 405 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 113 => 0x2, 140 => 'Latitude', 405 => 'GPSLatitude' },
	'gpslatituderef' => { 113 => 0x1 },
	'gpslongitude' => { 113 => 0x4, 140 => 'Longitude', 405 => 'GPSLongitude' },
	'gpslongituderef' => { 113 => 0x3 },
	'gpsmapdatum' => { 113 => 0x12, 140 => 'Datum', 405 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 113 => 0xa, 140 => 'MeasureMode', 405 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 113 => 0x1b, 405 => 'GPSProcessingMethod' },
	'gpssatellites' => { 113 => 0x8, 140 => 'Satellites', 405 => 'GPSSatellites' },
	'gpsspeed' => { 113 => 0xd, 140 => 'Speed', 405 => 'GPSSpeed' },
	'gpsspeedref' => { 113 => 0xc, 405 => 'GPSSpeedRef' },
	'gpsstatus' => { 113 => 0x9, 405 => 'GPSStatus' },
	'gpstimestamp' => { 113 => 0x7 },
	'gpstrack' => { 113 => 0xf, 140 => 'Heading', 405 => 'GPSTrack' },
	'gpstrackref' => { 113 => 0xe, 405 => 'GPSTrackRef' },
	'gpsversionid' => { 113 => 0x0, 405 => 'GPSVersionID' },
	'gradation' => { 250 => 0x50f },
	'gradientbasedcorractive' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 401 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 401 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 401 => 'GrainAmount' },
	'grainfrequency' => { 401 => 'GrainFrequency' },
	'grainsize' => { 401 => 'GrainSize' },
	'graymixeraqua' => { 401 => 'GrayMixerAqua' },
	'graymixerblue' => { 401 => 'GrayMixerBlue' },
	'graymixergreen' => { 401 => 'GrayMixerGreen' },
	'graymixermagenta' => { 401 => 'GrayMixerMagenta' },
	'graymixerorange' => { 401 => 'GrayMixerOrange' },
	'graymixerpurple' => { 401 => 'GrayMixerPurple' },
	'graymixerred' => { 401 => 'GrayMixerRed' },
	'graymixeryellow' => { 401 => 'GrayMixerYellow' },
	'graypoint' => { 386 => 0x8021 },
	'grayresponseunit' => { 106 => 0x122 },
	'greencurvelimits' => { 97 => 0x1c4 },
	'greencurvepoints' => { 96 => 0x53, 97 => 0x19a },
	'greenhsl' => { 92 => 0x20912 },
	'greenhue' => { 401 => 'GreenHue' },
	'greensaturation' => { 401 => 'GreenSaturation' },
	'griddisplay' => { 237 => '13.3', 238 => '4.3', 240 => '2.2', 243 => '10.5', 244 => '3.4', 245 => '6.1', 247 => '4.4', 248 => '4.2' },
	'gripbatteryadload' => { 282 => 0x5 },
	'gripbatteryadnoload' => { 282 => 0x4 },
	'gripbatterystate' => { 282 => '1.2' },
	'groupareaafillumination' => { 238 => '46.4', 247 => '47.4' },
	'halftonehints' => { 106 => 0x141 },
	'hardlink' => { 107 => 'HardLink' },
	'hasalternative' => { 416 => 'hasAlternative' },
	'hascorrection' => { 416 => 'hasCorrection' },
	'hascorrectiona-lang' => { 416 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 416 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 416 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 401 => 'HasCrop' },
	'hasextendedxmp' => { 428 => 'HasExtendedXMP' },
	'hassettings' => { 401 => 'HasSettings' },
	'hastranslation' => { 416 => 'hasTranslation' },
	'hdr' => { 52 => 0x1, 187 => 0x4, 270 => 0x9e, 303 => 0x85, 357 => 0x200a },
	'hdreffect' => { 52 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 187 => 0x0 },
	'hdrlevel' => { 187 => 0x5, 347 => 0x2e, 361 => 0x17 },
	'hdrlevel2' => { 187 => 0x7 },
	'hdrsetting' => { 347 => 0x2d, 361 => 0x16, 364 => 0x1148, 365 => 0x1148, 366 => 0x1124, 367 => 0x11a0, 368 => 0x117c, 369 => 0x1034, 370 => 0x22c, 371 => 0x22c },
	'hdrsmoothing' => { 187 => 0x6 },
	'headline' => { 114 => 0x69, 413 => 'Headline' },
	'hierarchicalkeywords' => { 151 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 151 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 151 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 151 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 151 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 151 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 392 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 105 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 274 => 0x1a },
	'highisomultipliergreen' => { 274 => 0x19 },
	'highisomultiplierred' => { 274 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 54 => 0x5, 73 => 0x202, 111 => 0x100e, 194 => 0xb1, 303 => 0x71, 345 => 0x2c, 346 => 0x26, 347 => 0x26, 357 => 0x2009, 361 => 0x12, 382 => 0x42 },
	'highisonoisereduction2' => { 357 => 0xb050 },
	'highlight' => { 337 => 0xf },
	'highlightadj' => { 92 => 0x2030c },
	'highlightcolordistortreduct' => { 386 => 0x8026 },
	'highlightprotection' => { 229 => 0x6 },
	'highlightrecovery' => { 401 => 'HighlightRecovery' },
	'highlights' => { 394 => 'Highlights' },
	'highlights2012' => { 401 => 'Highlights2012' },
	'highlighttone' => { 111 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 54 => 0x3, 73 => 0x203 },
	'highlowkeyadj' => { 303 => 0x6c },
	'highspeedsync' => { 161 => 0x5, 345 => 0x2, 346 => 0x2 },
	'histogramxml' => { 230 => 0x83a1a25 },
	'history' => { 413 => 'History', 427 => 'History' },
	'historyaction' => { 427 => [\'History','HistoryAction'] },
	'historychanged' => { 427 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 427 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 427 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 427 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 427 => [\'History','HistoryWhen'] },
	'hometowncity' => { 102 => 0x3006, 303 => 0x23, 309 => 0x2 },
	'hometowncitycode' => { 310 => 0x1000 },
	'hometowndst' => { 303 => 0x25, 309 => '0.2' },
	'hostcomputer' => { 106 => 0x13c },
	'hue' => { 166 => 0x3b, 303 => 0x67 },
	'hueadj' => { 233 => 0x2f, 386 => 0x8019 },
	'hueadjust' => { 328 => 0x1016 },
	'hueadjustment' => { 159 => 0x4a, 160 => 0x40, 194 => 0x92, 196 => 0x36 },
	'hueadjustmentaqua' => { 401 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 401 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 401 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 401 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 401 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 401 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 401 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 401 => 'HueAdjustmentYellow' },
	'huesetting' => { 258 => 0x1011 },
	'icc_profile' => { 107 => 'ICC_Profile' },
	'iccprofilename' => { 413 => 'ICCProfile' },
	'idccreativestyle' => { 386 => 0x8000 },
	'idcpreviewlength' => { 386 => 0x202 },
	'idcpreviewstart' => { 386 => 0x201 },
	'identification' => { 105 => 'Identification' },
	'identificationid' => { 105 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 105 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 105 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 105 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 105 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 105 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 402 => 'identifier', 424 => 'Identifier' },
	'illumination' => { 245 => '0.5' },
	'imageadjustment' => { 194 => 0x80, 220 => 0x5 },
	'imagealterationconstraints' => { 414 => 'ImageAlterationConstraints' },
	'imagearea' => { 205 => 0x10, 208 => 0x10 },
	'imageareaoffset' => { 303 => 0x38 },
	'imageauthentication' => { 194 => 0x20 },
	'imageboundary' => { 194 => 0x16 },
	'imagecount' => { 111 => 0x1438, 194 => 0xa5, 359 => 0x11b, 373 => [0x32,0x3a] },
	'imagecount2' => { 373 => [0x4c,0x58] },
	'imagecount3' => { 373 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 414 => 'ImageCreator' },
	'imagecreatorid' => { 414 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 414 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 414 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 194 => 0xa2 },
	'imagedescription' => { 106 => 0x10e, 422 => 'ImageDescription' },
	'imageduplicationconstraints' => { 414 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 230 => 0xfe443a45 },
	'imageeditcount' => { 303 => 0x41 },
	'imageediting' => { 303 => 0x32 },
	'imageeffects' => { 328 => 0x1010 },
	'imagefileconstraints' => { 414 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 414 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 414 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 111 => 0x1436 },
	'imageheight' => { 106 => 0x101, 165 => 0xc, 312 => 0x10d, 422 => 'ImageLength' },
	'imagehistory' => { 106 => 0x9213, 404 => 'ImageHistory' },
	'imageidnumber' => { 266 => 0x340 },
	'imagenumber' => { 106 => 0x9211, 136 => 'ImageNumber', 159 => 0xae, 160 => 0x5e, 312 => 0x113, 345 => 0x9b, 347 => [0x400,'276.1',0x314], 397 => 'ImageNumber' },
	'imagenumber2' => { 160 => 0x62 },
	'imageoptimization' => { 194 => 0xa9 },
	'imageorientation' => { 114 => 0x83 },
	'imageprocessing' => { 194 => 0x1a },
	'imageprocessingversion' => { 254 => 0x0 },
	'imagequality' => { 136 => 'ImageQuality', 207 => '723.2', 208 => '732.2', 216 => '708.1', 270 => 0x1 },
	'imagequality2' => { 250 => 0x603 },
	'imageref' => { 409 => 'ImageRef' },
	'imagereview' => { 239 => '0.4', 245 => '0.4' },
	'imagereviewmonitorofftime' => { 238 => '21.1', 247 => '21.1' },
	'imagereviewtime' => { 237 => '25.1', 239 => '2.1', 240 => '19.1', 241 => '20.1', 242 => '20.1', 243 => '9.2', 244 => '20.1', 248 => '21.2' },
	'imagesize' => { 142 => 'ImageSize' },
	'imagesizerestriction' => { 419 => 'imageSizeRestriction' },
	'imagesourcedata' => { 106 => 0x935c },
	'imagestabilization' => { 31 => 0x22, 102 => 0x3020, 111 => 0x1422, 136 => 'ImageStabilization', 159 => 0xbd, 160 => 0x71, 161 => 0x57, 162 => 0x0, 163 => [0x18,0x107,0x113], 164 => 0x49c2, 194 => 0xac, 250 => 0x604, 253 => 0x1600, 270 => 0x1a, 350 => 0x12, 351 => 0x11, 357 => 0xb026 },
	'imagestabilization2' => { 349 => 0xa },
	'imagestabilizationsetting' => { 164 => 0x14, 345 => 0x3d, 346 => 0x3d, 356 => 0x14 },
	'imagestyle' => { 345 => 0x2d, 346 => 0x27 },
	'imagesupplier' => { 414 => 'ImageSupplier' },
	'imagesupplierid' => { 414 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 414 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 414 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 108 => 0x1 },
	'imagetemperaturemin' => { 108 => 0x2 },
	'imagetone' => { 303 => 0x4f },
	'imagetype' => { 114 => 0x82, 414 => 'ImageType' },
	'imageuniqueid' => { 55 => 0x28, 106 => 0xa420, 405 => 'ImageUniqueID' },
	'imagewidth' => { 106 => 0x100, 165 => 0xe, 312 => 0x10c, 422 => 'ImageWidth' },
	'incrementaltemperature' => { 401 => 'IncrementalTemperature' },
	'incrementaltint' => { 401 => 'IncrementalTint' },
	'industry' => { 416 => 'industry', 417 => 'industry' },
	'infobuttonwhenshooting' => { 73 => 0x409 },
	'infraredilluminator' => { 324 => 0x28 },
	'ingredientexclusion' => { 418 => 'ingredientExclusion' },
	'ingredients' => { 427 => 'Ingredients' },
	'ingredientsalternatepaths' => { 427 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 427 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 427 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 427 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 427 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 427 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 427 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 427 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 427 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 427 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 427 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 427 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 427 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 427 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 427 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 427 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 427 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 73 => 0x51e },
	'initialhorizontalfovdegrees' => { 390 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 390 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 390 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 390 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 237 => '4.4' },
	'initialzoomsetting' => { 237 => '9.3', 243 => '27.3' },
	'inkset' => { 106 => 0x14c },
	'inputprofile' => { 120 => 0x1389 },
	'instanceid' => { 427 => 'InstanceID' },
	'instantplaybacksetup' => { 161 => 0x3e },
	'instantplaybacktime' => { 161 => 0x3d },
	'instructions' => { 413 => 'Instructions' },
	'instrument' => { 426 => 'instrument' },
	'intellectualgenre' => { 410 => 'IntellectualGenre' },
	'intelligentauto' => { 357 => 0xb052 },
	'intelligentcontrast' => { 44 => 0x4 },
	'intelligentd-range' => { 270 => 0x79 },
	'intelligentexposure' => { 270 => 0x5d },
	'intelligentresolution' => { 270 => 0x70 },
	'interchangecolorspace' => { 116 => 0x40 },
	'internalflash' => { 158 => 0x2b, 237 => '23.1', 239 => '8.1', 240 => '22.1', 242 => '23.1', 245 => '8.1', 248 => '24.1', 253 => 0x1208 },
	'internalflashae1' => { 255 => 0x1021 },
	'internalflashae1_0' => { 255 => 0x101d },
	'internalflashae2' => { 255 => 0x1022 },
	'internalflashae2_0' => { 255 => 0x101e },
	'internalflashmode' => { 291 => 0x1 },
	'internalflashstrength' => { 291 => 0x3 },
	'internalflashtable' => { 255 => 0x1024 },
	'internallensserialnumber' => { 334 => 0xa005 },
	'internalndfilter' => { 270 => 0x9d },
	'internalserialnumber' => { 55 => 0x96, 66 => 0x9, 111 => 0x10, 164 => 0x49dc, 249 => 0x18, 251 => 0x102, 270 => 0x25, 283 => 0x4, 328 => 0x5, 373 => [0x7c,0x88,0xf0] },
	'interopindex' => { 106 => 0x1, 406 => 'InteroperabilityIndex' },
	'interopversion' => { 106 => 0x2 },
	'intervallength' => { 158 => 0x10 },
	'intervalmode' => { 158 => 0x26 },
	'intervalnumber' => { 158 => 0x11 },
	'introtime' => { 426 => 'introTime' },
	'introtimescale' => { 426 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 426 => [\'introTime','introTimeValue'] },
	'iptc' => { 107 => 'IPTC' },
	'iptc-naa' => { 106 => 0x83bb, 274 => 0x83bb },
	'iptcbitspersample' => { 116 => 0x56 },
	'iptcdigest' => { 317 => 0x425 },
	'iptcimageheight' => { 116 => 0x1e },
	'iptcimagerotation' => { 116 => 0x66 },
	'iptcimagewidth' => { 116 => 0x14 },
	'iptclastedited' => { 411 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 116 => 0xa },
	'iptcpixelheight' => { 116 => 0x32 },
	'iptcpixelwidth' => { 116 => 0x28 },
	'isalternativeof' => { 416 => 'isAlternativeOf' },
	'isbn' => { 416 => 'isbn' },
	'iscorrectionof' => { 416 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 98 => 0x3 },
	'ismergedhdr' => { 397 => 'IsMergedHDR' },
	'ismergedpanorama' => { 397 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 101 => 0x14, 102 => [0x3014,0x14], 106 => 0x8827, 119 => 0xfd06, 120 => 0x1784, 122 => 0x60, 124 => [0xfa2e,0xfa46], 125 => [0x27,0x28], 126 => 0xf105, 129 => 0x14, 131 => 0x4e, 134 => 0x34, 136 => 'ISO', 158 => 0x8, 164 => 0x49ba, 188 => 0x0, 194 => 0x2, 274 => 0x17, 303 => [0x8b,0x14], 310 => 0x14, 312 => 0x105, 334 => 0xa014, 356 => 0x6f, 361 => [0x1f,0x21,0x25], 405 => 'ISOSpeedRatings' },
	'iso2' => { 188 => 0x6, 202 => 0x265, 203 => 0x25c, 204 => 0x265, 205 => 0x221, 206 => 0x25d, 207 => 0x256, 208 => 0x25d, 211 => 0x2b5, 214 => 0x265, 219 => 0x2b5 },
	'isoauto' => { 284 => '14.4' },
	'isoautoparameters' => { 303 => 0x7a },
	'isodisplay' => { 240 => '2.3', 241 => '3.3', 242 => '3.3', 244 => '3.3', 247 => '4.3', 248 => '4.3' },
	'isoexpansion' => { 73 => 0x103, 74 => 0x7, 75 => 0x8, 78 => 0x8, 188 => 0x4 },
	'isoexpansion2' => { 188 => 0xa },
	'isofloor' => { 284 => 0x6 },
	'isoselection' => { 194 => 0xf },
	'isosensitivitystep' => { 244 => '6.2' },
	'isosetting' => { 122 => 0x5e, 136 => 'ISOSetting', 158 => 0x24, 159 => 0x26, 160 => 0x1c, 161 => 0x13, 166 => 0x6, 194 => 0x13, 284 => '17.3', 327 => 0x27, 345 => 0x16, 346 => 0x14, 347 => 0x2, 356 => 0x6d },
	'isospeed' => { 106 => 0x8833, 406 => 'ISOSpeed' },
	'isospeedexpansion' => { 72 => 0x3 },
	'isospeedincrements' => { 73 => 0x102 },
	'isospeedlatitudeyyy' => { 106 => 0x8834, 406 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 106 => 0x8835, 406 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 73 => 0x103 },
	'isostepsize' => { 237 => '6.1', 238 => '7.2', 243 => '4.1', 247 => '7.2' },
	'isovalue' => { 255 => 0x1001 },
	'issn' => { 416 => 'issn' },
	'issueidentifier' => { 416 => 'issueIdentifier' },
	'issuename' => { 416 => 'issueName' },
	'issueteaser' => { 416 => 'issueTeaser' },
	'issuetype' => { 416 => 'issueType' },
	'istranslationof' => { 416 => 'isTranslationOf' },
	'jobid' => { 114 => 0xb8 },
	'jobname' => { 407 => 'JobName' },
	'jobref' => { 425 => 'JobRef' },
	'jobrefid' => { 425 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 425 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 425 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 407 => 'JobStatus' },
	'jpeghandling' => { 401 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 272 => 0x3034, 357 => 0xb047 },
	'jpegsize' => { 272 => 0x303a },
	'jpgfromraw' => { 86 => 0x2007, 103 => 'JpgFromRaw', 274 => 0x2e },
	'jpgfromrawlength' => { 106 => [0x117,0x202] },
	'jpgfromrawstart' => { 106 => [0x111,0x201] },
	'jpgrecordedpixels' => { 284 => '14.1' },
	'jurisdiction' => { 398 => 'jurisdiction' },
	'kelvinwb_01' => { 292 => 0x5 },
	'kelvinwb_02' => { 292 => 0x9 },
	'kelvinwb_03' => { 292 => 0xd },
	'kelvinwb_04' => { 292 => 0x11 },
	'kelvinwb_05' => { 292 => 0x15 },
	'kelvinwb_06' => { 292 => 0x19 },
	'kelvinwb_07' => { 292 => 0x1d },
	'kelvinwb_08' => { 292 => 0x21 },
	'kelvinwb_09' => { 292 => 0x25 },
	'kelvinwb_10' => { 292 => 0x29 },
	'kelvinwb_11' => { 292 => 0x2d },
	'kelvinwb_12' => { 292 => 0x31 },
	'kelvinwb_13' => { 292 => 0x35 },
	'kelvinwb_14' => { 292 => 0x39 },
	'kelvinwb_15' => { 292 => 0x3d },
	'kelvinwb_16' => { 292 => 0x41 },
	'kelvinwb_daylight' => { 292 => 0x1 },
	'key' => { 426 => 'key' },
	'keyword' => { 416 => 'keyword' },
	'keywordinfo' => { 151 => 'Keywords' },
	'keywords' => { 114 => 0x19, 137 => 'Keywords', 259 => 'Keywords', 319 => 'Keywords', 395 => 'keywords', 412 => 'Keywords', 424 => 'Keywords' },
	'killdate' => { 416 => 'killDate' },
	'killdatea-platform' => { 416 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 416 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 119 => 0xf908, 122 => 0xe, 124 => [0xfa1e,0xfa52], 130 => 0x70 },
	'kodakimagewidth' => { 119 => 0xf907, 122 => 0xc, 124 => [0xfa1d,0xfa51], 130 => 0x6c },
	'kodakinfotype' => { 119 => 0xfa00 },
	'kodaklook' => { 120 => 0xe4c },
	'kodaklookprofile' => { 120 => 0x138a },
	'kodakmaker' => { 130 => 0x8 },
	'kodakmodel' => { 122 => 0x0, 130 => 0x28 },
	'label' => { 262 => 'Label', 424 => 'Label' },
	'labelname1' => { 409 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 409 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 270 => 0x6f },
	'landscapeoutputhighlightpoint' => { 98 => 0x26 },
	'landscapeoutputshadowpoint' => { 98 => 0x27 },
	'landscaperawcolortone' => { 98 => 0x1f },
	'landscaperawcontrast' => { 98 => 0x21 },
	'landscaperawhighlight' => { 98 => 0x77 },
	'landscaperawhighlightpoint' => { 98 => 0x24 },
	'landscaperawlinear' => { 98 => 0x22 },
	'landscaperawsaturation' => { 98 => 0x20 },
	'landscaperawshadow' => { 98 => 0x80 },
	'landscaperawshadowpoint' => { 98 => 0x25 },
	'landscaperawsharpness' => { 98 => 0x23 },
	'landscapeunsharpmaskfineness' => { 98 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 98 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 98 => 0xa2 },
	'language' => { 402 => 'language' },
	'languageidentifier' => { 114 => 0x87 },
	'largestvalidinteriorrectheight' => { 390 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 390 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 390 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 390 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 158 => 0x1b },
	'lastkeywordiptc' => { 156 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 156 => 'LastKeywordXMP' },
	'lastphotodate' => { 390 => 'LastPhotoDate' },
	'lasturl' => { 427 => 'LastURL' },
	'lateralchromaticaberration' => { 357 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 397 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 105 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 105 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 105 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 105 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 105 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 294 => 0x2 },
	'lc10' => { 294 => 0xb },
	'lc11' => { 294 => 0xc },
	'lc12' => { 294 => 0xd },
	'lc14' => { 294 => 0xf },
	'lc15' => { 294 => 0x10 },
	'lc3' => { 294 => 0x4 },
	'lc4' => { 294 => 0x5 },
	'lc5' => { 294 => 0x6 },
	'lc6' => { 294 => 0x7 },
	'lc7' => { 294 => 0x8 },
	'lc8' => { 294 => 0x9 },
	'lcddisplayatpoweron' => { 73 => 0x811, 77 => 0xa },
	'lcddisplayreturntoshoot' => { 78 => 0x12 },
	'lcdillumination' => { 237 => '17.5', 238 => '5.2', 243 => '10.3', 244 => '4.2', 247 => '5.2', 248 => '5.4' },
	'lcdilluminationduringbulb' => { 73 => 0x408 },
	'lcdpanels' => { 72 => 0x8 },
	'lcheditor' => { 230 => 0x8ae85e },
	'legacyiptcdigest' => { 413 => 'LegacyIPTCDigest' },
	'legalcode' => { 398 => 'legalcode' },
	'lens' => { 106 => 0xfdea, 194 => 0x84, 397 => 'Lens' },
	'lensafstopbutton' => { 71 => 0x11, 72 => 0x13, 73 => 0x506, 74 => 0x10, 75 => 0x12, 78 => 0x13, 79 => 0x9 },
	'lensaperturerange' => { 337 => [0x30,0x48] },
	'lenscorrectionsettings' => { 404 => 'LensCorrectionSettings' },
	'lensdistortionparams' => { 255 => 0x206 },
	'lensdrivenoaf' => { 73 => 0x505 },
	'lense-mountversion' => { 347 => 0x3f0, 385 => 0xd },
	'lensfirmware' => { 329 => 0x20, 334 => 0xa004 },
	'lensfirmwareversion' => { 251 => 0x204, 270 => 0x60, 347 => 0x3f4, 385 => 0x15 },
	'lensfocallength' => { 92 => 0xf0512, 294 => 0x9 },
	'lensfocalrange' => { 337 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 238 => '55.1', 247 => '52.1' },
	'lensformat' => { 368 => 0x1891, 370 => 0x18bd, 371 => 0x18ed, 373 => 0x106, 381 => 0x603, 382 => 0x5d },
	'lensfstops' => { 189 => 0x7, 190 => 0xc, 191 => 0xd, 194 => 0x8b, 294 => '0.3' },
	'lensid' => { 397 => 'LensID' },
	'lensidnumber' => { 189 => 0x6, 190 => 0xb, 191 => 0xc },
	'lensinfo' => { 106 => 0xa432, 300 => 0x2a, 397 => 'LensInfo', 406 => 'LensSpecification' },
	'lenskind' => { 294 => 0x1 },
	'lensmake' => { 106 => 0xa433, 143 => 'Make', 406 => 'LensMake' },
	'lensmanualdistortionamount' => { 401 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 156 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 337 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 55 => 0x95, 106 => 0xa434, 143 => 'Model', 156 => 'LensModel', 192 => 0x18a, 251 => 0x203, 268 => 0x303, 300 => 0xc, 312 => 0x412, 406 => 'LensModel' },
	'lensmount' => { 347 => 0x99, 368 => 0x1892, 370 => 0x18be, 371 => 0x18ee, 373 => 0x105, 381 => 0x604, 382 => 0x5e },
	'lensmount2' => { 385 => 0x8 },
	'lensparameters' => { 365 => 0x1a23, 368 => 0x1870, 370 => 0x189c, 371 => 0x18cc, 381 => 0x6ca, 382 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 401 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 401 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 401 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 401 => 'LensProfileEnable' },
	'lensprofilefilename' => { 401 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 401 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 401 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 401 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 401 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 401 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 401 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 401 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 401 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 401 => 'LensProfileName' },
	'lensprofilesetup' => { 401 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 401 => 'LensProfileVignettingScale' },
	'lensproperties' => { 251 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 29 => 0x16b, 53 => 0x0, 106 => 0xa435, 143 => 'SerialNumber', 251 => 0x202, 270 => 0x52, 329 => 0x30, 397 => 'LensSerialNumber', 406 => 'LensSerialNumber' },
	'lensshutterlock' => { 161 => 0x4a },
	'lensspec' => { 342 => 0x0, 343 => 0x0, 344 => 0x0, 357 => 0xb02a },
	'lensspecfeatures' => { 373 => [0x115,0x116] },
	'lenstemperature' => { 255 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 31 => 0x16, 163 => 0x10c, 164 => 0x49bd, 194 => 0x83, 251 => 0x201, 263 => 0x16, 266 => 0x310, 269 => 0x303, 270 => 0x51, 272 => 0x3405, 295 => 0x0, 296 => 0x0, 297 => 0x1, 298 => 0x1, 299 => 0x1, 301 => 0x0, 334 => 0xa003, 337 => 0x27, 357 => 0xb027, 368 => 0x1896, 370 => 0x18c2, 371 => 0x18f2, 373 => 0x109, 381 => 0x608, 382 => 0x62 },
	'lenstype2' => { 347 => 0x3f7, 368 => 0x1893, 370 => 0x18bf, 371 => 0x18ef, 373 => 0x107, 381 => 0x605, 382 => 0x60 },
	'lenstype3' => { 385 => 0x9 },
	'lenszoomposition' => { 379 => 0x19, 380 => 0x1e, 382 => [0x342,0x35a] },
	'levelindicator' => { 277 => 0x15 },
	'levelorientation' => { 302 => 0x0 },
	'license' => { 398 => 'license' },
	'licensee' => { 414 => 'Licensee' },
	'licenseeid' => { 414 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 414 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 414 => 'LicenseeImageNotes' },
	'licenseename' => { 414 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 414 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 414 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 414 => 'LicenseeTransactionID' },
	'licenseid' => { 414 => 'LicenseID' },
	'licensestartdate' => { 414 => 'LicenseStartDate' },
	'licensetransactiondate' => { 414 => 'LicenseTransactionDate' },
	'licensetype' => { 403 => 'licensetype' },
	'licensor' => { 414 => 'Licensor' },
	'licensorcity' => { 414 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 414 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 414 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 414 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 414 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 414 => 'LicensorImageID' },
	'licensorname' => { 414 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 414 => 'LicensorNotes' },
	'licensorpostalcode' => { 414 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 414 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 414 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 414 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 414 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 414 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 414 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 414 => 'LicensorTransactionID' },
	'licensorurl' => { 414 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 255 => 0x1009 },
	'lightingmode' => { 102 => 0x302a },
	'lightreading' => { 303 => 0x15 },
	'lightsource' => { 106 => 0x9208, 194 => 0x90, 258 => 0x1000, 405 => 'LightSource' },
	'lightsourcespecial' => { 336 => 0x21d },
	'lightswitch' => { 247 => '0.1', 248 => '0.1' },
	'lightvaluecenter' => { 255 => 0x103d },
	'lightvalueperiphery' => { 255 => 0x103e },
	'limitafareamodeselection' => { 238 => '51.1', 247 => '49.1' },
	'linearitylimitblue' => { 274 => 0x10 },
	'linearitylimitgreen' => { 274 => 0xf },
	'linearitylimitred' => { 274 => 0xe },
	'linearityuppermargin' => { 38 => [0x2ba,0x2d1,0x2d5], 40 => 0x1e5, 41 => [0x1fe,0x2de], 42 => 0x310 },
	'linearizationtable' => { 106 => 0xc618 },
	'linearresponselimit' => { 106 => 0xc62e },
	'link' => { 416 => 'link' },
	'linkaetoafpoint' => { 284 => '14.2' },
	'linkedencodedrightsexpr' => { 411 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 411 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 411 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 411 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 105 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 240 => '32.1', 248 => '34.1' },
	'liveviewafareamode' => { 244 => '34.1' },
	'liveviewafmethod' => { 361 => 0x20 },
	'liveviewafmode' => { 244 => '34.2' },
	'liveviewafsetting' => { 347 => 0x36 },
	'liveviewbuttonoptions' => { 238 => '50.2', 247 => '48.2' },
	'liveviewexposuresimulation' => { 73 => 0x810 },
	'liveviewfocusmode' => { 347 => [0x8b,0x28b] },
	'liveviewmetering' => { 347 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 238 => '21.2', 241 => '20.2', 242 => '20.2', 244 => '20.2', 247 => '21.2' },
	'liveviewshooting' => { 49 => 0x13 },
	'localcaption' => { 114 => 0x79 },
	'localizedcameramodel' => { 106 => 0xc615 },
	'locallocationname' => { 334 => 0x30 },
	'location' => { 193 => 0x9, 270 => 0x67, 393 => 'Location', 410 => 'Location', 415 => 'location', 416 => 'location' },
	'locationareacode' => { 399 => 'lac' },
	'locationcreated' => { 411 => 'LocationCreated' },
	'locationcreatedcity' => { 411 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 411 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 411 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 411 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 411 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 411 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 411 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 193 => 0x0 },
	'locationname' => { 334 => 0x31 },
	'locationshown' => { 411 => 'LocationShown' },
	'locationshowncity' => { 411 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 411 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 411 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 411 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 411 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 411 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 411 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 73 => 0x709 },
	'logcomment' => { 426 => 'logComment' },
	'longexposurenoisereduction' => { 54 => 0x4, 73 => 0x201, 74 => 0x1, 75 => 0x2, 76 => 0x1, 77 => 0x1, 78 => 0x2, 79 => 0x1, 270 => 0x49, 345 => 0x2b, 346 => 0x25, 347 => 0x25, 357 => 0x2008, 361 => 0x11, 382 => 0x44 },
	'longexposurenoisereduction2' => { 49 => 0x8 },
	'loop' => { 426 => 'loop' },
	'lowestbiostratigraphiczone' => { 105 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 401 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 401 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 401 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 401 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 401 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 401 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 401 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 401 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 97 => 0x150 },
	'luminancecurvepoints' => { 97 => 0x126 },
	'luminancenoisereduction' => { 92 => 0x20600, 98 => 0x5f, 337 => 0x1b },
	'luminancenoisereductioncontrast' => { 401 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 401 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 98 => 0x6d },
	'luminancesmoothing' => { 401 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 73 => [0x40b,0x40c] },
	'lyrics' => { 426 => 'lyrics' },
	'm16cversion' => { 266 => 0x333 },
	'macatom' => { 400 => 'macAtom' },
	'macatomapplicationcode' => { 400 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 400 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 400 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 111 => 0x1020, 112 => 0x202, 255 => 0x202, 327 => 0x21, 336 => 0x202, 357 => 0xb040 },
	'macroled' => { 253 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 49 => 0x10 },
	'macromode' => { 31 => 0x1, 158 => 0xb, 250 => 0x300, 270 => 0x1c, 328 => 0x1009 },
	'magentahsl' => { 92 => 0x20917 },
	'magicfilter' => { 250 => 0x52c },
	'magnifiedview' => { 75 => 0x11, 77 => 0x9 },
	'maindialexposurecomp' => { 245 => '0.6' },
	'mainingredient' => { 418 => 'mainIngredient' },
	'make' => { 87 => 0x0, 106 => 0x10f, 136 => 'Make', 262 => 'Make', 274 => 0x10f, 415 => 'make', 422 => 'Make' },
	'makernote' => { 405 => 'MakerNote' },
	'makernoteapple' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecanon' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecasio' => { 104 => 'MakN', 106 => 0x927c },
	'makernotecasio2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteflir' => { 104 => 'MakN', 106 => 0x927c },
	'makernotefujifilm' => { 104 => 'MakN', 106 => 0x927c },
	'makernotege' => { 104 => 'MakN', 106 => 0x927c },
	'makernotege2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehasselblad' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotehp6' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteisl' => { 104 => 'MakN', 106 => 0x927c },
	'makernotejvc' => { 104 => 'MakN', 106 => 0x927c },
	'makernotejvctext' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak10' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak11' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak1a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak1b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak6a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak6b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak7' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak8c' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodak9' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekodakunknown' => { 104 => 'MakN', 106 => 0x927c },
	'makernotekyocera' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica3' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica4' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica5' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica6' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica7' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica8' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteleica9' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta2' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteminolta3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotemotorola' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenikon3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotenintendo' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteoffset' => { 336 => 0xff },
	'makernoteolympus' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteolympus2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepanasonic' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepanasonic2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotepentax6' => { 104 => 'MakN', 106 => 0x927c },
	'makernotephaseone' => { 104 => 'MakN', 106 => 0x927c },
	'makernotereconyx' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericoh' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericoh2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotericohtext' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesafety' => { 106 => 0xc635 },
	'makernotesamsung1a' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesamsung1b' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesamsung2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyo' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyoc4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesanyopatch' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesigma' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony2' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony3' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony4' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesony5' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesonyericsson' => { 104 => 'MakN', 106 => 0x927c },
	'makernotesonysrf' => { 104 => 'MakN', 106 => 0x927c },
	'makernotetype' => { 328 => 0x1 },
	'makernoteunknown' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteunknownbinary' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteunknowntext' => { 104 => 'MakN', 106 => 0x927c },
	'makernoteversion' => { 163 => 0x0, 194 => 0x1, 255 => 0x0, 270 => 0x8000, 332 => 0x0, 334 => 0x1, 337 => [0x1d,0x1f], 348 => 0x2000 },
	'managedfrom' => { 427 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 427 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 427 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 427 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 427 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 427 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 427 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 427 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 427 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 427 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 427 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 427 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 427 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 427 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 427 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 427 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 427 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 427 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 427 => 'Manager' },
	'managervariant' => { 427 => 'ManagerVariant' },
	'manageto' => { 427 => 'ManageTo' },
	'manageui' => { 427 => 'ManageUI' },
	'manifest' => { 427 => 'Manifest' },
	'manifestlinkform' => { 427 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 427 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 427 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 427 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 427 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 427 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 427 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 427 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 427 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 427 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 427 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 427 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 427 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 427 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 427 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 427 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 427 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 427 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 427 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 427 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 427 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 427 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 250 => 0x900, 270 => 0x86 },
	'manometerreading' => { 250 => 0x901 },
	'manualafpointselectpattern' => { 73 => 0x513 },
	'manualflash' => { 253 => 0x1209 },
	'manualflashoutput' => { 31 => 0x29, 239 => '8.2', 240 => '22.2', 241 => '23.1', 242 => '23.2', 243 => '16.2', 244 => '23.2', 245 => '8.2', 246 => '23.2', 248 => '24.2', 328 => 0x100c },
	'manualflashstrength' => { 250 => 0x406 },
	'manualfocusdistance' => { 194 => 0x85, 255 => 0x100c, 336 => 0x223 },
	'manualtv' => { 72 => 0x5, 73 => 0x705 },
	'manufacturedate' => { 168 => 0x6705, 283 => 0x1 },
	'manufacturedate1' => { 330 => 0x4 },
	'manufacturedate2' => { 330 => 0x5 },
	'manufacturer' => { 415 => 'manufacturer' },
	'marked' => { 412 => 'Marked', 430 => 'Marked' },
	'markers' => { 426 => 'markers' },
	'markerscomment' => { 426 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 426 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 426 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 426 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 426 => [\'markers','markersCuePointType'] },
	'markersduration' => { 426 => [\'markers','markersDuration'] },
	'markerslocation' => { 426 => [\'markers','markersLocation'] },
	'markersname' => { 426 => [\'markers','markersName'] },
	'markersprobability' => { 426 => [\'markers','markersProbability'] },
	'markersspeaker' => { 426 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 426 => [\'markers','markersStartTime'] },
	'markerstarget' => { 426 => [\'markers','markersTarget'] },
	'markerstype' => { 426 => [\'markers','markersType'] },
	'maskedareas' => { 106 => 0xc68e },
	'masterdocumentid' => { 114 => 0xb9 },
	'mastergain' => { 200 => 0x50 },
	'matrixmetering' => { 238 => '50.1', 247 => '48.1' },
	'maxaperture' => { 31 => 0x1a, 126 => 0x6103, 143 => 'MaxAperture', 158 => 0x17, 164 => 0x49c5, 251 => 0x20a, 294 => '14.1', 373 => 0x0 },
	'maxapertureatmaxfocal' => { 111 => 0x1407, 143 => 'MaxApertureAtMaxFocal', 189 => 0xb, 190 => 0x10, 191 => 0x11, 251 => 0x206 },
	'maxapertureatminfocal' => { 111 => 0x1406, 189 => 0xa, 190 => 0xf, 191 => 0x10, 251 => 0x205 },
	'maxaperturevalue' => { 106 => 0x9205, 312 => 0x414, 405 => 'MaxApertureValue' },
	'maxavailheight' => { 411 => 'MaxAvailHeight' },
	'maxavailwidth' => { 411 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 237 => 0xb, 238 => 0xc, 243 => 0xc, 244 => 0xb, 247 => '12.1' },
	'maxfaces' => { 254 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 31 => 0x17, 111 => 0x1405, 143 => 'MaxFocalLength', 189 => 0x9, 190 => 0xe, 191 => 0xf, 251 => 0x208, 368 => 0x127c, 369 => 0x1138, 370 => 0x330, 371 => 0x330 },
	'maximumdensityrange' => { 116 => 0x8c },
	'maxpagesize' => { 431 => 'MaxPageSize' },
	'maxpagesizeh' => { 431 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 431 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 431 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 106 => 0x119 },
	'maxstorage' => { 421 => 'maxstorage' },
	'mb-d10batteries' => { 237 => '12.6' },
	'mb-d10batterytype' => { 243 => '13.3' },
	'mb-d11batterytype' => { 244 => '2.3' },
	'mb-d12batterytype' => { 247 => '3.2' },
	'mb-d80batteries' => { 245 => '6.5' },
	'mb-d80batterytype' => { 248 => '3.2' },
	'mcuversion' => { 189 => 0xc, 190 => 0x11, 191 => 0x12 },
	'md5digest' => { 144 => 'zmd5' },
	'meal' => { 418 => 'meal' },
	'measuredev' => { 26 => 0x9, 67 => 0x3, 86 => 0x1814, 136 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 67 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 164 => 0x690, 266 => 0x312, 272 => 0x3407 },
	'measuredrggb' => { 56 => 0x1 },
	'measuredrggbdata' => { 37 => 0x287 },
	'measurementaccuracy' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 105 => 'MeasurementOrFact' },
	'measurementremarks' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 105 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 414 => 'MediaConstraints' },
	'mediacreatedate' => { 320 => 0x1 },
	'mediamodifydate' => { 320 => 0x2 },
	'mediasummarycode' => { 414 => 'MediaSummaryCode' },
	'memoaudioquality' => { 73 => 0x812 },
	'memorycardconfiguration' => { 351 => 0x16 },
	'memorycardnumber' => { 182 => 0x2 },
	'menubuttondisplayposition' => { 71 => 0xb, 74 => 0xa, 75 => 0xb, 78 => 0xb },
	'menubuttonreturn' => { 79 => 0xb },
	'menumonitorofftime' => { 237 => '26.1', 238 => '22.1', 243 => '8.2', 244 => '21.1', 247 => '22.1', 248 => '22.1' },
	'metadatadate' => { 424 => 'MetadataDate' },
	'metadatamoddate' => { 426 => 'metadataModDate' },
	'metaversion' => { 363 => 0x34 },
	'meterinfo1row1' => { 358 => 0x0 },
	'meterinfo1row2' => { 358 => 0x6c },
	'meterinfo1row3' => { 358 => 0xd8 },
	'meterinfo1row4' => { 358 => 0x144 },
	'meterinfo1row5' => { 358 => 0x1b0 },
	'meterinfo1row6' => { 358 => 0x21c },
	'meterinfo1row7' => { 358 => 0x288 },
	'meterinfo2row1' => { 358 => 0x2f4 },
	'meterinfo2row2' => { 358 => 0x378 },
	'meterinfo2row3' => { 358 => 0x3fc },
	'meterinfo2row4' => { 358 => 0x480 },
	'meterinfo2row5' => { 358 => 0x504 },
	'meterinfo2row6' => { 358 => 0x588 },
	'meterinfo2row7' => { 358 => 0x60c },
	'meterinfo2row8' => { 358 => 0x690 },
	'meterinfo2row9' => { 358 => 0x714 },
	'metering' => { 239 => '6.1' },
	'meteringmode' => { 31 => 0x11, 106 => 0x9207, 122 => 0x1c, 158 => 0x7, 159 => 0x25, 161 => 0x12, 250 => 0x202, 303 => 0x17, 337 => 0x9, 345 => 0x15, 346 => 0x13, 347 => 0x7, 361 => 0x3, 364 => 0x1174, 365 => 0x1178, 366 => 0x1154, 367 => 0x11d0, 368 => 0x11ac, 369 => 0x1064, 370 => 0x25c, 371 => 0x25c, 405 => 'MeteringMode' },
	'meteringmode2' => { 284 => '2.1' },
	'meteringmode3' => { 284 => '16.1' },
	'meteringoffscaleindicator' => { 161 => 0x53 },
	'meteringtime' => { 237 => '22.2', 239 => '3.2', 240 => '17.1', 241 => '18.1', 243 => '7.3', 244 => '18.1', 245 => '3.2', 248 => '19.1' },
	'mieversion' => { 144 => '0Vers' },
	'minaperture' => { 31 => 0x1b, 143 => 'MinAperture', 294 => '0.2', 373 => 0x1 },
	'minaperturevalue' => { 312 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 31 => 0x18, 111 => 0x1404, 143 => 'MinFocalLength', 189 => 0x8, 190 => 0xd, 191 => 0xe, 251 => 0x207, 368 => 0x127a, 369 => 0x1136, 370 => 0x32e, 371 => 0x32e },
	'minfocusdistance' => { 294 => 0x3 },
	'minoltadate' => { 158 => 0x15 },
	'minoltaimagesize' => { 158 => 0x4, 159 => 0xc, 160 => 0x2, 163 => 0x103 },
	'minoltamodelid' => { 158 => 0x25 },
	'minoltaquality' => { 158 => 0x5, 159 => 0xd, 160 => 0x3, 163 => [0x102,0x103] },
	'minoltatime' => { 158 => 0x16 },
	'minormodelagedisclosure' => { 414 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 106 => 0x118 },
	'mirrorlockup' => { 71 => 0xc, 72 => 0xc, 73 => 0x60f, 74 => 0xb, 75 => 0xc, 76 => 0x6, 77 => 0x6, 78 => 0xc, 79 => 0x3 },
	'mobilecountrycode' => { 399 => 'mcc' },
	'mobilenetworkcode' => { 399 => 'mnc' },
	'moddate' => { 262 => 'modify-date', 412 => 'ModDate' },
	'modedialposition' => { 351 => 0x14 },
	'model' => { 87 => 0x6, 106 => 0x110, 136 => 'Model', 262 => 'Model', 274 => 0x110, 415 => 'model', 422 => 'Model' },
	'modelage' => { 411 => 'ModelAge' },
	'modelid' => { 249 => 0x0 },
	'modelingflash' => { 237 => '21.4', 238 => '31.1', 243 => '26.4', 244 => '30.2', 245 => '7.4', 246 => '30.1', 247 => '31.1', 248 => '31.3' },
	'modelreleaseid' => { 414 => 'ModelReleaseID' },
	'modelreleasestatus' => { 414 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 374 => 0x52, 375 => 0x46, 376 => 0x53 },
	'modelyear' => { 415 => 'modelYear' },
	'modificationdate' => { 416 => 'modificationDate' },
	'modifiedcolortemp' => { 57 => 0x9 },
	'modifieddigitalgain' => { 57 => 0xb },
	'modifiedparamflag' => { 50 => 0x1 },
	'modifiedpicturestyle' => { 57 => 0xa },
	'modifiedsaturation' => { 250 => 0x504 },
	'modifiedsensorbluelevel' => { 57 => 0x5 },
	'modifiedsensorredlevel' => { 57 => 0x4 },
	'modifiedsharpness' => { 57 => 0x2 },
	'modifiedsharpnessfreq' => { 57 => 0x3 },
	'modifiedtonecurve' => { 57 => 0x1 },
	'modifiedwhitebalance' => { 57 => 0x8 },
	'modifiedwhitebalanceblue' => { 57 => 0x7 },
	'modifiedwhitebalancered' => { 57 => 0x6 },
	'modifydate' => { 106 => 0x132, 137 => 'ModifyDate', 259 => 'ModDate', 260 => 'tIME', 319 => 'ModDate', 321 => 0x2, 424 => 'ModifyDate' },
	'moirefilter' => { 106 => 0xfe58, 401 => 'MoireFilter' },
	'monitordisplayoff' => { 161 => 0x4c },
	'monitorofftime' => { 237 => '18.2', 239 => '3.1', 245 => '3.1' },
	'monochromecontrast' => { 98 => 0x3c },
	'monochromefiltereffect' => { 92 => 0x20307, 98 => 0x3a, 303 => 0x73 },
	'monochromelinear' => { 98 => 0x3d },
	'monochromeoutputhighlightpoint' => { 98 => 0x41 },
	'monochromeoutputshadowpoint' => { 98 => 0x42 },
	'monochromerawhighlight' => { 98 => 0x7a },
	'monochromerawhighlightpoint' => { 98 => 0x3f },
	'monochromerawshadow' => { 98 => 0x83 },
	'monochromerawshadowpoint' => { 98 => 0x40 },
	'monochromesharpness' => { 98 => 0x3e },
	'monochrometoning' => { 303 => 0x74 },
	'monochrometoningeffect' => { 92 => 0x20306, 98 => 0x3b },
	'monochromeunsharpmaskfineness' => { 98 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 98 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 98 => 0xb4 },
	'monthdaycreated' => { 122 => 0x12, 131 => 0xe },
	'moonphase' => { 324 => 0x12 },
	'morepermissions' => { 398 => 'morePermissions' },
	'motionsensitivity' => { 324 => 0x29 },
	'movieaelockbuttonassignment' => { 247 => '40.1' },
	'moviefunctionbutton' => { 238 => '41.1', 247 => '41.1' },
	'moviefunctionbuttonplusdials' => { 238 => '52.1' },
	'moviepreviewbutton' => { 238 => '41.2', 247 => '41.2' },
	'moviepreviewbuttonplusdials' => { 238 => '52.2' },
	'movieshutterbutton' => { 238 => '38.3', 247 => '38.3' },
	'moviesubselectorassignment' => { 238 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 238 => '53.1' },
	'multiburstimageheight' => { 357 => 0x1002 },
	'multiburstimagewidth' => { 357 => 0x1001 },
	'multiburstmode' => { 357 => 0x1000 },
	'multicontrollerwhilemetering' => { 73 => 0x517 },
	'multiexposure' => { 59 => 0x1 },
	'multiexposureautogain' => { 195 => 0x3 },
	'multiexposurecontrol' => { 59 => 0x2 },
	'multiexposuremode' => { 195 => 0x1 },
	'multiexposureshots' => { 59 => 0x3, 195 => 0x2 },
	'multiframenoisereduction' => { 347 => 0x35, 357 => 0x200b, 361 => 0x15 },
	'multifunctionlock' => { 73 => 0x70f },
	'multipleexposuremode' => { 254 => 0x101c },
	'multipleexposureset' => { 284 => '10.1' },
	'multisample' => { 200 => 0x40 },
	'multiselector' => { 237 => '9.4', 238 => '10.3', 243 => '27.4', 247 => '10.3' },
	'multiselectorliveview' => { 237 => '4.3', 247 => '37.1' },
	'multiselectorliveviewmode' => { 210 => 0x18c2 },
	'multiselectorplaybackmode' => { 237 => ['13.5','9.2'], 238 => '10.2', 243 => '27.2', 247 => '10.2' },
	'multiselectorshootmode' => { 237 => '9.1', 238 => '10.1', 243 => '27.1', 247 => '10.1' },
	'mycolormode' => { 60 => 0x2 },
	'nationalcatalognumber' => { 416 => 'nationalCatalogNumber' },
	'nativedigest' => { 405 => 'NativeDigest', 422 => 'NativeDigest' },
	'ncdfileinfo' => { 120 => 0x414 },
	'ndfilter' => { 67 => 0x1c, 250 => 0x204, 328 => 0x1019 },
	'nefbitdepth' => { 194 => 0xe22 },
	'nefcompression' => { 194 => 0x93 },
	'neflinearizationtable' => { 194 => 0x96 },
	'negativecachelargepreviewsize' => { 401 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 401 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 401 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 303 => 0x88 },
	'neutraloutputhighlightpoint' => { 98 => 0x2f },
	'neutraloutputshadowpoint' => { 98 => 0x30 },
	'neutralrawcolortone' => { 98 => 0x28 },
	'neutralrawcontrast' => { 98 => 0x2a },
	'neutralrawhighlight' => { 98 => 0x78 },
	'neutralrawhighlightpoint' => { 98 => 0x2d },
	'neutralrawlinear' => { 98 => 0x2b },
	'neutralrawsaturation' => { 98 => 0x29 },
	'neutralrawshadow' => { 98 => 0x81 },
	'neutralrawshadowpoint' => { 98 => 0x2e },
	'neutralrawsharpness' => { 98 => 0x2c },
	'neutralunsharpmaskfineness' => { 98 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 98 => 0xa8 },
	'neutraunsharpmaskstrength' => { 98 => 0xa4 },
	'newrawimagedigest' => { 106 => 0xc7a7 },
	'newsphotoversion' => { 116 => 0x0 },
	'nickname' => { 424 => 'Nickname' },
	'nikoncapturedata' => { 194 => 0xe01 },
	'nikoncaptureeditversions' => { 194 => 0xe13 },
	'nikoncaptureoutput' => { 194 => 0xe1e },
	'nikoncaptureversion' => { 194 => 0xe09 },
	'nikoniccprofile' => { 194 => 0xe1d },
	'nikonimagesize' => { 207 => '723.1', 208 => '732.1', 216 => 0x2c4 },
	'noisefilter' => { 250 => 0x527 },
	'noiseprofile' => { 106 => 0xc761 },
	'noisereduction' => { 111 => 0x100b, 159 => 0xb0, 160 => 0x60, 161 => 0x3f, 194 => 0x95, 230 => 0x753dcbc0, 231 => 0x17, 250 => 0x50a, 255 => 0x103a, 270 => 0x2d, 303 => 0x49, 328 => 0x100f, 330 => 0x2a },
	'noisereduction2' => { 254 => 0x1010 },
	'noisereductionapplied' => { 106 => 0xc6f7 },
	'noisereductionintensity' => { 231 => 0x9 },
	'noisereductionmethod' => { 231 => 0x11 },
	'noisereductionmode' => { 386 => 0x801e },
	'noisereductionsharpness' => { 231 => 0xd },
	'noisereductionvalue' => { 386 => 0x8027 },
	'nomemorycard' => { 237 => '22.1', 238 => '4.2', 239 => '0.3', 240 => '2.4', 241 => '3.2', 242 => '3.2', 243 => '33.7', 244 => '3.2', 245 => '0.3', 247 => '4.2', 248 => '4.5' },
	'nominalmaxaperture' => { 294 => 0xa },
	'nominalminaperture' => { 294 => '10.1' },
	'normalwhitelevel' => { 38 => [0x2b8,0x2cf,0x2d3], 40 => 0x1e3, 41 => [0x1fc,0x2dc], 42 => 0x30e },
	'notes' => { 387 => 'Notes', 395 => 'notes' },
	'npages' => { 431 => 'NPages' },
	'nrwdata' => { 194 => 0x14 },
	'nullrecord' => { 86 => 0x0 },
	'number' => { 416 => 'number' },
	'numberofbeats' => { 426 => 'numberOfBeats' },
	'numberoffocuspoints' => { 242 => '0.2', 244 => '0.3' },
	'numfacepositions' => { 264 => 0x0 },
	'numindexentries' => { 116 => 0x54 },
	'numwbentries' => { 275 => 0x0, 276 => 0x0 },
	'object' => { 416 => 'object' },
	'objectattributereference' => { 114 => 0x4 },
	'objectcycle' => { 114 => 0x4b, 395 => 'ObjectCycle' },
	'objectdescription' => { 415 => 'objectDescription' },
	'objectdistance' => { 101 => 0x6, 102 => 0x2022 },
	'objectname' => { 114 => 0x5 },
	'objectpreviewdata' => { 114 => 0xca },
	'objectpreviewfileformat' => { 114 => 0xc8 },
	'objectpreviewfileversion' => { 114 => 0xc9 },
	'objectsubtype' => { 415 => 'objectSubtype' },
	'objecttype' => { 415 => 'objectType' },
	'objecttypereference' => { 114 => 0x3 },
	'occurrence' => { 105 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 105 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 105 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 105 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 105 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 105 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 105 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 105 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 105 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 105 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 105 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 105 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 105 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 105 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 105 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 105 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 105 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 105 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 105 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 105 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 105 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 105 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 105 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 105 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 405 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 405 => [\'OECF','OECFNames'] },
	'oecfrows' => { 405 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 405 => [\'OECF','OECFValues'] },
	'offsaledate' => { 416 => 'offSaleDate' },
	'offsaledatea-platform' => { 416 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 416 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 106 => 0xea1d },
	'okbutton' => { 244 => '15.1', 248 => '16.1' },
	'oldsubfiletype' => { 106 => 0xff },
	'olympusimageheight' => { 255 => 0x102f },
	'olympusimagewidth' => { 255 => 0x102e },
	'onetouchwb' => { 255 => 0x302 },
	'onsaledate' => { 416 => 'onSaleDate' },
	'onsaledatea-platform' => { 416 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 416 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 416 => 'onSaleDay' },
	'onsaledaya-platform' => { 416 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 416 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 124 => 0xfa3d, 126 => [0x6006,0xf006], 127 => 0x1000, 128 => 0xf, 131 => 0x1e, 143 => 'OpticalZoom' },
	'opticalzoomcode' => { 67 => 0xa },
	'opticalzoommode' => { 270 => 0x34 },
	'opticalzoomon' => { 336 => 0x219 },
	'optionenddate' => { 419 => 'optionEndDate' },
	'opto-electricconvfactor' => { 405 => 'OECF' },
	'orangehsl' => { 92 => 0x20911 },
	'ordernumber' => { 111 => 0x8002 },
	'organisationinimagecode' => { 411 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 411 => 'OrganisationInImageName' },
	'organization' => { 416 => 'organization' },
	'orientation' => { 106 => 0x112, 274 => 0x112, 415 => 'orientation', 422 => 'Orientation' },
	'orientation2' => { 361 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 73 => 0x516 },
	'originalbestqualitysize' => { 106 => 0xc792 },
	'originaldecisiondata' => { 103 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 55 => 0x83 },
	'originaldefaultcropsize' => { 106 => 0xc793 },
	'originaldefaultfinalsize' => { 106 => 0xc791 },
	'originaldirectory' => { 268 => 0x408 },
	'originaldocumentid' => { 427 => 'OriginalDocumentID' },
	'originalfilename' => { 86 => 0x816, 120 => 0x3e9, 132 => 0x20, 268 => 0x407, 391 => 'OriginalFilename' },
	'originalimageheight' => { 69 => 0xc, 110 => 0x1 },
	'originalimagewidth' => { 69 => 0xb, 110 => 0x0 },
	'originalrawfiledata' => { 106 => 0xc68c },
	'originalrawfiledigest' => { 106 => 0xc71d },
	'originalrawfilename' => { 106 => 0xc68b },
	'originaltransmissionreference' => { 114 => 0x67 },
	'originatingprogram' => { 114 => 0x41, 395 => 'OriginatingProgram' },
	'originplatform' => { 416 => 'originPlatform' },
	'os' => { 403 => 'os' },
	'otherconditions' => { 414 => 'OtherConditions' },
	'otherconstraints' => { 414 => 'OtherConstraints' },
	'otherimage' => { 103 => 'OtherImage' },
	'otherimageinfo' => { 414 => 'OtherImageInfo' },
	'otherimagelength' => { 106 => 0x202 },
	'otherimagestart' => { 106 => 0x201 },
	'otherlicensedocuments' => { 414 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 414 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 414 => 'OtherLicenseRequirements' },
	'outcue' => { 426 => 'outCue' },
	'outcuescale' => { 426 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 426 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 173 => 0x3 },
	'outputimagewidth' => { 173 => 0x2 },
	'outputprofile' => { 120 => 0x138b },
	'outputresolution' => { 173 => 0x4 },
	'owner' => { 430 => 'Owner' },
	'ownerid' => { 114 => 0xbc },
	'ownername' => { 14 => 0x10f, 55 => 0x9, 86 => 0x810, 106 => [0xa430,0xfde8], 136 => 'OwnerName', 397 => 'OwnerName', 406 => 'CameraOwnerName' },
	'padding' => { 106 => 0xea1c },
	'pagecount' => { 416 => 'pageCount' },
	'pageimage' => { 424 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 424 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 424 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 424 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 424 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 424 => 'PageInfo' },
	'pagename' => { 106 => 0x11d },
	'pagenumber' => { 106 => 0x129 },
	'pageprogressiondirection' => { 416 => 'pageProgressionDirection' },
	'pagerange' => { 416 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 401 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 401 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 270 => 0x26 },
	'panasonicimageheight' => { 270 => 0x4c },
	'panasonicimagewidth' => { 270 => 0x4b },
	'panasonicrawversion' => { 274 => 0x1 },
	'panasonictitle' => { 106 => 0xc6d2 },
	'panasonictitle2' => { 106 => 0xc6d3 },
	'panoramacropbottom' => { 362 => 0x7 },
	'panoramacropleft' => { 362 => 0x4 },
	'panoramacropright' => { 362 => 0x6 },
	'panoramacroptop' => { 362 => 0x5 },
	'panoramadirection' => { 63 => 0x5, 362 => 0x3 },
	'panoramaframeheight' => { 362 => 0x9 },
	'panoramaframenumber' => { 63 => 0x2 },
	'panoramaframewidth' => { 362 => 0x8 },
	'panoramafullheight' => { 362 => 0x2 },
	'panoramafullwidth' => { 362 => 0x1 },
	'panoramamode' => { 122 => 0x3c, 250 => 0x601 },
	'panoramasize3d' => { 347 => 0x38 },
	'panoramasourceheight' => { 362 => 0xb },
	'panoramasourcewidth' => { 362 => 0xa },
	'panoramicstitchcameramotion' => { 154 => 'PanoramicStitchCameraMotion', 155 => 0x1 },
	'panoramicstitchmaptype' => { 154 => 'PanoramicStitchMapType', 155 => 0x2 },
	'panoramicstitchphi0' => { 154 => 'PanoramicStitchPhi0', 155 => 0x5 },
	'panoramicstitchphi1' => { 154 => 'PanoramicStitchPhi1', 155 => 0x6 },
	'panoramicstitchtheta0' => { 154 => 'PanoramicStitchTheta0', 155 => 0x3 },
	'panoramicstitchtheta1' => { 154 => 'PanoramicStitchTheta1', 155 => 0x4 },
	'panoramicstitchversion' => { 155 => 0x0 },
	'pantry' => { 427 => 'Pantry' },
	'parallax' => { 111 => 0xb211, 249 => 0x28 },
	'parametricdarks' => { 401 => 'ParametricDarks' },
	'parametrichighlights' => { 401 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 401 => 'ParametricHighlightSplit' },
	'parametriclights' => { 401 => 'ParametricLights' },
	'parametricmidtonesplit' => { 401 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 401 => 'ParametricShadows' },
	'parametricshadowsplit' => { 401 => 'ParametricShadowSplit' },
	'parentmeid' => { 391 => 'ParentMEID' },
	'parentreference1' => { 409 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 409 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 426 => 'partOfCompilation' },
	'patientbirthdate' => { 388 => 'PatientDOB' },
	'patientid' => { 388 => 'PatientID' },
	'patientname' => { 388 => 'PatientName' },
	'patientsex' => { 388 => 'PatientSex' },
	'pdfversion' => { 412 => 'PDFVersion' },
	'pentaximagesize' => { 303 => 0x9 },
	'pentaxmodelid' => { 283 => 0x0, 303 => 0x5 },
	'pentaxmodeltype' => { 303 => 0x1 },
	'pentaxversion' => { 303 => 0x0 },
	'people' => { 389 => 'People', 393 => 'People' },
	'perchannelblacklevel' => { 37 => 0xc4, 38 => [0x2b4,0x2cb,0x2cf], 39 => 0x108, 40 => 0x1df, 41 => [0x1f8,0x2d8], 42 => 0x30a },
	'peripheralillumcentralradius' => { 386 => 0x8030 },
	'peripheralillumcentralvalue' => { 386 => 0x8031 },
	'peripheralillumination' => { 92 => 0x20702, 98 => 0x68 },
	'peripheralilluminationcorr' => { 54 => 0x1, 293 => 0x2 },
	'peripheralilluminationon' => { 92 => '0x20702.0', 98 => 0x64 },
	'peripheralillumperiphvalue' => { 386 => 0x8032 },
	'peripherallighting' => { 69 => 0x2 },
	'peripherallightingsetting' => { 70 => 0x5 },
	'peripherallightingvalue' => { 69 => 0x6 },
	'permissions' => { 419 => 'permissions' },
	'permits' => { 398 => 'permits' },
	'person' => { 416 => 'person' },
	'personality' => { 391 => 'Personality' },
	'personinimage' => { 411 => 'PersonInImage' },
	'personinimagecharacteristic' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 411 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 411 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 401 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 401 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 401 => 'PerspectiveRotate' },
	'perspectivescale' => { 401 => 'PerspectiveScale' },
	'perspectiveupright' => { 401 => 'PerspectiveUpright' },
	'perspectivevertical' => { 401 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 81 => 0x1 },
	'pf10retainprogramshift' => { 81 => 0xb },
	'pf13drivepriority' => { 81 => 0xe },
	'pf14disablefocussearch' => { 81 => 0xf },
	'pf15disableafassistbeam' => { 81 => 0x10 },
	'pf16autofocuspointshoot' => { 81 => 0x11 },
	'pf17disableafpointsel' => { 81 => 0x12 },
	'pf18enableautoafpointsel' => { 81 => 0x13 },
	'pf19continuousshootspeed' => { 81 => 0x14 },
	'pf19shootingspeedhigh' => { 80 => 0xa },
	'pf19shootingspeedlow' => { 80 => 0x9 },
	'pf1disableshootingmodes' => { 81 => 0x2 },
	'pf1value' => { 80 => 0x1 },
	'pf20limitcontinousshots' => { 81 => 0x15 },
	'pf20maxcontinousshots' => { 80 => 0xb },
	'pf21enablequietoperation' => { 81 => 0x16 },
	'pf23felocktime' => { 80 => 0xd },
	'pf23postreleasetime' => { 80 => 0xe },
	'pf23settimerlengths' => { 81 => 0x18 },
	'pf23shutterbuttontime' => { 80 => 0xc },
	'pf24lightlcdduringbulb' => { 81 => 0x19 },
	'pf25aemode' => { 80 => 0xf },
	'pf25afmode' => { 80 => 0x12 },
	'pf25afpointsel' => { 80 => 0x13 },
	'pf25colormatrix' => { 80 => 0x17 },
	'pf25defaultclearsettings' => { 81 => 0x1a },
	'pf25drivemode' => { 80 => 0x11 },
	'pf25imagesize' => { 80 => 0x14 },
	'pf25meteringmode' => { 80 => 0x10 },
	'pf25parameters' => { 80 => 0x16 },
	'pf25wbmode' => { 80 => 0x15 },
	'pf26shortenreleaselag' => { 81 => 0x1b },
	'pf27reversedialrotation' => { 81 => 0x1c },
	'pf27value' => { 80 => 0x18 },
	'pf28noquickdialexpcomp' => { 81 => 0x1d },
	'pf29quickdialswitchoff' => { 81 => 0x1e },
	'pf2disablemeteringmodes' => { 81 => 0x3 },
	'pf2value' => { 80 => 0x2 },
	'pf30enlargementmode' => { 81 => 0x1f },
	'pf31originaldecisiondata' => { 81 => 0x20 },
	'pf3manualexposuremetering' => { 81 => 0x4 },
	'pf3value' => { 80 => 0x3 },
	'pf4exposuretimelimits' => { 81 => 0x5 },
	'pf4exposuretimemax' => { 80 => 0x5 },
	'pf4exposuretimemin' => { 80 => 0x4 },
	'pf5aperturelimits' => { 81 => 0x6 },
	'pf5aperturemax' => { 80 => 0x7 },
	'pf5aperturemin' => { 80 => 0x6 },
	'pf6presetshootingmodes' => { 81 => 0x7 },
	'pf7bracketcontinuousshoot' => { 81 => 0x8 },
	'pf8bracketshots' => { 80 => 0x8 },
	'pf8setbracketshots' => { 81 => 0x9 },
	'pf9changebracketsequence' => { 81 => 0xa },
	'phasedetectaf' => { 170 => 0x6 },
	'phonenumber' => { 137 => 'Phone' },
	'photoeffect' => { 31 => 0x28 },
	'photoeffecthistoryxml' => { 230 => 0xe9651831 },
	'photoeffects' => { 230 => 0xab5eca5e },
	'photoeffectsblue' => { 232 => 0x8 },
	'photoeffectsgreen' => { 232 => 0x6 },
	'photoeffectsred' => { 232 => 0x4 },
	'photoeffectstype' => { 232 => 0x0 },
	'photographicsensitivity' => { 406 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 237 => '17.6', 243 => '33.6' },
	'photometricinterpretation' => { 106 => 0x106, 422 => 'PhotometricInterpretation' },
	'photoshopbgrthumbnail' => { 317 => 0x409 },
	'photoshopquality' => { 316 => 0x0 },
	'photoshopthumbnail' => { 317 => 0x40c },
	'photostyle' => { 270 => 0x89 },
	'picklabel' => { 404 => 'PickLabel' },
	'pictinfo' => { 336 => 0x208 },
	'picturecontrol' => { 230 => 0xe2173c47 },
	'picturecontrolactive' => { 233 => 0x0 },
	'picturecontroladjust' => { 196 => 0x30 },
	'picturecontrolbase' => { 196 => 0x18 },
	'picturecontroldata' => { 194 => [0xbd,0x23] },
	'picturecontrolmode' => { 233 => 0x13 },
	'picturecontrolname' => { 196 => 0x4 },
	'picturecontrolquickadjust' => { 196 => 0x31 },
	'pictureeffect' => { 357 => 0x200e },
	'pictureeffect2' => { 364 => 0x1163, 365 => 0x1167, 366 => 0x1143, 367 => 0x11bf, 368 => 0x119b, 369 => 0x1053, 370 => 0x24b, 371 => 0x24b, 382 => 0x46 },
	'picturefinish' => { 159 => 0x71 },
	'picturemode' => { 111 => 0x1031, 250 => 0x520, 303 => [0xb,0x33], 337 => 0x3d },
	'picturemode2' => { 284 => 0x0 },
	'picturemodebwfilter' => { 250 => 0x525 },
	'picturemodecontrast' => { 250 => 0x523 },
	'picturemodeeffect' => { 250 => 0x52d },
	'picturemodehue' => { 250 => 0x522 },
	'picturemodesaturation' => { 250 => 0x521 },
	'picturemodesharpness' => { 250 => 0x524 },
	'picturemodetone' => { 250 => 0x526 },
	'pictureprofile' => { 364 => [0x115e,0x115f], 365 => [0x1162,0x1163], 366 => [0x113e,0x113f], 367 => [0x11ba,0x11bb], 368 => [0x1196,0x1197], 369 => [0x104e,0x104f], 370 => [0x246,0x247], 371 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 65 => 0xa, 92 => 0x20301, 98 => 0x2 },
	'picturewizard' => { 334 => 0x21 },
	'picturewizardcolor' => { 333 => 0x1 },
	'picturewizardcontrast' => { 333 => 0x4 },
	'picturewizardmode' => { 333 => 0x0 },
	'picturewizardsaturation' => { 333 => 0x2 },
	'picturewizardsharpness' => { 333 => 0x3 },
	'pipelineversion' => { 154 => 'PipelineVersion' },
	'pitch' => { 238 => '4.1', 247 => '4.1' },
	'pitchangle' => { 210 => 0x350f, 250 => 0x904, 270 => 0x91, 302 => 0x2 },
	'pixelshiftresolution' => { 304 => 0x0 },
	'pixelsperunitx' => { 261 => 0x0 },
	'pixelsperunity' => { 261 => 0x4 },
	'pixelunits' => { 261 => 0x8 },
	'planarconfiguration' => { 106 => 0x11c, 422 => 'PlanarConfiguration' },
	'platenames' => { 431 => 'PlateNames' },
	'platform' => { 416 => 'platform' },
	'playbackmenustime' => { 240 => '20.1', 241 => '21.1', 242 => '21.1' },
	'playbackmonitorofftime' => { 237 => '25.2', 238 => '36.1', 243 => '8.1', 244 => '35.1', 247 => '36.1', 248 => '21.1' },
	'playbackzoom' => { 238 => '37.1' },
	'playdisplay' => { 161 => 0x4e },
	'plusversion' => { 414 => 'Version' },
	'pmversion' => { 315 => 'PMVersion' },
	'pngwarning' => { 262 => 'Warning' },
	'poilevel' => { 193 => 0x8 },
	'portraitoutputhighlightpoint' => { 98 => 0x1d },
	'portraitoutputshadowpoint' => { 98 => 0x1e },
	'portraitrawcolortone' => { 98 => 0x16 },
	'portraitrawcontrast' => { 98 => 0x18 },
	'portraitrawhighlight' => { 98 => 0x76 },
	'portraitrawhighlightpoint' => { 98 => 0x1b },
	'portraitrawlinear' => { 98 => 0x19 },
	'portraitrawsaturation' => { 98 => 0x17 },
	'portraitrawshadow' => { 98 => 0x7f },
	'portraitrawshadowpoint' => { 98 => 0x1c },
	'portraitrawsharpness' => { 98 => 0x1a },
	'portraitrefiner' => { 102 => 0x302b },
	'portraitunsharpmaskfineness' => { 98 => 0x9a },
	'portraitunsharpmaskstrength' => { 98 => 0x98 },
	'portraitunsharpmaskthreshold' => { 98 => 0x9c },
	'poseheadingdegrees' => { 390 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 390 => 'PosePitchDegrees' },
	'poserolldegrees' => { 390 => 'PoseRollDegrees' },
	'positiondescriptor' => { 415 => 'positionDescriptor' },
	'postalcode' => { 141 => 'PostalCode' },
	'postcropvignetteamount' => { 401 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 401 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 401 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 401 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 401 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 401 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 355 => 0xb },
	'potentialface2position' => { 355 => 0x15 },
	'potentialface3position' => { 355 => 0x1f },
	'potentialface4position' => { 355 => 0x29 },
	'potentialface5position' => { 355 => 0x33 },
	'potentialface6position' => { 355 => 0x3d },
	'potentialface7position' => { 355 => 0x47 },
	'potentialface8position' => { 355 => 0x51 },
	'powersource' => { 282 => '0.1' },
	'poweruptime' => { 194 => 0xb6 },
	'precaptureframes' => { 255 => 0x300 },
	'predictor' => { 106 => 0x13d },
	'preflashreturnstrength' => { 208 => 0x28a },
	'prefs' => { 114 => 0xdd, 315 => 'Prefs' },
	'preservedfilename' => { 427 => 'PreservedFileName' },
	'presetwhitebalance' => { 161 => 0x24, 386 => 0x8002 },
	'presetwhitebalanceadj' => { 386 => 0x8014 },
	'previewapplicationname' => { 106 => 0xc716 },
	'previewapplicationversion' => { 106 => 0xc717 },
	'previewbutton' => { 237 => ['14.1','15.1'], 238 => '15.1', 243 => '29.1', 244 => '14.1', 247 => '15.1' },
	'previewbuttonplusdials' => { 237 => ['14.2','15.2'], 238 => '15.2', 243 => '31.2', 247 => '43.1' },
	'previewcolorspace' => { 106 => 0xc71a },
	'previewcropbottom' => { 314 => 0xef },
	'previewcropleft' => { 314 => 0xec },
	'previewcropright' => { 314 => 0xee },
	'previewcroptop' => { 314 => 0xed },
	'previewdate' => { 322 => 0x0 },
	'previewdatetime' => { 106 => 0xc71b },
	'previewimage' => { 102 => 0x2000, 103 => 'PreviewImage', 107 => 'PreviewImage', 109 => 0x4, 146 => 'data', 163 => 0x81, 255 => 0x280, 269 => 0x300, 357 => 0x2001 },
	'previewimageborders' => { 303 => 0x3e },
	'previewimageheight' => { 64 => 0x4, 124 => 0xfa58 },
	'previewimagelength' => { 64 => 0x2, 102 => 0x3, 106 => [0x117,0x202], 163 => 0x89, 197 => 0x202, 250 => 0x102, 255 => 0x1037, 303 => 0x3, 327 => 0x1e, 332 => 0x3, 337 => [0x1b,0x1d], 348 => 0x202 },
	'previewimagename' => { 146 => '1Name' },
	'previewimagesize' => { 102 => 0x2, 129 => 0x2, 146 => 'ImageSize', 303 => 0x2, 337 => [0x1c,0x1e], 357 => 0xb02c },
	'previewimagestart' => { 64 => 0x5, 102 => 0x4, 106 => [0x111,0x201], 163 => 0x88, 197 => 0x201, 250 => 0x101, 255 => 0x1036, 303 => 0x4, 327 => 0x1c, 332 => 0x2, 337 => [0x1a,0x1c], 348 => 0x201 },
	'previewimagetype' => { 146 => '0Type' },
	'previewimagevalid' => { 250 => 0x100, 255 => 0x1035 },
	'previewimagewidth' => { 64 => 0x3, 124 => 0xfa57 },
	'previewquality' => { 64 => 0x1 },
	'previewsettingsdigest' => { 106 => 0xc719 },
	'previewsettingsname' => { 106 => 0xc718 },
	'primaryafpoint' => { 170 => 0x7 },
	'primarychromaticities' => { 106 => 0x13f, 422 => 'PrimaryChromaticities' },
	'printim' => { 106 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 161 => 0x1d, 345 => 0x28 },
	'privatertkinfo' => { 392 => 'privateRTKInfo' },
	'processingsoftware' => { 106 => 0xb },
	'processversion' => { 401 => 'ProcessVersion' },
	'producer' => { 259 => 'Producer', 412 => 'Producer' },
	'productcode' => { 416 => 'productCode' },
	'productid' => { 115 => 0x32, 415 => 'productID' },
	'productidtype' => { 415 => 'productIDType' },
	'productinimage' => { 411 => 'ProductInImage' },
	'productinimagedescription' => { 411 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 411 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 411 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 283 => 0x2 },
	'productorserviceconstraints' => { 414 => 'ProductOrServiceConstraints' },
	'profession' => { 416 => 'profession' },
	'profilecalibrationsig' => { 106 => 0xc6f4 },
	'profilecopyright' => { 106 => 0xc6fe },
	'profileembedpolicy' => { 106 => 0xc6fd },
	'profilehuesatmapdata1' => { 106 => 0xc6fa },
	'profilehuesatmapdata2' => { 106 => 0xc6fb },
	'profilehuesatmapdims' => { 106 => 0xc6f9 },
	'profilehuesatmapencoding' => { 106 => 0xc7a3 },
	'profilelooktabledata' => { 106 => 0xc726 },
	'profilelooktabledims' => { 106 => 0xc725 },
	'profilelooktableencoding' => { 106 => 0xc7a4 },
	'profilename' => { 106 => 0xc6f8 },
	'profiletonecurve' => { 106 => 0xc6fc },
	'programiso' => { 270 => 0x3c },
	'programline' => { 284 => '1.1' },
	'programmode' => { 166 => 0x5 },
	'programshift' => { 194 => 0xd },
	'programversion' => { 114 => 0x46 },
	'prohibits' => { 398 => 'prohibits' },
	'projectiontype' => { 390 => 'ProjectionType' },
	'projectname' => { 426 => 'projectName' },
	'projectref' => { 426 => 'projectRef' },
	'projectrefpath' => { 426 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 426 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 414 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 414 => 'PropertyReleaseStatus' },
	'province-state' => { 114 => 0x5f },
	'publicationdate' => { 416 => 'publicationDate' },
	'publicationdatea-platform' => { 416 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 416 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 416 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 416 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 416 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 416 => 'publicationName' },
	'publisher' => { 402 => 'publisher' },
	'publishingfrequency' => { 416 => 'publishingFrequency' },
	'pulldown' => { 426 => 'pullDown' },
	'purplehsl' => { 92 => 0x20916 },
	'quality' => { 0 => 0x1, 31 => 0x3, 101 => 0x2, 102 => 0x3002, 111 => 0x1000, 122 => 0x9, 194 => 0x4, 220 => 0x3, 255 => 0x201, 266 => 0x300, 303 => 0x8, 310 => 0x2, 337 => 0x16, 345 => 0x56, 346 => 0x56, 347 => 0xb, 357 => 0x102 },
	'quality2' => { 364 => 0x1170, 365 => 0x1174, 366 => 0x1150, 368 => 0x11a8, 369 => 0x1060, 370 => 0x258, 371 => 0x258, 374 => 0x29, 375 => 0x25, 376 => 0x2a },
	'qualitymode' => { 102 => 0x8 },
	'quantizationmethod' => { 116 => 0x78 },
	'quickadjust' => { 233 => 0x2a },
	'quickcontroldialinmeter' => { 73 => 0x703 },
	'quickfix' => { 230 => 0x416391c6 },
	'quickshot' => { 336 => 0x213 },
	'rangefinder' => { 240 => '4.1', 241 => '5.1', 242 => '5.1' },
	'rasterizedcaption' => { 114 => 0x7d },
	'rating' => { 106 => 0x4746, 111 => 0x1431, 314 => 0xdf, 357 => 0x2002, 395 => 'rating', 403 => 'rating', 416 => 'rating', 424 => 'Rating' },
	'ratingpercent' => { 106 => 0x4749, 156 => 'Rating' },
	'rawandjpgrecording' => { 71 => 0x8, 163 => 0x109, 284 => 0xd },
	'rawbrightnessadj' => { 92 => 0x20001, 97 => 0x38 },
	'rawcoloradj' => { 97 => 0x2e },
	'rawcompressionmode' => { 334 => 0x45 },
	'rawcropbottom' => { 314 => 0xd4 },
	'rawcropleft' => { 314 => 0xd1 },
	'rawcropright' => { 314 => 0xd3 },
	'rawcroptop' => { 314 => 0xd2 },
	'rawcustomsaturation' => { 97 => 0x30 },
	'rawcustomtone' => { 97 => 0x34 },
	'rawdata' => { 334 => 0xa048 },
	'rawdatauniqueid' => { 106 => 0xc65d },
	'rawdepth' => { 165 => 0x10 },
	'rawdevartfilter' => { 257 => 0x121 },
	'rawdevautogradation' => { 257 => 0x119 },
	'rawdevcolorspace' => { 256 => 0x108, 257 => 0x109 },
	'rawdevcontrastvalue' => { 256 => 0x106, 257 => 0x105 },
	'rawdeveditstatus' => { 256 => 0x10b },
	'rawdevelopmentprocess' => { 303 => 0x62 },
	'rawdevengine' => { 256 => 0x109, 257 => 0x10b },
	'rawdevexposurebiasvalue' => { 256 => 0x100, 257 => 0x100 },
	'rawdevgradation' => { 257 => 0x112 },
	'rawdevgraypoint' => { 256 => 0x103, 257 => 0x104 },
	'rawdevmemorycoloremphasis' => { 256 => 0x105, 257 => 0x108 },
	'rawdevnoisereduction' => { 256 => 0x10a, 257 => 0x10a },
	'rawdevpicturemode' => { 257 => 0x10c },
	'rawdevpm_bwfilter' => { 257 => 0x110 },
	'rawdevpmcontrast' => { 257 => 0x10e },
	'rawdevpmnoisefilter' => { 257 => 0x120 },
	'rawdevpmpicturetone' => { 257 => 0x111 },
	'rawdevpmsaturation' => { 257 => 0x10d },
	'rawdevpmsharpness' => { 257 => 0x10f },
	'rawdevsaturation3' => { 257 => 0x113 },
	'rawdevsaturationemphasis' => { 256 => 0x104, 257 => 0x107 },
	'rawdevsettings' => { 256 => 0x10c },
	'rawdevsharpnessvalue' => { 256 => 0x107, 257 => 0x106 },
	'rawdevversion' => { 256 => 0x0, 257 => 0x0 },
	'rawdevwbfineadjustment' => { 256 => 0x102, 257 => 0x103 },
	'rawdevwhitebalance' => { 257 => 0x101 },
	'rawdevwhitebalancevalue' => { 256 => 0x101, 257 => 0x102 },
	'rawfile' => { 106 => 0xfe4c },
	'rawfilename' => { 401 => 'RawFileName' },
	'rawformat' => { 312 => 0x10e },
	'rawimagecenter' => { 194 => 0x99 },
	'rawimagedigest' => { 106 => 0xc71c },
	'rawimagesize' => { 303 => 0x39 },
	'rawinfoversion' => { 258 => 0x0 },
	'rawjpgheight' => { 88 => 0x4 },
	'rawjpgquality' => { 49 => 0x6, 88 => 0x1 },
	'rawjpgsize' => { 49 => 0x7, 88 => 0x2 },
	'rawjpgwidth' => { 88 => 0x3 },
	'rawmeasuredrggb' => { 36 => 0x26a, 38 => 0x280, 40 => 0x194, 41 => [0x1ad,0x26b] },
	'rawrppused' => { 395 => 'rawrppused' },
	'rawtopreviewgain' => { 106 => 0xc7a8 },
	'reardisplay' => { 237 => '12.3', 238 => '6.2' },
	'recipeendingpage' => { 418 => 'recipeEndingPage' },
	'recipepagerange' => { 418 => 'recipePageRange' },
	'recipesource' => { 418 => 'recipeSource' },
	'recipestartingpage' => { 418 => 'recipeStartingPage' },
	'recipetitle' => { 418 => 'recipeTitle' },
	'recognizedface1age' => { 265 => 0x20 },
	'recognizedface1name' => { 265 => 0x4 },
	'recognizedface1position' => { 265 => 0x18 },
	'recognizedface2age' => { 265 => 0x50 },
	'recognizedface2name' => { 265 => 0x34 },
	'recognizedface2position' => { 265 => 0x48 },
	'recognizedface3age' => { 265 => 0x80 },
	'recognizedface3name' => { 265 => 0x64 },
	'recognizedface3position' => { 265 => 0x78 },
	'recognizedfaceflags' => { 270 => 0x63 },
	'recommendedexposureindex' => { 106 => 0x8832, 406 => 'RecommendedExposureIndex' },
	'record' => { 105 => 'Record' },
	'recordbasisofrecord' => { 105 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 105 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 105 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 105 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 105 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 105 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 161 => 0x4d },
	'recorddynamicproperties' => { 105 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 86 => 0x1804 },
	'recordinformationwithheld' => { 105 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 328 => 0x1000 },
	'recordingmode' => { 101 => 0x1, 310 => 0x1 },
	'recordinstitutioncode' => { 105 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 105 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 31 => 0x9, 102 => 0x3000 },
	'recordownerinstitutioncode' => { 105 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 336 => 0x217 },
	'redbalance' => { 178 => 0x270, 255 => 0x1017, 274 => 0x11, 303 => 0x1c },
	'redcurvelimits' => { 97 => 0x18a },
	'redcurvepoints' => { 96 => 0x2d, 97 => 0x160 },
	'redeyecorrection' => { 234 => 0x0 },
	'redeyeinfo' => { 401 => 'RedEyeInfo' },
	'redeyereduction' => { 161 => 0x41, 345 => 0x6a, 347 => 0x28 },
	'redhsl' => { 92 => 0x20910 },
	'redhue' => { 401 => 'RedHue' },
	'redsaturation' => { 401 => 'RedSaturation' },
	'reductionmatrix1' => { 106 => 0xc625 },
	'reductionmatrix2' => { 106 => 0xc626 },
	'reelname' => { 106 => 0xc789 },
	'reference1' => { 409 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 409 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 106 => 0x214, 422 => 'ReferenceBlackWhite' },
	'referencedate' => { 114 => 0x2f },
	'referencenumber' => { 114 => 0x32 },
	'references' => { 137 => 'References' },
	'referenceservice' => { 114 => 0x2d },
	'regionappliedtodimensions' => { 152 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 152 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 152 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 152 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 152 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 152 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 152 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 152 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 152 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 152 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 152 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 152 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 414 => 'RegionConstraints' },
	'regiondescription' => { 152 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 152 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 152 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 152 => 'Regions' },
	'regioninfodateregionsvalid' => { 153 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 153 => 'RegionInfo' },
	'regioninforegions' => { 153 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 152 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 152 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 153 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 153 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 152 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 152 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 152 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 411 => 'RegistryId' },
	'registryitemid' => { 411 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 411 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 135 => 'data' },
	'relatedaudiofilename' => { 135 => '1Name' },
	'relatedaudiofiletype' => { 135 => '0Type' },
	'relatedimagefileformat' => { 106 => 0x1000 },
	'relatedimageheight' => { 106 => 0x1002 },
	'relatedimagewidth' => { 106 => 0x1001 },
	'relatedresourceid' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 106 => 0xa004, 405 => 'RelatedSoundFile' },
	'relatedvideofile' => { 149 => 'data' },
	'relatedvideofilename' => { 149 => '1Name' },
	'relatedvideofiletype' => { 149 => '0Type' },
	'relation' => { 402 => 'relation' },
	'relationshipaccordingto' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 105 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 426 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 426 => 'relativeTimestamp' },
	'relativetimestampscale' => { 426 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 426 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 237 => '17.8', 238 => '18.5', 243 => '33.8', 244 => '17.6', 247 => '18.5' },
	'releasedate' => { 114 => 0x1e, 395 => 'ReleaseDate', 426 => 'releaseDate' },
	'releasemode' => { 102 => 0x3001, 357 => 0xb049 },
	'releasemode2' => { 364 => 0x112c, 365 => [0x112c,0x8], 366 => [0x1108,0x8], 367 => [0x1184,0x8], 368 => [0x1160,0x8], 369 => [0x4,0x1018], 370 => [0x4,0x210], 371 => [0x4,0x210], 373 => [0x67,0x73,0x3f,0x4b], 374 => 0x10, 375 => 0x10, 376 => 0x9, 382 => 0x34 },
	'releasemode3' => { 364 => 0x1128, 365 => 0x1128, 366 => 0x1104, 367 => 0x1180, 368 => 0x115c, 369 => 0x1014, 370 => 0x20c, 371 => 0x20c },
	'releasesetting' => { 86 => 0x1016 },
	'releasetime' => { 114 => 0x23, 395 => 'ReleaseTime' },
	'remoteonduration' => { 239 => '3.4', 240 => '17.2', 241 => '18.2', 242 => '18.2', 244 => '18.2', 245 => '4.3', 248 => '19.2' },
	'renditionclass' => { 427 => 'RenditionClass' },
	'renditionof' => { 427 => 'RenditionOf' },
	'renditionofalternatepaths' => { 427 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 427 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 427 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 427 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 427 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 427 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 427 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 427 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 427 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 427 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 427 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 427 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 427 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 427 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 427 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 427 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 427 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 427 => 'RenditionParams' },
	'repeatingflashcount' => { 183 => 0xd, 184 => 0xe, 185 => 0xe, 243 => '17.2', 244 => '24.2', 245 => '9.2', 246 => '24.2', 248 => '25.2' },
	'repeatingflashcountbuilt-in' => { 217 => 0x4db },
	'repeatingflashcountexternal' => { 217 => 0x4c3 },
	'repeatingflashoutput' => { 243 => '17.1', 244 => '24.1', 245 => '9.1', 246 => '24.1', 248 => '25.1' },
	'repeatingflashoutputexternal' => { 217 => 0x4c0 },
	'repeatingflashrate' => { 183 => 0xc, 184 => 0xd, 185 => 0xd, 243 => '18.1', 244 => '25.1', 245 => '10.1', 246 => '25.1', 248 => '26.1' },
	'repeatingflashratebuilt-in' => { 217 => 0x4da },
	'repeatingflashrateexternal' => { 217 => 0x4c2 },
	'requires' => { 398 => 'requires' },
	'resampleparams' => { 426 => 'resampleParams' },
	'resampleparamsquality' => { 426 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 336 => 0x21e },
	'resolution' => { 142 => 'Resolution' },
	'resolutionmode' => { 337 => 0x4 },
	'resolutionunit' => { 106 => 0x128, 117 => 0x2, 422 => 'ResolutionUnit' },
	'resourceid' => { 105 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 105 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 105 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 73 => 0x612 },
	'restrictions' => { 419 => 'restrictions' },
	'retouchareafeather' => { 401 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 401 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 401 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 401 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 401 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 401 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 401 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 401 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 401 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 401 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 401 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 401 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 401 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 401 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 401 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 401 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 401 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 401 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 401 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 401 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 401 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 401 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 401 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 401 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 401 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 401 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 401 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 401 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 401 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 401 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 401 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 401 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 401 => 'RetouchAreas' },
	'retouchareaseed' => { 401 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 401 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 401 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 401 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 194 => 0x9e },
	'retouchinfo' => { 401 => 'RetouchInfo' },
	'retouchnefprocessing' => { 199 => 0x5 },
	'retractlensonpoweroff' => { 73 => 0x814 },
	'reuse' => { 414 => 'Reuse' },
	'reuseallowed' => { 429 => 'ReuseAllowed' },
	'reuseprohibited' => { 419 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 242 => '5.2' },
	'reverseindicators' => { 237 => '12.1', 238 => '6.1', 240 => '4.3', 241 => '5.2', 242 => '5.4', 243 => '33.5', 244 => '5.1', 247 => '6.1', 248 => '6.2' },
	'reverseshutterspeedaperture' => { 242 => '5.3' },
	'revision' => { 403 => 'revision' },
	'rgbcurvelimits' => { 97 => 0x238 },
	'rgbcurvepoints' => { 96 => 0x7, 97 => 0x20e },
	'richtextcomment' => { 408 => 'RichTextComment' },
	'ricohdate' => { 327 => 0x6 },
	'ricohimageheight' => { 327 => 0x2 },
	'ricohimagewidth' => { 327 => 0x0 },
	'rightascension' => { 145 => 'RightAscension' },
	'rights' => { 402 => 'rights' },
	'rightsagent' => { 419 => 'rightsAgent' },
	'rightsowner' => { 419 => 'rightsOwner' },
	'rollangle' => { 210 => 0x350b, 250 => 0x903, 270 => 0x90, 302 => 0x1 },
	'romoperationmode' => { 86 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 85 => 0x3, 92 => 0x10002, 97 => 0x26e, 110 => 0x4, 145 => 'Rotation', 159 => [0x65,0x50], 160 => 0x46, 161 => 0x5a, 164 => 0x10, 216 => '590.1', 230 => 0x76a43207, 270 => 0x30, 284 => '17.2', 314 => 0xd8, 345 => 0x3f, 346 => 0x3f, 356 => 0x10 },
	'routedto' => { 407 => 'RoutedTo' },
	'routing' => { 319 => 'Routing' },
	'routingnotes' => { 407 => 'RoutingNotes' },
	'rowsperstrip' => { 106 => 0x116 },
	'rpp' => { 395 => 'rpp' },
	'safetyshift' => { 73 => 0x108 },
	'safetyshiftinavortv' => { 71 => 0x10, 72 => 0x10, 74 => 0xf, 75 => 0x10, 78 => 0x10 },
	'sameexposurefornewaperture' => { 73 => 0x112 },
	'samplebits' => { 135 => 'SampleBits' },
	'samplepagerange' => { 416 => 'samplePageRange' },
	'samplerate' => { 135 => 'SampleRate' },
	'samplesperpixel' => { 106 => 0x115, 422 => 'SamplesPerPixel' },
	'samplestructure' => { 116 => 0x5a },
	'samsungmodelid' => { 334 => 0x3 },
	'sanyoquality' => { 336 => 0x201 },
	'sanyothumbnail' => { 336 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 31 => 0xe, 43 => 0x1, 101 => 0xd, 102 => [0x3013,0x1f], 106 => [0xa409,0xfe55], 111 => 0x1003, 136 => 'Saturation', 158 => 0x1f, 159 => 0x32, 160 => 0x28, 161 => 0x1a, 166 => 0x1, 194 => [0x94,0xaa], 196 => 0x35, 270 => 0x40, 272 => 0x300d, 303 => 0x1f, 310 => 0xd, 324 => 0x27, 327 => 0x28, 328 => 0x1013, 337 => 0x10, 345 => 0x1e, 346 => 0x1b, 357 => 0x2005, 401 => 'Saturation', 405 => 'Saturation' },
	'saturationadj' => { 92 => 0x20901, 97 => 0x116, 229 => 0x1, 233 => 0x2e, 386 => 0x8016 },
	'saturationadjustmentaqua' => { 401 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 401 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 401 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 401 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 401 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 401 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 401 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 401 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 62 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 61 => 0x68, 62 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 61 => 0x38, 62 => 0x38 },
	'saturationmonochrome' => { 61 => 0x80, 62 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 61 => 0x50, 62 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 61 => 0x20, 62 => 0x20 },
	'saturationsetting' => { 258 => 0x1010, 347 => 0x11, 361 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 61 => 0x8, 62 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 61 => 0x98, 62 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 61 => 0xb0, 62 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 61 => 0xc8, 62 => 0xe0 },
	'saveid' => { 427 => 'SaveID' },
	'scaletype' => { 426 => 'scaleType' },
	'scanimageenhancer' => { 200 => 0x60 },
	'scanningdirection' => { 116 => 0x64 },
	'scene' => { 410 => 'Scene', 426 => 'scene' },
	'scenearea' => { 253 => 0x211, 255 => 0x1031 },
	'sceneassist' => { 194 => 0x9c },
	'scenecapturetype' => { 106 => 0xa406, 405 => 'SceneCaptureType' },
	'scenedetect' => { 253 => 0x210, 255 => 0x1030 },
	'scenedetectdata' => { 253 => 0x212, 255 => 0x1033 },
	'scenemode' => { 124 => 0xfa02, 163 => 0x100, 194 => 0x8f, 250 => 0x509, 255 => 0x403, 270 => 0x8001, 278 => 0xf, 357 => 0xb023 },
	'scenemodeused' => { 126 => [0x6002,0xf002] },
	'sceneselect' => { 336 => 0x21f },
	'scenetype' => { 106 => 0xa301, 405 => 'SceneType' },
	'screentips' => { 237 => '12.7', 238 => '5.3', 243 => '13.1', 244 => '4.4', 247 => '5.4', 248 => '5.1' },
	'season' => { 415 => 'season' },
	'section' => { 416 => 'section' },
	'securityclassification' => { 106 => 0x9212 },
	'selectableafpoint' => { 73 => 0x509 },
	'selectafareaselectmode' => { 73 => 0x512 },
	'selftimer' => { 31 => 0x2, 270 => 0x2e, 336 => 0x214, 364 => 0x1134, 365 => 0x1134, 366 => 0x1110, 367 => 0x118c, 368 => 0x1168, 369 => 0x1020, 370 => 0x218, 371 => 0x218 },
	'selftimer2' => { 67 => 0x1d },
	'selftimerinterval' => { 244 => '19.2' },
	'selftimermode' => { 106 => 0x882b },
	'selftimershotcount' => { 238 => '20.2', 240 => '18.2', 241 => '19.2', 242 => '19.2', 244 => '19.3', 247 => '20.3', 248 => '20.2' },
	'selftimershotinterval' => { 238 => '20.3', 247 => '20.2' },
	'selftimertime' => { 86 => 0x1806, 161 => 0x1f, 237 => '18.1', 238 => '20.1', 239 => '3.3', 240 => '18.1', 241 => '19.1', 242 => '19.1', 243 => '7.2', 244 => '19.1', 245 => '3.3', 247 => '20.1', 248 => '20.1' },
	'sellingagency' => { 416 => 'sellingAgency' },
	'seminfo' => { 106 => 0x8546 },
	'sensingmethod' => { 106 => 0xa217, 405 => 'SensingMethod' },
	'sensitivityadjust' => { 303 => 0x40 },
	'sensitivitysteps' => { 284 => ['14.3','17.4'], 286 => 0x1 },
	'sensitivitytype' => { 106 => 0x8830, 406 => 'SensitivityType' },
	'sensor' => { 168 => 0x665e },
	'sensorareas' => { 334 => 0xa010 },
	'sensorbitdepth' => { 272 => 0x312d },
	'sensorbluelevel' => { 65 => 0x5 },
	'sensorcalibration' => { 254 => 0x805 },
	'sensorcleaning' => { 79 => 0xd },
	'sensorfullheight' => { 119 => 0xf904 },
	'sensorfullwidth' => { 119 => 0xf903 },
	'sensorheight' => { 119 => 0xf901, 124 => 0xfa21, 165 => 0x8, 272 => 0x312c, 312 => 0x109, 328 => 0x1602 },
	'sensorleftmargin' => { 312 => 0x10a },
	'sensorpixelsize' => { 194 => 0x9a },
	'sensorredlevel' => { 65 => 0x4 },
	'sensorserialnumber' => { 120 => 0x9ce },
	'sensorsize' => { 136 => 'SensorSize', 303 => 0x35 },
	'sensortemperature' => { 253 => 0x1500, 255 => 0x1007, 308 => 0xc, 312 => 0x210, 337 => [0x39,0x55] },
	'sensortemperature2' => { 308 => 0xe, 312 => 0x211 },
	'sensortopmargin' => { 312 => 0x10b },
	'sensorwidth' => { 119 => 0xf900, 124 => 0xfa20, 165 => 0xa, 272 => 0x312b, 312 => 0x108, 328 => 0x1601 },
	'sequence' => { 324 => 0x7 },
	'sequencefilenumber' => { 365 => 0x4, 366 => 0x4, 367 => 0x4, 368 => 0x4, 374 => 0xc, 375 => 0xc, 376 => 0x1a },
	'sequenceimagenumber' => { 365 => 0x0, 366 => 0x0, 367 => 0x0, 368 => 0x0, 374 => 0x8, 375 => 0x8, 376 => 0x12, 382 => 0x24 },
	'sequencelength' => { 374 => 0x22, 375 => 0x1e, 376 => [0x16,0x1e] },
	'sequencename' => { 415 => 'sequenceName' },
	'sequencenumber' => { 67 => 0x9, 102 => 0x301c, 111 => 0x1101, 122 => 0x1d, 217 => 0x51c, 270 => 0x2b, 347 => [0x10c,0x30c], 357 => 0xb04a, 415 => 'sequenceNumber' },
	'sequenceshotinterval' => { 336 => 0x224 },
	'sequencetotalnumber' => { 415 => 'sequenceTotalNumber' },
	'sequentialshot' => { 336 => 0x20e },
	'serialnumber' => { 55 => 0xc, 86 => 0x180b, 106 => [0xa431,0xfde9], 119 => 0xfa04, 121 => 0xfa00, 123 => 0xc354, 124 => 0xfa19, 133 => 0x0, 136 => 'SerialNumber', 194 => [0xa0,0x1d], 251 => 0x101, 255 => [0x404,0x101a], 266 => 0x303, 272 => 0x3103, 303 => 0x229, 312 => 0x102, 313 => 0x407, 324 => 0x15, 328 => 0x5, 337 => 0x2, 397 => 'SerialNumber', 406 => 'BodySerialNumber' },
	'serialnumberformat' => { 55 => 0x15, 86 => 0x183b },
	'seriesdatetime' => { 388 => 'SeriesDateTime' },
	'seriesdescription' => { 388 => 'SeriesDescription' },
	'seriesmodality' => { 388 => 'SeriesModality' },
	'seriesnumber' => { 388 => 'SeriesNumber', 416 => 'seriesNumber' },
	'seriestitle' => { 416 => 'seriesTitle' },
	'serviceidentifier' => { 115 => 0x1e },
	'servingsize' => { 418 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 76 => 0x0, 77 => 0x0 },
	'setbuttonwhenshooting' => { 71 => 0x1, 73 => 0x704, 79 => 0xc },
	'setfunctionwhenshooting' => { 74 => 0x0, 75 => 0x1, 78 => 0x1 },
	'setting' => { 415 => 'setting' },
	'shadingcompensation' => { 250 => 0x50c, 270 => 0x8a },
	'shadingcompensation2' => { 254 => 0x1012 },
	'shadow' => { 337 => 0xe },
	'shadowadj' => { 92 => 0x2030b },
	'shadowcorrection' => { 303 => 0x79 },
	'shadowprotection' => { 229 => 0x0 },
	'shadows' => { 106 => 0xfe52, 394 => 'Shadows', 401 => 'Shadows' },
	'shadows2012' => { 401 => 'Shadows2012' },
	'shadowscale' => { 106 => 0xc633 },
	'shadowtint' => { 401 => 'ShadowTint' },
	'shadowtone' => { 111 => 0x1040 },
	'shakereduction' => { 305 => 0x1, 306 => 0x1 },
	'sharpendetail' => { 401 => 'SharpenDetail' },
	'sharpenedgemasking' => { 401 => 'SharpenEdgeMasking' },
	'sharpening' => { 272 => 0x300b },
	'sharpeningadj' => { 233 => 0x2b },
	'sharpenradius' => { 401 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 31 => 0xf, 65 => 0x2, 101 => 0xb, 102 => [0x3011,0x21], 106 => [0xa40a,0xfe56], 111 => 0x1001, 122 => 0x6b, 131 => 0x37, 136 => 'Sharpness', 158 => 0x21, 159 => 0x30, 160 => 0x26, 161 => 0x18, 166 => 0x3, 194 => 0x6, 196 => 0x32, 255 => 0x100f, 270 => 0x41, 303 => 0x21, 310 => 0xb, 324 => 0x26, 327 => 0x22, 328 => [0x1003,0x1014], 337 => 0x11, 345 => 0x1c, 346 => 0x19, 357 => 0x2006, 382 => 0x52, 401 => 'Sharpness', 405 => 'Sharpness' },
	'sharpnessadj' => { 92 => 0x20310, 97 => 0x25a, 386 => 0x801a },
	'sharpnessadjon' => { 92 => '0x20310.0' },
	'sharpnessauto' => { 62 => 0x94 },
	'sharpnessfactor' => { 255 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 61 => 0x64, 62 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 65 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 61 => 0x34, 62 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 61 => 0x7c, 62 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 61 => 0x4c, 62 => 0x4c },
	'sharpnessovershoot' => { 386 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 61 => 0x1c, 62 => 0x1c },
	'sharpnesssetting' => { 250 => 0x506, 258 => 0x1013, 347 => 0x12, 361 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 61 => 0x4, 62 => 0x4 },
	'sharpnessstrength' => { 92 => 0x20311 },
	'sharpnessthreshold' => { 386 => 0x801d },
	'sharpnessundershoot' => { 386 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 61 => 0x94, 62 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 61 => 0xac, 62 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 61 => 0xc4, 62 => 0xdc },
	'shootid' => { 415 => 'shootID' },
	'shootingdistance' => { 92 => 0x20701 },
	'shootinginfodisplay' => { 237 => '13.2', 238 => '5.1', 243 => '10.2', 244 => '4.1', 247 => '5.1', 248 => '5.3' },
	'shootinginfomonitorofftime' => { 237 => '26.2', 238 => '22.2', 243 => '9.1', 244 => '21.2', 247 => '22.2', 248 => '22.2' },
	'shootingmode' => { 136 => 'ShootingMode', 194 => 0x89, 270 => 0x1f },
	'shootingmodesetting' => { 239 => '5.1' },
	'shortdescription' => { 403 => 'shortdescription' },
	'shortdocumentid' => { 114 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 73 => 0x80d },
	'shotdate' => { 426 => 'shotDate' },
	'shotday' => { 426 => 'shotDay' },
	'shotlocation' => { 426 => 'shotLocation' },
	'shotname' => { 426 => 'shotName' },
	'shotnumber' => { 426 => 'shotNumber' },
	'shotnumbersincepowerup' => { 360 => 0x44e, 374 => 0x1a, 375 => 0x16, 376 => 0xa },
	'shotnumbersincepowerup2' => { 347 => 0x200 },
	'shotsize' => { 426 => 'shotSize' },
	'shutter-aelock' => { 71 => 0x4, 73 => 0x701, 74 => 0x3, 75 => 0x4, 76 => 0x3, 77 => 0x3, 78 => 0x4, 79 => 0x2 },
	'shutteraelbutton' => { 72 => 0x4 },
	'shutterbuttonafonbutton' => { 73 => 0x701 },
	'shuttercount' => { 10 => 0x176, 49 => 0x1, 194 => 0xa7, 201 => [0x6a,0x157,0x24d], 202 => 0x286, 203 => 0x279, 204 => 0x284, 205 => 0x242, 206 => 0x280, 207 => 0x276, 208 => [0x27d,0x27f], 209 => 0x246, 211 => 0x2d6, 212 => 0x321, 213 => 0xbd8, 214 => 0x287, 215 => 0x320, 216 => 0x24a, 217 => 0x5fb, 219 => 0x2d5, 303 => 0x5d, 356 => 0x846, 359 => [0x125,0x14a] },
	'shuttercurtainsync' => { 71 => 0xf, 72 => 0xf, 73 => 0x305, 74 => 0xe, 75 => 0xf, 76 => 0x8, 77 => 0x8, 78 => 0xf, 79 => 0x8 },
	'shuttermode' => { 122 => 0x1b },
	'shutterreleasebuttonae-l' => { 237 => '17.7', 238 => '18.4', 240 => '16.1', 241 => '17.1', 242 => '17.1', 243 => '7.1', 244 => '17.5', 247 => '18.4', 248 => '18.2' },
	'shutterreleasemethod' => { 86 => 0x1010 },
	'shutterreleasenocfcard' => { 71 => 0x2, 72 => 0x2, 79 => 0xf },
	'shutterreleasetiming' => { 86 => 0x1011 },
	'shutterreleasewithoutlens' => { 73 => 0x711 },
	'shutterspeedlock' => { 238 => '38.1', 247 => '38.1' },
	'shutterspeedrange' => { 73 => 0x10c },
	'shutterspeedsetting' => { 161 => 0x6, 345 => 0x2f, 346 => 0x28, 347 => 0x0 },
	'shutterspeedvalue' => { 82 => 0x1, 106 => 0x9201, 255 => 0x1000, 312 => 0x400, 405 => 'ShutterSpeedValue' },
	'shuttertype' => { 111 => 0x1050, 270 => 0x9f },
	'sidecarforextension' => { 413 => 'SidecarForExtension' },
	'similarityindex' => { 114 => 0xe4 },
	'singleframebracketing' => { 161 => 0x21 },
	'skilllevel' => { 418 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 303 => 0x20b },
	'slideshowname' => { 415 => 'slideshowName' },
	'slideshownumber' => { 415 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 415 => 'slideshowTotalNumber' },
	'slowshutter' => { 67 => 0x8 },
	'slowsync' => { 111 => 0x1030 },
	'smartrange' => { 334 => 0xa012 },
	'smileshutter' => { 347 => 0x31 },
	'smileshuttermode' => { 347 => 0x27 },
	'smoothness' => { 106 => 0xfe57, 401 => 'Smoothness' },
	'snapshots' => { 395 => 'Snapshots' },
	'softskineffect' => { 357 => 0x200f },
	'software' => { 106 => 0x131, 137 => 'Software', 262 => 'Software', 312 => 0x203, 337 => 0x18, 422 => 'Software' },
	'softwareversion' => { 336 => 0x207 },
	'sonydatetime' => { 363 => 0x6, 365 => 0x1b6, 366 => 0x210, 367 => 0x1fe, 368 => 0x22c },
	'sonydatetime2' => { 373 => [0x51,0x5d] },
	'sonyexposuretime' => { 373 => 0x46 },
	'sonyexposuretime2' => { 382 => 0xe },
	'sonyfnumber' => { 373 => [0x3c,0x48], 382 => 0x14 },
	'sonyimageheight' => { 363 => 0x1a, 374 => 0x44, 375 => 0x3f, 376 => 0x47 },
	'sonyimagesize' => { 161 => 0x3b, 345 => 0x54, 346 => 0x54, 347 => 0x9 },
	'sonyimagewidth' => { 363 => 0x1c },
	'sonyiso' => { 365 => 0x1218, 366 => 0x11f4, 367 => 0x1270, 368 => [0x1254,0x1258,0x1280], 369 => 0x113c, 370 => 0x344, 371 => 0x346, 382 => 0x4 },
	'sonymaxaperturevalue' => { 382 => 0x16 },
	'sonymodelid' => { 357 => 0xb001 },
	'sonyquality' => { 161 => 0x3c },
	'source' => { 114 => 0x73, 262 => 'Source', 402 => 'source', 403 => 'source', 413 => 'Source' },
	'sourcedirectoryindex' => { 290 => 0x0 },
	'sourcefileindex' => { 290 => 0x2 },
	'sourcephotoscount' => { 390 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 405 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 405 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 405 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 405 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 405 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 426 => 'speakerPlacement' },
	'specialeffectlevel' => { 102 => 0x3030 },
	'specialeffectmode' => { 102 => 0x2076 },
	'specialeffectsetting' => { 102 => 0x3031 },
	'specialinstructions' => { 114 => 0x28 },
	'specialmode' => { 255 => 0x200, 336 => 0x200 },
	'specialoccasion' => { 418 => 'specialOccasion' },
	'spectralsensitivity' => { 106 => 0x8824, 405 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 38 => [0x2b9,0x2d0,0x2d4], 40 => 0x1e4, 41 => [0x1fd,0x2dd], 42 => 0x30f },
	'splitcolumn' => { 312 => 0x222 },
	'splittoningbalance' => { 401 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 401 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 401 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 401 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 401 => 'SplitToningShadowSaturation' },
	'sport' => { 416 => 'sport' },
	'spotfocuspointx' => { 158 => 0x2d },
	'spotfocuspointy' => { 158 => 0x2e },
	'spotmeteringmode' => { 31 => 0x27 },
	'spotmeterlinktoafpoint' => { 73 => 0x107 },
	'sractive' => { 284 => '17.1' },
	'srawquality' => { 31 => 0x2e },
	'srfocallength' => { 305 => 0x3 },
	'srhalfpresstime' => { 305 => 0x2 },
	'srresult' => { 305 => 0x0, 306 => 0x0 },
	'stackedimage' => { 250 => 0x804 },
	'standardoutputhighlightpoint' => { 98 => 0x14 },
	'standardoutputsensitivity' => { 106 => 0x8831, 406 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 98 => 0x15 },
	'standardrawcolortone' => { 98 => 0xd },
	'standardrawcontrast' => { 98 => 0xf },
	'standardrawhighlight' => { 98 => 0x75 },
	'standardrawhighlightpoint' => { 98 => 0x12 },
	'standardrawlinear' => { 98 => 0x10 },
	'standardrawsaturation' => { 98 => 0xe },
	'standardrawshadow' => { 98 => 0x7e },
	'standardrawshadowpoint' => { 98 => 0x13 },
	'standardrawsharpness' => { 98 => 0x11 },
	'standardunsharpmaskfineness' => { 98 => 0x94 },
	'standardunsharpmaskstrength' => { 98 => 0x92 },
	'standardunsharpmaskthreshold' => { 98 => 0x96 },
	'standbytimer' => { 238 => '19.1', 242 => '18.1', 247 => '19.1' },
	'startingpage' => { 416 => 'startingPage' },
	'startmovieshooting' => { 73 => 0x70d },
	'starttimecode' => { 426 => 'startTimecode' },
	'starttimecodetimeformat' => { 426 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 426 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 426 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 426 => 'startTimeSampleSize' },
	'starttimescale' => { 426 => 'startTimeScale' },
	'state' => { 141 => 'State', 270 => 0x6b, 413 => 'State' },
	'status' => { 389 => 'Status', 393 => 'Status' },
	'stitchingsoftware' => { 390 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 364 => 0x113e, 365 => 0x113e, 366 => 0x111a, 367 => 0x1196, 368 => 0x1172, 369 => 0x102a, 370 => 0x222, 371 => 0x222, 382 => 0xa },
	'storagemethod' => { 165 => 0x12 },
	'storebyorientation' => { 238 => '46.3', 247 => '47.3' },
	'straightenangle' => { 230 => 0x2fc08431 },
	'streamtype' => { 154 => 'StreamType' },
	'stretchmode' => { 426 => 'stretchMode' },
	'studydatetime' => { 388 => 'StudyDateTime' },
	'studydescription' => { 388 => 'StudyDescription' },
	'studyid' => { 388 => 'StudyID' },
	'studyphysician' => { 388 => 'StudyPhysician' },
	'sub-location' => { 114 => 0x5c },
	'subfiledata' => { 144 => 'data' },
	'subfiledirectory' => { 144 => '1Directory' },
	'subfilemimetype' => { 144 => '2MIME' },
	'subfilename' => { 144 => '1Name' },
	'subfileresource' => { 144 => 'rsrc' },
	'subfiletype' => { 106 => 0xfe, 144 => '0Type' },
	'subject' => { 259 => 'Subject', 319 => 'Subject', 402 => 'subject', 412 => 'Subject', 427 => 'subject' },
	'subjectarea' => { 106 => 0x9214, 405 => 'SubjectArea' },
	'subjectcode' => { 410 => 'SubjectCode' },
	'subjectdistance' => { 106 => 0x9206, 122 => 0x3e, 405 => 'SubjectDistance' },
	'subjectdistancerange' => { 106 => 0xa40c, 405 => 'SubjectDistanceRange' },
	'subjectlocation' => { 106 => 0xa214, 405 => 'SubjectLocation' },
	'subjectprogram' => { 158 => 0x22 },
	'subjectreference' => { 114 => 0xc },
	'sublabels4' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 409 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 409 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 106 => 0x9290 },
	'subsectimedigitized' => { 106 => 0x9292 },
	'subsectimeoriginal' => { 106 => 0x9291 },
	'subsection1' => { 416 => 'subsection1' },
	'subsection2' => { 416 => 'subsection2' },
	'subsection3' => { 416 => 'subsection3' },
	'subsection4' => { 416 => 'subsection4' },
	'subselector' => { 238 => '49.1' },
	'subselectorassignment' => { 238 => '48.1' },
	'subselectorplusdials' => { 238 => '49.2' },
	'subtitle' => { 416 => 'subtitle' },
	'subversionfilename' => { 409 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 409 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 409 => 'SubVersions' },
	'superimposeddisplay' => { 71 => 0xa, 73 => 0x510, 74 => 0x9, 75 => 0xa, 78 => 0xa, 79 => 0xe },
	'supermacro' => { 55 => 0x1a },
	'supplementalcategories' => { 114 => 0x14, 413 => 'SupplementalCategories' },
	'supplementaltype' => { 116 => 0x37 },
	'supplementdisplayid' => { 416 => 'supplementDisplayID' },
	'supplementstartingpage' => { 416 => 'supplementStartingPage' },
	'supplementtitle' => { 416 => 'supplementTitle' },
	'svisosetting' => { 284 => 0x14 },
	'sweeppanoramadirection' => { 270 => 0x93, 347 => 0x33 },
	'sweeppanoramafieldofview' => { 270 => 0x94 },
	'sweeppanoramasize' => { 347 => 0x32 },
	'switchtoregisteredafpoint' => { 72 => 0x12, 73 => 0x50a },
	'system' => { 312 => 0x204 },
	'tagged' => { 314 => 0xdd, 315 => 'Tagged', 395 => 'tagged' },
	'tagslist' => { 404 => 'TagsList' },
	'tagstructure' => { 409 => 'TagStructure' },
	'takenumber' => { 426 => 'takeNumber' },
	'tapename' => { 426 => 'tapeName' },
	'targetaperture' => { 67 => 0x4 },
	'targetcompressionratio' => { 84 => 0x1 },
	'targetdistancesetting' => { 86 => 0x1807 },
	'targetexposuretime' => { 67 => 0x5 },
	'targetimagetype' => { 86 => 0x100a },
	'taxon' => { 105 => 'Taxon' },
	'taxonacceptednameusage' => { 105 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 105 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 105 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 105 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 105 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 105 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 105 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 105 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 105 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 105 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 105 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 105 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 105 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 105 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 105 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 105 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 105 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 105 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 105 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 105 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 105 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 105 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 105 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 105 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 105 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 105 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 105 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 105 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 105 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 105 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 105 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 105 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 105 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 416 => 'teaser' },
	'teleconverter' => { 163 => 0x105, 357 => 0x105 },
	'tempo' => { 426 => 'tempo' },
	'termsandconditionstext' => { 414 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 414 => 'TermsAndConditionsURL' },
	'testname' => { 107 => 'TestName' },
	'textencoding' => { 193 => 0x4 },
	'textlayername' => { 413 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 413 => 'TextLayers' },
	'textlayertext' => { 413 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 270 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 106 => 0x107 },
	'thumbnailfilename' => { 86 => 0x817 },
	'thumbnailformat' => { 424 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 124 => 0xfa55, 424 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 86 => 0x2008, 103 => 'ThumbnailImage', 109 => 0x3, 147 => 'data', 255 => 0x100, 424 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 147 => '1Name' },
	'thumbnailimagesize' => { 147 => 'ImageSize' },
	'thumbnailimagetype' => { 147 => '0Type' },
	'thumbnailimagevalidarea' => { 55 => 0x13 },
	'thumbnaillength' => { 106 => 0x202 },
	'thumbnailoffset' => { 106 => 0x201 },
	'thumbnails' => { 424 => 'Thumbnails' },
	'thumbnailwidth' => { 124 => 0xfa54, 424 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 416 => 'ticker' },
	'tiffhandling' => { 401 => 'TIFFHandling' },
	'tiffmeteringimage' => { 164 => 0x104c, 356 => 0x1110 },
	'tilelength' => { 106 => 0x143 },
	'tilewidth' => { 106 => 0x142 },
	'time' => { 120 => 0x401, 303 => 0x7 },
	'timecodes' => { 106 => 0xc763 },
	'timecreated' => { 114 => 0x3c, 122 => 0x14, 131 => 0x10, 315 => 'TimeCreated' },
	'timeperiod' => { 416 => 'timePeriod' },
	'timerfunctionbutton' => { 239 => '5.2', 240 => '12.1', 241 => '13.1' },
	'timerlength' => { 73 => 0x80c },
	'timerrecording' => { 270 => 0x96 },
	'timescaleparams' => { 426 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 426 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 426 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 426 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 115 => 0x50 },
	'timesignature' => { 426 => 'timeSignature' },
	'timesincepoweron' => { 270 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 249 => 0x8, 262 => 'TimeStamp', 396 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 68 => 0x1, 222 => 0x0, 331 => 0xa },
	'timezonecity' => { 68 => 0x2 },
	'timezonecode' => { 89 => 0x1 },
	'timezoneinfo' => { 89 => 0x2 },
	'timezoneoffset' => { 106 => 0x882a },
	'tint' => { 401 => 'Tint' },
	'title' => { 137 => 'Title', 259 => 'Title', 262 => 'Title', 270 => 0x65, 319 => 'Title', 402 => 'title', 412 => 'Title', 424 => 'Title' },
	'tonecomp' => { 194 => 0x81 },
	'tonecurve' => { 65 => 0x1, 303 => 0x402, 401 => 'ToneCurve' },
	'tonecurveactive' => { 97 => 0x110 },
	'tonecurveadobergb' => { 334 => 0xa043 },
	'tonecurveadobergbdefault' => { 334 => 0xa041 },
	'tonecurveblue' => { 401 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 386 => 0x9003 },
	'tonecurvebluey' => { 386 => 0x9007 },
	'tonecurvebrightness' => { 92 => 0x20410 },
	'tonecurvebrightnessx' => { 386 => 0x9000 },
	'tonecurvebrightnessy' => { 386 => 0x9004 },
	'tonecurvecolorspace' => { 96 => 0x0 },
	'tonecurvecontrast' => { 92 => 0x20411 },
	'tonecurvefilename' => { 120 => 0x1391 },
	'tonecurvegreen' => { 401 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 386 => 0x9002 },
	'tonecurvegreeny' => { 386 => 0x9006 },
	'tonecurveinputrange' => { 96 => 0x3 },
	'tonecurveinterpolation' => { 97 => 0x159 },
	'tonecurvemode' => { 97 => 0x113 },
	'tonecurvename' => { 401 => 'ToneCurveName' },
	'tonecurvename2012' => { 401 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 92 => '0x20400.1' },
	'tonecurveoutputrange' => { 96 => 0x5 },
	'tonecurveproperty' => { 97 => 0x3c },
	'tonecurvepv2012' => { 401 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 401 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 401 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 401 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 401 => 'ToneCurveRed' },
	'tonecurveredx' => { 386 => 0x9001 },
	'tonecurveredy' => { 386 => 0x9005 },
	'tonecurves' => { 303 => 0x403 },
	'tonecurveshape' => { 96 => 0x1 },
	'tonecurvesrgb' => { 334 => 0xa042 },
	'tonecurvesrgbdefault' => { 334 => 0xa040 },
	'tonecurvex' => { 96 => 0xa },
	'tonecurvey' => { 96 => 0xb },
	'tonelevel' => { 250 => 0x52e },
	'toningeffect' => { 49 => 0xf, 194 => 0xb3, 196 => 0x38, 328 => 0x1015 },
	'toningeffectauto' => { 62 => 0xa4 },
	'toningeffectfaithful' => { 61 => 0x74, 62 => 0x74 },
	'toningeffectlandscape' => { 61 => 0x44, 62 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 61 => 0x8c, 62 => 0x8c },
	'toningeffectneutral' => { 61 => 0x5c, 62 => 0x5c },
	'toningeffectportrait' => { 61 => 0x2c, 62 => 0x2c },
	'toningeffectstandard' => { 61 => 0x14, 62 => 0x14 },
	'toningeffectuserdef1' => { 61 => 0xa4, 62 => 0xbc },
	'toningeffectuserdef2' => { 61 => 0xbc, 62 => 0xd4 },
	'toningeffectuserdef3' => { 61 => 0xd4, 62 => 0xec },
	'toningsaturation' => { 196 => 0x39 },
	'totalzoom' => { 122 => 0x62 },
	'touchae' => { 270 => 0xab },
	'trackcreatedate' => { 323 => 0x1 },
	'trackmodifydate' => { 323 => 0x2 },
	'tracknumber' => { 426 => 'trackNumber' },
	'tracks' => { 426 => 'Tracks' },
	'tracksframerate' => { 426 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 426 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 426 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 426 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 426 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 426 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 426 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 426 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 426 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 426 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 426 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 426 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 426 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 426 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 426 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 426 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 426 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 144 => 'zmie' },
	'transferfunction' => { 106 => 0x12d, 422 => 'TransferFunction' },
	'transform' => { 270 => [0x8012,0x59] },
	'transmissionreference' => { 413 => 'TransmissionReference' },
	'trapped' => { 259 => 'Trapped', 412 => 'Trapped' },
	'trashbuttonfunction' => { 73 => 0x710 },
	'travelday' => { 270 => 0x36 },
	'triggermode' => { 324 => 0x6 },
	'tstop' => { 106 => 0xc772 },
	'ttl_da_adown' => { 291 => 0x5 },
	'ttl_da_aup' => { 291 => 0x4 },
	'ttl_da_bdown' => { 291 => 0x7 },
	'ttl_da_bup' => { 291 => 0x6 },
	'tungstenawb' => { 281 => 0x1 },
	'tvexposuretimesetting' => { 284 => 0x12 },
	'type' => { 402 => 'type', 421 => 'type' },
	'typestatus' => { 105 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 106 => 0xc614 },
	'uniquedocumentid' => { 114 => 0xbb },
	'uniqueobjectname' => { 115 => 0x64 },
	'unknownblock' => { 303 => 0x405 },
	'unknownblock1' => { 254 => 0x635 },
	'unknownblock2' => { 254 => 0x636 },
	'unknownblock3' => { 254 => 0x1103 },
	'unknownblock4' => { 254 => 0x1104 },
	'unknowncontrast' => { 98 => 0x45 },
	'unknowndate' => { 312 => 0x212 },
	'unknownev' => { 120 => 0x1 },
	'unknownlinear' => { 98 => 0x46 },
	'unknownnumber' => { 86 => 0x180b },
	'unknownoutputhighlightpoint' => { 98 => 0x4a },
	'unknownoutputshadowpoint' => { 98 => 0x4b },
	'unknownrawhighlight' => { 98 => 0x7b },
	'unknownrawhighlightpoint' => { 98 => 0x48 },
	'unknownrawshadow' => { 98 => 0x84 },
	'unknownrawshadowpoint' => { 98 => 0x49 },
	'unknownsharpness' => { 98 => 0x47 },
	'unknowntemperature' => { 108 => 0x4 },
	'unsharp1color' => { 235 => 0x13 },
	'unsharp1halowidth' => { 235 => 0x19 },
	'unsharp1intensity' => { 235 => 0x17 },
	'unsharp1threshold' => { 235 => 0x1b },
	'unsharp2color' => { 235 => 0x2e },
	'unsharp2halowidth' => { 235 => 0x34 },
	'unsharp2intensity' => { 235 => 0x32 },
	'unsharp2threshold' => { 235 => 0x36 },
	'unsharp3color' => { 235 => 0x49 },
	'unsharp3halowidth' => { 235 => 0x4f },
	'unsharp3intensity' => { 235 => 0x4d },
	'unsharp3threshold' => { 235 => 0x51 },
	'unsharp4color' => { 235 => 0x64 },
	'unsharp4halowidth' => { 235 => 0x6a },
	'unsharp4intensity' => { 235 => 0x68 },
	'unsharp4threshold' => { 235 => 0x6c },
	'unsharpcount' => { 235 => 0x0 },
	'unsharpmask' => { 98 => 0x90, 230 => 0x76a43200 },
	'unsharpmaskfineness' => { 92 => 0x20309 },
	'unsharpmaskstrength' => { 92 => 0x20308 },
	'unsharpmaskthreshold' => { 92 => 0x2030a },
	'uprightcentermode' => { 401 => 'UprightCenterMode' },
	'uprightcenternormx' => { 401 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 401 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 401 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 401 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 401 => 'UprightFocalMode' },
	'uprightpreview' => { 401 => 'UprightPreview' },
	'uprighttransform_0' => { 401 => 'UprightTransform_0' },
	'uprighttransform_1' => { 401 => 'UprightTransform_1' },
	'uprighttransform_2' => { 401 => 'UprightTransform_2' },
	'uprighttransform_3' => { 401 => 'UprightTransform_3' },
	'uprighttransform_4' => { 401 => 'UprightTransform_4' },
	'uprighttransformcount' => { 401 => 'UprightTransformCount' },
	'uprightversion' => { 401 => 'UprightVersion' },
	'urgency' => { 114 => 0xa, 413 => 'Urgency' },
	'url' => { 137 => 'URL', 262 => 'URL', 317 => 0x40b, 416 => 'url' },
	'urla-platform' => { 416 => [\'url','urlA-platform'] },
	'urlurl' => { 416 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 73 => 0x10a },
	'usableshootingmodes' => { 73 => 0x109 },
	'usage' => { 417 => 'usage' },
	'usageterms' => { 430 => 'UsageTerms' },
	'useguidelines' => { 398 => 'useGuidelines' },
	'usepanoramaviewer' => { 390 => 'UsePanoramaViewer' },
	'usercomment' => { 86 => 0x805, 106 => 0x9286, 405 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 61 => 0xd8, 62 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 61 => 0xda, 62 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 61 => 0xdc, 62 => 0xf4 },
	'userfields' => { 393 => 'UserFields' },
	'userlabel' => { 324 => 0x2b },
	'userprofile' => { 266 => 0x302, 272 => 0x3038 },
	'usmlenselectronicmf' => { 72 => 0x7, 73 => 0x501 },
	'uspsnumber' => { 416 => 'uspsNumber' },
	'utmeasting' => { 148 => 'Easting' },
	'utmmapdatum' => { 148 => 'Datum' },
	'utmnorthing' => { 148 => 'Northing' },
	'utmzone' => { 148 => 'Zone' },
	'uv-irfiltercorrection' => { 266 => 0x325 },
	'validbits' => { 254 => 0x611, 255 => 0x102c },
	'validpixeldepth' => { 258 => 0x611 },
	'variousmodes' => { 122 => 0x26 },
	'variousmodes2' => { 122 => 0x3a },
	'variprogram' => { 194 => 0xab },
	'version' => { 111 => 0x0, 319 => 'Version', 401 => 'Version' },
	'versioncreatedate' => { 386 => 0xd100 },
	'versionid' => { 427 => 'VersionID' },
	'versionidentifier' => { 416 => 'versionIdentifier' },
	'versionmodifydate' => { 386 => 0xd101 },
	'versions' => { 427 => 'Versions' },
	'versionscomments' => { 427 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 427 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 427 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 427 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 427 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 427 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 427 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 427 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 427 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 427 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 427 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 237 => '3.2', 238 => '47.2' },
	'verticalfuncbutton' => { 238 => '42.2' },
	'verticalfuncbuttonplusdials' => { 238 => '43.1' },
	'verticalmultiselector' => { 238 => '42.1' },
	'vfdisplayillumination' => { 73 => [0x510,0x51d] },
	'vibrance' => { 394 => 'Vibrance', 401 => 'Vibrance' },
	'vibrationreduction' => { 201 => [0x75,0x82,0x1ae], 209 => '586.1', 216 => '590.2', 221 => 0x4 },
	'videoalphamode' => { 426 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 426 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 426 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 426 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 58 => 0x74 },
	'videocolorspace' => { 426 => 'videoColorSpace' },
	'videocompressor' => { 426 => 'videoCompressor' },
	'videofieldorder' => { 426 => 'videoFieldOrder' },
	'videoframerate' => { 426 => 'videoFrameRate' },
	'videoframesize' => { 426 => 'videoFrameSize' },
	'videoframesizeh' => { 426 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 426 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 426 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 426 => 'videoModDate' },
	'videopixelaspectratio' => { 426 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 426 => 'videoPixelDepth' },
	'videoquality' => { 102 => 0x4003 },
	'viewfinderdisplay' => { 237 => '12.4', 238 => '6.3' },
	'viewfinderwarning' => { 237 => '13.4', 244 => '3.5', 245 => '6.2', 248 => '4.4' },
	'viewfinderwarnings' => { 73 => 0x40a },
	'viewinfoduringexposure' => { 73 => 0x407 },
	'viewingmode' => { 347 => 0x2f, 361 => 0x18 },
	'viewingmode2' => { 347 => [0x85,0x285] },
	'viewpoint' => { 415 => 'viewpoint' },
	'vignetteamount' => { 401 => 'VignetteAmount' },
	'vignettecontrol' => { 194 => 0x2a, 230 => 0x76a43205 },
	'vignettecontrolintensity' => { 230 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 397 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 401 => 'VignetteMidpoint' },
	'vignetting' => { 328 => 0x1011, 334 => 0xa052 },
	'vignettingcorrection' => { 334 => 0xa053, 357 => 0x2011 },
	'vignettingsetting' => { 334 => 0xa054 },
	'visualtechnique' => { 415 => 'visualTechnique' },
	'voicememo' => { 336 => 0x216 },
	'volume' => { 416 => 'volume' },
	'vr_0x66' => { 201 => 0x66 },
	'vrdoffset' => { 55 => 0xd0 },
	'vrmode' => { 221 => 0x6 },
	'wb_bluelevel3500k' => { 164 => 0x19a },
	'wb_bluelevel6500k' => { 164 => 0x18a },
	'wb_bluelevelcustom' => { 164 => 0x18e },
	'wb_bluelevelscloudy' => { 164 => 0x106 },
	'wb_bluelevelsdaylight' => { 164 => 0xea },
	'wb_bluelevelsflash' => { 164 => 0x122 },
	'wb_bluelevelsfluorescent' => { 164 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 164 => 0x254 },
	'wb_bluelevelsshade' => { 164 => 0x176 },
	'wb_bluelevelstungsten' => { 164 => 0xce },
	'wb_gbrglevels' => { 164 => 0xae, 167 => 0x4 },
	'wb_glevel' => { 254 => 0x11f },
	'wb_glevel3000k' => { 254 => 0x113 },
	'wb_glevel3300k' => { 254 => 0x114 },
	'wb_glevel3600k' => { 254 => 0x115 },
	'wb_glevel3900k' => { 254 => 0x116 },
	'wb_glevel4000k' => { 254 => 0x117 },
	'wb_glevel4300k' => { 254 => 0x118 },
	'wb_glevel4500k' => { 254 => 0x119 },
	'wb_glevel4800k' => { 254 => 0x11a },
	'wb_glevel5300k' => { 254 => 0x11b },
	'wb_glevel6000k' => { 254 => 0x11c },
	'wb_glevel6600k' => { 254 => 0x11d },
	'wb_glevel7500k' => { 254 => 0x11e },
	'wb_grbglevels' => { 177 => 0x0 },
	'wb_rbgglevels' => { 174 => 0x0 },
	'wb_rblevels' => { 194 => 0xc, 254 => 0x100 },
	'wb_rblevels1' => { 275 => 0x2 },
	'wb_rblevels2' => { 275 => 0x5 },
	'wb_rblevels3' => { 275 => 0x8 },
	'wb_rblevels3000k' => { 254 => 0x102 },
	'wb_rblevels3300k' => { 254 => 0x103 },
	'wb_rblevels3500k' => { 164 => 0x430 },
	'wb_rblevels3600k' => { 254 => 0x104 },
	'wb_rblevels3900k' => { 254 => 0x105 },
	'wb_rblevels4' => { 275 => 0xb },
	'wb_rblevels4000k' => { 254 => 0x106 },
	'wb_rblevels4300k' => { 254 => 0x107 },
	'wb_rblevels4500k' => { 254 => 0x108 },
	'wb_rblevels4800k' => { 254 => 0x109 },
	'wb_rblevels5' => { 275 => 0xe },
	'wb_rblevels5300k' => { 254 => 0x10a },
	'wb_rblevels6' => { 275 => 0x11 },
	'wb_rblevels6000k' => { 254 => 0x10b },
	'wb_rblevels6500k' => { 164 => 0x420 },
	'wb_rblevels6600k' => { 254 => 0x10c },
	'wb_rblevels7' => { 275 => 0x14 },
	'wb_rblevels7500k' => { 254 => 0x10d },
	'wb_rblevelsauto' => { 258 => 0x110 },
	'wb_rblevelscloudy' => { 164 => 0x3f0, 166 => 0x10, 258 => 0x121 },
	'wb_rblevelscoolwhitef' => { 164 => 0x308, 166 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 258 => 0x132 },
	'wb_rblevelscustom' => { 164 => 0x424 },
	'wb_rblevelscwb1' => { 254 => 0x10e },
	'wb_rblevelscwb2' => { 254 => 0x10f },
	'wb_rblevelscwb3' => { 254 => 0x110 },
	'wb_rblevelscwb4' => { 254 => 0x111 },
	'wb_rblevelsdaylight' => { 164 => [0x3ec,0x528], 166 => 0xc },
	'wb_rblevelsdaylightf' => { 166 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 258 => 0x130 },
	'wb_rblevelsdaywhitef' => { 166 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 258 => 0x131 },
	'wb_rblevelseveningsunlight' => { 258 => 0x124 },
	'wb_rblevelsfineweather' => { 258 => 0x122 },
	'wb_rblevelsflash' => { 164 => [0x3f4,0x304], 166 => 0x18 },
	'wb_rblevelsshade' => { 164 => 0x418, 166 => 0x20, 258 => 0x120 },
	'wb_rblevelstungsten' => { 164 => 0x3e8, 166 => 0x8, 258 => 0x123 },
	'wb_rblevelsunknown' => { 166 => 0x1c },
	'wb_rblevelsused' => { 258 => 0x100 },
	'wb_rblevelswhitef' => { 166 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 258 => 0x133 },
	'wb_redlevel3500k' => { 164 => 0x198 },
	'wb_redlevel6500k' => { 164 => 0x188 },
	'wb_redlevelcustom' => { 164 => 0x18c },
	'wb_redlevelscloudy' => { 164 => 0xf8 },
	'wb_redlevelsdaylight' => { 164 => 0xdc },
	'wb_redlevelsflash' => { 164 => 0x114 },
	'wb_redlevelsfluorescent' => { 164 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 164 => 0x1be },
	'wb_redlevelsshade' => { 164 => 0x168 },
	'wb_redlevelstungsten' => { 164 => 0xc0 },
	'wb_rgbglevels' => { 176 => 0x0 },
	'wb_rgblevels' => { 164 => [0x546,0x96], 267 => 0xd, 268 => 0x413, 272 => 0x3036, 312 => 0x107, 364 => 0x117c, 365 => 0x1180, 366 => 0x115c, 367 => 0x11d8, 368 => 0x11b4, 369 => 0x106c, 370 => 0x264, 371 => 0x264 },
	'wb_rgblevels1' => { 276 => 0x2 },
	'wb_rgblevels2' => { 276 => 0x6 },
	'wb_rgblevels3' => { 276 => 0xa },
	'wb_rgblevels4' => { 276 => 0xe },
	'wb_rgblevels5' => { 276 => 0x12 },
	'wb_rgblevels6' => { 276 => 0x16 },
	'wb_rgblevels7' => { 276 => 0x1a },
	'wb_rggbblacklevels' => { 32 => 0x25 },
	'wb_rggblevels' => { 167 => 0x4, 175 => 0x0 },
	'wb_rggblevelsasshot' => { 34 => 0x0, 35 => 0x19, 36 => 0x22, 37 => 0x3f, 40 => 0x3f, 41 => 0x3f, 42 => 0x3f },
	'wb_rggblevelsauto' => { 32 => 0x1, 34 => 0x5, 35 => 0x1e, 36 => 0x18, 37 => 0x44, 40 => 0x44, 41 => 0x44, 42 => 0x44, 334 => 0xa022 },
	'wb_rggblevelsblack' => { 334 => 0xa028 },
	'wb_rggblevelscloudy' => { 32 => 0xd, 34 => 0x1e, 35 => 0x2d, 36 => 0x31, 37 => 0x58, 40 => 0x71, 41 => 0x8a, 42 => 0x8f, 303 => 0x20f, 311 => 0x14 },
	'wb_rggblevelscustom' => { 32 => 0x1d, 37 => 0x80 },
	'wb_rggblevelscustom1' => { 35 => 0x41 },
	'wb_rggblevelscustom2' => { 35 => 0x46 },
	'wb_rggblevelsdaylight' => { 32 => 0x5, 34 => 0x14, 35 => 0x23, 36 => 0x27, 37 => 0x4e, 40 => 0x67, 41 => 0x80, 42 => 0x85, 303 => 0x20d, 311 => 0x2 },
	'wb_rggblevelsflash' => { 32 => 0x19, 34 => 0x32, 35 => 0x3c, 36 => 0x45, 37 => 0x6c, 40 => 0x85, 41 => 0x9e, 42 => 0xa3, 303 => 0x214, 311 => 0x41 },
	'wb_rggblevelsfluorescent' => { 32 => 0x15, 34 => 0x28, 35 => 0x37, 36 => 0x3b, 37 => 0x62, 40 => 0x7b, 41 => 0x94, 42 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 303 => 0x211, 311 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 311 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 303 => 0x212, 311 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 303 => 0x213, 311 => 0x38 },
	'wb_rggblevelsilluminator1' => { 334 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 334 => 0xa024 },
	'wb_rggblevelskelvin' => { 32 => 0x21, 34 => 0x2d, 36 => 0x40, 37 => 0x67, 40 => 0x80, 41 => 0x99, 42 => 0x9e },
	'wb_rggblevelsmeasured' => { 34 => 0xa, 37 => 0x49, 40 => 0x49, 41 => 0x49, 42 => 0x49 },
	'wb_rggblevelspc1' => { 36 => 0x90, 37 => 0x71 },
	'wb_rggblevelspc2' => { 36 => 0x95, 37 => 0x76 },
	'wb_rggblevelspc3' => { 36 => 0x9a, 37 => 0x7b },
	'wb_rggblevelsshade' => { 32 => 0x9, 34 => 0x19, 35 => 0x28, 36 => 0x2c, 37 => 0x53, 40 => 0x6c, 41 => 0x85, 42 => 0x8a, 303 => 0x20e, 311 => 0xb },
	'wb_rggblevelstungsten' => { 32 => 0x11, 34 => 0x23, 35 => 0x32, 36 => 0x36, 37 => 0x5d, 40 => 0x76, 41 => 0x8f, 42 => 0x94, 303 => 0x210, 311 => 0x1d },
	'wb_rggblevelsuncorrected' => { 334 => 0xa021 },
	'wb_rggblevelsunknown' => { 34 => 0xf, 36 => 0x1d, 40 => 0x4e, 41 => 0x4e, 42 => 0x4e, 311 => 0x53 },
	'wb_rggblevelsunknown10' => { 34 => 0x5f, 36 => 0x72, 40 => 0x9e, 41 => 0x7b, 42 => 0x7b },
	'wb_rggblevelsunknown11' => { 34 => 0x64, 36 => 0x77, 40 => 0xa3, 41 => 0xa3, 42 => 0x80 },
	'wb_rggblevelsunknown12' => { 34 => 0x69, 36 => 0x7c, 40 => 0xa8, 41 => 0xa8, 42 => 0xa8 },
	'wb_rggblevelsunknown13' => { 34 => 0x6e, 36 => 0x81, 40 => 0xad, 41 => 0xad, 42 => 0xad },
	'wb_rggblevelsunknown14' => { 36 => 0x86, 40 => 0xb2, 41 => 0xb2, 42 => 0xb2 },
	'wb_rggblevelsunknown15' => { 36 => 0x8b, 40 => 0xb7, 41 => 0xb7, 42 => 0xb7 },
	'wb_rggblevelsunknown16' => { 36 => 0x9f, 41 => 0xbc, 42 => 0xbc },
	'wb_rggblevelsunknown17' => { 41 => 0xc1, 42 => 0xc1 },
	'wb_rggblevelsunknown18' => { 41 => 0xc6, 42 => 0xc6 },
	'wb_rggblevelsunknown19' => { 41 => 0xcb, 42 => 0xcb },
	'wb_rggblevelsunknown2' => { 34 => 0x37, 36 => 0x4a, 40 => 0x53, 41 => 0x53, 42 => 0x53 },
	'wb_rggblevelsunknown20' => { 41 => 0xd0, 42 => 0xd0 },
	'wb_rggblevelsunknown21' => { 42 => 0xd5 },
	'wb_rggblevelsunknown22' => { 42 => 0xda },
	'wb_rggblevelsunknown23' => { 42 => 0xdf },
	'wb_rggblevelsunknown24' => { 42 => 0xe4 },
	'wb_rggblevelsunknown25' => { 42 => 0xe9 },
	'wb_rggblevelsunknown26' => { 42 => 0xee },
	'wb_rggblevelsunknown27' => { 42 => 0xf3 },
	'wb_rggblevelsunknown28' => { 42 => 0xf8 },
	'wb_rggblevelsunknown29' => { 42 => 0xfd },
	'wb_rggblevelsunknown3' => { 34 => 0x3c, 36 => 0x4f, 40 => 0x58, 41 => 0x58, 42 => 0x58 },
	'wb_rggblevelsunknown30' => { 42 => 0x102 },
	'wb_rggblevelsunknown4' => { 34 => 0x41, 36 => 0x54, 40 => 0x5d, 41 => 0x5d, 42 => 0x5d },
	'wb_rggblevelsunknown5' => { 34 => 0x46, 36 => 0x59, 40 => 0x62, 41 => 0x62, 42 => 0x62 },
	'wb_rggblevelsunknown6' => { 34 => 0x4b, 36 => 0x5e, 40 => 0x8a, 41 => 0x67, 42 => 0x67 },
	'wb_rggblevelsunknown7' => { 34 => 0x50, 36 => 0x63, 40 => 0x8f, 41 => 0x6c, 42 => 0x6c },
	'wb_rggblevelsunknown8' => { 34 => 0x55, 36 => 0x68, 40 => 0x94, 41 => 0x71, 42 => 0x71 },
	'wb_rggblevelsunknown9' => { 34 => 0x5a, 36 => 0x6d, 40 => 0x99, 41 => 0x76, 42 => 0x76 },
	'wb_rggblevelsuserselected' => { 311 => 0x5c },
	'wbadjblueamber' => { 92 => 0x20106 },
	'wbadjbluebalance' => { 236 => 0x8 },
	'wbadjcolortemp' => { 92 => 0x20102, 97 => 0x1a },
	'wbadjlighting' => { 236 => 0x14 },
	'wbadjmagentagreen' => { 92 => 0x20105 },
	'wbadjmode' => { 236 => 0x10 },
	'wbadjredbalance' => { 236 => 0x0 },
	'wbadjrggblevels' => { 92 => 0x20125, 97 => 0x6 },
	'wbadjtemperature' => { 236 => 0x18 },
	'wbadjtint' => { 236 => 0x25 },
	'wbbluelevel' => { 266 => 0x324, 270 => 0x8006, 274 => 0x26 },
	'wbbracketmode' => { 49 => 0x9 },
	'wbbracketshotnumber' => { 164 => 0x2b, 328 => 0x101a },
	'wbbracketvalueab' => { 49 => 0xc },
	'wbbracketvaluegm' => { 49 => 0xd },
	'wbfinetuneactive' => { 97 => 0x24 },
	'wbfinetunesaturation' => { 97 => 0x28 },
	'wbfinetunetone' => { 97 => 0x2c },
	'wbgreenlevel' => { 266 => 0x323, 270 => 0x8005, 274 => 0x25 },
	'wbmediaimagesizesetting' => { 73 => 0x708 },
	'wbmode' => { 166 => 0x4, 255 => 0x1015 },
	'wbredlevel' => { 266 => 0x322, 270 => 0x8004, 274 => 0x24 },
	'wbscale' => { 167 => 0x0 },
	'wbshiftab' => { 65 => 0xc, 270 => 0x46, 285 => 0x10 },
	'wbshiftab_gm' => { 357 => 0x2014 },
	'wbshiftab_gm_precise' => { 357 => 0x2026 },
	'wbshiftgm' => { 65 => 0xd, 270 => 0x47, 285 => 0x11 },
	'wbtype1' => { 275 => 0x1, 276 => 0x1 },
	'wbtype2' => { 275 => 0x4, 276 => 0x5 },
	'wbtype3' => { 275 => 0x7, 276 => 0x9 },
	'wbtype4' => { 275 => 0xa, 276 => 0xd },
	'wbtype5' => { 275 => 0xd, 276 => 0x11 },
	'wbtype6' => { 275 => 0x10, 276 => 0x15 },
	'wbtype7' => { 275 => 0x13, 276 => 0x19 },
	'webstatement' => { 430 => 'WebStatement' },
	'what' => { 401 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 65 => 0x8, 67 => 0x7, 101 => 0x7, 102 => [0x19,0x2012], 106 => [0xa403,0xfe4e], 111 => 0x1002, 120 => 0x3fc, 121 => 0xfa0d, 122 => 0x40, 158 => 0x3, 159 => 0xe, 160 => 0x4, 161 => 0xb, 163 => 0x115, 194 => 0x5, 220 => 0x7, 266 => 0x304, 270 => 0x3, 272 => 0x3033, 303 => 0x19, 310 => 0x7, 327 => 0x26, 328 => 0x1003, 337 => [0x3c,0x7,0x58], 345 => 0xf, 346 => 0xe, 357 => [0x115,0xb054], 401 => 'WhiteBalance', 405 => 'WhiteBalance' },
	'whitebalance0' => { 154 => 'WhiteBalance0' },
	'whitebalance1' => { 154 => 'WhiteBalance1' },
	'whitebalance2' => { 154 => 'WhiteBalance2', 250 => 0x500 },
	'whitebalanceadj' => { 92 => 0x20101, 97 => 0x18, 230 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 281 => 0x0 },
	'whitebalancebias' => { 102 => 0x2011, 255 => 0x304, 270 => 0x23 },
	'whitebalanceblue' => { 65 => 0x7 },
	'whitebalancebracket' => { 250 => 0x502, 255 => 0x303 },
	'whitebalancebracketing' => { 161 => 0x22, 164 => 0x2c, 356 => 0x2c },
	'whitebalancecomp' => { 258 => 0x1001 },
	'whitebalancefinetune' => { 111 => 0x100a, 161 => 0x38, 163 => 0x112, 194 => 0xb, 328 => 0x1004, 345 => 0x6, 346 => 0x5, 357 => 0x112 },
	'whitebalancemode' => { 303 => 0x1a },
	'whitebalancered' => { 65 => 0x6 },
	'whitebalanceset' => { 284 => 0xa },
	'whitebalancesetting' => { 161 => 0x23, 345 => 0x5, 346 => 0x4, 347 => 0x16, 361 => 0xd },
	'whitebalancetemperature' => { 250 => 0x501 },
	'whiteboard' => { 255 => 0x301 },
	'whitelevel' => { 106 => 0xc61d, 303 => 0x7e },
	'whitepoint' => { 106 => 0x13e, 303 => 0x201, 422 => 'WhitePoint' },
	'whites2012' => { 401 => 'Whites2012' },
	'wideadapter' => { 328 => 0x1017 },
	'widefocuszone' => { 158 => 0x2f },
	'widerange' => { 336 => 0x20f },
	'windowsatom' => { 400 => 'windowsAtom' },
	'windowsatomextension' => { 400 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 400 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 400 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 416 => 'wordCount' },
	'workcolorspace' => { 92 => 0x10200, 97 => 0x270 },
	'worktodo' => { 407 => 'WorkToDo' },
	'worldtimelocation' => { 270 => 0x3a, 303 => 0x22, 309 => '0.1' },
	'writer-editor' => { 114 => 0x7a },
	'x3filllight' => { 337 => 0x12 },
	'xml' => { 118 => 'xml ' },
	'xmp' => { 95 => 0xffff00f6, 107 => 'XMP' },
	'xmptoolkit' => { 423 => 'xmptk' },
	'xpauthor' => { 106 => 0x9c9d },
	'xpcomment' => { 106 => 0x9c9c },
	'xpkeywords' => { 106 => 0x9c9e },
	'xposition' => { 106 => 0x11e },
	'xpsubject' => { 106 => 0x9c9f },
	'xptitle' => { 106 => 0x9c9b },
	'xresolution' => { 106 => 0x11a, 117 => 0x3, 318 => 0x0, 422 => 'XResolution' },
	'xyresolution' => { 110 => 0x3 },
	'yawangle' => { 210 => 0x3513 },
	'ycbcrcoefficients' => { 106 => 0x211, 422 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 106 => 0x213, 422 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 106 => 0x212, 422 => 'YCbCrSubSampling' },
	'yearcreated' => { 122 => 0x10, 131 => 0xc },
	'yield' => { 418 => 'yield' },
	'yposition' => { 106 => 0x11f },
	'yresolution' => { 106 => 0x11b, 117 => 0x5, 318 => 0x4, 422 => 'YResolution' },
	'zonematching' => { 163 => 0x10a, 166 => [0x3a,0x4a], 357 => 0xb024 },
	'zonematchingmode' => { 161 => 0x14 },
	'zonematchingon' => { 160 => 0x75 },
	'zonematchingvalue' => { 345 => 0x1f },
	'zoomedpreviewlength' => { 255 => 0xf05 },
	'zoomedpreviewsize' => { 255 => 0xf06 },
	'zoomedpreviewstart' => { 255 => 0xf04 },
	'zoomsourcewidth' => { 31 => 0x24 },
	'zoomstepcount' => { 253 => 0x300, 255 => 0x100d },
	'zoomtargetwidth' => { 31 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemtags' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawfiletype' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'variablelowpassfilter' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName || $field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2016, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
