use strict;
use warnings;

use ExtUtils::MakeMaker;

# ----------------

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my(%params) =
(
	($] ge '5.005') ?
	(
		'AUTHOR'   => 'Ron Savage (ron@savage.net.au)',
		'ABSTRACT' => 'Call HTML::Entities::encode_entities, via a hash, within a string',
		) : (),
	clean =>
	{
		FILES => 'blib/* Makefile MANIFEST HTML-Entities-Interpolate-*'
	},
	dist =>
	{
		COMPRESS => 'gzip',
		SUFFIX   => 'gz'
	},
	DISTNAME  => 'HTML-Entities-Interpolate',
	NAME      => 'HTML::Entities::Interpolate',
	LICENSE   => 'artistic_2',
	PL_FILES  => {},
	PREREQ_PM =>
	{
		'Capture::Tiny' => 0.30,
		'File::Slurper' => 0.008,
		'File::Spec' => 0,
		'HTML::Entities' => 3.69,
		'strict' => 0,
		'Test::More' => 1.001014, # Only used for xt/author/pod.t.
		'Test::Stream' => 1.302026,
		'Test::Pod' => 1.48,
		'Tie::Function' => 0.02,
		'warnings' => 0,
	},
	VERSION_FROM => 'lib/HTML/Entities/Interpolate.pm',
);

if ( ($ExtUtils::MakeMaker::VERSION =~ /^\d\.\d\d$/) && ($ExtUtils::MakeMaker::VERSION > 6.30) )
{
	$params{LICENSE} = 'artistic_2';
}

if ($ExtUtils::MakeMaker::VERSION ge '6.46')
{
	$params{META_MERGE} =
	{
		'meta-spec' =>
		{
			version => 2,
		},
		resources =>
		{
			bugtracker => 'https://rt.cpan.org/Public/Dist/Display.html?Name=HTML-Entities-Interpolate',
			license    => 'http://opensource.org/licenses/Artistic-2.0',
			repository =>
			{
				type => 'git',
				url  => 'https://github.com/ronsavage/HTML-Entities-Interpolate.git',
				web  => 'https://github.com/ronsavage/HTML-Entities-Interpolate',
			},
		},
	};
}

WriteMakefile(%params);
