--source include/master-slave.inc

CALL mtr.add_suppression("An error occurred during flush stage of the commit. 'binlog_error_action' is set to 'IGNORE_ERROR'.");
CALL mtr.add_suppression("Error writing file.*(errno: 28 - No space left on device)");

--echo # Restart master with a custom error log
--let $rpl_server_number= 1
--let $rpl_server_parameters= --log-error=$MYSQLTEST_VARDIR/tmp/rpl_bug72457.err
--let $rpl_omit_print_server_parameters= 1
--source include/rpl_restart_server.inc
--exec echo "                               [parameters: --log-error=ERROR_LOG_FILE]"

--let $rpl_only_running_threads= 1
--source include/rpl_reset.inc

let $saved_binlog_error_action=`SELECT @@GLOBAL.binlog_error_action`;
SET GLOBAL binlog_error_action = IGNORE_ERROR;

CREATE TABLE t1(f1 TEXT) ENGINE=MyISAM;
INSERT INTO t1 VALUES(MD5(1));

--let $i = 10
while($i)
{
  INSERT INTO t1 SELECT * FROM t1;
  --dec $i
}
--source include/sync_slave_sql_with_master.inc

--source include/rpl_connection_master.inc

--let $log_pos_before = query_get_value("SHOW BINARY LOGS", File_size, 1)

SET SESSION debug = "+d,simulate_tmpdir_partition_full";
--replace_regex /Error writing file .*/Error writing file <tmp_file_name> (Errcode: ##)/
INSERT INTO t1 SELECT * FROM t1;
SET SESSION debug = "-d,simulate_tmpdir_partition_full";

--echo # Check if INSERT is committed
--let $assert_cond = COUNT(*) = 2048 FROM t1;
--let $assert_text = Count of elements in t1 should be 2048.
--source include/assert.inc

--echo # Cleanup and stop slave
--source include/rpl_connection_slave.inc
DROP TABLE t1;
--source include/stop_slave.inc

--echo # Binlog is closed due to above error. Restart the server to
--echo # enable the binlog again to continue the test. Use default error log.
--let $rpl_server_number= 1
--let $rpl_server_parameters=
--let $rpl_omit_print_server_parameters= 0
--source include/rpl_restart_server.inc

--source include/rpl_connection_master.inc
--echo # Only "Stop" should be logged
--let $binlog_start= $log_pos_before
--source include/show_binlog_events.inc

--echo # Make sure that the warnings are present in a custom error log.
let SEARCH_FILE= $MYSQLTEST_VARDIR/tmp/rpl_bug72457.err;
let SEARCH_PATTERN= An error occurred during flush stage of the commit. 'binlog_error_action' is set to 'IGNORE_ERROR'.;
--source include/search_pattern.inc
--remove_file $SEARCH_FILE

DROP TABLE t1;

--eval SET GLOBAL binlog_error_action= $saved_binlog_error_action

--let $rpl_only_running_threads = 1
--source include/rpl_end.inc
