#
# Test TRIM() function with Japanese characters sjis encoding
#

--character_set sjis
SET NAMES sjis;
SET character_set_database = sjis;

--disable_warnings
DROP TABLE IF EXISTS `sP`;
DROP TABLE IF EXISTS `sQ`;
DROP TABLE IF EXISTS `sR`;
--enable_warnings
--replace_result $engine <engine_to_be_tested>
eval CREATE TABLE `sP` (`bP` CHAR(12), INDEX(`bP`)) DEFAULT CHARSET = sjis ENGINE = $engine;
--replace_result $engine <engine_to_be_tested>
eval CREATE TABLE `sQ` (`bP` CHAR(12), INDEX(`bP`)) DEFAULT CHARSET = sjis ENGINE = $engine;
--replace_result $engine <engine_to_be_tested>
eval CREATE TABLE `sR` (`bP` CHAR(12), INDEX(`bP`)) DEFAULT CHARSET = sjis ENGINE = $engine;

# Nothing to trim
INSERT INTO `sP` VALUES ('');
# Test data for TRIM(TRAILING [remstr] FROM str)
INSERT INTO `sP` VALUES ('');
INSERT INTO `sP` VALUES ('');
INSERT INTO `sP` VALUES ('');
# Test data for TRIM(LEADING [remstr] FROM str)
INSERT INTO `sP` VALUES ('');
INSERT INTO `sP` VALUES ('');
INSERT INTO `sP` VALUES ('');
# Test data for TRIM(BOTH [remstr] FROM str)
INSERT INTO `sP` VALUES ('');
# Test data for TRIM without [remstr] (remove spaces) 
INSERT INTO `sP` VALUES ('      ');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('');
INSERT INTO `sQ` VALUES ('      ');
INSERT INTO `sR` VALUES ('\\\\\');
INSERT INTO `sR` VALUES ('\\\\\\');
INSERT INTO `sR` VALUES ('\\\\\\\');
INSERT INTO `sR` VALUES ('\\\\\\\\');
INSERT INTO `sR` VALUES ('\\\\\\');
INSERT INTO `sR` VALUES ('\\\\\\\');
INSERT INTO `sR` VALUES ('\\\\\\\\');
INSERT INTO `sR` VALUES ('\\\\\\\\\\\');
INSERT INTO `sR` VALUES ('   \\\\\   ');

SELECT `bP`,TRIM(TRAILING '' FROM `bP`) FROM `sP`;
SELECT `bP`,TRIM(LEADING '' FROM `bP`) FROM `sP`;
SELECT `bP`,TRIM(BOTH '' FROM `bP`) FROM `sP`;
SELECT `bP`,TRIM(`bP`) FROM `sP`;
SELECT `bP`,TRIM(TRAILING '' FROM `bP`) FROM `sQ`;
SELECT `bP`,TRIM(LEADING '' FROM `bP`) FROM `sQ`;
SELECT `bP`,TRIM(BOTH '' FROM `bP`) FROM `sQ`;
SELECT `bP`,TRIM(`bP`) FROM `sQ`;
SELECT `bP`,TRIM(TRAILING '\' FROM `bP`) FROM `sR`;
SELECT `bP`,TRIM(LEADING '\' FROM `bP`) FROM `sR`;
SELECT `bP`,TRIM(BOTH '\' FROM `bP`) FROM `sR`;
SELECT `bP`,TRIM(`bP`) FROM `sR`;

DROP TABLE `sP`;
DROP TABLE `sQ`;
DROP TABLE `sR`;
