/**
 * \file access.h
 *
 * \brief Table of default attributes and their permissions
 */

#ifndef __ATR_TAB_H
#define __ATR_TAB_H

#include "attrib.h"
#include "privtab.h"

/* attribute list */
ATTR attr[] = {
  {"AAHEAR", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ABUY", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ACLONE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ACONNECT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ADESCRIBE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ADESTROY", AF_WIZARD | AF_PRIVATE | AF_NOCOPY | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"ADISCONNECT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ADROP", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AEFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AENTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AFAILURE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AFOLLOW", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AGIVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AHEAR", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AIDESCRIBE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ALEAVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ALFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ALIAS", AF_VISUAL | AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AMAIL", AF_WIZARD | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AMHEAR", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AMOVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ANAME", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"APAYMENT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ARECEIVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ASUCCESS", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ATPORT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AUFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AUNFOLLOW", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AUSE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AWAY", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AZENTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"AZLEAVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"BUY", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"CHARGES", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"CHATFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"COMMENT", AF_NOPROG | AF_MDARK | AF_WIZARD | AF_PREFIXMATCH | AF_NOCOPY, 0,
   NULL_CHUNK_REFERENCE},
  {"CONFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"COST", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"DEBUGFORWARDLIST", AF_NOPROG | AF_PRIVATE | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"DESCFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"DESCRIBE", AF_PUBLIC | AF_NEARBY | AF_VISUAL | AF_NOPROG | AF_PREFIXMATCH,
   0, NULL_CHUNK_REFERENCE},
  {"DESTINATION", AF_NOPROG, 0, NULL_CHUNK_REFERENCE},
  {"DOING", AF_NOPROG | AF_PRIVATE | AF_VISUAL | AF_PUBLIC, 0,
   NULL_CHUNK_REFERENCE},
  {"DROP", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"EALIAS", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"EFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ENTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"EXITFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"EXITTO", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"FAILURE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"FILTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"FOLLOW", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},

  {"FOLLOWING", AF_NOPROG | AF_PRIVATE | AF_WIZARD | AF_NOCOPY | AF_PREFIXMATCH,
   0, NULL_CHUNK_REFERENCE},
  {"FOLLOWERS", AF_NOPROG | AF_PRIVATE | AF_WIZARD | AF_NOCOPY | AF_PREFIXMATCH,
   0, NULL_CHUNK_REFERENCE},
  {"FORWARDLIST", AF_NOPROG | AF_PRIVATE | AF_PREFIXMATCH, NULL_CHUNK_REFERENCE,
   0},
  {"GIVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"HAVEN", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"IDESCFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"IDESCRIBE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"IDLE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"INFILTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"INPREFIX", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"INVFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"LALIAS", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"LAST", AF_VISUAL | AF_WIZARD | AF_NOCOPY | AF_LOCKED | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"LASTIP", AF_WIZARD | AF_LOCKED | AF_NOCOPY | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"LASTFAILED", AF_WIZARD | AF_LOCKED | AF_NOCOPY | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"LASTLOGOUT", AF_WIZARD | AF_LOCKED | AF_NOCOPY | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"LASTPAGED", AF_WIZARD | AF_LOCKED | AF_NOCOPY | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"LASTSITE", AF_WIZARD | AF_LOCKED | AF_NOCOPY | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"LEAVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"LFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"LISTEN", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"MAILCURF", AF_WIZARD | AF_NOPROG | AF_LOCKED | AF_PREFIXMATCH | AF_NOCOPY,
   0, NULL_CHUNK_REFERENCE},
  {"MAILFILTERS",
   AF_WIZARD | AF_NOPROG | AF_LOCKED | AF_PREFIXMATCH | AF_NOCOPY, 0,
   NULL_CHUNK_REFERENCE},
  {"MAILFILTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"MAILFOLDERS",
   AF_WIZARD | AF_NOPROG | AF_LOCKED | AF_NOCOPY | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"MAILFORWARDLIST", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"MAILQUOTA", AF_NOPROG | AF_NOCOPY | AF_LOCKED | AF_WIZARD, 0,
   NULL_CHUNK_REFERENCE},
  {"MAILSIGNATURE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"MONIKER", AF_NOPROG | AF_VISUAL | AF_WIZARD | AF_LOCKED, 0,
   NULL_CHUNK_REFERENCE},
  {"MOVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"NAMEACCENT", AF_NOPROG | AF_VISUAL | AF_PREFIXMATCH, NULL_CHUNK_REFERENCE,
   0},
  {"NAMEFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OBUY", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ODESCRIBE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ODROP", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OEFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OENTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OFAILURE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OFOLLOW", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OGIVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OIDESCRIBE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OLEAVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OLFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OMOVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ONAME", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OPAYMENT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ORECEIVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OXMOVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OSUCCESS", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OTPORT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OUFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OUNFOLLOW", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OUSE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OUTPAGEFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OXENTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OXLEAVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OXTPORT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OZENTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"OZLEAVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"PAYMENT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"PAGEFORMAT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"PRICELIST", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"PREFIX", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"RECEIVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"QUEUE", AF_WIZARD | AF_PRIVATE | AF_NOCOPY | AF_NODUMP, 0,
   NULL_CHUNK_REFERENCE},
  {"REGISTERED_EMAIL", AF_WIZARD | AF_LOCKED | AF_PRIVATE | AF_NOCOPY, 0,
   NULL_CHUNK_REFERENCE},
  {"RQUOTA", AF_MDARK | AF_LOCKED, 0, NULL_CHUNK_REFERENCE},
  {"RUNOUT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"SEMAPHORE", AF_LOCKED | AF_PRIVATE | AF_NOCOPY | AF_NODUMP, 0,
   NULL_CHUNK_REFERENCE},
  {"SEX", AF_VISUAL | AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"SPEECHMOD", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"STARTUP", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"SUCCESS", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"TFPREFIX", AF_NOPROG | AF_NOCOPY | AF_PRIVATE | AF_PREFIXMATCH, 0,
   NULL_CHUNK_REFERENCE},
  {"TPORT", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"TZ", AF_VISUAL | AF_NOPROG, 0, NULL_CHUNK_REFERENCE},
  {"UFAIL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"UNFOLLOW", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"USE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"VA", 0, 0, NULL_CHUNK_REFERENCE},
  {"VB", 0, 0, NULL_CHUNK_REFERENCE},
  {"VC", 0, 0, NULL_CHUNK_REFERENCE},
  {"VD", 0, 0, NULL_CHUNK_REFERENCE},
  {"VE", 0, 0, NULL_CHUNK_REFERENCE},
  {"VF", 0, 0, NULL_CHUNK_REFERENCE},
  {"VG", 0, 0, NULL_CHUNK_REFERENCE},
  {"VH", 0, 0, NULL_CHUNK_REFERENCE},
  {"VI", 0, 0, NULL_CHUNK_REFERENCE},
  {"VJ", 0, 0, NULL_CHUNK_REFERENCE},
  {"VK", 0, 0, NULL_CHUNK_REFERENCE},
  {"VL", 0, 0, NULL_CHUNK_REFERENCE},
  {"VM", 0, 0, NULL_CHUNK_REFERENCE},
  {"VN", 0, 0, NULL_CHUNK_REFERENCE},
  {"VO", 0, 0, NULL_CHUNK_REFERENCE},
  {"VP", 0, 0, NULL_CHUNK_REFERENCE},
  {"VQ", 0, 0, NULL_CHUNK_REFERENCE},
  {"VR", 0, 0, NULL_CHUNK_REFERENCE},
  {"VRML_URL", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"VS", 0, 0, NULL_CHUNK_REFERENCE},
  {"VT", 0, 0, NULL_CHUNK_REFERENCE},
  {"VU", 0, 0, NULL_CHUNK_REFERENCE},
  {"VV", 0, 0, NULL_CHUNK_REFERENCE},
  {"VW", 0, 0, NULL_CHUNK_REFERENCE},
  {"VX", 0, 0, NULL_CHUNK_REFERENCE},
  {"VY", 0, 0, NULL_CHUNK_REFERENCE},
  {"VZ", 0, 0, NULL_CHUNK_REFERENCE},
  {"WA", 0, 0, NULL_CHUNK_REFERENCE},
  {"WB", 0, 0, NULL_CHUNK_REFERENCE},
  {"WC", 0, 0, NULL_CHUNK_REFERENCE},
  {"WD", 0, 0, NULL_CHUNK_REFERENCE},
  {"WE", 0, 0, NULL_CHUNK_REFERENCE},
  {"WF", 0, 0, NULL_CHUNK_REFERENCE},
  {"WG", 0, 0, NULL_CHUNK_REFERENCE},
  {"WH", 0, 0, NULL_CHUNK_REFERENCE},
  {"WI", 0, 0, NULL_CHUNK_REFERENCE},
  {"WJ", 0, 0, NULL_CHUNK_REFERENCE},
  {"WK", 0, 0, NULL_CHUNK_REFERENCE},
  {"WL", 0, 0, NULL_CHUNK_REFERENCE},
  {"WM", 0, 0, NULL_CHUNK_REFERENCE},
  {"WN", 0, 0, NULL_CHUNK_REFERENCE},
  {"WO", 0, 0, NULL_CHUNK_REFERENCE},
  {"WP", 0, 0, NULL_CHUNK_REFERENCE},
  {"WQ", 0, 0, NULL_CHUNK_REFERENCE},
  {"WR", 0, 0, NULL_CHUNK_REFERENCE},
  {"WS", 0, 0, NULL_CHUNK_REFERENCE},
  {"WT", 0, 0, NULL_CHUNK_REFERENCE},
  {"WU", 0, 0, NULL_CHUNK_REFERENCE},
  {"WV", 0, 0, NULL_CHUNK_REFERENCE},
  {"WW", 0, 0, NULL_CHUNK_REFERENCE},
  {"WX", 0, 0, NULL_CHUNK_REFERENCE},
  {"WY", 0, 0, NULL_CHUNK_REFERENCE},
  {"WZ", 0, 0, NULL_CHUNK_REFERENCE},
  {"XA", 0, 0, NULL_CHUNK_REFERENCE},
  {"XB", 0, 0, NULL_CHUNK_REFERENCE},
  {"XC", 0, 0, NULL_CHUNK_REFERENCE},
  {"XD", 0, 0, NULL_CHUNK_REFERENCE},
  {"XE", 0, 0, NULL_CHUNK_REFERENCE},
  {"XF", 0, 0, NULL_CHUNK_REFERENCE},
  {"XG", 0, 0, NULL_CHUNK_REFERENCE},
  {"XH", 0, 0, NULL_CHUNK_REFERENCE},
  {"XI", 0, 0, NULL_CHUNK_REFERENCE},
  {"XJ", 0, 0, NULL_CHUNK_REFERENCE},
  {"XK", 0, 0, NULL_CHUNK_REFERENCE},
  {"XL", 0, 0, NULL_CHUNK_REFERENCE},
  {"XM", 0, 0, NULL_CHUNK_REFERENCE},
  {"XN", 0, 0, NULL_CHUNK_REFERENCE},
  {"XO", 0, 0, NULL_CHUNK_REFERENCE},
  {"XP", 0, 0, NULL_CHUNK_REFERENCE},
  {"XQ", 0, 0, NULL_CHUNK_REFERENCE},
  {"XR", 0, 0, NULL_CHUNK_REFERENCE},
  {"XS", 0, 0, NULL_CHUNK_REFERENCE},
  {"XT", 0, 0, NULL_CHUNK_REFERENCE},
  {"XU", 0, 0, NULL_CHUNK_REFERENCE},
  {"XV", 0, 0, NULL_CHUNK_REFERENCE},
  {"XW", 0, 0, NULL_CHUNK_REFERENCE},
  {"XX", 0, 0, NULL_CHUNK_REFERENCE},
  {"XY", 0, 0, NULL_CHUNK_REFERENCE},
  {"XZ", 0, 0, NULL_CHUNK_REFERENCE},
  {"XYXXY", AF_INTERNAL | AF_NOPROG | AF_LOCKED | AF_NOCOPY | AF_WIZARD, 0,
   NULL_CHUNK_REFERENCE},
  {"ZENTER", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {"ZLEAVE", AF_NOPROG | AF_PREFIXMATCH, 0, NULL_CHUNK_REFERENCE},
  {NULL, 0, 0, NULL_CHUNK_REFERENCE}};

ATRALIAS attralias[] = {
  {"DESC", "DESCRIBE"},  {"IDESC", "IDESCRIBE"}, {"SUCC", "SUCCESS"},
  {"ASUCC", "ASUCCESS"}, {"OSUCC", "OSUCCESS"},  {"FAIL", "FAILURE"},
  {"AFAIL", "AFAILURE"}, {"OFAIL", "OFAILURE"},  {NULL, NULL}};

/** Attribute flags which may be present in the db */
PRIV attr_privs_db[] = {{"no_command", '$', AF_NOPROG, AF_NOPROG},
                        {"no_inherit", 'i', AF_PRIVATE, AF_PRIVATE},
                        {"no_clone", 'c', AF_NOCOPY, AF_NOCOPY},
                        {"wizard", 'w', AF_WIZARD, AF_WIZARD},
                        {"visual", 'v', AF_VISUAL, AF_VISUAL},
                        {"mortal_dark", 'm', AF_MDARK, AF_MDARK},
                        {"regexp", 'R', AF_REGEXP, AF_REGEXP},
                        {"case", 'C', AF_CASE, AF_CASE},
                        {"locked", '+', AF_LOCKED, AF_LOCKED},
                        {"safe", 'S', AF_SAFE, AF_SAFE},
                        {"prefixmatch", '\0', AF_PREFIXMATCH, AF_PREFIXMATCH},
                        {"veiled", 'V', AF_VEILED, AF_VEILED},
                        {"debug", 'b', AF_DEBUG, AF_DEBUG},
                        {"no_debug", 'B', AF_NODEBUG, AF_NODEBUG},
                        {"public", 'p', AF_PUBLIC, AF_PUBLIC},
                        {"nearby", 'n', AF_NEARBY, AF_NEARBY},
                        {"noname", 'N', AF_NONAME, AF_NONAME},
                        {"nospace", 's', AF_NOSPACE, AF_NOSPACE},
                        {"amhear", 'M', AF_MHEAR, AF_MHEAR},
                        {"aahear", 'A', AF_AHEAR, AF_AHEAR},
                        {"enum", '\0', AF_ENUM, AF_ENUM},
                        {"limit", '\0', AF_RLIMIT, AF_RLIMIT},
                        {"internal", '\0', AF_INTERNAL, AF_INTERNAL},
                        {"quiet", 'Q', AF_QUIET, AF_QUIET},
                        {NULL, '\0', 0, 0}};

#endif /* __ATR_TAB_H */
