#!/bin/bash

#
# Copyright Staffan Gimåker 2008-2009.
#
# ---
#
# This file is part of peekabot.
#
# peekabot is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# peekabot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

if [ $# -lt 1 ]; then
    echo "Usage: check_license.sh <source-dir>"
    exit 1
fi

dir="$1"

gpl2_license="This file is part of peekabot. peekabot is free software; you can \
redistribute it and\/or modify it under the terms of the GNU General Public \
License as published by the Free Software Foundation; either version 3 of the \
License, or (at your option) any later version. peekabot is distributed in \
the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the \
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See \
the GNU General Public License for more details. You should have received a \
copy of the GNU General Public License along with this program. If not, see \
<http:/\/www.gnu.org\/licenses\/>."

bsl1_license="Distributed under the Boost Software License, Version 1.0. \
(See accompanying file LICENSE_1_0.txt or copy at \
http://www.boost.org/LICENSE_1_0.txt)"

file_count=0
missing_count=0


for file in $( grep -o -e "[A-Za-z0-9\/]\+\.\(\(hh\)\|\(cc\)\)" $dir/Makefile.am ); do
    #echo $file
    file="$dir/$file"

    has_gpl2="$(sed s/[%\*]//g $file | awk '{ printf $0 }' | \
         sed "s/[[:space:]]\+/ /g" | grep -o -e "$gpl2_license")"

    has_bsl1="$(sed s/[%\*]//g $file | awk '{ printf $0 }' | \
         sed "s/[[:space:]]\+/ /g" | grep -o -e "$bsl1_license")"

    if [ -z "$has_gpl2" ] && [ -z "$has_bsl1" ]; then
	echo "License missing from $file"
	let missing_count=$missing_count+1
    fi

    let file_count=$file_count+1
done

echo "$file_count files checked, $missing_count offending file(s) found"

if [ $missing_count -gt 0 ]; then
    exit -1
else
    exit 0
fi
