/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <boost/test/unit_test.hpp>

#include "Fixture.hh"
#include "../../actions/NoOp.hh"


using namespace peekabot;

namespace
{
    struct Class1 : public Serializable 
    {
    protected:
        virtual void save(SerializationInterface &ar) const {}
        virtual void load(DeserializationInterface &ar) {}
    };

    struct Class2 : public Serializable 
    {
    protected:
        virtual void save(SerializationInterface &ar) const {}
        virtual void load(DeserializationInterface &ar) {}
    };
};


BOOST_AUTO_TEST_SUITE( Serialization_Serializable );


BOOST_FIXTURE_TEST_CASE( register_class, Fixture )
{
    SerializableFactory factory;
    BOOST_CHECK_NO_THROW( factory.register_class<Class1>(1) );
    BOOST_CHECK_NO_THROW( factory.register_class<Class2>(2) );
    BOOST_CHECK_THROW( factory.register_class<Class2>(2), std::runtime_error );
    BOOST_CHECK_THROW( factory.register_class<Class1>(2), std::runtime_error );
}

BOOST_FIXTURE_TEST_CASE( save_load_serializable_ptr, Fixture )
{
    NoOp noop;
    {
        SerializationInterface *ret;

        BOOST_CHECK_NO_THROW( ret = &(m_ser << (&noop)) );
        // Check returned serialization interface, should be the same as
        // the one we passed along (or m_ser << foo << bar; won't work)
        BOOST_CHECK_EQUAL( ret, &m_ser );
    }
    {
        DeserializationInterface *ret;
        Action *read_back = 0;

        BOOST_CHECK_NO_THROW( ret = &(m_deser >> read_back) );
        BOOST_CHECK_EQUAL( ret, &m_deser );
        BOOST_CHECK( dynamic_cast<NoOp *>(read_back) != 0 );
        BOOST_CHECK_EQUAL( m_buf.get_size(), 0u );

        BOOST_REQUIRE( read_back != 0 );
        delete read_back;
    }
}

BOOST_FIXTURE_TEST_CASE( save_load_serializable_nonptr, Fixture )
{
    NoOp noop;
    {
        SerializationInterface *ret;

        BOOST_CHECK_NO_THROW( ret = &(m_ser << noop) );
        // Check returned serialization interface, should be the same as
        // the one we passed along (or m_ser << foo << bar; won't work)
        BOOST_CHECK_EQUAL( ret, &m_ser );
    }
    {
        DeserializationInterface *ret;
        NoOp read_back;

        BOOST_CHECK_NO_THROW( ret = &(m_deser >> read_back) );
        BOOST_CHECK_EQUAL( ret, &m_deser );
        BOOST_CHECK_EQUAL( m_buf.get_size(), 0u );
    }
}

/*BOOST_FIXTURE_TEST_CASE( save_load_serializable_ptr_array, Fixture )
{

}*/


BOOST_AUTO_TEST_SUITE_END();
