/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SERIALIZATION_ANY_HH_INCLUDED
#define PEEKABOT_SERIALIZATION_ANY_HH_INCLUDED


#include "../Any.hh"
#include "serialization/SerializationInterface.hh"
#include "serialization/DeserializationInterface.hh"
#include "serialization/SerializableFactory.hh"


namespace peekabot
{
    inline SerializationInterface &operator<<(
        SerializationInterface &ar, const Any &x)
    {
        return (ar << x.m_content);
    }

    inline DeserializationInterface &operator>>(
        DeserializationInterface &ar, Any &x)
    {
        return (ar >> x.m_content);
    }

    template<typename ValueType> void register_any_type(boost::uint16_t id)
    {
        TheSerializableFactory::instance().register_type<
            Any::Holder<ValueType> >(id);
    }
}


#endif // PEEKABOT_SERIALIZATION_ANY_HH_INCLUDED
