/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_POLYLINE_HH_INCLUDED
#define PEEKABOT_RENDERER_POLYLINE_HH_INCLUDED


#include "../CullableEntity.hh"
#include "../VertexBased.hh"
#include "../LineBased.hh"

#include <cstddef>
#include <vector>
#include <boost/cstdint.hpp>


namespace peekabot
{
    namespace renderer
    {
        class LineStripMesh;

        class Polyline :
            public CullableEntity,
            public VertexBased,
            public LineBased
        {
        public:
            Polyline();

            Polyline(const Polyline &other);

            virtual ~Polyline();

            virtual Polyline *clone() const;

            virtual void get_renderables(PrepareRenderContext &context) const;

            virtual void set_vertices(
                const Vertices &vertices);

            virtual void add_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices);

            virtual void get_vertices(
                Vertices &vertices) const;

            virtual void set_colored_vertices(
                const Vertices &vertices,
                const VertexColors &colors);

            virtual void add_colored_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices,
                const VertexColors &new_colors,
                const VertexColors &all_colors);

            virtual void set_line_style(
                float line_width,
                boost::uint16_t stipple_pattern,
                int stipple_factor);

            std::size_t vertex_count() const;

        private:
            /**
             * \brief Set the entity's vertices without clearing the color
             * pointers.
             */
            void set_vertices_helper(const Vertices &vertices);

            void add_vertices_helper(
                const Vertices &new_vertices, const Vertices &all_vertices);

        private:
            boost::shared_ptr<LineStripMesh> m_mesh;
        };
    }
}


#endif // PEEKABOT_RENDERER_POLYLINE_HH_INCLUDED
