/*
 * Copyright Staffan Gimåker 2007-2008, 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_PRIMITIVES_POLYGON_HH_INCLUDED
#define PEEKABOT_RENDERER_PRIMITIVES_POLYGON_HH_INCLUDED


#include "../VertexBased.hh"
#include "../CullableEntity.hh"
#include "../Mesh.hh"

#include <vector>
#include <boost/cstdint.hpp>


namespace peekabot
{
    namespace renderer
    {
        class Polygon : public CullableEntity,
                        public VertexBased
        {
            typedef std::vector<boost::uint32_t> Indices;

        public:
            Polygon();

            Polygon(const Polygon &x);

            virtual void get_renderables(PrepareRenderContext &context) const;

            virtual void set_vertices(const Vertices &vertices) throw();

            virtual void add_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices) throw();

            virtual void get_vertices(Vertices &vertices) const throw();

            virtual void set_colored_vertices(
                const Vertices &vertices,
                const VertexColors &colors);

            virtual void add_colored_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices,
                const VertexColors &new_colors,
                const VertexColors &all_colors);

        protected:
            void calculate_bvs(const Vertices &vertices) throw();

            void calculate_normals(
                const Indices &indices, const Vertices &vertices,
                std::vector<Eigen::Vector3f> &ff_normals,
                std::vector<Eigen::Vector3f> &bf_normals);

            static void emit_face_callback(
                Indices &indices,
                std::size_t idx1, std::size_t idx2, std::size_t idx3);

            static std::size_t combine_callback(
                Vertices &vertices,
                VertexColors *colors,
                const Eigen::Vector3f &v,
                std::size_t idx1, std::size_t idx2,
                std::size_t idx3, std::size_t idx4,
                const float w[4]);

        private:
            TriMesh m_ff_mesh;
            TriMesh m_bf_mesh;
        };
    }
}


#endif // PEEKABOT_RENDERER_PRIMITIVES_POLYGON_HH_INCLUDED
