/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_VERTEX_BASED_HH_INCLUDED
#define PEEKABOT_RENDERER_VERTEX_BASED_HH_INCLUDED


#include <vector>
#include <Eigen/Core>
#include <boost/cstdint.hpp>

#include "../Types.hh"


namespace peekabot
{
    namespace renderer
    {
        class VertexBased
        {
        public:
            typedef std::vector<Eigen::Vector3f> Vertices;
            typedef std::vector<boost::uint8_t> VertexColors;

            virtual ~VertexBased() {}

            virtual void set_vertices(const Vertices &vertices) = 0;

            virtual void add_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices) = 0;

            virtual void get_vertices(Vertices &vertices) const = 0;

            virtual void set_colored_vertices(
                const Vertices &vertices,
                const VertexColors &colors) = 0;

            virtual void add_colored_vertices(
                const Vertices &new_vertices,
                const Vertices &all_vertices,
                const VertexColors &new_colors,
                const VertexColors &all_colors) = 0;
        };
    }
}


#endif // PEEKABOT_RENDERER_VERTEX_BASED_HH_INCLUDED
