/*
 * Copyright Staffan Gimåker 2007-2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Texture.hh"
#include "Device.hh"


using namespace peekabot;
using namespace peekabot::renderer;


GLuint Texture::ms_bound_tex = 0;


Texture::Texture()
    : m_tex_name(0)
{
    glGenTextures(1, &m_tex_name);
}


Texture::Texture(int32_t w, int32_t h, GLenum format, void *data)
{
    glGenTextures(1, &m_tex_name);
    set_data(w, h, format, data);
}

Texture::~Texture()
{
    unbind();
    glDeleteTextures(1, &m_tex_name);
}

void Texture::set_data(int32_t w, int32_t h, GLenum format, void *data)
{
    bind();

    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    CHECK_GL_ERRORS();

    // Set some random default texture parameters
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    CHECK_GL_ERRORS();
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    CHECK_GL_ERRORS();
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    CHECK_GL_ERRORS();
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
    CHECK_GL_ERRORS();

    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    CHECK_GL_ERRORS();

    gluBuild2DMipmaps(GL_TEXTURE_2D, 3, w, h,
                      format, GL_UNSIGNED_BYTE, data);
    CHECK_GL_ERRORS();
}

void Texture::bind() const throw()
{
    if( !is_bound() )
    {
        glBindTexture(GL_TEXTURE_2D, m_tex_name);
        ms_bound_tex = m_tex_name;

        CHECK_GL_ERRORS();
    }
}

void Texture::unbind() const throw()
{
    glBindTexture(GL_TEXTURE_2D, 0);
    ms_bound_tex = 0;
}


bool Texture::is_bound() const throw()
{
    return ms_bound_tex == m_tex_name;
}
