/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <cassert>

#include "Statelet.hh"
#include "statelets/Transformation.hh"


using namespace peekabot;
using namespace renderer::statelets;

StateletType Statelet::ms_next_available_statelet_type(0);

Name::NameImpl::ImplTab Name::NameImpl::ms_impl_tab;

Eigen::Transform3f renderer::statelets::Transformation::ms_eye(
    Eigen::Matrix4f::Identity());


Statelet::Statelet(boost::shared_ptr<StateletImpl> impl)
    : m_impl(impl)
{
    assert( m_impl != 0 );
}
