/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_RENDER_ENGINE_HH_INCLUDED
#define PEEKABOT_RENDERER_RENDER_ENGINE_HH_INCLUDED


#include <queue>
#include <boost/cstdint.hpp>

#include "Types.hh"
#include "SceneManager.hh"


namespace peekabot
{
    namespace renderer
    {
        class SceneAction;

        class RenderEngine
        {
        public:
            RenderEngine();

            ~RenderEngine();

            void init();

            void init_context();

            void render(
                unsigned int w, unsigned int h,
                Camera &camera,
                const bool *visible_layers);

            ObjectID pick(
                unsigned int w, unsigned int h,
                Camera &camera,
                const bool *visible_layers,
                int x, int y, float sensitivity);

            SceneManager &get_scene_manager()
            {
                return m_scene_manager;
            }

            const SceneManager &get_scene_manager() const
            {
                return m_scene_manager;
            }

            void set_background_color(const RGBColor &color);

            void set_selected_color(const RGBColor &color);

            void set_ancestor_selected_color(const RGBColor &color);

        private:
            void use_camera(Camera &camera) const throw();

        private:
            RGBColor m_bg_color;
            RGBColor m_selected_color;
            RGBColor m_ancestor_selected_color;

            SceneManager m_scene_manager;
        };
    }
}


#endif // PEEKABOT_RENDERER_RENDER_ENGINE_HH_INCLUDED
