/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_PRIMITIVE_FACTORY_HH_INCLUDED
#define PEEKABOT_RENDERER_PRIMITIVE_FACTORY_HH_INCLUDED


#include <map>

#include "../Singleton.hh"


namespace peekabot
{
    namespace renderer
    {
        class MeshBased;


        class PrimitiveFactory
        {
        public:
            PrimitiveFactory() throw();

            ~PrimitiveFactory() throw();

            MeshBased *get_disc() const throw();

            MeshBased *get_cylinder() const throw();

            MeshBased *get_icosphere() const throw();

            MeshBased *get_circle() const throw();

            MeshBased *get_cone() const throw();

            //MeshBased *get_cube() const throw();

        private:
            enum MeshType
            {
                DISC = 0,
                CYLINDER,
                ICOSPHERE,
                CIRCLE,
                CONE
            };

            typedef std::map<MeshType, MeshBased *> PrimitiveMap;

            PrimitiveMap m_boilerplates;

        private:
            void add_boilerplate(
                MeshType type, MeshBased *boilerplate) throw();

            void generate_boilerplates() throw();
        };

        typedef Singleton<PrimitiveFactory> ThePrimitiveFactory;

    }
}


#endif // PEEKABOT_RENDERER_PRIMITIVE_FACTORY_HH_INCLUDED
