/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_FONT_HH_INCLUDED
#define PEEKABOT_RENDERER_FONT_HH_INCLUDED


#include <map>
#include <vector>
#include <Eigen/Core>
#include <ft2build.h>
#include FT_FREETYPE_H


namespace peekabot
{
    namespace renderer
    {
        class Font
        {
            struct GlyphData
            {
                float m_hori_bearing_x; // in m
                float m_hori_bearing_y; // in m
                float m_width; // in m
                float m_height; // in m
                float m_hori_advance; // in m

                //VertexBuffer m_vertices;
                std::vector<float> m_vertices;
            };
            
            typedef FT_UInt GlyphType;
            typedef std::map<GlyphType, GlyphData> GlyphMap;

        public:
            Font(const std::string &filename/*, int size*/);

            virtual ~Font();

            void render_string(const std::string &str, float offset);

            // Returns the width and height of the string in meters
            std::pair<float, float> measure_string(
                const std::string &str) const throw();

            //const Renderable *get_char_renderable(char ch);

            /*std::vector<Eigen::Vector3f> get_glyph_vertices(int ch) const throw()
            {
                FT_UInt glyph_index = FT_Get_Char_Index( m_face, ch );
                return get_glyph_data(glyph_index).m_vertices;
                }*/

            FT_UShort units_per_EM() const throw()
            {
                return m_face->units_per_EM;
            }

            // Converts a value in font/grid/EM units, 26.6 format to meters
            inline float fu26_6_to_m(FT_Pos fu) const throw()
            {
                return fu / (64.0f * m_face->units_per_EM);
            }

            inline Eigen::Vector2f fu26_6_to_m(
                const Eigen::Vector2f &fu) const throw()
            {
                return Eigen::Vector2f(fu26_6_to_m(fu(0)), fu26_6_to_m(fu(1)));
            }

        private:
            inline bool has_glyph(GlyphType glyph) const throw()
            {
                return m_glyphs.find(glyph) != m_glyphs.end();
            }

            void render_glyph(GlyphType glyph) const;

            void load_glyph(GlyphType glyph) const;

            const GlyphData &get_glyph_data(GlyphType glyph) const;

            static void emit_face_callback(
                std::vector<float> &verts,
                const Eigen::Vector3f &v1,
                const Eigen::Vector3f &v2,
                const Eigen::Vector3f &v3);

            static std::size_t combine_callback(
                const Eigen::Vector3f &v,
                std::size_t idx1, std::size_t idx2,
                std::size_t idx3, std::size_t idx4,
                const float w[4]);

        private:
            //VertexBuffer m_vertices;

            FT_Face m_face;

            mutable GlyphMap m_glyphs;

            static unsigned int ms_ft_use_count;
            static FT_Library ms_ft_library;
        };



        /*class TextLabel : public Cullable, public Renderable // ????
        {
        public:
            virtual void render()
            {
                glMatrixMode(GL_MODELVIEW);
                glPushMatrix();
                m_font->render_string(m_text);
                glPopMatrix();
            }

        protected:
            virtual void calculate_bvs();

        private:
            std::string m_text;
            boost::shared_ptr<Font> m_font;
        };*/
    }
}


#endif // PEEKABOT_RENDERER_FONT_HH_INCLUDED
