/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_CULLABLE_ENTITY_HH_INCLUDED
#define PEEKABOT_RENDERER_CULLABLE_ENTITY_HH_INCLUDED


#include <boost/signals2.hpp>

#include "ObjectEntity.hh"
#include "BoundingVolumes.hh"


namespace peekabot
{
    namespace renderer
    {
        class CullableEntity : public ObjectEntity
        {
        public:
            CullableEntity();

            CullableEntity(const BoundingSphere &bs);

            inline const BoundingSphere &get_bounding_sphere_lc() const throw()
            {
                return m_bs_local;
            }

            // bs in world coordinates
            inline const BoundingSphere &get_bounding_sphere_wc()
                const throw()
            {
                return m_bs_world;
            }


            /// \name Signals
            /// @{

            typedef boost::signals2::signal<void (const CullableEntity *)> OnLocalBVSet;
            mutable OnLocalBVSet m_on_local_bv_set;

            typedef boost::signals2::signal<void (const CullableEntity *)> OnWorldBVSet;
            mutable OnWorldBVSet m_on_world_bv_set;

            /// @}

        protected:
            void set_bounding_sphere(const Eigen::Vector3f &v, float r);

            void set_bounding_sphere(const BoundingSphere &bs);

            void recalc_world_bs();

            virtual void on_transformation_set();

        private:
            BoundingSphere m_bs_local;

            BoundingSphere m_bs_world;
        };
    }
}


#endif // PEEKABOT_RENDERER_CULLABLE_ENTITY_HH_INCLUDED
