/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <cmath>

#include "BoundingVolumes.hh"


using namespace peekabot;
using namespace peekabot::renderer;



// ---------------- BoundingSphere implementation ------------------


IntersectionTestResult BoundingSphere::contained_in(const BoundingSphere &container)
    const throw()
{
    // this could probably be replaced by a branch and sq_dist, getting away
    // without the sqrt.
    /*float d = m_pos.dist(container.m_pos);

    if( d - m_r > container.m_r )
        return DISJOINT;
    else if( d + m_r <= container.m_r )
        return INSIDE;
    else
        return INTERSECT;*/


    // OPT: optimization possiblity, use this cheap binary test:

        // if the distance between the centers is less than the sum
        // of the radii, then we have an intersection
        // we calculate this using the squared lengths for speed
    if( (m_pos - container.m_pos).squaredNorm() <
        ((m_r + container.m_r)*(m_r + container.m_r)) )
        return INTERSECT;

    return DISJOINT;
}



IntersectionTestResult BoundingSphere::contained_in(
    const BoundingCone &container) const throw()
{
    // TODO: Try to optimize this - get rid of the sqrts.

    Eigen::Vector3f D = m_pos - container.get_vertex() +
        (m_r/container.get_sin_angle())*container.get_axis();

    if( container.get_axis().dot(D) >= D.norm() * container.get_cos_angle() )
    {
        D = m_pos - container.get_vertex();
        float D_norm = D.norm();

        if ( -container.get_axis().dot(D) >= D_norm*container.get_sin_angle() )
        {
            return (D_norm <= m_r) ? INTERSECT:DISJOINT;
        }
        else
        {
            return INTERSECT;
        }
    }
    else
    {
        return DISJOINT;
    }
}



IntersectionTestResult BoundingSphere::contained_in(const Plane &container)
    const throw()
{
    float dist = container.get_normal().dot(m_pos) + container.get_d();

    if( dist > m_r )
        return DISJOINT;
    else if( dist <= m_r && -dist <= m_r )
        return INTERSECT;
    else
        return INSIDE;
}


IntersectionTestResult BoundingSphere::intersect(const BoundingSphere &bv) const throw()
{
    return DISJOINT;
}


IntersectionTestResult BoundingSphere::intersect(const Plane &bv) const throw()
{
    return DISJOINT;
}






// ---------------- BoundingCone implementation ------------------


BoundingCone::BoundingCone() throw()
{
}


BoundingCone::BoundingCone(
    const Eigen::Vector3f &vertex,
    const Eigen::Vector3f &axis,
    float angle) throw()
    : m_vertex(vertex),
      m_axis(axis),
      m_angle(angle),
      m_sin_angle(sinf(m_angle)),
      m_cos_angle(cosf(m_angle))
{
    m_axis.normalize();
}


IntersectionTestResult BoundingCone::intersect(const BoundingSphere &bv)
    const throw()
{
    return INTERSECT;
}


IntersectionTestResult BoundingCone::intersect(const Plane &bv) const throw()
{
    return DISJOINT;
}


// ---------------- Plane implementation ------------------


IntersectionTestResult Plane::intersect(const BoundingSphere &bv)
    const throw()
{
    return INTERSECT;
}


IntersectionTestResult Plane::intersect(const Plane &bv) const throw()
{
    return DISJOINT;
}
