/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_RENDERER_ABSTRACT_PROVIDER_HH
#define __PEEKABOT_RENDERER_ABSTRACT_PROVIDER_HH


#include <string>
#include <boost/shared_ptr.hpp>


namespace peekabot
{
    namespace renderer
    {
        template<class T, class U> class ResourceManager;

        template<class T, class U = std::string>
        class AbstractProvider
        {
        public:
            typedef T ResourceType;
            typedef U ResourceIdentifier;

            virtual ~AbstractProvider() {}
            
            virtual boost::shared_ptr<ResourceType> get(const ResourceIdentifier &id) = 0;

            virtual bool matches(const ResourceIdentifier &id) throw() { return true; }
        };
        
    }
}


#endif // __PEEKABOT_RENDERER_ABSTRACT_PROVIDER_HH
