/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_MTOW_PROP_ADAPTER_HH_INCLUDED
#define PEEKABOT_MTOW_PROP_ADAPTER_HH_INCLUDED


#include "Prop.hh"
#include "SceneObject.hh"
#include "PropVisitor.hh"

#include <boost/cstdint.hpp>
#include <Eigen/Core>
#include <Eigen/Geometry>


namespace peekabot
{
    class MtowPropAdapter : public Prop
    {
    public:
        virtual void set(const Any &val, SceneObject *obj)
        {
            obj->set_transformation(
                any_cast<Eigen::Transform3f>(val), WORLD_COORDINATES);
        }

        virtual Any get(const SceneObject *obj) const
        {
            return Any(obj->get_mtow());
        }

        virtual void accept(PropVisitor &visitor)
        {
            visitor.visit(this);
        }

        SignalType &signal(SceneObject *obj)
        {
            return obj->mtow_changed_signal();
        }
    };
}


#endif // PEEKABOT_MTOW_PROP_ADAPTER_HH_INCLUDED
