/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "PropMediatorFactory.hh"
#include "PropInspectorController.hh"
#include "../Prop.hh"
#include "../SceneObject.hh"

#include "BoolPropMediator.hh"
#include "StringPropMediator.hh"
#include "FloatPropMediator.hh"
#include "ColorPropMediator.hh"
#include "Uint32PropMediator.hh"
#include "Vector3PropMediator.hh"
#include "EnumPropMediator.hh"
#include "LayerPropMediator.hh"
#include "MtowPropMediator.hh"


using namespace peekabot;
using namespace peekabot::gui;


PropMediatorFactory::PropMediatorFactory(PropInspectorController &pi)
    : m_pi(pi)
{
}


PropMediator *PropMediatorFactory::create_mediator(
    SceneObject *obj, PropKey prop_key)
{
    // m_mediator is used as the return value, and it is only set when a
    // suitable mediator can be constructed, so we want to reset this to zero
    // before proceeding
    m_mediator = 0;
    // Save state needed by the visitor
    m_obj = obj;
    m_prop_key = prop_key;

    // Run the visitor to determine and create the suitable mediator, if one
    // can be constructed
    Prop *prop = obj->get_prop(prop_key);
    if( !prop->is_gui_visibile() )
    {
        return 0;
    }
    else
    {
        prop->accept(*this);
        return m_mediator;
    }
}


void PropMediatorFactory::visit(BoolPropBase *prop)
{
    m_mediator = new BoolPropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(FloatPropBase *prop)
{
    m_mediator = new FloatPropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(StringPropBase *prop)
{
    m_mediator = new StringPropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(EnumPropBase *prop)
{
    m_mediator = new EnumPropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(ColorPropBase *prop)
{
    m_mediator = new ColorPropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(Uint32PropBase *prop)
{
    m_mediator = new Uint32PropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(Vector3PropBase *prop)
{
    m_mediator = new Vector3PropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(LayerPropAdapter *prop)
{
    m_mediator = new LayerPropMediator(m_pi, m_obj, prop, m_prop_key);
}


void PropMediatorFactory::visit(MtowPropAdapter *prop)
{
    m_mediator = new MtowPropMediator(m_pi, m_obj, prop, m_prop_key);
}
