/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_FRAME_HH_INCLUDED
#define PEEKABOT_GUI_FRAME_HH_INCLUDED


#include <gtkmm.h>


namespace peekabot
{
    namespace gui
    {
        class FrameLayoutController;

        class Frame
        {
        public:
            Frame(FrameLayoutController &layout);

            virtual ~Frame();

            Gtk::Widget *get_frame_widget();

            FrameLayoutController &get_frame_layout_controller();

        protected:
            void set_main_widget(Gtk::Widget *main_widget);

            void prepend_toolbar_item(Gtk::ToolItem &item);

        private:
            void setup_frame_ctrls();

            void on_split(bool hsplit);

            void on_collapse(bool collapse_other);

        private:
            FrameLayoutController &m_frame_layout_controller;

            Gtk::VBox m_vbox;

            Gtk::Widget *m_main_widget;

            Gtk::Toolbar m_toolbar;

            Gtk::ToolItem m_tool_expander;

            Gtk::MenuToolButton m_tool_frame_ctrls;

            Gtk::Menu m_menu_frame_ctrls;
        };
    }
}


#endif // PEEKABOT_GUI_FRAME_HH_INCLUDED
