/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Frame.hh"
#include "SceneViewFrame.hh"
#include "FrameLayoutController.hh"

#include <boost/bind.hpp>


using namespace peekabot;
using namespace peekabot::gui;


Frame::Frame(FrameLayoutController &layout)
    : m_frame_layout_controller(layout),
      m_main_widget(0)
{
    m_toolbar.set_icon_size(Gtk::ICON_SIZE_LARGE_TOOLBAR);
    m_toolbar.set_toolbar_style(Gtk::TOOLBAR_ICONS);

    setup_frame_ctrls();
    m_vbox.pack_start(m_toolbar, Gtk::PACK_SHRINK);
    m_vbox.show_all();
}


Frame::~Frame()
{
}


Gtk::Widget *Frame::get_frame_widget()
{
    return &m_vbox;
}


FrameLayoutController &Frame::get_frame_layout_controller()
{
    return m_frame_layout_controller;
}


void Frame::set_main_widget(Gtk::Widget *main_widget)
{
    if( m_main_widget )
    {
        m_vbox.remove(*m_main_widget);
        m_main_widget = 0;
    }

    m_main_widget = main_widget;
    m_vbox.pack_start(*m_main_widget, Gtk::PACK_EXPAND_WIDGET);
}


void Frame::prepend_toolbar_item(Gtk::ToolItem &item)
{
    m_toolbar.prepend(item);
    item.show_all();
}


void Frame::setup_frame_ctrls()
{
    m_tool_expander.set_expand();
    m_toolbar.append(m_tool_expander);

    Gtk::ImageMenuItem *item_collapse_other = manage(
        new Gtk::ImageMenuItem(Gtk::Stock::REMOVE));
    item_collapse_other->set_label("Collapse other");
    m_menu_frame_ctrls.add(*item_collapse_other);
    item_collapse_other->signal_activate().connect(
        boost::bind(&Frame::on_collapse, this, true));

    Gtk::ImageMenuItem *item_hsplit = manage(
        new Gtk::ImageMenuItem(Gtk::Stock::ADD));
    item_hsplit->set_label("Split horizontally");
    m_menu_frame_ctrls.add(*item_hsplit);
    item_hsplit->signal_activate().connect(
        boost::bind(&Frame::on_split, this, true));

    Gtk::ImageMenuItem *item_vsplit = manage(
        new Gtk::ImageMenuItem(Gtk::Stock::ADD));
    item_vsplit->set_label("Split vertically");
    m_menu_frame_ctrls.add(*item_vsplit);
    item_vsplit->signal_activate().connect(
        boost::bind(&Frame::on_split, this, false));

    m_tool_frame_ctrls.set_stock_id(Gtk::Stock::REMOVE);
    m_tool_frame_ctrls.set_tooltip_text("Collapse split and remove this frame");
    m_tool_frame_ctrls.set_label("Collapse this");
    m_tool_frame_ctrls.set_menu(m_menu_frame_ctrls);
    m_tool_frame_ctrls.signal_clicked().connect(
        boost::bind(&Frame::on_collapse, this, false));
    m_menu_frame_ctrls.show_all();
    m_toolbar.append(m_tool_frame_ctrls);
}


void Frame::on_split(bool hsplit)
{
    m_frame_layout_controller.split(
        this,
        hsplit ? FrameLayoutController::HSPLIT : FrameLayoutController::VSPLIT,
        new SceneViewFrame(m_frame_layout_controller));
}


void Frame::on_collapse(bool collapse_other)
{
    m_frame_layout_controller.collapse(this, collapse_other);
}
