/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_SCALABLE_PROXY_HH_INCLUDED
#define PEEKABOT_CLIENT_SCALABLE_PROXY_HH_INCLUDED


#include "ObjectProxy.hh"
#include "../DelayedDispatch.hh"


namespace peekabot
{
    namespace client
    {
        /**
         * \brief Base class for all scalable object proxies.
         */
        class PEEKABOT_API ScalableProxyBase : virtual public ObjectProxyBase
        {
        public:
            ScalableProxyBase();

            ScalableProxyBase(const ScalableProxyBase &p);

            /**
             * \brief Set the scale of the object to \a scale, uniformly along
             * all three axes.
             *
             * The scaling is performed along the local axes of the object.
             *
             * \pre scale > 0
             */
            inline DelayedDispatch set_scale(float scale)
            {
                return set_scale(scale, scale, scale);
            }

            /**
             * \brief Set the object's scale along the three different axes.
             *
             * The scaling is performed along the local axes of the object.
             *
             * \pre x_scale, y_scale, z_scale > 0
             */
            DelayedDispatch set_scale(
                float x_scale, float y_scale, float z_scale);
        };


        /**
         * \brief Proxy class used to manipulate any type of scalable object.
         */
        class PEEKABOT_API ScalableProxy : public ScalableProxyBase
        {
        public:
            ScalableProxy();

            ScalableProxy(const ScalableProxyBase &p);

            ScalableProxy &operator=(const ScalableProxy &p);

            ScalableProxy &operator=(const ScalableProxyBase &p);

            /**
             * \brief Upcast and assign from another proxy.
             *
             * If the object pointed to by \a p is not of compatible type, the
             * assignment will fail and subsequent operations performed on the 
             * proxy will fail.
             */
            DelayedDispatch assign(const ObjectProxyBase &p);

            /**
             * \copydoc ObjectProxy::assign(PeekabotClient&,const std::string&)
             */
            DelayedDispatch assign(
                PeekabotClient &client,
                const std::string &path);

            /**
             * \copydoc 
             * ObjectProxy::assign(const ObjectProxyBase&,const std::string&)
             */
            DelayedDispatch assign(
                const ObjectProxyBase &parent, 
                const std::string &rel_path);
        };
    }
}


#endif // PEEKABOT_CLIENT_SCALABLE_PROXY_HH_INCLUDED
