/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_MODEL_PROXY_HH_INCLUDED
#define PEEKABOT_CLIENT_MODEL_PROXY_HH_INCLUDED


#include "ScalableProxy.hh"


namespace peekabot
{
    namespace client
    {
        /**
         * \brief Base class for ModelProxy.
         */
        class PEEKABOT_API ModelProxyBase : public ScalableProxyBase
        {
        public:
            ModelProxyBase();

            ModelProxyBase(const ModelProxyBase &p);
        };


        /**
         * \brief Proxy class used to add and manipulate models.
         */
        class PEEKABOT_API ModelProxy : public ModelProxyBase
        {
        public:
            ModelProxy();

            ModelProxy(const ModelProxyBase &p);

            ModelProxy &operator=(const ModelProxy &p);

            ModelProxy &operator=(const ModelProxyBase &p);

            /**
             * \copydoc ScalableProxy::assign(const ObjectProxyBase&)
             */
            DelayedDispatch assign(const ObjectProxyBase &p);

            /**
             * \copydoc ObjectProxy::assign(PeekabotClient&,const std::string&)
             */
            DelayedDispatch assign(
                PeekabotClient &client,
                const std::string &path);

            /**
             * \copydoc 
             * ObjectProxy::assign(const ObjectProxyBase&,const std::string&)
             */
            DelayedDispatch assign(
                const ObjectProxyBase &parent, 
                const std::string &rel_path);

            /**
             * \brief Add a model to the scene.
             *
             * Adds a model to the scene at the given path and assigns 
             * the proxy to point to it. If an object already exists at the 
             * given path the outcome is governed by \a conflict_policy.
             *
             * The model file to load must reside on the peekabot server, not
             * the client.
             *
             * \param path The path where the object will be added, including 
             * the name of the object.
             * \param filename The (server-side) path to the model file.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                PeekabotClient &client,
                const std::string &path,
                const std::string &filename,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);

            /**
             * \brief Add a model to the scene.
             *
             * Adds a model with the given name under the the object referred 
             * to by \a parent and assigns the proxy to point to it. If an 
             * object already exists at the given path the outcome is governed 
             * by \a conflict_policy.
             *
             * The model file to load must reside on the peekabot server, not
             * the client.
             *
             * \param parent The parent under which the object will be added.
             * \param name The name to assign to the created object.
             * \param filename The (server-side) path to the model file.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                const ObjectProxyBase &parent, 
                const std::string &name,
                const std::string &filename,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);
        };
    }
}


#endif // PEEKABOT_CLIENT_MODEL_PROXY_HH_INCLUDED
