/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_JOINT_PROXY_HH_INCLUDED
#define PEEKABOT_CLIENT_JOINT_PROXY_HH_INCLUDED


#include "ObjectProxy.hh"


namespace peekabot
{
    namespace client
    {
        /**
         * \brief Base class for JointProxy.
         */
        class PEEKABOT_API JointProxyBase : public ObjectProxyBase
        {
        public:
            JointProxyBase();

            JointProxyBase(const JointProxyBase &p);

            /**
             * \brief Set the joint's actuation value.
             *
             * For hinges, this is an angle in radians and for sliders this is
             * a displacement in meters.
             */
            DelayedDispatch set_dof(float val);

            /**
             * \brief Set the minimum valid joint actuation value.
             */
            DelayedDispatch set_min(float min);

            /**
             * \brief Set the maximum valid joint actuation value.
             */
            DelayedDispatch set_max(float max);

            /**
             * \brief Set the joint's value offset, see the
             * \ref manual_scenedef_joints section for an explanation.
             */
            DelayedDispatch set_offset(float offset);
        };


        /**
         * \brief Proxy class used manipulate joints.
         */
        class PEEKABOT_API JointProxy : public JointProxyBase
        {
        public:
            JointProxy();

            JointProxy(const JointProxyBase &p);

            JointProxy &operator=(const JointProxy &p);

            JointProxy &operator=(const JointProxyBase &p);

            /**
             * \copydoc ScalableProxy::assign(const ObjectProxyBase&)
             */
            DelayedDispatch assign(const ObjectProxyBase &p);

            /**
             * \copydoc ObjectProxy::assign(PeekabotClient&,const std::string&)
             */
            DelayedDispatch assign(
                PeekabotClient &client,
                const std::string &path);

            /**
             * \copydoc
             * ObjectProxy::assign(const ObjectProxyBase&,const std::string&)
             */
            DelayedDispatch assign(
                const ObjectProxyBase &parent,
                const std::string &rel_path);
        };
    }
}


#endif // PEEKABOT_CLIENT_JOINT_PROXY_HH_INCLUDED
