/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "Transport.hh"
#include "ClientImpl.hh"


using namespace peekabot;
using namespace peekabot::client;


void Transport::disconnected()
{
    boost::shared_ptr<ClientImpl> ptr(client());
    if( ptr )
        ptr->report_disconnected_transport(this);
}


void Transport::execute_action(boost::shared_ptr<Action> action)
{
    boost::shared_ptr<ClientImpl> ptr(client());
    if( ptr )
        ptr->execute_action(action);
}
