/*
 * Copyright Staffan Gimåker 2009
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_RECORDING_IMPL_HH_INCLUDED
#define PEEKABOT_CLIENT_RECORDING_IMPL_HH_INCLUDED


#include "../PbarPlayer.hh"


namespace peekabot
{
    namespace client
    {
        class ClientImpl;

        class RecordingImpl : public boost::noncopyable
        {
        public:
            RecordingImpl(
                ClientImpl &client,
                const std::string &filename);

            void play();

            void pause();

            bool is_paused() const;

            bool is_finished() const;

            void step(size_t n);

            void step(const boost::posix_time::time_duration &td);

            void set_playback_speed(double factor);

            double get_playback_speed() const;

            boost::posix_time::time_duration elapsed() const;

            boost::posix_time::time_duration duration() const;

        private:
            void dispatch(boost::shared_ptr<Action> action);

        private:
            ClientImpl &m_client;

            PbarPlayer m_player;
        };
    }
}


#endif // PEEKABOT_CLIENT_RECORDING_IMPL_HH_INCLUDED
